/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#pragma once

namespace writerfilter::rtftok
{
// fix error with SEC being defined elsewhere
#undef SEC
/**
 * An RTF destination state is the last open destination control word.
 *
 * Note that this is not a 1:1 mapping between destination control
 * words, e.g. RTF_PICT gets mapped to Destination::PICT or
 * Destination::SHAPEPROPERTYVALUEPICT.
 */
enum class Destination
{
    NORMAL,
    SKIP,
    FONTTABLE,
    FONTENTRY,
    COLORTABLE,
    STYLESHEET,
    STYLEENTRY,
    FIELD,
    FIELDINSTRUCTION,
    FIELDRESULT,
    LISTTABLE,
    LISTPICTURE,
    LISTENTRY,
    LISTNAME,
    LISTOVERRIDETABLE,
    LISTOVERRIDEENTRY,
    LISTLEVEL,
    LEVELTEXT,
    LEVELNUMBERS,
    SHPPICT,
    PICT,
    PICPROP,
    SHAPEPROPERTY,
    SHAPEPROPERTYNAME,
    SHAPEPROPERTYVALUE,
    SHAPE,
    SHAPEINSTRUCTION,
    SHAPEPROPERTYVALUEPICT,
    NESTEDTABLEPROPERTIES,
    FOOTNOTE,
    BOOKMARKSTART,
    BOOKMARKEND,
    REVISIONTABLE,
    REVISIONENTRY,
    SHAPETEXT,
    FORMFIELD,
    FORMFIELDNAME,
    FORMFIELDLIST,
    DATAFIELD,
    INFO,
    CREATIONTIME,
    REVISIONTIME,
    PRINTTIME,
    AUTHOR,
    KEYWORDS,
    OPERATOR,
    COMPANY,
    COMMENT,
    OBJECT,
    OBJDATA,
    OBJCLASS,
    RESULT,
    ANNOTATIONDATE,
    ANNOTATIONAUTHOR,
    ANNOTATIONREFERENCE,
    FALT,
    FLYMAINCONTENT,
    DRAWINGOBJECT,
    PARAGRAPHNUMBERING,
    PARAGRAPHNUMBERING_TEXTBEFORE,
    PARAGRAPHNUMBERING_TEXTAFTER,
    TITLE,
    SUBJECT,
    DOCCOMM,
    ATNID,
    ANNOTATIONREFERENCESTART,
    ANNOTATIONREFERENCEEND,
    MOMATH,
    MR,
    MF,
    MFPR,
    MCTRLPR,
    MNUM,
    MDEN,
    MACC,
    MACCPR,
    MCHR,
    MPOS,
    MVERTJC,
    MSTRIKEH,
    MDEGHIDE,
    ME,
    MBAR,
    MBARPR,
    MD,
    MDPR,
    MBEGCHR,
    MSEPCHR,
    MENDCHR,
    MFUNC,
    MFUNCPR,
    MFNAME,
    MLIMLOW,
    MLIMLOWPR,
    MLIM,
    MM,
    MMPR,
    MMR,
    MNARY,
    MNARYPR,
    MSUB,
    MSUP,
    MSUBHIDE,
    MSUPHIDE,
    MLIMUPP,
    MLIMUPPPR,
    MGROUPCHR,
    MGROUPCHRPR,
    MBORDERBOX,
    MBORDERBOXPR,
    MRAD,
    MRADPR,
    MDEG,
    MSSUB,
    MSSUBPR,
    MSSUP,
    MSSUPPR,
    MSSUBSUP,
    MSSUBSUPPR,
    MSPRE,
    MSPREPR,
    MTYPE,
    MGROW,
    MBOX,
    MEQARR,
    UPR,
    LFOLEVEL,
    BACKGROUND,
    SHAPEGROUP,
    FOOTNOTESEPARATOR,
    INDEXENTRY,
    TOCENTRY,
    USERPROPS,
    PROPNAME,
    STATICVAL,
    GENERATOR,
    DOCVAR,
};

enum class RTFKeyword
{
    invalid = -1,
    HEXCHAR,
    OPTHYPH,
    IGNORE,
    SUBENTRY,
    BACKSLASH,
    NOBRKHYPH,
    LBRACE,
    FORMULA,
    RBRACE,
    NOBREAK,
    AB,
    ABSH,
    ABSLOCK,
    ABSNOOVRLP,
    ABSW,
    ACAPS,
    ACCCIRCLE,
    ACCCOMMA,
    ACCDOT,
    ACCNONE,
    ACCUNDERDOT,
    ACF,
    ADEFF,
    ADDITIVE,
    ADEFLANG,
    ADJUSTRIGHT,
    ADN,
    AENDDOC,
    AENDNOTES,
    AEXPND,
    AF,
    AFELEV,
    AFS,
    AFTNBJ,
    AFTNCN,
    AFTNNALC,
    AFTNNAR,
    AFTNNAUC,
    AFTNNCHI,
    AFTNNCHOSUNG,
    AFTNNCNUM,
    AFTNNDBAR,
    AFTNNDBNUM,
    AFTNNDBNUMD,
    AFTNNDBNUMK,
    AFTNNDBNUMT,
    AFTNNGANADA,
    AFTNNGBNUM,
    AFTNNGBNUMD,
    AFTNNGBNUMK,
    AFTNNGBNUML,
    AFTNNRLC,
    AFTNNRUC,
    AFTNNZODIAC,
    AFTNNZODIACD,
    AFTNNZODIACL,
    AFTNRESTART,
    AFTNRSTCONT,
    AFTNSEP,
    AFTNSEPC,
    AFTNSTART,
    AFTNTJ,
    AI,
    ALANG,
    ALLOWFIELDENDSEL,
    ALLPROT,
    ALNTBLIND,
    ALT,
    ANIMTEXT,
    ANNOTATION,
    ANNOTPROT,
    ANSI,
    ANSICPG,
    AOUTL,
    APPLYBRKRULES,
    ASCAPS,
    ASHAD,
    ASIANBRKRULE,
    ASPALPHA,
    ASPNUM,
    ASTRIKE,
    ATNAUTHOR,
    ATNDATE,
    ATNICN,
    ATNID,
    ATNPARENT,
    ATNREF,
    ATNTIME,
    ATRFEND,
    ATRFSTART,
    AUL,
    AULD,
    AULDB,
    AULNONE,
    AULW,
    AUP,
    AUTHOR,
    AUTOFMTOVERRIDE,
    B,
    BACKGROUND,
    BDBFHDR,
    BDRRLSWSIX,
    BGBDIAG,
    BGCROSS,
    BGDCROSS,
    BGDKBDIAG,
    BGDKCROSS,
    BGDKDCROSS,
    BGDKFDIAG,
    BGDKHORIZ,
    BGDKVERT,
    BGFDIAG,
    BGHORIZ,
    BGVERT,
    BIN,
    BINFSXN,
    BINSXN,
    BKMKCOLF,
    BKMKCOLL,
    BKMKEND,
    BKMKPUB,
    BKMKSTART,
    BLIPTAG,
    BLIPUID,
    BLIPUPI,
    BLUE,
    BOOKFOLD,
    BOOKFOLDREV,
    BOOKFOLDSHEETS,
    BOX,
    BRDRART,
    BRDRB,
    BRDRBAR,
    BRDRBTW,
    BRDRCF,
    BRDRDASH,
    BRDRDASHD,
    BRDRDASHDD,
    BRDRDASHDOTSTR,
    BRDRDASHSM,
    BRDRDB,
    BRDRDOT,
    BRDREMBOSS,
    BRDRENGRAVE,
    BRDRFRAME,
    BRDRHAIR,
    BRDRINSET,
    BRDRL,
    BRDRNIL,
    BRDRNONE,
    BRDROUTSET,
    BRDRR,
    BRDRS,
    BRDRSH,
    BRDRT,
    BRDRTBL,
    BRDRTH,
    BRDRTHTNLG,
    BRDRTHTNMG,
    BRDRTHTNSG,
    BRDRTNTHLG,
    BRDRTNTHMG,
    BRDRTNTHSG,
    BRDRTNTHTNLG,
    BRDRTNTHTNMG,
    BRDRTNTHTNSG,
    BRDRTRIPLE,
    BRDRW,
    BRDRWAVY,
    BRDRWAVYDB,
    BRKFRM,
    BRSP,
    BULLET,
    BUPTIM,
    BXE,
    CACCENTFIVE,
    CACCENTFOUR,
    CACCENTONE,
    CACCENTSIX,
    CACCENTTHREE,
    CACCENTTWO,
    CACHEDCOLBAL,
    CAPS,
    CATEGORY,
    CB,
    CBACKGROUNDONE,
    CBACKGROUNDTWO,
    CBPAT,
    CCHS,
    CELL,
    CELLX,
    CF,
    CFOLLOWEDHYPERLINK,
    CFPAT,
    CGRID,
    CHARRSID,
    CHARSCALEX,
    CHATN,
    CHBGBDIAG,
    CHBGCROSS,
    CHBGDCROSS,
    CHBGDKBDIAG,
    CHBGDKCROSS,
    CHBGDKDCROSS,
    CHBGDKFDIAG,
    CHBGDKHORIZ,
    CHBGDKVERT,
    CHBGFDIAG,
    CHBGHORIZ,
    CHBGVERT,
    CHBRDR,
    CHCBPAT,
    CHCFPAT,
    CHDATE,
    CHDPA,
    CHDPL,
    CHFTN,
    CHFTNSEP,
    CHFTNSEPC,
    CHPGN,
    CHHRES,
    CHSHDNG,
    CHTIME,
    CHYPERLINK,
    CLBGBDIAG,
    CLBGCROSS,
    CLBGDCROSS,
    CLBGDKBDIAG,
    CLBGDKCROSS,
    CLBGDKDCROSS,
    CLBGDKFDIAG,
    CLBGDKHOR,
    CLBGDKVERT,
    CLBGFDIAG,
    CLBGHORIZ,
    CLBGVERT,
    CLBRDRB,
    CLBRDRL,
    CLBRDRR,
    CLBRDRT,
    CLCBPAT,
    CLCBPATRAW,
    CLCFPAT,
    CLCFPATRAW,
    CLDEL,
    CLDELAUTH,
    CLDELDTTM,
    CLDGLL,
    CLDGLU,
    CLFITTEXT,
    CLFTSWIDTH,
    CLHIDEMARK,
    CLINS,
    CLINSAUTH,
    CLINSDTTM,
    CLMGF,
    CLMRG,
    CLMRGD,
    CLMRGDAUTH,
    CLMRGDDTTM,
    CLMRGDR,
    CLNOWRAP,
    CLPADB,
    CLPADFB,
    CLPADFL,
    CLPADFR,
    CLPADFT,
    CLPADL,
    CLPADR,
    CLPADT,
    CLSPB,
    CLSPFB,
    CLSPFL,
    CLSPFR,
    CLSPFT,
    CLSPL,
    CLSPR,
    CLSPT,
    CLSHDNG,
    CLSHDNGRAW,
    CLSHDRAWNIL,
    CLSPLIT,
    CLSPLITR,
    CLTXBTLR,
    CLTXLRTB,
    CLTXLRTBV,
    CLTXTBRL,
    CLTXTBRLV,
    CLVERTALB,
    CLVERTALC,
    CLVERTALT,
    CLVMGF,
    CLVMRG,
    CLWWIDTH,
    CMAINDARKONE,
    CMAINDARKTWO,
    CMAINLIGHTONE,
    CMAINLIGHTTWO,
    COLLAPSED,
    COLNO,
    COLORSCHEMEMAPPING,
    COLORTBL,
    COLS,
    COLSR,
    COLSX,
    COLUMN,
    COLW,
    COMMENT,
    COMPANY,
    CONTEXTUALSPACE,
    CPG,
    CRAUTH,
    CRDATE,
    CREATIM,
    CS,
    CSHADE,
    CTEXTONE,
    CTEXTTWO,
    CTINT,
    CTRL,
    CTS,
    CUFI,
    CULI,
    CURI,
    CVMME,
    DATAFIELD,
    DATASTORE,
    DATE,
    DBCH,
    DEFCHP,
    DEFF,
    DEFFORMAT,
    DEFLANG,
    DEFLANGFE,
    DEFPAP,
    DEFSHP,
    DEFTAB,
    DELETED,
    DELRSID,
    DFRAUTH,
    DFRDATE,
    DFRMTXTX,
    DFRMTXTY,
    DFRSTART,
    DFRSTOP,
    DFRXST,
    DGHORIGIN,
    DGHSHOW,
    DGHSPACE,
    DGMARGIN,
    DGSNAP,
    DGVORIGIN,
    DGVSHOW,
    DGVSPACE,
    DIBITMAP,
    DISABLED,
    DN,
    DNTBLNSBDB,
    DO,
    DOBXCOLUMN,
    DOBXMARGIN,
    DOBXPAGE,
    DOBYMARGIN,
    DOBYPAGE,
    DOBYPARA,
    DOCCOMM,
    DOCTEMP,
    DOCTYPE,
    DOCVAR,
    DODHGT,
    DOLOCK,
    DONOTEMBEDLINGDATA,
    DONOTEMBEDSYSFONT,
    DONOTSHOWCOMMENTS,
    DONOTSHOWINSDEL,
    DONOTSHOWMARKUP,
    DONOTSHOWPROPS,
    DPAENDHOL,
    DPAENDL,
    DPAENDSOL,
    DPAENDW,
    DPARC,
    DPARCFLIPX,
    DPARCFLIPY,
    DPASTARTHOL,
    DPASTARTL,
    DPASTARTSOL,
    DPASTARTW,
    DPCALLOUT,
    DPCOA,
    DPCOACCENT,
    DPCOBESTFIT,
    DPCOBORDER,
    DPCODABS,
    DPCODBOTTOM,
    DPCODCENTER,
    DPCODESCENT,
    DPCODTOP,
    DPCOLENGTH,
    DPCOMINUSX,
    DPCOMINUSY,
    DPCOOFFSET,
    DPCOSMARTA,
    DPCOTDOUBLE,
    DPCOTRIGHT,
    DPCOTSINGLE,
    DPCOTTRIPLE,
    DPCOUNT,
    DPELLIPSE,
    DPENDGROUP,
    DPFILLBGCB,
    DPFILLBGCG,
    DPFILLBGCR,
    DPFILLBGGRAY,
    DPFILLBGPAL,
    DPFILLFGCB,
    DPFILLFGCG,
    DPFILLFGCR,
    DPFILLFGGRAY,
    DPFILLFGPAL,
    DPFILLPAT,
    DPGROUP,
    DPLINE,
    DPLINECOB,
    DPLINECOG,
    DPLINECOR,
    DPLINEDADO,
    DPLINEDADODO,
    DPLINEDASH,
    DPLINEDOT,
    DPLINEGRAY,
    DPLINEHOLLOW,
    DPLINEPAL,
    DPLINESOLID,
    DPLINEW,
    DPPOLYCOUNT,
    DPPOLYGON,
    DPPOLYLINE,
    DPPTX,
    DPPTY,
    DPRECT,
    DPROUNDR,
    DPSHADOW,
    DPSHADX,
    DPSHADY,
    DPTXBTLR,
    DPTXBX,
    DPTXBXMAR,
    DPTXBXTEXT,
    DPTXLRTB,
    DPTXLRTBV,
    DPTXTBRL,
    DPTXTBRLV,
    DPX,
    DPXSIZE,
    DPY,
    DPYSIZE,
    DROPCAPLI,
    DROPCAPT,
    DS,
    DXFRTEXT,
    DY,
    EBCEND,
    EBCSTART,
    EDMINS,
    EMBO,
    EMDASH,
    EMFBLIP,
    EMSPACE,
    ENDASH,
    ENDDOC,
    ENDNHERE,
    ENDNOTES,
    ENFORCEPROT,
    ENSPACE,
    EXPND,
    EXPNDTW,
    EXPSHRTN,
    F,
    FAAUTO,
    FACENTER,
    FACINGP,
    FACTOIDNAME,
    FAFIXED,
    FAHANG,
    FALT,
    FAROMAN,
    FAVAR,
    FBIAS,
    FBIDI,
    FBIDIS,
    FBIMAJOR,
    FBIMINOR,
    FCHARS,
    FCHARSET,
    FCS,
    FDBMAJOR,
    FDBMINOR,
    FDECOR,
    FELNBRELEV,
    FET,
    FETCH,
    FFDEFRES,
    FFDEFTEXT,
    FFENTRYMCR,
    FFEXITMCR,
    FFFORMAT,
    FFHASLISTBOX,
    FFHELPTEXT,
    FFHPS,
    FFL,
    FFMAXLEN,
    FFNAME,
    FFOWNHELP,
    FFOWNSTAT,
    FFPROT,
    FFRECALC,
    FFRES,
    FFSIZE,
    FFSTATTEXT,
    FFTYPE,
    FFTYPETXT,
    FHIMAJOR,
    FHIMINOR,
    FI,
    FID,
    FIELD,
    FILE,
    FILETBL,
    FITTEXT,
    FJGOTHIC,
    FJMINCHOU,
    FLDALT,
    FLDDIRTY,
    FLDEDIT,
    FLDINST,
    FLDLOCK,
    FLDPRIV,
    FLDRSLT,
    FLDTYPE,
    FLOMAJOR,
    FLOMINOR,
    FMODERN,
    FN,
    FNAME,
    FNETWORK,
    FNIL,
    FNONFILESYS,
    FONTEMB,
    FONTFILE,
    FONTTBL,
    FOOTER,
    FOOTERF,
    FOOTERL,
    FOOTERR,
    FOOTERY,
    FOOTNOTE,
    FORCEUPGRADE,
    FORMDISP,
    FORMFIELD,
    FORMPROT,
    FORMSHADE,
    FOSNUM,
    FPRQ,
    FRACWIDTH,
    FRELATIVE,
    FRMTXBTLR,
    FRMTXLRTB,
    FRMTXLRTBV,
    FRMTXTBRL,
    FRMTXTBRLV,
    FROMAN,
    FROMHTML,
    FROMTEXT,
    FS,
    FSCRIPT,
    FSWISS,
    FTECH,
    FTNALT,
    FTNBJ,
    FTNCN,
    FTNIL,
    FTNLYTWNINE,
    FTNNALC,
    FTNNAR,
    FTNNAUC,
    FTNNCHI,
    FTNNCHOSUNG,
    FTNNCNUM,
    FTNNDBAR,
    FTNNDBNUM,
    FTNNDBNUMD,
    FTNNDBNUMK,
    FTNNDBNUMT,
    FTNNGANADA,
    FTNNGBNUM,
    FTNNGBNUMD,
    FTNNGBNUMK,
    FTNNGBNUML,
    FTNNRLC,
    FTNNRUC,
    FTNNZODIAC,
    FTNNZODIACD,
    FTNNZODIACL,
    FTNRESTART,
    FTNRSTCONT,
    FTNRSTPG,
    FTNSEP,
    FTNSEPC,
    FTNSTART,
    FTNTJ,
    FTTRUETYPE,
    FVALIDDOS,
    FVALIDHPFS,
    FVALIDMAC,
    FVALIDNTFS,
    G,
    GCW,
    GENERATOR,
    GREEN,
    GRFDOCEVENTS,
    GRIDTBL,
    GUTTER,
    GUTTERPRL,
    GUTTERSXN,
    HEADER,
    HEADERF,
    HEADERL,
    HEADERR,
    HEADERY,
    HICH,
    HIGHLIGHT,
    HL,
    HLFR,
    HLINKBASE,
    HLLOC,
    HLSRC,
    HORZDOC,
    HORZSECT,
    HORZVERT,
    HR,
    HRES,
    HRULE,
    HSV,
    HTMAUTSP,
    HTMLBASE,
    HTMLRTF,
    HTMLTAG,
    HWELEV,
    HYPHAUTO,
    HYPHCAPS,
    HYPHCONSEC,
    HYPHHOTZ,
    HYPHPAR,
    I,
    ID,
    IGNOREMIXEDCONTENT,
    ILFOMACATCLNUP,
    ILVL,
    IMPR,
    INDMIRROR,
    INDRLSWELEVEN,
    INFO,
    INSRSID,
    INTBL,
    IPGP,
    IROWBAND,
    IROW,
    ITAP,
    IXE,
    JCOMPRESS,
    JEXPAND,
    JIS,
    JPEGBLIP,
    JSKSU,
    KEEP,
    KEEPN,
    KERNING,
    KEYCODE,
    KEYWORDS,
    KRNPRSNET,
    KSULANG,
    JCLISTTAB,
    LANDSCAPE,
    LANG,
    LANGFE,
    LANGFENP,
    LANGNP,
    LASTROW,
    LATENTSTYLES,
    LBR,
    LCHARS,
    LDBLQUOTE,
    LEVEL,
    LEVELFOLLOW,
    LEVELINDENT,
    LEVELJC,
    LEVELJCN,
    LEVELLEGAL,
    LEVELNFC,
    LEVELNFCN,
    LEVELNORESTART,
    LEVELNUMBERS,
    LEVELOLD,
    LEVELPICTURE,
    LEVELPICTURENOSIZE,
    LEVELPREV,
    LEVELPREVSPACE,
    LEVELSPACE,
    LEVELSTARTAT,
    LEVELTEMPLATEID,
    LEVELTEXT,
    LFOLEVEL,
    LI,
    LINE,
    LINEBETCOL,
    LINECONT,
    LINEMOD,
    LINEPPAGE,
    LINERESTART,
    LINESTART,
    LINESTARTS,
    LINEX,
    LINKSELF,
    LINKSTYLES,
    LINKVAL,
    LIN,
    LISA,
    LISB,
    LIST,
    LISTHYBRID,
    LISTID,
    LISTLEVEL,
    LISTNAME,
    LISTOVERRIDE,
    LISTOVERRIDECOUNT,
    LISTOVERRIDEFORMAT,
    LISTOVERRIDESTARTAT,
    LISTOVERRIDETABLE,
    LISTPICTURE,
    LISTRESTARTHDN,
    LISTSIMPLE,
    LISTSTYLEID,
    LISTSTYLENAME,
    LISTTABLE,
    LISTTEMPLATEID,
    LISTTEXT,
    LNBRKRULE,
    LNDSCPSXN,
    LNONGRID,
    LOCH,
    LQUOTE,
    LS,
    LSDLOCKED,
    LSDLOCKEDDEF,
    LSDLOCKEDEXCEPT,
    LSDPRIORITY,
    LSDPRIORITYDEF,
    LSDQFORMAT,
    LSDQFORMATDEF,
    LSDSEMIHIDDEN,
    LSDSEMIHIDDENDEF,
    LSDSTIMAX,
    LSDUNHIDEUSED,
    LSDUNHIDEUSEDDEF,
    LTRCH,
    LTRDOC,
    LTRMARK,
    LTRPAR,
    LTRROW,
    LTRSECT,
    LVLTENTATIVE,
    LYTCALCTBLWD,
    LYTEXCTTP,
    LYTPRTMET,
    LYTTBLRTGR,
    MAC,
    MACC,
    MACCPR,
    MACPICT,
    MAILMERGE,
    MAKEBACKUP,
    MALN,
    MALNSCR,
    MANAGER,
    MARGB,
    MARGBSXN,
    MARGL,
    MARGLSXN,
    MARGMIRROR,
    MARGMIRSXN,
    MARGPR,
    MARGR,
    MARGRSXN,
    MARGSZ,
    MARGT,
    MARGTSXN,
    MBAR,
    MBARPR,
    MBASEJC,
    MBEGCHR,
    MBORDERBOX,
    MBORDERBOXPR,
    MBOX,
    MBOXPR,
    MBRK,
    MBRKBIN,
    MBRKBINSUB,
    MCGP,
    MCGPRULE,
    MCHR,
    MCOUNT,
    MCSP,
    MCTRLPR,
    MD,
    MDEFJC,
    MDEG,
    MDEGHIDE,
    MDEN,
    MDIFF,
    MDIFFSTY,
    MDISPDEF,
    MDPR,
    ME,
    MENDCHR,
    MEQARR,
    MEQARRPR,
    MF,
    MFNAME,
    MFPR,
    MFUNC,
    MFUNCPR,
    MGROUPCHR,
    MGROUPCHRPR,
    MGROW,
    MHIDEBOT,
    MHIDELEFT,
    MHIDERIGHT,
    MHIDETOP,
    MHTMLTAG,
    MIN,
    MINTERSP,
    MINTLIM,
    MINTRASP,
    MJC,
    MLIM,
    MLIMLOC,
    MLIMLOW,
    MLIMLOWPR,
    MLIMUPP,
    MLIMUPPPR,
    MLIT,
    MLMARGIN,
    MM,
    MMADDFIELDNAME,
    MMATH,
    MMATHFONT,
    MMATHPICT,
    MMATHPR,
    MMATTACH,
    MMAXDIST,
    MMBLANKLINES,
    MMC,
    MMCJC,
    MMCONNECTSTR,
    MMCONNECTSTRDATA,
    MMCPR,
    MMCS,
    MMDATASOURCE,
    MMDATATYPEACCESS,
    MMDATATYPEEXCEL,
    MMDATATYPEFILE,
    MMDATATYPEODBC,
    MMDATATYPEODSO,
    MMDATATYPEQT,
    MMDEFAULTSQL,
    MMDESTEMAIL,
    MMDESTFAX,
    MMDESTNEWDOC,
    MMDESTPRINTER,
    MMERRORS,
    MMFTTYPEADDRESS,
    MMFTTYPEBARCODE,
    MMFTTYPEDBCOLUMN,
    MMFTTYPEMAPPED,
    MMFTTYPENULL,
    MMFTTYPESALUTATION,
    MMHEADERSOURCE,
    MMJDSOTYPE,
    MMLINKTOQUERY,
    MMMAILSUBJECT,
    MMMAINTYPECATALOG,
    MMMAINTYPEEMAIL,
    MMMAINTYPEENVELOPES,
    MMMAINTYPEFAX,
    MMMAINTYPELABELS,
    MMMAINTYPELETTERS,
    MMODSO,
    MMODSOACTIVE,
    MMODSOCOLDELIM,
    MMODSOCOLUMN,
    MMODSODYNADDR,
    MMODSOFHDR,
    MMODSOFILTER,
    MMODSOFLDMPDATA,
    MMODSOFMCOLUMN,
    MMODSOHASH,
    MMODSOLID,
    MMODSOMAPPEDNAME,
    MMODSONAME,
    MMODSORECIPDATA,
    MMODSOSORT,
    MMODSOSRC,
    MMODSOTABLE,
    MMODSOUDL,
    MMODSOUDLDATA,
    MMODSOUNIQUETAG,
    MMPR,
    MMQUERY,
    MMR,
    MMRECCUR,
    MMSHOWDATA,
    MNARY,
    MNARYLIM,
    MNARYPR,
    MNOBREAK,
    MNOR,
    MNUM,
    MO,
    MOBJDIST,
    MOMATH,
    MOMATHPARA,
    MOMATHPARAPR,
    MOPEMU,
    MPHANT,
    MPHANTPR,
    MPLCHIDE,
    MPOS,
    MPOSTSP,
    MPRESP,
    MR,
    MRAD,
    MRADPR,
    MRMARGIN,
    MRPR,
    MRSP,
    MRSPRULE,
    MSCR,
    MSEPCHR,
    MSHOW,
    MSHP,
    MSMALLFRAC,
    MSMCAP,
    MSPRE,
    MSPREPR,
    MSSUB,
    MSSUBPR,
    MSSUBSUP,
    MSSUBSUPPR,
    MSSUP,
    MSSUPPR,
    MSTRIKEBLTR,
    MSTRIKEH,
    MSTRIKETLBR,
    MSTRIKEV,
    MSTY,
    MSUB,
    MSUBHIDE,
    MSUP,
    MSUPHIDE,
    MTRANSP,
    MTYPE,
    MUSER,
    MVAUTH,
    MVDATE,
    MVERTJC,
    MVF,
    MVFMF,
    MVFML,
    MVT,
    MVTOF,
    MVTOL,
    MWRAPINDENT,
    MWRAPRIGHT,
    MZEROASC,
    MZERODESC,
    MZEROWID,
    NESTCELL,
    NESTROW,
    NESTTABLEPROPS,
    NEWTBLSTYRULS,
    NEXTFILE,
    NOAFCNSTTBL,
    NOBRKWRPTBL,
    NOCOLBAL,
    NOCOMPATOPTIONS,
    NOCWRAP,
    NOCXSPTABLE,
    NOEXTRASPRL,
    NOFCHARS,
    NOFCHARSWS,
    NOFEATURETHROTTLE,
    NOFPAGES,
    NOFWORDS,
    NOGROWAUTOFIT,
    NOINDNMBRTS,
    NOJKERNPUNCT,
    NOLEAD,
    NOLINE,
    NOLNHTADJTBL,
    NONESTTABLES,
    NONSHPPICT,
    NOOVERFLOW,
    NOPROOF,
    NOQFPROMOTE,
    NOSECTEXPAND,
    NOSNAPLINEGRID,
    NOSPACEFORUL,
    NOSUPERSUB,
    NOTABIND,
    NOTBRKCNSTFRCTBL,
    NOTCVASP,
    NOTVATXBX,
    NOUICOMPAT,
    NOULTRLSPC,
    NOWIDCTLPAR,
    NOWRAP,
    NOWWRAP,
    NOXLATTOYEN,
    OBJALIAS,
    OBJALIGN,
    OBJATTPH,
    OBJAUTLINK,
    OBJCLASS,
    OBJCROPB,
    OBJCROPL,
    OBJCROPR,
    OBJCROPT,
    OBJDATA,
    OBJECT,
    OBJEMB,
    OBJH,
    OBJHTML,
    OBJICEMB,
    OBJLINK,
    OBJLOCK,
    OBJNAME,
    OBJOCX,
    OBJPUB,
    OBJSCALEX,
    OBJSCALEY,
    OBJSECT,
    OBJSETSIZE,
    OBJSUB,
    OBJTIME,
    OBJTRANSY,
    OBJUPDATE,
    OBJW,
    OGUTTER,
    OLDAS,
    OLDCPROPS,
    OLDLINEWRAP,
    OLDPPROPS,
    OLDSPROPS,
    OLDTPROPS,
    OLECLSID,
    OPERATOR,
    OTBLRUL,
    OUTL,
    OUTLINELEVEL,
    OVERLAY,
    PAGE,
    PAGEBB,
    PANOSE,
    PAPERH,
    PAPERW,
    PAR,
    PARARSID,
    PARD,
    PASSWORD,
    PASSWORDHASH,
    PC,
    PCA,
    PGBRDRB,
    PGBRDRFOOT,
    PGBRDRHEAD,
    PGBRDRL,
    PGBRDROPT,
    PGBRDRR,
    PGBRDRSNAP,
    PGBRDRT,
    PGHSXN,
    PGNBIDIA,
    PGNBIDIB,
    PGNCHOSUNG,
    PGNCNUM,
    PGNCONT,
    PGNDBNUM,
    PGNDBNUMD,
    PGNDBNUMK,
    PGNDBNUMT,
    PGNDEC,
    PGNDECD,
    PGNGANADA,
    PGNGBNUM,
    PGNGBNUMD,
    PGNGBNUMK,
    PGNGBNUML,
    PGNHINDIA,
    PGNHINDIB,
    PGNHINDIC,
    PGNHINDID,
    PGNHN,
    PGNHNSC,
    PGNHNSH,
    PGNHNSM,
    PGNHNSN,
    PGNHNSP,
    PGNID,
    PGNLCLTR,
    PGNLCRM,
    PGNRESTART,
    PGNSTART,
    PGNSTARTS,
    PGNTHAIA,
    PGNTHAIB,
    PGNTHAIC,
    PGNUCLTR,
    PGNUCRM,
    PGNVIETA,
    PGNX,
    PGNY,
    PGNZODIAC,
    PGNZODIACD,
    PGNZODIACL,
    PGP,
    PGPTBL,
    PGWSXN,
    PHCOL,
    PHMRG,
    PHPG,
    PICBMP,
    PICBPP,
    PICCROPB,
    PICCROPL,
    PICCROPR,
    PICCROPT,
    PICH,
    PICHGOAL,
    PICPROP,
    PICSCALED,
    PICSCALEX,
    PICSCALEY,
    PICT,
    PICW,
    PICWGOAL,
    PINDTABQC,
    PINDTABQL,
    PINDTABQR,
    PLAIN,
    PMARTABQC,
    PMARTABQL,
    PMARTABQR,
    PMMETAFILE,
    PN,
    PNACROSS,
    PNAIU,
    PNAIUD,
    PNAIUEO,
    PNAIUEOD,
    PNB,
    PNBIDIA,
    PNBIDIB,
    PNCAPS,
    PNCARD,
    PNCF,
    PNCHOSUNG,
    PNCNUM,
    PNDBNUM,
    PNDBNUMD,
    PNDBNUMK,
    PNDBNUML,
    PNDBNUMT,
    PNDEC,
    PNDECD,
    PNF,
    PNFS,
    PNGANADA,
    PNGBLIP,
    PNGBNUM,
    PNGBNUMD,
    PNGBNUMK,
    PNGBNUML,
    PNHANG,
    PNI,
    PNINDENT,
    PNIROHA,
    PNIROHAD,
    PNLCLTR,
    PNLCRM,
    PNLVL,
    PNLVLBLT,
    PNLVLBODY,
    PNLVLCONT,
    PNNUMONCE,
    PNORD,
    PNORDT,
    PNPREV,
    PNQC,
    PNQL,
    PNQR,
    PNRAUTH,
    PNRDATE,
    PNRESTART,
    PNRNFC,
    PNRNOT,
    PNRPNBR,
    PNRRGB,
    PNRSTART,
    PNRSTOP,
    PNRXST,
    PNSCAPS,
    PNSECLVL,
    PNSP,
    PNSTART,
    PNSTRIKE,
    PNTEXT,
    PNTXTA,
    PNTXTB,
    PNUCLTR,
    PNUCRM,
    PNUL,
    PNULD,
    PNULDASH,
    PNULDASHD,
    PNULDASHDD,
    PNULDB,
    PNULHAIR,
    PNULNONE,
    PNULTH,
    PNULW,
    PNULWAVE,
    PNZODIAC,
    PNZODIACD,
    PNZODIACL,
    POSNEGX,
    POSNEGY,
    POSX,
    POSXC,
    POSXI,
    POSXL,
    POSXO,
    POSXR,
    POSY,
    POSYB,
    POSYC,
    POSYIL,
    POSYIN,
    POSYOUT,
    POSYT,
    PRAUTH,
    PRCOLBL,
    PRDATE,
    PRINTDATA,
    PRINTIM,
    PRIVATE,
    PROPNAME,
    PROPTYPE,
    PROTECT,
    PROTEND,
    PROTLEVEL,
    PROTSTART,
    PROTUSERTBL,
    PSOVER,
    PSZ,
    PTABLDOT,
    PTABLMDOT,
    PTABLMINUS,
    PTABLNONE,
    PTABLUSCORE,
    PUBAUTO,
    PVMRG,
    PVPARA,
    PVPG,
    PWD,
    PXE,
    QC,
    QD,
    QJ,
    QK,
    QL,
    QMSPACE,
    QR,
    QT,
    RAWCLBGDKBDIAG,
    RAWCLBGBDIAG,
    RAWCLBGCROSS,
    RAWCLBGDCROSS,
    RAWCLBGDKCROSS,
    RAWCLBGDKDCROSS,
    RAWCLBGDKFDIAG,
    RAWCLBGDKHOR,
    RAWCLBGDKVERT,
    RAWCLBGFDIAG,
    RAWCLBGHORIZ,
    RAWCLBGVERT,
    RDBLQUOTE,
    READONLYRECOMMENDED,
    READPROT,
    RED,
    RELYONVML,
    REMDTTM,
    REMPERSONALINFO,
    RESULT,
    REVAUTH,
    REVAUTHDEL,
    REVBAR,
    REVDTTM,
    REVDTTMDEL,
    REVISED,
    REVISIONS,
    REVPROP,
    REVPROT,
    REVTBL,
    REVTIM,
    RI,
    RIN,
    ROW,
    RQUOTE,
    RSID,
    RSIDROOT,
    RSIDTBL,
    RSLTBMP,
    RSLTHTML,
    RSLTMERGE,
    RSLTPICT,
    RSLTRTF,
    RSLTTXT,
    RTF,
    RTLCH,
    RTLDOC,
    RTLGUTTER,
    RTLMARK,
    RTLPAR,
    RTLROW,
    RTLSECT,
    RXE,
    S,
    SA,
    SAAUTO,
    SAFTNNALC,
    SAFTNNAR,
    SAFTNNAUC,
    SAFTNNCHI,
    SAFTNNCHOSUNG,
    SAFTNNCNUM,
    SAFTNNDBAR,
    SAFTNNDBNUM,
    SAFTNNDBNUMD,
    SAFTNNDBNUMK,
    SAFTNNDBNUMT,
    SAFTNNGANADA,
    SAFTNNGBNUM,
    SAFTNNGBNUMD,
    SAFTNNGBNUMK,
    SAFTNNGBNUML,
    SAFTNNRLC,
    SAFTNNRUC,
    SAFTNNZODIAC,
    SAFTNNZODIACD,
    SAFTNNZODIACL,
    SAFTNRESTART,
    SAFTNRSTCONT,
    SAFTNSTART,
    SAUTOUPD,
    SAVEINVALIDXML,
    SAVEPREVPICT,
    SB,
    SBASEDON,
    SBAUTO,
    SBKCOL,
    SBKEVEN,
    SBKNONE,
    SBKODD,
    SBKPAGE,
    SBYS,
    SCAPS,
    SCOMPOSE,
    SEC,
    SECT,
    SECTD,
    SECTDEFAULTCL,
    SECTEXPAND,
    SECTLINEGRID,
    SECTNUM,
    SECTRSID,
    SECTSPECIFYCL,
    SECTSPECIFYGENN,
    SECTSPECIFYL,
    SECTUNLOCKED,
    SFTNBJ,
    SFTNNALC,
    SFTNNAR,
    SFTNNAUC,
    SFTNNCHI,
    SFTNNCHOSUNG,
    SFTNNCNUM,
    SFTNNDBAR,
    SFTNNDBNUM,
    SFTNNDBNUMD,
    SFTNNDBNUMK,
    SFTNNDBNUMT,
    SFTNNGANADA,
    SFTNNGBNUM,
    SFTNNGBNUMD,
    SFTNNGBNUMK,
    SFTNNGBNUML,
    SFTNNRLC,
    SFTNNRUC,
    SFTNNZODIAC,
    SFTNNZODIACD,
    SFTNNZODIACL,
    SFTNRESTART,
    SFTNRSTCONT,
    SFTNRSTPG,
    SFTNSTART,
    SFTNTJ,
    SHAD,
    SHADING,
    SHIDDEN,
    SHIFT,
    SHOWPLACEHOLDTEXT,
    SHOWXMLERRORS,
    SHP,
    SHPBOTTOM,
    SHPBXCOLUMN,
    SHPBXIGNORE,
    SHPBXMARGIN,
    SHPBXPAGE,
    SHPBYIGNORE,
    SHPBYMARGIN,
    SHPBYPAGE,
    SHPBYPARA,
    SHPFBLWTXT,
    SHPFHDR,
    SHPGRP,
    SHPINST,
    SHPLEFT,
    SHPLID,
    SHPLOCKANCHOR,
    SHPPICT,
    SHPRIGHT,
    SHPRSLT,
    SHPTOP,
    SHPTXT,
    SHPWRK,
    SHPWR,
    SHPZ,
    SL,
    SLINK,
    SLMULT,
    SLOCKED,
    SN,
    SNAPTOGRIDINCELL,
    SNEXT,
    SOFTCOL,
    SOFTLHEIGHT,
    SOFTLINE,
    SOFTPAGE,
    SP,
    SPERSONAL,
    SPLTPGPAR,
    SPLYTWNINE,
    SPRIORITY,
    SPRSBSP,
    SPRSLNSP,
    SPRSSPBF,
    SPRSTSM,
    SPRSTSP,
    SPV,
    SQFORMAT,
    SRAUTH,
    SRDATE,
    SREPLY,
    SSEMIHIDDEN,
    STATICVAL,
    STEXTFLOW,
    STRIKE,
    STRIKED,
    STSHFBI,
    STSHFDBCH,
    STSHFHICH,
    STSHFLOCH,
    STYLELOCK,
    STYLELOCKBACKCOMP,
    STYLELOCKENFORCED,
    STYLELOCKQFSET,
    STYLELOCKTHEME,
    STYLESHEET,
    STYLESORTMETHOD,
    STYRSID,
    SUB,
    SUBDOCUMENT,
    SUBFONTBYSIZE,
    SUBJECT,
    SUNHIDEUSED,
    SUPER,
    SV,
    SVB,
    SWPBDR,
    TAB,
    TABSNOOVRLP,
    TAPRTL,
    TB,
    TBLIND,
    TBLINDTYPE,
    TBLLKBESTFIT,
    TBLLKBORDER,
    TBLLKCOLOR,
    TBLLKFONT,
    TBLLKHDRCOLS,
    TBLLKHDRROWS,
    TBLLKLASTCOL,
    TBLLKLASTROW,
    TBLLKNOCOLBAND,
    TBLLKNOROWBAND,
    TBLLKSHADING,
    TBLRSID,
    TC,
    TCELLD,
    TCF,
    TCL,
    TCN,
    TDFRMTXTBOTTOM,
    TDFRMTXTLEFT,
    TDFRMTXTRIGHT,
    TDFRMTXTTOP,
    TEMPLATE,
    THEMEDATA,
    THEMELANG,
    THEMELANGCS,
    THEMELANGFE,
    TIME,
    TITLE,
    TITLEPG,
    TLDOT,
    TLEQ,
    TLHYPH,
    TLMDOT,
    TLTH,
    TLUL,
    TOPLINEPUNCT,
    TPHCOL,
    TPHMRG,
    TPHPG,
    TPOSNEGX,
    TPOSNEGY,
    TPOSXC,
    TPOSXI,
    TPOSXL,
    TPOSX,
    TPOSXO,
    TPOSXR,
    TPOSY,
    TPOSYB,
    TPOSYC,
    TPOSYIL,
    TPOSYIN,
    TPOSYOUT,
    TPOSYT,
    TPVMRG,
    TPVPARA,
    TPVPG,
    TQC,
    TQDEC,
    TQR,
    TRACKFORMATTING,
    TRACKMOVES,
    TRANSMF,
    TRAUTH,
    TRAUTOFIT,
    TRBGBDIAG,
    TRBGCROSS,
    TRBGDCROSS,
    TRBGDKBDIAG,
    TRBGDKCROSS,
    TRBGDKDCROSS,
    TRBGDKFDIAG,
    TRBGDKHOR,
    TRBGDKVERT,
    TRBGFDIAG,
    TRBGHORIZ,
    TRBGVERT,
    TRBRDRB,
    TRBRDRH,
    TRBRDRL,
    TRBRDRR,
    TRBRDRT,
    TRBRDRV,
    TRCBPAT,
    TRCFPAT,
    TRDATE,
    TRFTSWIDTHA,
    TRFTSWIDTHB,
    TRFTSWIDTH,
    TRGAPH,
    TRHDR,
    TRKEEP,
    TRKEEPFOLLOW,
    TRLEFT,
    TROWD,
    TRPADDB,
    TRPADDFB,
    TRPADDFL,
    TRPADDFR,
    TRPADDFT,
    TRPADDL,
    TRPADDR,
    TRPADDT,
    TRPADOB,
    TRPADOFB,
    TRPADOFL,
    TRPADOFR,
    TRPADOFT,
    TRPADOL,
    TRPADOR,
    TRPADOT,
    TRPAT,
    TRQC,
    TRQL,
    TRQR,
    TRRH,
    TRSHDNG,
    TRSPDB,
    TRSPDFB,
    TRSPDFL,
    TRSPDFR,
    TRSPDFT,
    TRSPDL,
    TRSPDR,
    TRSPDT,
    TRSPOB,
    TRSPOFB,
    TRSPOFL,
    TRSPOFR,
    TRSPOFT,
    TRSPOL,
    TRSPOR,
    TRSPOT,
    TRUNCATEFONTHEIGHT,
    TRUNCEX,
    TRWWIDTHA,
    TRWWIDTHB,
    TRWWIDTH,
    TS,
    TSBGBDIAG,
    TSBGCROSS,
    TSBGDCROSS,
    TSBGDKBDIAG,
    TSBGDKCROSS,
    TSBGDKDCROSS,
    TSBGDKFDIAG,
    TSBGDKHOR,
    TSBGDKVERT,
    TSBGFDIAG,
    TSBGHORIZ,
    TSBGVERT,
    TSBRDRB,
    TSBRDRDGL,
    TSBRDRDGR,
    TSBRDRH,
    TSBRDRL,
    TSBRDRR,
    TSBRDRT,
    TSBRDRV,
    TSCBANDHORZEVEN,
    TSCBANDHORZODD,
    TSCBANDSH,
    TSCBANDSV,
    TSCBANDVERTEVEN,
    TSCBANDVERTODD,
    TSCELLCBPAT,
    TSCELLCFPAT,
    TSCELLPADDB,
    TSCELLPADDFB,
    TSCELLPADDFL,
    TSCELLPADDFR,
    TSCELLPADDFT,
    TSCELLPADDL,
    TSCELLPADDR,
    TSCELLPADDT,
    TSCELLPCT,
    TSCELLWIDTH,
    TSCELLWIDTHFTS,
    TSCFIRSTCOL,
    TSCFIRSTROW,
    TSCLASTCOL,
    TSCLASTROW,
    TSCNECELL,
    TSCNWCELL,
    TSCSECELL,
    TSCSWCELL,
    TSD,
    TSNOWRAP,
    TSROWD,
    TSVERTALB,
    TSVERTALC,
    TSVERTALT,
    TWOINONE,
    TWOONONE,
    TX,
    TXBXTWALWAYS,
    TXBXTWFIRST,
    TXBXTWFIRSTLAST,
    TXBXTWLAST,
    TXBXTWNO,
    TXE,
    U,
    UC,
    UD,
    UL,
    ULC,
    ULD,
    ULDASH,
    ULDASHD,
    ULDASHDD,
    ULDB,
    ULHAIR,
    ULHWAVE,
    ULLDASH,
    ULNONE,
    ULTH,
    ULTHD,
    ULTHDASH,
    ULTHDASHD,
    ULTHDASHDD,
    ULTHLDASH,
    ULULDBWAVE,
    ULW,
    ULWAVE,
    UP,
    UPR,
    URTF,
    USELTBALN,
    USENORMSTYFORLIST,
    USERPROPS,
    USEXFORM,
    UTINL,
    V,
    VALIDATEXML,
    VERN,
    VERSION,
    VERTAL,
    VERTALB,
    VERTALC,
    VERTALJ,
    VERTALT,
    VERTDOC,
    VERTSECT,
    VIEWBKSP,
    VIEWKIND,
    VIEWNOBOUND,
    VIEWSCALE,
    VIEWZK,
    WBITMAP,
    WBMBITSPIXEL,
    WBMPLANES,
    WBMWIDTHBYTE,
    WEBHIDDEN,
    WGRFFMTFILTER,
    WIDCTLPAR,
    WIDOWCTRL,
    WINDOWCAPTION,
    WMETAFILE,
    WPEQN,
    WPJST,
    WPSP,
    WRAPAROUND,
    WRAPDEFAULT,
    WRAPTHROUGH,
    WRAPTIGHT,
    WRAPTRSP,
    WRITERESERVATION,
    WRITERESERVHASH,
    WRPPUNCT,
    XE,
    XEF,
    XFORM,
    XMLATTR,
    XMLATTRNAME,
    XMLATTRNS,
    XMLATTRVALUE,
    XMLCLOSE,
    XMLNAME,
    XMLNS,
    XMLNSTBL,
    XMLOPEN,
    XMLSDTTCELL,
    XMLSDTTPARA,
    XMLSDTTREGULAR,
    XMLSDTTROW,
    XMLSDTTUNKNOWN,
    YR,
    YTS,
    YXE,
    ZWBO,
    ZWJ,
    ZWNBO,
    ZWNJ,
    FLYMAINCNT,
    FLYVERT,
    FLYHORZ,
    FLYANCHOR
};

/// Represents an RTF Math Control Word
class RTFMathSymbolData
{
    int m_nToken; ///< This is the OOXML token equivalent.
    Destination m_eDestination;

public:
    constexpr RTFMathSymbolData(int nToken, Destination eDestination)
        : m_nToken(nToken)
        , m_eDestination(eDestination)
    {
    }

    int GetToken() const { return m_nToken; }

    Destination GetDestination() const { return m_eDestination; }
};
} // namespace writerfilter::rtftok

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
