/* Generated from /jenkins/jobs/oi-userland/workspace/components/library/heimdal/heimdal-7.8.0/lib/asn1/test.asn1 */
/* Do not edit */

#ifndef __test_template_asn1_h__
#define __test_template_asn1_h__

#include <stddef.h>
#include <time.h>

#ifndef __asn1_common_definitions__
#define __asn1_common_definitions__

#ifndef __HEIM_BASE_DATA__
#define __HEIM_BASE_DATA__ 1
struct heim_base_data {
    size_t length;
    void *data;
};
typedef struct heim_base_data heim_octet_string;
#endif

typedef struct heim_integer {
  size_t length;
  void *data;
  int negative;
} heim_integer;

typedef char *heim_general_string;

typedef char *heim_utf8_string;

typedef struct heim_base_data heim_printable_string;

typedef struct heim_base_data heim_ia5_string;

typedef struct heim_bmp_string {
  size_t length;
  uint16_t *data;
} heim_bmp_string;

typedef struct heim_universal_string {
  size_t length;
  uint32_t *data;
} heim_universal_string;

typedef char *heim_visible_string;

typedef struct heim_oid {
  size_t length;
  unsigned *components;
} heim_oid;

typedef struct heim_bit_string {
  size_t length;
  void *data;
} heim_bit_string;

typedef struct heim_base_data heim_any;
typedef struct heim_base_data heim_any_set;

#define ASN1_MALLOC_ENCODE(T, B, BL, S, L, R)                  \
  do {                                                         \
    (BL) = length_##T((S));                                    \
    (B) = malloc((BL));                                        \
    if((B) == NULL) {                                          \
      (R) = ENOMEM;                                            \
    } else {                                                   \
      (R) = encode_##T(((unsigned char*)(B)) + (BL) - 1, (BL), \
                       (S), (L));                              \
      if((R) != 0) {                                           \
        free((B));                                             \
        (B) = NULL;                                            \
      }                                                        \
    }                                                          \
  } while (0)

#ifdef _WIN32
#ifndef ASN1_LIB
#define ASN1EXP  __declspec(dllimport)
#else
#define ASN1EXP
#endif
#define ASN1CALL __stdcall
#else
#define ASN1EXP
#define ASN1CALL
#endif
struct units;

#endif

#include <heim_asn1.h>
/*
TESTuint32 ::= INTEGER (0..4294967295)
*/

typedef unsigned int TESTuint32;

ASN1EXP int    ASN1CALL decode_TESTuint32(const unsigned char *, size_t, TESTuint32 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTuint32(unsigned char *, size_t, const TESTuint32 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTuint32(const TESTuint32 *);
ASN1EXP int    ASN1CALL copy_TESTuint32  (const TESTuint32 *, TESTuint32 *);
ASN1EXP void   ASN1CALL free_TESTuint32  (TESTuint32 *);


/*
TESTuint64 ::= INTEGER (0..9223372036854775807)
*/

typedef uint64_t TESTuint64;

ASN1EXP int    ASN1CALL decode_TESTuint64(const unsigned char *, size_t, TESTuint64 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTuint64(unsigned char *, size_t, const TESTuint64 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTuint64(const TESTuint64 *);
ASN1EXP int    ASN1CALL copy_TESTuint64  (const TESTuint64 *, TESTuint64 *);
ASN1EXP void   ASN1CALL free_TESTuint64  (TESTuint64 *);


/*
TESTint64 ::= INTEGER (-9223372036854775808..9223372036854775807)
*/

typedef int64_t TESTint64;

ASN1EXP int    ASN1CALL decode_TESTint64(const unsigned char *, size_t, TESTint64 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTint64(unsigned char *, size_t, const TESTint64 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTint64(const TESTint64 *);
ASN1EXP int    ASN1CALL copy_TESTint64  (const TESTint64 *, TESTint64 *);
ASN1EXP void   ASN1CALL free_TESTint64  (TESTint64 *);


/*
TESTLargeTag ::= SEQUENCE {
  foo             [127] INTEGER (-2147483648..2147483647),
  bar             [128] INTEGER (-2147483648..2147483647),
}
*/

typedef struct TESTLargeTag {
  int foo;
  int bar;
} TESTLargeTag;

ASN1EXP int    ASN1CALL decode_TESTLargeTag(const unsigned char *, size_t, TESTLargeTag *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTLargeTag(unsigned char *, size_t, const TESTLargeTag *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTLargeTag(const TESTLargeTag *);
ASN1EXP int    ASN1CALL copy_TESTLargeTag  (const TESTLargeTag *, TESTLargeTag *);
ASN1EXP void   ASN1CALL free_TESTLargeTag  (TESTLargeTag *);


/*
TESTSeq ::= SEQUENCE {
  tag0            [0] INTEGER (-2147483648..2147483647),
  tag1            [1] TESTLargeTag,
  tagless         INTEGER (-2147483648..2147483647),
  tag3            [2] INTEGER (-2147483648..2147483647),
}
*/

typedef struct TESTSeq {
  int tag0;
  TESTLargeTag tag1;
  int tagless;
  int tag3;
} TESTSeq;

ASN1EXP int    ASN1CALL decode_TESTSeq(const unsigned char *, size_t, TESTSeq *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeq(unsigned char *, size_t, const TESTSeq *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeq(const TESTSeq *);
ASN1EXP int    ASN1CALL copy_TESTSeq  (const TESTSeq *, TESTSeq *);
ASN1EXP void   ASN1CALL free_TESTSeq  (TESTSeq *);


/*
TESTChoice1 ::= CHOICE {
  i1              [1] INTEGER (-2147483648..2147483647),
  i2              [2] INTEGER (-2147483648..2147483647),
  ...,
}
*/

typedef struct TESTChoice1 {
  enum TESTChoice1_enum {
    choice_TESTChoice1_asn1_ellipsis = 0,
    choice_TESTChoice1_i1,
    choice_TESTChoice1_i2
    /* ... */
  } element;
  union {
    int i1;
    int i2;
    heim_octet_string asn1_ellipsis;
  } u;
} TESTChoice1;

ASN1EXP int    ASN1CALL decode_TESTChoice1(const unsigned char *, size_t, TESTChoice1 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTChoice1(unsigned char *, size_t, const TESTChoice1 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTChoice1(const TESTChoice1 *);
ASN1EXP int    ASN1CALL copy_TESTChoice1  (const TESTChoice1 *, TESTChoice1 *);
ASN1EXP void   ASN1CALL free_TESTChoice1  (TESTChoice1 *);


/*
TESTChoice2 ::= CHOICE {
  i1              [1] INTEGER (-2147483648..2147483647),
  ...,
}
*/

typedef struct TESTChoice2 {
  enum TESTChoice2_enum {
    choice_TESTChoice2_asn1_ellipsis = 0,
    choice_TESTChoice2_i1
    /* ... */
  } element;
  union {
    int i1;
    heim_octet_string asn1_ellipsis;
  } u;
} TESTChoice2;

ASN1EXP int    ASN1CALL decode_TESTChoice2(const unsigned char *, size_t, TESTChoice2 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTChoice2(unsigned char *, size_t, const TESTChoice2 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTChoice2(const TESTChoice2 *);
ASN1EXP int    ASN1CALL copy_TESTChoice2  (const TESTChoice2 *, TESTChoice2 *);
ASN1EXP void   ASN1CALL free_TESTChoice2  (TESTChoice2 *);


/*
TESTInteger ::= INTEGER (-2147483648..2147483647)
*/

typedef int TESTInteger;

ASN1EXP int    ASN1CALL decode_TESTInteger(const unsigned char *, size_t, TESTInteger *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTInteger(unsigned char *, size_t, const TESTInteger *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTInteger(const TESTInteger *);
ASN1EXP int    ASN1CALL copy_TESTInteger  (const TESTInteger *, TESTInteger *);
ASN1EXP void   ASN1CALL free_TESTInteger  (TESTInteger *);


/*
TESTInteger2 ::= [4] IMPLICIT TESTInteger
*/

typedef TESTInteger TESTInteger2;

ASN1EXP int    ASN1CALL decode_TESTInteger2(const unsigned char *, size_t, TESTInteger2 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTInteger2(unsigned char *, size_t, const TESTInteger2 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTInteger2(const TESTInteger2 *);
ASN1EXP int    ASN1CALL copy_TESTInteger2  (const TESTInteger2 *, TESTInteger2 *);
ASN1EXP void   ASN1CALL free_TESTInteger2  (TESTInteger2 *);


/*
TESTInteger3 ::= [5] IMPLICIT TESTInteger2
*/

typedef TESTInteger2 TESTInteger3;

ASN1EXP int    ASN1CALL decode_TESTInteger3(const unsigned char *, size_t, TESTInteger3 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTInteger3(unsigned char *, size_t, const TESTInteger3 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTInteger3(const TESTInteger3 *);
ASN1EXP int    ASN1CALL copy_TESTInteger3  (const TESTInteger3 *, TESTInteger3 *);
ASN1EXP void   ASN1CALL free_TESTInteger3  (TESTInteger3 *);


/*
TESTImplicit ::= SEQUENCE {
  ti1             [0] IMPLICIT INTEGER (-2147483648..2147483647),
  ti2             [1] IMPLICIT SEQUENCE {
    foo             [127] INTEGER (-2147483648..2147483647),
  },
  ti3             [2] IMPLICIT [5] IMPLICIT [4] IMPLICIT INTEGER (-2147483648..2147483647),
}
*/

typedef struct TESTImplicit {
  int ti1;
  struct TESTImplicit_ti2 {
    int foo;
  } ti2;
  int ti3;
} TESTImplicit;

ASN1EXP int    ASN1CALL decode_TESTImplicit(const unsigned char *, size_t, TESTImplicit *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTImplicit(unsigned char *, size_t, const TESTImplicit *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTImplicit(const TESTImplicit *);
ASN1EXP int    ASN1CALL copy_TESTImplicit  (const TESTImplicit *, TESTImplicit *);
ASN1EXP void   ASN1CALL free_TESTImplicit  (TESTImplicit *);


/*
TESTImplicit2 ::= SEQUENCE {
  ti1             [0] IMPLICIT TESTInteger,
  ti3             [2] IMPLICIT TESTInteger3,
}
*/

typedef struct TESTImplicit2 {
  TESTInteger ti1;
  TESTInteger3 ti3;
} TESTImplicit2;

ASN1EXP int    ASN1CALL decode_TESTImplicit2(const unsigned char *, size_t, TESTImplicit2 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTImplicit2(unsigned char *, size_t, const TESTImplicit2 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTImplicit2(const TESTImplicit2 *);
ASN1EXP int    ASN1CALL copy_TESTImplicit2  (const TESTImplicit2 *, TESTImplicit2 *);
ASN1EXP void   ASN1CALL free_TESTImplicit2  (TESTImplicit2 *);


/*
TESTAllocInner ::= SEQUENCE {
  ai              [0] TESTInteger,
}
*/

typedef struct TESTAllocInner {
  TESTInteger ai;
} TESTAllocInner;

ASN1EXP int    ASN1CALL decode_TESTAllocInner(const unsigned char *, size_t, TESTAllocInner *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTAllocInner(unsigned char *, size_t, const TESTAllocInner *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTAllocInner(const TESTAllocInner *);
ASN1EXP int    ASN1CALL copy_TESTAllocInner  (const TESTAllocInner *, TESTAllocInner *);
ASN1EXP void   ASN1CALL free_TESTAllocInner  (TESTAllocInner *);


/*
TESTAlloc ::= SEQUENCE {
  tagless         TESTAllocInner OPTIONAL,
  three           [1] INTEGER (-2147483648..2147483647),
  tagless2        heim_any OPTIONAL,
}
*/

typedef struct TESTAlloc {
  TESTAllocInner *tagless;
  int three;
  heim_any *tagless2;
} TESTAlloc;

ASN1EXP int    ASN1CALL decode_TESTAlloc(const unsigned char *, size_t, TESTAlloc *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTAlloc(unsigned char *, size_t, const TESTAlloc *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTAlloc(const TESTAlloc *);
ASN1EXP int    ASN1CALL copy_TESTAlloc  (const TESTAlloc *, TESTAlloc *);
ASN1EXP void   ASN1CALL free_TESTAlloc  (TESTAlloc *);


/*
TESTOptional ::= SEQUENCE {
  zero            [0] INTEGER (-2147483648..2147483647) OPTIONAL,
  one             [1] INTEGER (-2147483648..2147483647) OPTIONAL,
}
*/

typedef struct TESTOptional {
  int *zero;
  int *one;
} TESTOptional;

ASN1EXP int    ASN1CALL decode_TESTOptional(const unsigned char *, size_t, TESTOptional *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTOptional(unsigned char *, size_t, const TESTOptional *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTOptional(const TESTOptional *);
ASN1EXP int    ASN1CALL copy_TESTOptional  (const TESTOptional *, TESTOptional *);
ASN1EXP void   ASN1CALL free_TESTOptional  (TESTOptional *);


/*
TESTCONTAINING ::= OCTET STRING
*/

typedef heim_octet_string TESTCONTAINING;

ASN1EXP int    ASN1CALL decode_TESTCONTAINING(const unsigned char *, size_t, TESTCONTAINING *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTCONTAINING(unsigned char *, size_t, const TESTCONTAINING *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTCONTAINING(const TESTCONTAINING *);
ASN1EXP int    ASN1CALL copy_TESTCONTAINING  (const TESTCONTAINING *, TESTCONTAINING *);
ASN1EXP void   ASN1CALL free_TESTCONTAINING  (TESTCONTAINING *);


/*
TESTENCODEDBY ::= OCTET STRING
*/

typedef heim_octet_string TESTENCODEDBY;

ASN1EXP int    ASN1CALL decode_TESTENCODEDBY(const unsigned char *, size_t, TESTENCODEDBY *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTENCODEDBY(unsigned char *, size_t, const TESTENCODEDBY *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTENCODEDBY(const TESTENCODEDBY *);
ASN1EXP int    ASN1CALL copy_TESTENCODEDBY  (const TESTENCODEDBY *, TESTENCODEDBY *);
ASN1EXP void   ASN1CALL free_TESTENCODEDBY  (TESTENCODEDBY *);


/* OBJECT IDENTIFIER TESTDer ::= { joint-iso-itu-t(2) asn(1) ber-derived(2) distinguished-encoding(1) } */
extern ASN1EXP const heim_oid asn1_oid_TESTDer;
#define ASN1_OID_TESTDER (&asn1_oid_TESTDer)

/*
TESTCONTAININGENCODEDBY ::= OCTET STRING
*/

typedef heim_octet_string TESTCONTAININGENCODEDBY;

ASN1EXP int    ASN1CALL decode_TESTCONTAININGENCODEDBY(const unsigned char *, size_t, TESTCONTAININGENCODEDBY *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTCONTAININGENCODEDBY(unsigned char *, size_t, const TESTCONTAININGENCODEDBY *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTCONTAININGENCODEDBY(const TESTCONTAININGENCODEDBY *);
ASN1EXP int    ASN1CALL copy_TESTCONTAININGENCODEDBY  (const TESTCONTAININGENCODEDBY *, TESTCONTAININGENCODEDBY *);
ASN1EXP void   ASN1CALL free_TESTCONTAININGENCODEDBY  (TESTCONTAININGENCODEDBY *);


/*
TESTCONTAININGENCODEDBY2 ::= OCTET STRING
*/

typedef heim_octet_string TESTCONTAININGENCODEDBY2;

ASN1EXP int    ASN1CALL decode_TESTCONTAININGENCODEDBY2(const unsigned char *, size_t, TESTCONTAININGENCODEDBY2 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTCONTAININGENCODEDBY2(unsigned char *, size_t, const TESTCONTAININGENCODEDBY2 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTCONTAININGENCODEDBY2(const TESTCONTAININGENCODEDBY2 *);
ASN1EXP int    ASN1CALL copy_TESTCONTAININGENCODEDBY2  (const TESTCONTAININGENCODEDBY2 *, TESTCONTAININGENCODEDBY2 *);
ASN1EXP void   ASN1CALL free_TESTCONTAININGENCODEDBY2  (TESTCONTAININGENCODEDBY2 *);


enum { TESTValue1 = 1 };

/*
TESTUSERCONSTRAINED ::= OCTET STRING
*/

typedef heim_octet_string TESTUSERCONSTRAINED;

ASN1EXP int    ASN1CALL decode_TESTUSERCONSTRAINED(const unsigned char *, size_t, TESTUSERCONSTRAINED *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTUSERCONSTRAINED(unsigned char *, size_t, const TESTUSERCONSTRAINED *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTUSERCONSTRAINED(const TESTUSERCONSTRAINED *);
ASN1EXP int    ASN1CALL copy_TESTUSERCONSTRAINED  (const TESTUSERCONSTRAINED *, TESTUSERCONSTRAINED *);
ASN1EXP void   ASN1CALL free_TESTUSERCONSTRAINED  (TESTUSERCONSTRAINED *);


/*
TESTSeqOf ::= SEQUENCE OF TESTInteger
*/

typedef struct TESTSeqOf {
  unsigned int len;
  TESTInteger *val;
} TESTSeqOf;

ASN1EXP int   ASN1CALL add_TESTSeqOf  (TESTSeqOf *, const TESTInteger *);
ASN1EXP int   ASN1CALL remove_TESTSeqOf  (TESTSeqOf *, unsigned int);
ASN1EXP int    ASN1CALL decode_TESTSeqOf(const unsigned char *, size_t, TESTSeqOf *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOf(unsigned char *, size_t, const TESTSeqOf *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOf(const TESTSeqOf *);
ASN1EXP int    ASN1CALL copy_TESTSeqOf  (const TESTSeqOf *, TESTSeqOf *);
ASN1EXP void   ASN1CALL free_TESTSeqOf  (TESTSeqOf *);


/*
TESTSeqSizeOf1 ::= SEQUENCE OF TESTInteger
*/

typedef struct TESTSeqSizeOf1 {
  unsigned int len;
  TESTInteger *val;
} TESTSeqSizeOf1;

ASN1EXP int    ASN1CALL decode_TESTSeqSizeOf1(const unsigned char *, size_t, TESTSeqSizeOf1 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqSizeOf1(unsigned char *, size_t, const TESTSeqSizeOf1 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqSizeOf1(const TESTSeqSizeOf1 *);
ASN1EXP int    ASN1CALL copy_TESTSeqSizeOf1  (const TESTSeqSizeOf1 *, TESTSeqSizeOf1 *);
ASN1EXP void   ASN1CALL free_TESTSeqSizeOf1  (TESTSeqSizeOf1 *);


/*
TESTSeqSizeOf2 ::= SEQUENCE OF TESTInteger
*/

typedef struct TESTSeqSizeOf2 {
  unsigned int len;
  TESTInteger *val;
} TESTSeqSizeOf2;

ASN1EXP int    ASN1CALL decode_TESTSeqSizeOf2(const unsigned char *, size_t, TESTSeqSizeOf2 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqSizeOf2(unsigned char *, size_t, const TESTSeqSizeOf2 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqSizeOf2(const TESTSeqSizeOf2 *);
ASN1EXP int    ASN1CALL copy_TESTSeqSizeOf2  (const TESTSeqSizeOf2 *, TESTSeqSizeOf2 *);
ASN1EXP void   ASN1CALL free_TESTSeqSizeOf2  (TESTSeqSizeOf2 *);


/*
TESTSeqSizeOf3 ::= SEQUENCE OF TESTInteger
*/

typedef struct TESTSeqSizeOf3 {
  unsigned int len;
  TESTInteger *val;
} TESTSeqSizeOf3;

ASN1EXP int    ASN1CALL decode_TESTSeqSizeOf3(const unsigned char *, size_t, TESTSeqSizeOf3 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqSizeOf3(unsigned char *, size_t, const TESTSeqSizeOf3 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqSizeOf3(const TESTSeqSizeOf3 *);
ASN1EXP int    ASN1CALL copy_TESTSeqSizeOf3  (const TESTSeqSizeOf3 *, TESTSeqSizeOf3 *);
ASN1EXP void   ASN1CALL free_TESTSeqSizeOf3  (TESTSeqSizeOf3 *);


/*
TESTSeqSizeOf4 ::= SEQUENCE OF TESTInteger
*/

typedef struct TESTSeqSizeOf4 {
  unsigned int len;
  TESTInteger *val;
} TESTSeqSizeOf4;

ASN1EXP int    ASN1CALL decode_TESTSeqSizeOf4(const unsigned char *, size_t, TESTSeqSizeOf4 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqSizeOf4(unsigned char *, size_t, const TESTSeqSizeOf4 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqSizeOf4(const TESTSeqSizeOf4 *);
ASN1EXP int    ASN1CALL copy_TESTSeqSizeOf4  (const TESTSeqSizeOf4 *, TESTSeqSizeOf4 *);
ASN1EXP void   ASN1CALL free_TESTSeqSizeOf4  (TESTSeqSizeOf4 *);


/*
TESTOSSize1 ::= OCTET STRING
*/

typedef heim_octet_string TESTOSSize1;

ASN1EXP int    ASN1CALL decode_TESTOSSize1(const unsigned char *, size_t, TESTOSSize1 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTOSSize1(unsigned char *, size_t, const TESTOSSize1 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTOSSize1(const TESTOSSize1 *);
ASN1EXP int    ASN1CALL copy_TESTOSSize1  (const TESTOSSize1 *, TESTOSSize1 *);
ASN1EXP void   ASN1CALL free_TESTOSSize1  (TESTOSSize1 *);


/*
TESTSeqOfSeq ::= SEQUENCE OF SEQUENCE {
  zero            [0] TESTInteger,
}
*/

typedef struct TESTSeqOfSeq {
  unsigned int len;
  struct TESTSeqOfSeq_val {
    TESTInteger zero;
  } *val;
} TESTSeqOfSeq;

ASN1EXP int    ASN1CALL decode_TESTSeqOfSeq(const unsigned char *, size_t, TESTSeqOfSeq *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOfSeq(unsigned char *, size_t, const TESTSeqOfSeq *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOfSeq(const TESTSeqOfSeq *);
ASN1EXP int    ASN1CALL copy_TESTSeqOfSeq  (const TESTSeqOfSeq *, TESTSeqOfSeq *);
ASN1EXP void   ASN1CALL free_TESTSeqOfSeq  (TESTSeqOfSeq *);


/*
TESTSeqOfSeq2 ::= SEQUENCE OF SEQUENCE {
  string          [0] GeneralString,
}
*/

typedef struct TESTSeqOfSeq2 {
  unsigned int len;
  struct TESTSeqOfSeq2_val {
    heim_general_string string;
  } *val;
} TESTSeqOfSeq2;

ASN1EXP int    ASN1CALL decode_TESTSeqOfSeq2(const unsigned char *, size_t, TESTSeqOfSeq2 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOfSeq2(unsigned char *, size_t, const TESTSeqOfSeq2 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOfSeq2(const TESTSeqOfSeq2 *);
ASN1EXP int    ASN1CALL copy_TESTSeqOfSeq2  (const TESTSeqOfSeq2 *, TESTSeqOfSeq2 *);
ASN1EXP void   ASN1CALL free_TESTSeqOfSeq2  (TESTSeqOfSeq2 *);


/*
TESTSeqOfSeq3 ::= SEQUENCE OF SEQUENCE {
  zero            [0] TESTInteger,
  string          [0] GeneralString,
}
*/

typedef struct TESTSeqOfSeq3 {
  unsigned int len;
  struct TESTSeqOfSeq3_val {
    TESTInteger zero;
    heim_general_string string;
  } *val;
} TESTSeqOfSeq3;

ASN1EXP int    ASN1CALL decode_TESTSeqOfSeq3(const unsigned char *, size_t, TESTSeqOfSeq3 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOfSeq3(unsigned char *, size_t, const TESTSeqOfSeq3 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOfSeq3(const TESTSeqOfSeq3 *);
ASN1EXP int    ASN1CALL copy_TESTSeqOfSeq3  (const TESTSeqOfSeq3 *, TESTSeqOfSeq3 *);
ASN1EXP void   ASN1CALL free_TESTSeqOfSeq3  (TESTSeqOfSeq3 *);


/*
TESTSeqOf2 ::= SEQUENCE {
  strings         SEQUENCE OF GeneralString,
}
*/

typedef struct TESTSeqOf2 {
  struct TESTSeqOf2_strings {
    unsigned int len;
    heim_general_string *val;
  } strings;
} TESTSeqOf2;

ASN1EXP int    ASN1CALL decode_TESTSeqOf2(const unsigned char *, size_t, TESTSeqOf2 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOf2(unsigned char *, size_t, const TESTSeqOf2 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOf2(const TESTSeqOf2 *);
ASN1EXP int    ASN1CALL copy_TESTSeqOf2  (const TESTSeqOf2 *, TESTSeqOf2 *);
ASN1EXP void   ASN1CALL free_TESTSeqOf2  (TESTSeqOf2 *);


/*
TESTSeqOf3 ::= SEQUENCE {
  strings         SEQUENCE OF GeneralString OPTIONAL,
}
*/

typedef struct TESTSeqOf3 {
  struct TESTSeqOf3_strings {
    unsigned int len;
    heim_general_string *val;
  } *strings;
} TESTSeqOf3;

ASN1EXP int    ASN1CALL decode_TESTSeqOf3(const unsigned char *, size_t, TESTSeqOf3 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOf3(unsigned char *, size_t, const TESTSeqOf3 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOf3(const TESTSeqOf3 *);
ASN1EXP int    ASN1CALL copy_TESTSeqOf3  (const TESTSeqOf3 *, TESTSeqOf3 *);
ASN1EXP void   ASN1CALL free_TESTSeqOf3  (TESTSeqOf3 *);


/*
TESTSeqOf4 ::= SEQUENCE {
  b1              [0] SEQUENCE OF SEQUENCE {
  s1              OCTET STRING,
  s2              OCTET STRING,
  u1              TESTuint64,
  u2              TESTuint64,
} OPTIONAL,
  b2              [1] IMPLICIT SEQUENCE OF SEQUENCE {
  u1              TESTuint64,
  u2              TESTuint64,
  u3              TESTuint64,
  s1              OCTET STRING,
  s2              OCTET STRING,
  s3              OCTET STRING,
} OPTIONAL,
  b3              [2] IMPLICIT SEQUENCE OF SEQUENCE {
  s1              OCTET STRING,
  u1              TESTuint64,
  s2              OCTET STRING,
  u2              TESTuint64,
  s3              OCTET STRING,
  u3              TESTuint64,
  s4              OCTET STRING,
  u4              TESTuint64,
} OPTIONAL,
}
*/

typedef struct TESTSeqOf4 {
  struct TESTSeqOf4_b1 {
    unsigned int len;
    struct TESTSeqOf4_b1_val {
      heim_octet_string s1;
      heim_octet_string s2;
      TESTuint64 u1;
      TESTuint64 u2;
    } *val;
  } *b1;
  struct TESTSeqOf4_b2 {
    unsigned int len;
    struct TESTSeqOf4_b2_val {
      TESTuint64 u1;
      TESTuint64 u2;
      TESTuint64 u3;
      heim_octet_string s1;
      heim_octet_string s2;
      heim_octet_string s3;
    } *val;
  } *b2;
  struct TESTSeqOf4_b3 {
    unsigned int len;
    struct TESTSeqOf4_b3_val {
      heim_octet_string s1;
      TESTuint64 u1;
      heim_octet_string s2;
      TESTuint64 u2;
      heim_octet_string s3;
      TESTuint64 u3;
      heim_octet_string s4;
      TESTuint64 u4;
    } *val;
  } *b3;
} TESTSeqOf4;

ASN1EXP int    ASN1CALL decode_TESTSeqOf4(const unsigned char *, size_t, TESTSeqOf4 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOf4(unsigned char *, size_t, const TESTSeqOf4 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOf4(const TESTSeqOf4 *);
ASN1EXP int    ASN1CALL copy_TESTSeqOf4  (const TESTSeqOf4 *, TESTSeqOf4 *);
ASN1EXP void   ASN1CALL free_TESTSeqOf4  (TESTSeqOf4 *);


/*
TESTSeqOf5 ::= SEQUENCE {
  outer           SEQUENCE {
    inner           SEQUENCE {
      u0              TESTuint64,
      s0              OCTET STRING,
      u1              TESTuint64,
      s1              OCTET STRING,
      u2              TESTuint64,
      s2              OCTET STRING,
      u3              TESTuint64,
      s3              OCTET STRING,
      u4              TESTuint64,
      s4              OCTET STRING,
      u5              TESTuint64,
      s5              OCTET STRING,
      u6              TESTuint64,
      s6              OCTET STRING,
      u7              TESTuint64,
      s7              OCTET STRING,
    },
  } OPTIONAL,
}
*/

typedef struct TESTSeqOf5 {
  struct TESTSeqOf5_outer {
    struct TESTSeqOf5_outer_inner {
      TESTuint64 u0;
      heim_octet_string s0;
      TESTuint64 u1;
      heim_octet_string s1;
      TESTuint64 u2;
      heim_octet_string s2;
      TESTuint64 u3;
      heim_octet_string s3;
      TESTuint64 u4;
      heim_octet_string s4;
      TESTuint64 u5;
      heim_octet_string s5;
      TESTuint64 u6;
      heim_octet_string s6;
      TESTuint64 u7;
      heim_octet_string s7;
    } inner;
  } *outer;
} TESTSeqOf5;

ASN1EXP int    ASN1CALL decode_TESTSeqOf5(const unsigned char *, size_t, TESTSeqOf5 *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTSeqOf5(unsigned char *, size_t, const TESTSeqOf5 *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTSeqOf5(const TESTSeqOf5 *);
ASN1EXP int    ASN1CALL copy_TESTSeqOf5  (const TESTSeqOf5 *, TESTSeqOf5 *);
ASN1EXP void   ASN1CALL free_TESTSeqOf5  (TESTSeqOf5 *);


/*
TESTPreserve ::= SEQUENCE {
  zero            [0] TESTInteger,
  one             [1] TESTInteger,
}
*/

typedef struct TESTPreserve {
  TESTInteger zero;
  TESTInteger one;
} TESTPreserve;

ASN1EXP int    ASN1CALL decode_TESTPreserve(const unsigned char *, size_t, TESTPreserve *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTPreserve(unsigned char *, size_t, const TESTPreserve *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTPreserve(const TESTPreserve *);
ASN1EXP int    ASN1CALL copy_TESTPreserve  (const TESTPreserve *, TESTPreserve *);
ASN1EXP void   ASN1CALL free_TESTPreserve  (TESTPreserve *);


/*
TESTBitString ::= BIT STRING {
  zero(0),
  eight(8),
  thirtyone(31)
}
*/

typedef struct TESTBitString {
  unsigned int zero:1;
  unsigned int _unused1:1;
  unsigned int _unused2:1;
  unsigned int _unused3:1;
  unsigned int _unused4:1;
  unsigned int _unused5:1;
  unsigned int _unused6:1;
  unsigned int _unused7:1;
  unsigned int eight:1;
  unsigned int _unused9:1;
  unsigned int _unused10:1;
  unsigned int _unused11:1;
  unsigned int _unused12:1;
  unsigned int _unused13:1;
  unsigned int _unused14:1;
  unsigned int _unused15:1;
  unsigned int _unused16:1;
  unsigned int _unused17:1;
  unsigned int _unused18:1;
  unsigned int _unused19:1;
  unsigned int _unused20:1;
  unsigned int _unused21:1;
  unsigned int _unused22:1;
  unsigned int _unused23:1;
  unsigned int _unused24:1;
  unsigned int _unused25:1;
  unsigned int _unused26:1;
  unsigned int _unused27:1;
  unsigned int _unused28:1;
  unsigned int _unused29:1;
  unsigned int _unused30:1;
  unsigned int thirtyone:1;
} TESTBitString;


unsigned TESTBitString2int(TESTBitString);
TESTBitString int2TESTBitString(unsigned);
extern const struct units *asn1_TESTBitString_table_units;
#define asn1_TESTBitString_units() (asn1_TESTBitString_table_units)
ASN1EXP int    ASN1CALL decode_TESTBitString(const unsigned char *, size_t, TESTBitString *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTBitString(unsigned char *, size_t, const TESTBitString *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTBitString(const TESTBitString *);
ASN1EXP int    ASN1CALL copy_TESTBitString  (const TESTBitString *, TESTBitString *);
ASN1EXP void   ASN1CALL free_TESTBitString  (TESTBitString *);


/*
TESTMechType ::= OBJECT IDENTIFIER
*/

typedef heim_oid TESTMechType;

ASN1EXP int    ASN1CALL decode_TESTMechType(const unsigned char *, size_t, TESTMechType *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTMechType(unsigned char *, size_t, const TESTMechType *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTMechType(const TESTMechType *);
ASN1EXP int    ASN1CALL copy_TESTMechType  (const TESTMechType *, TESTMechType *);
ASN1EXP void   ASN1CALL free_TESTMechType  (TESTMechType *);


/*
TESTMechTypeList ::= SEQUENCE OF TESTMechType
*/

typedef struct TESTMechTypeList {
  unsigned int len;
  TESTMechType *val;
} TESTMechTypeList;

ASN1EXP int    ASN1CALL decode_TESTMechTypeList(const unsigned char *, size_t, TESTMechTypeList *, size_t *);
ASN1EXP int    ASN1CALL encode_TESTMechTypeList(unsigned char *, size_t, const TESTMechTypeList *, size_t *);
ASN1EXP size_t ASN1CALL length_TESTMechTypeList(const TESTMechTypeList *);
ASN1EXP int    ASN1CALL copy_TESTMechTypeList  (const TESTMechTypeList *, TESTMechTypeList *);
ASN1EXP void   ASN1CALL free_TESTMechTypeList  (TESTMechTypeList *);


#endif /* __test_template_asn1_h__ */
