#include <stdio.h>
#include <getarg.h>
#include <sl.h>
#include "gss-commands.h"

static int
mechanisms_wrap(int argc, char **argv)
{
    int ret;
    int optidx = 0;
    struct getargs args[] = {
        { "help", 'h', arg_flag, NULL, NULL, NULL }
    };
    int help_flag = 0;
    args[0].value = &help_flag;
    if(getarg(args, 1, argc, argv, &optidx))
        goto usage;
    if(argc - optidx > 0) {
        fprintf(stderr, "Arguments given (%u) are more than expected (0).\n\n", argc - optidx);
        goto usage;
    }
    if(help_flag)
        goto usage;
    ret = mechanisms(NULL, argc - optidx, argv + optidx);
    return ret;
usage:
    arg_printusage (args, 1, "mechanisms", "");
    return 0;
}

static int
attributes_wrap(int argc, char **argv)
{
    struct attributes_options opt;
    int ret;
    int optidx = 0;
    struct getargs args[] = {
        { "all", 0, arg_flag, NULL, NULL, NULL },
        { "mech", 0, arg_string, NULL, NULL, "mechanism" },
        { "help", 'h', arg_flag, NULL, NULL, NULL }
    };
    int help_flag = 0;
    opt.all_flag = 0;
    opt.mech_string = NULL;
    args[0].value = &opt.all_flag;
    args[1].value = &opt.mech_string;
    args[2].value = &help_flag;
    if(getarg(args, 3, argc, argv, &optidx))
        goto usage;
    if(help_flag)
        goto usage;
    ret = attributes(&opt, argc - optidx, argv + optidx);
    return ret;
usage:
    arg_printusage (args, 3, "attributes", "");
    return 0;
}

static int
help_wrap(int argc, char **argv)
{
    int ret;
    int optidx = 0;
    struct getargs args[] = {
        { "help", 'h', arg_flag, NULL, NULL, NULL }
    };
    int help_flag = 0;
    args[0].value = &help_flag;
    if(getarg(args, 1, argc, argv, &optidx))
        goto usage;
    if(argc - optidx > 1) {
        fprintf(stderr, "Arguments given (%u) are more than expected (1).\n\n", argc - optidx);
        goto usage;
    }
    if(argc - optidx < 0) {
        fprintf(stderr, "Arguments given (%u) are less than expected (0).\n\n", argc - optidx);
        goto usage;
    }
    if(help_flag)
        goto usage;
    ret = help(NULL, argc - optidx, argv + optidx);
    return ret;
usage:
    arg_printusage (args, 1, "help", "[command]");
    return 0;
}

SL_cmd commands[] = {
        { "mechanisms", mechanisms_wrap, "mechanisms", "Print the supported mechanisms" },
        { "supported-mechanisms", NULL, NULL, NULL },

        { "attributes", attributes_wrap, "attributes", "Print the attributes for mechs" },
        { "attrs-for-mech", NULL, NULL, NULL },

        { "help", help_wrap, "help [command]", "Help! I need somebody." },
        { "?", NULL, NULL, NULL },

    { NULL, NULL, NULL, NULL }
};
