/* Generated from /jenkins/jobs/oi-userland/workspace/components/library/heimdal/heimdal-7.8.0/lib/asn1/test.asn1 */
/* Do not edit */

#define  ASN1_LIB

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <krb5-types.h>
#include "test_asn1.h"
#include "test_asn1-priv.h"
#include <asn1_err.h>
#include <der.h>
#include <asn1-template.h>

#include <parse_units.h>

int ASN1CALL
encode_TESTuint32(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTuint32 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_unsigned(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTuint32(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTuint32 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Integer, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_unsigned(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTuint32(data);
return e;
}

void ASN1CALL
free_TESTuint32(TESTuint32 *data)
{
*data = 0;
}

size_t ASN1CALL
length_TESTuint32(const TESTuint32 *data)
{
size_t ret = 0;
ret += der_length_unsigned(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTuint32(const TESTuint32 *from, TESTuint32 *to)
{
memset(to, 0, sizeof(*to));
*(to) = *(from);
return 0;
}

int ASN1CALL
encode_TESTuint64(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTuint64 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_unsigned64(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTuint64(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTuint64 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Integer, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_unsigned64(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTuint64(data);
return e;
}

void ASN1CALL
free_TESTuint64(TESTuint64 *data)
{
*data = 0;
}

size_t ASN1CALL
length_TESTuint64(const TESTuint64 *data)
{
size_t ret = 0;
ret += der_length_unsigned64(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTuint64(const TESTuint64 *from, TESTuint64 *to)
{
memset(to, 0, sizeof(*to));
*(to) = *(from);
return 0;
}

int ASN1CALL
encode_TESTint64(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTint64 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_integer64(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTint64(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTint64 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Integer, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_integer64(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTint64(data);
return e;
}

void ASN1CALL
free_TESTint64(TESTint64 *data)
{
*data = 0;
}

size_t ASN1CALL
length_TESTint64(const TESTint64 *data)
{
size_t ret = 0;
ret += der_length_integer64(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTint64(const TESTint64 *from, TESTint64 *to)
{
memset(to, 0, sizeof(*to));
*(to) = *(from);
return 0;
}

int ASN1CALL
encode_TESTLargeTag(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTLargeTag *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* bar */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->bar, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 128, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* foo */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->foo, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 127, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTLargeTag(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTLargeTag *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t foo_datalen, foo_oldlen;
Der_type foo_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &foo_type, 127, &foo_datalen, &l);
if (e == 0 && foo_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
foo_oldlen = len;
if (foo_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = foo_datalen;
{
size_t foo_Tag_datalen, foo_Tag_oldlen;
Der_type foo_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &foo_Tag_type, UT_Integer, &foo_Tag_datalen, &l);
if (e == 0 && foo_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
foo_Tag_oldlen = len;
if (foo_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = foo_Tag_datalen;
e = der_get_integer(p, len, &(data)->foo, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = foo_Tag_oldlen - foo_Tag_datalen;
}
len = foo_oldlen - foo_datalen;
}
{
size_t bar_datalen, bar_oldlen;
Der_type bar_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &bar_type, 128, &bar_datalen, &l);
if (e == 0 && bar_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
bar_oldlen = len;
if (bar_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = bar_datalen;
{
size_t bar_Tag_datalen, bar_Tag_oldlen;
Der_type bar_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &bar_Tag_type, UT_Integer, &bar_Tag_datalen, &l);
if (e == 0 && bar_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
bar_Tag_oldlen = len;
if (bar_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = bar_Tag_datalen;
e = der_get_integer(p, len, &(data)->bar, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = bar_Tag_oldlen - bar_Tag_datalen;
}
len = bar_oldlen - bar_datalen;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTLargeTag(data);
return e;
}

void ASN1CALL
free_TESTLargeTag(TESTLargeTag *data)
{
*&(data)->foo = 0;
*&(data)->bar = 0;
}

size_t ASN1CALL
length_TESTLargeTag(const TESTLargeTag *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->foo);
ret += 1 + der_length_len (ret);
ret += 2 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->bar);
ret += 1 + der_length_len (ret);
ret += 3 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTLargeTag(const TESTLargeTag *from, TESTLargeTag *to)
{
memset(to, 0, sizeof(*to));
*(&(to)->foo) = *(&(from)->foo);
*(&(to)->bar) = *(&(from)->bar);
return 0;
}

int ASN1CALL
encode_TESTSeq(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeq *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* tag3 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->tag3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* tagless */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->tagless, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* tag1 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTLargeTag(p, len, &(data)->tag1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* tag0 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->tag0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeq(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeq *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t tag0_datalen, tag0_oldlen;
Der_type tag0_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &tag0_type, 0, &tag0_datalen, &l);
if (e == 0 && tag0_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
tag0_oldlen = len;
if (tag0_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = tag0_datalen;
{
size_t tag0_Tag_datalen, tag0_Tag_oldlen;
Der_type tag0_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &tag0_Tag_type, UT_Integer, &tag0_Tag_datalen, &l);
if (e == 0 && tag0_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
tag0_Tag_oldlen = len;
if (tag0_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = tag0_Tag_datalen;
e = der_get_integer(p, len, &(data)->tag0, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = tag0_Tag_oldlen - tag0_Tag_datalen;
}
len = tag0_oldlen - tag0_datalen;
}
{
size_t tag1_datalen, tag1_oldlen;
Der_type tag1_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &tag1_type, 1, &tag1_datalen, &l);
if (e == 0 && tag1_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
tag1_oldlen = len;
if (tag1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = tag1_datalen;
e = decode_TESTLargeTag(p, len, &(data)->tag1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = tag1_oldlen - tag1_datalen;
}
{
size_t tagless_datalen, tagless_oldlen;
Der_type tagless_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &tagless_type, UT_Integer, &tagless_datalen, &l);
if (e == 0 && tagless_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
tagless_oldlen = len;
if (tagless_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = tagless_datalen;
e = der_get_integer(p, len, &(data)->tagless, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = tagless_oldlen - tagless_datalen;
}
{
size_t tag3_datalen, tag3_oldlen;
Der_type tag3_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &tag3_type, 2, &tag3_datalen, &l);
if (e == 0 && tag3_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
tag3_oldlen = len;
if (tag3_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = tag3_datalen;
{
size_t tag3_Tag_datalen, tag3_Tag_oldlen;
Der_type tag3_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &tag3_Tag_type, UT_Integer, &tag3_Tag_datalen, &l);
if (e == 0 && tag3_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
tag3_Tag_oldlen = len;
if (tag3_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = tag3_Tag_datalen;
e = der_get_integer(p, len, &(data)->tag3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = tag3_Tag_oldlen - tag3_Tag_datalen;
}
len = tag3_oldlen - tag3_datalen;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeq(data);
return e;
}

void ASN1CALL
free_TESTSeq(TESTSeq *data)
{
*&(data)->tag0 = 0;
free_TESTLargeTag(&(data)->tag1);
*&(data)->tagless = 0;
*&(data)->tag3 = 0;
}

size_t ASN1CALL
length_TESTSeq(const TESTSeq *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->tag0);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_TESTLargeTag(&(data)->tag1);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->tagless);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->tag3);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeq(const TESTSeq *from, TESTSeq *to)
{
memset(to, 0, sizeof(*to));
*(&(to)->tag0) = *(&(from)->tag0);
if(copy_TESTLargeTag(&(from)->tag1, &(to)->tag1)) goto fail;
*(&(to)->tagless) = *(&(from)->tagless);
*(&(to)->tag3) = *(&(from)->tag3);
return 0;
fail:
free_TESTSeq(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTChoice1(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTChoice1 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;


switch((data)->element) {
case choice_TESTChoice1_i2: {size_t Top_oldret = ret;
ret = 0;
e = der_put_integer(p, len, &((data))->u.i2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_oldret;
break;
}
case choice_TESTChoice1_i1: {size_t Top_oldret = ret;
ret = 0;
e = der_put_integer(p, len, &((data))->u.i1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_oldret;
break;
}
case choice_TESTChoice1_asn1_ellipsis: {
if (len < (data)->u.asn1_ellipsis.length)
return ASN1_OVERFLOW;
p -= (data)->u.asn1_ellipsis.length;
ret += (data)->u.asn1_ellipsis.length;
memcpy(p + 1, (data)->u.asn1_ellipsis.data, (data)->u.asn1_ellipsis.length);
break;
}
};
*size = ret;
return 0;
}

int ASN1CALL
decode_TESTChoice1(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTChoice1 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
if (der_match_tag(p, len, ASN1_C_CONTEXT, CONS, 1, NULL) == 0) {
(data)->element = choice_TESTChoice1_i1;
{
size_t i1_datalen, i1_oldlen;
Der_type i1_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &i1_type, 1, &i1_datalen, &l);
if (e == 0 && i1_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
i1_oldlen = len;
if (i1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = i1_datalen;
{
size_t i1_Tag_datalen, i1_Tag_oldlen;
Der_type i1_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &i1_Tag_type, UT_Integer, &i1_Tag_datalen, &l);
if (e == 0 && i1_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
i1_Tag_oldlen = len;
if (i1_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = i1_Tag_datalen;
e = der_get_integer(p, len, &(data)->u.i1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = i1_Tag_oldlen - i1_Tag_datalen;
}
len = i1_oldlen - i1_datalen;
}
}
else if (der_match_tag(p, len, ASN1_C_CONTEXT, CONS, 2, NULL) == 0) {
(data)->element = choice_TESTChoice1_i2;
{
size_t i2_datalen, i2_oldlen;
Der_type i2_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &i2_type, 2, &i2_datalen, &l);
if (e == 0 && i2_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
i2_oldlen = len;
if (i2_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = i2_datalen;
{
size_t i2_Tag_datalen, i2_Tag_oldlen;
Der_type i2_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &i2_Tag_type, UT_Integer, &i2_Tag_datalen, &l);
if (e == 0 && i2_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
i2_Tag_oldlen = len;
if (i2_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = i2_Tag_datalen;
e = der_get_integer(p, len, &(data)->u.i2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = i2_Tag_oldlen - i2_Tag_datalen;
}
len = i2_oldlen - i2_datalen;
}
}
else {
(data)->element = choice_TESTChoice1_asn1_ellipsis;
(data)->u.asn1_ellipsis.data = calloc(1, len);
if ((data)->u.asn1_ellipsis.data == NULL) {
e = ENOMEM; goto fail;
}
(data)->u.asn1_ellipsis.length = len;
memcpy((data)->u.asn1_ellipsis.data, p, len);
p += len;
ret += len;
len = 0;
}
if(size) *size = ret;
return 0;
fail:
free_TESTChoice1(data);
return e;
}

void ASN1CALL
free_TESTChoice1(TESTChoice1 *data)
{
switch((data)->element) {
case choice_TESTChoice1_i1:
*&(data)->u.i1 = 0;
break;
case choice_TESTChoice1_i2:
*&(data)->u.i2 = 0;
break;
case choice_TESTChoice1_asn1_ellipsis:
der_free_octet_string(&(data)->u.asn1_ellipsis);
break;}
}

size_t ASN1CALL
length_TESTChoice1(const TESTChoice1 *data)
{
size_t ret = 0;
switch((data)->element) {
case choice_TESTChoice1_i1:
{
size_t Top_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->u.i1);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_oldret;
}
break;
case choice_TESTChoice1_i2:
{
size_t Top_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->u.i2);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_oldret;
}
break;
case choice_TESTChoice1_asn1_ellipsis:
ret += (data)->u.asn1_ellipsis.length;
break;
}
return ret;
}

int ASN1CALL
copy_TESTChoice1(const TESTChoice1 *from, TESTChoice1 *to)
{
memset(to, 0, sizeof(*to));
(to)->element = (from)->element;
switch((from)->element) {
case choice_TESTChoice1_i1:
*(&(to)->u.i1) = *(&(from)->u.i1);
break;
case choice_TESTChoice1_i2:
*(&(to)->u.i2) = *(&(from)->u.i2);
break;
case choice_TESTChoice1_asn1_ellipsis: {
int ret;
ret=der_copy_octet_string(&(from)->u.asn1_ellipsis, &(to)->u.asn1_ellipsis);
if (ret) goto fail;
break;
}
}
return 0;
fail:
free_TESTChoice1(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTChoice2(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTChoice2 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;


switch((data)->element) {
case choice_TESTChoice2_i1: {size_t Top_oldret = ret;
ret = 0;
e = der_put_integer(p, len, &((data))->u.i1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_oldret;
break;
}
case choice_TESTChoice2_asn1_ellipsis: {
if (len < (data)->u.asn1_ellipsis.length)
return ASN1_OVERFLOW;
p -= (data)->u.asn1_ellipsis.length;
ret += (data)->u.asn1_ellipsis.length;
memcpy(p + 1, (data)->u.asn1_ellipsis.data, (data)->u.asn1_ellipsis.length);
break;
}
};
*size = ret;
return 0;
}

int ASN1CALL
decode_TESTChoice2(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTChoice2 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
if (der_match_tag(p, len, ASN1_C_CONTEXT, CONS, 1, NULL) == 0) {
(data)->element = choice_TESTChoice2_i1;
{
size_t i1_datalen, i1_oldlen;
Der_type i1_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &i1_type, 1, &i1_datalen, &l);
if (e == 0 && i1_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
i1_oldlen = len;
if (i1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = i1_datalen;
{
size_t i1_Tag_datalen, i1_Tag_oldlen;
Der_type i1_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &i1_Tag_type, UT_Integer, &i1_Tag_datalen, &l);
if (e == 0 && i1_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
i1_Tag_oldlen = len;
if (i1_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = i1_Tag_datalen;
e = der_get_integer(p, len, &(data)->u.i1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = i1_Tag_oldlen - i1_Tag_datalen;
}
len = i1_oldlen - i1_datalen;
}
}
else {
(data)->element = choice_TESTChoice2_asn1_ellipsis;
(data)->u.asn1_ellipsis.data = calloc(1, len);
if ((data)->u.asn1_ellipsis.data == NULL) {
e = ENOMEM; goto fail;
}
(data)->u.asn1_ellipsis.length = len;
memcpy((data)->u.asn1_ellipsis.data, p, len);
p += len;
ret += len;
len = 0;
}
if(size) *size = ret;
return 0;
fail:
free_TESTChoice2(data);
return e;
}

void ASN1CALL
free_TESTChoice2(TESTChoice2 *data)
{
switch((data)->element) {
case choice_TESTChoice2_i1:
*&(data)->u.i1 = 0;
break;
case choice_TESTChoice2_asn1_ellipsis:
der_free_octet_string(&(data)->u.asn1_ellipsis);
break;}
}

size_t ASN1CALL
length_TESTChoice2(const TESTChoice2 *data)
{
size_t ret = 0;
switch((data)->element) {
case choice_TESTChoice2_i1:
{
size_t Top_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->u.i1);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_oldret;
}
break;
case choice_TESTChoice2_asn1_ellipsis:
ret += (data)->u.asn1_ellipsis.length;
break;
}
return ret;
}

int ASN1CALL
copy_TESTChoice2(const TESTChoice2 *from, TESTChoice2 *to)
{
memset(to, 0, sizeof(*to));
(to)->element = (from)->element;
switch((from)->element) {
case choice_TESTChoice2_i1:
*(&(to)->u.i1) = *(&(from)->u.i1);
break;
case choice_TESTChoice2_asn1_ellipsis: {
int ret;
ret=der_copy_octet_string(&(from)->u.asn1_ellipsis, &(to)->u.asn1_ellipsis);
if (ret) goto fail;
break;
}
}
return 0;
fail:
free_TESTChoice2(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTInteger(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTInteger *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_integer(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTInteger(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTInteger *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Integer, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_integer(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTInteger(data);
return e;
}

void ASN1CALL
free_TESTInteger(TESTInteger *data)
{
*data = 0;
}

size_t ASN1CALL
length_TESTInteger(const TESTInteger *data)
{
size_t ret = 0;
ret += der_length_integer(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTInteger(const TESTInteger *from, TESTInteger *to)
{
memset(to, 0, sizeof(*to));
*(to) = *(from);
return 0;
}

int ASN1CALL
encode_TESTInteger2(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTInteger2 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = encode_TESTInteger(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 4, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTInteger2(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTInteger2 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &Top_type, 4, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = decode_TESTInteger(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTInteger2(data);
return e;
}

void ASN1CALL
free_TESTInteger2(TESTInteger2 *data)
{
free_TESTInteger(data);
}

size_t ASN1CALL
length_TESTInteger2(const TESTInteger2 *data)
{
size_t ret = 0;
ret += length_TESTInteger(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTInteger2(const TESTInteger2 *from, TESTInteger2 *to)
{
memset(to, 0, sizeof(*to));
if(copy_TESTInteger(from, to)) goto fail;
return 0;
fail:
free_TESTInteger2(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTInteger3(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTInteger3 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = encode_TESTInteger2(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 5, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTInteger3(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTInteger3 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &Top_type, 5, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = decode_TESTInteger2(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTInteger3(data);
return e;
}

void ASN1CALL
free_TESTInteger3(TESTInteger3 *data)
{
free_TESTInteger2(data);
}

size_t ASN1CALL
length_TESTInteger3(const TESTInteger3 *data)
{
size_t ret = 0;
ret += length_TESTInteger2(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTInteger3(const TESTInteger3 *from, TESTInteger3 *to)
{
memset(to, 0, sizeof(*to));
if(copy_TESTInteger2(from, to)) goto fail;
return 0;
fail:
free_TESTInteger3(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTImplicit(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTImplicit *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* ti3 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->ti3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, PRIM, 2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* ti2 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
/* foo */
{
size_t ti2_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(&(data)->ti2)->foo, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 127, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += ti2_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* ti1 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->ti1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, PRIM, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTImplicit(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTImplicit *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t ti1_datalen, ti1_oldlen;
Der_type ti1_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &ti1_type, 0, &ti1_datalen, &l);
if (e == 0 && ti1_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
ti1_oldlen = len;
if (ti1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = ti1_datalen;
e = der_get_integer(p, len, &(data)->ti1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = ti1_oldlen - ti1_datalen;
}
{
size_t ti2_datalen, ti2_oldlen;
Der_type ti2_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &ti2_type, 1, &ti2_datalen, &l);
if (e == 0 && ti2_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
ti2_oldlen = len;
if (ti2_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = ti2_datalen;
{
size_t foo_datalen, foo_oldlen;
Der_type foo_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &foo_type, 127, &foo_datalen, &l);
if (e == 0 && foo_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
foo_oldlen = len;
if (foo_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = foo_datalen;
{
size_t foo_Tag_datalen, foo_Tag_oldlen;
Der_type foo_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &foo_Tag_type, UT_Integer, &foo_Tag_datalen, &l);
if (e == 0 && foo_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
foo_Tag_oldlen = len;
if (foo_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = foo_Tag_datalen;
e = der_get_integer(p, len, &(&(data)->ti2)->foo, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = foo_Tag_oldlen - foo_Tag_datalen;
}
len = foo_oldlen - foo_datalen;
}
len = ti2_oldlen - ti2_datalen;
}
{
size_t ti3_datalen, ti3_oldlen;
Der_type ti3_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &ti3_type, 2, &ti3_datalen, &l);
if (e == 0 && ti3_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
ti3_oldlen = len;
if (ti3_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = ti3_datalen;
e = der_get_integer(p, len, &(data)->ti3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = ti3_oldlen - ti3_datalen;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTImplicit(data);
return e;
}

void ASN1CALL
free_TESTImplicit(TESTImplicit *data)
{
*&(data)->ti1 = 0;
*&(&(data)->ti2)->foo = 0;
*&(data)->ti3 = 0;
}

size_t ASN1CALL
length_TESTImplicit(const TESTImplicit *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->ti1);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
{
size_t ti2_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(&(data)->ti2)->foo);
ret += 1 + der_length_len (ret);
ret += 2 + der_length_len (ret);
ret += ti2_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->ti3);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTImplicit(const TESTImplicit *from, TESTImplicit *to)
{
memset(to, 0, sizeof(*to));
*(&(to)->ti1) = *(&(from)->ti1);
*(&(&(to)->ti2)->foo) = *(&(&(from)->ti2)->foo);
*(&(to)->ti3) = *(&(from)->ti3);
return 0;
}

int ASN1CALL
encode_TESTImplicit2(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTImplicit2 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* ti3 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTInteger3(p, len, &(data)->ti3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* ti1 */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->ti1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTImplicit2(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTImplicit2 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t ti1_datalen, ti1_oldlen;
Der_type ti1_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &ti1_type, 0, &ti1_datalen, &l);
if (e == 0 && ti1_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
ti1_oldlen = len;
if (ti1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = ti1_datalen;
e = decode_TESTInteger(p, len, &(data)->ti1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = ti1_oldlen - ti1_datalen;
}
{
size_t ti3_datalen, ti3_oldlen;
Der_type ti3_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &ti3_type, 2, &ti3_datalen, &l);
if (e == 0 && ti3_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
ti3_oldlen = len;
if (ti3_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = ti3_datalen;
e = decode_TESTInteger3(p, len, &(data)->ti3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = ti3_oldlen - ti3_datalen;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTImplicit2(data);
return e;
}

void ASN1CALL
free_TESTImplicit2(TESTImplicit2 *data)
{
free_TESTInteger(&(data)->ti1);
free_TESTInteger3(&(data)->ti3);
}

size_t ASN1CALL
length_TESTImplicit2(const TESTImplicit2 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->ti1);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_TESTInteger3(&(data)->ti3);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTImplicit2(const TESTImplicit2 *from, TESTImplicit2 *to)
{
memset(to, 0, sizeof(*to));
if(copy_TESTInteger(&(from)->ti1, &(to)->ti1)) goto fail;
if(copy_TESTInteger3(&(from)->ti3, &(to)->ti3)) goto fail;
return 0;
fail:
free_TESTImplicit2(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTAllocInner(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTAllocInner *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* ai */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->ai, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTAllocInner(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTAllocInner *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t ai_datalen, ai_oldlen;
Der_type ai_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &ai_type, 0, &ai_datalen, &l);
if (e == 0 && ai_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
ai_oldlen = len;
if (ai_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = ai_datalen;
e = decode_TESTInteger(p, len, &(data)->ai, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = ai_oldlen - ai_datalen;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTAllocInner(data);
return e;
}

void ASN1CALL
free_TESTAllocInner(TESTAllocInner *data)
{
free_TESTInteger(&(data)->ai);
}

size_t ASN1CALL
length_TESTAllocInner(const TESTAllocInner *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->ai);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTAllocInner(const TESTAllocInner *from, TESTAllocInner *to)
{
memset(to, 0, sizeof(*to));
if(copy_TESTInteger(&(from)->ai, &(to)->ai)) goto fail;
return 0;
fail:
free_TESTAllocInner(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTAlloc(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTAlloc *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* tagless2 */
if((data)->tagless2) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_heim_any(p, len, (data)->tagless2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* three */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, &(data)->three, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* tagless */
if((data)->tagless) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTAllocInner(p, len, (data)->tagless, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTAlloc(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTAlloc *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
(data)->tagless = calloc(1, sizeof(*(data)->tagless));
if ((data)->tagless == NULL) goto fail;
e = decode_TESTAllocInner(p, len, (data)->tagless, &l);
if(e) {
free((data)->tagless);
(data)->tagless = NULL;
} else {
p += l; len -= l; ret += l;
}
{
size_t three_datalen, three_oldlen;
Der_type three_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &three_type, 1, &three_datalen, &l);
if (e == 0 && three_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
three_oldlen = len;
if (three_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = three_datalen;
{
size_t three_Tag_datalen, three_Tag_oldlen;
Der_type three_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &three_Tag_type, UT_Integer, &three_Tag_datalen, &l);
if (e == 0 && three_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
three_Tag_oldlen = len;
if (three_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = three_Tag_datalen;
e = der_get_integer(p, len, &(data)->three, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = three_Tag_oldlen - three_Tag_datalen;
}
len = three_oldlen - three_datalen;
}
(data)->tagless2 = calloc(1, sizeof(*(data)->tagless2));
if ((data)->tagless2 == NULL) goto fail;
e = decode_heim_any(p, len, (data)->tagless2, &l);
if(e) {
free((data)->tagless2);
(data)->tagless2 = NULL;
} else {
p += l; len -= l; ret += l;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTAlloc(data);
return e;
}

void ASN1CALL
free_TESTAlloc(TESTAlloc *data)
{
if((data)->tagless) {
free_TESTAllocInner((data)->tagless);
free((data)->tagless);
(data)->tagless = NULL;
}
*&(data)->three = 0;
if((data)->tagless2) {
free_heim_any((data)->tagless2);
free((data)->tagless2);
(data)->tagless2 = NULL;
}
}

size_t ASN1CALL
length_TESTAlloc(const TESTAlloc *data)
{
size_t ret = 0;
if((data)->tagless){
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_TESTAllocInner((data)->tagless);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer(&(data)->three);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
if((data)->tagless2){
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_heim_any((data)->tagless2);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTAlloc(const TESTAlloc *from, TESTAlloc *to)
{
memset(to, 0, sizeof(*to));
if((from)->tagless) {
(to)->tagless = malloc(sizeof(*(to)->tagless));
if((to)->tagless == NULL) goto fail;
if(copy_TESTAllocInner((from)->tagless, (to)->tagless)) goto fail;
}else
(to)->tagless = NULL;
*(&(to)->three) = *(&(from)->three);
if((from)->tagless2) {
(to)->tagless2 = malloc(sizeof(*(to)->tagless2));
if((to)->tagless2 == NULL) goto fail;
if(copy_heim_any((from)->tagless2, (to)->tagless2)) goto fail;
}else
(to)->tagless2 = NULL;
return 0;
fail:
free_TESTAlloc(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTOptional(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTOptional *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* one */
if((data)->one) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, (data)->one, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* zero */
if((data)->zero) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_integer(p, len, (data)->zero, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTOptional(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTOptional *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t zero_datalen, zero_oldlen;
Der_type zero_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &zero_type, 0, &zero_datalen, &l);
if (e == 0 && zero_type != CONS) { e = ASN1_BAD_ID; }
if(e) {
(data)->zero = NULL;
} else {
(data)->zero = calloc(1, sizeof(*(data)->zero));
if ((data)->zero == NULL) { e = ENOMEM; goto fail; }
p += l; len -= l; ret += l;
zero_oldlen = len;
if (zero_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = zero_datalen;
{
size_t zero_Tag_datalen, zero_Tag_oldlen;
Der_type zero_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &zero_Tag_type, UT_Integer, &zero_Tag_datalen, &l);
if (e == 0 && zero_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
zero_Tag_oldlen = len;
if (zero_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = zero_Tag_datalen;
e = der_get_integer(p, len, (data)->zero, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = zero_Tag_oldlen - zero_Tag_datalen;
}
len = zero_oldlen - zero_datalen;
}
}
{
size_t one_datalen, one_oldlen;
Der_type one_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &one_type, 1, &one_datalen, &l);
if (e == 0 && one_type != CONS) { e = ASN1_BAD_ID; }
if(e) {
(data)->one = NULL;
} else {
(data)->one = calloc(1, sizeof(*(data)->one));
if ((data)->one == NULL) { e = ENOMEM; goto fail; }
p += l; len -= l; ret += l;
one_oldlen = len;
if (one_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = one_datalen;
{
size_t one_Tag_datalen, one_Tag_oldlen;
Der_type one_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &one_Tag_type, UT_Integer, &one_Tag_datalen, &l);
if (e == 0 && one_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
one_Tag_oldlen = len;
if (one_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = one_Tag_datalen;
e = der_get_integer(p, len, (data)->one, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = one_Tag_oldlen - one_Tag_datalen;
}
len = one_oldlen - one_datalen;
}
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTOptional(data);
return e;
}

void ASN1CALL
free_TESTOptional(TESTOptional *data)
{
if((data)->zero) {
*(data)->zero = 0;
free((data)->zero);
(data)->zero = NULL;
}
if((data)->one) {
*(data)->one = 0;
free((data)->one);
(data)->one = NULL;
}
}

size_t ASN1CALL
length_TESTOptional(const TESTOptional *data)
{
size_t ret = 0;
if((data)->zero){
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer((data)->zero);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
if((data)->one){
size_t Top_tag_oldret = ret;
ret = 0;
ret += der_length_integer((data)->one);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTOptional(const TESTOptional *from, TESTOptional *to)
{
memset(to, 0, sizeof(*to));
if((from)->zero) {
(to)->zero = malloc(sizeof(*(to)->zero));
if((to)->zero == NULL) goto fail;
*((to)->zero) = *((from)->zero);
}else
(to)->zero = NULL;
if((from)->one) {
(to)->one = malloc(sizeof(*(to)->one));
if((to)->one == NULL) goto fail;
*((to)->one) = *((from)->one);
}else
(to)->one = NULL;
return 0;
fail:
free_TESTOptional(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTCONTAINING(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTCONTAINING *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_octet_string(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTCONTAINING(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTCONTAINING *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_OctetString, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_octet_string(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTCONTAINING(data);
return e;
}

void ASN1CALL
free_TESTCONTAINING(TESTCONTAINING *data)
{
der_free_octet_string(data);
}

size_t ASN1CALL
length_TESTCONTAINING(const TESTCONTAINING *data)
{
size_t ret = 0;
ret += der_length_octet_string(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTCONTAINING(const TESTCONTAINING *from, TESTCONTAINING *to)
{
memset(to, 0, sizeof(*to));
if(der_copy_octet_string(from, to)) goto fail;
return 0;
fail:
free_TESTCONTAINING(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTENCODEDBY(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTENCODEDBY *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_octet_string(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTENCODEDBY(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTENCODEDBY *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_OctetString, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_octet_string(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTENCODEDBY(data);
return e;
}

void ASN1CALL
free_TESTENCODEDBY(TESTENCODEDBY *data)
{
der_free_octet_string(data);
}

size_t ASN1CALL
length_TESTENCODEDBY(const TESTENCODEDBY *data)
{
size_t ret = 0;
ret += der_length_octet_string(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTENCODEDBY(const TESTENCODEDBY *from, TESTENCODEDBY *to)
{
memset(to, 0, sizeof(*to));
if(der_copy_octet_string(from, to)) goto fail;
return 0;
fail:
free_TESTENCODEDBY(to);
return ENOMEM;
}

static unsigned oid_TESTDer_variable_num[4] =  {2, 1, 2, 1 };
const heim_oid asn1_oid_TESTDer = { 4, oid_TESTDer_variable_num };

int ASN1CALL
encode_TESTCONTAININGENCODEDBY(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTCONTAININGENCODEDBY *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_octet_string(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTCONTAININGENCODEDBY(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTCONTAININGENCODEDBY *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_OctetString, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_octet_string(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTCONTAININGENCODEDBY(data);
return e;
}

void ASN1CALL
free_TESTCONTAININGENCODEDBY(TESTCONTAININGENCODEDBY *data)
{
der_free_octet_string(data);
}

size_t ASN1CALL
length_TESTCONTAININGENCODEDBY(const TESTCONTAININGENCODEDBY *data)
{
size_t ret = 0;
ret += der_length_octet_string(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTCONTAININGENCODEDBY(const TESTCONTAININGENCODEDBY *from, TESTCONTAININGENCODEDBY *to)
{
memset(to, 0, sizeof(*to));
if(der_copy_octet_string(from, to)) goto fail;
return 0;
fail:
free_TESTCONTAININGENCODEDBY(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTCONTAININGENCODEDBY2(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTCONTAININGENCODEDBY2 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_octet_string(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTCONTAININGENCODEDBY2(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTCONTAININGENCODEDBY2 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_OctetString, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_octet_string(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTCONTAININGENCODEDBY2(data);
return e;
}

void ASN1CALL
free_TESTCONTAININGENCODEDBY2(TESTCONTAININGENCODEDBY2 *data)
{
der_free_octet_string(data);
}

size_t ASN1CALL
length_TESTCONTAININGENCODEDBY2(const TESTCONTAININGENCODEDBY2 *data)
{
size_t ret = 0;
ret += der_length_octet_string(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTCONTAININGENCODEDBY2(const TESTCONTAININGENCODEDBY2 *from, TESTCONTAININGENCODEDBY2 *to)
{
memset(to, 0, sizeof(*to));
if(der_copy_octet_string(from, to)) goto fail;
return 0;
fail:
free_TESTCONTAININGENCODEDBY2(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTUSERCONSTRAINED(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTUSERCONSTRAINED *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_octet_string(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTUSERCONSTRAINED(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTUSERCONSTRAINED *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_OctetString, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_octet_string(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTUSERCONSTRAINED(data);
return e;
}

void ASN1CALL
free_TESTUSERCONSTRAINED(TESTUSERCONSTRAINED *data)
{
der_free_octet_string(data);
}

size_t ASN1CALL
length_TESTUSERCONSTRAINED(const TESTUSERCONSTRAINED *data)
{
size_t ret = 0;
ret += der_length_octet_string(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTUSERCONSTRAINED(const TESTUSERCONSTRAINED *from, TESTUSERCONSTRAINED *to)
{
memset(to, 0, sizeof(*to));
if(der_copy_octet_string(from, to)) goto fail;
return 0;
fail:
free_TESTUSERCONSTRAINED(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOf(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOf *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOf(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOf *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
e = decode_TESTInteger(p, len, &(data)->val[(data)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOf(data);
return e;
}

void ASN1CALL
free_TESTSeqOf(TESTSeqOf *data)
{
while((data)->len){
free_TESTInteger(&(data)->val[(data)->len-1]);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqOf(const TESTSeqOf *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->val[n_Top_tag - 1]);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOf(const TESTSeqOf *from, TESTSeqOf *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTInteger(&(from)->val[(to)->len], &(to)->val[(to)->len])) goto fail;
}
return 0;
fail:
free_TESTSeqOf(to);
return ENOMEM;
}

int ASN1CALL
add_TESTSeqOf(TESTSeqOf *data, const TESTInteger *element)
{
int ret;
void *ptr;

ptr = realloc(data->val, 
	(data->len + 1) * sizeof(data->val[0]));
if (ptr == NULL) return ENOMEM;
data->val = ptr;

ret = copy_TESTInteger(element, &data->val[data->len]);
if (ret) return ret;
data->len++;
return 0;
}

int ASN1CALL
remove_TESTSeqOf(TESTSeqOf *data, unsigned int element)
{
void *ptr;

if (data->len == 0 || element >= data->len)
	return ASN1_OVERRUN;
free_TESTInteger(&data->val[element]);
data->len--;
if (element < data->len)
	memmove(&data->val[element], &data->val[element + 1], 
		sizeof(data->val[0]) * (data->len - element));
ptr = realloc(data->val, data->len * sizeof(data->val[0]));
if (ptr != NULL || data->len == 0) data->val = ptr;
return 0;
}

int ASN1CALL
encode_TESTSeqSizeOf1(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqSizeOf1 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqSizeOf1(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqSizeOf1 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
e = decode_TESTInteger(p, len, &(data)->val[(data)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
if ((data)->len != 2) {
e = ASN1_EXACT_CONSTRAINT; goto fail;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqSizeOf1(data);
return e;
}

void ASN1CALL
free_TESTSeqSizeOf1(TESTSeqSizeOf1 *data)
{
while((data)->len){
free_TESTInteger(&(data)->val[(data)->len-1]);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqSizeOf1(const TESTSeqSizeOf1 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->val[n_Top_tag - 1]);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqSizeOf1(const TESTSeqSizeOf1 *from, TESTSeqSizeOf1 *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTInteger(&(from)->val[(to)->len], &(to)->val[(to)->len])) goto fail;
}
return 0;
fail:
free_TESTSeqSizeOf1(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqSizeOf2(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqSizeOf2 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqSizeOf2(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqSizeOf2 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
e = decode_TESTInteger(p, len, &(data)->val[(data)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
if ((data)->len > 2) {
e = ASN1_MAX_CONSTRAINT; goto fail;
}
if ((data)->len < 1) {
e = ASN1_MIN_CONSTRAINT; goto fail;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqSizeOf2(data);
return e;
}

void ASN1CALL
free_TESTSeqSizeOf2(TESTSeqSizeOf2 *data)
{
while((data)->len){
free_TESTInteger(&(data)->val[(data)->len-1]);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqSizeOf2(const TESTSeqSizeOf2 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->val[n_Top_tag - 1]);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqSizeOf2(const TESTSeqSizeOf2 *from, TESTSeqSizeOf2 *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTInteger(&(from)->val[(to)->len], &(to)->val[(to)->len])) goto fail;
}
return 0;
fail:
free_TESTSeqSizeOf2(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqSizeOf3(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqSizeOf3 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqSizeOf3(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqSizeOf3 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
e = decode_TESTInteger(p, len, &(data)->val[(data)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
if ((data)->len > 2147483647) {
e = ASN1_MAX_CONSTRAINT; goto fail;
}
if ((data)->len < 1) {
e = ASN1_MIN_CONSTRAINT; goto fail;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqSizeOf3(data);
return e;
}

void ASN1CALL
free_TESTSeqSizeOf3(TESTSeqSizeOf3 *data)
{
while((data)->len){
free_TESTInteger(&(data)->val[(data)->len-1]);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqSizeOf3(const TESTSeqSizeOf3 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->val[n_Top_tag - 1]);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqSizeOf3(const TESTSeqSizeOf3 *from, TESTSeqSizeOf3 *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTInteger(&(from)->val[(to)->len], &(to)->val[(to)->len])) goto fail;
}
return 0;
fail:
free_TESTSeqSizeOf3(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqSizeOf4(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqSizeOf4 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqSizeOf4(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqSizeOf4 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
e = decode_TESTInteger(p, len, &(data)->val[(data)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
if ((data)->len > 2) {
e = ASN1_MAX_CONSTRAINT; goto fail;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqSizeOf4(data);
return e;
}

void ASN1CALL
free_TESTSeqSizeOf4(TESTSeqSizeOf4 *data)
{
while((data)->len){
free_TESTInteger(&(data)->val[(data)->len-1]);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqSizeOf4(const TESTSeqSizeOf4 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->val[n_Top_tag - 1]);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqSizeOf4(const TESTSeqSizeOf4 *from, TESTSeqSizeOf4 *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTInteger(&(from)->val[(to)->len], &(to)->val[(to)->len])) goto fail;
}
return 0;
fail:
free_TESTSeqSizeOf4(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTOSSize1(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTOSSize1 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_octet_string(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTOSSize1(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTOSSize1 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_OctetString, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_octet_string(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
if ((data)->length > 2) {
e = ASN1_MAX_CONSTRAINT; goto fail;
}
if ((data)->length < 1) {
e = ASN1_MIN_CONSTRAINT; goto fail;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTOSSize1(data);
return e;
}

void ASN1CALL
free_TESTOSSize1(TESTOSSize1 *data)
{
der_free_octet_string(data);
}

size_t ASN1CALL
length_TESTOSSize1(const TESTOSSize1 *data)
{
size_t ret = 0;
ret += der_length_octet_string(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTOSSize1(const TESTOSSize1 *from, TESTOSSize1 *to)
{
memset(to, 0, sizeof(*to));
if(der_copy_octet_string(from, to)) goto fail;
return 0;
fail:
free_TESTOSSize1(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOfSeq(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOfSeq *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
/* zero */
{
size_t Top_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(&(data)->val[i])->zero, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_S_Of_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOfSeq(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOfSeq *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
{
size_t Top_Tag_s_of_datalen, Top_Tag_s_of_oldlen;
Der_type Top_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_Tag_s_of_type, UT_Sequence, &Top_Tag_s_of_datalen, &l);
if (e == 0 && Top_Tag_s_of_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_Tag_s_of_oldlen = len;
if (Top_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_Tag_s_of_datalen;
{
size_t zero_datalen, zero_oldlen;
Der_type zero_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &zero_type, 0, &zero_datalen, &l);
if (e == 0 && zero_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
zero_oldlen = len;
if (zero_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = zero_datalen;
e = decode_TESTInteger(p, len, &(&(data)->val[(data)->len])->zero, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = zero_oldlen - zero_datalen;
}
len = Top_Tag_s_of_oldlen - Top_Tag_s_of_datalen;
}
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOfSeq(data);
return e;
}

void ASN1CALL
free_TESTSeqOfSeq(TESTSeqOfSeq *data)
{
while((data)->len){
free_TESTInteger(&(&(data)->val[(data)->len-1])->zero);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqOfSeq(const TESTSeqOfSeq *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
{
size_t Top_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(&(data)->val[n_Top_tag - 1])->zero);
ret += 1 + der_length_len (ret);
ret += Top_tag_S_Of_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOfSeq(const TESTSeqOfSeq *from, TESTSeqOfSeq *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTInteger(&(&(from)->val[(to)->len])->zero, &(&(to)->val[(to)->len])->zero)) goto fail;
}
return 0;
fail:
free_TESTSeqOfSeq(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOfSeq2(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOfSeq2 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
/* string */
{
size_t Top_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_general_string(p, len, &(&(data)->val[i])->string, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_GeneralString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_S_Of_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOfSeq2(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOfSeq2 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
{
size_t Top_Tag_s_of_datalen, Top_Tag_s_of_oldlen;
Der_type Top_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_Tag_s_of_type, UT_Sequence, &Top_Tag_s_of_datalen, &l);
if (e == 0 && Top_Tag_s_of_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_Tag_s_of_oldlen = len;
if (Top_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_Tag_s_of_datalen;
{
size_t string_datalen, string_oldlen;
Der_type string_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &string_type, 0, &string_datalen, &l);
if (e == 0 && string_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
string_oldlen = len;
if (string_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = string_datalen;
{
size_t string_Tag_datalen, string_Tag_oldlen;
Der_type string_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &string_Tag_type, UT_GeneralString, &string_Tag_datalen, &l);
if (e == 0 && string_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
string_Tag_oldlen = len;
if (string_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = string_Tag_datalen;
e = der_get_general_string(p, len, &(&(data)->val[(data)->len])->string, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = string_Tag_oldlen - string_Tag_datalen;
}
len = string_oldlen - string_datalen;
}
len = Top_Tag_s_of_oldlen - Top_Tag_s_of_datalen;
}
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOfSeq2(data);
return e;
}

void ASN1CALL
free_TESTSeqOfSeq2(TESTSeqOfSeq2 *data)
{
while((data)->len){
der_free_general_string(&(&(data)->val[(data)->len-1])->string);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqOfSeq2(const TESTSeqOfSeq2 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
{
size_t Top_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_general_string(&(&(data)->val[n_Top_tag - 1])->string);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_S_Of_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOfSeq2(const TESTSeqOfSeq2 *from, TESTSeqOfSeq2 *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(der_copy_general_string(&(&(from)->val[(to)->len])->string, &(&(to)->val[(to)->len])->string)) goto fail;
}
return 0;
fail:
free_TESTSeqOfSeq2(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOfSeq3(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOfSeq3 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
/* string */
{
size_t Top_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_general_string(p, len, &(&(data)->val[i])->string, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_GeneralString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_S_Of_tag_oldret;
}
/* zero */
{
size_t Top_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(&(data)->val[i])->zero, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_S_Of_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOfSeq3(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOfSeq3 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
{
size_t Top_Tag_s_of_datalen, Top_Tag_s_of_oldlen;
Der_type Top_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_Tag_s_of_type, UT_Sequence, &Top_Tag_s_of_datalen, &l);
if (e == 0 && Top_Tag_s_of_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_Tag_s_of_oldlen = len;
if (Top_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_Tag_s_of_datalen;
{
size_t zero_datalen, zero_oldlen;
Der_type zero_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &zero_type, 0, &zero_datalen, &l);
if (e == 0 && zero_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
zero_oldlen = len;
if (zero_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = zero_datalen;
e = decode_TESTInteger(p, len, &(&(data)->val[(data)->len])->zero, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = zero_oldlen - zero_datalen;
}
{
size_t string_datalen, string_oldlen;
Der_type string_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &string_type, 0, &string_datalen, &l);
if (e == 0 && string_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
string_oldlen = len;
if (string_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = string_datalen;
{
size_t string_Tag_datalen, string_Tag_oldlen;
Der_type string_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &string_Tag_type, UT_GeneralString, &string_Tag_datalen, &l);
if (e == 0 && string_Tag_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
string_Tag_oldlen = len;
if (string_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = string_Tag_datalen;
e = der_get_general_string(p, len, &(&(data)->val[(data)->len])->string, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = string_Tag_oldlen - string_Tag_datalen;
}
len = string_oldlen - string_datalen;
}
len = Top_Tag_s_of_oldlen - Top_Tag_s_of_datalen;
}
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOfSeq3(data);
return e;
}

void ASN1CALL
free_TESTSeqOfSeq3(TESTSeqOfSeq3 *data)
{
while((data)->len){
free_TESTInteger(&(&(data)->val[(data)->len-1])->zero);
der_free_general_string(&(&(data)->val[(data)->len-1])->string);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqOfSeq3(const TESTSeqOfSeq3 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
{
size_t Top_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(&(data)->val[n_Top_tag - 1])->zero);
ret += 1 + der_length_len (ret);
ret += Top_tag_S_Of_tag_oldret;
}
{
size_t Top_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_general_string(&(&(data)->val[n_Top_tag - 1])->string);
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_S_Of_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOfSeq3(const TESTSeqOfSeq3 *from, TESTSeqOfSeq3 *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTInteger(&(&(from)->val[(to)->len])->zero, &(&(to)->val[(to)->len])->zero)) goto fail;
if(der_copy_general_string(&(&(from)->val[(to)->len])->string, &(&(to)->val[(to)->len])->string)) goto fail;
}
return 0;
fail:
free_TESTSeqOfSeq3(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOf2(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOf2 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* strings */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
for(i = (int)(&(data)->strings)->len - 1; i >= 0; --i) {
size_t strings_tag_for_oldret = ret;
ret = 0;
e = der_put_general_string(p, len, &(&(data)->strings)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_GeneralString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += strings_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOf2(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOf2 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t strings_datalen, strings_oldlen;
Der_type strings_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &strings_type, UT_Sequence, &strings_datalen, &l);
if (e == 0 && strings_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
strings_oldlen = len;
if (strings_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = strings_datalen;
{
size_t strings_Tag_origlen = len;
size_t strings_Tag_oldret = ret;
size_t strings_Tag_olen = 0;
void *strings_Tag_tmp;
ret = 0;
(&(data)->strings)->len = 0;
(&(data)->strings)->val = NULL;
while(ret < strings_Tag_origlen) {
size_t strings_Tag_nlen = strings_Tag_olen + sizeof(*((&(data)->strings)->val));
if (strings_Tag_olen > strings_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
strings_Tag_olen = strings_Tag_nlen;
strings_Tag_tmp = realloc((&(data)->strings)->val, strings_Tag_olen);
if (strings_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(&(data)->strings)->val = strings_Tag_tmp;
{
size_t strings_Tag_s_of_datalen, strings_Tag_s_of_oldlen;
Der_type strings_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &strings_Tag_s_of_type, UT_GeneralString, &strings_Tag_s_of_datalen, &l);
if (e == 0 && strings_Tag_s_of_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
strings_Tag_s_of_oldlen = len;
if (strings_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = strings_Tag_s_of_datalen;
e = der_get_general_string(p, len, &(&(data)->strings)->val[(&(data)->strings)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = strings_Tag_s_of_oldlen - strings_Tag_s_of_datalen;
}
(&(data)->strings)->len++;
len = strings_Tag_origlen - ret;
}
ret += strings_Tag_oldret;
}
len = strings_oldlen - strings_datalen;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOf2(data);
return e;
}

void ASN1CALL
free_TESTSeqOf2(TESTSeqOf2 *data)
{
while((&(data)->strings)->len){
der_free_general_string(&(&(data)->strings)->val[(&(data)->strings)->len-1]);
(&(data)->strings)->len--;
}
free((&(data)->strings)->val);
(&(data)->strings)->val = NULL;
}

size_t ASN1CALL
length_TESTSeqOf2(const TESTSeqOf2 *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
ret = 0;
{
size_t strings_tag_oldret = ret;
unsigned int n_strings_tag;
ret = 0;
for(n_strings_tag = (&(data)->strings)->len; n_strings_tag > 0; --n_strings_tag){
size_t strings_tag_for_oldret = ret;
ret = 0;
ret += der_length_general_string(&(&(data)->strings)->val[n_strings_tag - 1]);
ret += 1 + der_length_len (ret);
ret += strings_tag_for_oldret;
}
ret += strings_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOf2(const TESTSeqOf2 *from, TESTSeqOf2 *to)
{
memset(to, 0, sizeof(*to));
if(((&(to)->strings)->val = malloc((&(from)->strings)->len * sizeof(*(&(to)->strings)->val))) == NULL && (&(from)->strings)->len != 0)
goto fail;
for((&(to)->strings)->len = 0; (&(to)->strings)->len < (&(from)->strings)->len; (&(to)->strings)->len++){
if(der_copy_general_string(&(&(from)->strings)->val[(&(to)->strings)->len], &(&(to)->strings)->val[(&(to)->strings)->len])) goto fail;
}
return 0;
fail:
free_TESTSeqOf2(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOf3(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOf3 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* strings */
if((data)->strings) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
for(i = (int)((data)->strings)->len - 1; i >= 0; --i) {
size_t strings_tag_for_oldret = ret;
ret = 0;
e = der_put_general_string(p, len, &((data)->strings)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_GeneralString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += strings_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOf3(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOf3 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t strings_datalen, strings_oldlen;
Der_type strings_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &strings_type, UT_Sequence, &strings_datalen, &l);
if (e == 0 && strings_type != CONS) { e = ASN1_BAD_ID; }
if(e) {
(data)->strings = NULL;
} else {
(data)->strings = calloc(1, sizeof(*(data)->strings));
if ((data)->strings == NULL) { e = ENOMEM; goto fail; }
p += l; len -= l; ret += l;
strings_oldlen = len;
if (strings_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = strings_datalen;
{
size_t strings_Tag_origlen = len;
size_t strings_Tag_oldret = ret;
size_t strings_Tag_olen = 0;
void *strings_Tag_tmp;
ret = 0;
((data)->strings)->len = 0;
((data)->strings)->val = NULL;
while(ret < strings_Tag_origlen) {
size_t strings_Tag_nlen = strings_Tag_olen + sizeof(*(((data)->strings)->val));
if (strings_Tag_olen > strings_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
strings_Tag_olen = strings_Tag_nlen;
strings_Tag_tmp = realloc(((data)->strings)->val, strings_Tag_olen);
if (strings_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
((data)->strings)->val = strings_Tag_tmp;
{
size_t strings_Tag_s_of_datalen, strings_Tag_s_of_oldlen;
Der_type strings_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &strings_Tag_s_of_type, UT_GeneralString, &strings_Tag_s_of_datalen, &l);
if (e == 0 && strings_Tag_s_of_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
strings_Tag_s_of_oldlen = len;
if (strings_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = strings_Tag_s_of_datalen;
e = der_get_general_string(p, len, &((data)->strings)->val[((data)->strings)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = strings_Tag_s_of_oldlen - strings_Tag_s_of_datalen;
}
((data)->strings)->len++;
len = strings_Tag_origlen - ret;
}
ret += strings_Tag_oldret;
}
len = strings_oldlen - strings_datalen;
}
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOf3(data);
return e;
}

void ASN1CALL
free_TESTSeqOf3(TESTSeqOf3 *data)
{
if((data)->strings) {
while(((data)->strings)->len){
der_free_general_string(&((data)->strings)->val[((data)->strings)->len-1]);
((data)->strings)->len--;
}
free(((data)->strings)->val);
((data)->strings)->val = NULL;
free((data)->strings);
(data)->strings = NULL;
}
}

size_t ASN1CALL
length_TESTSeqOf3(const TESTSeqOf3 *data)
{
size_t ret = 0;
if((data)->strings){
size_t Top_tag_oldret = ret;
ret = 0;
{
size_t strings_tag_oldret = ret;
unsigned int n_strings_tag;
ret = 0;
for(n_strings_tag = ((data)->strings)->len; n_strings_tag > 0; --n_strings_tag){
size_t strings_tag_for_oldret = ret;
ret = 0;
ret += der_length_general_string(&((data)->strings)->val[n_strings_tag - 1]);
ret += 1 + der_length_len (ret);
ret += strings_tag_for_oldret;
}
ret += strings_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOf3(const TESTSeqOf3 *from, TESTSeqOf3 *to)
{
memset(to, 0, sizeof(*to));
if((from)->strings) {
(to)->strings = malloc(sizeof(*(to)->strings));
if((to)->strings == NULL) goto fail;
if((((to)->strings)->val = malloc(((from)->strings)->len * sizeof(*((to)->strings)->val))) == NULL && ((from)->strings)->len != 0)
goto fail;
for(((to)->strings)->len = 0; ((to)->strings)->len < ((from)->strings)->len; ((to)->strings)->len++){
if(der_copy_general_string(&((from)->strings)->val[((to)->strings)->len], &((to)->strings)->val[((to)->strings)->len])) goto fail;
}
}else
(to)->strings = NULL;
return 0;
fail:
free_TESTSeqOf3(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOf4(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOf4 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* b3 */
if((data)->b3) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
for(i = (int)((data)->b3)->len - 1; i >= 0; --i) {
size_t b3_tag_for_oldret = ret;
ret = 0;
/* u4 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b3)->val[i])->u4, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
/* s4 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b3)->val[i])->s4, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
/* u3 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b3)->val[i])->u3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
/* s3 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b3)->val[i])->s3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
/* u2 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b3)->val[i])->u2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
/* s2 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b3)->val[i])->s2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
/* u1 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b3)->val[i])->u1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
/* s1 */
{
size_t b3_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b3)->val[i])->s1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_S_Of_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b3_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* b2 */
if((data)->b2) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
for(i = (int)((data)->b2)->len - 1; i >= 0; --i) {
size_t b2_tag_for_oldret = ret;
ret = 0;
/* s3 */
{
size_t b2_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b2)->val[i])->s3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b2_tag_S_Of_tag_oldret;
}
/* s2 */
{
size_t b2_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b2)->val[i])->s2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b2_tag_S_Of_tag_oldret;
}
/* s1 */
{
size_t b2_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b2)->val[i])->s1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b2_tag_S_Of_tag_oldret;
}
/* u3 */
{
size_t b2_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b2)->val[i])->u3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b2_tag_S_Of_tag_oldret;
}
/* u2 */
{
size_t b2_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b2)->val[i])->u2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b2_tag_S_Of_tag_oldret;
}
/* u1 */
{
size_t b2_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b2)->val[i])->u1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b2_tag_S_Of_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b2_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* b1 */
if((data)->b1) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
for(i = (int)((data)->b1)->len - 1; i >= 0; --i) {
size_t b1_tag_tag_for_oldret = ret;
ret = 0;
/* u2 */
{
size_t b1_tag_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b1)->val[i])->u2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b1_tag_tag_S_Of_tag_oldret;
}
/* u1 */
{
size_t b1_tag_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->b1)->val[i])->u1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b1_tag_tag_S_Of_tag_oldret;
}
/* s2 */
{
size_t b1_tag_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b1)->val[i])->s2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b1_tag_tag_S_Of_tag_oldret;
}
/* s1 */
{
size_t b1_tag_tag_S_Of_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->b1)->val[i])->s1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b1_tag_tag_S_Of_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += b1_tag_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOf4(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOf4 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t b1_datalen, b1_oldlen;
Der_type b1_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &b1_type, 0, &b1_datalen, &l);
if (e == 0 && b1_type != CONS) { e = ASN1_BAD_ID; }
if(e) {
(data)->b1 = NULL;
} else {
(data)->b1 = calloc(1, sizeof(*(data)->b1));
if ((data)->b1 == NULL) { e = ENOMEM; goto fail; }
p += l; len -= l; ret += l;
b1_oldlen = len;
if (b1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = b1_datalen;
{
size_t b1_Tag_datalen, b1_Tag_oldlen;
Der_type b1_Tag_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &b1_Tag_type, UT_Sequence, &b1_Tag_datalen, &l);
if (e == 0 && b1_Tag_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
b1_Tag_oldlen = len;
if (b1_Tag_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = b1_Tag_datalen;
{
size_t b1_Tag_Tag_origlen = len;
size_t b1_Tag_Tag_oldret = ret;
size_t b1_Tag_Tag_olen = 0;
void *b1_Tag_Tag_tmp;
ret = 0;
((data)->b1)->len = 0;
((data)->b1)->val = NULL;
while(ret < b1_Tag_Tag_origlen) {
size_t b1_Tag_Tag_nlen = b1_Tag_Tag_olen + sizeof(*(((data)->b1)->val));
if (b1_Tag_Tag_olen > b1_Tag_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
b1_Tag_Tag_olen = b1_Tag_Tag_nlen;
b1_Tag_Tag_tmp = realloc(((data)->b1)->val, b1_Tag_Tag_olen);
if (b1_Tag_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
((data)->b1)->val = b1_Tag_Tag_tmp;
{
size_t b1_Tag_Tag_s_of_datalen, b1_Tag_Tag_s_of_oldlen;
Der_type b1_Tag_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &b1_Tag_Tag_s_of_type, UT_Sequence, &b1_Tag_Tag_s_of_datalen, &l);
if (e == 0 && b1_Tag_Tag_s_of_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
b1_Tag_Tag_s_of_oldlen = len;
if (b1_Tag_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = b1_Tag_Tag_s_of_datalen;
{
size_t s1_datalen, s1_oldlen;
Der_type s1_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s1_type, UT_OctetString, &s1_datalen, &l);
if (e == 0 && s1_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s1_oldlen = len;
if (s1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s1_datalen;
e = der_get_octet_string(p, len, &(&((data)->b1)->val[((data)->b1)->len])->s1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s1_oldlen - s1_datalen;
}
{
size_t s2_datalen, s2_oldlen;
Der_type s2_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s2_type, UT_OctetString, &s2_datalen, &l);
if (e == 0 && s2_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s2_oldlen = len;
if (s2_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s2_datalen;
e = der_get_octet_string(p, len, &(&((data)->b1)->val[((data)->b1)->len])->s2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s2_oldlen - s2_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->b1)->val[((data)->b1)->len])->u1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
e = decode_TESTuint64(p, len, &(&((data)->b1)->val[((data)->b1)->len])->u2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = b1_Tag_Tag_s_of_oldlen - b1_Tag_Tag_s_of_datalen;
}
((data)->b1)->len++;
len = b1_Tag_Tag_origlen - ret;
}
ret += b1_Tag_Tag_oldret;
}
len = b1_Tag_oldlen - b1_Tag_datalen;
}
len = b1_oldlen - b1_datalen;
}
}
{
size_t b2_datalen, b2_oldlen;
Der_type b2_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &b2_type, 1, &b2_datalen, &l);
if (e == 0 && b2_type != CONS) { e = ASN1_BAD_ID; }
if(e) {
(data)->b2 = NULL;
} else {
(data)->b2 = calloc(1, sizeof(*(data)->b2));
if ((data)->b2 == NULL) { e = ENOMEM; goto fail; }
p += l; len -= l; ret += l;
b2_oldlen = len;
if (b2_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = b2_datalen;
{
size_t b2_Tag_origlen = len;
size_t b2_Tag_oldret = ret;
size_t b2_Tag_olen = 0;
void *b2_Tag_tmp;
ret = 0;
((data)->b2)->len = 0;
((data)->b2)->val = NULL;
while(ret < b2_Tag_origlen) {
size_t b2_Tag_nlen = b2_Tag_olen + sizeof(*(((data)->b2)->val));
if (b2_Tag_olen > b2_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
b2_Tag_olen = b2_Tag_nlen;
b2_Tag_tmp = realloc(((data)->b2)->val, b2_Tag_olen);
if (b2_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
((data)->b2)->val = b2_Tag_tmp;
{
size_t b2_Tag_s_of_datalen, b2_Tag_s_of_oldlen;
Der_type b2_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &b2_Tag_s_of_type, UT_Sequence, &b2_Tag_s_of_datalen, &l);
if (e == 0 && b2_Tag_s_of_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
b2_Tag_s_of_oldlen = len;
if (b2_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = b2_Tag_s_of_datalen;
e = decode_TESTuint64(p, len, &(&((data)->b2)->val[((data)->b2)->len])->u1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
e = decode_TESTuint64(p, len, &(&((data)->b2)->val[((data)->b2)->len])->u2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
e = decode_TESTuint64(p, len, &(&((data)->b2)->val[((data)->b2)->len])->u3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s1_datalen, s1_oldlen;
Der_type s1_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s1_type, UT_OctetString, &s1_datalen, &l);
if (e == 0 && s1_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s1_oldlen = len;
if (s1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s1_datalen;
e = der_get_octet_string(p, len, &(&((data)->b2)->val[((data)->b2)->len])->s1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s1_oldlen - s1_datalen;
}
{
size_t s2_datalen, s2_oldlen;
Der_type s2_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s2_type, UT_OctetString, &s2_datalen, &l);
if (e == 0 && s2_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s2_oldlen = len;
if (s2_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s2_datalen;
e = der_get_octet_string(p, len, &(&((data)->b2)->val[((data)->b2)->len])->s2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s2_oldlen - s2_datalen;
}
{
size_t s3_datalen, s3_oldlen;
Der_type s3_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s3_type, UT_OctetString, &s3_datalen, &l);
if (e == 0 && s3_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s3_oldlen = len;
if (s3_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s3_datalen;
e = der_get_octet_string(p, len, &(&((data)->b2)->val[((data)->b2)->len])->s3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s3_oldlen - s3_datalen;
}
len = b2_Tag_s_of_oldlen - b2_Tag_s_of_datalen;
}
((data)->b2)->len++;
len = b2_Tag_origlen - ret;
}
ret += b2_Tag_oldret;
}
len = b2_oldlen - b2_datalen;
}
}
{
size_t b3_datalen, b3_oldlen;
Der_type b3_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &b3_type, 2, &b3_datalen, &l);
if (e == 0 && b3_type != CONS) { e = ASN1_BAD_ID; }
if(e) {
(data)->b3 = NULL;
} else {
(data)->b3 = calloc(1, sizeof(*(data)->b3));
if ((data)->b3 == NULL) { e = ENOMEM; goto fail; }
p += l; len -= l; ret += l;
b3_oldlen = len;
if (b3_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = b3_datalen;
{
size_t b3_Tag_origlen = len;
size_t b3_Tag_oldret = ret;
size_t b3_Tag_olen = 0;
void *b3_Tag_tmp;
ret = 0;
((data)->b3)->len = 0;
((data)->b3)->val = NULL;
while(ret < b3_Tag_origlen) {
size_t b3_Tag_nlen = b3_Tag_olen + sizeof(*(((data)->b3)->val));
if (b3_Tag_olen > b3_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
b3_Tag_olen = b3_Tag_nlen;
b3_Tag_tmp = realloc(((data)->b3)->val, b3_Tag_olen);
if (b3_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
((data)->b3)->val = b3_Tag_tmp;
{
size_t b3_Tag_s_of_datalen, b3_Tag_s_of_oldlen;
Der_type b3_Tag_s_of_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &b3_Tag_s_of_type, UT_Sequence, &b3_Tag_s_of_datalen, &l);
if (e == 0 && b3_Tag_s_of_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
b3_Tag_s_of_oldlen = len;
if (b3_Tag_s_of_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = b3_Tag_s_of_datalen;
{
size_t s1_datalen, s1_oldlen;
Der_type s1_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s1_type, UT_OctetString, &s1_datalen, &l);
if (e == 0 && s1_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s1_oldlen = len;
if (s1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s1_datalen;
e = der_get_octet_string(p, len, &(&((data)->b3)->val[((data)->b3)->len])->s1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s1_oldlen - s1_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->b3)->val[((data)->b3)->len])->u1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s2_datalen, s2_oldlen;
Der_type s2_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s2_type, UT_OctetString, &s2_datalen, &l);
if (e == 0 && s2_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s2_oldlen = len;
if (s2_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s2_datalen;
e = der_get_octet_string(p, len, &(&((data)->b3)->val[((data)->b3)->len])->s2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s2_oldlen - s2_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->b3)->val[((data)->b3)->len])->u2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s3_datalen, s3_oldlen;
Der_type s3_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s3_type, UT_OctetString, &s3_datalen, &l);
if (e == 0 && s3_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s3_oldlen = len;
if (s3_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s3_datalen;
e = der_get_octet_string(p, len, &(&((data)->b3)->val[((data)->b3)->len])->s3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s3_oldlen - s3_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->b3)->val[((data)->b3)->len])->u3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s4_datalen, s4_oldlen;
Der_type s4_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s4_type, UT_OctetString, &s4_datalen, &l);
if (e == 0 && s4_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s4_oldlen = len;
if (s4_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s4_datalen;
e = der_get_octet_string(p, len, &(&((data)->b3)->val[((data)->b3)->len])->s4, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s4_oldlen - s4_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->b3)->val[((data)->b3)->len])->u4, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = b3_Tag_s_of_oldlen - b3_Tag_s_of_datalen;
}
((data)->b3)->len++;
len = b3_Tag_origlen - ret;
}
ret += b3_Tag_oldret;
}
len = b3_oldlen - b3_datalen;
}
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOf4(data);
return e;
}

void ASN1CALL
free_TESTSeqOf4(TESTSeqOf4 *data)
{
if((data)->b1) {
while(((data)->b1)->len){
der_free_octet_string(&(&((data)->b1)->val[((data)->b1)->len-1])->s1);
der_free_octet_string(&(&((data)->b1)->val[((data)->b1)->len-1])->s2);
free_TESTuint64(&(&((data)->b1)->val[((data)->b1)->len-1])->u1);
free_TESTuint64(&(&((data)->b1)->val[((data)->b1)->len-1])->u2);
((data)->b1)->len--;
}
free(((data)->b1)->val);
((data)->b1)->val = NULL;
free((data)->b1);
(data)->b1 = NULL;
}
if((data)->b2) {
while(((data)->b2)->len){
free_TESTuint64(&(&((data)->b2)->val[((data)->b2)->len-1])->u1);
free_TESTuint64(&(&((data)->b2)->val[((data)->b2)->len-1])->u2);
free_TESTuint64(&(&((data)->b2)->val[((data)->b2)->len-1])->u3);
der_free_octet_string(&(&((data)->b2)->val[((data)->b2)->len-1])->s1);
der_free_octet_string(&(&((data)->b2)->val[((data)->b2)->len-1])->s2);
der_free_octet_string(&(&((data)->b2)->val[((data)->b2)->len-1])->s3);
((data)->b2)->len--;
}
free(((data)->b2)->val);
((data)->b2)->val = NULL;
free((data)->b2);
(data)->b2 = NULL;
}
if((data)->b3) {
while(((data)->b3)->len){
der_free_octet_string(&(&((data)->b3)->val[((data)->b3)->len-1])->s1);
free_TESTuint64(&(&((data)->b3)->val[((data)->b3)->len-1])->u1);
der_free_octet_string(&(&((data)->b3)->val[((data)->b3)->len-1])->s2);
free_TESTuint64(&(&((data)->b3)->val[((data)->b3)->len-1])->u2);
der_free_octet_string(&(&((data)->b3)->val[((data)->b3)->len-1])->s3);
free_TESTuint64(&(&((data)->b3)->val[((data)->b3)->len-1])->u3);
der_free_octet_string(&(&((data)->b3)->val[((data)->b3)->len-1])->s4);
free_TESTuint64(&(&((data)->b3)->val[((data)->b3)->len-1])->u4);
((data)->b3)->len--;
}
free(((data)->b3)->val);
((data)->b3)->val = NULL;
free((data)->b3);
(data)->b3 = NULL;
}
}

size_t ASN1CALL
length_TESTSeqOf4(const TESTSeqOf4 *data)
{
size_t ret = 0;
if((data)->b1){
size_t Top_tag_oldret = ret;
ret = 0;
{
size_t b1_tag_tag_oldret = ret;
unsigned int n_b1_tag_tag;
ret = 0;
for(n_b1_tag_tag = ((data)->b1)->len; n_b1_tag_tag > 0; --n_b1_tag_tag){
size_t b1_tag_tag_for_oldret = ret;
ret = 0;
{
size_t b1_tag_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b1)->val[n_b1_tag_tag - 1])->s1);
ret += 1 + der_length_len (ret);
ret += b1_tag_tag_S_Of_tag_oldret;
}
{
size_t b1_tag_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b1)->val[n_b1_tag_tag - 1])->s2);
ret += 1 + der_length_len (ret);
ret += b1_tag_tag_S_Of_tag_oldret;
}
{
size_t b1_tag_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b1)->val[n_b1_tag_tag - 1])->u1);
ret += b1_tag_tag_S_Of_tag_oldret;
}
{
size_t b1_tag_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b1)->val[n_b1_tag_tag - 1])->u2);
ret += b1_tag_tag_S_Of_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += b1_tag_tag_for_oldret;
}
ret += b1_tag_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
if((data)->b2){
size_t Top_tag_oldret = ret;
ret = 0;
{
size_t b2_tag_oldret = ret;
unsigned int n_b2_tag;
ret = 0;
for(n_b2_tag = ((data)->b2)->len; n_b2_tag > 0; --n_b2_tag){
size_t b2_tag_for_oldret = ret;
ret = 0;
{
size_t b2_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b2)->val[n_b2_tag - 1])->u1);
ret += b2_tag_S_Of_tag_oldret;
}
{
size_t b2_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b2)->val[n_b2_tag - 1])->u2);
ret += b2_tag_S_Of_tag_oldret;
}
{
size_t b2_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b2)->val[n_b2_tag - 1])->u3);
ret += b2_tag_S_Of_tag_oldret;
}
{
size_t b2_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b2)->val[n_b2_tag - 1])->s1);
ret += 1 + der_length_len (ret);
ret += b2_tag_S_Of_tag_oldret;
}
{
size_t b2_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b2)->val[n_b2_tag - 1])->s2);
ret += 1 + der_length_len (ret);
ret += b2_tag_S_Of_tag_oldret;
}
{
size_t b2_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b2)->val[n_b2_tag - 1])->s3);
ret += 1 + der_length_len (ret);
ret += b2_tag_S_Of_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += b2_tag_for_oldret;
}
ret += b2_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
if((data)->b3){
size_t Top_tag_oldret = ret;
ret = 0;
{
size_t b3_tag_oldret = ret;
unsigned int n_b3_tag;
ret = 0;
for(n_b3_tag = ((data)->b3)->len; n_b3_tag > 0; --n_b3_tag){
size_t b3_tag_for_oldret = ret;
ret = 0;
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b3)->val[n_b3_tag - 1])->s1);
ret += 1 + der_length_len (ret);
ret += b3_tag_S_Of_tag_oldret;
}
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b3)->val[n_b3_tag - 1])->u1);
ret += b3_tag_S_Of_tag_oldret;
}
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b3)->val[n_b3_tag - 1])->s2);
ret += 1 + der_length_len (ret);
ret += b3_tag_S_Of_tag_oldret;
}
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b3)->val[n_b3_tag - 1])->u2);
ret += b3_tag_S_Of_tag_oldret;
}
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b3)->val[n_b3_tag - 1])->s3);
ret += 1 + der_length_len (ret);
ret += b3_tag_S_Of_tag_oldret;
}
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b3)->val[n_b3_tag - 1])->u3);
ret += b3_tag_S_Of_tag_oldret;
}
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->b3)->val[n_b3_tag - 1])->s4);
ret += 1 + der_length_len (ret);
ret += b3_tag_S_Of_tag_oldret;
}
{
size_t b3_tag_S_Of_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->b3)->val[n_b3_tag - 1])->u4);
ret += b3_tag_S_Of_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += b3_tag_for_oldret;
}
ret += b3_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOf4(const TESTSeqOf4 *from, TESTSeqOf4 *to)
{
memset(to, 0, sizeof(*to));
if((from)->b1) {
(to)->b1 = malloc(sizeof(*(to)->b1));
if((to)->b1 == NULL) goto fail;
if((((to)->b1)->val = malloc(((from)->b1)->len * sizeof(*((to)->b1)->val))) == NULL && ((from)->b1)->len != 0)
goto fail;
for(((to)->b1)->len = 0; ((to)->b1)->len < ((from)->b1)->len; ((to)->b1)->len++){
if(der_copy_octet_string(&(&((from)->b1)->val[((to)->b1)->len])->s1, &(&((to)->b1)->val[((to)->b1)->len])->s1)) goto fail;
if(der_copy_octet_string(&(&((from)->b1)->val[((to)->b1)->len])->s2, &(&((to)->b1)->val[((to)->b1)->len])->s2)) goto fail;
if(copy_TESTuint64(&(&((from)->b1)->val[((to)->b1)->len])->u1, &(&((to)->b1)->val[((to)->b1)->len])->u1)) goto fail;
if(copy_TESTuint64(&(&((from)->b1)->val[((to)->b1)->len])->u2, &(&((to)->b1)->val[((to)->b1)->len])->u2)) goto fail;
}
}else
(to)->b1 = NULL;
if((from)->b2) {
(to)->b2 = malloc(sizeof(*(to)->b2));
if((to)->b2 == NULL) goto fail;
if((((to)->b2)->val = malloc(((from)->b2)->len * sizeof(*((to)->b2)->val))) == NULL && ((from)->b2)->len != 0)
goto fail;
for(((to)->b2)->len = 0; ((to)->b2)->len < ((from)->b2)->len; ((to)->b2)->len++){
if(copy_TESTuint64(&(&((from)->b2)->val[((to)->b2)->len])->u1, &(&((to)->b2)->val[((to)->b2)->len])->u1)) goto fail;
if(copy_TESTuint64(&(&((from)->b2)->val[((to)->b2)->len])->u2, &(&((to)->b2)->val[((to)->b2)->len])->u2)) goto fail;
if(copy_TESTuint64(&(&((from)->b2)->val[((to)->b2)->len])->u3, &(&((to)->b2)->val[((to)->b2)->len])->u3)) goto fail;
if(der_copy_octet_string(&(&((from)->b2)->val[((to)->b2)->len])->s1, &(&((to)->b2)->val[((to)->b2)->len])->s1)) goto fail;
if(der_copy_octet_string(&(&((from)->b2)->val[((to)->b2)->len])->s2, &(&((to)->b2)->val[((to)->b2)->len])->s2)) goto fail;
if(der_copy_octet_string(&(&((from)->b2)->val[((to)->b2)->len])->s3, &(&((to)->b2)->val[((to)->b2)->len])->s3)) goto fail;
}
}else
(to)->b2 = NULL;
if((from)->b3) {
(to)->b3 = malloc(sizeof(*(to)->b3));
if((to)->b3 == NULL) goto fail;
if((((to)->b3)->val = malloc(((from)->b3)->len * sizeof(*((to)->b3)->val))) == NULL && ((from)->b3)->len != 0)
goto fail;
for(((to)->b3)->len = 0; ((to)->b3)->len < ((from)->b3)->len; ((to)->b3)->len++){
if(der_copy_octet_string(&(&((from)->b3)->val[((to)->b3)->len])->s1, &(&((to)->b3)->val[((to)->b3)->len])->s1)) goto fail;
if(copy_TESTuint64(&(&((from)->b3)->val[((to)->b3)->len])->u1, &(&((to)->b3)->val[((to)->b3)->len])->u1)) goto fail;
if(der_copy_octet_string(&(&((from)->b3)->val[((to)->b3)->len])->s2, &(&((to)->b3)->val[((to)->b3)->len])->s2)) goto fail;
if(copy_TESTuint64(&(&((from)->b3)->val[((to)->b3)->len])->u2, &(&((to)->b3)->val[((to)->b3)->len])->u2)) goto fail;
if(der_copy_octet_string(&(&((from)->b3)->val[((to)->b3)->len])->s3, &(&((to)->b3)->val[((to)->b3)->len])->s3)) goto fail;
if(copy_TESTuint64(&(&((from)->b3)->val[((to)->b3)->len])->u3, &(&((to)->b3)->val[((to)->b3)->len])->u3)) goto fail;
if(der_copy_octet_string(&(&((from)->b3)->val[((to)->b3)->len])->s4, &(&((to)->b3)->val[((to)->b3)->len])->s4)) goto fail;
if(copy_TESTuint64(&(&((from)->b3)->val[((to)->b3)->len])->u4, &(&((to)->b3)->val[((to)->b3)->len])->u4)) goto fail;
}
}else
(to)->b3 = NULL;
return 0;
fail:
free_TESTSeqOf4(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTSeqOf5(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTSeqOf5 *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* outer */
if((data)->outer) {
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
/* inner */
{
size_t outer_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
/* s7 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s7, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u7 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u7, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* s6 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s6, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u6 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u6, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* s5 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s5, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u5 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u5, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* s4 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s4, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u4 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u4, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* s3 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u3 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u3, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* s2 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u2 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u2, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* s1 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u1 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* s0 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = der_put_octet_string(p, len, &(&((data)->outer)->inner)->s0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OctetString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
/* u0 */
{
size_t inner_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTuint64(p, len, &(&((data)->outer)->inner)->u0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += inner_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += outer_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTSeqOf5(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTSeqOf5 *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t outer_datalen, outer_oldlen;
Der_type outer_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &outer_type, UT_Sequence, &outer_datalen, &l);
if (e == 0 && outer_type != CONS) { e = ASN1_BAD_ID; }
if(e) {
(data)->outer = NULL;
} else {
(data)->outer = calloc(1, sizeof(*(data)->outer));
if ((data)->outer == NULL) { e = ENOMEM; goto fail; }
p += l; len -= l; ret += l;
outer_oldlen = len;
if (outer_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = outer_datalen;
{
size_t inner_datalen, inner_oldlen;
Der_type inner_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &inner_type, UT_Sequence, &inner_datalen, &l);
if (e == 0 && inner_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
inner_oldlen = len;
if (inner_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = inner_datalen;
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u0, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s0_datalen, s0_oldlen;
Der_type s0_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s0_type, UT_OctetString, &s0_datalen, &l);
if (e == 0 && s0_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s0_oldlen = len;
if (s0_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s0_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s0, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s0_oldlen - s0_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s1_datalen, s1_oldlen;
Der_type s1_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s1_type, UT_OctetString, &s1_datalen, &l);
if (e == 0 && s1_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s1_oldlen = len;
if (s1_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s1_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s1, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s1_oldlen - s1_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s2_datalen, s2_oldlen;
Der_type s2_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s2_type, UT_OctetString, &s2_datalen, &l);
if (e == 0 && s2_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s2_oldlen = len;
if (s2_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s2_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s2, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s2_oldlen - s2_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s3_datalen, s3_oldlen;
Der_type s3_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s3_type, UT_OctetString, &s3_datalen, &l);
if (e == 0 && s3_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s3_oldlen = len;
if (s3_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s3_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s3, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s3_oldlen - s3_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u4, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s4_datalen, s4_oldlen;
Der_type s4_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s4_type, UT_OctetString, &s4_datalen, &l);
if (e == 0 && s4_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s4_oldlen = len;
if (s4_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s4_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s4, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s4_oldlen - s4_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u5, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s5_datalen, s5_oldlen;
Der_type s5_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s5_type, UT_OctetString, &s5_datalen, &l);
if (e == 0 && s5_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s5_oldlen = len;
if (s5_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s5_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s5, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s5_oldlen - s5_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u6, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s6_datalen, s6_oldlen;
Der_type s6_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s6_type, UT_OctetString, &s6_datalen, &l);
if (e == 0 && s6_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s6_oldlen = len;
if (s6_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s6_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s6, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s6_oldlen - s6_datalen;
}
e = decode_TESTuint64(p, len, &(&((data)->outer)->inner)->u7, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
{
size_t s7_datalen, s7_oldlen;
Der_type s7_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &s7_type, UT_OctetString, &s7_datalen, &l);
if (e == 0 && s7_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
s7_oldlen = len;
if (s7_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = s7_datalen;
e = der_get_octet_string(p, len, &(&((data)->outer)->inner)->s7, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = s7_oldlen - s7_datalen;
}
len = inner_oldlen - inner_datalen;
}
len = outer_oldlen - outer_datalen;
}
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTSeqOf5(data);
return e;
}

void ASN1CALL
free_TESTSeqOf5(TESTSeqOf5 *data)
{
if((data)->outer) {
free_TESTuint64(&(&((data)->outer)->inner)->u0);
der_free_octet_string(&(&((data)->outer)->inner)->s0);
free_TESTuint64(&(&((data)->outer)->inner)->u1);
der_free_octet_string(&(&((data)->outer)->inner)->s1);
free_TESTuint64(&(&((data)->outer)->inner)->u2);
der_free_octet_string(&(&((data)->outer)->inner)->s2);
free_TESTuint64(&(&((data)->outer)->inner)->u3);
der_free_octet_string(&(&((data)->outer)->inner)->s3);
free_TESTuint64(&(&((data)->outer)->inner)->u4);
der_free_octet_string(&(&((data)->outer)->inner)->s4);
free_TESTuint64(&(&((data)->outer)->inner)->u5);
der_free_octet_string(&(&((data)->outer)->inner)->s5);
free_TESTuint64(&(&((data)->outer)->inner)->u6);
der_free_octet_string(&(&((data)->outer)->inner)->s6);
free_TESTuint64(&(&((data)->outer)->inner)->u7);
der_free_octet_string(&(&((data)->outer)->inner)->s7);
free((data)->outer);
(data)->outer = NULL;
}
}

size_t ASN1CALL
length_TESTSeqOf5(const TESTSeqOf5 *data)
{
size_t ret = 0;
if((data)->outer){
size_t Top_tag_oldret = ret;
ret = 0;
{
size_t outer_tag_oldret = ret;
ret = 0;
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u0);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s0);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u1);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s1);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u2);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s2);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u3);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s3);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u4);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s4);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u5);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s5);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u6);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s6);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += length_TESTuint64(&(&((data)->outer)->inner)->u7);
ret += inner_tag_oldret;
}
{
size_t inner_tag_oldret = ret;
ret = 0;
ret += der_length_octet_string(&(&((data)->outer)->inner)->s7);
ret += 1 + der_length_len (ret);
ret += inner_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += outer_tag_oldret;
}
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTSeqOf5(const TESTSeqOf5 *from, TESTSeqOf5 *to)
{
memset(to, 0, sizeof(*to));
if((from)->outer) {
(to)->outer = malloc(sizeof(*(to)->outer));
if((to)->outer == NULL) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u0, &(&((to)->outer)->inner)->u0)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s0, &(&((to)->outer)->inner)->s0)) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u1, &(&((to)->outer)->inner)->u1)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s1, &(&((to)->outer)->inner)->s1)) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u2, &(&((to)->outer)->inner)->u2)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s2, &(&((to)->outer)->inner)->s2)) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u3, &(&((to)->outer)->inner)->u3)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s3, &(&((to)->outer)->inner)->s3)) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u4, &(&((to)->outer)->inner)->u4)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s4, &(&((to)->outer)->inner)->s4)) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u5, &(&((to)->outer)->inner)->u5)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s5, &(&((to)->outer)->inner)->s5)) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u6, &(&((to)->outer)->inner)->u6)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s6, &(&((to)->outer)->inner)->s6)) goto fail;
if(copy_TESTuint64(&(&((from)->outer)->inner)->u7, &(&((to)->outer)->inner)->u7)) goto fail;
if(der_copy_octet_string(&(&((from)->outer)->inner)->s7, &(&((to)->outer)->inner)->s7)) goto fail;
}else
(to)->outer = NULL;
return 0;
fail:
free_TESTSeqOf5(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTPreserve(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTPreserve *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

/* one */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->one, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
/* zero */
{
size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
ret = 0;
e = encode_TESTInteger(p, len, &(data)->zero, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTPreserve(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTPreserve *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t zero_datalen, zero_oldlen;
Der_type zero_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &zero_type, 0, &zero_datalen, &l);
if (e == 0 && zero_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
zero_oldlen = len;
if (zero_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = zero_datalen;
e = decode_TESTInteger(p, len, &(data)->zero, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = zero_oldlen - zero_datalen;
}
{
size_t one_datalen, one_oldlen;
Der_type one_type;
e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &one_type, 1, &one_datalen, &l);
if (e == 0 && one_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
one_oldlen = len;
if (one_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = one_datalen;
e = decode_TESTInteger(p, len, &(data)->one, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = one_oldlen - one_datalen;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTPreserve(data);
return e;
}

void ASN1CALL
free_TESTPreserve(TESTPreserve *data)
{
free_TESTInteger(&(data)->zero);
free_TESTInteger(&(data)->one);
}

size_t ASN1CALL
length_TESTPreserve(const TESTPreserve *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->zero);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
{
size_t Top_tag_oldret = ret;
ret = 0;
ret += length_TESTInteger(&(data)->one);
ret += 1 + der_length_len (ret);
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTPreserve(const TESTPreserve *from, TESTPreserve *to)
{
memset(to, 0, sizeof(*to));
if(copy_TESTInteger(&(from)->zero, &(to)->zero)) goto fail;
if(copy_TESTInteger(&(from)->one, &(to)->one)) goto fail;
return 0;
fail:
free_TESTPreserve(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTBitString(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTBitString *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

{
unsigned char c = 0;
int rest = 0;
int bit_set = 0;
if((data)->thirtyone) {
c |= 1<<0;
}
if (c != 0 || bit_set) {
if (len < 1) return ASN1_OVERFLOW;
*p-- = c; len--; ret++;
if (!bit_set) {
rest = 0;
while(c) { 
if (c & 1) break;
c = c >> 1;
rest++;
}
bit_set = 1;
}
}
c = 0;
if (c != 0 || bit_set) {
if (len < 1) return ASN1_OVERFLOW;
*p-- = c; len--; ret++;
if (!bit_set) {
rest = 0;
while(c) { 
if (c & 1) break;
c = c >> 1;
rest++;
}
bit_set = 1;
}
}
c = 0;
if((data)->eight) {
c |= 1<<7;
}
if (c != 0 || bit_set) {
if (len < 1) return ASN1_OVERFLOW;
*p-- = c; len--; ret++;
if (!bit_set) {
rest = 0;
while(c) { 
if (c & 1) break;
c = c >> 1;
rest++;
}
bit_set = 1;
}
}
c = 0;
if((data)->zero) {
c |= 1<<7;
}
if (c != 0 || bit_set) {
if (len < 1) return ASN1_OVERFLOW;
*p-- = c; len--; ret++;
if (!bit_set) {
rest = 0;
if(c) { 
while(c) { 
if (c & 1) break;
c = c >> 1;
rest++;
}
}
}
}
if (len < 1) return ASN1_OVERFLOW;
*p-- = rest;
len -= 1;
ret += 1;
}

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_BitString, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTBitString(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTBitString *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_BitString, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
if (len < 1) return ASN1_OVERRUN;
p++; len--; ret++;
do {
if (len < 1) break;
(data)->zero = (*p >> 7) & 1;
p++; len--; ret++;
if (len < 1) break;
(data)->eight = (*p >> 7) & 1;
p++; len--; ret++;
if (len < 1) break;
p++; len--; ret++;
if (len < 1) break;
(data)->thirtyone = (*p >> 0) & 1;
} while(0);
p += len; ret += len;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTBitString(data);
return e;
}

void ASN1CALL
free_TESTBitString(TESTBitString *data)
{
}

size_t ASN1CALL
length_TESTBitString(const TESTBitString *data)
{
size_t ret = 0;
do {
if((data)->thirtyone) { ret += 4; break; }
if((data)->eight) { ret += 2; break; }
if((data)->zero) { ret += 1; break; }
} while(0);
ret += 1;
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTBitString(const TESTBitString *from, TESTBitString *to)
{
memset(to, 0, sizeof(*to));
*(to) = *(from);
return 0;
}

unsigned TESTBitString2int(TESTBitString f)
{
unsigned r = 0;
if(f.zero) r |= (1U << 0);
if(f.eight) r |= (1U << 8);
if(f.thirtyone) r |= (1U << 31);
return r;
}

TESTBitString int2TESTBitString(unsigned n)
{
	TESTBitString flags;

	memset(&flags, 0, sizeof(flags));

	flags.zero = (n >> 0) & 1;
	flags.eight = (n >> 8) & 1;
	flags.thirtyone = (n >> 31) & 1;
	return flags;
}

static struct units TESTBitString_units[] = {
	{"thirtyone",	1U << 31},
	{"eight",	1U << 8},
	{"zero",	1U << 0},
	{NULL,	0}
};

const struct units * asn1_TESTBitString_units(void){
return TESTBitString_units;
}

int ASN1CALL
encode_TESTMechType(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTMechType *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

e = der_put_oid(p, len, data, &l);
if (e) return e;
p -= l; len -= l; ret += l;

e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, PRIM, UT_OID, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTMechType(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTMechType *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_OID, &Top_datalen, &l);
if (e == 0 && Top_type != PRIM) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
e = der_get_oid(p, len, data, &l);
if(e) goto fail;
p += l; len -= l; ret += l;
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTMechType(data);
return e;
}

void ASN1CALL
free_TESTMechType(TESTMechType *data)
{
der_free_oid(data);
}

size_t ASN1CALL
length_TESTMechType(const TESTMechType *data)
{
size_t ret = 0;
ret += der_length_oid(data);
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTMechType(const TESTMechType *from, TESTMechType *to)
{
memset(to, 0, sizeof(*to));
if(der_copy_oid(from, to)) goto fail;
return 0;
fail:
free_TESTMechType(to);
return ENOMEM;
}

int ASN1CALL
encode_TESTMechTypeList(unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, const TESTMechTypeList *data, size_t *size)
{
size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

for(i = (int)(data)->len - 1; i >= 0; --i) {
size_t Top_tag_for_oldret = ret;
ret = 0;
e = encode_TESTMechType(p, len, &(data)->val[i], &l);
if (e) return e;
p -= l; len -= l; ret += l;

ret += Top_tag_for_oldret;
}
e = der_put_length_and_tag (p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
if (e) return e;
p -= l; len -= l; ret += l;

*size = ret;
return 0;
}

int ASN1CALL
decode_TESTMechTypeList(const unsigned char *p HEIMDAL_UNUSED_ATTRIBUTE, size_t len HEIMDAL_UNUSED_ATTRIBUTE, TESTMechTypeList *data, size_t *size)
{
size_t ret = 0;
size_t l HEIMDAL_UNUSED_ATTRIBUTE;
int e HEIMDAL_UNUSED_ATTRIBUTE;

memset(data, 0, sizeof(*data));
{
size_t Top_datalen, Top_oldlen;
Der_type Top_type;
e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence, &Top_datalen, &l);
if (e == 0 && Top_type != CONS) { e = ASN1_BAD_ID; }
if(e) goto fail;
p += l; len -= l; ret += l;
Top_oldlen = len;
if (Top_datalen > len) { e = ASN1_OVERRUN; goto fail; }
len = Top_datalen;
{
size_t Top_Tag_origlen = len;
size_t Top_Tag_oldret = ret;
size_t Top_Tag_olen = 0;
void *Top_Tag_tmp;
ret = 0;
(data)->len = 0;
(data)->val = NULL;
while(ret < Top_Tag_origlen) {
size_t Top_Tag_nlen = Top_Tag_olen + sizeof(*((data)->val));
if (Top_Tag_olen > Top_Tag_nlen) { e = ASN1_OVERFLOW; goto fail; }
Top_Tag_olen = Top_Tag_nlen;
Top_Tag_tmp = realloc((data)->val, Top_Tag_olen);
if (Top_Tag_tmp == NULL) { e = ENOMEM; goto fail; }
(data)->val = Top_Tag_tmp;
e = decode_TESTMechType(p, len, &(data)->val[(data)->len], &l);
if(e) goto fail;
p += l; len -= l; ret += l;
(data)->len++;
len = Top_Tag_origlen - ret;
}
ret += Top_Tag_oldret;
}
len = Top_oldlen - Top_datalen;
}
if(size) *size = ret;
return 0;
fail:
free_TESTMechTypeList(data);
return e;
}

void ASN1CALL
free_TESTMechTypeList(TESTMechTypeList *data)
{
while((data)->len){
free_TESTMechType(&(data)->val[(data)->len-1]);
(data)->len--;
}
free((data)->val);
(data)->val = NULL;
}

size_t ASN1CALL
length_TESTMechTypeList(const TESTMechTypeList *data)
{
size_t ret = 0;
{
size_t Top_tag_oldret = ret;
unsigned int n_Top_tag;
ret = 0;
for(n_Top_tag = (data)->len; n_Top_tag > 0; --n_Top_tag){
size_t Top_tag_for_oldret = ret;
ret = 0;
ret += length_TESTMechType(&(data)->val[n_Top_tag - 1]);
ret += Top_tag_for_oldret;
}
ret += Top_tag_oldret;
}
ret += 1 + der_length_len (ret);
return ret;
}

int ASN1CALL
copy_TESTMechTypeList(const TESTMechTypeList *from, TESTMechTypeList *to)
{
memset(to, 0, sizeof(*to));
if(((to)->val = malloc((from)->len * sizeof(*(to)->val))) == NULL && (from)->len != 0)
goto fail;
for((to)->len = 0; (to)->len < (from)->len; (to)->len++){
if(copy_TESTMechType(&(from)->val[(to)->len], &(to)->val[(to)->len])) goto fail;
}
return 0;
fail:
free_TESTMechTypeList(to);
return ENOMEM;
}

