/* Generated from
 * /jenkins/jobs/oi-userland/workspace/components/library/heimdal/heimdal-7.8.0/lib/hdb/hdb.asn1
 */
/* Do not edit */

#define ASN1_LIB

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <krb5-types.h>
#include "hdb_asn1.h"
#include "hdb_asn1-priv.h"
#include <asn1_err.h>
#include <der.h>
#include <asn1-template.h>

#include <parse_units.h>

int ASN1CALL encode_hdb_keyset(unsigned char* p HEIMDAL_UNUSED_ATTRIBUTE,
                               size_t len HEIMDAL_UNUSED_ATTRIBUTE,
                               const hdb_keyset* data,
                               size_t* size) {
  size_t ret HEIMDAL_UNUSED_ATTRIBUTE = 0;
  size_t l HEIMDAL_UNUSED_ATTRIBUTE;
  int i HEIMDAL_UNUSED_ATTRIBUTE, e HEIMDAL_UNUSED_ATTRIBUTE;

  /* set-time */
  if ((data)->set_time) {
    size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
    ret = 0;
    e = encode_KerberosTime(p, len, (data)->set_time, &l);
    if (e)
      return e;
    p -= l;
    len -= l;
    ret += l;

    e = der_put_length_and_tag(p, len, ret, ASN1_C_CONTEXT, CONS, 2, &l);
    if (e)
      return e;
    p -= l;
    len -= l;
    ret += l;

    ret += Top_tag_oldret;
  }
  /* keys */
  {
    size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
    ret = 0;
    e = encode_Keys(p, len, &(data)->keys, &l);
    if (e)
      return e;
    p -= l;
    len -= l;
    ret += l;

    e = der_put_length_and_tag(p, len, ret, ASN1_C_CONTEXT, CONS, 1, &l);
    if (e)
      return e;
    p -= l;
    len -= l;
    ret += l;

    ret += Top_tag_oldret;
  }
  /* kvno */
  {
    size_t Top_tag_oldret HEIMDAL_UNUSED_ATTRIBUTE = ret;
    ret = 0;
    e = der_put_unsigned(p, len, &(data)->kvno, &l);
    if (e)
      return e;
    p -= l;
    len -= l;
    ret += l;

    e = der_put_length_and_tag(p, len, ret, ASN1_C_UNIV, PRIM, UT_Integer, &l);
    if (e)
      return e;
    p -= l;
    len -= l;
    ret += l;

    e = der_put_length_and_tag(p, len, ret, ASN1_C_CONTEXT, CONS, 0, &l);
    if (e)
      return e;
    p -= l;
    len -= l;
    ret += l;

    ret += Top_tag_oldret;
  }
  e = der_put_length_and_tag(p, len, ret, ASN1_C_UNIV, CONS, UT_Sequence, &l);
  if (e)
    return e;
  p -= l;
  len -= l;
  ret += l;

  *size = ret;
  return 0;
}

int ASN1CALL decode_hdb_keyset(const unsigned char* p HEIMDAL_UNUSED_ATTRIBUTE,
                               size_t len HEIMDAL_UNUSED_ATTRIBUTE,
                               hdb_keyset* data,
                               size_t* size) {
  size_t ret = 0;
  size_t l HEIMDAL_UNUSED_ATTRIBUTE;
  int e HEIMDAL_UNUSED_ATTRIBUTE;

  memset(data, 0, sizeof(*data));
  {
    size_t Top_datalen, Top_oldlen;
    Der_type Top_type;
    e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &Top_type, UT_Sequence,
                                 &Top_datalen, &l);
    if (e == 0 && Top_type != CONS) {
      e = ASN1_BAD_ID;
    }
    if (e)
      goto fail;
    p += l;
    len -= l;
    ret += l;
    Top_oldlen = len;
    if (Top_datalen > len) {
      e = ASN1_OVERRUN;
      goto fail;
    }
    len = Top_datalen;
    {
      size_t kvno_datalen, kvno_oldlen;
      Der_type kvno_type;
      e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &kvno_type, 0,
                                   &kvno_datalen, &l);
      if (e == 0 && kvno_type != CONS) {
        e = ASN1_BAD_ID;
      }
      if (e)
        goto fail;
      p += l;
      len -= l;
      ret += l;
      kvno_oldlen = len;
      if (kvno_datalen > len) {
        e = ASN1_OVERRUN;
        goto fail;
      }
      len = kvno_datalen;
      {
        size_t kvno_Tag_datalen, kvno_Tag_oldlen;
        Der_type kvno_Tag_type;
        e = der_match_tag_and_length(p, len, ASN1_C_UNIV, &kvno_Tag_type,
                                     UT_Integer, &kvno_Tag_datalen, &l);
        if (e == 0 && kvno_Tag_type != PRIM) {
          e = ASN1_BAD_ID;
        }
        if (e)
          goto fail;
        p += l;
        len -= l;
        ret += l;
        kvno_Tag_oldlen = len;
        if (kvno_Tag_datalen > len) {
          e = ASN1_OVERRUN;
          goto fail;
        }
        len = kvno_Tag_datalen;
        e = der_get_unsigned(p, len, &(data)->kvno, &l);
        if (e)
          goto fail;
        p += l;
        len -= l;
        ret += l;
        len = kvno_Tag_oldlen - kvno_Tag_datalen;
      }
      len = kvno_oldlen - kvno_datalen;
    }
    {
      size_t keys_datalen, keys_oldlen;
      Der_type keys_type;
      e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &keys_type, 1,
                                   &keys_datalen, &l);
      if (e == 0 && keys_type != CONS) {
        e = ASN1_BAD_ID;
      }
      if (e)
        goto fail;
      p += l;
      len -= l;
      ret += l;
      keys_oldlen = len;
      if (keys_datalen > len) {
        e = ASN1_OVERRUN;
        goto fail;
      }
      len = keys_datalen;
      e = decode_Keys(p, len, &(data)->keys, &l);
      if (e)
        goto fail;
      p += l;
      len -= l;
      ret += l;
      len = keys_oldlen - keys_datalen;
    }
    {
      size_t set_time_datalen, set_time_oldlen;
      Der_type set_time_type;
      e = der_match_tag_and_length(p, len, ASN1_C_CONTEXT, &set_time_type, 2,
                                   &set_time_datalen, &l);
      if (e == 0 && set_time_type != CONS) {
        e = ASN1_BAD_ID;
      }
      if (e) {
        (data)->set_time = NULL;
      } else {
        (data)->set_time = calloc(1, sizeof(*(data)->set_time));
        if ((data)->set_time == NULL) {
          e = ENOMEM;
          goto fail;
        }
        p += l;
        len -= l;
        ret += l;
        set_time_oldlen = len;
        if (set_time_datalen > len) {
          e = ASN1_OVERRUN;
          goto fail;
        }
        len = set_time_datalen;
        e = decode_KerberosTime(p, len, (data)->set_time, &l);
        if (e)
          goto fail;
        p += l;
        len -= l;
        ret += l;
        len = set_time_oldlen - set_time_datalen;
      }
    }
    len = Top_oldlen - Top_datalen;
  }
  if (size)
    *size = ret;
  return 0;
fail:
  free_hdb_keyset(data);
  return e;
}

void ASN1CALL free_hdb_keyset(hdb_keyset* data) {
  *&(data)->kvno = 0;
  free_Keys(&(data)->keys);
  if ((data)->set_time) {
    free_KerberosTime((data)->set_time);
    free((data)->set_time);
    (data)->set_time = NULL;
  }
}

size_t ASN1CALL length_hdb_keyset(const hdb_keyset* data) {
  size_t ret = 0;
  {
    size_t Top_tag_oldret = ret;
    ret = 0;
    ret += der_length_unsigned(&(data)->kvno);
    ret += 1 + der_length_len(ret);
    ret += 1 + der_length_len(ret);
    ret += Top_tag_oldret;
  }
  {
    size_t Top_tag_oldret = ret;
    ret = 0;
    ret += length_Keys(&(data)->keys);
    ret += 1 + der_length_len(ret);
    ret += Top_tag_oldret;
  }
  if ((data)->set_time) {
    size_t Top_tag_oldret = ret;
    ret = 0;
    ret += length_KerberosTime((data)->set_time);
    ret += 1 + der_length_len(ret);
    ret += Top_tag_oldret;
  }
  ret += 1 + der_length_len(ret);
  return ret;
}

int ASN1CALL copy_hdb_keyset(const hdb_keyset* from, hdb_keyset* to) {
  memset(to, 0, sizeof(*to));
  *(&(to)->kvno) = *(&(from)->kvno);
  if (copy_Keys(&(from)->keys, &(to)->keys))
    goto fail;
  if ((from)->set_time) {
    (to)->set_time = malloc(sizeof(*(to)->set_time));
    if ((to)->set_time == NULL)
      goto fail;
    if (copy_KerberosTime((from)->set_time, (to)->set_time))
      goto fail;
  } else
    (to)->set_time = NULL;
  return 0;
fail:
  free_hdb_keyset(to);
  return ENOMEM;
}
