#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSActorTypeUtils = 8175,
  JSProcessActorChild = 8192,
  JSProcessActorParent = 8212,
  JSWindowActorChild = 8233,
  JSWindowActorParent = 8252,
  KeyEvent = 8272,
  KeyboardEvent = 8281,
  KeyframeEffect = 8295,
  L10nFileSource = 8310,
  L10nOverlays = 8325,
  L10nRegistry = 8338,
  LargestContentfulPaint = 8351,
  LegacyMozTCPSocket = 8374,
  LlamaRunner = 8393,
  Localization = 8405,
  Location = 8418,
  Lock = 8427,
  LockManager = 8432,
  MIDIAccess = 8444,
  MIDIConnectionEvent = 8455,
  MIDIInput = 8475,
  MIDIInputMap = 8485,
  MIDIMessageEvent = 8498,
  MIDIOutput = 8515,
  MIDIOutputMap = 8526,
  MIDIPort = 8540,
  MLS = 8549,
  MLSGroupView = 8553,
  MOZ_debug = 8566,
  MatchGlob = 8576,
  MatchPattern = 8586,
  MatchPatternSet = 8599,
  MathMLElement = 8615,
  MediaCapabilities = 8629,
  MediaControlService = 8647,
  MediaController = 8667,
  MediaDeviceInfo = 8683,
  MediaDevices = 8699,
  MediaElementAudioSourceNode = 8712,
  MediaEncryptedEvent = 8740,
  MediaError = 8760,
  MediaKeyError = 8771,
  MediaKeyMessageEvent = 8785,
  MediaKeySession = 8806,
  MediaKeyStatusMap = 8822,
  MediaKeyStatusMap_Iterator = 8840,
  MediaKeySystemAccess = 8867,
  MediaKeys = 8888,
  MediaList = 8898,
  MediaMetadata = 8908,
  MediaQueryList = 8922,
  MediaQueryListEvent = 8937,
  MediaRecorder = 8957,
  MediaRecorderErrorEvent = 8971,
  MediaSession = 8995,
  MediaSource = 9008,
  MediaStream = 9020,
  MediaStreamAudioDestinationNode = 9032,
  MediaStreamAudioSourceNode = 9064,
  MediaStreamError = 9091,
  MediaStreamEvent = 9108,
  MediaStreamTrack = 9125,
  MediaStreamTrackAudioSourceNode = 9142,
  MediaStreamTrackEvent = 9174,
  MerchantValidationEvent = 9196,
  MessageBroadcaster = 9220,
  MessageChannel = 9239,
  MessageEvent = 9254,
  MessageListenerManager = 9267,
  MessagePort = 9290,
  MessageSender = 9302,
  MimeType = 9316,
  MimeTypeArray = 9325,
  MouseEvent = 9339,
  MouseScrollEvent = 9350,
  MozCanvasPrintState = 9367,
  MozDocumentMatcher = 9387,
  MozDocumentObserver = 9406,
  MozQueryInterface = 9426,
  MozSharedMap = 9444,
  MozSharedMap_Iterator = 9457,
  MozSharedMapChangeEvent = 9479,
  MozStorageAsyncStatementParams = 9503,
  MozStorageStatementParams = 9534,
  MozStorageStatementRow = 9560,
  MozWritableSharedMap = 9583,
  MutationObserver = 9604,
  MutationRecord = 9621,
  NamedNodeMap = 9636,
  NavigateEvent = 9649,
  Navigation = 9663,
  NavigationActivation = 9674,
  NavigationCurrentEntryChangeEvent = 9695,
  NavigationDestination = 9729,
  NavigationHistoryEntry = 9751,
  NavigationPrecommitController = 9774,
  NavigationPreloadManager = 9804,
  NavigationTransition = 9829,
  Navigator = 9850,
  NavigatorLogin = 9860,
  NetworkInformation = 9875,
  Node = 9894,
  NodeFilter = 9899,
  NodeIterator = 9910,
  NodeList = 9923,
  Notification = 9932,
  NotificationEvent = 9945,
  NotifyPaintEvent = 9963,
  OES_draw_buffers_indexed = 9980,
  OES_element_index_uint = 10005,
  OES_fbo_render_mipmap = 10028,
  OES_standard_derivatives = 10050,
  OES_texture_float = 10075,
  OES_texture_float_linear = 10093,
  OES_texture_half_float = 10118,
  OES_texture_half_float_linear = 10141,
  OES_vertex_array_object = 10171,
  OVR_multiview2 = 10195,
  OfflineAudioCompletionEvent = 10210,
  OfflineAudioContext = 10238,
  OffscreenCanvas = 10258,
  OffscreenCanvasRenderingContext2D = 10274,
  Option = 10308,
  OscillatorNode = 10315,
  PageTransitionEvent = 10330,
  PaintRequest = 10350,
  PaintRequestList = 10363,
  PaintWorkletGlobalScope = 10380,
  PannerNode = 10404,
  ParentProcessMessageManager = 10415,
  Path2D = 10443,
  PathUtils = 10450,
  PaymentAddress = 10460,
  PaymentMethodChangeEvent = 10475,
  PaymentRequest = 10500,
  PaymentRequestUpdateEvent = 10515,
  PaymentResponse = 10541,
  Performance = 10557,
  PerformanceEntry = 10569,
  PerformanceEntryEvent = 10586,
  PerformanceEventTiming = 10608,
  PerformanceMark = 10631,
  PerformanceMeasure = 10647,
  PerformanceNavigation = 10666,
  PerformanceNavigationTiming = 10688,
  PerformanceObserver = 10716,
  PerformanceObserverEntryList = 10736,
  PerformancePaintTiming = 10765,
  PerformanceResourceTiming = 10788,
  PerformanceServerTiming = 10814,
  PerformanceTiming = 10838,
  PeriodicWave = 10856,
  PermissionStatus = 10869,
  Permissions = 10886,
  PlacesBookmark = 10898,
  PlacesBookmarkAddition = 10913,
  PlacesBookmarkChanged = 10936,
  PlacesBookmarkGuid = 10958,
  PlacesBookmarkKeyword = 10977,
  PlacesBookmarkMoved = 10999,
  PlacesBookmarkRemoved = 11019,
  PlacesBookmarkTags = 11041,
  PlacesBookmarkTime = 11060,
  PlacesBookmarkTitle = 11079,
  PlacesBookmarkUrl = 11099,
  PlacesEvent = 11117,
  PlacesEventCounts = 11129,
  PlacesFavicon = 11147,
  PlacesHistoryCleared = 11161,
  PlacesObservers = 11182,
  PlacesPurgeCaches = 11198,
  PlacesRanking = 11216,
  PlacesVisit = 11230,
  PlacesVisitRemoved = 11242,
  PlacesVisitTitle = 11261,
  PlacesWeakCallbackWrapper = 11278,
  Plugin = 11304,
  PluginArray = 11311,
  PluginCrashedEvent = 11323,
  PointerEvent = 11342,
  PopStateEvent = 11355,
  PopupBlockedEvent = 11369,
  PopupPositionedEvent = 11387,
  PositionStateEvent = 11408,
  PrecompiledScript = 11427,
  PrivateAttribution = 11445,
  ProcessMessageManager = 11464,
  ProcessingInstruction = 11486,
  ProgressEvent = 11508,
  PromiseDebugging = 11522,
  PromiseNativeHandler = 11539,
  PromiseRejectionEvent = 11560,
  PublicKeyCredential = 11582,
  PushEvent = 11602,
  PushManager = 11612,
  PushManagerImpl = 11624,
  PushMessageData = 11640,
  PushSubscription = 11656,
  PushSubscriptionChangeEvent = 11673,
  PushSubscriptionOptions = 11701,
  RadioNodeList = 11725,
  Range = 11739,
  ReadableByteStreamController = 11745,
  ReadableStream = 11774,
  ReadableStream_AsyncIterator = 11789,
  ReadableStreamBYOBReader = 11818,
  ReadableStreamBYOBRequest = 11843,
  ReadableStreamDefaultController = 11869,
  ReadableStreamDefaultReader = 11901,
  RedirectBlockedEvent = 11929,
  Report = 11950,
  ReportBody = 11957,
  ReportingObserver = 11968,
  Request = 11986,
  ResizeObserver = 11994,
  ResizeObserverEntry = 12009,
  ResizeObserverSize = 12029,
  Response = 12048,
  SVGAElement = 12057,
  SVGAngle = 12069,
  SVGAnimateElement = 12078,
  SVGAnimateMotionElement = 12096,
  SVGAnimateTransformElement = 12120,
  SVGAnimatedAngle = 12147,
  SVGAnimatedBoolean = 12164,
  SVGAnimatedEnumeration = 12183,
  SVGAnimatedInteger = 12206,
  SVGAnimatedLength = 12225,
  SVGAnimatedLengthList = 12243,
  SVGAnimatedNumber = 12265,
  SVGAnimatedNumberList = 12283,
  SVGAnimatedPreserveAspectRatio = 12305,
  SVGAnimatedRect = 12336,
  SVGAnimatedString = 12352,
  SVGAnimatedTransformList = 12370,
  SVGAnimationElement = 12395,
  SVGCircleElement = 12415,
  SVGClipPathElement = 12432,
  SVGComponentTransferFunctionElement = 12451,
  SVGDefsElement = 12487,
  SVGDescElement = 12502,
  SVGElement = 12517,
  SVGEllipseElement = 12528,
  SVGFEBlendElement = 12546,
  SVGFEColorMatrixElement = 12564,
  SVGFEComponentTransferElement = 12588,
  SVGFECompositeElement = 12618,
  SVGFEConvolveMatrixElement = 12640,
  SVGFEDiffuseLightingElement = 12667,
  SVGFEDisplacementMapElement = 12695,
  SVGFEDistantLightElement = 12723,
  SVGFEDropShadowElement = 12748,
  SVGFEFloodElement = 12771,
  SVGFEFuncAElement = 12789,
  SVGFEFuncBElement = 12807,
  SVGFEFuncGElement = 12825,
  SVGFEFuncRElement = 12843,
  SVGFEGaussianBlurElement = 12861,
  SVGFEImageElement = 12886,
  SVGFEMergeElement = 12904,
  SVGFEMergeNodeElement = 12922,
  SVGFEMorphologyElement = 12944,
  SVGFEOffsetElement = 12967,
  SVGFEPointLightElement = 12986,
  SVGFESpecularLightingElement = 13009,
  SVGFESpotLightElement = 13038,
  SVGFETileElement = 13060,
  SVGFETurbulenceElement = 13077,
  SVGFilterElement = 13100,
  SVGForeignObjectElement = 13117,
  SVGGElement = 13141,
  SVGGeometryElement = 13153,
  SVGGradientElement = 13172,
  SVGGraphicsElement = 13191,
  SVGImageElement = 13210,
  SVGLength = 13226,
  SVGLengthList = 13236,
  SVGLineElement = 13250,
  SVGLinearGradientElement = 13265,
  SVGMPathElement = 13290,
  SVGMarkerElement = 13306,
  SVGMaskElement = 13323,
  SVGMatrix = 13338,
  SVGMetadataElement = 13348,
  SVGNumber = 13367,
  SVGNumberList = 13377,
  SVGPathElement = 13391,
  SVGPathSegment = 13406,
  SVGPatternElement = 13421,
  SVGPoint = 13439,
  SVGPointList = 13448,
  SVGPolygonElement = 13461,
  SVGPolylineElement = 13479,
  SVGPreserveAspectRatio = 13498,
  SVGRadialGradientElement = 13521,
  SVGRect = 13546,
  SVGRectElement = 13554,
  SVGSVGElement = 13569,
  SVGScriptElement = 13583,
  SVGSetElement = 13600,
  SVGStopElement = 13614,
  SVGStringList = 13629,
  SVGStyleElement = 13643,
  SVGSwitchElement = 13659,
  SVGSymbolElement = 13676,
  SVGTSpanElement = 13693,
  SVGTextContentElement = 13709,
  SVGTextElement = 13731,
  SVGTextPathElement = 13746,
  SVGTextPositioningElement = 13765,
  SVGTitleElement = 13791,
  SVGTransform = 13807,
  SVGTransformList = 13820,
  SVGUnitTypes = 13837,
  SVGUseElement = 13850,
  SVGViewElement = 13864,
  Sanitizer = 13879,
  Scheduler = 13889,
  Screen = 13899,
  ScreenLuminance = 13906,
  ScreenOrientation = 13922,
  ScriptProcessorNode = 13940,
  ScrollAreaEvent = 13960,
  SecurityPolicyViolationEvent = 13976,
  Selection = 14005,
  ServiceWorker = 14015,
  ServiceWorkerContainer = 14029,
  ServiceWorkerGlobalScope = 14052,
  ServiceWorkerRegistration = 14077,
  SessionStoreFormData = 14103,
  SessionStoreScrollData = 14124,
  SessionStoreUtils = 14147,
  ShadowRealmGlobalScope = 14165,
  ShadowRoot = 14188,
  SharedWorker = 14199,
  SharedWorkerGlobalScope = 14212,
  SimpleGestureEvent = 14236,
  SourceBuffer = 14255,
  SourceBufferList = 14268,
  SpeechGrammar = 14285,
  SpeechGrammarList = 14299,
  SpeechRecognition = 14317,
  SpeechRecognitionAlternative = 14335,
  SpeechRecognitionError = 14364,
  SpeechRecognitionEvent = 14387,
  SpeechRecognitionResult = 14410,
  SpeechRecognitionResultList = 14434,
  SpeechSynthesis = 14462,
  SpeechSynthesisErrorEvent = 14478,
  SpeechSynthesisEvent = 14504,
  SpeechSynthesisUtterance = 14525,
  SpeechSynthesisVoice = 14550,
  StaticRange = 14571,
  StereoPannerNode = 14583,
  Storage = 14600,
  StorageEvent = 14608,
  StorageManager = 14621,
  StreamFilter = 14636,
  StreamFilterDataEvent = 14649,
  StructuredCloneHolder = 14671,
  StructuredCloneTester = 14693,
  StylePropertyMap = 14715,
  StylePropertyMapReadOnly = 14732,
  StylePropertyMapReadOnly_Iterator = 14757,
  StyleSheet = 14791,
  StyleSheetApplicableStateChangeEvent = 14802,
  StyleSheetList = 14839,
  StyleSheetRemovedEvent = 14854,
  SubmitEvent = 14877,
  SubtleCrypto = 14889,
  SyncMessageSender = 14902,
  SyncReadFile = 14920,
  TCPServerSocket = 14933,
  TCPServerSocketEvent = 14949,
  TCPSocket = 14970,
  TCPSocketErrorEvent = 14980,
  TCPSocketEvent = 15000,
  TaskController = 15015,
  TaskPriorityChangeEvent = 15030,
  TaskSignal = 15054,
  Tensor = 15065,
  TestUtils = 15072,
  TestingDeprecatedInterface = 15082,
  Text = 15109,
  TextClause = 15114,
  TextDecoder = 15125,
  TextDecoderStream = 15137,
  TextEncoder = 15155,
  TextEncoderStream = 15167,
  TextEvent = 15185,
  TextMetrics = 15195,
  TextTrack = 15207,
  TextTrackCue = 15217,
  TextTrackCueList = 15230,
  TextTrackList = 15247,
  TimeEvent = 15261,
  TimeRanges = 15271,
  ToggleEvent = 15282,
  Touch = 15294,
  TouchEvent = 15300,
  TouchList = 15311,
  TrackEvent = 15321,
  TransformStream = 15332,
  TransformStreamDefaultController = 15348,
  TransitionEvent = 15381,
  TreeColumn = 15397,
  TreeColumns = 15408,
  TreeContentView = 15420,
  TreeWalker = 15436,
  TrustedHTML = 15447,
  TrustedScript = 15459,
  TrustedScriptURL = 15473,
  TrustedTypePolicy = 15490,
  TrustedTypePolicyFactory = 15508,
  UDPMessageEvent = 15533,
  UDPSocket = 15549,
  UIEvent = 15559,
  URL = 15567,
  URLPattern = 15571,
  URLSearchParams = 15582,
  URLSearchParams_Iterator = 15598,
  UniFFIPointer = 15623,
  UniFFIScaffolding = 15637,
  UserActivation = 15655,
  UserInteraction = 15670,
  UserProximityEvent = 15686,
  VRDisplay = 15705,
  VRDisplayCapabilities = 15715,
  VRDisplayEvent = 15737,
  VREyeParameters = 15752,
  VRFieldOfView = 15768,
  VRFrameData = 15782,
  VRMockController = 15794,
  VRMockDisplay = 15811,
  VRPose = 15825,
  VRServiceTest = 15832,
  VRStageParameters = 15846,
  VTTCue = 15864,
  VTTRegion = 15871,
  ValidityState = 15881,
  VideoColorSpace = 15895,
  VideoDecoder = 15911,
  VideoEncoder = 15924,
  VideoFrame = 15937,
  VideoPlaybackQuality = 15948,
  VideoTrack = 15969,
  VideoTrackList = 15980,
  ViewTransition = 15995,
  ViewTransitionTypeSet = 16010,
  VisualViewport = 16032,
  WEBGL_color_buffer_float = 16047,
  WEBGL_compressed_texture_astc = 16072,
  WEBGL_compressed_texture_etc = 16102,
  WEBGL_compressed_texture_etc1 = 16131,
  WEBGL_compressed_texture_pvrtc = 16161,
  WEBGL_compressed_texture_s3tc = 16192,
  WEBGL_compressed_texture_s3tc_srgb = 16222,
  WEBGL_debug_renderer_info = 16257,
  WEBGL_debug_shaders = 16283,
  WEBGL_depth_texture = 16303,
  WEBGL_draw_buffers = 16323,
  WEBGL_explicit_present = 16342,
  WEBGL_lose_context = 16365,
  WEBGL_provoking_vertex = 16384,
  WGSLLanguageFeatures = 16407,
  WakeLock = 16428,
  WakeLockSentinel = 16437,
  WaveShaperNode = 16454,
  WebExtensionContentScript = 16469,
  WebExtensionPolicy = 16495,
  WebGL2RenderingContext = 16514,
  WebGLActiveInfo = 16537,
  WebGLBuffer = 16553,
  WebGLContextEvent = 16565,
  WebGLFramebuffer = 16583,
  WebGLProgram = 16600,
  WebGLQuery = 16613,
  WebGLRenderbuffer = 16624,
  WebGLRenderingContext = 16642,
  WebGLSampler = 16664,
  WebGLShader = 16677,
  WebGLShaderPrecisionFormat = 16689,
  WebGLSync = 16716,
  WebGLTexture = 16726,
  WebGLTransformFeedback = 16739,
  WebGLUniformLocation = 16762,
  WebGLVertexArrayObject = 16783,
  WebKitCSSMatrix = 16806,
  WebSocket = 16822,
  WebTransport = 16832,
  WebTransportBidirectionalStream = 16845,
  WebTransportDatagramDuplexStream = 16877,
  WebTransportError = 16910,
  WebTransportReceiveStream = 16928,
  WebTransportSendStream = 16954,
  WheelEvent = 16977,
  Window = 16988,
  WindowClient = 16995,
  WindowContext = 17008,
  WindowGlobalChild = 17022,
  WindowGlobalParent = 17040,
  WindowRoot = 17059,
  Worker = 17070,
  WorkerDebuggerGlobalScope = 17077,
  WorkerGlobalScope = 17103,
  WorkerLocation = 17121,
  WorkerNavigator = 17136,
  WorkerTestUtils = 17152,
  Worklet = 17168,
  WorkletGlobalScope = 17176,
  WritableStream = 17195,
  WritableStreamDefaultController = 17210,
  WritableStreamDefaultWriter = 17242,
  XMLDocument = 17270,
  XMLHttpRequest = 17282,
  XMLHttpRequestEventTarget = 17297,
  XMLHttpRequestUpload = 17323,
  XMLSerializer = 17344,
  XPathEvaluator = 17358,
  XPathExpression = 17373,
  XPathResult = 17389,
  XRBoundedReferenceSpace = 17401,
  XRFrame = 17425,
  XRInputSource = 17433,
  XRInputSourceArray = 17447,
  XRInputSourceEvent = 17466,
  XRInputSourcesChangeEvent = 17485,
  XRPose = 17511,
  XRReferenceSpace = 17518,
  XRReferenceSpaceEvent = 17535,
  XRRenderState = 17557,
  XRRigidTransform = 17571,
  XRSession = 17588,
  XRSessionEvent = 17598,
  XRSpace = 17613,
  XRSystem = 17621,
  XRView = 17630,
  XRViewerPose = 17637,
  XRViewport = 17650,
  XRWebGLLayer = 17661,
  XSLTProcessor = 17674,
  XULCommandEvent = 17688,
  XULElement = 17704,
  XULFrameElement = 17715,
  XULMenuElement = 17731,
  XULPopupElement = 17746,
  XULResizerElement = 17762,
  XULTextElement = 17780,
  XULTreeElement = 17795,
  console = 17810,
  webkitSpeechGrammar = 17818,
  webkitSpeechGrammarList = 17838,
  webkitSpeechRecognition = 17862,
  webkitURL = 17886,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
