//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/base/mozIThirdPartyUtil.idl
//


/// `interface mozIThirdPartyUtil : nsISupports`
///

/// ```text
/// /**
///  * Utility functions for determining whether a given URI, channel, or window
///  * hierarchy is third party with respect to a known URI.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct mozIThirdPartyUtil {
    vtable: &'static mozIThirdPartyUtilVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for mozIThirdPartyUtil.
unsafe impl XpCom for mozIThirdPartyUtil {
    const IID: nsIID = nsID(0xfd82700e, 0xffb4, 0x4932,
        [0xb7, 0xd6, 0x08, 0xf0, 0xb5, 0x69, 0x7d, 0xda]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for mozIThirdPartyUtil {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from mozIThirdPartyUtil.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait mozIThirdPartyUtilCoerce {
    /// Cheaply cast a value of this type from a `mozIThirdPartyUtil`.
    fn coerce_from(v: &mozIThirdPartyUtil) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl mozIThirdPartyUtilCoerce for mozIThirdPartyUtil {
    #[inline]
    fn coerce_from(v: &mozIThirdPartyUtil) -> &Self {
        v
    }
}

impl mozIThirdPartyUtil {
    /// Cast this `mozIThirdPartyUtil` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: mozIThirdPartyUtilCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for mozIThirdPartyUtil {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> mozIThirdPartyUtilCoerce for T {
    #[inline]
    fn coerce_from(v: &mozIThirdPartyUtil) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every mozIThirdPartyUtil
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct mozIThirdPartyUtilVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* boolean isThirdPartyURI (in nsIURI aFirstURI, in nsIURI aSecondURI); */
    pub IsThirdPartyURI: unsafe extern "system" fn (this: *const mozIThirdPartyUtil, aFirstURI: *const nsIURI, aSecondURI: *const nsIURI, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean isThirdPartyWindow (in mozIDOMWindowProxy aWindow, [optional] in nsIURI aURI); */
    pub IsThirdPartyWindow: unsafe extern "system" fn (this: *const mozIThirdPartyUtil, aWindow: *const mozIDOMWindowProxy, aURI: *const nsIURI, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean isThirdPartyChannel (in nsIChannel aChannel, [optional] in nsIURI aURI); */
    pub IsThirdPartyChannel: unsafe extern "system" fn (this: *const mozIThirdPartyUtil, aChannel: *const nsIChannel, aURI: *const nsIURI, _retval: *mut bool) -> ::nserror::nsresult,

    /* AUTF8String getBaseDomain (in nsIURI aHostURI); */
    pub GetBaseDomain: unsafe extern "system" fn (this: *const mozIThirdPartyUtil, aHostURI: *const nsIURI, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* nsIURI getURIFromWindow (in mozIDOMWindowProxy aWindow); */
    pub GetURIFromWindow: unsafe extern "system" fn (this: *const mozIThirdPartyUtil, aWindow: *const mozIDOMWindowProxy, _retval: *mut*const nsIURI) -> ::nserror::nsresult,

    /* nsIPrincipal getPrincipalFromWindow (in mozIDOMWindowProxy aWindow); */
    pub GetPrincipalFromWindow: unsafe extern "system" fn (this: *const mozIThirdPartyUtil, aWindow: *const mozIDOMWindowProxy, _retval: *mut*const nsIPrincipal) -> ::nserror::nsresult,

    /* [noscript] mozIDOMWindowProxy getTopWindowForChannel (in nsIChannel aChannel, [optional] in nsIURI aURIBeingLoaded); */
    pub GetTopWindowForChannel: unsafe extern "system" fn (this: *const mozIThirdPartyUtil, aChannel: *const nsIChannel, aURIBeingLoaded: *const nsIURI, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult,

    /* [noscript,notxpcom] ThirdPartyAnalysisResult analyzeChannel (in nsIChannel aChannel, in boolean aNotify, [optional] in nsIURI aURI, [optional] in RequireThirdPartyCheck aRequireThirdPartyCheck, out uint32_t aRejectedReason); */
    /// Unable to generate binding because `Rust only supports [ref] / [ptr] native types`
    pub AnalyzeChannel: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl mozIThirdPartyUtil {

    /// ```text
    /// /**
    ///    * isThirdPartyURI
    ///    *
    ///    * Determine whether two URIs are third party with respect to each other.
    ///    * This is determined by computing the base domain for both URIs. If they can
    ///    * be determined, and the base domains match, the request is defined as first
    ///    * party. If it cannot be determined because one or both URIs do not have a
    ///    * base domain (for instance, in the case of IP addresses, host aliases such
        ///    * as 'localhost', or a file:// URI), an exact string comparison on host is
    ///    * performed.
    ///    *
    ///    * For example, the URI "http://mail.google.com/" is not third party with
    ///    * respect to "http://images.google.com/", but "http://mail.yahoo.com/" and
    ///    * "http://192.168.1.1/" are.
    ///    *
    ///    * @return true if aFirstURI is third party with respect to aSecondURI.
    ///    *
    ///    * @throws if either URI is null, has a malformed host, or has an empty host
    ///    *         and is not a file:// URI.
    ///    */
    /// ```
    ///

    /// `boolean isThirdPartyURI (in nsIURI aFirstURI, in nsIURI aSecondURI);`
    #[inline]
    pub unsafe fn IsThirdPartyURI(&self, aFirstURI: *const nsIURI, aSecondURI: *const nsIURI, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).IsThirdPartyURI)(self, aFirstURI, aSecondURI, _retval)
    }


    /// ```text
    /// /**
    ///    * isThirdPartyWindow
    ///    *
    ///    * Determine whether the given window hierarchy is third party. This is done
    ///    * as follows:
    ///    *
    ///    * 1) Obtain the URI of the principal associated with 'aWindow'. Call this the
///    *    'bottom URI'.
///    * 2) If 'aURI' is provided, determine if it is third party with respect to
///    *    the bottom URI. If so, return.
///    * 3) Find the same-type parent window, if there is one, and its URI.
///    *    Determine whether it is third party with respect to the bottom URI. If
///    *    so, return.
///    *
///    * Therefore, each level in the window hierarchy is tested. (This means that
///    * nested iframes with different base domains, even though the bottommost and
///    * topmost URIs might be equal, will be considered third party.)
///    *
///    * @param aWindow
///    *        The bottommost window in the hierarchy.
///    * @param aURI
///    *        A URI to test against. If null, the URI of the principal
///    *        associated with 'aWindow' will be used.
///    *
///    * For example, if 'aURI' is "http://mail.google.com/", 'aWindow' has a URI
///    * of "http://google.com/", and its parent is the topmost content window with
///    * a URI of "http://mozilla.com", the result will be true.
///    *
///    * @return true if 'aURI' is third party with respect to any of the URIs
///    *         associated with aWindow and its same-type parents.
///    *
///    * @throws if aWindow is null; the same-type parent of any window in the
///    *         hierarchy cannot be determined; or the URI associated with any
///    *         window in the hierarchy is null, has a malformed host, or has an
///    *         empty host and is not a file:// URI.
///    *
///    * @see isThirdPartyURI
///    */
/// ```
///

/// `boolean isThirdPartyWindow (in mozIDOMWindowProxy aWindow, [optional] in nsIURI aURI);`
#[inline]
pub unsafe fn IsThirdPartyWindow(&self, aWindow: *const mozIDOMWindowProxy, aURI: *const nsIURI, _retval: *mut bool) -> ::nserror::nsresult {
((*self.vtable).IsThirdPartyWindow)(self, aWindow, aURI, _retval)
}


/// ```text
/// /**
///    * isThirdPartyChannel
///    *
///    * Determine whether the given channel and its content window hierarchy is
///    * third party. This is done as follows:
///    *
///    * 1) If 'aChannel' is an nsIHttpChannel and has the
///    *    'forceAllowThirdPartyCookie' property set, then:
///    *    a) If 'aURI' is null, return false.
///    *    b) Otherwise, find the URI of the channel, determine whether it is
///    *       foreign with respect to 'aURI', and return.
///    * 2) Find the URI of the channel and determine whether it is third party with
///    *    respect to the URI of the channel. If so, return.
///    * 3) Obtain the bottommost nsIDOMWindow, and its same-type parent if it
///    *    exists, from the channel's notification callbacks. Then:
///    *    a) If the parent is the same as the bottommost window, and the channel
///    *       has the LOAD_DOCUMENT_URI flag set, return false. This represents the
///    *       case where a toplevel load is occurring and the window's URI has not
///    *       yet been updated. (We have already checked that 'aURI' is not foreign
///    *       with respect to the channel URI.)
///    *    b) Otherwise, return the result of isThirdPartyWindow with arguments
///    *       of the channel's bottommost window and the channel URI, respectively.
///    *
///    * Therefore, both the channel's URI and each level in the window hierarchy
///    * associated with the channel is tested.
///    *
///    * @param aChannel
///    *        The channel associated with the load.
///    * @param aURI
///    *        A URI to test against. If null, the URI of the channel will be used.
///    *
///    * For example, if 'aURI' is "http://mail.google.com/", 'aChannel' has a URI
///    * of "http://google.com/", and its parent is the topmost content window with
///    * a URI of "http://mozilla.com", the result will be true.
///    *
///    * @return true if aURI is third party with respect to the channel URI or any
///    *         of the URIs associated with the same-type window hierarchy of the
///    *         channel.
///    *
///    * @throws if 'aChannel' is null; the channel has no notification callbacks or
///    *         an associated window; or isThirdPartyWindow throws.
///    *
///    * @see isThirdPartyWindow
///    */
/// ```
///

/// `boolean isThirdPartyChannel (in nsIChannel aChannel, [optional] in nsIURI aURI);`
#[inline]
pub unsafe fn IsThirdPartyChannel(&self, aChannel: *const nsIChannel, aURI: *const nsIURI, _retval: *mut bool) -> ::nserror::nsresult {
((*self.vtable).IsThirdPartyChannel)(self, aChannel, aURI, _retval)
}


/// ```text
/// /**
///    * getBaseDomain
///    *
///    * Get the base domain for aHostURI; e.g. for "www.bbc.co.uk", this would be
///    * "bbc.co.uk". Only properly-formed URI's are tolerated, though a trailing
///    * dot may be present. If aHostURI is an IP address, an alias such as
///    * 'localhost', an eTLD such as 'co.uk', or the empty string, aBaseDomain will
///    * be the exact host. The result of this function should only be used in exact
///    * string comparisons, since substring comparisons will not be valid for the
///    * special cases elided above.
///    *
///    * @param aHostURI
///    *        The URI to analyze.
///    *
///    * @return the base domain.
///    */
/// ```
///

/// `AUTF8String getBaseDomain (in nsIURI aHostURI);`
#[inline]
pub unsafe fn GetBaseDomain(&self, aHostURI: *const nsIURI, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
((*self.vtable).GetBaseDomain)(self, aHostURI, _retval)
}


/// ```text
/// /**
///    * getURIFromWindow
///    *
///    * Returns the URI associated with the script object principal for the
///    * window.
///    */
/// ```
///

/// `nsIURI getURIFromWindow (in mozIDOMWindowProxy aWindow);`
#[inline]
pub unsafe fn GetURIFromWindow(&self, aWindow: *const mozIDOMWindowProxy, _retval: *mut*const nsIURI) -> ::nserror::nsresult {
((*self.vtable).GetURIFromWindow)(self, aWindow, _retval)
}


/// ```text
/// /**
///    * getPrincipalFromWindow
///    *
///    * Returns the script object principal for the window.
///    */
/// ```
///

/// `nsIPrincipal getPrincipalFromWindow (in mozIDOMWindowProxy aWindow);`
#[inline]
pub unsafe fn GetPrincipalFromWindow(&self, aWindow: *const mozIDOMWindowProxy, _retval: *mut*const nsIPrincipal) -> ::nserror::nsresult {
((*self.vtable).GetPrincipalFromWindow)(self, aWindow, _retval)
}


/// ```text
/// /**
///    * getTopWindowForChannel
///    *
///    * Returns the top-level window associated with the given channel.
///    */
/// ```
///

/// `[noscript] mozIDOMWindowProxy getTopWindowForChannel (in nsIChannel aChannel, [optional] in nsIURI aURIBeingLoaded);`
#[inline]
pub unsafe fn GetTopWindowForChannel(&self, aChannel: *const nsIChannel, aURIBeingLoaded: *const nsIURI, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult {
((*self.vtable).GetTopWindowForChannel)(self, aChannel, aURIBeingLoaded, _retval)
}



/// `[noscript,notxpcom] ThirdPartyAnalysisResult analyzeChannel (in nsIChannel aChannel, in boolean aNotify, [optional] in nsIURI aURI, [optional] in RequireThirdPartyCheck aRequireThirdPartyCheck, out uint32_t aRejectedReason);`
const _AnalyzeChannel: () = ();

}


