//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/accessible/interfaces/nsIAccessibleEvent.idl
//


/// `interface nsIAccessibleEvent : nsISupports`
///

/// ```text
/// /**
///  * An interface for accessibility events listened to
///  * by in-process accessibility clients, which can be used
///  * to find out how to get accessibility and DOM interfaces for
///  * the event and its target. To listen to in-process accessibility invents,
///  * make your object an nsIObserver, and listen for accessible-event by
///  * using code something like this:
///  *   nsCOMPtr<nsIObserverService> observerService =
///  *     do_GetService("@mozilla.org/observer-service;1", &rv);
///  *   if (NS_SUCCEEDED(rv))
///  *     rv = observerService->AddObserver(this, "accessible-event", PR_TRUE);
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIAccessibleEvent {
    vtable: &'static nsIAccessibleEventVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIAccessibleEvent.
unsafe impl XpCom for nsIAccessibleEvent {
    const IID: nsIID = nsID(0x20c69a40, 0x6c2c, 0x42a3,
        [0xa5, 0x78, 0x6f, 0x44, 0x73, 0xaa, 0xb9, 0xdd]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIAccessibleEvent {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIAccessibleEvent.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIAccessibleEventCoerce {
    /// Cheaply cast a value of this type from a `nsIAccessibleEvent`.
    fn coerce_from(v: &nsIAccessibleEvent) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIAccessibleEventCoerce for nsIAccessibleEvent {
    #[inline]
    fn coerce_from(v: &nsIAccessibleEvent) -> &Self {
        v
    }
}

impl nsIAccessibleEvent {
    /// Cast this `nsIAccessibleEvent` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIAccessibleEventCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIAccessibleEvent {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIAccessibleEventCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIAccessibleEvent) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIAccessibleEvent
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIAccessibleEventVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute unsigned long eventType; */
    pub GetEventType: unsafe extern "system" fn (this: *const nsIAccessibleEvent, aEventType: *mut u32) -> ::nserror::nsresult,

    /* readonly attribute nsIAccessible accessible; */
    pub GetAccessible: unsafe extern "system" fn (this: *const nsIAccessibleEvent, aAccessible: *mut*const nsIAccessible) -> ::nserror::nsresult,

    /* readonly attribute nsIAccessibleDocument accessibleDocument; */
    pub GetAccessibleDocument: unsafe extern "system" fn (this: *const nsIAccessibleEvent, aAccessibleDocument: *mut*const nsIAccessibleDocument) -> ::nserror::nsresult,

    /* readonly attribute Node DOMNode; */
    pub GetDOMNode: unsafe extern "system" fn (this: *const nsIAccessibleEvent, aDOMNode: *mut *const libc::c_void) -> ::nserror::nsresult,

    /* readonly attribute boolean isFromUserInput; */
    pub GetIsFromUserInput: unsafe extern "system" fn (this: *const nsIAccessibleEvent, aIsFromUserInput: *mut bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIAccessibleEvent {
    /// ```text
    /// /**
    ///    * An object has been created.
    ///    */
    /// ```
    ///

    pub const EVENT_SHOW: u32 = 1;

    /// ```text
    /// /**
    ///    * An object has been destroyed.
    ///    */
    /// ```
    ///

    pub const EVENT_HIDE: u32 = 2;

    /// ```text
    /// /**
    ///    * An object's children have changed
    ///    */
    /// ```
    ///

    pub const EVENT_REORDER: u32 = 3;

    /// ```text
    /// /**
    ///    * An object has received the keyboard focus.
    ///    */
    /// ```
    ///

    pub const EVENT_FOCUS: u32 = 4;

    /// ```text
    /// /**
    ///    * An object's state has changed.
    ///    */
    /// ```
    ///

    pub const EVENT_STATE_CHANGE: u32 = 5;

    /// ```text
    /// /**
    ///    * An object's Name property has changed.
    ///    */
    /// ```
    ///

    pub const EVENT_NAME_CHANGE: u32 = 6;

    /// ```text
    /// /**
    ///    * An object's Description property has changed.
    ///    */
    /// ```
    ///

    pub const EVENT_DESCRIPTION_CHANGE: u32 = 7;

    /// ```text
    /// /**
    ///    * An object's numeric Value has changed.
    ///    */
    /// ```
    ///

    pub const EVENT_VALUE_CHANGE: u32 = 8;

    /// ```text
    /// /**
    ///    * The selection within a container object has changed.
    ///    */
    /// ```
    ///

    pub const EVENT_SELECTION: u32 = 9;

    /// ```text
    /// /**
    ///    * An item within a container object has been added to the selection.
    ///    */
    /// ```
    ///

    pub const EVENT_SELECTION_ADD: u32 = 10;

    /// ```text
    /// /**
    ///    * An item within a container object has been removed from the selection.
    ///    */
    /// ```
    ///

    pub const EVENT_SELECTION_REMOVE: u32 = 11;

    /// ```text
    /// /**
    ///    * Numerous selection changes have occurred within a container object.
    ///    */
    /// ```
    ///

    pub const EVENT_SELECTION_WITHIN: u32 = 12;

    /// ```text
    /// /**
    ///    * An alert has been generated. Server applications send this event when a
    ///    * user needs to know that a user interface element has changed.
    ///    */
    /// ```
    ///

    pub const EVENT_ALERT: u32 = 13;

    /// ```text
    /// /**
    ///    * A menu item on the menu bar has been selected.
    ///    */
    /// ```
    ///

    pub const EVENT_MENU_START: u32 = 14;

    /// ```text
    /// /**
    ///    * A menu from the menu bar has been closed.
    ///    */
    /// ```
    ///

    pub const EVENT_MENU_END: u32 = 15;

    /// ```text
    /// /**
    ///    * A pop-up menu has been displayed.
    ///    */
    /// ```
    ///

    pub const EVENT_MENUPOPUP_START: u32 = 16;

    /// ```text
    /// /**
    ///    * A pop-up menu has been closed.
    ///    */
    /// ```
    ///

    pub const EVENT_MENUPOPUP_END: u32 = 17;

    /// ```text
    /// /**
    ///    * An application is about to enter drag-and-drop mode
    ///    */
    /// ```
    ///

    pub const EVENT_DRAGDROP_START: u32 = 18;

    /// ```text
    /// /**
    ///    * Scrolling has started on a scroll bar
    ///    */
    /// ```
    ///

    pub const EVENT_SCROLLING_START: u32 = 19;

    /// ```text
    /// /**
    ///    * Scrolling has ended on a scroll bar
    ///    */
    /// ```
    ///

    pub const EVENT_SCROLLING_END: u32 = 20;

    /// ```text
    /// /**
    ///    * The loading of the document has completed.
    ///    */
    /// ```
    ///

    pub const EVENT_DOCUMENT_LOAD_COMPLETE: u32 = 21;

    /// ```text
    /// /**
    ///    * The document contents are being reloaded.
    ///    */
    /// ```
    ///

    pub const EVENT_DOCUMENT_RELOAD: u32 = 22;

    /// ```text
    /// /**
    ///    * The loading of the document was interrupted.
    ///    */
    /// ```
    ///

    pub const EVENT_DOCUMENT_LOAD_STOPPED: u32 = 23;

    /// ```text
    /// /**
    ///    * A text object's attributes changed.
    ///    * Also see EVENT_OBJECT_ATTRIBUTE_CHANGED.
    ///    */
    /// ```
    ///

    pub const EVENT_TEXT_ATTRIBUTE_CHANGED: u32 = 24;

    /// ```text
    /// /**
    ///    * The caret has moved to a new position.
    ///    */
    /// ```
    ///

    pub const EVENT_TEXT_CARET_MOVED: u32 = 25;

    /// ```text
    /// /**
    ///    * Text was inserted.
    ///    */
    /// ```
    ///

    pub const EVENT_TEXT_INSERTED: u32 = 26;

    /// ```text
    /// /**
    ///    * Text was removed.
    ///    */
    /// ```
    ///

    pub const EVENT_TEXT_REMOVED: u32 = 27;

    /// ```text
    /// /**
    ///    * The text selection changed.
    ///    */
    /// ```
    ///

    pub const EVENT_TEXT_SELECTION_CHANGED: u32 = 28;


    pub const EVENT_WINDOW_ACTIVATE: u32 = 29;


    pub const EVENT_WINDOW_DEACTIVATE: u32 = 30;


    pub const EVENT_WINDOW_MAXIMIZE: u32 = 31;


    pub const EVENT_WINDOW_MINIMIZE: u32 = 32;


    pub const EVENT_WINDOW_RESTORE: u32 = 33;

    /// ```text
    /// /**
    ///    * An object's attributes changed. Also see EVENT_TEXT_ATTRIBUTE_CHANGED.
    ///    */
    /// ```
    ///

    pub const EVENT_OBJECT_ATTRIBUTE_CHANGED: u32 = 34;

    /// ```text
    /// /**
    ///    * An object's text Value has changed.
    ///    */
    /// ```
    ///

    pub const EVENT_TEXT_VALUE_CHANGE: u32 = 35;

    /// ```text
    /// /**
    ///    * An accessible's viewport is scrolling.
    ///    */
    /// ```
    ///

    pub const EVENT_SCROLLING: u32 = 36;

    /// ```text
    /// /**
    ///    * An accessible is making an explicit announcement.
    ///    */
    /// ```
    ///

    pub const EVENT_ANNOUNCEMENT: u32 = 37;

    /// ```text
    /// /**
    ///    * A live region has been introduced. Mac only.
    ///    */
    /// ```
    ///

    pub const EVENT_LIVE_REGION_ADDED: u32 = 38;

    /// ```text
    /// /**
    ///    * A live region has been removed (aria-live attribute changed). Mac Only.
    ///    */
    /// ```
    ///

    pub const EVENT_LIVE_REGION_REMOVED: u32 = 39;

    /// ```text
    /// /**
    ///    * A reorder event that has been coalesced into a mutation
    ///    * of an ancestor's subtree.
    ///    */
    /// ```
    ///

    pub const EVENT_INNER_REORDER: u32 = 40;

    /// ```text
    /// /**
    ///    * A live region's contents has changed. Mac Only.
    ///    */
    /// ```
    ///

    pub const EVENT_LIVE_REGION_CHANGED: u32 = 41;

    /// ```text
    /// /**
    ///    * A value of aria-errormessage was changed.
    ///    */
    /// ```
    ///

    pub const EVENT_ERRORMESSAGE_CHANGED: u32 = 42;

    /// ```text
    /// /**
    ///    * Help make sure event map does not get out-of-line.
    ///    */
    /// ```
    ///

    pub const EVENT_LAST_ENTRY: u32 = 43;

    /// ```text
    /// /**
    ///    * The type of event, based on the enumerated event values
    ///    * defined in this interface.
    ///    */
    /// ```
    ///

    /// `readonly attribute unsigned long eventType;`
    #[inline]
    pub unsafe fn GetEventType(&self, aEventType: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).GetEventType)(self, aEventType)
    }


    /// ```text
    /// /**
    ///    * The nsIAccessible associated with the event.
    ///    * May return null if no accessible is available
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIAccessible accessible;`
    #[inline]
    pub unsafe fn GetAccessible(&self, aAccessible: *mut*const nsIAccessible) -> ::nserror::nsresult {
        ((*self.vtable).GetAccessible)(self, aAccessible)
    }


    /// ```text
    /// /**
    ///    * The nsIAccessibleDocument that the event target nsIAccessible
    ///    * resides in. This can be used to get the DOM window,
    ///    * the DOM document and the window handler, among other things.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIAccessibleDocument accessibleDocument;`
    #[inline]
    pub unsafe fn GetAccessibleDocument(&self, aAccessibleDocument: *mut*const nsIAccessibleDocument) -> ::nserror::nsresult {
        ((*self.vtable).GetAccessibleDocument)(self, aAccessibleDocument)
    }


    /// ```text
    /// /**
    ///    * The Node associated with the event
    ///    * May return null if accessible for event has been shut down
    ///    */
    /// ```
    ///

    /// `readonly attribute Node DOMNode;`
    #[inline]
    pub unsafe fn GetDOMNode(&self, aDOMNode: *mut *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetDOMNode)(self, aDOMNode)
    }


    /// ```text
    /// /**
    ///    * Returns true if the event was caused by explicit user input,
    ///    * as opposed to purely originating from a timer or mouse movement
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean isFromUserInput;`
    #[inline]
    pub unsafe fn GetIsFromUserInput(&self, aIsFromUserInput: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsFromUserInput)(self, aIsFromUserInput)
    }


}


