//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/accessible/interfaces/nsIAccessiblePivot.idl
//


/// `typedef int16_t  PivotMoveReason;`
///


pub type PivotMoveReason = i16;


/// `interface nsIAccessiblePivot : nsISupports`
///

/// ```text
/// /**
///  * The pivot interface encapsulates a reference to a single place in an accessible
///  * subtree. The pivot is a point or a range in the accessible tree. This interface
///  * provides traversal methods to move the pivot to next/prev state that complies
///  * to a given rule.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIAccessiblePivot {
    vtable: &'static nsIAccessiblePivotVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIAccessiblePivot.
unsafe impl XpCom for nsIAccessiblePivot {
    const IID: nsIID = nsID(0x81fe5144, 0x059b, 0x42db,
        [0xbd, 0x3a, 0xf6, 0xce, 0x31, 0x58, 0xd5, 0xe9]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIAccessiblePivot {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIAccessiblePivot.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIAccessiblePivotCoerce {
    /// Cheaply cast a value of this type from a `nsIAccessiblePivot`.
    fn coerce_from(v: &nsIAccessiblePivot) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIAccessiblePivotCoerce for nsIAccessiblePivot {
    #[inline]
    fn coerce_from(v: &nsIAccessiblePivot) -> &Self {
        v
    }
}

impl nsIAccessiblePivot {
    /// Cast this `nsIAccessiblePivot` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIAccessiblePivotCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIAccessiblePivot {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIAccessiblePivotCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIAccessiblePivot) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIAccessiblePivot
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIAccessiblePivotVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* [optional_argc] nsIAccessible next (in nsIAccessible aAnchor, in nsIAccessibleTraversalRule aRule, [optional] in boolean aIncludeStart); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub Next: *const ::libc::c_void,

    /* [optional_argc] nsIAccessible prev (in nsIAccessible aAnchor, in nsIAccessibleTraversalRule aRule, [optional] in boolean aIncludeStart); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub Prev: *const ::libc::c_void,

    /* nsIAccessible first (in nsIAccessibleTraversalRule aRule); */
    pub First: unsafe extern "system" fn (this: *const nsIAccessiblePivot, aRule: *const nsIAccessibleTraversalRule, _retval: *mut*const nsIAccessible) -> ::nserror::nsresult,

    /* nsIAccessible last (in nsIAccessibleTraversalRule aRule); */
    pub Last: unsafe extern "system" fn (this: *const nsIAccessiblePivot, aRule: *const nsIAccessibleTraversalRule, _retval: *mut*const nsIAccessible) -> ::nserror::nsresult,

    /* nsIAccessible atPoint (in long aX, in long aY, in nsIAccessibleTraversalRule aRule); */
    pub AtPoint: unsafe extern "system" fn (this: *const nsIAccessiblePivot, aX: i32, aY: i32, aRule: *const nsIAccessibleTraversalRule, _retval: *mut*const nsIAccessible) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIAccessiblePivot {

    /// ```text
    /// /**
    ///    * Move pivot to next object, from current position or given anchor,
    ///    * complying to given traversal rule.
    ///    *
    ///    * @param aRule            [in] traversal rule to use.
    ///    * @param aAnchor          [in] accessible to start search from, if not provided,
    ///    *                           current position will be used.
    ///    * @param aIncludeStart    [in] include anchor accessible in search.
    ///    * @return next accessible node that matches rule in preorder.
    ///    */
    /// ```
    ///

    /// `[optional_argc] nsIAccessible next (in nsIAccessible aAnchor, in nsIAccessibleTraversalRule aRule, [optional] in boolean aIncludeStart);`
    const _Next: () = ();

    /// ```text
    /// /**
    ///    * Move pivot to previous object, from current position or given anchor,
    ///    * complying to given traversal rule.
    ///    *
    ///    * @param aRule            [in] traversal rule to use.
    ///    * @param aAnchor          [in] accessible to start search from, if not provided,
    ///    *                           current position will be used.
    ///    * @param aIncludeStart    [in] include anchor accessible in search.
    ///    * @return previous accessible node that matches rule in preorder.
    ///    */
    /// ```
    ///

    /// `[optional_argc] nsIAccessible prev (in nsIAccessible aAnchor, in nsIAccessibleTraversalRule aRule, [optional] in boolean aIncludeStart);`
    const _Prev: () = ();

    /// ```text
    /// /**
    ///    * Move pivot to first object in subtree complying to given traversal rule.
    ///    *
    ///    * @param aRule            [in] traversal rule to use.
    ///    * @return first accessible node in subtree that matches rule in preorder.
    ///    */
    /// ```
    ///

    /// `nsIAccessible first (in nsIAccessibleTraversalRule aRule);`
    #[inline]
    pub unsafe fn First(&self, aRule: *const nsIAccessibleTraversalRule, _retval: *mut*const nsIAccessible) -> ::nserror::nsresult {
        ((*self.vtable).First)(self, aRule, _retval)
    }


    /// ```text
    /// /**
    ///    * Move pivot to last object in subtree complying to given traversal rule.
    ///    *
    ///    * @param aRule            [in] traversal rule to use.
    ///    * @return last accessible node in subtree that matches rule in preorder.
    ///    */
    /// ```
    ///

    /// `nsIAccessible last (in nsIAccessibleTraversalRule aRule);`
    #[inline]
    pub unsafe fn Last(&self, aRule: *const nsIAccessibleTraversalRule, _retval: *mut*const nsIAccessible) -> ::nserror::nsresult {
        ((*self.vtable).Last)(self, aRule, _retval)
    }


    /// ```text
    /// /**
    ///    * Move pivot to given coordinate in screen pixels.
    ///    *
    ///    * @param aX               [in]  screen's x coordinate
    ///    * @param aY               [in]  screen's y coordinate
    ///    * @param aRule            [in]  raversal rule to use.
    ///    * @return highest accessible in subtree that matches rule at given point.
    ///    */
    /// ```
    ///

    /// `nsIAccessible atPoint (in long aX, in long aY, in nsIAccessibleTraversalRule aRule);`
    #[inline]
    pub unsafe fn AtPoint(&self, aX: i32, aY: i32, aRule: *const nsIAccessibleTraversalRule, _retval: *mut*const nsIAccessible) -> ::nserror::nsresult {
        ((*self.vtable).AtPoint)(self, aX, aY, aRule, _retval)
    }


}


/// `interface nsIAccessibleTraversalRule : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIAccessibleTraversalRule {
    vtable: &'static nsIAccessibleTraversalRuleVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIAccessibleTraversalRule.
unsafe impl XpCom for nsIAccessibleTraversalRule {
    const IID: nsIID = nsID(0xe197460d, 0x1eff, 0x4247,
        [0xb4, 0xbb, 0xa4, 0x3b, 0xe1, 0x84, 0x0d, 0xae]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIAccessibleTraversalRule {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIAccessibleTraversalRule.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIAccessibleTraversalRuleCoerce {
    /// Cheaply cast a value of this type from a `nsIAccessibleTraversalRule`.
    fn coerce_from(v: &nsIAccessibleTraversalRule) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIAccessibleTraversalRuleCoerce for nsIAccessibleTraversalRule {
    #[inline]
    fn coerce_from(v: &nsIAccessibleTraversalRule) -> &Self {
        v
    }
}

impl nsIAccessibleTraversalRule {
    /// Cast this `nsIAccessibleTraversalRule` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIAccessibleTraversalRuleCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIAccessibleTraversalRule {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIAccessibleTraversalRuleCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIAccessibleTraversalRule) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIAccessibleTraversalRule
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIAccessibleTraversalRuleVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* unsigned short match (in nsIAccessible aAccessible); */
    pub Match: unsafe extern "system" fn (this: *const nsIAccessibleTraversalRule, aAccessible: *const nsIAccessible, _retval: *mut u16) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIAccessibleTraversalRule {

    pub const FILTER_IGNORE: u16 = 0;


    pub const FILTER_MATCH: u16 = 1;


    pub const FILTER_IGNORE_SUBTREE: u16 = 2;

    /// ```text
    /// /**
    ///    * Determines if a given accessible is to be accepted in our traversal rule
    ///    *
    ///    * @param aAccessible [in] accessible to examine.
    ///    * @return a bitfield of FILTER_MATCH and FILTER_IGNORE_SUBTREE.
    ///    */
    /// ```
    ///

    /// `unsigned short match (in nsIAccessible aAccessible);`
    #[inline]
    pub unsafe fn Match(&self, aAccessible: *const nsIAccessible, _retval: *mut u16) -> ::nserror::nsresult {
        ((*self.vtable).Match)(self, aAccessible, _retval)
    }


}


