//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/accessible/interfaces/nsIAccessibleTextRange.idl
//


/// `interface nsIAccessibleTextRange : nsISupports`
///

/// ```text
/// /**
///  * A range representing a piece of text in the document.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIAccessibleTextRange {
    vtable: &'static nsIAccessibleTextRangeVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIAccessibleTextRange.
unsafe impl XpCom for nsIAccessibleTextRange {
    const IID: nsIID = nsID(0xc4515623, 0x55f9, 0x4543,
        [0xa3, 0xd5, 0xc1, 0xe9, 0xaf, 0xa5, 0x88, 0xf4]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIAccessibleTextRange {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIAccessibleTextRange.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIAccessibleTextRangeCoerce {
    /// Cheaply cast a value of this type from a `nsIAccessibleTextRange`.
    fn coerce_from(v: &nsIAccessibleTextRange) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIAccessibleTextRangeCoerce for nsIAccessibleTextRange {
    #[inline]
    fn coerce_from(v: &nsIAccessibleTextRange) -> &Self {
        v
    }
}

impl nsIAccessibleTextRange {
    /// Cast this `nsIAccessibleTextRange` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIAccessibleTextRangeCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIAccessibleTextRange {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIAccessibleTextRangeCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIAccessibleTextRange) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIAccessibleTextRange
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIAccessibleTextRangeVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute nsIAccessibleText startContainer; */
    pub GetStartContainer: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aStartContainer: *mut*const nsIAccessibleText) -> ::nserror::nsresult,

    /* readonly attribute long startOffset; */
    pub GetStartOffset: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aStartOffset: *mut i32) -> ::nserror::nsresult,

    /* readonly attribute nsIAccessibleText endContainer; */
    pub GetEndContainer: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aEndContainer: *mut*const nsIAccessibleText) -> ::nserror::nsresult,

    /* readonly attribute long endOffset; */
    pub GetEndOffset: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aEndOffset: *mut i32) -> ::nserror::nsresult,

    /* readonly attribute nsIAccessible container; */
    pub GetContainer: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aContainer: *mut*const nsIAccessible) -> ::nserror::nsresult,

    /* boolean compare (in nsIAccessibleTextRange aOtherRange); */
    pub Compare: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aOtherRange: *const nsIAccessibleTextRange, _retval: *mut bool) -> ::nserror::nsresult,

    /* long compareEndPoints (in unsigned long aEndPoint, in nsIAccessibleTextRange aOtherRange, in unsigned long aOtherRangeEndPoint); */
    pub CompareEndPoints: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aEndPoint: u32, aOtherRange: *const nsIAccessibleTextRange, aOtherRangeEndPoint: u32, _retval: *mut i32) -> ::nserror::nsresult,

    /* boolean crop (in nsIAccessible aContainer); */
    pub Crop: unsafe extern "system" fn (this: *const nsIAccessibleTextRange, aContainer: *const nsIAccessible, _retval: *mut bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIAccessibleTextRange {
    /// ```text
    /// /**
    ///    * The two endpoints of the range (starting and ending).
    ///    */
    /// ```
    ///

    pub const EndPoint_Start: u32 = 1;


    pub const EndPoint_End: u32 = 2;


    pub const AlignToTop: u32 = 0;


    pub const AlignToBottom: u32 = 1;


    /// `readonly attribute nsIAccessibleText startContainer;`
    #[inline]
    pub unsafe fn GetStartContainer(&self, aStartContainer: *mut*const nsIAccessibleText) -> ::nserror::nsresult {
        ((*self.vtable).GetStartContainer)(self, aStartContainer)
    }



    /// `readonly attribute long startOffset;`
    #[inline]
    pub unsafe fn GetStartOffset(&self, aStartOffset: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetStartOffset)(self, aStartOffset)
    }



    /// `readonly attribute nsIAccessibleText endContainer;`
    #[inline]
    pub unsafe fn GetEndContainer(&self, aEndContainer: *mut*const nsIAccessibleText) -> ::nserror::nsresult {
        ((*self.vtable).GetEndContainer)(self, aEndContainer)
    }



    /// `readonly attribute long endOffset;`
    #[inline]
    pub unsafe fn GetEndOffset(&self, aEndOffset: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetEndOffset)(self, aEndOffset)
    }


    /// ```text
    /// /**
    ///    * Return an accessible containing the whole range
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIAccessible container;`
    #[inline]
    pub unsafe fn GetContainer(&self, aContainer: *mut*const nsIAccessible) -> ::nserror::nsresult {
        ((*self.vtable).GetContainer)(self, aContainer)
    }


    /// ```text
    /// /**
    ///    * Return true if this range has the same end points of the given range.
    ///    */
    /// ```
    ///

    /// `boolean compare (in nsIAccessibleTextRange aOtherRange);`
    #[inline]
    pub unsafe fn Compare(&self, aOtherRange: *const nsIAccessibleTextRange, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).Compare)(self, aOtherRange, _retval)
    }


    /// ```text
    /// /**
    ///    * Compare this and given ranges end points.
    ///    *
    ///    * @return -1/0/1 if this range end point is before/equal/after the given
    ///    *          range end point.
    ///    */
    /// ```
    ///

    /// `long compareEndPoints (in unsigned long aEndPoint, in nsIAccessibleTextRange aOtherRange, in unsigned long aOtherRangeEndPoint);`
    #[inline]
    pub unsafe fn CompareEndPoints(&self, aEndPoint: u32, aOtherRange: *const nsIAccessibleTextRange, aOtherRangeEndPoint: u32, _retval: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).CompareEndPoints)(self, aEndPoint, aOtherRange, aOtherRangeEndPoint, _retval)
    }


    /// ```text
    /// /**
    ///    * Crops the range by the given accessible element.
    ///    */
    /// ```
    ///

    /// `boolean crop (in nsIAccessible aContainer);`
    #[inline]
    pub unsafe fn Crop(&self, aContainer: *const nsIAccessible, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).Crop)(self, aContainer, _retval)
    }


}


