//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/cache2/nsICachePurgeLock.idl
//


/// `interface nsICachePurgeLock : nsISupports`
///

/// ```text
/// /**
///  * This object is a wrapper of MultiInstanceLock.
///  * It's intended to be used to ensure exclusive access to folders being
///  * deleted by the purgeHTTPCache background task.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICachePurgeLock {
    vtable: &'static nsICachePurgeLockVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICachePurgeLock.
unsafe impl XpCom for nsICachePurgeLock {
    const IID: nsIID = nsID(0x8abb21e3, 0xc6a0, 0x4b4d,
        [0x93, 0x33, 0xcc, 0x0d, 0x72, 0xf2, 0xc2, 0x3b]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICachePurgeLock {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICachePurgeLock.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICachePurgeLockCoerce {
    /// Cheaply cast a value of this type from a `nsICachePurgeLock`.
    fn coerce_from(v: &nsICachePurgeLock) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICachePurgeLockCoerce for nsICachePurgeLock {
    #[inline]
    fn coerce_from(v: &nsICachePurgeLock) -> &Self {
        v
    }
}

impl nsICachePurgeLock {
    /// Cast this `nsICachePurgeLock` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICachePurgeLockCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICachePurgeLock {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICachePurgeLockCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICachePurgeLock) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICachePurgeLock
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICachePurgeLockVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void lock (in AUTF8String profileName); */
    pub Lock: unsafe extern "system" fn (this: *const nsICachePurgeLock, profileName: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* boolean isOtherInstanceRunning (); */
    pub IsOtherInstanceRunning: unsafe extern "system" fn (this: *const nsICachePurgeLock, _retval: *mut bool) -> ::nserror::nsresult,

    /* void unlock (); */
    pub Unlock: unsafe extern "system" fn (this: *const nsICachePurgeLock) -> ::nserror::nsresult,

    /* nsIFile getLockFile (in AUTF8String profileName); */
    pub GetLockFile: unsafe extern "system" fn (this: *const nsICachePurgeLock, profileName: *const ::nsstring::nsACString, _retval: *mut*const nsIFile) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICachePurgeLock {

    /// ```text
    /// /**
    ///      * Initializes the lock using the profile name and the current process's
    ///      * path.
    ///      * Will throw if a lock was already acquired successfully.
    ///      */
    /// ```
    ///

    /// `void lock (in AUTF8String profileName);`
    #[inline]
    pub unsafe fn Lock(&self, profileName: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).Lock)(self, profileName)
    }


    /// ```text
    /// /**
    ///      * Returns true if another instance also holds the lock.
    ///      * Throws if called before lock was called, or after unlock was called.
    ///      */
    /// ```
    ///

    /// `boolean isOtherInstanceRunning ();`
    #[inline]
    pub unsafe fn IsOtherInstanceRunning(&self, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).IsOtherInstanceRunning)(self, _retval)
    }


    /// ```text
    /// /**
    ///      * Releases the lock.
    ///      * This object may be locked again, potentially using a different path
    ///      * after unlocking.
    ///      */
    /// ```
    ///

    /// `void unlock ();`
    #[inline]
    pub unsafe fn Unlock(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).Unlock)(self, )
    }


    /// ```text
    /// /**
    ///      * Returns the file used to guarantee single access to a resource.
    ///      * This method is used to remove the lock file when no longer necessary.
    ///      */
    /// ```
    ///

    /// `nsIFile getLockFile (in AUTF8String profileName);`
    #[inline]
    pub unsafe fn GetLockFile(&self, profileName: *const ::nsstring::nsACString, _retval: *mut*const nsIFile) -> ::nserror::nsresult {
        ((*self.vtable).GetLockFile)(self, profileName, _retval)
    }


}


