//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/cascade_bloom_filter/nsICascadeFilter.idl
//


/// `interface nsICascadeFilter : nsISupports`
///

/// ```text
/// /**
///  * A consumer of a filter cascade, i.e. a cascaded bloom filter as generated by
///  * https://github.com/mozilla/filter-cascade
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICascadeFilter {
    vtable: &'static nsICascadeFilterVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICascadeFilter.
unsafe impl XpCom for nsICascadeFilter {
    const IID: nsIID = nsID(0xc8d0b0b3, 0x17f8, 0x458b,
        [0x92, 0x64, 0x7b, 0x67, 0xb2, 0x88, 0xfe, 0x79]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICascadeFilter {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICascadeFilter.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICascadeFilterCoerce {
    /// Cheaply cast a value of this type from a `nsICascadeFilter`.
    fn coerce_from(v: &nsICascadeFilter) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICascadeFilterCoerce for nsICascadeFilter {
    #[inline]
    fn coerce_from(v: &nsICascadeFilter) -> &Self {
        v
    }
}

impl nsICascadeFilter {
    /// Cast this `nsICascadeFilter` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICascadeFilterCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICascadeFilter {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICascadeFilterCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICascadeFilter) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICascadeFilter
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICascadeFilterVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void setFilterData (in Array<octet> data); */
    pub SetFilterData: unsafe extern "system" fn (this: *const nsICascadeFilter, data: *const thin_vec::ThinVec<u8>) -> ::nserror::nsresult,

    /* boolean has (in ACString key); */
    pub Has: unsafe extern "system" fn (this: *const nsICascadeFilter, key: *const ::nsstring::nsACString, _retval: *mut bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICascadeFilter {

    /// ```text
    /// /**
    ///    * Initialize with the data that represents the filter cascade.
    ///    * This method can be called repeatedly.
    ///    *
    ///    * @throws NS_ERROR_INVALID_ARG if the input is malformed.
    ///    */
    /// ```
    ///

    /// `void setFilterData (in Array<octet> data);`
    #[inline]
    pub unsafe fn SetFilterData(&self, data: *const thin_vec::ThinVec<u8>) -> ::nserror::nsresult {
        ((*self.vtable).SetFilterData)(self, data)
    }


    /// ```text
    /// /**
    ///    * Check whether a given key is a member of the filter cascade.
    ///    * The result can only be relied upon if the key was known at the time of the
    ///    * filter generation. If the key is unknown, the method may incorrectly
    ///    * return true (due to the probabilistic nature of bloom filters).
    ///    */
    /// ```
    ///

    /// `boolean has (in ACString key);`
    #[inline]
    pub unsafe fn Has(&self, key: *const ::nsstring::nsACString, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).Has)(self, key, _retval)
    }


}


