//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/security/manager/ssl/nsICertOverrideService.idl
//


/// `interface nsICertOverride : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICertOverride {
    vtable: &'static nsICertOverrideVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICertOverride.
unsafe impl XpCom for nsICertOverride {
    const IID: nsIID = nsID(0xed735e24, 0xfa55, 0x4163,
        [0x90, 0x6d, 0x17, 0xfb, 0x78, 0x85, 0x1f, 0xe1]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICertOverride {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICertOverride.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICertOverrideCoerce {
    /// Cheaply cast a value of this type from a `nsICertOverride`.
    fn coerce_from(v: &nsICertOverride) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICertOverrideCoerce for nsICertOverride {
    #[inline]
    fn coerce_from(v: &nsICertOverride) -> &Self {
        v
    }
}

impl nsICertOverride {
    /// Cast this `nsICertOverride` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICertOverrideCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICertOverride {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICertOverrideCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICertOverride) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICertOverride
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICertOverrideVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute ACString asciiHost; */
    pub GetAsciiHost: unsafe extern "system" fn (this: *const nsICertOverride, aAsciiHost: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute int32_t port; */
    pub GetPort: unsafe extern "system" fn (this: *const nsICertOverride, aPort: *mut i32) -> ::nserror::nsresult,

    /* readonly attribute ACString hostPort; */
    pub GetHostPort: unsafe extern "system" fn (this: *const nsICertOverride, aHostPort: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute ACString fingerprint; */
    pub GetFingerprint: unsafe extern "system" fn (this: *const nsICertOverride, aFingerprint: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [implicit_jscontext] readonly attribute jsval originAttributes; */
    /// Unable to generate binding because `special type jsval unsupported`
    pub GetOriginAttributes: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICertOverride {

    /// ```text
    /// /**
    ///   *   The hostname of the server the override is used for.
    ///   */
    /// ```
    ///

    /// `readonly attribute ACString asciiHost;`
    #[inline]
    pub unsafe fn GetAsciiHost(&self, aAsciiHost: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetAsciiHost)(self, aAsciiHost)
    }


    /// ```text
    /// /**
    ///   *   The port of the server the override is used for.
    ///   */
    /// ```
    ///

    /// `readonly attribute int32_t port;`
    #[inline]
    pub unsafe fn GetPort(&self, aPort: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetPort)(self, aPort)
    }


    /// ```text
    /// /**
    ///   *   A combination of hostname and port in the form host:port.
    ///   *   Since the port can be -1 which is equivalent to port 433 we use an
    ///   *   existing function of nsCertOverrideService to create this property.
    ///   */
    /// ```
    ///

    /// `readonly attribute ACString hostPort;`
    #[inline]
    pub unsafe fn GetHostPort(&self, aHostPort: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetHostPort)(self, aHostPort)
    }


    /// ```text
    /// /**
    ///   *   The fingerprint for the associated certificate.
    ///   */
    /// ```
    ///

    /// `readonly attribute ACString fingerprint;`
    #[inline]
    pub unsafe fn GetFingerprint(&self, aFingerprint: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetFingerprint)(self, aFingerprint)
    }


    /// ```text
    /// /**
    ///   *   The origin attributes associated with this override.
    ///   */
    /// ```
    ///

    /// `[implicit_jscontext] readonly attribute jsval originAttributes;`
    const _GetOriginAttributes: () = ();

}


/// `interface nsICertOverrideService : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICertOverrideService {
    vtable: &'static nsICertOverrideServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICertOverrideService.
unsafe impl XpCom for nsICertOverrideService {
    const IID: nsIID = nsID(0xbe019e47, 0x22fc, 0x4355,
        [0x9f, 0x16, 0x9a, 0xb0, 0x47, 0xd6, 0x74, 0x2d]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICertOverrideService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICertOverrideService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICertOverrideServiceCoerce {
    /// Cheaply cast a value of this type from a `nsICertOverrideService`.
    fn coerce_from(v: &nsICertOverrideService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICertOverrideServiceCoerce for nsICertOverrideService {
    #[inline]
    fn coerce_from(v: &nsICertOverrideService) -> &Self {
        v
    }
}

impl nsICertOverrideService {
    /// Cast this `nsICertOverrideService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICertOverrideServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICertOverrideService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICertOverrideServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICertOverrideService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICertOverrideService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICertOverrideServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* [binaryname(RememberValidityOverride),must_use,noscript] void rememberValidityOverrideNative (in AUTF8String aHostName, in int32_t aPort, in const_OriginAttributesRef aOriginAttributes, in nsIX509Cert aCert, in boolean aTemporary); */
    /// Unable to generate binding because `native type const mozilla::OriginAttributes unsupported`
    pub RememberValidityOverride: *const ::libc::c_void,

    /* [binaryname(RememberValidityOverrideScriptable),implicit_jscontext,must_use] void rememberValidityOverride (in AUTF8String aHostName, in int32_t aPort, in jsval aOriginAttributes, in nsIX509Cert aCert, in boolean aTemporary); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub RememberValidityOverrideScriptable: *const ::libc::c_void,

    /* [binaryname(HasMatchingOverride),must_use,noscript] boolean hasMatchingOverrideNative (in AUTF8String aHostName, in int32_t aPort, in const_OriginAttributesRef aOriginAttributes, in nsIX509Cert aCert, out boolean aIsTemporary); */
    /// Unable to generate binding because `native type const mozilla::OriginAttributes unsupported`
    pub HasMatchingOverride: *const ::libc::c_void,

    /* [binaryname(HasMatchingOverrideScriptable),implicit_jscontext,must_use] boolean hasMatchingOverride (in AUTF8String aHostName, in int32_t aPort, in jsval aOriginAttributes, in nsIX509Cert aCert, out boolean aIsTemporary); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub HasMatchingOverrideScriptable: *const ::libc::c_void,

    /* [binaryname(ClearValidityOverride),noscript] void clearValidityOverrideNative (in AUTF8String aHostName, in int32_t aPort, in const_OriginAttributesRef aOriginAttributes); */
    /// Unable to generate binding because `native type const mozilla::OriginAttributes unsupported`
    pub ClearValidityOverride: *const ::libc::c_void,

    /* [binaryname(ClearValidityOverrideScriptable),implicit_jscontext] void clearValidityOverride (in AUTF8String aHostName, in int32_t aPort, in jsval aOriginAttributes); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub ClearValidityOverrideScriptable: *const ::libc::c_void,

    /* void clearAllOverrides (); */
    pub ClearAllOverrides: unsafe extern "system" fn (this: *const nsICertOverrideService) -> ::nserror::nsresult,

    /* Array<nsICertOverride> getOverrides (); */
    pub GetOverrides: unsafe extern "system" fn (this: *const nsICertOverrideService, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsICertOverride>>>) -> ::nserror::nsresult,

    /* void setDisableAllSecurityChecksAndLetAttackersInterceptMyData (in boolean aDisable); */
    pub SetDisableAllSecurityChecksAndLetAttackersInterceptMyData: unsafe extern "system" fn (this: *const nsICertOverrideService, aDisable: bool) -> ::nserror::nsresult,

    /* void setDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext (in uint32_t aUserContextId, in boolean aDisable); */
    pub SetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext: unsafe extern "system" fn (this: *const nsICertOverrideService, aUserContextId: u32, aDisable: bool) -> ::nserror::nsresult,

    /* void resetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext (in uint32_t aUserContextId); */
    pub ResetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext: unsafe extern "system" fn (this: *const nsICertOverrideService, aUserContextId: u32) -> ::nserror::nsresult,

    /* readonly attribute boolean securityCheckDisabled; */
    pub GetSecurityCheckDisabled: unsafe extern "system" fn (this: *const nsICertOverrideService, aSecurityCheckDisabled: *mut bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICertOverrideService {

    /// ```text
    /// /**
    ///    * When making a TLS connection to the given hostname and port (in the
        ///    * context of the given origin attributes), if the certificate verifier
    ///    * encounters an overridable error when verifying the given certificate, the
    ///    * connection will continue (provided overrides are allowed for that host).
    ///    *
    ///    * @param aHostName The host (punycode) this mapping belongs to
    ///    * @param aPort The port this mapping belongs to. If it is -1 then it
    ///    *              is internaly treated as 443.
    ///    * @param aOriginAttributes the origin attributes of the mapping
    ///    * @param aCert The certificate used by the server
    ///    * @param aTemporary Whether or not to only store the mapping for the session
    ///    */
    /// ```
    ///

    /// `[binaryname(RememberValidityOverride),must_use,noscript] void rememberValidityOverrideNative (in AUTF8String aHostName, in int32_t aPort, in const_OriginAttributesRef aOriginAttributes, in nsIX509Cert aCert, in boolean aTemporary);`
    const _RememberValidityOverride: () = ();


    /// `[binaryname(RememberValidityOverrideScriptable),implicit_jscontext,must_use] void rememberValidityOverride (in AUTF8String aHostName, in int32_t aPort, in jsval aOriginAttributes, in nsIX509Cert aCert, in boolean aTemporary);`
    const _RememberValidityOverrideScriptable: () = ();

    /// ```text
    /// /**
    ///    *  Return whether this host, port, cert triple has a stored override.
    ///    *  If so, the outparams will contain the specific errors that were
    ///    *  overridden, and whether the override is permanent, or only for the current
    ///    *  session.
    ///    *
    ///    *  @param aHostName The host (punycode) this mapping belongs to
    ///    *  @param aPort The port this mapping belongs to, if it is -1 then it
    ///    *         is internally treated as 443
    ///    *  @param aCert The certificate this mapping belongs to
    ///    *  @param aIsTemporary Whether the stored override is session-only,
    ///    *         or permanent
    ///    *  @return Whether an override has been stored for this host+port+cert
    ///    */
    /// ```
    ///

    /// `[binaryname(HasMatchingOverride),must_use,noscript] boolean hasMatchingOverrideNative (in AUTF8String aHostName, in int32_t aPort, in const_OriginAttributesRef aOriginAttributes, in nsIX509Cert aCert, out boolean aIsTemporary);`
    const _HasMatchingOverride: () = ();


    /// `[binaryname(HasMatchingOverrideScriptable),implicit_jscontext,must_use] boolean hasMatchingOverride (in AUTF8String aHostName, in int32_t aPort, in jsval aOriginAttributes, in nsIX509Cert aCert, out boolean aIsTemporary);`
    const _HasMatchingOverrideScriptable: () = ();

    /// ```text
    /// /**
    ///    *  Remove a override for the given hostname:port.
    ///    *
    ///    *  @param aHostName The host (punycode) whose entry should be cleared.
    ///    *  @param aPort The port whose entry should be cleared.
    ///    *               If it is -1, then it is internaly treated as 443.
    ///    *               If it is 0 and aHostName is "all:temporary-certificates",
    ///    *               then all temporary certificates should be cleared.
    ///    */
    /// ```
    ///

    /// `[binaryname(ClearValidityOverride),noscript] void clearValidityOverrideNative (in AUTF8String aHostName, in int32_t aPort, in const_OriginAttributesRef aOriginAttributes);`
    const _ClearValidityOverride: () = ();


    /// `[binaryname(ClearValidityOverrideScriptable),implicit_jscontext] void clearValidityOverride (in AUTF8String aHostName, in int32_t aPort, in jsval aOriginAttributes);`
    const _ClearValidityOverrideScriptable: () = ();

    /// ```text
    /// /**
    ///    *  Remove all overrides.
    ///    */
    /// ```
    ///

    /// `void clearAllOverrides ();`
    #[inline]
    pub unsafe fn ClearAllOverrides(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).ClearAllOverrides)(self, )
    }



    /// `Array<nsICertOverride> getOverrides ();`
    #[inline]
    pub unsafe fn GetOverrides(&self, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsICertOverride>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetOverrides)(self, _retval)
    }


    /// ```text
    /// /**
    ///    *  NOTE: This function is used only for testing!
    ///    *
    ///    *  @param aDisable If true, disable all security checks and make
    ///    *                  hasMatchingOverride always return true.
    ///    */
    /// ```
    ///

    /// `void setDisableAllSecurityChecksAndLetAttackersInterceptMyData (in boolean aDisable);`
    #[inline]
    pub unsafe fn SetDisableAllSecurityChecksAndLetAttackersInterceptMyData(&self, aDisable: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetDisableAllSecurityChecksAndLetAttackersInterceptMyData)(self, aDisable)
    }


    /// ```text
    /// /**
    ///    *  NOTE: This function is used only for webdriver!
    ///    *  Spec: https://www.w3.org/TR/webdriver-bidi/#command-browser-createUserContext.
    ///    *
    ///    *  The method is designed to enable or disable all security checks
    ///    *  for the specified user context. This settings should override the global state,
    ///    *  e.g., the security checks can be disabled globally but with this method they can
    ///    *  be enabled for the specified user context.
    ///    *
    ///    *  @param aUserContextId Enable or disable all security checks for this user context.
    ///    *  @param aDisable If true, disable all security checks and make
    ///    *                  hasMatchingOverride always return true.
    ///    */
    /// ```
    ///

    /// `void setDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext (in uint32_t aUserContextId, in boolean aDisable);`
    #[inline]
    pub unsafe fn SetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext(&self, aUserContextId: u32, aDisable: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext)(self, aUserContextId, aDisable)
    }


    /// ```text
    /// /**
    ///    *  NOTE: This function is used only for webdriver!
    ///    *  Spec: https://www.w3.org/TR/webdriver-bidi/#cleanup-the-session.
    ///    *
    ///    *  This method is required to reset the status of security checks
    ///    *  for the specified user context and fallback to the global state.
    ///    *  E.g., the user context can have security checks enabled
    ///    *  but globally they are disabled. After calling this method the security checks
    ///    *  for the user context should be disabled as it is globally.
    ///    *
    ///    *  @param aUserContextId Reset the status of security checks for this user context.
    ///    */
    /// ```
    ///

    /// `void resetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext (in uint32_t aUserContextId);`
    #[inline]
    pub unsafe fn ResetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext(&self, aUserContextId: u32) -> ::nserror::nsresult {
        ((*self.vtable).ResetDisableAllSecurityChecksAndLetAttackersInterceptMyDataForUserContext)(self, aUserContextId)
    }



    /// `readonly attribute boolean securityCheckDisabled;`
    #[inline]
    pub unsafe fn GetSecurityCheckDisabled(&self, aSecurityCheckDisabled: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetSecurityCheckDisabled)(self, aSecurityCheckDisabled)
    }


}


