//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/cleardata/nsIClearDataService.idl
//


/// `interface nsIClearDataService : nsISupports`
///

/// ```text
/// /**
///  * nsIClearDataService
///  *
///  * Provides methods for cleaning data from a nsIPrincipal and/or from a time
///  * range.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIClearDataService {
    vtable: &'static nsIClearDataServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIClearDataService.
unsafe impl XpCom for nsIClearDataService {
    const IID: nsIID = nsID(0x6ef3ef16, 0xa502, 0x4576,
        [0x9f, 0xb4, 0x91, 0x9f, 0x1c, 0x40, 0xbf, 0x61]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIClearDataService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIClearDataService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIClearDataServiceCoerce {
    /// Cheaply cast a value of this type from a `nsIClearDataService`.
    fn coerce_from(v: &nsIClearDataService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIClearDataServiceCoerce for nsIClearDataService {
    #[inline]
    fn coerce_from(v: &nsIClearDataService) -> &Self {
        v
    }
}

impl nsIClearDataService {
    /// Cast this `nsIClearDataService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIClearDataServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIClearDataService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIClearDataServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIClearDataService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIClearDataService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIClearDataServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void deleteDataFromLocalFiles (in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    pub DeleteDataFromLocalFiles: unsafe extern "system" fn (this: *const nsIClearDataService, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* void deleteDataFromHost (in AUTF8String aHost, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    pub DeleteDataFromHost: unsafe extern "system" fn (this: *const nsIClearDataService, aHost: *const ::nsstring::nsACString, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* void deleteDataFromSite (in AUTF8String aSchemelessSite, in jsval aOriginAttributesPattern, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub DeleteDataFromSite: *const ::libc::c_void,

    /* void deleteDataFromSiteAndOriginAttributesPatternString (in AUTF8String aSchemelessSite, in AString aOriginAttributesPatternString, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    pub DeleteDataFromSiteAndOriginAttributesPatternString: unsafe extern "system" fn (this: *const nsIClearDataService, aSchemelessSite: *const ::nsstring::nsACString, aOriginAttributesPatternString: *const ::nsstring::nsAString, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* void deleteDataFromPrincipal (in nsIPrincipal aPrincipal, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    pub DeleteDataFromPrincipal: unsafe extern "system" fn (this: *const nsIClearDataService, aPrincipal: *const nsIPrincipal, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* void deleteDataInTimeRange (in PRTime aFrom, in PRTime aTo, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    pub DeleteDataInTimeRange: unsafe extern "system" fn (this: *const nsIClearDataService, aFrom: PRTime, aTo: PRTime, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* void deleteData (in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    pub DeleteData: unsafe extern "system" fn (this: *const nsIClearDataService, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* void deleteDataFromOriginAttributesPattern (in jsval aOriginAttributesPattern, [optional] in nsIClearDataCallback aCallback); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub DeleteDataFromOriginAttributesPattern: *const ::libc::c_void,

    /* void deleteUserInteractionForClearingHistory (in Array<nsIPrincipal> aPrincipalsWithStorage, [optional] in PRTime aFrom, [optional] in nsIClearDataCallback aCallback); */
    pub DeleteUserInteractionForClearingHistory: unsafe extern "system" fn (this: *const nsIClearDataService, aPrincipalsWithStorage: *const thin_vec::ThinVec<Option<RefPtr<nsIPrincipal>>>, aFrom: PRTime, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* void cleanupAfterDeletionAtShutdown (in uint32_t aFlags, in nsIClearDataCallback aCallback); */
    pub CleanupAfterDeletionAtShutdown: unsafe extern "system" fn (this: *const nsIClearDataService, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult,

    /* boolean hostMatchesSite (in AUTF8String aHost, in jsval aOriginAttributes, in AUTF8String aSchemelessSite, [optional] in jsval aOriginAttributesPattern); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub HostMatchesSite: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIClearDataService {
    /// ```text
    /// /**************************************************************************
    ///    * Listed below are the various flags which may be or'd together.
    ///    */
    /// /**
    ///    * Delete cookies.
    ///    */
    /// ```
    ///

    pub const CLEAR_COOKIES: u32 = 1;

    /// ```text
    /// /**
    ///    * Network Cache.
    ///    */
    /// ```
    ///

    pub const CLEAR_NETWORK_CACHE: u32 = 2;

    /// ```text
    /// /**
    ///    * Clear bfcache.
    ///    * FIXME: We are out of bits in this bitflag. To mitigate this we will merge
    ///    *        CLEAR_ALL_CACHES into a single bit Bug 1918722. Reuse the
    ///    *        CLEAR_NETWORK_CACHE bit for now with similar effect.
    ///    */
    /// ```
    ///

    pub const CLEAR_BFCACHE: u32 = 2;

    /// ```text
    /// /**
    ///    * Image cache.
    ///    */
    /// ```
    ///

    pub const CLEAR_IMAGE_CACHE: u32 = 4;

    /// ```text
    /// /**
    ///    * In-memory JS cache.
    ///    */
    /// ```
    ///

    pub const CLEAR_JS_CACHE: u32 = 8;

    /// ```text
    /// /**
    ///    * Completed downloads.
    ///    */
    /// ```
    ///

    pub const CLEAR_DOWNLOADS: u32 = 16;

    /// ```text
    /// /**
    ///    * Media devices.
    ///    */
    /// ```
    ///

    pub const CLEAR_MEDIA_DEVICES: u32 = 64;

    /// ```text
    /// /**
    ///    * LocalStorage, IndexedDB, ServiceWorkers, DOM Cache and so on.
    ///    */
    /// ```
    ///

    pub const CLEAR_DOM_QUOTA: u32 = 128;

    /// ```text
    /// /**
    ///    * Predictor network data
    ///    */
    /// ```
    ///

    pub const CLEAR_PREDICTOR_NETWORK_DATA: u32 = 256;

    /// ```text
    /// /**
    ///    * DOM Push notifications
    ///    */
    /// ```
    ///

    pub const CLEAR_DOM_PUSH_NOTIFICATIONS: u32 = 512;

    /// ```text
    /// /**
    ///    * Places history
    ///    */
    /// ```
    ///

    pub const CLEAR_HISTORY: u32 = 1024;

    /// ```text
    /// /**
    ///    * Messaging Layer Security state
    ///    */
    /// ```
    ///

    pub const CLEAR_MESSAGING_LAYER_SECURITY_STATE: u32 = 2048;

    /// ```text
    /// /**
    ///    * Auth tokens
    ///    */
    /// ```
    ///

    pub const CLEAR_AUTH_TOKENS: u32 = 4096;

    /// ```text
    /// /**
    ///    * Login cache
    ///    */
    /// ```
    ///

    pub const CLEAR_AUTH_CACHE: u32 = 8192;

    /// ```text
    /// /**
    ///    * Clear Site permissions. Excludes permissions which are used as shutdown data clearing exceptions.
    ///    */
    /// ```
    ///

    pub const CLEAR_SITE_PERMISSIONS: u32 = 16384;

    /// ```text
    /// /**
    ///    * Site preferences
    ///    */
    /// ```
    ///

    pub const CLEAR_CONTENT_PREFERENCES: u32 = 32768;

    /// ```text
    /// /**
    ///    * Clear HSTS data
    ///    */
    /// ```
    ///

    pub const CLEAR_HSTS: u32 = 65536;

    /// ```text
    /// /**
    ///    * Media plugin data
    ///    */
    /// ```
    ///

    pub const CLEAR_EME: u32 = 131072;

    /// ```text
    /// /**
    ///    * Reporting API reports.
    ///    */
    /// ```
    ///

    pub const CLEAR_REPORTS: u32 = 262144;

    /// ```text
    /// /**
    ///    * StorageAccessAPI flag, which indicates user interaction.
    ///    */
    /// ```
    ///

    pub const CLEAR_STORAGE_ACCESS: u32 = 524288;

    /// ```text
    /// /**
    ///    * Clear Cert Exceptions.
    ///    */
    /// ```
    ///

    pub const CLEAR_CERT_EXCEPTIONS: u32 = 1048576;

    /// ```text
    /// /**
    ///    * Clear entries in the content blocking database.
    ///    */
    /// ```
    ///

    pub const CLEAR_CONTENT_BLOCKING_RECORDS: u32 = 2097152;

    /// ```text
    /// /**
    ///    * Clear the in-memory CSS cache.
    ///    */
    /// ```
    ///

    pub const CLEAR_CSS_CACHE: u32 = 4194304;

    /// ```text
    /// /**
    ///    * Clear the CORS preflight cache.
    ///    */
    /// ```
    ///

    pub const CLEAR_PREFLIGHT_CACHE: u32 = 8388608;

    /// ```text
    /// /**
    ///    * Forget descision about clients authentification certificate
    ///    */
    /// ```
    ///

    pub const CLEAR_CLIENT_AUTH_REMEMBER_SERVICE: u32 = 16777216;

    /// ```text
    /// /**
    ///    * Clear state associated with FedCM
    ///    */
    /// ```
    ///

    pub const CLEAR_CREDENTIAL_MANAGER_STATE: u32 = 33554432;

    /// ```text
    /// /**
    ///    * Clear the per-site exception for cookie banner handling.
    ///    */
    /// ```
    ///

    pub const CLEAR_COOKIE_BANNER_EXCEPTION: u32 = 67108864;

    /// ```text
    /// /**
    ///    * Clear the site executed record for cookie banner handling.
    ///    */
    /// ```
    ///

    pub const CLEAR_COOKIE_BANNER_EXECUTED_RECORD: u32 = 134217728;

    /// ```text
    /// /**
    ///    * Clear state associated with the fingerprinting protection.
    ///    */
    /// ```
    ///

    pub const CLEAR_FINGERPRINTING_PROTECTION_STATE: u32 = 268435456;

    /// ```text
    /// /**
    ///    * Clear the bounce tracking protection state.
    ///    */
    /// ```
    ///

    pub const CLEAR_BOUNCE_TRACKING_PROTECTION_STATE: u32 = 536870912;

    /// ```text
    /// /**
    ///    * Clear permissions of type "persistent-storage" and "storage-access"
    ///    */
    /// ```
    ///

    pub const CLEAR_STORAGE_PERMISSIONS: u32 = 1073741824;

    /// ```text
    /// /**
    ///    * Clear permissions of type "cookie" used for manual cookie rules and shutdown exceptions
    ///    *
    ///    * TODO: Bug 1767271: move clear-on-shutdown exceptions to its own permission type and switch this cleaner over to clear the new permission type, not the "cookie" permissions.
    ///    */
    /// ```
    ///

    pub const CLEAR_SHUTDOWN_EXCEPTIONS: u32 = 2147483648;

    /// ```text
    /// /**
    ///    * Use this value to delete all the data.
    ///    */
    /// ```
    ///

    pub const CLEAR_ALL: u32 = 4294967295;

    /// ```text
    /// /**************************************************************************
    ///    * The following flags are helpers: they combine some of the previous flags
    ///    * in a more convenient way.
    ///    */
    /// /**
    ///    * Helper flag for clearing ALL permissions from the permission manager.
    ///    */
    /// ```
    ///

    pub const CLEAR_PERMISSIONS: u32 = 2147500032;

    /// ```text
    /// /**
    ///    * Delete all the possible caches.
    ///    */
    /// ```
    ///

    pub const CLEAR_ALL_CACHES: u32 = 12648462;

    /// ```text
    /// /**
    ///    * Delete all DOM storages
    ///    */
    /// ```
    ///

    pub const CLEAR_DOM_STORAGES: u32 = 262784;

    /// ```text
    /// /**
    ///    * Helper flag for forget about site
    ///    */
    /// ```
    ///

    pub const CLEAR_FORGET_ABOUT_SITE: u32 = 3218591647;

    /// ```text
    /// /**
    ///    * Helper flag for clearing cookies and site data.
    ///    * This flag groups state that we consider site data
    ///    * from the user perspective. If you implement UI that
    ///    * offers site data clearing this is almost always what you want.
    ///    * If you need more granular control please use more specific
    ///    * flags like CLEAR_COOKIES and CLEAR_DOM_STORAGES.
    ///    * This flag does not clear caches.
    ///    */
    /// ```
    ///

    pub const CLEAR_COOKIES_AND_SITE_DATA: u32 = 2013739649;

    /// ```text
    /// /**
    ///   * Helper flag for tracker purging
    ///   */
    /// ```
    ///

    pub const CLEAR_STATE_FOR_TRACKER_PURGING: u32 = 2043624143;

    /// ```text
    /// /**
    ///    * Delete data owned by local files or other hostless schemes.
    ///    * @param aIsUserRequest true if this request comes from a user interaction.
    ///    *        This information is important because if true, it's probably better
    ///    *        to remove more than less, for privacy reason. If false (e.g.
        ///    *        Clear-Site-Data header), we don't want to delete more than what is
    ///    *        strictly required.
    ///    * @param aFlags List of flags. See below the accepted values.
    ///                    Note that not all flags will make sense (e.g. we can't clear
        ///                    certificates for local files). Nonsensical flags will be
    ///                    ignored.
    ///    * @param aCallback this callback will be executed when the operation is
    ///    *                  completed.
    ///    */
    /// ```
    ///

    /// `void deleteDataFromLocalFiles (in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn DeleteDataFromLocalFiles(&self, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).DeleteDataFromLocalFiles)(self, aIsUserRequest, aFlags, aCallback)
    }


    /// ```text
    /// /**
    ///    * Delete data owned by a host. For instance: mozilla.org. Data from any
    ///    * possible originAttributes will be deleted.
    ///    * @param aHost the host to be used.
    ///    * @param aIsUserRequest true if this request comes from a user interaction.
    ///    *        This information is important because if true, it's probably better
    ///    *        to remove more than less, for privacy reason. If false (e.g.
        ///    *        Clear-Site-Data header), we don't want to delete more than what is
    ///    *        strictly required.
    ///    * @param aFlags List of flags. See below the accepted values.
    ///    * @param aCallback this callback will be executed when the operation is
    ///    *                  completed.
    ///    * @deprecated Use deleteDataFromSite instead.
    ///    */
    /// ```
    ///

    /// `void deleteDataFromHost (in AUTF8String aHost, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn DeleteDataFromHost(&self, aHost: *const ::nsstring::nsACString, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).DeleteDataFromHost)(self, aHost, aIsUserRequest, aFlags, aCallback)
    }


    /// ```text
    /// /**
    ///    * Delete data from cookie jars associated with the given schemeless site
    ///    * aSchemelessSite.
    ///    * In addition to regular first-party data this includes data of aSchemelessSite in a
    ///    * third-party context and data from other sites partitioned under aSchemelessSite.
    ///    * You can use Services.eTLD.getSchemelessSite to extract the site portion of a URI.
    ///    * See https://html.spec.whatwg.org/#obtain-a-site for details.
    ///    * If you have an nsIPrincipal object you can simply pass in
    ///    * principal.baseDomain.
    ///    * When handling user requests for clearing data using this method is
    ///    * preferred over deleteDataFromPrincipal, since origins may share information
    ///    * with their site (e.g. cookies) that are not deleted by principal.
    ///    * @param aSchemelessSite the site to be cleared excluding scheme.
    ///    * @param aOriginAttributesPatternString optional pattern to filter OriginAttributes
    ///    *        by. If not passed all entries matching aSchemelessSite are cleared.
    ///    * @param aIsUserRequest true if this request comes from a user interaction.
    ///    *        This information is important because if true, it's probably better
    ///    *        to remove more than less, for privacy reason. If false (e.g.
        ///    *        Clear-Site-Data header), we don't want to delete more than what is
    ///    *        strictly required.
    ///    * @param aFlags List of flags. See below the accepted values.
    ///    * @param aCallback this callback will be executed when the operation is
    ///    *                  completed.
    ///    */
    /// ```
    ///

    /// `void deleteDataFromSite (in AUTF8String aSchemelessSite, in jsval aOriginAttributesPattern, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    const _DeleteDataFromSite: () = ();

    /// ```text
    /// /**
    ///    * Variant of deleteDataFromSite that accepts a JSON string for the OriginAttributesPattern.
    ///    * This is helpful for native callers because they don't have to construct a jsval.
    ///    * From JS prefer calling deleteDataFromSite directly.
    ///    */
    /// ```
    ///

    /// `void deleteDataFromSiteAndOriginAttributesPatternString (in AUTF8String aSchemelessSite, in AString aOriginAttributesPatternString, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn DeleteDataFromSiteAndOriginAttributesPatternString(&self, aSchemelessSite: *const ::nsstring::nsACString, aOriginAttributesPatternString: *const ::nsstring::nsAString, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).DeleteDataFromSiteAndOriginAttributesPatternString)(self, aSchemelessSite, aOriginAttributesPatternString, aIsUserRequest, aFlags, aCallback)
    }


    /// ```text
    /// /**
    ///    * Delete data owned by a principal.
    ///    * @param aPrincipal the nsIPrincipal to be used.
    ///    * @param aIsUserRequest true if this request comes from a user interaction.
    ///    *        This information is important because if true, it's probably better
    ///    *        to remove more than less, for privacy reason. If false (e.g.
        ///    *        Clear-Site-Data header), we don't want to delete more than what is
    ///    *        strictly required.
    ///    * @param aFlags List of flags. See below the accepted values.
    ///    * @param aCallback ths callback will be executed when the operation is
    ///    *                  completed.
    ///    */
    /// ```
    ///

    /// `void deleteDataFromPrincipal (in nsIPrincipal aPrincipal, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn DeleteDataFromPrincipal(&self, aPrincipal: *const nsIPrincipal, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).DeleteDataFromPrincipal)(self, aPrincipal, aIsUserRequest, aFlags, aCallback)
    }


    /// ```text
    /// /**
    ///    * Delete all data in a time range. Limit excluded.
    ///    * @param aFrom microseconds from the epoch
    ///    * @param aTo microseconds from the epoch
    ///    * @param aIsUserRequest true if this request comes from a user interaction.
    ///    *        This information is important because if true, it's probably better
    ///    *        to remove more than less, for privacy reason. If false (e.g.
        ///    *        Clear-Site-Data header), we don't want to delete more than what is
    ///    *        strictly required.
    ///    * @param aFlags List of flags. See below the accepted values.
    ///    * @param aCallback ths callback will be executed when the operation is
    ///    *                  completed.
    ///    */
    /// ```
    ///

    /// `void deleteDataInTimeRange (in PRTime aFrom, in PRTime aTo, in boolean aIsUserRequest, in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn DeleteDataInTimeRange(&self, aFrom: PRTime, aTo: PRTime, aIsUserRequest: bool, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).DeleteDataInTimeRange)(self, aFrom, aTo, aIsUserRequest, aFlags, aCallback)
    }


    /// ```text
    /// /**
    ///    * Delete all data from any host, in any time range.
    ///    * @param aFlags List of flags. See below the accepted values.
    ///    * @param aCallback ths callback will be executed when the operation is
    ///    *                  completed.
    ///    */
    /// ```
    ///

    /// `void deleteData (in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn DeleteData(&self, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).DeleteData)(self, aFlags, aCallback)
    }


    /// ```text
    /// /**
    ///    * Delete all data from an OriginAttributesPatternDictionary.
    ///    * @param aOriginAttributesPattern the originAttributes dictionary.
    ///    * @param aCallback the optional callback will be executed when the operation
    ///    *                  is completed.
    ///    */
    /// ```
    ///

    /// `void deleteDataFromOriginAttributesPattern (in jsval aOriginAttributesPattern, [optional] in nsIClearDataCallback aCallback);`
    const _DeleteDataFromOriginAttributesPattern: () = ();

    /// ```text
    /// /**
    ///    * This is a helper function to clear storageAccessAPI permissions
    ///    * in a way that will not result in users getting logged out by
    ///    * cookie purging. To that end we only clear permissions for principals
    ///    * whose base domain does not have any storage associated with it.
    ///    *
    ///    * The principals to be considered will need to be passed by the API consumer.
    ///    * It is recommended to use PrincipalsCollector.sys.mjs for that.
    ///    *
    ///    * @param aPrincipalsWithStorage principals to be excluded from clearing
    ///    * @param aFrom microseconds from the epoch
    ///    * @param aCallback the optional callback will be executed when the operation
    ///    *                  is completed.
    ///    */
    /// ```
    ///

    /// `void deleteUserInteractionForClearingHistory (in Array<nsIPrincipal> aPrincipalsWithStorage, [optional] in PRTime aFrom, [optional] in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn DeleteUserInteractionForClearingHistory(&self, aPrincipalsWithStorage: *const thin_vec::ThinVec<Option<RefPtr<nsIPrincipal>>>, aFrom: PRTime, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).DeleteUserInteractionForClearingHistory)(self, aPrincipalsWithStorage, aFrom, aCallback)
    }


    /// ```text
    /// /**
    ///    * Some cleaners, namely QuotaCleaner, can opt in and treat things as deleted
    ///    * without actually removing files at shutdown. This function will trigger
    ///    * actual removal of them.
    ///    */
    /// ```
    ///

    /// `void cleanupAfterDeletionAtShutdown (in uint32_t aFlags, in nsIClearDataCallback aCallback);`
    #[inline]
    pub unsafe fn CleanupAfterDeletionAtShutdown(&self, aFlags: u32, aCallback: *const nsIClearDataCallback) -> ::nserror::nsresult {
        ((*self.vtable).CleanupAfterDeletionAtShutdown)(self, aFlags, aCallback)
    }


    /// ```text
    /// /**
    ///    * Match a host and OriginAttributes against a schemeless site and
    ///    * OriginAttributesPattern.
    ///    * Also considers partitioned state by inspecting OriginAttributes
    ///    * partitionKey.
    ///    * This is a helper method for external callers that need to do
    ///    * filtering for data clearing.
    ///    */
    /// ```
    ///

    /// `boolean hostMatchesSite (in AUTF8String aHost, in jsval aOriginAttributes, in AUTF8String aSchemelessSite, [optional] in jsval aOriginAttributesPattern);`
    const _HostMatchesSite: () = ();

}


/// `interface nsIClearDataCallback : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIClearDataCallback {
    vtable: &'static nsIClearDataCallbackVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIClearDataCallback.
unsafe impl XpCom for nsIClearDataCallback {
    const IID: nsIID = nsID(0xe225517b, 0x24c5, 0x498a,
        [0xb9, 0xfb, 0x99, 0x93, 0xe3, 0x41, 0xa3, 0x98]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIClearDataCallback {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIClearDataCallback.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIClearDataCallbackCoerce {
    /// Cheaply cast a value of this type from a `nsIClearDataCallback`.
    fn coerce_from(v: &nsIClearDataCallback) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIClearDataCallbackCoerce for nsIClearDataCallback {
    #[inline]
    fn coerce_from(v: &nsIClearDataCallback) -> &Self {
        v
    }
}

impl nsIClearDataCallback {
    /// Cast this `nsIClearDataCallback` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIClearDataCallbackCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIClearDataCallback {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIClearDataCallbackCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIClearDataCallback) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIClearDataCallback
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIClearDataCallbackVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onDataDeleted (in uint32_t aFailedFlags); */
    pub OnDataDeleted: unsafe extern "system" fn (this: *const nsIClearDataCallback, aFailedFlags: u32) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIClearDataCallback {

    /// ```text
    /// /**
    ///  * This is a companion interface for
    ///  * nsIClearDataService::deleteDataFromPrincipal().
    ///  */
    /// /**
    ///    * Called to indicate that the data cleaning is completed.
    ///    * @param aFailedFlags this value contains the flags that failed during the
    ///    *                     cleanup. If nothing failed, aFailedFlags will be 0.
    ///    */
    /// ```
    ///

    /// `void onDataDeleted (in uint32_t aFailedFlags);`
    #[inline]
    pub unsafe fn OnDataDeleted(&self, aFailedFlags: u32) -> ::nserror::nsresult {
        ((*self.vtable).OnDataDeleted)(self, aFailedFlags)
    }


}


