//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIClipboard.idl
//


/// `interface nsIAsyncSetClipboardData : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIAsyncSetClipboardData {
    vtable: &'static nsIAsyncSetClipboardDataVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIAsyncSetClipboardData.
unsafe impl XpCom for nsIAsyncSetClipboardData {
    const IID: nsIID = nsID(0x801e2318, 0xc8fa, 0x11ed,
        [0xaf, 0xa1, 0x02, 0x42, 0xac, 0x12, 0x00, 0x02]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIAsyncSetClipboardData {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIAsyncSetClipboardData.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIAsyncSetClipboardDataCoerce {
    /// Cheaply cast a value of this type from a `nsIAsyncSetClipboardData`.
    fn coerce_from(v: &nsIAsyncSetClipboardData) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIAsyncSetClipboardDataCoerce for nsIAsyncSetClipboardData {
    #[inline]
    fn coerce_from(v: &nsIAsyncSetClipboardData) -> &Self {
        v
    }
}

impl nsIAsyncSetClipboardData {
    /// Cast this `nsIAsyncSetClipboardData` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIAsyncSetClipboardDataCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIAsyncSetClipboardData {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIAsyncSetClipboardDataCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIAsyncSetClipboardData) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIAsyncSetClipboardData
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIAsyncSetClipboardDataVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void setData (in nsITransferable aTransferable, [optional] in nsIClipboardOwner aOwner); */
    pub SetData: unsafe extern "system" fn (this: *const nsIAsyncSetClipboardData, aTransferable: *const nsITransferable, aOwner: *const nsIClipboardOwner) -> ::nserror::nsresult,

    /* void abort (in nsresult aReason); */
    pub Abort: unsafe extern "system" fn (this: *const nsIAsyncSetClipboardData, aReason: nserror::nsresult) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIAsyncSetClipboardData {

    /// ```text
    /// /**
    ///    * Provide the data for the set request.
    ///    *
    ///    * @param  aTransferable
    ///    *         The transferable contains the data to be written.
    ///    * @param  aOwner [optional]
    ///    *         The owner of the transferable.
    ///    */
    /// ```
    ///

    /// `void setData (in nsITransferable aTransferable, [optional] in nsIClipboardOwner aOwner);`
    #[inline]
    pub unsafe fn SetData(&self, aTransferable: *const nsITransferable, aOwner: *const nsIClipboardOwner) -> ::nserror::nsresult {
        ((*self.vtable).SetData)(self, aTransferable, aOwner)
    }


    /// ```text
    /// /**
    ///    * Abort the request to set data.
    ///    *
    ///    * @param  aReason
    ///    *         The reason for the abort, can not be NS_OK.
    ///    */
    /// ```
    ///

    /// `void abort (in nsresult aReason);`
    #[inline]
    pub unsafe fn Abort(&self, aReason: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).Abort)(self, aReason)
    }


}


/// `interface nsIAsyncClipboardRequestCallback : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIAsyncClipboardRequestCallback {
    vtable: &'static nsIAsyncClipboardRequestCallbackVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIAsyncClipboardRequestCallback.
unsafe impl XpCom for nsIAsyncClipboardRequestCallback {
    const IID: nsIID = nsID(0x78f7c18e, 0xc8fa, 0x11ed,
        [0xaf, 0xa1, 0x02, 0x42, 0xac, 0x12, 0x00, 0x02]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIAsyncClipboardRequestCallback {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIAsyncClipboardRequestCallback.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIAsyncClipboardRequestCallbackCoerce {
    /// Cheaply cast a value of this type from a `nsIAsyncClipboardRequestCallback`.
    fn coerce_from(v: &nsIAsyncClipboardRequestCallback) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIAsyncClipboardRequestCallbackCoerce for nsIAsyncClipboardRequestCallback {
    #[inline]
    fn coerce_from(v: &nsIAsyncClipboardRequestCallback) -> &Self {
        v
    }
}

impl nsIAsyncClipboardRequestCallback {
    /// Cast this `nsIAsyncClipboardRequestCallback` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIAsyncClipboardRequestCallbackCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIAsyncClipboardRequestCallback {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIAsyncClipboardRequestCallbackCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIAsyncClipboardRequestCallback) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIAsyncClipboardRequestCallback
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIAsyncClipboardRequestCallbackVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onComplete (in nsresult aResult); */
    pub OnComplete: unsafe extern "system" fn (this: *const nsIAsyncClipboardRequestCallback, aResult: nserror::nsresult) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIAsyncClipboardRequestCallback {

    /// ```text
    /// /**
    ///    * Indicates that the clipboard request has either succeeded, been canceled or
    ///    * rejected.
    ///    *
    ///    * @param  aResult
    ///    *         The result of the request. NS_OK if successful, or another value
    ///    *         that indicates the reason for failure or cancellation.
    ///    */
    /// ```
    ///

    /// `void onComplete (in nsresult aResult);`
    #[inline]
    pub unsafe fn OnComplete(&self, aResult: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).OnComplete)(self, aResult)
    }


}


/// `interface nsIClipboardDataSnapshot : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIClipboardDataSnapshot {
    vtable: &'static nsIClipboardDataSnapshotVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIClipboardDataSnapshot.
unsafe impl XpCom for nsIClipboardDataSnapshot {
    const IID: nsIID = nsID(0xc18ea2f7, 0x6b6f, 0x4a38,
        [0x9a, 0xb3, 0xa8, 0x78, 0x1f, 0xdf, 0xcc, 0x39]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIClipboardDataSnapshot {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIClipboardDataSnapshot.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIClipboardDataSnapshotCoerce {
    /// Cheaply cast a value of this type from a `nsIClipboardDataSnapshot`.
    fn coerce_from(v: &nsIClipboardDataSnapshot) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIClipboardDataSnapshotCoerce for nsIClipboardDataSnapshot {
    #[inline]
    fn coerce_from(v: &nsIClipboardDataSnapshot) -> &Self {
        v
    }
}

impl nsIClipboardDataSnapshot {
    /// Cast this `nsIClipboardDataSnapshot` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIClipboardDataSnapshotCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIClipboardDataSnapshot {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIClipboardDataSnapshotCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIClipboardDataSnapshot) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIClipboardDataSnapshot
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIClipboardDataSnapshotVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute boolean valid; */
    pub GetValid: unsafe extern "system" fn (this: *const nsIClipboardDataSnapshot, aValid: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute Array<ACString> flavorList; */
    pub GetFlavorList: unsafe extern "system" fn (this: *const nsIClipboardDataSnapshot, aFlavorList: *mut thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void getData (in nsITransferable aTransferable, in nsIAsyncClipboardRequestCallback aCallback); */
    pub GetData: unsafe extern "system" fn (this: *const nsIClipboardDataSnapshot, aTransferable: *const nsITransferable, aCallback: *const nsIAsyncClipboardRequestCallback) -> ::nserror::nsresult,

    /* void getDataSync (in nsITransferable aTransferable); */
    pub GetDataSync: unsafe extern "system" fn (this: *const nsIClipboardDataSnapshot, aTransferable: *const nsITransferable) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIClipboardDataSnapshot {

    /// ```text
    /// /**
    ///    * Determines whether this request is still valid (e.g., the clipboard content
        ///    * associated with this request is not stale).
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean valid;`
    #[inline]
    pub unsafe fn GetValid(&self, aValid: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetValid)(self, aValid)
    }


    /// ```text
    /// /**
    ///    * The available flavors in the clipboard.
    ///    */
    /// ```
    ///

    /// `readonly attribute Array<ACString> flavorList;`
    #[inline]
    pub unsafe fn GetFlavorList(&self, aFlavorList: *mut thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).GetFlavorList)(self, aFlavorList)
    }


    /// ```text
    /// /**
    ///    * Filters the flavors that `aTransferable` can import (see
        ///    * `nsITransferable::flavorsTransferableCanImport`). Every specified flavors
    ///    * must exist in `flavorList`, or the request will be rejected. If the request
    ///    * remains valid, it retrieves the data for the first flavor. The data is then
    ///    * set for `aTransferable`.
    ///    *
    ///    * @param  aTransferable
    ///    *         The transferable which contains the flavors to be read.
    ///    * @param  aCallback
    ///    *         The nsIAsyncClipboardRequestCallback to be invoked once the get
    ///    *         request is either successfully completed or rejected.
    ///    * @result NS_OK if no errors
    ///    */
    /// ```
    ///

    /// `void getData (in nsITransferable aTransferable, in nsIAsyncClipboardRequestCallback aCallback);`
    #[inline]
    pub unsafe fn GetData(&self, aTransferable: *const nsITransferable, aCallback: *const nsIAsyncClipboardRequestCallback) -> ::nserror::nsresult {
        ((*self.vtable).GetData)(self, aTransferable, aCallback)
    }


    /// ```text
    /// /**
    ///    * Filters the flavors that `aTransferable` can import (see
        ///    * `nsITransferable::flavorsTransferableCanImport`). Every specified flavors
    ///    * must exist in `flavorList`, or the request will be rejected. If the request
    ///    * remains valid, it retrieves the data for the first flavor. The data is then
    ///    * set for `aTransferable`.
    ///    *
    ///    * @param  aTransferable
    ///    *         The transferable which contains the flavors to be read.
    ///    * @result NS_OK if no errors
    ///    */
    /// ```
    ///

    /// `void getDataSync (in nsITransferable aTransferable);`
    #[inline]
    pub unsafe fn GetDataSync(&self, aTransferable: *const nsITransferable) -> ::nserror::nsresult {
        ((*self.vtable).GetDataSync)(self, aTransferable)
    }


}


/// `interface nsIClipboardGetDataSnapshotCallback : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIClipboardGetDataSnapshotCallback {
    vtable: &'static nsIClipboardGetDataSnapshotCallbackVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIClipboardGetDataSnapshotCallback.
unsafe impl XpCom for nsIClipboardGetDataSnapshotCallback {
    const IID: nsIID = nsID(0xce23c1c4, 0x58fd, 0x4c33,
        [0x85, 0x79, 0xfa, 0x07, 0x96, 0xd9, 0x65, 0x2c]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIClipboardGetDataSnapshotCallback {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIClipboardGetDataSnapshotCallback.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIClipboardGetDataSnapshotCallbackCoerce {
    /// Cheaply cast a value of this type from a `nsIClipboardGetDataSnapshotCallback`.
    fn coerce_from(v: &nsIClipboardGetDataSnapshotCallback) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIClipboardGetDataSnapshotCallbackCoerce for nsIClipboardGetDataSnapshotCallback {
    #[inline]
    fn coerce_from(v: &nsIClipboardGetDataSnapshotCallback) -> &Self {
        v
    }
}

impl nsIClipboardGetDataSnapshotCallback {
    /// Cast this `nsIClipboardGetDataSnapshotCallback` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIClipboardGetDataSnapshotCallbackCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIClipboardGetDataSnapshotCallback {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIClipboardGetDataSnapshotCallbackCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIClipboardGetDataSnapshotCallback) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIClipboardGetDataSnapshotCallback
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIClipboardGetDataSnapshotCallbackVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onSuccess (in nsIClipboardDataSnapshot aClipboardDataSnapshot); */
    pub OnSuccess: unsafe extern "system" fn (this: *const nsIClipboardGetDataSnapshotCallback, aClipboardDataSnapshot: *const nsIClipboardDataSnapshot) -> ::nserror::nsresult,

    /* void onError (in nsresult aResult); */
    pub OnError: unsafe extern "system" fn (this: *const nsIClipboardGetDataSnapshotCallback, aResult: nserror::nsresult) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIClipboardGetDataSnapshotCallback {

    /// ```text
    /// /**
    ///    * Indicates that the clipboard get request has succeeded.
    ///    */
    /// ```
    ///

    /// `void onSuccess (in nsIClipboardDataSnapshot aClipboardDataSnapshot);`
    #[inline]
    pub unsafe fn OnSuccess(&self, aClipboardDataSnapshot: *const nsIClipboardDataSnapshot) -> ::nserror::nsresult {
        ((*self.vtable).OnSuccess)(self, aClipboardDataSnapshot)
    }


    /// ```text
    /// /**
    ///    * Indicates that the clipboard get request has rejected.
    ///    *
    ///    * @param  aResult
    ///    *         The reason for the rejection, can not be NS_OK.
    ///    */
    /// ```
    ///

    /// `void onError (in nsresult aResult);`
    #[inline]
    pub unsafe fn OnError(&self, aResult: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).OnError)(self, aResult)
    }


}


/// `interface nsIClipboard : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIClipboard {
    vtable: &'static nsIClipboardVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIClipboard.
unsafe impl XpCom for nsIClipboard {
    const IID: nsIID = nsID(0xceaa0047, 0x647f, 0x4b8e,
        [0xad, 0x1c, 0xaf, 0xf9, 0xfa, 0x62, 0xaa, 0x51]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIClipboard {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIClipboard.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIClipboardCoerce {
    /// Cheaply cast a value of this type from a `nsIClipboard`.
    fn coerce_from(v: &nsIClipboard) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIClipboardCoerce for nsIClipboard {
    #[inline]
    fn coerce_from(v: &nsIClipboard) -> &Self {
        v
    }
}

impl nsIClipboard {
    /// Cast this `nsIClipboard` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIClipboardCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIClipboard {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIClipboardCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIClipboard) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIClipboard
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIClipboardVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void setData (in nsITransferable aTransferable, in nsIClipboardOwner anOwner, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aSettingWindowContext); */
    pub SetData: unsafe extern "system" fn (this: *const nsIClipboard, aTransferable: *const nsITransferable, anOwner: *const nsIClipboardOwner, aWhichClipboard:  u32, aSettingWindowContext: *const libc::c_void) -> ::nserror::nsresult,

    /* nsIAsyncSetClipboardData asyncSetData (in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aSettingWindowContext, [optional] in nsIAsyncClipboardRequestCallback aCallback); */
    pub AsyncSetData: unsafe extern "system" fn (this: *const nsIClipboard, aWhichClipboard:  u32, aSettingWindowContext: *const libc::c_void, aCallback: *const nsIAsyncClipboardRequestCallback, _retval: *mut *const nsIAsyncSetClipboardData) -> ::nserror::nsresult,

    /* void getData (in nsITransferable aTransferable, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aRequestingWindowContext); */
    pub GetData: unsafe extern "system" fn (this: *const nsIClipboard, aTransferable: *const nsITransferable, aWhichClipboard:  u32, aRequestingWindowContext: *const libc::c_void) -> ::nserror::nsresult,

    /* void getDataSnapshot (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard, in WindowContext aRequestingWindowContext, in nsIPrincipal aRequestingPrincipal, in nsIClipboardGetDataSnapshotCallback aCallback); */
    pub GetDataSnapshot: unsafe extern "system" fn (this: *const nsIClipboard, aFlavorList: *const thin_vec::ThinVec<::nsstring::nsCString>, aWhichClipboard:  u32, aRequestingWindowContext: *const libc::c_void, aRequestingPrincipal: *const nsIPrincipal, aCallback: *const nsIClipboardGetDataSnapshotCallback) -> ::nserror::nsresult,

    /* nsIClipboardDataSnapshot getDataSnapshotSync (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aRequestingWindowContext); */
    pub GetDataSnapshotSync: unsafe extern "system" fn (this: *const nsIClipboard, aFlavorList: *const thin_vec::ThinVec<::nsstring::nsCString>, aWhichClipboard:  u32, aRequestingWindowContext: *const libc::c_void, _retval: *mut *const nsIClipboardDataSnapshot) -> ::nserror::nsresult,

    /* void emptyClipboard (in nsIClipboard_ClipboardType aWhichClipboard); */
    pub EmptyClipboard: unsafe extern "system" fn (this: *const nsIClipboard, aWhichClipboard:  u32) -> ::nserror::nsresult,

    /* boolean hasDataMatchingFlavors (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard); */
    pub HasDataMatchingFlavors: unsafe extern "system" fn (this: *const nsIClipboard, aFlavorList: *const thin_vec::ThinVec<::nsstring::nsCString>, aWhichClipboard:  u32, _retval: *mut bool) -> ::nserror::nsresult,

    /* [infallible] boolean isClipboardTypeSupported (in nsIClipboard_ClipboardType aWhichClipboard); */
    pub IsClipboardTypeSupported: unsafe extern "system" fn (this: *const nsIClipboard, aWhichClipboard:  u32, _retval: *mut bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIClipboard {

    pub const kSelectionClipboard:  u32 = 0;


    pub const kGlobalClipboard:  u32 = 1;


    pub const kFindClipboard:  u32 = 2;


    pub const kSelectionCache:  u32 = 3;

    /// ```text
    /// /**
    ///     * Given a transferable, set the data on the native clipboard
    ///     *
    ///     * @param  aTransferable The transferable
    ///     * @param  anOwner The owner of the transferable
    ///     * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    ///     * @param  aSettingWindowContext [optional]
    ///     *         The window context that is setting the clipboard, if any. This is used
    ///     *         to possibly bypass Content Analysis if a set clipboard and get clipboard
    ///     *         operation are done on the same page.
    ///     * @result NS_OK if no errors
    ///     */
    /// ```
    ///

    /// `void setData (in nsITransferable aTransferable, in nsIClipboardOwner anOwner, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aSettingWindowContext);`
    #[inline]
    pub unsafe fn SetData(&self, aTransferable: *const nsITransferable, anOwner: *const nsIClipboardOwner, aWhichClipboard:  u32, aSettingWindowContext: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).SetData)(self, aTransferable, anOwner, aWhichClipboard, aSettingWindowContext)
    }


    /// ```text
    /// /**
    ///      * Requests setting data to the native clipboard. The actual set occurs
    ///      * when the data is provided by calling nsIAsyncSetClipboardData::setData().
    ///      * The result will be notified by nsIClipboardCallback. A new set request
    ///      * will cancel any prior pending requests, if any exist.
    ///      *
    ///      * @param  aWhichClipboard
    ///      *         Specifies the clipboard to which this operation applies.
    ///      * @param  aSettingWindowContext [optional]
    ///      *         The window context that is setting the clipboard, if any. This is used
    ///      *         to possibly bypass Content Analysis if a set clipboard and get clipboard
    ///      *         operation are done on the same page.
    ///      * @param  aCallback [optional]
    ///      *         The callback object that will be notified upon completion.
    ///      * @return nsIAsyncSetClipboardData
    ///      *         The write request object. The actual write will occur when the
    ///      *         data is provided by calling nsIAsyncSetClipboardData::setData().
    ///      */
    /// ```
    ///

    /// `nsIAsyncSetClipboardData asyncSetData (in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aSettingWindowContext, [optional] in nsIAsyncClipboardRequestCallback aCallback);`
    #[inline]
    pub unsafe fn AsyncSetData(&self, aWhichClipboard:  u32, aSettingWindowContext: *const libc::c_void, aCallback: *const nsIAsyncClipboardRequestCallback, _retval: *mut *const nsIAsyncSetClipboardData) -> ::nserror::nsresult {
        ((*self.vtable).AsyncSetData)(self, aWhichClipboard, aSettingWindowContext, aCallback, _retval)
    }


    /// ```text
    /// /**
    ///     * Filters the flavors aTransferable can import (see
        ///     * `nsITransferable::flavorsTransferableCanImport`) and gets the data for the
    ///     * first available flavor. That data is set for aTransferable.
    ///     *
    ///     * @param  aTransferable The transferable
    ///     * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    ///     * @param  aRequestingWindowContext [optional]
    ///     *         The window context window that is requesting the clipboard, which is
    ///     *         used for content analysis. Passing null means that the content is
    ///     *         exempt from content analysis. (for example, scripted clipboard read by
        ///     *         system code) This parameter should not be null when calling this from a
    ///     *         content process.
    ///     * @result NS_OK if no errors
    ///     */
    /// ```
    ///

    /// `void getData (in nsITransferable aTransferable, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aRequestingWindowContext);`
    #[inline]
    pub unsafe fn GetData(&self, aTransferable: *const nsITransferable, aWhichClipboard:  u32, aRequestingWindowContext: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetData)(self, aTransferable, aWhichClipboard, aRequestingWindowContext)
    }


    /// ```text
    /// /**
    ///      * Requests getting data asynchronously from the native clipboard. This does
    ///      * not actually retrieve the data, but returns a nsIAsyncGetClipboardData
    ///      * contains current avaiable data formats. If the native clipboard is
    ///      * updated, either by us or other application, the existing
    ///      * nsIAsyncGetClipboardData becomes invalid.
    ///      *
    ///      * @param  aFlavorList
    ///      *         Specific data formats ('flavors') that can be retrieved from the
    ///      *         clipboard.
    ///      * @param  aWhichClipboard
    ///      *         Specifies the clipboard to which this operation applies.
    ///      * @param  aCallback
    ///      *         The callback object that will be notified upon completion.
    ///      * @result NS_OK if no errors
    ///      */
    /// ```
    ///

    /// `void getDataSnapshot (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard, in WindowContext aRequestingWindowContext, in nsIPrincipal aRequestingPrincipal, in nsIClipboardGetDataSnapshotCallback aCallback);`
    #[inline]
    pub unsafe fn GetDataSnapshot(&self, aFlavorList: *const thin_vec::ThinVec<::nsstring::nsCString>, aWhichClipboard:  u32, aRequestingWindowContext: *const libc::c_void, aRequestingPrincipal: *const nsIPrincipal, aCallback: *const nsIClipboardGetDataSnapshotCallback) -> ::nserror::nsresult {
        ((*self.vtable).GetDataSnapshot)(self, aFlavorList, aWhichClipboard, aRequestingWindowContext, aRequestingPrincipal, aCallback)
    }


    /// ```text
    /// /**
    ///      * Requests getting data from the native clipboard. This does not actually
    ///      * retreive the data, but returns a nsIAsyncGetClipboardData contains
    ///      * current avaiable data formats. If the native clipboard is updated, either
    ///      * by us or other application, the existing nsIAsyncGetClipboardData becomes
    ///      * invalid.
    ///      *
    ///      * @param  aFlavorList
    ///      *         Specific data formats ('flavors') that can be retrieved from the
    ///      *         clipboard.
    ///      * @param  aWhichClipboard
    ///      *         Specifies the clipboard to which this operation applies.
    ///      * @param  aRequestingWindowContext [optional]
    ///      *         The window context window that is requesting the clipboard, which is
    ///      *         used for content analysis. Passing null means that the content is
    ///      *         exempt from content analysis. (for example, scripted clipboard read by
        ///      *         system code) This parameter should not be null when calling this from a
    ///      *         content process.
    ///      * @return nsIAsyncSetClipboardData if successful.
    ///      * @throws if the request can not be made.
    ///      */
    /// ```
    ///

    /// `nsIClipboardDataSnapshot getDataSnapshotSync (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard, [optional] in WindowContext aRequestingWindowContext);`
    #[inline]
    pub unsafe fn GetDataSnapshotSync(&self, aFlavorList: *const thin_vec::ThinVec<::nsstring::nsCString>, aWhichClipboard:  u32, aRequestingWindowContext: *const libc::c_void, _retval: *mut *const nsIClipboardDataSnapshot) -> ::nserror::nsresult {
        ((*self.vtable).GetDataSnapshotSync)(self, aFlavorList, aWhichClipboard, aRequestingWindowContext, _retval)
    }


    /// ```text
    /// /**
    ///     * This empties the clipboard and notifies the clipboard owner.
    ///     * This empties the "logical" clipboard. It does not clear the native clipboard.
    ///     *
    ///     * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    ///     * @result NS_OK if successful.
    ///     */
    /// ```
    ///

    /// `void emptyClipboard (in nsIClipboard_ClipboardType aWhichClipboard);`
    #[inline]
    pub unsafe fn EmptyClipboard(&self, aWhichClipboard:  u32) -> ::nserror::nsresult {
        ((*self.vtable).EmptyClipboard)(self, aWhichClipboard)
    }


    /// ```text
    /// /**
    ///     * This provides a way to give correct UI feedback about, for instance, a paste
    ///     * should be allowed. It does _NOT_ actually retreive the data and should be a very
    ///     * inexpensive call. All it does is check if there is data on the clipboard matching
    ///     * any of the flavors in the given list.
    ///     *
    ///     * @param  aFlavorList     An array of ASCII strings.
    ///     * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    ///     * @outResult - if data is present matching one of
    ///     * @result NS_OK if successful.
    ///     */
    /// ```
    ///

    /// `boolean hasDataMatchingFlavors (in Array<ACString> aFlavorList, in nsIClipboard_ClipboardType aWhichClipboard);`
    #[inline]
    pub unsafe fn HasDataMatchingFlavors(&self, aFlavorList: *const thin_vec::ThinVec<::nsstring::nsCString>, aWhichClipboard:  u32, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).HasDataMatchingFlavors)(self, aFlavorList, aWhichClipboard, _retval)
    }


    /// ```text
    /// /**
    ///      * Allows clients to determine if the implementation supports the concept of a
    ///      * separate clipboard.
    ///      *
    ///      * @param aWhichClipboard  Specifies the clipboard to which this operation applies.
    ///      * @outResult  true if the implementaion supports specific clipboard type.
    ///      * @result  NS_OK if successful.
    ///      */
    /// ```
    ///

    /// `[infallible] boolean isClipboardTypeSupported (in nsIClipboard_ClipboardType aWhichClipboard);`
    #[inline]
    pub unsafe fn IsClipboardTypeSupported(&self, aWhichClipboard:  u32, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).IsClipboardTypeSupported)(self, aWhichClipboard, _retval)
    }


}


