//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIClipboardHelper.idl
//


/// `interface nsIClipboardHelper : nsISupports`
///

/// ```text
/// /**
///  * helper service for common uses of nsIClipboard.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIClipboardHelper {
    vtable: &'static nsIClipboardHelperVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIClipboardHelper.
unsafe impl XpCom for nsIClipboardHelper {
    const IID: nsIID = nsID(0x438307fd, 0x0c68, 0x4d79,
        [0x92, 0x2a, 0xf6, 0xcc, 0x95, 0x50, 0xcd, 0x02]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIClipboardHelper {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIClipboardHelper.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIClipboardHelperCoerce {
    /// Cheaply cast a value of this type from a `nsIClipboardHelper`.
    fn coerce_from(v: &nsIClipboardHelper) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIClipboardHelperCoerce for nsIClipboardHelper {
    #[inline]
    fn coerce_from(v: &nsIClipboardHelper) -> &Self {
        v
    }
}

impl nsIClipboardHelper {
    /// Cast this `nsIClipboardHelper` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIClipboardHelperCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIClipboardHelper {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIClipboardHelperCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIClipboardHelper) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIClipboardHelper
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIClipboardHelperVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void copyStringToClipboard (in AString aString, in nsIClipboard_ClipboardType aClipboardID, [optional] in WindowContext aSettingWindowContext, [optional, default (NotSensitive)] in nsIClipboardHelper_SensitiveData aSensitive); */
    pub CopyStringToClipboard: unsafe extern "system" fn (this: *const nsIClipboardHelper, aString: *const ::nsstring::nsAString, aClipboardID:  u32, aSettingWindowContext: *const libc::c_void, aSensitive:  u8) -> ::nserror::nsresult,

    /* void copyString (in AString aString, [optional] in WindowContext aSettingWindowContext, [optional, default (NotSensitive)] in nsIClipboardHelper_SensitiveData aSensitive); */
    pub CopyString: unsafe extern "system" fn (this: *const nsIClipboardHelper, aString: *const ::nsstring::nsAString, aSettingWindowContext: *const libc::c_void, aSensitive:  u8) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIClipboardHelper {

    pub const NotSensitive:  u8 = 0;


    pub const Sensitive:  u8 = 1;

    /// ```text
    /// /**
    ///    * copy string to given clipboard
    ///    *
    ///    * @param aString, the string to copy to the clipboard
    ///    * @param aClipboardID, the ID of the clipboard to copy to
    ///    *        (eg. kSelectionClipboard -- see nsIClipboard.idl)
    ///    * @param aSettingWindowContext
    ///    *         The window context that is setting the clipboard, if any. This is used
    ///    *         to possibly bypass Content Analysis if a set clipboard and get clipboard
    ///    *         operation are done on the same page.
    ///    * @param aSensitive, optional flag to indicate that data is sensitive, like a password.
    ///    *        That will exclude data from Cloud Clipboard/Clipboard History on Windows.
    ///    */
    /// ```
    ///

    /// `void copyStringToClipboard (in AString aString, in nsIClipboard_ClipboardType aClipboardID, [optional] in WindowContext aSettingWindowContext, [optional, default (NotSensitive)] in nsIClipboardHelper_SensitiveData aSensitive);`
    #[inline]
    pub unsafe fn CopyStringToClipboard(&self, aString: *const ::nsstring::nsAString, aClipboardID:  u32, aSettingWindowContext: *const libc::c_void, aSensitive:  u8) -> ::nserror::nsresult {
        ((*self.vtable).CopyStringToClipboard)(self, aString, aClipboardID, aSettingWindowContext, aSensitive)
    }


    /// ```text
    /// /**
    ///    * copy string to (default) clipboard
    ///    *
    ///    * @param aString, the string to copy to the clipboard
    ///    * @param aSettingWindowContext
    ///    *         The window context that is setting the clipboard, if any. This is used
    ///    *         to possibly bypass Content Analysis if a set clipboard and get clipboard
    ///    *         operation are done on the same page.
    ///    * @param aSensitive, optional flag to indicate that data is sensitive, like a password.
    ///    *        That will exclude data from Cloud Clipboard/Clipboard History on Windows.
    ///    */
    /// ```
    ///

    /// `void copyString (in AString aString, [optional] in WindowContext aSettingWindowContext, [optional, default (NotSensitive)] in nsIClipboardHelper_SensitiveData aSensitive);`
    #[inline]
    pub unsafe fn CopyString(&self, aString: *const ::nsstring::nsAString, aSettingWindowContext: *const libc::c_void, aSensitive:  u8) -> ::nserror::nsresult {
        ((*self.vtable).CopyString)(self, aString, aSettingWindowContext, aSensitive)
    }


}


