//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/dom/base/nsIContentPolicy.idl
//


/// `interface nsIContentPolicy : nsISupports`
///

/// ```text
/// /**
///  * Interface for content policy mechanism.  Implementations of this
///  * interface can be used to control loading of various types of out-of-line
///  * content, or processing of certain types of in-line content.
///  *
///  * WARNING: do not block the caller from shouldLoad or shouldProcess (e.g.,
    ///  * by launching a dialog to prompt the user for something).
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIContentPolicy {
    vtable: &'static nsIContentPolicyVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIContentPolicy.
unsafe impl XpCom for nsIContentPolicy {
    const IID: nsIID = nsID(0xcaad4f1f, 0xd047, 0x46ac,
        [0xae, 0x9d, 0xdc, 0x59, 0x8e, 0x4f, 0xb9, 0x1b]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIContentPolicy {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIContentPolicy.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIContentPolicyCoerce {
    /// Cheaply cast a value of this type from a `nsIContentPolicy`.
    fn coerce_from(v: &nsIContentPolicy) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIContentPolicyCoerce for nsIContentPolicy {
    #[inline]
    fn coerce_from(v: &nsIContentPolicy) -> &Self {
        v
    }
}

impl nsIContentPolicy {
    /// Cast this `nsIContentPolicy` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIContentPolicyCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIContentPolicy {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIContentPolicyCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIContentPolicy) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIContentPolicy
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIContentPolicyVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* short shouldLoad (in nsIURI aContentLocation, in nsILoadInfo aLoadInfo); */
    pub ShouldLoad: unsafe extern "system" fn (this: *const nsIContentPolicy, aContentLocation: *const nsIURI, aLoadInfo: *const nsILoadInfo, _retval: *mut i16) -> ::nserror::nsresult,

    /* short shouldProcess (in nsIURI aContentLocation, in nsILoadInfo aLoadInfo); */
    pub ShouldProcess: unsafe extern "system" fn (this: *const nsIContentPolicy, aContentLocation: *const nsIURI, aLoadInfo: *const nsILoadInfo, _retval: *mut i16) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIContentPolicy {

    pub const TYPE_INVALID:  u8 = 0;


    pub const TYPE_OTHER:  u8 = 1;


    pub const TYPE_SCRIPT:  u8 = 2;


    pub const TYPE_IMAGE:  u8 = 3;


    pub const TYPE_STYLESHEET:  u8 = 4;


    pub const TYPE_OBJECT:  u8 = 5;


    pub const TYPE_DOCUMENT:  u8 = 6;


    pub const TYPE_SUBDOCUMENT:  u8 = 7;


    pub const TYPE_PING:  u8 = 10;


    pub const TYPE_XMLHTTPREQUEST:  u8 = 11;


    pub const TYPE_DTD:  u8 = 13;


    pub const TYPE_FONT:  u8 = 14;


    pub const TYPE_MEDIA:  u8 = 15;


    pub const TYPE_WEBSOCKET:  u8 = 16;


    pub const TYPE_CSP_REPORT:  u8 = 17;


    pub const TYPE_XSLT:  u8 = 18;


    pub const TYPE_BEACON:  u8 = 19;


    pub const TYPE_FETCH:  u8 = 20;


    pub const TYPE_IMAGESET:  u8 = 21;


    pub const TYPE_WEB_MANIFEST:  u8 = 22;


    pub const TYPE_INTERNAL_SCRIPT:  u8 = 23;


    pub const TYPE_INTERNAL_WORKER:  u8 = 24;


    pub const TYPE_INTERNAL_SHARED_WORKER:  u8 = 25;


    pub const TYPE_INTERNAL_EMBED:  u8 = 26;


    pub const TYPE_INTERNAL_OBJECT:  u8 = 27;


    pub const TYPE_INTERNAL_FRAME:  u8 = 28;


    pub const TYPE_INTERNAL_IFRAME:  u8 = 29;


    pub const TYPE_INTERNAL_AUDIO:  u8 = 30;


    pub const TYPE_INTERNAL_VIDEO:  u8 = 31;


    pub const TYPE_INTERNAL_TRACK:  u8 = 32;


    pub const TYPE_INTERNAL_XMLHTTPREQUEST_ASYNC:  u8 = 33;


    pub const TYPE_INTERNAL_EVENTSOURCE:  u8 = 34;


    pub const TYPE_INTERNAL_SERVICE_WORKER:  u8 = 35;


    pub const TYPE_INTERNAL_SCRIPT_PRELOAD:  u8 = 36;


    pub const TYPE_INTERNAL_IMAGE:  u8 = 37;


    pub const TYPE_INTERNAL_IMAGE_PRELOAD:  u8 = 38;


    pub const TYPE_INTERNAL_STYLESHEET:  u8 = 39;


    pub const TYPE_INTERNAL_STYLESHEET_PRELOAD:  u8 = 40;


    pub const TYPE_INTERNAL_IMAGE_FAVICON:  u8 = 41;


    pub const TYPE_INTERNAL_WORKER_IMPORT_SCRIPTS:  u8 = 42;


    pub const TYPE_SAVEAS_DOWNLOAD:  u8 = 43;


    pub const TYPE_SPECULATIVE:  u8 = 44;


    pub const TYPE_INTERNAL_MODULE:  u8 = 45;


    pub const TYPE_INTERNAL_MODULE_PRELOAD:  u8 = 46;


    pub const TYPE_INTERNAL_DTD:  u8 = 47;


    pub const TYPE_INTERNAL_FORCE_ALLOWED_DTD:  u8 = 48;


    pub const TYPE_INTERNAL_AUDIOWORKLET:  u8 = 49;


    pub const TYPE_INTERNAL_PAINTWORKLET:  u8 = 50;


    pub const TYPE_INTERNAL_FONT_PRELOAD:  u8 = 51;


    pub const TYPE_INTERNAL_CHROMEUTILS_COMPILED_SCRIPT:  u8 = 52;


    pub const TYPE_INTERNAL_FRAME_MESSAGEMANAGER_SCRIPT:  u8 = 53;


    pub const TYPE_INTERNAL_FETCH_PRELOAD:  u8 = 54;


    pub const TYPE_UA_FONT:  u8 = 55;


    pub const TYPE_PROXIED_WEBRTC_MEDIA:  u8 = 56;


    pub const TYPE_WEB_IDENTITY:  u8 = 57;


    pub const TYPE_INTERNAL_WORKER_STATIC_MODULE:  u8 = 58;


    pub const TYPE_WEB_TRANSPORT:  u8 = 59;


    pub const TYPE_INTERNAL_XMLHTTPREQUEST_SYNC:  u8 = 60;


    pub const TYPE_INTERNAL_EXTERNAL_RESOURCE:  u8 = 61;


    pub const TYPE_JSON:  u8 = 62;


    pub const TYPE_INTERNAL_JSON_PRELOAD:  u8 = 63;


    pub const TYPE_END:  u8 = 64;

    /// ```text
    /// /**
    ///    * Returned from shouldLoad or shouldProcess if the load or process request
    ///    * is rejected based on details of the request.
    ///    */
    /// ```
    ///

    pub const REJECT_REQUEST: i16 = -1;

    /// ```text
    /// /**
    ///    * Returned from shouldLoad or shouldProcess if the load/process is rejected
    ///    * based solely on its type (of the above flags).
    ///    *
    ///    * NOTE that it is not meant to stop future requests for this type--only the
    ///    * current request.
    ///    */
    /// ```
    ///

    pub const REJECT_TYPE: i16 = -2;

    /// ```text
    /// /**
    ///    * Returned from shouldLoad or shouldProcess if the load/process is rejected
    ///    * based on the server it is hosted on or requested from (aContentLocation or
        ///    * aRequestOrigin), e.g., if you block an IMAGE because it is served from
    ///    * goatse.cx (even if you don't necessarily block other types from that
        ///    * server/domain).
    ///    *
    ///    * NOTE that it is not meant to stop future requests for this server--only the
    ///    * current request.
    ///    */
    /// ```
    ///

    pub const REJECT_SERVER: i16 = -3;

    /// ```text
    /// /**
    ///    * Returned from shouldLoad or shouldProcess if the load/process is rejected
    ///    * based on some other criteria. Mozilla callers will handle this like
    ///    * REJECT_REQUEST; third-party implementors may, for example, use this to
    ///    * direct their own callers to consult the extra parameter for additional
    ///    * details.
    ///    */
    /// ```
    ///

    pub const REJECT_OTHER: i16 = -4;

    /// ```text
    /// /**
    ///    * Returned from shouldLoad or shouldProcess if the load/process is forbiddden
    ///    * based on enterprise policy.
    ///    */
    /// ```
    ///

    pub const REJECT_POLICY: i16 = -5;

    /// ```text
    /// /**
    ///    * Returned from shouldLoad or shouldProcess if the load or process request
    ///    * is not rejected.
    ///    */
    /// ```
    ///

    pub const ACCEPT: i16 = 1;

    /// ```text
    /// /**
    ///    * Should the resource at this location be loaded?
    ///    * ShouldLoad will be called before loading the resource at aContentLocation
    ///    * to determine whether to start the load at all.
    ///    *
    ///    * @param aContentLocation  the location of the content being checked; must
    ///    *                          not be null
    ///    *
    ///    * @param aLoadInfo         the loadinfo of the channel being evaluated.
    ///    *
    ///    * @return ACCEPT or REJECT_*
    ///    *
    ///    * @note shouldLoad can be called while the DOM and layout of the document
    ///    * involved is in an inconsistent state.  This means that implementors of
    ///    * this method MUST NOT do any of the following:
    ///    * 1)  Modify the DOM in any way (e.g. setting attributes is a no-no).
///    * 2)  Query any DOM properties that depend on layout (e.g. offset*
///    *     properties).
///    * 3)  Query any DOM properties that depend on style (e.g. computed style).
///    * 4)  Query any DOM properties that depend on the current state of the DOM
///    *     outside the "context" node (e.g. lengths of node lists).
///    * 5)  [JavaScript implementations only] Access properties of any sort on any
///    *     object without using XPCNativeWrapper (either explicitly or
///    *     implicitly).  Due to various DOM0 things, this leads to item 4.
///    * If you do any of these things in your shouldLoad implementation, expect
///    * unpredictable behavior, possibly including crashes, content not showing
///    * up, content showing up doubled, etc.  If you need to do any of the things
///    * above, do them off timeout or event.
///    */
/// ```
///

/// `short shouldLoad (in nsIURI aContentLocation, in nsILoadInfo aLoadInfo);`
#[inline]
pub unsafe fn ShouldLoad(&self, aContentLocation: *const nsIURI, aLoadInfo: *const nsILoadInfo, _retval: *mut i16) -> ::nserror::nsresult {
((*self.vtable).ShouldLoad)(self, aContentLocation, aLoadInfo, _retval)
}


/// ```text
/// /**
///    * Should the resource be processed?
///    * ShouldProcess will be called once all the information passed to it has
///    * been determined about the resource, typically after part of the resource
///    * has been loaded.
///    *
///    * @param aContentLocation  OPTIONAL; the location of the resource being
///    *                          requested: MAY be, e.g., a post-redirection URI
///    *                          for the resource.
///    *
///    * @param aLoadInfo         the loadinfo of the channel being evaluated.
///    *
///    * @return ACCEPT or REJECT_*
///    *
///    * @note shouldProcess can be called while the DOM and layout of the document
///    * involved is in an inconsistent state.  See the note on shouldLoad to see
///    * what this means for implementors of this method.
///    */
/// ```
///

/// `short shouldProcess (in nsIURI aContentLocation, in nsILoadInfo aLoadInfo);`
#[inline]
pub unsafe fn ShouldProcess(&self, aContentLocation: *const nsIURI, aLoadInfo: *const nsILoadInfo, _retval: *mut i16) -> ::nserror::nsresult {
((*self.vtable).ShouldProcess)(self, aContentLocation, aLoadInfo, _retval)
}


}


/// `typedef nsIContentPolicy::nsContentPolicyType  nsContentPolicyType;`
///


pub type nsContentPolicyType =  u8;


