//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/dom/interfaces/security/nsIContentSecurityPolicy.idl
//


/// `interface nsIContentSecurityPolicy : nsISerializable`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIContentSecurityPolicy {
    vtable: &'static nsIContentSecurityPolicyVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIContentSecurityPolicy.
unsafe impl XpCom for nsIContentSecurityPolicy {
    const IID: nsIID = nsID(0x1d632008, 0x6c97, 0x48ae,
        [0xa5, 0x1c, 0x16, 0xe2, 0xda, 0xa0, 0xf4, 0xf6]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIContentSecurityPolicy {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIContentSecurityPolicy.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIContentSecurityPolicyCoerce {
    /// Cheaply cast a value of this type from a `nsIContentSecurityPolicy`.
    fn coerce_from(v: &nsIContentSecurityPolicy) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIContentSecurityPolicyCoerce for nsIContentSecurityPolicy {
    #[inline]
    fn coerce_from(v: &nsIContentSecurityPolicy) -> &Self {
        v
    }
}

impl nsIContentSecurityPolicy {
    /// Cast this `nsIContentSecurityPolicy` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIContentSecurityPolicyCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIContentSecurityPolicy {
    type Target = nsISerializable;
    #[inline]
    fn deref(&self) -> &nsISerializable {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISerializableCoerce> nsIContentSecurityPolicyCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIContentSecurityPolicy) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIContentSecurityPolicy
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIContentSecurityPolicyVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISerializableVTable,

    /* [binaryname(GetPolicyString)] AString getPolicy (in unsigned long index); */
    pub GetPolicyString: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, index: u32, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* [noscript,nostdcall,notxpcom] CSPPolicyPtr GetPolicy (in unsigned long index); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub GetPolicy: *const ::libc::c_void,

    /* readonly attribute unsigned long policyCount; */
    pub GetPolicyCount: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aPolicyCount: *mut u32) -> ::nserror::nsresult,

    /* readonly attribute boolean upgradeInsecureRequests; */
    pub GetUpgradeInsecureRequests: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aUpgradeInsecureRequests: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean blockAllMixedContent; */
    pub GetBlockAllMixedContent: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aBlockAllMixedContent: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean enforcesFrameAncestors; */
    pub GetEnforcesFrameAncestors: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aEnforcesFrameAncestors: *mut bool) -> ::nserror::nsresult,

    /* void appendPolicy (in AString policyString, in boolean reportOnly, in boolean deliveredViaMetaTag); */
    pub AppendPolicy: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, policyString: *const ::nsstring::nsAString, reportOnly: bool, deliveredViaMetaTag: bool) -> ::nserror::nsresult,

    /* [infallible] readonly attribute nsIContentSecurityPolicy_RequireTrustedTypesForDirectiveState requireTrustedTypesForDirectiveState; */
    pub GetRequireTrustedTypesForDirectiveState: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aRequireTrustedTypesForDirectiveState: *mut u8) -> ::nserror::nsresult,

    /* boolean getAllowsInline (in nsIContentSecurityPolicy_CSPDirective aDirective, in boolean aHasUnsafeHash, in AString aNonce, in boolean aParserCreated, in Element aTriggeringElement, in nsICSPEventListener aCSPEventListener, in AString aSourceText, in unsigned long aLineNumber, in unsigned long aColumnNumber); */
    pub GetAllowsInline: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aDirective:  u8, aHasUnsafeHash: bool, aNonce: *const ::nsstring::nsAString, aParserCreated: bool, aTriggeringElement: *const libc::c_void, aCSPEventListener: *const nsICSPEventListener, aSourceText: *const ::nsstring::nsAString, aLineNumber: u32, aColumnNumber: u32, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean getAllowsEval (out boolean shouldReportViolations); */
    pub GetAllowsEval: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, shouldReportViolations: *mut bool, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean getAllowsWasmEval (out boolean shouldReportViolations); */
    pub GetAllowsWasmEval: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, shouldReportViolations: *mut bool, _retval: *mut bool) -> ::nserror::nsresult,

    /* uint32_t getCSPSandboxFlags (); */
    pub GetCSPSandboxFlags: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, _retval: *mut u32) -> ::nserror::nsresult,

    /* void logViolationDetails (in unsigned short violationType, in Element triggeringElement, in nsICSPEventListener aCSPEventListener, in ACString sourceFile, in AString scriptSample, in int32_t lineNum, in int32_t columnNum, [optional] in AString nonce, [optional] in AString content); */
    pub LogViolationDetails: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, violationType: u16, triggeringElement: *const libc::c_void, aCSPEventListener: *const nsICSPEventListener, sourceFile: *const ::nsstring::nsACString, scriptSample: *const ::nsstring::nsAString, lineNum: i32, columnNum: i32, nonce: *const ::nsstring::nsAString, content: *const ::nsstring::nsAString) -> ::nserror::nsresult,

    /* [noscript] void logTrustedTypesViolationDetailsUnchecked (in CSPViolationData aCSPViolationData, in AString aObserverSubject, in nsICSPEventListener aCSPEventListener); */
    /// Unable to generate binding because `Rust only supports [ref] / [ptr] native types`
    pub LogTrustedTypesViolationDetailsUnchecked: *const ::libc::c_void,

    /* [must_use] void setRequestContextWithDocument (in Document aDocument); */
    pub SetRequestContextWithDocument: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aDocument: *const libc::c_void) -> ::nserror::nsresult,

    /* [must_use] void setRequestContextWithPrincipal (in nsIPrincipal aRequestPrincipal, in nsIURI aSelfURI, in ACString aReferrer, in unsigned long long aInnerWindowId); */
    pub SetRequestContextWithPrincipal: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aRequestPrincipal: *const nsIPrincipal, aSelfURI: *const nsIURI, aReferrer: *const ::nsstring::nsACString, aInnerWindowId: u64) -> ::nserror::nsresult,

    /* [noscript,nostdcall,notxpcom] readonly attribute nsIPrincipal requestPrincipal; */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub GetRequestPrincipal: *const ::libc::c_void,

    /* [noscript,nostdcall,notxpcom] readonly attribute nsIURI selfURI; */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub GetSelfURI: *const ::libc::c_void,

    /* [noscript] readonly attribute ACString referrer; */
    pub GetReferrer: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aReferrer: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [noscript,nostdcall,notxpcom] readonly attribute unsigned long long innerWindowID; */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub GetInnerWindowID: *const ::libc::c_void,

    /* [noscript,nostdcall,notxpcom] attribute boolean skipAllowInlineStyleCheck; */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub GetSkipAllowInlineStyleCheck: *const ::libc::c_void,

    /* [noscript,nostdcall,notxpcom] attribute boolean skipAllowInlineStyleCheck; */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub SetSkipAllowInlineStyleCheck: *const ::libc::c_void,

    /* [noscript] void ensureEventTarget (in nsIEventTarget aEventTarget); */
    pub EnsureEventTarget: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aEventTarget: *const nsIEventTarget) -> ::nserror::nsresult,

    /* boolean permitsAncestry (in nsILoadInfo aLoadInfo); */
    pub PermitsAncestry: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aLoadInfo: *const nsILoadInfo, _retval: *mut bool) -> ::nserror::nsresult,

    /* boolean permits (in Element aTriggeringElement, in nsICSPEventListener aCSPEventListener, in nsIURI aURI, in nsIContentSecurityPolicy_CSPDirective aDir, in boolean aSpecific, in boolean aSendViolationReports); */
    pub Permits: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aTriggeringElement: *const libc::c_void, aCSPEventListener: *const nsICSPEventListener, aURI: *const nsIURI, aDir:  u8, aSpecific: bool, aSendViolationReports: bool, _retval: *mut bool) -> ::nserror::nsresult,

    /* short shouldLoad (in nsContentPolicyType aContentType, in nsICSPEventListener aCSPEventListener, in nsILoadInfo aLoadInfo, in nsIURI aContentLocation, in nsIURI aOriginalURIIfRedirect, in boolean aSendViolationReports); */
    pub ShouldLoad: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, aContentType: nsContentPolicyType, aCSPEventListener: *const nsICSPEventListener, aLoadInfo: *const nsILoadInfo, aContentLocation: *const nsIURI, aOriginalURIIfRedirect: *const nsIURI, aSendViolationReports: bool, _retval: *mut i16) -> ::nserror::nsresult,

    /* AString toJSON (); */
    pub ToJSON: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* [noscript] void EnsureIPCPoliciesRead (); */
    pub EnsureIPCPoliciesRead: unsafe extern "system" fn (this: *const nsIContentSecurityPolicy) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIContentSecurityPolicy {

    pub const NO_DIRECTIVE:  u8 = 0;


    pub const DEFAULT_SRC_DIRECTIVE:  u8 = 1;


    pub const SCRIPT_SRC_DIRECTIVE:  u8 = 2;


    pub const OBJECT_SRC_DIRECTIVE:  u8 = 3;


    pub const STYLE_SRC_DIRECTIVE:  u8 = 4;


    pub const IMG_SRC_DIRECTIVE:  u8 = 5;


    pub const MEDIA_SRC_DIRECTIVE:  u8 = 6;


    pub const FRAME_SRC_DIRECTIVE:  u8 = 7;


    pub const FONT_SRC_DIRECTIVE:  u8 = 8;


    pub const CONNECT_SRC_DIRECTIVE:  u8 = 9;


    pub const REPORT_URI_DIRECTIVE:  u8 = 10;


    pub const FRAME_ANCESTORS_DIRECTIVE:  u8 = 11;


    pub const REFLECTED_XSS_DIRECTIVE:  u8 = 12;


    pub const BASE_URI_DIRECTIVE:  u8 = 13;


    pub const FORM_ACTION_DIRECTIVE:  u8 = 14;


    pub const WEB_MANIFEST_SRC_DIRECTIVE:  u8 = 15;


    pub const UPGRADE_IF_INSECURE_DIRECTIVE:  u8 = 16;


    pub const CHILD_SRC_DIRECTIVE:  u8 = 17;


    pub const BLOCK_ALL_MIXED_CONTENT:  u8 = 18;


    pub const SANDBOX_DIRECTIVE:  u8 = 19;


    pub const WORKER_SRC_DIRECTIVE:  u8 = 20;


    pub const SCRIPT_SRC_ELEM_DIRECTIVE:  u8 = 21;


    pub const SCRIPT_SRC_ATTR_DIRECTIVE:  u8 = 22;


    pub const STYLE_SRC_ELEM_DIRECTIVE:  u8 = 23;


    pub const STYLE_SRC_ATTR_DIRECTIVE:  u8 = 24;


    pub const REQUIRE_TRUSTED_TYPES_FOR_DIRECTIVE:  u8 = 25;


    pub const TRUSTED_TYPES_DIRECTIVE:  u8 = 26;


    pub const REPORT_TO_DIRECTIVE:  u8 = 27;


    pub const NONE:  u8 = 0;


    pub const REPORT_ONLY:  u8 = 1;


    pub const ENFORCE:  u8 = 2;


    pub const VIOLATION_TYPE_EVAL: u16 = 1;


    pub const VIOLATION_TYPE_WASM_EVAL: u16 = 2;

    /// ```text
    /// /**
    ///    * Accessor method for a read-only string version of the policy at a given
    ///    * index.
    ///    */
    /// ```
    ///

    /// `[binaryname(GetPolicyString)] AString getPolicy (in unsigned long index);`
    #[inline]
    pub unsafe fn GetPolicyString(&self, index: u32, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetPolicyString)(self, index, _retval)
    }


    /// ```text
    /// /**
    ///    * Accessor method for a read-only pointer the policy object at a given
    ///    * index. Returns a null pointer if the index is larger than the current
    ///    * policy count.
    ///    */
    /// ```
    ///

    /// `[noscript,nostdcall,notxpcom] CSPPolicyPtr GetPolicy (in unsigned long index);`
    const _GetPolicy: () = ();

    /// ```text
    /// /**
    ///    * Returns the number of policies attached to this CSP instance.  Useful with
    ///    * getPolicy().
    ///    */
    /// ```
    ///

    /// `readonly attribute unsigned long policyCount;`
    #[inline]
    pub unsafe fn GetPolicyCount(&self, aPolicyCount: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).GetPolicyCount)(self, aPolicyCount)
    }


    /// ```text
    /// /**
    ///    * Returns whether this policy uses the directive upgrade-insecure-requests.
    ///    * Please note that upgrade-insecure-reqeusts also applies if the parent or
    ///    * including document (context) makes use of the directive.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean upgradeInsecureRequests;`
    #[inline]
    pub unsafe fn GetUpgradeInsecureRequests(&self, aUpgradeInsecureRequests: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetUpgradeInsecureRequests)(self, aUpgradeInsecureRequests)
    }


    /// ```text
    /// /**
    ///    * Returns whether this policy uses the directive block-all-mixed-content.
    ///    * Please note that block-all-mixed-content takes presedence in case the
    ///    * directive upgrade-insecure-requests is defined in the same policy and
    ///    * will therefore block all mixed content without even trying to perform
    ///    * an upgrade.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean blockAllMixedContent;`
    #[inline]
    pub unsafe fn GetBlockAllMixedContent(&self, aBlockAllMixedContent: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetBlockAllMixedContent)(self, aBlockAllMixedContent)
    }


    /// ```text
    /// /**
    ///    * Returns whether this policy enforces the frame-ancestors directive.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean enforcesFrameAncestors;`
    #[inline]
    pub unsafe fn GetEnforcesFrameAncestors(&self, aEnforcesFrameAncestors: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetEnforcesFrameAncestors)(self, aEnforcesFrameAncestors)
    }


    /// ```text
    /// /**
    ///    * Parse and install a CSP policy.
    ///    * @param aPolicy
    ///    *        String representation of the policy
    ///    *        (e.g., header value, meta content)
    ///    * @param reportOnly
    ///    *        Should this policy affect content, script and style processing or
    ///    *        just send reports if it is violated?
    ///    * @param deliveredViaMetaTag
    ///    *        Indicates whether the policy was delivered via the meta tag.
    ///    */
    /// ```
    ///

    /// `void appendPolicy (in AString policyString, in boolean reportOnly, in boolean deliveredViaMetaTag);`
    #[inline]
    pub unsafe fn AppendPolicy(&self, policyString: *const ::nsstring::nsAString, reportOnly: bool, deliveredViaMetaTag: bool) -> ::nserror::nsresult {
        ((*self.vtable).AppendPolicy)(self, policyString, reportOnly, deliveredViaMetaTag)
    }


    /// ```text
    /// /**
    ///    * Indicate the global state for the require-trusted-types-for directives
    ///    * - NONE: No require-trusted-types-for directives.
    ///    * - REPORT_ONLY: At least one require-trusted-types-for directive, but all
    ///    *   of them have "report" disposition.
    ///    * - ENFORCE: At least one require-trusted-types-for directive with "enforce"
    ///    *   disposition.
    ///    */
    /// ```
    ///

    /// `[infallible] readonly attribute nsIContentSecurityPolicy_RequireTrustedTypesForDirectiveState requireTrustedTypesForDirectiveState;`
    #[inline]
    pub unsafe fn GetRequireTrustedTypesForDirectiveState(&self, aRequireTrustedTypesForDirectiveState: *mut u8) -> ::nserror::nsresult {
        ((*self.vtable).GetRequireTrustedTypesForDirectiveState)(self, aRequireTrustedTypesForDirectiveState)
    }



    /// `boolean getAllowsInline (in nsIContentSecurityPolicy_CSPDirective aDirective, in boolean aHasUnsafeHash, in AString aNonce, in boolean aParserCreated, in Element aTriggeringElement, in nsICSPEventListener aCSPEventListener, in AString aSourceText, in unsigned long aLineNumber, in unsigned long aColumnNumber);`
    #[inline]
    pub unsafe fn GetAllowsInline(&self, aDirective:  u8, aHasUnsafeHash: bool, aNonce: *const ::nsstring::nsAString, aParserCreated: bool, aTriggeringElement: *const libc::c_void, aCSPEventListener: *const nsICSPEventListener, aSourceText: *const ::nsstring::nsAString, aLineNumber: u32, aColumnNumber: u32, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetAllowsInline)(self, aDirective, aHasUnsafeHash, aNonce, aParserCreated, aTriggeringElement, aCSPEventListener, aSourceText, aLineNumber, aColumnNumber, _retval)
    }


    /// ```text
    /// /**
    ///    * Whether this policy allows eval and eval-like functions
    ///    * such as setTimeout("code string", time).
    ///    * @param shouldReportViolations
    ///    *     Whether or not the use of eval should be reported.
    ///    *     This function returns "true" when violating report-only policies, but
    ///    *     when any policy (report-only or otherwise) is violated,
    ///    *     shouldReportViolations is true as well.
    ///    * @return
    ///    *     Whether or not the effects of the eval call should be allowed
    ///    *     (block the call if false).
    ///    */
    /// ```
    ///

    /// `boolean getAllowsEval (out boolean shouldReportViolations);`
    #[inline]
    pub unsafe fn GetAllowsEval(&self, shouldReportViolations: *mut bool, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetAllowsEval)(self, shouldReportViolations, _retval)
    }


    /// ```text
    /// /**
    ///    * Whether this policy allows the evaluation (and compilation) of
    ///    * WASM code from functions like `WebAssembly.compile`.
    ///   * @param shouldReportViolations
    ///    *     Whether or not the use of WASM evaluation should be reported.
    ///    *     This function returns "true" when violating report-only policies, but
    ///    *     when any policy (report-only or otherwise) is violated,
    ///    *     shouldReportViolations is true as well.
    ///    * @return
    ///    *     Whether or not the effects of the WASM evaluation should be allowed
    ///    *     (block the call if false).
    ///    */
    /// ```
    ///

    /// `boolean getAllowsWasmEval (out boolean shouldReportViolations);`
    #[inline]
    pub unsafe fn GetAllowsWasmEval(&self, shouldReportViolations: *mut bool, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetAllowsWasmEval)(self, shouldReportViolations, _retval)
    }


    /// ```text
    /// /**
    ///    * Delegate method called by the service when the protected document is loaded.
    ///    * Returns the union of all the sandbox flags contained in CSP policies. This is the most
    ///    * restrictive interpretation of flags set in multiple policies.
    ///    * See nsSandboxFlags.h for the possible flags.
    ///    *
    ///    * @return
    ///    *    sandbox flags or SANDBOXED_NONE if no sandbox directive exists
    ///    */
    /// ```
    ///

    /// `uint32_t getCSPSandboxFlags ();`
    #[inline]
    pub unsafe fn GetCSPSandboxFlags(&self, _retval: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).GetCSPSandboxFlags)(self, _retval)
    }


    /// ```text
    /// /**
    ///    * For each violated policy (of type violationType), log policy violation on
    ///    * the Error Console and send a report to report-uris present in the violated
    ///    * policies.
    ///    *
    ///    * @param violationType
    ///    *     one of the VIOLATION_TYPE_* constants, e.g. eval or wasm-eval
    ///    * @param triggeringElement
    ///    *     the element that triggers this CSP violation. It can be null.
    ///    * @param sourceFile
    ///    *     name of the source file containing the violation (if available)
    ///    * @param contentSample
    ///    *     sample of the violating content (to aid debugging)
    ///    * @param lineNum
    ///    *     source line number of the violation (if available)
    ///    * @param columnNum
    ///    *     source column number of the violation (if available)
    ///    * @param aNonce
    ///    *     (optional) If this is a nonce violation, include the nonce so we can
    ///    *     recheck to determine which policies were violated and send the
    ///    *     appropriate reports.
    ///    * @param aContent
    ///    *     (optional) If this is a hash violation, include contents of the inline
    ///    *     resource in the question so we can recheck the hash in order to
    ///    *     determine which policies were violated and send the appropriate
    ///    *     reports.
    ///    */
    /// ```
    ///

    /// `void logViolationDetails (in unsigned short violationType, in Element triggeringElement, in nsICSPEventListener aCSPEventListener, in ACString sourceFile, in AString scriptSample, in int32_t lineNum, in int32_t columnNum, [optional] in AString nonce, [optional] in AString content);`
    #[inline]
    pub unsafe fn LogViolationDetails(&self, violationType: u16, triggeringElement: *const libc::c_void, aCSPEventListener: *const nsICSPEventListener, sourceFile: *const ::nsstring::nsACString, scriptSample: *const ::nsstring::nsAString, lineNum: i32, columnNum: i32, nonce: *const ::nsstring::nsAString, content: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).LogViolationDetails)(self, violationType, triggeringElement, aCSPEventListener, sourceFile, scriptSample, lineNum, columnNum, nonce, content)
    }


    /// ```text
    /// /**
    ///    * Log violation details for aCSPViolationData's directive. The directive is
    ///    * required to:
    ///    * - be one of the CSP directives corresponding to Trusted Types.
    ///    * - belong to the policy referrenced by aCSPViolationData.
    ///    * No check happens that the policy is indeed violated.
    ///    *
    ///    * Notifies observers, logs on the error console, sends a report (with a code-
        ///    * sample) to the directive's report-uris and may fire a violation event.
    ///    *
    ///    * @param aCSPEventListener Should be null for Windows
    ///    *                          (https://html.spec.whatwg.org/multipage/nav-history-apis.html#window),
    ///    *                          and non-null for Workers.
    ///    */
    /// ```
    ///

    /// `[noscript] void logTrustedTypesViolationDetailsUnchecked (in CSPViolationData aCSPViolationData, in AString aObserverSubject, in nsICSPEventListener aCSPEventListener);`
    const _LogTrustedTypesViolationDetailsUnchecked: () = ();

    /// ```text
    /// /**
    ///    * Called after the CSP object is created to fill in appropriate request
    ///    * context. Either use
    ///    *  * aDocument (preferred), or if no document is available, then provide
    ///    *  * aPrincipal, aSelfURI, aReferrer, aInnerWindowId explicitly.
    ///    */
    /// ```
    ///

    /// `[must_use] void setRequestContextWithDocument (in Document aDocument);`
    #[inline]
    pub unsafe fn SetRequestContextWithDocument(&self, aDocument: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).SetRequestContextWithDocument)(self, aDocument)
    }



    /// `[must_use] void setRequestContextWithPrincipal (in nsIPrincipal aRequestPrincipal, in nsIURI aSelfURI, in ACString aReferrer, in unsigned long long aInnerWindowId);`
    #[inline]
    pub unsafe fn SetRequestContextWithPrincipal(&self, aRequestPrincipal: *const nsIPrincipal, aSelfURI: *const nsIURI, aReferrer: *const ::nsstring::nsACString, aInnerWindowId: u64) -> ::nserror::nsresult {
        ((*self.vtable).SetRequestContextWithPrincipal)(self, aRequestPrincipal, aSelfURI, aReferrer, aInnerWindowId)
    }


    /// ```text
    /// /**
    ///    * Get the various arguments needed to create a new request context for a CSP.
    ///    */
    /// ```
    ///

    /// `[noscript,nostdcall,notxpcom] readonly attribute nsIPrincipal requestPrincipal;`
    const _GetRequestPrincipal: () = ();


    /// `[noscript,nostdcall,notxpcom] readonly attribute nsIURI selfURI;`
    const _GetSelfURI: () = ();


    /// `[noscript] readonly attribute ACString referrer;`
    #[inline]
    pub unsafe fn GetReferrer(&self, aReferrer: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetReferrer)(self, aReferrer)
    }



    /// `[noscript,nostdcall,notxpcom] readonly attribute unsigned long long innerWindowID;`
    const _GetInnerWindowID: () = ();

    /// ```text
    /// /**
    ///    * Warning: Do not set that attribute unless you know exactly what you are doing!
    ///    *
    ///    * Primarily used to allow Devtools to edit inline styles!
    ///    */
    /// ```
    ///

    /// `[noscript,nostdcall,notxpcom] attribute boolean skipAllowInlineStyleCheck;`
    const _GetSkipAllowInlineStyleCheck: () = ();

    /// ```text
    /// /**
    ///    * Warning: Do not set that attribute unless you know exactly what you are doing!
    ///    *
    ///    * Primarily used to allow Devtools to edit inline styles!
    ///    */
    /// ```
    ///

    /// `[noscript,nostdcall,notxpcom] attribute boolean skipAllowInlineStyleCheck;`
    const _SetSkipAllowInlineStyleCheck: () = ();

    /// ```text
    /// /**
    ///    *  Ensure we have a nsIEventTarget to use to label CSPReportSenderRunnable
    ///    */
    /// ```
    ///

    /// `[noscript] void ensureEventTarget (in nsIEventTarget aEventTarget);`
    #[inline]
    pub unsafe fn EnsureEventTarget(&self, aEventTarget: *const nsIEventTarget) -> ::nserror::nsresult {
        ((*self.vtable).EnsureEventTarget)(self, aEventTarget)
    }


    /// ```text
    /// /**
    ///    * Verifies ancestry as permitted by the policy.
    ///    *
    ///    * NOTE: Calls to this may trigger violation reports when queried, so this
    ///    * value should not be cached.
    ///    *
    ///    * @param aLoadInfo
    ///    *    The loadinfo of the channel containing the protected resource
    ///    * @return
    ///    *    true if the frame's ancestors are all allowed by policy (except for
        ///    *    report-only policies, which will send reports and then return true
        ///    *    here when violated).
    ///    */
    /// ```
    ///

    /// `boolean permitsAncestry (in nsILoadInfo aLoadInfo);`
    #[inline]
    pub unsafe fn PermitsAncestry(&self, aLoadInfo: *const nsILoadInfo, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).PermitsAncestry)(self, aLoadInfo, _retval)
    }


    /// ```text
    /// /**
    ///    * Checks if a specific directive permits loading of a URI.
    ///    *
    ///    * @param aTriggeringElement
    ///    *    The element that triggers this CSP check. It can be null.
    ///    * @param aURI
    ///    *    The URI about to be loaded or used.
    ///    * @param aDir
    ///    *    The CSPDirective to query (see above constants *_DIRECTIVE).
    ///    * @param aSpecific
    ///    *    If "true" and the directive is specified to fall back to "default-src"
    ///    *    when it's not explicitly provided, directivePermits will NOT try
    ///    *    default-src when the specific directive is not used.  Setting this to
    ///    *    "false" allows CSP to fall back to default-src.  This function
    ///    *    behaves the same for both values of canUseDefault when querying
    ///    *    directives that don't fall-back.
    ///    * @param aSendViolationReports
    ///    *    If `true` and the uri is not allowed then trigger violation reports.
    ///    *    This should be `false` for caching or preloads.
    ///    * @return
    ///    *    Whether or not the provided URI is allowed by CSP under the given
    ///    *    directive. (block the pending operation if false).
    ///    */
    /// ```
    ///

    /// `boolean permits (in Element aTriggeringElement, in nsICSPEventListener aCSPEventListener, in nsIURI aURI, in nsIContentSecurityPolicy_CSPDirective aDir, in boolean aSpecific, in boolean aSendViolationReports);`
    #[inline]
    pub unsafe fn Permits(&self, aTriggeringElement: *const libc::c_void, aCSPEventListener: *const nsICSPEventListener, aURI: *const nsIURI, aDir:  u8, aSpecific: bool, aSendViolationReports: bool, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).Permits)(self, aTriggeringElement, aCSPEventListener, aURI, aDir, aSpecific, aSendViolationReports, _retval)
    }


    /// ```text
    /// /**
    ///    * Delegate method called by the service when sub-elements of the protected
    ///    * document are being loaded.  Given a bit of information about the request,
    ///    * decides whether or not the policy is satisfied.
    ///    *
    ///    * Calls to this may trigger violation reports when queried, so
    ///    * this value should not be cached.
    ///    *
    ///    * aOriginalURIIfRedirect must be passed only if this loading is the result
    ///    * of a redirect. In this case, aOriginalURIIfRedirect must be the original
    ///    * URL.
    ///    */
    /// ```
    ///

    /// `short shouldLoad (in nsContentPolicyType aContentType, in nsICSPEventListener aCSPEventListener, in nsILoadInfo aLoadInfo, in nsIURI aContentLocation, in nsIURI aOriginalURIIfRedirect, in boolean aSendViolationReports);`
    #[inline]
    pub unsafe fn ShouldLoad(&self, aContentType: nsContentPolicyType, aCSPEventListener: *const nsICSPEventListener, aLoadInfo: *const nsILoadInfo, aContentLocation: *const nsIURI, aOriginalURIIfRedirect: *const nsIURI, aSendViolationReports: bool, _retval: *mut i16) -> ::nserror::nsresult {
        ((*self.vtable).ShouldLoad)(self, aContentType, aCSPEventListener, aLoadInfo, aContentLocation, aOriginalURIIfRedirect, aSendViolationReports, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns the CSP in JSON notation.
    ///    */
    /// ```
    ///

    /// `AString toJSON ();`
    #[inline]
    pub unsafe fn ToJSON(&self, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).ToJSON)(self, _retval)
    }


    /// ```text
    /// /**
    ///    * Ensure policies from IPC are read/parsed.
    ///    */
    /// ```
    ///

    /// `[noscript] void EnsureIPCPoliciesRead ();`
    #[inline]
    pub unsafe fn EnsureIPCPoliciesRead(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).EnsureIPCPoliciesRead)(self, )
    }


}


/// `typedef nsIContentSecurityPolicy::CSPDirective  CSPDirective;`
///


pub type CSPDirective =  u8;


/// `typedef nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState  RequireTrustedTypesForDirectiveState;`
///


pub type RequireTrustedTypesForDirectiveState =  u8;


/// `interface nsICSPEventListener : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICSPEventListener {
    vtable: &'static nsICSPEventListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICSPEventListener.
unsafe impl XpCom for nsICSPEventListener {
    const IID: nsIID = nsID(0xc3163b14, 0x3a8f, 0x46dd,
        [0xa4, 0xaf, 0xbd, 0x04, 0x68, 0x03, 0x64, 0xcd]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICSPEventListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICSPEventListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICSPEventListenerCoerce {
    /// Cheaply cast a value of this type from a `nsICSPEventListener`.
    fn coerce_from(v: &nsICSPEventListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICSPEventListenerCoerce for nsICSPEventListener {
    #[inline]
    fn coerce_from(v: &nsICSPEventListener) -> &Self {
        v
    }
}

impl nsICSPEventListener {
    /// Cast this `nsICSPEventListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICSPEventListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICSPEventListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICSPEventListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICSPEventListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICSPEventListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICSPEventListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onCSPViolationEvent (in AString aJSON); */
    pub OnCSPViolationEvent: unsafe extern "system" fn (this: *const nsICSPEventListener, aJSON: *const ::nsstring::nsAString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICSPEventListener {


    /// `void onCSPViolationEvent (in AString aJSON);`
    #[inline]
    pub unsafe fn OnCSPViolationEvent(&self, aJSON: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).OnCSPViolationEvent)(self, aJSON)
    }


}


