//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/cookiebanners/nsICookieBannerService.idl
//


/// `interface nsICookieBannerService : nsISupports`
///

/// ```text
/// /**
///  * Service singleton which owns the cookie banner feature.
///  * This service owns the cookie banner handling rules.
///  * It initializes both the component for importing rules
///  * (nsICookieBannerListService) and injecting cookies (nsICookieInjector).
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICookieBannerService {
    vtable: &'static nsICookieBannerServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICookieBannerService.
unsafe impl XpCom for nsICookieBannerService {
    const IID: nsIID = nsID(0xeac9cdc4, 0xecee, 0x49f2,
        [0x91, 0xda, 0x76, 0x27, 0xe1, 0x5c, 0x1f, 0x3c]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICookieBannerService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICookieBannerService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICookieBannerServiceCoerce {
    /// Cheaply cast a value of this type from a `nsICookieBannerService`.
    fn coerce_from(v: &nsICookieBannerService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICookieBannerServiceCoerce for nsICookieBannerService {
    #[inline]
    fn coerce_from(v: &nsICookieBannerService) -> &Self {
        v
    }
}

impl nsICookieBannerService {
    /// Cast this `nsICookieBannerService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICookieBannerServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICookieBannerService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICookieBannerServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICookieBannerService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICookieBannerService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICookieBannerServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute boolean isEnabled; */
    pub GetIsEnabled: unsafe extern "system" fn (this: *const nsICookieBannerService, aIsEnabled: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute Array<nsICookieBannerRule> rules; */
    pub GetRules: unsafe extern "system" fn (this: *const nsICookieBannerService, aRules: *mut thin_vec::ThinVec<Option<RefPtr<nsICookieBannerRule>>>) -> ::nserror::nsresult,

    /* void resetRules ([optional] in boolean doImport); */
    pub ResetRules: unsafe extern "system" fn (this: *const nsICookieBannerService, doImport: bool) -> ::nserror::nsresult,

    /* Array<nsICookieRule> getCookiesForURI (in nsIURI aURI, in boolean aIsPrivateBrowsing); */
    pub GetCookiesForURI: unsafe extern "system" fn (this: *const nsICookieBannerService, aURI: *const nsIURI, aIsPrivateBrowsing: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsICookieRule>>>) -> ::nserror::nsresult,

    /* Array<nsIClickRule> getClickRulesForDomain (in ACString aDomain, in boolean aIsTopLevel); */
    pub GetClickRulesForDomain: unsafe extern "system" fn (this: *const nsICookieBannerService, aDomain: *const ::nsstring::nsACString, aIsTopLevel: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIClickRule>>>) -> ::nserror::nsresult,

    /* void insertRule (in nsICookieBannerRule aRule); */
    pub InsertRule: unsafe extern "system" fn (this: *const nsICookieBannerService, aRule: *const nsICookieBannerRule) -> ::nserror::nsresult,

    /* void removeRule (in nsICookieBannerRule aRule); */
    pub RemoveRule: unsafe extern "system" fn (this: *const nsICookieBannerService, aRule: *const nsICookieBannerRule) -> ::nserror::nsresult,

    /* boolean hasRuleForBrowsingContextTree (in BrowsingContext aBrowsingContext); */
    pub HasRuleForBrowsingContextTree: unsafe extern "system" fn (this: *const nsICookieBannerService, aBrowsingContext: *const libc::c_void, _retval: *mut bool) -> ::nserror::nsresult,

    /* nsICookieBannerService_Modes getDomainPref (in nsIURI aTopLevelURI, in boolean aIsPrivate); */
    pub GetDomainPref: unsafe extern "system" fn (this: *const nsICookieBannerService, aTopLevelURI: *const nsIURI, aIsPrivate: bool, _retval: *mut u8) -> ::nserror::nsresult,

    /* void setDomainPref (in nsIURI aTopLevelURI, in nsICookieBannerService_Modes aMode, in boolean aIsPrivate); */
    pub SetDomainPref: unsafe extern "system" fn (this: *const nsICookieBannerService, aTopLevelURI: *const nsIURI, aMode:  u8, aIsPrivate: bool) -> ::nserror::nsresult,

    /* void setDomainPrefAndPersistInPrivateBrowsing (in nsIURI aTopLevelURI, in nsICookieBannerService_Modes aMode); */
    pub SetDomainPrefAndPersistInPrivateBrowsing: unsafe extern "system" fn (this: *const nsICookieBannerService, aTopLevelURI: *const nsIURI, aMode:  u8) -> ::nserror::nsresult,

    /* void removeDomainPref (in nsIURI aTopLevelURI, in boolean aIsPrivate); */
    pub RemoveDomainPref: unsafe extern "system" fn (this: *const nsICookieBannerService, aTopLevelURI: *const nsIURI, aIsPrivate: bool) -> ::nserror::nsresult,

    /* void removeAllDomainPrefs (in boolean aIsPrivate); */
    pub RemoveAllDomainPrefs: unsafe extern "system" fn (this: *const nsICookieBannerService, aIsPrivate: bool) -> ::nserror::nsresult,

    /* boolean shouldStopBannerClickingForSite (in ACString aSite, in boolean aIsTopLevel, in boolean aIsPrivate); */
    pub ShouldStopBannerClickingForSite: unsafe extern "system" fn (this: *const nsICookieBannerService, aSite: *const ::nsstring::nsACString, aIsTopLevel: bool, aIsPrivate: bool, _retval: *mut bool) -> ::nserror::nsresult,

    /* void markSiteExecuted (in ACString aSite, in boolean aIsTopLevel, in boolean aIsPrivate); */
    pub MarkSiteExecuted: unsafe extern "system" fn (this: *const nsICookieBannerService, aSite: *const ::nsstring::nsACString, aIsTopLevel: bool, aIsPrivate: bool) -> ::nserror::nsresult,

    /* void removeExecutedRecordForSite (in ACString aSite, in boolean aIsPrivate); */
    pub RemoveExecutedRecordForSite: unsafe extern "system" fn (this: *const nsICookieBannerService, aSite: *const ::nsstring::nsACString, aIsPrivate: bool) -> ::nserror::nsresult,

    /* void removeAllExecutedRecords (in boolean aIsPrivate); */
    pub RemoveAllExecutedRecords: unsafe extern "system" fn (this: *const nsICookieBannerService, aIsPrivate: bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICookieBannerService {

    pub const MODE_DISABLED:  u8 = 0;


    pub const MODE_REJECT:  u8 = 1;


    pub const MODE_REJECT_OR_ACCEPT:  u8 = 2;


    pub const MODE_UNSET:  u8 = 3;

    /// ```text
    /// /**
    ///    * Whether the feature / service is enabled.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean isEnabled;`
    #[inline]
    pub unsafe fn GetIsEnabled(&self, aIsEnabled: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsEnabled)(self, aIsEnabled)
    }


    /// ```text
    /// /**
    ///    * Getter for a list of all cookie banner rules. This includes both opt-in and opt-out rules.
    ///    */
    /// ```
    ///

    /// `readonly attribute Array<nsICookieBannerRule> rules;`
    #[inline]
    pub unsafe fn GetRules(&self, aRules: *mut thin_vec::ThinVec<Option<RefPtr<nsICookieBannerRule>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetRules)(self, aRules)
    }


    /// ```text
    /// /**
    ///    * Clears all imported rules. They will be imported again on startup and when
    ///    * enabling the service. This is currently only used for testing.
    ///    *
    ///    * doImport - Whether to import initial rule list after reset. Passing false
    ///    * will result in an empty rule list.
    ///    */
    /// ```
    ///

    /// `void resetRules ([optional] in boolean doImport);`
    #[inline]
    pub unsafe fn ResetRules(&self, doImport: bool) -> ::nserror::nsresult {
        ((*self.vtable).ResetRules)(self, doImport)
    }


    /// ```text
    /// /**
    ///    * Look up all cookie rules for a given top-level URI. Depending on the MODE_
    ///    * this will return none, only reject rules or accept rules if there is no
    ///    * reject rule available.
    ///    */
    /// ```
    ///

    /// `Array<nsICookieRule> getCookiesForURI (in nsIURI aURI, in boolean aIsPrivateBrowsing);`
    #[inline]
    pub unsafe fn GetCookiesForURI(&self, aURI: *const nsIURI, aIsPrivateBrowsing: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsICookieRule>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetCookiesForURI)(self, aURI, aIsPrivateBrowsing, _retval)
    }


    /// ```text
    /// /**
    ///    * Look up the click rules for a given domain.
    ///    */
    /// ```
    ///

    /// `Array<nsIClickRule> getClickRulesForDomain (in ACString aDomain, in boolean aIsTopLevel);`
    #[inline]
    pub unsafe fn GetClickRulesForDomain(&self, aDomain: *const ::nsstring::nsACString, aIsTopLevel: bool, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIClickRule>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetClickRulesForDomain)(self, aDomain, aIsTopLevel, _retval)
    }


    /// ```text
    /// /**
    ///    * Insert a cookie banner rule for a domain. If there was previously a rule
    ///    * stored with the same domain it will be overwritten.
    ///    */
    /// ```
    ///

    /// `void insertRule (in nsICookieBannerRule aRule);`
    #[inline]
    pub unsafe fn InsertRule(&self, aRule: *const nsICookieBannerRule) -> ::nserror::nsresult {
        ((*self.vtable).InsertRule)(self, aRule)
    }


    /// ```text
    /// /**
    ///    * Remove a cookie banner rule.
    ///    */
    /// ```
    ///

    /// `void removeRule (in nsICookieBannerRule aRule);`
    #[inline]
    pub unsafe fn RemoveRule(&self, aRule: *const nsICookieBannerRule) -> ::nserror::nsresult {
        ((*self.vtable).RemoveRule)(self, aRule)
    }


    /// ```text
    /// /**
    ///    * Computes whether we have a rule for the given browsing context or any of
    ///    * its children. This takes the current cookie banner service mode into
    ///    * consideration and whether the BC is in private browsing mode.
    ///    *
    ///    * This method only takes the global service mode into account. It will ignore
    ///    * any per-site mode overrides. It is meant for callers to find out whether an
    ///    * applicable rule exists, even if users have disabled the feature for the
    ///    * given site.
    ///    */
    /// ```
    ///

    /// `boolean hasRuleForBrowsingContextTree (in BrowsingContext aBrowsingContext);`
    #[inline]
    pub unsafe fn HasRuleForBrowsingContextTree(&self, aBrowsingContext: *const libc::c_void, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).HasRuleForBrowsingContextTree)(self, aBrowsingContext, _retval)
    }


    /// ```text
    /// /**
    ///    * Get the domain preference of the given top-level URI. It will return the
    ///    * service mode if there is a site preference for the given URI. Otherwise, it
    ///    * will return MODE_UNSET.
    ///    */
    /// ```
    ///

    /// `nsICookieBannerService_Modes getDomainPref (in nsIURI aTopLevelURI, in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn GetDomainPref(&self, aTopLevelURI: *const nsIURI, aIsPrivate: bool, _retval: *mut u8) -> ::nserror::nsresult {
        ((*self.vtable).GetDomainPref)(self, aTopLevelURI, aIsPrivate, _retval)
    }


    /// ```text
    /// /**
    ///    * Set the domain preference of the given top-level URI.
    ///    */
    /// ```
    ///

    /// `void setDomainPref (in nsIURI aTopLevelURI, in nsICookieBannerService_Modes aMode, in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn SetDomainPref(&self, aTopLevelURI: *const nsIURI, aMode:  u8, aIsPrivate: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetDomainPref)(self, aTopLevelURI, aMode, aIsPrivate)
    }


    /// ```text
    /// /**
    ///    * Set the domain preference of the given top-level URI. It will persist the
    ///    * domain preference for private browsing.
    ///    *
    ///    * WARNING: setting permanent domain preference _will_ leak data in private
    ///    * browsing. Only use if you understand the consequences and trade-offs. If
    ///    * you are unsure, |setDomainPref| is very likely what you want to use
    ///    * instead.
    ///    */
    /// ```
    ///

    /// `void setDomainPrefAndPersistInPrivateBrowsing (in nsIURI aTopLevelURI, in nsICookieBannerService_Modes aMode);`
    #[inline]
    pub unsafe fn SetDomainPrefAndPersistInPrivateBrowsing(&self, aTopLevelURI: *const nsIURI, aMode:  u8) -> ::nserror::nsresult {
        ((*self.vtable).SetDomainPrefAndPersistInPrivateBrowsing)(self, aTopLevelURI, aMode)
    }


    /// ```text
    /// /**
    ///    * Remove the domain preference of the given top-level URI.
    ///    */
    /// ```
    ///

    /// `void removeDomainPref (in nsIURI aTopLevelURI, in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn RemoveDomainPref(&self, aTopLevelURI: *const nsIURI, aIsPrivate: bool) -> ::nserror::nsresult {
        ((*self.vtable).RemoveDomainPref)(self, aTopLevelURI, aIsPrivate)
    }


    /// ```text
    /// /**
    ///    * Remove all domain preferences.
    ///    */
    /// ```
    ///

    /// `void removeAllDomainPrefs (in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn RemoveAllDomainPrefs(&self, aIsPrivate: bool) -> ::nserror::nsresult {
        ((*self.vtable).RemoveAllDomainPrefs)(self, aIsPrivate)
    }


    /// ```text
    /// /**
    ///    * Return true if we should stop cookie banner clicking for the given site in
    ///    * this session.
    ///    */
    /// ```
    ///

    /// `boolean shouldStopBannerClickingForSite (in ACString aSite, in boolean aIsTopLevel, in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn ShouldStopBannerClickingForSite(&self, aSite: *const ::nsstring::nsACString, aIsTopLevel: bool, aIsPrivate: bool, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).ShouldStopBannerClickingForSite)(self, aSite, aIsTopLevel, aIsPrivate, _retval)
    }


    /// ```text
    /// /**
    ///    * Mark that the cookie banner handling code was executed for the given site
    ///    * for this session.
    ///    */
    /// ```
    ///

    /// `void markSiteExecuted (in ACString aSite, in boolean aIsTopLevel, in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn MarkSiteExecuted(&self, aSite: *const ::nsstring::nsACString, aIsTopLevel: bool, aIsPrivate: bool) -> ::nserror::nsresult {
        ((*self.vtable).MarkSiteExecuted)(self, aSite, aIsTopLevel, aIsPrivate)
    }



    /// `void removeExecutedRecordForSite (in ACString aSite, in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn RemoveExecutedRecordForSite(&self, aSite: *const ::nsstring::nsACString, aIsPrivate: bool) -> ::nserror::nsresult {
        ((*self.vtable).RemoveExecutedRecordForSite)(self, aSite, aIsPrivate)
    }


    /// ```text
    /// /**
    ///    * Remove all the record of sites where cookie banner handling has been
    ///    * executed under the private browsing session or normal session.
    ///    */
    /// ```
    ///

    /// `void removeAllExecutedRecords (in boolean aIsPrivate);`
    #[inline]
    pub unsafe fn RemoveAllExecutedRecords(&self, aIsPrivate: bool) -> ::nserror::nsresult {
        ((*self.vtable).RemoveAllExecutedRecords)(self, aIsPrivate)
    }


}


