//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/cookie/nsICookieNotification.idl
//


/// `interface nsICookieNotification : nsISupports`
///

/// ```text
/// /**
///  * Meta object dispatched by cookie change notifications.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICookieNotification {
    vtable: &'static nsICookieNotificationVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICookieNotification.
unsafe impl XpCom for nsICookieNotification {
    const IID: nsIID = nsID(0x5b3490f2, 0x75f0, 0x4e36,
        [0x9f, 0x3d, 0x47, 0xc8, 0x57, 0xec, 0xdf, 0xbb]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICookieNotification {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICookieNotification.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICookieNotificationCoerce {
    /// Cheaply cast a value of this type from a `nsICookieNotification`.
    fn coerce_from(v: &nsICookieNotification) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICookieNotificationCoerce for nsICookieNotification {
    #[inline]
    fn coerce_from(v: &nsICookieNotification) -> &Self {
        v
    }
}

impl nsICookieNotification {
    /// Cast this `nsICookieNotification` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICookieNotificationCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICookieNotification {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICookieNotificationCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICookieNotification) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICookieNotification
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICookieNotificationVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* [infallible] readonly attribute nsICookieNotification_Action action; */
    pub GetAction: unsafe extern "system" fn (this: *const nsICookieNotification, aAction: *mut u8) -> ::nserror::nsresult,

    /* [infallible] readonly attribute nsICookie cookie; */
    pub GetCookie: unsafe extern "system" fn (this: *const nsICookieNotification, aCookie: *mut*const nsICookie) -> ::nserror::nsresult,

    /* readonly attribute ACString baseDomain; */
    pub GetBaseDomain: unsafe extern "system" fn (this: *const nsICookieNotification, aBaseDomain: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [infallible] readonly attribute boolean isThirdParty; */
    pub GetIsThirdParty: unsafe extern "system" fn (this: *const nsICookieNotification, aIsThirdParty: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute nsIArray batchDeletedCookies; */
    pub GetBatchDeletedCookies: unsafe extern "system" fn (this: *const nsICookieNotification, aBatchDeletedCookies: *mut*const nsIArray) -> ::nserror::nsresult,

    /* [infallible] readonly attribute unsigned long long browsingContextId; */
    pub GetBrowsingContextId: unsafe extern "system" fn (this: *const nsICookieNotification, aBrowsingContextId: *mut u64) -> ::nserror::nsresult,

    /* [infallible] readonly attribute BrowsingContext browsingContext; */
    pub GetBrowsingContext: unsafe extern "system" fn (this: *const nsICookieNotification, aBrowsingContext: *mut *const libc::c_void) -> ::nserror::nsresult,

    /* readonly attribute nsIDPtr operationID; */
    pub GetOperationID: unsafe extern "system" fn (this: *const nsICookieNotification, aOperationID: *mut *mut nsID) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICookieNotification {

    pub const COOKIE_DELETED:  u8 = 0;


    pub const COOKIE_ADDED:  u8 = 1;


    pub const COOKIE_CHANGED:  u8 = 2;


    pub const ALL_COOKIES_CLEARED:  u8 = 3;


    pub const COOKIES_BATCH_DELETED:  u8 = 4;

    /// ```text
    /// /**
    ///      * Describes the cookie operation this notification is for. Cookies may be
    ///      * deleted, added or changed. See Action enum above for possible values.
    ///      */
    /// ```
    ///

    /// `[infallible] readonly attribute nsICookieNotification_Action action;`
    #[inline]
    pub unsafe fn GetAction(&self, aAction: *mut u8) -> ::nserror::nsresult {
        ((*self.vtable).GetAction)(self, aAction)
    }


    /// ```text
    /// /**
    ///      * The cookie the notification is for, may be null depending on the action.
    ///      */
    /// ```
    ///

    /// `[infallible] readonly attribute nsICookie cookie;`
    #[inline]
    pub unsafe fn GetCookie(&self, aCookie: *mut*const nsICookie) -> ::nserror::nsresult {
        ((*self.vtable).GetCookie)(self, aCookie)
    }


    /// ```text
    /// /**
    ///      * Base domain of the cookie. May be empty if cookie is null.
    ///      */
    /// ```
    ///

    /// `readonly attribute ACString baseDomain;`
    #[inline]
    pub unsafe fn GetBaseDomain(&self, aBaseDomain: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetBaseDomain)(self, aBaseDomain)
    }


    /// ```text
    /// /**
    ///      * True if the cookie set (added or changed) is considered third-party.
    ///      */
    /// ```
    ///

    /// `[infallible] readonly attribute boolean isThirdParty;`
    #[inline]
    pub unsafe fn GetIsThirdParty(&self) -> bool {
        let mut result = <bool as ::std::default::Default>::default();
        let _rv = ((*self.vtable).GetIsThirdParty)(self, &mut result);
        debug_assert!(_rv.succeeded());
        result
    }


    /// ```text
    /// /**
    ///      * List of cookies purged.
    ///      * Only set when action == COOKIES_BATCH_DELETED.
    ///      */
    /// ```
    ///

    /// `readonly attribute nsIArray batchDeletedCookies;`
    #[inline]
    pub unsafe fn GetBatchDeletedCookies(&self, aBatchDeletedCookies: *mut*const nsIArray) -> ::nserror::nsresult {
        ((*self.vtable).GetBatchDeletedCookies)(self, aBatchDeletedCookies)
    }


    /// ```text
    /// /**
    ///      * The id of the BrowsingContext the cookie change was triggered from. Set
    ///      * to 0 if there is not applicable BrowsingContext.
    ///      */
    /// ```
    ///

    /// `[infallible] readonly attribute unsigned long long browsingContextId;`
    #[inline]
    pub unsafe fn GetBrowsingContextId(&self) -> u64 {
        let mut result = <u64 as ::std::default::Default>::default();
        let _rv = ((*self.vtable).GetBrowsingContextId)(self, &mut result);
        debug_assert!(_rv.succeeded());
        result
    }


    /// ```text
    /// /**
    ///      * BrowsingContext associated with browsingContextId. May be nullptr.
    ///      */
    /// ```
    ///

    /// `[infallible] readonly attribute BrowsingContext browsingContext;`
    #[inline]
    pub unsafe fn GetBrowsingContext(&self, aBrowsingContext: *mut *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetBrowsingContext)(self, aBrowsingContext)
    }


    /// ```text
    /// /**
    ///      * Operation ID to track which nsICookieManager operation has generated
    ///      * this notification.
    ///      */
    /// ```
    ///

    /// `readonly attribute nsIDPtr operationID;`
    #[inline]
    pub unsafe fn GetOperationID(&self, aOperationID: *mut *mut nsID) -> ::nserror::nsresult {
        ((*self.vtable).GetOperationID)(self, aOperationID)
    }


}


