//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/cookiebanners/nsICookieRule.idl
//


/// `interface nsICookieRule : nsISupports`
///

/// ```text
/// /**
///  * Rule which specifies a cookie to be set in order to handle a cookie banner.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICookieRule {
    vtable: &'static nsICookieRuleVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICookieRule.
unsafe impl XpCom for nsICookieRule {
    const IID: nsIID = nsID(0xbf049b1e, 0x8a05, 0x481f,
        [0xa1, 0x20, 0x33, 0x2e, 0xa1, 0xbd, 0x65, 0xef]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICookieRule {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICookieRule.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICookieRuleCoerce {
    /// Cheaply cast a value of this type from a `nsICookieRule`.
    fn coerce_from(v: &nsICookieRule) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICookieRuleCoerce for nsICookieRule {
    #[inline]
    fn coerce_from(v: &nsICookieRule) -> &Self {
        v
    }
}

impl nsICookieRule {
    /// Cast this `nsICookieRule` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICookieRuleCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICookieRule {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICookieRuleCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICookieRule) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICookieRule
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICookieRuleVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute nsICookie cookie; */
    pub GetCookie: unsafe extern "system" fn (this: *const nsICookieRule, aCookie: *mut *const nsICookie) -> ::nserror::nsresult,

    /* readonly attribute int64_t expiryRelative; */
    pub GetExpiryRelative: unsafe extern "system" fn (this: *const nsICookieRule, aExpiryRelative: *mut i64) -> ::nserror::nsresult,

    /* readonly attribute AUTF8String unsetValue; */
    pub GetUnsetValue: unsafe extern "system" fn (this: *const nsICookieRule, aUnsetValue: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [noscript] nsICookieRule copyForDomain (in ACString aDomain); */
    pub CopyForDomain: unsafe extern "system" fn (this: *const nsICookieRule, aDomain: *const ::nsstring::nsACString, _retval: *mut *const nsICookieRule) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICookieRule {

    /// ```text
    /// /**
    ///      * The cookie to set.
    ///      * When calling this getter creation, expiry and last accessed time are
    ///      * computed.
    ///      */
    /// ```
    ///

    /// `readonly attribute nsICookie cookie;`
    #[inline]
    pub unsafe fn GetCookie(&self, aCookie: *mut *const nsICookie) -> ::nserror::nsresult {
        ((*self.vtable).GetCookie)(self, aCookie)
    }


    /// ```text
    /// /**
    ///      * Expiry time of the cookie in seconds relative to the injection time.
    ///      * If you want a cookie to expire in 1 month after it has been set, set this
    ///      * to 2592000.
    ///      * Defaults to 'cookiebanners.cookieInjector.defaultExpiryRelative'.
    ///      */
    /// ```
    ///

    /// `readonly attribute int64_t expiryRelative;`
    #[inline]
    pub unsafe fn GetExpiryRelative(&self, aExpiryRelative: *mut i64) -> ::nserror::nsresult {
        ((*self.vtable).GetExpiryRelative)(self, aExpiryRelative)
    }


    /// ```text
    /// /**
    ///      * If an existing cookie sets this value it may be overwritten.
    ///      * This is used for sites which set an explicit cookie state, even if a
    ///      * cookie banner is still pending.
    ///      */
    /// ```
    ///

    /// `readonly attribute AUTF8String unsetValue;`
    #[inline]
    pub unsafe fn GetUnsetValue(&self, aUnsetValue: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetUnsetValue)(self, aUnsetValue)
    }


    /// ```text
    /// /**
    ///      * Create a copy of this rule for a domain. If the cookie host is unset it
    ///      * is set to ".<domain>".
    ///      * Non-empty host fields will be preserved.
    ///      */
    /// ```
    ///

    /// `[noscript] nsICookieRule copyForDomain (in ACString aDomain);`
    #[inline]
    pub unsafe fn CopyForDomain(&self, aDomain: *const ::nsstring::nsACString, _retval: *mut *const nsICookieRule) -> ::nserror::nsresult {
        ((*self.vtable).CopyForDomain)(self, aDomain, _retval)
    }


}


