//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/dap/nsIDAPTelemetry.idl
//


/// `interface nsIDAPTelemetry : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIDAPTelemetry {
    vtable: &'static nsIDAPTelemetryVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIDAPTelemetry.
unsafe impl XpCom for nsIDAPTelemetry {
    const IID: nsIID = nsID(0x58a4c579, 0xd2dd, 0x46b7,
        [0x9c, 0x3b, 0x68, 0x81, 0xa1, 0xc3, 0x6c, 0x6a]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIDAPTelemetry {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIDAPTelemetry.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIDAPTelemetryCoerce {
    /// Cheaply cast a value of this type from a `nsIDAPTelemetry`.
    fn coerce_from(v: &nsIDAPTelemetry) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIDAPTelemetryCoerce for nsIDAPTelemetry {
    #[inline]
    fn coerce_from(v: &nsIDAPTelemetry) -> &Self {
        v
    }
}

impl nsIDAPTelemetry {
    /// Cast this `nsIDAPTelemetry` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIDAPTelemetryCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIDAPTelemetry {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIDAPTelemetryCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIDAPTelemetry) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIDAPTelemetry
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIDAPTelemetryVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void GetReportPrioSum (in Array<uint8_t> leaderHpkeConfig, in Array<uint8_t> helperHpkeConfig, in uint32_t measurement, in Array<uint8_t> task_id, in uint32_t bits, in uint64_t time_precision, out Array<uint8_t> report); */
    pub GetReportPrioSum: unsafe extern "system" fn (this: *const nsIDAPTelemetry, leaderHpkeConfig: *const thin_vec::ThinVec<u8>, helperHpkeConfig: *const thin_vec::ThinVec<u8>, measurement: u32, task_id: *const thin_vec::ThinVec<u8>, bits: u32, time_precision: u64, report: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult,

    /* void GetReportPrioSumVec (in Array<uint8_t> leaderHpkeConfig, in Array<uint8_t> helperHpkeConfig, in Array<uint32_t> measurement, in Array<uint8_t> task_id, in uint32_t bits, in uint64_t time_precision, out Array<uint8_t> report); */
    pub GetReportPrioSumVec: unsafe extern "system" fn (this: *const nsIDAPTelemetry, leaderHpkeConfig: *const thin_vec::ThinVec<u8>, helperHpkeConfig: *const thin_vec::ThinVec<u8>, measurement: *const thin_vec::ThinVec<u32>, task_id: *const thin_vec::ThinVec<u8>, bits: u32, time_precision: u64, report: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult,

    /* void GetReportPrioHistogram (in Array<uint8_t> leaderHpkeConfig, in Array<uint8_t> helperHpkeConfig, in uint32_t measurement, in Array<uint8_t> task_id, in uint32_t length, in uint64_t time_precision, out Array<uint8_t> report); */
    pub GetReportPrioHistogram: unsafe extern "system" fn (this: *const nsIDAPTelemetry, leaderHpkeConfig: *const thin_vec::ThinVec<u8>, helperHpkeConfig: *const thin_vec::ThinVec<u8>, measurement: u32, task_id: *const thin_vec::ThinVec<u8>, length: u32, time_precision: u64, report: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIDAPTelemetry {

    /// ```text
    /// /**
    ///    * Split measurement into shares and create a report with encrypted shares.
    ///    *
    ///    * @param leaderHpkeConfig  Leader encryption configuration.
    ///    * @param helperHpkeConfig  Helper encryption configuration.
    ///    * @param measurement       The data which will be encoded and shared.
    ///    * @param task_id           Identifies which task this measurement is for
    ///    *                          which influences both encoding and encryption.
    ///    * @param [bits]            Bitwidth of integers that the VDAF consumes.
    ///    *                          size of vector in the case of histograms.
    ///    * @param [length]          Number of bins in the case of histograms.
    ///    * @param time_precision    Determines the report timestamp.
    ///    *
    ///    * @return The raw bytes of a report, ready for sending.
    ///    *
    ///    * @note This can potentially run for a long time. Take care not to block
    ///    *       the main thread for too long.
    ///    */
    /// ```
    ///

    /// `void GetReportPrioSum (in Array<uint8_t> leaderHpkeConfig, in Array<uint8_t> helperHpkeConfig, in uint32_t measurement, in Array<uint8_t> task_id, in uint32_t bits, in uint64_t time_precision, out Array<uint8_t> report);`
    #[inline]
    pub unsafe fn GetReportPrioSum(&self, leaderHpkeConfig: *const thin_vec::ThinVec<u8>, helperHpkeConfig: *const thin_vec::ThinVec<u8>, measurement: u32, task_id: *const thin_vec::ThinVec<u8>, bits: u32, time_precision: u64, report: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult {
        ((*self.vtable).GetReportPrioSum)(self, leaderHpkeConfig, helperHpkeConfig, measurement, task_id, bits, time_precision, report)
    }



    /// `void GetReportPrioSumVec (in Array<uint8_t> leaderHpkeConfig, in Array<uint8_t> helperHpkeConfig, in Array<uint32_t> measurement, in Array<uint8_t> task_id, in uint32_t bits, in uint64_t time_precision, out Array<uint8_t> report);`
    #[inline]
    pub unsafe fn GetReportPrioSumVec(&self, leaderHpkeConfig: *const thin_vec::ThinVec<u8>, helperHpkeConfig: *const thin_vec::ThinVec<u8>, measurement: *const thin_vec::ThinVec<u32>, task_id: *const thin_vec::ThinVec<u8>, bits: u32, time_precision: u64, report: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult {
        ((*self.vtable).GetReportPrioSumVec)(self, leaderHpkeConfig, helperHpkeConfig, measurement, task_id, bits, time_precision, report)
    }



    /// `void GetReportPrioHistogram (in Array<uint8_t> leaderHpkeConfig, in Array<uint8_t> helperHpkeConfig, in uint32_t measurement, in Array<uint8_t> task_id, in uint32_t length, in uint64_t time_precision, out Array<uint8_t> report);`
    #[inline]
    pub unsafe fn GetReportPrioHistogram(&self, leaderHpkeConfig: *const thin_vec::ThinVec<u8>, helperHpkeConfig: *const thin_vec::ThinVec<u8>, measurement: u32, task_id: *const thin_vec::ThinVec<u8>, length: u32, time_precision: u64, report: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult {
        ((*self.vtable).GetReportPrioHistogram)(self, leaderHpkeConfig, helperHpkeConfig, measurement, task_id, length, time_precision, report)
    }


}


