//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/dom/ipc/nsIDOMProcessParent.idl
//


/// `interface nsIDOMProcessParent : nsISupports`
///

/// ```text
/// /**
///  * Parent actor interface for a process which can host DOM content.
///  *
///  * Implemented by either `InProcessParent` for the parent process, or
///  * `ContentParent` for a content process.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIDOMProcessParent {
    vtable: &'static nsIDOMProcessParentVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIDOMProcessParent.
unsafe impl XpCom for nsIDOMProcessParent {
    const IID: nsIID = nsID(0x81fc08b9, 0xc901, 0x471f,
        [0xab, 0x0d, 0x87, 0x63, 0x62, 0xeb, 0xa7, 0x70]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIDOMProcessParent {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIDOMProcessParent.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIDOMProcessParentCoerce {
    /// Cheaply cast a value of this type from a `nsIDOMProcessParent`.
    fn coerce_from(v: &nsIDOMProcessParent) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIDOMProcessParentCoerce for nsIDOMProcessParent {
    #[inline]
    fn coerce_from(v: &nsIDOMProcessParent) -> &Self {
        v
    }
}

impl nsIDOMProcessParent {
    /// Cast this `nsIDOMProcessParent` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIDOMProcessParentCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIDOMProcessParent {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIDOMProcessParentCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIDOMProcessParent) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIDOMProcessParent
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIDOMProcessParentVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* [infallible] readonly attribute unsigned long long childID; */
    pub GetChildID: unsafe extern "system" fn (this: *const nsIDOMProcessParent, aChildID: *mut u64) -> ::nserror::nsresult,

    /* [infallible] readonly attribute long osPid; */
    pub GetOsPid: unsafe extern "system" fn (this: *const nsIDOMProcessParent, aOsPid: *mut i32) -> ::nserror::nsresult,

    /* [implicit_jscontext] JSProcessActorParent getActor (in ACString name); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub GetActor: *const ::libc::c_void,

    /* JSProcessActorParent getExistingActor (in ACString name); */
    pub GetExistingActor: unsafe extern "system" fn (this: *const nsIDOMProcessParent, name: *const ::nsstring::nsACString, _retval: *mut *const libc::c_void) -> ::nserror::nsresult,

    /* [infallible] readonly attribute boolean canSend; */
    pub GetCanSend: unsafe extern "system" fn (this: *const nsIDOMProcessParent, aCanSend: *mut bool) -> ::nserror::nsresult,

    /* [nostdcall,notxpcom] ContentParentPtr AsContentParent (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub AsContentParent: *const ::libc::c_void,

    /* [nostdcall,notxpcom] JSActorManagerPtr AsJSActorManager (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub AsJSActorManager: *const ::libc::c_void,

    /* readonly attribute ACString remoteType; */
    pub GetRemoteType: unsafe extern "system" fn (this: *const nsIDOMProcessParent, aRemoteType: *mut ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIDOMProcessParent {

    /// ```text
    /// /**
    ///    * Internal child process ID. `0` is reserved for the parent process.
    ///    */
    /// ```
    ///

    /// `[infallible] readonly attribute unsigned long long childID;`
    #[inline]
    pub unsafe fn GetChildID(&self) -> u64 {
        let mut result = <u64 as ::std::default::Default>::default();
        let _rv = ((*self.vtable).GetChildID)(self, &mut result);
        debug_assert!(_rv.succeeded());
        result
    }


    /// ```text
    /// /**
    ///    * OS ID of the process.
    ///    */
    /// ```
    ///

    /// `[infallible] readonly attribute long osPid;`
    #[inline]
    pub unsafe fn GetOsPid(&self) -> i32 {
        let mut result = <i32 as ::std::default::Default>::default();
        let _rv = ((*self.vtable).GetOsPid)(self, &mut result);
        debug_assert!(_rv.succeeded());
        result
    }


    /// ```text
    /// /**
    ///    * Lookup a JSProcessActorParent managed by this interface by name.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] JSProcessActorParent getActor (in ACString name);`
    const _GetActor: () = ();


    /// `JSProcessActorParent getExistingActor (in ACString name);`
    #[inline]
    pub unsafe fn GetExistingActor(&self, name: *const ::nsstring::nsACString, _retval: *mut *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetExistingActor)(self, name, _retval)
    }


    /// ```text
    /// /** Can the actor still send messages? */
    /// ```
    ///

    /// `[infallible] readonly attribute boolean canSend;`
    #[inline]
    pub unsafe fn GetCanSend(&self) -> bool {
        let mut result = <bool as ::std::default::Default>::default();
        let _rv = ((*self.vtable).GetCanSend)(self, &mut result);
        debug_assert!(_rv.succeeded());
        result
    }



    /// `[nostdcall,notxpcom] ContentParentPtr AsContentParent ();`
    const _AsContentParent: () = ();

    /// ```text
    /// /** Cast this nsIDOMProcessParent to a JSActorManager */
    /// ```
    ///

    /// `[nostdcall,notxpcom] JSActorManagerPtr AsJSActorManager ();`
    const _AsJSActorManager: () = ();

    /// ```text
    /// /**
    ///    * Remote type of the process.
    ///    */
    /// ```
    ///

    /// `readonly attribute ACString remoteType;`
    #[inline]
    pub unsafe fn GetRemoteType(&self, aRemoteType: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetRemoteType)(self, aRemoteType)
    }


}


/// `interface nsIContentParentKeepAlive : nsISupports`
///

/// ```text
/// /**
///  * Reference counted and cycle collected interface to expose a
///  * UniqueContentParentKeepAlive to chrome JS.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIContentParentKeepAlive {
    vtable: &'static nsIContentParentKeepAliveVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIContentParentKeepAlive.
unsafe impl XpCom for nsIContentParentKeepAlive {
    const IID: nsIID = nsID(0xb43907bd, 0xe40d, 0x4bf5,
        [0xa8, 0x5e, 0x86, 0x69, 0x98, 0xbe, 0xb7, 0xa9]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIContentParentKeepAlive {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIContentParentKeepAlive.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIContentParentKeepAliveCoerce {
    /// Cheaply cast a value of this type from a `nsIContentParentKeepAlive`.
    fn coerce_from(v: &nsIContentParentKeepAlive) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIContentParentKeepAliveCoerce for nsIContentParentKeepAlive {
    #[inline]
    fn coerce_from(v: &nsIContentParentKeepAlive) -> &Self {
        v
    }
}

impl nsIContentParentKeepAlive {
    /// Cast this `nsIContentParentKeepAlive` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIContentParentKeepAliveCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIContentParentKeepAlive {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIContentParentKeepAliveCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIContentParentKeepAlive) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIContentParentKeepAlive
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIContentParentKeepAliveVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute nsIDOMProcessParent domProcess; */
    pub GetDomProcess: unsafe extern "system" fn (this: *const nsIContentParentKeepAlive, aDomProcess: *mut *const nsIDOMProcessParent) -> ::nserror::nsresult,

    /* void invalidateKeepAlive (); */
    pub InvalidateKeepAlive: unsafe extern "system" fn (this: *const nsIContentParentKeepAlive) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIContentParentKeepAlive {

    /// ```text
    /// /**
    ///    * Underlying nsIDOMProcessParent which is being kept alive.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIDOMProcessParent domProcess;`
    #[inline]
    pub unsafe fn GetDomProcess(&self, aDomProcess: *mut *const nsIDOMProcessParent) -> ::nserror::nsresult {
        ((*self.vtable).GetDomProcess)(self, aDomProcess)
    }


    /// ```text
    /// /**
    ///    * Invalidate this nsIContentParentKeepAlive, dropping the keep alive
    ///    * and ContentParent reference without waiting for the object to be gc/cc-ed.
    ///    */
    /// ```
    ///

    /// `void invalidateKeepAlive ();`
    #[inline]
    pub unsafe fn InvalidateKeepAlive(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).InvalidateKeepAlive)(self, )
    }


}


