//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIDragSession.idl
//


/// `interface nsIDragSession : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIDragSession {
    vtable: &'static nsIDragSessionVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIDragSession.
unsafe impl XpCom for nsIDragSession {
    const IID: nsIID = nsID(0x25bce737, 0x73f0, 0x43c7,
        [0xbc, 0x20, 0xc7, 0x10, 0x44, 0xa7, 0x3c, 0x5a]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIDragSession {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIDragSession.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIDragSessionCoerce {
    /// Cheaply cast a value of this type from a `nsIDragSession`.
    fn coerce_from(v: &nsIDragSession) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIDragSessionCoerce for nsIDragSession {
    #[inline]
    fn coerce_from(v: &nsIDragSession) -> &Self {
        v
    }
}

impl nsIDragSession {
    /// Cast this `nsIDragSession` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIDragSessionCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIDragSession {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIDragSessionCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIDragSession) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIDragSession
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIDragSessionVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* attribute boolean canDrop; */
    pub GetCanDrop: unsafe extern "system" fn (this: *const nsIDragSession, aCanDrop: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean canDrop; */
    pub SetCanDrop: unsafe extern "system" fn (this: *const nsIDragSession, aCanDrop: bool) -> ::nserror::nsresult,

    /* attribute boolean onlyChromeDrop; */
    pub GetOnlyChromeDrop: unsafe extern "system" fn (this: *const nsIDragSession, aOnlyChromeDrop: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean onlyChromeDrop; */
    pub SetOnlyChromeDrop: unsafe extern "system" fn (this: *const nsIDragSession, aOnlyChromeDrop: bool) -> ::nserror::nsresult,

    /* attribute unsigned long dragAction; */
    pub GetDragAction: unsafe extern "system" fn (this: *const nsIDragSession, aDragAction: *mut u32) -> ::nserror::nsresult,

    /* attribute unsigned long dragAction; */
    pub SetDragAction: unsafe extern "system" fn (this: *const nsIDragSession, aDragAction: u32) -> ::nserror::nsresult,

    /* readonly attribute unsigned long numDropItems; */
    pub GetNumDropItems: unsafe extern "system" fn (this: *const nsIDragSession, aNumDropItems: *mut u32) -> ::nserror::nsresult,

    /* [infallible] attribute WindowContext sourceWindowContext; */
    pub GetSourceWindowContext: unsafe extern "system" fn (this: *const nsIDragSession, aSourceWindowContext: *mut *const libc::c_void) -> ::nserror::nsresult,

    /* [infallible] attribute WindowContext sourceWindowContext; */
    pub SetSourceWindowContext: unsafe extern "system" fn (this: *const nsIDragSession, aSourceWindowContext: *const libc::c_void) -> ::nserror::nsresult,

    /* [infallible] attribute WindowContext sourceTopWindowContext; */
    pub GetSourceTopWindowContext: unsafe extern "system" fn (this: *const nsIDragSession, aSourceTopWindowContext: *mut *const libc::c_void) -> ::nserror::nsresult,

    /* [infallible] attribute WindowContext sourceTopWindowContext; */
    pub SetSourceTopWindowContext: unsafe extern "system" fn (this: *const nsIDragSession, aSourceTopWindowContext: *const libc::c_void) -> ::nserror::nsresult,

    /* readonly attribute Node sourceNode; */
    pub GetSourceNode: unsafe extern "system" fn (this: *const nsIDragSession, aSourceNode: *mut *const libc::c_void) -> ::nserror::nsresult,

    /* [nostdcall,notxpcom] void updateSource (in Node aNewSourceNode, in Selection aNewSelection); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub UpdateSource: *const ::libc::c_void,

    /* attribute nsIPrincipal triggeringPrincipal; */
    pub GetTriggeringPrincipal: unsafe extern "system" fn (this: *const nsIDragSession, aTriggeringPrincipal: *mut*const nsIPrincipal) -> ::nserror::nsresult,

    /* attribute nsIPrincipal triggeringPrincipal; */
    pub SetTriggeringPrincipal: unsafe extern "system" fn (this: *const nsIDragSession, aTriggeringPrincipal: *const nsIPrincipal) -> ::nserror::nsresult,

    /* attribute nsIPolicyContainer policyContainer; */
    pub GetPolicyContainer: unsafe extern "system" fn (this: *const nsIDragSession, aPolicyContainer: *mut*const nsIPolicyContainer) -> ::nserror::nsresult,

    /* attribute nsIPolicyContainer policyContainer; */
    pub SetPolicyContainer: unsafe extern "system" fn (this: *const nsIDragSession, aPolicyContainer: *const nsIPolicyContainer) -> ::nserror::nsresult,

    /* [binaryname(DataTransferXPCOM)] attribute DataTransfer dataTransfer; */
    pub GetDataTransferXPCOM: unsafe extern "system" fn (this: *const nsIDragSession, aDataTransfer: *mut *const libc::c_void) -> ::nserror::nsresult,

    /* [binaryname(DataTransferXPCOM)] attribute DataTransfer dataTransfer; */
    pub SetDataTransferXPCOM: unsafe extern "system" fn (this: *const nsIDragSession, aDataTransfer: *const libc::c_void) -> ::nserror::nsresult,

    /* [nostdcall,notxpcom] DataTransfer getDataTransfer (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub GetDataTransfer: *const ::libc::c_void,

    /* [nostdcall,notxpcom] void setDataTransfer (in DataTransfer aDataTransfer); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub SetDataTransfer: *const ::libc::c_void,

    /* void getData (in nsITransferable aTransferable, in unsigned long aItemIndex); */
    pub GetData: unsafe extern "system" fn (this: *const nsIDragSession, aTransferable: *const nsITransferable, aItemIndex: u32) -> ::nserror::nsresult,

    /* boolean isDataFlavorSupported (in string aDataFlavor); */
    pub IsDataFlavorSupported: unsafe extern "system" fn (this: *const nsIDragSession, aDataFlavor: *const libc::c_char, _retval: *mut bool) -> ::nserror::nsresult,

    /* void userCancelled (); */
    pub UserCancelled: unsafe extern "system" fn (this: *const nsIDragSession) -> ::nserror::nsresult,

    /* void dragEventDispatchedToChildProcess (); */
    pub DragEventDispatchedToChildProcess: unsafe extern "system" fn (this: *const nsIDragSession) -> ::nserror::nsresult,

    /* void updateDragEffect (); */
    pub UpdateDragEffect: unsafe extern "system" fn (this: *const nsIDragSession) -> ::nserror::nsresult,

    /* void updateDragImage (in Node aImage, in long aImageX, in long aImageY); */
    pub UpdateDragImage: unsafe extern "system" fn (this: *const nsIDragSession, aImage: *const libc::c_void, aImageX: i32, aImageY: i32) -> ::nserror::nsresult,

    /* [noscript] void InitForTests (in uint32_t aAllowedEffect); */
    pub InitForTests: unsafe extern "system" fn (this: *const nsIDragSession, aAllowedEffect: u32) -> ::nserror::nsresult,

    /* [nostdcall,notxpcom] unsigned long getEffectAllowedForTests (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub GetEffectAllowedForTests: *const ::libc::c_void,

    /* [nostdcall,notxpcom] boolean isSynthesizedForTests (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub IsSynthesizedForTests: *const ::libc::c_void,

    /* void setDragEndPoint (in long aScreenX, in long aScreenY); */
    pub SetDragEndPoint: unsafe extern "system" fn (this: *const nsIDragSession, aScreenX: i32, aScreenY: i32) -> ::nserror::nsresult,

    /* void setDragEndPointForTests (in float aScreenX, in float aScreenY); */
    pub SetDragEndPointForTests: unsafe extern "system" fn (this: *const nsIDragSession, aScreenX: libc::c_float, aScreenY: libc::c_float) -> ::nserror::nsresult,

    /* [nostdcall,notxpcom] boolean isDraggingTextInTextControl (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub IsDraggingTextInTextControl: *const ::libc::c_void,

    /* [noscript] void maybeEditorDeletedSourceNode (in Element aEditingHost); */
    pub MaybeEditorDeletedSourceNode: unsafe extern "system" fn (this: *const nsIDragSession, aEditingHost: *const libc::c_void) -> ::nserror::nsresult,

    /* [noscript] void dragMoved (in long aX, in long aY); */
    pub DragMoved: unsafe extern "system" fn (this: *const nsIDragSession, aX: i32, aY: i32) -> ::nserror::nsresult,

    /* [can_run_script,noscript] void fireDragEventAtSource (in EventMessage aEventMessage, in unsigned long aKeyModifiers); */
    /// Unable to generate binding because `Rust only supports [ref] / [ptr] native types`
    pub FireDragEventAtSource: *const ::libc::c_void,

    /* [nostdcall,notxpcom] boolean maybeAddBrowser (in BrowserParentPtr aBP); */
    /// Unable to generate binding because `native type mozilla::dom::BrowserParent unsupported`
    pub MaybeAddBrowser: *const ::libc::c_void,

    /* [nostdcall,notxpcom] boolean removeAllBrowsers (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub RemoveAllBrowsers: *const ::libc::c_void,

    /* [can_run_script] void endDragSession (in boolean aDoneDrag, [optional] in unsigned long aKeyModifiers); */
    pub EndDragSession: unsafe extern "system" fn (this: *const nsIDragSession, aDoneDrag: bool, aKeyModifiers: u32) -> ::nserror::nsresult,

    /* void sendStoreDropTargetAndDelayEndDragSession (in DragEvent aEvent); */
    pub SendStoreDropTargetAndDelayEndDragSession: unsafe extern "system" fn (this: *const nsIDragSession, aEvent: *const libc::c_void) -> ::nserror::nsresult,

    /* void sendDispatchToDropTargetAndResumeEndDragSession (in boolean aShouldDrop, in Array<nsIFile> aAllowedFiles); */
    pub SendDispatchToDropTargetAndResumeEndDragSession: unsafe extern "system" fn (this: *const nsIDragSession, aShouldDrop: bool, aAllowedFiles: *const thin_vec::ThinVec<Option<RefPtr<nsIFile>>>) -> ::nserror::nsresult,

    /* [noscript] void storeDropTargetAndDelayEndDragSession (in Element aElement, in nsIFramePtr aDocFrame); */
    /// Unable to generate binding because `native type nsIFrame unsupported`
    pub StoreDropTargetAndDelayEndDragSession: *const ::libc::c_void,

    /* [can_run_script,noscript] void dispatchToDropTargetAndResumeEndDragSession (in nsIWidgetPtr aWidget, [const] in LayoutDeviceIntPoint aPt, in boolean aShouldDrop, in StringSet aAllowedFilePaths); */
    /// Unable to generate binding because `native type nsIWidget unsupported`
    pub DispatchToDropTargetAndResumeEndDragSession: *const ::libc::c_void,

    /* [nostdcall,notxpcom] boolean mustUpdateDataTransfer (in EventMessage aMessage); */
    /// Unable to generate binding because `Rust only supports [ref] / [ptr] native types`
    pub MustUpdateDataTransfer: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIDragSession {

    /// ```text
    /// /**
    ///     * Set the current state of the drag, whether it can be dropped or not.
    ///     * usually the target "frame" sets this so the native system can render the correct feedback
    ///     */
    /// ```
    ///

    /// `attribute boolean canDrop;`
    #[inline]
    pub unsafe fn GetCanDrop(&self, aCanDrop: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetCanDrop)(self, aCanDrop)
    }


    /// ```text
    /// /**
    ///     * Set the current state of the drag, whether it can be dropped or not.
    ///     * usually the target "frame" sets this so the native system can render the correct feedback
    ///     */
    /// ```
    ///

    /// `attribute boolean canDrop;`
    #[inline]
    pub unsafe fn SetCanDrop(&self, aCanDrop: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetCanDrop)(self, aCanDrop)
    }


    /// ```text
    /// /**
    ///    * Indicates if the drop event should be dispatched only to chrome.
    ///    */
    /// ```
    ///

    /// `attribute boolean onlyChromeDrop;`
    #[inline]
    pub unsafe fn GetOnlyChromeDrop(&self, aOnlyChromeDrop: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetOnlyChromeDrop)(self, aOnlyChromeDrop)
    }


    /// ```text
    /// /**
    ///    * Indicates if the drop event should be dispatched only to chrome.
    ///    */
    /// ```
    ///

    /// `attribute boolean onlyChromeDrop;`
    #[inline]
    pub unsafe fn SetOnlyChromeDrop(&self, aOnlyChromeDrop: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetOnlyChromeDrop)(self, aOnlyChromeDrop)
    }


    /// ```text
    /// /**
    ///     * Sets the action (copy, move, link, et.c) for the current drag
    ///     */
    /// ```
    ///

    /// `attribute unsigned long dragAction;`
    #[inline]
    pub unsafe fn GetDragAction(&self, aDragAction: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).GetDragAction)(self, aDragAction)
    }


    /// ```text
    /// /**
    ///     * Sets the action (copy, move, link, et.c) for the current drag
    ///     */
    /// ```
    ///

    /// `attribute unsigned long dragAction;`
    #[inline]
    pub unsafe fn SetDragAction(&self, aDragAction: u32) -> ::nserror::nsresult {
        ((*self.vtable).SetDragAction)(self, aDragAction)
    }


    /// ```text
    /// /**
    ///     * Get the number of items that were dropped
    ///     */
    /// ```
    ///

    /// `readonly attribute unsigned long numDropItems;`
    #[inline]
    pub unsafe fn GetNumDropItems(&self, aNumDropItems: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).GetNumDropItems)(self, aNumDropItems)
    }


    /// ```text
    /// /**
    ///     * The window context where the drag was started, which will be null if the
    ///     * drag originated outside the application. Useful for determining if a drop
    ///     * originated in the same window context.
    ///     */
    /// ```
    ///

    /// `[infallible] attribute WindowContext sourceWindowContext;`
    #[inline]
    pub unsafe fn GetSourceWindowContext(&self, aSourceWindowContext: *mut *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetSourceWindowContext)(self, aSourceWindowContext)
    }


    /// ```text
    /// /**
    ///     * The window context where the drag was started, which will be null if the
    ///     * drag originated outside the application. Useful for determining if a drop
    ///     * originated in the same window context.
    ///     */
    /// ```
    ///

    /// `[infallible] attribute WindowContext sourceWindowContext;`
    #[inline]
    pub unsafe fn SetSourceWindowContext(&self, aSourceWindowContext: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).SetSourceWindowContext)(self, aSourceWindowContext)
    }


    /// ```text
    /// /**
    ///     * The top-level window context where the drag was started, which will be
    ///     * null if the drag originated outside the application. Useful for
    ///     * determining if a drop originated in the same top-level window context.
    ///     */
    /// ```
    ///

    /// `[infallible] attribute WindowContext sourceTopWindowContext;`
    #[inline]
    pub unsafe fn GetSourceTopWindowContext(&self, aSourceTopWindowContext: *mut *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetSourceTopWindowContext)(self, aSourceTopWindowContext)
    }


    /// ```text
    /// /**
    ///     * The top-level window context where the drag was started, which will be
    ///     * null if the drag originated outside the application. Useful for
    ///     * determining if a drop originated in the same top-level window context.
    ///     */
    /// ```
    ///

    /// `[infallible] attribute WindowContext sourceTopWindowContext;`
    #[inline]
    pub unsafe fn SetSourceTopWindowContext(&self, aSourceTopWindowContext: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).SetSourceTopWindowContext)(self, aSourceTopWindowContext)
    }


    /// ```text
    /// /**
    ///     * The dom node that was originally dragged to start the session, which will be null if the
    ///     * drag originated outside the application.
    ///     */
    /// ```
    ///

    /// `readonly attribute Node sourceNode;`
    #[inline]
    pub unsafe fn GetSourceNode(&self, aSourceNode: *mut *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetSourceNode)(self, aSourceNode)
    }


    /// ```text
    /// /**
    ///    * Replace source node and selection with new ones.
    ///    * If sourceNode is a native anonymous node, it may be replaced at reframing.
    ///    * If sourceNode is disconnected from the document, we cannot dispatch
    ///    * `dragend` event properly.
    ///    * When this is called, sourceNode or aNewSourceNode should be a native
    ///    * anonymous node.
    ///    */
    /// ```
    ///

    /// `[nostdcall,notxpcom] void updateSource (in Node aNewSourceNode, in Selection aNewSelection);`
    const _UpdateSource: () = ();

    /// ```text
    /// /**
    ///    * the triggering principal.  This may be different than sourceNode's
    ///    * principal when sourceNode is xul:browser and the drag is
    ///    * triggered in a browsing context inside it.
    ///    */
    /// ```
    ///

    /// `attribute nsIPrincipal triggeringPrincipal;`
    #[inline]
    pub unsafe fn GetTriggeringPrincipal(&self, aTriggeringPrincipal: *mut*const nsIPrincipal) -> ::nserror::nsresult {
        ((*self.vtable).GetTriggeringPrincipal)(self, aTriggeringPrincipal)
    }


    /// ```text
    /// /**
    ///    * the triggering principal.  This may be different than sourceNode's
    ///    * principal when sourceNode is xul:browser and the drag is
    ///    * triggered in a browsing context inside it.
    ///    */
    /// ```
    ///

    /// `attribute nsIPrincipal triggeringPrincipal;`
    #[inline]
    pub unsafe fn SetTriggeringPrincipal(&self, aTriggeringPrincipal: *const nsIPrincipal) -> ::nserror::nsresult {
        ((*self.vtable).SetTriggeringPrincipal)(self, aTriggeringPrincipal)
    }


    /// ```text
    /// /**
    ///    * the triggering policyContainer.  This may be different than sourceNode's
    ///    * policyContainer when sourceNode is xul:browser and the drag is
    ///    * triggered in a browsing context inside it.
    ///    */
    /// ```
    ///

    /// `attribute nsIPolicyContainer policyContainer;`
    #[inline]
    pub unsafe fn GetPolicyContainer(&self, aPolicyContainer: *mut*const nsIPolicyContainer) -> ::nserror::nsresult {
        ((*self.vtable).GetPolicyContainer)(self, aPolicyContainer)
    }


    /// ```text
    /// /**
    ///    * the triggering policyContainer.  This may be different than sourceNode's
    ///    * policyContainer when sourceNode is xul:browser and the drag is
    ///    * triggered in a browsing context inside it.
    ///    */
    /// ```
    ///

    /// `attribute nsIPolicyContainer policyContainer;`
    #[inline]
    pub unsafe fn SetPolicyContainer(&self, aPolicyContainer: *const nsIPolicyContainer) -> ::nserror::nsresult {
        ((*self.vtable).SetPolicyContainer)(self, aPolicyContainer)
    }


    /// ```text
    /// /**
    ///    * The data transfer object for the current drag.
    ///    */
    /// ```
    ///

    /// `[binaryname(DataTransferXPCOM)] attribute DataTransfer dataTransfer;`
    #[inline]
    pub unsafe fn GetDataTransferXPCOM(&self, aDataTransfer: *mut *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).GetDataTransferXPCOM)(self, aDataTransfer)
    }


    /// ```text
    /// /**
    ///    * The data transfer object for the current drag.
    ///    */
    /// ```
    ///

    /// `[binaryname(DataTransferXPCOM)] attribute DataTransfer dataTransfer;`
    #[inline]
    pub unsafe fn SetDataTransferXPCOM(&self, aDataTransfer: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).SetDataTransferXPCOM)(self, aDataTransfer)
    }



    /// `[nostdcall,notxpcom] DataTransfer getDataTransfer ();`
    const _GetDataTransfer: () = ();


    /// `[nostdcall,notxpcom] void setDataTransfer (in DataTransfer aDataTransfer);`
    const _SetDataTransfer: () = ();

    /// ```text
    /// /**
    ///     * Get data from a Drag&Drop. Can be called while the drag is in process
    ///     * or after the drop has completed.
    ///     *
    ///     * @param  aTransferable the transferable for the data to be put into
    ///     * @param  aItemIndex which of multiple drag items, zero-based
    ///     */
    /// ```
    ///

    /// `void getData (in nsITransferable aTransferable, in unsigned long aItemIndex);`
    #[inline]
    pub unsafe fn GetData(&self, aTransferable: *const nsITransferable, aItemIndex: u32) -> ::nserror::nsresult {
        ((*self.vtable).GetData)(self, aTransferable, aItemIndex)
    }


    /// ```text
    /// /**
    ///     * Check to set if any of the native data on the clipboard matches this data flavor
    ///     */
    /// ```
    ///

    /// `boolean isDataFlavorSupported (in string aDataFlavor);`
    #[inline]
    pub unsafe fn IsDataFlavorSupported(&self, aDataFlavor: *const libc::c_char, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).IsDataFlavorSupported)(self, aDataFlavor, _retval)
    }



    /// `void userCancelled ();`
    #[inline]
    pub unsafe fn UserCancelled(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).UserCancelled)(self, )
    }



    /// `void dragEventDispatchedToChildProcess ();`
    #[inline]
    pub unsafe fn DragEventDispatchedToChildProcess(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).DragEventDispatchedToChildProcess)(self, )
    }



    /// `void updateDragEffect ();`
    #[inline]
    pub unsafe fn UpdateDragEffect(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).UpdateDragEffect)(self, )
    }



    /// `void updateDragImage (in Node aImage, in long aImageX, in long aImageY);`
    #[inline]
    pub unsafe fn UpdateDragImage(&self, aImage: *const libc::c_void, aImageX: i32, aImageY: i32) -> ::nserror::nsresult {
        ((*self.vtable).UpdateDragImage)(self, aImage, aImageX, aImageY)
    }


    /// ```text
    /// /**
    ///    * Tell Gecko that this session is generated for automated testing.
    ///    * This should be called immediately after StartDragSession when testing.
    ///    */
    /// ```
    ///

    /// `[noscript] void InitForTests (in uint32_t aAllowedEffect);`
    #[inline]
    pub unsafe fn InitForTests(&self, aAllowedEffect: u32) -> ::nserror::nsresult {
        ((*self.vtable).InitForTests)(self, aAllowedEffect)
    }


    /// ```text
    /// /**
    ///    * Returns effects allowed at starting the session for tests.
    ///    */
    /// ```
    ///

    /// `[nostdcall,notxpcom] unsigned long getEffectAllowedForTests ();`
    const _GetEffectAllowedForTests: () = ();

    /// ```text
    /// /**
    ///    * Returns true if current session was started with synthesized drag start.
    ///    */
    /// ```
    ///

    /// `[nostdcall,notxpcom] boolean isSynthesizedForTests ();`
    const _IsSynthesizedForTests: () = ();

    /// ```text
    /// /**
    ///    * Sets the drag end point.  Position is relative to screen in device coords.
    ///    */
    /// ```
    ///

    /// `void setDragEndPoint (in long aScreenX, in long aScreenY);`
    #[inline]
    pub unsafe fn SetDragEndPoint(&self, aScreenX: i32, aScreenY: i32) -> ::nserror::nsresult {
        ((*self.vtable).SetDragEndPoint)(self, aScreenX, aScreenY)
    }


    /// ```text
    /// /**
    ///    * Sets drag end point of synthesized session when the test does not dispatch
    ///    * "drop" event.  Position is relative to screen in CSS coordinates.
    ///    */
    /// ```
    ///

    /// `void setDragEndPointForTests (in float aScreenX, in float aScreenY);`
    #[inline]
    pub unsafe fn SetDragEndPointForTests(&self, aScreenX: libc::c_float, aScreenY: libc::c_float) -> ::nserror::nsresult {
        ((*self.vtable).SetDragEndPointForTests)(self, aScreenX, aScreenY)
    }


    /// ```text
    /// /**
    ///    * Returns true if the session is for dragging text in a text in text control
    ///    * element.
    ///    */
    /// ```
    ///

    /// `[nostdcall,notxpcom] boolean isDraggingTextInTextControl ();`
    const _IsDraggingTextInTextControl: () = ();

    /// ```text
    /// /**
    ///    * Called when HTMLEditor maybe deleted the source node from the document.
    ///    *
    ///    * @param aEditingHost    The editing host when the editor deletes selection.
    ///    */
    /// ```
    ///

    /// `[noscript] void maybeEditorDeletedSourceNode (in Element aEditingHost);`
    #[inline]
    pub unsafe fn MaybeEditorDeletedSourceNode(&self, aEditingHost: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).MaybeEditorDeletedSourceNode)(self, aEditingHost)
    }


    /// ```text
    /// /**
    ///     * Sets the position for the Gecko-drawn dragged-contents image.
    ///     * aX and aY are in LayoutDevice pixels.
    ///     */
    /// ```
    ///

    /// `[noscript] void dragMoved (in long aX, in long aY);`
    #[inline]
    pub unsafe fn DragMoved(&self, aX: i32, aY: i32) -> ::nserror::nsresult {
        ((*self.vtable).DragMoved)(self, aX, aY)
    }


    /// ```text
    /// /**
    ///    * Fire a drag event at the source of the drag
    ///    */
    /// ```
    ///

    /// `[can_run_script,noscript] void fireDragEventAtSource (in EventMessage aEventMessage, in unsigned long aKeyModifiers);`
    const _FireDragEventAtSource: () = ();


    /// `[nostdcall,notxpcom] boolean maybeAddBrowser (in BrowserParentPtr aBP);`
    const _MaybeAddBrowser: () = ();


    /// `[nostdcall,notxpcom] boolean removeAllBrowsers ();`
    const _RemoveAllBrowsers: () = ();

    /// ```text
    /// /**
    ///     * Tells the Drag Service to end a drag session.
    ///     *
    ///     * If aDoneDrag is true, the drag has finished, otherwise the drag has
    ///     * just left the window.
    ///     *
    ///     * @param aDoneDrag       If true, reports the drag as complete.
    ///     * @param aKeyModifiers   Key state to assume while ending the session.
    ///     */
    /// ```
    ///

    /// `[can_run_script] void endDragSession (in boolean aDoneDrag, [optional] in unsigned long aKeyModifiers);`
    #[inline]
    pub unsafe fn EndDragSession(&self, aDoneDrag: bool, aKeyModifiers: u32) -> ::nserror::nsresult {
        ((*self.vtable).EndDragSession)(self, aDoneDrag, aKeyModifiers)
    }


    /// ```text
    /// /**
    ///    * Tell the drag session for the given browser that it
    ///    * should store the would-be target of the aEvent (a drop event) and delay
    ///    * calls to EndDragSession.  This is used in the main process.
    ///    *
    ///    * @param aEvent The drag event
    ///    */
    /// ```
    ///

    /// `void sendStoreDropTargetAndDelayEndDragSession (in DragEvent aEvent);`
    #[inline]
    pub unsafe fn SendStoreDropTargetAndDelayEndDragSession(&self, aEvent: *const libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).SendStoreDropTargetAndDelayEndDragSession)(self, aEvent)
    }


    /// ```text
    /// /**
    ///    * After sendStoreDropTargetAndDelayEndDragSession, send a drop (if
        ///    * aShouldDrop is true) or dragexit event to the recorded drop target and
    ///    * then reissue any stored EndDragSession call.  This is used in the main
    ///    * process.
    ///    *
    ///    * @param aShouldDrop  True to send drop event, false to send dragexit event
    ///    */
    /// ```
    ///

    /// `void sendDispatchToDropTargetAndResumeEndDragSession (in boolean aShouldDrop, in Array<nsIFile> aAllowedFiles);`
    #[inline]
    pub unsafe fn SendDispatchToDropTargetAndResumeEndDragSession(&self, aShouldDrop: bool, aAllowedFiles: *const thin_vec::ThinVec<Option<RefPtr<nsIFile>>>) -> ::nserror::nsresult {
        ((*self.vtable).SendDispatchToDropTargetAndResumeEndDragSession)(self, aShouldDrop, aAllowedFiles)
    }


    /// ```text
    /// /**
    ///    * Store aElement and aDocFrame as the future drop/dragexit context, and
    ///    * delay calls to EndDragSession.  This is used in content processes.
    ///    *
    ///    * @param aElement        The element to drop onto
    ///    * @param aDocFrame       The frame to dispatch to
    ///    */
    /// ```
    ///

    /// `[noscript] void storeDropTargetAndDelayEndDragSession (in Element aElement, in nsIFramePtr aDocFrame);`
    const _StoreDropTargetAndDelayEndDragSession: () = ();

    /// ```text
    /// /**
    ///    * Issue drop or dragexit to the stored drop target (if any) and issue
    ///    * any delayed call to EndDragSession.  This is used in content processes.
    ///    *
    ///    * @param aWidget           The widget on which the drop will happen
    ///    * @param aPt               Screen coords of drop
    ///    * @param aShouldDrop       If true, send a drop event.  Otherwise send dragexit.
    ///    * @param aAllowedFilePaths Paths to the files that were allowed to be dropped.
    ///    */
    /// ```
    ///

    /// `[can_run_script,noscript] void dispatchToDropTargetAndResumeEndDragSession (in nsIWidgetPtr aWidget, [const] in LayoutDeviceIntPoint aPt, in boolean aShouldDrop, in StringSet aAllowedFilePaths);`
    const _DispatchToDropTargetAndResumeEndDragSession: () = ();

    /// ```text
    /// /**
    ///    * Retrun true if nsIDragSession's data is updated.
    ///    */
    /// ```
    ///

    /// `[nostdcall,notxpcom] boolean mustUpdateDataTransfer (in EventMessage aMessage);`
    const _MustUpdateDataTransfer: () = ();

}


