//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/glean/xpcom/nsIFOG.idl
//


/// `interface nsIFOG : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIFOG {
    vtable: &'static nsIFOGVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIFOG.
unsafe impl XpCom for nsIFOG {
    const IID: nsIID = nsID(0x98d0e975, 0x9cad, 0x4ce3,
        [0xae, 0x2f, 0xf8, 0x78, 0xb8, 0xbe, 0x63, 0x07]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIFOG {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIFOG.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIFOGCoerce {
    /// Cheaply cast a value of this type from a `nsIFOG`.
    fn coerce_from(v: &nsIFOG) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIFOGCoerce for nsIFOG {
    #[inline]
    fn coerce_from(v: &nsIFOG) -> &Self {
        v
    }
}

impl nsIFOG {
    /// Cast this `nsIFOG` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIFOGCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIFOG {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIFOGCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIFOG) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIFOG
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIFOGVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void initializeFOG ([optional] in AUTF8String aDataPathOverride, [optional] in AUTF8String aAppIdOverride, [optional] in boolean aDisableInternalPings); */
    pub InitializeFOG: unsafe extern "system" fn (this: *const nsIFOG, aDataPathOverride: *const ::nsstring::nsACString, aAppIdOverride: *const ::nsstring::nsACString, aDisableInternalPings: bool) -> ::nserror::nsresult,

    /* void registerCustomPings (); */
    pub RegisterCustomPings: unsafe extern "system" fn (this: *const nsIFOG) -> ::nserror::nsresult,

    /* void setLogPings (in boolean aEnableLogPings); */
    pub SetLogPings: unsafe extern "system" fn (this: *const nsIFOG, aEnableLogPings: bool) -> ::nserror::nsresult,

    /* void setTagPings (in ACString aDebugTag); */
    pub SetTagPings: unsafe extern "system" fn (this: *const nsIFOG, aDebugTag: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void sendPing (in ACString aPingName); */
    pub SendPing: unsafe extern "system" fn (this: *const nsIFOG, aPingName: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [implicit_jscontext] void setExperimentActive (in ACString aExperimentId, in ACString aBranch, [optional] in jsval aExtra); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub SetExperimentActive: *const ::libc::c_void,

    /* void setExperimentInactive (in ACString aExperimentId); */
    pub SetExperimentInactive: unsafe extern "system" fn (this: *const nsIFOG, aExperimentId: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [implicit_jscontext] jsval testGetExperimentData (in ACString aExperimentId); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub TestGetExperimentData: *const ::libc::c_void,

    /* void applyServerKnobsConfig (in ACString aJsonConfig); */
    pub ApplyServerKnobsConfig: unsafe extern "system" fn (this: *const nsIFOG, aJsonConfig: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [implicit_jscontext] Promise testFlushAllChildren (); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub TestFlushAllChildren: *const ::libc::c_void,

    /* void testResetFOG ([optional] in AUTF8String aDataPathOverride, [optional] in AUTF8String aAppIdOverride); */
    pub TestResetFOG: unsafe extern "system" fn (this: *const nsIFOG, aDataPathOverride: *const ::nsstring::nsACString, aAppIdOverride: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [implicit_jscontext] Promise testTriggerMetrics (in unsigned long aProcessType); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub TestTriggerMetrics: *const ::libc::c_void,

    /* uint32_t testRegisterRuntimeMetric (in ACString aType, in ACString aCategory, in ACString aName, in Array<ACString> aPings, in ACString aLifetime, in boolean aDisabled, [optional] in ACString aExtraArgs); */
    pub TestRegisterRuntimeMetric: unsafe extern "system" fn (this: *const nsIFOG, aType: *const ::nsstring::nsACString, aCategory: *const ::nsstring::nsACString, aName: *const ::nsstring::nsACString, aPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aLifetime: *const ::nsstring::nsACString, aDisabled: bool, aExtraArgs: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult,

    /* uint32_t testRegisterRuntimePing (in ACString aName, in boolean aIncludeClientId, in boolean aSendIfEmpty, in boolean aPreciseTimestamps, in boolean aIncludeInfoSections, in boolean aEnabled, in Array<ACString> aSchedulesPings, in Array<ACString> aReasonCodes, in boolean aFollowsCollectionEnabled, in Array<ACString> aUploaderCapabilities); */
    pub TestRegisterRuntimePing: unsafe extern "system" fn (this: *const nsIFOG, aName: *const ::nsstring::nsACString, aIncludeClientId: bool, aSendIfEmpty: bool, aPreciseTimestamps: bool, aIncludeInfoSections: bool, aEnabled: bool, aSchedulesPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aReasonCodes: *const thin_vec::ThinVec<::nsstring::nsCString>, aFollowsCollectionEnabled: bool, aUploaderCapabilities: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut u32) -> ::nserror::nsresult,

    /* void updateAttribution (in ACString aSource, in ACString aMedium, in ACString aCampaign, in ACString aTerm, in ACString aContent); */
    pub UpdateAttribution: unsafe extern "system" fn (this: *const nsIFOG, aSource: *const ::nsstring::nsACString, aMedium: *const ::nsstring::nsACString, aCampaign: *const ::nsstring::nsACString, aTerm: *const ::nsstring::nsACString, aContent: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [implicit_jscontext] jsval testGetAttribution (); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub TestGetAttribution: *const ::libc::c_void,

    /* void updateDistribution (in ACString aName); */
    pub UpdateDistribution: unsafe extern "system" fn (this: *const nsIFOG, aName: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [implicit_jscontext] jsval testGetDistribution (); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub TestGetDistribution: *const ::libc::c_void,

    /* void registerRuntimeMetric (in ACString aType, in ACString aCategory, in ACString aName, in Array<ACString> aPings, in ACString aLifetime, in boolean aDisabled, [optional] in ACString aExtraArgs); */
    pub RegisterRuntimeMetric: unsafe extern "system" fn (this: *const nsIFOG, aType: *const ::nsstring::nsACString, aCategory: *const ::nsstring::nsACString, aName: *const ::nsstring::nsACString, aPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aLifetime: *const ::nsstring::nsACString, aDisabled: bool, aExtraArgs: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void registerRuntimePing (in ACString aName, in boolean aIncludeClientId, in boolean aSendIfEmpty, in boolean aPreciseTimestamps, in boolean aIncludeInfoSections, in boolean aEnabled, in Array<ACString> aSchedulesPings, in Array<ACString> aReasonCodes, in boolean aFollowsCollectionEnabled, in Array<ACString> aUploaderCapabilities); */
    pub RegisterRuntimePing: unsafe extern "system" fn (this: *const nsIFOG, aName: *const ::nsstring::nsACString, aIncludeClientId: bool, aSendIfEmpty: bool, aPreciseTimestamps: bool, aIncludeInfoSections: bool, aEnabled: bool, aSchedulesPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aReasonCodes: *const thin_vec::ThinVec<::nsstring::nsCString>, aFollowsCollectionEnabled: bool, aUploaderCapabilities: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIFOG {

    /// ```text
    /// /**
    ///    * Initialize FOG.
    ///    *
    ///    * Call it eventually. Metric data recorded beforehand will be buffered.
    ///    *
    ///    * @param aDataPathOverride - The path of a custom Glean data path to use
    ///    *        instead of the profile dir.
    ///    * @param aAppIdOverride - The application_id to use instead of
    ///    *        "firefox.desktop".
    ///    * @param aDisableInternalPings - Whether to disable internal pings (baseline, events, metrics).
    ///    *        Default: false.
    ///    */
    /// ```
    ///

    /// `void initializeFOG ([optional] in AUTF8String aDataPathOverride, [optional] in AUTF8String aAppIdOverride, [optional] in boolean aDisableInternalPings);`
    #[inline]
    pub unsafe fn InitializeFOG(&self, aDataPathOverride: *const ::nsstring::nsACString, aAppIdOverride: *const ::nsstring::nsACString, aDisableInternalPings: bool) -> ::nserror::nsresult {
        ((*self.vtable).InitializeFOG)(self, aDataPathOverride, aAppIdOverride, aDisableInternalPings)
    }


    /// ```text
    /// /**
    ///    * Register custom pings.
    ///    *
    ///    * Ensure all custom pings are registered with Glean.
    ///    */
    /// ```
    ///

    /// `void registerCustomPings ();`
    #[inline]
    pub unsafe fn RegisterCustomPings(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).RegisterCustomPings)(self, )
    }


    /// ```text
    /// /**
    ///    * Enable or Disable the logging of pings in the Glean SDK.
    ///    * See https://firefox-source-docs.mozilla.org/toolkit/components/glean/dev/testing.html
    ///    * for details.
    ///    *
    ///    * @param aEnableLogPings - true to enable logging, false to disable.
    ///    */
    /// ```
    ///

    /// `void setLogPings (in boolean aEnableLogPings);`
    #[inline]
    pub unsafe fn SetLogPings(&self, aEnableLogPings: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetLogPings)(self, aEnableLogPings)
    }


    /// ```text
    /// /**
    ///    * Set the tag to be applied to pings assembled from now on.
    ///    * See https://firefox-source-docs.mozilla.org/toolkit/components/glean/dev/testing.html
    ///    * for details.
    ///    *
    ///    * @param aDebugTag - The string tag to apply.
    ///    *                    If it cannot be applied (e.g it contains characters that are
        ///    *                    forbidden in HTTP headers) the old value will remain.
    ///    */
    /// ```
    ///

    /// `void setTagPings (in ACString aDebugTag);`
    #[inline]
    pub unsafe fn SetTagPings(&self, aDebugTag: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetTagPings)(self, aDebugTag)
    }


    /// ```text
    /// /**
    ///    * Send the named ping.
    ///    * See https://firefox-source-docs.mozilla.org/toolkit/components/glean/dev/testing.html
    ///    * for details.
    ///    *
    ///    * @param aPingName - The name of the ping to send. If no ping of that name
    ///    *                    exists, or the ping is known but cannot be assembled
    ///    *                    (e.g if it is empty), no ping will be sent.
    ///    */
    /// ```
    ///

    /// `void sendPing (in ACString aPingName);`
    #[inline]
    pub unsafe fn SendPing(&self, aPingName: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SendPing)(self, aPingName)
    }


    /// ```text
    /// /**
    ///    * Indicate that an experiment is running.
    ///    * Glean will add an experiment annotation which is sent with pings.
    ///    * This information is not persisted between runs.
    ///    *
    ///    * See `glean_core::Glean::set_experiment_active`.
    ///    *
    ///    * Logs on error, but does not throw.
    ///    *
    ///    * @param aExperimentId - The id/slug of the experiment.
    ///    * @param aBranch - The name of the active branch of the experiment.
    ///    * @param aExtra - Optional string -> string dictionary of extra information.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] void setExperimentActive (in ACString aExperimentId, in ACString aBranch, [optional] in jsval aExtra);`
    const _SetExperimentActive: () = ();

    /// ```text
    /// /**
    ///    * Indicate that an experiment is no longer running.
    ///    *
    ///    * See `glean_core::Glean::set_experiment_inactive`.
    ///    *
    ///    * Logs on error, but does not throw.
    ///    *
    ///    * @param aExperimentId - The id/slug of the experiment from setExperimentActive.
    ///    */
    /// ```
    ///

    /// `void setExperimentInactive (in ACString aExperimentId);`
    #[inline]
    pub unsafe fn SetExperimentInactive(&self, aExperimentId: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetExperimentInactive)(self, aExperimentId)
    }


    /// ```text
    /// /**
    ///    * **Test-only API**
    ///    *
    ///    * If the identified experiment was set active and hasn't been set inactive,
    ///    * this will give you the active branch and extra information.
    ///    *
    ///    * @param aExperimentId - The id/slug of the experiment from setExperimentActive.
    ///    *
    ///    * @return an object of the form
    ///    *         {branch: "branch-name", extra: {extra_key1: extra_value1, ...}}
    ///    *         if there is an active experiment. Undefined, otherwise.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] jsval testGetExperimentData (in ACString aExperimentId);`
    const _TestGetExperimentData: () = ();

    /// ```text
    /// /**
    ///    * Set remote-configuration for metrics' disabled property.
    ///    *
    ///    * See [`glean_core::Glean::apply_server_knobs_config`]
    ///    *
    ///    * Logs on error, but does not throw.
    ///    *
    ///    * @param aJsonConfig - The stringified JSON object in the form
    ///    *        {metric_base_identifier: boolean,}
    ///    *        which may contain multiple metric object entries.
    ///    */
    /// ```
    ///

    /// `void applyServerKnobsConfig (in ACString aJsonConfig);`
    #[inline]
    pub unsafe fn ApplyServerKnobsConfig(&self, aJsonConfig: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).ApplyServerKnobsConfig)(self, aJsonConfig)
    }


    /// ```text
    /// /**
    ///    * ** Test-only Method **
    ///    *
    ///    * Flush all data from all child processes.
    ///    *
    ///    * @returns A promise that resolves when the data's been stored.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] Promise testFlushAllChildren ();`
    const _TestFlushAllChildren: () = ();

    /// ```text
    /// /**
    ///    * ** Test-only Method **
    ///    *
    ///    * Reset FOG and the Glean SDK, clearing storage.
    ///    */
    /// ```
    ///

    /// `void testResetFOG ([optional] in AUTF8String aDataPathOverride, [optional] in AUTF8String aAppIdOverride);`
    #[inline]
    pub unsafe fn TestResetFOG(&self, aDataPathOverride: *const ::nsstring::nsACString, aAppIdOverride: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).TestResetFOG)(self, aDataPathOverride, aAppIdOverride)
    }


    /// ```text
    /// /**
    ///    * ** Test-only Method **
    ///    *
    ///    * Trigger test metric instrumentation on the GPU, RDD or Socket process.
    ///    *
    ///    * @param aProcessType - A PROCESS_TYPE_* value from the constants defined
    ///    *                       in the nsIXULRuntime interface.
    ///    *
    ///    * @returns A promise that resolves when the test data has been added.
    ///    *          The promise will be rejected if the process type is not supported
    ///    *          or if sending the IPC to the child process fails.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] Promise testTriggerMetrics (in unsigned long aProcessType);`
    const _TestTriggerMetrics: () = ();

    /// ```text
    /// /**
    ///    * ** Test-only Method **
    ///    *
    ///    * Register a metric.
    ///    *
    ///    * This function is deliberately not too friendly to use. You probably aren't
    ///    * supposed to use it unless you're testing metric registration itself.
    ///    *
    ///    * @param aType - The metric's type.
    ///    * @param aCategory - The metric's category.
    ///    * @param aName - The metric's name.
    ///    * @param aPings - The pings to send it in.
    ///    * @param aLifetime - The metric's lifetime.
    ///    * @param aDisabled - Whether the metric, though existing, isn't enabled.
    ///    * @param aExtraArgs - Optional JSON string of extra args.
    ///    */
    /// ```
    ///

    /// `uint32_t testRegisterRuntimeMetric (in ACString aType, in ACString aCategory, in ACString aName, in Array<ACString> aPings, in ACString aLifetime, in boolean aDisabled, [optional] in ACString aExtraArgs);`
    #[inline]
    pub unsafe fn TestRegisterRuntimeMetric(&self, aType: *const ::nsstring::nsACString, aCategory: *const ::nsstring::nsACString, aName: *const ::nsstring::nsACString, aPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aLifetime: *const ::nsstring::nsACString, aDisabled: bool, aExtraArgs: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).TestRegisterRuntimeMetric)(self, aType, aCategory, aName, aPings, aLifetime, aDisabled, aExtraArgs, _retval)
    }


    /// ```text
    /// /**
    ///    * ** Test-only Method **
    ///    *
    ///    * Register a ping.
    ///    *
    ///    * This function is deliberately not too friendly to use. You probably aren't
    ///    * supposed to use it unless you're testing ping registration itself.
    ///    *
    ///    * @param aName - The ping's name.
    ///    * @param aIncludeClientId - Whether the ping should include the client_id.
    ///    * @param aSendIfEmpty - Whether the ping should send even if empty.
    ///    * @param aIncludeInfoSections - Whether the ping should include
    ///    *                               {client|ping}_info sections.
    ///    * TODO(jer): docs
    ///    * @param aReasonCodes - The list of valid reasons for ping submission.
    ///    */
    /// ```
    ///

    /// `uint32_t testRegisterRuntimePing (in ACString aName, in boolean aIncludeClientId, in boolean aSendIfEmpty, in boolean aPreciseTimestamps, in boolean aIncludeInfoSections, in boolean aEnabled, in Array<ACString> aSchedulesPings, in Array<ACString> aReasonCodes, in boolean aFollowsCollectionEnabled, in Array<ACString> aUploaderCapabilities);`
    #[inline]
    pub unsafe fn TestRegisterRuntimePing(&self, aName: *const ::nsstring::nsACString, aIncludeClientId: bool, aSendIfEmpty: bool, aPreciseTimestamps: bool, aIncludeInfoSections: bool, aEnabled: bool, aSchedulesPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aReasonCodes: *const thin_vec::ThinVec<::nsstring::nsCString>, aFollowsCollectionEnabled: bool, aUploaderCapabilities: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).TestRegisterRuntimePing)(self, aName, aIncludeClientId, aSendIfEmpty, aPreciseTimestamps, aIncludeInfoSections, aEnabled, aSchedulesPings, aReasonCodes, aFollowsCollectionEnabled, aUploaderCapabilities, _retval)
    }


    /// ```text
    /// /**
    ///    * Update the core attribution metrics in Glean.
    ///    *
    ///    * @param aSource - The product's attribution source (e.g. "google-play").
    ///    * @param aMedium - The product's attribution medium (e.g. "organic" for a search engine).
    ///    * @param aCampaign - The product's attribution campaign (e.g. "mozilla-org").
    ///    * @param aTerm - The product's attribution term (e.g. "browser with developer tools for android").
    ///    * @param aContent - The product's attribution content (e.g. "firefoxview").
    ///    */
    /// ```
    ///

    /// `void updateAttribution (in ACString aSource, in ACString aMedium, in ACString aCampaign, in ACString aTerm, in ACString aContent);`
    #[inline]
    pub unsafe fn UpdateAttribution(&self, aSource: *const ::nsstring::nsACString, aMedium: *const ::nsstring::nsACString, aCampaign: *const ::nsstring::nsACString, aTerm: *const ::nsstring::nsACString, aContent: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).UpdateAttribution)(self, aSource, aMedium, aCampaign, aTerm, aContent)
    }


    /// ```text
    /// /**
    ///    * ** Test-only Method **
    ///    *
    ///    * Returns the core attribution data from Glean.
    ///    *
    ///    * @returns the core attribution data from Glean in the form
    ///    *          `{source, medium, campaign, term, content}`.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] jsval testGetAttribution ();`
    const _TestGetAttribution: () = ();

    /// ```text
    /// /**
    ///    * Update the core distribution metrics in Glean.
    ///    *
    ///    * @param aName - The product's distribution name (e.g. "MozillaOnline").
    ///    */
    /// ```
    ///

    /// `void updateDistribution (in ACString aName);`
    #[inline]
    pub unsafe fn UpdateDistribution(&self, aName: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).UpdateDistribution)(self, aName)
    }


    /// ```text
    /// /**
    ///    * ** Test-only Method **
    ///    *
    ///    * Returns the core distribution data from Glean.
    ///    *
    ///    * @returns the core distribution data from Glean in the form `{name}`.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] jsval testGetDistribution ();`
    const _TestGetDistribution: () = ();

    /// ```text
    /// /**
    ///    * Creates and registers a metric as specified,
    ///    * making it and its APIs available on the JS Glean global.
    ///    *
    ///    * Main process only.
    ///    *
    ///    * Not necessary for most uses of FOG and Glean.
    ///    * If you're not sure if you should call this,
    ///    * err on the side of not calling it.
    ///    *
    ///    * @param aType - The metric's type (e.g., "counter", "string", etc.)
    ///    * @param aCategory - The metric's category (namespace)
    ///    * @param aName - The metric's name
    ///    * @param aPings - The pings to send this metric in
    ///    * @param aLifetime - The metric's lifetime (e.g., "ping", "application", "user")
    ///    * @param aDisabled - Whether the metric is disabled
    ///    * @param aExtraArgs - Optional JSON string of additional configuration
    ///    * @throws NS_ERROR_INVALID_ARG if required arguments are missing
    ///    * @throws NS_ERROR_FAILURE if registration fails
    ///    */
    /// ```
    ///

    /// `void registerRuntimeMetric (in ACString aType, in ACString aCategory, in ACString aName, in Array<ACString> aPings, in ACString aLifetime, in boolean aDisabled, [optional] in ACString aExtraArgs);`
    #[inline]
    pub unsafe fn RegisterRuntimeMetric(&self, aType: *const ::nsstring::nsACString, aCategory: *const ::nsstring::nsACString, aName: *const ::nsstring::nsACString, aPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aLifetime: *const ::nsstring::nsACString, aDisabled: bool, aExtraArgs: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).RegisterRuntimeMetric)(self, aType, aCategory, aName, aPings, aLifetime, aDisabled, aExtraArgs)
    }


    /// ```text
    /// /**
    ///    * Creates and registers a ping as specified,
    ///    * making it and its APIs available on the JS GleanPings global.
    ///    *
    ///    * Main process only.
    ///    *
    ///    * Not necessary for most uses of FOG and Glean.
    ///    * If you're not sure if you should call this,
    ///    * err on the side of not calling it.
    ///    *
    ///    * @param aName - The ping's name
    ///    * @param aIncludeClientId - Whether the ping should include the client_id
    ///    * @param aSendIfEmpty - Whether the ping should send even if empty
    ///    * @param aPreciseTimestamps - Whether to use precise timestamps
    ///    * @param aIncludeInfoSections - Whether to include client_info and ping_info sections
    ///    * @param aEnabled - Whether the ping is enabled
    ///    * @param aSchedulesPings - Array of pings that this ping schedules
    ///    * @param aReasonCodes - Array of valid reason codes for this ping
    ///    * @param aFollowsCollectionEnabled - Whether this ping follows the collection enabled setting
    ///    * @param aUploaderCapabilities - Array of capabilities that the uploader must support to handle this ping
    ///    * @throws NS_ERROR_INVALID_ARG if required arguments are missing
    ///    * @throws NS_ERROR_FAILURE if registration fails
    ///    */
    /// ```
    ///

    /// `void registerRuntimePing (in ACString aName, in boolean aIncludeClientId, in boolean aSendIfEmpty, in boolean aPreciseTimestamps, in boolean aIncludeInfoSections, in boolean aEnabled, in Array<ACString> aSchedulesPings, in Array<ACString> aReasonCodes, in boolean aFollowsCollectionEnabled, in Array<ACString> aUploaderCapabilities);`
    #[inline]
    pub unsafe fn RegisterRuntimePing(&self, aName: *const ::nsstring::nsACString, aIncludeClientId: bool, aSendIfEmpty: bool, aPreciseTimestamps: bool, aIncludeInfoSections: bool, aEnabled: bool, aSchedulesPings: *const thin_vec::ThinVec<::nsstring::nsCString>, aReasonCodes: *const thin_vec::ThinVec<::nsstring::nsCString>, aFollowsCollectionEnabled: bool, aUploaderCapabilities: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).RegisterRuntimePing)(self, aName, aIncludeClientId, aSendIfEmpty, aPreciseTimestamps, aIncludeInfoSections, aEnabled, aSchedulesPings, aReasonCodes, aFollowsCollectionEnabled, aUploaderCapabilities)
    }


}


