//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/dns/nsIIDNService.idl
//


/// `interface nsIIDNService : nsISupports`
///

/// ```text
/// /**
///  * IDN (Internationalized Domain Name) support. Provides facilities
///  * for manipulating IDN hostnames according to UTS #46 as parametrized
///  * by the WHATWG URL Standard.
///  *
///  * UTS #46: https://www.unicode.org/reports/tr46/
///  *
///  * URL Standard: https://url.spec.whatwg.org/
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIIDNService {
    vtable: &'static nsIIDNServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIIDNService.
unsafe impl XpCom for nsIIDNService {
    const IID: nsIID = nsID(0xa592a60e, 0x3621, 0x4f19,
        [0xa3, 0x18, 0x2b, 0xf2, 0x33, 0xcf, 0xad, 0x3e]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIIDNService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIIDNService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIIDNServiceCoerce {
    /// Cheaply cast a value of this type from a `nsIIDNService`.
    fn coerce_from(v: &nsIIDNService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIIDNServiceCoerce for nsIIDNService {
    #[inline]
    fn coerce_from(v: &nsIIDNService) -> &Self {
        v
    }
}

impl nsIIDNService {
    /// Cast this `nsIIDNService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIIDNServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIIDNService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIIDNServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIIDNService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIIDNService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIIDNServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* ACString domainToASCII (in AUTF8String input); */
    pub DomainToASCII: unsafe extern "system" fn (this: *const nsIIDNService, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* ACString convertUTF8toACE (in AUTF8String input); */
    pub ConvertUTF8toACE: unsafe extern "system" fn (this: *const nsIIDNService, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* AUTF8String domainToDisplay (in AUTF8String input); */
    pub DomainToDisplay: unsafe extern "system" fn (this: *const nsIIDNService, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* AUTF8String convertToDisplayIDN (in AUTF8String input); */
    pub ConvertToDisplayIDN: unsafe extern "system" fn (this: *const nsIIDNService, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* AUTF8String convertACEtoUTF8 (in ACString input); */
    pub ConvertACEtoUTF8: unsafe extern "system" fn (this: *const nsIIDNService, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIIDNService {

    /// ```text
    /// /**
    ///      * The UTS #46 ToASCII operation as parametrized by the WHATWG URL Standard
    ///      *
    ///      * Use this function to prepare a host name for network protocols.
    ///      *
    ///      * Do not try to optimize and avoid calling this function if you already
    ///      * have ASCII. This function optimizes internally, and calling it is
    ///      * required for correctness!
    ///      *
    ///      * The function is available to C++ callers as `NS_DomainToASCII`.
    ///      *
    ///      * Rust callers that don't happen to be using XPCOM strings are better
    ///      * off using the `idna` crate directly.
    ///      */
    /// ```
    ///

    /// `ACString domainToASCII (in AUTF8String input);`
    #[inline]
    pub unsafe fn DomainToASCII(&self, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).DomainToASCII)(self, input, _retval)
    }


    /// ```text
    /// /**
    ///      * Legacy variant of `domainToASCII` that allows allows any ASCII character that has a glyph.
    ///      *
    ///      * The function is available to C++ callers as `NS_DomainToASCIIAllowAnyGlyphfulASCII`.
    ///      */
    /// ```
    ///

    /// `ACString convertUTF8toACE (in AUTF8String input);`
    #[inline]
    pub unsafe fn ConvertUTF8toACE(&self, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).ConvertUTF8toACE)(self, input, _retval)
    }


    /// ```text
    /// /**
    ///      * The UTS #46 ToUnicode operation as parametrized by the WHATWG URL Standard,
    ///      * except potentially misleading labels are treated according to ToASCII instead.
    ///      *
    ///      * Use this function to prepare a host name for display to the user.
    ///      *
    ///      * The function is available to C++ callers as `NS_DomainToDisplay`.
    ///      *
    ///      * Rust callers that don't happen to be using XPCOM strings are better
    ///      * off using the `idna` crate directly. (See `idna_glue` for what policy
        ///      * closure to use.)
    ///      */
    /// ```
    ///

    /// `AUTF8String domainToDisplay (in AUTF8String input);`
    #[inline]
    pub unsafe fn DomainToDisplay(&self, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).DomainToDisplay)(self, input, _retval)
    }


    /// ```text
    /// /**
    ///      * Legacy variant of `domainToDisplay` that allows allows any ASCII character that has a glyph.
    ///      *
    ///      * The function is available to C++ callers as `NS_DomainToDisplayAllowAnyGlyphfulASCII`.
    ///      */
    /// ```
    ///

    /// `AUTF8String convertToDisplayIDN (in AUTF8String input);`
    #[inline]
    pub unsafe fn ConvertToDisplayIDN(&self, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).ConvertToDisplayIDN)(self, input, _retval)
    }


    /// ```text
    /// /**
    ///      * The UTS #46 ToUnicode operation as parametrized by the WHATWG URL Standard,
    ///      * except allows any ASCII character that has a glyph.
    ///      *
    ///      * It's most likely INCORRECT to call this function, and `domainToDisplay`
    ///      * should typically be called instead. Please avoid adding new callers, so
    ///      * that this conversion could be removed entirely!
    ///      *
    ///      * There is no `domainToUnicode` to discourage new callers.
    ///      *
    ///      * The function is available to C++ callers as `NS_DomainToUnicodeAllowAnyGlyphfulASCII`.
    ///      *
    ///      * Rust callers that don't happen to be using XPCOM strings are better
    ///      * off using the `idna` crate directly.
    ///      */
    /// ```
    ///

    /// `AUTF8String convertACEtoUTF8 (in ACString input);`
    #[inline]
    pub unsafe fn ConvertACEtoUTF8(&self, input: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).ConvertACEtoUTF8)(self, input, _retval)
    }


}


