//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/mime/nsIMIMEService.idl
//


/// `interface nsIMIMEService : nsISupports`
///

/// ```text
/// /**
///  * The MIME service is responsible for mapping file extensions to MIME-types
///  * (see RFC 2045). It also provides access to nsIMIMEInfo interfaces and
///  * acts as a general convenience wrapper of nsIMIMEInfo interfaces.
///  *
///  * The MIME service maintains a database with a <b>one</b> MIME type <b>to many</b>
///  * file extensions rule. Adding the same file extension to multiple MIME types
///  * is illegal and behavior is undefined.
///  *
///  * @see nsIMIMEInfo
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIMIMEService {
    vtable: &'static nsIMIMEServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIMIMEService.
unsafe impl XpCom for nsIMIMEService {
    const IID: nsIID = nsID(0x5b3675a1, 0x02db, 0x4f8f,
        [0xa5, 0x60, 0xb3, 0x47, 0x36, 0x63, 0x5f, 0x47]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIMIMEService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIMIMEService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIMIMEServiceCoerce {
    /// Cheaply cast a value of this type from a `nsIMIMEService`.
    fn coerce_from(v: &nsIMIMEService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIMIMEServiceCoerce for nsIMIMEService {
    #[inline]
    fn coerce_from(v: &nsIMIMEService) -> &Self {
        v
    }
}

impl nsIMIMEService {
    /// Cast this `nsIMIMEService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIMIMEServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIMIMEService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIMIMEServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIMIMEService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIMIMEService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIMIMEServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* nsIMIMEInfo getFromTypeAndExtension (in ACString aMIMEType, in AUTF8String aFileExt); */
    pub GetFromTypeAndExtension: unsafe extern "system" fn (this: *const nsIMIMEService, aMIMEType: *const ::nsstring::nsACString, aFileExt: *const ::nsstring::nsACString, _retval: *mut*const nsIMIMEInfo) -> ::nserror::nsresult,

    /* ACString getTypeFromExtension (in AUTF8String aFileExt); */
    pub GetTypeFromExtension: unsafe extern "system" fn (this: *const nsIMIMEService, aFileExt: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* ACString getTypeFromURI (in nsIURI aURI); */
    pub GetTypeFromURI: unsafe extern "system" fn (this: *const nsIMIMEService, aURI: *const nsIURI, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* ACString getDefaultTypeFromURI (in nsIURI aURI); */
    pub GetDefaultTypeFromURI: unsafe extern "system" fn (this: *const nsIMIMEService, aURI: *const nsIURI, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* ACString getTypeFromFile (in nsIFile aFile); */
    pub GetTypeFromFile: unsafe extern "system" fn (this: *const nsIMIMEService, aFile: *const nsIFile, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* AUTF8String getPrimaryExtension (in ACString aMIMEType, in AUTF8String aFileExt); */
    pub GetPrimaryExtension: unsafe extern "system" fn (this: *const nsIMIMEService, aMIMEType: *const ::nsstring::nsACString, aFileExt: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* nsIMIMEInfo getMIMEInfoFromOS (in ACString aType, in ACString aFileExtension, out boolean aFound); */
    pub GetMIMEInfoFromOS: unsafe extern "system" fn (this: *const nsIMIMEService, aType: *const ::nsstring::nsACString, aFileExtension: *const ::nsstring::nsACString, aFound: *mut bool, _retval: *mut*const nsIMIMEInfo) -> ::nserror::nsresult,

    /* void updateDefaultAppInfo (in nsIMIMEInfo aMIMEInfo); */
    pub UpdateDefaultAppInfo: unsafe extern "system" fn (this: *const nsIMIMEService, aMIMEInfo: *const nsIMIMEInfo) -> ::nserror::nsresult,

    /* AString getValidFileName (in nsIChannel aChannel, in ACString aType, in nsIURI aOriginalURI, in unsigned long aFlags); */
    pub GetValidFileName: unsafe extern "system" fn (this: *const nsIMIMEService, aChannel: *const nsIChannel, aType: *const ::nsstring::nsACString, aOriginalURI: *const nsIURI, aFlags: u32, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* AString validateFileNameForSaving (in AString aFileName, in ACString aType, in unsigned long aFlags); */
    pub ValidateFileNameForSaving: unsafe extern "system" fn (this: *const nsIMIMEService, aFileName: *const ::nsstring::nsAString, aType: *const ::nsstring::nsACString, aFlags: u32, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIMIMEService {
    /// ```text
    /// /**
    ///      * Default filename validation for getValidFileName and
    ///      * validateFileNameForSaving where other flags are not true.
    ///      * That is, the extension is modified to fit the content type,
    ///      * duplicate whitespace is collapsed, and long filenames are
    ///      * truncated. A valid content type must be supplied. See the
    ///      * description of getValidFileName for more details about how
    ///      * the flags are used.
    ///      */
    /// ```
    ///

    pub const VALIDATE_DEFAULT: i32 = 0;

    /// ```text
    /// /**
    ///      * If true, then the filename is only validated to ensure that it is
    ///      * acceptable for the file system. If false, then the extension is also
    ///      * checked to ensure that it is valid for the content type. If the
    ///      * extension is not valid, the filename is modified to have the proper
    ///      * extension.
    ///      */
    /// ```
    ///

    pub const VALIDATE_SANITIZE_ONLY: i32 = 1;

    /// ```text
    /// /**
    ///      * Don't collapse strings of duplicate whitespace into a single string.
    ///      */
    /// ```
    ///

    pub const VALIDATE_DONT_COLLAPSE_WHITESPACE: i32 = 2;

    /// ```text
    /// /**
    ///      * Don't truncate long filenames.
    ///      */
    /// ```
    ///

    pub const VALIDATE_DONT_TRUNCATE: i32 = 4;

    /// ```text
    /// /**
    ///      * True to ignore the content type and guess the type from any existing
    ///      * extension instead. "application/octet-stream" is used as the default
    ///      * if there is no extension or there is no information available for
    ///      * the extension.
    ///      */
    /// ```
    ///

    pub const VALIDATE_GUESS_FROM_EXTENSION: i32 = 8;

    /// ```text
    /// /**
    ///      * If the filename is empty, return the empty filename
    ///      * without modification.
    ///      */
    /// ```
    ///

    pub const VALIDATE_ALLOW_EMPTY: i32 = 16;

    /// ```text
    /// /**
    ///      * Don't apply a default filename if the non-extension portion of the
    ///      * filename is empty.
    ///      */
    /// ```
    ///

    pub const VALIDATE_NO_DEFAULT_FILENAME: i32 = 32;

    /// ```text
    /// /**
    ///      * When the filename has an invalid extension, force the the filename to
    ///      * have a valid extension appended to the end of the filename when that
    ///      * extension would normally be ignored for the given content type. This
    ///      * primarily is used when saving pages to ensure that the html extension
    ///      * is applied over any extension that might have been generated from a
    ///      * page title.
    ///      */
    /// ```
    ///

    pub const VALIDATE_FORCE_APPEND_EXTENSION: i32 = 64;

    /// ```text
    /// /**
    ///      * Don't modify filenames or extensions that might be invalid or dangerous
    ///      * on some platforms. If this flag is not used, these filenames will be
    ///      * modified so that the operating system does not treat them specially.
    ///      */
    /// ```
    ///

    pub const VALIDATE_ALLOW_INVALID_FILENAMES: i32 = 128;

    /// ```text
    /// /**
    ///      * Some names are unsafe as a file name, but safe for directory names.
    ///      * If this is used, the validation is more permissive towards names that
    ///      * are valid directory names.
    ///      */
    /// ```
    ///

    pub const VALIDATE_ALLOW_DIRECTORY_NAMES: i32 = 256;

    /// ```text
    /// /**
    ///      * Retrieves an nsIMIMEInfo using both the extension
    ///      * and the type of a file. The type is given preference
    ///      * during the lookup. One of aMIMEType and aFileExt
    ///      * can be an empty string. At least one of aMIMEType and aFileExt
    ///      * must be nonempty.
    ///      */
    /// ```
    ///

    /// `nsIMIMEInfo getFromTypeAndExtension (in ACString aMIMEType, in AUTF8String aFileExt);`
    #[inline]
    pub unsafe fn GetFromTypeAndExtension(&self, aMIMEType: *const ::nsstring::nsACString, aFileExt: *const ::nsstring::nsACString, _retval: *mut*const nsIMIMEInfo) -> ::nserror::nsresult {
        ((*self.vtable).GetFromTypeAndExtension)(self, aMIMEType, aFileExt, _retval)
    }


    /// ```text
    /// /**
    ///      * Retrieves a ACString representation of the MIME type
    ///      * associated with this file extension.
    ///      *
    ///      * @param  A file extension (excluding the dot ('.')).
    ///      * @return The MIME type, if any.
    ///      */
    /// ```
    ///

    /// `ACString getTypeFromExtension (in AUTF8String aFileExt);`
    #[inline]
    pub unsafe fn GetTypeFromExtension(&self, aFileExt: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetTypeFromExtension)(self, aFileExt, _retval)
    }


    /// ```text
    /// /**
    ///      * Retrieves a ACString representation of the MIME type
    ///      * associated with this URI. The association is purely
    ///      * file extension to MIME type based. No attempt to determine
    ///      * the type via server headers or byte scanning is made.
    ///      *
    ///      * @param  The URI the user wants MIME info on.
    ///      * @return The MIME type, if any.
    ///      */
    /// ```
    ///

    /// `ACString getTypeFromURI (in nsIURI aURI);`
    #[inline]
    pub unsafe fn GetTypeFromURI(&self, aURI: *const nsIURI, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetTypeFromURI)(self, aURI, _retval)
    }


    /// ```text
    /// /**
    ///      * Retrieves a ACString representation of the MIME type
    ///      * associated with this file extension.  Only the default
    ///      * builtin list is examined.  Unless you need a restricted
    ///      * set use getTypeFromURI.
    ///      *
    ///      * @param  The URI the user wants MIME info on.
    ///      * @return The MIME type, if any.
    ///      */
    /// ```
    ///

    /// `ACString getDefaultTypeFromURI (in nsIURI aURI);`
    #[inline]
    pub unsafe fn GetDefaultTypeFromURI(&self, aURI: *const nsIURI, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetDefaultTypeFromURI)(self, aURI, _retval)
    }



    /// `ACString getTypeFromFile (in nsIFile aFile);`
    #[inline]
    pub unsafe fn GetTypeFromFile(&self, aFile: *const nsIFile, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetTypeFromFile)(self, aFile, _retval)
    }


    /// ```text
    /// /**
    ///      * Given a Type/Extension combination, returns the default extension
    ///      * for this type. This may be identical to the passed-in extension.
    ///      *
    ///      * @param aMIMEType The Type to get information on. Must not be empty.
    ///      * @param aFileExt  File Extension. Can be empty.
    ///      */
    /// ```
    ///

    /// `AUTF8String getPrimaryExtension (in ACString aMIMEType, in AUTF8String aFileExt);`
    #[inline]
    pub unsafe fn GetPrimaryExtension(&self, aMIMEType: *const ::nsstring::nsACString, aFileExt: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetPrimaryExtension)(self, aMIMEType, aFileExt, _retval)
    }



    /// `nsIMIMEInfo getMIMEInfoFromOS (in ACString aType, in ACString aFileExtension, out boolean aFound);`
    #[inline]
    pub unsafe fn GetMIMEInfoFromOS(&self, aType: *const ::nsstring::nsACString, aFileExtension: *const ::nsstring::nsACString, aFound: *mut bool, _retval: *mut*const nsIMIMEInfo) -> ::nserror::nsresult {
        ((*self.vtable).GetMIMEInfoFromOS)(self, aType, aFileExtension, aFound, _retval)
    }


    /// ```text
    /// /**
    ///      * Update the mime info's default app information based on OS
    ///      * lookups.
    ///      * Note: normally called automatically by nsIMIMEInfo. If you find
    ///      * yourself needing to call this from elsewhere, file a bug instead.
    ///      */
    /// ```
    ///

    /// `void updateDefaultAppInfo (in nsIMIMEInfo aMIMEInfo);`
    #[inline]
    pub unsafe fn UpdateDefaultAppInfo(&self, aMIMEInfo: *const nsIMIMEInfo) -> ::nserror::nsresult {
        ((*self.vtable).UpdateDefaultAppInfo)(self, aMIMEInfo)
    }


    /// ```text
    /// /**
    ///      * Generate a valid filename from the channel that can be used to save
    ///      * the content of the channel to the local disk.
    ///      *
    ///      * The filename is determined from the content disposition, the filename
    ///      * of the uri, or a default filename. The following modifications are
    ///      * applied:
    ///      *  - If the VALIDATE_SANITIZE_ONLY flag is not specified, then the
    ///      *    extension of the filename is modified to suit the supplied content type.
    ///      *  - Path separators (typically / and \) are replaced by underscores (_)
    ///      *  - Characters that are not valid or would be confusing in filenames are
    ///      *    replaced by spaces (*, :, etc)
    ///      *  - Bidi related marks are replaced by underscores (_)
    ///      *  - Whitespace and periods are removed from the beginning and end.
    ///      *  - Unless VALIDATE_DONT_COLLAPSE_WHITESPACE is specified, multiple
    ///      *    consecutive whitespace characters are collapsed to a single space
    ///      *    character, either ' ' or an ideographic space 0x3000 if present.
    ///      *  - Unless VALIDATE_DONT_TRUNCATE is specified, the filename is truncated
    ///      *    to a maximum length, preserving the extension if possible.
    ///      *  - Some filenames and extensions are invalid on certain platforms.
    ///      *    These are replaced if possible unless VALIDATE_ALLOW_INVALID_FILENAMES
    ///      *    is specified.
    ///      *
    ///      * If the VALIDATE_NO_DEFAULT_FILENAME flag is not specified, and after the
    ///      * rules above are applied, the resulting filename is empty, a default
    ///      * filename is used.
    ///      *
    ///      * If the VALIDATE_ALLOW_EMPTY flag is specified, an empty string may be
    ///      * returned only if the filename could not be determined or was blank.
    ///      *
    ///      * If either the VALIDATE_SANITIZE_ONLY or VALIDATE_GUESS_FROM_EXTENSION flags
    ///      * are specified, then the content type may be empty. Otherwise, the type must
    ///      * not be empty.
    ///      *
    ///      * The aOriginalURI would be specified if the channel is for a local file but
    ///      * it was originally sourced from a different uri.
    ///      *
    ///      * When saving an image, use validateFileNameForSaving instead and
    ///      * pass the result of imgIRequest::GetFileName() as the filename to
    ///      * check.
    ///      *
    ///      * @param aChannel The channel of the content to save.
    ///      * @param aType The MIME type to use, which would usually be the
    ///      *              same as the content type of the channel.
    ///      * @param aOriginalURL the source url of the file, but may be null.
    ///      * @param aFlags one or more of the flags above.
    ///      * @returns The resulting filename.
    ///      */
    /// ```
    ///

    /// `AString getValidFileName (in nsIChannel aChannel, in ACString aType, in nsIURI aOriginalURI, in unsigned long aFlags);`
    #[inline]
    pub unsafe fn GetValidFileName(&self, aChannel: *const nsIChannel, aType: *const ::nsstring::nsACString, aOriginalURI: *const nsIURI, aFlags: u32, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetValidFileName)(self, aChannel, aType, aOriginalURI, aFlags, _retval)
    }


    /// ```text
    /// /**
    ///      * Similar to getValidFileName, but used when a specific filename needs
    ///      * to be validated. The filename is modified as needed based on the
    ///      * content type in the same manner as getValidFileName.
    ///      *
    ///      * If the filename came from a uri, it should not be escaped, that is,
    ///      * any needed unescaping of the filename should happen before calling
    ///      * this method.
    ///      *
    ///      * @param aType The MIME type to use.
    ///      * @param aFlags one or more of the flags above.
    ///      * @param aFileName The filename to validate.
    ///      * @returns The validated filename.
    ///      */
    /// ```
    ///

    /// `AString validateFileNameForSaving (in AString aFileName, in ACString aType, in unsigned long aFlags);`
    #[inline]
    pub unsafe fn ValidateFileNameForSaving(&self, aFileName: *const ::nsstring::nsAString, aType: *const ::nsstring::nsACString, aFlags: u32, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).ValidateFileNameForSaving)(self, aFileName, aType, aFlags, _retval)
    }


}


