//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIMockDragServiceController.idl
//


/// `interface nsIMockDragServiceController : nsISupports`
///

/// ```text
/// /**
///  * A driver for MockDragService, so that tests can mock system DND behavior.
///  * (System DND is not permitted in tests.)
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIMockDragServiceController {
    vtable: &'static nsIMockDragServiceControllerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIMockDragServiceController.
unsafe impl XpCom for nsIMockDragServiceController {
    const IID: nsIID = nsID(0x32037ab0, 0xbfc7, 0x11ee,
        [0x9f, 0x4b, 0x09, 0x90, 0x1b, 0xed, 0x55, 0xfa]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIMockDragServiceController {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIMockDragServiceController.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIMockDragServiceControllerCoerce {
    /// Cheaply cast a value of this type from a `nsIMockDragServiceController`.
    fn coerce_from(v: &nsIMockDragServiceController) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIMockDragServiceControllerCoerce for nsIMockDragServiceController {
    #[inline]
    fn coerce_from(v: &nsIMockDragServiceController) -> &Self {
        v
    }
}

impl nsIMockDragServiceController {
    /// Cast this `nsIMockDragServiceController` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIMockDragServiceControllerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIMockDragServiceController {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIMockDragServiceControllerCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIMockDragServiceController) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIMockDragServiceController
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIMockDragServiceControllerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute nsIDragService mockDragService; */
    pub GetMockDragService: unsafe extern "system" fn (this: *const nsIMockDragServiceController, aMockDragService: *mut*const nsIDragService) -> ::nserror::nsresult,

    /* [can_run_script] void sendEvent (in BrowsingContext aBC, in nsIMockDragServiceController_EventType aEventType, in long aScreenX, in long aScreenY, [optional] in uint32_t aKeyModifiers); */
    pub SendEvent: unsafe extern "system" fn (this: *const nsIMockDragServiceController, aBC: *const libc::c_void, aEventType:  u8, aScreenX: i32, aScreenY: i32, aKeyModifiers: u32) -> ::nserror::nsresult,

    /* [can_run_script] void cancelDrag ([optional] in uint32_t aKeyModifiers); */
    pub CancelDrag: unsafe extern "system" fn (this: *const nsIMockDragServiceController, aKeyModifiers: u32) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIMockDragServiceController {

    pub const eDragEnter:  u8 = 0;


    pub const eDragOver:  u8 = 1;


    pub const eDragExit:  u8 = 2;


    pub const eDrop:  u8 = 3;


    pub const eMouseDown:  u8 = 4;


    pub const eMouseMove:  u8 = 5;


    pub const eMouseUp:  u8 = 6;

    /// ```text
    /// /**
    ///    * The nsIDragService that this controller targets.  It is a mock version
    ///    * of the normal nsIDragService.  The caller must replace the drag
    ///    * service in the service manager with this object before sending
    ///    * drag events to it.  This can be done with MockRegistrar or by calling
    ///    * the nsComponentManager directly.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIDragService mockDragService;`
    #[inline]
    pub unsafe fn GetMockDragService(&self, aMockDragService: *mut*const nsIDragService) -> ::nserror::nsresult {
        ((*self.vtable).GetMockDragService)(self, aMockDragService)
    }


    /// ```text
    /// /**
    ///    * Issue the given event from our mock drag service, as if that type
    ///    * of event came from the system.  The mock object attempts to mimic the
    ///    * essential behavior of the native drag classes for this.
    ///    *
    ///    * @param aBC            A BrowsingContext in the widget the event is
    ///    *                       targetted at
    ///    * @param aEventType     Type of event to send
    ///    * @param aScreenX       Screen X coordinate of event
    ///    * @param aScreenY       Screen Y coordinate of event
    ///    * @param aKeyModifiers  Keys that are pressed during event.
    ///    *                       NOTE: Keys should be interpreted as selecting
    ///    *                       the drag action, but that logic is very
    ///    *                       platform-dependent and is not yet mocked.
    ///    *                       Drops will be processed as "moves".
    ///    */
    /// ```
    ///

    /// `[can_run_script] void sendEvent (in BrowsingContext aBC, in nsIMockDragServiceController_EventType aEventType, in long aScreenX, in long aScreenY, [optional] in uint32_t aKeyModifiers);`
    #[inline]
    pub unsafe fn SendEvent(&self, aBC: *const libc::c_void, aEventType:  u8, aScreenX: i32, aScreenY: i32, aKeyModifiers: u32) -> ::nserror::nsresult {
        ((*self.vtable).SendEvent)(self, aBC, aEventType, aScreenX, aScreenY, aKeyModifiers)
    }


    /// ```text
    /// /**
    ///    * Windows' IDropTarget has the ability to "Cancel" a drag that is
    ///    * different than dragleave.  This emulates that behavior for testing.
    ///    */
    /// ```
    ///

    /// `[can_run_script] void cancelDrag ([optional] in uint32_t aKeyModifiers);`
    #[inline]
    pub unsafe fn CancelDrag(&self, aKeyModifiers: u32) -> ::nserror::nsresult {
        ((*self.vtable).CancelDrag)(self, aKeyModifiers)
    }


}


