//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/extensions/nsINativeMessagingPortal.idl
//


/// `interface nsINativeMessagingPortal : nsISupports`
///

/// ```text
/// /**
///  * An interface to talk to the WebExtensions XDG desktop portal,
///  * for sandboxed browsers (e.g. packaged as a snap or a flatpak).
///  * See https://github.com/flatpak/xdg-desktop-portal/issues/655.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsINativeMessagingPortal {
    vtable: &'static nsINativeMessagingPortalVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsINativeMessagingPortal.
unsafe impl XpCom for nsINativeMessagingPortal {
    const IID: nsIID = nsID(0x7c3003e8, 0x6d10, 0x46cc,
        [0xb7, 0x54, 0x70, 0xcd, 0x88, 0x98, 0x71, 0xe7]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsINativeMessagingPortal {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsINativeMessagingPortal.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsINativeMessagingPortalCoerce {
    /// Cheaply cast a value of this type from a `nsINativeMessagingPortal`.
    fn coerce_from(v: &nsINativeMessagingPortal) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsINativeMessagingPortalCoerce for nsINativeMessagingPortal {
    #[inline]
    fn coerce_from(v: &nsINativeMessagingPortal) -> &Self {
        v
    }
}

impl nsINativeMessagingPortal {
    /// Cast this `nsINativeMessagingPortal` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsINativeMessagingPortalCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsINativeMessagingPortal {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsINativeMessagingPortalCoerce for T {
    #[inline]
    fn coerce_from(v: &nsINativeMessagingPortal) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsINativeMessagingPortal
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsINativeMessagingPortalVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* boolean shouldUse (); */
    pub ShouldUse: unsafe extern "system" fn (this: *const nsINativeMessagingPortal, _retval: *mut bool) -> ::nserror::nsresult,

    /* [implicit_jscontext] readonly attribute Promise available; */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetAvailable: *const ::libc::c_void,

    /* [implicit_jscontext] Promise createSession (in ACString aApplication); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub CreateSession: *const ::libc::c_void,

    /* [implicit_jscontext] Promise closeSession (in ACString aHandle); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub CloseSession: *const ::libc::c_void,

    /* [implicit_jscontext] Promise getManifest (in ACString aHandle, in ACString aName, in ACString aExtension); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub GetManifest: *const ::libc::c_void,

    /* [implicit_jscontext] Promise start (in ACString aHandle, in ACString aName, in ACString aExtension); */
    /// Unable to generate binding because `jscontext is unsupported`
    pub Start: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsINativeMessagingPortal {

    /// ```text
    /// /**
    ///    * Whether client code should use the portal, or fall back to the "legacy"
    ///    * implementation that spawns and communicates directly with native
    ///    * applications.
    ///    */
    /// ```
    ///

    /// `boolean shouldUse ();`
    #[inline]
    pub unsafe fn ShouldUse(&self, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).ShouldUse)(self, _retval)
    }


    /// ```text
    /// /**
    ///    * Whether the portal is available and can be talked to. It is an error to
    ///    * call other methods in this interface if the portal isn't available.
    ///    *
    ///    * @returns Promise that resolves with a boolean that reflects
    ///               the availability of the portal.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] readonly attribute Promise available;`
    const _GetAvailable: () = ();

    /// ```text
    /// /**
    ///    * Create a native messaging session.
    ///    *
    ///    * @param aApplication The name of the native application which the portal is
    ///    *                     being requested to talk to. See
    ///    *                     https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/Native_manifests#native_messaging_manifests.
    ///    *
    ///    * @returns Promise that resolves with a string that represents the
    ///               session handle (a D-Bus object path of the form
        ///               /org/freedesktop/portal/desktop/session/SENDER/TOKEN).
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] Promise createSession (in ACString aApplication);`
    const _CreateSession: () = ();

    /// ```text
    /// /**
    ///    * Close a previously open session.
    ///    *
    ///    * @param aHandle The handle of a valid session.
    ///    *
    ///    * @returns Promise that resolves when the session is successfully closed.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] Promise closeSession (in ACString aHandle);`
    const _CloseSession: () = ();

    /// ```text
    /// /**
    ///    * Find and return the JSON manifest for the named native messaging server
    ///    * as a string. This allows the browser to validate the manifest before
    ///    * deciding to start the server.
    ///    *
    ///    * @param aHandle    The handle of a valid session.
    ///    * @param aName      The name of the native messaging server to start.
    ///    * @param aExtension The ID of the extension that issues the request.
    ///    *
    ///    * @returns Promise that resolves with an UTF8-encoded string containing
    ///               the raw JSON manifest.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] Promise getManifest (in ACString aHandle, in ACString aName, in ACString aExtension);`
    const _GetManifest: () = ();

    /// ```text
    /// /**
    ///    * Start the named native messaging server, in a previously open session.
    ///    * The caller must indicate the requesting web extension (by extension ID).
    ///    *
    ///    * @param aHandle    The handle of a valid session.
    ///    * @param aName      The name of the native messaging server to start.
    ///    * @param aExtension The ID of the extension that issues the request.
    ///    *
    ///    * @returns Promise that resolves with an object that has 'stdin', 'stdout'
    ///               and 'stderr' attributes for the open file descriptors that the
    ///               caller can use to communicate with the native application once
    ///               successfully started.
    ///    */
    /// ```
    ///

    /// `[implicit_jscontext] Promise start (in ACString aHandle, in ACString aName, in ACString aExtension);`
    const _Start: () = ();

}


