//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/places/nsINavBookmarksService.idl
//


/// `interface nsINavBookmarksService : nsISupports`
///

/// ```text
/// /**
///  * The BookmarksService interface provides methods for managing bookmarked
///  * history items.  Bookmarks consist of a set of user-customizable
///  * folders.  A URI in history can be contained in one or more such folders.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsINavBookmarksService {
    vtable: &'static nsINavBookmarksServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsINavBookmarksService.
unsafe impl XpCom for nsINavBookmarksService {
    const IID: nsIID = nsID(0x24533891, 0xafa6, 0x4663,
        [0xb7, 0x2d, 0x31, 0x43, 0xd0, 0x3f, 0x1b, 0x04]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsINavBookmarksService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsINavBookmarksService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsINavBookmarksServiceCoerce {
    /// Cheaply cast a value of this type from a `nsINavBookmarksService`.
    fn coerce_from(v: &nsINavBookmarksService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsINavBookmarksServiceCoerce for nsINavBookmarksService {
    #[inline]
    fn coerce_from(v: &nsINavBookmarksService) -> &Self {
        v
    }
}

impl nsINavBookmarksService {
    /// Cast this `nsINavBookmarksService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsINavBookmarksServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsINavBookmarksService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsINavBookmarksServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsINavBookmarksService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsINavBookmarksService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsINavBookmarksServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute long long tagsFolder; */
    pub GetTagsFolder: unsafe extern "system" fn (this: *const nsINavBookmarksService, aTagsFolder: *mut i64) -> ::nserror::nsresult,

    /* readonly attribute long long totalSyncChanges; */
    pub GetTotalSyncChanges: unsafe extern "system" fn (this: *const nsINavBookmarksService, aTotalSyncChanges: *mut i64) -> ::nserror::nsresult,

    /* [can_run_script] long long insertBookmark (in long long aParentId, in nsIURI aURI, in long aIndex, in AUTF8String aTitle, [optional] in ACString aGuid, [optional] in unsigned short aSource); */
    pub InsertBookmark: unsafe extern "system" fn (this: *const nsINavBookmarksService, aParentId: i64, aURI: *const nsIURI, aIndex: i32, aTitle: *const ::nsstring::nsACString, aGuid: *const ::nsstring::nsACString, aSource: u16, _retval: *mut i64) -> ::nserror::nsresult,

    /* [can_run_script] void removeItem (in long long aItemId, [optional] in unsigned short aSource); */
    pub RemoveItem: unsafe extern "system" fn (this: *const nsINavBookmarksService, aItemId: i64, aSource: u16) -> ::nserror::nsresult,

    /* [can_run_script] long long createFolder (in long long aParentFolder, in AUTF8String name, in long index, [optional] in ACString aGuid, [optional] in unsigned short aSource); */
    pub CreateFolder: unsafe extern "system" fn (this: *const nsINavBookmarksService, aParentFolder: i64, name: *const ::nsstring::nsACString, index: i32, aGuid: *const ::nsstring::nsACString, aSource: u16, _retval: *mut i64) -> ::nserror::nsresult,

    /* [can_run_script] void setItemTitle (in long long aItemId, in AUTF8String aTitle, [optional] in unsigned short aSource); */
    pub SetItemTitle: unsafe extern "system" fn (this: *const nsINavBookmarksService, aItemId: i64, aTitle: *const ::nsstring::nsACString, aSource: u16) -> ::nserror::nsresult,

    /* AUTF8String getItemTitle (in long long aItemId); */
    pub GetItemTitle: unsafe extern "system" fn (this: *const nsINavBookmarksService, aItemId: i64, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* [can_run_script] void setItemLastModified (in long long aItemId, in PRTime aLastModified, [optional] in unsigned short aSource); */
    pub SetItemLastModified: unsafe extern "system" fn (this: *const nsINavBookmarksService, aItemId: i64, aLastModified: PRTime, aSource: u16) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsINavBookmarksService {
    /// ```text
    /// /**
    ///    * This value should be used for APIs that allow passing in an index
    ///    * where an index is not known, or not required to be specified.
    ///    * e.g.: When appending an item to a folder.
    ///    */
    /// ```
    ///

    pub const DEFAULT_INDEX: i16 = -1;


    pub const TYPE_BOOKMARK:  u16 = 1;


    pub const TYPE_FOLDER:  u16 = 2;


    pub const TYPE_SEPARATOR:  u16 = 3;


    pub const TYPE_DYNAMIC_CONTAINER:  u16 = 4;


    pub const SOURCE_DEFAULT:  u8 = 0;


    pub const SOURCE_SYNC:  u8 = 1;


    pub const SOURCE_IMPORT:  u8 = 2;


    pub const SOURCE_SYNC_REPARENT_REMOVED_FOLDER_CHILDREN:  u8 = 4;


    pub const SOURCE_RESTORE:  u8 = 5;


    pub const SOURCE_RESTORE_ON_STARTUP:  u8 = 6;

    /// ```text
    /// /**
    ///    * Sync status flags, stored in Places for each item. These affect conflict
    ///    * resolution, when an item is changed both locally and remotely; deduping,
    ///    * when a local item matches a remote item with similar contents and different
    ///    * GUIDs; and whether we write a tombstone when an item is deleted locally.
    ///    *
    ///    * Status  | Description               | Conflict   | Can     | Needs
    ///    *         |                           | resolution | dedupe? | tombstone?
    ///    * -----------------------------------------------------------------------
    ///    * UNKNOWN | Automatically restored    | Prefer     | No      | No
    ///    *         | on startup to recover     | deletion   |         |
    ///    *         | from database corruption, |            |         |
    ///    *         | or sync ID change on      |            |         |
    ///    *         | server.                   |            |         |
    ///    * -----------------------------------------------------------------------
    ///    * NEW     | Item not uploaded to      | Prefer     | Yes     | No
    ///    *         | server yet, or Sync       | newer      |         |
    ///    *         | disconnected.             |            |         |
    ///    * -----------------------------------------------------------------------
    ///    * NORMAL  | Item uploaded to server.  | Prefer     | No      | Yes
    ///    *         |                           | newer      |         |
    ///    */
    /// ```
    ///

    pub const SYNC_STATUS_UNKNOWN: u16 = 0;


    pub const SYNC_STATUS_NEW: u16 = 1;


    pub const SYNC_STATUS_NORMAL: u16 = 2;

    /// ```text
    /// /**
    ///    * The item ID of the top-level folder that contain the tag "folders".
    ///    */
    /// ```
    ///

    /// `readonly attribute long long tagsFolder;`
    #[inline]
    pub unsafe fn GetTagsFolder(&self, aTagsFolder: *mut i64) -> ::nserror::nsresult {
        ((*self.vtable).GetTagsFolder)(self, aTagsFolder)
    }


    /// ```text
    /// /**
    ///    * The total number of Sync changes (inserts, updates, deletes, merges, and
        ///    * uploads) recorded since Places startup for all bookmarks.
    ///    *
    ///    * Note that this is *not* the number of bookmark syncs. It's a monotonically
    ///    * increasing counter incremented for every change that affects a bookmark's
    ///    * `syncChangeCounter`.
    ///    *
    ///    * The counter can be used to avoid keeping an exclusive transaction open for
    ///    * time-consuming work. One way to do that is to store the current value of
    ///    * the counter, do the work, start a transaction, check the current value
    ///    * again, and compare it to the stored value to determine if the database
    ///    * changed during the work.
    ///    *
    ///    * The bookmarks mirror does this to check for changes between building and
    ///    * applying a merged tree. This avoids blocking the main Places connection
    ///    * during the merge, and ensures that the new tree still applies cleanly.
    ///    */
    /// ```
    ///

    /// `readonly attribute long long totalSyncChanges;`
    #[inline]
    pub unsafe fn GetTotalSyncChanges(&self, aTotalSyncChanges: *mut i64) -> ::nserror::nsresult {
        ((*self.vtable).GetTotalSyncChanges)(self, aTotalSyncChanges)
    }


    /// ```text
    /// /**
    ///    * Inserts a child bookmark into the given folder.
    ///    *
    ///    *  @param aParentId
    ///    *         The id of the parent folder
    ///    *  @param aURI
    ///    *         The URI to insert
    ///    *  @param aIndex
    ///    *         The index to insert at, or DEFAULT_INDEX to append
    ///    *  @param aTitle
    ///    *         The title for the new bookmark
    ///    *  @param [optional] aGuid
    ///    *         The GUID to be set for the new item.  If not set, a new GUID is
    ///    *         generated.  Unless you've a very sound reason, such as an undo
    ///    *         manager implementation, do not pass this argument.
    ///    *  @param [optional] aSource
    ///    *         The change source. This is forwarded to all bookmark observers,
    ///    *         allowing them to distinguish between insertions from different
    ///    *         callers. Defaults to SOURCE_DEFAULT if omitted.
    ///    *  @return The ID of the newly-created bookmark.
    ///    *
    ///    *  @note aTitle will be truncated to TITLE_LENGTH_MAX and
    ///    *        aURI will be truncated to URI_LENGTH_MAX.
    ///    *  @throws if aGuid is malformed.
    ///    */
    /// ```
    ///

    /// `[can_run_script] long long insertBookmark (in long long aParentId, in nsIURI aURI, in long aIndex, in AUTF8String aTitle, [optional] in ACString aGuid, [optional] in unsigned short aSource);`
    #[inline]
    pub unsafe fn InsertBookmark(&self, aParentId: i64, aURI: *const nsIURI, aIndex: i32, aTitle: *const ::nsstring::nsACString, aGuid: *const ::nsstring::nsACString, aSource: u16, _retval: *mut i64) -> ::nserror::nsresult {
        ((*self.vtable).InsertBookmark)(self, aParentId, aURI, aIndex, aTitle, aGuid, aSource, _retval)
    }


    /// ```text
    /// /**
    ///    * Removes a child item. Used to delete a bookmark or separator.
    ///    *  @param aItemId
    ///    *         The child item to remove
    ///    *  @param [optional] aSource
    ///    *         The change source, forwarded to all bookmark observers. Defaults
    ///    *         to SOURCE_DEFAULT.
    ///    */
    /// ```
    ///

    /// `[can_run_script] void removeItem (in long long aItemId, [optional] in unsigned short aSource);`
    #[inline]
    pub unsafe fn RemoveItem(&self, aItemId: i64, aSource: u16) -> ::nserror::nsresult {
        ((*self.vtable).RemoveItem)(self, aItemId, aSource)
    }


    /// ```text
    /// /**
    ///    * Creates a new child folder and inserts it under the given parent.
    ///    *  @param aParentFolder
    ///    *         The id of the parent folder
    ///    *  @param aName
    ///    *         The name of the new folder
    ///    *  @param aIndex
    ///    *         The index to insert at, or DEFAULT_INDEX to append
    ///    *  @param [optional] aGuid
    ///    *         The GUID to be set for the new item.  If not set, a new GUID is
    ///    *         generated.  Unless you've a very sound reason, such as an undo
    ///    *         manager implementation, do not pass this argument.
    ///    *  @param [optional] aSource
    ///    *         The change source, forwarded to all bookmark observers. Defaults
    ///    *         to SOURCE_DEFAULT.
    ///    *  @return The ID of the newly-inserted folder.
    ///    *  @throws if aGuid is malformed.
    ///    */
    /// ```
    ///

    /// `[can_run_script] long long createFolder (in long long aParentFolder, in AUTF8String name, in long index, [optional] in ACString aGuid, [optional] in unsigned short aSource);`
    #[inline]
    pub unsafe fn CreateFolder(&self, aParentFolder: i64, name: *const ::nsstring::nsACString, index: i32, aGuid: *const ::nsstring::nsACString, aSource: u16, _retval: *mut i64) -> ::nserror::nsresult {
        ((*self.vtable).CreateFolder)(self, aParentFolder, name, index, aGuid, aSource, _retval)
    }


    /// ```text
    /// /**
    ///    * Set the title for an item.
    ///    *  @param aItemId
    ///    *         The id of the item whose title should be updated.
    ///    *  @param aTitle
    ///    *         The new title for the bookmark.
    ///    *  @param [optional] aSource
    ///    *         The change source, forwarded to all bookmark observers. Defaults
    ///    *         to SOURCE_DEFAULT.
    ///    *
    ///    *  @note  aTitle will be truncated to TITLE_LENGTH_MAX.
    ///    */
    /// ```
    ///

    /// `[can_run_script] void setItemTitle (in long long aItemId, in AUTF8String aTitle, [optional] in unsigned short aSource);`
    #[inline]
    pub unsafe fn SetItemTitle(&self, aItemId: i64, aTitle: *const ::nsstring::nsACString, aSource: u16) -> ::nserror::nsresult {
        ((*self.vtable).SetItemTitle)(self, aItemId, aTitle, aSource)
    }


    /// ```text
    /// /**
    ///    * Get the title for an item.
    ///    *
    ///    * If no item title is available it will return a void string (null in JS).
    ///    *
    ///    *  @param aItemId
    ///    *         The id of the item whose title should be retrieved
    ///    *  @return The title of the item.
    ///    */
    /// ```
    ///

    /// `AUTF8String getItemTitle (in long long aItemId);`
    #[inline]
    pub unsafe fn GetItemTitle(&self, aItemId: i64, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetItemTitle)(self, aItemId, _retval)
    }


    /// ```text
    /// /**
    ///    * Set the last modified time for an item.
    ///    *
    ///    * @param aItemId
    ///    *        the id of the item whose last modified time should be updated.
    ///    * @param aLastModified
    ///    *        the new last modified value in microseconds.  Note that it is
    ///    *        rounded down to milliseconds precision.
    ///    * @param [optional] aSource
    ///    *        The change source, forwarded to all bookmark observers. Defaults
    ///    *        to SOURCE_DEFAULT.
    ///    *
    ///    * @note This is the only method that will send an itemChanged notification
    ///    *       for the property.  lastModified will still be updated in
    ///    *       any other method that changes an item property, but we will send
    ///    *       the corresponding itemChanged notification instead.
    ///    */
    /// ```
    ///

    /// `[can_run_script] void setItemLastModified (in long long aItemId, in PRTime aLastModified, [optional] in unsigned short aSource);`
    #[inline]
    pub unsafe fn SetItemLastModified(&self, aItemId: i64, aLastModified: PRTime, aSource: u16) -> ::nserror::nsresult {
        ((*self.vtable).SetItemLastModified)(self, aItemId, aLastModified, aSource)
    }


}


