//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/dom/interfaces/notification/nsINotificationStorage.idl
//


/// `interface nsINotificationActionStorageEntry : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsINotificationActionStorageEntry {
    vtable: &'static nsINotificationActionStorageEntryVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsINotificationActionStorageEntry.
unsafe impl XpCom for nsINotificationActionStorageEntry {
    const IID: nsIID = nsID(0x6b782346, 0x49ec, 0x41dd,
        [0x81, 0x65, 0x17, 0x15, 0x06, 0xf8, 0xd4, 0xf4]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsINotificationActionStorageEntry {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsINotificationActionStorageEntry.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsINotificationActionStorageEntryCoerce {
    /// Cheaply cast a value of this type from a `nsINotificationActionStorageEntry`.
    fn coerce_from(v: &nsINotificationActionStorageEntry) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsINotificationActionStorageEntryCoerce for nsINotificationActionStorageEntry {
    #[inline]
    fn coerce_from(v: &nsINotificationActionStorageEntry) -> &Self {
        v
    }
}

impl nsINotificationActionStorageEntry {
    /// Cast this `nsINotificationActionStorageEntry` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsINotificationActionStorageEntryCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsINotificationActionStorageEntry {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsINotificationActionStorageEntryCoerce for T {
    #[inline]
    fn coerce_from(v: &nsINotificationActionStorageEntry) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsINotificationActionStorageEntry
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsINotificationActionStorageEntryVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute AString name; */
    pub GetName: unsafe extern "system" fn (this: *const nsINotificationActionStorageEntry, aName: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString title; */
    pub GetTitle: unsafe extern "system" fn (this: *const nsINotificationActionStorageEntry, aTitle: *mut ::nsstring::nsAString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsINotificationActionStorageEntry {


    /// `readonly attribute AString name;`
    #[inline]
    pub unsafe fn GetName(&self, aName: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetName)(self, aName)
    }



    /// `readonly attribute AString title;`
    #[inline]
    pub unsafe fn GetTitle(&self, aTitle: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetTitle)(self, aTitle)
    }


}


/// `interface nsINotificationStorageEntry : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsINotificationStorageEntry {
    vtable: &'static nsINotificationStorageEntryVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsINotificationStorageEntry.
unsafe impl XpCom for nsINotificationStorageEntry {
    const IID: nsIID = nsID(0xc772e1b9, 0xd4b0, 0x4e23,
        [0x84, 0x81, 0x4a, 0x8b, 0x7d, 0xbb, 0xfe, 0x92]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsINotificationStorageEntry {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsINotificationStorageEntry.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsINotificationStorageEntryCoerce {
    /// Cheaply cast a value of this type from a `nsINotificationStorageEntry`.
    fn coerce_from(v: &nsINotificationStorageEntry) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsINotificationStorageEntryCoerce for nsINotificationStorageEntry {
    #[inline]
    fn coerce_from(v: &nsINotificationStorageEntry) -> &Self {
        v
    }
}

impl nsINotificationStorageEntry {
    /// Cast this `nsINotificationStorageEntry` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsINotificationStorageEntryCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsINotificationStorageEntry {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsINotificationStorageEntryCoerce for T {
    #[inline]
    fn coerce_from(v: &nsINotificationStorageEntry) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsINotificationStorageEntry
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsINotificationStorageEntryVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute AString id; */
    pub GetId: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aId: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString title; */
    pub GetTitle: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aTitle: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute ACString dir; */
    pub GetDir: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aDir: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute AString lang; */
    pub GetLang: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aLang: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString body; */
    pub GetBody: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aBody: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString tag; */
    pub GetTag: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aTag: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute ACString icon; */
    pub GetIcon: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aIcon: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute boolean requireInteraction; */
    pub GetRequireInteraction: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aRequireInteraction: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean silent; */
    pub GetSilent: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aSilent: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute AString dataSerialized; */
    pub GetDataSerialized: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aDataSerialized: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute Array<nsINotificationActionStorageEntry> actions; */
    pub GetActions: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aActions: *mut thin_vec::ThinVec<Option<RefPtr<nsINotificationActionStorageEntry>>>) -> ::nserror::nsresult,

    /* readonly attribute AString serviceWorkerRegistrationScope; */
    pub GetServiceWorkerRegistrationScope: unsafe extern "system" fn (this: *const nsINotificationStorageEntry, aServiceWorkerRegistrationScope: *mut ::nsstring::nsAString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsINotificationStorageEntry {


    /// `readonly attribute AString id;`
    #[inline]
    pub unsafe fn GetId(&self, aId: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetId)(self, aId)
    }



    /// `readonly attribute AString title;`
    #[inline]
    pub unsafe fn GetTitle(&self, aTitle: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetTitle)(self, aTitle)
    }



    /// `readonly attribute ACString dir;`
    #[inline]
    pub unsafe fn GetDir(&self, aDir: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetDir)(self, aDir)
    }



    /// `readonly attribute AString lang;`
    #[inline]
    pub unsafe fn GetLang(&self, aLang: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetLang)(self, aLang)
    }



    /// `readonly attribute AString body;`
    #[inline]
    pub unsafe fn GetBody(&self, aBody: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetBody)(self, aBody)
    }



    /// `readonly attribute AString tag;`
    #[inline]
    pub unsafe fn GetTag(&self, aTag: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetTag)(self, aTag)
    }



    /// `readonly attribute ACString icon;`
    #[inline]
    pub unsafe fn GetIcon(&self, aIcon: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetIcon)(self, aIcon)
    }



    /// `readonly attribute boolean requireInteraction;`
    #[inline]
    pub unsafe fn GetRequireInteraction(&self, aRequireInteraction: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetRequireInteraction)(self, aRequireInteraction)
    }



    /// `readonly attribute boolean silent;`
    #[inline]
    pub unsafe fn GetSilent(&self, aSilent: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetSilent)(self, aSilent)
    }



    /// `readonly attribute AString dataSerialized;`
    #[inline]
    pub unsafe fn GetDataSerialized(&self, aDataSerialized: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetDataSerialized)(self, aDataSerialized)
    }



    /// `readonly attribute Array<nsINotificationActionStorageEntry> actions;`
    #[inline]
    pub unsafe fn GetActions(&self, aActions: *mut thin_vec::ThinVec<Option<RefPtr<nsINotificationActionStorageEntry>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetActions)(self, aActions)
    }



    /// `readonly attribute AString serviceWorkerRegistrationScope;`
    #[inline]
    pub unsafe fn GetServiceWorkerRegistrationScope(&self, aServiceWorkerRegistrationScope: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetServiceWorkerRegistrationScope)(self, aServiceWorkerRegistrationScope)
    }


}


/// `interface nsINotificationStorageCallback : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsINotificationStorageCallback {
    vtable: &'static nsINotificationStorageCallbackVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsINotificationStorageCallback.
unsafe impl XpCom for nsINotificationStorageCallback {
    const IID: nsIID = nsID(0xc1622232, 0x259c, 0x43b0,
        [0xb5, 0x2e, 0x89, 0xc3, 0x9d, 0xcd, 0x97, 0x96]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsINotificationStorageCallback {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsINotificationStorageCallback.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsINotificationStorageCallbackCoerce {
    /// Cheaply cast a value of this type from a `nsINotificationStorageCallback`.
    fn coerce_from(v: &nsINotificationStorageCallback) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsINotificationStorageCallbackCoerce for nsINotificationStorageCallback {
    #[inline]
    fn coerce_from(v: &nsINotificationStorageCallback) -> &Self {
        v
    }
}

impl nsINotificationStorageCallback {
    /// Cast this `nsINotificationStorageCallback` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsINotificationStorageCallbackCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsINotificationStorageCallback {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsINotificationStorageCallbackCoerce for T {
    #[inline]
    fn coerce_from(v: &nsINotificationStorageCallback) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsINotificationStorageCallback
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsINotificationStorageCallbackVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void done (in Array<nsINotificationStorageEntry> aEntries); */
    pub Done: unsafe extern "system" fn (this: *const nsINotificationStorageCallback, aEntries: *const thin_vec::ThinVec<Option<RefPtr<nsINotificationStorageEntry>>>) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsINotificationStorageCallback {

    /// ```text
    /// /**
    ///    * Callback function used to pass single notification back
    ///    * into C++ land for getNotifications() return data.
    ///    *
    ///    * @param aEntry: the stored notification entries
    ///    */
    /// ```
    ///

    /// `void done (in Array<nsINotificationStorageEntry> aEntries);`
    #[inline]
    pub unsafe fn Done(&self, aEntries: *const thin_vec::ThinVec<Option<RefPtr<nsINotificationStorageEntry>>>) -> ::nserror::nsresult {
        ((*self.vtable).Done)(self, aEntries)
    }


}


/// `interface nsINotificationStorage : nsISupports`
///

/// ```text
/// /**
///  * Interface for notification persistence layer.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsINotificationStorage {
    vtable: &'static nsINotificationStorageVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsINotificationStorage.
unsafe impl XpCom for nsINotificationStorage {
    const IID: nsIID = nsID(0x17f85e52, 0xfe57, 0x440e,
        [0x9b, 0xa1, 0x5c, 0x31, 0x2c, 0xa0, 0x2b, 0x95]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsINotificationStorage {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsINotificationStorage.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsINotificationStorageCoerce {
    /// Cheaply cast a value of this type from a `nsINotificationStorage`.
    fn coerce_from(v: &nsINotificationStorage) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsINotificationStorageCoerce for nsINotificationStorage {
    #[inline]
    fn coerce_from(v: &nsINotificationStorage) -> &Self {
        v
    }
}

impl nsINotificationStorage {
    /// Cast this `nsINotificationStorage` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsINotificationStorageCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsINotificationStorage {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsINotificationStorageCoerce for T {
    #[inline]
    fn coerce_from(v: &nsINotificationStorage) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsINotificationStorage
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsINotificationStorageVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void put (in AString aOrigin, in nsINotificationStorageEntry aEntry, in AString aScope); */
    pub Put: unsafe extern "system" fn (this: *const nsINotificationStorage, aOrigin: *const ::nsstring::nsAString, aEntry: *const nsINotificationStorageEntry, aScope: *const ::nsstring::nsAString) -> ::nserror::nsresult,

    /* void get (in AString origin, in AString scope, in AString tag, in nsINotificationStorageCallback aCallback); */
    pub Get: unsafe extern "system" fn (this: *const nsINotificationStorage, origin: *const ::nsstring::nsAString, scope: *const ::nsstring::nsAString, tag: *const ::nsstring::nsAString, aCallback: *const nsINotificationStorageCallback) -> ::nserror::nsresult,

    /* Promise getById (in AUTF8String origin, in AString id); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetById: *const ::libc::c_void,

    /* void delete (in AString origin, in AString id); */
    pub Delete: unsafe extern "system" fn (this: *const nsINotificationStorage, origin: *const ::nsstring::nsAString, id: *const ::nsstring::nsAString) -> ::nserror::nsresult,

    /* void deleteAllExcept (in Array<AString> ids); */
    pub DeleteAllExcept: unsafe extern "system" fn (this: *const nsINotificationStorage, ids: *const thin_vec::ThinVec<::nsstring::nsString>) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsINotificationStorage {

    /// ```text
    /// /**
    ///    * Add/replace a notification to the persistence layer.
    ///    *
    ///    * @param aOrigin: the origin of this notification
    ///    * @param aScope: the ServiceWorker registration scope, or empty if unscoped.
    ///    * @param aEntry: the notification data to store
    ///    */
    /// ```
    ///

    /// `void put (in AString aOrigin, in nsINotificationStorageEntry aEntry, in AString aScope);`
    #[inline]
    pub unsafe fn Put(&self, aOrigin: *const ::nsstring::nsAString, aEntry: *const nsINotificationStorageEntry, aScope: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).Put)(self, aOrigin, aEntry, aScope)
    }


    /// ```text
    /// /**
    ///    * Retrieve a list of notifications.
    ///    *
    ///    * @param origin: the origin for which to fetch notifications from
    ///    * @param scope: Used to limit for the specific scope.
    ///    *               Pass an empty string for unscoped notifications.
    ///    *               (See bug 1881812 for potential spec changes to how notifications
        ///    *               are associated with ServiceWorker registrations.)
    ///    * @param tag: used to fetch only a specific tag
    ///    * @param callback: nsINotificationStorageCallback, used for
    ///    *                  returning notifications objects
    ///    */
    /// ```
    ///

    /// `void get (in AString origin, in AString scope, in AString tag, in nsINotificationStorageCallback aCallback);`
    #[inline]
    pub unsafe fn Get(&self, origin: *const ::nsstring::nsAString, scope: *const ::nsstring::nsAString, tag: *const ::nsstring::nsAString, aCallback: *const nsINotificationStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).Get)(self, origin, scope, tag, aCallback)
    }


    /// ```text
    /// /**
    ///    * Retrieve a notification by ID.
    ///    *
    ///    * @param origin: the origin/app for which to fetch notifications from
    ///    * @param tag: used to fetch only a specific tag
    ///    */
    /// ```
    ///

    /// `Promise getById (in AUTF8String origin, in AString id);`
    const _GetById: () = ();

    /// ```text
    /// /**
    ///    * Remove a notification from storage.
    ///    *
    ///    * @param origin: the origin to delete the notification from
    ///    * @param id: the uuid for the notification to delete
    ///    */
    /// ```
    ///

    /// `void delete (in AString origin, in AString id);`
    #[inline]
    pub unsafe fn Delete(&self, origin: *const ::nsstring::nsAString, id: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).Delete)(self, origin, id)
    }


    /// ```text
    /// /**
    ///    * Remove all notifications from storage, except the ones in `ids`.
    ///    *
    ///    * This can be used to clean up old notifications that are not known to the
    ///    * system notification backend anymore. It's needed because the backend can
    ///    * discard notifications while Firefox is not running.
    ///    *
    ///    * No `origin` parameter because:
    ///    *
    ///    * 1. This should affect all known origins
    ///    * 2. The IDs are unique and should not collide between origins
    ///    *
    ///    * @param ids: the ids for the notifications to not delete
    ///    */
    /// ```
    ///

    /// `void deleteAllExcept (in Array<AString> ids);`
    #[inline]
    pub unsafe fn DeleteAllExcept(&self, ids: *const thin_vec::ThinVec<::nsstring::nsString>) -> ::nserror::nsresult {
        ((*self.vtable).DeleteAllExcept)(self, ids)
    }


}


