//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/base/nsIPermissionManager.idl
//


/// `interface nsIPermissionManager : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIPermissionManager {
    vtable: &'static nsIPermissionManagerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIPermissionManager.
unsafe impl XpCom for nsIPermissionManager {
    const IID: nsIID = nsID(0x4dcb3851, 0xeba2, 0x4e42,
        [0xb2, 0x36, 0x82, 0xd2, 0x59, 0x6f, 0xca, 0x22]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIPermissionManager {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIPermissionManager.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIPermissionManagerCoerce {
    /// Cheaply cast a value of this type from a `nsIPermissionManager`.
    fn coerce_from(v: &nsIPermissionManager) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIPermissionManagerCoerce for nsIPermissionManager {
    #[inline]
    fn coerce_from(v: &nsIPermissionManager) -> &Self {
        v
    }
}

impl nsIPermissionManager {
    /// Cast this `nsIPermissionManager` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIPermissionManagerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIPermissionManager {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIPermissionManagerCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIPermissionManager) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIPermissionManager
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIPermissionManagerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* Array<nsIPermission> getAllForPrincipal (in nsIPrincipal principal); */
    pub GetAllForPrincipal: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult,

    /* Array<nsIPermission> getAllWithTypePrefix (in ACString prefix); */
    pub GetAllWithTypePrefix: unsafe extern "system" fn (this: *const nsIPermissionManager, prefix: *const ::nsstring::nsACString, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult,

    /* Array<nsIPermission> getAllByTypes (in Array<ACString> types); */
    pub GetAllByTypes: unsafe extern "system" fn (this: *const nsIPermissionManager, types: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult,

    /* Array<nsIPermission> getAllByTypeSince (in ACString type, in int64_t since); */
    pub GetAllByTypeSince: unsafe extern "system" fn (this: *const nsIPermissionManager, type_: *const ::nsstring::nsACString, since: i64, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult,

    /* void addFromPrincipal (in nsIPrincipal principal, in ACString type, in uint32_t permission, [optional] in uint32_t expireType, [optional] in int64_t expireTime); */
    pub AddFromPrincipal: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32, expireType: u32, expireTime: i64) -> ::nserror::nsresult,

    /* void testAddFromPrincipalByTime (in nsIPrincipal principal, in ACString type, in uint32_t permission, in int64_t modificationTime); */
    pub TestAddFromPrincipalByTime: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32, modificationTime: i64) -> ::nserror::nsresult,

    /* void addFromPrincipalAndPersistInPrivateBrowsing (in nsIPrincipal principal, in ACString type, in uint32_t permission); */
    pub AddFromPrincipalAndPersistInPrivateBrowsing: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32) -> ::nserror::nsresult,

    /* void addDefaultFromPrincipal (in nsIPrincipal principal, in ACString type, in uint32_t permission); */
    pub AddDefaultFromPrincipal: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32) -> ::nserror::nsresult,

    /* void removeFromPrincipal (in nsIPrincipal principal, in ACString type); */
    pub RemoveFromPrincipal: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void removePermission (in nsIPermission perm); */
    pub RemovePermission: unsafe extern "system" fn (this: *const nsIPermissionManager, perm: *const nsIPermission) -> ::nserror::nsresult,

    /* void removeAll (); */
    pub RemoveAll: unsafe extern "system" fn (this: *const nsIPermissionManager) -> ::nserror::nsresult,

    /* void removeAllSince (in int64_t since); */
    pub RemoveAllSince: unsafe extern "system" fn (this: *const nsIPermissionManager, since: i64) -> ::nserror::nsresult,

    /* void removeByType (in ACString type); */
    pub RemoveByType: unsafe extern "system" fn (this: *const nsIPermissionManager, type_: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void removeAllExceptTypes (in Array<ACString> typeExceptions); */
    pub RemoveAllExceptTypes: unsafe extern "system" fn (this: *const nsIPermissionManager, typeExceptions: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void removeByTypeSince (in ACString type, in int64_t since); */
    pub RemoveByTypeSince: unsafe extern "system" fn (this: *const nsIPermissionManager, type_: *const ::nsstring::nsACString, since: i64) -> ::nserror::nsresult,

    /* void removeAllSinceWithTypeExceptions (in int64_t since, in Array<ACString> typeExceptions); */
    pub RemoveAllSinceWithTypeExceptions: unsafe extern "system" fn (this: *const nsIPermissionManager, since: i64, typeExceptions: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* uint32_t testPermissionFromPrincipal (in nsIPrincipal principal, in ACString type); */
    pub TestPermissionFromPrincipal: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult,

    /* uint32_t testExactPermissionFromPrincipal (in nsIPrincipal principal, in ACString type); */
    pub TestExactPermissionFromPrincipal: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult,

    /* uint32_t testExactPermanentPermission (in nsIPrincipal principal, in ACString type); */
    pub TestExactPermanentPermission: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult,

    /* nsIPermission getPermissionObject (in nsIPrincipal principal, in ACString type, in boolean exactHost); */
    pub GetPermissionObject: unsafe extern "system" fn (this: *const nsIPermissionManager, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, exactHost: bool, _retval: *mut*const nsIPermission) -> ::nserror::nsresult,

    /* readonly attribute Array<nsIPermission> all; */
    pub GetAll: unsafe extern "system" fn (this: *const nsIPermissionManager, aAll: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult,

    /* void removePermissionsWithAttributes (in AString patternAsJSON, in Array<ACString> typeInclusions, in Array<ACString> typeExceptions); */
    pub RemovePermissionsWithAttributes: unsafe extern "system" fn (this: *const nsIPermissionManager, patternAsJSON: *const ::nsstring::nsAString, typeInclusions: *const thin_vec::ThinVec<::nsstring::nsCString>, typeExceptions: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIPermissionManager {
    /// ```text
    /// /**
    ///    * Predefined return values for the testPermission method and for
    ///    * the permission param of the add method
    ///    * NOTES:
    ///    *
    ///    * UNKNOWN_ACTION (0) is reserved to represent the
    ///    * default permission when no entry is found for a host, and
    ///    * should not be used by consumers to indicate otherwise.
    ///    * If no other entries are found, it translates into "prompt"
    ///    * in the permissions.query() API.
    ///    *
    ///    * PROMPT_ACTION (3) is not persisted for most permissions.
    ///    * Except for camera and microphone, where persisting it means
    ///    * "Always Ask" (the user leaves "☐ Remember this decision"
        ///    * unchecked in the permission grant). It translates into
    ///    * "granted" in permissions.query() to prevent websites from
    ///    * asking users to escalate permissions further.
    ///    *
    ///    * MAX_VALID_ACTION is the highest value (used to validate prefs)
    ///    */
    /// ```
    ///

    pub const UNKNOWN_ACTION: u32 = 0;


    pub const ALLOW_ACTION: u32 = 1;


    pub const DENY_ACTION: u32 = 2;


    pub const PROMPT_ACTION: u32 = 3;


    pub const MAX_VALID_ACTION: u32 = 3;

    /// ```text
    /// /**
    ///    * Predefined expiration types for permissions.  Permissions can be permanent
    ///    * (never expire), expire at the end of the session, or expire at a specified
    ///    * time. Permissions that expire at the end of a session may also have a
    ///    * specified expiration time.
    ///    *
    ///    * EXPIRE_POLICY is a special expiration status. It is set when the permission
    ///    * is set by reading an enterprise policy. These permissions cannot be overridden.
    ///    */
    /// ```
    ///

    pub const EXPIRE_NEVER: u32 = 0;


    pub const EXPIRE_SESSION: u32 = 1;


    pub const EXPIRE_TIME: u32 = 2;


    pub const EXPIRE_POLICY: u32 = 3;

    /// ```text
    /// /**
    ///    * Get all custom permissions for a given nsIPrincipal. This will return an
    ///    * enumerator of all permissions which are not set to default and which
    ///    * belong to the matching principal of the given nsIPrincipal.
    ///    *
    ///    * @param principal  the URI to get all permissions for
    ///    */
    /// ```
    ///

    /// `Array<nsIPermission> getAllForPrincipal (in nsIPrincipal principal);`
    #[inline]
    pub unsafe fn GetAllForPrincipal(&self, principal: *const nsIPrincipal, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetAllForPrincipal)(self, principal, _retval)
    }


    /// ```text
    /// /**
    ///    * Get all custom permissions of a specific type, specified with a prefix
    ///    * string.  This will return an array of all permissions which are not set to
    ///    * default.  Also the passed type argument is either equal to or a prefix of
    ///    * the type of the returned permissions.
    ///    *
    ///    * @param prefix  the type prefix string
    ///    */
    /// ```
    ///

    /// `Array<nsIPermission> getAllWithTypePrefix (in ACString prefix);`
    #[inline]
    pub unsafe fn GetAllWithTypePrefix(&self, prefix: *const ::nsstring::nsACString, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetAllWithTypePrefix)(self, prefix, _retval)
    }


    /// ```text
    /// /**
    ///    * Get all custom permissions whose type exactly match one of the types defined
    ///    * in the passed array argument.
    ///    * This will return an array of all permissions which are not set to default.
    ///    *
    ///    * @param types  an array of case-sensitive ASCII strings, identifying the
    ///    *               permissions to be matched.
    ///    */
    /// ```
    ///

    /// `Array<nsIPermission> getAllByTypes (in Array<ACString> types);`
    #[inline]
    pub unsafe fn GetAllByTypes(&self, types: *const thin_vec::ThinVec<::nsstring::nsCString>, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetAllByTypes)(self, types, _retval)
    }


    /// ```text
    /// /**
    ///    * Get all custom permissions of a specific type and that were modified after
    ///    * the specified date. This will return an array of all permissions which are
    ///    * not set to default.
    ///    *
    ///    * @param type    a case-sensitive ASCII string, identifying the permission.
    ///    * @param since   a unix timestamp representing the number of milliseconds from
    ///    *                Jan 1, 1970 00:00:00 UTC.
    ///    */
    /// ```
    ///

    /// `Array<nsIPermission> getAllByTypeSince (in ACString type, in int64_t since);`
    #[inline]
    pub unsafe fn GetAllByTypeSince(&self, type_: *const ::nsstring::nsACString, since: i64, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetAllByTypeSince)(self, type_, since, _retval)
    }


    /// ```text
    /// /**
    ///    * Add permission information for a given principal.
    ///    * It is internally calling the other add() method using the nsIURI from the
    ///    * principal.
    ///    * Passing a system principal will be a no-op because they will always be
    ///    * granted permissions.
    ///    */
    /// ```
    ///

    /// `void addFromPrincipal (in nsIPrincipal principal, in ACString type, in uint32_t permission, [optional] in uint32_t expireType, [optional] in int64_t expireTime);`
    #[inline]
    pub unsafe fn AddFromPrincipal(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32, expireType: u32, expireTime: i64) -> ::nserror::nsresult {
        ((*self.vtable).AddFromPrincipal)(self, principal, type_, permission, expireType, expireTime)
    }


    /// ```text
    /// /**
    ///    * Test method to add a permission for a given principal with custom modification time.
    ///    */
    /// ```
    ///

    /// `void testAddFromPrincipalByTime (in nsIPrincipal principal, in ACString type, in uint32_t permission, in int64_t modificationTime);`
    #[inline]
    pub unsafe fn TestAddFromPrincipalByTime(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32, modificationTime: i64) -> ::nserror::nsresult {
        ((*self.vtable).TestAddFromPrincipalByTime)(self, principal, type_, permission, modificationTime)
    }


    /// ```text
    /// /**
    ///    * Add permanent permission information for a given principal in private
    ///    * browsing.
    ///    *
    ///    * Normally permissions in private browsing are cleared at the end of the
    ///    * session, this method allows you to override this behavior and set
    ///    * permanent permissions.
    ///    *
    ///    * WARNING: setting permanent permissions _will_ leak data in private
    ///    * browsing. Only use if you understand the consequences and trade-offs. If
    ///    * you are unsure, |addFromPrincipal| is very likely what you want to use
    ///    * instead.
    ///    */
    /// ```
    ///

    /// `void addFromPrincipalAndPersistInPrivateBrowsing (in nsIPrincipal principal, in ACString type, in uint32_t permission);`
    #[inline]
    pub unsafe fn AddFromPrincipalAndPersistInPrivateBrowsing(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32) -> ::nserror::nsresult {
        ((*self.vtable).AddFromPrincipalAndPersistInPrivateBrowsing)(self, principal, type_, permission)
    }


    /// ```text
    /// /**
    ///    * Add temporary default permission information for a given principal.
    ///    * This permission will be cleared at the end of the session, will not be
    ///    * stored on disk, and will not be set if a conflicting (non-default)
    ///    * permission already exists.
    ///    *
    ///    * This function shouldn't be used by regular permission manager consumers and
    ///    * is only expected to be called by the RemotePermissionService.sys.mjs for
    ///    * the purpose of importing default permissions from remote settings.
    ///    */
    /// ```
    ///

    /// `void addDefaultFromPrincipal (in nsIPrincipal principal, in ACString type, in uint32_t permission);`
    #[inline]
    pub unsafe fn AddDefaultFromPrincipal(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, permission: u32) -> ::nserror::nsresult {
        ((*self.vtable).AddDefaultFromPrincipal)(self, principal, type_, permission)
    }


    /// ```text
    /// /**
    ///    * Remove permission information for a given principal.
    ///    * This is internally calling remove() with the host from the principal's URI.
    ///    * Passing system principal will be a no-op because we never add them to the
    ///    * database.
    ///    */
    /// ```
    ///

    /// `void removeFromPrincipal (in nsIPrincipal principal, in ACString type);`
    #[inline]
    pub unsafe fn RemoveFromPrincipal(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).RemoveFromPrincipal)(self, principal, type_)
    }


    /// ```text
    /// /**
    ///    * Remove the given permission from the permission manager.
    ///    *
    ///    * @param perm   a permission obtained from the permission manager.
    ///    */
    /// ```
    ///

    /// `void removePermission (in nsIPermission perm);`
    #[inline]
    pub unsafe fn RemovePermission(&self, perm: *const nsIPermission) -> ::nserror::nsresult {
        ((*self.vtable).RemovePermission)(self, perm)
    }


    /// ```text
    /// /**
    ///    * Clear permission information for all websites.
    ///    */
    /// ```
    ///

    /// `void removeAll ();`
    #[inline]
    pub unsafe fn RemoveAll(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).RemoveAll)(self, )
    }


    /// ```text
    /// /**
    ///    * Clear all permission information added since the specified time.
    ///    */
    /// ```
    ///

    /// `void removeAllSince (in int64_t since);`
    #[inline]
    pub unsafe fn RemoveAllSince(&self, since: i64) -> ::nserror::nsresult {
        ((*self.vtable).RemoveAllSince)(self, since)
    }


    /// ```text
    /// /**
    ///    * Clear all permissions of the passed type.
    ///    */
    /// ```
    ///

    /// `void removeByType (in ACString type);`
    #[inline]
    pub unsafe fn RemoveByType(&self, type_: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).RemoveByType)(self, type_)
    }


    /// ```text
    /// /**
    ///    * Clear all permissions not of the passed types.
    ///    */
    /// ```
    ///

    /// `void removeAllExceptTypes (in Array<ACString> typeExceptions);`
    #[inline]
    pub unsafe fn RemoveAllExceptTypes(&self, typeExceptions: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).RemoveAllExceptTypes)(self, typeExceptions)
    }


    /// ```text
    /// /**
    ///    * Clear all permissions of the passed type added since the specified time.
    ///    * @param type    a case-sensitive ASCII string, identifying the permission.
    ///    * @param since   a unix timestamp representing the number of milliseconds from
    ///    *                Jan 1, 1970 00:00:00 UTC.
    ///    */
    /// ```
    ///

    /// `void removeByTypeSince (in ACString type, in int64_t since);`
    #[inline]
    pub unsafe fn RemoveByTypeSince(&self, type_: *const ::nsstring::nsACString, since: i64) -> ::nserror::nsresult {
        ((*self.vtable).RemoveByTypeSince)(self, type_, since)
    }


    /// ```text
    /// /**
    ///    * Clear all permissions of the passed types added since the specified time.
    ///    * @param since   a unix timestamp representing the number of milliseconds from
    ///    *                Jan 1, 1970 00:00:00 UTC.
    ///    * @param typeExceptions    a array of case-sensitive ASCII strings, identifying
    ///    *                          the types to not remove.
    ///    */
    /// ```
    ///

    /// `void removeAllSinceWithTypeExceptions (in int64_t since, in Array<ACString> typeExceptions);`
    #[inline]
    pub unsafe fn RemoveAllSinceWithTypeExceptions(&self, since: i64, typeExceptions: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).RemoveAllSinceWithTypeExceptions)(self, since, typeExceptions)
    }


    /// ```text
    /// /**
    ///    * Test whether the principal has the permission to perform a given action.
    ///    * System principals will always have permissions granted.
    ///    * This function will perform a pref lookup to permissions.default.<type>
    ///    * if the specific permission type is part of the whitelist for that functionality.
    ///    */
    /// ```
    ///

    /// `uint32_t testPermissionFromPrincipal (in nsIPrincipal principal, in ACString type);`
    #[inline]
    pub unsafe fn TestPermissionFromPrincipal(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).TestPermissionFromPrincipal)(self, principal, type_, _retval)
    }


    /// ```text
    /// /**
    ///    * Test whether the principal has the permission to perform a given action.
    ///    * This requires an exact hostname match. Subdomain principals do not match
    ///    * permissions of base domains.
    ///    * System principals will always have permissions granted.
    ///    * This function will perform a pref lookup to permissions.default.<type>
    ///    * if the specific permission type is part of the whitelist for that functionality.
    ///    */
    /// ```
    ///

    /// `uint32_t testExactPermissionFromPrincipal (in nsIPrincipal principal, in ACString type);`
    #[inline]
    pub unsafe fn TestExactPermissionFromPrincipal(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).TestExactPermissionFromPrincipal)(self, principal, type_, _retval)
    }


    /// ```text
    /// /**
    ///    * Test whether a website has permission to perform the given action
    ///    * ignoring active sessions.
    ///    * System principals will always have permissions granted.
    ///    * This function will perform a pref lookup to permissions.default.<type>
    ///    * if the specific permission type is part of the whitelist for that functionality.
    ///    *
    ///    * @param principal the principal
    ///    * @param type      a case-sensitive ASCII string, identifying the consumer
    ///    * @param return    see add(), param permission. returns UNKNOWN_ACTION when
    ///    *                  there is no stored permission for this uri and / or type.
    ///    */
    /// ```
    ///

    /// `uint32_t testExactPermanentPermission (in nsIPrincipal principal, in ACString type);`
    #[inline]
    pub unsafe fn TestExactPermanentPermission(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).TestExactPermanentPermission)(self, principal, type_, _retval)
    }


    /// ```text
    /// /**
    ///    * Get the permission object associated with the given principal and action.
    ///    * @param principal The principal
    ///    * @param type      A case-sensitive ASCII string identifying the consumer
    ///    * @param exactHost If true, only the specific host will be matched.
    ///    *                  If false, base domains of the principal will also
    ///    *                  be searched.
    ///    * @returns The matching permission object, or null if no matching object
    ///    *          was found. No matching object is equivalent to UNKNOWN_ACTION.
    ///    * @note Clients in general should prefer the test* methods unless they
    ///    *       need to know the specific stored details.
    ///    * @note This method will always return null for the system principal.
    ///    */
    /// ```
    ///

    /// `nsIPermission getPermissionObject (in nsIPrincipal principal, in ACString type, in boolean exactHost);`
    #[inline]
    pub unsafe fn GetPermissionObject(&self, principal: *const nsIPrincipal, type_: *const ::nsstring::nsACString, exactHost: bool, _retval: *mut*const nsIPermission) -> ::nserror::nsresult {
        ((*self.vtable).GetPermissionObject)(self, principal, type_, exactHost, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns all stored permissions.
    ///    * @return an array of nsIPermission objects
    ///    */
    /// ```
    ///

    /// `readonly attribute Array<nsIPermission> all;`
    #[inline]
    pub unsafe fn GetAll(&self, aAll: *mut thin_vec::ThinVec<Option<RefPtr<nsIPermission>>>) -> ::nserror::nsresult {
        ((*self.vtable).GetAll)(self, aAll)
    }


    /// ```text
    /// /**
    ///    * Remove all permissions that will match the origin pattern.
    ///    * @param patternAsJSON    Origin pattern to match.
    ///    * @param typeInclusions   Types to include in search. If empty, includes all types.
    ///    * @param typeExceptions   Types to skip in search.
    ///    */
    /// ```
    ///

    /// `void removePermissionsWithAttributes (in AString patternAsJSON, in Array<ACString> typeInclusions, in Array<ACString> typeExceptions);`
    #[inline]
    pub unsafe fn RemovePermissionsWithAttributes(&self, patternAsJSON: *const ::nsstring::nsAString, typeInclusions: *const thin_vec::ThinVec<::nsstring::nsCString>, typeExceptions: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).RemovePermissionsWithAttributes)(self, patternAsJSON, typeInclusions, typeExceptions)
    }


}


