//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIPrintDialogService.idl
//


/// `interface nsIPrintDialogService : nsISupports`
///

/// ```text
/// /**
///  * Service for opening native print dialogs provided by the operating system.
///  * (The widget code may customize the dialog.)
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIPrintDialogService {
    vtable: &'static nsIPrintDialogServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIPrintDialogService.
unsafe impl XpCom for nsIPrintDialogService {
    const IID: nsIID = nsID(0x88af6712, 0xa9fd, 0x4393,
        [0x9a, 0xf3, 0x3f, 0xfb, 0xb1, 0xf2, 0xca, 0xaf]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIPrintDialogService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIPrintDialogService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIPrintDialogServiceCoerce {
    /// Cheaply cast a value of this type from a `nsIPrintDialogService`.
    fn coerce_from(v: &nsIPrintDialogService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIPrintDialogServiceCoerce for nsIPrintDialogService {
    #[inline]
    fn coerce_from(v: &nsIPrintDialogService) -> &Self {
        v
    }
}

impl nsIPrintDialogService {
    /// Cast this `nsIPrintDialogService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIPrintDialogServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIPrintDialogService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIPrintDialogServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIPrintDialogService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIPrintDialogService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIPrintDialogServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void init (); */
    pub Init: unsafe extern "system" fn (this: *const nsIPrintDialogService) -> ::nserror::nsresult,

    /* void showPrintDialog (in mozIDOMWindowProxy aParent, in boolean aHaveSelection, in nsIPrintSettings aPrintSettings); */
    pub ShowPrintDialog: unsafe extern "system" fn (this: *const nsIPrintDialogService, aParent: *const mozIDOMWindowProxy, aHaveSelection: bool, aPrintSettings: *const nsIPrintSettings) -> ::nserror::nsresult,

    /* void showPageSetupDialog (in mozIDOMWindowProxy aParent, in nsIPrintSettings aPrintSettings); */
    pub ShowPageSetupDialog: unsafe extern "system" fn (this: *const nsIPrintDialogService, aParent: *const mozIDOMWindowProxy, aPrintSettings: *const nsIPrintSettings) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIPrintDialogService {

    /// ```text
    /// /**
    ///    * Initialize the service.
    ///    */
    /// ```
    ///

    /// `void init ();`
    #[inline]
    pub unsafe fn Init(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).Init)(self, )
    }


    /// ```text
    /// /**
    ///    * Show the print dialog.
    ///    * @param aParent   A DOM window the dialog will be parented to.
    ///    * @param aHaveSelection A boolean indicating whether the document to be
    ///    *                  printed has some selected text, which is used to
    ///    *                  determine whether the "Print selection only" radio
    ///    *                  button is enabled in the print settings dialog.
    ///    * @param aSettings On entry, this contains initial settings for the
    ///    *                  print dialog. On return, if the print operation should
    ///    *                  proceed, then this has been updated with the settings
    ///    *                  that the user selected in the dialog.
    ///    * @return NS_OK if the print operation should proceed
    ///    * @return NS_ERROR_ABORT if the user indicated not to proceed
    ///    * @return a suitable error for failures to show the print dialog.
    ///    */
    /// ```
    ///

    /// `void showPrintDialog (in mozIDOMWindowProxy aParent, in boolean aHaveSelection, in nsIPrintSettings aPrintSettings);`
    #[inline]
    pub unsafe fn ShowPrintDialog(&self, aParent: *const mozIDOMWindowProxy, aHaveSelection: bool, aPrintSettings: *const nsIPrintSettings) -> ::nserror::nsresult {
        ((*self.vtable).ShowPrintDialog)(self, aParent, aHaveSelection, aPrintSettings)
    }


    /// ```text
    /// /**
    ///    * Show the page setup dialog. Note that there is no way to tell whether the
    ///    * user clicked OK or Cancel on the dialog.
    ///    * @param aParent   A DOM window the dialog will be parented to.
    ///    * @param aSettings On entry, this contains initial settings for the
    ///    *                  page setup dialog. On return, if the dialog wasn't
    ///    *                  cancelled, then this has been updated with the settings
    ///    *                  that the user selected in the dialog.
    ///    */
    /// ```
    ///

    /// `void showPageSetupDialog (in mozIDOMWindowProxy aParent, in nsIPrintSettings aPrintSettings);`
    #[inline]
    pub unsafe fn ShowPageSetupDialog(&self, aParent: *const mozIDOMWindowProxy, aPrintSettings: *const nsIPrintSettings) -> ::nserror::nsresult {
        ((*self.vtable).ShowPageSetupDialog)(self, aParent, aPrintSettings)
    }


}


