//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIPrintSettingsService.idl
//


/// `interface nsIPrintSettingsService : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIPrintSettingsService {
    vtable: &'static nsIPrintSettingsServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIPrintSettingsService.
unsafe impl XpCom for nsIPrintSettingsService {
    const IID: nsIID = nsID(0x841387c8, 0x72e6, 0x484b,
        [0x92, 0x96, 0xbf, 0x6e, 0xea, 0x80, 0xd5, 0x8a]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIPrintSettingsService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIPrintSettingsService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIPrintSettingsServiceCoerce {
    /// Cheaply cast a value of this type from a `nsIPrintSettingsService`.
    fn coerce_from(v: &nsIPrintSettingsService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIPrintSettingsServiceCoerce for nsIPrintSettingsService {
    #[inline]
    fn coerce_from(v: &nsIPrintSettingsService) -> &Self {
        v
    }
}

impl nsIPrintSettingsService {
    /// Cast this `nsIPrintSettingsService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIPrintSettingsServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIPrintSettingsService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIPrintSettingsServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIPrintSettingsService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIPrintSettingsService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIPrintSettingsServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* [noscript] readonly attribute nsIPrintSettings defaultPrintSettingsForPrinting; */
    pub GetDefaultPrintSettingsForPrinting: unsafe extern "system" fn (this: *const nsIPrintSettingsService, aDefaultPrintSettingsForPrinting: *mut*const nsIPrintSettings) -> ::nserror::nsresult,

    /* nsIPrintSettings createNewPrintSettings (); */
    pub CreateNewPrintSettings: unsafe extern "system" fn (this: *const nsIPrintSettingsService, _retval: *mut*const nsIPrintSettings) -> ::nserror::nsresult,

    /* readonly attribute AString lastUsedPrinterName; */
    pub GetLastUsedPrinterName: unsafe extern "system" fn (this: *const nsIPrintSettingsService, aLastUsedPrinterName: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* void initPrintSettingsFromPrinter (in AString aPrinterName, in nsIPrintSettings aPrintSettings); */
    pub InitPrintSettingsFromPrinter: unsafe extern "system" fn (this: *const nsIPrintSettingsService, aPrinterName: *const ::nsstring::nsAString, aPrintSettings: *const nsIPrintSettings) -> ::nserror::nsresult,

    /* void initPrintSettingsFromPrefs (in nsIPrintSettings aPrintSettings, in boolean aUsePrinterNamePrefix, in unsigned long aFlags); */
    pub InitPrintSettingsFromPrefs: unsafe extern "system" fn (this: *const nsIPrintSettingsService, aPrintSettings: *const nsIPrintSettings, aUsePrinterNamePrefix: bool, aFlags: u32) -> ::nserror::nsresult,

    /* void maybeSavePrintSettingsToPrefs (in nsIPrintSettings aPrintSettings, in unsigned long aFlags); */
    pub MaybeSavePrintSettingsToPrefs: unsafe extern "system" fn (this: *const nsIPrintSettingsService, aPrintSettings: *const nsIPrintSettings, aFlags: u32) -> ::nserror::nsresult,

    /* void maybeSaveLastUsedPrinterNameToPrefs (in AString aPrinterName); */
    pub MaybeSaveLastUsedPrinterNameToPrefs: unsafe extern "system" fn (this: *const nsIPrintSettingsService, aPrinterName: *const ::nsstring::nsAString) -> ::nserror::nsresult,

    /* [noscript] void SerializeToPrintData (in nsIPrintSettings aPrintSettings, in PrintDataPtr data); */
    /// Unable to generate binding because `native type mozilla::embedding::PrintData unsupported`
    pub SerializeToPrintData: *const ::libc::c_void,

    /* [noscript] void DeserializeToPrintSettings (in PrintDataRef data, in nsIPrintSettings aPrintSettings); */
    /// Unable to generate binding because `native type const mozilla::embedding::PrintData unsupported`
    pub DeserializeToPrintSettings: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIPrintSettingsService {

    /// ```text
    /// /**
    ///    * Returns the default print settings as used for printing.
    ///    */
    /// ```
    ///

    /// `[noscript] readonly attribute nsIPrintSettings defaultPrintSettingsForPrinting;`
    #[inline]
    pub unsafe fn GetDefaultPrintSettingsForPrinting(&self, aDefaultPrintSettingsForPrinting: *mut*const nsIPrintSettings) -> ::nserror::nsresult {
        ((*self.vtable).GetDefaultPrintSettingsForPrinting)(self, aDefaultPrintSettingsForPrinting)
    }


    /// ```text
    /// /**
    ///    * Creates a new nsIPrintSettings object.
    ///    *
    ///    * Initializes the settings object from the unprefixed printer
    ///    * (Note: this may not happen if there is an OS specific implementation.)
    ///    */
    /// ```
    ///

    /// `nsIPrintSettings createNewPrintSettings ();`
    #[inline]
    pub unsafe fn CreateNewPrintSettings(&self, _retval: *mut*const nsIPrintSettings) -> ::nserror::nsresult {
        ((*self.vtable).CreateNewPrintSettings)(self, _retval)
    }


    /// ```text
    /// /**
    ///    * The name of the last printer used. Note that this may not be set, or may
    ///    * no longer be a valid printer. The caller is responsible for checking and
    ///    * falling back to some other printer (such as the system default printer).
    ///    *
    ///    * XXX: make it [infallible] when AString supports that (bug 1491187).
    ///    */
    /// ```
    ///

    /// `readonly attribute AString lastUsedPrinterName;`
    #[inline]
    pub unsafe fn GetLastUsedPrinterName(&self, aLastUsedPrinterName: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetLastUsedPrinterName)(self, aLastUsedPrinterName)
    }


    /// ```text
    /// /**
    ///    * Initializes certain settings from the native printer into the PrintSettings
    ///    * if aPrinterName is null then it uses the default printer name if it can
    ///    * These settings include, but are not limited to:
    ///    *   Page Orientation
    ///    *   Page Size
    ///    *   Number of Copies
    ///    */
    /// ```
    ///

    /// `void initPrintSettingsFromPrinter (in AString aPrinterName, in nsIPrintSettings aPrintSettings);`
    #[inline]
    pub unsafe fn InitPrintSettingsFromPrinter(&self, aPrinterName: *const ::nsstring::nsAString, aPrintSettings: *const nsIPrintSettings) -> ::nserror::nsresult {
        ((*self.vtable).InitPrintSettingsFromPrinter)(self, aPrinterName, aPrintSettings)
    }


    /// ```text
    /// /**
    ///    * Reads PrintSettings values from Prefs,
    ///    * the values to be read are indicated by the "flags" arg.
    ///    *
    ///    * aPrintSettings should be initialized with the name of a printer. First
    ///    * it reads in the PrintSettings from the last print job. Then it uses the
    ///    * PrinterName in the PrinterSettings to read any settings that were saved
    ///    * just for that printer.
    ///    *
    ///    * aPS - PrintSettings to have its settings read
    ///    * aUsePrinterNamePrefix - indicates whether to use the printer name as a prefix
    ///    * aFlags - indicates which prefs to read, see nsIPrintSettings.idl for the
    ///    *          const values.
    ///    *
    ///    * Items not read:
    ///    *   startPageRange, endPageRange, scaling, printRange, title
    ///    *   docURL, isCancelled,
    ///    *   printSilent, shrinkToFit, numCopies,
    ///    *   printerName
    ///    *
    ///    */
    /// ```
    ///

    /// `void initPrintSettingsFromPrefs (in nsIPrintSettings aPrintSettings, in boolean aUsePrinterNamePrefix, in unsigned long aFlags);`
    #[inline]
    pub unsafe fn InitPrintSettingsFromPrefs(&self, aPrintSettings: *const nsIPrintSettings, aUsePrinterNamePrefix: bool, aFlags: u32) -> ::nserror::nsresult {
        ((*self.vtable).InitPrintSettingsFromPrefs)(self, aPrintSettings, aUsePrinterNamePrefix, aFlags)
    }


    /// ```text
    /// /**
    ///    * As long as the pref print.save_print_settings isn't set to false, this
    ///    * saves to prefs the settings from aPrintSettings that are indicated by
    ///    * aFlags.
    ///    *
    ///    * If there is no PrinterName in the PrinterSettings
    ///    * the values are saved as the "generic" values not associated with any printer.
    ///    * If a PrinterName is there, then it saves the items qualified for that Printer
    ///    *
    ///    * aPS - PrintSettings to have its settings saved
    ///    * aFlags - indicates which prefs to save, see nsIPrintSettings.idl for the const values.
    ///    *
    ///    * Items not written:
    ///    *   startPageRange, endPageRange, scaling, printRange, title
    ///    *   docURL, isCancelled,
    ///    *   printSilent, shrinkToFit, numCopies
    ///    *
    ///    */
    /// ```
    ///

    /// `void maybeSavePrintSettingsToPrefs (in nsIPrintSettings aPrintSettings, in unsigned long aFlags);`
    #[inline]
    pub unsafe fn MaybeSavePrintSettingsToPrefs(&self, aPrintSettings: *const nsIPrintSettings, aFlags: u32) -> ::nserror::nsresult {
        ((*self.vtable).MaybeSavePrintSettingsToPrefs)(self, aPrintSettings, aFlags)
    }


    /// ```text
    /// /**
    ///    * As long as the pref print.save_print_settings isn't set to false, this
    ///    * saves the given printer name as the last used printer name.
    ///    */
    /// ```
    ///

    /// `void maybeSaveLastUsedPrinterNameToPrefs (in AString aPrinterName);`
    #[inline]
    pub unsafe fn MaybeSaveLastUsedPrinterNameToPrefs(&self, aPrinterName: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).MaybeSaveLastUsedPrinterNameToPrefs)(self, aPrinterName)
    }


    /// ```text
    /// /**
    ///    * Given some nsIPrintSettings,
    ///    * populates a PrintData representing them which can be sent over IPC. Values
    ///    * are only ever read from aSettings and aWBP.
    ///    *
    ///    * @param aSettings
    ///    *        An nsIPrintSettings for a print job.
    ///    * @param data
    ///    *        Pointer to a pre-existing PrintData to populate.
    ///    *
    ///    * @return nsresult
    ///    */
    /// ```
    ///

    /// `[noscript] void SerializeToPrintData (in nsIPrintSettings aPrintSettings, in PrintDataPtr data);`
    const _SerializeToPrintData: () = ();

    /// ```text
    /// /**
    ///    * This function is the opposite of SerializeToPrintData, in that it takes
    ///    * a PrintData, and populates a pre-existing nsIPrintSettings with the data
    ///    * from PrintData.
    ///    *
    ///    * @param PrintData
    ///    *        Printing information sent through IPC.
    ///    * @param settings
    ///    *        A pre-existing nsIPrintSettings to populate with the PrintData.
    ///    *
    ///    * @return nsresult
    ///    */
    /// ```
    ///

    /// `[noscript] void DeserializeToPrintSettings (in PrintDataRef data, in nsIPrintSettings aPrintSettings);`
    const _DeserializeToPrintSettings: () = ();

}


