//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/xpcom/io/nsIRandomAccessStream.idl
//


/// `interface nsIRandomAccessStream : nsISeekableStream`
///

/// ```text
/// /**
///  * nsIRandomAccessStream
///  *
///  * An interface which supports both reading and writing to a storage starting
///  * at the current offset. Both the input stream and the output stream share the
///  * offset in the stream. Read operations invoked on the input stream start at
///  * the offset and advance it past the bytes read. Write operations invoked on
///  * the output stream start the offset and advance it past the bytes written.
///  * The offset can be set to an arbitrary value prior reading or writting. Each
///  * call to getInputStream or getOutputStream always returns the same object,
///  * rather than creating a new stream. It's recommended for objects implementing
///  * this interface to also implement nsIInputStream and nsIOutputStream, so they
///  * can be easilly used with e.g. NS_AsyncCopy.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIRandomAccessStream {
    vtable: &'static nsIRandomAccessStreamVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIRandomAccessStream.
unsafe impl XpCom for nsIRandomAccessStream {
    const IID: nsIID = nsID(0x9b5904a8, 0x886a, 0x420f,
        [0xa1, 0xd8, 0x84, 0x7d, 0xe8, 0xff, 0xc1, 0x33]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIRandomAccessStream {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIRandomAccessStream.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIRandomAccessStreamCoerce {
    /// Cheaply cast a value of this type from a `nsIRandomAccessStream`.
    fn coerce_from(v: &nsIRandomAccessStream) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIRandomAccessStreamCoerce for nsIRandomAccessStream {
    #[inline]
    fn coerce_from(v: &nsIRandomAccessStream) -> &Self {
        v
    }
}

impl nsIRandomAccessStream {
    /// Cast this `nsIRandomAccessStream` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIRandomAccessStreamCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIRandomAccessStream {
    type Target = nsISeekableStream;
    #[inline]
    fn deref(&self) -> &nsISeekableStream {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISeekableStreamCoerce> nsIRandomAccessStreamCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIRandomAccessStream) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIRandomAccessStream
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIRandomAccessStreamVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISeekableStreamVTable,

    /* nsIInputStream getInputStream (); */
    pub GetInputStream: unsafe extern "system" fn (this: *const nsIRandomAccessStream, _retval: *mut*const nsIInputStream) -> ::nserror::nsresult,

    /* nsIOutputStream getOutputStream (); */
    pub GetOutputStream: unsafe extern "system" fn (this: *const nsIRandomAccessStream, _retval: *mut*const nsIOutputStream) -> ::nserror::nsresult,

    /* [nostdcall,notxpcom] nsIInputStream inputStream (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub InputStream: *const ::libc::c_void,

    /* [nostdcall,notxpcom] nsIOutputStream outputStream (); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub OutputStream: *const ::libc::c_void,

    /* [nostdcall,notxpcom] RandomAccessStreamParams serialize (in nsIInterfaceRequestor aCallbacks); */
    /// Unable to generate binding because `nostdcall is unsupported`
    pub Serialize: *const ::libc::c_void,

    /* [nostdcall,notxpcom] boolean deserialize (inout RandomAccessStreamParamsRef params); */
    /// Unable to generate binding because `native type mozilla::ipc::RandomAccessStreamParams unsupported`
    pub Deserialize: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIRandomAccessStream {

    /// ```text
    /// /**
    ///    * This method always returns the same object.
    ///    */
    /// ```
    ///

    /// `nsIInputStream getInputStream ();`
    #[inline]
    pub unsafe fn GetInputStream(&self, _retval: *mut*const nsIInputStream) -> ::nserror::nsresult {
        ((*self.vtable).GetInputStream)(self, _retval)
    }


    /// ```text
    /// /**
    ///    * This method always returns the same object.
    ///    */
    /// ```
    ///

    /// `nsIOutputStream getOutputStream ();`
    #[inline]
    pub unsafe fn GetOutputStream(&self, _retval: *mut*const nsIOutputStream) -> ::nserror::nsresult {
        ((*self.vtable).GetOutputStream)(self, _retval)
    }


    /// ```text
    /// /**
    ///    * Like getInputStream but infallible.
    ///    */
    /// ```
    ///

    /// `[nostdcall,notxpcom] nsIInputStream inputStream ();`
    const _InputStream: () = ();

    /// ```text
    /// /**
    ///    * Like getOutputStream but infallible.
    ///    */
    /// ```
    ///

    /// `[nostdcall,notxpcom] nsIOutputStream outputStream ();`
    const _OutputStream: () = ();


    /// `[nostdcall,notxpcom] RandomAccessStreamParams serialize (in nsIInterfaceRequestor aCallbacks);`
    const _Serialize: () = ();


    /// `[nostdcall,notxpcom] boolean deserialize (inout RandomAccessStreamParamsRef params);`
    const _Deserialize: () = ();

}


