//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/docshell/base/nsIRefreshURI.idl
//


/// `interface nsIRefreshURI : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIRefreshURI {
    vtable: &'static nsIRefreshURIVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIRefreshURI.
unsafe impl XpCom for nsIRefreshURI {
    const IID: nsIID = nsID(0xa5e61a3c, 0x51bd, 0x45be,
        [0xac, 0x0c, 0xe8, 0x7b, 0x71, 0x86, 0x06, 0x56]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIRefreshURI {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIRefreshURI.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIRefreshURICoerce {
    /// Cheaply cast a value of this type from a `nsIRefreshURI`.
    fn coerce_from(v: &nsIRefreshURI) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIRefreshURICoerce for nsIRefreshURI {
    #[inline]
    fn coerce_from(v: &nsIRefreshURI) -> &Self {
        v
    }
}

impl nsIRefreshURI {
    /// Cast this `nsIRefreshURI` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIRefreshURICoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIRefreshURI {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIRefreshURICoerce for T {
    #[inline]
    fn coerce_from(v: &nsIRefreshURI) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIRefreshURI
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIRefreshURIVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void refreshURI (in nsIURI aURI, in nsIPrincipal aPrincipal, in unsigned long aMillis); */
    pub RefreshURI: unsafe extern "system" fn (this: *const nsIRefreshURI, aURI: *const nsIURI, aPrincipal: *const nsIPrincipal, aMillis: u32) -> ::nserror::nsresult,

    /* void forceRefreshURI (in nsIURI aURI, in nsIPrincipal aPrincipal, in unsigned long aMillis); */
    pub ForceRefreshURI: unsafe extern "system" fn (this: *const nsIRefreshURI, aURI: *const nsIURI, aPrincipal: *const nsIPrincipal, aMillis: u32) -> ::nserror::nsresult,

    /* void cancelRefreshURITimers (); */
    pub CancelRefreshURITimers: unsafe extern "system" fn (this: *const nsIRefreshURI) -> ::nserror::nsresult,

    /* readonly attribute boolean refreshPending; */
    pub GetRefreshPending: unsafe extern "system" fn (this: *const nsIRefreshURI, aRefreshPending: *mut bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIRefreshURI {

    /// ```text
    /// /**
    ///       * Load a uri after waiting for aMillis milliseconds (as a result of a
        ///       * meta refresh). If the docshell is busy loading a page currently, the
    ///       * refresh request will be queued and executed when the current load
    ///       * finishes.
    ///       *
    ///       * @param aUri The uri to refresh.
    ///       * @param aPrincipal The triggeringPrincipal for the refresh load
    ///       *   May be null, in which case the principal of current document will be
    ///       *   applied.
    ///       * @param aMillis The number of milliseconds to wait.
    ///       */
    /// ```
    ///

    /// `void refreshURI (in nsIURI aURI, in nsIPrincipal aPrincipal, in unsigned long aMillis);`
    #[inline]
    pub unsafe fn RefreshURI(&self, aURI: *const nsIURI, aPrincipal: *const nsIPrincipal, aMillis: u32) -> ::nserror::nsresult {
        ((*self.vtable).RefreshURI)(self, aURI, aPrincipal, aMillis)
    }


    /// ```text
    /// /**
    ///       * Loads a URI immediately as if it were a meta refresh.
    ///       *
    ///       * @param aURI The URI to refresh.
    ///       * @param aPrincipal The triggeringPrincipal for the refresh load
    ///       *   May be null, in which case the principal of current document will be
    ///       *   applied.
    ///       * @param aMillis The number of milliseconds by which this refresh would
    ///       *                be delayed if it were not being forced.
    ///       */
    /// ```
    ///

    /// `void forceRefreshURI (in nsIURI aURI, in nsIPrincipal aPrincipal, in unsigned long aMillis);`
    #[inline]
    pub unsafe fn ForceRefreshURI(&self, aURI: *const nsIURI, aPrincipal: *const nsIPrincipal, aMillis: u32) -> ::nserror::nsresult {
        ((*self.vtable).ForceRefreshURI)(self, aURI, aPrincipal, aMillis)
    }


    /// ```text
    /// /**
    ///       * Cancels all timer loads.
    ///       */
    /// ```
    ///

    /// `void cancelRefreshURITimers ();`
    #[inline]
    pub unsafe fn CancelRefreshURITimers(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).CancelRefreshURITimers)(self, )
    }


    /// ```text
    /// /**
    ///      * True when there are pending refreshes, false otherwise.
    ///      */
    /// ```
    ///

    /// `readonly attribute boolean refreshPending;`
    #[inline]
    pub unsafe fn GetRefreshPending(&self, aRefreshPending: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetRefreshPending)(self, aRefreshPending)
    }


}


