//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/extensions/permissions/nsIRemotePermissionService.idl
//


/// `interface nsIRemotePermissionService : nsISupports`
///

/// ```text
/// /**
///  * Service to import default permissions from Remote Settings. Will be
///  * initialized by permission manager after it itself has completed its
///  * initialization, and will then import default permissions from Remote Settings
///  * asynchronously. This also means default permissions aren't guranteed to be
///  * available directly after startup.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIRemotePermissionService {
    vtable: &'static nsIRemotePermissionServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIRemotePermissionService.
unsafe impl XpCom for nsIRemotePermissionService {
    const IID: nsIID = nsID(0xa4b1b3b1, 0xb68a, 0x4129,
        [0xaa, 0x2f, 0xeb, 0x08, 0x61, 0x62, 0xa8, 0xc7]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIRemotePermissionService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIRemotePermissionService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIRemotePermissionServiceCoerce {
    /// Cheaply cast a value of this type from a `nsIRemotePermissionService`.
    fn coerce_from(v: &nsIRemotePermissionService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIRemotePermissionServiceCoerce for nsIRemotePermissionService {
    #[inline]
    fn coerce_from(v: &nsIRemotePermissionService) -> &Self {
        v
    }
}

impl nsIRemotePermissionService {
    /// Cast this `nsIRemotePermissionService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIRemotePermissionServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIRemotePermissionService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIRemotePermissionServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIRemotePermissionService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIRemotePermissionService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIRemotePermissionServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void init (); */
    pub Init: unsafe extern "system" fn (this: *const nsIRemotePermissionService) -> ::nserror::nsresult,

    /* readonly attribute Promise isInitialized; */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetIsInitialized: *const ::libc::c_void,

    /* attribute jsval testAllowedPermissionValues; */
    /// Unable to generate binding because `special type jsval unsupported`
    pub GetTestAllowedPermissionValues: *const ::libc::c_void,

    /* attribute jsval testAllowedPermissionValues; */
    /// Unable to generate binding because `special type jsval unsupported`
    pub SetTestAllowedPermissionValues: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIRemotePermissionService {

    /// ```text
    /// /**
    ///      * Asynchonously import all default permissions from remote settings into
    ///      * the permission manager. Also, if not already done, set up remote settings
    ///      * event listener to keep remote permissions in sync.
    ///      */
    /// ```
    ///

    /// `void init ();`
    #[inline]
    pub unsafe fn Init(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).Init)(self, )
    }


    /// ```text
    /// /**
    ///      * Promise that is resolved when the remote permission service has been
    ///      * fully initialized, meaning all intial permissions have been imported and
    ///      * the remote settings sync event listener has been set up. If any errors
    ///      * are encountered during inizialization, this promise will be rejected.
    ///      */
    /// ```
    ///

    /// `readonly attribute Promise isInitialized;`
    const _GetIsInitialized: () = ();

    /// ```text
    /// /**
    ///      * Allowed permission types and values to be set through remote settings.
    ///      * See RemotePermissionService.sys.mjs for further documentation. Exposed
    ///      * only for testing purposes.
    ///      */
    /// ```
    ///

    /// `attribute jsval testAllowedPermissionValues;`
    const _GetTestAllowedPermissionValues: () = ();

    /// ```text
    /// /**
    ///      * Allowed permission types and values to be set through remote settings.
    ///      * See RemotePermissionService.sys.mjs for further documentation. Exposed
    ///      * only for testing purposes.
    ///      */
    /// ```
    ///

    /// `attribute jsval testAllowedPermissionValues;`
    const _SetTestAllowedPermissionValues: () = ();

}


