//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/search/nsISearchService.idl
//


/// `interface nsISearchSubmission : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsISearchSubmission {
    vtable: &'static nsISearchSubmissionVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsISearchSubmission.
unsafe impl XpCom for nsISearchSubmission {
    const IID: nsIID = nsID(0x5799251f, 0x5b55, 0x4df7,
        [0xa9, 0xe7, 0x0c, 0x27, 0x81, 0x2c, 0x46, 0x9a]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsISearchSubmission {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsISearchSubmission.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsISearchSubmissionCoerce {
    /// Cheaply cast a value of this type from a `nsISearchSubmission`.
    fn coerce_from(v: &nsISearchSubmission) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsISearchSubmissionCoerce for nsISearchSubmission {
    #[inline]
    fn coerce_from(v: &nsISearchSubmission) -> &Self {
        v
    }
}

impl nsISearchSubmission {
    /// Cast this `nsISearchSubmission` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsISearchSubmissionCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsISearchSubmission {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsISearchSubmissionCoerce for T {
    #[inline]
    fn coerce_from(v: &nsISearchSubmission) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsISearchSubmission
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsISearchSubmissionVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute nsIInputStream postData; */
    pub GetPostData: unsafe extern "system" fn (this: *const nsISearchSubmission, aPostData: *mut*const nsIInputStream) -> ::nserror::nsresult,

    /* readonly attribute nsIURI uri; */
    pub GetUri: unsafe extern "system" fn (this: *const nsISearchSubmission, aUri: *mut*const nsIURI) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsISearchSubmission {

    /// ```text
    /// /**
    ///    * The POST data associated with a search submission, wrapped in a MIME
    ///    * input stream. May be null.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIInputStream postData;`
    #[inline]
    pub unsafe fn GetPostData(&self, aPostData: *mut*const nsIInputStream) -> ::nserror::nsresult {
        ((*self.vtable).GetPostData)(self, aPostData)
    }


    /// ```text
    /// /**
    ///    * The URI to submit a search to.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIURI uri;`
    #[inline]
    pub unsafe fn GetUri(&self, aUri: *mut*const nsIURI) -> ::nserror::nsresult {
        ((*self.vtable).GetUri)(self, aUri)
    }


}


/// `interface nsISearchEngine : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsISearchEngine {
    vtable: &'static nsISearchEngineVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsISearchEngine.
unsafe impl XpCom for nsISearchEngine {
    const IID: nsIID = nsID(0x620bd920, 0x0491, 0x48c8,
        [0x99, 0xa8, 0xd6, 0x04, 0x7e, 0x64, 0x80, 0x2d]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsISearchEngine {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsISearchEngine.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsISearchEngineCoerce {
    /// Cheaply cast a value of this type from a `nsISearchEngine`.
    fn coerce_from(v: &nsISearchEngine) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsISearchEngineCoerce for nsISearchEngine {
    #[inline]
    fn coerce_from(v: &nsISearchEngine) -> &Self {
        v
    }
}

impl nsISearchEngine {
    /// Cast this `nsISearchEngine` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsISearchEngineCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsISearchEngine {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsISearchEngineCoerce for T {
    #[inline]
    fn coerce_from(v: &nsISearchEngine) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsISearchEngine
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsISearchEngineVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* nsISearchSubmission getSubmission (in AString searchTerms, [optional] in AString responseType); */
    pub GetSubmission: unsafe extern "system" fn (this: *const nsISearchEngine, searchTerms: *const ::nsstring::nsAString, responseType: *const ::nsstring::nsAString, _retval: *mut *const nsISearchSubmission) -> ::nserror::nsresult,

    /* readonly attribute nsIURI searchURLWithNoTerms; */
    pub GetSearchURLWithNoTerms: unsafe extern "system" fn (this: *const nsISearchEngine, aSearchURLWithNoTerms: *mut*const nsIURI) -> ::nserror::nsresult,

    /* AString searchTermFromResult (in nsIURI uri); */
    pub SearchTermFromResult: unsafe extern "system" fn (this: *const nsISearchEngine, uri: *const nsIURI, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString searchUrlQueryParamName; */
    pub GetSearchUrlQueryParamName: unsafe extern "system" fn (this: *const nsISearchEngine, aSearchUrlQueryParamName: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString searchUrlPublicSuffix; */
    pub GetSearchUrlPublicSuffix: unsafe extern "system" fn (this: *const nsISearchEngine, aSearchUrlPublicSuffix: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* boolean supportsResponseType (in AString responseType); */
    pub SupportsResponseType: unsafe extern "system" fn (this: *const nsISearchEngine, responseType: *const ::nsstring::nsAString, _retval: *mut bool) -> ::nserror::nsresult,

    /* Promise getIconURL ([optional] in unsigned short preferredWidth); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetIconURL: *const ::libc::c_void,

    /* void speculativeConnect (in jsval options); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub SpeculativeConnect: *const ::libc::c_void,

    /* attribute AString alias; */
    pub GetAlias: unsafe extern "system" fn (this: *const nsISearchEngine, aAlias: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* attribute AString alias; */
    pub SetAlias: unsafe extern "system" fn (this: *const nsISearchEngine, aAlias: *const ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute Array<AString> aliases; */
    pub GetAliases: unsafe extern "system" fn (this: *const nsISearchEngine, aAliases: *mut thin_vec::ThinVec<::nsstring::nsString>) -> ::nserror::nsresult,

    /* attribute boolean hidden; */
    pub GetHidden: unsafe extern "system" fn (this: *const nsISearchEngine, aHidden: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean hidden; */
    pub SetHidden: unsafe extern "system" fn (this: *const nsISearchEngine, aHidden: bool) -> ::nserror::nsresult,

    /* attribute boolean hideOneOffButton; */
    pub GetHideOneOffButton: unsafe extern "system" fn (this: *const nsISearchEngine, aHideOneOffButton: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean hideOneOffButton; */
    pub SetHideOneOffButton: unsafe extern "system" fn (this: *const nsISearchEngine, aHideOneOffButton: bool) -> ::nserror::nsresult,

    /* readonly attribute AString name; */
    pub GetName: unsafe extern "system" fn (this: *const nsISearchEngine, aName: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString id; */
    pub GetId: unsafe extern "system" fn (this: *const nsISearchEngine, aId: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString telemetryId; */
    pub GetTelemetryId: unsafe extern "system" fn (this: *const nsISearchEngine, aTelemetryId: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString loadPath; */
    pub GetLoadPath: unsafe extern "system" fn (this: *const nsISearchEngine, aLoadPath: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute boolean isAppProvided; */
    pub GetIsAppProvided: unsafe extern "system" fn (this: *const nsISearchEngine, aIsAppProvided: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean isConfigEngine; */
    pub GetIsConfigEngine: unsafe extern "system" fn (this: *const nsISearchEngine, aIsConfigEngine: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean inMemory; */
    pub GetInMemory: unsafe extern "system" fn (this: *const nsISearchEngine, aInMemory: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute string overriddenById; */
    pub GetOverriddenById: unsafe extern "system" fn (this: *const nsISearchEngine, aOverriddenById: *mut *const libc::c_char) -> ::nserror::nsresult,

    /* readonly attribute boolean isGeneralPurposeEngine; */
    pub GetIsGeneralPurposeEngine: unsafe extern "system" fn (this: *const nsISearchEngine, aIsGeneralPurposeEngine: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute AString searchUrlDomain; */
    pub GetSearchUrlDomain: unsafe extern "system" fn (this: *const nsISearchEngine, aSearchUrlDomain: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString clickUrl; */
    pub GetClickUrl: unsafe extern "system" fn (this: *const nsISearchEngine, aClickUrl: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString searchForm; */
    pub GetSearchForm: unsafe extern "system" fn (this: *const nsISearchEngine, aSearchForm: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AUTF8String partnerCode; */
    pub GetPartnerCode: unsafe extern "system" fn (this: *const nsISearchEngine, aPartnerCode: *mut ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsISearchEngine {

    /// ```text
    /// /**
    ///    * Gets a nsISearchSubmission object that contains information about what to
    ///    * send to the search engine, including the URI and postData, if applicable.
    ///    *
    ///    * @param searchTerms
    ///    *   The search term(s) for the submission.
    ///    *
    ///    * @param responseType [optional]
    ///    *   The MIME type that we'd like to receive in response
    ///    *   to this submission.  If null, will default to "text/html".
    ///    *
    ///    * @returns nsISearchSubmission
    ///    *   The submission data. If no appropriate submission can be determined for
    ///    *   the request type, this may be null.
    ///    */
    /// ```
    ///

    /// `nsISearchSubmission getSubmission (in AString searchTerms, [optional] in AString responseType);`
    #[inline]
    pub unsafe fn GetSubmission(&self, searchTerms: *const ::nsstring::nsAString, responseType: *const ::nsstring::nsAString, _retval: *mut *const nsISearchSubmission) -> ::nserror::nsresult {
        ((*self.vtable).GetSubmission)(self, searchTerms, responseType, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns a search URL with no search terms. This is typically used for
    ///    * purposes where we want to check something on the URL, but not use it for
    ///    * an actual submission to the search engine.
    ///    *
    ///    * @returns {nsIURI}
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIURI searchURLWithNoTerms;`
    #[inline]
    pub unsafe fn GetSearchURLWithNoTerms(&self, aSearchURLWithNoTerms: *mut*const nsIURI) -> ::nserror::nsresult {
        ((*self.vtable).GetSearchURLWithNoTerms)(self, aSearchURLWithNoTerms)
    }


    /// ```text
    /// /**
    ///    * Returns the search term of a possible search result URI if and only if:
    ///    * - The URI has the same scheme, host, and path as the engine.
    ///    * - All query parameters of the URI have a matching name and value in the engine.
    ///    * - An exception to the equality check is the engine's termsParameterName
    ///    *   value, which contains a placeholder, i.e. {searchTerms}.
    ///    * - If an engine has query parameters with "null" values, they will be ignored.
    ///    *
    ///    * @param uri
    ///    *   A URI that may or may not be from a search result matching the engine.
    ///    *
    ///    * @returns A string representing the termsParameterName value of the URI,
    ///    *          or an empty string if the URI isn't matched to the engine.
    ///    */
    /// ```
    ///

    /// `AString searchTermFromResult (in nsIURI uri);`
    #[inline]
    pub unsafe fn SearchTermFromResult(&self, uri: *const nsIURI, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).SearchTermFromResult)(self, uri, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns the name of the parameter used for the search terms for a submission
    ///    * URL of type `SearchUtils.URL_TYPE.SEARCH`.
    ///    *
    ///    * @returns A string which is the name of the parameter, or empty string
    ///    *          if no parameter can be found or is not supported (e.g. POST).
    ///    */
    /// ```
    ///

    /// `readonly attribute AString searchUrlQueryParamName;`
    #[inline]
    pub unsafe fn GetSearchUrlQueryParamName(&self, aSearchUrlQueryParamName: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetSearchUrlQueryParamName)(self, aSearchUrlQueryParamName)
    }


    /// ```text
    /// /**
    ///    * Returns the public suffix for the submission URL of type
    ///    * `SearchUtils.URL_TYPE.SEARCH`.
    ///    *
    ///    * @returns A string which is a known public suffix, or empty string
    ///    *          if one cannot be found.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString searchUrlPublicSuffix;`
    #[inline]
    pub unsafe fn GetSearchUrlPublicSuffix(&self, aSearchUrlPublicSuffix: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetSearchUrlPublicSuffix)(self, aSearchUrlPublicSuffix)
    }


    /// ```text
    /// /**
    ///    * Determines whether the engine can return responses in the given
    ///    * MIME type.  Returns true if the engine spec has a URL with the
    ///    * given responseType, false otherwise.
    ///    *
    ///    * @param responseType
    ///    *        The MIME type to check for
    ///    */
    /// ```
    ///

    /// `boolean supportsResponseType (in AString responseType);`
    #[inline]
    pub unsafe fn SupportsResponseType(&self, responseType: *const ::nsstring::nsAString, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).SupportsResponseType)(self, responseType, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns a string with the URL to an engine's icon matching the preferred
    ///    * width as closely as possible. Returns undefined if the engine has no icon.
    ///    *
    ///    * @param preferredWidth
    ///    *   Width of the requested icon. If not specified, it is assumed that
    ///    *   16x16 is desired.
    ///    */
    /// ```
    ///

    /// `Promise getIconURL ([optional] in unsigned short preferredWidth);`
    const _GetIconURL: () = ();

    /// ```text
    /// /**
    ///    * Opens a speculative connection to the engine's search URI
    ///    * (and suggest URI, if different) to reduce request latency
    ///    *
    ///    * @param  options
    ///    *         An object that must contain the following fields:
    ///    *         {window} the content window for the window performing the search
    ///    *         {originAttributes} the originAttributes for performing the search
    ///    *
    ///    * @throws NS_ERROR_INVALID_ARG if options is omitted or lacks required
    ///    *         elemeents
    ///    */
    /// ```
    ///

    /// `void speculativeConnect (in jsval options);`
    const _SpeculativeConnect: () = ();

    /// ```text
    /// /**
    ///    * A user defined alias for the engine.
    ///    * When not an empty string, this should be a unique identifier.
    ///    */
    /// ```
    ///

    /// `attribute AString alias;`
    #[inline]
    pub unsafe fn GetAlias(&self, aAlias: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetAlias)(self, aAlias)
    }


    /// ```text
    /// /**
    ///    * A user defined alias for the engine.
    ///    * When not an empty string, this should be a unique identifier.
    ///    */
    /// ```
    ///

    /// `attribute AString alias;`
    #[inline]
    pub unsafe fn SetAlias(&self, aAlias: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).SetAlias)(self, aAlias)
    }


    /// ```text
    /// /**
    ///    * An array of aliases including the user defined alias and
    ///    * ones specified by the webextensions keywords field.
    ///    */
    /// ```
    ///

    /// `readonly attribute Array<AString> aliases;`
    #[inline]
    pub unsafe fn GetAliases(&self, aAliases: *mut thin_vec::ThinVec<::nsstring::nsString>) -> ::nserror::nsresult {
        ((*self.vtable).GetAliases)(self, aAliases)
    }


    /// ```text
    /// /**
    ///    * Whether the engine should be hidden from the user.
    ///    */
    /// ```
    ///

    /// `attribute boolean hidden;`
    #[inline]
    pub unsafe fn GetHidden(&self, aHidden: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetHidden)(self, aHidden)
    }


    /// ```text
    /// /**
    ///    * Whether the engine should be hidden from the user.
    ///    */
    /// ```
    ///

    /// `attribute boolean hidden;`
    #[inline]
    pub unsafe fn SetHidden(&self, aHidden: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetHidden)(self, aHidden)
    }


    /// ```text
    /// /**
    ///    * Whether the associated one off button should be hidden from the user.
    ///    */
    /// ```
    ///

    /// `attribute boolean hideOneOffButton;`
    #[inline]
    pub unsafe fn GetHideOneOffButton(&self, aHideOneOffButton: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetHideOneOffButton)(self, aHideOneOffButton)
    }


    /// ```text
    /// /**
    ///    * Whether the associated one off button should be hidden from the user.
    ///    */
    /// ```
    ///

    /// `attribute boolean hideOneOffButton;`
    #[inline]
    pub unsafe fn SetHideOneOffButton(&self, aHideOneOffButton: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetHideOneOffButton)(self, aHideOneOffButton)
    }


    /// ```text
    /// /**
    ///    * The display name of the search engine. This is a unique identifier.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString name;`
    #[inline]
    pub unsafe fn GetName(&self, aName: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetName)(self, aName)
    }


    /// ```text
    /// /**
    ///    * The display of the search engine id. This is a unique identifier.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString id;`
    #[inline]
    pub unsafe fn GetId(&self, aId: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetId)(self, aId)
    }


    /// ```text
    /// /**
    ///    * @deprecated: This should not be used for new telemetry. It is a combined
    ///    * field that contains multiple values. Report separate
    ///    * id/partner_code/other fields instead.
    ///    *
    ///    * The identifier to use for this engine when submitting to telemetry.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString telemetryId;`
    #[inline]
    pub unsafe fn GetTelemetryId(&self, aTelemetryId: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetTelemetryId)(self, aTelemetryId)
    }


    /// ```text
    /// /**
    ///    * Anonymized path of where we initially loaded the engine from.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString loadPath;`
    #[inline]
    pub unsafe fn GetLoadPath(&self, aLoadPath: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetLoadPath)(self, aLoadPath)
    }


    /// ```text
    /// /**
    ///    * Whether this engine is an app provided config engine, i.e., it comes
    ///    * from the search-config-v2 and is pre-configured based on the user's
    ///    * environment such as locale and region.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean isAppProvided;`
    #[inline]
    pub unsafe fn GetIsAppProvided(&self, aIsAppProvided: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsAppProvided)(self, aIsAppProvided)
    }


    /// ```text
    /// /**
    ///    * Whether this engine is a config search engine, i.e., it comes
    ///    * from the search-config-v2.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean isConfigEngine;`
    #[inline]
    pub unsafe fn GetIsConfigEngine(&self, aIsConfigEngine: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsConfigEngine)(self, aIsConfigEngine)
    }


    /// ```text
    /// /**
    ///    * Whether or not this engine is an in-memory only search engine.
    ///    * These engines are typically application provided or policy engines,
    ///    * where they are loaded every time on SearchService initialization
    ///    * using the policy JSON or the extension manifest. Minimal details of the
    ///    * in-memory engines are saved to disk, but they are never loaded
    ///    * from the user's saved settings file.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean inMemory;`
    #[inline]
    pub unsafe fn GetInMemory(&self, aInMemory: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetInMemory)(self, aInMemory)
    }


    /// ```text
    /// /**
    ///    * If this engine has been overridden by a third-party engine, the id returned
    ///    * will be the engine it was overriden by. Otherwise this will return null.
    ///    */
    /// ```
    ///

    /// `readonly attribute string overriddenById;`
    #[inline]
    pub unsafe fn GetOverriddenById(&self, aOverriddenById: *mut *const libc::c_char) -> ::nserror::nsresult {
        ((*self.vtable).GetOverriddenById)(self, aOverriddenById)
    }


    /// ```text
    /// /**
    ///    * Whether or not this engine is a "general" search engine, e.g. is it for
    ///    * generally searching the web, or does it have a specific purpose like
    ///    * shopping.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean isGeneralPurposeEngine;`
    #[inline]
    pub unsafe fn GetIsGeneralPurposeEngine(&self, aIsGeneralPurposeEngine: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsGeneralPurposeEngine)(self, aIsGeneralPurposeEngine)
    }


    /// ```text
    /// /**
    ///    * The domain from which search results are returned for this engine.
    ///    *
    ///    * @return the domain of the the search URL.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString searchUrlDomain;`
    #[inline]
    pub unsafe fn GetSearchUrlDomain(&self, aSearchUrlDomain: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetSearchUrlDomain)(self, aSearchUrlDomain)
    }


    /// ```text
    /// /**
    ///    * The URL to report the search to.
    ///    *
    ///    * @return the reporting URL.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString clickUrl;`
    #[inline]
    pub unsafe fn GetClickUrl(&self, aClickUrl: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetClickUrl)(self, aClickUrl)
    }


    /// ```text
    /// /**
    ///    * The URL of the homepage of the engine. Defaults to the pre path
    ///    * of the search URL but search engines can specify an arbitrary URL.
    ///    *
    ///    * @return the URL of the search engine home page.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString searchForm;`
    #[inline]
    pub unsafe fn GetSearchForm(&self, aSearchForm: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetSearchForm)(self, aSearchForm)
    }


    /// ```text
    /// /**
    ///    * The partner code being used by this search engine in the Search URL.
    ///    * @return {string}
    ///    */
    /// ```
    ///

    /// `readonly attribute AUTF8String partnerCode;`
    #[inline]
    pub unsafe fn GetPartnerCode(&self, aPartnerCode: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetPartnerCode)(self, aPartnerCode)
    }


}


/// `interface nsISearchParseSubmissionResult : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsISearchParseSubmissionResult {
    vtable: &'static nsISearchParseSubmissionResultVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsISearchParseSubmissionResult.
unsafe impl XpCom for nsISearchParseSubmissionResult {
    const IID: nsIID = nsID(0x0dc93e51, 0xa7bf, 0x4a16,
        [0x86, 0x2d, 0x4b, 0x34, 0x69, 0xff, 0x62, 0x06]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsISearchParseSubmissionResult {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsISearchParseSubmissionResult.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsISearchParseSubmissionResultCoerce {
    /// Cheaply cast a value of this type from a `nsISearchParseSubmissionResult`.
    fn coerce_from(v: &nsISearchParseSubmissionResult) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsISearchParseSubmissionResultCoerce for nsISearchParseSubmissionResult {
    #[inline]
    fn coerce_from(v: &nsISearchParseSubmissionResult) -> &Self {
        v
    }
}

impl nsISearchParseSubmissionResult {
    /// Cast this `nsISearchParseSubmissionResult` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsISearchParseSubmissionResultCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsISearchParseSubmissionResult {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsISearchParseSubmissionResultCoerce for T {
    #[inline]
    fn coerce_from(v: &nsISearchParseSubmissionResult) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsISearchParseSubmissionResult
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsISearchParseSubmissionResultVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute nsISearchEngine engine; */
    pub GetEngine: unsafe extern "system" fn (this: *const nsISearchParseSubmissionResult, aEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult,

    /* readonly attribute AString terms; */
    pub GetTerms: unsafe extern "system" fn (this: *const nsISearchParseSubmissionResult, aTerms: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute AString termsParameterName; */
    pub GetTermsParameterName: unsafe extern "system" fn (this: *const nsISearchParseSubmissionResult, aTermsParameterName: *mut ::nsstring::nsAString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsISearchParseSubmissionResult {

    /// ```text
    /// /**
    ///    * The search engine associated with the URL passed in to
    ///    * nsISearchEngine::parseSubmissionURL, or null if the URL does not represent
    ///    * a search submission.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsISearchEngine engine;`
    #[inline]
    pub unsafe fn GetEngine(&self, aEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult {
        ((*self.vtable).GetEngine)(self, aEngine)
    }


    /// ```text
    /// /**
    ///    * String containing the sought terms.  This can be an empty string in case no
    ///    * terms were specified or the URL does not represent a search submission.
    ///    */
    /// ```
    ///

    /// `readonly attribute AString terms;`
    #[inline]
    pub unsafe fn GetTerms(&self, aTerms: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetTerms)(self, aTerms)
    }


    /// ```text
    /// /**
    ///    * The name of the query parameter used by `engine` for queries. E.g. "q".
    ///    */
    /// ```
    ///

    /// `readonly attribute AString termsParameterName;`
    #[inline]
    pub unsafe fn GetTermsParameterName(&self, aTermsParameterName: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetTermsParameterName)(self, aTermsParameterName)
    }


}


/// `interface nsISearchService : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsISearchService {
    vtable: &'static nsISearchServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsISearchService.
unsafe impl XpCom for nsISearchService {
    const IID: nsIID = nsID(0x0301834b, 0x2630, 0x440e,
        [0x8b, 0x98, 0xdb, 0x8d, 0xc5, 0x5f, 0x34, 0xb9]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsISearchService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsISearchService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsISearchServiceCoerce {
    /// Cheaply cast a value of this type from a `nsISearchService`.
    fn coerce_from(v: &nsISearchService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsISearchServiceCoerce for nsISearchService {
    #[inline]
    fn coerce_from(v: &nsISearchService) -> &Self {
        v
    }
}

impl nsISearchService {
    /// Cast this `nsISearchService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsISearchServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsISearchService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsISearchServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsISearchService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsISearchService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsISearchServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* Promise init (); */
    /// Unable to generate binding because `special type promise unsupported`
    pub Init: *const ::libc::c_void,

    /* readonly attribute Promise promiseInitialized; */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetPromiseInitialized: *const ::libc::c_void,

    /* readonly attribute boolean isInitialized; */
    pub GetIsInitialized: unsafe extern "system" fn (this: *const nsISearchService, aIsInitialized: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean hasSuccessfullyInitialized; */
    pub GetHasSuccessfullyInitialized: unsafe extern "system" fn (this: *const nsISearchService, aHasSuccessfullyInitialized: *mut bool) -> ::nserror::nsresult,

    /* Promise runBackgroundChecks (); */
    /// Unable to generate binding because `special type promise unsupported`
    pub RunBackgroundChecks: *const ::libc::c_void,

    /* void resetToAppDefaultEngine (); */
    pub ResetToAppDefaultEngine: unsafe extern "system" fn (this: *const nsISearchService) -> ::nserror::nsresult,

    /* Promise addOpenSearchEngine (in AString engineURL, in AString iconURL, [optional] in jsval originAttributes); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub AddOpenSearchEngine: *const ::libc::c_void,

    /* Promise addUserEngine (in jsval formInfo); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub AddUserEngine: *const ::libc::c_void,

    /* Promise addEnginesFromExtension (in jsval extension); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub AddEnginesFromExtension: *const ::libc::c_void,

    /* void restoreDefaultEngines (); */
    pub RestoreDefaultEngines: unsafe extern "system" fn (this: *const nsISearchService) -> ::nserror::nsresult,

    /* Promise getEngineByAlias (in AString alias); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetEngineByAlias: *const ::libc::c_void,

    /* nsISearchEngine getEngineByName (in AString aEngineName); */
    pub GetEngineByName: unsafe extern "system" fn (this: *const nsISearchService, aEngineName: *const ::nsstring::nsAString, _retval: *mut *const nsISearchEngine) -> ::nserror::nsresult,

    /* nsISearchEngine getEngineById (in AString aEngineId); */
    pub GetEngineById: unsafe extern "system" fn (this: *const nsISearchService, aEngineId: *const ::nsstring::nsAString, _retval: *mut *const nsISearchEngine) -> ::nserror::nsresult,

    /* Promise getEngines (); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetEngines: *const ::libc::c_void,

    /* Promise getVisibleEngines (); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetVisibleEngines: *const ::libc::c_void,

    /* Promise getAppProvidedEngines (); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetAppProvidedEngines: *const ::libc::c_void,

    /* Promise findContextualSearchEngineByHost (in AString host); */
    /// Unable to generate binding because `special type promise unsupported`
    pub FindContextualSearchEngineByHost: *const ::libc::c_void,

    /* Promise shouldShowInstallPrompt (in jsval engine); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub ShouldShowInstallPrompt: *const ::libc::c_void,

    /* Promise addSearchEngine (in jsval engine); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub AddSearchEngine: *const ::libc::c_void,

    /* Promise moveEngine (in nsISearchEngine engine, in long newIndex); */
    /// Unable to generate binding because `special type promise unsupported`
    pub MoveEngine: *const ::libc::c_void,

    /* Promise removeEngine (in nsISearchEngine engine, [optional] in unsigned short changeReason); */
    /// Unable to generate binding because `special type promise unsupported`
    pub RemoveEngine: *const ::libc::c_void,

    /* Promise removeWebExtensionEngine (in AString id); */
    /// Unable to generate binding because `special type promise unsupported`
    pub RemoveWebExtensionEngine: *const ::libc::c_void,

    /* readonly attribute nsISearchEngine appDefaultEngine; */
    pub GetAppDefaultEngine: unsafe extern "system" fn (this: *const nsISearchService, aAppDefaultEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult,

    /* readonly attribute nsISearchEngine appPrivateDefaultEngine; */
    pub GetAppPrivateDefaultEngine: unsafe extern "system" fn (this: *const nsISearchService, aAppPrivateDefaultEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult,

    /* readonly attribute nsISearchEngine defaultEngine; */
    pub GetDefaultEngine: unsafe extern "system" fn (this: *const nsISearchService, aDefaultEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult,

    /* Promise getDefault (); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetDefault: *const ::libc::c_void,

    /* Promise setDefault (in nsISearchEngine engine, in unsigned short changeReason); */
    /// Unable to generate binding because `special type promise unsupported`
    pub SetDefault: *const ::libc::c_void,

    /* readonly attribute nsISearchEngine defaultPrivateEngine; */
    pub GetDefaultPrivateEngine: unsafe extern "system" fn (this: *const nsISearchService, aDefaultPrivateEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult,

    /* Promise getDefaultPrivate (); */
    /// Unable to generate binding because `special type promise unsupported`
    pub GetDefaultPrivate: *const ::libc::c_void,

    /* Promise setDefaultPrivate (in nsISearchEngine engine, in unsigned short changeReason); */
    /// Unable to generate binding because `special type promise unsupported`
    pub SetDefaultPrivate: *const ::libc::c_void,

    /* readonly attribute boolean separatePrivateDefaultUrlbarResultEnabled; */
    pub GetSeparatePrivateDefaultUrlbarResultEnabled: unsafe extern "system" fn (this: *const nsISearchService, aSeparatePrivateDefaultUrlbarResultEnabled: *mut bool) -> ::nserror::nsresult,

    /* Promise maybeSetAndOverrideDefault (in jsval extension); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub MaybeSetAndOverrideDefault: *const ::libc::c_void,

    /* jsval getDefaultEngineInfo (); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub GetDefaultEngineInfo: *const ::libc::c_void,

    /* nsISearchParseSubmissionResult parseSubmissionURL (in AString url); */
    pub ParseSubmissionURL: unsafe extern "system" fn (this: *const nsISearchService, url: *const ::nsstring::nsAString, _retval: *mut *const nsISearchParseSubmissionResult) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsISearchService {

    pub const ERROR_DOWNLOAD_FAILURE:  u8 = 1;


    pub const ERROR_DUPLICATE_ENGINE:  u8 = 2;


    pub const ERROR_ENGINE_CORRUPTED:  u8 = 3;


    pub const CHANGE_REASON_UNKNOWN:  u8 = 0;


    pub const CHANGE_REASON_USER:  u8 = 1;


    pub const CHANGE_REASON_USER_PRIVATE_SPLIT:  u8 = 2;


    pub const CHANGE_REASON_USER_SEARCHBAR:  u8 = 3;


    pub const CHANGE_REASON_USER_SEARCHBAR_CONTEXT:  u8 = 4;


    pub const CHANGE_REASON_ADDON_INSTALL:  u8 = 5;


    pub const CHANGE_REASON_ADDON_UNINSTALL:  u8 = 6;


    pub const CHANGE_REASON_CONFIG:  u8 = 7;


    pub const CHANGE_REASON_LOCALE:  u8 = 8;


    pub const CHANGE_REASON_REGION:  u8 = 9;


    pub const CHANGE_REASON_EXPERIMENT:  u8 = 10;


    pub const CHANGE_REASON_ENTERPRISE:  u8 = 11;


    pub const CHANGE_REASON_UITOUR:  u8 = 12;


    pub const CHANGE_REASON_ENGINE_UPDATE:  u8 = 13;


    pub const CHANGE_REASON_USER_PRIVATE_PREF_ENABLED:  u8 = 14;


    pub const CHANGE_REASON_ENGINE_IGNORE_LIST_UPDATED:  u8 = 15;


    pub const CHANGE_REASON_NO_EXISTING_DEFAULT_ENGINE:  u8 = 16;

    /// ```text
    /// /**
    ///    * Start asynchronous initialization.
    ///    *
    ///    * The promise is resolved once initialization is complete, which may be
    ///    * immediately, if initialization has already been completed by some previous
    ///    * call to this method.
    ///    * This method should only be called when you need or want to wait for the
    ///    * full initialization of the search service.
    ///    */
    /// ```
    ///

    /// `Promise init ();`
    const _Init: () = ();

    /// ```text
    /// /**
    ///    * A promise that is resolved when initialization has finished, but does not
    ///    * trigger initialization to begin.
    ///    *
    ///    * @returns {Promise}
    ///    *   Resolved when initalization has successfully finished, and rejected if it
    ///    *   has failed.
    ///    */
    /// ```
    ///

    /// `readonly attribute Promise promiseInitialized;`
    const _GetPromiseInitialized: () = ();

    /// ```text
    /// /**
    ///    * Determine whether initialization has been completed.
    ///    *
    ///    * Clients of the service can use this attribute to quickly determine whether
    ///    * initialization is complete, and decide to trigger some immediate treatment,
    ///    * to launch asynchronous initialization or to bailout.
    ///    *
    ///    * Note that this attribute does not indicate that initialization has succeeded.
    ///    *
    ///    * @return |true| if the search service is now initialized, |false| if
    ///    * initialization has not been triggered yet.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean isInitialized;`
    #[inline]
    pub unsafe fn GetIsInitialized(&self, aIsInitialized: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsInitialized)(self, aIsInitialized)
    }


    /// ```text
    /// /**
    ///    * Determine whether initialization has been completed successfully.
    ///    *
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean hasSuccessfullyInitialized;`
    #[inline]
    pub unsafe fn GetHasSuccessfullyInitialized(&self, aHasSuccessfullyInitialized: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetHasSuccessfullyInitialized)(self, aHasSuccessfullyInitialized)
    }


    /// ```text
    /// /**
    ///    * Runs background checks; Designed to be run on idle.
    ///    */
    /// ```
    ///

    /// `Promise runBackgroundChecks ();`
    const _RunBackgroundChecks: () = ();

    /// ```text
    /// /**
    ///    * Resets the default engine to its app default engine value.
    ///    */
    /// ```
    ///

    /// `void resetToAppDefaultEngine ();`
    #[inline]
    pub unsafe fn ResetToAppDefaultEngine(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).ResetToAppDefaultEngine)(self, )
    }


    /// ```text
    /// /**
    ///    * Adds a new Open Search engine from the file at the supplied URI.
    ///    *
    ///    * @param engineURL
    ///    *        The URL to the search engine's description file.
    ///    *
    ///    * @param iconURL
    ///    *        A URL string to an icon file to be used as the search engine's
    ///    *        icon. This value may be overridden by an icon specified in the
    ///    *        engine description file.
    ///    *
    ///    * @param originAttributes [optional]
    ///             The origin attributes to use to load this manifest.
    ///    *
    ///    * @throws NS_ERROR_FAILURE if the description file cannot be successfully
    ///    *         loaded.
    ///    */
    /// ```
    ///

    /// `Promise addOpenSearchEngine (in AString engineURL, in AString iconURL, [optional] in jsval originAttributes);`
    const _AddOpenSearchEngine: () = ();

    /// ```text
    /// /**
    ///    * Adds a new search engine defined by the user.
    ///    *
    ///    * @param formInfo
    ///    *         General information about the search engine. See UserSearchEngine
    ///    *         for more details.
    ///    * @returns The generated nsISearchEngine object.
    ///    */
    /// ```
    ///

    /// `Promise addUserEngine (in jsval formInfo);`
    const _AddUserEngine: () = ();

    /// ```text
    /// /**
    ///    * Adds search providers to the search service.  If the search
    ///    * service is configured to load multiple locales for the extension,
    ///    * it may load more than one search engine. If called directly
    ///    * ensure the extension has been initialised.
    ///    *
    ///    * @param extension
    ///    *        The extension to load from.
    ///    * @returns Promise that resolves when finished.
    ///    */
    /// ```
    ///

    /// `Promise addEnginesFromExtension (in jsval extension);`
    const _AddEnginesFromExtension: () = ();

    /// ```text
    /// /**
    ///    * Un-hides all engines in the set of engines returned by getAppProvidedEngines.
    ///    */
    /// ```
    ///

    /// `void restoreDefaultEngines ();`
    #[inline]
    pub unsafe fn RestoreDefaultEngines(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).RestoreDefaultEngines)(self, )
    }


    /// ```text
    /// /**
    ///    * Returns the first search engine matching the provided alias
    ///    * (case-insensitive).
    ///    *
    ///    * @param   alias
    ///    *          The search engine's alias.
    ///    * @returns The corresponding nsISearchEngine object, or null if it doesn't
    ///    *          exist.
    ///    */
    /// ```
    ///

    /// `Promise getEngineByAlias (in AString alias);`
    const _GetEngineByAlias: () = ();

    /// ```text
    /// /**
    ///    * Returns an engine with the specified name.
    ///    *
    ///    * @param   aEngineName
    ///    *          The name of the engine.
    ///    * @returns The corresponding nsISearchEngine object, or null if it doesn't
    ///    *          exist.
    ///    */
    /// ```
    ///

    /// `nsISearchEngine getEngineByName (in AString aEngineName);`
    #[inline]
    pub unsafe fn GetEngineByName(&self, aEngineName: *const ::nsstring::nsAString, _retval: *mut *const nsISearchEngine) -> ::nserror::nsresult {
        ((*self.vtable).GetEngineByName)(self, aEngineName, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns an engine with the specified Id.
    ///    *
    ///    * @param   aEngineId
    ///    *          The Id of the engine.
    ///    * @returns The corresponding nsISearchEngine object, or null if it doesn't
    ///    *          exist.
    ///    */
    /// ```
    ///

    /// `nsISearchEngine getEngineById (in AString aEngineId);`
    #[inline]
    pub unsafe fn GetEngineById(&self, aEngineId: *const ::nsstring::nsAString, _retval: *mut *const nsISearchEngine) -> ::nserror::nsresult {
        ((*self.vtable).GetEngineById)(self, aEngineId, _retval)
    }


    /// ```text
    /// /**
    ///    * Returns an array of all installed search engines.
    ///    * The array is sorted either to the user requirements or the default order.
    ///    *
    ///    * @returns an array of nsISearchEngine objects.
    ///    */
    /// ```
    ///

    /// `Promise getEngines ();`
    const _GetEngines: () = ();

    /// ```text
    /// /**
    ///    * Returns an array of all installed search engines whose hidden attribute is
    ///    * false.
    ///    * The array is sorted either to the user requirements or the default order.
    ///    *
    ///    * @returns an array of nsISearchEngine objects.
    ///    */
    /// ```
    ///

    /// `Promise getVisibleEngines ();`
    const _GetVisibleEngines: () = ();

    /// ```text
    /// /**
    ///    * Returns an array of all default search engines. This includes all loaded
    ///    * engines that aren't in the user's profile directory.
    ///    * The array is sorted to the default order.
    ///    *
    ///    * @returns an array of nsISearchEngine objects.
    ///    */
    /// ```
    ///

    /// `Promise getAppProvidedEngines ();`
    const _GetAppProvidedEngines: () = ();

    /// ```text
    /// /**
    ///    * Returns an engine definition if it's search url matches the host provided.
    ///    *
    ///    * @param   host
    ///    *          The host to search for.
    ///    * @returns An nsISearchEngine engine object if one matched.
    ///    */
    /// ```
    ///

    /// `Promise findContextualSearchEngineByHost (in AString host);`
    const _FindContextualSearchEngineByHost: () = ();

    /// ```text
    /// /**
    ///    * Returns whether the user should be given a prompt to install the
    ///    * engine they are currently using. A prompt is shown after the
    ///    * second time a user picks a contextual engine to search with. After
    ///    * the second time the prompt should not be shown again.
    ///    *
    ///    * @param   engine
    ///    *          The engine to check.
    ///    * @returns {boolean}
    ///    *          Whether or not to show the prompt.
    ///    */
    /// ```
    ///

    /// `Promise shouldShowInstallPrompt (in jsval engine);`
    const _ShouldShowInstallPrompt: () = ();

    /// ```text
    /// /**
    ///    * Installs an engine into the users engine list.
    ///    *
    ///    * @param   engine
    ///    *          An engine configuration definition.
    ///    */
    /// ```
    ///

    /// `Promise addSearchEngine (in jsval engine);`
    const _AddSearchEngine: () = ();

    /// ```text
    /// /**
    ///    * Moves a visible search engine.
    ///    *
    ///    * @param  engine
    ///    *         The engine to move.
    ///    * @param  newIndex
    ///    *         The engine's new index in the set of visible engines.
    ///    *
    ///    * @throws NS_ERROR_FAILURE if newIndex is out of bounds, or if engine is
    ///    *         hidden.
    ///    */
    /// ```
    ///

    /// `Promise moveEngine (in nsISearchEngine engine, in long newIndex);`
    const _MoveEngine: () = ();

    /// ```text
    /// /**
    ///    * Removes the search engine. If the search engine is installed in a global
    ///    * location, this will just hide the engine. If the engine is in the user's
    ///    * profile directory, it will be removed from disk.
    ///    *
    ///    * @param  engine
    ///    *         The engine to remove.
    ///    */
    /// ```
    ///

    /// `Promise removeEngine (in nsISearchEngine engine, [optional] in unsigned short changeReason);`
    const _RemoveEngine: () = ();

    /// ```text
    /// /**
    ///    * Notify nsSearchService that an extension has been removed. Removes any
    ///    * engines that are associated with that extension.
    ///    *
    ///    * @param  id
    ///    *         The id of the extension.
    ///    */
    /// ```
    ///

    /// `Promise removeWebExtensionEngine (in AString id);`
    const _RemoveWebExtensionEngine: () = ();

    /// ```text
    /// /**
    ///    * The Application Default Engine object that is the default for this region,
    ///    * ignoring changes the user may have subsequently made.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsISearchEngine appDefaultEngine;`
    #[inline]
    pub unsafe fn GetAppDefaultEngine(&self, aAppDefaultEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult {
        ((*self.vtable).GetAppDefaultEngine)(self, aAppDefaultEngine)
    }


    /// ```text
    /// /**
    ///    * The Application Default Engine object that is the default for this region when in
    ///    * private browsing mode, ignoring changes the user may have subsequently made.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsISearchEngine appPrivateDefaultEngine;`
    #[inline]
    pub unsafe fn GetAppPrivateDefaultEngine(&self, aAppPrivateDefaultEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult {
        ((*self.vtable).GetAppPrivateDefaultEngine)(self, aAppPrivateDefaultEngine)
    }


    /// ```text
    /// /**
    ///    * The currently active search engine.
    ///    * Unless the application doesn't ship any search engine, this should never
    ///    * be null. If the currently active engine is removed, this attribute will
    ///    * fallback first to the application default engine if it's not hidden, then to
    ///    * the first visible engine, and as a last resort it will unhide the app
    ///    * default engine.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsISearchEngine defaultEngine;`
    #[inline]
    pub unsafe fn GetDefaultEngine(&self, aDefaultEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult {
        ((*self.vtable).GetDefaultEngine)(self, aDefaultEngine)
    }



    /// `Promise getDefault ();`
    const _GetDefault: () = ();


    /// `Promise setDefault (in nsISearchEngine engine, in unsigned short changeReason);`
    const _SetDefault: () = ();

    /// ```text
    /// /**
    ///    * The currently active search engine for private browsing mode.
    ///    * @see defaultEngine.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsISearchEngine defaultPrivateEngine;`
    #[inline]
    pub unsafe fn GetDefaultPrivateEngine(&self, aDefaultPrivateEngine: *mut *const nsISearchEngine) -> ::nserror::nsresult {
        ((*self.vtable).GetDefaultPrivateEngine)(self, aDefaultPrivateEngine)
    }



    /// `Promise getDefaultPrivate ();`
    const _GetDefaultPrivate: () = ();


    /// `Promise setDefaultPrivate (in nsISearchEngine engine, in unsigned short changeReason);`
    const _SetDefaultPrivate: () = ();

    /// ```text
    /// /**
    ///    * Whether to display the "Search in Private Window" result in the urlbar.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean separatePrivateDefaultUrlbarResultEnabled;`
    #[inline]
    pub unsafe fn GetSeparatePrivateDefaultUrlbarResultEnabled(&self, aSeparatePrivateDefaultUrlbarResultEnabled: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetSeparatePrivateDefaultUrlbarResultEnabled)(self, aSeparatePrivateDefaultUrlbarResultEnabled)
    }


    /// ```text
    /// /**
    ///    * Allows the add-on manager to discover if a WebExtension based search engine
    ///    * may change the default to a config search engine.
    ///    * If that WebExtension is on the allow list, then it will override the
    ///    * built-in engine's urls and parameters.
    ///    *
    ///    *  @param extension
    ///    *   The extension to load from.
    ///    *  @returns An object with two booleans:
    ///    *   canChangeToConfigEngine: indicates if the WebExtension engine may set the
    ///    *     already installed config search engine as default.
    ///    *   canInstallEngine: indicates if the WebExtension engine may be installed.
    ///    */
    /// ```
    ///

    /// `Promise maybeSetAndOverrideDefault (in jsval extension);`
    const _MaybeSetAndOverrideDefault: () = ();

    /// ```text
    /// /**
    ///    * Gets a representation of the default engine in an anonymized JSON
    ///    * string suitable for recording in the Telemetry environment.
    ///    *
    ///    * @return {object} result
    ///    *   contains anonymized info about the default engine(s).
    ///    * @return {string} result.defaultSearchEngine
    ///    *   contains the telemetry id of the default engine.
    ///    * @return {object} result.defaultSearchEngineData
    ///    *   contains information about the default engine:
    ///    *     name, loadPath, original submissionURL
    ///    * @return {string} [result.defaultPrivateSearchEngine]
    ///    *   only returned if the preference for having a separate engine in private
    ///    *   mode is turned on.
    ///    *   contains the telemetry id of the default engine for private browsing mode.
    ///    * @return {object} [result.defaultPrivateSearchEngineData]
    ///    *   only returned if the preference for having a separate engine in private
    ///    *   mode is turned on.
    ///    *   contains information about the default engine for private browsing mode:
    ///    *     name, loadPath, original submissionURL
    ///    */
    /// ```
    ///

    /// `jsval getDefaultEngineInfo ();`
    const _GetDefaultEngineInfo: () = ();

    /// ```text
    /// /**
    ///    * Determines if the provided URL represents results from a search engine, and
    ///    * provides details about the match.
    ///    *
    ///    * The lookup mechanism checks whether the domain name and path of the
    ///    * provided HTTP or HTTPS URL matches one of the known values for the visible
    ///    * search engines.  The match does not depend on which of the schemes is used.
    ///    * The expected URI parameter for the search terms must exist in the query
    ///    * string, but other parameters are ignored.
    ///    *
    ///    * @param url
    ///    *        String containing the URL to parse, for example
    ///    *        "https://www.google.com/search?q=terms".
    ///    */
    /// ```
    ///

    /// `nsISearchParseSubmissionResult parseSubmissionURL (in AString url);`
    #[inline]
    pub unsafe fn ParseSubmissionURL(&self, url: *const ::nsstring::nsAString, _retval: *mut *const nsISearchParseSubmissionResult) -> ::nserror::nsresult {
        ((*self.vtable).ParseSubmissionURL)(self, url, _retval)
    }


}


