//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/base/nsIStreamTransportService.idl
//


/// `interface nsIStreamTransportService : nsISupports`
///

/// ```text
/// /**
///  * This service read/writes a stream on a background thread.
///  *
///  * Note: instead of using this interface, probably you want to use
///  * NS_MakeAsyncNonBlockingInputStream.
///  *
///  * Use this service to transform any blocking stream (e.g., file stream)
///  * into a fully asynchronous stream that can be read/written without
///  * blocking the main thread.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIStreamTransportService {
    vtable: &'static nsIStreamTransportServiceVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIStreamTransportService.
unsafe impl XpCom for nsIStreamTransportService {
    const IID: nsIID = nsID(0x5e0adf7d, 0x9785, 0x45c3,
        [0xa1, 0x93, 0x04, 0xf2, 0x5a, 0x75, 0xda, 0x8f]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIStreamTransportService {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIStreamTransportService.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIStreamTransportServiceCoerce {
    /// Cheaply cast a value of this type from a `nsIStreamTransportService`.
    fn coerce_from(v: &nsIStreamTransportService) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIStreamTransportServiceCoerce for nsIStreamTransportService {
    #[inline]
    fn coerce_from(v: &nsIStreamTransportService) -> &Self {
        v
    }
}

impl nsIStreamTransportService {
    /// Cast this `nsIStreamTransportService` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIStreamTransportServiceCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIStreamTransportService {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIStreamTransportServiceCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIStreamTransportService) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIStreamTransportService
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIStreamTransportServiceVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* nsITransport createInputTransport (in nsIInputStream aStream, in boolean aCloseWhenDone); */
    pub CreateInputTransport: unsafe extern "system" fn (this: *const nsIStreamTransportService, aStream: *const nsIInputStream, aCloseWhenDone: bool, _retval: *mut*const nsITransport) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIStreamTransportService {

    /// ```text
    /// /**
    ///      * CreateInputTransport
    ///      *
    ///      * @param aStream
    ///      *        The input stream that will be read on a background thread.
    ///      *        This stream must implement "blocking" stream semantics.
    ///      * @param aCloseWhenDone
    ///      *        Specify this flag to have the input stream closed once its
    ///      *        contents have been completely read.
    ///      *
    ///      * @return nsITransport instance.
    ///      */
    /// ```
    ///

    /// `nsITransport createInputTransport (in nsIInputStream aStream, in boolean aCloseWhenDone);`
    #[inline]
    pub unsafe fn CreateInputTransport(&self, aStream: *const nsIInputStream, aCloseWhenDone: bool, _retval: *mut*const nsITransport) -> ::nserror::nsresult {
        ((*self.vtable).CreateInputTransport)(self, aStream, aCloseWhenDone, _retval)
    }


}


