//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/dom/interfaces/base/nsITextInputProcessor.idl
//


/// `interface nsITextInputProcessor : nsISupports`
///

/// ```text
/// /**
///  * An nsITextInputProcessor instance is associated with a top level widget which
///  * handles native IME.  It's associated by calling beginInputTransaction() or
///  * beginInputTransactionForTests().  While an instance has composition, nobody
///  * can steal the rights to make composition on the top level widget.  In other
///  * words, if another instance is composing on a top level widget, either
///  * beginInputTransaction() or beginInputTransactionForTests() returns false
///  * (i.e., not throws an exception).
///  *
///  * NOTE: See nsITextInputProcessorCallback.idl for examples of |callback| in
///  *       following examples,
///  *
///  * Example #1 JS-IME can start composition like this:
///  *
///  *   var TIP = Components.classes["@mozilla.org/text-input-processor;1"].
///  *               createInstance(Components.interfaces.nsITextInputProcessor);
///  *   if (!TIP.beginInputTransaction(window, callback)) {
    ///  *     return; // You failed to get the rights to make composition
    ///  *   }
///  *   // Create a keyboard event if the following compositionc change is caused
///  *   // by a key event.
///  *   var keyEvent =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   // Set new composition string first
///  *   TIP.setPendingCompositionString("some-words-are-inputted");
///  *   // Set clause information.
///  *   TIP.appendClauseToPendingComposition(23, TIP.ATTR_RAW_CLAUSE);
///  *   // Set caret position, this is optional.
///  *   TIP.setCaretInPendingComposition(23);
///  *   // Flush the pending composition
///  *   if (!TIP.flushPendingComposition(keyEvent)) {
    ///  *     // If it returns false, it fails to start composition.
    ///  *     return;
    ///  *   }
///  *
///  * Example #2 JS-IME can separate composition string to two or more clauses:
///  *
///  *   // Create a keyboard event if the following compositionc change is caused
///  *   // by a key event.
///  *   var keyEvent =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   // First, set composition string again
///  *   TIP.setPendingCompositionString("some-words-are-inputted");
///  *   // Then, if "are" is selected to convert, there are 3 clauses:
///  *   TIP.appendClauseToPendingComposition(11, TIP.ATTR_CONVERTED_CLAUSE);
///  *   TIP.appendClauseToPendingComposition(3,  TIP.ATTR_SELECTED_CLAUSE);
///  *   TIP.appendClauseToPendingComposition(9,  TIP.ATTR_CONVERTED_CLAUSE);
///  *   // Show caret at the beginning of the selected clause
///  *   TIP.setCaretInPendingComposition(11);
///  *   // Flush the pending composition.  Note that if there is a composition,
///  *   // flushPendingComposition() won't return false.
///  *   TIP.flushPendingComposition(keyEvent);
///  *
///  * Example #3 JS-IME can commit composition with specific string with this:
///  *
///  *   // Create a keyboard event if the following compositionc change is caused
///  *   // by a key event.
///  *   var keyEvent1 =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   // First, there is a composition.
///  *   TIP.setPendingCompositionString("some-words-directly-inputted");
///  *   TIP.appendClauseToPendingComposition(28, TIP.ATTR_RAW_CLAUSE);
///  *   TIP.flushPendingComposition(keyEvent1);
///  *   // Create a keyboard event if the following commit composition is caused
///  *   // by a key event.
///  *   var keyEvent2 =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   // This is useful when user selects a commit string from candidate list UI
///  *   // which is provided by JS-IME.
///  *   TIP.commitCompositionWith("selected-words-from-candidate-list", keyEvent2);
///  *
///  * Example #4 JS-IME can commit composition with the last composition string
///  *            without specifying commit string:
///  *
///  *   // Create a keyboard event if the following compositionc change is caused
///  *   // by a key event.
///  *   var keyEvent1 =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   // First, there is a composition.
///  *   TIP.setPendingCompositionString("some-words-will-be-commited");
///  *   TIP.appendClauseToPendingComposition(27, TIP.ATTR_RAW_CLAUSE);
///  *   TIP.flushPendingComposition(keyEvent1);
///  *   // Create a keyboard event if the following commit is caused by a key
///  *   // event.
///  *   var keyEvent2 =
///  *     new KeyboardEvent("", { key: "Enter", code: "Enter",
        ///                                keyCode: KeyboardEvent.DOM_VK_RETURN });
///  *   // This is useful when user just type Enter key.
///  *   TIP.commitComposition(keyEvent2);
///  *
///  * Example #5 JS-IME can cancel composition with this:
///  *
///  *   // Create a keyboard event if the following composition change is caused
///  *   // by a key event.
///  *   var keyEvent1 =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   // First, there is a composition.
///  *   TIP.setPendingCompositionString("some-words-will-be-canceled");
///  *   TIP.appendClauseToPendingComposition(27, TIP.ATTR_RAW_CLAUSE);
///  *   TIP.flushPendingComposition(keyEvent1);
///  *   // Create a keyboard event if the following canceling composition is
///  *   // caused by a key event.
///  *   var keyEvent2 =
///  *     new KeyboardEvent("", { key: "Escape", code: "Escape",
        ///                                keyCode: KeyboardEvent.DOM_VK_ESCAPE });
///  *   // This is useful when user doesn't want to commit the composition.
///  *   // FYI: This is same as TIP.commitCompositionWith("") for now.
///  *   TIP.cancelComposition(keyEvent2);
///  *
///  * Example #6 JS-IME can insert text only with commitCompositionWith():
///  *
///  *   // Create a keyboard event if the following inserting text is caused by a
///  *   // key event.
///  *   var keyEvent1 =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   if (!TIP.beginInputTransaction(window, callback)) {
    ///  *     return; // You failed to get the rights to make composition
    ///  *   }
///  *   TIP.commitCompositionWith("Some words", keyEvent1);
///  *
///  * Example #7 JS-IME can start composition explicitly:
///  *
///  *   if (!TIP.beginInputTransaction(window, callback)) {
    ///  *     return; // You failed to get the rights to make composition
    ///  *   }
///  *   // Create a keyboard event if the following starting composition is caused
///  *   // by a key event.
///  *   var keyEvent1 =
///  *     new KeyboardEvent("", { key: "foo", code: "bar", keyCode: buzz });
///  *   // If JS-IME don't want to show composing string in the focused editor,
///  *   // JS-IME can dispatch only compositionstart event with this.
///  *   if (!TIP.startComposition(keyEvent1)) {
    ///  *     // Failed to start composition.
    ///  *     return;
    ///  *   }
///  *   // And when user selects a result from UI of JS-IME, commit with it.
///  *   // Then, the key event should be null.
///  *   TIP.commitCompositionWith("selected-words");
///  *
///  * Example #8 JS-IME or JS-Keyboard should dispatch key events even during
///  *            composition (non-printable key case):
///  *
///  *   if (!TIP.beginInputTransaction(window, callback)) {
    ///  *     return; // You failed to get the rights to dispatch key events
    ///  *   }
///  *
///  *   // You don't need to specify .keyCode value if it's non-printable key
///  *   // because it can be computed from .key value.
///  *   // If you specify non-zero value to .keyCode, it'll be used.
///  *   var keyEvent = new KeyboardEvent("", { code: "Enter", key: "Enter" });
///  *   if (TIP.keydown(keyEvent)) {
    ///  *     // Handle its default action
    ///  *   }
///  *
///  *   // Even if keydown event was consumed, keyup event should be dispatched.
///  *   if (TIP.keyup(keyEvent)) {
    ///  *     // Handle its default action
    ///  *   }
///  *
///  * Example #9 JS-IME or JS-Keyboard should dispatch key events even during
///  *            composition (printable key case):
///  *
///  *   if (!TIP.beginInputTransaction(window, callback)) {
    ///  *     return; // You failed to get the rights to dispatch key events
    ///  *   }
///  *
///  *   // You need to specify .keyCode value if it's printable key.
///  *   // The rules of .keyCode value is documented in MDN:
///  *   //   https://developer.mozilla.org/docs/Web/API/KeyboardEvent.keyCode
///  *   //
///  *   //   #1 If the key location is DOM_KEY_LOCATION_NUMPAD and NumLock is
///  *   //      active, you should specify DOM_VK_NUMPAD[0-9], DOM_VK_MULTIPLY,
///  *   //      DOM_VK_ADD, DOM_VK_SEPARATOR, DOM_VK_SUBTRACT, DOM_VK_DECIMAL or
///  *   //      DOM_VK_DIVIDE.
///  *   //   #2 If the key is Spacebar, use DOM_VK_SPACE.
///  *   //
///  *   //   Following rules are printable keys in DOM_KEY_LOCATION_STANDARD.
///  *   //   .keyCode value for a key shouldn't be changed by modifier states:
///  *   //     #1 If the key can input [0-9] with any modifier state (except
    ///  *   //        NumLock state), the value should be DOM_VK_[0-9].
///  *   //     #2 Otherwise, and if the key inputs an ASCII alphabet with no
///  *   //        active modifiers, use DOM_VK_[A-Z].
///  *   //     #3 Otherwise, and if the key inputs an ASCII alphabet with no
///  *   //        active modifiers except Shift key state, use DOM_VK_[A-Z] for
///  *   //        the shifted character.  E.g., if a key causes non-alphabet
///  *   //        character such as "@" or a Unicode character without Shift key
///  *   //        but "a" is inputted when Shift key is pressed, the proper
///  *   //        keyCode is DOM_VK_A.
///  *   //     #4 Otherwise, and if the key inputs another ASCII character with
///  *   //        no modifier states, use a proper value for the character.  E.g.,
///  *   //        if the key inputs "*" without Shift key state, it should be
///  *   //        DOM_VK_ASTERISK.
///  *   //     #5 Otherwise, and if the key inputs another ASCII character with
///  *   //        Shift key state, use a proper value for the character.  E.g.,
///  *   //        if a key causes a Unicode character without Shift key but "&"
///  *   //        is inputted when Shift key is pressed, the proper keyCode is
///  *   //        DOM_VK_AMPERSAND.
///  *   //     See above document for the other cases.
///  *   //
///  *   // NOTE: If the software keyboard is 10-key like simple phone,
///  *   //       We don't have common rules to decide its .keyCode value.
///  *   //       Above rules should be used when the JS-Keyboard emulates PC
///  *   //       keyboard.
///  *   // .key value should be inputting character by the key with current
///  *   // modifier state.
///  *   // .code value should be empty string if the JS-Keyboard isn't emulating
///  *   // physical keyboard.  Otherwise, use same value with physical keyboard's
///  *   // same key.
///  *   var keyEvent = new KeyboardEvent("", { code: "KeyA", key: "a",
        ///  *                                          keyCode: KeyboardEvent.DOM_VK_A });
///  *   if (TIP.keydown(keyEvent)) {
    ///  *     // Handle its default action
    ///  *   }
///  *
///  *   // Even if keydown event was consumed, keyup event should be dispatched.
///  *   if (TIP.keyup(keyEvent)) {
    ///  *     // Handle its default action
    ///  *   }
///  *
///  * Example #10 JS-Keyboard doesn't need to initialize modifier states at
///  *             calling either keydown() or keyup().
///  *
///  *   // Neither beginInputTransaction() nor beginInputTransactionForTests()
///  *   // resets modifier state.
///  *   if (!TIP.beginInputTransaction(window, callback)) {
    ///  *     return; // You failed to get the rights to dispatch key events
    ///  *   }
///  *
///  *   var leftShift = new KeyboardEvent("", { code: "ShiftLeft", key: "Shift" });
///  *
///  *   // This causes following key events will be shifted automatically.
///  *   TIP.keydown(leftShift);
///  *
///  *   var rightShift =
///  *     new KeyboardEvent("", { code: "ShiftRight", key: "Shift" });
///  *
///  *   TIP.keydown(rightShift);
///  *
///  *   // keyup of one of shift key doesn't cause inactivating "Shift" state.
///  *   TIP.keyup(rightShift);
///  *
///  *   // This causes inactivating "Shift" state completely.
///  *   TIP.keyup(leftShift);
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsITextInputProcessor {
    vtable: &'static nsITextInputProcessorVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsITextInputProcessor.
unsafe impl XpCom for nsITextInputProcessor {
    const IID: nsIID = nsID(0x47ae2181, 0x2e98, 0x4d58,
        [0x84, 0xa2, 0xb8, 0xdb, 0x67, 0x64, 0xce, 0x9a]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsITextInputProcessor {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsITextInputProcessor.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsITextInputProcessorCoerce {
    /// Cheaply cast a value of this type from a `nsITextInputProcessor`.
    fn coerce_from(v: &nsITextInputProcessor) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsITextInputProcessorCoerce for nsITextInputProcessor {
    #[inline]
    fn coerce_from(v: &nsITextInputProcessor) -> &Self {
        v
    }
}

impl nsITextInputProcessor {
    /// Cast this `nsITextInputProcessor` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsITextInputProcessorCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsITextInputProcessor {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsITextInputProcessorCoerce for T {
    #[inline]
    fn coerce_from(v: &nsITextInputProcessor) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsITextInputProcessor
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsITextInputProcessorVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute boolean hasComposition; */
    pub GetHasComposition: unsafe extern "system" fn (this: *const nsITextInputProcessor, aHasComposition: *mut bool) -> ::nserror::nsresult,

    /* boolean beginInputTransaction (in mozIDOMWindow aWindow, in nsITextInputProcessorCallback aCallback); */
    pub BeginInputTransaction: unsafe extern "system" fn (this: *const nsITextInputProcessor, aWindow: *const mozIDOMWindow, aCallback: *const nsITextInputProcessorCallback, _retval: *mut bool) -> ::nserror::nsresult,

    /* [optional_argc] boolean beginInputTransactionForTests (in mozIDOMWindow aWindow, [optional] in nsITextInputProcessorCallback aCallback); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub BeginInputTransactionForTests: *const ::libc::c_void,

    /* [can_run_script,optional_argc] boolean startComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub StartComposition: *const ::libc::c_void,

    /* void setPendingCompositionString (in AString aString); */
    pub SetPendingCompositionString: unsafe extern "system" fn (this: *const nsITextInputProcessor, aString: *const ::nsstring::nsAString) -> ::nserror::nsresult,

    /* void appendClauseToPendingComposition (in unsigned long aLength, in unsigned long aAttribute); */
    pub AppendClauseToPendingComposition: unsafe extern "system" fn (this: *const nsITextInputProcessor, aLength: u32, aAttribute: u32) -> ::nserror::nsresult,

    /* void setCaretInPendingComposition (in unsigned long aOffset); */
    pub SetCaretInPendingComposition: unsafe extern "system" fn (this: *const nsITextInputProcessor, aOffset: u32) -> ::nserror::nsresult,

    /* [can_run_script,optional_argc] boolean flushPendingComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub FlushPendingComposition: *const ::libc::c_void,

    /* [can_run_script,optional_argc] void commitComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub CommitComposition: *const ::libc::c_void,

    /* [can_run_script,optional_argc] boolean commitCompositionWith (in AString aCommitString, [optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub CommitCompositionWith: *const ::libc::c_void,

    /* [can_run_script,optional_argc] void cancelComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub CancelComposition: *const ::libc::c_void,

    /* [can_run_script,optional_argc] unsigned long keydown (in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub Keydown: *const ::libc::c_void,

    /* [optional_argc] boolean keyup (in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub Keyup: *const ::libc::c_void,

    /* [can_run_script,optional_argc] boolean insertTextWithKeyPress (in AString aString, [optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags); */
    /// Unable to generate binding because `optional_argc is unsupported`
    pub InsertTextWithKeyPress: *const ::libc::c_void,

    /* boolean getModifierState (in AString aModifierKey); */
    pub GetModifierState: unsafe extern "system" fn (this: *const nsITextInputProcessor, aModifierKey: *const ::nsstring::nsAString, _retval: *mut bool) -> ::nserror::nsresult,

    /* void shareModifierStateOf (in nsITextInputProcessor aOther); */
    pub ShareModifierStateOf: unsafe extern "system" fn (this: *const nsITextInputProcessor, aOther: *const nsITextInputProcessor) -> ::nserror::nsresult,

    /* [optional_argc] AString computeCodeValueOfNonPrintableKey (in AString aKeyValue, [optional] in jsval aLocation); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub ComputeCodeValueOfNonPrintableKey: *const ::libc::c_void,

    /* [optional_argc] AString guessCodeValueOfPrintableKeyInUSEnglishKeyboardLayout (in AString aKeyValue, [optional] in jsval aLocation); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub GuessCodeValueOfPrintableKeyInUSEnglishKeyboardLayout: *const ::libc::c_void,

    /* [optional_argc] unsigned long guessKeyCodeValueOfPrintableKeyInUSEnglishKeyboardLayout (in AString aKeyValue, [optional] in jsval aLocation); */
    /// Unable to generate binding because `special type jsval unsupported`
    pub GuessKeyCodeValueOfPrintableKeyInUSEnglishKeyboardLayout: *const ::libc::c_void,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsITextInputProcessor {

    pub const ATTR_RAW_CLAUSE: u32 = 2;


    pub const ATTR_SELECTED_RAW_CLAUSE: u32 = 3;


    pub const ATTR_CONVERTED_CLAUSE: u32 = 4;


    pub const ATTR_SELECTED_CLAUSE: u32 = 5;


    pub const KEY_DEFAULT_PREVENTED: u32 = 1;


    pub const KEY_NON_PRINTABLE_KEY: u32 = 2;


    pub const KEY_FORCE_PRINTABLE_KEY: u32 = 4;


    pub const KEY_KEEP_KEY_LOCATION_STANDARD: u32 = 8;


    pub const KEY_KEEP_KEYCODE_ZERO: u32 = 16;


    pub const KEY_DONT_DISPATCH_MODIFIER_KEY_EVENT: u32 = 32;


    pub const KEY_DONT_MARK_KEYDOWN_AS_PROCESSED: u32 = 64;


    pub const KEY_MARK_KEYUP_AS_PROCESSED: u32 = 128;


    pub const KEYEVENT_NOT_CONSUMED: u32 = 0;


    pub const KEYDOWN_IS_CONSUMED: u32 = 1;


    pub const KEYPRESS_IS_CONSUMED: u32 = 2;

    /// ```text
    /// /**
    ///    * Returns true if this instance was dispatched compositionstart but hasn't
    ///    * dispatched compositionend yet.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean hasComposition;`
    #[inline]
    pub unsafe fn GetHasComposition(&self, aHasComposition: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetHasComposition)(self, aHasComposition)
    }


    /// ```text
    /// /**
    ///    * When you create an instance, you must call beginInputTransaction() first
    ///    * except when you created the instance for automated tests.
    ///    *
    ///    * @param aWindow         A DOM window.  The instance will look for a top
    ///    *                        level widget from this.
    ///    * @param aCallback       Callback interface which handles requests to
    ///    *                        IME and notifications to IME.  This must not be
    ///    *                        null.
    ///    * @return                If somebody uses internal text input service for a
    ///    *                        composition, this returns false.  Otherwise, returns
    ///    *                        true.  I.e., only your TIP can create composition
    ///    *                        when this returns true.  If this returns false,
    ///    *                        your TIP should wait next chance.
    ///    */
    /// ```
    ///

    /// `boolean beginInputTransaction (in mozIDOMWindow aWindow, in nsITextInputProcessorCallback aCallback);`
    #[inline]
    pub unsafe fn BeginInputTransaction(&self, aWindow: *const mozIDOMWindow, aCallback: *const nsITextInputProcessorCallback, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).BeginInputTransaction)(self, aWindow, aCallback, _retval)
    }


    /// ```text
    /// /**
    ///    * When you create an instance for automated test, you must call
    ///    * beginInputTransaction(), first.  See beginInputTransaction() for more
    ///    * detail of this.
    ///    * Note that aCallback can be null.  If it's null, nsITextInputProcessor
    ///    * implementation will handle them automatically.
    ///    */
    /// ```
    ///

    /// `[optional_argc] boolean beginInputTransactionForTests (in mozIDOMWindow aWindow, [optional] in nsITextInputProcessorCallback aCallback);`
    const _BeginInputTransactionForTests: () = ();

    /// ```text
    /// /**
    ///    * startComposition() dispatches compositionstart event explicitly.
    ///    * IME does NOT need to call this typically since compositionstart event
    ///    * is automatically dispatched by sendPendingComposition() if
    ///    * compositionstart event hasn't been dispatched yet.  If this is called
    ///    * when compositionstart has already been dispatched, this throws an
    ///    * exception.
    ///    *
    ///    * @param aKeyboardEvent  Key event which causes starting composition.
    ///    *                        If its type value is "keydown", this method
    ///    *                        dispatches only keydown event first.  Otherwise,
    ///    *                        dispatches keydown first and keyup at last.
    ///    *                        key value and keyCode values of keydown event
    ///    *                        are set to "Process" and DOM_VK_PROCESSKEY
    ///    *                        automatically.  You can prevent this behavior
    ///    *                        with KEY_DONT_MARK_KEYDOWN_AS_PROCESSED.
    ///    * @param aKeyFlags       See KEY_* constants.
    ///    * @return                Returns true if composition starts normally.
    ///    *                        Otherwise, returns false because it might be
    ///    *                        canceled by the web application.
    ///    */
    /// ```
    ///

    /// `[can_run_script,optional_argc] boolean startComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _StartComposition: () = ();

    /// ```text
    /// /**
    ///    * Set new composition string.  Pending composition will be flushed by
    ///    * a call of flushPendingComposition().  However, if the new composition
    ///    * string isn't empty, you need to call appendClauseToPendingComposition() to
    ///    * fill all characters of aString with one or more clauses before flushing.
    ///    * Note that if you need to commit or cancel composition, use
    ///    * commitComposition(), commitCompositionWith() or cancelComposition().
    ///    */
    /// ```
    ///

    /// `void setPendingCompositionString (in AString aString);`
    #[inline]
    pub unsafe fn SetPendingCompositionString(&self, aString: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).SetPendingCompositionString)(self, aString)
    }


    /// ```text
    /// /**
    ///    * Append a clause to the pending composition.
    ///    *
    ///    * If you need to fill the pending composition string with a clause, you
    ///    * should call this once.  For example:
    ///    *   appendClauseToPendingComposition(compositionString.length,
        ///    *                                    ATTR_RAW_CLAUSE);
    ///    * is enough.  If you need to separate the pending composition string to
    ///    * multiple clauses, you need to call this multiple times. For example,
    ///    * if your pending composition string has three clauses and the second clause
    ///    * is being converted:
    ///    *  appendClauseToPendingComposition(firstClauseLength,
        ///    *                                   ATTR_CONVERTED_CLAUSE);
    ///    *  appendClauseToPendingComposition(secondClauseLength,
        ///    *                                   ATTR_SELECTED_CLAUSE);
    ///    *  appendClauseToPendingComposition(thirdClauseLength,
        ///    *                                   ATTR_CONVERTED_CLAUSE);
    ///    * Note that if sum of aLength mismatches length of the pending composition
    ///    * string, flushPendingComposition() will throw an exception.  I.e.,
    ///    * |firstClauseLength + secondClauseLength + thirdClauseLength| must be
    ///    * same as the length of pending composition string.
    ///    *
    ///    * TODO: Should be able to specify custom clause style.
    ///    *
    ///    * @param aLength         Length of the clause.
    ///    * @param aAttribute      One of ATTR_* constants.
    ///    */
    /// ```
    ///

    /// `void appendClauseToPendingComposition (in unsigned long aLength, in unsigned long aAttribute);`
    #[inline]
    pub unsafe fn AppendClauseToPendingComposition(&self, aLength: u32, aAttribute: u32) -> ::nserror::nsresult {
        ((*self.vtable).AppendClauseToPendingComposition)(self, aLength, aAttribute)
    }


    /// ```text
    /// /**
    ///    * Set caret offset in the pending composition string.  If you don't need to
    ///    * show a caret, you don't need to call this.
    ///    *
    ///    * @param aOffset         Caret offset in the pending composition string.
    ///    *                        This must be between 0 and length of the pending
    ///    *                        composition string.
    ///    */
    /// ```
    ///

    /// `void setCaretInPendingComposition (in unsigned long aOffset);`
    #[inline]
    pub unsafe fn SetCaretInPendingComposition(&self, aOffset: u32) -> ::nserror::nsresult {
        ((*self.vtable).SetCaretInPendingComposition)(self, aOffset)
    }


    /// ```text
    /// /**
    ///    * flushPendingComposition() must be called after
    ///    * setPendingCompositionString() and appendClauseToPendingComposition()
    ///    * (setCaretInPendingComposition() is optional) are called.
    ///    *
    ///    * Note that compositionstart will be automatically dispatched if this is
    ///    * called when there is no composition.
    ///    *
    ///    * Note that if sum of lengths of appended clauses are not same as composition
    ///    * string or caret offset is larger than the composition string length, this
    ///    * throws an exception.
    ///    *
    ///    * @param aKeyboardEvent  Key event which causes the composition string.
    ///    *                        If its type value is "keydown", this method
    ///    *                        dispatches only keydown event first.  Otherwise,
    ///    *                        dispatches keydown first and keyup at last.
    ///    *                        key value and keyCode values of keydown event
    ///    *                        are set to "Process" and DOM_VK_PROCESSKEY
    ///    *                        automatically.  You can prevent this behavior
    ///    *                        with KEY_DONT_MARK_KEYDOWN_AS_PROCESSED.
    ///    * @param aKeyFlags       See KEY_* constants.
    ///    * @return                Returns true if there is a composition already or
    ///    *                        starting composition automatically.
    ///    *                        Otherwise, i.e., if it cannot start composition
    ///    *                        automatically, e.g., canceled by web apps, returns
    ///    *                        false.
    ///    */
    /// ```
    ///

    /// `[can_run_script,optional_argc] boolean flushPendingComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _FlushPendingComposition: () = ();

    /// ```text
    /// /**
    ///    * commitComposition() will commit composition with the last composition
    ///    * string.  If there is no composition, this will throw an exception.
    ///    *
    ///    * @param aKeyboardEvent  Key event which causes the commit composition.
    ///    *                        If its type value is "keydown", this method
    ///    *                        dispatches only keydown event first.  Otherwise,
    ///    *                        dispatches keydown first and keyup at last.
    ///    *                        key value and keyCode values of keydown event
    ///    *                        are set to "Process" and DOM_VK_PROCESSKEY
    ///    *                        automatically.  You can prevent this behavior
    ///    *                        with KEY_DONT_MARK_KEYDOWN_AS_PROCESSED.
    ///    * @param aKeyFlags       See KEY_* constants.
    ///    */
    /// ```
    ///

    /// `[can_run_script,optional_argc] void commitComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _CommitComposition: () = ();

    /// ```text
    /// /**
    ///    * commitCompositionWith() will commit composition with the specific string.
    ///    * If there is no composition, this will start composition and commit it
    ///    * with the specified string.
    ///    *
    ///    * @param aCommitString   The string to be committed.
    ///    * @param aKeyboardEvent  Key event which causes the commit composition.
    ///    *                        If its type value is "keydown", this method
    ///    *                        dispatches only keydown event first.  Otherwise,
    ///    *                        dispatches keydown first and keyup at last.
    ///    *                        key value and keyCode values of keydown event
    ///    *                        are set to "Process" and DOM_VK_PROCESSKEY
    ///    *                        automatically.  You can prevent this behavior
    ///    *                        with KEY_DONT_MARK_KEYDOWN_AS_PROCESSED.
    ///    * @param aKeyFlags       See KEY_* constants.
    ///    * @return                Returns true if there is a composition already or
    ///    *                        starting composition automatically.
    ///    *                        Otherwise, i.e., if it cannot start composition
    ///    *                        automatically, e.g., canceled by web apps, returns
    ///    *                        false.
    ///    */
    /// ```
    ///

    /// `[can_run_script,optional_argc] boolean commitCompositionWith (in AString aCommitString, [optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _CommitCompositionWith: () = ();

    /// ```text
    /// /**
    ///    * cancelComposition() will cancel composition.  This is for now the same as
    ///    * calling commitComposition("").  However, in the future, this might work
    ///    * better.  If your IME needs to cancel composition, use this instead of
    ///    * commitComposition().
    ///    *
    ///    * Note that if you tries to cancel composition when there is no composition,
    ///    * this throws an exception.
    ///    *
    ///    * @param aKeyboardEvent  Key event which causes the canceling composition.
    ///    *                        If its type value is "keydown", this method
    ///    *                        dispatches only keydown event first.  Otherwise,
    ///    *                        dispatches keydown first and keyup at last.
    ///    *                        key value and keyCode values of keydown event
    ///    *                        are set to "Process" and DOM_VK_PROCESSKEY
    ///    *                        automatically.  You can prevent this behavior
    ///    *                        with KEY_DONT_MARK_KEYDOWN_AS_PROCESSED.
    ///    * @param aKeyFlags       See KEY_* constants.
    ///    */
    /// ```
    ///

    /// `[can_run_script,optional_argc] void cancelComposition ([optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _CancelComposition: () = ();

    /// ```text
    /// /**
    ///    * keydown() may dispatch a keydown event and some keypress events if
    ///    * preceding keydown event isn't consumed and they are necessary.
    ///    * Note that even if this is called during composition, key events may not
    ///    * be dispatched.  In this case, this returns false.
    ///    *
    ///    * You should initialize at least .key value and .code value of the event.
    ///    * Additionally, if you try to emulate a printable key, .keyCode value should
    ///    * be specified if there is proper key value.  See the comment of above
    ///    * example how to decide .keyCode value of a printable key.  On the other
    ///    * hand, .keyCode value is automatically computed when you try to emulate
    ///    * non-printable key.  However, if you try to emulate physical keyboard of
    ///    * desktop platform, you need to specify proper value explicitly because
    ///    * the mapping table of this API isn't enough to emulate the behavior of
    ///    * Gecko for desktop platforms.
    ///    *
    ///    * NOTE: Even if this has composition, JS-Keyboard should call keydown() and
    ///    *       keyup().  Although, with the default preferences and normal
    ///    *       conditions, DOM key events won't be fired during composition.
    ///    *       However, they MAY be dispatched for some reasons, e.g., the web
    ///    *       content listens only key events, or if the standard DOM event spec
    ///    *       will be changed in the future.
    ///    *
    ///    * @param aKeyboardEvent  Must be a keyboard event which should be dispatched
    ///    *                        as a keydown event and keypress events.
    ///    *                        #1 Note that you don't need to set charCode value
    ///    *                        because it's computed from its key value.
    ///    *                        #2 If code value is set properly and location value
    ///    *                        isn't specified (i.e., 0), the location value will
    ///    *                        be guessed from the code value.
    ///    *                        #3 Non-defined code names are not allowed. If your
    ///    *                        key isn't registered, file a bug. If your key isn't
    ///    *                        defined by any standards, use "" (empty string).
    ///    *                        #4 .keyCode is guessed from .key value if the key
    ///    *                        name is registered and .keyCode isn't initialized.
    ///    *                        #5 modifier key states, e.g., .shiftKey, are
    ///    *                        ignored.  Instead, modifier states are managed by
    ///    *                        each instance and set automatically.
    ///    * @param aKeyFlags       Special flags.  The values can be some of KEY_*
    ///    *                        constants.
    ///    * @return                KEYEVENT_NOT_CONSUMED, if the keydown event nor
    ///    *                        the following keypress event(s) are consumed.
    ///    *                        KEYDOWN_IS_CONSUMED, if the keydown event is
    ///    *                        consumed. No keypress event will be dispatched in
    ///    *                        this case.
    ///    *                        KEYPRESS_IS_CONSUMED, if the keypress event(s) is
    ///    *                        consumed when dispatched.
    ///    *                        Note that keypress event is always consumed by
    ///    *                        native code for the printable keys (indicating the
        ///    *                        default action has been taken).
    ///    */
    /// ```
    ///

    /// `[can_run_script,optional_argc] unsigned long keydown (in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _Keydown: () = ();

    /// ```text
    /// /**
    ///    * Similar to keydown(), but this dispatches only a keyup event.
    ///    */
    /// ```
    ///

    /// `[optional_argc] boolean keyup (in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _Keyup: () = ();

    /// ```text
    /// /**
    ///    * insertTextWithKeyPress() is designed for automated tests.  This dispatches
    ///    * isolated eKeyPress events to insert aString if selection is in an editable
    ///    * element.
    ///    *
    ///    * @aString           The string which will be inserted.
    ///    * @aKeyboardEvent    [optional]  This is nullable.   If specified as
    ///    *                    non-nullptr, the insertion is emulated as caused by the
    ///    *                    key event.
    ///    * @param aKeyFlags   Special flags.  The values can be some of KEY_*
    ///    *                    constants.
    ///    * @return            false if one of the dispatched eKeyPress event is
    ///    *                    consumed.
    ///    */
    /// ```
    ///

    /// `[can_run_script,optional_argc] boolean insertTextWithKeyPress (in AString aString, [optional] in Event aKeyboardEvent, [optional] in unsigned long aKeyFlags);`
    const _InsertTextWithKeyPress: () = ();

    /// ```text
    /// /**
    ///    * getModifierState() returns modifier state managed by this instance.
    ///    *
    ///    * @param aModifier       One of modifier key names.  This doesn't support
    ///    *                        virtual modifiers like "Accel".
    ///    * @return                true if the modifier key is active.  Otherwise,
    ///    *                        false.
    ///    */
    /// ```
    ///

    /// `boolean getModifierState (in AString aModifierKey);`
    #[inline]
    pub unsafe fn GetModifierState(&self, aModifierKey: *const ::nsstring::nsAString, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetModifierState)(self, aModifierKey, _retval)
    }


    /// ```text
    /// /**
    ///    * shareModifierStateOf() makes the instance shares modifier state of
    ///    * another instance.  When this is called, the instance refers the modifier
    ///    * state of another instance.  After that, changes to either this and the
    ///    * other instance's modifier state is synchronized.
    ///    *
    ///    * @param aOther          Another instance which will be referred by the
    ///    *                        instance.  If this is null, the instance restarts
    ///    *                        to manage modifier state independently.
    ///    */
    /// ```
    ///

    /// `void shareModifierStateOf (in nsITextInputProcessor aOther);`
    #[inline]
    pub unsafe fn ShareModifierStateOf(&self, aOther: *const nsITextInputProcessor) -> ::nserror::nsresult {
        ((*self.vtable).ShareModifierStateOf)(self, aOther)
    }


    /// ```text
    /// /**
    ///    * Helper method to get usual |.code| value of non-printable keys.
    ///    *
    ///    * @param aKeyValue       A predefined key value such as "Enter".
    ///    *                        If this is not a proper non-printable key value
    ///    *                        or a proper key value but not in usual keyboard of
    ///    *                        the platform, this returns empty string.
    ///    * @param aLocation       The |.location| value.  This is important if
    ///    *                        the key may be in different location.
    ///    *                        E.g., Left vs. Right or Standard vs. Numpad.
    ///    *                        If this is undefined or null, it'll be treated
    ///    *                        as Standard or Left.
    ///    * @return                One of a code value of well-known key on usual
    ///    *                        keyboard on the platform, or empty string.
    ///    */
    /// ```
    ///

    /// `[optional_argc] AString computeCodeValueOfNonPrintableKey (in AString aKeyValue, [optional] in jsval aLocation);`
    const _ComputeCodeValueOfNonPrintableKey: () = ();

    /// ```text
    /// /**
    ///    * Helper method to guess |.code| value of a printable key which is in usual
    ///    * keyboard of the platform and when active keyboard layout is US-English.
    ///    * Note that this is not aware of option key mapping on macOS.
    ///    *
    ///    * @param aKeyValue          The key value. Must be a character which can
    ///    *                           be inputted with US-English keyboard layout.
    ///    * @param aLocation          The location of the key.  This is important
    ///    *                           to distinguish whether the key is in Standard
    ///    *                           or Numpad. If this is undefined or null, will
    ///    *                           be treated as Standard.
    ///    * @return                   Returns empty string if there is no proper key.
    ///    */
    /// ```
    ///

    /// `[optional_argc] AString guessCodeValueOfPrintableKeyInUSEnglishKeyboardLayout (in AString aKeyValue, [optional] in jsval aLocation);`
    const _GuessCodeValueOfPrintableKeyInUSEnglishKeyboardLayout: () = ();

    /// ```text
    /// /**
    ///    * Helper method to guess |.keyCode| value of a printable key which is in
    ///    * usual keyboard of the platform and when active keyboard layout is
    ///    * US-English.
    ///    * Note that this is not aware of option key mapping on macOS.
    ///    *
    ///    * @param aKeyValue          The key value.  Must be a character which can
    ///    *                           be inputted with US-English keyboard layout.
    ///    * @param aLocation          The location of the key.  This is important
    ///    *                           to distinguish whether the key is in Standard
    ///    *                           our Numpad.  If this is undefined or null,
    ///    *                           will be treated as Standard.
    ///    * @return                   Returns 0 if there is no proper key to input
    ///    *                           aKeyValue with US-English keyboard layout.
    ///    */
    /// ```
    ///

    /// `[optional_argc] unsigned long guessKeyCodeValueOfPrintableKeyInUSEnglishKeyboardLayout (in AString aKeyValue, [optional] in jsval aLocation);`
    const _GuessKeyCodeValueOfPrintableKeyInUSEnglishKeyboardLayout: () = ();

}


