//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/url-classifier/nsIUrlClassifierExceptionList.idl
//


/// `interface nsIUrlClassifierExceptionList : nsISupports`
///

/// ```text
/// /**
///  * Interface for managing URL classifier exception lists.
///  *
///  * @see nsIUrlClassifierExceptionListEntry
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIUrlClassifierExceptionList {
    vtable: &'static nsIUrlClassifierExceptionListVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIUrlClassifierExceptionList.
unsafe impl XpCom for nsIUrlClassifierExceptionList {
    const IID: nsIID = nsID(0x807535bf, 0x018e, 0x4300,
        [0xb8, 0xd3, 0x4a, 0x64, 0x05, 0xfb, 0x9f, 0x65]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIUrlClassifierExceptionList {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIUrlClassifierExceptionList.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIUrlClassifierExceptionListCoerce {
    /// Cheaply cast a value of this type from a `nsIUrlClassifierExceptionList`.
    fn coerce_from(v: &nsIUrlClassifierExceptionList) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIUrlClassifierExceptionListCoerce for nsIUrlClassifierExceptionList {
    #[inline]
    fn coerce_from(v: &nsIUrlClassifierExceptionList) -> &Self {
        v
    }
}

impl nsIUrlClassifierExceptionList {
    /// Cast this `nsIUrlClassifierExceptionList` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIUrlClassifierExceptionListCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIUrlClassifierExceptionList {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIUrlClassifierExceptionListCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIUrlClassifierExceptionList) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIUrlClassifierExceptionList
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIUrlClassifierExceptionListVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void init (in ACString aFeature); */
    pub Init: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionList, aFeature: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void addEntry (in nsIUrlClassifierExceptionListEntry aEntry); */
    pub AddEntry: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionList, aEntry: *const nsIUrlClassifierExceptionListEntry) -> ::nserror::nsresult,

    /* boolean matches (in nsIURI aURI, in nsIURI aTopLevelURI, in boolean aIsPrivateBrowsing); */
    pub Matches: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionList, aURI: *const nsIURI, aTopLevelURI: *const nsIURI, aIsPrivateBrowsing: bool, _retval: *mut bool) -> ::nserror::nsresult,

    /* Array<nsIUrlClassifierExceptionListEntry> testGetEntries (); */
    pub TestGetEntries: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionList, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIUrlClassifierExceptionListEntry>>>) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIUrlClassifierExceptionList {

    /// ```text
    /// /**
    ///      * Initialize the exception list for a specific feature.
    ///      * @param aFeature The feature to initialize the exception list for
    ///      */
    /// ```
    ///

    /// `void init (in ACString aFeature);`
    #[inline]
    pub unsafe fn Init(&self, aFeature: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).Init)(self, aFeature)
    }


    /// ```text
    /// /**
    ///      * Add a new exception list entry to the list.
    ///      * @param aEntry The exception list entry to add
    ///      */
    /// ```
    ///

    /// `void addEntry (in nsIUrlClassifierExceptionListEntry aEntry);`
    #[inline]
    pub unsafe fn AddEntry(&self, aEntry: *const nsIUrlClassifierExceptionListEntry) -> ::nserror::nsresult {
        ((*self.vtable).AddEntry)(self, aEntry)
    }


    /// ```text
    /// /**
    ///      * Check if the exception list matches the given URI.
    ///      * @param aURI The URI to check
    ///      * @param aTopLevelURI The top-level URI to check
    ///      * @param aIsPrivateBrowsing Whether the load is in private browsing mode
    ///      * @return True if the exception list matches, false otherwise
    ///      */
    /// ```
    ///

    /// `boolean matches (in nsIURI aURI, in nsIURI aTopLevelURI, in boolean aIsPrivateBrowsing);`
    #[inline]
    pub unsafe fn Matches(&self, aURI: *const nsIURI, aTopLevelURI: *const nsIURI, aIsPrivateBrowsing: bool, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).Matches)(self, aURI, aTopLevelURI, aIsPrivateBrowsing, _retval)
    }


    /// ```text
    /// /**
    ///      * Test-only interface to get all entries in the exception list.
    ///      * @return The entries in the exception list
    ///      */
    /// ```
    ///

    /// `Array<nsIUrlClassifierExceptionListEntry> testGetEntries ();`
    #[inline]
    pub unsafe fn TestGetEntries(&self, _retval: *mut thin_vec::ThinVec<Option<RefPtr<nsIUrlClassifierExceptionListEntry>>>) -> ::nserror::nsresult {
        ((*self.vtable).TestGetEntries)(self, _retval)
    }


}


