//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/url-classifier/nsIUrlClassifierExceptionListEntry.idl
//


/// `interface nsIUrlClassifierExceptionListEntry : nsISupports`
///

/// ```text
/// /**
///  * Represents a single exception list entry for the url classifier exception list.
///  * Needs to be initialized with init() before use.
///  *
///  * @see nsIUrlClassifierExceptionList
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIUrlClassifierExceptionListEntry {
    vtable: &'static nsIUrlClassifierExceptionListEntryVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIUrlClassifierExceptionListEntry.
unsafe impl XpCom for nsIUrlClassifierExceptionListEntry {
    const IID: nsIID = nsID(0x8753a413, 0x3ed6, 0x4a61,
        [0xa1, 0xdc, 0xb3, 0x1a, 0x7e, 0x69, 0xb7, 0x96]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIUrlClassifierExceptionListEntry {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIUrlClassifierExceptionListEntry.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIUrlClassifierExceptionListEntryCoerce {
    /// Cheaply cast a value of this type from a `nsIUrlClassifierExceptionListEntry`.
    fn coerce_from(v: &nsIUrlClassifierExceptionListEntry) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIUrlClassifierExceptionListEntryCoerce for nsIUrlClassifierExceptionListEntry {
    #[inline]
    fn coerce_from(v: &nsIUrlClassifierExceptionListEntry) -> &Self {
        v
    }
}

impl nsIUrlClassifierExceptionListEntry {
    /// Cast this `nsIUrlClassifierExceptionListEntry` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIUrlClassifierExceptionListEntryCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIUrlClassifierExceptionListEntry {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIUrlClassifierExceptionListEntryCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIUrlClassifierExceptionListEntry) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIUrlClassifierExceptionListEntry
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIUrlClassifierExceptionListEntryVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void init (in nsIUrlClassifierExceptionListEntry_Category aCategory, in ACString aUrlPattern, in ACString aTopLevelUrlPattern, in boolean aIsPrivateBrowsingOnly, in Array<ACString> aFilterContentBlockingCategories, in Array<ACString> aClassifierFeatures); */
    pub Init: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aCategory:  u8, aUrlPattern: *const ::nsstring::nsACString, aTopLevelUrlPattern: *const ::nsstring::nsACString, aIsPrivateBrowsingOnly: bool, aFilterContentBlockingCategories: *const thin_vec::ThinVec<::nsstring::nsCString>, aClassifierFeatures: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* boolean matches (in nsIURI aURI, in nsIURI aTopLevelURI, in boolean aIsPrivateBrowsing); */
    pub Matches: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aURI: *const nsIURI, aTopLevelURI: *const nsIURI, aIsPrivateBrowsing: bool, _retval: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute nsIUrlClassifierExceptionListEntry_Category category; */
    pub GetCategory: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aCategory: *mut u8) -> ::nserror::nsresult,

    /* readonly attribute ACString urlPattern; */
    pub GetUrlPattern: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aUrlPattern: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute ACString topLevelUrlPattern; */
    pub GetTopLevelUrlPattern: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aTopLevelUrlPattern: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute boolean isPrivateBrowsingOnly; */
    pub GetIsPrivateBrowsingOnly: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aIsPrivateBrowsingOnly: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute Array<ACString> filterContentBlockingCategories; */
    pub GetFilterContentBlockingCategories: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aFilterContentBlockingCategories: *mut thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* readonly attribute Array<ACString> classifierFeatures; */
    pub GetClassifierFeatures: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, aClassifierFeatures: *mut thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* [noscript] ACString describe (); */
    pub Describe: unsafe extern "system" fn (this: *const nsIUrlClassifierExceptionListEntry, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIUrlClassifierExceptionListEntry {

    pub const CATEGORY_INTERNAL_PREF:  u8 = 0;


    pub const CATEGORY_BASELINE:  u8 = 1;


    pub const CATEGORY_CONVENIENCE:  u8 = 2;

    /// ```text
    /// /**
    ///      * Initialize all fields of the exception list entry.
    ///      * @param aCategory - The category of this exception entry.
    ///      * @param aUrlPattern - The urlPattern for the url to be loaded. See https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/Match_patterns for more info.
    ///      * @param aTopLevelUrlPattern - Optional top-level url pattern to filter for this exception. If not set the exception applies to all top level sites.
    ///      * @param aIsPrivateBrowsingOnly - Whether this applies only to private browsing
    ///      * @param aFilterContentBlockingCategories - The content blocking categories to filter for this exception.
    ///      * @param aClassifierFeatures - The list of url classifier features to apply this exception to.
    ///
    ///      */
    /// ```
    ///

    /// `void init (in nsIUrlClassifierExceptionListEntry_Category aCategory, in ACString aUrlPattern, in ACString aTopLevelUrlPattern, in boolean aIsPrivateBrowsingOnly, in Array<ACString> aFilterContentBlockingCategories, in Array<ACString> aClassifierFeatures);`
    #[inline]
    pub unsafe fn Init(&self, aCategory:  u8, aUrlPattern: *const ::nsstring::nsACString, aTopLevelUrlPattern: *const ::nsstring::nsACString, aIsPrivateBrowsingOnly: bool, aFilterContentBlockingCategories: *const thin_vec::ThinVec<::nsstring::nsCString>, aClassifierFeatures: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).Init)(self, aCategory, aUrlPattern, aTopLevelUrlPattern, aIsPrivateBrowsingOnly, aFilterContentBlockingCategories, aClassifierFeatures)
    }


    /// ```text
    /// /**
    ///      * Check if the exception list entry matches the given load.
    ///      * @param aURI The URI to check
    ///      * @param aTopLevelURI The top-level URI to check
    ///      * @param aIsPrivateBrowsing Whether the load is in private browsing mode
    ///      * @return True if the exception list entry matches the given load and it
    ///      *         should be skipped from classification, false otherwise
    ///      */
    /// ```
    ///

    /// `boolean matches (in nsIURI aURI, in nsIURI aTopLevelURI, in boolean aIsPrivateBrowsing);`
    #[inline]
    pub unsafe fn Matches(&self, aURI: *const nsIURI, aTopLevelURI: *const nsIURI, aIsPrivateBrowsing: bool, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).Matches)(self, aURI, aTopLevelURI, aIsPrivateBrowsing, _retval)
    }


    /// ```text
    /// /**
    ///      * The category of this exception entry.
    ///      * This is used for filtering exception list entries based on user configuration.
    ///      */
    /// ```
    ///

    /// `readonly attribute nsIUrlClassifierExceptionListEntry_Category category;`
    #[inline]
    pub unsafe fn GetCategory(&self, aCategory: *mut u8) -> ::nserror::nsresult {
        ((*self.vtable).GetCategory)(self, aCategory)
    }


    /// ```text
    /// /**
    ///      * The urlPattern name for this exception entry.
    ///      */
    /// ```
    ///

    /// `readonly attribute ACString urlPattern;`
    #[inline]
    pub unsafe fn GetUrlPattern(&self, aUrlPattern: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetUrlPattern)(self, aUrlPattern)
    }


    /// ```text
    /// /**
    ///      * Optional top-level url pattern to filter for this exception. If not set
    ///      * the exception applies to all top level sites.
    ///      */
    /// ```
    ///

    /// `readonly attribute ACString topLevelUrlPattern;`
    #[inline]
    pub unsafe fn GetTopLevelUrlPattern(&self, aTopLevelUrlPattern: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetTopLevelUrlPattern)(self, aTopLevelUrlPattern)
    }


    /// ```text
    /// /**
    ///      * Whether this exception only applies in private browsing mode.
    ///      */
    /// ```
    ///

    /// `readonly attribute boolean isPrivateBrowsingOnly;`
    #[inline]
    pub unsafe fn GetIsPrivateBrowsingOnly(&self, aIsPrivateBrowsingOnly: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsPrivateBrowsingOnly)(self, aIsPrivateBrowsingOnly)
    }


    /// ```text
    /// /**
    ///      * Optional array of content blocking categories to filter for this
    ///      * exception. If not set the exception applies to all content blocking
    ///      * categories.
    ///      */
    /// ```
    ///

    /// `readonly attribute Array<ACString> filterContentBlockingCategories;`
    #[inline]
    pub unsafe fn GetFilterContentBlockingCategories(&self, aFilterContentBlockingCategories: *mut thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).GetFilterContentBlockingCategories)(self, aFilterContentBlockingCategories)
    }


    /// ```text
    /// /**
    ///      * The list of url classifier features to apply this exception to.
    ///      */
    /// ```
    ///

    /// `readonly attribute Array<ACString> classifierFeatures;`
    #[inline]
    pub unsafe fn GetClassifierFeatures(&self, aClassifierFeatures: *mut thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).GetClassifierFeatures)(self, aClassifierFeatures)
    }


    /// ```text
    /// /**
    ///      * Returns a string containing all attributes of this exception list entry.
    ///      * This is intended for logging purposes only.
    ///      * @return A string containing all attributes
    ///      */
    /// ```
    ///

    /// `[noscript] ACString describe ();`
    #[inline]
    pub unsafe fn Describe(&self, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).Describe)(self, _retval)
    }


}


