//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/url-classifier/nsIUrlClassifierTestUtils.idl
//


/// `interface nsIUrlClassifierTestUtils : nsISupports`
///

/// ```text
/// /**
///  * Some utility methods used by the url classifier test suite.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIUrlClassifierTestUtils {
    vtable: &'static nsIUrlClassifierTestUtilsVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIUrlClassifierTestUtils.
unsafe impl XpCom for nsIUrlClassifierTestUtils {
    const IID: nsIID = nsID(0xd63d6302, 0x05fe, 0x4b0e,
        [0xaf, 0xf9, 0xf6, 0xb1, 0x18, 0xf9, 0x1a, 0xda]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIUrlClassifierTestUtils {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIUrlClassifierTestUtils.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIUrlClassifierTestUtilsCoerce {
    /// Cheaply cast a value of this type from a `nsIUrlClassifierTestUtils`.
    fn coerce_from(v: &nsIUrlClassifierTestUtils) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIUrlClassifierTestUtilsCoerce for nsIUrlClassifierTestUtils {
    #[inline]
    fn coerce_from(v: &nsIUrlClassifierTestUtils) -> &Self {
        v
    }
}

impl nsIUrlClassifierTestUtils {
    /// Cast this `nsIUrlClassifierTestUtils` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIUrlClassifierTestUtilsCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIUrlClassifierTestUtils {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIUrlClassifierTestUtilsCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIUrlClassifierTestUtils) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIUrlClassifierTestUtils
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIUrlClassifierTestUtilsVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* ACString makeUpdateResponseV5 (in ACString aName, in uint32_t aSingleHash); */
    pub MakeUpdateResponseV5: unsafe extern "system" fn (this: *const nsIUrlClassifierTestUtils, aName: *const ::nsstring::nsACString, aSingleHash: u32, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* ACString makeFindFullHashResponseV5 (in ACString aFullHash); */
    pub MakeFindFullHashResponseV5: unsafe extern "system" fn (this: *const nsIUrlClassifierTestUtils, aFullHash: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* uint32_t generateLookupHash (in ACString aFragment); */
    pub GenerateLookupHash: unsafe extern "system" fn (this: *const nsIUrlClassifierTestUtils, aFragment: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult,

    /* ACString generateFullHash (in ACString aFragment); */
    pub GenerateFullHash: unsafe extern "system" fn (this: *const nsIUrlClassifierTestUtils, aFragment: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIUrlClassifierTestUtils {

    /// ```text
    /// /**
    ///    * Make update response for the V5 protocol. The update response only contains
    ///    * a single hash. This is used for testing.
    ///    *
    ///    * @param aName The name of the list.
    ///    * @param aSingleHash The single hash.
    ///    *
    ///    * @returns A string that contains the update response.
    ///    */
    /// ```
    ///

    /// `ACString makeUpdateResponseV5 (in ACString aName, in uint32_t aSingleHash);`
    #[inline]
    pub unsafe fn MakeUpdateResponseV5(&self, aName: *const ::nsstring::nsACString, aSingleHash: u32, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).MakeUpdateResponseV5)(self, aName, aSingleHash, _retval)
    }


    /// ```text
    /// /**
    ///    * Make find full hash response for the V5 protocol. This is used for testing.
    ///    *
    ///    * @param aFullHash The full hash.
    ///    *
    ///    * @returns A string that contains the find full hash response.
    ///    */
    /// ```
    ///

    /// `ACString makeFindFullHashResponseV5 (in ACString aFullHash);`
    #[inline]
    pub unsafe fn MakeFindFullHashResponseV5(&self, aFullHash: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).MakeFindFullHashResponseV5)(self, aFullHash, _retval)
    }


    /// ```text
    /// /**
    ///    * Generate lookup hash(4 bytes) from the given fragment.
    ///    * @param aFragment The fragment.
    ///    *
    ///    * @returns A uint32_t that contains the lookup hash.
    ///    */
    /// ```
    ///

    /// `uint32_t generateLookupHash (in ACString aFragment);`
    #[inline]
    pub unsafe fn GenerateLookupHash(&self, aFragment: *const ::nsstring::nsACString, _retval: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).GenerateLookupHash)(self, aFragment, _retval)
    }


    /// ```text
    /// /**
    ///    * Generate full hash(32 bytes) from the given fragment.
    ///    * @param aFragment The fragment.
    ///    *
    ///    * @returns A base64 encoded string that contains the full hash.
    ///    */
    /// ```
    ///

    /// `ACString generateFullHash (in ACString aFragment);`
    #[inline]
    pub unsafe fn GenerateFullHash(&self, aFragment: *const ::nsstring::nsACString, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GenerateFullHash)(self, aFragment, _retval)
    }


}


