//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/uriloader/base/nsIWebProgressListener.idl
//


/// `interface nsIWebProgressListener : nsISupports`
///

/// ```text
/// /**
///  * The nsIWebProgressListener interface is implemented by clients wishing to
///  * listen in on the progress associated with the loading of asynchronous
///  * requests in the context of a nsIWebProgress instance as well as any child
///  * nsIWebProgress instances.  nsIWebProgress.idl describes the parent-child
///  * relationship of nsIWebProgress instances.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIWebProgressListener {
    vtable: &'static nsIWebProgressListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIWebProgressListener.
unsafe impl XpCom for nsIWebProgressListener {
    const IID: nsIID = nsID(0xa9df523b, 0xefe2, 0x421e,
        [0x9d, 0x8e, 0x3d, 0x7f, 0x80, 0x7d, 0xda, 0x4c]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIWebProgressListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIWebProgressListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIWebProgressListenerCoerce {
    /// Cheaply cast a value of this type from a `nsIWebProgressListener`.
    fn coerce_from(v: &nsIWebProgressListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIWebProgressListenerCoerce for nsIWebProgressListener {
    #[inline]
    fn coerce_from(v: &nsIWebProgressListener) -> &Self {
        v
    }
}

impl nsIWebProgressListener {
    /// Cast this `nsIWebProgressListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIWebProgressListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIWebProgressListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIWebProgressListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIWebProgressListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIWebProgressListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIWebProgressListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onStateChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aStateFlags, in nsresult aStatus); */
    pub OnStateChange: unsafe extern "system" fn (this: *const nsIWebProgressListener, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aStateFlags: u32, aStatus: nserror::nsresult) -> ::nserror::nsresult,

    /* void onProgressChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in long aCurSelfProgress, in long aMaxSelfProgress, in long aCurTotalProgress, in long aMaxTotalProgress); */
    pub OnProgressChange: unsafe extern "system" fn (this: *const nsIWebProgressListener, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aCurSelfProgress: i32, aMaxSelfProgress: i32, aCurTotalProgress: i32, aMaxTotalProgress: i32) -> ::nserror::nsresult,

    /* void onLocationChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in nsIURI aLocation, [optional] in unsigned long aFlags); */
    pub OnLocationChange: unsafe extern "system" fn (this: *const nsIWebProgressListener, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aLocation: *const nsIURI, aFlags: u32) -> ::nserror::nsresult,

    /* void onStatusChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in nsresult aStatus, in wstring aMessage); */
    pub OnStatusChange: unsafe extern "system" fn (this: *const nsIWebProgressListener, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aStatus: nserror::nsresult, aMessage: *const u16) -> ::nserror::nsresult,

    /* void onSecurityChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aState); */
    pub OnSecurityChange: unsafe extern "system" fn (this: *const nsIWebProgressListener, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aState: u32) -> ::nserror::nsresult,

    /* void onContentBlockingEvent (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aEvent); */
    pub OnContentBlockingEvent: unsafe extern "system" fn (this: *const nsIWebProgressListener, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aEvent: u32) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIWebProgressListener {
    /// ```text
    /// /**
    ///    * State Transition Flags
    ///    *
    ///    * These flags indicate the various states that requests may transition
    ///    * through as they are being loaded.  These flags are mutually exclusive.
    ///    *
    ///    * For any given request, onStateChange is called once with the STATE_START
    ///    * flag, zero or more times with the STATE_TRANSFERRING flag or once with the
    ///    * STATE_REDIRECTING flag, and then finally once with the STATE_STOP flag.
    ///    * NOTE: For document requests, a second STATE_STOP is generated (see the
        ///    * description of STATE_IS_WINDOW for more details).
    ///    *
    ///    * STATE_START
    ///    *   This flag indicates the start of a request.  This flag is set when a
    ///    *   request is initiated.  The request is complete when onStateChange is
    ///    *   called for the same request with the STATE_STOP flag set.
    ///    *
    ///    * STATE_REDIRECTING
    ///    *   This flag indicates that a request is being redirected.  The request
    ///    *   passed to onStateChange is the request that is being redirected.  When a
    ///    *   redirect occurs, a new request is generated automatically to process the
    ///    *   new request.  Expect a corresponding STATE_START event for the new
    ///    *   request, and a STATE_STOP for the redirected request.
    ///    *
    ///    * STATE_TRANSFERRING
    ///    *   This flag indicates that data for a request is being transferred to an
    ///    *   end consumer.  This flag indicates that the request has been targeted,
    ///    *   and that the user may start seeing content corresponding to the request.
    ///    *
    ///    * STATE_NEGOTIATING
    ///    *   This flag is not used.
    ///    *
    ///    * STATE_STOP
    ///    *   This flag indicates the completion of a request.  The aStatus parameter
    ///    *   to onStateChange indicates the final status of the request.
    ///    */
    /// ```
    ///

    pub const STATE_START: u32 = 1;


    pub const STATE_REDIRECTING: u32 = 2;


    pub const STATE_TRANSFERRING: u32 = 4;


    pub const STATE_NEGOTIATING: u32 = 8;


    pub const STATE_STOP: u32 = 16;

    /// ```text
    /// /**
    ///    * State Type Flags
    ///    *
    ///    * These flags further describe the entity for which the state transition is
    ///    * occuring.  These flags are NOT mutually exclusive (i.e., an onStateChange
        ///    * event may indicate some combination of these flags).
    ///    *
    ///    * STATE_IS_REQUEST
    ///    *   This flag indicates that the state transition is for a request, which
    ///    *   includes but is not limited to document requests.  (See below for a
        ///    *   description of document requests.)  Other types of requests, such as
    ///    *   requests for inline content (e.g., images and stylesheets) are
    ///    *   considered normal requests.
    ///    *
    ///    * STATE_IS_DOCUMENT
    ///    *   This flag indicates that the state transition is for a document request.
    ///    *   This flag is set in addition to STATE_IS_REQUEST.  A document request
    ///    *   supports the nsIChannel interface and its loadFlags attribute includes
    ///    *   the nsIChannel::LOAD_DOCUMENT_URI flag.
    ///    *
    ///    *   A document request does not complete until all requests associated with
    ///    *   the loading of its corresponding document have completed.  This includes
    ///    *   other document requests (e.g., corresponding to HTML <iframe> elements).
    ///    *   The document corresponding to a document request is available via the
    ///    *   DOMWindow attribute of onStateChange's aWebProgress parameter.
    ///    *
    ///    * STATE_IS_NETWORK
    ///    *   This flag indicates that the state transition corresponds to the start
    ///    *   or stop of activity in the indicated nsIWebProgress instance.  This flag
    ///    *   is accompanied by either STATE_START or STATE_STOP, and it may be
    ///    *   combined with other State Type Flags.
    ///    *
    ///    *   Unlike STATE_IS_WINDOW, this flag is only set when activity within the
    ///    *   nsIWebProgress instance being observed starts or stops.  If activity
    ///    *   only occurs in a child nsIWebProgress instance, then this flag will be
    ///    *   set to indicate the start and stop of that activity.
    ///    *
    ///    *   For example, in the case of navigation within a single frame of a HTML
    ///    *   frameset, a nsIWebProgressListener instance attached to the
    ///    *   nsIWebProgress of the frameset window will receive onStateChange calls
    ///    *   with the STATE_IS_NETWORK flag set to indicate the start and stop of
    ///    *   said navigation.  In other words, an observer of an outer window can
    ///    *   determine when activity, that may be constrained to a child window or
    ///    *   set of child windows, starts and stops.
    ///    *
    ///    * STATE_IS_WINDOW
    ///    *   This flag indicates that the state transition corresponds to the start
    ///    *   or stop of activity in the indicated nsIWebProgress instance.  This flag
    ///    *   is accompanied by either STATE_START or STATE_STOP, and it may be
    ///    *   combined with other State Type Flags.
    ///    *
    ///    *   This flag is similar to STATE_IS_DOCUMENT.  However, when a document
    ///    *   request completes, two onStateChange calls with STATE_STOP are
    ///    *   generated.  The document request is passed as aRequest to both calls.
    ///    *   The first has STATE_IS_REQUEST and STATE_IS_DOCUMENT set, and the second
    ///    *   has the STATE_IS_WINDOW flag set (and possibly the STATE_IS_NETWORK flag
        ///    *   set as well -- see above for a description of when the STATE_IS_NETWORK
        ///    *   flag may be set).  This second STATE_STOP event may be useful as a way
    ///    *   to partition the work that occurs when a document request completes.
    ///    *
    ///    * STATE_IS_REDIRECTED_DOCUMENT
    ///    *  Same as STATE_IS_DOCUMENT, but sent only after a redirect has occured.
    ///    *  Introduced in order not to confuse existing code with extra state change
    ///    *  events. See |nsDocLoader::OnStartRequest| for more info.
    ///    */
    /// ```
    ///

    pub const STATE_IS_REQUEST: u32 = 65536;


    pub const STATE_IS_DOCUMENT: u32 = 131072;


    pub const STATE_IS_NETWORK: u32 = 262144;


    pub const STATE_IS_WINDOW: u32 = 524288;


    pub const STATE_IS_REDIRECTED_DOCUMENT: u32 = 1048576;

    /// ```text
    /// /**
    ///    * State Modifier Flags
    ///    *
    ///    * These flags further describe the transition which is occuring.  These
    ///    * flags are NOT mutually exclusive (i.e., an onStateChange event may
        ///    * indicate some combination of these flags).
    ///    *
    ///    * STATE_RESTORING
    ///    *   This flag indicates that the state transition corresponds to the start
    ///    *   or stop of activity for restoring a previously-rendered presentation.
    ///    *   As such, there is no actual network activity associated with this
    ///    *   request, and any modifications made to the document or presentation
    ///    *   when it was originally loaded will still be present.
    ///    */
    /// ```
    ///

    pub const STATE_RESTORING: u32 = 16777216;

    /// ```text
    /// /**
    ///    * State Security Flags
    ///    *
    ///    * These flags describe the security state reported by a call to the
    ///    * onSecurityChange method.  These flags are mutually exclusive.
    ///    *
    ///    * STATE_IS_INSECURE
    ///    *   This flag indicates that the data corresponding to the request
    ///    *   was received over an insecure channel.
    ///    *
    ///    * STATE_IS_BROKEN
    ///    *   This flag indicates an unknown security state.  This may mean that the
    ///    *   request is being loaded as part of a page in which some content was
    ///    *   received over an insecure channel.
    ///    *
    ///    * STATE_IS_SECURE
    ///    *   This flag indicates that the data corresponding to the request was
    ///    *   received over a secure channel.  The degree of security is expressed by
    ///    *   STATE_SECURE_HIGH, STATE_SECURE_MED, or STATE_SECURE_LOW.
    ///    */
    /// ```
    ///

    pub const STATE_IS_INSECURE: u32 = 4;


    pub const STATE_IS_BROKEN: u32 = 1;


    pub const STATE_IS_SECURE: u32 = 2;

    /// ```text
    /// /**
    ///    * Mixed active content flags
    ///    *
    ///    * NOTE: IF YOU ARE ADDING MORE OF THESE FLAGS, MAKE SURE TO EDIT
    ///    * nsSecureBrowserUIImpl::CheckForBlockedContent().
    ///    *
    ///    * May be set in addition to the State Security Flags, to indicate that
    ///    * mixed active content has been encountered.
    ///    *
    ///    * STATE_BLOCKED_MIXED_ACTIVE_CONTENT
    ///    *   Mixed active content has been blocked from loading.
    ///    *
    ///    * STATE_LOADED_MIXED_ACTIVE_CONTENT
    ///    *   Mixed active content has been loaded. State should be STATE_IS_BROKEN.
    ///    */
    /// ```
    ///

    pub const STATE_BLOCKED_MIXED_ACTIVE_CONTENT: u32 = 16;


    pub const STATE_LOADED_MIXED_ACTIVE_CONTENT: u32 = 32;

    /// ```text
    /// /**
    ///    * Mixed display content flags
    ///    *
    ///    * NOTE: IF YOU ARE ADDING MORE OF THESE FLAGS, MAKE SURE TO EDIT
    ///    * nsSecureBrowserUIImpl::CheckForBlockedContent().
    ///    *
    ///    * May be set in addition to the State Security Flags, to indicate that
    ///    * mixed display content has been encountered.
    ///    *
    ///    * STATE_BLOCKED_MIXED_DISPLAY_CONTENT
    ///    *   Mixed display content has been blocked from loading.
    ///    *
    ///    * STATE_LOADED_MIXED_DISPLAY_CONTENT
    ///    *   Mixed display content has been loaded. State should be STATE_IS_BROKEN.
    ///    */
    /// ```
    ///

    pub const STATE_BLOCKED_MIXED_DISPLAY_CONTENT: u32 = 256;


    pub const STATE_LOADED_MIXED_DISPLAY_CONTENT: u32 = 512;

    /// ```text
    /// /**
    ///     * State bits for EV == Extended Validation == High Assurance
    ///     *
    ///     * These flags describe the level of identity verification
    ///     * in a call to the onSecurityChange method.
    ///     *
    ///     * STATE_IDENTITY_EV_TOPLEVEL
    ///     *   The topmost document uses an EV cert.
    ///     *   NOTE: Available since Gecko 1.9
    ///     */
    /// ```
    ///

    pub const STATE_IDENTITY_EV_TOPLEVEL: u32 = 1048576;

    /// ```text
    /// /***
    ///    * Associated state flag
    ///    *
    ///    * This flag is used to if a page is inheriting its security context.
    ///    *
    ///    * STATE_IDENTITY_ASSOCIATED
    ///    *   This document doesn't have an identity of its own, and instead
    ///    *   uses its predecessor's identity.
    ///    */
    /// ```
    ///

    pub const STATE_IDENTITY_ASSOCIATED: u32 = 2097152;

    /// ```text
    /// /**
    ///     * Broken state flags
    ///     *
    ///     * These flags describe the reason of the broken state.
    ///     *
    ///     * STATE_USES_SSL_3
    ///     *   The topmost document uses SSL 3.0.
    ///     *
    ///     * STATE_USES_WEAK_CRYPTO
    ///     *   The topmost document uses a weak cipher suite such as RC4.
    ///     *
    ///     * STATE_CERT_USER_OVERRIDDEN
    ///     *   The user has added a security exception for the site.
    ///     */
    /// ```
    ///

    pub const STATE_USES_SSL_3: u32 = 16777216;


    pub const STATE_USES_WEAK_CRYPTO: u32 = 33554432;


    pub const STATE_CERT_USER_OVERRIDDEN: u32 = 67108864;

    /// ```text
    /// /**
    ///    * Content Blocking Event flags
    ///    *
    ///    * NOTE: IF YOU ARE ADDING MORE OF THESE FLAGS, MAKE SURE TO EDIT
    ///    * nsSecureBrowserUIImpl::CheckForBlockedContent() AND UPDATE THE
    ///    * CORRESPONDING LIST IN ContentBlockingController.java
    ///    *
    ///    * These flags describe the reason of cookie jar rejection.
    ///    *
    ///    * STATE_BLOCKED_TRACKING_CONTENT
    ///    *   Tracking content has been blocked from loading.
    ///    *
    ///    * STATE_LOADED_LEVEL_1_TRACKING_CONTENT
    ///    *   Tracking content from the Disconnect Level 1 list has been loaded.
    ///    *
    ///    * STATE_LOADED_LEVEL_2_TRACKING_CONTENT
    ///    *   Tracking content from the Disconnect Level 2 list has been loaded.
    ///    *
    ///    * STATE_BLOCKED_FINGERPRINTING_CONTENT
    ///    *   Fingerprinting content has been blocked from loading.
    ///    *
    ///    * STATE_LOADED_FINGERPRINTING_CONTENT
    ///    *   Fingerprinting content has been loaded.
    ///    *
    ///    * STATE_REPLACED_FINGERPRINTING_CONTENT
    ///    *   Fingerprinting content which should be blocked from loading was replaced with a
    ///    *   shim.
    ///    *
    ///    * STATE_ALLOWED_FINGERPRINTING_CONTENT
    ///    *   Fingerprinting content which should be blocked from loading was allowed.
    ///    *
    ///    * STATE_BLOCKED_CRYPTOMINING_CONTENT
    ///    *   Cryptomining content has been blocked from loading.
    ///    *
    ///    * STATE_LOADED_CRYPTOMINING_CONTENT
    ///    *   Cryptomining content has been loaded.
    ///    *
    ///    * STATE_BLOCKED_UNSAFE_CONTENT
    ///    *   Content which againts SafeBrowsing list has been blocked from loading.
    ///    *
    ///    * STATE_COOKIES_LOADED
    ///    *   Performed a storage access check, which usually means something like a
    ///    *   cookie or a storage item was loaded/stored on the current tab.
    ///    *   Alternatively this could indicate that something in the current tab
    ///    *   attempted to communicate with its same-origin counterparts in other
    ///    *   tabs.
    ///    *
    ///    * STATE_COOKIES_LOADED_TRACKER
    ///    *   Similar to STATE_COOKIES_LOADED, but only sent if the subject of the
    ///    *   action was a third-party tracker when the active cookie policy imposes
    ///    *   restrictions on such content.
    ///    *
    ///    * STATE_COOKIES_LOADED_SOCIALTRACKER
    ///    *   Similar to STATE_COOKIES_LOADED, but only sent if the subject of the
    ///    *   action was a third-party social tracker when the active cookie policy
    ///    *   imposes restrictions on such content.
    ///    *
    ///    * STATE_COOKIES_BLOCKED_BY_PERMISSION
    ///    *   Rejected for custom site permission.
    ///    *
    ///    * STATE_COOKIES_BLOCKED_TRACKER
    ///    *   Rejected because the resource is a tracker and cookie policy doesn't
    ///    *   allow its loading.
    ///    *
    ///    * STATE_COOKIES_BLOCKED_SOCIALTRACKER
    ///    *   Rejected because the resource is a tracker from a social origin and
    ///    *   cookie policy doesn't allow its loading.
    ///    *
    ///    * STATE_COOKIES_PARTITIONED_TRACKER
    ///    *   Rejected because the resource is a third-party tracker and cookie policy
    ///    *   forces third-party resources to be partitioned.
    ///    *
    ///    * STATE_COOKIES_PARTITIONED_FOREIGN
    ///    *   Rejected because the resource is a third-party and cookie policy forces
    ///    *   third-party resources to be partitioned.
    ///    *
    ///    * STATE_COOKIES_BLOCKED_ALL
    ///    *   Rejected because cookie policy blocks all cookies.
    ///    *
    ///    * STATE_COOKIES_BLOCKED_FOREIGN
    ///    *   Rejected because cookie policy blocks 3rd party cookies.
    ///    *
    ///    * STATE_BLOCKED_SOCIALTRACKING_CONTENT
    ///    *   SocialTracking content has been blocked from loading.
    ///    *
    ///    * STATE_LOADED_SOCIALTRACKING_CONTENT
    ///    *   SocialTracking content has been loaded.
    ///    *
    ///    * STATE_REPLACED_TRACKING_CONTENT
    ///    *   Tracking content which should be blocked from loading was replaced with a
    ///    *   shim.
    ///    *
    ///    * STATE_ALLOWED_TRACKING_CONTENT
    ///    *   Tracking content which should be blocked from loading was allowed.
    ///    *
    ///    * STATE_BLOCKED_EMAILTRACING_CONTENT
    ///    *   EmailTracking content has been blocked from loading.
    ///    *
    ///    * STATE_LOADED_EMAILTRACKING_LEVEL_1_CONTENT
    ///    *   EmailTracking content from the Disconnect level 1 has been loaded.
    ///    *
    ///    * STATE_LOADED_EMAILTRACKING_LEVEL_2_CONTENT
    ///    *   EmailTracking content from the Disconnect level 2 has been loaded.
    ///    *
    ///    * STATE_ALLOWED_CANVAS_FINGERPRINTING
    ///    *   A potential attempt to fingerprint using the canvas API was observed.
    ///    *
    ///    * STATE_ALLOWED_FONT_FINGERPRINTING
    ///    *   A potential attempt to fingerprint by checking the exposed fonts
    ///    *   was observed.
    ///    *
    ///    * STATE_BLOCKED_SUSPICIOUS_FINGERPRINTING
    ///    *   Suspicious fingerprinting activity has been blocked by the fingerprinting
    ///    *   protection.
    ///    *
    ///    * STATE_PURGED_BOUNCETRACKER
    ///    *   BounceTrackingProtection purged state for a bounce tracker.
    ///    */
    /// ```
    ///

    pub const STATE_BLOCKED_TRACKING_CONTENT: u32 = 4096;


    pub const STATE_LOADED_LEVEL_1_TRACKING_CONTENT: u32 = 8192;


    pub const STATE_LOADED_LEVEL_2_TRACKING_CONTENT: u32 = 1048576;


    pub const STATE_BLOCKED_FINGERPRINTING_CONTENT: u32 = 64;


    pub const STATE_LOADED_FINGERPRINTING_CONTENT: u32 = 1024;


    pub const STATE_REPLACED_FINGERPRINTING_CONTENT: u32 = 134217728;


    pub const STATE_ALLOWED_FINGERPRINTING_CONTENT: u32 = 512;


    pub const STATE_BLOCKED_CRYPTOMINING_CONTENT: u32 = 2048;


    pub const STATE_LOADED_CRYPTOMINING_CONTENT: u32 = 2097152;


    pub const STATE_BLOCKED_UNSAFE_CONTENT: u32 = 16384;


    pub const STATE_COOKIES_LOADED: u32 = 32768;


    pub const STATE_COOKIES_LOADED_TRACKER: u32 = 262144;


    pub const STATE_COOKIES_LOADED_SOCIALTRACKER: u32 = 524288;


    pub const STATE_COOKIES_BLOCKED_BY_PERMISSION: u32 = 268435456;


    pub const STATE_COOKIES_BLOCKED_TRACKER: u32 = 536870912;


    pub const STATE_COOKIES_BLOCKED_SOCIALTRACKER: u32 = 16777216;


    pub const STATE_COOKIES_BLOCKED_ALL: u32 = 1073741824;


    pub const STATE_COOKIES_PARTITIONED_TRACKER: u32 = 2;


    pub const STATE_COOKIES_PARTITIONED_FOREIGN: u32 = 2147483648;


    pub const STATE_COOKIES_BLOCKED_FOREIGN: u32 = 128;


    pub const STATE_BLOCKED_SOCIALTRACKING_CONTENT: u32 = 65536;


    pub const STATE_LOADED_SOCIALTRACKING_CONTENT: u32 = 131072;


    pub const STATE_REPLACED_TRACKING_CONTENT: u32 = 16;


    pub const STATE_ALLOWED_TRACKING_CONTENT: u32 = 32;


    pub const STATE_BLOCKED_EMAILTRACKING_CONTENT: u32 = 4194304;


    pub const STATE_LOADED_EMAILTRACKING_LEVEL_1_CONTENT: u32 = 8388608;


    pub const STATE_LOADED_EMAILTRACKING_LEVEL_2_CONTENT: u32 = 256;


    pub const STATE_ALLOWED_CANVAS_FINGERPRINTING: u32 = 33554432;


    pub const STATE_ALLOWED_FONT_FINGERPRINTING: u32 = 67108864;


    pub const STATE_BLOCKED_SUSPICIOUS_FINGERPRINTING: u32 = 4;


    pub const STATE_PURGED_BOUNCETRACKER: u32 = 8;

    /// ```text
    /// /**
    ///    * Flags for HTTPS-Only and HTTPS-First Mode upgrades
    ///    *
    ///    * STATE_HTTPS_ONLY_MODE_UPGRADED
    ///    *   When a request has been upgraded by HTTPS-Only Mode
    ///    *
    ///    * STATE_HTTPS_ONLY_MODE_UPGRADE_FAILED
    ///    *   When an upgraded request failed.
    ///    *
    ///    * STATE_HTTPS_ONLY_MODE_UPGRADED_FIRST
    ///    *   When a request has been upgraded by HTTPS-First Mode
    ///    */
    /// ```
    ///

    pub const STATE_HTTPS_ONLY_MODE_UPGRADED: u32 = 4194304;


    pub const STATE_HTTPS_ONLY_MODE_UPGRADE_FAILED: u32 = 8388608;


    pub const STATE_HTTPS_ONLY_MODE_UPGRADED_FIRST: u32 = 134217728;

    /// ```text
    /// /**
    ///    * Flags for onLocationChange
    ///    *
    ///    * LOCATION_CHANGE_SAME_DOCUMENT
    ///    *   This flag is on when |aWebProgress| did not load a new document.
    ///    *   For example, the location change is due to an anchor scroll or a
    ///    *   pushState/popState/replaceState.
    ///    *
    ///    * LOCATION_CHANGE_ERROR_PAGE
    ///    *   This flag is on when |aWebProgress| redirected from the requested
    ///    *   contents to an internal page to show error status, such as
    ///    *   <about:neterror>, <about:certerror> and so on.
    ///    *
    ///    *   Generally speaking, |aURI| and |aRequest| are the original data. DOM
    ///    *   |window.location.href| is also the original location, while
    ///    *   |document.documentURI| is the redirected location. Sometimes |aURI| is
    ///    *   <about:blank> and |aRequest| is null when the original data does not
    ///    +   remain.
    ///    *
    ///    *   |aWebProgress| does NOT set this flag when it did not try to load a new
    ///    *   document. In this case, it should set LOCATION_CHANGE_SAME_DOCUMENT.
    ///    *
    ///    * LOCATION_CHANGE_RELOAD
    ///    *   This flag is on when reloading the current page, either from
    ///    *   location.reload() or the browser UI.
    ///    *
    ///    * LOCATION_CHANGE_HASHCHANGE
    ///    *   This flag is on for same-document location changes where only the URI's
    ///    *   reference fragment has changed. This flag implies
    ///    *   LOCATION_CHANGE_SAME_DOCUMENT.
    ///    *
    ///    * LOCATION_CHANGE_SESSION_STORE
    ///    *   This flag is on for location changes that are the result of the session
    ///    *   store updating the URI of aWebProgress without actually navigating.
    ///    */
    /// ```
    ///

    pub const LOCATION_CHANGE_SAME_DOCUMENT: u32 = 1;


    pub const LOCATION_CHANGE_ERROR_PAGE: u32 = 2;


    pub const LOCATION_CHANGE_RELOAD: u32 = 4;


    pub const LOCATION_CHANGE_HASHCHANGE: u32 = 8;


    pub const LOCATION_CHANGE_SESSION_STORE: u32 = 16;

    /// ```text
    /// /**
    ///    * Notification indicating the state has changed for one of the requests
    ///    * associated with aWebProgress.
    ///    *
    ///    * @param aWebProgress
    ///    *        The nsIWebProgress instance that fired the notification
    ///    * @param aRequest
    ///    *        The nsIRequest that has changed state.
    ///    * @param aStateFlags
    ///    *        Flags indicating the new state.  This value is a combination of one
    ///    *        of the State Transition Flags and one or more of the State Type
    ///    *        Flags defined above.  Any undefined bits are reserved for future
    ///    *        use.
    ///    * @param aStatus
    ///    *        Error status code associated with the state change.  This parameter
    ///    *        should be ignored unless aStateFlags includes the STATE_STOP bit.
    ///    *        The status code indicates success or failure of the request
    ///    *        associated with the state change.  NOTE: aStatus may be a success
    ///    *        code even for server generated errors, such as the HTTP 404 error.
    ///    *        In such cases, the request itself should be queried for extended
    ///    *        error information (e.g., for HTTP requests see nsIHttpChannel).
    ///    */
    /// ```
    ///

    /// `void onStateChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aStateFlags, in nsresult aStatus);`
    #[inline]
    pub unsafe fn OnStateChange(&self, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aStateFlags: u32, aStatus: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).OnStateChange)(self, aWebProgress, aRequest, aStateFlags, aStatus)
    }


    /// ```text
    /// /**
    ///    * Notification that the progress has changed for one of the requests
    ///    * associated with aWebProgress.  Progress totals are reset to zero when all
    ///    * requests in aWebProgress complete (corresponding to onStateChange being
        ///    * called with aStateFlags including the STATE_STOP and STATE_IS_WINDOW
        ///    * flags).
    ///    *
    ///    * @param aWebProgress
    ///    *        The nsIWebProgress instance that fired the notification.
    ///    * @param aRequest
    ///    *        The nsIRequest that has new progress.
    ///    * @param aCurSelfProgress
    ///    *        The current progress for aRequest.
    ///    * @param aMaxSelfProgress
    ///    *        The maximum progress for aRequest.
    ///    * @param aCurTotalProgress
    ///    *        The current progress for all requests associated with aWebProgress.
    ///    * @param aMaxTotalProgress
    ///    *        The total progress for all requests associated with aWebProgress.
    ///    *
    ///    * NOTE: If any progress value is unknown, or if its value would exceed the
    ///    * maximum value of type long, then its value is replaced with -1.
    ///    *
    ///    * NOTE: If the object also implements nsIWebProgressListener2 and the caller
    ///    * knows about that interface, this function will not be called. Instead,
    ///    * nsIWebProgressListener2::onProgressChange64 will be called.
    ///    */
    /// ```
    ///

    /// `void onProgressChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in long aCurSelfProgress, in long aMaxSelfProgress, in long aCurTotalProgress, in long aMaxTotalProgress);`
    #[inline]
    pub unsafe fn OnProgressChange(&self, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aCurSelfProgress: i32, aMaxSelfProgress: i32, aCurTotalProgress: i32, aMaxTotalProgress: i32) -> ::nserror::nsresult {
        ((*self.vtable).OnProgressChange)(self, aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress)
    }


    /// ```text
    /// /**
    ///    * Called when the location of the window being watched changes.  This is not
    ///    * when a load is requested, but rather once it is verified that the load is
    ///    * going to occur in the given window.  For instance, a load that starts in a
    ///    * window might send progress and status messages for the new site, but it
    ///    * will not send the onLocationChange until we are sure that we are loading
    ///    * this new page here.
    ///    *
    ///    * @param aWebProgress
    ///    *        The nsIWebProgress instance that fired the notification.
    ///    * @param aRequest
    ///    *        The associated nsIRequest.  This may be null in some cases.
    ///    * @param aLocation
    ///    *        The URI of the location that is being loaded.
    ///    * @param aFlags
    ///    *        This is a value which explains the situation or the reason why
    ///    *        the location has changed.
    ///    */
    /// ```
    ///

    /// `void onLocationChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in nsIURI aLocation, [optional] in unsigned long aFlags);`
    #[inline]
    pub unsafe fn OnLocationChange(&self, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aLocation: *const nsIURI, aFlags: u32) -> ::nserror::nsresult {
        ((*self.vtable).OnLocationChange)(self, aWebProgress, aRequest, aLocation, aFlags)
    }


    /// ```text
    /// /**
    ///    * Notification that the status of a request has changed.  The status message
    ///    * is intended to be displayed to the user (e.g., in the status bar of the
        ///    * browser).
    ///    *
    ///    * @param aWebProgress
    ///    *        The nsIWebProgress instance that fired the notification.
    ///    * @param aRequest
    ///    *        The nsIRequest that has new status.
    ///    * @param aStatus
    ///    *        This value is not an error code.  Instead, it is a numeric value
    ///    *        that indicates the current status of the request.  This interface
    ///    *        does not define the set of possible status codes.  NOTE: Some
    ///    *        status values are defined by nsITransport and nsISocketTransport.
    ///    * @param aMessage
    ///    *        Localized text corresponding to aStatus.
    ///    */
    /// ```
    ///

    /// `void onStatusChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in nsresult aStatus, in wstring aMessage);`
    #[inline]
    pub unsafe fn OnStatusChange(&self, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aStatus: nserror::nsresult, aMessage: *const u16) -> ::nserror::nsresult {
        ((*self.vtable).OnStatusChange)(self, aWebProgress, aRequest, aStatus, aMessage)
    }


    /// ```text
    /// /**
    ///    * Notification called for security progress.  This method will be called on
    ///    * security transitions (eg HTTP -> HTTPS, HTTPS -> HTTP, FOO -> HTTPS) and
    ///    * after document load completion.  It might also be called if an error
    ///    * occurs during network loading.
    ///    *
    ///    * @param aWebProgress
    ///    *        The nsIWebProgress instance that fired the notification.
    ///    * @param aRequest
    ///    *        The nsIRequest that has new security state.
    ///    * @param aState
    ///    *        A value composed of the Security State Flags and the Security
    ///    *        Strength Flags listed above.  Any undefined bits are reserved for
    ///    *        future use.
    ///    *
    ///    * NOTE: These notifications will only occur if a security package is
    ///    * installed.
    ///    */
    /// ```
    ///

    /// `void onSecurityChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aState);`
    #[inline]
    pub unsafe fn OnSecurityChange(&self, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aState: u32) -> ::nserror::nsresult {
        ((*self.vtable).OnSecurityChange)(self, aWebProgress, aRequest, aState)
    }


    /// ```text
    /// /**
    ///    * Notification called for content blocking events.  This method will be
    ///    * called when content gets allowed/blocked for various reasons per the
    ///    * Content Blocking rules.
    ///    *
    ///    * @param aWebProgress
    ///    *        The nsIWebProgress instance that fired the notification.
    ///    * @param aRequest
    ///    *        The nsIRequest that has new security state.
    ///    * @param aEvent
    ///    *        A value composed of the Content Blocking Event Flags listed above.
    ///    *        Any undefined bits are reserved for future use.
    ///    */
    /// ```
    ///

    /// `void onContentBlockingEvent (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aEvent);`
    #[inline]
    pub unsafe fn OnContentBlockingEvent(&self, aWebProgress: *const nsIWebProgress, aRequest: *const nsIRequest, aEvent: u32) -> ::nserror::nsresult {
        ((*self.vtable).OnContentBlockingEvent)(self, aWebProgress, aRequest, aEvent)
    }


}


