//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/xpfe/appshell/nsIWindowMediator.idl
//


/// `interface nsIWindowMediator : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIWindowMediator {
    vtable: &'static nsIWindowMediatorVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIWindowMediator.
unsafe impl XpCom for nsIWindowMediator {
    const IID: nsIID = nsID(0xdf0da056, 0x357d, 0x427f,
        [0xba, 0xfd, 0xe6, 0xcb, 0xf1, 0x9c, 0x93, 0x81]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIWindowMediator {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIWindowMediator.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIWindowMediatorCoerce {
    /// Cheaply cast a value of this type from a `nsIWindowMediator`.
    fn coerce_from(v: &nsIWindowMediator) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIWindowMediatorCoerce for nsIWindowMediator {
    #[inline]
    fn coerce_from(v: &nsIWindowMediator) -> &Self {
        v
    }
}

impl nsIWindowMediator {
    /// Cast this `nsIWindowMediator` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIWindowMediatorCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIWindowMediator {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIWindowMediatorCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIWindowMediator) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIWindowMediator
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIWindowMediatorVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* nsISimpleEnumerator getEnumerator (in wstring aWindowType); */
    pub GetEnumerator: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindowType: *const u16, _retval: *mut *const nsISimpleEnumerator) -> ::nserror::nsresult,

    /* nsISimpleEnumerator getAppWindowEnumerator (in wstring aWindowType); */
    pub GetAppWindowEnumerator: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindowType: *const u16, _retval: *mut *const nsISimpleEnumerator) -> ::nserror::nsresult,

    /* nsISimpleEnumerator getZOrderAppWindowEnumerator (in wstring aWindowType, in boolean aFrontToBack); */
    pub GetZOrderAppWindowEnumerator: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindowType: *const u16, aFrontToBack: bool, _retval: *mut *const nsISimpleEnumerator) -> ::nserror::nsresult,

    /* mozIDOMWindowProxy getMostRecentWindow (in wstring aWindowType); */
    pub GetMostRecentWindow: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindowType: *const u16, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult,

    /* mozIDOMWindowProxy getMostRecentBrowserWindow (); */
    pub GetMostRecentBrowserWindow: unsafe extern "system" fn (this: *const nsIWindowMediator, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult,

    /* mozIDOMWindowProxy getMostRecentNonPBWindow (in wstring aWindowType); */
    pub GetMostRecentNonPBWindow: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindowType: *const u16, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult,

    /* mozIDOMWindowProxy getMostRecentWindowBy (in wstring aWindowType, in uint8_t aFilter); */
    pub GetMostRecentWindowBy: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindowType: *const u16, aFilter: u8, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult,

    /* mozIDOMWindowProxy getOuterWindowWithId (in unsigned long long aOuterWindowID); */
    pub GetOuterWindowWithId: unsafe extern "system" fn (this: *const nsIWindowMediator, aOuterWindowID: u64, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult,

    /* mozIDOMWindow getCurrentInnerWindowWithId (in unsigned long long aInnerWindowID); */
    pub GetCurrentInnerWindowWithId: unsafe extern "system" fn (this: *const nsIWindowMediator, aInnerWindowID: u64, _retval: *mut*const mozIDOMWindow) -> ::nserror::nsresult,

    /* [noscript] void registerWindow (in nsIAppWindow aWindow); */
    pub RegisterWindow: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindow: *const nsIAppWindow) -> ::nserror::nsresult,

    /* [noscript] void unregisterWindow (in nsIAppWindow aWindow); */
    pub UnregisterWindow: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindow: *const nsIAppWindow) -> ::nserror::nsresult,

    /* [noscript] void updateWindowTimeStamp (in nsIAppWindow aWindow); */
    pub UpdateWindowTimeStamp: unsafe extern "system" fn (this: *const nsIWindowMediator, aWindow: *const nsIAppWindow) -> ::nserror::nsresult,

    /* void addListener (in nsIWindowMediatorListener aListener); */
    pub AddListener: unsafe extern "system" fn (this: *const nsIWindowMediator, aListener: *const nsIWindowMediatorListener) -> ::nserror::nsresult,

    /* void removeListener (in nsIWindowMediatorListener aListener); */
    pub RemoveListener: unsafe extern "system" fn (this: *const nsIWindowMediator, aListener: *const nsIWindowMediatorListener) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIWindowMediator {

    /// ```text
    /// /** Return an enumerator which iterates over all windows of type aWindowType
    ///     * from the oldest window to the youngest.
    ///     * @param  aWindowType the returned enumerator will enumerate only
    ///     *                     windows of this type. ("type" is the
        ///     *                     |windowtype| attribute of the XML <window> element.)
    ///     *                     If null, all windows will be enumerated.
    ///     * @return an enumerator of nsIDOMWindows.  Note that windows close
    ///     *         asynchronously in many cases, so windows returned from this
    ///     *         enumerator can have .closed set to true.  Caveat enumerator!
    ///     */
    /// ```
    ///

    /// `nsISimpleEnumerator getEnumerator (in wstring aWindowType);`
    #[inline]
    pub unsafe fn GetEnumerator(&self, aWindowType: *const u16, _retval: *mut *const nsISimpleEnumerator) -> ::nserror::nsresult {
        ((*self.vtable).GetEnumerator)(self, aWindowType, _retval)
    }


    /// ```text
    /// /** Identical to getEnumerator except:
    ///     * @return an enumerator of nsIAppWindows
    ///   */
    /// ```
    ///

    /// `nsISimpleEnumerator getAppWindowEnumerator (in wstring aWindowType);`
    #[inline]
    pub unsafe fn GetAppWindowEnumerator(&self, aWindowType: *const u16, _retval: *mut *const nsISimpleEnumerator) -> ::nserror::nsresult {
        ((*self.vtable).GetAppWindowEnumerator)(self, aWindowType, _retval)
    }


    /// ```text
    /// /** Return an enumerator which iterates over all windows of type aWindowType
    ///     * in their z (front-to-back) order. Note this interface makes
    ///     * no requirement that a window couldn't be revisited if windows
    ///     * are re-ordered while z-order enumerators are active.
    ///     * @param  aWindowType the returned enumerator will enumerate only
    ///     *                     windows of this type. ("type" is the
        ///     *                     |windowtype| attribute of the XML <window> element.)
    ///     *                     If null, all windows will be enumerated.
    ///     * @param  aFrontToBack if true, the enumerator enumerates windows in order
    ///     *                      from front to back. back to front if false.
    ///     * @return an enumerator of nsIAppWindows
    ///     */
    /// ```
    ///

    /// `nsISimpleEnumerator getZOrderAppWindowEnumerator (in wstring aWindowType, in boolean aFrontToBack);`
    #[inline]
    pub unsafe fn GetZOrderAppWindowEnumerator(&self, aWindowType: *const u16, aFrontToBack: bool, _retval: *mut *const nsISimpleEnumerator) -> ::nserror::nsresult {
        ((*self.vtable).GetZOrderAppWindowEnumerator)(self, aWindowType, aFrontToBack, _retval)
    }


    /// ```text
    /// /** This is a shortcut for simply fetching the first window in
    ///     * front to back order.
    ///     * @param  aWindowType return the topmost window of this type.
    ///     *                     ("type" is the |windowtype| attribute of
        ///     *                     the XML <window> element.)
    ///     *                     If null, return the topmost window of any type.
    ///     * @return the topmost window
    ///     */
    /// ```
    ///

    /// `mozIDOMWindowProxy getMostRecentWindow (in wstring aWindowType);`
    #[inline]
    pub unsafe fn GetMostRecentWindow(&self, aWindowType: *const u16, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult {
        ((*self.vtable).GetMostRecentWindow)(self, aWindowType, _retval)
    }


    /// ```text
    /// /** This is a shortcut for getMostRecentWindow('navigator:browser'), but
    ///     * if that fails it also tries 'navigator:geckoview' and 'mail:3pane'.
    ///     *
    ///     * @return the topmost browser window
    ///     */
    /// ```
    ///

    /// `mozIDOMWindowProxy getMostRecentBrowserWindow ();`
    #[inline]
    pub unsafe fn GetMostRecentBrowserWindow(&self, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult {
        ((*self.vtable).GetMostRecentBrowserWindow)(self, _retval)
    }


    /// ```text
    /// /**
    ///    * Same as getMostRecentWindow, but ignores private browsing
    ///    * windows.
    ///    */
    /// ```
    ///

    /// `mozIDOMWindowProxy getMostRecentNonPBWindow (in wstring aWindowType);`
    #[inline]
    pub unsafe fn GetMostRecentNonPBWindow(&self, aWindowType: *const u16, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult {
        ((*self.vtable).GetMostRecentNonPBWindow)(self, aWindowType, _retval)
    }


    /// ```text
    /// /**
    ///    * Same as getMostRecentWindow, but filters out based on the parameter.
    ///    * @param aFilter The value based on the enum WindowMediatorFilter.
    ///    *
    ///    * (Not using WindowMediatorFilter directly it requires [builtinclass])
    ///    */
    /// ```
    ///

    /// `mozIDOMWindowProxy getMostRecentWindowBy (in wstring aWindowType, in uint8_t aFilter);`
    #[inline]
    pub unsafe fn GetMostRecentWindowBy(&self, aWindowType: *const u16, aFilter: u8, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult {
        ((*self.vtable).GetMostRecentWindowBy)(self, aWindowType, aFilter, _retval)
    }


    /// ```text
    /// /**
    ///    * Return the outer window with the given ID, if any.  Can return null.
    ///    */
    /// ```
    ///

    /// `mozIDOMWindowProxy getOuterWindowWithId (in unsigned long long aOuterWindowID);`
    #[inline]
    pub unsafe fn GetOuterWindowWithId(&self, aOuterWindowID: u64, _retval: *mut*const mozIDOMWindowProxy) -> ::nserror::nsresult {
        ((*self.vtable).GetOuterWindowWithId)(self, aOuterWindowID, _retval)
    }


    /// ```text
    /// /**
    ///     * Return the inner window with the given current window ID, if any.
    ///     * Can return null if no inner window with the ID exists or if it's not
    ///     * a current inner anymore.
    ///     */
    /// ```
    ///

    /// `mozIDOMWindow getCurrentInnerWindowWithId (in unsigned long long aInnerWindowID);`
    #[inline]
    pub unsafe fn GetCurrentInnerWindowWithId(&self, aInnerWindowID: u64, _retval: *mut*const mozIDOMWindow) -> ::nserror::nsresult {
        ((*self.vtable).GetCurrentInnerWindowWithId)(self, aInnerWindowID, _retval)
    }


    /// ```text
    /// /** Add the window to the list of known windows. Listeners (see
        ///     * addListener) will be notified through their onOpenWindow method.
    ///     * @param aWindow the window to add
    ///     */
    /// ```
    ///

    /// `[noscript] void registerWindow (in nsIAppWindow aWindow);`
    #[inline]
    pub unsafe fn RegisterWindow(&self, aWindow: *const nsIAppWindow) -> ::nserror::nsresult {
        ((*self.vtable).RegisterWindow)(self, aWindow)
    }


    /// ```text
    /// /** Remove the window from the list of known windows. Listeners (see
        ///     * addListener) will be be notified through their onCloseWindow method.
    ///     * @param aWindow the window to remove
    ///     */
    /// ```
    ///

    /// `[noscript] void unregisterWindow (in nsIAppWindow aWindow);`
    #[inline]
    pub unsafe fn UnregisterWindow(&self, aWindow: *const nsIAppWindow) -> ::nserror::nsresult {
        ((*self.vtable).UnregisterWindow)(self, aWindow)
    }


    /// ```text
    /// /** Call this method when a window gains focus. It's a primitive means of
    ///     * determining the most recent window. It's no longer necessary and it
    ///     * really should be removed.
    ///     * @param aWindow the window which has gained focus
    ///     */
    /// ```
    ///

    /// `[noscript] void updateWindowTimeStamp (in nsIAppWindow aWindow);`
    #[inline]
    pub unsafe fn UpdateWindowTimeStamp(&self, aWindow: *const nsIAppWindow) -> ::nserror::nsresult {
        ((*self.vtable).UpdateWindowTimeStamp)(self, aWindow)
    }


    /// ```text
    /// /** Register a listener for window status changes.
    ///     * keeps strong ref? (to be decided)
    ///     * @param aListener the listener to register
    ///     */
    /// ```
    ///

    /// `void addListener (in nsIWindowMediatorListener aListener);`
    #[inline]
    pub unsafe fn AddListener(&self, aListener: *const nsIWindowMediatorListener) -> ::nserror::nsresult {
        ((*self.vtable).AddListener)(self, aListener)
    }


    /// ```text
    /// /** Unregister a listener of window status changes.
    ///     * @param aListener the listener to unregister
    ///     */
    /// ```
    ///

    /// `void removeListener (in nsIWindowMediatorListener aListener);`
    #[inline]
    pub unsafe fn RemoveListener(&self, aListener: *const nsIWindowMediatorListener) -> ::nserror::nsresult {
        ((*self.vtable).RemoveListener)(self, aListener)
    }


}


