/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef jit_CacheIROpsGenerated_h
#define jit_CacheIROpsGenerated_h

/* This file is generated by jit/GenerateCacheIRFiles.py. Do not edit! */

#define CACHE_IR_OPS(_)\
_(ReturnFromIC, 0, true, 1)\
_(GuardToObject, 1, true, 1)\
_(GuardIsNullOrUndefined, 1, true, 1)\
_(GuardIsNull, 1, true, 1)\
_(GuardIsUndefined, 1, true, 1)\
_(GuardIsNotUninitializedLexical, 1, true, 1)\
_(GuardToBoolean, 1, true, 1)\
_(GuardToString, 1, true, 1)\
_(GuardToSymbol, 1, true, 1)\
_(GuardToBigInt, 1, true, 1)\
_(GuardIsNumber, 1, true, 1)\
_(GuardToInt32, 1, true, 1)\
_(GuardToNonGCThing, 1, true, 1)\
_(GuardBooleanToInt32, 1 + 1, true, 1)\
_(GuardToInt32Index, 1 + 1, true, 1)\
_(Int32ToIntPtr, 1 + 1, true, 1)\
_(GuardNumberToIntPtrIndex, 1 + 1 + 1, true, 2)\
_(GuardToInt32ModUint32, 1 + 1, true, 2)\
_(GuardToUint8Clamped, 1 + 1, true, 2)\
_(GuardNonDoubleType, 1 + 1, true, 1)\
_(GuardShape, 1 + 1, true, 1)\
_(GuardMultipleShapes, 1 + 1, true, 2)\
_(GuardProto, 1 + 1, true, 1)\
_(GuardNullProto, 1, true, 1)\
_(GuardClass, 1 + 1, true, 1)\
_(GuardFuse, 1, true, 1)\
_(GuardRuntimeFuse, 1, true, 1)\
_(GuardObjectFuseProperty, 1 + 1 + 1 + 1 + 1 + 1 + 1, true, 1)\
_(GuardAnyClass, 1 + 1, true, 1)\
_(GuardGlobalGeneration, 1 + 1, true, 1)\
_(HasClassResult, 1 + 1, true, 1)\
_(HasShapeResult, 1 + 1, true, 1)\
_(CallRegExpMatcherResult, 1 + 1 + 1 + 1, true, 5)\
_(CallRegExpSearcherResult, 1 + 1 + 1 + 1, true, 5)\
_(RegExpSearcherLastLimitResult, 0, true, 1)\
_(RegExpHasCaptureGroupsResult, 1 + 1, true, 1)\
_(RegExpBuiltinExecMatchResult, 1 + 1 + 1, true, 5)\
_(RegExpBuiltinExecTestResult, 1 + 1 + 1, true, 5)\
_(RegExpFlagResult, 1 + 4, true, 2)\
_(CallSubstringKernelResult, 1 + 1 + 1, true, 5)\
_(StringReplaceStringResult, 1 + 1 + 1, true, 5)\
_(StringSplitStringResult, 1 + 1, true, 5)\
_(GetFirstDollarIndexResult, 1, true, 5)\
_(GuardCompartment, 1 + 1 + 1, false, 2)\
_(GuardIsExtensible, 1, true, 1)\
_(GuardIsNativeObject, 1, true, 1)\
_(GuardIsProxy, 1, true, 1)\
_(GuardIsNotProxy, 1, true, 1)\
_(GuardToArrayBuffer, 1, true, 1)\
_(GuardToSharedArrayBuffer, 1, true, 1)\
_(GuardIsNotArrayBufferMaybeShared, 1, true, 1)\
_(GuardIsTypedArray, 1, true, 1)\
_(GuardIsNonResizableTypedArray, 1, true, 1)\
_(GuardIsResizableTypedArray, 1, true, 1)\
_(GuardHasProxyHandler, 1 + 1, true, 1)\
_(GuardIsNotDOMProxy, 1, true, 1)\
_(GuardSpecificObject, 1 + 1, true, 1)\
_(GuardObjectIdentity, 1 + 1, true, 1)\
_(GuardSpecificFunction, 1 + 1 + 1, true, 1)\
_(GuardFunctionScript, 1 + 1 + 1, true, 1)\
_(GuardSpecificAtom, 1 + 1, true, 4)\
_(GuardSpecificSymbol, 1 + 1, true, 1)\
_(GuardSpecificInt32, 1 + 4, true, 1)\
_(GuardSpecificValue, 1 + 1, true, 1)\
_(GuardNoDenseElements, 1, true, 1)\
_(GuardStringToIndex, 1 + 1, true, 4)\
_(GuardStringToInt32, 1 + 1, true, 4)\
_(GuardStringToNumber, 1 + 1, true, 4)\
_(StringToAtom, 1, true, 4)\
_(BooleanToNumber, 1 + 1, true, 1)\
_(LoadGetterSetterFunction, 1 + 1 + 1 + 1, true, 1)\
_(GuardHasGetterSetter, 1 + 1 + 1, true, 4)\
_(GuardInt32IsNonNegative, 1, true, 1)\
_(GuardIntPtrIsNonNegative, 1, true, 1)\
_(GuardIndexIsValidUpdateOrAdd, 1 + 1, true, 1)\
_(GuardIndexIsNotDenseElement, 1 + 1, true, 1)\
_(GuardTagNotEqual, 1 + 1, true, 1)\
_(GuardXrayExpandoShapeAndDefaultProto, 1 + 1, false, 2)\
_(GuardXrayNoExpando, 1, false, 2)\
_(GuardDynamicSlotIsSpecificObject, 1 + 1 + 1, true, 1)\
_(GuardDynamicSlotIsNotObject, 1 + 1, true, 1)\
_(GuardFixedSlotValue, 1 + 1 + 1, true, 1)\
_(GuardDynamicSlotValue, 1 + 1 + 1, true, 1)\
_(CheckWeakValueResultForFixedSlot, 1 + 1 + 1, true, 1)\
_(CheckWeakValueResultForDynamicSlot, 1 + 1 + 1, true, 1)\
_(LoadScriptedProxyHandler, 1 + 1, true, 1)\
_(IdToStringOrSymbol, 1 + 1, true, 2)\
_(LoadFixedSlot, 1 + 1 + 1, true, 1)\
_(LoadDynamicSlot, 1 + 1 + 1, true, 1)\
_(GuardNoAllocationMetadataBuilder, 1, true, 1)\
_(GuardFunctionHasJitEntry, 1, true, 1)\
_(GuardFunctionHasNoJitEntry, 1, true, 1)\
_(GuardFunctionIsNonBuiltinCtor, 1, true, 1)\
_(GuardFunctionIsConstructor, 1, true, 1)\
_(GuardNotClassConstructor, 1, true, 1)\
_(GuardArrayIsPacked, 1, true, 1)\
_(GuardArgumentsObjectFlags, 1 + 1, true, 1)\
_(GuardObjectHasSameRealm, 1, true, 1)\
_(LoadObject, 1 + 1, true, 1)\
_(LoadProtoObject, 1 + 1 + 1, true, 1)\
_(LoadProto, 1 + 1, true, 1)\
_(LoadEnclosingEnvironment, 1 + 1, true, 1)\
_(LoadWrapperTarget, 1 + 1 + 1, true, 1)\
_(LoadValueTag, 1 + 1, true, 1)\
_(LoadArgumentFixedSlot, 1 + 1, true, 1)\
_(LoadArgumentDynamicSlot, 1 + 1 + 1, true, 1)\
_(TruncateDoubleToUInt32, 1 + 1, true, 4)\
_(DoubleToUint8Clamped, 1 + 1, true, 2)\
_(MegamorphicLoadSlotResult, 1 + 1, true, 4)\
_(MegamorphicLoadSlotByValueResult, 1 + 1, true, 4)\
_(MegamorphicLoadSlotPermissiveResult, 1 + 1, true, 4)\
_(MegamorphicLoadSlotByValuePermissiveResult, 1 + 1, true, 4)\
_(MegamorphicStoreSlot, 1 + 1 + 1 + 1, true, 5)\
_(MegamorphicSetElement, 1 + 1 + 1 + 1, true, 5)\
_(MegamorphicHasPropResult, 1 + 1 + 1, true, 4)\
_(SmallObjectVariableKeyHasOwnResult, 1 + 1 + 1, true, 4)\
_(ObjectToIteratorResult, 1 + 1, true, 5)\
_(ValueToIteratorResult, 1, true, 5)\
_(LoadDOMExpandoValue, 1 + 1, true, 1)\
_(LoadDOMExpandoValueGuardGeneration, 1 + 1 + 1 + 1, true, 2)\
_(LoadDOMExpandoValueIgnoreGeneration, 1 + 1, true, 1)\
_(GuardDOMExpandoMissingOrGuardShape, 1 + 1, true, 2)\
_(StoreFixedSlot, 1 + 1 + 1, true, 6)\
_(StoreDynamicSlot, 1 + 1 + 1, true, 6)\
_(AddAndStoreFixedSlot, 1 + 1 + 1 + 1 + 1, true, 6)\
_(AddAndStoreDynamicSlot, 1 + 1 + 1 + 1 + 1, true, 6)\
_(AllocateAndStoreDynamicSlot, 1 + 1 + 1 + 1 + 1 + 1, true, 6)\
_(AddSlotAndCallAddPropHook, 1 + 1 + 1, true, 6)\
_(StoreDenseElement, 1 + 1 + 1 + 1, true, 6)\
_(StoreDenseElementHole, 1 + 1 + 1 + 1, true, 6)\
_(ArrayPush, 1 + 1, true, 6)\
_(ArrayJoinResult, 1 + 1, true, 5)\
_(ObjectKeysResult, 1 + 1, true, 6)\
_(PackedArrayPopResult, 1, true, 2)\
_(PackedArrayShiftResult, 1, true, 4)\
_(PackedArraySliceResult, 1 + 1 + 1 + 1, true, 5)\
_(ArgumentsSliceResult, 1 + 1 + 1 + 1, true, 5)\
_(IsArrayResult, 1, true, 5)\
_(StoreFixedSlotUndefinedResult, 1 + 1 + 1, true, 4294967295)\
_(IsObjectResult, 1, true, 1)\
_(IsPackedArrayResult, 1, true, 2)\
_(IsCallableResult, 1, true, 4)\
_(IsConstructorResult, 1, true, 4)\
_(IsCrossRealmArrayConstructorResult, 1, true, 2)\
_(IsTypedArrayResult, 1 + 1, true, 5)\
_(IsTypedArrayConstructorResult, 1, true, 2)\
_(ArrayBufferViewByteOffsetInt32Result, 1, true, 1)\
_(ArrayBufferViewByteOffsetDoubleResult, 1, true, 1)\
_(TypedArrayByteLengthInt32Result, 1, true, 2)\
_(TypedArrayByteLengthDoubleResult, 1, true, 2)\
_(ResizableTypedArrayByteLengthInt32Result, 1, true, 2)\
_(ResizableTypedArrayByteLengthDoubleResult, 1, true, 2)\
_(ResizableTypedArrayLengthInt32Result, 1, true, 2)\
_(ResizableTypedArrayLengthDoubleResult, 1, true, 2)\
_(ResizableDataViewByteLengthInt32Result, 1, true, 2)\
_(ResizableDataViewByteLengthDoubleResult, 1, true, 2)\
_(GrowableSharedArrayBufferByteLengthInt32Result, 1, true, 2)\
_(GrowableSharedArrayBufferByteLengthDoubleResult, 1, true, 2)\
_(GuardHasAttachedArrayBuffer, 1, true, 2)\
_(GuardResizableArrayBufferViewInBounds, 1, true, 2)\
_(GuardResizableArrayBufferViewInBoundsOrDetached, 1, true, 2)\
_(TypedArrayFillResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(TypedArraySetResult, 1 + 1 + 1 + 1, true, 4)\
_(TypedArraySubarrayResult, 1 + 1 + 1 + 1, true, 5)\
_(NewArrayIteratorResult, 1, true, 5)\
_(NewStringIteratorResult, 1, true, 5)\
_(NewRegExpStringIteratorResult, 1, true, 5)\
_(ObjectCreateResult, 1, true, 5)\
_(NewArrayFromLengthResult, 1 + 1 + 1, true, 5)\
_(NewTypedArrayFromLengthResult, 1 + 1, true, 5)\
_(NewTypedArrayFromArrayBufferResult, 1 + 1 + 1 + 1, true, 5)\
_(NewTypedArrayFromArrayResult, 1 + 1, true, 5)\
_(NewMapObjectResult, 1, true, 5)\
_(NewSetObjectResult, 1, true, 5)\
_(NewMapObjectFromIterableResult, 1 + 1, true, 5)\
_(NewSetObjectFromIterableResult, 1 + 1, true, 5)\
_(NewStringObjectResult, 1 + 1, true, 5)\
_(StringFromCharCodeResult, 1, true, 5)\
_(StringFromCodePointResult, 1, true, 5)\
_(StringIncludesResult, 1 + 1, true, 5)\
_(StringIndexOfResult, 1 + 1, true, 5)\
_(StringLastIndexOfResult, 1 + 1, true, 5)\
_(StringStartsWithResult, 1 + 1, true, 5)\
_(StringEndsWithResult, 1 + 1, true, 5)\
_(StringToLowerCaseResult, 1, true, 5)\
_(StringToUpperCaseResult, 1, true, 5)\
_(StringTrimResult, 1, true, 5)\
_(StringTrimStartResult, 1, true, 5)\
_(StringTrimEndResult, 1, true, 5)\
_(MathAbsInt32Result, 1, true, 2)\
_(MathAbsNumberResult, 1, true, 1)\
_(MathClz32Result, 1, true, 1)\
_(MathSignInt32Result, 1, true, 1)\
_(MathSignNumberResult, 1, true, 2)\
_(MathSignNumberToInt32Result, 1, true, 2)\
_(MathImulResult, 1 + 1, true, 1)\
_(MathSqrtNumberResult, 1, true, 1)\
_(MathFRoundNumberResult, 1, true, 1)\
_(MathF16RoundNumberResult, 1, true, 4)\
_(MathRandomResult, 1, true, 3)\
_(MathHypot2NumberResult, 1 + 1, true, 4)\
_(MathHypot3NumberResult, 1 + 1 + 1, true, 4)\
_(MathHypot4NumberResult, 1 + 1 + 1 + 1, true, 4)\
_(MathAtan2NumberResult, 1 + 1, true, 4)\
_(MathFloorNumberResult, 1, true, 4)\
_(MathCeilNumberResult, 1, true, 4)\
_(MathTruncNumberResult, 1, true, 4)\
_(MathRoundNumberResult, 1, true, 4)\
_(MathFloorToInt32Result, 1, true, 3)\
_(MathCeilToInt32Result, 1, true, 1)\
_(MathTruncToInt32Result, 1, true, 4294967295)\
_(MathRoundToInt32Result, 1, true, 1)\
_(Int32MinMax, 1 + 1 + 1 + 1, true, 1)\
_(NumberMinMax, 1 + 1 + 1 + 1, true, 1)\
_(Int32MinMaxArrayResult, 1 + 1, true, 3)\
_(NumberMinMaxArrayResult, 1 + 1, true, 3)\
_(MathFunctionNumberResult, 1 + 1, true, 4)\
_(NumberParseIntResult, 1 + 1, true, 5)\
_(DoubleParseIntResult, 1, true, 2)\
_(ObjectToStringResult, 1, true, 4)\
_(ReflectGetPrototypeOfResult, 1, true, 5)\
_(StoreTypedArrayElement, 1 + 1 + 1 + 1 + 1 + 1, true, 3)\
_(AtomicsCompareExchangeResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsExchangeResult, 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsAddResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsSubResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsAndResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsOrResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsXorResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(AtomicsLoadResult, 1 + 1 + 1 + 1, true, 2)\
_(AtomicsStoreResult, 1 + 1 + 1 + 1 + 1, true, 2)\
_(AtomicsIsLockFreeResult, 1, true, 1)\
_(AtomicsPauseResult, 0, true, 1)\
_(CallNativeSetter, 1 + 1 + 1 + 1 + 1, true, 5)\
_(CallScriptedSetter, 1 + 1 + 1 + 1 + 1, true, 3)\
_(CallInlinedSetter, 1 + 1 + 1 + 1 + 1 + 1, true, 3)\
_(CallDOMSetter, 1 + 1 + 1, true, 4)\
_(CallSetArrayLength, 1 + 1 + 1, true, 5)\
_(ProxySet, 1 + 1 + 1 + 1, true, 5)\
_(ProxySetByValue, 1 + 1 + 1 + 1, true, 5)\
_(CallAddOrUpdateSparseElementHelper, 1 + 1 + 1 + 1, true, 5)\
_(CallInt32ToString, 1 + 1, true, 4)\
_(CallNumberToString, 1 + 1, true, 4)\
_(Int32ToStringWithBaseResult, 1 + 1, true, 3)\
_(BooleanToString, 1 + 1, true, 2)\
_(CallScriptedFunction, 1 + 1 + 1 + 4, true, 3)\
_(CallBoundScriptedFunction, 1 + 1 + 1 + 1 + 4, true, 3)\
_(CallWasmFunction, 1 + 1 + 1 + 4 + 1 + 1, true, 3)\
_(GuardWasmArg, 1 + 1, true, 2)\
_(CallNativeFunction, 1 + 1 + 1 + 4 + 1, true, 4)\
_(CallDOMFunction, 1 + 1 + 1 + 1 + 4, true, 4)\
_(CallDOMFunctionWithAllocSite, 1 + 1 + 1 + 1 + 4 + 1, true, 4)\
_(CallClassHook, 1 + 1 + 1 + 4 + 1, true, 4)\
_(CallInlinedFunction, 1 + 1 + 1 + 1 + 4, true, 4)\
_(CallScriptedProxyGetResult, 1 + 1 + 1 + 1 + 1 + 4, true, 4)\
_(CallScriptedProxyGetByValueResult, 1 + 1 + 1 + 1 + 1 + 4, true, 4)\
_(MetaScriptedThisShape, 1, true, 0)\
_(BindFunctionResult, 1 + 4 + 1, true, 5)\
_(SpecializedBindFunctionResult, 1 + 4 + 1, true, 4)\
_(LoadFixedSlotResult, 1 + 1, true, 1)\
_(LoadFixedSlotTypedResult, 1 + 1 + 1, true, 1)\
_(LoadDynamicSlotResult, 1 + 1, true, 1)\
_(LoadDenseElementResult, 1 + 1 + 1, true, 2)\
_(LoadDenseElementHoleResult, 1 + 1, true, 2)\
_(CallGetSparseElementResult, 1 + 1, true, 5)\
_(LoadDenseElementExistsResult, 1 + 1, true, 1)\
_(LoadTypedArrayElementExistsResult, 1 + 1 + 1, true, 2)\
_(LoadDenseElementHoleExistsResult, 1 + 1, true, 2)\
_(LoadTypedArrayElementResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(LoadDataViewValueResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(StoreDataViewValueResult, 1 + 1 + 1 + 1 + 1 + 1, true, 4)\
_(LoadInt32ArrayLengthResult, 1, true, 1)\
_(LoadInt32ArrayLength, 1 + 1, true, 1)\
_(LoadArgumentsObjectArgResult, 1 + 1, true, 2)\
_(LoadArgumentsObjectArgHoleResult, 1 + 1, true, 2)\
_(LoadArgumentsObjectArgExistsResult, 1 + 1, true, 2)\
_(LoadArgumentsObjectLengthResult, 1, true, 1)\
_(LoadArgumentsObjectLength, 1 + 1, true, 1)\
_(LoadFunctionLengthResult, 1, true, 2)\
_(LoadFunctionNameResult, 1, true, 2)\
_(LoadBoundFunctionNumArgs, 1 + 1, true, 1)\
_(LoadBoundFunctionTarget, 1 + 1, true, 1)\
_(LoadBoundFunctionArgument, 1 + 4 + 1, true, 2)\
_(GuardBoundFunctionIsConstructor, 1, true, 1)\
_(LoadArrayBufferByteLengthInt32Result, 1, true, 1)\
_(LoadArrayBufferByteLengthDoubleResult, 1, true, 1)\
_(LoadArrayBufferViewLengthInt32Result, 1, true, 1)\
_(LoadArrayBufferViewLengthDoubleResult, 1, true, 1)\
_(LoadArrayBufferViewLength, 1 + 1, true, 1)\
_(LinearizeForCharAccess, 1 + 1 + 1, true, 4)\
_(LinearizeForCodePointAccess, 1 + 1 + 1, true, 4)\
_(ToRelativeStringIndex, 1 + 1 + 1, true, 1)\
_(LoadStringCharResult, 1 + 1 + 1, true, 5)\
_(LoadStringAtResult, 1 + 1 + 1, true, 5)\
_(LoadStringCharCodeResult, 1 + 1 + 1, true, 3)\
_(LoadStringCodePointResult, 1 + 1 + 1, true, 3)\
_(LoadStringLengthResult, 1, true, 1)\
_(FrameIsConstructingResult, 0, true, 1)\
_(LoadObjectResult, 1, true, 1)\
_(LoadStringResult, 1, true, 1)\
_(LoadSymbolResult, 1, true, 1)\
_(LoadInt32Result, 1, true, 1)\
_(LoadDoubleResult, 1, true, 2)\
_(LoadBigIntResult, 1, true, 1)\
_(CallScriptedGetterResult, 1 + 1 + 1 + 1, true, 5)\
_(CallInlinedGetterResult, 1 + 1 + 1 + 1 + 1, true, 5)\
_(CallNativeGetterResult, 1 + 1 + 1 + 1, true, 5)\
_(CallDOMGetterResult, 1 + 1, true, 4)\
_(ProxyGetResult, 1 + 1, true, 5)\
_(ProxyGetByValueResult, 1 + 1, true, 5)\
_(ProxyHasPropResult, 1 + 1 + 1, true, 5)\
_(CallObjectHasSparseElementResult, 1 + 1, true, 4)\
_(CallNativeGetElementResult, 1 + 1, true, 5)\
_(CallNativeGetElementSuperResult, 1 + 1 + 1, true, 5)\
_(GetNextMapSetEntryForIteratorResult, 1 + 1 + 1, true, 4)\
_(LoadUndefinedResult, 0, true, 1)\
_(LoadBooleanResult, 1, true, 1)\
_(LoadInt32Constant, 1 + 1, true, 1)\
_(LoadInt32AsIntPtrConstant, 1 + 1, true, 1)\
_(LoadDoubleConstant, 1 + 1, true, 1)\
_(LoadBooleanConstant, 1 + 1, true, 1)\
_(LoadUndefined, 1, true, 1)\
_(LoadConstantString, 1 + 1, true, 1)\
_(LoadConstantStringResult, 1, true, 1)\
_(LoadInstanceOfObjectResult, 1 + 1, true, 3)\
_(LoadTypeOfObjectResult, 1, true, 4)\
_(LoadTypeOfEqObjectResult, 1 + 1, true, 4)\
_(DoubleAddResult, 1 + 1, true, 2)\
_(DoubleSubResult, 1 + 1, true, 2)\
_(DoubleMulResult, 1 + 1, true, 2)\
_(DoubleDivResult, 1 + 1, true, 2)\
_(DoubleModResult, 1 + 1, true, 4)\
_(DoublePowResult, 1 + 1, true, 4)\
_(Int32AddResult, 1 + 1, true, 1)\
_(Int32SubResult, 1 + 1, true, 1)\
_(Int32MulResult, 1 + 1, true, 2)\
_(Int32DivResult, 1 + 1, true, 2)\
_(Int32ModResult, 1 + 1, true, 2)\
_(Int32PowResult, 1 + 1, true, 1)\
_(BigIntAddResult, 1 + 1, true, 5)\
_(BigIntSubResult, 1 + 1, true, 5)\
_(BigIntMulResult, 1 + 1, true, 5)\
_(BigIntDivResult, 1 + 1, true, 5)\
_(BigIntModResult, 1 + 1, true, 5)\
_(BigIntPowResult, 1 + 1, true, 5)\
_(BigIntToIntPtr, 1 + 1, true, 1)\
_(IntPtrToBigIntResult, 1, true, 5)\
_(BigIntPtrAdd, 1 + 1 + 1, true, 1)\
_(BigIntPtrSub, 1 + 1 + 1, true, 1)\
_(BigIntPtrMul, 1 + 1 + 1, true, 1)\
_(BigIntPtrDiv, 1 + 1 + 1, true, 1)\
_(BigIntPtrMod, 1 + 1 + 1, true, 1)\
_(BigIntPtrPow, 1 + 1 + 1, true, 2)\
_(Int32BitOrResult, 1 + 1, true, 1)\
_(Int32BitXorResult, 1 + 1, true, 1)\
_(Int32BitAndResult, 1 + 1, true, 1)\
_(Int32LeftShiftResult, 1 + 1, true, 1)\
_(Int32RightShiftResult, 1 + 1, true, 1)\
_(Int32URightShiftResult, 1 + 1 + 1, true, 2)\
_(Int32NotResult, 1, true, 1)\
_(BigIntBitOrResult, 1 + 1, true, 5)\
_(BigIntBitXorResult, 1 + 1, true, 5)\
_(BigIntBitAndResult, 1 + 1, true, 5)\
_(BigIntLeftShiftResult, 1 + 1, true, 5)\
_(BigIntRightShiftResult, 1 + 1, true, 5)\
_(BigIntNotResult, 1, true, 5)\
_(BigIntPtrBitOr, 1 + 1 + 1, true, 1)\
_(BigIntPtrBitXor, 1 + 1 + 1, true, 1)\
_(BigIntPtrBitAnd, 1 + 1 + 1, true, 1)\
_(BigIntPtrLeftShift, 1 + 1 + 1, true, 3)\
_(BigIntPtrRightShift, 1 + 1 + 1, true, 3)\
_(BigIntPtrNot, 1 + 1, true, 1)\
_(Int32NegationResult, 1, true, 1)\
_(DoubleNegationResult, 1, true, 1)\
_(BigIntNegationResult, 1, true, 5)\
_(BigIntPtrNegation, 1 + 1, true, 1)\
_(Int32IncResult, 1, true, 1)\
_(Int32DecResult, 1, true, 1)\
_(DoubleIncResult, 1, true, 1)\
_(DoubleDecResult, 1, true, 1)\
_(BigIntIncResult, 1, true, 5)\
_(BigIntDecResult, 1, true, 5)\
_(BigIntPtrInc, 1 + 1, true, 1)\
_(BigIntPtrDec, 1 + 1, true, 1)\
_(LoadInt32TruthyResult, 1, true, 2)\
_(LoadDoubleTruthyResult, 1, true, 2)\
_(LoadStringTruthyResult, 1, true, 2)\
_(LoadObjectTruthyResult, 1, true, 4)\
_(LoadBigIntTruthyResult, 1, true, 2)\
_(LoadValueTruthyResult, 1, true, 4)\
_(LoadValueResult, 1, true, 1)\
_(UncheckedLoadWeakValueResult, 1, true, 1)\
_(UncheckedLoadWeakObjectResult, 1, true, 1)\
_(LoadOperandResult, 1, true, 1)\
_(NewPlainObjectResult, 4 + 4 + 1 + 1 + 1, true, 4)\
_(NewArrayObjectResult, 4 + 1 + 1, true, 4)\
_(NewFunctionCloneResult, 1 + 1 + 1, true, 4)\
_(ConcatStringsResult, 1 + 1 + 1, true, 5)\
_(CallStringObjectConcatResult, 1 + 1, false, 5)\
_(CallIsSuspendedGeneratorResult, 1, false, 2)\
_(CompareStringResult, 1 + 1 + 1, true, 5)\
_(CompareObjectResult, 1 + 1 + 1, true, 2)\
_(CompareSymbolResult, 1 + 1 + 1, true, 2)\
_(CompareInt32Result, 1 + 1 + 1, true, 2)\
_(CompareDoubleResult, 1 + 1 + 1, true, 2)\
_(CompareBigIntResult, 1 + 1 + 1, true, 4)\
_(CompareBigIntInt32Result, 1 + 1 + 1, true, 3)\
_(CompareBigIntNumberResult, 1 + 1 + 1, true, 4)\
_(CompareBigIntStringResult, 1 + 1 + 1, true, 5)\
_(CompareNullUndefinedResult, 1 + 1 + 1, true, 2)\
_(CompareDoubleSameValueResult, 1 + 1, true, 3)\
_(SameValueResult, 1 + 1, true, 4)\
_(IndirectTruncateInt32Result, 1, true, 1)\
_(BigIntAsIntNResult, 1 + 1, true, 5)\
_(BigIntAsUintNResult, 1 + 1, true, 5)\
_(SetHasResult, 1 + 1, true, 5)\
_(SetHasNonGCThingResult, 1 + 1, true, 3)\
_(SetHasStringResult, 1 + 1, true, 5)\
_(SetHasSymbolResult, 1 + 1, true, 3)\
_(SetHasBigIntResult, 1 + 1, true, 3)\
_(SetHasObjectResult, 1 + 1, true, 3)\
_(SetDeleteResult, 1 + 1, true, 5)\
_(SetAddResult, 1 + 1, true, 5)\
_(SetSizeResult, 1, true, 1)\
_(MapHasResult, 1 + 1, true, 5)\
_(MapHasNonGCThingResult, 1 + 1, true, 3)\
_(MapHasStringResult, 1 + 1, true, 5)\
_(MapHasSymbolResult, 1 + 1, true, 3)\
_(MapHasBigIntResult, 1 + 1, true, 3)\
_(MapHasObjectResult, 1 + 1, true, 3)\
_(MapGetResult, 1 + 1, true, 5)\
_(MapGetNonGCThingResult, 1 + 1, true, 3)\
_(MapGetStringResult, 1 + 1, true, 5)\
_(MapGetSymbolResult, 1 + 1, true, 3)\
_(MapGetBigIntResult, 1 + 1, true, 3)\
_(MapGetObjectResult, 1 + 1, true, 3)\
_(MapDeleteResult, 1 + 1, true, 5)\
_(MapSetResult, 1 + 1 + 1, true, 5)\
_(MapSizeResult, 1, true, 1)\
_(WeakMapGetObjectResult, 1 + 1, true, 3)\
_(WeakMapHasObjectResult, 1 + 1, true, 3)\
_(WeakSetHasObjectResult, 1 + 1, true, 3)\
_(DateFillLocalTimeSlots, 1, true, 4)\
_(DateHoursFromSecondsIntoYearResult, 1, true, 2)\
_(DateMinutesFromSecondsIntoYearResult, 1, true, 2)\
_(DateSecondsFromSecondsIntoYearResult, 1, true, 2)\
_(ArrayFromArgumentsObjectResult, 1 + 1, true, 5)\
_(CloseIterScriptedResult, 1 + 1 + 1 + 4, true, 5)\
_(CallPrintString, sizeof(uintptr_t), false, 1)\
_(Breakpoint, 0, false, 1)\
_(WrapResult, 0, false, 4)\
_(Bailout, 0, true, 0)\
_(AssertFloat32Result, 1 + 1, true, 1)\
_(AssertRecoveredOnBailoutResult, 1 + 1, true, 1)\
_(AssertPropertyLookup, 1 + 1 + 1, true, 4)

#define CACHE_IR_WRITER_GENERATED \
void returnFromIC() {\
  writeOp(CacheOp::ReturnFromIC);\
  assertLengthMatches();\
}\
private:\
void guardToObject_(ValOperandId input) {\
  writeOp(CacheOp::GuardToObject);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
void guardIsNullOrUndefined(ValOperandId input) {\
  writeOp(CacheOp::GuardIsNullOrUndefined);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void guardIsNull(ValOperandId input) {\
  writeOp(CacheOp::GuardIsNull);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void guardIsUndefined(ValOperandId input) {\
  writeOp(CacheOp::GuardIsUndefined);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void guardIsNotUninitializedLexical(ValOperandId val) {\
  writeOp(CacheOp::GuardIsNotUninitializedLexical);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
private:\
void guardToBoolean_(ValOperandId input) {\
  writeOp(CacheOp::GuardToBoolean);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToString_(ValOperandId input) {\
  writeOp(CacheOp::GuardToString);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToSymbol_(ValOperandId input) {\
  writeOp(CacheOp::GuardToSymbol);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToBigInt_(ValOperandId input) {\
  writeOp(CacheOp::GuardToBigInt);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardIsNumber_(ValOperandId input) {\
  writeOp(CacheOp::GuardIsNumber);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
private:\
void guardToInt32_(ValOperandId input) {\
  writeOp(CacheOp::GuardToInt32);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
public:\
void guardToNonGCThing(ValOperandId input) {\
  writeOp(CacheOp::GuardToNonGCThing);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
Int32OperandId guardBooleanToInt32(ValOperandId input) {\
  writeOp(CacheOp::GuardBooleanToInt32);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardToInt32Index(ValOperandId input) {\
  writeOp(CacheOp::GuardToInt32Index);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId int32ToIntPtr(Int32OperandId input) {\
  writeOp(CacheOp::Int32ToIntPtr);\
  writeOperandId(input);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId guardNumberToIntPtrIndex(NumberOperandId input, bool supportOOB) {\
  writeOp(CacheOp::GuardNumberToIntPtrIndex);\
  writeOperandId(input);\
  writeBoolImm(supportOOB);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardToInt32ModUint32(ValOperandId input) {\
  writeOp(CacheOp::GuardToInt32ModUint32);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardToUint8Clamped(ValOperandId input) {\
  writeOp(CacheOp::GuardToUint8Clamped);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void guardNonDoubleType(ValOperandId input, ValueType type) {\
  writeOp(CacheOp::GuardNonDoubleType);\
  writeOperandId(input);\
  writeValueTypeImm(type);\
  assertLengthMatches();\
}\
void guardShape(ObjOperandId obj, Shape* shape) {\
  writeOp(CacheOp::GuardShape);\
  writeOperandId(obj);\
  writeWeakShapeField(shape);\
  assertLengthMatches();\
}\
private:\
void guardMultipleShapes_(ObjOperandId obj, JSObject* shapes) {\
  writeOp(CacheOp::GuardMultipleShapes);\
  writeOperandId(obj);\
  writeObjectField(shapes);\
  assertLengthMatches();\
}\
public:\
void guardProto(ObjOperandId obj, JSObject* proto) {\
  writeOp(CacheOp::GuardProto);\
  writeOperandId(obj);\
  writeWeakObjectField(proto);\
  assertLengthMatches();\
}\
void guardNullProto(ObjOperandId obj) {\
  writeOp(CacheOp::GuardNullProto);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardClass(ObjOperandId obj, GuardClassKind kind) {\
  writeOp(CacheOp::GuardClass);\
  writeOperandId(obj);\
  writeGuardClassKindImm(kind);\
  assertLengthMatches();\
}\
void guardFuse(RealmFuses::FuseIndex fuseWord) {\
  writeOp(CacheOp::GuardFuse);\
  writeRealmFuseIndexImm(fuseWord);\
  assertLengthMatches();\
}\
void guardRuntimeFuse(RuntimeFuses::FuseIndex fuseWord) {\
  writeOp(CacheOp::GuardRuntimeFuse);\
  writeRuntimeFuseIndexImm(fuseWord);\
  assertLengthMatches();\
}\
void guardObjectFuseProperty(ObjOperandId obj, JSObject* objFuseOwner, const void* objFuse, uint32_t expectedGeneration, uint32_t propIndex, uint32_t propMask, bool canUseFastPath) {\
  writeOp(CacheOp::GuardObjectFuseProperty);\
  writeOperandId(obj);\
  writeWeakObjectField(objFuseOwner);\
  writeRawPointerField(objFuse);\
  writeRawInt32Field(expectedGeneration);\
  writeRawInt32Field(propIndex);\
  writeRawInt32Field(propMask);\
  writeBoolImm(canUseFastPath);\
  assertLengthMatches();\
}\
void guardAnyClass(ObjOperandId obj, const void* clasp) {\
  writeOp(CacheOp::GuardAnyClass);\
  writeOperandId(obj);\
  writeRawPointerField(clasp);\
  assertLengthMatches();\
}\
void guardGlobalGeneration(uint32_t expected, const void* generationAddr) {\
  writeOp(CacheOp::GuardGlobalGeneration);\
  writeRawInt32Field(expected);\
  writeRawPointerField(generationAddr);\
  assertLengthMatches();\
}\
void hasClassResult(ObjOperandId obj, const void* clasp) {\
  writeOp(CacheOp::HasClassResult);\
  writeOperandId(obj);\
  writeRawPointerField(clasp);\
  assertLengthMatches();\
}\
void hasShapeResult(ObjOperandId obj, Shape* shape) {\
  writeOp(CacheOp::HasShapeResult);\
  writeOperandId(obj);\
  writeShapeField(shape);\
  assertLengthMatches();\
}\
void callRegExpMatcherResult(ObjOperandId regexp, StringOperandId input, Int32OperandId lastIndex, JitCode* stub) {\
  writeOp(CacheOp::CallRegExpMatcherResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  writeOperandId(lastIndex);\
  writeJitCodeField(stub);\
  assertLengthMatches();\
}\
void callRegExpSearcherResult(ObjOperandId regexp, StringOperandId input, Int32OperandId lastIndex, JitCode* stub) {\
  writeOp(CacheOp::CallRegExpSearcherResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  writeOperandId(lastIndex);\
  writeJitCodeField(stub);\
  assertLengthMatches();\
}\
void regExpSearcherLastLimitResult() {\
  writeOp(CacheOp::RegExpSearcherLastLimitResult);\
  assertLengthMatches();\
}\
void regExpHasCaptureGroupsResult(ObjOperandId regexp, StringOperandId input) {\
  writeOp(CacheOp::RegExpHasCaptureGroupsResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void regExpBuiltinExecMatchResult(ObjOperandId regexp, StringOperandId input, JitCode* stub) {\
  writeOp(CacheOp::RegExpBuiltinExecMatchResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  writeJitCodeField(stub);\
  assertLengthMatches();\
}\
void regExpBuiltinExecTestResult(ObjOperandId regexp, StringOperandId input, JitCode* stub) {\
  writeOp(CacheOp::RegExpBuiltinExecTestResult);\
  writeOperandId(regexp);\
  writeOperandId(input);\
  writeJitCodeField(stub);\
  assertLengthMatches();\
}\
void regExpFlagResult(ObjOperandId regexp, int32_t flagsMask) {\
  writeOp(CacheOp::RegExpFlagResult);\
  writeOperandId(regexp);\
  writeInt32Imm(flagsMask);\
  assertLengthMatches();\
}\
void callSubstringKernelResult(StringOperandId str, Int32OperandId begin, Int32OperandId length) {\
  writeOp(CacheOp::CallSubstringKernelResult);\
  writeOperandId(str);\
  writeOperandId(begin);\
  writeOperandId(length);\
  assertLengthMatches();\
}\
void stringReplaceStringResult(StringOperandId str, StringOperandId pattern, StringOperandId replacement) {\
  writeOp(CacheOp::StringReplaceStringResult);\
  writeOperandId(str);\
  writeOperandId(pattern);\
  writeOperandId(replacement);\
  assertLengthMatches();\
}\
void stringSplitStringResult(StringOperandId str, StringOperandId separator) {\
  writeOp(CacheOp::StringSplitStringResult);\
  writeOperandId(str);\
  writeOperandId(separator);\
  assertLengthMatches();\
}\
void getFirstDollarIndexResult(StringOperandId str) {\
  writeOp(CacheOp::GetFirstDollarIndexResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void guardCompartment(ObjOperandId obj, JSObject* global, const void* compartment) {\
  writeOp(CacheOp::GuardCompartment);\
  writeOperandId(obj);\
  writeObjectField(global);\
  writeRawPointerField(compartment);\
  assertLengthMatches();\
}\
void guardIsExtensible(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsExtensible);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsNativeObject(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNativeObject);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsProxy(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsProxy);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsNotProxy(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNotProxy);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardToArrayBuffer(ObjOperandId obj) {\
  writeOp(CacheOp::GuardToArrayBuffer);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardToSharedArrayBuffer(ObjOperandId obj) {\
  writeOp(CacheOp::GuardToSharedArrayBuffer);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsNotArrayBufferMaybeShared(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNotArrayBufferMaybeShared);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsTypedArray(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsTypedArray);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsNonResizableTypedArray(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNonResizableTypedArray);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardIsResizableTypedArray(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsResizableTypedArray);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardHasProxyHandler(ObjOperandId obj, const void* handler) {\
  writeOp(CacheOp::GuardHasProxyHandler);\
  writeOperandId(obj);\
  writeRawPointerField(handler);\
  assertLengthMatches();\
}\
void guardIsNotDOMProxy(ObjOperandId obj) {\
  writeOp(CacheOp::GuardIsNotDOMProxy);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardSpecificObject(ObjOperandId obj, JSObject* expected) {\
  writeOp(CacheOp::GuardSpecificObject);\
  writeOperandId(obj);\
  writeWeakObjectField(expected);\
  assertLengthMatches();\
}\
void guardObjectIdentity(ObjOperandId obj1, ObjOperandId obj2) {\
  writeOp(CacheOp::GuardObjectIdentity);\
  writeOperandId(obj1);\
  writeOperandId(obj2);\
  assertLengthMatches();\
}\
private:\
void guardSpecificFunction_(ObjOperandId fun, JSObject* expected, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::GuardSpecificFunction);\
  writeOperandId(fun);\
  writeWeakObjectField(expected);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void guardFunctionScript_(ObjOperandId obj, BaseScript* expected, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::GuardFunctionScript);\
  writeOperandId(obj);\
  writeWeakBaseScriptField(expected);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
void guardSpecificAtom(StringOperandId str, JSAtom* expected) {\
  writeOp(CacheOp::GuardSpecificAtom);\
  writeOperandId(str);\
  writeStringField(expected);\
  assertLengthMatches();\
}\
void guardSpecificSymbol(SymbolOperandId sym, JS::Symbol* expected) {\
  writeOp(CacheOp::GuardSpecificSymbol);\
  writeOperandId(sym);\
  writeSymbolField(expected);\
  assertLengthMatches();\
}\
void guardSpecificInt32(Int32OperandId num, int32_t expected) {\
  writeOp(CacheOp::GuardSpecificInt32);\
  writeOperandId(num);\
  writeInt32Imm(expected);\
  assertLengthMatches();\
}\
void guardSpecificValue(ValOperandId val, const Value& expected) {\
  writeOp(CacheOp::GuardSpecificValue);\
  writeOperandId(val);\
  writeValueField(expected);\
  assertLengthMatches();\
}\
void guardNoDenseElements(ObjOperandId obj) {\
  writeOp(CacheOp::GuardNoDenseElements);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
Int32OperandId guardStringToIndex(StringOperandId str) {\
  writeOp(CacheOp::GuardStringToIndex);\
  writeOperandId(str);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId guardStringToInt32(StringOperandId str) {\
  writeOp(CacheOp::GuardStringToInt32);\
  writeOperandId(str);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
NumberOperandId guardStringToNumber(StringOperandId str) {\
  writeOp(CacheOp::GuardStringToNumber);\
  writeOperandId(str);\
  NumberOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
private:\
void stringToAtom_(StringOperandId str) {\
  writeOp(CacheOp::StringToAtom);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
public:\
NumberOperandId booleanToNumber(BooleanOperandId boolean) {\
  writeOp(CacheOp::BooleanToNumber);\
  writeOperandId(boolean);\
  NumberOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadGetterSetterFunction(ValOperandId getterSetter, bool isGetter, bool needsClassGuard) {\
  writeOp(CacheOp::LoadGetterSetterFunction);\
  writeOperandId(getterSetter);\
  writeBoolImm(isGetter);\
  writeBoolImm(needsClassGuard);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void guardHasGetterSetter(ObjOperandId obj, jsid id, const Value& getterSetter) {\
  writeOp(CacheOp::GuardHasGetterSetter);\
  writeOperandId(obj);\
  writeIdField(id);\
  writeWeakValueField(getterSetter);\
  assertLengthMatches();\
}\
void guardInt32IsNonNegative(Int32OperandId index) {\
  writeOp(CacheOp::GuardInt32IsNonNegative);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void guardIntPtrIsNonNegative(IntPtrOperandId index) {\
  writeOp(CacheOp::GuardIntPtrIsNonNegative);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void guardIndexIsValidUpdateOrAdd(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::GuardIndexIsValidUpdateOrAdd);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void guardIndexIsNotDenseElement(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::GuardIndexIsNotDenseElement);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void guardTagNotEqual(ValueTagOperandId lhs, ValueTagOperandId rhs) {\
  writeOp(CacheOp::GuardTagNotEqual);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void guardXrayExpandoShapeAndDefaultProto(ObjOperandId obj, JSObject* shapeWrapper) {\
  writeOp(CacheOp::GuardXrayExpandoShapeAndDefaultProto);\
  writeOperandId(obj);\
  writeObjectField(shapeWrapper);\
  assertLengthMatches();\
}\
void guardXrayNoExpando(ObjOperandId obj) {\
  writeOp(CacheOp::GuardXrayNoExpando);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardDynamicSlotIsSpecificObject(ObjOperandId obj, ObjOperandId expected, uint32_t slot) {\
  writeOp(CacheOp::GuardDynamicSlotIsSpecificObject);\
  writeOperandId(obj);\
  writeOperandId(expected);\
  writeRawInt32Field(slot);\
  assertLengthMatches();\
}\
void guardDynamicSlotIsNotObject(ObjOperandId obj, uint32_t slot) {\
  writeOp(CacheOp::GuardDynamicSlotIsNotObject);\
  writeOperandId(obj);\
  writeRawInt32Field(slot);\
  assertLengthMatches();\
}\
void guardFixedSlotValue(ObjOperandId obj, uint32_t offset, const Value& val) {\
  writeOp(CacheOp::GuardFixedSlotValue);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeValueField(val);\
  assertLengthMatches();\
}\
void guardDynamicSlotValue(ObjOperandId obj, uint32_t offset, const Value& val) {\
  writeOp(CacheOp::GuardDynamicSlotValue);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeValueField(val);\
  assertLengthMatches();\
}\
void checkWeakValueResultForFixedSlot(ObjOperandId obj, uint32_t offset, const Value& val) {\
  writeOp(CacheOp::CheckWeakValueResultForFixedSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeWeakValueField(val);\
  assertLengthMatches();\
}\
void checkWeakValueResultForDynamicSlot(ObjOperandId obj, uint32_t offset, const Value& val) {\
  writeOp(CacheOp::CheckWeakValueResultForDynamicSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeWeakValueField(val);\
  assertLengthMatches();\
}\
ObjOperandId loadScriptedProxyHandler(ObjOperandId obj) {\
  writeOp(CacheOp::LoadScriptedProxyHandler);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  writeOperandId(obj);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId idToStringOrSymbol(ValOperandId id) {\
  writeOp(CacheOp::IdToStringOrSymbol);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  writeOperandId(id);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadFixedSlot(ObjOperandId obj, uint32_t offset) {\
  writeOp(CacheOp::LoadFixedSlot);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadDynamicSlot(ObjOperandId obj, uint32_t slot) {\
  writeOp(CacheOp::LoadDynamicSlot);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  writeOperandId(obj);\
  writeRawInt32Field(slot);\
  assertLengthMatches();\
  return result;\
}\
void guardNoAllocationMetadataBuilder(const void* builderAddr) {\
  writeOp(CacheOp::GuardNoAllocationMetadataBuilder);\
  writeRawPointerField(builderAddr);\
  assertLengthMatches();\
}\
void guardFunctionHasJitEntry(ObjOperandId fun) {\
  writeOp(CacheOp::GuardFunctionHasJitEntry);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardFunctionHasNoJitEntry(ObjOperandId fun) {\
  writeOp(CacheOp::GuardFunctionHasNoJitEntry);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardFunctionIsNonBuiltinCtor(ObjOperandId fun) {\
  writeOp(CacheOp::GuardFunctionIsNonBuiltinCtor);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardFunctionIsConstructor(ObjOperandId fun) {\
  writeOp(CacheOp::GuardFunctionIsConstructor);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardNotClassConstructor(ObjOperandId fun) {\
  writeOp(CacheOp::GuardNotClassConstructor);\
  writeOperandId(fun);\
  assertLengthMatches();\
}\
void guardArrayIsPacked(ObjOperandId array) {\
  writeOp(CacheOp::GuardArrayIsPacked);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void guardArgumentsObjectFlags(ObjOperandId obj, uint32_t flags) {\
  writeOp(CacheOp::GuardArgumentsObjectFlags);\
  writeOperandId(obj);\
  writeByteImm(flags);\
  assertLengthMatches();\
}\
void guardObjectHasSameRealm(ObjOperandId obj) {\
  writeOp(CacheOp::GuardObjectHasSameRealm);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
ObjOperandId loadObject(JSObject* obj) {\
  writeOp(CacheOp::LoadObject);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  writeObjectField(obj);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadProtoObject(JSObject* protoObj, ObjOperandId receiverObj) {\
  writeOp(CacheOp::LoadProtoObject);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  writeObjectField(protoObj);\
  writeOperandId(receiverObj);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadProto(ObjOperandId obj) {\
  writeOp(CacheOp::LoadProto);\
  writeOperandId(obj);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadEnclosingEnvironment(ObjOperandId obj) {\
  writeOp(CacheOp::LoadEnclosingEnvironment);\
  writeOperandId(obj);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadWrapperTarget(ObjOperandId obj, bool fallible) {\
  writeOp(CacheOp::LoadWrapperTarget);\
  writeOperandId(obj);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  writeBoolImm(fallible);\
  assertLengthMatches();\
  return result;\
}\
ValueTagOperandId loadValueTag(ValOperandId val) {\
  writeOp(CacheOp::LoadValueTag);\
  writeOperandId(val);\
  ValueTagOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
private:\
ValOperandId loadArgumentFixedSlot_(uint32_t slotIndex) {\
  writeOp(CacheOp::LoadArgumentFixedSlot);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  writeByteImm(slotIndex);\
  assertLengthMatches();\
  return result;\
}\
public:\
private:\
ValOperandId loadArgumentDynamicSlot_(Int32OperandId argc, uint32_t slotIndex) {\
  writeOp(CacheOp::LoadArgumentDynamicSlot);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  writeOperandId(argc);\
  writeByteImm(slotIndex);\
  assertLengthMatches();\
  return result;\
}\
public:\
Int32OperandId truncateDoubleToUInt32(NumberOperandId input) {\
  writeOp(CacheOp::TruncateDoubleToUInt32);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId doubleToUint8Clamped(NumberOperandId input) {\
  writeOp(CacheOp::DoubleToUint8Clamped);\
  writeOperandId(input);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void megamorphicLoadSlotResult(ObjOperandId obj, jsid name) {\
  writeOp(CacheOp::MegamorphicLoadSlotResult);\
  writeOperandId(obj);\
  writeIdField(name);\
  assertLengthMatches();\
}\
void megamorphicLoadSlotByValueResult(ObjOperandId obj, ValOperandId id) {\
  writeOp(CacheOp::MegamorphicLoadSlotByValueResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  assertLengthMatches();\
}\
void megamorphicLoadSlotPermissiveResult(ObjOperandId obj, jsid name) {\
  writeOp(CacheOp::MegamorphicLoadSlotPermissiveResult);\
  writeOperandId(obj);\
  writeIdField(name);\
  assertLengthMatches();\
}\
void megamorphicLoadSlotByValuePermissiveResult(ObjOperandId obj, ValOperandId id) {\
  writeOp(CacheOp::MegamorphicLoadSlotByValuePermissiveResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  assertLengthMatches();\
}\
void megamorphicStoreSlot(ObjOperandId obj, jsid name, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::MegamorphicStoreSlot);\
  writeOperandId(obj);\
  writeIdField(name);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
void megamorphicSetElement(ObjOperandId obj, ValOperandId id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::MegamorphicSetElement);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
void megamorphicHasPropResult(ObjOperandId obj, ValOperandId id, bool hasOwn) {\
  writeOp(CacheOp::MegamorphicHasPropResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeBoolImm(hasOwn);\
  assertLengthMatches();\
}\
void smallObjectVariableKeyHasOwnResult(StringOperandId id, JSObject* propNames, Shape* shape) {\
  writeOp(CacheOp::SmallObjectVariableKeyHasOwnResult);\
  writeOperandId(id);\
  writeObjectField(propNames);\
  writeShapeField(shape);\
  assertLengthMatches();\
}\
void objectToIteratorResult(ObjOperandId obj, const void* enumeratorsAddr) {\
  writeOp(CacheOp::ObjectToIteratorResult);\
  writeOperandId(obj);\
  writeRawPointerField(enumeratorsAddr);\
  assertLengthMatches();\
}\
void valueToIteratorResult(ValOperandId val) {\
  writeOp(CacheOp::ValueToIteratorResult);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
ValOperandId loadDOMExpandoValue(ObjOperandId obj) {\
  writeOp(CacheOp::LoadDOMExpandoValue);\
  writeOperandId(obj);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadDOMExpandoValueGuardGeneration(ObjOperandId obj, const void* expandoAndGeneration, uint64_t generation) {\
  writeOp(CacheOp::LoadDOMExpandoValueGuardGeneration);\
  writeOperandId(obj);\
  writeRawPointerField(expandoAndGeneration);\
  writeRawInt64Field(generation);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadDOMExpandoValueIgnoreGeneration(ObjOperandId obj) {\
  writeOp(CacheOp::LoadDOMExpandoValueIgnoreGeneration);\
  writeOperandId(obj);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void guardDOMExpandoMissingOrGuardShape(ValOperandId expando, Shape* shape) {\
  writeOp(CacheOp::GuardDOMExpandoMissingOrGuardShape);\
  writeOperandId(expando);\
  writeShapeField(shape);\
  assertLengthMatches();\
}\
void storeFixedSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs) {\
  writeOp(CacheOp::StoreFixedSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void storeDynamicSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs) {\
  writeOp(CacheOp::StoreDynamicSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void addAndStoreFixedSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs, Shape* newShape, bool preserveWrapper) {\
  writeOp(CacheOp::AddAndStoreFixedSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  writeShapeField(newShape);\
  writeBoolImm(preserveWrapper);\
  assertLengthMatches();\
}\
void addAndStoreDynamicSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs, Shape* newShape, bool preserveWrapper) {\
  writeOp(CacheOp::AddAndStoreDynamicSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  writeShapeField(newShape);\
  writeBoolImm(preserveWrapper);\
  assertLengthMatches();\
}\
void allocateAndStoreDynamicSlot(ObjOperandId obj, uint32_t offset, ValOperandId rhs, Shape* newShape, uint32_t numNewSlots, bool preserveWrapper) {\
  writeOp(CacheOp::AllocateAndStoreDynamicSlot);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  writeShapeField(newShape);\
  writeRawInt32Field(numNewSlots);\
  writeBoolImm(preserveWrapper);\
  assertLengthMatches();\
}\
void addSlotAndCallAddPropHook(ObjOperandId obj, ValOperandId rhs, Shape* newShape) {\
  writeOp(CacheOp::AddSlotAndCallAddPropHook);\
  writeOperandId(obj);\
  writeOperandId(rhs);\
  writeShapeField(newShape);\
  assertLengthMatches();\
}\
void storeDenseElement(ObjOperandId obj, Int32OperandId index, ValOperandId rhs, bool expectPackedElements) {\
  writeOp(CacheOp::StoreDenseElement);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(rhs);\
  writeBoolImm(expectPackedElements);\
  assertLengthMatches();\
}\
void storeDenseElementHole(ObjOperandId obj, Int32OperandId index, ValOperandId rhs, bool handleAdd) {\
  writeOp(CacheOp::StoreDenseElementHole);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(rhs);\
  writeBoolImm(handleAdd);\
  assertLengthMatches();\
}\
void arrayPush(ObjOperandId obj, ValOperandId rhs) {\
  writeOp(CacheOp::ArrayPush);\
  writeOperandId(obj);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void arrayJoinResult(ObjOperandId obj, StringOperandId sep) {\
  writeOp(CacheOp::ArrayJoinResult);\
  writeOperandId(obj);\
  writeOperandId(sep);\
  assertLengthMatches();\
}\
void objectKeysResult(ObjOperandId obj, Shape* resultShape) {\
  writeOp(CacheOp::ObjectKeysResult);\
  writeOperandId(obj);\
  writeShapeField(resultShape);\
  assertLengthMatches();\
}\
void packedArrayPopResult(ObjOperandId array) {\
  writeOp(CacheOp::PackedArrayPopResult);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void packedArrayShiftResult(ObjOperandId array) {\
  writeOp(CacheOp::PackedArrayShiftResult);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void packedArraySliceResult(JSObject* templateObject, ObjOperandId array, Int32OperandId begin, Int32OperandId end) {\
  writeOp(CacheOp::PackedArraySliceResult);\
  writeObjectField(templateObject);\
  writeOperandId(array);\
  writeOperandId(begin);\
  writeOperandId(end);\
  assertLengthMatches();\
}\
void argumentsSliceResult(JSObject* templateObject, ObjOperandId args, Int32OperandId begin, Int32OperandId end) {\
  writeOp(CacheOp::ArgumentsSliceResult);\
  writeObjectField(templateObject);\
  writeOperandId(args);\
  writeOperandId(begin);\
  writeOperandId(end);\
  assertLengthMatches();\
}\
void isArrayResult(ValOperandId input) {\
  writeOp(CacheOp::IsArrayResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void storeFixedSlotUndefinedResult(ObjOperandId obj, uint32_t offset, ValOperandId rhs) {\
  writeOp(CacheOp::StoreFixedSlotUndefinedResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void isObjectResult(ValOperandId input) {\
  writeOp(CacheOp::IsObjectResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void isPackedArrayResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsPackedArrayResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void isCallableResult(ValOperandId input) {\
  writeOp(CacheOp::IsCallableResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void isConstructorResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsConstructorResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void isCrossRealmArrayConstructorResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsCrossRealmArrayConstructorResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void isTypedArrayResult(ObjOperandId obj, bool isPossiblyWrapped) {\
  writeOp(CacheOp::IsTypedArrayResult);\
  writeOperandId(obj);\
  writeBoolImm(isPossiblyWrapped);\
  assertLengthMatches();\
}\
void isTypedArrayConstructorResult(ObjOperandId obj) {\
  writeOp(CacheOp::IsTypedArrayConstructorResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void arrayBufferViewByteOffsetInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::ArrayBufferViewByteOffsetInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void arrayBufferViewByteOffsetDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::ArrayBufferViewByteOffsetDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void typedArrayByteLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::TypedArrayByteLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void typedArrayByteLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::TypedArrayByteLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void resizableTypedArrayByteLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::ResizableTypedArrayByteLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void resizableTypedArrayByteLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::ResizableTypedArrayByteLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void resizableTypedArrayLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::ResizableTypedArrayLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void resizableTypedArrayLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::ResizableTypedArrayLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void resizableDataViewByteLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::ResizableDataViewByteLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void resizableDataViewByteLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::ResizableDataViewByteLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void growableSharedArrayBufferByteLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::GrowableSharedArrayBufferByteLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void growableSharedArrayBufferByteLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::GrowableSharedArrayBufferByteLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardHasAttachedArrayBuffer(ObjOperandId obj) {\
  writeOp(CacheOp::GuardHasAttachedArrayBuffer);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardResizableArrayBufferViewInBounds(ObjOperandId obj) {\
  writeOp(CacheOp::GuardResizableArrayBufferViewInBounds);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void guardResizableArrayBufferViewInBoundsOrDetached(ObjOperandId obj) {\
  writeOp(CacheOp::GuardResizableArrayBufferViewInBoundsOrDetached);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void typedArrayFillResult(ObjOperandId obj, OperandId fillValue, IntPtrOperandId start, IntPtrOperandId end, Scalar::Type elementType) {\
  writeOp(CacheOp::TypedArrayFillResult);\
  writeOperandId(obj);\
  writeOperandId(fillValue);\
  writeOperandId(start);\
  writeOperandId(end);\
  writeScalarTypeImm(elementType);\
  assertLengthMatches();\
}\
void typedArraySetResult(ObjOperandId target, ObjOperandId source, IntPtrOperandId offset, bool canUseBitwiseCopy) {\
  writeOp(CacheOp::TypedArraySetResult);\
  writeOperandId(target);\
  writeOperandId(source);\
  writeOperandId(offset);\
  writeBoolImm(canUseBitwiseCopy);\
  assertLengthMatches();\
}\
void typedArraySubarrayResult(JSObject* templateObject, ObjOperandId obj, IntPtrOperandId start, IntPtrOperandId end) {\
  writeOp(CacheOp::TypedArraySubarrayResult);\
  writeObjectField(templateObject);\
  writeOperandId(obj);\
  writeOperandId(start);\
  writeOperandId(end);\
  assertLengthMatches();\
}\
void newArrayIteratorResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewArrayIteratorResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newStringIteratorResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewStringIteratorResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newRegExpStringIteratorResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewRegExpStringIteratorResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void objectCreateResult(JSObject* templateObject) {\
  writeOp(CacheOp::ObjectCreateResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newArrayFromLengthResult(JSObject* templateObject, Int32OperandId length, gc::AllocSite* site) {\
  writeOp(CacheOp::NewArrayFromLengthResult);\
  writeObjectField(templateObject);\
  writeOperandId(length);\
  writeAllocSiteField(site);\
  assertLengthMatches();\
}\
void newTypedArrayFromLengthResult(JSObject* templateObject, Int32OperandId length) {\
  writeOp(CacheOp::NewTypedArrayFromLengthResult);\
  writeObjectField(templateObject);\
  writeOperandId(length);\
  assertLengthMatches();\
}\
void newTypedArrayFromArrayBufferResult(JSObject* templateObject, ObjOperandId buffer, ValOperandId byteOffset, ValOperandId length) {\
  writeOp(CacheOp::NewTypedArrayFromArrayBufferResult);\
  writeObjectField(templateObject);\
  writeOperandId(buffer);\
  writeOperandId(byteOffset);\
  writeOperandId(length);\
  assertLengthMatches();\
}\
void newTypedArrayFromArrayResult(JSObject* templateObject, ObjOperandId array) {\
  writeOp(CacheOp::NewTypedArrayFromArrayResult);\
  writeObjectField(templateObject);\
  writeOperandId(array);\
  assertLengthMatches();\
}\
void newMapObjectResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewMapObjectResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newSetObjectResult(JSObject* templateObject) {\
  writeOp(CacheOp::NewSetObjectResult);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void newMapObjectFromIterableResult(JSObject* templateObject, ValOperandId iterable) {\
  writeOp(CacheOp::NewMapObjectFromIterableResult);\
  writeObjectField(templateObject);\
  writeOperandId(iterable);\
  assertLengthMatches();\
}\
void newSetObjectFromIterableResult(JSObject* templateObject, ValOperandId iterable) {\
  writeOp(CacheOp::NewSetObjectFromIterableResult);\
  writeObjectField(templateObject);\
  writeOperandId(iterable);\
  assertLengthMatches();\
}\
void newStringObjectResult(JSObject* templateObject, StringOperandId str) {\
  writeOp(CacheOp::NewStringObjectResult);\
  writeObjectField(templateObject);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void stringFromCharCodeResult(Int32OperandId code) {\
  writeOp(CacheOp::StringFromCharCodeResult);\
  writeOperandId(code);\
  assertLengthMatches();\
}\
void stringFromCodePointResult(Int32OperandId code) {\
  writeOp(CacheOp::StringFromCodePointResult);\
  writeOperandId(code);\
  assertLengthMatches();\
}\
void stringIncludesResult(StringOperandId str, StringOperandId searchStr) {\
  writeOp(CacheOp::StringIncludesResult);\
  writeOperandId(str);\
  writeOperandId(searchStr);\
  assertLengthMatches();\
}\
void stringIndexOfResult(StringOperandId str, StringOperandId searchStr) {\
  writeOp(CacheOp::StringIndexOfResult);\
  writeOperandId(str);\
  writeOperandId(searchStr);\
  assertLengthMatches();\
}\
void stringLastIndexOfResult(StringOperandId str, StringOperandId searchStr) {\
  writeOp(CacheOp::StringLastIndexOfResult);\
  writeOperandId(str);\
  writeOperandId(searchStr);\
  assertLengthMatches();\
}\
void stringStartsWithResult(StringOperandId str, StringOperandId searchStr) {\
  writeOp(CacheOp::StringStartsWithResult);\
  writeOperandId(str);\
  writeOperandId(searchStr);\
  assertLengthMatches();\
}\
void stringEndsWithResult(StringOperandId str, StringOperandId searchStr) {\
  writeOp(CacheOp::StringEndsWithResult);\
  writeOperandId(str);\
  writeOperandId(searchStr);\
  assertLengthMatches();\
}\
void stringToLowerCaseResult(StringOperandId str) {\
  writeOp(CacheOp::StringToLowerCaseResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void stringToUpperCaseResult(StringOperandId str) {\
  writeOp(CacheOp::StringToUpperCaseResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void stringTrimResult(StringOperandId str) {\
  writeOp(CacheOp::StringTrimResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void stringTrimStartResult(StringOperandId str) {\
  writeOp(CacheOp::StringTrimStartResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void stringTrimEndResult(StringOperandId str) {\
  writeOp(CacheOp::StringTrimEndResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void mathAbsInt32Result(Int32OperandId input) {\
  writeOp(CacheOp::MathAbsInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathAbsNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathAbsNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathClz32Result(Int32OperandId input) {\
  writeOp(CacheOp::MathClz32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathSignInt32Result(Int32OperandId input) {\
  writeOp(CacheOp::MathSignInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathSignNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathSignNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathSignNumberToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathSignNumberToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathImulResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::MathImulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void mathSqrtNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathSqrtNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathFRoundNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathFRoundNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathF16RoundNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathF16RoundNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathRandomResult(const void* rng) {\
  writeOp(CacheOp::MathRandomResult);\
  writeRawPointerField(rng);\
  assertLengthMatches();\
}\
void mathHypot2NumberResult(NumberOperandId first, NumberOperandId second) {\
  writeOp(CacheOp::MathHypot2NumberResult);\
  writeOperandId(first);\
  writeOperandId(second);\
  assertLengthMatches();\
}\
void mathHypot3NumberResult(NumberOperandId first, NumberOperandId second, NumberOperandId third) {\
  writeOp(CacheOp::MathHypot3NumberResult);\
  writeOperandId(first);\
  writeOperandId(second);\
  writeOperandId(third);\
  assertLengthMatches();\
}\
void mathHypot4NumberResult(NumberOperandId first, NumberOperandId second, NumberOperandId third, NumberOperandId fourth) {\
  writeOp(CacheOp::MathHypot4NumberResult);\
  writeOperandId(first);\
  writeOperandId(second);\
  writeOperandId(third);\
  writeOperandId(fourth);\
  assertLengthMatches();\
}\
void mathAtan2NumberResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::MathAtan2NumberResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void mathFloorNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathFloorNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathCeilNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathCeilNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathTruncNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathTruncNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathRoundNumberResult(NumberOperandId input) {\
  writeOp(CacheOp::MathRoundNumberResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathFloorToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathFloorToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathCeilToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathCeilToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathTruncToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathTruncToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void mathRoundToInt32Result(NumberOperandId input) {\
  writeOp(CacheOp::MathRoundToInt32Result);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
Int32OperandId int32MinMax(bool isMax, Int32OperandId first, Int32OperandId second) {\
  writeOp(CacheOp::Int32MinMax);\
  writeBoolImm(isMax);\
  writeOperandId(first);\
  writeOperandId(second);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
NumberOperandId numberMinMax(bool isMax, NumberOperandId first, NumberOperandId second) {\
  writeOp(CacheOp::NumberMinMax);\
  writeBoolImm(isMax);\
  writeOperandId(first);\
  writeOperandId(second);\
  NumberOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void int32MinMaxArrayResult(ObjOperandId array, bool isMax) {\
  writeOp(CacheOp::Int32MinMaxArrayResult);\
  writeOperandId(array);\
  writeBoolImm(isMax);\
  assertLengthMatches();\
}\
void numberMinMaxArrayResult(ObjOperandId array, bool isMax) {\
  writeOp(CacheOp::NumberMinMaxArrayResult);\
  writeOperandId(array);\
  writeBoolImm(isMax);\
  assertLengthMatches();\
}\
void mathFunctionNumberResult(NumberOperandId input, UnaryMathFunction fun) {\
  writeOp(CacheOp::MathFunctionNumberResult);\
  writeOperandId(input);\
  writeUnaryMathFunctionImm(fun);\
  assertLengthMatches();\
}\
void numberParseIntResult(StringOperandId str, Int32OperandId radix) {\
  writeOp(CacheOp::NumberParseIntResult);\
  writeOperandId(str);\
  writeOperandId(radix);\
  assertLengthMatches();\
}\
void doubleParseIntResult(NumberOperandId num) {\
  writeOp(CacheOp::DoubleParseIntResult);\
  writeOperandId(num);\
  assertLengthMatches();\
}\
void objectToStringResult(ObjOperandId obj) {\
  writeOp(CacheOp::ObjectToStringResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void reflectGetPrototypeOfResult(ObjOperandId obj) {\
  writeOp(CacheOp::ReflectGetPrototypeOfResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void storeTypedArrayElement(ObjOperandId obj, Scalar::Type elementType, IntPtrOperandId index, OperandId rhs, bool handleOOB, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::StoreTypedArrayElement);\
  writeOperandId(obj);\
  writeScalarTypeImm(elementType);\
  writeOperandId(index);\
  writeOperandId(rhs);\
  writeBoolImm(handleOOB);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsCompareExchangeResult(ObjOperandId obj, IntPtrOperandId index, OperandId expected, OperandId replacement, Scalar::Type elementType, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsCompareExchangeResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(expected);\
  writeOperandId(replacement);\
  writeScalarTypeImm(elementType);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsExchangeResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsExchangeResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsAddResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsAddResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsSubResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsSubResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsAndResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsAndResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsOrResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsOrResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsXorResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsXorResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forEffect);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsLoadResult(ObjOperandId obj, IntPtrOperandId index, Scalar::Type elementType, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsLoadResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeScalarTypeImm(elementType);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsStoreResult(ObjOperandId obj, IntPtrOperandId index, OperandId value, Scalar::Type elementType, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::AtomicsStoreResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(value);\
  writeScalarTypeImm(elementType);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void atomicsIsLockFreeResult(Int32OperandId value) {\
  writeOp(CacheOp::AtomicsIsLockFreeResult);\
  writeOperandId(value);\
  assertLengthMatches();\
}\
void atomicsPauseResult() {\
  writeOp(CacheOp::AtomicsPauseResult);\
  assertLengthMatches();\
}\
private:\
void callNativeSetter_(ObjOperandId receiver, JSObject* setter, ValOperandId rhs, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallNativeSetter);\
  writeOperandId(receiver);\
  writeObjectField(setter);\
  writeOperandId(rhs);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callScriptedSetter_(ObjOperandId receiver, ObjOperandId callee, ValOperandId rhs, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallScriptedSetter);\
  writeOperandId(receiver);\
  writeOperandId(callee);\
  writeOperandId(rhs);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callInlinedSetter_(ObjOperandId receiver, ObjOperandId callee, ValOperandId rhs, const void* icScript, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallInlinedSetter);\
  writeOperandId(receiver);\
  writeOperandId(callee);\
  writeOperandId(rhs);\
  writeRawPointerField(icScript);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
void callDOMSetter(ObjOperandId obj, const void* jitInfo, ValOperandId rhs) {\
  writeOp(CacheOp::CallDOMSetter);\
  writeOperandId(obj);\
  writeRawPointerField(jitInfo);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void callSetArrayLength(ObjOperandId obj, bool strict, ValOperandId rhs) {\
  writeOp(CacheOp::CallSetArrayLength);\
  writeOperandId(obj);\
  writeBoolImm(strict);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void proxySet(ObjOperandId obj, jsid id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::ProxySet);\
  writeOperandId(obj);\
  writeIdField(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
void proxySetByValue(ObjOperandId obj, ValOperandId id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::ProxySetByValue);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
void callAddOrUpdateSparseElementHelper(ObjOperandId obj, Int32OperandId id, ValOperandId rhs, bool strict) {\
  writeOp(CacheOp::CallAddOrUpdateSparseElementHelper);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeOperandId(rhs);\
  writeBoolImm(strict);\
  assertLengthMatches();\
}\
StringOperandId callInt32ToString(Int32OperandId input) {\
  writeOp(CacheOp::CallInt32ToString);\
  writeOperandId(input);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
StringOperandId callNumberToString(NumberOperandId input) {\
  writeOp(CacheOp::CallNumberToString);\
  writeOperandId(input);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void int32ToStringWithBaseResult(Int32OperandId input, Int32OperandId base) {\
  writeOp(CacheOp::Int32ToStringWithBaseResult);\
  writeOperandId(input);\
  writeOperandId(base);\
  assertLengthMatches();\
}\
StringOperandId booleanToString(BooleanOperandId input) {\
  writeOp(CacheOp::BooleanToString);\
  writeOperandId(input);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
private:\
void callScriptedFunction_(ObjOperandId callee, Int32OperandId argc, CallFlags flags, uint32_t argcFixed) {\
  writeOp(CacheOp::CallScriptedFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(argcFixed);\
  assertLengthMatches();\
}\
public:\
void callBoundScriptedFunction(ObjOperandId callee, ObjOperandId target, Int32OperandId argc, CallFlags flags, uint32_t numBoundArgs) {\
  writeOp(CacheOp::CallBoundScriptedFunction);\
  writeOperandId(callee);\
  writeOperandId(target);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(numBoundArgs);\
  assertLengthMatches();\
}\
void callWasmFunction(ObjOperandId callee, Int32OperandId argc, CallFlags flags, uint32_t argcFixed, const void* funcType, JSObject* instance) {\
  writeOp(CacheOp::CallWasmFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(argcFixed);\
  writeRawPointerField(funcType);\
  writeObjectField(instance);\
  assertLengthMatches();\
}\
void guardWasmArg(ValOperandId arg, wasm::ValType::Kind type) {\
  writeOp(CacheOp::GuardWasmArg);\
  writeOperandId(arg);\
  writeWasmValTypeImm(type);\
  assertLengthMatches();\
}\
private:\
void callNativeFunction_(ObjOperandId callee, Int32OperandId argc, CallFlags flags, uint32_t argcFixed, bool ignoresReturnValue) {\
  writeOp(CacheOp::CallNativeFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(argcFixed);\
  writeBoolImm(ignoresReturnValue);\
  assertLengthMatches();\
}\
public:\
private:\
void callDOMFunction_(ObjOperandId callee, Int32OperandId argc, ObjOperandId thisObj, CallFlags flags, uint32_t argcFixed) {\
  writeOp(CacheOp::CallDOMFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeOperandId(thisObj);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(argcFixed);\
  assertLengthMatches();\
}\
public:\
private:\
void callDOMFunctionWithAllocSite_(ObjOperandId callee, Int32OperandId argc, ObjOperandId thisObj, CallFlags flags, uint32_t argcFixed, gc::AllocSite* site) {\
  writeOp(CacheOp::CallDOMFunctionWithAllocSite);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeOperandId(thisObj);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(argcFixed);\
  writeAllocSiteField(site);\
  assertLengthMatches();\
}\
public:\
private:\
void callClassHook_(ObjOperandId callee, Int32OperandId argc, CallFlags flags, uint32_t argcFixed, const void* target) {\
  writeOp(CacheOp::CallClassHook);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(argcFixed);\
  writeRawPointerField(target);\
  assertLengthMatches();\
}\
public:\
private:\
void callInlinedFunction_(ObjOperandId callee, Int32OperandId argc, const void* icScript, CallFlags flags, uint32_t argcFixed) {\
  writeOp(CacheOp::CallInlinedFunction);\
  writeOperandId(callee);\
  writeOperandId(argc);\
  writeRawPointerField(icScript);\
  writeCallFlagsImm(flags);\
  writeUInt32Imm(argcFixed);\
  assertLengthMatches();\
}\
public:\
private:\
void callScriptedProxyGetResult_(ValOperandId target, ObjOperandId receiver, ObjOperandId handler, ObjOperandId trap, jsid property, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallScriptedProxyGetResult);\
  writeOperandId(target);\
  writeOperandId(receiver);\
  writeOperandId(handler);\
  writeOperandId(trap);\
  writeIdField(property);\
  writeUInt32Imm(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callScriptedProxyGetByValueResult_(ValOperandId target, ObjOperandId receiver, ObjOperandId handler, ValOperandId property, ObjOperandId trap, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallScriptedProxyGetByValueResult);\
  writeOperandId(target);\
  writeOperandId(receiver);\
  writeOperandId(handler);\
  writeOperandId(property);\
  writeOperandId(trap);\
  writeUInt32Imm(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void metaScriptedThisShape_(Shape* thisShape) {\
  writeOp(CacheOp::MetaScriptedThisShape);\
  writeShapeField(thisShape);\
  assertLengthMatches();\
}\
public:\
void bindFunctionResult(ObjOperandId target, uint32_t argc, JSObject* templateObject) {\
  writeOp(CacheOp::BindFunctionResult);\
  writeOperandId(target);\
  writeUInt32Imm(argc);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void specializedBindFunctionResult(ObjOperandId target, uint32_t argc, JSObject* templateObject) {\
  writeOp(CacheOp::SpecializedBindFunctionResult);\
  writeOperandId(target);\
  writeUInt32Imm(argc);\
  writeObjectField(templateObject);\
  assertLengthMatches();\
}\
void loadFixedSlotResult(ObjOperandId obj, uint32_t offset) {\
  writeOp(CacheOp::LoadFixedSlotResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  assertLengthMatches();\
}\
void loadFixedSlotTypedResult(ObjOperandId obj, uint32_t offset, ValueType type) {\
  writeOp(CacheOp::LoadFixedSlotTypedResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  writeValueTypeImm(type);\
  assertLengthMatches();\
}\
void loadDynamicSlotResult(ObjOperandId obj, uint32_t offset) {\
  writeOp(CacheOp::LoadDynamicSlotResult);\
  writeOperandId(obj);\
  writeRawInt32Field(offset);\
  assertLengthMatches();\
}\
void loadDenseElementResult(ObjOperandId obj, Int32OperandId index, bool expectPackedElements) {\
  writeOp(CacheOp::LoadDenseElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeBoolImm(expectPackedElements);\
  assertLengthMatches();\
}\
void loadDenseElementHoleResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadDenseElementHoleResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void callGetSparseElementResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::CallGetSparseElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadDenseElementExistsResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadDenseElementExistsResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadTypedArrayElementExistsResult(ObjOperandId obj, IntPtrOperandId index, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::LoadTypedArrayElementExistsResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void loadDenseElementHoleExistsResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadDenseElementHoleExistsResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadTypedArrayElementResult(ObjOperandId obj, IntPtrOperandId index, Scalar::Type elementType, bool handleOOB, bool forceDoubleForUint32, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::LoadTypedArrayElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(handleOOB);\
  writeBoolImm(forceDoubleForUint32);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void loadDataViewValueResult(ObjOperandId obj, IntPtrOperandId offset, BooleanOperandId littleEndian, Scalar::Type elementType, bool forceDoubleForUint32, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::LoadDataViewValueResult);\
  writeOperandId(obj);\
  writeOperandId(offset);\
  writeOperandId(littleEndian);\
  writeScalarTypeImm(elementType);\
  writeBoolImm(forceDoubleForUint32);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void storeDataViewValueResult(ObjOperandId obj, IntPtrOperandId offset, OperandId value, BooleanOperandId littleEndian, Scalar::Type elementType, ArrayBufferViewKind viewKind) {\
  writeOp(CacheOp::StoreDataViewValueResult);\
  writeOperandId(obj);\
  writeOperandId(offset);\
  writeOperandId(value);\
  writeOperandId(littleEndian);\
  writeScalarTypeImm(elementType);\
  writeArrayBufferViewKindImm(viewKind);\
  assertLengthMatches();\
}\
void loadInt32ArrayLengthResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadInt32ArrayLengthResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
Int32OperandId loadInt32ArrayLength(ObjOperandId obj) {\
  writeOp(CacheOp::LoadInt32ArrayLength);\
  writeOperandId(obj);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void loadArgumentsObjectArgResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadArgumentsObjectArgResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadArgumentsObjectArgHoleResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadArgumentsObjectArgHoleResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadArgumentsObjectArgExistsResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::LoadArgumentsObjectArgExistsResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void loadArgumentsObjectLengthResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArgumentsObjectLengthResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
Int32OperandId loadArgumentsObjectLength(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArgumentsObjectLength);\
  writeOperandId(obj);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void loadFunctionLengthResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadFunctionLengthResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadFunctionNameResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadFunctionNameResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
Int32OperandId loadBoundFunctionNumArgs(ObjOperandId obj) {\
  writeOp(CacheOp::LoadBoundFunctionNumArgs);\
  writeOperandId(obj);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ObjOperandId loadBoundFunctionTarget(ObjOperandId obj) {\
  writeOp(CacheOp::LoadBoundFunctionTarget);\
  writeOperandId(obj);\
  ObjOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadBoundFunctionArgument(ObjOperandId obj, uint32_t index) {\
  writeOp(CacheOp::LoadBoundFunctionArgument);\
  writeOperandId(obj);\
  writeUInt32Imm(index);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void guardBoundFunctionIsConstructor(ObjOperandId obj) {\
  writeOp(CacheOp::GuardBoundFunctionIsConstructor);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferByteLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferByteLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferByteLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferByteLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferViewLengthInt32Result(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferViewLengthInt32Result);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadArrayBufferViewLengthDoubleResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferViewLengthDoubleResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
IntPtrOperandId loadArrayBufferViewLength(ObjOperandId obj) {\
  writeOp(CacheOp::LoadArrayBufferViewLength);\
  writeOperandId(obj);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
StringOperandId linearizeForCharAccess(StringOperandId str, Int32OperandId index) {\
  writeOp(CacheOp::LinearizeForCharAccess);\
  writeOperandId(str);\
  writeOperandId(index);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
StringOperandId linearizeForCodePointAccess(StringOperandId str, Int32OperandId index) {\
  writeOp(CacheOp::LinearizeForCodePointAccess);\
  writeOperandId(str);\
  writeOperandId(index);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
Int32OperandId toRelativeStringIndex(Int32OperandId index, StringOperandId str) {\
  writeOp(CacheOp::ToRelativeStringIndex);\
  writeOperandId(index);\
  writeOperandId(str);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void loadStringCharResult(StringOperandId str, Int32OperandId index, bool handleOOB) {\
  writeOp(CacheOp::LoadStringCharResult);\
  writeOperandId(str);\
  writeOperandId(index);\
  writeBoolImm(handleOOB);\
  assertLengthMatches();\
}\
void loadStringAtResult(StringOperandId str, Int32OperandId index, bool handleOOB) {\
  writeOp(CacheOp::LoadStringAtResult);\
  writeOperandId(str);\
  writeOperandId(index);\
  writeBoolImm(handleOOB);\
  assertLengthMatches();\
}\
void loadStringCharCodeResult(StringOperandId str, Int32OperandId index, bool handleOOB) {\
  writeOp(CacheOp::LoadStringCharCodeResult);\
  writeOperandId(str);\
  writeOperandId(index);\
  writeBoolImm(handleOOB);\
  assertLengthMatches();\
}\
void loadStringCodePointResult(StringOperandId str, Int32OperandId index, bool handleOOB) {\
  writeOp(CacheOp::LoadStringCodePointResult);\
  writeOperandId(str);\
  writeOperandId(index);\
  writeBoolImm(handleOOB);\
  assertLengthMatches();\
}\
void loadStringLengthResult(StringOperandId str) {\
  writeOp(CacheOp::LoadStringLengthResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void frameIsConstructingResult() {\
  writeOp(CacheOp::FrameIsConstructingResult);\
  assertLengthMatches();\
}\
void loadObjectResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadObjectResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadStringResult(StringOperandId str) {\
  writeOp(CacheOp::LoadStringResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void loadSymbolResult(SymbolOperandId sym) {\
  writeOp(CacheOp::LoadSymbolResult);\
  writeOperandId(sym);\
  assertLengthMatches();\
}\
void loadInt32Result(Int32OperandId val) {\
  writeOp(CacheOp::LoadInt32Result);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void loadDoubleResult(NumberOperandId val) {\
  writeOp(CacheOp::LoadDoubleResult);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void loadBigIntResult(BigIntOperandId val) {\
  writeOp(CacheOp::LoadBigIntResult);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
private:\
void callScriptedGetterResult_(ValOperandId receiver, ObjOperandId callee, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallScriptedGetterResult);\
  writeOperandId(receiver);\
  writeOperandId(callee);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callInlinedGetterResult_(ValOperandId receiver, ObjOperandId callee, const void* icScript, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallInlinedGetterResult);\
  writeOperandId(receiver);\
  writeOperandId(callee);\
  writeRawPointerField(icScript);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
private:\
void callNativeGetterResult_(ValOperandId receiver, JSObject* getter, bool sameRealm, uint32_t nargsAndFlags) {\
  writeOp(CacheOp::CallNativeGetterResult);\
  writeOperandId(receiver);\
  writeObjectField(getter);\
  writeBoolImm(sameRealm);\
  writeRawInt32Field(nargsAndFlags);\
  assertLengthMatches();\
}\
public:\
void callDOMGetterResult(ObjOperandId obj, const void* jitInfo) {\
  writeOp(CacheOp::CallDOMGetterResult);\
  writeOperandId(obj);\
  writeRawPointerField(jitInfo);\
  assertLengthMatches();\
}\
void proxyGetResult(ObjOperandId obj, jsid id) {\
  writeOp(CacheOp::ProxyGetResult);\
  writeOperandId(obj);\
  writeIdField(id);\
  assertLengthMatches();\
}\
void proxyGetByValueResult(ObjOperandId obj, ValOperandId id) {\
  writeOp(CacheOp::ProxyGetByValueResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  assertLengthMatches();\
}\
void proxyHasPropResult(ObjOperandId obj, ValOperandId id, bool hasOwn) {\
  writeOp(CacheOp::ProxyHasPropResult);\
  writeOperandId(obj);\
  writeOperandId(id);\
  writeBoolImm(hasOwn);\
  assertLengthMatches();\
}\
void callObjectHasSparseElementResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::CallObjectHasSparseElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void callNativeGetElementResult(ObjOperandId obj, Int32OperandId index) {\
  writeOp(CacheOp::CallNativeGetElementResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  assertLengthMatches();\
}\
void callNativeGetElementSuperResult(ObjOperandId obj, Int32OperandId index, ValOperandId receiver) {\
  writeOp(CacheOp::CallNativeGetElementSuperResult);\
  writeOperandId(obj);\
  writeOperandId(index);\
  writeOperandId(receiver);\
  assertLengthMatches();\
}\
void getNextMapSetEntryForIteratorResult(ObjOperandId iter, ObjOperandId resultArr, bool isMap) {\
  writeOp(CacheOp::GetNextMapSetEntryForIteratorResult);\
  writeOperandId(iter);\
  writeOperandId(resultArr);\
  writeBoolImm(isMap);\
  assertLengthMatches();\
}\
void loadUndefinedResult() {\
  writeOp(CacheOp::LoadUndefinedResult);\
  assertLengthMatches();\
}\
void loadBooleanResult(bool val) {\
  writeOp(CacheOp::LoadBooleanResult);\
  writeBoolImm(val);\
  assertLengthMatches();\
}\
Int32OperandId loadInt32Constant(uint32_t val) {\
  writeOp(CacheOp::LoadInt32Constant);\
  writeRawInt32Field(val);\
  Int32OperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId loadInt32AsIntPtrConstant(uint32_t val) {\
  writeOp(CacheOp::LoadInt32AsIntPtrConstant);\
  writeRawInt32Field(val);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
NumberOperandId loadDoubleConstant(double val) {\
  writeOp(CacheOp::LoadDoubleConstant);\
  writeDoubleField(val);\
  NumberOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
BooleanOperandId loadBooleanConstant(bool val) {\
  writeOp(CacheOp::LoadBooleanConstant);\
  writeBoolImm(val);\
  BooleanOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
ValOperandId loadUndefined() {\
  writeOp(CacheOp::LoadUndefined);\
  ValOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
StringOperandId loadConstantString(JSString* str) {\
  writeOp(CacheOp::LoadConstantString);\
  writeStringField(str);\
  StringOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void loadConstantStringResult(JSString* str) {\
  writeOp(CacheOp::LoadConstantStringResult);\
  writeStringField(str);\
  assertLengthMatches();\
}\
void loadInstanceOfObjectResult(ValOperandId lhs, ObjOperandId proto) {\
  writeOp(CacheOp::LoadInstanceOfObjectResult);\
  writeOperandId(lhs);\
  writeOperandId(proto);\
  assertLengthMatches();\
}\
void loadTypeOfObjectResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadTypeOfObjectResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadTypeOfEqObjectResult(ObjOperandId obj, TypeofEqOperand operand) {\
  writeOp(CacheOp::LoadTypeOfEqObjectResult);\
  writeOperandId(obj);\
  writeTypeofEqOperandImm(operand);\
  assertLengthMatches();\
}\
void doubleAddResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleAddResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleSubResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleSubResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleMulResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleMulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleDivResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleDivResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doubleModResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoubleModResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void doublePowResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::DoublePowResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32AddResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32AddResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32SubResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32SubResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32MulResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32MulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32DivResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32DivResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32ModResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32ModResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32PowResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32PowResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntAddResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntAddResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntSubResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntSubResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntMulResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntMulResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntDivResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntDivResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntModResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntModResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntPowResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntPowResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
IntPtrOperandId bigIntToIntPtr(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntToIntPtr);\
  writeOperandId(input);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void intPtrToBigIntResult(IntPtrOperandId input) {\
  writeOp(CacheOp::IntPtrToBigIntResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
IntPtrOperandId bigIntPtrAdd(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrAdd);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrSub(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrSub);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrMul(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrMul);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrDiv(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrDiv);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrMod(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrMod);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrPow(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrPow);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void int32BitOrResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32BitOrResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32BitXorResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32BitXorResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32BitAndResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32BitAndResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32LeftShiftResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32LeftShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32RightShiftResult(Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::Int32RightShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void int32URightShiftResult(Int32OperandId lhs, Int32OperandId rhs, bool forceDouble) {\
  writeOp(CacheOp::Int32URightShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  writeBoolImm(forceDouble);\
  assertLengthMatches();\
}\
void int32NotResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32NotResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntBitOrResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntBitOrResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntBitXorResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntBitXorResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntBitAndResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntBitAndResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntLeftShiftResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntLeftShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntRightShiftResult(BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::BigIntRightShiftResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void bigIntNotResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntNotResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
IntPtrOperandId bigIntPtrBitOr(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrBitOr);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrBitXor(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrBitXor);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrBitAnd(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrBitAnd);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrLeftShift(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrLeftShift);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrRightShift(IntPtrOperandId lhs, IntPtrOperandId rhs) {\
  writeOp(CacheOp::BigIntPtrRightShift);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrNot(IntPtrOperandId input) {\
  writeOp(CacheOp::BigIntPtrNot);\
  writeOperandId(input);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void int32NegationResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32NegationResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void doubleNegationResult(NumberOperandId input) {\
  writeOp(CacheOp::DoubleNegationResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntNegationResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntNegationResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
IntPtrOperandId bigIntPtrNegation(IntPtrOperandId input) {\
  writeOp(CacheOp::BigIntPtrNegation);\
  writeOperandId(input);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void int32IncResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32IncResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void int32DecResult(Int32OperandId input) {\
  writeOp(CacheOp::Int32DecResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void doubleIncResult(NumberOperandId input) {\
  writeOp(CacheOp::DoubleIncResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void doubleDecResult(NumberOperandId input) {\
  writeOp(CacheOp::DoubleDecResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntIncResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntIncResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void bigIntDecResult(BigIntOperandId input) {\
  writeOp(CacheOp::BigIntDecResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
IntPtrOperandId bigIntPtrInc(IntPtrOperandId input) {\
  writeOp(CacheOp::BigIntPtrInc);\
  writeOperandId(input);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
IntPtrOperandId bigIntPtrDec(IntPtrOperandId input) {\
  writeOp(CacheOp::BigIntPtrDec);\
  writeOperandId(input);\
  IntPtrOperandId result(newOperandId());\
  writeOperandId(result);\
  assertLengthMatches();\
  return result;\
}\
void loadInt32TruthyResult(ValOperandId input) {\
  writeOp(CacheOp::LoadInt32TruthyResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void loadDoubleTruthyResult(NumberOperandId input) {\
  writeOp(CacheOp::LoadDoubleTruthyResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void loadStringTruthyResult(StringOperandId str) {\
  writeOp(CacheOp::LoadStringTruthyResult);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void loadObjectTruthyResult(ObjOperandId obj) {\
  writeOp(CacheOp::LoadObjectTruthyResult);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void loadBigIntTruthyResult(BigIntOperandId bigInt) {\
  writeOp(CacheOp::LoadBigIntTruthyResult);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void loadValueTruthyResult(ValOperandId input) {\
  writeOp(CacheOp::LoadValueTruthyResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void loadValueResult(const Value& val) {\
  writeOp(CacheOp::LoadValueResult);\
  writeValueField(val);\
  assertLengthMatches();\
}\
void uncheckedLoadWeakValueResult(const Value& val) {\
  writeOp(CacheOp::UncheckedLoadWeakValueResult);\
  writeWeakValueField(val);\
  assertLengthMatches();\
}\
void uncheckedLoadWeakObjectResult(JSObject* obj) {\
  writeOp(CacheOp::UncheckedLoadWeakObjectResult);\
  writeWeakObjectField(obj);\
  assertLengthMatches();\
}\
void loadOperandResult(ValOperandId input) {\
  writeOp(CacheOp::LoadOperandResult);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void newPlainObjectResult(uint32_t numFixedSlots, uint32_t numDynamicSlots, gc::AllocKind allocKind, Shape* shape, gc::AllocSite* site) {\
  writeOp(CacheOp::NewPlainObjectResult);\
  writeUInt32Imm(numFixedSlots);\
  writeUInt32Imm(numDynamicSlots);\
  writeAllocKindImm(allocKind);\
  writeShapeField(shape);\
  writeAllocSiteField(site);\
  assertLengthMatches();\
}\
void newArrayObjectResult(uint32_t arrayLength, Shape* shape, gc::AllocSite* site) {\
  writeOp(CacheOp::NewArrayObjectResult);\
  writeUInt32Imm(arrayLength);\
  writeShapeField(shape);\
  writeAllocSiteField(site);\
  assertLengthMatches();\
}\
void newFunctionCloneResult(JSObject* canonical, gc::AllocKind allocKind, gc::AllocSite* site) {\
  writeOp(CacheOp::NewFunctionCloneResult);\
  writeObjectField(canonical);\
  writeAllocKindImm(allocKind);\
  writeAllocSiteField(site);\
  assertLengthMatches();\
}\
void concatStringsResult(StringOperandId lhs, StringOperandId rhs, JitCode* stub) {\
  writeOp(CacheOp::ConcatStringsResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  writeJitCodeField(stub);\
  assertLengthMatches();\
}\
void callStringObjectConcatResult(ValOperandId lhs, ValOperandId rhs) {\
  writeOp(CacheOp::CallStringObjectConcatResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void callIsSuspendedGeneratorResult(ValOperandId val) {\
  writeOp(CacheOp::CallIsSuspendedGeneratorResult);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void compareStringResult(JSOp op, StringOperandId lhs, StringOperandId rhs) {\
  writeOp(CacheOp::CompareStringResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareObjectResult(JSOp op, ObjOperandId lhs, ObjOperandId rhs) {\
  writeOp(CacheOp::CompareObjectResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareSymbolResult(JSOp op, SymbolOperandId lhs, SymbolOperandId rhs) {\
  writeOp(CacheOp::CompareSymbolResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareInt32Result(JSOp op, Int32OperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::CompareInt32Result);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareDoubleResult(JSOp op, NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::CompareDoubleResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntResult(JSOp op, BigIntOperandId lhs, BigIntOperandId rhs) {\
  writeOp(CacheOp::CompareBigIntResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntInt32Result(JSOp op, BigIntOperandId lhs, Int32OperandId rhs) {\
  writeOp(CacheOp::CompareBigIntInt32Result);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntNumberResult(JSOp op, BigIntOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::CompareBigIntNumberResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareBigIntStringResult(JSOp op, BigIntOperandId lhs, StringOperandId rhs) {\
  writeOp(CacheOp::CompareBigIntStringResult);\
  writeJSOpImm(op);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void compareNullUndefinedResult(JSOp op, bool isUndefined, ValOperandId input) {\
  writeOp(CacheOp::CompareNullUndefinedResult);\
  writeJSOpImm(op);\
  writeBoolImm(isUndefined);\
  writeOperandId(input);\
  assertLengthMatches();\
}\
void compareDoubleSameValueResult(NumberOperandId lhs, NumberOperandId rhs) {\
  writeOp(CacheOp::CompareDoubleSameValueResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void sameValueResult(ValOperandId lhs, ValOperandId rhs) {\
  writeOp(CacheOp::SameValueResult);\
  writeOperandId(lhs);\
  writeOperandId(rhs);\
  assertLengthMatches();\
}\
void indirectTruncateInt32Result(Int32OperandId val) {\
  writeOp(CacheOp::IndirectTruncateInt32Result);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void bigIntAsIntNResult(Int32OperandId bits, BigIntOperandId bigInt) {\
  writeOp(CacheOp::BigIntAsIntNResult);\
  writeOperandId(bits);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void bigIntAsUintNResult(Int32OperandId bits, BigIntOperandId bigInt) {\
  writeOp(CacheOp::BigIntAsUintNResult);\
  writeOperandId(bits);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void setHasResult(ObjOperandId set, ValOperandId val) {\
  writeOp(CacheOp::SetHasResult);\
  writeOperandId(set);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void setHasNonGCThingResult(ObjOperandId set, ValOperandId val) {\
  writeOp(CacheOp::SetHasNonGCThingResult);\
  writeOperandId(set);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void setHasStringResult(ObjOperandId set, StringOperandId str) {\
  writeOp(CacheOp::SetHasStringResult);\
  writeOperandId(set);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void setHasSymbolResult(ObjOperandId set, SymbolOperandId sym) {\
  writeOp(CacheOp::SetHasSymbolResult);\
  writeOperandId(set);\
  writeOperandId(sym);\
  assertLengthMatches();\
}\
void setHasBigIntResult(ObjOperandId set, BigIntOperandId bigInt) {\
  writeOp(CacheOp::SetHasBigIntResult);\
  writeOperandId(set);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void setHasObjectResult(ObjOperandId set, ObjOperandId obj) {\
  writeOp(CacheOp::SetHasObjectResult);\
  writeOperandId(set);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void setDeleteResult(ObjOperandId set, ValOperandId val) {\
  writeOp(CacheOp::SetDeleteResult);\
  writeOperandId(set);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void setAddResult(ObjOperandId set, ValOperandId key) {\
  writeOp(CacheOp::SetAddResult);\
  writeOperandId(set);\
  writeOperandId(key);\
  assertLengthMatches();\
}\
void setSizeResult(ObjOperandId set) {\
  writeOp(CacheOp::SetSizeResult);\
  writeOperandId(set);\
  assertLengthMatches();\
}\
void mapHasResult(ObjOperandId map, ValOperandId val) {\
  writeOp(CacheOp::MapHasResult);\
  writeOperandId(map);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void mapHasNonGCThingResult(ObjOperandId map, ValOperandId val) {\
  writeOp(CacheOp::MapHasNonGCThingResult);\
  writeOperandId(map);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void mapHasStringResult(ObjOperandId map, StringOperandId str) {\
  writeOp(CacheOp::MapHasStringResult);\
  writeOperandId(map);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void mapHasSymbolResult(ObjOperandId map, SymbolOperandId sym) {\
  writeOp(CacheOp::MapHasSymbolResult);\
  writeOperandId(map);\
  writeOperandId(sym);\
  assertLengthMatches();\
}\
void mapHasBigIntResult(ObjOperandId map, BigIntOperandId bigInt) {\
  writeOp(CacheOp::MapHasBigIntResult);\
  writeOperandId(map);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void mapHasObjectResult(ObjOperandId map, ObjOperandId obj) {\
  writeOp(CacheOp::MapHasObjectResult);\
  writeOperandId(map);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void mapGetResult(ObjOperandId map, ValOperandId val) {\
  writeOp(CacheOp::MapGetResult);\
  writeOperandId(map);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void mapGetNonGCThingResult(ObjOperandId map, ValOperandId val) {\
  writeOp(CacheOp::MapGetNonGCThingResult);\
  writeOperandId(map);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void mapGetStringResult(ObjOperandId map, StringOperandId str) {\
  writeOp(CacheOp::MapGetStringResult);\
  writeOperandId(map);\
  writeOperandId(str);\
  assertLengthMatches();\
}\
void mapGetSymbolResult(ObjOperandId map, SymbolOperandId sym) {\
  writeOp(CacheOp::MapGetSymbolResult);\
  writeOperandId(map);\
  writeOperandId(sym);\
  assertLengthMatches();\
}\
void mapGetBigIntResult(ObjOperandId map, BigIntOperandId bigInt) {\
  writeOp(CacheOp::MapGetBigIntResult);\
  writeOperandId(map);\
  writeOperandId(bigInt);\
  assertLengthMatches();\
}\
void mapGetObjectResult(ObjOperandId map, ObjOperandId obj) {\
  writeOp(CacheOp::MapGetObjectResult);\
  writeOperandId(map);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void mapDeleteResult(ObjOperandId map, ValOperandId val) {\
  writeOp(CacheOp::MapDeleteResult);\
  writeOperandId(map);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void mapSetResult(ObjOperandId map, ValOperandId key, ValOperandId val) {\
  writeOp(CacheOp::MapSetResult);\
  writeOperandId(map);\
  writeOperandId(key);\
  writeOperandId(val);\
  assertLengthMatches();\
}\
void mapSizeResult(ObjOperandId map) {\
  writeOp(CacheOp::MapSizeResult);\
  writeOperandId(map);\
  assertLengthMatches();\
}\
void weakMapGetObjectResult(ObjOperandId weakMap, ObjOperandId obj) {\
  writeOp(CacheOp::WeakMapGetObjectResult);\
  writeOperandId(weakMap);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void weakMapHasObjectResult(ObjOperandId weakMap, ObjOperandId obj) {\
  writeOp(CacheOp::WeakMapHasObjectResult);\
  writeOperandId(weakMap);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void weakSetHasObjectResult(ObjOperandId weakSet, ObjOperandId obj) {\
  writeOp(CacheOp::WeakSetHasObjectResult);\
  writeOperandId(weakSet);\
  writeOperandId(obj);\
  assertLengthMatches();\
}\
void dateFillLocalTimeSlots(ObjOperandId date) {\
  writeOp(CacheOp::DateFillLocalTimeSlots);\
  writeOperandId(date);\
  assertLengthMatches();\
}\
void dateHoursFromSecondsIntoYearResult(ValOperandId secondsIntoYear) {\
  writeOp(CacheOp::DateHoursFromSecondsIntoYearResult);\
  writeOperandId(secondsIntoYear);\
  assertLengthMatches();\
}\
void dateMinutesFromSecondsIntoYearResult(ValOperandId secondsIntoYear) {\
  writeOp(CacheOp::DateMinutesFromSecondsIntoYearResult);\
  writeOperandId(secondsIntoYear);\
  assertLengthMatches();\
}\
void dateSecondsFromSecondsIntoYearResult(ValOperandId secondsIntoYear) {\
  writeOp(CacheOp::DateSecondsFromSecondsIntoYearResult);\
  writeOperandId(secondsIntoYear);\
  assertLengthMatches();\
}\
void arrayFromArgumentsObjectResult(ObjOperandId obj, Shape* shape) {\
  writeOp(CacheOp::ArrayFromArgumentsObjectResult);\
  writeOperandId(obj);\
  writeShapeField(shape);\
  assertLengthMatches();\
}\
void closeIterScriptedResult(ObjOperandId iter, ObjOperandId callee, CompletionKind kind, uint32_t targetNargs) {\
  writeOp(CacheOp::CloseIterScriptedResult);\
  writeOperandId(iter);\
  writeOperandId(callee);\
  writeCompletionKindImm(kind);\
  writeUInt32Imm(targetNargs);\
  assertLengthMatches();\
}\
void callPrintString(const char* str) {\
  writeOp(CacheOp::CallPrintString);\
  writeStaticStringImm(str);\
  assertLengthMatches();\
}\
void breakpoint() {\
  writeOp(CacheOp::Breakpoint);\
  assertLengthMatches();\
}\
void wrapResult() {\
  writeOp(CacheOp::WrapResult);\
  assertLengthMatches();\
}\
void bailout() {\
  writeOp(CacheOp::Bailout);\
  assertLengthMatches();\
}\
void assertFloat32Result(ValOperandId val, bool mustBeFloat32) {\
  writeOp(CacheOp::AssertFloat32Result);\
  writeOperandId(val);\
  writeBoolImm(mustBeFloat32);\
  assertLengthMatches();\
}\
void assertRecoveredOnBailoutResult(ValOperandId val, bool mustBeRecovered) {\
  writeOp(CacheOp::AssertRecoveredOnBailoutResult);\
  writeOperandId(val);\
  writeBoolImm(mustBeRecovered);\
  assertLengthMatches();\
}\
void assertPropertyLookup(ObjOperandId obj, jsid id, uint32_t slot) {\
  writeOp(CacheOp::AssertPropertyLookup);\
  writeOperandId(obj);\
  writeIdField(id);\
  writeRawInt32Field(slot);\
  assertLengthMatches();\
}

#define CACHE_IR_READER_GENERATED \
struct ReturnFromICArgs final {  };\
ReturnFromICArgs argsForReturnFromIC() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ReturnFromIC);\
  return {  };\
}\
\
struct GuardToObjectArgs final { ValOperandId inputId; };\
GuardToObjectArgs argsForGuardToObject() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToObject);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardIsNullOrUndefinedArgs final { ValOperandId inputId; };\
GuardIsNullOrUndefinedArgs argsForGuardIsNullOrUndefined() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNullOrUndefined);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardIsNullArgs final { ValOperandId inputId; };\
GuardIsNullArgs argsForGuardIsNull() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNull);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardIsUndefinedArgs final { ValOperandId inputId; };\
GuardIsUndefinedArgs argsForGuardIsUndefined() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsUndefined);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardIsNotUninitializedLexicalArgs final { ValOperandId valId; };\
GuardIsNotUninitializedLexicalArgs argsForGuardIsNotUninitializedLexical() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNotUninitializedLexical);\
  ValOperandId valId_ = this->valOperandId();\
  return { valId_ };\
}\
\
struct GuardToBooleanArgs final { ValOperandId inputId; };\
GuardToBooleanArgs argsForGuardToBoolean() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToBoolean);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardToStringArgs final { ValOperandId inputId; };\
GuardToStringArgs argsForGuardToString() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToString);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardToSymbolArgs final { ValOperandId inputId; };\
GuardToSymbolArgs argsForGuardToSymbol() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToSymbol);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardToBigIntArgs final { ValOperandId inputId; };\
GuardToBigIntArgs argsForGuardToBigInt() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToBigInt);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardIsNumberArgs final { ValOperandId inputId; };\
GuardIsNumberArgs argsForGuardIsNumber() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNumber);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardToInt32Args final { ValOperandId inputId; };\
GuardToInt32Args argsForGuardToInt32() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToInt32);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardToNonGCThingArgs final { ValOperandId inputId; };\
GuardToNonGCThingArgs argsForGuardToNonGCThing() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToNonGCThing);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct GuardBooleanToInt32Args final { ValOperandId inputId; Int32OperandId resultId; };\
GuardBooleanToInt32Args argsForGuardBooleanToInt32() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardBooleanToInt32);\
  ValOperandId inputId_ = this->valOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { inputId_, resultId_ };\
}\
\
struct GuardToInt32IndexArgs final { ValOperandId inputId; Int32OperandId resultId; };\
GuardToInt32IndexArgs argsForGuardToInt32Index() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToInt32Index);\
  ValOperandId inputId_ = this->valOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { inputId_, resultId_ };\
}\
\
struct Int32ToIntPtrArgs final { Int32OperandId inputId; IntPtrOperandId resultId; };\
Int32ToIntPtrArgs argsForInt32ToIntPtr() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32ToIntPtr);\
  Int32OperandId inputId_ = this->int32OperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct GuardNumberToIntPtrIndexArgs final { NumberOperandId inputId; bool supportOOB; IntPtrOperandId resultId; };\
GuardNumberToIntPtrIndexArgs argsForGuardNumberToIntPtrIndex() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardNumberToIntPtrIndex);\
  NumberOperandId inputId_ = this->numberOperandId();\
  bool supportOOB_ = this->readBool();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { inputId_, supportOOB_, resultId_ };\
}\
\
struct GuardToInt32ModUint32Args final { ValOperandId inputId; Int32OperandId resultId; };\
GuardToInt32ModUint32Args argsForGuardToInt32ModUint32() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToInt32ModUint32);\
  ValOperandId inputId_ = this->valOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { inputId_, resultId_ };\
}\
\
struct GuardToUint8ClampedArgs final { ValOperandId inputId; Int32OperandId resultId; };\
GuardToUint8ClampedArgs argsForGuardToUint8Clamped() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToUint8Clamped);\
  ValOperandId inputId_ = this->valOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { inputId_, resultId_ };\
}\
\
struct GuardNonDoubleTypeArgs final { ValOperandId inputId; ValueType type; };\
GuardNonDoubleTypeArgs argsForGuardNonDoubleType() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardNonDoubleType);\
  ValOperandId inputId_ = this->valOperandId();\
  ValueType type_ = this->valueType();\
  return { inputId_, type_ };\
}\
\
struct GuardShapeArgs final { ObjOperandId objId; uint32_t shapeOffset; };\
GuardShapeArgs argsForGuardShape() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardShape);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t shapeOffset_ = this->stubOffset();\
  return { objId_, shapeOffset_ };\
}\
\
struct GuardMultipleShapesArgs final { ObjOperandId objId; uint32_t shapesOffset; };\
GuardMultipleShapesArgs argsForGuardMultipleShapes() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardMultipleShapes);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t shapesOffset_ = this->stubOffset();\
  return { objId_, shapesOffset_ };\
}\
\
struct GuardProtoArgs final { ObjOperandId objId; uint32_t protoOffset; };\
GuardProtoArgs argsForGuardProto() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardProto);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t protoOffset_ = this->stubOffset();\
  return { objId_, protoOffset_ };\
}\
\
struct GuardNullProtoArgs final { ObjOperandId objId; };\
GuardNullProtoArgs argsForGuardNullProto() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardNullProto);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardClassArgs final { ObjOperandId objId; GuardClassKind kind; };\
GuardClassArgs argsForGuardClass() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardClass);\
  ObjOperandId objId_ = this->objOperandId();\
  GuardClassKind kind_ = this->guardClassKind();\
  return { objId_, kind_ };\
}\
\
struct GuardFuseArgs final { RealmFuses::FuseIndex fuseWord; };\
GuardFuseArgs argsForGuardFuse() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardFuse);\
  RealmFuses::FuseIndex fuseWord_ = this->realmFuseIndex();\
  return { fuseWord_ };\
}\
\
struct GuardRuntimeFuseArgs final { RuntimeFuses::FuseIndex fuseWord; };\
GuardRuntimeFuseArgs argsForGuardRuntimeFuse() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardRuntimeFuse);\
  RuntimeFuses::FuseIndex fuseWord_ = this->runtimeFuseIndex();\
  return { fuseWord_ };\
}\
\
struct GuardObjectFusePropertyArgs final { ObjOperandId objId; uint32_t objFuseOwnerOffset; uint32_t objFuseOffset; uint32_t expectedGenerationOffset; uint32_t propIndexOffset; uint32_t propMaskOffset; bool canUseFastPath; };\
GuardObjectFusePropertyArgs argsForGuardObjectFuseProperty() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardObjectFuseProperty);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t objFuseOwnerOffset_ = this->stubOffset();\
  uint32_t objFuseOffset_ = this->stubOffset();\
  uint32_t expectedGenerationOffset_ = this->stubOffset();\
  uint32_t propIndexOffset_ = this->stubOffset();\
  uint32_t propMaskOffset_ = this->stubOffset();\
  bool canUseFastPath_ = this->readBool();\
  return { objId_, objFuseOwnerOffset_, objFuseOffset_, expectedGenerationOffset_, propIndexOffset_, propMaskOffset_, canUseFastPath_ };\
}\
\
struct GuardAnyClassArgs final { ObjOperandId objId; uint32_t claspOffset; };\
GuardAnyClassArgs argsForGuardAnyClass() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardAnyClass);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t claspOffset_ = this->stubOffset();\
  return { objId_, claspOffset_ };\
}\
\
struct GuardGlobalGenerationArgs final { uint32_t expectedOffset; uint32_t generationAddrOffset; };\
GuardGlobalGenerationArgs argsForGuardGlobalGeneration() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardGlobalGeneration);\
  uint32_t expectedOffset_ = this->stubOffset();\
  uint32_t generationAddrOffset_ = this->stubOffset();\
  return { expectedOffset_, generationAddrOffset_ };\
}\
\
struct HasClassResultArgs final { ObjOperandId objId; uint32_t claspOffset; };\
HasClassResultArgs argsForHasClassResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::HasClassResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t claspOffset_ = this->stubOffset();\
  return { objId_, claspOffset_ };\
}\
\
struct HasShapeResultArgs final { ObjOperandId objId; uint32_t shapeOffset; };\
HasShapeResultArgs argsForHasShapeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::HasShapeResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t shapeOffset_ = this->stubOffset();\
  return { objId_, shapeOffset_ };\
}\
\
struct CallRegExpMatcherResultArgs final { ObjOperandId regexpId; StringOperandId inputId; Int32OperandId lastIndexId; uint32_t stubOffset; };\
CallRegExpMatcherResultArgs argsForCallRegExpMatcherResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallRegExpMatcherResult);\
  ObjOperandId regexpId_ = this->objOperandId();\
  StringOperandId inputId_ = this->stringOperandId();\
  Int32OperandId lastIndexId_ = this->int32OperandId();\
  uint32_t stubOffset_ = this->stubOffset();\
  return { regexpId_, inputId_, lastIndexId_, stubOffset_ };\
}\
\
struct CallRegExpSearcherResultArgs final { ObjOperandId regexpId; StringOperandId inputId; Int32OperandId lastIndexId; uint32_t stubOffset; };\
CallRegExpSearcherResultArgs argsForCallRegExpSearcherResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallRegExpSearcherResult);\
  ObjOperandId regexpId_ = this->objOperandId();\
  StringOperandId inputId_ = this->stringOperandId();\
  Int32OperandId lastIndexId_ = this->int32OperandId();\
  uint32_t stubOffset_ = this->stubOffset();\
  return { regexpId_, inputId_, lastIndexId_, stubOffset_ };\
}\
\
struct RegExpSearcherLastLimitResultArgs final {  };\
RegExpSearcherLastLimitResultArgs argsForRegExpSearcherLastLimitResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::RegExpSearcherLastLimitResult);\
  return {  };\
}\
\
struct RegExpHasCaptureGroupsResultArgs final { ObjOperandId regexpId; StringOperandId inputId; };\
RegExpHasCaptureGroupsResultArgs argsForRegExpHasCaptureGroupsResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::RegExpHasCaptureGroupsResult);\
  ObjOperandId regexpId_ = this->objOperandId();\
  StringOperandId inputId_ = this->stringOperandId();\
  return { regexpId_, inputId_ };\
}\
\
struct RegExpBuiltinExecMatchResultArgs final { ObjOperandId regexpId; StringOperandId inputId; uint32_t stubOffset; };\
RegExpBuiltinExecMatchResultArgs argsForRegExpBuiltinExecMatchResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::RegExpBuiltinExecMatchResult);\
  ObjOperandId regexpId_ = this->objOperandId();\
  StringOperandId inputId_ = this->stringOperandId();\
  uint32_t stubOffset_ = this->stubOffset();\
  return { regexpId_, inputId_, stubOffset_ };\
}\
\
struct RegExpBuiltinExecTestResultArgs final { ObjOperandId regexpId; StringOperandId inputId; uint32_t stubOffset; };\
RegExpBuiltinExecTestResultArgs argsForRegExpBuiltinExecTestResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::RegExpBuiltinExecTestResult);\
  ObjOperandId regexpId_ = this->objOperandId();\
  StringOperandId inputId_ = this->stringOperandId();\
  uint32_t stubOffset_ = this->stubOffset();\
  return { regexpId_, inputId_, stubOffset_ };\
}\
\
struct RegExpFlagResultArgs final { ObjOperandId regexpId; int32_t flagsMask; };\
RegExpFlagResultArgs argsForRegExpFlagResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::RegExpFlagResult);\
  ObjOperandId regexpId_ = this->objOperandId();\
  int32_t flagsMask_ = this->int32Immediate();\
  return { regexpId_, flagsMask_ };\
}\
\
struct CallSubstringKernelResultArgs final { StringOperandId strId; Int32OperandId beginId; Int32OperandId lengthId; };\
CallSubstringKernelResultArgs argsForCallSubstringKernelResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallSubstringKernelResult);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId beginId_ = this->int32OperandId();\
  Int32OperandId lengthId_ = this->int32OperandId();\
  return { strId_, beginId_, lengthId_ };\
}\
\
struct StringReplaceStringResultArgs final { StringOperandId strId; StringOperandId patternId; StringOperandId replacementId; };\
StringReplaceStringResultArgs argsForStringReplaceStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringReplaceStringResult);\
  StringOperandId strId_ = this->stringOperandId();\
  StringOperandId patternId_ = this->stringOperandId();\
  StringOperandId replacementId_ = this->stringOperandId();\
  return { strId_, patternId_, replacementId_ };\
}\
\
struct StringSplitStringResultArgs final { StringOperandId strId; StringOperandId separatorId; };\
StringSplitStringResultArgs argsForStringSplitStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringSplitStringResult);\
  StringOperandId strId_ = this->stringOperandId();\
  StringOperandId separatorId_ = this->stringOperandId();\
  return { strId_, separatorId_ };\
}\
\
struct GetFirstDollarIndexResultArgs final { StringOperandId strId; };\
GetFirstDollarIndexResultArgs argsForGetFirstDollarIndexResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GetFirstDollarIndexResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct GuardCompartmentArgs final { ObjOperandId objId; uint32_t globalOffset; uint32_t compartmentOffset; };\
GuardCompartmentArgs argsForGuardCompartment() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardCompartment);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t globalOffset_ = this->stubOffset();\
  uint32_t compartmentOffset_ = this->stubOffset();\
  return { objId_, globalOffset_, compartmentOffset_ };\
}\
\
struct GuardIsExtensibleArgs final { ObjOperandId objId; };\
GuardIsExtensibleArgs argsForGuardIsExtensible() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsExtensible);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardIsNativeObjectArgs final { ObjOperandId objId; };\
GuardIsNativeObjectArgs argsForGuardIsNativeObject() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNativeObject);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardIsProxyArgs final { ObjOperandId objId; };\
GuardIsProxyArgs argsForGuardIsProxy() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsProxy);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardIsNotProxyArgs final { ObjOperandId objId; };\
GuardIsNotProxyArgs argsForGuardIsNotProxy() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNotProxy);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardToArrayBufferArgs final { ObjOperandId objId; };\
GuardToArrayBufferArgs argsForGuardToArrayBuffer() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToArrayBuffer);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardToSharedArrayBufferArgs final { ObjOperandId objId; };\
GuardToSharedArrayBufferArgs argsForGuardToSharedArrayBuffer() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardToSharedArrayBuffer);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardIsNotArrayBufferMaybeSharedArgs final { ObjOperandId objId; };\
GuardIsNotArrayBufferMaybeSharedArgs argsForGuardIsNotArrayBufferMaybeShared() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNotArrayBufferMaybeShared);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardIsTypedArrayArgs final { ObjOperandId objId; };\
GuardIsTypedArrayArgs argsForGuardIsTypedArray() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsTypedArray);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardIsNonResizableTypedArrayArgs final { ObjOperandId objId; };\
GuardIsNonResizableTypedArrayArgs argsForGuardIsNonResizableTypedArray() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNonResizableTypedArray);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardIsResizableTypedArrayArgs final { ObjOperandId objId; };\
GuardIsResizableTypedArrayArgs argsForGuardIsResizableTypedArray() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsResizableTypedArray);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardHasProxyHandlerArgs final { ObjOperandId objId; uint32_t handlerOffset; };\
GuardHasProxyHandlerArgs argsForGuardHasProxyHandler() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardHasProxyHandler);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t handlerOffset_ = this->stubOffset();\
  return { objId_, handlerOffset_ };\
}\
\
struct GuardIsNotDOMProxyArgs final { ObjOperandId objId; };\
GuardIsNotDOMProxyArgs argsForGuardIsNotDOMProxy() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIsNotDOMProxy);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardSpecificObjectArgs final { ObjOperandId objId; uint32_t expectedOffset; };\
GuardSpecificObjectArgs argsForGuardSpecificObject() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardSpecificObject);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t expectedOffset_ = this->stubOffset();\
  return { objId_, expectedOffset_ };\
}\
\
struct GuardObjectIdentityArgs final { ObjOperandId obj1Id; ObjOperandId obj2Id; };\
GuardObjectIdentityArgs argsForGuardObjectIdentity() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardObjectIdentity);\
  ObjOperandId obj1Id_ = this->objOperandId();\
  ObjOperandId obj2Id_ = this->objOperandId();\
  return { obj1Id_, obj2Id_ };\
}\
\
struct GuardSpecificFunctionArgs final { ObjOperandId funId; uint32_t expectedOffset; uint32_t nargsAndFlagsOffset; };\
GuardSpecificFunctionArgs argsForGuardSpecificFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardSpecificFunction);\
  ObjOperandId funId_ = this->objOperandId();\
  uint32_t expectedOffset_ = this->stubOffset();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { funId_, expectedOffset_, nargsAndFlagsOffset_ };\
}\
\
struct GuardFunctionScriptArgs final { ObjOperandId objId; uint32_t expectedOffset; uint32_t nargsAndFlagsOffset; };\
GuardFunctionScriptArgs argsForGuardFunctionScript() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardFunctionScript);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t expectedOffset_ = this->stubOffset();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { objId_, expectedOffset_, nargsAndFlagsOffset_ };\
}\
\
struct GuardSpecificAtomArgs final { StringOperandId strId; uint32_t expectedOffset; };\
GuardSpecificAtomArgs argsForGuardSpecificAtom() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardSpecificAtom);\
  StringOperandId strId_ = this->stringOperandId();\
  uint32_t expectedOffset_ = this->stubOffset();\
  return { strId_, expectedOffset_ };\
}\
\
struct GuardSpecificSymbolArgs final { SymbolOperandId symId; uint32_t expectedOffset; };\
GuardSpecificSymbolArgs argsForGuardSpecificSymbol() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardSpecificSymbol);\
  SymbolOperandId symId_ = this->symbolOperandId();\
  uint32_t expectedOffset_ = this->stubOffset();\
  return { symId_, expectedOffset_ };\
}\
\
struct GuardSpecificInt32Args final { Int32OperandId numId; int32_t expected; };\
GuardSpecificInt32Args argsForGuardSpecificInt32() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardSpecificInt32);\
  Int32OperandId numId_ = this->int32OperandId();\
  int32_t expected_ = this->int32Immediate();\
  return { numId_, expected_ };\
}\
\
struct GuardSpecificValueArgs final { ValOperandId valId; uint32_t expectedOffset; };\
GuardSpecificValueArgs argsForGuardSpecificValue() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardSpecificValue);\
  ValOperandId valId_ = this->valOperandId();\
  uint32_t expectedOffset_ = this->stubOffset();\
  return { valId_, expectedOffset_ };\
}\
\
struct GuardNoDenseElementsArgs final { ObjOperandId objId; };\
GuardNoDenseElementsArgs argsForGuardNoDenseElements() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardNoDenseElements);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardStringToIndexArgs final { StringOperandId strId; Int32OperandId resultId; };\
GuardStringToIndexArgs argsForGuardStringToIndex() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardStringToIndex);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { strId_, resultId_ };\
}\
\
struct GuardStringToInt32Args final { StringOperandId strId; Int32OperandId resultId; };\
GuardStringToInt32Args argsForGuardStringToInt32() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardStringToInt32);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { strId_, resultId_ };\
}\
\
struct GuardStringToNumberArgs final { StringOperandId strId; NumberOperandId resultId; };\
GuardStringToNumberArgs argsForGuardStringToNumber() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardStringToNumber);\
  StringOperandId strId_ = this->stringOperandId();\
  NumberOperandId resultId_ = this->numberOperandId();\
  return { strId_, resultId_ };\
}\
\
struct StringToAtomArgs final { StringOperandId strId; };\
StringToAtomArgs argsForStringToAtom() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringToAtom);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct BooleanToNumberArgs final { BooleanOperandId booleanId; NumberOperandId resultId; };\
BooleanToNumberArgs argsForBooleanToNumber() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BooleanToNumber);\
  BooleanOperandId booleanId_ = this->booleanOperandId();\
  NumberOperandId resultId_ = this->numberOperandId();\
  return { booleanId_, resultId_ };\
}\
\
struct LoadGetterSetterFunctionArgs final { ValOperandId getterSetterId; bool isGetter; bool needsClassGuard; ObjOperandId resultId; };\
LoadGetterSetterFunctionArgs argsForLoadGetterSetterFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadGetterSetterFunction);\
  ValOperandId getterSetterId_ = this->valOperandId();\
  bool isGetter_ = this->readBool();\
  bool needsClassGuard_ = this->readBool();\
  ObjOperandId resultId_ = this->objOperandId();\
  return { getterSetterId_, isGetter_, needsClassGuard_, resultId_ };\
}\
\
struct GuardHasGetterSetterArgs final { ObjOperandId objId; uint32_t idOffset; uint32_t getterSetterOffset; };\
GuardHasGetterSetterArgs argsForGuardHasGetterSetter() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardHasGetterSetter);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t idOffset_ = this->stubOffset();\
  uint32_t getterSetterOffset_ = this->stubOffset();\
  return { objId_, idOffset_, getterSetterOffset_ };\
}\
\
struct GuardInt32IsNonNegativeArgs final { Int32OperandId indexId; };\
GuardInt32IsNonNegativeArgs argsForGuardInt32IsNonNegative() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardInt32IsNonNegative);\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { indexId_ };\
}\
\
struct GuardIntPtrIsNonNegativeArgs final { IntPtrOperandId indexId; };\
GuardIntPtrIsNonNegativeArgs argsForGuardIntPtrIsNonNegative() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIntPtrIsNonNegative);\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  return { indexId_ };\
}\
\
struct GuardIndexIsValidUpdateOrAddArgs final { ObjOperandId objId; Int32OperandId indexId; };\
GuardIndexIsValidUpdateOrAddArgs argsForGuardIndexIsValidUpdateOrAdd() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIndexIsValidUpdateOrAdd);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct GuardIndexIsNotDenseElementArgs final { ObjOperandId objId; Int32OperandId indexId; };\
GuardIndexIsNotDenseElementArgs argsForGuardIndexIsNotDenseElement() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardIndexIsNotDenseElement);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct GuardTagNotEqualArgs final { ValueTagOperandId lhsId; ValueTagOperandId rhsId; };\
GuardTagNotEqualArgs argsForGuardTagNotEqual() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardTagNotEqual);\
  ValueTagOperandId lhsId_ = this->valueTagOperandId();\
  ValueTagOperandId rhsId_ = this->valueTagOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct GuardXrayExpandoShapeAndDefaultProtoArgs final { ObjOperandId objId; uint32_t shapeWrapperOffset; };\
GuardXrayExpandoShapeAndDefaultProtoArgs argsForGuardXrayExpandoShapeAndDefaultProto() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardXrayExpandoShapeAndDefaultProto);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t shapeWrapperOffset_ = this->stubOffset();\
  return { objId_, shapeWrapperOffset_ };\
}\
\
struct GuardXrayNoExpandoArgs final { ObjOperandId objId; };\
GuardXrayNoExpandoArgs argsForGuardXrayNoExpando() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardXrayNoExpando);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardDynamicSlotIsSpecificObjectArgs final { ObjOperandId objId; ObjOperandId expectedId; uint32_t slotOffset; };\
GuardDynamicSlotIsSpecificObjectArgs argsForGuardDynamicSlotIsSpecificObject() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardDynamicSlotIsSpecificObject);\
  ObjOperandId objId_ = this->objOperandId();\
  ObjOperandId expectedId_ = this->objOperandId();\
  uint32_t slotOffset_ = this->stubOffset();\
  return { objId_, expectedId_, slotOffset_ };\
}\
\
struct GuardDynamicSlotIsNotObjectArgs final { ObjOperandId objId; uint32_t slotOffset; };\
GuardDynamicSlotIsNotObjectArgs argsForGuardDynamicSlotIsNotObject() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardDynamicSlotIsNotObject);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t slotOffset_ = this->stubOffset();\
  return { objId_, slotOffset_ };\
}\
\
struct GuardFixedSlotValueArgs final { ObjOperandId objId; uint32_t offsetOffset; uint32_t valOffset; };\
GuardFixedSlotValueArgs argsForGuardFixedSlotValue() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardFixedSlotValue);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  uint32_t valOffset_ = this->stubOffset();\
  return { objId_, offsetOffset_, valOffset_ };\
}\
\
struct GuardDynamicSlotValueArgs final { ObjOperandId objId; uint32_t offsetOffset; uint32_t valOffset; };\
GuardDynamicSlotValueArgs argsForGuardDynamicSlotValue() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardDynamicSlotValue);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  uint32_t valOffset_ = this->stubOffset();\
  return { objId_, offsetOffset_, valOffset_ };\
}\
\
struct CheckWeakValueResultForFixedSlotArgs final { ObjOperandId objId; uint32_t offsetOffset; uint32_t valOffset; };\
CheckWeakValueResultForFixedSlotArgs argsForCheckWeakValueResultForFixedSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CheckWeakValueResultForFixedSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  uint32_t valOffset_ = this->stubOffset();\
  return { objId_, offsetOffset_, valOffset_ };\
}\
\
struct CheckWeakValueResultForDynamicSlotArgs final { ObjOperandId objId; uint32_t offsetOffset; uint32_t valOffset; };\
CheckWeakValueResultForDynamicSlotArgs argsForCheckWeakValueResultForDynamicSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CheckWeakValueResultForDynamicSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  uint32_t valOffset_ = this->stubOffset();\
  return { objId_, offsetOffset_, valOffset_ };\
}\
\
struct LoadScriptedProxyHandlerArgs final { ObjOperandId resultId; ObjOperandId objId; };\
LoadScriptedProxyHandlerArgs argsForLoadScriptedProxyHandler() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadScriptedProxyHandler);\
  ObjOperandId resultId_ = this->objOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  return { resultId_, objId_ };\
}\
\
struct IdToStringOrSymbolArgs final { ValOperandId resultId; ValOperandId idId; };\
IdToStringOrSymbolArgs argsForIdToStringOrSymbol() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IdToStringOrSymbol);\
  ValOperandId resultId_ = this->valOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  return { resultId_, idId_ };\
}\
\
struct LoadFixedSlotArgs final { ValOperandId resultId; ObjOperandId objId; uint32_t offsetOffset; };\
LoadFixedSlotArgs argsForLoadFixedSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadFixedSlot);\
  ValOperandId resultId_ = this->valOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  return { resultId_, objId_, offsetOffset_ };\
}\
\
struct LoadDynamicSlotArgs final { ValOperandId resultId; ObjOperandId objId; uint32_t slotOffset; };\
LoadDynamicSlotArgs argsForLoadDynamicSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDynamicSlot);\
  ValOperandId resultId_ = this->valOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t slotOffset_ = this->stubOffset();\
  return { resultId_, objId_, slotOffset_ };\
}\
\
struct GuardNoAllocationMetadataBuilderArgs final { uint32_t builderAddrOffset; };\
GuardNoAllocationMetadataBuilderArgs argsForGuardNoAllocationMetadataBuilder() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardNoAllocationMetadataBuilder);\
  uint32_t builderAddrOffset_ = this->stubOffset();\
  return { builderAddrOffset_ };\
}\
\
struct GuardFunctionHasJitEntryArgs final { ObjOperandId funId; };\
GuardFunctionHasJitEntryArgs argsForGuardFunctionHasJitEntry() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardFunctionHasJitEntry);\
  ObjOperandId funId_ = this->objOperandId();\
  return { funId_ };\
}\
\
struct GuardFunctionHasNoJitEntryArgs final { ObjOperandId funId; };\
GuardFunctionHasNoJitEntryArgs argsForGuardFunctionHasNoJitEntry() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardFunctionHasNoJitEntry);\
  ObjOperandId funId_ = this->objOperandId();\
  return { funId_ };\
}\
\
struct GuardFunctionIsNonBuiltinCtorArgs final { ObjOperandId funId; };\
GuardFunctionIsNonBuiltinCtorArgs argsForGuardFunctionIsNonBuiltinCtor() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardFunctionIsNonBuiltinCtor);\
  ObjOperandId funId_ = this->objOperandId();\
  return { funId_ };\
}\
\
struct GuardFunctionIsConstructorArgs final { ObjOperandId funId; };\
GuardFunctionIsConstructorArgs argsForGuardFunctionIsConstructor() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardFunctionIsConstructor);\
  ObjOperandId funId_ = this->objOperandId();\
  return { funId_ };\
}\
\
struct GuardNotClassConstructorArgs final { ObjOperandId funId; };\
GuardNotClassConstructorArgs argsForGuardNotClassConstructor() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardNotClassConstructor);\
  ObjOperandId funId_ = this->objOperandId();\
  return { funId_ };\
}\
\
struct GuardArrayIsPackedArgs final { ObjOperandId arrayId; };\
GuardArrayIsPackedArgs argsForGuardArrayIsPacked() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardArrayIsPacked);\
  ObjOperandId arrayId_ = this->objOperandId();\
  return { arrayId_ };\
}\
\
struct GuardArgumentsObjectFlagsArgs final { ObjOperandId objId; uint8_t flags; };\
GuardArgumentsObjectFlagsArgs argsForGuardArgumentsObjectFlags() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardArgumentsObjectFlags);\
  ObjOperandId objId_ = this->objOperandId();\
  uint8_t flags_ = this->readByte();\
  return { objId_, flags_ };\
}\
\
struct GuardObjectHasSameRealmArgs final { ObjOperandId objId; };\
GuardObjectHasSameRealmArgs argsForGuardObjectHasSameRealm() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardObjectHasSameRealm);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadObjectArgs final { ObjOperandId resultId; uint32_t objOffset; };\
LoadObjectArgs argsForLoadObject() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadObject);\
  ObjOperandId resultId_ = this->objOperandId();\
  uint32_t objOffset_ = this->stubOffset();\
  return { resultId_, objOffset_ };\
}\
\
struct LoadProtoObjectArgs final { ObjOperandId resultId; uint32_t protoObjOffset; ObjOperandId receiverObjId; };\
LoadProtoObjectArgs argsForLoadProtoObject() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadProtoObject);\
  ObjOperandId resultId_ = this->objOperandId();\
  uint32_t protoObjOffset_ = this->stubOffset();\
  ObjOperandId receiverObjId_ = this->objOperandId();\
  return { resultId_, protoObjOffset_, receiverObjId_ };\
}\
\
struct LoadProtoArgs final { ObjOperandId objId; ObjOperandId resultId; };\
LoadProtoArgs argsForLoadProto() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadProto);\
  ObjOperandId objId_ = this->objOperandId();\
  ObjOperandId resultId_ = this->objOperandId();\
  return { objId_, resultId_ };\
}\
\
struct LoadEnclosingEnvironmentArgs final { ObjOperandId objId; ObjOperandId resultId; };\
LoadEnclosingEnvironmentArgs argsForLoadEnclosingEnvironment() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadEnclosingEnvironment);\
  ObjOperandId objId_ = this->objOperandId();\
  ObjOperandId resultId_ = this->objOperandId();\
  return { objId_, resultId_ };\
}\
\
struct LoadWrapperTargetArgs final { ObjOperandId objId; ObjOperandId resultId; bool fallible; };\
LoadWrapperTargetArgs argsForLoadWrapperTarget() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadWrapperTarget);\
  ObjOperandId objId_ = this->objOperandId();\
  ObjOperandId resultId_ = this->objOperandId();\
  bool fallible_ = this->readBool();\
  return { objId_, resultId_, fallible_ };\
}\
\
struct LoadValueTagArgs final { ValOperandId valId; ValueTagOperandId resultId; };\
LoadValueTagArgs argsForLoadValueTag() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadValueTag);\
  ValOperandId valId_ = this->valOperandId();\
  ValueTagOperandId resultId_ = this->valueTagOperandId();\
  return { valId_, resultId_ };\
}\
\
struct LoadArgumentFixedSlotArgs final { ValOperandId resultId; uint8_t slotIndex; };\
LoadArgumentFixedSlotArgs argsForLoadArgumentFixedSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArgumentFixedSlot);\
  ValOperandId resultId_ = this->valOperandId();\
  uint8_t slotIndex_ = this->readByte();\
  return { resultId_, slotIndex_ };\
}\
\
struct LoadArgumentDynamicSlotArgs final { ValOperandId resultId; Int32OperandId argcId; uint8_t slotIndex; };\
LoadArgumentDynamicSlotArgs argsForLoadArgumentDynamicSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArgumentDynamicSlot);\
  ValOperandId resultId_ = this->valOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  uint8_t slotIndex_ = this->readByte();\
  return { resultId_, argcId_, slotIndex_ };\
}\
\
struct TruncateDoubleToUInt32Args final { NumberOperandId inputId; Int32OperandId resultId; };\
TruncateDoubleToUInt32Args argsForTruncateDoubleToUInt32() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::TruncateDoubleToUInt32);\
  NumberOperandId inputId_ = this->numberOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { inputId_, resultId_ };\
}\
\
struct DoubleToUint8ClampedArgs final { NumberOperandId inputId; Int32OperandId resultId; };\
DoubleToUint8ClampedArgs argsForDoubleToUint8Clamped() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleToUint8Clamped);\
  NumberOperandId inputId_ = this->numberOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { inputId_, resultId_ };\
}\
\
struct MegamorphicLoadSlotResultArgs final { ObjOperandId objId; uint32_t nameOffset; };\
MegamorphicLoadSlotResultArgs argsForMegamorphicLoadSlotResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MegamorphicLoadSlotResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t nameOffset_ = this->stubOffset();\
  return { objId_, nameOffset_ };\
}\
\
struct MegamorphicLoadSlotByValueResultArgs final { ObjOperandId objId; ValOperandId idId; };\
MegamorphicLoadSlotByValueResultArgs argsForMegamorphicLoadSlotByValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MegamorphicLoadSlotByValueResult);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  return { objId_, idId_ };\
}\
\
struct MegamorphicLoadSlotPermissiveResultArgs final { ObjOperandId objId; uint32_t nameOffset; };\
MegamorphicLoadSlotPermissiveResultArgs argsForMegamorphicLoadSlotPermissiveResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MegamorphicLoadSlotPermissiveResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t nameOffset_ = this->stubOffset();\
  return { objId_, nameOffset_ };\
}\
\
struct MegamorphicLoadSlotByValuePermissiveResultArgs final { ObjOperandId objId; ValOperandId idId; };\
MegamorphicLoadSlotByValuePermissiveResultArgs argsForMegamorphicLoadSlotByValuePermissiveResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MegamorphicLoadSlotByValuePermissiveResult);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  return { objId_, idId_ };\
}\
\
struct MegamorphicStoreSlotArgs final { ObjOperandId objId; uint32_t nameOffset; ValOperandId rhsId; bool strict; };\
MegamorphicStoreSlotArgs argsForMegamorphicStoreSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MegamorphicStoreSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t nameOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool strict_ = this->readBool();\
  return { objId_, nameOffset_, rhsId_, strict_ };\
}\
\
struct MegamorphicSetElementArgs final { ObjOperandId objId; ValOperandId idId; ValOperandId rhsId; bool strict; };\
MegamorphicSetElementArgs argsForMegamorphicSetElement() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MegamorphicSetElement);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool strict_ = this->readBool();\
  return { objId_, idId_, rhsId_, strict_ };\
}\
\
struct MegamorphicHasPropResultArgs final { ObjOperandId objId; ValOperandId idId; bool hasOwn; };\
MegamorphicHasPropResultArgs argsForMegamorphicHasPropResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MegamorphicHasPropResult);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  bool hasOwn_ = this->readBool();\
  return { objId_, idId_, hasOwn_ };\
}\
\
struct SmallObjectVariableKeyHasOwnResultArgs final { StringOperandId idId; uint32_t propNamesOffset; uint32_t shapeOffset; };\
SmallObjectVariableKeyHasOwnResultArgs argsForSmallObjectVariableKeyHasOwnResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SmallObjectVariableKeyHasOwnResult);\
  StringOperandId idId_ = this->stringOperandId();\
  uint32_t propNamesOffset_ = this->stubOffset();\
  uint32_t shapeOffset_ = this->stubOffset();\
  return { idId_, propNamesOffset_, shapeOffset_ };\
}\
\
struct ObjectToIteratorResultArgs final { ObjOperandId objId; uint32_t enumeratorsAddrOffset; };\
ObjectToIteratorResultArgs argsForObjectToIteratorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ObjectToIteratorResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t enumeratorsAddrOffset_ = this->stubOffset();\
  return { objId_, enumeratorsAddrOffset_ };\
}\
\
struct ValueToIteratorResultArgs final { ValOperandId valId; };\
ValueToIteratorResultArgs argsForValueToIteratorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ValueToIteratorResult);\
  ValOperandId valId_ = this->valOperandId();\
  return { valId_ };\
}\
\
struct LoadDOMExpandoValueArgs final { ObjOperandId objId; ValOperandId resultId; };\
LoadDOMExpandoValueArgs argsForLoadDOMExpandoValue() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDOMExpandoValue);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId resultId_ = this->valOperandId();\
  return { objId_, resultId_ };\
}\
\
struct LoadDOMExpandoValueGuardGenerationArgs final { ObjOperandId objId; uint32_t expandoAndGenerationOffset; uint32_t generationOffset; ValOperandId resultId; };\
LoadDOMExpandoValueGuardGenerationArgs argsForLoadDOMExpandoValueGuardGeneration() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDOMExpandoValueGuardGeneration);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t expandoAndGenerationOffset_ = this->stubOffset();\
  uint32_t generationOffset_ = this->stubOffset();\
  ValOperandId resultId_ = this->valOperandId();\
  return { objId_, expandoAndGenerationOffset_, generationOffset_, resultId_ };\
}\
\
struct LoadDOMExpandoValueIgnoreGenerationArgs final { ObjOperandId objId; ValOperandId resultId; };\
LoadDOMExpandoValueIgnoreGenerationArgs argsForLoadDOMExpandoValueIgnoreGeneration() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDOMExpandoValueIgnoreGeneration);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId resultId_ = this->valOperandId();\
  return { objId_, resultId_ };\
}\
\
struct GuardDOMExpandoMissingOrGuardShapeArgs final { ValOperandId expandoId; uint32_t shapeOffset; };\
GuardDOMExpandoMissingOrGuardShapeArgs argsForGuardDOMExpandoMissingOrGuardShape() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardDOMExpandoMissingOrGuardShape);\
  ValOperandId expandoId_ = this->valOperandId();\
  uint32_t shapeOffset_ = this->stubOffset();\
  return { expandoId_, shapeOffset_ };\
}\
\
struct StoreFixedSlotArgs final { ObjOperandId objId; uint32_t offsetOffset; ValOperandId rhsId; };\
StoreFixedSlotArgs argsForStoreFixedSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StoreFixedSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { objId_, offsetOffset_, rhsId_ };\
}\
\
struct StoreDynamicSlotArgs final { ObjOperandId objId; uint32_t offsetOffset; ValOperandId rhsId; };\
StoreDynamicSlotArgs argsForStoreDynamicSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StoreDynamicSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { objId_, offsetOffset_, rhsId_ };\
}\
\
struct AddAndStoreFixedSlotArgs final { ObjOperandId objId; uint32_t offsetOffset; ValOperandId rhsId; uint32_t newShapeOffset; bool preserveWrapper; };\
AddAndStoreFixedSlotArgs argsForAddAndStoreFixedSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AddAndStoreFixedSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  uint32_t newShapeOffset_ = this->stubOffset();\
  bool preserveWrapper_ = this->readBool();\
  return { objId_, offsetOffset_, rhsId_, newShapeOffset_, preserveWrapper_ };\
}\
\
struct AddAndStoreDynamicSlotArgs final { ObjOperandId objId; uint32_t offsetOffset; ValOperandId rhsId; uint32_t newShapeOffset; bool preserveWrapper; };\
AddAndStoreDynamicSlotArgs argsForAddAndStoreDynamicSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AddAndStoreDynamicSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  uint32_t newShapeOffset_ = this->stubOffset();\
  bool preserveWrapper_ = this->readBool();\
  return { objId_, offsetOffset_, rhsId_, newShapeOffset_, preserveWrapper_ };\
}\
\
struct AllocateAndStoreDynamicSlotArgs final { ObjOperandId objId; uint32_t offsetOffset; ValOperandId rhsId; uint32_t newShapeOffset; uint32_t numNewSlotsOffset; bool preserveWrapper; };\
AllocateAndStoreDynamicSlotArgs argsForAllocateAndStoreDynamicSlot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AllocateAndStoreDynamicSlot);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  uint32_t newShapeOffset_ = this->stubOffset();\
  uint32_t numNewSlotsOffset_ = this->stubOffset();\
  bool preserveWrapper_ = this->readBool();\
  return { objId_, offsetOffset_, rhsId_, newShapeOffset_, numNewSlotsOffset_, preserveWrapper_ };\
}\
\
struct AddSlotAndCallAddPropHookArgs final { ObjOperandId objId; ValOperandId rhsId; uint32_t newShapeOffset; };\
AddSlotAndCallAddPropHookArgs argsForAddSlotAndCallAddPropHook() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AddSlotAndCallAddPropHook);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  uint32_t newShapeOffset_ = this->stubOffset();\
  return { objId_, rhsId_, newShapeOffset_ };\
}\
\
struct StoreDenseElementArgs final { ObjOperandId objId; Int32OperandId indexId; ValOperandId rhsId; bool expectPackedElements; };\
StoreDenseElementArgs argsForStoreDenseElement() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StoreDenseElement);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool expectPackedElements_ = this->readBool();\
  return { objId_, indexId_, rhsId_, expectPackedElements_ };\
}\
\
struct StoreDenseElementHoleArgs final { ObjOperandId objId; Int32OperandId indexId; ValOperandId rhsId; bool handleAdd; };\
StoreDenseElementHoleArgs argsForStoreDenseElementHole() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StoreDenseElementHole);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool handleAdd_ = this->readBool();\
  return { objId_, indexId_, rhsId_, handleAdd_ };\
}\
\
struct ArrayPushArgs final { ObjOperandId objId; ValOperandId rhsId; };\
ArrayPushArgs argsForArrayPush() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ArrayPush);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { objId_, rhsId_ };\
}\
\
struct ArrayJoinResultArgs final { ObjOperandId objId; StringOperandId sepId; };\
ArrayJoinResultArgs argsForArrayJoinResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ArrayJoinResult);\
  ObjOperandId objId_ = this->objOperandId();\
  StringOperandId sepId_ = this->stringOperandId();\
  return { objId_, sepId_ };\
}\
\
struct ObjectKeysResultArgs final { ObjOperandId objId; uint32_t resultShapeOffset; };\
ObjectKeysResultArgs argsForObjectKeysResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ObjectKeysResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t resultShapeOffset_ = this->stubOffset();\
  return { objId_, resultShapeOffset_ };\
}\
\
struct PackedArrayPopResultArgs final { ObjOperandId arrayId; };\
PackedArrayPopResultArgs argsForPackedArrayPopResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::PackedArrayPopResult);\
  ObjOperandId arrayId_ = this->objOperandId();\
  return { arrayId_ };\
}\
\
struct PackedArrayShiftResultArgs final { ObjOperandId arrayId; };\
PackedArrayShiftResultArgs argsForPackedArrayShiftResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::PackedArrayShiftResult);\
  ObjOperandId arrayId_ = this->objOperandId();\
  return { arrayId_ };\
}\
\
struct PackedArraySliceResultArgs final { uint32_t templateObjectOffset; ObjOperandId arrayId; Int32OperandId beginId; Int32OperandId endId; };\
PackedArraySliceResultArgs argsForPackedArraySliceResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::PackedArraySliceResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  ObjOperandId arrayId_ = this->objOperandId();\
  Int32OperandId beginId_ = this->int32OperandId();\
  Int32OperandId endId_ = this->int32OperandId();\
  return { templateObjectOffset_, arrayId_, beginId_, endId_ };\
}\
\
struct ArgumentsSliceResultArgs final { uint32_t templateObjectOffset; ObjOperandId argsId; Int32OperandId beginId; Int32OperandId endId; };\
ArgumentsSliceResultArgs argsForArgumentsSliceResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ArgumentsSliceResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  ObjOperandId argsId_ = this->objOperandId();\
  Int32OperandId beginId_ = this->int32OperandId();\
  Int32OperandId endId_ = this->int32OperandId();\
  return { templateObjectOffset_, argsId_, beginId_, endId_ };\
}\
\
struct IsArrayResultArgs final { ValOperandId inputId; };\
IsArrayResultArgs argsForIsArrayResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsArrayResult);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct StoreFixedSlotUndefinedResultArgs final { ObjOperandId objId; uint32_t offsetOffset; ValOperandId rhsId; };\
StoreFixedSlotUndefinedResultArgs argsForStoreFixedSlotUndefinedResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StoreFixedSlotUndefinedResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { objId_, offsetOffset_, rhsId_ };\
}\
\
struct IsObjectResultArgs final { ValOperandId inputId; };\
IsObjectResultArgs argsForIsObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsObjectResult);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct IsPackedArrayResultArgs final { ObjOperandId objId; };\
IsPackedArrayResultArgs argsForIsPackedArrayResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsPackedArrayResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct IsCallableResultArgs final { ValOperandId inputId; };\
IsCallableResultArgs argsForIsCallableResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsCallableResult);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct IsConstructorResultArgs final { ObjOperandId objId; };\
IsConstructorResultArgs argsForIsConstructorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsConstructorResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct IsCrossRealmArrayConstructorResultArgs final { ObjOperandId objId; };\
IsCrossRealmArrayConstructorResultArgs argsForIsCrossRealmArrayConstructorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsCrossRealmArrayConstructorResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct IsTypedArrayResultArgs final { ObjOperandId objId; bool isPossiblyWrapped; };\
IsTypedArrayResultArgs argsForIsTypedArrayResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsTypedArrayResult);\
  ObjOperandId objId_ = this->objOperandId();\
  bool isPossiblyWrapped_ = this->readBool();\
  return { objId_, isPossiblyWrapped_ };\
}\
\
struct IsTypedArrayConstructorResultArgs final { ObjOperandId objId; };\
IsTypedArrayConstructorResultArgs argsForIsTypedArrayConstructorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IsTypedArrayConstructorResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ArrayBufferViewByteOffsetInt32ResultArgs final { ObjOperandId objId; };\
ArrayBufferViewByteOffsetInt32ResultArgs argsForArrayBufferViewByteOffsetInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ArrayBufferViewByteOffsetInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ArrayBufferViewByteOffsetDoubleResultArgs final { ObjOperandId objId; };\
ArrayBufferViewByteOffsetDoubleResultArgs argsForArrayBufferViewByteOffsetDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ArrayBufferViewByteOffsetDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct TypedArrayByteLengthInt32ResultArgs final { ObjOperandId objId; };\
TypedArrayByteLengthInt32ResultArgs argsForTypedArrayByteLengthInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::TypedArrayByteLengthInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct TypedArrayByteLengthDoubleResultArgs final { ObjOperandId objId; };\
TypedArrayByteLengthDoubleResultArgs argsForTypedArrayByteLengthDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::TypedArrayByteLengthDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ResizableTypedArrayByteLengthInt32ResultArgs final { ObjOperandId objId; };\
ResizableTypedArrayByteLengthInt32ResultArgs argsForResizableTypedArrayByteLengthInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ResizableTypedArrayByteLengthInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ResizableTypedArrayByteLengthDoubleResultArgs final { ObjOperandId objId; };\
ResizableTypedArrayByteLengthDoubleResultArgs argsForResizableTypedArrayByteLengthDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ResizableTypedArrayByteLengthDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ResizableTypedArrayLengthInt32ResultArgs final { ObjOperandId objId; };\
ResizableTypedArrayLengthInt32ResultArgs argsForResizableTypedArrayLengthInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ResizableTypedArrayLengthInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ResizableTypedArrayLengthDoubleResultArgs final { ObjOperandId objId; };\
ResizableTypedArrayLengthDoubleResultArgs argsForResizableTypedArrayLengthDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ResizableTypedArrayLengthDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ResizableDataViewByteLengthInt32ResultArgs final { ObjOperandId objId; };\
ResizableDataViewByteLengthInt32ResultArgs argsForResizableDataViewByteLengthInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ResizableDataViewByteLengthInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ResizableDataViewByteLengthDoubleResultArgs final { ObjOperandId objId; };\
ResizableDataViewByteLengthDoubleResultArgs argsForResizableDataViewByteLengthDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ResizableDataViewByteLengthDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GrowableSharedArrayBufferByteLengthInt32ResultArgs final { ObjOperandId objId; };\
GrowableSharedArrayBufferByteLengthInt32ResultArgs argsForGrowableSharedArrayBufferByteLengthInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GrowableSharedArrayBufferByteLengthInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GrowableSharedArrayBufferByteLengthDoubleResultArgs final { ObjOperandId objId; };\
GrowableSharedArrayBufferByteLengthDoubleResultArgs argsForGrowableSharedArrayBufferByteLengthDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GrowableSharedArrayBufferByteLengthDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardHasAttachedArrayBufferArgs final { ObjOperandId objId; };\
GuardHasAttachedArrayBufferArgs argsForGuardHasAttachedArrayBuffer() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardHasAttachedArrayBuffer);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardResizableArrayBufferViewInBoundsArgs final { ObjOperandId objId; };\
GuardResizableArrayBufferViewInBoundsArgs argsForGuardResizableArrayBufferViewInBounds() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardResizableArrayBufferViewInBounds);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct GuardResizableArrayBufferViewInBoundsOrDetachedArgs final { ObjOperandId objId; };\
GuardResizableArrayBufferViewInBoundsOrDetachedArgs argsForGuardResizableArrayBufferViewInBoundsOrDetached() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardResizableArrayBufferViewInBoundsOrDetached);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct TypedArrayFillResultArgs final { ObjOperandId objId; uint32_t fillValueId; IntPtrOperandId startId; IntPtrOperandId endId; Scalar::Type elementType; };\
TypedArrayFillResultArgs argsForTypedArrayFillResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::TypedArrayFillResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t fillValueId_ = this->rawOperandId();\
  IntPtrOperandId startId_ = this->intPtrOperandId();\
  IntPtrOperandId endId_ = this->intPtrOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  return { objId_, fillValueId_, startId_, endId_, elementType_ };\
}\
\
struct TypedArraySetResultArgs final { ObjOperandId targetId; ObjOperandId sourceId; IntPtrOperandId offsetId; bool canUseBitwiseCopy; };\
TypedArraySetResultArgs argsForTypedArraySetResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::TypedArraySetResult);\
  ObjOperandId targetId_ = this->objOperandId();\
  ObjOperandId sourceId_ = this->objOperandId();\
  IntPtrOperandId offsetId_ = this->intPtrOperandId();\
  bool canUseBitwiseCopy_ = this->readBool();\
  return { targetId_, sourceId_, offsetId_, canUseBitwiseCopy_ };\
}\
\
struct TypedArraySubarrayResultArgs final { uint32_t templateObjectOffset; ObjOperandId objId; IntPtrOperandId startId; IntPtrOperandId endId; };\
TypedArraySubarrayResultArgs argsForTypedArraySubarrayResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::TypedArraySubarrayResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId startId_ = this->intPtrOperandId();\
  IntPtrOperandId endId_ = this->intPtrOperandId();\
  return { templateObjectOffset_, objId_, startId_, endId_ };\
}\
\
struct NewArrayIteratorResultArgs final { uint32_t templateObjectOffset; };\
NewArrayIteratorResultArgs argsForNewArrayIteratorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewArrayIteratorResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { templateObjectOffset_ };\
}\
\
struct NewStringIteratorResultArgs final { uint32_t templateObjectOffset; };\
NewStringIteratorResultArgs argsForNewStringIteratorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewStringIteratorResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { templateObjectOffset_ };\
}\
\
struct NewRegExpStringIteratorResultArgs final { uint32_t templateObjectOffset; };\
NewRegExpStringIteratorResultArgs argsForNewRegExpStringIteratorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewRegExpStringIteratorResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { templateObjectOffset_ };\
}\
\
struct ObjectCreateResultArgs final { uint32_t templateObjectOffset; };\
ObjectCreateResultArgs argsForObjectCreateResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ObjectCreateResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { templateObjectOffset_ };\
}\
\
struct NewArrayFromLengthResultArgs final { uint32_t templateObjectOffset; Int32OperandId lengthId; uint32_t siteOffset; };\
NewArrayFromLengthResultArgs argsForNewArrayFromLengthResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewArrayFromLengthResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  Int32OperandId lengthId_ = this->int32OperandId();\
  uint32_t siteOffset_ = this->stubOffset();\
  return { templateObjectOffset_, lengthId_, siteOffset_ };\
}\
\
struct NewTypedArrayFromLengthResultArgs final { uint32_t templateObjectOffset; Int32OperandId lengthId; };\
NewTypedArrayFromLengthResultArgs argsForNewTypedArrayFromLengthResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewTypedArrayFromLengthResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  Int32OperandId lengthId_ = this->int32OperandId();\
  return { templateObjectOffset_, lengthId_ };\
}\
\
struct NewTypedArrayFromArrayBufferResultArgs final { uint32_t templateObjectOffset; ObjOperandId bufferId; ValOperandId byteOffsetId; ValOperandId lengthId; };\
NewTypedArrayFromArrayBufferResultArgs argsForNewTypedArrayFromArrayBufferResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewTypedArrayFromArrayBufferResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  ObjOperandId bufferId_ = this->objOperandId();\
  ValOperandId byteOffsetId_ = this->valOperandId();\
  ValOperandId lengthId_ = this->valOperandId();\
  return { templateObjectOffset_, bufferId_, byteOffsetId_, lengthId_ };\
}\
\
struct NewTypedArrayFromArrayResultArgs final { uint32_t templateObjectOffset; ObjOperandId arrayId; };\
NewTypedArrayFromArrayResultArgs argsForNewTypedArrayFromArrayResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewTypedArrayFromArrayResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  ObjOperandId arrayId_ = this->objOperandId();\
  return { templateObjectOffset_, arrayId_ };\
}\
\
struct NewMapObjectResultArgs final { uint32_t templateObjectOffset; };\
NewMapObjectResultArgs argsForNewMapObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewMapObjectResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { templateObjectOffset_ };\
}\
\
struct NewSetObjectResultArgs final { uint32_t templateObjectOffset; };\
NewSetObjectResultArgs argsForNewSetObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewSetObjectResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { templateObjectOffset_ };\
}\
\
struct NewMapObjectFromIterableResultArgs final { uint32_t templateObjectOffset; ValOperandId iterableId; };\
NewMapObjectFromIterableResultArgs argsForNewMapObjectFromIterableResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewMapObjectFromIterableResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  ValOperandId iterableId_ = this->valOperandId();\
  return { templateObjectOffset_, iterableId_ };\
}\
\
struct NewSetObjectFromIterableResultArgs final { uint32_t templateObjectOffset; ValOperandId iterableId; };\
NewSetObjectFromIterableResultArgs argsForNewSetObjectFromIterableResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewSetObjectFromIterableResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  ValOperandId iterableId_ = this->valOperandId();\
  return { templateObjectOffset_, iterableId_ };\
}\
\
struct NewStringObjectResultArgs final { uint32_t templateObjectOffset; StringOperandId strId; };\
NewStringObjectResultArgs argsForNewStringObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewStringObjectResult);\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  StringOperandId strId_ = this->stringOperandId();\
  return { templateObjectOffset_, strId_ };\
}\
\
struct StringFromCharCodeResultArgs final { Int32OperandId codeId; };\
StringFromCharCodeResultArgs argsForStringFromCharCodeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringFromCharCodeResult);\
  Int32OperandId codeId_ = this->int32OperandId();\
  return { codeId_ };\
}\
\
struct StringFromCodePointResultArgs final { Int32OperandId codeId; };\
StringFromCodePointResultArgs argsForStringFromCodePointResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringFromCodePointResult);\
  Int32OperandId codeId_ = this->int32OperandId();\
  return { codeId_ };\
}\
\
struct StringIncludesResultArgs final { StringOperandId strId; StringOperandId searchStrId; };\
StringIncludesResultArgs argsForStringIncludesResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringIncludesResult);\
  StringOperandId strId_ = this->stringOperandId();\
  StringOperandId searchStrId_ = this->stringOperandId();\
  return { strId_, searchStrId_ };\
}\
\
struct StringIndexOfResultArgs final { StringOperandId strId; StringOperandId searchStrId; };\
StringIndexOfResultArgs argsForStringIndexOfResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringIndexOfResult);\
  StringOperandId strId_ = this->stringOperandId();\
  StringOperandId searchStrId_ = this->stringOperandId();\
  return { strId_, searchStrId_ };\
}\
\
struct StringLastIndexOfResultArgs final { StringOperandId strId; StringOperandId searchStrId; };\
StringLastIndexOfResultArgs argsForStringLastIndexOfResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringLastIndexOfResult);\
  StringOperandId strId_ = this->stringOperandId();\
  StringOperandId searchStrId_ = this->stringOperandId();\
  return { strId_, searchStrId_ };\
}\
\
struct StringStartsWithResultArgs final { StringOperandId strId; StringOperandId searchStrId; };\
StringStartsWithResultArgs argsForStringStartsWithResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringStartsWithResult);\
  StringOperandId strId_ = this->stringOperandId();\
  StringOperandId searchStrId_ = this->stringOperandId();\
  return { strId_, searchStrId_ };\
}\
\
struct StringEndsWithResultArgs final { StringOperandId strId; StringOperandId searchStrId; };\
StringEndsWithResultArgs argsForStringEndsWithResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringEndsWithResult);\
  StringOperandId strId_ = this->stringOperandId();\
  StringOperandId searchStrId_ = this->stringOperandId();\
  return { strId_, searchStrId_ };\
}\
\
struct StringToLowerCaseResultArgs final { StringOperandId strId; };\
StringToLowerCaseResultArgs argsForStringToLowerCaseResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringToLowerCaseResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct StringToUpperCaseResultArgs final { StringOperandId strId; };\
StringToUpperCaseResultArgs argsForStringToUpperCaseResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringToUpperCaseResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct StringTrimResultArgs final { StringOperandId strId; };\
StringTrimResultArgs argsForStringTrimResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringTrimResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct StringTrimStartResultArgs final { StringOperandId strId; };\
StringTrimStartResultArgs argsForStringTrimStartResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringTrimStartResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct StringTrimEndResultArgs final { StringOperandId strId; };\
StringTrimEndResultArgs argsForStringTrimEndResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StringTrimEndResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct MathAbsInt32ResultArgs final { Int32OperandId inputId; };\
MathAbsInt32ResultArgs argsForMathAbsInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathAbsInt32Result);\
  Int32OperandId inputId_ = this->int32OperandId();\
  return { inputId_ };\
}\
\
struct MathAbsNumberResultArgs final { NumberOperandId inputId; };\
MathAbsNumberResultArgs argsForMathAbsNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathAbsNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathClz32ResultArgs final { Int32OperandId inputId; };\
MathClz32ResultArgs argsForMathClz32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathClz32Result);\
  Int32OperandId inputId_ = this->int32OperandId();\
  return { inputId_ };\
}\
\
struct MathSignInt32ResultArgs final { Int32OperandId inputId; };\
MathSignInt32ResultArgs argsForMathSignInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathSignInt32Result);\
  Int32OperandId inputId_ = this->int32OperandId();\
  return { inputId_ };\
}\
\
struct MathSignNumberResultArgs final { NumberOperandId inputId; };\
MathSignNumberResultArgs argsForMathSignNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathSignNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathSignNumberToInt32ResultArgs final { NumberOperandId inputId; };\
MathSignNumberToInt32ResultArgs argsForMathSignNumberToInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathSignNumberToInt32Result);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathImulResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
MathImulResultArgs argsForMathImulResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathImulResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct MathSqrtNumberResultArgs final { NumberOperandId inputId; };\
MathSqrtNumberResultArgs argsForMathSqrtNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathSqrtNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathFRoundNumberResultArgs final { NumberOperandId inputId; };\
MathFRoundNumberResultArgs argsForMathFRoundNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathFRoundNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathF16RoundNumberResultArgs final { NumberOperandId inputId; };\
MathF16RoundNumberResultArgs argsForMathF16RoundNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathF16RoundNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathRandomResultArgs final { uint32_t rngOffset; };\
MathRandomResultArgs argsForMathRandomResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathRandomResult);\
  uint32_t rngOffset_ = this->stubOffset();\
  return { rngOffset_ };\
}\
\
struct MathHypot2NumberResultArgs final { NumberOperandId firstId; NumberOperandId secondId; };\
MathHypot2NumberResultArgs argsForMathHypot2NumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathHypot2NumberResult);\
  NumberOperandId firstId_ = this->numberOperandId();\
  NumberOperandId secondId_ = this->numberOperandId();\
  return { firstId_, secondId_ };\
}\
\
struct MathHypot3NumberResultArgs final { NumberOperandId firstId; NumberOperandId secondId; NumberOperandId thirdId; };\
MathHypot3NumberResultArgs argsForMathHypot3NumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathHypot3NumberResult);\
  NumberOperandId firstId_ = this->numberOperandId();\
  NumberOperandId secondId_ = this->numberOperandId();\
  NumberOperandId thirdId_ = this->numberOperandId();\
  return { firstId_, secondId_, thirdId_ };\
}\
\
struct MathHypot4NumberResultArgs final { NumberOperandId firstId; NumberOperandId secondId; NumberOperandId thirdId; NumberOperandId fourthId; };\
MathHypot4NumberResultArgs argsForMathHypot4NumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathHypot4NumberResult);\
  NumberOperandId firstId_ = this->numberOperandId();\
  NumberOperandId secondId_ = this->numberOperandId();\
  NumberOperandId thirdId_ = this->numberOperandId();\
  NumberOperandId fourthId_ = this->numberOperandId();\
  return { firstId_, secondId_, thirdId_, fourthId_ };\
}\
\
struct MathAtan2NumberResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
MathAtan2NumberResultArgs argsForMathAtan2NumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathAtan2NumberResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct MathFloorNumberResultArgs final { NumberOperandId inputId; };\
MathFloorNumberResultArgs argsForMathFloorNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathFloorNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathCeilNumberResultArgs final { NumberOperandId inputId; };\
MathCeilNumberResultArgs argsForMathCeilNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathCeilNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathTruncNumberResultArgs final { NumberOperandId inputId; };\
MathTruncNumberResultArgs argsForMathTruncNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathTruncNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathRoundNumberResultArgs final { NumberOperandId inputId; };\
MathRoundNumberResultArgs argsForMathRoundNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathRoundNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathFloorToInt32ResultArgs final { NumberOperandId inputId; };\
MathFloorToInt32ResultArgs argsForMathFloorToInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathFloorToInt32Result);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathCeilToInt32ResultArgs final { NumberOperandId inputId; };\
MathCeilToInt32ResultArgs argsForMathCeilToInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathCeilToInt32Result);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathTruncToInt32ResultArgs final { NumberOperandId inputId; };\
MathTruncToInt32ResultArgs argsForMathTruncToInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathTruncToInt32Result);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct MathRoundToInt32ResultArgs final { NumberOperandId inputId; };\
MathRoundToInt32ResultArgs argsForMathRoundToInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathRoundToInt32Result);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct Int32MinMaxArgs final { bool isMax; Int32OperandId firstId; Int32OperandId secondId; Int32OperandId resultId; };\
Int32MinMaxArgs argsForInt32MinMax() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32MinMax);\
  bool isMax_ = this->readBool();\
  Int32OperandId firstId_ = this->int32OperandId();\
  Int32OperandId secondId_ = this->int32OperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { isMax_, firstId_, secondId_, resultId_ };\
}\
\
struct NumberMinMaxArgs final { bool isMax; NumberOperandId firstId; NumberOperandId secondId; NumberOperandId resultId; };\
NumberMinMaxArgs argsForNumberMinMax() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NumberMinMax);\
  bool isMax_ = this->readBool();\
  NumberOperandId firstId_ = this->numberOperandId();\
  NumberOperandId secondId_ = this->numberOperandId();\
  NumberOperandId resultId_ = this->numberOperandId();\
  return { isMax_, firstId_, secondId_, resultId_ };\
}\
\
struct Int32MinMaxArrayResultArgs final { ObjOperandId arrayId; bool isMax; };\
Int32MinMaxArrayResultArgs argsForInt32MinMaxArrayResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32MinMaxArrayResult);\
  ObjOperandId arrayId_ = this->objOperandId();\
  bool isMax_ = this->readBool();\
  return { arrayId_, isMax_ };\
}\
\
struct NumberMinMaxArrayResultArgs final { ObjOperandId arrayId; bool isMax; };\
NumberMinMaxArrayResultArgs argsForNumberMinMaxArrayResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NumberMinMaxArrayResult);\
  ObjOperandId arrayId_ = this->objOperandId();\
  bool isMax_ = this->readBool();\
  return { arrayId_, isMax_ };\
}\
\
struct MathFunctionNumberResultArgs final { NumberOperandId inputId; UnaryMathFunction fun; };\
MathFunctionNumberResultArgs argsForMathFunctionNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MathFunctionNumberResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  UnaryMathFunction fun_ = this->unaryMathFunction();\
  return { inputId_, fun_ };\
}\
\
struct NumberParseIntResultArgs final { StringOperandId strId; Int32OperandId radixId; };\
NumberParseIntResultArgs argsForNumberParseIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NumberParseIntResult);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId radixId_ = this->int32OperandId();\
  return { strId_, radixId_ };\
}\
\
struct DoubleParseIntResultArgs final { NumberOperandId numId; };\
DoubleParseIntResultArgs argsForDoubleParseIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleParseIntResult);\
  NumberOperandId numId_ = this->numberOperandId();\
  return { numId_ };\
}\
\
struct ObjectToStringResultArgs final { ObjOperandId objId; };\
ObjectToStringResultArgs argsForObjectToStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ObjectToStringResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct ReflectGetPrototypeOfResultArgs final { ObjOperandId objId; };\
ReflectGetPrototypeOfResultArgs argsForReflectGetPrototypeOfResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ReflectGetPrototypeOfResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct StoreTypedArrayElementArgs final { ObjOperandId objId; Scalar::Type elementType; IntPtrOperandId indexId; uint32_t rhsId; bool handleOOB; ArrayBufferViewKind viewKind; };\
StoreTypedArrayElementArgs argsForStoreTypedArrayElement() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StoreTypedArrayElement);\
  ObjOperandId objId_ = this->objOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t rhsId_ = this->rawOperandId();\
  bool handleOOB_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, elementType_, indexId_, rhsId_, handleOOB_, viewKind_ };\
}\
\
struct AtomicsCompareExchangeResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t expectedId; uint32_t replacementId; Scalar::Type elementType; ArrayBufferViewKind viewKind; };\
AtomicsCompareExchangeResultArgs argsForAtomicsCompareExchangeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsCompareExchangeResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t expectedId_ = this->rawOperandId();\
  uint32_t replacementId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, expectedId_, replacementId_, elementType_, viewKind_ };\
}\
\
struct AtomicsExchangeResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t valueId; Scalar::Type elementType; ArrayBufferViewKind viewKind; };\
AtomicsExchangeResultArgs argsForAtomicsExchangeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsExchangeResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, valueId_, elementType_, viewKind_ };\
}\
\
struct AtomicsAddResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t valueId; Scalar::Type elementType; bool forEffect; ArrayBufferViewKind viewKind; };\
AtomicsAddResultArgs argsForAtomicsAddResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsAddResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  bool forEffect_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, valueId_, elementType_, forEffect_, viewKind_ };\
}\
\
struct AtomicsSubResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t valueId; Scalar::Type elementType; bool forEffect; ArrayBufferViewKind viewKind; };\
AtomicsSubResultArgs argsForAtomicsSubResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsSubResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  bool forEffect_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, valueId_, elementType_, forEffect_, viewKind_ };\
}\
\
struct AtomicsAndResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t valueId; Scalar::Type elementType; bool forEffect; ArrayBufferViewKind viewKind; };\
AtomicsAndResultArgs argsForAtomicsAndResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsAndResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  bool forEffect_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, valueId_, elementType_, forEffect_, viewKind_ };\
}\
\
struct AtomicsOrResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t valueId; Scalar::Type elementType; bool forEffect; ArrayBufferViewKind viewKind; };\
AtomicsOrResultArgs argsForAtomicsOrResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsOrResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  bool forEffect_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, valueId_, elementType_, forEffect_, viewKind_ };\
}\
\
struct AtomicsXorResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t valueId; Scalar::Type elementType; bool forEffect; ArrayBufferViewKind viewKind; };\
AtomicsXorResultArgs argsForAtomicsXorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsXorResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  bool forEffect_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, valueId_, elementType_, forEffect_, viewKind_ };\
}\
\
struct AtomicsLoadResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; Scalar::Type elementType; ArrayBufferViewKind viewKind; };\
AtomicsLoadResultArgs argsForAtomicsLoadResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsLoadResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, elementType_, viewKind_ };\
}\
\
struct AtomicsStoreResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; uint32_t valueId; Scalar::Type elementType; ArrayBufferViewKind viewKind; };\
AtomicsStoreResultArgs argsForAtomicsStoreResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsStoreResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, valueId_, elementType_, viewKind_ };\
}\
\
struct AtomicsIsLockFreeResultArgs final { Int32OperandId valueId; };\
AtomicsIsLockFreeResultArgs argsForAtomicsIsLockFreeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsIsLockFreeResult);\
  Int32OperandId valueId_ = this->int32OperandId();\
  return { valueId_ };\
}\
\
struct AtomicsPauseResultArgs final {  };\
AtomicsPauseResultArgs argsForAtomicsPauseResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AtomicsPauseResult);\
  return {  };\
}\
\
struct CallNativeSetterArgs final { ObjOperandId receiverId; uint32_t setterOffset; ValOperandId rhsId; bool sameRealm; uint32_t nargsAndFlagsOffset; };\
CallNativeSetterArgs argsForCallNativeSetter() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallNativeSetter);\
  ObjOperandId receiverId_ = this->objOperandId();\
  uint32_t setterOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool sameRealm_ = this->readBool();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { receiverId_, setterOffset_, rhsId_, sameRealm_, nargsAndFlagsOffset_ };\
}\
\
struct CallScriptedSetterArgs final { ObjOperandId receiverId; ObjOperandId calleeId; ValOperandId rhsId; bool sameRealm; uint32_t nargsAndFlagsOffset; };\
CallScriptedSetterArgs argsForCallScriptedSetter() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallScriptedSetter);\
  ObjOperandId receiverId_ = this->objOperandId();\
  ObjOperandId calleeId_ = this->objOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool sameRealm_ = this->readBool();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { receiverId_, calleeId_, rhsId_, sameRealm_, nargsAndFlagsOffset_ };\
}\
\
struct CallInlinedSetterArgs final { ObjOperandId receiverId; ObjOperandId calleeId; ValOperandId rhsId; uint32_t icScriptOffset; bool sameRealm; uint32_t nargsAndFlagsOffset; };\
CallInlinedSetterArgs argsForCallInlinedSetter() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallInlinedSetter);\
  ObjOperandId receiverId_ = this->objOperandId();\
  ObjOperandId calleeId_ = this->objOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  uint32_t icScriptOffset_ = this->stubOffset();\
  bool sameRealm_ = this->readBool();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { receiverId_, calleeId_, rhsId_, icScriptOffset_, sameRealm_, nargsAndFlagsOffset_ };\
}\
\
struct CallDOMSetterArgs final { ObjOperandId objId; uint32_t jitInfoOffset; ValOperandId rhsId; };\
CallDOMSetterArgs argsForCallDOMSetter() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallDOMSetter);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t jitInfoOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { objId_, jitInfoOffset_, rhsId_ };\
}\
\
struct CallSetArrayLengthArgs final { ObjOperandId objId; bool strict; ValOperandId rhsId; };\
CallSetArrayLengthArgs argsForCallSetArrayLength() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallSetArrayLength);\
  ObjOperandId objId_ = this->objOperandId();\
  bool strict_ = this->readBool();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { objId_, strict_, rhsId_ };\
}\
\
struct ProxySetArgs final { ObjOperandId objId; uint32_t idOffset; ValOperandId rhsId; bool strict; };\
ProxySetArgs argsForProxySet() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ProxySet);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t idOffset_ = this->stubOffset();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool strict_ = this->readBool();\
  return { objId_, idOffset_, rhsId_, strict_ };\
}\
\
struct ProxySetByValueArgs final { ObjOperandId objId; ValOperandId idId; ValOperandId rhsId; bool strict; };\
ProxySetByValueArgs argsForProxySetByValue() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ProxySetByValue);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool strict_ = this->readBool();\
  return { objId_, idId_, rhsId_, strict_ };\
}\
\
struct CallAddOrUpdateSparseElementHelperArgs final { ObjOperandId objId; Int32OperandId idId; ValOperandId rhsId; bool strict; };\
CallAddOrUpdateSparseElementHelperArgs argsForCallAddOrUpdateSparseElementHelper() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallAddOrUpdateSparseElementHelper);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId idId_ = this->int32OperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  bool strict_ = this->readBool();\
  return { objId_, idId_, rhsId_, strict_ };\
}\
\
struct CallInt32ToStringArgs final { Int32OperandId inputId; StringOperandId resultId; };\
CallInt32ToStringArgs argsForCallInt32ToString() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallInt32ToString);\
  Int32OperandId inputId_ = this->int32OperandId();\
  StringOperandId resultId_ = this->stringOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct CallNumberToStringArgs final { NumberOperandId inputId; StringOperandId resultId; };\
CallNumberToStringArgs argsForCallNumberToString() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallNumberToString);\
  NumberOperandId inputId_ = this->numberOperandId();\
  StringOperandId resultId_ = this->stringOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct Int32ToStringWithBaseResultArgs final { Int32OperandId inputId; Int32OperandId baseId; };\
Int32ToStringWithBaseResultArgs argsForInt32ToStringWithBaseResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32ToStringWithBaseResult);\
  Int32OperandId inputId_ = this->int32OperandId();\
  Int32OperandId baseId_ = this->int32OperandId();\
  return { inputId_, baseId_ };\
}\
\
struct BooleanToStringArgs final { BooleanOperandId inputId; StringOperandId resultId; };\
BooleanToStringArgs argsForBooleanToString() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BooleanToString);\
  BooleanOperandId inputId_ = this->booleanOperandId();\
  StringOperandId resultId_ = this->stringOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct CallScriptedFunctionArgs final { ObjOperandId calleeId; Int32OperandId argcId; CallFlags flags; uint32_t argcFixed; };\
CallScriptedFunctionArgs argsForCallScriptedFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallScriptedFunction);\
  ObjOperandId calleeId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  CallFlags flags_ = this->callFlags();\
  uint32_t argcFixed_ = this->uint32Immediate();\
  return { calleeId_, argcId_, flags_, argcFixed_ };\
}\
\
struct CallBoundScriptedFunctionArgs final { ObjOperandId calleeId; ObjOperandId targetId; Int32OperandId argcId; CallFlags flags; uint32_t numBoundArgs; };\
CallBoundScriptedFunctionArgs argsForCallBoundScriptedFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallBoundScriptedFunction);\
  ObjOperandId calleeId_ = this->objOperandId();\
  ObjOperandId targetId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  CallFlags flags_ = this->callFlags();\
  uint32_t numBoundArgs_ = this->uint32Immediate();\
  return { calleeId_, targetId_, argcId_, flags_, numBoundArgs_ };\
}\
\
struct CallWasmFunctionArgs final { ObjOperandId calleeId; Int32OperandId argcId; CallFlags flags; uint32_t argcFixed; uint32_t funcTypeOffset; uint32_t instanceOffset; };\
CallWasmFunctionArgs argsForCallWasmFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallWasmFunction);\
  ObjOperandId calleeId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  CallFlags flags_ = this->callFlags();\
  uint32_t argcFixed_ = this->uint32Immediate();\
  uint32_t funcTypeOffset_ = this->stubOffset();\
  uint32_t instanceOffset_ = this->stubOffset();\
  return { calleeId_, argcId_, flags_, argcFixed_, funcTypeOffset_, instanceOffset_ };\
}\
\
struct GuardWasmArgArgs final { ValOperandId argId; wasm::ValType::Kind type; };\
GuardWasmArgArgs argsForGuardWasmArg() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardWasmArg);\
  ValOperandId argId_ = this->valOperandId();\
  wasm::ValType::Kind type_ = this->wasmValType();\
  return { argId_, type_ };\
}\
\
struct CallNativeFunctionArgs final { ObjOperandId calleeId; Int32OperandId argcId; CallFlags flags; uint32_t argcFixed; bool ignoresReturnValue; };\
CallNativeFunctionArgs argsForCallNativeFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallNativeFunction);\
  ObjOperandId calleeId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  CallFlags flags_ = this->callFlags();\
  uint32_t argcFixed_ = this->uint32Immediate();\
  bool ignoresReturnValue_ = this->readBool();\
  return { calleeId_, argcId_, flags_, argcFixed_, ignoresReturnValue_ };\
}\
\
struct CallDOMFunctionArgs final { ObjOperandId calleeId; Int32OperandId argcId; ObjOperandId thisObjId; CallFlags flags; uint32_t argcFixed; };\
CallDOMFunctionArgs argsForCallDOMFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallDOMFunction);\
  ObjOperandId calleeId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  ObjOperandId thisObjId_ = this->objOperandId();\
  CallFlags flags_ = this->callFlags();\
  uint32_t argcFixed_ = this->uint32Immediate();\
  return { calleeId_, argcId_, thisObjId_, flags_, argcFixed_ };\
}\
\
struct CallDOMFunctionWithAllocSiteArgs final { ObjOperandId calleeId; Int32OperandId argcId; ObjOperandId thisObjId; CallFlags flags; uint32_t argcFixed; uint32_t siteOffset; };\
CallDOMFunctionWithAllocSiteArgs argsForCallDOMFunctionWithAllocSite() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallDOMFunctionWithAllocSite);\
  ObjOperandId calleeId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  ObjOperandId thisObjId_ = this->objOperandId();\
  CallFlags flags_ = this->callFlags();\
  uint32_t argcFixed_ = this->uint32Immediate();\
  uint32_t siteOffset_ = this->stubOffset();\
  return { calleeId_, argcId_, thisObjId_, flags_, argcFixed_, siteOffset_ };\
}\
\
struct CallClassHookArgs final { ObjOperandId calleeId; Int32OperandId argcId; CallFlags flags; uint32_t argcFixed; uint32_t targetOffset; };\
CallClassHookArgs argsForCallClassHook() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallClassHook);\
  ObjOperandId calleeId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  CallFlags flags_ = this->callFlags();\
  uint32_t argcFixed_ = this->uint32Immediate();\
  uint32_t targetOffset_ = this->stubOffset();\
  return { calleeId_, argcId_, flags_, argcFixed_, targetOffset_ };\
}\
\
struct CallInlinedFunctionArgs final { ObjOperandId calleeId; Int32OperandId argcId; uint32_t icScriptOffset; CallFlags flags; uint32_t argcFixed; };\
CallInlinedFunctionArgs argsForCallInlinedFunction() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallInlinedFunction);\
  ObjOperandId calleeId_ = this->objOperandId();\
  Int32OperandId argcId_ = this->int32OperandId();\
  uint32_t icScriptOffset_ = this->stubOffset();\
  CallFlags flags_ = this->callFlags();\
  uint32_t argcFixed_ = this->uint32Immediate();\
  return { calleeId_, argcId_, icScriptOffset_, flags_, argcFixed_ };\
}\
\
struct CallScriptedProxyGetResultArgs final { ValOperandId targetId; ObjOperandId receiverId; ObjOperandId handlerId; ObjOperandId trapId; uint32_t propertyOffset; uint32_t nargsAndFlags; };\
CallScriptedProxyGetResultArgs argsForCallScriptedProxyGetResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallScriptedProxyGetResult);\
  ValOperandId targetId_ = this->valOperandId();\
  ObjOperandId receiverId_ = this->objOperandId();\
  ObjOperandId handlerId_ = this->objOperandId();\
  ObjOperandId trapId_ = this->objOperandId();\
  uint32_t propertyOffset_ = this->stubOffset();\
  uint32_t nargsAndFlags_ = this->uint32Immediate();\
  return { targetId_, receiverId_, handlerId_, trapId_, propertyOffset_, nargsAndFlags_ };\
}\
\
struct CallScriptedProxyGetByValueResultArgs final { ValOperandId targetId; ObjOperandId receiverId; ObjOperandId handlerId; ValOperandId propertyId; ObjOperandId trapId; uint32_t nargsAndFlags; };\
CallScriptedProxyGetByValueResultArgs argsForCallScriptedProxyGetByValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallScriptedProxyGetByValueResult);\
  ValOperandId targetId_ = this->valOperandId();\
  ObjOperandId receiverId_ = this->objOperandId();\
  ObjOperandId handlerId_ = this->objOperandId();\
  ValOperandId propertyId_ = this->valOperandId();\
  ObjOperandId trapId_ = this->objOperandId();\
  uint32_t nargsAndFlags_ = this->uint32Immediate();\
  return { targetId_, receiverId_, handlerId_, propertyId_, trapId_, nargsAndFlags_ };\
}\
\
struct MetaScriptedThisShapeArgs final { uint32_t thisShapeOffset; };\
MetaScriptedThisShapeArgs argsForMetaScriptedThisShape() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MetaScriptedThisShape);\
  uint32_t thisShapeOffset_ = this->stubOffset();\
  return { thisShapeOffset_ };\
}\
\
struct BindFunctionResultArgs final { ObjOperandId targetId; uint32_t argc; uint32_t templateObjectOffset; };\
BindFunctionResultArgs argsForBindFunctionResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BindFunctionResult);\
  ObjOperandId targetId_ = this->objOperandId();\
  uint32_t argc_ = this->uint32Immediate();\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { targetId_, argc_, templateObjectOffset_ };\
}\
\
struct SpecializedBindFunctionResultArgs final { ObjOperandId targetId; uint32_t argc; uint32_t templateObjectOffset; };\
SpecializedBindFunctionResultArgs argsForSpecializedBindFunctionResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SpecializedBindFunctionResult);\
  ObjOperandId targetId_ = this->objOperandId();\
  uint32_t argc_ = this->uint32Immediate();\
  uint32_t templateObjectOffset_ = this->stubOffset();\
  return { targetId_, argc_, templateObjectOffset_ };\
}\
\
struct LoadFixedSlotResultArgs final { ObjOperandId objId; uint32_t offsetOffset; };\
LoadFixedSlotResultArgs argsForLoadFixedSlotResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadFixedSlotResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  return { objId_, offsetOffset_ };\
}\
\
struct LoadFixedSlotTypedResultArgs final { ObjOperandId objId; uint32_t offsetOffset; ValueType type; };\
LoadFixedSlotTypedResultArgs argsForLoadFixedSlotTypedResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadFixedSlotTypedResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  ValueType type_ = this->valueType();\
  return { objId_, offsetOffset_, type_ };\
}\
\
struct LoadDynamicSlotResultArgs final { ObjOperandId objId; uint32_t offsetOffset; };\
LoadDynamicSlotResultArgs argsForLoadDynamicSlotResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDynamicSlotResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t offsetOffset_ = this->stubOffset();\
  return { objId_, offsetOffset_ };\
}\
\
struct LoadDenseElementResultArgs final { ObjOperandId objId; Int32OperandId indexId; bool expectPackedElements; };\
LoadDenseElementResultArgs argsForLoadDenseElementResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDenseElementResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  bool expectPackedElements_ = this->readBool();\
  return { objId_, indexId_, expectPackedElements_ };\
}\
\
struct LoadDenseElementHoleResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
LoadDenseElementHoleResultArgs argsForLoadDenseElementHoleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDenseElementHoleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct CallGetSparseElementResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
CallGetSparseElementResultArgs argsForCallGetSparseElementResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallGetSparseElementResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct LoadDenseElementExistsResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
LoadDenseElementExistsResultArgs argsForLoadDenseElementExistsResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDenseElementExistsResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct LoadTypedArrayElementExistsResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; ArrayBufferViewKind viewKind; };\
LoadTypedArrayElementExistsResultArgs argsForLoadTypedArrayElementExistsResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadTypedArrayElementExistsResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, viewKind_ };\
}\
\
struct LoadDenseElementHoleExistsResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
LoadDenseElementHoleExistsResultArgs argsForLoadDenseElementHoleExistsResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDenseElementHoleExistsResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct LoadTypedArrayElementResultArgs final { ObjOperandId objId; IntPtrOperandId indexId; Scalar::Type elementType; bool handleOOB; bool forceDoubleForUint32; ArrayBufferViewKind viewKind; };\
LoadTypedArrayElementResultArgs argsForLoadTypedArrayElementResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadTypedArrayElementResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId indexId_ = this->intPtrOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  bool handleOOB_ = this->readBool();\
  bool forceDoubleForUint32_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, indexId_, elementType_, handleOOB_, forceDoubleForUint32_, viewKind_ };\
}\
\
struct LoadDataViewValueResultArgs final { ObjOperandId objId; IntPtrOperandId offsetId; BooleanOperandId littleEndianId; Scalar::Type elementType; bool forceDoubleForUint32; ArrayBufferViewKind viewKind; };\
LoadDataViewValueResultArgs argsForLoadDataViewValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDataViewValueResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId offsetId_ = this->intPtrOperandId();\
  BooleanOperandId littleEndianId_ = this->booleanOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  bool forceDoubleForUint32_ = this->readBool();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, offsetId_, littleEndianId_, elementType_, forceDoubleForUint32_, viewKind_ };\
}\
\
struct StoreDataViewValueResultArgs final { ObjOperandId objId; IntPtrOperandId offsetId; uint32_t valueId; BooleanOperandId littleEndianId; Scalar::Type elementType; ArrayBufferViewKind viewKind; };\
StoreDataViewValueResultArgs argsForStoreDataViewValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::StoreDataViewValueResult);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId offsetId_ = this->intPtrOperandId();\
  uint32_t valueId_ = this->rawOperandId();\
  BooleanOperandId littleEndianId_ = this->booleanOperandId();\
  Scalar::Type elementType_ = this->scalarType();\
  ArrayBufferViewKind viewKind_ = this->arrayBufferViewKind();\
  return { objId_, offsetId_, valueId_, littleEndianId_, elementType_, viewKind_ };\
}\
\
struct LoadInt32ArrayLengthResultArgs final { ObjOperandId objId; };\
LoadInt32ArrayLengthResultArgs argsForLoadInt32ArrayLengthResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadInt32ArrayLengthResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadInt32ArrayLengthArgs final { ObjOperandId objId; Int32OperandId resultId; };\
LoadInt32ArrayLengthArgs argsForLoadInt32ArrayLength() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadInt32ArrayLength);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { objId_, resultId_ };\
}\
\
struct LoadArgumentsObjectArgResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
LoadArgumentsObjectArgResultArgs argsForLoadArgumentsObjectArgResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArgumentsObjectArgResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct LoadArgumentsObjectArgHoleResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
LoadArgumentsObjectArgHoleResultArgs argsForLoadArgumentsObjectArgHoleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArgumentsObjectArgHoleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct LoadArgumentsObjectArgExistsResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
LoadArgumentsObjectArgExistsResultArgs argsForLoadArgumentsObjectArgExistsResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArgumentsObjectArgExistsResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct LoadArgumentsObjectLengthResultArgs final { ObjOperandId objId; };\
LoadArgumentsObjectLengthResultArgs argsForLoadArgumentsObjectLengthResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArgumentsObjectLengthResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadArgumentsObjectLengthArgs final { ObjOperandId objId; Int32OperandId resultId; };\
LoadArgumentsObjectLengthArgs argsForLoadArgumentsObjectLength() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArgumentsObjectLength);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { objId_, resultId_ };\
}\
\
struct LoadFunctionLengthResultArgs final { ObjOperandId objId; };\
LoadFunctionLengthResultArgs argsForLoadFunctionLengthResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadFunctionLengthResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadFunctionNameResultArgs final { ObjOperandId objId; };\
LoadFunctionNameResultArgs argsForLoadFunctionNameResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadFunctionNameResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadBoundFunctionNumArgsArgs final { ObjOperandId objId; Int32OperandId resultId; };\
LoadBoundFunctionNumArgsArgs argsForLoadBoundFunctionNumArgs() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadBoundFunctionNumArgs);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { objId_, resultId_ };\
}\
\
struct LoadBoundFunctionTargetArgs final { ObjOperandId objId; ObjOperandId resultId; };\
LoadBoundFunctionTargetArgs argsForLoadBoundFunctionTarget() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadBoundFunctionTarget);\
  ObjOperandId objId_ = this->objOperandId();\
  ObjOperandId resultId_ = this->objOperandId();\
  return { objId_, resultId_ };\
}\
\
struct LoadBoundFunctionArgumentArgs final { ObjOperandId objId; uint32_t index; ValOperandId resultId; };\
LoadBoundFunctionArgumentArgs argsForLoadBoundFunctionArgument() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadBoundFunctionArgument);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t index_ = this->uint32Immediate();\
  ValOperandId resultId_ = this->valOperandId();\
  return { objId_, index_, resultId_ };\
}\
\
struct GuardBoundFunctionIsConstructorArgs final { ObjOperandId objId; };\
GuardBoundFunctionIsConstructorArgs argsForGuardBoundFunctionIsConstructor() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GuardBoundFunctionIsConstructor);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadArrayBufferByteLengthInt32ResultArgs final { ObjOperandId objId; };\
LoadArrayBufferByteLengthInt32ResultArgs argsForLoadArrayBufferByteLengthInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArrayBufferByteLengthInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadArrayBufferByteLengthDoubleResultArgs final { ObjOperandId objId; };\
LoadArrayBufferByteLengthDoubleResultArgs argsForLoadArrayBufferByteLengthDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArrayBufferByteLengthDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadArrayBufferViewLengthInt32ResultArgs final { ObjOperandId objId; };\
LoadArrayBufferViewLengthInt32ResultArgs argsForLoadArrayBufferViewLengthInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArrayBufferViewLengthInt32Result);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadArrayBufferViewLengthDoubleResultArgs final { ObjOperandId objId; };\
LoadArrayBufferViewLengthDoubleResultArgs argsForLoadArrayBufferViewLengthDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArrayBufferViewLengthDoubleResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadArrayBufferViewLengthArgs final { ObjOperandId objId; IntPtrOperandId resultId; };\
LoadArrayBufferViewLengthArgs argsForLoadArrayBufferViewLength() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadArrayBufferViewLength);\
  ObjOperandId objId_ = this->objOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { objId_, resultId_ };\
}\
\
struct LinearizeForCharAccessArgs final { StringOperandId strId; Int32OperandId indexId; StringOperandId resultId; };\
LinearizeForCharAccessArgs argsForLinearizeForCharAccess() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LinearizeForCharAccess);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  StringOperandId resultId_ = this->stringOperandId();\
  return { strId_, indexId_, resultId_ };\
}\
\
struct LinearizeForCodePointAccessArgs final { StringOperandId strId; Int32OperandId indexId; StringOperandId resultId; };\
LinearizeForCodePointAccessArgs argsForLinearizeForCodePointAccess() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LinearizeForCodePointAccess);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  StringOperandId resultId_ = this->stringOperandId();\
  return { strId_, indexId_, resultId_ };\
}\
\
struct ToRelativeStringIndexArgs final { Int32OperandId indexId; StringOperandId strId; Int32OperandId resultId; };\
ToRelativeStringIndexArgs argsForToRelativeStringIndex() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ToRelativeStringIndex);\
  Int32OperandId indexId_ = this->int32OperandId();\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { indexId_, strId_, resultId_ };\
}\
\
struct LoadStringCharResultArgs final { StringOperandId strId; Int32OperandId indexId; bool handleOOB; };\
LoadStringCharResultArgs argsForLoadStringCharResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadStringCharResult);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  bool handleOOB_ = this->readBool();\
  return { strId_, indexId_, handleOOB_ };\
}\
\
struct LoadStringAtResultArgs final { StringOperandId strId; Int32OperandId indexId; bool handleOOB; };\
LoadStringAtResultArgs argsForLoadStringAtResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadStringAtResult);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  bool handleOOB_ = this->readBool();\
  return { strId_, indexId_, handleOOB_ };\
}\
\
struct LoadStringCharCodeResultArgs final { StringOperandId strId; Int32OperandId indexId; bool handleOOB; };\
LoadStringCharCodeResultArgs argsForLoadStringCharCodeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadStringCharCodeResult);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  bool handleOOB_ = this->readBool();\
  return { strId_, indexId_, handleOOB_ };\
}\
\
struct LoadStringCodePointResultArgs final { StringOperandId strId; Int32OperandId indexId; bool handleOOB; };\
LoadStringCodePointResultArgs argsForLoadStringCodePointResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadStringCodePointResult);\
  StringOperandId strId_ = this->stringOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  bool handleOOB_ = this->readBool();\
  return { strId_, indexId_, handleOOB_ };\
}\
\
struct LoadStringLengthResultArgs final { StringOperandId strId; };\
LoadStringLengthResultArgs argsForLoadStringLengthResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadStringLengthResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct FrameIsConstructingResultArgs final {  };\
FrameIsConstructingResultArgs argsForFrameIsConstructingResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::FrameIsConstructingResult);\
  return {  };\
}\
\
struct LoadObjectResultArgs final { ObjOperandId objId; };\
LoadObjectResultArgs argsForLoadObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadObjectResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadStringResultArgs final { StringOperandId strId; };\
LoadStringResultArgs argsForLoadStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadStringResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct LoadSymbolResultArgs final { SymbolOperandId symId; };\
LoadSymbolResultArgs argsForLoadSymbolResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadSymbolResult);\
  SymbolOperandId symId_ = this->symbolOperandId();\
  return { symId_ };\
}\
\
struct LoadInt32ResultArgs final { Int32OperandId valId; };\
LoadInt32ResultArgs argsForLoadInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadInt32Result);\
  Int32OperandId valId_ = this->int32OperandId();\
  return { valId_ };\
}\
\
struct LoadDoubleResultArgs final { NumberOperandId valId; };\
LoadDoubleResultArgs argsForLoadDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDoubleResult);\
  NumberOperandId valId_ = this->numberOperandId();\
  return { valId_ };\
}\
\
struct LoadBigIntResultArgs final { BigIntOperandId valId; };\
LoadBigIntResultArgs argsForLoadBigIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadBigIntResult);\
  BigIntOperandId valId_ = this->bigIntOperandId();\
  return { valId_ };\
}\
\
struct CallScriptedGetterResultArgs final { ValOperandId receiverId; ObjOperandId calleeId; bool sameRealm; uint32_t nargsAndFlagsOffset; };\
CallScriptedGetterResultArgs argsForCallScriptedGetterResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallScriptedGetterResult);\
  ValOperandId receiverId_ = this->valOperandId();\
  ObjOperandId calleeId_ = this->objOperandId();\
  bool sameRealm_ = this->readBool();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { receiverId_, calleeId_, sameRealm_, nargsAndFlagsOffset_ };\
}\
\
struct CallInlinedGetterResultArgs final { ValOperandId receiverId; ObjOperandId calleeId; uint32_t icScriptOffset; bool sameRealm; uint32_t nargsAndFlagsOffset; };\
CallInlinedGetterResultArgs argsForCallInlinedGetterResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallInlinedGetterResult);\
  ValOperandId receiverId_ = this->valOperandId();\
  ObjOperandId calleeId_ = this->objOperandId();\
  uint32_t icScriptOffset_ = this->stubOffset();\
  bool sameRealm_ = this->readBool();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { receiverId_, calleeId_, icScriptOffset_, sameRealm_, nargsAndFlagsOffset_ };\
}\
\
struct CallNativeGetterResultArgs final { ValOperandId receiverId; uint32_t getterOffset; bool sameRealm; uint32_t nargsAndFlagsOffset; };\
CallNativeGetterResultArgs argsForCallNativeGetterResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallNativeGetterResult);\
  ValOperandId receiverId_ = this->valOperandId();\
  uint32_t getterOffset_ = this->stubOffset();\
  bool sameRealm_ = this->readBool();\
  uint32_t nargsAndFlagsOffset_ = this->stubOffset();\
  return { receiverId_, getterOffset_, sameRealm_, nargsAndFlagsOffset_ };\
}\
\
struct CallDOMGetterResultArgs final { ObjOperandId objId; uint32_t jitInfoOffset; };\
CallDOMGetterResultArgs argsForCallDOMGetterResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallDOMGetterResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t jitInfoOffset_ = this->stubOffset();\
  return { objId_, jitInfoOffset_ };\
}\
\
struct ProxyGetResultArgs final { ObjOperandId objId; uint32_t idOffset; };\
ProxyGetResultArgs argsForProxyGetResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ProxyGetResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t idOffset_ = this->stubOffset();\
  return { objId_, idOffset_ };\
}\
\
struct ProxyGetByValueResultArgs final { ObjOperandId objId; ValOperandId idId; };\
ProxyGetByValueResultArgs argsForProxyGetByValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ProxyGetByValueResult);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  return { objId_, idId_ };\
}\
\
struct ProxyHasPropResultArgs final { ObjOperandId objId; ValOperandId idId; bool hasOwn; };\
ProxyHasPropResultArgs argsForProxyHasPropResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ProxyHasPropResult);\
  ObjOperandId objId_ = this->objOperandId();\
  ValOperandId idId_ = this->valOperandId();\
  bool hasOwn_ = this->readBool();\
  return { objId_, idId_, hasOwn_ };\
}\
\
struct CallObjectHasSparseElementResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
CallObjectHasSparseElementResultArgs argsForCallObjectHasSparseElementResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallObjectHasSparseElementResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct CallNativeGetElementResultArgs final { ObjOperandId objId; Int32OperandId indexId; };\
CallNativeGetElementResultArgs argsForCallNativeGetElementResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallNativeGetElementResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  return { objId_, indexId_ };\
}\
\
struct CallNativeGetElementSuperResultArgs final { ObjOperandId objId; Int32OperandId indexId; ValOperandId receiverId; };\
CallNativeGetElementSuperResultArgs argsForCallNativeGetElementSuperResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallNativeGetElementSuperResult);\
  ObjOperandId objId_ = this->objOperandId();\
  Int32OperandId indexId_ = this->int32OperandId();\
  ValOperandId receiverId_ = this->valOperandId();\
  return { objId_, indexId_, receiverId_ };\
}\
\
struct GetNextMapSetEntryForIteratorResultArgs final { ObjOperandId iterId; ObjOperandId resultArrId; bool isMap; };\
GetNextMapSetEntryForIteratorResultArgs argsForGetNextMapSetEntryForIteratorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::GetNextMapSetEntryForIteratorResult);\
  ObjOperandId iterId_ = this->objOperandId();\
  ObjOperandId resultArrId_ = this->objOperandId();\
  bool isMap_ = this->readBool();\
  return { iterId_, resultArrId_, isMap_ };\
}\
\
struct LoadUndefinedResultArgs final {  };\
LoadUndefinedResultArgs argsForLoadUndefinedResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadUndefinedResult);\
  return {  };\
}\
\
struct LoadBooleanResultArgs final { bool val; };\
LoadBooleanResultArgs argsForLoadBooleanResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadBooleanResult);\
  bool val_ = this->readBool();\
  return { val_ };\
}\
\
struct LoadInt32ConstantArgs final { uint32_t valOffset; Int32OperandId resultId; };\
LoadInt32ConstantArgs argsForLoadInt32Constant() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadInt32Constant);\
  uint32_t valOffset_ = this->stubOffset();\
  Int32OperandId resultId_ = this->int32OperandId();\
  return { valOffset_, resultId_ };\
}\
\
struct LoadInt32AsIntPtrConstantArgs final { uint32_t valOffset; IntPtrOperandId resultId; };\
LoadInt32AsIntPtrConstantArgs argsForLoadInt32AsIntPtrConstant() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadInt32AsIntPtrConstant);\
  uint32_t valOffset_ = this->stubOffset();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { valOffset_, resultId_ };\
}\
\
struct LoadDoubleConstantArgs final { uint32_t valOffset; NumberOperandId resultId; };\
LoadDoubleConstantArgs argsForLoadDoubleConstant() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDoubleConstant);\
  uint32_t valOffset_ = this->stubOffset();\
  NumberOperandId resultId_ = this->numberOperandId();\
  return { valOffset_, resultId_ };\
}\
\
struct LoadBooleanConstantArgs final { bool val; BooleanOperandId resultId; };\
LoadBooleanConstantArgs argsForLoadBooleanConstant() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadBooleanConstant);\
  bool val_ = this->readBool();\
  BooleanOperandId resultId_ = this->booleanOperandId();\
  return { val_, resultId_ };\
}\
\
struct LoadUndefinedArgs final { ValOperandId resultId; };\
LoadUndefinedArgs argsForLoadUndefined() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadUndefined);\
  ValOperandId resultId_ = this->valOperandId();\
  return { resultId_ };\
}\
\
struct LoadConstantStringArgs final { uint32_t strOffset; StringOperandId resultId; };\
LoadConstantStringArgs argsForLoadConstantString() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadConstantString);\
  uint32_t strOffset_ = this->stubOffset();\
  StringOperandId resultId_ = this->stringOperandId();\
  return { strOffset_, resultId_ };\
}\
\
struct LoadConstantStringResultArgs final { uint32_t strOffset; };\
LoadConstantStringResultArgs argsForLoadConstantStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadConstantStringResult);\
  uint32_t strOffset_ = this->stubOffset();\
  return { strOffset_ };\
}\
\
struct LoadInstanceOfObjectResultArgs final { ValOperandId lhsId; ObjOperandId protoId; };\
LoadInstanceOfObjectResultArgs argsForLoadInstanceOfObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadInstanceOfObjectResult);\
  ValOperandId lhsId_ = this->valOperandId();\
  ObjOperandId protoId_ = this->objOperandId();\
  return { lhsId_, protoId_ };\
}\
\
struct LoadTypeOfObjectResultArgs final { ObjOperandId objId; };\
LoadTypeOfObjectResultArgs argsForLoadTypeOfObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadTypeOfObjectResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadTypeOfEqObjectResultArgs final { ObjOperandId objId; TypeofEqOperand operand; };\
LoadTypeOfEqObjectResultArgs argsForLoadTypeOfEqObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadTypeOfEqObjectResult);\
  ObjOperandId objId_ = this->objOperandId();\
  TypeofEqOperand operand_ = this->typeofEqOperand();\
  return { objId_, operand_ };\
}\
\
struct DoubleAddResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
DoubleAddResultArgs argsForDoubleAddResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleAddResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct DoubleSubResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
DoubleSubResultArgs argsForDoubleSubResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleSubResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct DoubleMulResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
DoubleMulResultArgs argsForDoubleMulResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleMulResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct DoubleDivResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
DoubleDivResultArgs argsForDoubleDivResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleDivResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct DoubleModResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
DoubleModResultArgs argsForDoubleModResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleModResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct DoublePowResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
DoublePowResultArgs argsForDoublePowResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoublePowResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32AddResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32AddResultArgs argsForInt32AddResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32AddResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32SubResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32SubResultArgs argsForInt32SubResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32SubResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32MulResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32MulResultArgs argsForInt32MulResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32MulResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32DivResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32DivResultArgs argsForInt32DivResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32DivResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32ModResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32ModResultArgs argsForInt32ModResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32ModResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32PowResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32PowResultArgs argsForInt32PowResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32PowResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntAddResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntAddResultArgs argsForBigIntAddResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntAddResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntSubResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntSubResultArgs argsForBigIntSubResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntSubResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntMulResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntMulResultArgs argsForBigIntMulResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntMulResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntDivResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntDivResultArgs argsForBigIntDivResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntDivResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntModResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntModResultArgs argsForBigIntModResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntModResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntPowResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntPowResultArgs argsForBigIntPowResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPowResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntToIntPtrArgs final { BigIntOperandId inputId; IntPtrOperandId resultId; };\
BigIntToIntPtrArgs argsForBigIntToIntPtr() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntToIntPtr);\
  BigIntOperandId inputId_ = this->bigIntOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct IntPtrToBigIntResultArgs final { IntPtrOperandId inputId; };\
IntPtrToBigIntResultArgs argsForIntPtrToBigIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IntPtrToBigIntResult);\
  IntPtrOperandId inputId_ = this->intPtrOperandId();\
  return { inputId_ };\
}\
\
struct BigIntPtrAddArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrAddArgs argsForBigIntPtrAdd() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrAdd);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrSubArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrSubArgs argsForBigIntPtrSub() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrSub);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrMulArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrMulArgs argsForBigIntPtrMul() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrMul);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrDivArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrDivArgs argsForBigIntPtrDiv() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrDiv);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrModArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrModArgs argsForBigIntPtrMod() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrMod);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrPowArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrPowArgs argsForBigIntPtrPow() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrPow);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct Int32BitOrResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32BitOrResultArgs argsForInt32BitOrResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32BitOrResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32BitXorResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32BitXorResultArgs argsForInt32BitXorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32BitXorResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32BitAndResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32BitAndResultArgs argsForInt32BitAndResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32BitAndResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32LeftShiftResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32LeftShiftResultArgs argsForInt32LeftShiftResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32LeftShiftResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32RightShiftResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; };\
Int32RightShiftResultArgs argsForInt32RightShiftResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32RightShiftResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct Int32URightShiftResultArgs final { Int32OperandId lhsId; Int32OperandId rhsId; bool forceDouble; };\
Int32URightShiftResultArgs argsForInt32URightShiftResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32URightShiftResult);\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  bool forceDouble_ = this->readBool();\
  return { lhsId_, rhsId_, forceDouble_ };\
}\
\
struct Int32NotResultArgs final { Int32OperandId inputId; };\
Int32NotResultArgs argsForInt32NotResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32NotResult);\
  Int32OperandId inputId_ = this->int32OperandId();\
  return { inputId_ };\
}\
\
struct BigIntBitOrResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntBitOrResultArgs argsForBigIntBitOrResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntBitOrResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntBitXorResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntBitXorResultArgs argsForBigIntBitXorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntBitXorResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntBitAndResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntBitAndResultArgs argsForBigIntBitAndResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntBitAndResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntLeftShiftResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntLeftShiftResultArgs argsForBigIntLeftShiftResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntLeftShiftResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntRightShiftResultArgs final { BigIntOperandId lhsId; BigIntOperandId rhsId; };\
BigIntRightShiftResultArgs argsForBigIntRightShiftResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntRightShiftResult);\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct BigIntNotResultArgs final { BigIntOperandId inputId; };\
BigIntNotResultArgs argsForBigIntNotResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntNotResult);\
  BigIntOperandId inputId_ = this->bigIntOperandId();\
  return { inputId_ };\
}\
\
struct BigIntPtrBitOrArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrBitOrArgs argsForBigIntPtrBitOr() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrBitOr);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrBitXorArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrBitXorArgs argsForBigIntPtrBitXor() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrBitXor);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrBitAndArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrBitAndArgs argsForBigIntPtrBitAnd() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrBitAnd);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrLeftShiftArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrLeftShiftArgs argsForBigIntPtrLeftShift() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrLeftShift);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrRightShiftArgs final { IntPtrOperandId lhsId; IntPtrOperandId rhsId; IntPtrOperandId resultId; };\
BigIntPtrRightShiftArgs argsForBigIntPtrRightShift() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrRightShift);\
  IntPtrOperandId lhsId_ = this->intPtrOperandId();\
  IntPtrOperandId rhsId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { lhsId_, rhsId_, resultId_ };\
}\
\
struct BigIntPtrNotArgs final { IntPtrOperandId inputId; IntPtrOperandId resultId; };\
BigIntPtrNotArgs argsForBigIntPtrNot() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrNot);\
  IntPtrOperandId inputId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct Int32NegationResultArgs final { Int32OperandId inputId; };\
Int32NegationResultArgs argsForInt32NegationResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32NegationResult);\
  Int32OperandId inputId_ = this->int32OperandId();\
  return { inputId_ };\
}\
\
struct DoubleNegationResultArgs final { NumberOperandId inputId; };\
DoubleNegationResultArgs argsForDoubleNegationResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleNegationResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct BigIntNegationResultArgs final { BigIntOperandId inputId; };\
BigIntNegationResultArgs argsForBigIntNegationResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntNegationResult);\
  BigIntOperandId inputId_ = this->bigIntOperandId();\
  return { inputId_ };\
}\
\
struct BigIntPtrNegationArgs final { IntPtrOperandId inputId; IntPtrOperandId resultId; };\
BigIntPtrNegationArgs argsForBigIntPtrNegation() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrNegation);\
  IntPtrOperandId inputId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct Int32IncResultArgs final { Int32OperandId inputId; };\
Int32IncResultArgs argsForInt32IncResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32IncResult);\
  Int32OperandId inputId_ = this->int32OperandId();\
  return { inputId_ };\
}\
\
struct Int32DecResultArgs final { Int32OperandId inputId; };\
Int32DecResultArgs argsForInt32DecResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Int32DecResult);\
  Int32OperandId inputId_ = this->int32OperandId();\
  return { inputId_ };\
}\
\
struct DoubleIncResultArgs final { NumberOperandId inputId; };\
DoubleIncResultArgs argsForDoubleIncResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleIncResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct DoubleDecResultArgs final { NumberOperandId inputId; };\
DoubleDecResultArgs argsForDoubleDecResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DoubleDecResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct BigIntIncResultArgs final { BigIntOperandId inputId; };\
BigIntIncResultArgs argsForBigIntIncResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntIncResult);\
  BigIntOperandId inputId_ = this->bigIntOperandId();\
  return { inputId_ };\
}\
\
struct BigIntDecResultArgs final { BigIntOperandId inputId; };\
BigIntDecResultArgs argsForBigIntDecResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntDecResult);\
  BigIntOperandId inputId_ = this->bigIntOperandId();\
  return { inputId_ };\
}\
\
struct BigIntPtrIncArgs final { IntPtrOperandId inputId; IntPtrOperandId resultId; };\
BigIntPtrIncArgs argsForBigIntPtrInc() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrInc);\
  IntPtrOperandId inputId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct BigIntPtrDecArgs final { IntPtrOperandId inputId; IntPtrOperandId resultId; };\
BigIntPtrDecArgs argsForBigIntPtrDec() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntPtrDec);\
  IntPtrOperandId inputId_ = this->intPtrOperandId();\
  IntPtrOperandId resultId_ = this->intPtrOperandId();\
  return { inputId_, resultId_ };\
}\
\
struct LoadInt32TruthyResultArgs final { ValOperandId inputId; };\
LoadInt32TruthyResultArgs argsForLoadInt32TruthyResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadInt32TruthyResult);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct LoadDoubleTruthyResultArgs final { NumberOperandId inputId; };\
LoadDoubleTruthyResultArgs argsForLoadDoubleTruthyResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadDoubleTruthyResult);\
  NumberOperandId inputId_ = this->numberOperandId();\
  return { inputId_ };\
}\
\
struct LoadStringTruthyResultArgs final { StringOperandId strId; };\
LoadStringTruthyResultArgs argsForLoadStringTruthyResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadStringTruthyResult);\
  StringOperandId strId_ = this->stringOperandId();\
  return { strId_ };\
}\
\
struct LoadObjectTruthyResultArgs final { ObjOperandId objId; };\
LoadObjectTruthyResultArgs argsForLoadObjectTruthyResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadObjectTruthyResult);\
  ObjOperandId objId_ = this->objOperandId();\
  return { objId_ };\
}\
\
struct LoadBigIntTruthyResultArgs final { BigIntOperandId bigIntId; };\
LoadBigIntTruthyResultArgs argsForLoadBigIntTruthyResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadBigIntTruthyResult);\
  BigIntOperandId bigIntId_ = this->bigIntOperandId();\
  return { bigIntId_ };\
}\
\
struct LoadValueTruthyResultArgs final { ValOperandId inputId; };\
LoadValueTruthyResultArgs argsForLoadValueTruthyResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadValueTruthyResult);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct LoadValueResultArgs final { uint32_t valOffset; };\
LoadValueResultArgs argsForLoadValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadValueResult);\
  uint32_t valOffset_ = this->stubOffset();\
  return { valOffset_ };\
}\
\
struct UncheckedLoadWeakValueResultArgs final { uint32_t valOffset; };\
UncheckedLoadWeakValueResultArgs argsForUncheckedLoadWeakValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::UncheckedLoadWeakValueResult);\
  uint32_t valOffset_ = this->stubOffset();\
  return { valOffset_ };\
}\
\
struct UncheckedLoadWeakObjectResultArgs final { uint32_t objOffset; };\
UncheckedLoadWeakObjectResultArgs argsForUncheckedLoadWeakObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::UncheckedLoadWeakObjectResult);\
  uint32_t objOffset_ = this->stubOffset();\
  return { objOffset_ };\
}\
\
struct LoadOperandResultArgs final { ValOperandId inputId; };\
LoadOperandResultArgs argsForLoadOperandResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::LoadOperandResult);\
  ValOperandId inputId_ = this->valOperandId();\
  return { inputId_ };\
}\
\
struct NewPlainObjectResultArgs final { uint32_t numFixedSlots; uint32_t numDynamicSlots; gc::AllocKind allocKind; uint32_t shapeOffset; uint32_t siteOffset; };\
NewPlainObjectResultArgs argsForNewPlainObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewPlainObjectResult);\
  uint32_t numFixedSlots_ = this->uint32Immediate();\
  uint32_t numDynamicSlots_ = this->uint32Immediate();\
  gc::AllocKind allocKind_ = this->allocKind();\
  uint32_t shapeOffset_ = this->stubOffset();\
  uint32_t siteOffset_ = this->stubOffset();\
  return { numFixedSlots_, numDynamicSlots_, allocKind_, shapeOffset_, siteOffset_ };\
}\
\
struct NewArrayObjectResultArgs final { uint32_t arrayLength; uint32_t shapeOffset; uint32_t siteOffset; };\
NewArrayObjectResultArgs argsForNewArrayObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewArrayObjectResult);\
  uint32_t arrayLength_ = this->uint32Immediate();\
  uint32_t shapeOffset_ = this->stubOffset();\
  uint32_t siteOffset_ = this->stubOffset();\
  return { arrayLength_, shapeOffset_, siteOffset_ };\
}\
\
struct NewFunctionCloneResultArgs final { uint32_t canonicalOffset; gc::AllocKind allocKind; uint32_t siteOffset; };\
NewFunctionCloneResultArgs argsForNewFunctionCloneResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::NewFunctionCloneResult);\
  uint32_t canonicalOffset_ = this->stubOffset();\
  gc::AllocKind allocKind_ = this->allocKind();\
  uint32_t siteOffset_ = this->stubOffset();\
  return { canonicalOffset_, allocKind_, siteOffset_ };\
}\
\
struct ConcatStringsResultArgs final { StringOperandId lhsId; StringOperandId rhsId; uint32_t stubOffset; };\
ConcatStringsResultArgs argsForConcatStringsResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ConcatStringsResult);\
  StringOperandId lhsId_ = this->stringOperandId();\
  StringOperandId rhsId_ = this->stringOperandId();\
  uint32_t stubOffset_ = this->stubOffset();\
  return { lhsId_, rhsId_, stubOffset_ };\
}\
\
struct CallStringObjectConcatResultArgs final { ValOperandId lhsId; ValOperandId rhsId; };\
CallStringObjectConcatResultArgs argsForCallStringObjectConcatResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallStringObjectConcatResult);\
  ValOperandId lhsId_ = this->valOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct CallIsSuspendedGeneratorResultArgs final { ValOperandId valId; };\
CallIsSuspendedGeneratorResultArgs argsForCallIsSuspendedGeneratorResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallIsSuspendedGeneratorResult);\
  ValOperandId valId_ = this->valOperandId();\
  return { valId_ };\
}\
\
struct CompareStringResultArgs final { JSOp op; StringOperandId lhsId; StringOperandId rhsId; };\
CompareStringResultArgs argsForCompareStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareStringResult);\
  JSOp op_ = this->jsop();\
  StringOperandId lhsId_ = this->stringOperandId();\
  StringOperandId rhsId_ = this->stringOperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareObjectResultArgs final { JSOp op; ObjOperandId lhsId; ObjOperandId rhsId; };\
CompareObjectResultArgs argsForCompareObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareObjectResult);\
  JSOp op_ = this->jsop();\
  ObjOperandId lhsId_ = this->objOperandId();\
  ObjOperandId rhsId_ = this->objOperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareSymbolResultArgs final { JSOp op; SymbolOperandId lhsId; SymbolOperandId rhsId; };\
CompareSymbolResultArgs argsForCompareSymbolResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareSymbolResult);\
  JSOp op_ = this->jsop();\
  SymbolOperandId lhsId_ = this->symbolOperandId();\
  SymbolOperandId rhsId_ = this->symbolOperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareInt32ResultArgs final { JSOp op; Int32OperandId lhsId; Int32OperandId rhsId; };\
CompareInt32ResultArgs argsForCompareInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareInt32Result);\
  JSOp op_ = this->jsop();\
  Int32OperandId lhsId_ = this->int32OperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareDoubleResultArgs final { JSOp op; NumberOperandId lhsId; NumberOperandId rhsId; };\
CompareDoubleResultArgs argsForCompareDoubleResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareDoubleResult);\
  JSOp op_ = this->jsop();\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareBigIntResultArgs final { JSOp op; BigIntOperandId lhsId; BigIntOperandId rhsId; };\
CompareBigIntResultArgs argsForCompareBigIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareBigIntResult);\
  JSOp op_ = this->jsop();\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  BigIntOperandId rhsId_ = this->bigIntOperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareBigIntInt32ResultArgs final { JSOp op; BigIntOperandId lhsId; Int32OperandId rhsId; };\
CompareBigIntInt32ResultArgs argsForCompareBigIntInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareBigIntInt32Result);\
  JSOp op_ = this->jsop();\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  Int32OperandId rhsId_ = this->int32OperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareBigIntNumberResultArgs final { JSOp op; BigIntOperandId lhsId; NumberOperandId rhsId; };\
CompareBigIntNumberResultArgs argsForCompareBigIntNumberResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareBigIntNumberResult);\
  JSOp op_ = this->jsop();\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareBigIntStringResultArgs final { JSOp op; BigIntOperandId lhsId; StringOperandId rhsId; };\
CompareBigIntStringResultArgs argsForCompareBigIntStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareBigIntStringResult);\
  JSOp op_ = this->jsop();\
  BigIntOperandId lhsId_ = this->bigIntOperandId();\
  StringOperandId rhsId_ = this->stringOperandId();\
  return { op_, lhsId_, rhsId_ };\
}\
\
struct CompareNullUndefinedResultArgs final { JSOp op; bool isUndefined; ValOperandId inputId; };\
CompareNullUndefinedResultArgs argsForCompareNullUndefinedResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareNullUndefinedResult);\
  JSOp op_ = this->jsop();\
  bool isUndefined_ = this->readBool();\
  ValOperandId inputId_ = this->valOperandId();\
  return { op_, isUndefined_, inputId_ };\
}\
\
struct CompareDoubleSameValueResultArgs final { NumberOperandId lhsId; NumberOperandId rhsId; };\
CompareDoubleSameValueResultArgs argsForCompareDoubleSameValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CompareDoubleSameValueResult);\
  NumberOperandId lhsId_ = this->numberOperandId();\
  NumberOperandId rhsId_ = this->numberOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct SameValueResultArgs final { ValOperandId lhsId; ValOperandId rhsId; };\
SameValueResultArgs argsForSameValueResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SameValueResult);\
  ValOperandId lhsId_ = this->valOperandId();\
  ValOperandId rhsId_ = this->valOperandId();\
  return { lhsId_, rhsId_ };\
}\
\
struct IndirectTruncateInt32ResultArgs final { Int32OperandId valId; };\
IndirectTruncateInt32ResultArgs argsForIndirectTruncateInt32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::IndirectTruncateInt32Result);\
  Int32OperandId valId_ = this->int32OperandId();\
  return { valId_ };\
}\
\
struct BigIntAsIntNResultArgs final { Int32OperandId bitsId; BigIntOperandId bigIntId; };\
BigIntAsIntNResultArgs argsForBigIntAsIntNResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntAsIntNResult);\
  Int32OperandId bitsId_ = this->int32OperandId();\
  BigIntOperandId bigIntId_ = this->bigIntOperandId();\
  return { bitsId_, bigIntId_ };\
}\
\
struct BigIntAsUintNResultArgs final { Int32OperandId bitsId; BigIntOperandId bigIntId; };\
BigIntAsUintNResultArgs argsForBigIntAsUintNResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::BigIntAsUintNResult);\
  Int32OperandId bitsId_ = this->int32OperandId();\
  BigIntOperandId bigIntId_ = this->bigIntOperandId();\
  return { bitsId_, bigIntId_ };\
}\
\
struct SetHasResultArgs final { ObjOperandId setId; ValOperandId valId; };\
SetHasResultArgs argsForSetHasResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetHasResult);\
  ObjOperandId setId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { setId_, valId_ };\
}\
\
struct SetHasNonGCThingResultArgs final { ObjOperandId setId; ValOperandId valId; };\
SetHasNonGCThingResultArgs argsForSetHasNonGCThingResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetHasNonGCThingResult);\
  ObjOperandId setId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { setId_, valId_ };\
}\
\
struct SetHasStringResultArgs final { ObjOperandId setId; StringOperandId strId; };\
SetHasStringResultArgs argsForSetHasStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetHasStringResult);\
  ObjOperandId setId_ = this->objOperandId();\
  StringOperandId strId_ = this->stringOperandId();\
  return { setId_, strId_ };\
}\
\
struct SetHasSymbolResultArgs final { ObjOperandId setId; SymbolOperandId symId; };\
SetHasSymbolResultArgs argsForSetHasSymbolResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetHasSymbolResult);\
  ObjOperandId setId_ = this->objOperandId();\
  SymbolOperandId symId_ = this->symbolOperandId();\
  return { setId_, symId_ };\
}\
\
struct SetHasBigIntResultArgs final { ObjOperandId setId; BigIntOperandId bigIntId; };\
SetHasBigIntResultArgs argsForSetHasBigIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetHasBigIntResult);\
  ObjOperandId setId_ = this->objOperandId();\
  BigIntOperandId bigIntId_ = this->bigIntOperandId();\
  return { setId_, bigIntId_ };\
}\
\
struct SetHasObjectResultArgs final { ObjOperandId setId; ObjOperandId objId; };\
SetHasObjectResultArgs argsForSetHasObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetHasObjectResult);\
  ObjOperandId setId_ = this->objOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  return { setId_, objId_ };\
}\
\
struct SetDeleteResultArgs final { ObjOperandId setId; ValOperandId valId; };\
SetDeleteResultArgs argsForSetDeleteResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetDeleteResult);\
  ObjOperandId setId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { setId_, valId_ };\
}\
\
struct SetAddResultArgs final { ObjOperandId setId; ValOperandId keyId; };\
SetAddResultArgs argsForSetAddResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetAddResult);\
  ObjOperandId setId_ = this->objOperandId();\
  ValOperandId keyId_ = this->valOperandId();\
  return { setId_, keyId_ };\
}\
\
struct SetSizeResultArgs final { ObjOperandId setId; };\
SetSizeResultArgs argsForSetSizeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::SetSizeResult);\
  ObjOperandId setId_ = this->objOperandId();\
  return { setId_ };\
}\
\
struct MapHasResultArgs final { ObjOperandId mapId; ValOperandId valId; };\
MapHasResultArgs argsForMapHasResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapHasResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { mapId_, valId_ };\
}\
\
struct MapHasNonGCThingResultArgs final { ObjOperandId mapId; ValOperandId valId; };\
MapHasNonGCThingResultArgs argsForMapHasNonGCThingResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapHasNonGCThingResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { mapId_, valId_ };\
}\
\
struct MapHasStringResultArgs final { ObjOperandId mapId; StringOperandId strId; };\
MapHasStringResultArgs argsForMapHasStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapHasStringResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  StringOperandId strId_ = this->stringOperandId();\
  return { mapId_, strId_ };\
}\
\
struct MapHasSymbolResultArgs final { ObjOperandId mapId; SymbolOperandId symId; };\
MapHasSymbolResultArgs argsForMapHasSymbolResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapHasSymbolResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  SymbolOperandId symId_ = this->symbolOperandId();\
  return { mapId_, symId_ };\
}\
\
struct MapHasBigIntResultArgs final { ObjOperandId mapId; BigIntOperandId bigIntId; };\
MapHasBigIntResultArgs argsForMapHasBigIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapHasBigIntResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  BigIntOperandId bigIntId_ = this->bigIntOperandId();\
  return { mapId_, bigIntId_ };\
}\
\
struct MapHasObjectResultArgs final { ObjOperandId mapId; ObjOperandId objId; };\
MapHasObjectResultArgs argsForMapHasObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapHasObjectResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  return { mapId_, objId_ };\
}\
\
struct MapGetResultArgs final { ObjOperandId mapId; ValOperandId valId; };\
MapGetResultArgs argsForMapGetResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapGetResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { mapId_, valId_ };\
}\
\
struct MapGetNonGCThingResultArgs final { ObjOperandId mapId; ValOperandId valId; };\
MapGetNonGCThingResultArgs argsForMapGetNonGCThingResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapGetNonGCThingResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { mapId_, valId_ };\
}\
\
struct MapGetStringResultArgs final { ObjOperandId mapId; StringOperandId strId; };\
MapGetStringResultArgs argsForMapGetStringResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapGetStringResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  StringOperandId strId_ = this->stringOperandId();\
  return { mapId_, strId_ };\
}\
\
struct MapGetSymbolResultArgs final { ObjOperandId mapId; SymbolOperandId symId; };\
MapGetSymbolResultArgs argsForMapGetSymbolResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapGetSymbolResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  SymbolOperandId symId_ = this->symbolOperandId();\
  return { mapId_, symId_ };\
}\
\
struct MapGetBigIntResultArgs final { ObjOperandId mapId; BigIntOperandId bigIntId; };\
MapGetBigIntResultArgs argsForMapGetBigIntResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapGetBigIntResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  BigIntOperandId bigIntId_ = this->bigIntOperandId();\
  return { mapId_, bigIntId_ };\
}\
\
struct MapGetObjectResultArgs final { ObjOperandId mapId; ObjOperandId objId; };\
MapGetObjectResultArgs argsForMapGetObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapGetObjectResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  return { mapId_, objId_ };\
}\
\
struct MapDeleteResultArgs final { ObjOperandId mapId; ValOperandId valId; };\
MapDeleteResultArgs argsForMapDeleteResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapDeleteResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { mapId_, valId_ };\
}\
\
struct MapSetResultArgs final { ObjOperandId mapId; ValOperandId keyId; ValOperandId valId; };\
MapSetResultArgs argsForMapSetResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapSetResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  ValOperandId keyId_ = this->valOperandId();\
  ValOperandId valId_ = this->valOperandId();\
  return { mapId_, keyId_, valId_ };\
}\
\
struct MapSizeResultArgs final { ObjOperandId mapId; };\
MapSizeResultArgs argsForMapSizeResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::MapSizeResult);\
  ObjOperandId mapId_ = this->objOperandId();\
  return { mapId_ };\
}\
\
struct WeakMapGetObjectResultArgs final { ObjOperandId weakMapId; ObjOperandId objId; };\
WeakMapGetObjectResultArgs argsForWeakMapGetObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::WeakMapGetObjectResult);\
  ObjOperandId weakMapId_ = this->objOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  return { weakMapId_, objId_ };\
}\
\
struct WeakMapHasObjectResultArgs final { ObjOperandId weakMapId; ObjOperandId objId; };\
WeakMapHasObjectResultArgs argsForWeakMapHasObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::WeakMapHasObjectResult);\
  ObjOperandId weakMapId_ = this->objOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  return { weakMapId_, objId_ };\
}\
\
struct WeakSetHasObjectResultArgs final { ObjOperandId weakSetId; ObjOperandId objId; };\
WeakSetHasObjectResultArgs argsForWeakSetHasObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::WeakSetHasObjectResult);\
  ObjOperandId weakSetId_ = this->objOperandId();\
  ObjOperandId objId_ = this->objOperandId();\
  return { weakSetId_, objId_ };\
}\
\
struct DateFillLocalTimeSlotsArgs final { ObjOperandId dateId; };\
DateFillLocalTimeSlotsArgs argsForDateFillLocalTimeSlots() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DateFillLocalTimeSlots);\
  ObjOperandId dateId_ = this->objOperandId();\
  return { dateId_ };\
}\
\
struct DateHoursFromSecondsIntoYearResultArgs final { ValOperandId secondsIntoYearId; };\
DateHoursFromSecondsIntoYearResultArgs argsForDateHoursFromSecondsIntoYearResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DateHoursFromSecondsIntoYearResult);\
  ValOperandId secondsIntoYearId_ = this->valOperandId();\
  return { secondsIntoYearId_ };\
}\
\
struct DateMinutesFromSecondsIntoYearResultArgs final { ValOperandId secondsIntoYearId; };\
DateMinutesFromSecondsIntoYearResultArgs argsForDateMinutesFromSecondsIntoYearResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DateMinutesFromSecondsIntoYearResult);\
  ValOperandId secondsIntoYearId_ = this->valOperandId();\
  return { secondsIntoYearId_ };\
}\
\
struct DateSecondsFromSecondsIntoYearResultArgs final { ValOperandId secondsIntoYearId; };\
DateSecondsFromSecondsIntoYearResultArgs argsForDateSecondsFromSecondsIntoYearResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::DateSecondsFromSecondsIntoYearResult);\
  ValOperandId secondsIntoYearId_ = this->valOperandId();\
  return { secondsIntoYearId_ };\
}\
\
struct ArrayFromArgumentsObjectResultArgs final { ObjOperandId objId; uint32_t shapeOffset; };\
ArrayFromArgumentsObjectResultArgs argsForArrayFromArgumentsObjectResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::ArrayFromArgumentsObjectResult);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t shapeOffset_ = this->stubOffset();\
  return { objId_, shapeOffset_ };\
}\
\
struct CloseIterScriptedResultArgs final { ObjOperandId iterId; ObjOperandId calleeId; CompletionKind kind; uint32_t targetNargs; };\
CloseIterScriptedResultArgs argsForCloseIterScriptedResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CloseIterScriptedResult);\
  ObjOperandId iterId_ = this->objOperandId();\
  ObjOperandId calleeId_ = this->objOperandId();\
  CompletionKind kind_ = this->completionKind();\
  uint32_t targetNargs_ = this->uint32Immediate();\
  return { iterId_, calleeId_, kind_, targetNargs_ };\
}\
\
struct CallPrintStringArgs final { const char* str; };\
CallPrintStringArgs argsForCallPrintString() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::CallPrintString);\
  const char* str_ = reinterpret_cast<char*>(this->pointer());\
  return { str_ };\
}\
\
struct BreakpointArgs final {  };\
BreakpointArgs argsForBreakpoint() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Breakpoint);\
  return {  };\
}\
\
struct WrapResultArgs final {  };\
WrapResultArgs argsForWrapResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::WrapResult);\
  return {  };\
}\
\
struct BailoutArgs final {  };\
BailoutArgs argsForBailout() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::Bailout);\
  return {  };\
}\
\
struct AssertFloat32ResultArgs final { ValOperandId valId; bool mustBeFloat32; };\
AssertFloat32ResultArgs argsForAssertFloat32Result() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AssertFloat32Result);\
  ValOperandId valId_ = this->valOperandId();\
  bool mustBeFloat32_ = this->readBool();\
  return { valId_, mustBeFloat32_ };\
}\
\
struct AssertRecoveredOnBailoutResultArgs final { ValOperandId valId; bool mustBeRecovered; };\
AssertRecoveredOnBailoutResultArgs argsForAssertRecoveredOnBailoutResult() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AssertRecoveredOnBailoutResult);\
  ValOperandId valId_ = this->valOperandId();\
  bool mustBeRecovered_ = this->readBool();\
  return { valId_, mustBeRecovered_ };\
}\
\
struct AssertPropertyLookupArgs final { ObjOperandId objId; uint32_t idOffset; uint32_t slotOffset; };\
AssertPropertyLookupArgs argsForAssertPropertyLookup() {\
  MOZ_ASSERT(*lastOp_ == CacheOp::AssertPropertyLookup);\
  ObjOperandId objId_ = this->objOperandId();\
  uint32_t idOffset_ = this->stubOffset();\
  uint32_t slotOffset_ = this->stubOffset();\
  return { objId_, idOffset_, slotOffset_ };\
}\


#define CACHE_IR_COMPILER_SHARED_GENERATED \
[[nodiscard]] bool emitGuardToObject(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToObject(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToObject(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNullOrUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNullOrUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNullOrUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNull(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNull(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNull(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNotUninitializedLexical(ValOperandId valId);\
[[nodiscard]] bool emitGuardIsNotUninitializedLexical(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  return emitGuardIsNotUninitializedLexical(valId);\
}\
\
[[nodiscard]] bool emitGuardToBoolean(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBoolean(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBoolean(inputId);\
}\
\
[[nodiscard]] bool emitGuardToString(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToString(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToString(inputId);\
}\
\
[[nodiscard]] bool emitGuardToSymbol(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToSymbol(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToSymbol(inputId);\
}\
\
[[nodiscard]] bool emitGuardToBigInt(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBigInt(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBigInt(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNumber(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNumber(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNumber(inputId);\
}\
\
[[nodiscard]] bool emitGuardToInt32(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToInt32(inputId);\
}\
\
[[nodiscard]] bool emitGuardToNonGCThing(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToNonGCThing(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToNonGCThing(inputId);\
}\
\
[[nodiscard]] bool emitGuardBooleanToInt32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardBooleanToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardBooleanToInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32Index(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32Index(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32Index(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32ToIntPtr(Int32OperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitInt32ToIntPtr(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitInt32ToIntPtr(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(NumberOperandId inputId, bool supportOOB, IntPtrOperandId resultId);\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  bool supportOOB = reader.readBool();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitGuardNumberToIntPtrIndex(inputId, supportOOB, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32ModUint32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32ModUint32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32ModUint32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToUint8Clamped(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToUint8Clamped(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToUint8Clamped(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNonDoubleType(ValOperandId inputId, ValueType type);\
[[nodiscard]] bool emitGuardNonDoubleType(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  ValueType type = reader.valueType();\
  return emitGuardNonDoubleType(inputId, type);\
}\
\
[[nodiscard]] bool emitGuardMultipleShapes(ObjOperandId objId, uint32_t shapesOffset);\
[[nodiscard]] bool emitGuardMultipleShapes(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapesOffset = reader.stubOffset();\
  return emitGuardMultipleShapes(objId, shapesOffset);\
}\
\
[[nodiscard]] bool emitGuardNullProto(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNullProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNullProto(objId);\
}\
\
[[nodiscard]] bool emitGuardClass(ObjOperandId objId, GuardClassKind kind);\
[[nodiscard]] bool emitGuardClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  GuardClassKind kind = reader.guardClassKind();\
  return emitGuardClass(objId, kind);\
}\
\
[[nodiscard]] bool emitGuardFuse(RealmFuses::FuseIndex fuseWord);\
[[nodiscard]] bool emitGuardFuse(CacheIRReader& reader) {\
  RealmFuses::FuseIndex fuseWord = reader.realmFuseIndex();\
  return emitGuardFuse(fuseWord);\
}\
\
[[nodiscard]] bool emitGuardRuntimeFuse(RuntimeFuses::FuseIndex fuseWord);\
[[nodiscard]] bool emitGuardRuntimeFuse(CacheIRReader& reader) {\
  RuntimeFuses::FuseIndex fuseWord = reader.runtimeFuseIndex();\
  return emitGuardRuntimeFuse(fuseWord);\
}\
\
[[nodiscard]] bool emitGuardObjectFuseProperty(ObjOperandId objId, uint32_t objFuseOwnerOffset, uint32_t objFuseOffset, uint32_t expectedGenerationOffset, uint32_t propIndexOffset, uint32_t propMaskOffset, bool canUseFastPath);\
[[nodiscard]] bool emitGuardObjectFuseProperty(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t objFuseOwnerOffset = reader.stubOffset();\
  uint32_t objFuseOffset = reader.stubOffset();\
  uint32_t expectedGenerationOffset = reader.stubOffset();\
  uint32_t propIndexOffset = reader.stubOffset();\
  uint32_t propMaskOffset = reader.stubOffset();\
  bool canUseFastPath = reader.readBool();\
  return emitGuardObjectFuseProperty(objId, objFuseOwnerOffset, objFuseOffset, expectedGenerationOffset, propIndexOffset, propMaskOffset, canUseFastPath);\
}\
\
[[nodiscard]] bool emitGuardGlobalGeneration(uint32_t expectedOffset, uint32_t generationAddrOffset);\
[[nodiscard]] bool emitGuardGlobalGeneration(CacheIRReader& reader) {\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t generationAddrOffset = reader.stubOffset();\
  return emitGuardGlobalGeneration(expectedOffset, generationAddrOffset);\
}\
\
[[nodiscard]] bool emitRegExpSearcherLastLimitResult();\
[[nodiscard]] bool emitRegExpSearcherLastLimitResult(CacheIRReader& reader) {\
  return emitRegExpSearcherLastLimitResult();\
}\
\
[[nodiscard]] bool emitRegExpFlagResult(ObjOperandId regexpId, int32_t flagsMask);\
[[nodiscard]] bool emitRegExpFlagResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  int32_t flagsMask = reader.int32Immediate();\
  return emitRegExpFlagResult(regexpId, flagsMask);\
}\
\
[[nodiscard]] bool emitCallSubstringKernelResult(StringOperandId strId, Int32OperandId beginId, Int32OperandId lengthId);\
[[nodiscard]] bool emitCallSubstringKernelResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitCallSubstringKernelResult(strId, beginId, lengthId);\
}\
\
[[nodiscard]] bool emitStringReplaceStringResult(StringOperandId strId, StringOperandId patternId, StringOperandId replacementId);\
[[nodiscard]] bool emitStringReplaceStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId patternId = reader.stringOperandId();\
  StringOperandId replacementId = reader.stringOperandId();\
  return emitStringReplaceStringResult(strId, patternId, replacementId);\
}\
\
[[nodiscard]] bool emitStringSplitStringResult(StringOperandId strId, StringOperandId separatorId);\
[[nodiscard]] bool emitStringSplitStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId separatorId = reader.stringOperandId();\
  return emitStringSplitStringResult(strId, separatorId);\
}\
\
[[nodiscard]] bool emitGetFirstDollarIndexResult(StringOperandId strId);\
[[nodiscard]] bool emitGetFirstDollarIndexResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitGetFirstDollarIndexResult(strId);\
}\
\
[[nodiscard]] bool emitGuardIsExtensible(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsExtensible(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsExtensible(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNativeObject(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNativeObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNativeObject(objId);\
}\
\
[[nodiscard]] bool emitGuardIsProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardToArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardToArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardToArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitGuardToSharedArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardToSharedArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardToSharedArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotArrayBufferMaybeShared(objId);\
}\
\
[[nodiscard]] bool emitGuardIsTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNonResizableTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNonResizableTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNonResizableTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardIsResizableTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsResizableTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsResizableTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotDOMProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotDOMProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotDOMProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardObjectIdentity(ObjOperandId obj1Id, ObjOperandId obj2Id);\
[[nodiscard]] bool emitGuardObjectIdentity(CacheIRReader& reader) {\
  ObjOperandId obj1Id = reader.objOperandId();\
  ObjOperandId obj2Id = reader.objOperandId();\
  return emitGuardObjectIdentity(obj1Id, obj2Id);\
}\
\
[[nodiscard]] bool emitGuardSpecificInt32(Int32OperandId numId, int32_t expected);\
[[nodiscard]] bool emitGuardSpecificInt32(CacheIRReader& reader) {\
  Int32OperandId numId = reader.int32OperandId();\
  int32_t expected = reader.int32Immediate();\
  return emitGuardSpecificInt32(numId, expected);\
}\
\
[[nodiscard]] bool emitGuardNoDenseElements(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNoDenseElements(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNoDenseElements(objId);\
}\
\
[[nodiscard]] bool emitGuardStringToIndex(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToIndex(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToIndex(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToInt32(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToInt32(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToInt32(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToNumber(StringOperandId strId, NumberOperandId resultId);\
[[nodiscard]] bool emitGuardStringToNumber(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitGuardStringToNumber(strId, resultId);\
}\
\
[[nodiscard]] bool emitStringToAtom(StringOperandId strId);\
[[nodiscard]] bool emitStringToAtom(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToAtom(strId);\
}\
\
[[nodiscard]] bool emitBooleanToNumber(BooleanOperandId booleanId, NumberOperandId resultId);\
[[nodiscard]] bool emitBooleanToNumber(CacheIRReader& reader) {\
  BooleanOperandId booleanId = reader.booleanOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitBooleanToNumber(booleanId, resultId);\
}\
\
[[nodiscard]] bool emitLoadGetterSetterFunction(ValOperandId getterSetterId, bool isGetter, bool needsClassGuard, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadGetterSetterFunction(CacheIRReader& reader) {\
  ValOperandId getterSetterId = reader.valOperandId();\
  bool isGetter = reader.readBool();\
  bool needsClassGuard = reader.readBool();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadGetterSetterFunction(getterSetterId, isGetter, needsClassGuard, resultId);\
}\
\
[[nodiscard]] bool emitGuardHasGetterSetter(ObjOperandId objId, uint32_t idOffset, uint32_t getterSetterOffset);\
[[nodiscard]] bool emitGuardHasGetterSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  uint32_t getterSetterOffset = reader.stubOffset();\
  return emitGuardHasGetterSetter(objId, idOffset, getterSetterOffset);\
}\
\
[[nodiscard]] bool emitGuardInt32IsNonNegative(Int32OperandId indexId);\
[[nodiscard]] bool emitGuardInt32IsNonNegative(CacheIRReader& reader) {\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardInt32IsNonNegative(indexId);\
}\
\
[[nodiscard]] bool emitGuardIntPtrIsNonNegative(IntPtrOperandId indexId);\
[[nodiscard]] bool emitGuardIntPtrIsNonNegative(CacheIRReader& reader) {\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  return emitGuardIntPtrIsNonNegative(indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexIsValidUpdateOrAdd(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexIsNotDenseElement(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexIsNotDenseElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexIsNotDenseElement(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardTagNotEqual(ValueTagOperandId lhsId, ValueTagOperandId rhsId);\
[[nodiscard]] bool emitGuardTagNotEqual(CacheIRReader& reader) {\
  ValueTagOperandId lhsId = reader.valueTagOperandId();\
  ValueTagOperandId rhsId = reader.valueTagOperandId();\
  return emitGuardTagNotEqual(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitGuardXrayExpandoShapeAndDefaultProto(ObjOperandId objId, uint32_t shapeWrapperOffset);\
[[nodiscard]] bool emitGuardXrayExpandoShapeAndDefaultProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeWrapperOffset = reader.stubOffset();\
  return emitGuardXrayExpandoShapeAndDefaultProto(objId, shapeWrapperOffset);\
}\
\
[[nodiscard]] bool emitGuardXrayNoExpando(ObjOperandId objId);\
[[nodiscard]] bool emitGuardXrayNoExpando(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardXrayNoExpando(objId);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(ObjOperandId objId, ObjOperandId expectedId, uint32_t slotOffset);\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId expectedId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitGuardDynamicSlotIsSpecificObject(objId, expectedId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotIsNotObject(ObjOperandId objId, uint32_t slotOffset);\
[[nodiscard]] bool emitGuardDynamicSlotIsNotObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitGuardDynamicSlotIsNotObject(objId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardFixedSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardFixedSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardFixedSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardDynamicSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardDynamicSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitCheckWeakValueResultForFixedSlot(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitCheckWeakValueResultForFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitCheckWeakValueResultForFixedSlot(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitCheckWeakValueResultForDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitCheckWeakValueResultForDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitCheckWeakValueResultForDynamicSlot(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitLoadScriptedProxyHandler(ObjOperandId resultId, ObjOperandId objId);\
[[nodiscard]] bool emitLoadScriptedProxyHandler(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadScriptedProxyHandler(resultId, objId);\
}\
\
[[nodiscard]] bool emitIdToStringOrSymbol(ValOperandId resultId, ValOperandId idId);\
[[nodiscard]] bool emitIdToStringOrSymbol(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitIdToStringOrSymbol(resultId, idId);\
}\
\
[[nodiscard]] bool emitLoadFixedSlot(ValOperandId resultId, ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadFixedSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadFixedSlot(resultId, objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadDynamicSlot(ValOperandId resultId, ObjOperandId objId, uint32_t slotOffset);\
[[nodiscard]] bool emitLoadDynamicSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitLoadDynamicSlot(resultId, objId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(uint32_t builderAddrOffset);\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(CacheIRReader& reader) {\
  uint32_t builderAddrOffset = reader.stubOffset();\
  return emitGuardNoAllocationMetadataBuilder(builderAddrOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionHasJitEntry(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionHasNoJitEntry(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsNonBuiltinCtor(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardNotClassConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardNotClassConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardNotClassConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardArrayIsPacked(ObjOperandId arrayId);\
[[nodiscard]] bool emitGuardArrayIsPacked(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitGuardArrayIsPacked(arrayId);\
}\
\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(ObjOperandId objId, uint8_t flags);\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint8_t flags = reader.readByte();\
  return emitGuardArgumentsObjectFlags(objId, flags);\
}\
\
[[nodiscard]] bool emitGuardObjectHasSameRealm(ObjOperandId objId);\
[[nodiscard]] bool emitGuardObjectHasSameRealm(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardObjectHasSameRealm(objId);\
}\
\
[[nodiscard]] bool emitLoadObject(ObjOperandId resultId, uint32_t objOffset);\
[[nodiscard]] bool emitLoadObject(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  uint32_t objOffset = reader.stubOffset();\
  return emitLoadObject(resultId, objOffset);\
}\
\
[[nodiscard]] bool emitLoadProtoObject(ObjOperandId resultId, uint32_t protoObjOffset, ObjOperandId receiverObjId);\
[[nodiscard]] bool emitLoadProtoObject(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  uint32_t protoObjOffset = reader.stubOffset();\
  ObjOperandId receiverObjId = reader.objOperandId();\
  return emitLoadProtoObject(resultId, protoObjOffset, receiverObjId);\
}\
\
[[nodiscard]] bool emitLoadProto(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadProto(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadEnclosingEnvironment(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadEnclosingEnvironment(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadEnclosingEnvironment(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadWrapperTarget(ObjOperandId objId, ObjOperandId resultId, bool fallible);\
[[nodiscard]] bool emitLoadWrapperTarget(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  bool fallible = reader.readBool();\
  return emitLoadWrapperTarget(objId, resultId, fallible);\
}\
\
[[nodiscard]] bool emitLoadValueTag(ValOperandId valId, ValueTagOperandId resultId);\
[[nodiscard]] bool emitLoadValueTag(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  ValueTagOperandId resultId = reader.valueTagOperandId();\
  return emitLoadValueTag(valId, resultId);\
}\
\
[[nodiscard]] bool emitTruncateDoubleToUInt32(NumberOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitTruncateDoubleToUInt32(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitTruncateDoubleToUInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitDoubleToUint8Clamped(NumberOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitDoubleToUint8Clamped(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitDoubleToUint8Clamped(inputId, resultId);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(ObjOperandId objId, uint32_t nameOffset);\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  return emitMegamorphicLoadSlotResult(objId, nameOffset);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitMegamorphicLoadSlotByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotPermissiveResult(ObjOperandId objId, uint32_t nameOffset);\
[[nodiscard]] bool emitMegamorphicLoadSlotPermissiveResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  return emitMegamorphicLoadSlotPermissiveResult(objId, nameOffset);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotByValuePermissiveResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitMegamorphicLoadSlotByValuePermissiveResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitMegamorphicLoadSlotByValuePermissiveResult(objId, idId);\
}\
\
[[nodiscard]] bool emitMegamorphicStoreSlot(ObjOperandId objId, uint32_t nameOffset, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitMegamorphicStoreSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitMegamorphicStoreSlot(objId, nameOffset, rhsId, strict);\
}\
\
[[nodiscard]] bool emitMegamorphicHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitMegamorphicHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitMegamorphicHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitSmallObjectVariableKeyHasOwnResult(StringOperandId idId, uint32_t propNamesOffset, uint32_t shapeOffset);\
[[nodiscard]] bool emitSmallObjectVariableKeyHasOwnResult(CacheIRReader& reader) {\
  StringOperandId idId = reader.stringOperandId();\
  uint32_t propNamesOffset = reader.stubOffset();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitSmallObjectVariableKeyHasOwnResult(idId, propNamesOffset, shapeOffset);\
}\
\
[[nodiscard]] bool emitObjectToIteratorResult(ObjOperandId objId, uint32_t enumeratorsAddrOffset);\
[[nodiscard]] bool emitObjectToIteratorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t enumeratorsAddrOffset = reader.stubOffset();\
  return emitObjectToIteratorResult(objId, enumeratorsAddrOffset);\
}\
\
[[nodiscard]] bool emitValueToIteratorResult(ValOperandId valId);\
[[nodiscard]] bool emitValueToIteratorResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  return emitValueToIteratorResult(valId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValue(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValue(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueIgnoreGeneration(objId, resultId);\
}\
\
[[nodiscard]] bool emitAddSlotAndCallAddPropHook(ObjOperandId objId, ValOperandId rhsId, uint32_t newShapeOffset);\
[[nodiscard]] bool emitAddSlotAndCallAddPropHook(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  return emitAddSlotAndCallAddPropHook(objId, rhsId, newShapeOffset);\
}\
\
[[nodiscard]] bool emitStoreDenseElement(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId, bool expectPackedElements);\
[[nodiscard]] bool emitStoreDenseElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool expectPackedElements = reader.readBool();\
  return emitStoreDenseElement(objId, indexId, rhsId, expectPackedElements);\
}\
\
[[nodiscard]] bool emitStoreDenseElementHole(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId, bool handleAdd);\
[[nodiscard]] bool emitStoreDenseElementHole(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool handleAdd = reader.readBool();\
  return emitStoreDenseElementHole(objId, indexId, rhsId, handleAdd);\
}\
\
[[nodiscard]] bool emitArrayPush(ObjOperandId objId, ValOperandId rhsId);\
[[nodiscard]] bool emitArrayPush(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitArrayPush(objId, rhsId);\
}\
\
[[nodiscard]] bool emitArrayJoinResult(ObjOperandId objId, StringOperandId sepId);\
[[nodiscard]] bool emitArrayJoinResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  StringOperandId sepId = reader.stringOperandId();\
  return emitArrayJoinResult(objId, sepId);\
}\
\
[[nodiscard]] bool emitObjectKeysResult(ObjOperandId objId, uint32_t resultShapeOffset);\
[[nodiscard]] bool emitObjectKeysResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t resultShapeOffset = reader.stubOffset();\
  return emitObjectKeysResult(objId, resultShapeOffset);\
}\
\
[[nodiscard]] bool emitPackedArrayPopResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayPopResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayPopResult(arrayId);\
}\
\
[[nodiscard]] bool emitPackedArrayShiftResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayShiftResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayShiftResult(arrayId);\
}\
\
[[nodiscard]] bool emitPackedArraySliceResult(uint32_t templateObjectOffset, ObjOperandId arrayId, Int32OperandId beginId, Int32OperandId endId);\
[[nodiscard]] bool emitPackedArraySliceResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId endId = reader.int32OperandId();\
  return emitPackedArraySliceResult(templateObjectOffset, arrayId, beginId, endId);\
}\
\
[[nodiscard]] bool emitArgumentsSliceResult(uint32_t templateObjectOffset, ObjOperandId argsId, Int32OperandId beginId, Int32OperandId endId);\
[[nodiscard]] bool emitArgumentsSliceResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId argsId = reader.objOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId endId = reader.int32OperandId();\
  return emitArgumentsSliceResult(templateObjectOffset, argsId, beginId, endId);\
}\
\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlotUndefinedResult(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitIsObjectResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsObjectResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsObjectResult(inputId);\
}\
\
[[nodiscard]] bool emitIsPackedArrayResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsPackedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsPackedArrayResult(objId);\
}\
\
[[nodiscard]] bool emitIsCallableResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsCallableResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsCallableResult(inputId);\
}\
\
[[nodiscard]] bool emitIsConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsCrossRealmArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsTypedArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetInt32Result(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitResizableDataViewByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitResizableDataViewByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableDataViewByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitResizableDataViewByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitResizableDataViewByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableDataViewByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGrowableSharedArrayBufferByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGrowableSharedArrayBufferByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardHasAttachedArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBounds(ObjOperandId objId);\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBounds(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardResizableArrayBufferViewInBounds(objId);\
}\
\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBoundsOrDetached(ObjOperandId objId);\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBoundsOrDetached(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardResizableArrayBufferViewInBoundsOrDetached(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayFillResult(ObjOperandId objId, uint32_t fillValueId, IntPtrOperandId startId, IntPtrOperandId endId, Scalar::Type elementType);\
[[nodiscard]] bool emitTypedArrayFillResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t fillValueId = reader.rawOperandId();\
  IntPtrOperandId startId = reader.intPtrOperandId();\
  IntPtrOperandId endId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitTypedArrayFillResult(objId, fillValueId, startId, endId, elementType);\
}\
\
[[nodiscard]] bool emitTypedArraySetResult(ObjOperandId targetId, ObjOperandId sourceId, IntPtrOperandId offsetId, bool canUseBitwiseCopy);\
[[nodiscard]] bool emitTypedArraySetResult(CacheIRReader& reader) {\
  ObjOperandId targetId = reader.objOperandId();\
  ObjOperandId sourceId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  bool canUseBitwiseCopy = reader.readBool();\
  return emitTypedArraySetResult(targetId, sourceId, offsetId, canUseBitwiseCopy);\
}\
\
[[nodiscard]] bool emitTypedArraySubarrayResult(uint32_t templateObjectOffset, ObjOperandId objId, IntPtrOperandId startId, IntPtrOperandId endId);\
[[nodiscard]] bool emitTypedArraySubarrayResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId startId = reader.intPtrOperandId();\
  IntPtrOperandId endId = reader.intPtrOperandId();\
  return emitTypedArraySubarrayResult(templateObjectOffset, objId, startId, endId);\
}\
\
[[nodiscard]] bool emitNewArrayIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewArrayIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewArrayIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewRegExpStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitObjectCreateResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitObjectCreateResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitObjectCreateResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId, uint32_t siteOffset);\
[[nodiscard]] bool emitNewArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewArrayFromLengthResult(templateObjectOffset, lengthId, siteOffset);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitNewTypedArrayFromLengthResult(templateObjectOffset, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(uint32_t templateObjectOffset, ObjOperandId bufferId, ValOperandId byteOffsetId, ValOperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId bufferId = reader.objOperandId();\
  ValOperandId byteOffsetId = reader.valOperandId();\
  ValOperandId lengthId = reader.valOperandId();\
  return emitNewTypedArrayFromArrayBufferResult(templateObjectOffset, bufferId, byteOffsetId, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(uint32_t templateObjectOffset, ObjOperandId arrayId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitNewTypedArrayFromArrayResult(templateObjectOffset, arrayId);\
}\
\
[[nodiscard]] bool emitNewMapObjectResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewMapObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewMapObjectResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewSetObjectResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewSetObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewSetObjectResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewMapObjectFromIterableResult(uint32_t templateObjectOffset, ValOperandId iterableId);\
[[nodiscard]] bool emitNewMapObjectFromIterableResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ValOperandId iterableId = reader.valOperandId();\
  return emitNewMapObjectFromIterableResult(templateObjectOffset, iterableId);\
}\
\
[[nodiscard]] bool emitNewSetObjectFromIterableResult(uint32_t templateObjectOffset, ValOperandId iterableId);\
[[nodiscard]] bool emitNewSetObjectFromIterableResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ValOperandId iterableId = reader.valOperandId();\
  return emitNewSetObjectFromIterableResult(templateObjectOffset, iterableId);\
}\
\
[[nodiscard]] bool emitNewStringObjectResult(uint32_t templateObjectOffset, StringOperandId strId);\
[[nodiscard]] bool emitNewStringObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  StringOperandId strId = reader.stringOperandId();\
  return emitNewStringObjectResult(templateObjectOffset, strId);\
}\
\
[[nodiscard]] bool emitStringIncludesResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringIncludesResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringIncludesResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringIndexOfResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringIndexOfResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringIndexOfResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringLastIndexOfResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringLastIndexOfResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringLastIndexOfResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringStartsWithResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringStartsWithResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringStartsWithResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringEndsWithResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringEndsWithResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringEndsWithResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringToLowerCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToLowerCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToLowerCaseResult(strId);\
}\
\
[[nodiscard]] bool emitStringToUpperCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToUpperCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToUpperCaseResult(strId);\
}\
\
[[nodiscard]] bool emitStringTrimResult(StringOperandId strId);\
[[nodiscard]] bool emitStringTrimResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringTrimResult(strId);\
}\
\
[[nodiscard]] bool emitStringTrimStartResult(StringOperandId strId);\
[[nodiscard]] bool emitStringTrimStartResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringTrimStartResult(strId);\
}\
\
[[nodiscard]] bool emitStringTrimEndResult(StringOperandId strId);\
[[nodiscard]] bool emitStringTrimEndResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringTrimEndResult(strId);\
}\
\
[[nodiscard]] bool emitMathAbsInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathAbsInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathAbsInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathAbsNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathAbsNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathAbsNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathClz32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathClz32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathClz32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathSignInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathSignInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathImulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitMathImulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitMathImulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathSqrtNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSqrtNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSqrtNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFRoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFRoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFRoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathF16RoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathF16RoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathF16RoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathRandomResult(uint32_t rngOffset);\
[[nodiscard]] bool emitMathRandomResult(CacheIRReader& reader) {\
  uint32_t rngOffset = reader.stubOffset();\
  return emitMathRandomResult(rngOffset);\
}\
\
[[nodiscard]] bool emitMathHypot2NumberResult(NumberOperandId firstId, NumberOperandId secondId);\
[[nodiscard]] bool emitMathHypot2NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  return emitMathHypot2NumberResult(firstId, secondId);\
}\
\
[[nodiscard]] bool emitMathHypot3NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId);\
[[nodiscard]] bool emitMathHypot3NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  return emitMathHypot3NumberResult(firstId, secondId, thirdId);\
}\
\
[[nodiscard]] bool emitMathHypot4NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId, NumberOperandId fourthId);\
[[nodiscard]] bool emitMathHypot4NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  NumberOperandId fourthId = reader.numberOperandId();\
  return emitMathHypot4NumberResult(firstId, secondId, thirdId, fourthId);\
}\
\
[[nodiscard]] bool emitMathAtan2NumberResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitMathAtan2NumberResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitMathAtan2NumberResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathFloorNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathRoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathRoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathRoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFloorToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathRoundToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathRoundToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathRoundToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitInt32MinMax(bool isMax, Int32OperandId firstId, Int32OperandId secondId, Int32OperandId resultId);\
[[nodiscard]] bool emitInt32MinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  Int32OperandId firstId = reader.int32OperandId();\
  Int32OperandId secondId = reader.int32OperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitInt32MinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitNumberMinMax(bool isMax, NumberOperandId firstId, NumberOperandId secondId, NumberOperandId resultId);\
[[nodiscard]] bool emitNumberMinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitNumberMinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitInt32MinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitInt32MinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitInt32MinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitNumberMinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitNumberMinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitNumberMinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitMathFunctionNumberResult(NumberOperandId inputId, UnaryMathFunction fun);\
[[nodiscard]] bool emitMathFunctionNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  UnaryMathFunction fun = reader.unaryMathFunction();\
  return emitMathFunctionNumberResult(inputId, fun);\
}\
\
[[nodiscard]] bool emitNumberParseIntResult(StringOperandId strId, Int32OperandId radixId);\
[[nodiscard]] bool emitNumberParseIntResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId radixId = reader.int32OperandId();\
  return emitNumberParseIntResult(strId, radixId);\
}\
\
[[nodiscard]] bool emitDoubleParseIntResult(NumberOperandId numId);\
[[nodiscard]] bool emitDoubleParseIntResult(CacheIRReader& reader) {\
  NumberOperandId numId = reader.numberOperandId();\
  return emitDoubleParseIntResult(numId);\
}\
\
[[nodiscard]] bool emitObjectToStringResult(ObjOperandId objId);\
[[nodiscard]] bool emitObjectToStringResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitObjectToStringResult(objId);\
}\
\
[[nodiscard]] bool emitStoreTypedArrayElement(ObjOperandId objId, Scalar::Type elementType, IntPtrOperandId indexId, uint32_t rhsId, bool handleOOB, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitStoreTypedArrayElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t rhsId = reader.rawOperandId();\
  bool handleOOB = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitStoreTypedArrayElement(objId, elementType, indexId, rhsId, handleOOB, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t expectedId, uint32_t replacementId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t expectedId = reader.rawOperandId();\
  uint32_t replacementId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsCompareExchangeResult(objId, indexId, expectedId, replacementId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsExchangeResult(objId, indexId, valueId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsAddResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsAddResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsAddResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsSubResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsSubResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsSubResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsAndResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsAndResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsAndResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsOrResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsOrResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsOrResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsXorResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsXorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsXorResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsLoadResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsLoadResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsLoadResult(objId, indexId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsStoreResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsStoreResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsStoreResult(objId, indexId, valueId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(Int32OperandId valueId);\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(CacheIRReader& reader) {\
  Int32OperandId valueId = reader.int32OperandId();\
  return emitAtomicsIsLockFreeResult(valueId);\
}\
\
[[nodiscard]] bool emitAtomicsPauseResult();\
[[nodiscard]] bool emitAtomicsPauseResult(CacheIRReader& reader) {\
  return emitAtomicsPauseResult();\
}\
\
[[nodiscard]] bool emitCallInt32ToString(Int32OperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallInt32ToString(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallInt32ToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitCallNumberToString(NumberOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallNumberToString(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallNumberToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32ToStringWithBaseResult(Int32OperandId inputId, Int32OperandId baseId);\
[[nodiscard]] bool emitInt32ToStringWithBaseResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  Int32OperandId baseId = reader.int32OperandId();\
  return emitInt32ToStringWithBaseResult(inputId, baseId);\
}\
\
[[nodiscard]] bool emitBooleanToString(BooleanOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitBooleanToString(CacheIRReader& reader) {\
  BooleanOperandId inputId = reader.booleanOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitBooleanToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardWasmArg(ValOperandId argId, wasm::ValType::Kind type);\
[[nodiscard]] bool emitGuardWasmArg(CacheIRReader& reader) {\
  ValOperandId argId = reader.valOperandId();\
  wasm::ValType::Kind type = reader.wasmValType();\
  return emitGuardWasmArg(argId, type);\
}\
\
[[nodiscard]] bool emitMetaScriptedThisShape(uint32_t thisShapeOffset);\
[[nodiscard]] bool emitMetaScriptedThisShape(CacheIRReader& reader) {\
  uint32_t thisShapeOffset = reader.stubOffset();\
  return emitMetaScriptedThisShape(thisShapeOffset);\
}\
\
[[nodiscard]] bool emitBindFunctionResult(ObjOperandId targetId, uint32_t argc, uint32_t templateObjectOffset);\
[[nodiscard]] bool emitBindFunctionResult(CacheIRReader& reader) {\
  ObjOperandId targetId = reader.objOperandId();\
  uint32_t argc = reader.uint32Immediate();\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitBindFunctionResult(targetId, argc, templateObjectOffset);\
}\
\
[[nodiscard]] bool emitSpecializedBindFunctionResult(ObjOperandId targetId, uint32_t argc, uint32_t templateObjectOffset);\
[[nodiscard]] bool emitSpecializedBindFunctionResult(CacheIRReader& reader) {\
  ObjOperandId targetId = reader.objOperandId();\
  uint32_t argc = reader.uint32Immediate();\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitSpecializedBindFunctionResult(targetId, argc, templateObjectOffset);\
}\
\
[[nodiscard]] bool emitLoadDenseElementResult(ObjOperandId objId, Int32OperandId indexId, bool expectPackedElements);\
[[nodiscard]] bool emitLoadDenseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool expectPackedElements = reader.readBool();\
  return emitLoadDenseElementResult(objId, indexId, expectPackedElements);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallGetSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallGetSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallGetSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(ObjOperandId objId, IntPtrOperandId indexId, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitLoadTypedArrayElementExistsResult(objId, indexId, viewKind);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType, bool handleOOB, bool forceDoubleForUint32, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitLoadTypedArrayElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool handleOOB = reader.readBool();\
  bool forceDoubleForUint32 = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitLoadTypedArrayElementResult(objId, indexId, elementType, handleOOB, forceDoubleForUint32, viewKind);\
}\
\
[[nodiscard]] bool emitLoadDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, BooleanOperandId littleEndianId, Scalar::Type elementType, bool forceDoubleForUint32, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitLoadDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forceDoubleForUint32 = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitLoadDataViewValueResult(objId, offsetId, littleEndianId, elementType, forceDoubleForUint32, viewKind);\
}\
\
[[nodiscard]] bool emitStoreDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, uint32_t valueId, BooleanOperandId littleEndianId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitStoreDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitStoreDataViewValueResult(objId, offsetId, valueId, littleEndianId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadInt32ArrayLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLength(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32ArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32ArrayLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgHoleResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgHoleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgHoleResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArgumentsObjectLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectLength(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadArgumentsObjectLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadArgumentsObjectLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadFunctionLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadFunctionNameResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionNameResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionNameResult(objId);\
}\
\
[[nodiscard]] bool emitLoadBoundFunctionNumArgs(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadBoundFunctionNumArgs(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadBoundFunctionNumArgs(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadBoundFunctionTarget(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadBoundFunctionTarget(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadBoundFunctionTarget(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadBoundFunctionArgument(ObjOperandId objId, uint32_t index, ValOperandId resultId);\
[[nodiscard]] bool emitLoadBoundFunctionArgument(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t index = reader.uint32Immediate();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadBoundFunctionArgument(objId, index, resultId);\
}\
\
[[nodiscard]] bool emitGuardBoundFunctionIsConstructor(ObjOperandId objId);\
[[nodiscard]] bool emitGuardBoundFunctionIsConstructor(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardBoundFunctionIsConstructor(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLength(ObjOperandId objId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitLoadArrayBufferViewLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitLoadArrayBufferViewLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLinearizeForCharAccess(StringOperandId strId, Int32OperandId indexId, StringOperandId resultId);\
[[nodiscard]] bool emitLinearizeForCharAccess(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLinearizeForCharAccess(strId, indexId, resultId);\
}\
\
[[nodiscard]] bool emitLinearizeForCodePointAccess(StringOperandId strId, Int32OperandId indexId, StringOperandId resultId);\
[[nodiscard]] bool emitLinearizeForCodePointAccess(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLinearizeForCodePointAccess(strId, indexId, resultId);\
}\
\
[[nodiscard]] bool emitToRelativeStringIndex(Int32OperandId indexId, StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitToRelativeStringIndex(CacheIRReader& reader) {\
  Int32OperandId indexId = reader.int32OperandId();\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitToRelativeStringIndex(indexId, strId, resultId);\
}\
\
[[nodiscard]] bool emitLoadStringCharCodeResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringCharCodeResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringCharCodeResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitLoadStringCodePointResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringCodePointResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringCodePointResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitLoadStringLengthResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringLengthResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringLengthResult(strId);\
}\
\
[[nodiscard]] bool emitLoadObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectResult(objId);\
}\
\
[[nodiscard]] bool emitLoadStringResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringResult(strId);\
}\
\
[[nodiscard]] bool emitLoadSymbolResult(SymbolOperandId symId);\
[[nodiscard]] bool emitLoadSymbolResult(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitLoadSymbolResult(symId);\
}\
\
[[nodiscard]] bool emitLoadInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitLoadInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitLoadInt32Result(valId);\
}\
\
[[nodiscard]] bool emitLoadDoubleResult(NumberOperandId valId);\
[[nodiscard]] bool emitLoadDoubleResult(CacheIRReader& reader) {\
  NumberOperandId valId = reader.numberOperandId();\
  return emitLoadDoubleResult(valId);\
}\
\
[[nodiscard]] bool emitLoadBigIntResult(BigIntOperandId valId);\
[[nodiscard]] bool emitLoadBigIntResult(CacheIRReader& reader) {\
  BigIntOperandId valId = reader.bigIntOperandId();\
  return emitLoadBigIntResult(valId);\
}\
\
[[nodiscard]] bool emitProxyGetByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitProxyGetByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitProxyGetByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitProxyHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitProxyHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitProxyHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallObjectHasSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallNativeGetElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallNativeGetElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallNativeGetElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallNativeGetElementSuperResult(ObjOperandId objId, Int32OperandId indexId, ValOperandId receiverId);\
[[nodiscard]] bool emitCallNativeGetElementSuperResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId receiverId = reader.valOperandId();\
  return emitCallNativeGetElementSuperResult(objId, indexId, receiverId);\
}\
\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(ObjOperandId iterId, ObjOperandId resultArrId, bool isMap);\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(CacheIRReader& reader) {\
  ObjOperandId iterId = reader.objOperandId();\
  ObjOperandId resultArrId = reader.objOperandId();\
  bool isMap = reader.readBool();\
  return emitGetNextMapSetEntryForIteratorResult(iterId, resultArrId, isMap);\
}\
\
[[nodiscard]] bool emitLoadUndefinedResult();\
[[nodiscard]] bool emitLoadUndefinedResult(CacheIRReader& reader) {\
  return emitLoadUndefinedResult();\
}\
\
[[nodiscard]] bool emitLoadBooleanResult(bool val);\
[[nodiscard]] bool emitLoadBooleanResult(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  return emitLoadBooleanResult(val);\
}\
\
[[nodiscard]] bool emitLoadInt32Constant(uint32_t valOffset, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32Constant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32Constant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadInt32AsIntPtrConstant(uint32_t valOffset, IntPtrOperandId resultId);\
[[nodiscard]] bool emitLoadInt32AsIntPtrConstant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitLoadInt32AsIntPtrConstant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadDoubleConstant(uint32_t valOffset, NumberOperandId resultId);\
[[nodiscard]] bool emitLoadDoubleConstant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitLoadDoubleConstant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadBooleanConstant(bool val, BooleanOperandId resultId);\
[[nodiscard]] bool emitLoadBooleanConstant(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  BooleanOperandId resultId = reader.booleanOperandId();\
  return emitLoadBooleanConstant(val, resultId);\
}\
\
[[nodiscard]] bool emitLoadUndefined(ValOperandId resultId);\
[[nodiscard]] bool emitLoadUndefined(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadUndefined(resultId);\
}\
\
[[nodiscard]] bool emitLoadConstantString(uint32_t strOffset, StringOperandId resultId);\
[[nodiscard]] bool emitLoadConstantString(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLoadConstantString(strOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(ValOperandId lhsId, ObjOperandId protoId);\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ObjOperandId protoId = reader.objOperandId();\
  return emitLoadInstanceOfObjectResult(lhsId, protoId);\
}\
\
[[nodiscard]] bool emitLoadTypeOfObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadTypeOfObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadTypeOfObjectResult(objId);\
}\
\
[[nodiscard]] bool emitLoadTypeOfEqObjectResult(ObjOperandId objId, TypeofEqOperand operand);\
[[nodiscard]] bool emitLoadTypeOfEqObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  TypeofEqOperand operand = reader.typeofEqOperand();\
  return emitLoadTypeOfEqObjectResult(objId, operand);\
}\
\
[[nodiscard]] bool emitDoubleAddResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleAddResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleSubResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleSubResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleMulResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleMulResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleDivResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleDivResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleModResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleModResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoublePowResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoublePowResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoublePowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32AddResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32AddResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32AddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32SubResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32SubResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32SubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32MulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32MulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32MulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32DivResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32DivResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32DivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32ModResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32ModResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32ModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32PowResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32PowResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32PowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntAddResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntAddResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntSubResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntSubResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntMulResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntMulResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntDivResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntDivResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntModResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntModResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntPowResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntPowResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntPowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntToIntPtr(BigIntOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntToIntPtr(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntToIntPtr(inputId, resultId);\
}\
\
[[nodiscard]] bool emitIntPtrToBigIntResult(IntPtrOperandId inputId);\
[[nodiscard]] bool emitIntPtrToBigIntResult(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  return emitIntPtrToBigIntResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrAdd(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrAdd(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrAdd(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrSub(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrSub(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrSub(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrMul(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrMul(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrMul(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrDiv(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrDiv(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrDiv(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrMod(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrMod(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrMod(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrPow(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrPow(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrPow(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitInt32BitOrResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitOrResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitXorResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitXorResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitAndResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitAndResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32LeftShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32LeftShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32LeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32RightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32RightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32RightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32URightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId, bool forceDouble);\
[[nodiscard]] bool emitInt32URightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  bool forceDouble = reader.readBool();\
  return emitInt32URightShiftResult(lhsId, rhsId, forceDouble);\
}\
\
[[nodiscard]] bool emitInt32NotResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NotResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NotResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntBitOrResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitOrResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitXorResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitXorResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitAndResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitAndResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntLeftShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntLeftShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntLeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntRightShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntRightShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntRightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntNotResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNotResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNotResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrBitOr(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrBitOr(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrBitOr(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrBitXor(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrBitXor(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrBitXor(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrBitAnd(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrBitAnd(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrBitAnd(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrLeftShift(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrLeftShift(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrLeftShift(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrRightShift(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrRightShift(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrRightShift(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrNot(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrNot(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrNot(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32NegationResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NegationResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NegationResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleNegationResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleNegationResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntNegationResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNegationResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrNegation(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrNegation(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrNegation(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32IncResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32IncResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32IncResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32DecResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32DecResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32DecResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleIncResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleIncResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleIncResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleDecResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleDecResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleDecResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntIncResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntIncResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntIncResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntDecResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntDecResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntDecResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrInc(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrInc(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrInc(inputId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrDec(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrDec(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrDec(inputId, resultId);\
}\
\
[[nodiscard]] bool emitLoadInt32TruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadInt32TruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadInt32TruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadDoubleTruthyResult(NumberOperandId inputId);\
[[nodiscard]] bool emitLoadDoubleTruthyResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitLoadDoubleTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadStringTruthyResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringTruthyResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringTruthyResult(strId);\
}\
\
[[nodiscard]] bool emitLoadObjectTruthyResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectTruthyResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectTruthyResult(objId);\
}\
\
[[nodiscard]] bool emitLoadBigIntTruthyResult(BigIntOperandId bigIntId);\
[[nodiscard]] bool emitLoadBigIntTruthyResult(CacheIRReader& reader) {\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitLoadBigIntTruthyResult(bigIntId);\
}\
\
[[nodiscard]] bool emitLoadValueTruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadValueTruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadValueTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadOperandResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadOperandResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadOperandResult(inputId);\
}\
\
[[nodiscard]] bool emitConcatStringsResult(StringOperandId lhsId, StringOperandId rhsId, uint32_t stubOffset);\
[[nodiscard]] bool emitConcatStringsResult(CacheIRReader& reader) {\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitConcatStringsResult(lhsId, rhsId, stubOffset);\
}\
\
[[nodiscard]] bool emitCallIsSuspendedGeneratorResult(ValOperandId valId);\
[[nodiscard]] bool emitCallIsSuspendedGeneratorResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  return emitCallIsSuspendedGeneratorResult(valId);\
}\
\
[[nodiscard]] bool emitCompareObjectResult(JSOp op, ObjOperandId lhsId, ObjOperandId rhsId);\
[[nodiscard]] bool emitCompareObjectResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  ObjOperandId lhsId = reader.objOperandId();\
  ObjOperandId rhsId = reader.objOperandId();\
  return emitCompareObjectResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareSymbolResult(JSOp op, SymbolOperandId lhsId, SymbolOperandId rhsId);\
[[nodiscard]] bool emitCompareSymbolResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  SymbolOperandId lhsId = reader.symbolOperandId();\
  SymbolOperandId rhsId = reader.symbolOperandId();\
  return emitCompareSymbolResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareInt32Result(JSOp op, Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareDoubleResult(JSOp op, NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntResult(JSOp op, BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitCompareBigIntResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntInt32Result(JSOp op, BigIntOperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareBigIntInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntNumberResult(JSOp op, BigIntOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntNumberResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareBigIntNumberResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntStringResult(JSOp op, BigIntOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareBigIntStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareNullUndefinedResult(JSOp op, bool isUndefined, ValOperandId inputId);\
[[nodiscard]] bool emitCompareNullUndefinedResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  bool isUndefined = reader.readBool();\
  ValOperandId inputId = reader.valOperandId();\
  return emitCompareNullUndefinedResult(op, isUndefined, inputId);\
}\
\
[[nodiscard]] bool emitCompareDoubleSameValueResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleSameValueResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleSameValueResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitIndirectTruncateInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitIndirectTruncateInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitIndirectTruncateInt32Result(valId);\
}\
\
[[nodiscard]] bool emitBigIntAsIntNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsIntNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsIntNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitBigIntAsUintNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsUintNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsUintNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitSetHasResult(ObjOperandId setId, ValOperandId valId);\
[[nodiscard]] bool emitSetHasResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitSetHasResult(setId, valId);\
}\
\
[[nodiscard]] bool emitSetHasNonGCThingResult(ObjOperandId setId, ValOperandId valId);\
[[nodiscard]] bool emitSetHasNonGCThingResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitSetHasNonGCThingResult(setId, valId);\
}\
\
[[nodiscard]] bool emitSetHasSymbolResult(ObjOperandId setId, SymbolOperandId symId);\
[[nodiscard]] bool emitSetHasSymbolResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitSetHasSymbolResult(setId, symId);\
}\
\
[[nodiscard]] bool emitSetHasBigIntResult(ObjOperandId setId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitSetHasBigIntResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitSetHasBigIntResult(setId, bigIntId);\
}\
\
[[nodiscard]] bool emitSetHasObjectResult(ObjOperandId setId, ObjOperandId objId);\
[[nodiscard]] bool emitSetHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitSetHasObjectResult(setId, objId);\
}\
\
[[nodiscard]] bool emitSetDeleteResult(ObjOperandId setId, ValOperandId valId);\
[[nodiscard]] bool emitSetDeleteResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitSetDeleteResult(setId, valId);\
}\
\
[[nodiscard]] bool emitSetAddResult(ObjOperandId setId, ValOperandId keyId);\
[[nodiscard]] bool emitSetAddResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId keyId = reader.valOperandId();\
  return emitSetAddResult(setId, keyId);\
}\
\
[[nodiscard]] bool emitSetSizeResult(ObjOperandId setId);\
[[nodiscard]] bool emitSetSizeResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  return emitSetSizeResult(setId);\
}\
\
[[nodiscard]] bool emitMapHasResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapHasResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapHasResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapHasNonGCThingResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapHasNonGCThingResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapHasNonGCThingResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapHasSymbolResult(ObjOperandId mapId, SymbolOperandId symId);\
[[nodiscard]] bool emitMapHasSymbolResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitMapHasSymbolResult(mapId, symId);\
}\
\
[[nodiscard]] bool emitMapHasBigIntResult(ObjOperandId mapId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitMapHasBigIntResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitMapHasBigIntResult(mapId, bigIntId);\
}\
\
[[nodiscard]] bool emitMapHasObjectResult(ObjOperandId mapId, ObjOperandId objId);\
[[nodiscard]] bool emitMapHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitMapHasObjectResult(mapId, objId);\
}\
\
[[nodiscard]] bool emitMapGetResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapGetResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapGetResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapGetNonGCThingResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapGetNonGCThingResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapGetNonGCThingResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapGetSymbolResult(ObjOperandId mapId, SymbolOperandId symId);\
[[nodiscard]] bool emitMapGetSymbolResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitMapGetSymbolResult(mapId, symId);\
}\
\
[[nodiscard]] bool emitMapGetBigIntResult(ObjOperandId mapId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitMapGetBigIntResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitMapGetBigIntResult(mapId, bigIntId);\
}\
\
[[nodiscard]] bool emitMapGetObjectResult(ObjOperandId mapId, ObjOperandId objId);\
[[nodiscard]] bool emitMapGetObjectResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitMapGetObjectResult(mapId, objId);\
}\
\
[[nodiscard]] bool emitMapDeleteResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapDeleteResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapDeleteResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapSetResult(ObjOperandId mapId, ValOperandId keyId, ValOperandId valId);\
[[nodiscard]] bool emitMapSetResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId keyId = reader.valOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapSetResult(mapId, keyId, valId);\
}\
\
[[nodiscard]] bool emitMapSizeResult(ObjOperandId mapId);\
[[nodiscard]] bool emitMapSizeResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  return emitMapSizeResult(mapId);\
}\
\
[[nodiscard]] bool emitWeakMapGetObjectResult(ObjOperandId weakMapId, ObjOperandId objId);\
[[nodiscard]] bool emitWeakMapGetObjectResult(CacheIRReader& reader) {\
  ObjOperandId weakMapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitWeakMapGetObjectResult(weakMapId, objId);\
}\
\
[[nodiscard]] bool emitWeakMapHasObjectResult(ObjOperandId weakMapId, ObjOperandId objId);\
[[nodiscard]] bool emitWeakMapHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId weakMapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitWeakMapHasObjectResult(weakMapId, objId);\
}\
\
[[nodiscard]] bool emitWeakSetHasObjectResult(ObjOperandId weakSetId, ObjOperandId objId);\
[[nodiscard]] bool emitWeakSetHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId weakSetId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitWeakSetHasObjectResult(weakSetId, objId);\
}\
\
[[nodiscard]] bool emitDateFillLocalTimeSlots(ObjOperandId dateId);\
[[nodiscard]] bool emitDateFillLocalTimeSlots(CacheIRReader& reader) {\
  ObjOperandId dateId = reader.objOperandId();\
  return emitDateFillLocalTimeSlots(dateId);\
}\
\
[[nodiscard]] bool emitDateHoursFromSecondsIntoYearResult(ValOperandId secondsIntoYearId);\
[[nodiscard]] bool emitDateHoursFromSecondsIntoYearResult(CacheIRReader& reader) {\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  return emitDateHoursFromSecondsIntoYearResult(secondsIntoYearId);\
}\
\
[[nodiscard]] bool emitDateMinutesFromSecondsIntoYearResult(ValOperandId secondsIntoYearId);\
[[nodiscard]] bool emitDateMinutesFromSecondsIntoYearResult(CacheIRReader& reader) {\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  return emitDateMinutesFromSecondsIntoYearResult(secondsIntoYearId);\
}\
\
[[nodiscard]] bool emitDateSecondsFromSecondsIntoYearResult(ValOperandId secondsIntoYearId);\
[[nodiscard]] bool emitDateSecondsFromSecondsIntoYearResult(CacheIRReader& reader) {\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  return emitDateSecondsFromSecondsIntoYearResult(secondsIntoYearId);\
}\
\
[[nodiscard]] bool emitArrayFromArgumentsObjectResult(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitArrayFromArgumentsObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitArrayFromArgumentsObjectResult(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitCallPrintString(const char* str);\
[[nodiscard]] bool emitCallPrintString(CacheIRReader& reader) {\
  const char* str = reinterpret_cast<char*>(reader.pointer());\
  return emitCallPrintString(str);\
}\
\
[[nodiscard]] bool emitBreakpoint();\
[[nodiscard]] bool emitBreakpoint(CacheIRReader& reader) {\
  return emitBreakpoint();\
}\
\
[[nodiscard]] bool emitWrapResult();\
[[nodiscard]] bool emitWrapResult(CacheIRReader& reader) {\
  return emitWrapResult();\
}\
\
[[nodiscard]] bool emitBailout();\
[[nodiscard]] bool emitBailout(CacheIRReader& reader) {\
  return emitBailout();\
}\
\
[[nodiscard]] bool emitAssertFloat32Result(ValOperandId valId, bool mustBeFloat32);\
[[nodiscard]] bool emitAssertFloat32Result(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  bool mustBeFloat32 = reader.readBool();\
  return emitAssertFloat32Result(valId, mustBeFloat32);\
}\
\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(ValOperandId valId, bool mustBeRecovered);\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  bool mustBeRecovered = reader.readBool();\
  return emitAssertRecoveredOnBailoutResult(valId, mustBeRecovered);\
}\
\
[[nodiscard]] bool emitAssertPropertyLookup(ObjOperandId objId, uint32_t idOffset, uint32_t slotOffset);\
[[nodiscard]] bool emitAssertPropertyLookup(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitAssertPropertyLookup(objId, idOffset, slotOffset);\
}\


#define CACHE_IR_COMPILER_UNSHARED_GENERATED \
[[nodiscard]] bool emitReturnFromIC();\
[[nodiscard]] bool emitReturnFromIC(CacheIRReader& reader) {\
  return emitReturnFromIC();\
}\
\
[[nodiscard]] bool emitGuardShape(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardShape(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardShape(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitGuardProto(ObjOperandId objId, uint32_t protoOffset);\
[[nodiscard]] bool emitGuardProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t protoOffset = reader.stubOffset();\
  return emitGuardProto(objId, protoOffset);\
}\
\
[[nodiscard]] bool emitGuardAnyClass(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitGuardAnyClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitGuardAnyClass(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitHasClassResult(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitHasClassResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitHasClassResult(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitHasShapeResult(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitHasShapeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitHasShapeResult(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitCallRegExpMatcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId, uint32_t stubOffset);\
[[nodiscard]] bool emitCallRegExpMatcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitCallRegExpMatcherResult(regexpId, inputId, lastIndexId, stubOffset);\
}\
\
[[nodiscard]] bool emitCallRegExpSearcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId, uint32_t stubOffset);\
[[nodiscard]] bool emitCallRegExpSearcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitCallRegExpSearcherResult(regexpId, inputId, lastIndexId, stubOffset);\
}\
\
[[nodiscard]] bool emitRegExpHasCaptureGroupsResult(ObjOperandId regexpId, StringOperandId inputId);\
[[nodiscard]] bool emitRegExpHasCaptureGroupsResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  return emitRegExpHasCaptureGroupsResult(regexpId, inputId);\
}\
\
[[nodiscard]] bool emitRegExpBuiltinExecMatchResult(ObjOperandId regexpId, StringOperandId inputId, uint32_t stubOffset);\
[[nodiscard]] bool emitRegExpBuiltinExecMatchResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitRegExpBuiltinExecMatchResult(regexpId, inputId, stubOffset);\
}\
\
[[nodiscard]] bool emitRegExpBuiltinExecTestResult(ObjOperandId regexpId, StringOperandId inputId, uint32_t stubOffset);\
[[nodiscard]] bool emitRegExpBuiltinExecTestResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitRegExpBuiltinExecTestResult(regexpId, inputId, stubOffset);\
}\
\
[[nodiscard]] bool emitGuardCompartment(ObjOperandId objId, uint32_t globalOffset, uint32_t compartmentOffset);\
[[nodiscard]] bool emitGuardCompartment(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t globalOffset = reader.stubOffset();\
  uint32_t compartmentOffset = reader.stubOffset();\
  return emitGuardCompartment(objId, globalOffset, compartmentOffset);\
}\
\
[[nodiscard]] bool emitGuardHasProxyHandler(ObjOperandId objId, uint32_t handlerOffset);\
[[nodiscard]] bool emitGuardHasProxyHandler(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t handlerOffset = reader.stubOffset();\
  return emitGuardHasProxyHandler(objId, handlerOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificObject(ObjOperandId objId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificObject(objId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificFunction(ObjOperandId funId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardSpecificFunction(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardSpecificFunction(funId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionScript(ObjOperandId objId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardFunctionScript(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardFunctionScript(objId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificAtom(StringOperandId strId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificAtom(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificAtom(strId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificSymbol(SymbolOperandId symId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificSymbol(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificSymbol(symId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificValue(ValOperandId valId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificValue(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificValue(valId, expectedOffset);\
}\
\
[[nodiscard]] bool emitLoadArgumentFixedSlot(ValOperandId resultId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentFixedSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentFixedSlot(resultId, slotIndex);\
}\
\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(ValOperandId resultId, Int32OperandId argcId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentDynamicSlot(resultId, argcId, slotIndex);\
}\
\
[[nodiscard]] bool emitMegamorphicSetElement(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitMegamorphicSetElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitMegamorphicSetElement(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(ObjOperandId objId, uint32_t expandoAndGenerationOffset, uint32_t generationOffset, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expandoAndGenerationOffset = reader.stubOffset();\
  uint32_t generationOffset = reader.stubOffset();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueGuardGeneration(objId, expandoAndGenerationOffset, generationOffset, resultId);\
}\
\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(ValOperandId expandoId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader) {\
  ValOperandId expandoId = reader.valOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardDOMExpandoMissingOrGuardShape(expandoId, shapeOffset);\
}\
\
[[nodiscard]] bool emitStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreDynamicSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitAddAndStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, bool preserveWrapper);\
[[nodiscard]] bool emitAddAndStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  bool preserveWrapper = reader.readBool();\
  return emitAddAndStoreFixedSlot(objId, offsetOffset, rhsId, newShapeOffset, preserveWrapper);\
}\
\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, bool preserveWrapper);\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  bool preserveWrapper = reader.readBool();\
  return emitAddAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset, preserveWrapper);\
}\
\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, uint32_t numNewSlotsOffset, bool preserveWrapper);\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  uint32_t numNewSlotsOffset = reader.stubOffset();\
  bool preserveWrapper = reader.readBool();\
  return emitAllocateAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset, numNewSlotsOffset, preserveWrapper);\
}\
\
[[nodiscard]] bool emitIsArrayResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsArrayResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsArrayResult(inputId);\
}\
\
[[nodiscard]] bool emitIsTypedArrayResult(ObjOperandId objId, bool isPossiblyWrapped);\
[[nodiscard]] bool emitIsTypedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool isPossiblyWrapped = reader.readBool();\
  return emitIsTypedArrayResult(objId, isPossiblyWrapped);\
}\
\
[[nodiscard]] bool emitStringFromCharCodeResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCharCodeResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCharCodeResult(codeId);\
}\
\
[[nodiscard]] bool emitStringFromCodePointResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCodePointResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCodePointResult(codeId);\
}\
\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(ObjOperandId objId);\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitReflectGetPrototypeOfResult(objId);\
}\
\
[[nodiscard]] bool emitCallNativeSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeSetter(receiverId, setterOffset, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallScriptedSetter(ObjOperandId receiverId, ObjOperandId calleeId, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedSetter(receiverId, calleeId, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedSetter(ObjOperandId receiverId, ObjOperandId calleeId, ValOperandId rhsId, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedSetter(receiverId, calleeId, rhsId, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMSetter(ObjOperandId objId, uint32_t jitInfoOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitCallDOMSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallDOMSetter(objId, jitInfoOffset, rhsId);\
}\
\
[[nodiscard]] bool emitCallSetArrayLength(ObjOperandId objId, bool strict, ValOperandId rhsId);\
[[nodiscard]] bool emitCallSetArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool strict = reader.readBool();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallSetArrayLength(objId, strict, rhsId);\
}\
\
[[nodiscard]] bool emitProxySet(ObjOperandId objId, uint32_t idOffset, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySet(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySet(objId, idOffset, rhsId, strict);\
}\
\
[[nodiscard]] bool emitProxySetByValue(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySetByValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySetByValue(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(ObjOperandId objId, Int32OperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId idId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitCallAddOrUpdateSparseElementHelper(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallScriptedFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed);\
[[nodiscard]] bool emitCallScriptedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  return emitCallScriptedFunction(calleeId, argcId, flags, argcFixed);\
}\
\
[[nodiscard]] bool emitCallBoundScriptedFunction(ObjOperandId calleeId, ObjOperandId targetId, Int32OperandId argcId, CallFlags flags, uint32_t numBoundArgs);\
[[nodiscard]] bool emitCallBoundScriptedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  ObjOperandId targetId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t numBoundArgs = reader.uint32Immediate();\
  return emitCallBoundScriptedFunction(calleeId, targetId, argcId, flags, numBoundArgs);\
}\
\
[[nodiscard]] bool emitCallWasmFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed, uint32_t funcTypeOffset, uint32_t instanceOffset);\
[[nodiscard]] bool emitCallWasmFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  uint32_t funcTypeOffset = reader.stubOffset();\
  uint32_t instanceOffset = reader.stubOffset();\
  return emitCallWasmFunction(calleeId, argcId, flags, argcFixed, funcTypeOffset, instanceOffset);\
}\
\
[[nodiscard]] bool emitCallNativeFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed, bool ignoresReturnValue);\
[[nodiscard]] bool emitCallNativeFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  bool ignoresReturnValue = reader.readBool();\
  return emitCallNativeFunction(calleeId, argcId, flags, argcFixed, ignoresReturnValue);\
}\
\
[[nodiscard]] bool emitCallDOMFunction(ObjOperandId calleeId, Int32OperandId argcId, ObjOperandId thisObjId, CallFlags flags, uint32_t argcFixed);\
[[nodiscard]] bool emitCallDOMFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  ObjOperandId thisObjId = reader.objOperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  return emitCallDOMFunction(calleeId, argcId, thisObjId, flags, argcFixed);\
}\
\
[[nodiscard]] bool emitCallDOMFunctionWithAllocSite(ObjOperandId calleeId, Int32OperandId argcId, ObjOperandId thisObjId, CallFlags flags, uint32_t argcFixed, uint32_t siteOffset);\
[[nodiscard]] bool emitCallDOMFunctionWithAllocSite(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  ObjOperandId thisObjId = reader.objOperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitCallDOMFunctionWithAllocSite(calleeId, argcId, thisObjId, flags, argcFixed, siteOffset);\
}\
\
[[nodiscard]] bool emitCallClassHook(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed, uint32_t targetOffset);\
[[nodiscard]] bool emitCallClassHook(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  uint32_t targetOffset = reader.stubOffset();\
  return emitCallClassHook(calleeId, argcId, flags, argcFixed, targetOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedFunction(ObjOperandId calleeId, Int32OperandId argcId, uint32_t icScriptOffset, CallFlags flags, uint32_t argcFixed);\
[[nodiscard]] bool emitCallInlinedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  return emitCallInlinedFunction(calleeId, argcId, icScriptOffset, flags, argcFixed);\
}\
\
[[nodiscard]] bool emitCallScriptedProxyGetResult(ValOperandId targetId, ObjOperandId receiverId, ObjOperandId handlerId, ObjOperandId trapId, uint32_t propertyOffset, uint32_t nargsAndFlags);\
[[nodiscard]] bool emitCallScriptedProxyGetResult(CacheIRReader& reader) {\
  ValOperandId targetId = reader.valOperandId();\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId handlerId = reader.objOperandId();\
  ObjOperandId trapId = reader.objOperandId();\
  uint32_t propertyOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = reader.uint32Immediate();\
  return emitCallScriptedProxyGetResult(targetId, receiverId, handlerId, trapId, propertyOffset, nargsAndFlags);\
}\
\
[[nodiscard]] bool emitCallScriptedProxyGetByValueResult(ValOperandId targetId, ObjOperandId receiverId, ObjOperandId handlerId, ValOperandId propertyId, ObjOperandId trapId, uint32_t nargsAndFlags);\
[[nodiscard]] bool emitCallScriptedProxyGetByValueResult(CacheIRReader& reader) {\
  ValOperandId targetId = reader.valOperandId();\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId handlerId = reader.objOperandId();\
  ValOperandId propertyId = reader.valOperandId();\
  ObjOperandId trapId = reader.objOperandId();\
  uint32_t nargsAndFlags = reader.uint32Immediate();\
  return emitCallScriptedProxyGetByValueResult(targetId, receiverId, handlerId, propertyId, trapId, nargsAndFlags);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadFixedSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadFixedSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(ObjOperandId objId, uint32_t offsetOffset, ValueType type);\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValueType type = reader.valueType();\
  return emitLoadFixedSlotTypedResult(objId, offsetOffset, type);\
}\
\
[[nodiscard]] bool emitLoadDynamicSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadDynamicSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadDynamicSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadStringCharResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringCharResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringCharResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitLoadStringAtResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringAtResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringAtResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitFrameIsConstructingResult();\
[[nodiscard]] bool emitFrameIsConstructingResult(CacheIRReader& reader) {\
  return emitFrameIsConstructingResult();\
}\
\
[[nodiscard]] bool emitCallScriptedGetterResult(ValOperandId receiverId, ObjOperandId calleeId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedGetterResult(receiverId, calleeId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedGetterResult(ValOperandId receiverId, ObjOperandId calleeId, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedGetterResult(receiverId, calleeId, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallNativeGetterResult(ValOperandId receiverId, uint32_t getterOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeGetterResult(receiverId, getterOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMGetterResult(ObjOperandId objId, uint32_t jitInfoOffset);\
[[nodiscard]] bool emitCallDOMGetterResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  return emitCallDOMGetterResult(objId, jitInfoOffset);\
}\
\
[[nodiscard]] bool emitProxyGetResult(ObjOperandId objId, uint32_t idOffset);\
[[nodiscard]] bool emitProxyGetResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  return emitProxyGetResult(objId, idOffset);\
}\
\
[[nodiscard]] bool emitLoadConstantStringResult(uint32_t strOffset);\
[[nodiscard]] bool emitLoadConstantStringResult(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  return emitLoadConstantStringResult(strOffset);\
}\
\
[[nodiscard]] bool emitLoadValueResult(uint32_t valOffset);\
[[nodiscard]] bool emitLoadValueResult(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  return emitLoadValueResult(valOffset);\
}\
\
[[nodiscard]] bool emitUncheckedLoadWeakValueResult(uint32_t valOffset);\
[[nodiscard]] bool emitUncheckedLoadWeakValueResult(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  return emitUncheckedLoadWeakValueResult(valOffset);\
}\
\
[[nodiscard]] bool emitUncheckedLoadWeakObjectResult(uint32_t objOffset);\
[[nodiscard]] bool emitUncheckedLoadWeakObjectResult(CacheIRReader& reader) {\
  uint32_t objOffset = reader.stubOffset();\
  return emitUncheckedLoadWeakObjectResult(objOffset);\
}\
\
[[nodiscard]] bool emitNewPlainObjectResult(uint32_t numFixedSlots, uint32_t numDynamicSlots, gc::AllocKind allocKind, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewPlainObjectResult(CacheIRReader& reader) {\
  uint32_t numFixedSlots = reader.uint32Immediate();\
  uint32_t numDynamicSlots = reader.uint32Immediate();\
  gc::AllocKind allocKind = reader.allocKind();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewPlainObjectResult(numFixedSlots, numDynamicSlots, allocKind, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitNewArrayObjectResult(uint32_t arrayLength, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewArrayObjectResult(CacheIRReader& reader) {\
  uint32_t arrayLength = reader.uint32Immediate();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewArrayObjectResult(arrayLength, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitNewFunctionCloneResult(uint32_t canonicalOffset, gc::AllocKind allocKind, uint32_t siteOffset);\
[[nodiscard]] bool emitNewFunctionCloneResult(CacheIRReader& reader) {\
  uint32_t canonicalOffset = reader.stubOffset();\
  gc::AllocKind allocKind = reader.allocKind();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewFunctionCloneResult(canonicalOffset, allocKind, siteOffset);\
}\
\
[[nodiscard]] bool emitCallStringObjectConcatResult(ValOperandId lhsId, ValOperandId rhsId);\
[[nodiscard]] bool emitCallStringObjectConcatResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallStringObjectConcatResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareStringResult(JSOp op, StringOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitSameValueResult(ValOperandId lhsId, ValOperandId rhsId);\
[[nodiscard]] bool emitSameValueResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitSameValueResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitSetHasStringResult(ObjOperandId setId, StringOperandId strId);\
[[nodiscard]] bool emitSetHasStringResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  StringOperandId strId = reader.stringOperandId();\
  return emitSetHasStringResult(setId, strId);\
}\
\
[[nodiscard]] bool emitMapHasStringResult(ObjOperandId mapId, StringOperandId strId);\
[[nodiscard]] bool emitMapHasStringResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  StringOperandId strId = reader.stringOperandId();\
  return emitMapHasStringResult(mapId, strId);\
}\
\
[[nodiscard]] bool emitMapGetStringResult(ObjOperandId mapId, StringOperandId strId);\
[[nodiscard]] bool emitMapGetStringResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  StringOperandId strId = reader.stringOperandId();\
  return emitMapGetStringResult(mapId, strId);\
}\
\
[[nodiscard]] bool emitCloseIterScriptedResult(ObjOperandId iterId, ObjOperandId calleeId, CompletionKind kind, uint32_t targetNargs);\
[[nodiscard]] bool emitCloseIterScriptedResult(CacheIRReader& reader) {\
  ObjOperandId iterId = reader.objOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  CompletionKind kind = reader.completionKind();\
  uint32_t targetNargs = reader.uint32Immediate();\
  return emitCloseIterScriptedResult(iterId, calleeId, kind, targetNargs);\
}\


#define CACHE_IR_TRANSPILER_GENERATED \
[[nodiscard]] bool emitReturnFromIC();\
[[nodiscard]] bool emitReturnFromIC(CacheIRReader& reader) {\
  return emitReturnFromIC();\
}\
\
[[nodiscard]] bool emitGuardToObject(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToObject(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToObject(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNullOrUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNullOrUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNullOrUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNull(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNull(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNull(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsUndefined(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsUndefined(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsUndefined(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNotUninitializedLexical(ValOperandId valId);\
[[nodiscard]] bool emitGuardIsNotUninitializedLexical(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  return emitGuardIsNotUninitializedLexical(valId);\
}\
\
[[nodiscard]] bool emitGuardToBoolean(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBoolean(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBoolean(inputId);\
}\
\
[[nodiscard]] bool emitGuardToString(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToString(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToString(inputId);\
}\
\
[[nodiscard]] bool emitGuardToSymbol(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToSymbol(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToSymbol(inputId);\
}\
\
[[nodiscard]] bool emitGuardToBigInt(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToBigInt(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToBigInt(inputId);\
}\
\
[[nodiscard]] bool emitGuardIsNumber(ValOperandId inputId);\
[[nodiscard]] bool emitGuardIsNumber(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardIsNumber(inputId);\
}\
\
[[nodiscard]] bool emitGuardToInt32(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToInt32(inputId);\
}\
\
[[nodiscard]] bool emitGuardToNonGCThing(ValOperandId inputId);\
[[nodiscard]] bool emitGuardToNonGCThing(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitGuardToNonGCThing(inputId);\
}\
\
[[nodiscard]] bool emitGuardBooleanToInt32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardBooleanToInt32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardBooleanToInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32Index(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32Index(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32Index(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32ToIntPtr(Int32OperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitInt32ToIntPtr(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitInt32ToIntPtr(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(NumberOperandId inputId, bool supportOOB, IntPtrOperandId resultId);\
[[nodiscard]] bool emitGuardNumberToIntPtrIndex(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  bool supportOOB = reader.readBool();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitGuardNumberToIntPtrIndex(inputId, supportOOB, resultId);\
}\
\
[[nodiscard]] bool emitGuardToInt32ModUint32(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToInt32ModUint32(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToInt32ModUint32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardToUint8Clamped(ValOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardToUint8Clamped(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardToUint8Clamped(inputId, resultId);\
}\
\
[[nodiscard]] bool emitGuardNonDoubleType(ValOperandId inputId, ValueType type);\
[[nodiscard]] bool emitGuardNonDoubleType(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  ValueType type = reader.valueType();\
  return emitGuardNonDoubleType(inputId, type);\
}\
\
[[nodiscard]] bool emitGuardShape(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardShape(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardShape(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitGuardMultipleShapes(ObjOperandId objId, uint32_t shapesOffset);\
[[nodiscard]] bool emitGuardMultipleShapes(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapesOffset = reader.stubOffset();\
  return emitGuardMultipleShapes(objId, shapesOffset);\
}\
\
[[nodiscard]] bool emitGuardProto(ObjOperandId objId, uint32_t protoOffset);\
[[nodiscard]] bool emitGuardProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t protoOffset = reader.stubOffset();\
  return emitGuardProto(objId, protoOffset);\
}\
\
[[nodiscard]] bool emitGuardNullProto(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNullProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNullProto(objId);\
}\
\
[[nodiscard]] bool emitGuardClass(ObjOperandId objId, GuardClassKind kind);\
[[nodiscard]] bool emitGuardClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  GuardClassKind kind = reader.guardClassKind();\
  return emitGuardClass(objId, kind);\
}\
\
[[nodiscard]] bool emitGuardFuse(RealmFuses::FuseIndex fuseWord);\
[[nodiscard]] bool emitGuardFuse(CacheIRReader& reader) {\
  RealmFuses::FuseIndex fuseWord = reader.realmFuseIndex();\
  return emitGuardFuse(fuseWord);\
}\
\
[[nodiscard]] bool emitGuardRuntimeFuse(RuntimeFuses::FuseIndex fuseWord);\
[[nodiscard]] bool emitGuardRuntimeFuse(CacheIRReader& reader) {\
  RuntimeFuses::FuseIndex fuseWord = reader.runtimeFuseIndex();\
  return emitGuardRuntimeFuse(fuseWord);\
}\
\
[[nodiscard]] bool emitGuardObjectFuseProperty(ObjOperandId objId, uint32_t objFuseOwnerOffset, uint32_t objFuseOffset, uint32_t expectedGenerationOffset, uint32_t propIndexOffset, uint32_t propMaskOffset, bool canUseFastPath);\
[[nodiscard]] bool emitGuardObjectFuseProperty(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t objFuseOwnerOffset = reader.stubOffset();\
  uint32_t objFuseOffset = reader.stubOffset();\
  uint32_t expectedGenerationOffset = reader.stubOffset();\
  uint32_t propIndexOffset = reader.stubOffset();\
  uint32_t propMaskOffset = reader.stubOffset();\
  bool canUseFastPath = reader.readBool();\
  return emitGuardObjectFuseProperty(objId, objFuseOwnerOffset, objFuseOffset, expectedGenerationOffset, propIndexOffset, propMaskOffset, canUseFastPath);\
}\
\
[[nodiscard]] bool emitGuardAnyClass(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitGuardAnyClass(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitGuardAnyClass(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitGuardGlobalGeneration(uint32_t expectedOffset, uint32_t generationAddrOffset);\
[[nodiscard]] bool emitGuardGlobalGeneration(CacheIRReader& reader) {\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t generationAddrOffset = reader.stubOffset();\
  return emitGuardGlobalGeneration(expectedOffset, generationAddrOffset);\
}\
\
[[nodiscard]] bool emitHasClassResult(ObjOperandId objId, uint32_t claspOffset);\
[[nodiscard]] bool emitHasClassResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t claspOffset = reader.stubOffset();\
  return emitHasClassResult(objId, claspOffset);\
}\
\
[[nodiscard]] bool emitHasShapeResult(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitHasShapeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitHasShapeResult(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitCallRegExpMatcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId, uint32_t stubOffset);\
[[nodiscard]] bool emitCallRegExpMatcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitCallRegExpMatcherResult(regexpId, inputId, lastIndexId, stubOffset);\
}\
\
[[nodiscard]] bool emitCallRegExpSearcherResult(ObjOperandId regexpId, StringOperandId inputId, Int32OperandId lastIndexId, uint32_t stubOffset);\
[[nodiscard]] bool emitCallRegExpSearcherResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitCallRegExpSearcherResult(regexpId, inputId, lastIndexId, stubOffset);\
}\
\
[[nodiscard]] bool emitRegExpSearcherLastLimitResult();\
[[nodiscard]] bool emitRegExpSearcherLastLimitResult(CacheIRReader& reader) {\
  return emitRegExpSearcherLastLimitResult();\
}\
\
[[nodiscard]] bool emitRegExpHasCaptureGroupsResult(ObjOperandId regexpId, StringOperandId inputId);\
[[nodiscard]] bool emitRegExpHasCaptureGroupsResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  return emitRegExpHasCaptureGroupsResult(regexpId, inputId);\
}\
\
[[nodiscard]] bool emitRegExpBuiltinExecMatchResult(ObjOperandId regexpId, StringOperandId inputId, uint32_t stubOffset);\
[[nodiscard]] bool emitRegExpBuiltinExecMatchResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitRegExpBuiltinExecMatchResult(regexpId, inputId, stubOffset);\
}\
\
[[nodiscard]] bool emitRegExpBuiltinExecTestResult(ObjOperandId regexpId, StringOperandId inputId, uint32_t stubOffset);\
[[nodiscard]] bool emitRegExpBuiltinExecTestResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  StringOperandId inputId = reader.stringOperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitRegExpBuiltinExecTestResult(regexpId, inputId, stubOffset);\
}\
\
[[nodiscard]] bool emitRegExpFlagResult(ObjOperandId regexpId, int32_t flagsMask);\
[[nodiscard]] bool emitRegExpFlagResult(CacheIRReader& reader) {\
  ObjOperandId regexpId = reader.objOperandId();\
  int32_t flagsMask = reader.int32Immediate();\
  return emitRegExpFlagResult(regexpId, flagsMask);\
}\
\
[[nodiscard]] bool emitCallSubstringKernelResult(StringOperandId strId, Int32OperandId beginId, Int32OperandId lengthId);\
[[nodiscard]] bool emitCallSubstringKernelResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitCallSubstringKernelResult(strId, beginId, lengthId);\
}\
\
[[nodiscard]] bool emitStringReplaceStringResult(StringOperandId strId, StringOperandId patternId, StringOperandId replacementId);\
[[nodiscard]] bool emitStringReplaceStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId patternId = reader.stringOperandId();\
  StringOperandId replacementId = reader.stringOperandId();\
  return emitStringReplaceStringResult(strId, patternId, replacementId);\
}\
\
[[nodiscard]] bool emitStringSplitStringResult(StringOperandId strId, StringOperandId separatorId);\
[[nodiscard]] bool emitStringSplitStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId separatorId = reader.stringOperandId();\
  return emitStringSplitStringResult(strId, separatorId);\
}\
\
[[nodiscard]] bool emitGetFirstDollarIndexResult(StringOperandId strId);\
[[nodiscard]] bool emitGetFirstDollarIndexResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitGetFirstDollarIndexResult(strId);\
}\
\
[[nodiscard]] bool emitGuardIsExtensible(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsExtensible(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsExtensible(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNativeObject(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNativeObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNativeObject(objId);\
}\
\
[[nodiscard]] bool emitGuardIsProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardToArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardToArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardToArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitGuardToSharedArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardToSharedArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardToSharedArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotArrayBufferMaybeShared(objId);\
}\
\
[[nodiscard]] bool emitGuardIsTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardIsNonResizableTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNonResizableTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNonResizableTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardIsResizableTypedArray(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsResizableTypedArray(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsResizableTypedArray(objId);\
}\
\
[[nodiscard]] bool emitGuardHasProxyHandler(ObjOperandId objId, uint32_t handlerOffset);\
[[nodiscard]] bool emitGuardHasProxyHandler(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t handlerOffset = reader.stubOffset();\
  return emitGuardHasProxyHandler(objId, handlerOffset);\
}\
\
[[nodiscard]] bool emitGuardIsNotDOMProxy(ObjOperandId objId);\
[[nodiscard]] bool emitGuardIsNotDOMProxy(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardIsNotDOMProxy(objId);\
}\
\
[[nodiscard]] bool emitGuardSpecificObject(ObjOperandId objId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificObject(objId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardObjectIdentity(ObjOperandId obj1Id, ObjOperandId obj2Id);\
[[nodiscard]] bool emitGuardObjectIdentity(CacheIRReader& reader) {\
  ObjOperandId obj1Id = reader.objOperandId();\
  ObjOperandId obj2Id = reader.objOperandId();\
  return emitGuardObjectIdentity(obj1Id, obj2Id);\
}\
\
[[nodiscard]] bool emitGuardSpecificFunction(ObjOperandId funId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardSpecificFunction(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardSpecificFunction(funId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionScript(ObjOperandId objId, uint32_t expectedOffset, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitGuardFunctionScript(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitGuardFunctionScript(objId, expectedOffset, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificAtom(StringOperandId strId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificAtom(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificAtom(strId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificSymbol(SymbolOperandId symId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificSymbol(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificSymbol(symId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardSpecificInt32(Int32OperandId numId, int32_t expected);\
[[nodiscard]] bool emitGuardSpecificInt32(CacheIRReader& reader) {\
  Int32OperandId numId = reader.int32OperandId();\
  int32_t expected = reader.int32Immediate();\
  return emitGuardSpecificInt32(numId, expected);\
}\
\
[[nodiscard]] bool emitGuardSpecificValue(ValOperandId valId, uint32_t expectedOffset);\
[[nodiscard]] bool emitGuardSpecificValue(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  uint32_t expectedOffset = reader.stubOffset();\
  return emitGuardSpecificValue(valId, expectedOffset);\
}\
\
[[nodiscard]] bool emitGuardNoDenseElements(ObjOperandId objId);\
[[nodiscard]] bool emitGuardNoDenseElements(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardNoDenseElements(objId);\
}\
\
[[nodiscard]] bool emitGuardStringToIndex(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToIndex(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToIndex(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToInt32(StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitGuardStringToInt32(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitGuardStringToInt32(strId, resultId);\
}\
\
[[nodiscard]] bool emitGuardStringToNumber(StringOperandId strId, NumberOperandId resultId);\
[[nodiscard]] bool emitGuardStringToNumber(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitGuardStringToNumber(strId, resultId);\
}\
\
[[nodiscard]] bool emitStringToAtom(StringOperandId strId);\
[[nodiscard]] bool emitStringToAtom(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToAtom(strId);\
}\
\
[[nodiscard]] bool emitBooleanToNumber(BooleanOperandId booleanId, NumberOperandId resultId);\
[[nodiscard]] bool emitBooleanToNumber(CacheIRReader& reader) {\
  BooleanOperandId booleanId = reader.booleanOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitBooleanToNumber(booleanId, resultId);\
}\
\
[[nodiscard]] bool emitLoadGetterSetterFunction(ValOperandId getterSetterId, bool isGetter, bool needsClassGuard, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadGetterSetterFunction(CacheIRReader& reader) {\
  ValOperandId getterSetterId = reader.valOperandId();\
  bool isGetter = reader.readBool();\
  bool needsClassGuard = reader.readBool();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadGetterSetterFunction(getterSetterId, isGetter, needsClassGuard, resultId);\
}\
\
[[nodiscard]] bool emitGuardHasGetterSetter(ObjOperandId objId, uint32_t idOffset, uint32_t getterSetterOffset);\
[[nodiscard]] bool emitGuardHasGetterSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  uint32_t getterSetterOffset = reader.stubOffset();\
  return emitGuardHasGetterSetter(objId, idOffset, getterSetterOffset);\
}\
\
[[nodiscard]] bool emitGuardInt32IsNonNegative(Int32OperandId indexId);\
[[nodiscard]] bool emitGuardInt32IsNonNegative(CacheIRReader& reader) {\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardInt32IsNonNegative(indexId);\
}\
\
[[nodiscard]] bool emitGuardIntPtrIsNonNegative(IntPtrOperandId indexId);\
[[nodiscard]] bool emitGuardIntPtrIsNonNegative(CacheIRReader& reader) {\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  return emitGuardIntPtrIsNonNegative(indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexIsValidUpdateOrAdd(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardIndexIsNotDenseElement(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitGuardIndexIsNotDenseElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitGuardIndexIsNotDenseElement(objId, indexId);\
}\
\
[[nodiscard]] bool emitGuardTagNotEqual(ValueTagOperandId lhsId, ValueTagOperandId rhsId);\
[[nodiscard]] bool emitGuardTagNotEqual(CacheIRReader& reader) {\
  ValueTagOperandId lhsId = reader.valueTagOperandId();\
  ValueTagOperandId rhsId = reader.valueTagOperandId();\
  return emitGuardTagNotEqual(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(ObjOperandId objId, ObjOperandId expectedId, uint32_t slotOffset);\
[[nodiscard]] bool emitGuardDynamicSlotIsSpecificObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId expectedId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitGuardDynamicSlotIsSpecificObject(objId, expectedId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotIsNotObject(ObjOperandId objId, uint32_t slotOffset);\
[[nodiscard]] bool emitGuardDynamicSlotIsNotObject(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitGuardDynamicSlotIsNotObject(objId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardFixedSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardFixedSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardFixedSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitGuardDynamicSlotValue(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitGuardDynamicSlotValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitGuardDynamicSlotValue(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitCheckWeakValueResultForFixedSlot(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitCheckWeakValueResultForFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitCheckWeakValueResultForFixedSlot(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitCheckWeakValueResultForDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, uint32_t valOffset);\
[[nodiscard]] bool emitCheckWeakValueResultForDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t valOffset = reader.stubOffset();\
  return emitCheckWeakValueResultForDynamicSlot(objId, offsetOffset, valOffset);\
}\
\
[[nodiscard]] bool emitLoadScriptedProxyHandler(ObjOperandId resultId, ObjOperandId objId);\
[[nodiscard]] bool emitLoadScriptedProxyHandler(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadScriptedProxyHandler(resultId, objId);\
}\
\
[[nodiscard]] bool emitIdToStringOrSymbol(ValOperandId resultId, ValOperandId idId);\
[[nodiscard]] bool emitIdToStringOrSymbol(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitIdToStringOrSymbol(resultId, idId);\
}\
\
[[nodiscard]] bool emitLoadFixedSlot(ValOperandId resultId, ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadFixedSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadFixedSlot(resultId, objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadDynamicSlot(ValOperandId resultId, ObjOperandId objId, uint32_t slotOffset);\
[[nodiscard]] bool emitLoadDynamicSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitLoadDynamicSlot(resultId, objId, slotOffset);\
}\
\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(uint32_t builderAddrOffset);\
[[nodiscard]] bool emitGuardNoAllocationMetadataBuilder(CacheIRReader& reader) {\
  uint32_t builderAddrOffset = reader.stubOffset();\
  return emitGuardNoAllocationMetadataBuilder(builderAddrOffset);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionHasJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionHasJitEntry(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionHasNoJitEntry(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionHasNoJitEntry(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsNonBuiltinCtor(funId);\
}\
\
[[nodiscard]] bool emitGuardFunctionIsConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardFunctionIsConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardFunctionIsConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardNotClassConstructor(ObjOperandId funId);\
[[nodiscard]] bool emitGuardNotClassConstructor(CacheIRReader& reader) {\
  ObjOperandId funId = reader.objOperandId();\
  return emitGuardNotClassConstructor(funId);\
}\
\
[[nodiscard]] bool emitGuardArrayIsPacked(ObjOperandId arrayId);\
[[nodiscard]] bool emitGuardArrayIsPacked(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitGuardArrayIsPacked(arrayId);\
}\
\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(ObjOperandId objId, uint8_t flags);\
[[nodiscard]] bool emitGuardArgumentsObjectFlags(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint8_t flags = reader.readByte();\
  return emitGuardArgumentsObjectFlags(objId, flags);\
}\
\
[[nodiscard]] bool emitGuardObjectHasSameRealm(ObjOperandId objId);\
[[nodiscard]] bool emitGuardObjectHasSameRealm(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardObjectHasSameRealm(objId);\
}\
\
[[nodiscard]] bool emitLoadObject(ObjOperandId resultId, uint32_t objOffset);\
[[nodiscard]] bool emitLoadObject(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  uint32_t objOffset = reader.stubOffset();\
  return emitLoadObject(resultId, objOffset);\
}\
\
[[nodiscard]] bool emitLoadProtoObject(ObjOperandId resultId, uint32_t protoObjOffset, ObjOperandId receiverObjId);\
[[nodiscard]] bool emitLoadProtoObject(CacheIRReader& reader) {\
  ObjOperandId resultId = reader.objOperandId();\
  uint32_t protoObjOffset = reader.stubOffset();\
  ObjOperandId receiverObjId = reader.objOperandId();\
  return emitLoadProtoObject(resultId, protoObjOffset, receiverObjId);\
}\
\
[[nodiscard]] bool emitLoadProto(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadProto(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadProto(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadEnclosingEnvironment(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadEnclosingEnvironment(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadEnclosingEnvironment(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadWrapperTarget(ObjOperandId objId, ObjOperandId resultId, bool fallible);\
[[nodiscard]] bool emitLoadWrapperTarget(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  bool fallible = reader.readBool();\
  return emitLoadWrapperTarget(objId, resultId, fallible);\
}\
\
[[nodiscard]] bool emitLoadValueTag(ValOperandId valId, ValueTagOperandId resultId);\
[[nodiscard]] bool emitLoadValueTag(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  ValueTagOperandId resultId = reader.valueTagOperandId();\
  return emitLoadValueTag(valId, resultId);\
}\
\
[[nodiscard]] bool emitLoadArgumentFixedSlot(ValOperandId resultId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentFixedSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentFixedSlot(resultId, slotIndex);\
}\
\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(ValOperandId resultId, Int32OperandId argcId, uint8_t slotIndex);\
[[nodiscard]] bool emitLoadArgumentDynamicSlot(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint8_t slotIndex = reader.readByte();\
  return emitLoadArgumentDynamicSlot(resultId, argcId, slotIndex);\
}\
\
[[nodiscard]] bool emitTruncateDoubleToUInt32(NumberOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitTruncateDoubleToUInt32(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitTruncateDoubleToUInt32(inputId, resultId);\
}\
\
[[nodiscard]] bool emitDoubleToUint8Clamped(NumberOperandId inputId, Int32OperandId resultId);\
[[nodiscard]] bool emitDoubleToUint8Clamped(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitDoubleToUint8Clamped(inputId, resultId);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(ObjOperandId objId, uint32_t nameOffset);\
[[nodiscard]] bool emitMegamorphicLoadSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  return emitMegamorphicLoadSlotResult(objId, nameOffset);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitMegamorphicLoadSlotByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitMegamorphicLoadSlotByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotPermissiveResult(ObjOperandId objId, uint32_t nameOffset);\
[[nodiscard]] bool emitMegamorphicLoadSlotPermissiveResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  return emitMegamorphicLoadSlotPermissiveResult(objId, nameOffset);\
}\
\
[[nodiscard]] bool emitMegamorphicLoadSlotByValuePermissiveResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitMegamorphicLoadSlotByValuePermissiveResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitMegamorphicLoadSlotByValuePermissiveResult(objId, idId);\
}\
\
[[nodiscard]] bool emitMegamorphicStoreSlot(ObjOperandId objId, uint32_t nameOffset, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitMegamorphicStoreSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t nameOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitMegamorphicStoreSlot(objId, nameOffset, rhsId, strict);\
}\
\
[[nodiscard]] bool emitMegamorphicSetElement(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitMegamorphicSetElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitMegamorphicSetElement(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitMegamorphicHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitMegamorphicHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitMegamorphicHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitSmallObjectVariableKeyHasOwnResult(StringOperandId idId, uint32_t propNamesOffset, uint32_t shapeOffset);\
[[nodiscard]] bool emitSmallObjectVariableKeyHasOwnResult(CacheIRReader& reader) {\
  StringOperandId idId = reader.stringOperandId();\
  uint32_t propNamesOffset = reader.stubOffset();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitSmallObjectVariableKeyHasOwnResult(idId, propNamesOffset, shapeOffset);\
}\
\
[[nodiscard]] bool emitObjectToIteratorResult(ObjOperandId objId, uint32_t enumeratorsAddrOffset);\
[[nodiscard]] bool emitObjectToIteratorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t enumeratorsAddrOffset = reader.stubOffset();\
  return emitObjectToIteratorResult(objId, enumeratorsAddrOffset);\
}\
\
[[nodiscard]] bool emitValueToIteratorResult(ValOperandId valId);\
[[nodiscard]] bool emitValueToIteratorResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  return emitValueToIteratorResult(valId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValue(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValue(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(ObjOperandId objId, uint32_t expandoAndGenerationOffset, uint32_t generationOffset, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t expandoAndGenerationOffset = reader.stubOffset();\
  uint32_t generationOffset = reader.stubOffset();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueGuardGeneration(objId, expandoAndGenerationOffset, generationOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(ObjOperandId objId, ValOperandId resultId);\
[[nodiscard]] bool emitLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadDOMExpandoValueIgnoreGeneration(objId, resultId);\
}\
\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(ValOperandId expandoId, uint32_t shapeOffset);\
[[nodiscard]] bool emitGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader) {\
  ValOperandId expandoId = reader.valOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitGuardDOMExpandoMissingOrGuardShape(expandoId, shapeOffset);\
}\
\
[[nodiscard]] bool emitStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreDynamicSlot(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitAddAndStoreFixedSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, bool preserveWrapper);\
[[nodiscard]] bool emitAddAndStoreFixedSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  bool preserveWrapper = reader.readBool();\
  return emitAddAndStoreFixedSlot(objId, offsetOffset, rhsId, newShapeOffset, preserveWrapper);\
}\
\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, bool preserveWrapper);\
[[nodiscard]] bool emitAddAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  bool preserveWrapper = reader.readBool();\
  return emitAddAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset, preserveWrapper);\
}\
\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId, uint32_t newShapeOffset, uint32_t numNewSlotsOffset, bool preserveWrapper);\
[[nodiscard]] bool emitAllocateAndStoreDynamicSlot(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  uint32_t numNewSlotsOffset = reader.stubOffset();\
  bool preserveWrapper = reader.readBool();\
  return emitAllocateAndStoreDynamicSlot(objId, offsetOffset, rhsId, newShapeOffset, numNewSlotsOffset, preserveWrapper);\
}\
\
[[nodiscard]] bool emitAddSlotAndCallAddPropHook(ObjOperandId objId, ValOperandId rhsId, uint32_t newShapeOffset);\
[[nodiscard]] bool emitAddSlotAndCallAddPropHook(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t newShapeOffset = reader.stubOffset();\
  return emitAddSlotAndCallAddPropHook(objId, rhsId, newShapeOffset);\
}\
\
[[nodiscard]] bool emitStoreDenseElement(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId, bool expectPackedElements);\
[[nodiscard]] bool emitStoreDenseElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool expectPackedElements = reader.readBool();\
  return emitStoreDenseElement(objId, indexId, rhsId, expectPackedElements);\
}\
\
[[nodiscard]] bool emitStoreDenseElementHole(ObjOperandId objId, Int32OperandId indexId, ValOperandId rhsId, bool handleAdd);\
[[nodiscard]] bool emitStoreDenseElementHole(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool handleAdd = reader.readBool();\
  return emitStoreDenseElementHole(objId, indexId, rhsId, handleAdd);\
}\
\
[[nodiscard]] bool emitArrayPush(ObjOperandId objId, ValOperandId rhsId);\
[[nodiscard]] bool emitArrayPush(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitArrayPush(objId, rhsId);\
}\
\
[[nodiscard]] bool emitArrayJoinResult(ObjOperandId objId, StringOperandId sepId);\
[[nodiscard]] bool emitArrayJoinResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  StringOperandId sepId = reader.stringOperandId();\
  return emitArrayJoinResult(objId, sepId);\
}\
\
[[nodiscard]] bool emitObjectKeysResult(ObjOperandId objId, uint32_t resultShapeOffset);\
[[nodiscard]] bool emitObjectKeysResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t resultShapeOffset = reader.stubOffset();\
  return emitObjectKeysResult(objId, resultShapeOffset);\
}\
\
[[nodiscard]] bool emitPackedArrayPopResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayPopResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayPopResult(arrayId);\
}\
\
[[nodiscard]] bool emitPackedArrayShiftResult(ObjOperandId arrayId);\
[[nodiscard]] bool emitPackedArrayShiftResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitPackedArrayShiftResult(arrayId);\
}\
\
[[nodiscard]] bool emitPackedArraySliceResult(uint32_t templateObjectOffset, ObjOperandId arrayId, Int32OperandId beginId, Int32OperandId endId);\
[[nodiscard]] bool emitPackedArraySliceResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId endId = reader.int32OperandId();\
  return emitPackedArraySliceResult(templateObjectOffset, arrayId, beginId, endId);\
}\
\
[[nodiscard]] bool emitArgumentsSliceResult(uint32_t templateObjectOffset, ObjOperandId argsId, Int32OperandId beginId, Int32OperandId endId);\
[[nodiscard]] bool emitArgumentsSliceResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId argsId = reader.objOperandId();\
  Int32OperandId beginId = reader.int32OperandId();\
  Int32OperandId endId = reader.int32OperandId();\
  return emitArgumentsSliceResult(templateObjectOffset, argsId, beginId, endId);\
}\
\
[[nodiscard]] bool emitIsArrayResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsArrayResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsArrayResult(inputId);\
}\
\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(ObjOperandId objId, uint32_t offsetOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitStoreFixedSlotUndefinedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitStoreFixedSlotUndefinedResult(objId, offsetOffset, rhsId);\
}\
\
[[nodiscard]] bool emitIsObjectResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsObjectResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsObjectResult(inputId);\
}\
\
[[nodiscard]] bool emitIsPackedArrayResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsPackedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsPackedArrayResult(objId);\
}\
\
[[nodiscard]] bool emitIsCallableResult(ValOperandId inputId);\
[[nodiscard]] bool emitIsCallableResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitIsCallableResult(inputId);\
}\
\
[[nodiscard]] bool emitIsConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsCrossRealmArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsCrossRealmArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitIsTypedArrayResult(ObjOperandId objId, bool isPossiblyWrapped);\
[[nodiscard]] bool emitIsTypedArrayResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool isPossiblyWrapped = reader.readBool();\
  return emitIsTypedArrayResult(objId, isPossiblyWrapped);\
}\
\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(ObjOperandId objId);\
[[nodiscard]] bool emitIsTypedArrayConstructorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitIsTypedArrayConstructorResult(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetInt32Result(objId);\
}\
\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitArrayBufferViewByteOffsetDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitTypedArrayByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitResizableTypedArrayLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitResizableTypedArrayLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableTypedArrayLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitResizableDataViewByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitResizableDataViewByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableDataViewByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitResizableDataViewByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitResizableDataViewByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitResizableDataViewByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGrowableSharedArrayBufferByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitGrowableSharedArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGrowableSharedArrayBufferByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(ObjOperandId objId);\
[[nodiscard]] bool emitGuardHasAttachedArrayBuffer(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardHasAttachedArrayBuffer(objId);\
}\
\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBounds(ObjOperandId objId);\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBounds(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardResizableArrayBufferViewInBounds(objId);\
}\
\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBoundsOrDetached(ObjOperandId objId);\
[[nodiscard]] bool emitGuardResizableArrayBufferViewInBoundsOrDetached(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardResizableArrayBufferViewInBoundsOrDetached(objId);\
}\
\
[[nodiscard]] bool emitTypedArrayFillResult(ObjOperandId objId, uint32_t fillValueId, IntPtrOperandId startId, IntPtrOperandId endId, Scalar::Type elementType);\
[[nodiscard]] bool emitTypedArrayFillResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t fillValueId = reader.rawOperandId();\
  IntPtrOperandId startId = reader.intPtrOperandId();\
  IntPtrOperandId endId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  return emitTypedArrayFillResult(objId, fillValueId, startId, endId, elementType);\
}\
\
[[nodiscard]] bool emitTypedArraySetResult(ObjOperandId targetId, ObjOperandId sourceId, IntPtrOperandId offsetId, bool canUseBitwiseCopy);\
[[nodiscard]] bool emitTypedArraySetResult(CacheIRReader& reader) {\
  ObjOperandId targetId = reader.objOperandId();\
  ObjOperandId sourceId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  bool canUseBitwiseCopy = reader.readBool();\
  return emitTypedArraySetResult(targetId, sourceId, offsetId, canUseBitwiseCopy);\
}\
\
[[nodiscard]] bool emitTypedArraySubarrayResult(uint32_t templateObjectOffset, ObjOperandId objId, IntPtrOperandId startId, IntPtrOperandId endId);\
[[nodiscard]] bool emitTypedArraySubarrayResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId startId = reader.intPtrOperandId();\
  IntPtrOperandId endId = reader.intPtrOperandId();\
  return emitTypedArraySubarrayResult(templateObjectOffset, objId, startId, endId);\
}\
\
[[nodiscard]] bool emitNewArrayIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewArrayIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewArrayIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewRegExpStringIteratorResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewRegExpStringIteratorResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitObjectCreateResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitObjectCreateResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitObjectCreateResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId, uint32_t siteOffset);\
[[nodiscard]] bool emitNewArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewArrayFromLengthResult(templateObjectOffset, lengthId, siteOffset);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(uint32_t templateObjectOffset, Int32OperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromLengthResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  Int32OperandId lengthId = reader.int32OperandId();\
  return emitNewTypedArrayFromLengthResult(templateObjectOffset, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(uint32_t templateObjectOffset, ObjOperandId bufferId, ValOperandId byteOffsetId, ValOperandId lengthId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayBufferResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId bufferId = reader.objOperandId();\
  ValOperandId byteOffsetId = reader.valOperandId();\
  ValOperandId lengthId = reader.valOperandId();\
  return emitNewTypedArrayFromArrayBufferResult(templateObjectOffset, bufferId, byteOffsetId, lengthId);\
}\
\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(uint32_t templateObjectOffset, ObjOperandId arrayId);\
[[nodiscard]] bool emitNewTypedArrayFromArrayResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ObjOperandId arrayId = reader.objOperandId();\
  return emitNewTypedArrayFromArrayResult(templateObjectOffset, arrayId);\
}\
\
[[nodiscard]] bool emitNewMapObjectResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewMapObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewMapObjectResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewSetObjectResult(uint32_t templateObjectOffset);\
[[nodiscard]] bool emitNewSetObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitNewSetObjectResult(templateObjectOffset);\
}\
\
[[nodiscard]] bool emitNewMapObjectFromIterableResult(uint32_t templateObjectOffset, ValOperandId iterableId);\
[[nodiscard]] bool emitNewMapObjectFromIterableResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ValOperandId iterableId = reader.valOperandId();\
  return emitNewMapObjectFromIterableResult(templateObjectOffset, iterableId);\
}\
\
[[nodiscard]] bool emitNewSetObjectFromIterableResult(uint32_t templateObjectOffset, ValOperandId iterableId);\
[[nodiscard]] bool emitNewSetObjectFromIterableResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  ValOperandId iterableId = reader.valOperandId();\
  return emitNewSetObjectFromIterableResult(templateObjectOffset, iterableId);\
}\
\
[[nodiscard]] bool emitNewStringObjectResult(uint32_t templateObjectOffset, StringOperandId strId);\
[[nodiscard]] bool emitNewStringObjectResult(CacheIRReader& reader) {\
  uint32_t templateObjectOffset = reader.stubOffset();\
  StringOperandId strId = reader.stringOperandId();\
  return emitNewStringObjectResult(templateObjectOffset, strId);\
}\
\
[[nodiscard]] bool emitStringFromCharCodeResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCharCodeResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCharCodeResult(codeId);\
}\
\
[[nodiscard]] bool emitStringFromCodePointResult(Int32OperandId codeId);\
[[nodiscard]] bool emitStringFromCodePointResult(CacheIRReader& reader) {\
  Int32OperandId codeId = reader.int32OperandId();\
  return emitStringFromCodePointResult(codeId);\
}\
\
[[nodiscard]] bool emitStringIncludesResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringIncludesResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringIncludesResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringIndexOfResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringIndexOfResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringIndexOfResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringLastIndexOfResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringLastIndexOfResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringLastIndexOfResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringStartsWithResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringStartsWithResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringStartsWithResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringEndsWithResult(StringOperandId strId, StringOperandId searchStrId);\
[[nodiscard]] bool emitStringEndsWithResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  StringOperandId searchStrId = reader.stringOperandId();\
  return emitStringEndsWithResult(strId, searchStrId);\
}\
\
[[nodiscard]] bool emitStringToLowerCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToLowerCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToLowerCaseResult(strId);\
}\
\
[[nodiscard]] bool emitStringToUpperCaseResult(StringOperandId strId);\
[[nodiscard]] bool emitStringToUpperCaseResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringToUpperCaseResult(strId);\
}\
\
[[nodiscard]] bool emitStringTrimResult(StringOperandId strId);\
[[nodiscard]] bool emitStringTrimResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringTrimResult(strId);\
}\
\
[[nodiscard]] bool emitStringTrimStartResult(StringOperandId strId);\
[[nodiscard]] bool emitStringTrimStartResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringTrimStartResult(strId);\
}\
\
[[nodiscard]] bool emitStringTrimEndResult(StringOperandId strId);\
[[nodiscard]] bool emitStringTrimEndResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitStringTrimEndResult(strId);\
}\
\
[[nodiscard]] bool emitMathAbsInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathAbsInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathAbsInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathAbsNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathAbsNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathAbsNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathClz32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathClz32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathClz32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignInt32Result(Int32OperandId inputId);\
[[nodiscard]] bool emitMathSignInt32Result(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitMathSignInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathSignNumberToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSignNumberToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSignNumberToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathImulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitMathImulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitMathImulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathSqrtNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathSqrtNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathSqrtNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFRoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFRoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFRoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathF16RoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathF16RoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathF16RoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathRandomResult(uint32_t rngOffset);\
[[nodiscard]] bool emitMathRandomResult(CacheIRReader& reader) {\
  uint32_t rngOffset = reader.stubOffset();\
  return emitMathRandomResult(rngOffset);\
}\
\
[[nodiscard]] bool emitMathHypot2NumberResult(NumberOperandId firstId, NumberOperandId secondId);\
[[nodiscard]] bool emitMathHypot2NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  return emitMathHypot2NumberResult(firstId, secondId);\
}\
\
[[nodiscard]] bool emitMathHypot3NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId);\
[[nodiscard]] bool emitMathHypot3NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  return emitMathHypot3NumberResult(firstId, secondId, thirdId);\
}\
\
[[nodiscard]] bool emitMathHypot4NumberResult(NumberOperandId firstId, NumberOperandId secondId, NumberOperandId thirdId, NumberOperandId fourthId);\
[[nodiscard]] bool emitMathHypot4NumberResult(CacheIRReader& reader) {\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId thirdId = reader.numberOperandId();\
  NumberOperandId fourthId = reader.numberOperandId();\
  return emitMathHypot4NumberResult(firstId, secondId, thirdId, fourthId);\
}\
\
[[nodiscard]] bool emitMathAtan2NumberResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitMathAtan2NumberResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitMathAtan2NumberResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitMathFloorNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathRoundNumberResult(NumberOperandId inputId);\
[[nodiscard]] bool emitMathRoundNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathRoundNumberResult(inputId);\
}\
\
[[nodiscard]] bool emitMathFloorToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathFloorToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathFloorToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathCeilToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathCeilToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathCeilToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathTruncToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathTruncToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathTruncToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitMathRoundToInt32Result(NumberOperandId inputId);\
[[nodiscard]] bool emitMathRoundToInt32Result(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitMathRoundToInt32Result(inputId);\
}\
\
[[nodiscard]] bool emitInt32MinMax(bool isMax, Int32OperandId firstId, Int32OperandId secondId, Int32OperandId resultId);\
[[nodiscard]] bool emitInt32MinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  Int32OperandId firstId = reader.int32OperandId();\
  Int32OperandId secondId = reader.int32OperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitInt32MinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitNumberMinMax(bool isMax, NumberOperandId firstId, NumberOperandId secondId, NumberOperandId resultId);\
[[nodiscard]] bool emitNumberMinMax(CacheIRReader& reader) {\
  bool isMax = reader.readBool();\
  NumberOperandId firstId = reader.numberOperandId();\
  NumberOperandId secondId = reader.numberOperandId();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitNumberMinMax(isMax, firstId, secondId, resultId);\
}\
\
[[nodiscard]] bool emitInt32MinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitInt32MinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitInt32MinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitNumberMinMaxArrayResult(ObjOperandId arrayId, bool isMax);\
[[nodiscard]] bool emitNumberMinMaxArrayResult(CacheIRReader& reader) {\
  ObjOperandId arrayId = reader.objOperandId();\
  bool isMax = reader.readBool();\
  return emitNumberMinMaxArrayResult(arrayId, isMax);\
}\
\
[[nodiscard]] bool emitMathFunctionNumberResult(NumberOperandId inputId, UnaryMathFunction fun);\
[[nodiscard]] bool emitMathFunctionNumberResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  UnaryMathFunction fun = reader.unaryMathFunction();\
  return emitMathFunctionNumberResult(inputId, fun);\
}\
\
[[nodiscard]] bool emitNumberParseIntResult(StringOperandId strId, Int32OperandId radixId);\
[[nodiscard]] bool emitNumberParseIntResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId radixId = reader.int32OperandId();\
  return emitNumberParseIntResult(strId, radixId);\
}\
\
[[nodiscard]] bool emitDoubleParseIntResult(NumberOperandId numId);\
[[nodiscard]] bool emitDoubleParseIntResult(CacheIRReader& reader) {\
  NumberOperandId numId = reader.numberOperandId();\
  return emitDoubleParseIntResult(numId);\
}\
\
[[nodiscard]] bool emitObjectToStringResult(ObjOperandId objId);\
[[nodiscard]] bool emitObjectToStringResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitObjectToStringResult(objId);\
}\
\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(ObjOperandId objId);\
[[nodiscard]] bool emitReflectGetPrototypeOfResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitReflectGetPrototypeOfResult(objId);\
}\
\
[[nodiscard]] bool emitStoreTypedArrayElement(ObjOperandId objId, Scalar::Type elementType, IntPtrOperandId indexId, uint32_t rhsId, bool handleOOB, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitStoreTypedArrayElement(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t rhsId = reader.rawOperandId();\
  bool handleOOB = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitStoreTypedArrayElement(objId, elementType, indexId, rhsId, handleOOB, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t expectedId, uint32_t replacementId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsCompareExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t expectedId = reader.rawOperandId();\
  uint32_t replacementId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsCompareExchangeResult(objId, indexId, expectedId, replacementId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsExchangeResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsExchangeResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsExchangeResult(objId, indexId, valueId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsAddResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsAddResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsAddResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsSubResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsSubResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsSubResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsAndResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsAndResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsAndResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsOrResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsOrResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsOrResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsXorResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, bool forEffect, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsXorResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forEffect = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsXorResult(objId, indexId, valueId, elementType, forEffect, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsLoadResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsLoadResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsLoadResult(objId, indexId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsStoreResult(ObjOperandId objId, IntPtrOperandId indexId, uint32_t valueId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitAtomicsStoreResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitAtomicsStoreResult(objId, indexId, valueId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(Int32OperandId valueId);\
[[nodiscard]] bool emitAtomicsIsLockFreeResult(CacheIRReader& reader) {\
  Int32OperandId valueId = reader.int32OperandId();\
  return emitAtomicsIsLockFreeResult(valueId);\
}\
\
[[nodiscard]] bool emitAtomicsPauseResult();\
[[nodiscard]] bool emitAtomicsPauseResult(CacheIRReader& reader) {\
  return emitAtomicsPauseResult();\
}\
\
[[nodiscard]] bool emitCallNativeSetter(ObjOperandId receiverId, uint32_t setterOffset, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  uint32_t setterOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeSetter(receiverId, setterOffset, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallScriptedSetter(ObjOperandId receiverId, ObjOperandId calleeId, ValOperandId rhsId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedSetter(receiverId, calleeId, rhsId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedSetter(ObjOperandId receiverId, ObjOperandId calleeId, ValOperandId rhsId, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedSetter(CacheIRReader& reader) {\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedSetter(receiverId, calleeId, rhsId, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMSetter(ObjOperandId objId, uint32_t jitInfoOffset, ValOperandId rhsId);\
[[nodiscard]] bool emitCallDOMSetter(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallDOMSetter(objId, jitInfoOffset, rhsId);\
}\
\
[[nodiscard]] bool emitCallSetArrayLength(ObjOperandId objId, bool strict, ValOperandId rhsId);\
[[nodiscard]] bool emitCallSetArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  bool strict = reader.readBool();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitCallSetArrayLength(objId, strict, rhsId);\
}\
\
[[nodiscard]] bool emitProxySet(ObjOperandId objId, uint32_t idOffset, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySet(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySet(objId, idOffset, rhsId, strict);\
}\
\
[[nodiscard]] bool emitProxySetByValue(ObjOperandId objId, ValOperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitProxySetByValue(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitProxySetByValue(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(ObjOperandId objId, Int32OperandId idId, ValOperandId rhsId, bool strict);\
[[nodiscard]] bool emitCallAddOrUpdateSparseElementHelper(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId idId = reader.int32OperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  bool strict = reader.readBool();\
  return emitCallAddOrUpdateSparseElementHelper(objId, idId, rhsId, strict);\
}\
\
[[nodiscard]] bool emitCallInt32ToString(Int32OperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallInt32ToString(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallInt32ToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitCallNumberToString(NumberOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitCallNumberToString(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitCallNumberToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32ToStringWithBaseResult(Int32OperandId inputId, Int32OperandId baseId);\
[[nodiscard]] bool emitInt32ToStringWithBaseResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  Int32OperandId baseId = reader.int32OperandId();\
  return emitInt32ToStringWithBaseResult(inputId, baseId);\
}\
\
[[nodiscard]] bool emitBooleanToString(BooleanOperandId inputId, StringOperandId resultId);\
[[nodiscard]] bool emitBooleanToString(CacheIRReader& reader) {\
  BooleanOperandId inputId = reader.booleanOperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitBooleanToString(inputId, resultId);\
}\
\
[[nodiscard]] bool emitCallScriptedFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed);\
[[nodiscard]] bool emitCallScriptedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  return emitCallScriptedFunction(calleeId, argcId, flags, argcFixed);\
}\
\
[[nodiscard]] bool emitCallBoundScriptedFunction(ObjOperandId calleeId, ObjOperandId targetId, Int32OperandId argcId, CallFlags flags, uint32_t numBoundArgs);\
[[nodiscard]] bool emitCallBoundScriptedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  ObjOperandId targetId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t numBoundArgs = reader.uint32Immediate();\
  return emitCallBoundScriptedFunction(calleeId, targetId, argcId, flags, numBoundArgs);\
}\
\
[[nodiscard]] bool emitCallWasmFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed, uint32_t funcTypeOffset, uint32_t instanceOffset);\
[[nodiscard]] bool emitCallWasmFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  uint32_t funcTypeOffset = reader.stubOffset();\
  uint32_t instanceOffset = reader.stubOffset();\
  return emitCallWasmFunction(calleeId, argcId, flags, argcFixed, funcTypeOffset, instanceOffset);\
}\
\
[[nodiscard]] bool emitGuardWasmArg(ValOperandId argId, wasm::ValType::Kind type);\
[[nodiscard]] bool emitGuardWasmArg(CacheIRReader& reader) {\
  ValOperandId argId = reader.valOperandId();\
  wasm::ValType::Kind type = reader.wasmValType();\
  return emitGuardWasmArg(argId, type);\
}\
\
[[nodiscard]] bool emitCallNativeFunction(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed, bool ignoresReturnValue);\
[[nodiscard]] bool emitCallNativeFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  bool ignoresReturnValue = reader.readBool();\
  return emitCallNativeFunction(calleeId, argcId, flags, argcFixed, ignoresReturnValue);\
}\
\
[[nodiscard]] bool emitCallDOMFunction(ObjOperandId calleeId, Int32OperandId argcId, ObjOperandId thisObjId, CallFlags flags, uint32_t argcFixed);\
[[nodiscard]] bool emitCallDOMFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  ObjOperandId thisObjId = reader.objOperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  return emitCallDOMFunction(calleeId, argcId, thisObjId, flags, argcFixed);\
}\
\
[[nodiscard]] bool emitCallDOMFunctionWithAllocSite(ObjOperandId calleeId, Int32OperandId argcId, ObjOperandId thisObjId, CallFlags flags, uint32_t argcFixed, uint32_t siteOffset);\
[[nodiscard]] bool emitCallDOMFunctionWithAllocSite(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  ObjOperandId thisObjId = reader.objOperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitCallDOMFunctionWithAllocSite(calleeId, argcId, thisObjId, flags, argcFixed, siteOffset);\
}\
\
[[nodiscard]] bool emitCallClassHook(ObjOperandId calleeId, Int32OperandId argcId, CallFlags flags, uint32_t argcFixed, uint32_t targetOffset);\
[[nodiscard]] bool emitCallClassHook(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  uint32_t targetOffset = reader.stubOffset();\
  return emitCallClassHook(calleeId, argcId, flags, argcFixed, targetOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedFunction(ObjOperandId calleeId, Int32OperandId argcId, uint32_t icScriptOffset, CallFlags flags, uint32_t argcFixed);\
[[nodiscard]] bool emitCallInlinedFunction(CacheIRReader& reader) {\
  ObjOperandId calleeId = reader.objOperandId();\
  Int32OperandId argcId = reader.int32OperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  CallFlags flags = reader.callFlags();\
  uint32_t argcFixed = reader.uint32Immediate();\
  return emitCallInlinedFunction(calleeId, argcId, icScriptOffset, flags, argcFixed);\
}\
\
[[nodiscard]] bool emitCallScriptedProxyGetResult(ValOperandId targetId, ObjOperandId receiverId, ObjOperandId handlerId, ObjOperandId trapId, uint32_t propertyOffset, uint32_t nargsAndFlags);\
[[nodiscard]] bool emitCallScriptedProxyGetResult(CacheIRReader& reader) {\
  ValOperandId targetId = reader.valOperandId();\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId handlerId = reader.objOperandId();\
  ObjOperandId trapId = reader.objOperandId();\
  uint32_t propertyOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = reader.uint32Immediate();\
  return emitCallScriptedProxyGetResult(targetId, receiverId, handlerId, trapId, propertyOffset, nargsAndFlags);\
}\
\
[[nodiscard]] bool emitCallScriptedProxyGetByValueResult(ValOperandId targetId, ObjOperandId receiverId, ObjOperandId handlerId, ValOperandId propertyId, ObjOperandId trapId, uint32_t nargsAndFlags);\
[[nodiscard]] bool emitCallScriptedProxyGetByValueResult(CacheIRReader& reader) {\
  ValOperandId targetId = reader.valOperandId();\
  ObjOperandId receiverId = reader.objOperandId();\
  ObjOperandId handlerId = reader.objOperandId();\
  ValOperandId propertyId = reader.valOperandId();\
  ObjOperandId trapId = reader.objOperandId();\
  uint32_t nargsAndFlags = reader.uint32Immediate();\
  return emitCallScriptedProxyGetByValueResult(targetId, receiverId, handlerId, propertyId, trapId, nargsAndFlags);\
}\
\
[[nodiscard]] bool emitMetaScriptedThisShape(uint32_t thisShapeOffset);\
[[nodiscard]] bool emitMetaScriptedThisShape(CacheIRReader& reader) {\
  uint32_t thisShapeOffset = reader.stubOffset();\
  return emitMetaScriptedThisShape(thisShapeOffset);\
}\
\
[[nodiscard]] bool emitBindFunctionResult(ObjOperandId targetId, uint32_t argc, uint32_t templateObjectOffset);\
[[nodiscard]] bool emitBindFunctionResult(CacheIRReader& reader) {\
  ObjOperandId targetId = reader.objOperandId();\
  uint32_t argc = reader.uint32Immediate();\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitBindFunctionResult(targetId, argc, templateObjectOffset);\
}\
\
[[nodiscard]] bool emitSpecializedBindFunctionResult(ObjOperandId targetId, uint32_t argc, uint32_t templateObjectOffset);\
[[nodiscard]] bool emitSpecializedBindFunctionResult(CacheIRReader& reader) {\
  ObjOperandId targetId = reader.objOperandId();\
  uint32_t argc = reader.uint32Immediate();\
  uint32_t templateObjectOffset = reader.stubOffset();\
  return emitSpecializedBindFunctionResult(targetId, argc, templateObjectOffset);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadFixedSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadFixedSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(ObjOperandId objId, uint32_t offsetOffset, ValueType type);\
[[nodiscard]] bool emitLoadFixedSlotTypedResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  ValueType type = reader.valueType();\
  return emitLoadFixedSlotTypedResult(objId, offsetOffset, type);\
}\
\
[[nodiscard]] bool emitLoadDynamicSlotResult(ObjOperandId objId, uint32_t offsetOffset);\
[[nodiscard]] bool emitLoadDynamicSlotResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t offsetOffset = reader.stubOffset();\
  return emitLoadDynamicSlotResult(objId, offsetOffset);\
}\
\
[[nodiscard]] bool emitLoadDenseElementResult(ObjOperandId objId, Int32OperandId indexId, bool expectPackedElements);\
[[nodiscard]] bool emitLoadDenseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool expectPackedElements = reader.readBool();\
  return emitLoadDenseElementResult(objId, indexId, expectPackedElements);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallGetSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallGetSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallGetSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadDenseElementExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(ObjOperandId objId, IntPtrOperandId indexId, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitLoadTypedArrayElementExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitLoadTypedArrayElementExistsResult(objId, indexId, viewKind);\
}\
\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadDenseElementHoleExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadDenseElementHoleExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadTypedArrayElementResult(ObjOperandId objId, IntPtrOperandId indexId, Scalar::Type elementType, bool handleOOB, bool forceDoubleForUint32, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitLoadTypedArrayElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool handleOOB = reader.readBool();\
  bool forceDoubleForUint32 = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitLoadTypedArrayElementResult(objId, indexId, elementType, handleOOB, forceDoubleForUint32, viewKind);\
}\
\
[[nodiscard]] bool emitLoadDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, BooleanOperandId littleEndianId, Scalar::Type elementType, bool forceDoubleForUint32, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitLoadDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  bool forceDoubleForUint32 = reader.readBool();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitLoadDataViewValueResult(objId, offsetId, littleEndianId, elementType, forceDoubleForUint32, viewKind);\
}\
\
[[nodiscard]] bool emitStoreDataViewValueResult(ObjOperandId objId, IntPtrOperandId offsetId, uint32_t valueId, BooleanOperandId littleEndianId, Scalar::Type elementType, ArrayBufferViewKind viewKind);\
[[nodiscard]] bool emitStoreDataViewValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  uint32_t valueId = reader.rawOperandId();\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  Scalar::Type elementType = reader.scalarType();\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  return emitStoreDataViewValueResult(objId, offsetId, valueId, littleEndianId, elementType, viewKind);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadInt32ArrayLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadInt32ArrayLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadInt32ArrayLength(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32ArrayLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32ArrayLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgHoleResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgHoleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgHoleResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectArgExistsResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitLoadArgumentsObjectArgExistsResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitLoadArgumentsObjectArgExistsResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArgumentsObjectLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArgumentsObjectLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArgumentsObjectLength(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadArgumentsObjectLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadArgumentsObjectLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadFunctionLengthResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionLengthResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionLengthResult(objId);\
}\
\
[[nodiscard]] bool emitLoadFunctionNameResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadFunctionNameResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadFunctionNameResult(objId);\
}\
\
[[nodiscard]] bool emitLoadBoundFunctionNumArgs(ObjOperandId objId, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadBoundFunctionNumArgs(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadBoundFunctionNumArgs(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadBoundFunctionTarget(ObjOperandId objId, ObjOperandId resultId);\
[[nodiscard]] bool emitLoadBoundFunctionTarget(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ObjOperandId resultId = reader.objOperandId();\
  return emitLoadBoundFunctionTarget(objId, resultId);\
}\
\
[[nodiscard]] bool emitLoadBoundFunctionArgument(ObjOperandId objId, uint32_t index, ValOperandId resultId);\
[[nodiscard]] bool emitLoadBoundFunctionArgument(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t index = reader.uint32Immediate();\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadBoundFunctionArgument(objId, index, resultId);\
}\
\
[[nodiscard]] bool emitGuardBoundFunctionIsConstructor(ObjOperandId objId);\
[[nodiscard]] bool emitGuardBoundFunctionIsConstructor(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitGuardBoundFunctionIsConstructor(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferByteLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthInt32Result(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadArrayBufferViewLengthDoubleResult(objId);\
}\
\
[[nodiscard]] bool emitLoadArrayBufferViewLength(ObjOperandId objId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitLoadArrayBufferViewLength(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitLoadArrayBufferViewLength(objId, resultId);\
}\
\
[[nodiscard]] bool emitLinearizeForCharAccess(StringOperandId strId, Int32OperandId indexId, StringOperandId resultId);\
[[nodiscard]] bool emitLinearizeForCharAccess(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLinearizeForCharAccess(strId, indexId, resultId);\
}\
\
[[nodiscard]] bool emitLinearizeForCodePointAccess(StringOperandId strId, Int32OperandId indexId, StringOperandId resultId);\
[[nodiscard]] bool emitLinearizeForCodePointAccess(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLinearizeForCodePointAccess(strId, indexId, resultId);\
}\
\
[[nodiscard]] bool emitToRelativeStringIndex(Int32OperandId indexId, StringOperandId strId, Int32OperandId resultId);\
[[nodiscard]] bool emitToRelativeStringIndex(CacheIRReader& reader) {\
  Int32OperandId indexId = reader.int32OperandId();\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitToRelativeStringIndex(indexId, strId, resultId);\
}\
\
[[nodiscard]] bool emitLoadStringCharResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringCharResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringCharResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitLoadStringAtResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringAtResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringAtResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitLoadStringCharCodeResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringCharCodeResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringCharCodeResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitLoadStringCodePointResult(StringOperandId strId, Int32OperandId indexId, bool handleOOB);\
[[nodiscard]] bool emitLoadStringCodePointResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  bool handleOOB = reader.readBool();\
  return emitLoadStringCodePointResult(strId, indexId, handleOOB);\
}\
\
[[nodiscard]] bool emitLoadStringLengthResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringLengthResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringLengthResult(strId);\
}\
\
[[nodiscard]] bool emitFrameIsConstructingResult();\
[[nodiscard]] bool emitFrameIsConstructingResult(CacheIRReader& reader) {\
  return emitFrameIsConstructingResult();\
}\
\
[[nodiscard]] bool emitLoadObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectResult(objId);\
}\
\
[[nodiscard]] bool emitLoadStringResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringResult(strId);\
}\
\
[[nodiscard]] bool emitLoadSymbolResult(SymbolOperandId symId);\
[[nodiscard]] bool emitLoadSymbolResult(CacheIRReader& reader) {\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitLoadSymbolResult(symId);\
}\
\
[[nodiscard]] bool emitLoadInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitLoadInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitLoadInt32Result(valId);\
}\
\
[[nodiscard]] bool emitLoadDoubleResult(NumberOperandId valId);\
[[nodiscard]] bool emitLoadDoubleResult(CacheIRReader& reader) {\
  NumberOperandId valId = reader.numberOperandId();\
  return emitLoadDoubleResult(valId);\
}\
\
[[nodiscard]] bool emitLoadBigIntResult(BigIntOperandId valId);\
[[nodiscard]] bool emitLoadBigIntResult(CacheIRReader& reader) {\
  BigIntOperandId valId = reader.bigIntOperandId();\
  return emitLoadBigIntResult(valId);\
}\
\
[[nodiscard]] bool emitCallScriptedGetterResult(ValOperandId receiverId, ObjOperandId calleeId, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallScriptedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallScriptedGetterResult(receiverId, calleeId, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallInlinedGetterResult(ValOperandId receiverId, ObjOperandId calleeId, uint32_t icScriptOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallInlinedGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  uint32_t icScriptOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallInlinedGetterResult(receiverId, calleeId, icScriptOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallNativeGetterResult(ValOperandId receiverId, uint32_t getterOffset, bool sameRealm, uint32_t nargsAndFlagsOffset);\
[[nodiscard]] bool emitCallNativeGetterResult(CacheIRReader& reader) {\
  ValOperandId receiverId = reader.valOperandId();\
  uint32_t getterOffset = reader.stubOffset();\
  bool sameRealm = reader.readBool();\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  return emitCallNativeGetterResult(receiverId, getterOffset, sameRealm, nargsAndFlagsOffset);\
}\
\
[[nodiscard]] bool emitCallDOMGetterResult(ObjOperandId objId, uint32_t jitInfoOffset);\
[[nodiscard]] bool emitCallDOMGetterResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t jitInfoOffset = reader.stubOffset();\
  return emitCallDOMGetterResult(objId, jitInfoOffset);\
}\
\
[[nodiscard]] bool emitProxyGetResult(ObjOperandId objId, uint32_t idOffset);\
[[nodiscard]] bool emitProxyGetResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  return emitProxyGetResult(objId, idOffset);\
}\
\
[[nodiscard]] bool emitProxyGetByValueResult(ObjOperandId objId, ValOperandId idId);\
[[nodiscard]] bool emitProxyGetByValueResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  return emitProxyGetByValueResult(objId, idId);\
}\
\
[[nodiscard]] bool emitProxyHasPropResult(ObjOperandId objId, ValOperandId idId, bool hasOwn);\
[[nodiscard]] bool emitProxyHasPropResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  ValOperandId idId = reader.valOperandId();\
  bool hasOwn = reader.readBool();\
  return emitProxyHasPropResult(objId, idId, hasOwn);\
}\
\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallObjectHasSparseElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallObjectHasSparseElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallNativeGetElementResult(ObjOperandId objId, Int32OperandId indexId);\
[[nodiscard]] bool emitCallNativeGetElementResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  return emitCallNativeGetElementResult(objId, indexId);\
}\
\
[[nodiscard]] bool emitCallNativeGetElementSuperResult(ObjOperandId objId, Int32OperandId indexId, ValOperandId receiverId);\
[[nodiscard]] bool emitCallNativeGetElementSuperResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  Int32OperandId indexId = reader.int32OperandId();\
  ValOperandId receiverId = reader.valOperandId();\
  return emitCallNativeGetElementSuperResult(objId, indexId, receiverId);\
}\
\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(ObjOperandId iterId, ObjOperandId resultArrId, bool isMap);\
[[nodiscard]] bool emitGetNextMapSetEntryForIteratorResult(CacheIRReader& reader) {\
  ObjOperandId iterId = reader.objOperandId();\
  ObjOperandId resultArrId = reader.objOperandId();\
  bool isMap = reader.readBool();\
  return emitGetNextMapSetEntryForIteratorResult(iterId, resultArrId, isMap);\
}\
\
[[nodiscard]] bool emitLoadUndefinedResult();\
[[nodiscard]] bool emitLoadUndefinedResult(CacheIRReader& reader) {\
  return emitLoadUndefinedResult();\
}\
\
[[nodiscard]] bool emitLoadBooleanResult(bool val);\
[[nodiscard]] bool emitLoadBooleanResult(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  return emitLoadBooleanResult(val);\
}\
\
[[nodiscard]] bool emitLoadInt32Constant(uint32_t valOffset, Int32OperandId resultId);\
[[nodiscard]] bool emitLoadInt32Constant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  Int32OperandId resultId = reader.int32OperandId();\
  return emitLoadInt32Constant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadInt32AsIntPtrConstant(uint32_t valOffset, IntPtrOperandId resultId);\
[[nodiscard]] bool emitLoadInt32AsIntPtrConstant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitLoadInt32AsIntPtrConstant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadDoubleConstant(uint32_t valOffset, NumberOperandId resultId);\
[[nodiscard]] bool emitLoadDoubleConstant(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  NumberOperandId resultId = reader.numberOperandId();\
  return emitLoadDoubleConstant(valOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadBooleanConstant(bool val, BooleanOperandId resultId);\
[[nodiscard]] bool emitLoadBooleanConstant(CacheIRReader& reader) {\
  bool val = reader.readBool();\
  BooleanOperandId resultId = reader.booleanOperandId();\
  return emitLoadBooleanConstant(val, resultId);\
}\
\
[[nodiscard]] bool emitLoadUndefined(ValOperandId resultId);\
[[nodiscard]] bool emitLoadUndefined(CacheIRReader& reader) {\
  ValOperandId resultId = reader.valOperandId();\
  return emitLoadUndefined(resultId);\
}\
\
[[nodiscard]] bool emitLoadConstantString(uint32_t strOffset, StringOperandId resultId);\
[[nodiscard]] bool emitLoadConstantString(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  StringOperandId resultId = reader.stringOperandId();\
  return emitLoadConstantString(strOffset, resultId);\
}\
\
[[nodiscard]] bool emitLoadConstantStringResult(uint32_t strOffset);\
[[nodiscard]] bool emitLoadConstantStringResult(CacheIRReader& reader) {\
  uint32_t strOffset = reader.stubOffset();\
  return emitLoadConstantStringResult(strOffset);\
}\
\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(ValOperandId lhsId, ObjOperandId protoId);\
[[nodiscard]] bool emitLoadInstanceOfObjectResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ObjOperandId protoId = reader.objOperandId();\
  return emitLoadInstanceOfObjectResult(lhsId, protoId);\
}\
\
[[nodiscard]] bool emitLoadTypeOfObjectResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadTypeOfObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadTypeOfObjectResult(objId);\
}\
\
[[nodiscard]] bool emitLoadTypeOfEqObjectResult(ObjOperandId objId, TypeofEqOperand operand);\
[[nodiscard]] bool emitLoadTypeOfEqObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  TypeofEqOperand operand = reader.typeofEqOperand();\
  return emitLoadTypeOfEqObjectResult(objId, operand);\
}\
\
[[nodiscard]] bool emitDoubleAddResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleAddResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleSubResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleSubResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleMulResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleMulResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleDivResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleDivResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoubleModResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoubleModResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoubleModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitDoublePowResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitDoublePowResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitDoublePowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32AddResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32AddResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32AddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32SubResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32SubResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32SubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32MulResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32MulResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32MulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32DivResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32DivResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32DivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32ModResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32ModResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32ModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32PowResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32PowResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32PowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntAddResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntAddResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntAddResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntSubResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntSubResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntSubResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntMulResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntMulResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntMulResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntDivResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntDivResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntDivResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntModResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntModResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntModResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntPowResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntPowResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntPowResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntToIntPtr(BigIntOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntToIntPtr(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntToIntPtr(inputId, resultId);\
}\
\
[[nodiscard]] bool emitIntPtrToBigIntResult(IntPtrOperandId inputId);\
[[nodiscard]] bool emitIntPtrToBigIntResult(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  return emitIntPtrToBigIntResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrAdd(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrAdd(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrAdd(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrSub(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrSub(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrSub(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrMul(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrMul(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrMul(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrDiv(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrDiv(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrDiv(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrMod(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrMod(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrMod(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrPow(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrPow(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrPow(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitInt32BitOrResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitOrResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitXorResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitXorResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32BitAndResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32BitAndResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32BitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32LeftShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32LeftShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32LeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32RightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitInt32RightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitInt32RightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitInt32URightShiftResult(Int32OperandId lhsId, Int32OperandId rhsId, bool forceDouble);\
[[nodiscard]] bool emitInt32URightShiftResult(CacheIRReader& reader) {\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  bool forceDouble = reader.readBool();\
  return emitInt32URightShiftResult(lhsId, rhsId, forceDouble);\
}\
\
[[nodiscard]] bool emitInt32NotResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NotResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NotResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntBitOrResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitOrResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitOrResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitXorResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitXorResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitXorResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntBitAndResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntBitAndResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntBitAndResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntLeftShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntLeftShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntLeftShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntRightShiftResult(BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitBigIntRightShiftResult(CacheIRReader& reader) {\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitBigIntRightShiftResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitBigIntNotResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNotResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNotResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrBitOr(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrBitOr(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrBitOr(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrBitXor(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrBitXor(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrBitXor(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrBitAnd(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrBitAnd(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrBitAnd(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrLeftShift(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrLeftShift(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrLeftShift(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrRightShift(IntPtrOperandId lhsId, IntPtrOperandId rhsId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrRightShift(CacheIRReader& reader) {\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrRightShift(lhsId, rhsId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrNot(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrNot(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrNot(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32NegationResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32NegationResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32NegationResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleNegationResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleNegationResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntNegationResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntNegationResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntNegationResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrNegation(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrNegation(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrNegation(inputId, resultId);\
}\
\
[[nodiscard]] bool emitInt32IncResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32IncResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32IncResult(inputId);\
}\
\
[[nodiscard]] bool emitInt32DecResult(Int32OperandId inputId);\
[[nodiscard]] bool emitInt32DecResult(CacheIRReader& reader) {\
  Int32OperandId inputId = reader.int32OperandId();\
  return emitInt32DecResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleIncResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleIncResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleIncResult(inputId);\
}\
\
[[nodiscard]] bool emitDoubleDecResult(NumberOperandId inputId);\
[[nodiscard]] bool emitDoubleDecResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitDoubleDecResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntIncResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntIncResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntIncResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntDecResult(BigIntOperandId inputId);\
[[nodiscard]] bool emitBigIntDecResult(CacheIRReader& reader) {\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  return emitBigIntDecResult(inputId);\
}\
\
[[nodiscard]] bool emitBigIntPtrInc(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrInc(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrInc(inputId, resultId);\
}\
\
[[nodiscard]] bool emitBigIntPtrDec(IntPtrOperandId inputId, IntPtrOperandId resultId);\
[[nodiscard]] bool emitBigIntPtrDec(CacheIRReader& reader) {\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  return emitBigIntPtrDec(inputId, resultId);\
}\
\
[[nodiscard]] bool emitLoadInt32TruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadInt32TruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadInt32TruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadDoubleTruthyResult(NumberOperandId inputId);\
[[nodiscard]] bool emitLoadDoubleTruthyResult(CacheIRReader& reader) {\
  NumberOperandId inputId = reader.numberOperandId();\
  return emitLoadDoubleTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadStringTruthyResult(StringOperandId strId);\
[[nodiscard]] bool emitLoadStringTruthyResult(CacheIRReader& reader) {\
  StringOperandId strId = reader.stringOperandId();\
  return emitLoadStringTruthyResult(strId);\
}\
\
[[nodiscard]] bool emitLoadObjectTruthyResult(ObjOperandId objId);\
[[nodiscard]] bool emitLoadObjectTruthyResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  return emitLoadObjectTruthyResult(objId);\
}\
\
[[nodiscard]] bool emitLoadBigIntTruthyResult(BigIntOperandId bigIntId);\
[[nodiscard]] bool emitLoadBigIntTruthyResult(CacheIRReader& reader) {\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitLoadBigIntTruthyResult(bigIntId);\
}\
\
[[nodiscard]] bool emitLoadValueTruthyResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadValueTruthyResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadValueTruthyResult(inputId);\
}\
\
[[nodiscard]] bool emitLoadValueResult(uint32_t valOffset);\
[[nodiscard]] bool emitLoadValueResult(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  return emitLoadValueResult(valOffset);\
}\
\
[[nodiscard]] bool emitUncheckedLoadWeakValueResult(uint32_t valOffset);\
[[nodiscard]] bool emitUncheckedLoadWeakValueResult(CacheIRReader& reader) {\
  uint32_t valOffset = reader.stubOffset();\
  return emitUncheckedLoadWeakValueResult(valOffset);\
}\
\
[[nodiscard]] bool emitUncheckedLoadWeakObjectResult(uint32_t objOffset);\
[[nodiscard]] bool emitUncheckedLoadWeakObjectResult(CacheIRReader& reader) {\
  uint32_t objOffset = reader.stubOffset();\
  return emitUncheckedLoadWeakObjectResult(objOffset);\
}\
\
[[nodiscard]] bool emitLoadOperandResult(ValOperandId inputId);\
[[nodiscard]] bool emitLoadOperandResult(CacheIRReader& reader) {\
  ValOperandId inputId = reader.valOperandId();\
  return emitLoadOperandResult(inputId);\
}\
\
[[nodiscard]] bool emitNewPlainObjectResult(uint32_t numFixedSlots, uint32_t numDynamicSlots, gc::AllocKind allocKind, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewPlainObjectResult(CacheIRReader& reader) {\
  uint32_t numFixedSlots = reader.uint32Immediate();\
  uint32_t numDynamicSlots = reader.uint32Immediate();\
  gc::AllocKind allocKind = reader.allocKind();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewPlainObjectResult(numFixedSlots, numDynamicSlots, allocKind, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitNewArrayObjectResult(uint32_t arrayLength, uint32_t shapeOffset, uint32_t siteOffset);\
[[nodiscard]] bool emitNewArrayObjectResult(CacheIRReader& reader) {\
  uint32_t arrayLength = reader.uint32Immediate();\
  uint32_t shapeOffset = reader.stubOffset();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewArrayObjectResult(arrayLength, shapeOffset, siteOffset);\
}\
\
[[nodiscard]] bool emitNewFunctionCloneResult(uint32_t canonicalOffset, gc::AllocKind allocKind, uint32_t siteOffset);\
[[nodiscard]] bool emitNewFunctionCloneResult(CacheIRReader& reader) {\
  uint32_t canonicalOffset = reader.stubOffset();\
  gc::AllocKind allocKind = reader.allocKind();\
  uint32_t siteOffset = reader.stubOffset();\
  return emitNewFunctionCloneResult(canonicalOffset, allocKind, siteOffset);\
}\
\
[[nodiscard]] bool emitConcatStringsResult(StringOperandId lhsId, StringOperandId rhsId, uint32_t stubOffset);\
[[nodiscard]] bool emitConcatStringsResult(CacheIRReader& reader) {\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  uint32_t stubOffset = reader.stubOffset();\
  return emitConcatStringsResult(lhsId, rhsId, stubOffset);\
}\
\
[[nodiscard]] bool emitCompareStringResult(JSOp op, StringOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  StringOperandId lhsId = reader.stringOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareObjectResult(JSOp op, ObjOperandId lhsId, ObjOperandId rhsId);\
[[nodiscard]] bool emitCompareObjectResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  ObjOperandId lhsId = reader.objOperandId();\
  ObjOperandId rhsId = reader.objOperandId();\
  return emitCompareObjectResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareSymbolResult(JSOp op, SymbolOperandId lhsId, SymbolOperandId rhsId);\
[[nodiscard]] bool emitCompareSymbolResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  SymbolOperandId lhsId = reader.symbolOperandId();\
  SymbolOperandId rhsId = reader.symbolOperandId();\
  return emitCompareSymbolResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareInt32Result(JSOp op, Int32OperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  Int32OperandId lhsId = reader.int32OperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareDoubleResult(JSOp op, NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntResult(JSOp op, BigIntOperandId lhsId, BigIntOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  return emitCompareBigIntResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntInt32Result(JSOp op, BigIntOperandId lhsId, Int32OperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntInt32Result(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  Int32OperandId rhsId = reader.int32OperandId();\
  return emitCompareBigIntInt32Result(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntNumberResult(JSOp op, BigIntOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntNumberResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareBigIntNumberResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareBigIntStringResult(JSOp op, BigIntOperandId lhsId, StringOperandId rhsId);\
[[nodiscard]] bool emitCompareBigIntStringResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  StringOperandId rhsId = reader.stringOperandId();\
  return emitCompareBigIntStringResult(op, lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitCompareNullUndefinedResult(JSOp op, bool isUndefined, ValOperandId inputId);\
[[nodiscard]] bool emitCompareNullUndefinedResult(CacheIRReader& reader) {\
  JSOp op = reader.jsop();\
  bool isUndefined = reader.readBool();\
  ValOperandId inputId = reader.valOperandId();\
  return emitCompareNullUndefinedResult(op, isUndefined, inputId);\
}\
\
[[nodiscard]] bool emitCompareDoubleSameValueResult(NumberOperandId lhsId, NumberOperandId rhsId);\
[[nodiscard]] bool emitCompareDoubleSameValueResult(CacheIRReader& reader) {\
  NumberOperandId lhsId = reader.numberOperandId();\
  NumberOperandId rhsId = reader.numberOperandId();\
  return emitCompareDoubleSameValueResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitSameValueResult(ValOperandId lhsId, ValOperandId rhsId);\
[[nodiscard]] bool emitSameValueResult(CacheIRReader& reader) {\
  ValOperandId lhsId = reader.valOperandId();\
  ValOperandId rhsId = reader.valOperandId();\
  return emitSameValueResult(lhsId, rhsId);\
}\
\
[[nodiscard]] bool emitIndirectTruncateInt32Result(Int32OperandId valId);\
[[nodiscard]] bool emitIndirectTruncateInt32Result(CacheIRReader& reader) {\
  Int32OperandId valId = reader.int32OperandId();\
  return emitIndirectTruncateInt32Result(valId);\
}\
\
[[nodiscard]] bool emitBigIntAsIntNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsIntNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsIntNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitBigIntAsUintNResult(Int32OperandId bitsId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitBigIntAsUintNResult(CacheIRReader& reader) {\
  Int32OperandId bitsId = reader.int32OperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitBigIntAsUintNResult(bitsId, bigIntId);\
}\
\
[[nodiscard]] bool emitSetHasResult(ObjOperandId setId, ValOperandId valId);\
[[nodiscard]] bool emitSetHasResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitSetHasResult(setId, valId);\
}\
\
[[nodiscard]] bool emitSetHasNonGCThingResult(ObjOperandId setId, ValOperandId valId);\
[[nodiscard]] bool emitSetHasNonGCThingResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitSetHasNonGCThingResult(setId, valId);\
}\
\
[[nodiscard]] bool emitSetHasStringResult(ObjOperandId setId, StringOperandId strId);\
[[nodiscard]] bool emitSetHasStringResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  StringOperandId strId = reader.stringOperandId();\
  return emitSetHasStringResult(setId, strId);\
}\
\
[[nodiscard]] bool emitSetHasSymbolResult(ObjOperandId setId, SymbolOperandId symId);\
[[nodiscard]] bool emitSetHasSymbolResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitSetHasSymbolResult(setId, symId);\
}\
\
[[nodiscard]] bool emitSetHasBigIntResult(ObjOperandId setId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitSetHasBigIntResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitSetHasBigIntResult(setId, bigIntId);\
}\
\
[[nodiscard]] bool emitSetHasObjectResult(ObjOperandId setId, ObjOperandId objId);\
[[nodiscard]] bool emitSetHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitSetHasObjectResult(setId, objId);\
}\
\
[[nodiscard]] bool emitSetDeleteResult(ObjOperandId setId, ValOperandId valId);\
[[nodiscard]] bool emitSetDeleteResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitSetDeleteResult(setId, valId);\
}\
\
[[nodiscard]] bool emitSetAddResult(ObjOperandId setId, ValOperandId keyId);\
[[nodiscard]] bool emitSetAddResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  ValOperandId keyId = reader.valOperandId();\
  return emitSetAddResult(setId, keyId);\
}\
\
[[nodiscard]] bool emitSetSizeResult(ObjOperandId setId);\
[[nodiscard]] bool emitSetSizeResult(CacheIRReader& reader) {\
  ObjOperandId setId = reader.objOperandId();\
  return emitSetSizeResult(setId);\
}\
\
[[nodiscard]] bool emitMapHasResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapHasResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapHasResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapHasNonGCThingResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapHasNonGCThingResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapHasNonGCThingResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapHasStringResult(ObjOperandId mapId, StringOperandId strId);\
[[nodiscard]] bool emitMapHasStringResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  StringOperandId strId = reader.stringOperandId();\
  return emitMapHasStringResult(mapId, strId);\
}\
\
[[nodiscard]] bool emitMapHasSymbolResult(ObjOperandId mapId, SymbolOperandId symId);\
[[nodiscard]] bool emitMapHasSymbolResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitMapHasSymbolResult(mapId, symId);\
}\
\
[[nodiscard]] bool emitMapHasBigIntResult(ObjOperandId mapId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitMapHasBigIntResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitMapHasBigIntResult(mapId, bigIntId);\
}\
\
[[nodiscard]] bool emitMapHasObjectResult(ObjOperandId mapId, ObjOperandId objId);\
[[nodiscard]] bool emitMapHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitMapHasObjectResult(mapId, objId);\
}\
\
[[nodiscard]] bool emitMapGetResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapGetResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapGetResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapGetNonGCThingResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapGetNonGCThingResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapGetNonGCThingResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapGetStringResult(ObjOperandId mapId, StringOperandId strId);\
[[nodiscard]] bool emitMapGetStringResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  StringOperandId strId = reader.stringOperandId();\
  return emitMapGetStringResult(mapId, strId);\
}\
\
[[nodiscard]] bool emitMapGetSymbolResult(ObjOperandId mapId, SymbolOperandId symId);\
[[nodiscard]] bool emitMapGetSymbolResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  SymbolOperandId symId = reader.symbolOperandId();\
  return emitMapGetSymbolResult(mapId, symId);\
}\
\
[[nodiscard]] bool emitMapGetBigIntResult(ObjOperandId mapId, BigIntOperandId bigIntId);\
[[nodiscard]] bool emitMapGetBigIntResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  return emitMapGetBigIntResult(mapId, bigIntId);\
}\
\
[[nodiscard]] bool emitMapGetObjectResult(ObjOperandId mapId, ObjOperandId objId);\
[[nodiscard]] bool emitMapGetObjectResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitMapGetObjectResult(mapId, objId);\
}\
\
[[nodiscard]] bool emitMapDeleteResult(ObjOperandId mapId, ValOperandId valId);\
[[nodiscard]] bool emitMapDeleteResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapDeleteResult(mapId, valId);\
}\
\
[[nodiscard]] bool emitMapSetResult(ObjOperandId mapId, ValOperandId keyId, ValOperandId valId);\
[[nodiscard]] bool emitMapSetResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  ValOperandId keyId = reader.valOperandId();\
  ValOperandId valId = reader.valOperandId();\
  return emitMapSetResult(mapId, keyId, valId);\
}\
\
[[nodiscard]] bool emitMapSizeResult(ObjOperandId mapId);\
[[nodiscard]] bool emitMapSizeResult(CacheIRReader& reader) {\
  ObjOperandId mapId = reader.objOperandId();\
  return emitMapSizeResult(mapId);\
}\
\
[[nodiscard]] bool emitWeakMapGetObjectResult(ObjOperandId weakMapId, ObjOperandId objId);\
[[nodiscard]] bool emitWeakMapGetObjectResult(CacheIRReader& reader) {\
  ObjOperandId weakMapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitWeakMapGetObjectResult(weakMapId, objId);\
}\
\
[[nodiscard]] bool emitWeakMapHasObjectResult(ObjOperandId weakMapId, ObjOperandId objId);\
[[nodiscard]] bool emitWeakMapHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId weakMapId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitWeakMapHasObjectResult(weakMapId, objId);\
}\
\
[[nodiscard]] bool emitWeakSetHasObjectResult(ObjOperandId weakSetId, ObjOperandId objId);\
[[nodiscard]] bool emitWeakSetHasObjectResult(CacheIRReader& reader) {\
  ObjOperandId weakSetId = reader.objOperandId();\
  ObjOperandId objId = reader.objOperandId();\
  return emitWeakSetHasObjectResult(weakSetId, objId);\
}\
\
[[nodiscard]] bool emitDateFillLocalTimeSlots(ObjOperandId dateId);\
[[nodiscard]] bool emitDateFillLocalTimeSlots(CacheIRReader& reader) {\
  ObjOperandId dateId = reader.objOperandId();\
  return emitDateFillLocalTimeSlots(dateId);\
}\
\
[[nodiscard]] bool emitDateHoursFromSecondsIntoYearResult(ValOperandId secondsIntoYearId);\
[[nodiscard]] bool emitDateHoursFromSecondsIntoYearResult(CacheIRReader& reader) {\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  return emitDateHoursFromSecondsIntoYearResult(secondsIntoYearId);\
}\
\
[[nodiscard]] bool emitDateMinutesFromSecondsIntoYearResult(ValOperandId secondsIntoYearId);\
[[nodiscard]] bool emitDateMinutesFromSecondsIntoYearResult(CacheIRReader& reader) {\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  return emitDateMinutesFromSecondsIntoYearResult(secondsIntoYearId);\
}\
\
[[nodiscard]] bool emitDateSecondsFromSecondsIntoYearResult(ValOperandId secondsIntoYearId);\
[[nodiscard]] bool emitDateSecondsFromSecondsIntoYearResult(CacheIRReader& reader) {\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  return emitDateSecondsFromSecondsIntoYearResult(secondsIntoYearId);\
}\
\
[[nodiscard]] bool emitArrayFromArgumentsObjectResult(ObjOperandId objId, uint32_t shapeOffset);\
[[nodiscard]] bool emitArrayFromArgumentsObjectResult(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t shapeOffset = reader.stubOffset();\
  return emitArrayFromArgumentsObjectResult(objId, shapeOffset);\
}\
\
[[nodiscard]] bool emitCloseIterScriptedResult(ObjOperandId iterId, ObjOperandId calleeId, CompletionKind kind, uint32_t targetNargs);\
[[nodiscard]] bool emitCloseIterScriptedResult(CacheIRReader& reader) {\
  ObjOperandId iterId = reader.objOperandId();\
  ObjOperandId calleeId = reader.objOperandId();\
  CompletionKind kind = reader.completionKind();\
  uint32_t targetNargs = reader.uint32Immediate();\
  return emitCloseIterScriptedResult(iterId, calleeId, kind, targetNargs);\
}\
\
[[nodiscard]] bool emitBailout();\
[[nodiscard]] bool emitBailout(CacheIRReader& reader) {\
  return emitBailout();\
}\
\
[[nodiscard]] bool emitAssertFloat32Result(ValOperandId valId, bool mustBeFloat32);\
[[nodiscard]] bool emitAssertFloat32Result(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  bool mustBeFloat32 = reader.readBool();\
  return emitAssertFloat32Result(valId, mustBeFloat32);\
}\
\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(ValOperandId valId, bool mustBeRecovered);\
[[nodiscard]] bool emitAssertRecoveredOnBailoutResult(CacheIRReader& reader) {\
  ValOperandId valId = reader.valOperandId();\
  bool mustBeRecovered = reader.readBool();\
  return emitAssertRecoveredOnBailoutResult(valId, mustBeRecovered);\
}\
\
[[nodiscard]] bool emitAssertPropertyLookup(ObjOperandId objId, uint32_t idOffset, uint32_t slotOffset);\
[[nodiscard]] bool emitAssertPropertyLookup(CacheIRReader& reader) {\
  ObjOperandId objId = reader.objOperandId();\
  uint32_t idOffset = reader.stubOffset();\
  uint32_t slotOffset = reader.stubOffset();\
  return emitAssertPropertyLookup(objId, idOffset, slotOffset);\
}\


#define CACHE_IR_TRANSPILER_OPS(_)\
_(ReturnFromIC)\
_(GuardToObject)\
_(GuardIsNullOrUndefined)\
_(GuardIsNull)\
_(GuardIsUndefined)\
_(GuardIsNotUninitializedLexical)\
_(GuardToBoolean)\
_(GuardToString)\
_(GuardToSymbol)\
_(GuardToBigInt)\
_(GuardIsNumber)\
_(GuardToInt32)\
_(GuardToNonGCThing)\
_(GuardBooleanToInt32)\
_(GuardToInt32Index)\
_(Int32ToIntPtr)\
_(GuardNumberToIntPtrIndex)\
_(GuardToInt32ModUint32)\
_(GuardToUint8Clamped)\
_(GuardNonDoubleType)\
_(GuardShape)\
_(GuardMultipleShapes)\
_(GuardProto)\
_(GuardNullProto)\
_(GuardClass)\
_(GuardFuse)\
_(GuardRuntimeFuse)\
_(GuardObjectFuseProperty)\
_(GuardAnyClass)\
_(GuardGlobalGeneration)\
_(HasClassResult)\
_(HasShapeResult)\
_(CallRegExpMatcherResult)\
_(CallRegExpSearcherResult)\
_(RegExpSearcherLastLimitResult)\
_(RegExpHasCaptureGroupsResult)\
_(RegExpBuiltinExecMatchResult)\
_(RegExpBuiltinExecTestResult)\
_(RegExpFlagResult)\
_(CallSubstringKernelResult)\
_(StringReplaceStringResult)\
_(StringSplitStringResult)\
_(GetFirstDollarIndexResult)\
_(GuardIsExtensible)\
_(GuardIsNativeObject)\
_(GuardIsProxy)\
_(GuardIsNotProxy)\
_(GuardToArrayBuffer)\
_(GuardToSharedArrayBuffer)\
_(GuardIsNotArrayBufferMaybeShared)\
_(GuardIsTypedArray)\
_(GuardIsNonResizableTypedArray)\
_(GuardIsResizableTypedArray)\
_(GuardHasProxyHandler)\
_(GuardIsNotDOMProxy)\
_(GuardSpecificObject)\
_(GuardObjectIdentity)\
_(GuardSpecificFunction)\
_(GuardFunctionScript)\
_(GuardSpecificAtom)\
_(GuardSpecificSymbol)\
_(GuardSpecificInt32)\
_(GuardSpecificValue)\
_(GuardNoDenseElements)\
_(GuardStringToIndex)\
_(GuardStringToInt32)\
_(GuardStringToNumber)\
_(StringToAtom)\
_(BooleanToNumber)\
_(LoadGetterSetterFunction)\
_(GuardHasGetterSetter)\
_(GuardInt32IsNonNegative)\
_(GuardIntPtrIsNonNegative)\
_(GuardIndexIsValidUpdateOrAdd)\
_(GuardIndexIsNotDenseElement)\
_(GuardTagNotEqual)\
_(GuardDynamicSlotIsSpecificObject)\
_(GuardDynamicSlotIsNotObject)\
_(GuardFixedSlotValue)\
_(GuardDynamicSlotValue)\
_(CheckWeakValueResultForFixedSlot)\
_(CheckWeakValueResultForDynamicSlot)\
_(LoadScriptedProxyHandler)\
_(IdToStringOrSymbol)\
_(LoadFixedSlot)\
_(LoadDynamicSlot)\
_(GuardNoAllocationMetadataBuilder)\
_(GuardFunctionHasJitEntry)\
_(GuardFunctionHasNoJitEntry)\
_(GuardFunctionIsNonBuiltinCtor)\
_(GuardFunctionIsConstructor)\
_(GuardNotClassConstructor)\
_(GuardArrayIsPacked)\
_(GuardArgumentsObjectFlags)\
_(GuardObjectHasSameRealm)\
_(LoadObject)\
_(LoadProtoObject)\
_(LoadProto)\
_(LoadEnclosingEnvironment)\
_(LoadWrapperTarget)\
_(LoadValueTag)\
_(LoadArgumentFixedSlot)\
_(LoadArgumentDynamicSlot)\
_(TruncateDoubleToUInt32)\
_(DoubleToUint8Clamped)\
_(MegamorphicLoadSlotResult)\
_(MegamorphicLoadSlotByValueResult)\
_(MegamorphicLoadSlotPermissiveResult)\
_(MegamorphicLoadSlotByValuePermissiveResult)\
_(MegamorphicStoreSlot)\
_(MegamorphicSetElement)\
_(MegamorphicHasPropResult)\
_(SmallObjectVariableKeyHasOwnResult)\
_(ObjectToIteratorResult)\
_(ValueToIteratorResult)\
_(LoadDOMExpandoValue)\
_(LoadDOMExpandoValueGuardGeneration)\
_(LoadDOMExpandoValueIgnoreGeneration)\
_(GuardDOMExpandoMissingOrGuardShape)\
_(StoreFixedSlot)\
_(StoreDynamicSlot)\
_(AddAndStoreFixedSlot)\
_(AddAndStoreDynamicSlot)\
_(AllocateAndStoreDynamicSlot)\
_(AddSlotAndCallAddPropHook)\
_(StoreDenseElement)\
_(StoreDenseElementHole)\
_(ArrayPush)\
_(ArrayJoinResult)\
_(ObjectKeysResult)\
_(PackedArrayPopResult)\
_(PackedArrayShiftResult)\
_(PackedArraySliceResult)\
_(ArgumentsSliceResult)\
_(IsArrayResult)\
_(StoreFixedSlotUndefinedResult)\
_(IsObjectResult)\
_(IsPackedArrayResult)\
_(IsCallableResult)\
_(IsConstructorResult)\
_(IsCrossRealmArrayConstructorResult)\
_(IsTypedArrayResult)\
_(IsTypedArrayConstructorResult)\
_(ArrayBufferViewByteOffsetInt32Result)\
_(ArrayBufferViewByteOffsetDoubleResult)\
_(TypedArrayByteLengthInt32Result)\
_(TypedArrayByteLengthDoubleResult)\
_(ResizableTypedArrayByteLengthInt32Result)\
_(ResizableTypedArrayByteLengthDoubleResult)\
_(ResizableTypedArrayLengthInt32Result)\
_(ResizableTypedArrayLengthDoubleResult)\
_(ResizableDataViewByteLengthInt32Result)\
_(ResizableDataViewByteLengthDoubleResult)\
_(GrowableSharedArrayBufferByteLengthInt32Result)\
_(GrowableSharedArrayBufferByteLengthDoubleResult)\
_(GuardHasAttachedArrayBuffer)\
_(GuardResizableArrayBufferViewInBounds)\
_(GuardResizableArrayBufferViewInBoundsOrDetached)\
_(TypedArrayFillResult)\
_(TypedArraySetResult)\
_(TypedArraySubarrayResult)\
_(NewArrayIteratorResult)\
_(NewStringIteratorResult)\
_(NewRegExpStringIteratorResult)\
_(ObjectCreateResult)\
_(NewArrayFromLengthResult)\
_(NewTypedArrayFromLengthResult)\
_(NewTypedArrayFromArrayBufferResult)\
_(NewTypedArrayFromArrayResult)\
_(NewMapObjectResult)\
_(NewSetObjectResult)\
_(NewMapObjectFromIterableResult)\
_(NewSetObjectFromIterableResult)\
_(NewStringObjectResult)\
_(StringFromCharCodeResult)\
_(StringFromCodePointResult)\
_(StringIncludesResult)\
_(StringIndexOfResult)\
_(StringLastIndexOfResult)\
_(StringStartsWithResult)\
_(StringEndsWithResult)\
_(StringToLowerCaseResult)\
_(StringToUpperCaseResult)\
_(StringTrimResult)\
_(StringTrimStartResult)\
_(StringTrimEndResult)\
_(MathAbsInt32Result)\
_(MathAbsNumberResult)\
_(MathClz32Result)\
_(MathSignInt32Result)\
_(MathSignNumberResult)\
_(MathSignNumberToInt32Result)\
_(MathImulResult)\
_(MathSqrtNumberResult)\
_(MathFRoundNumberResult)\
_(MathF16RoundNumberResult)\
_(MathRandomResult)\
_(MathHypot2NumberResult)\
_(MathHypot3NumberResult)\
_(MathHypot4NumberResult)\
_(MathAtan2NumberResult)\
_(MathFloorNumberResult)\
_(MathCeilNumberResult)\
_(MathTruncNumberResult)\
_(MathRoundNumberResult)\
_(MathFloorToInt32Result)\
_(MathCeilToInt32Result)\
_(MathTruncToInt32Result)\
_(MathRoundToInt32Result)\
_(Int32MinMax)\
_(NumberMinMax)\
_(Int32MinMaxArrayResult)\
_(NumberMinMaxArrayResult)\
_(MathFunctionNumberResult)\
_(NumberParseIntResult)\
_(DoubleParseIntResult)\
_(ObjectToStringResult)\
_(ReflectGetPrototypeOfResult)\
_(StoreTypedArrayElement)\
_(AtomicsCompareExchangeResult)\
_(AtomicsExchangeResult)\
_(AtomicsAddResult)\
_(AtomicsSubResult)\
_(AtomicsAndResult)\
_(AtomicsOrResult)\
_(AtomicsXorResult)\
_(AtomicsLoadResult)\
_(AtomicsStoreResult)\
_(AtomicsIsLockFreeResult)\
_(AtomicsPauseResult)\
_(CallNativeSetter)\
_(CallScriptedSetter)\
_(CallInlinedSetter)\
_(CallDOMSetter)\
_(CallSetArrayLength)\
_(ProxySet)\
_(ProxySetByValue)\
_(CallAddOrUpdateSparseElementHelper)\
_(CallInt32ToString)\
_(CallNumberToString)\
_(Int32ToStringWithBaseResult)\
_(BooleanToString)\
_(CallScriptedFunction)\
_(CallBoundScriptedFunction)\
_(CallWasmFunction)\
_(GuardWasmArg)\
_(CallNativeFunction)\
_(CallDOMFunction)\
_(CallDOMFunctionWithAllocSite)\
_(CallClassHook)\
_(CallInlinedFunction)\
_(CallScriptedProxyGetResult)\
_(CallScriptedProxyGetByValueResult)\
_(MetaScriptedThisShape)\
_(BindFunctionResult)\
_(SpecializedBindFunctionResult)\
_(LoadFixedSlotResult)\
_(LoadFixedSlotTypedResult)\
_(LoadDynamicSlotResult)\
_(LoadDenseElementResult)\
_(LoadDenseElementHoleResult)\
_(CallGetSparseElementResult)\
_(LoadDenseElementExistsResult)\
_(LoadTypedArrayElementExistsResult)\
_(LoadDenseElementHoleExistsResult)\
_(LoadTypedArrayElementResult)\
_(LoadDataViewValueResult)\
_(StoreDataViewValueResult)\
_(LoadInt32ArrayLengthResult)\
_(LoadInt32ArrayLength)\
_(LoadArgumentsObjectArgResult)\
_(LoadArgumentsObjectArgHoleResult)\
_(LoadArgumentsObjectArgExistsResult)\
_(LoadArgumentsObjectLengthResult)\
_(LoadArgumentsObjectLength)\
_(LoadFunctionLengthResult)\
_(LoadFunctionNameResult)\
_(LoadBoundFunctionNumArgs)\
_(LoadBoundFunctionTarget)\
_(LoadBoundFunctionArgument)\
_(GuardBoundFunctionIsConstructor)\
_(LoadArrayBufferByteLengthInt32Result)\
_(LoadArrayBufferByteLengthDoubleResult)\
_(LoadArrayBufferViewLengthInt32Result)\
_(LoadArrayBufferViewLengthDoubleResult)\
_(LoadArrayBufferViewLength)\
_(LinearizeForCharAccess)\
_(LinearizeForCodePointAccess)\
_(ToRelativeStringIndex)\
_(LoadStringCharResult)\
_(LoadStringAtResult)\
_(LoadStringCharCodeResult)\
_(LoadStringCodePointResult)\
_(LoadStringLengthResult)\
_(FrameIsConstructingResult)\
_(LoadObjectResult)\
_(LoadStringResult)\
_(LoadSymbolResult)\
_(LoadInt32Result)\
_(LoadDoubleResult)\
_(LoadBigIntResult)\
_(CallScriptedGetterResult)\
_(CallInlinedGetterResult)\
_(CallNativeGetterResult)\
_(CallDOMGetterResult)\
_(ProxyGetResult)\
_(ProxyGetByValueResult)\
_(ProxyHasPropResult)\
_(CallObjectHasSparseElementResult)\
_(CallNativeGetElementResult)\
_(CallNativeGetElementSuperResult)\
_(GetNextMapSetEntryForIteratorResult)\
_(LoadUndefinedResult)\
_(LoadBooleanResult)\
_(LoadInt32Constant)\
_(LoadInt32AsIntPtrConstant)\
_(LoadDoubleConstant)\
_(LoadBooleanConstant)\
_(LoadUndefined)\
_(LoadConstantString)\
_(LoadConstantStringResult)\
_(LoadInstanceOfObjectResult)\
_(LoadTypeOfObjectResult)\
_(LoadTypeOfEqObjectResult)\
_(DoubleAddResult)\
_(DoubleSubResult)\
_(DoubleMulResult)\
_(DoubleDivResult)\
_(DoubleModResult)\
_(DoublePowResult)\
_(Int32AddResult)\
_(Int32SubResult)\
_(Int32MulResult)\
_(Int32DivResult)\
_(Int32ModResult)\
_(Int32PowResult)\
_(BigIntAddResult)\
_(BigIntSubResult)\
_(BigIntMulResult)\
_(BigIntDivResult)\
_(BigIntModResult)\
_(BigIntPowResult)\
_(BigIntToIntPtr)\
_(IntPtrToBigIntResult)\
_(BigIntPtrAdd)\
_(BigIntPtrSub)\
_(BigIntPtrMul)\
_(BigIntPtrDiv)\
_(BigIntPtrMod)\
_(BigIntPtrPow)\
_(Int32BitOrResult)\
_(Int32BitXorResult)\
_(Int32BitAndResult)\
_(Int32LeftShiftResult)\
_(Int32RightShiftResult)\
_(Int32URightShiftResult)\
_(Int32NotResult)\
_(BigIntBitOrResult)\
_(BigIntBitXorResult)\
_(BigIntBitAndResult)\
_(BigIntLeftShiftResult)\
_(BigIntRightShiftResult)\
_(BigIntNotResult)\
_(BigIntPtrBitOr)\
_(BigIntPtrBitXor)\
_(BigIntPtrBitAnd)\
_(BigIntPtrLeftShift)\
_(BigIntPtrRightShift)\
_(BigIntPtrNot)\
_(Int32NegationResult)\
_(DoubleNegationResult)\
_(BigIntNegationResult)\
_(BigIntPtrNegation)\
_(Int32IncResult)\
_(Int32DecResult)\
_(DoubleIncResult)\
_(DoubleDecResult)\
_(BigIntIncResult)\
_(BigIntDecResult)\
_(BigIntPtrInc)\
_(BigIntPtrDec)\
_(LoadInt32TruthyResult)\
_(LoadDoubleTruthyResult)\
_(LoadStringTruthyResult)\
_(LoadObjectTruthyResult)\
_(LoadBigIntTruthyResult)\
_(LoadValueTruthyResult)\
_(LoadValueResult)\
_(UncheckedLoadWeakValueResult)\
_(UncheckedLoadWeakObjectResult)\
_(LoadOperandResult)\
_(NewPlainObjectResult)\
_(NewArrayObjectResult)\
_(NewFunctionCloneResult)\
_(ConcatStringsResult)\
_(CompareStringResult)\
_(CompareObjectResult)\
_(CompareSymbolResult)\
_(CompareInt32Result)\
_(CompareDoubleResult)\
_(CompareBigIntResult)\
_(CompareBigIntInt32Result)\
_(CompareBigIntNumberResult)\
_(CompareBigIntStringResult)\
_(CompareNullUndefinedResult)\
_(CompareDoubleSameValueResult)\
_(SameValueResult)\
_(IndirectTruncateInt32Result)\
_(BigIntAsIntNResult)\
_(BigIntAsUintNResult)\
_(SetHasResult)\
_(SetHasNonGCThingResult)\
_(SetHasStringResult)\
_(SetHasSymbolResult)\
_(SetHasBigIntResult)\
_(SetHasObjectResult)\
_(SetDeleteResult)\
_(SetAddResult)\
_(SetSizeResult)\
_(MapHasResult)\
_(MapHasNonGCThingResult)\
_(MapHasStringResult)\
_(MapHasSymbolResult)\
_(MapHasBigIntResult)\
_(MapHasObjectResult)\
_(MapGetResult)\
_(MapGetNonGCThingResult)\
_(MapGetStringResult)\
_(MapGetSymbolResult)\
_(MapGetBigIntResult)\
_(MapGetObjectResult)\
_(MapDeleteResult)\
_(MapSetResult)\
_(MapSizeResult)\
_(WeakMapGetObjectResult)\
_(WeakMapHasObjectResult)\
_(WeakSetHasObjectResult)\
_(DateFillLocalTimeSlots)\
_(DateHoursFromSecondsIntoYearResult)\
_(DateMinutesFromSecondsIntoYearResult)\
_(DateSecondsFromSecondsIntoYearResult)\
_(ArrayFromArgumentsObjectResult)\
_(CloseIterScriptedResult)\
_(Bailout)\
_(AssertFloat32Result)\
_(AssertRecoveredOnBailoutResult)\
_(AssertPropertyLookup)

#define CACHE_IR_SPEWER_GENERATED \
void spewReturnFromIC(CacheIRReader& reader) {\
  spewOp(CacheOp::ReturnFromIC);\
  spewOpEnd();\
}\
\
void spewGuardToObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToObject);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNullOrUndefined(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNullOrUndefined);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNull(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNull);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsUndefined(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsUndefined);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNotUninitializedLexical(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNotUninitializedLexical);\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToBoolean(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToBoolean);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToString(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToString);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToSymbol(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToSymbol);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToBigInt(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToBigInt);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNumber(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNumber);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToInt32);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToNonGCThing(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToNonGCThing);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardBooleanToInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardBooleanToInt32);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardToInt32Index(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToInt32Index);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32ToIntPtr(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32ToIntPtr);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewGuardNumberToIntPtrIndex(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNumberToIntPtrIndex);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewBoolImm("supportOOB", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToInt32ModUint32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToInt32ModUint32);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardToUint8Clamped(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToUint8Clamped);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardNonDoubleType(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNonDoubleType);\
  spewOperandId("inputId", reader.valOperandId());\
  spewArgSeparator();\
  spewValueTypeImm("type", reader.valueType());\
  spewOpEnd();\
}\
\
void spewGuardShape(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardShape);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardMultipleShapes(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardMultipleShapes);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("shapesOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardProto(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("protoOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardNullProto(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNullProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardClass(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardClass);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewGuardClassKindImm("kind", reader.guardClassKind());\
  spewOpEnd();\
}\
\
void spewGuardFuse(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFuse);\
  spewRealmFuseIndexImm("fuseWord", reader.realmFuseIndex());\
  spewOpEnd();\
}\
\
void spewGuardRuntimeFuse(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardRuntimeFuse);\
  spewRuntimeFuseIndexImm("fuseWord", reader.runtimeFuseIndex());\
  spewOpEnd();\
}\
\
void spewGuardObjectFuseProperty(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardObjectFuseProperty);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("objFuseOwnerOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("objFuseOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("expectedGenerationOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("propIndexOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("propMaskOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("canUseFastPath", reader.readBool());\
  spewOpEnd();\
}\
\
void spewGuardAnyClass(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardAnyClass);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("claspOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardGlobalGeneration(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardGlobalGeneration);\
  spewField("expectedOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("generationAddrOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewHasClassResult(CacheIRReader& reader) {\
  spewOp(CacheOp::HasClassResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("claspOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewHasShapeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::HasShapeResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallRegExpMatcherResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallRegExpMatcherResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("lastIndexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewField("stubOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallRegExpSearcherResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallRegExpSearcherResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("lastIndexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewField("stubOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewRegExpSearcherLastLimitResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpSearcherLastLimitResult);\
  spewOpEnd();\
}\
\
void spewRegExpHasCaptureGroupsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpHasCaptureGroupsResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewRegExpBuiltinExecMatchResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpBuiltinExecMatchResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewArgSeparator();\
  spewField("stubOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewRegExpBuiltinExecTestResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpBuiltinExecTestResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.stringOperandId());\
  spewArgSeparator();\
  spewField("stubOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewRegExpFlagResult(CacheIRReader& reader) {\
  spewOp(CacheOp::RegExpFlagResult);\
  spewOperandId("regexpId", reader.objOperandId());\
  spewArgSeparator();\
  spewInt32Imm("flagsMask", reader.int32Immediate());\
  spewOpEnd();\
}\
\
void spewCallSubstringKernelResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallSubstringKernelResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("beginId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewStringReplaceStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringReplaceStringResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("patternId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("replacementId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringSplitStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringSplitStringResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("separatorId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewGetFirstDollarIndexResult(CacheIRReader& reader) {\
  spewOp(CacheOp::GetFirstDollarIndexResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewGuardCompartment(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardCompartment);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("globalOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("compartmentOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardIsExtensible(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsExtensible);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNativeObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNativeObject);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsProxy(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsProxy);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNotProxy(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNotProxy);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToArrayBuffer(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToArrayBuffer);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardToSharedArrayBuffer(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardToSharedArrayBuffer);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNotArrayBufferMaybeShared);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsTypedArray(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsTypedArray);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsNonResizableTypedArray(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNonResizableTypedArray);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIsResizableTypedArray(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsResizableTypedArray);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardHasProxyHandler(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardHasProxyHandler);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("handlerOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardIsNotDOMProxy(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIsNotDOMProxy);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardSpecificObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificObject);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardObjectIdentity(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardObjectIdentity);\
  spewOperandId("obj1Id", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("obj2Id", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardSpecificFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificFunction);\
  spewOperandId("funId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardFunctionScript(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionScript);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardSpecificAtom(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificAtom);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardSpecificSymbol(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificSymbol);\
  spewOperandId("symId", reader.symbolOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardSpecificInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificInt32);\
  spewOperandId("numId", reader.int32OperandId());\
  spewArgSeparator();\
  spewInt32Imm("expected", reader.int32Immediate());\
  spewOpEnd();\
}\
\
void spewGuardSpecificValue(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardSpecificValue);\
  spewOperandId("valId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("expectedOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardNoDenseElements(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNoDenseElements);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardStringToIndex(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardStringToIndex);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardStringToInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardStringToInt32);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardStringToNumber(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardStringToNumber);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewStringToAtom(CacheIRReader& reader) {\
  spewOp(CacheOp::StringToAtom);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewBooleanToNumber(CacheIRReader& reader) {\
  spewOp(CacheOp::BooleanToNumber);\
  spewOperandId("booleanId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewLoadGetterSetterFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadGetterSetterFunction);\
  spewOperandId("getterSetterId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("isGetter", reader.readBool());\
  spewArgSeparator();\
  spewBoolImm("needsClassGuard", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardHasGetterSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardHasGetterSetter);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("idOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("getterSetterOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardInt32IsNonNegative(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardInt32IsNonNegative);\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardIntPtrIsNonNegative(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIntPtrIsNonNegative);\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIndexIsValidUpdateOrAdd);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardIndexIsNotDenseElement(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardIndexIsNotDenseElement);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewGuardTagNotEqual(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardTagNotEqual);\
  spewOperandId("lhsId", reader.valueTagOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valueTagOperandId());\
  spewOpEnd();\
}\
\
void spewGuardXrayExpandoShapeAndDefaultProto(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardXrayExpandoShapeAndDefaultProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("shapeWrapperOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardXrayNoExpando(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardXrayNoExpando);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardDynamicSlotIsSpecificObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardDynamicSlotIsSpecificObject);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("expectedId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("slotOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardDynamicSlotIsNotObject(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardDynamicSlotIsNotObject);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("slotOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardFixedSlotValue(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFixedSlotValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardDynamicSlotValue(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardDynamicSlotValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCheckWeakValueResultForFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::CheckWeakValueResultForFixedSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCheckWeakValueResultForDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::CheckWeakValueResultForDynamicSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadScriptedProxyHandler(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadScriptedProxyHandler);\
  spewOperandId("resultId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewIdToStringOrSymbol(CacheIRReader& reader) {\
  spewOp(CacheOp::IdToStringOrSymbol);\
  spewOperandId("resultId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFixedSlot);\
  spewOperandId("resultId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDynamicSlot);\
  spewOperandId("resultId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("slotOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardNoAllocationMetadataBuilder(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNoAllocationMetadataBuilder);\
  spewField("builderAddrOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardFunctionHasJitEntry(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionHasJitEntry);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardFunctionHasNoJitEntry(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionHasNoJitEntry);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionIsNonBuiltinCtor);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardFunctionIsConstructor(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardFunctionIsConstructor);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardNotClassConstructor(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardNotClassConstructor);\
  spewOperandId("funId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardArrayIsPacked(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardArrayIsPacked);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardArgumentsObjectFlags(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardArgumentsObjectFlags);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewByteImm("flags", reader.readByte());\
  spewOpEnd();\
}\
\
void spewGuardObjectHasSameRealm(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardObjectHasSameRealm);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadObject(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadObject);\
  spewOperandId("resultId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("objOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadProtoObject(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadProtoObject);\
  spewOperandId("resultId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("protoObjOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("receiverObjId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadProto(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadProto);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadEnclosingEnvironment(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadEnclosingEnvironment);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadWrapperTarget(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadWrapperTarget);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("fallible", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadValueTag(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadValueTag);\
  spewOperandId("valId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valueTagOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentFixedSlot);\
  spewOperandId("resultId", reader.valOperandId());\
  spewArgSeparator();\
  spewByteImm("slotIndex", reader.readByte());\
  spewOpEnd();\
}\
\
void spewLoadArgumentDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentDynamicSlot);\
  spewOperandId("resultId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewByteImm("slotIndex", reader.readByte());\
  spewOpEnd();\
}\
\
void spewTruncateDoubleToUInt32(CacheIRReader& reader) {\
  spewOp(CacheOp::TruncateDoubleToUInt32);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewDoubleToUint8Clamped(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleToUint8Clamped);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMegamorphicLoadSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicLoadSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("nameOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewMegamorphicLoadSlotByValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicLoadSlotByValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMegamorphicLoadSlotPermissiveResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicLoadSlotPermissiveResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("nameOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewMegamorphicLoadSlotByValuePermissiveResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicLoadSlotByValuePermissiveResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMegamorphicStoreSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicStoreSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("nameOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewMegamorphicSetElement(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicSetElement);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewMegamorphicHasPropResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MegamorphicHasPropResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("hasOwn", reader.readBool());\
  spewOpEnd();\
}\
\
void spewSmallObjectVariableKeyHasOwnResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SmallObjectVariableKeyHasOwnResult);\
  spewOperandId("idId", reader.stringOperandId());\
  spewArgSeparator();\
  spewField("propNamesOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewObjectToIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ObjectToIteratorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("enumeratorsAddrOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewValueToIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ValueToIteratorResult);\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDOMExpandoValue(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDOMExpandoValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDOMExpandoValueGuardGeneration);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("expandoAndGenerationOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("generationOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDOMExpandoValueIgnoreGeneration);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardDOMExpandoMissingOrGuardShape);\
  spewOperandId("expandoId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewStoreFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreFixedSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewStoreDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDynamicSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewAddAndStoreFixedSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::AddAndStoreFixedSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("newShapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("preserveWrapper", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAddAndStoreDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::AddAndStoreDynamicSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("newShapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("preserveWrapper", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAllocateAndStoreDynamicSlot(CacheIRReader& reader) {\
  spewOp(CacheOp::AllocateAndStoreDynamicSlot);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("newShapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("numNewSlotsOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("preserveWrapper", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAddSlotAndCallAddPropHook(CacheIRReader& reader) {\
  spewOp(CacheOp::AddSlotAndCallAddPropHook);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("newShapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewStoreDenseElement(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDenseElement);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("expectPackedElements", reader.readBool());\
  spewOpEnd();\
}\
\
void spewStoreDenseElementHole(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDenseElementHole);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("handleAdd", reader.readBool());\
  spewOpEnd();\
}\
\
void spewArrayPush(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayPush);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewArrayJoinResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayJoinResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("sepId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewObjectKeysResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ObjectKeysResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("resultShapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewPackedArrayPopResult(CacheIRReader& reader) {\
  spewOp(CacheOp::PackedArrayPopResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewPackedArrayShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::PackedArrayShiftResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewPackedArraySliceResult(CacheIRReader& reader) {\
  spewOp(CacheOp::PackedArraySliceResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("arrayId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("beginId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("endId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewArgumentsSliceResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ArgumentsSliceResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("argsId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("beginId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("endId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewIsArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsArrayResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewStoreFixedSlotUndefinedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreFixedSlotUndefinedResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIsObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsObjectResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIsPackedArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsPackedArrayResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewIsCallableResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsCallableResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIsConstructorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsConstructorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewIsCrossRealmArrayConstructorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsCrossRealmArrayConstructorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewIsTypedArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsTypedArrayResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isPossiblyWrapped", reader.readBool());\
  spewOpEnd();\
}\
\
void spewIsTypedArrayConstructorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IsTypedArrayConstructorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayBufferViewByteOffsetInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayBufferViewByteOffsetDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArrayByteLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArrayByteLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewResizableTypedArrayByteLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::ResizableTypedArrayByteLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewResizableTypedArrayByteLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ResizableTypedArrayByteLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewResizableTypedArrayLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::ResizableTypedArrayLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewResizableTypedArrayLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ResizableTypedArrayLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewResizableDataViewByteLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::ResizableDataViewByteLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewResizableDataViewByteLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ResizableDataViewByteLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGrowableSharedArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::GrowableSharedArrayBufferByteLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGrowableSharedArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::GrowableSharedArrayBufferByteLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardHasAttachedArrayBuffer(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardHasAttachedArrayBuffer);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardResizableArrayBufferViewInBounds(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardResizableArrayBufferViewInBounds);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewGuardResizableArrayBufferViewInBoundsOrDetached(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardResizableArrayBufferViewInBoundsOrDetached);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewTypedArrayFillResult(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArrayFillResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewRawOperandId("fillValueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewOperandId("startId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("endId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewOpEnd();\
}\
\
void spewTypedArraySetResult(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArraySetResult);\
  spewOperandId("targetId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("sourceId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("offsetId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewBoolImm("canUseBitwiseCopy", reader.readBool());\
  spewOpEnd();\
}\
\
void spewTypedArraySubarrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::TypedArraySubarrayResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("startId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("endId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewNewArrayIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewArrayIteratorResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewStringIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewStringIteratorResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewRegExpStringIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewRegExpStringIteratorResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewObjectCreateResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ObjectCreateResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewArrayFromLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewArrayFromLengthResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.int32OperandId());\
  spewArgSeparator();\
  spewField("siteOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewTypedArrayFromLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewTypedArrayFromLengthResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewNewTypedArrayFromArrayBufferResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewTypedArrayFromArrayBufferResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("bufferId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("byteOffsetId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("lengthId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewNewTypedArrayFromArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewTypedArrayFromArrayResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("arrayId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewNewMapObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewMapObjectResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewSetObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewSetObjectResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewMapObjectFromIterableResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewMapObjectFromIterableResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("iterableId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewNewSetObjectFromIterableResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewSetObjectFromIterableResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("iterableId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewNewStringObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewStringObjectResult);\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringFromCharCodeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringFromCharCodeResult);\
  spewOperandId("codeId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewStringFromCodePointResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringFromCodePointResult);\
  spewOperandId("codeId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewStringIncludesResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringIncludesResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("searchStrId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringIndexOfResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringIndexOfResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("searchStrId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringLastIndexOfResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringLastIndexOfResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("searchStrId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringStartsWithResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringStartsWithResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("searchStrId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringEndsWithResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringEndsWithResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("searchStrId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringToLowerCaseResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringToLowerCaseResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringToUpperCaseResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringToUpperCaseResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringTrimResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringTrimResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringTrimStartResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringTrimStartResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewStringTrimEndResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StringTrimEndResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewMathAbsInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathAbsInt32Result);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathAbsNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathAbsNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathClz32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathClz32Result);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathSignInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSignInt32Result);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathSignNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSignNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathSignNumberToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSignNumberToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathImulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathImulResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewMathSqrtNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathSqrtNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathFRoundNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFRoundNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathF16RoundNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathF16RoundNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathRandomResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathRandomResult);\
  spewField("rngOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewMathHypot2NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathHypot2NumberResult);\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathHypot3NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathHypot3NumberResult);\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("thirdId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathHypot4NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathHypot4NumberResult);\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("thirdId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("fourthId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathAtan2NumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathAtan2NumberResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathFloorNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFloorNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathCeilNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathCeilNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathTruncNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathTruncNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathRoundNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathRoundNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathFloorToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFloorToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathCeilToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathCeilToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathTruncToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathTruncToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewMathRoundToInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::MathRoundToInt32Result);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewInt32MinMax(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32MinMax);\
  spewBoolImm("isMax", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("firstId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewNumberMinMax(CacheIRReader& reader) {\
  spewOp(CacheOp::NumberMinMax);\
  spewBoolImm("isMax", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("firstId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("secondId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewInt32MinMaxArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32MinMaxArrayResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isMax", reader.readBool());\
  spewOpEnd();\
}\
\
void spewNumberMinMaxArrayResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NumberMinMaxArrayResult);\
  spewOperandId("arrayId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isMax", reader.readBool());\
  spewOpEnd();\
}\
\
void spewMathFunctionNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MathFunctionNumberResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewUnaryMathFunctionImm("fun", reader.unaryMathFunction());\
  spewOpEnd();\
}\
\
void spewNumberParseIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NumberParseIntResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("radixId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewDoubleParseIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleParseIntResult);\
  spewOperandId("numId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewObjectToStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ObjectToStringResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewReflectGetPrototypeOfResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ReflectGetPrototypeOfResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewStoreTypedArrayElement(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreTypedArrayElement);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("rhsId", reader.rawOperandId());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsCompareExchangeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsCompareExchangeResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("expectedId", reader.rawOperandId());\
  spewArgSeparator();\
  spewRawOperandId("replacementId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsExchangeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsExchangeResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsAddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsAddResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsSubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsSubResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsAndResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsAndResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsOrResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsOrResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsXorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsXorResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forEffect", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsLoadResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsLoadResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsStoreResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsStoreResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewAtomicsIsLockFreeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsIsLockFreeResult);\
  spewOperandId("valueId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewAtomicsPauseResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AtomicsPauseResult);\
  spewOpEnd();\
}\
\
void spewCallNativeSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeSetter);\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("setterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallScriptedSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedSetter);\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallInlinedSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInlinedSetter);\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("icScriptOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallDOMSetter(CacheIRReader& reader) {\
  spewOp(CacheOp::CallDOMSetter);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("jitInfoOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCallSetArrayLength(CacheIRReader& reader) {\
  spewOp(CacheOp::CallSetArrayLength);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewProxySet(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxySet);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("idOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewProxySetByValue(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxySetByValue);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallAddOrUpdateSparseElementHelper(CacheIRReader& reader) {\
  spewOp(CacheOp::CallAddOrUpdateSparseElementHelper);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("strict", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallInt32ToString(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInt32ToString);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCallNumberToString(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNumberToString);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewInt32ToStringWithBaseResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32ToStringWithBaseResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("baseId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewBooleanToString(CacheIRReader& reader) {\
  spewOp(CacheOp::BooleanToString);\
  spewOperandId("inputId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCallScriptedFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("argcFixed", reader.uint32Immediate());\
  spewOpEnd();\
}\
\
void spewCallBoundScriptedFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallBoundScriptedFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("targetId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("numBoundArgs", reader.uint32Immediate());\
  spewOpEnd();\
}\
\
void spewCallWasmFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallWasmFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("argcFixed", reader.uint32Immediate());\
  spewArgSeparator();\
  spewField("funcTypeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("instanceOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewGuardWasmArg(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardWasmArg);\
  spewOperandId("argId", reader.valOperandId());\
  spewArgSeparator();\
  spewWasmValTypeImm("type", reader.wasmValType());\
  spewOpEnd();\
}\
\
void spewCallNativeFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("argcFixed", reader.uint32Immediate());\
  spewArgSeparator();\
  spewBoolImm("ignoresReturnValue", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallDOMFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallDOMFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("thisObjId", reader.objOperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("argcFixed", reader.uint32Immediate());\
  spewOpEnd();\
}\
\
void spewCallDOMFunctionWithAllocSite(CacheIRReader& reader) {\
  spewOp(CacheOp::CallDOMFunctionWithAllocSite);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("thisObjId", reader.objOperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("argcFixed", reader.uint32Immediate());\
  spewArgSeparator();\
  spewField("siteOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallClassHook(CacheIRReader& reader) {\
  spewOp(CacheOp::CallClassHook);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("argcFixed", reader.uint32Immediate());\
  spewArgSeparator();\
  spewField("targetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallInlinedFunction(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInlinedFunction);\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("argcId", reader.int32OperandId());\
  spewArgSeparator();\
  spewField("icScriptOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewCallFlagsImm("flags", reader.callFlags());\
  spewArgSeparator();\
  spewUInt32Imm("argcFixed", reader.uint32Immediate());\
  spewOpEnd();\
}\
\
void spewCallScriptedProxyGetResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedProxyGetResult);\
  spewOperandId("targetId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("handlerId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("trapId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("propertyOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewUInt32Imm("nargsAndFlags", reader.uint32Immediate());\
  spewOpEnd();\
}\
\
void spewCallScriptedProxyGetByValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedProxyGetByValueResult);\
  spewOperandId("targetId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("receiverId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("handlerId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("propertyId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("trapId", reader.objOperandId());\
  spewArgSeparator();\
  spewUInt32Imm("nargsAndFlags", reader.uint32Immediate());\
  spewOpEnd();\
}\
\
void spewMetaScriptedThisShape(CacheIRReader& reader) {\
  spewOp(CacheOp::MetaScriptedThisShape);\
  spewField("thisShapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewBindFunctionResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BindFunctionResult);\
  spewOperandId("targetId", reader.objOperandId());\
  spewArgSeparator();\
  spewUInt32Imm("argc", reader.uint32Immediate());\
  spewArgSeparator();\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewSpecializedBindFunctionResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SpecializedBindFunctionResult);\
  spewOperandId("targetId", reader.objOperandId());\
  spewArgSeparator();\
  spewUInt32Imm("argc", reader.uint32Immediate());\
  spewArgSeparator();\
  spewField("templateObjectOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadFixedSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFixedSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadFixedSlotTypedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFixedSlotTypedResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewValueTypeImm("type", reader.valueType());\
  spewOpEnd();\
}\
\
void spewLoadDynamicSlotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDynamicSlotResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("offsetOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewBoolImm("expectPackedElements", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementHoleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementHoleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallGetSparseElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallGetSparseElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementExistsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementExistsResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadTypedArrayElementExistsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadTypedArrayElementExistsResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewLoadDenseElementHoleExistsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDenseElementHoleExistsResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadTypedArrayElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadTypedArrayElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewArgSeparator();\
  spewBoolImm("forceDoubleForUint32", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewLoadDataViewValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDataViewValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("offsetId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("littleEndianId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewBoolImm("forceDoubleForUint32", reader.readBool());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewStoreDataViewValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::StoreDataViewValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("offsetId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewRawOperandId("valueId", reader.rawOperandId());\
  spewArgSeparator();\
  spewOperandId("littleEndianId", reader.booleanOperandId());\
  spewArgSeparator();\
  spewScalarTypeImm("elementType", reader.scalarType());\
  spewArgSeparator();\
  spewArrayBufferViewKindImm("viewKind", reader.arrayBufferViewKind());\
  spewOpEnd();\
}\
\
void spewLoadInt32ArrayLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32ArrayLengthResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadInt32ArrayLength(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32ArrayLength);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentsObjectArgResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentsObjectArgResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentsObjectArgHoleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentsObjectArgHoleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentsObjectArgExistsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentsObjectArgExistsResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentsObjectLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentsObjectLengthResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArgumentsObjectLength(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArgumentsObjectLength);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadFunctionLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFunctionLengthResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadFunctionNameResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadFunctionNameResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadBoundFunctionNumArgs(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBoundFunctionNumArgs);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadBoundFunctionTarget(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBoundFunctionTarget);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadBoundFunctionArgument(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBoundFunctionArgument);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewUInt32Imm("index", reader.uint32Immediate());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGuardBoundFunctionIsConstructor(CacheIRReader& reader) {\
  spewOp(CacheOp::GuardBoundFunctionIsConstructor);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferByteLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferByteLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferViewLengthInt32Result);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferViewLengthDoubleResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadArrayBufferViewLength(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadArrayBufferViewLength);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewLinearizeForCharAccess(CacheIRReader& reader) {\
  spewOp(CacheOp::LinearizeForCharAccess);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewLinearizeForCodePointAccess(CacheIRReader& reader) {\
  spewOp(CacheOp::LinearizeForCodePointAccess);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewToRelativeStringIndex(CacheIRReader& reader) {\
  spewOp(CacheOp::ToRelativeStringIndex);\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringCharResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringCharResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadStringAtResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringAtResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadStringCharCodeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringCharCodeResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadStringCodePointResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringCodePointResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewBoolImm("handleOOB", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadStringLengthResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringLengthResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewFrameIsConstructingResult(CacheIRReader& reader) {\
  spewOp(CacheOp::FrameIsConstructingResult);\
  spewOpEnd();\
}\
\
void spewLoadObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadObjectResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewLoadSymbolResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadSymbolResult);\
  spewOperandId("symId", reader.symbolOperandId());\
  spewOpEnd();\
}\
\
void spewLoadInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32Result);\
  spewOperandId("valId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDoubleResult);\
  spewOperandId("valId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewLoadBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBigIntResult);\
  spewOperandId("valId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewCallScriptedGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallScriptedGetterResult);\
  spewOperandId("receiverId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallInlinedGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallInlinedGetterResult);\
  spewOperandId("receiverId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("icScriptOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallNativeGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeGetterResult);\
  spewOperandId("receiverId", reader.valOperandId());\
  spewArgSeparator();\
  spewField("getterOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewBoolImm("sameRealm", reader.readBool());\
  spewArgSeparator();\
  spewField("nargsAndFlagsOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallDOMGetterResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallDOMGetterResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("jitInfoOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewProxyGetResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxyGetResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("idOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewProxyGetByValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxyGetByValueResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewProxyHasPropResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ProxyHasPropResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("idId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("hasOwn", reader.readBool());\
  spewOpEnd();\
}\
\
void spewCallObjectHasSparseElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallObjectHasSparseElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallNativeGetElementResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeGetElementResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCallNativeGetElementSuperResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallNativeGetElementSuperResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("indexId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("receiverId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewGetNextMapSetEntryForIteratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::GetNextMapSetEntryForIteratorResult);\
  spewOperandId("iterId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("resultArrId", reader.objOperandId());\
  spewArgSeparator();\
  spewBoolImm("isMap", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadUndefinedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadUndefinedResult);\
  spewOpEnd();\
}\
\
void spewLoadBooleanResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBooleanResult);\
  spewBoolImm("val", reader.readBool());\
  spewOpEnd();\
}\
\
void spewLoadInt32Constant(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32Constant);\
  spewField("valOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewLoadInt32AsIntPtrConstant(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32AsIntPtrConstant);\
  spewField("valOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDoubleConstant(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDoubleConstant);\
  spewField("valOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewLoadBooleanConstant(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBooleanConstant);\
  spewBoolImm("val", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.booleanOperandId());\
  spewOpEnd();\
}\
\
void spewLoadUndefined(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadUndefined);\
  spewOperandId("resultId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadConstantString(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadConstantString);\
  spewField("strOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewLoadConstantStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadConstantStringResult);\
  spewField("strOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadInstanceOfObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInstanceOfObjectResult);\
  spewOperandId("lhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("protoId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadTypeOfObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadTypeOfObjectResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadTypeOfEqObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadTypeOfEqObjectResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewTypeofEqOperandImm("operand", reader.typeofEqOperand());\
  spewOpEnd();\
}\
\
void spewDoubleAddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleAddResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleSubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleSubResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleMulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleMulResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleDivResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleDivResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleModResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleModResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoublePowResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoublePowResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewInt32AddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32AddResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32SubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32SubResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32MulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32MulResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32DivResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32DivResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32ModResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32ModResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32PowResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32PowResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewBigIntAddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntAddResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntSubResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntSubResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntMulResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntMulResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntDivResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntDivResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntModResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntModResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPowResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPowResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntToIntPtr(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntToIntPtr);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewIntPtrToBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::IntPtrToBigIntResult);\
  spewOperandId("inputId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrAdd(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrAdd);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrSub(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrSub);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrMul(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrMul);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrDiv(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrDiv);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrMod(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrMod);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrPow(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrPow);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewInt32BitOrResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32BitOrResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32BitXorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32BitXorResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32BitAndResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32BitAndResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32LeftShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32LeftShiftResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32RightShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32RightShiftResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32URightShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32URightShiftResult);\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewBoolImm("forceDouble", reader.readBool());\
  spewOpEnd();\
}\
\
void spewInt32NotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32NotResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewBigIntBitOrResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntBitOrResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntBitXorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntBitXorResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntBitAndResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntBitAndResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntLeftShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntLeftShiftResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntRightShiftResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntRightShiftResult);\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntNotResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntNotResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrBitOr(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrBitOr);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrBitXor(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrBitXor);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrBitAnd(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrBitAnd);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrLeftShift(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrLeftShift);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrRightShift(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrRightShift);\
  spewOperandId("lhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrNot(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrNot);\
  spewOperandId("inputId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewInt32NegationResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32NegationResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewDoubleNegationResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleNegationResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntNegationResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntNegationResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrNegation(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrNegation);\
  spewOperandId("inputId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewInt32IncResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32IncResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewInt32DecResult(CacheIRReader& reader) {\
  spewOp(CacheOp::Int32DecResult);\
  spewOperandId("inputId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewDoubleIncResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleIncResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewDoubleDecResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DoubleDecResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntIncResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntIncResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntDecResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntDecResult);\
  spewOperandId("inputId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrInc(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrInc);\
  spewOperandId("inputId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntPtrDec(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntPtrDec);\
  spewOperandId("inputId", reader.intPtrOperandId());\
  spewArgSeparator();\
  spewOperandId("resultId", reader.intPtrOperandId());\
  spewOpEnd();\
}\
\
void spewLoadInt32TruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadInt32TruthyResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadDoubleTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadDoubleTruthyResult);\
  spewOperandId("inputId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewLoadStringTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadStringTruthyResult);\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewLoadObjectTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadObjectTruthyResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewLoadBigIntTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadBigIntTruthyResult);\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewLoadValueTruthyResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadValueTruthyResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewLoadValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadValueResult);\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewUncheckedLoadWeakValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::UncheckedLoadWeakValueResult);\
  spewField("valOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewUncheckedLoadWeakObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::UncheckedLoadWeakObjectResult);\
  spewField("objOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewLoadOperandResult(CacheIRReader& reader) {\
  spewOp(CacheOp::LoadOperandResult);\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewNewPlainObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewPlainObjectResult);\
  spewUInt32Imm("numFixedSlots", reader.uint32Immediate());\
  spewArgSeparator();\
  spewUInt32Imm("numDynamicSlots", reader.uint32Immediate());\
  spewArgSeparator();\
  spewAllocKindImm("allocKind", reader.allocKind());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("siteOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewArrayObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewArrayObjectResult);\
  spewUInt32Imm("arrayLength", reader.uint32Immediate());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("siteOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewNewFunctionCloneResult(CacheIRReader& reader) {\
  spewOp(CacheOp::NewFunctionCloneResult);\
  spewField("canonicalOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewAllocKindImm("allocKind", reader.allocKind());\
  spewArgSeparator();\
  spewField("siteOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewConcatStringsResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ConcatStringsResult);\
  spewOperandId("lhsId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.stringOperandId());\
  spewArgSeparator();\
  spewField("stubOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCallStringObjectConcatResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallStringObjectConcatResult);\
  spewOperandId("lhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCallIsSuspendedGeneratorResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CallIsSuspendedGeneratorResult);\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCompareStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareStringResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.stringOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCompareObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareObjectResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewCompareSymbolResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareSymbolResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.symbolOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.symbolOperandId());\
  spewOpEnd();\
}\
\
void spewCompareInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareInt32Result);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCompareDoubleResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareDoubleResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntInt32Result);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntNumberResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntNumberResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewCompareBigIntStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareBigIntStringResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewOperandId("lhsId", reader.bigIntOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewCompareNullUndefinedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareNullUndefinedResult);\
  spewJSOpImm("op", reader.jsop());\
  spewArgSeparator();\
  spewBoolImm("isUndefined", reader.readBool());\
  spewArgSeparator();\
  spewOperandId("inputId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewCompareDoubleSameValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CompareDoubleSameValueResult);\
  spewOperandId("lhsId", reader.numberOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.numberOperandId());\
  spewOpEnd();\
}\
\
void spewSameValueResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SameValueResult);\
  spewOperandId("lhsId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("rhsId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewIndirectTruncateInt32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::IndirectTruncateInt32Result);\
  spewOperandId("valId", reader.int32OperandId());\
  spewOpEnd();\
}\
\
void spewBigIntAsIntNResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntAsIntNResult);\
  spewOperandId("bitsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewBigIntAsUintNResult(CacheIRReader& reader) {\
  spewOp(CacheOp::BigIntAsUintNResult);\
  spewOperandId("bitsId", reader.int32OperandId());\
  spewArgSeparator();\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewSetHasResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetHasResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewSetHasNonGCThingResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetHasNonGCThingResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewSetHasStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetHasStringResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewSetHasSymbolResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetHasSymbolResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("symId", reader.symbolOperandId());\
  spewOpEnd();\
}\
\
void spewSetHasBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetHasBigIntResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewSetHasObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetHasObjectResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewSetDeleteResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetDeleteResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewSetAddResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetAddResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("keyId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewSetSizeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::SetSizeResult);\
  spewOperandId("setId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewMapHasResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapHasResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMapHasNonGCThingResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapHasNonGCThingResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMapHasStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapHasStringResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewMapHasSymbolResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapHasSymbolResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("symId", reader.symbolOperandId());\
  spewOpEnd();\
}\
\
void spewMapHasBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapHasBigIntResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewMapHasObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapHasObjectResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewMapGetResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapGetResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMapGetNonGCThingResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapGetNonGCThingResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMapGetStringResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapGetStringResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("strId", reader.stringOperandId());\
  spewOpEnd();\
}\
\
void spewMapGetSymbolResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapGetSymbolResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("symId", reader.symbolOperandId());\
  spewOpEnd();\
}\
\
void spewMapGetBigIntResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapGetBigIntResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("bigIntId", reader.bigIntOperandId());\
  spewOpEnd();\
}\
\
void spewMapGetObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapGetObjectResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewMapDeleteResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapDeleteResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMapSetResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapSetResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("keyId", reader.valOperandId());\
  spewArgSeparator();\
  spewOperandId("valId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewMapSizeResult(CacheIRReader& reader) {\
  spewOp(CacheOp::MapSizeResult);\
  spewOperandId("mapId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewWeakMapGetObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::WeakMapGetObjectResult);\
  spewOperandId("weakMapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewWeakMapHasObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::WeakMapHasObjectResult);\
  spewOperandId("weakMapId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewWeakSetHasObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::WeakSetHasObjectResult);\
  spewOperandId("weakSetId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("objId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewDateFillLocalTimeSlots(CacheIRReader& reader) {\
  spewOp(CacheOp::DateFillLocalTimeSlots);\
  spewOperandId("dateId", reader.objOperandId());\
  spewOpEnd();\
}\
\
void spewDateHoursFromSecondsIntoYearResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DateHoursFromSecondsIntoYearResult);\
  spewOperandId("secondsIntoYearId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewDateMinutesFromSecondsIntoYearResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DateMinutesFromSecondsIntoYearResult);\
  spewOperandId("secondsIntoYearId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewDateSecondsFromSecondsIntoYearResult(CacheIRReader& reader) {\
  spewOp(CacheOp::DateSecondsFromSecondsIntoYearResult);\
  spewOperandId("secondsIntoYearId", reader.valOperandId());\
  spewOpEnd();\
}\
\
void spewArrayFromArgumentsObjectResult(CacheIRReader& reader) {\
  spewOp(CacheOp::ArrayFromArgumentsObjectResult);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("shapeOffset", reader.stubOffset());\
  spewOpEnd();\
}\
\
void spewCloseIterScriptedResult(CacheIRReader& reader) {\
  spewOp(CacheOp::CloseIterScriptedResult);\
  spewOperandId("iterId", reader.objOperandId());\
  spewArgSeparator();\
  spewOperandId("calleeId", reader.objOperandId());\
  spewArgSeparator();\
  spewCompletionKindImm("kind", reader.completionKind());\
  spewArgSeparator();\
  spewUInt32Imm("targetNargs", reader.uint32Immediate());\
  spewOpEnd();\
}\
\
void spewCallPrintString(CacheIRReader& reader) {\
  spewOp(CacheOp::CallPrintString);\
  spewStaticStringImm("str", reinterpret_cast<char*>(reader.pointer()));\
  spewOpEnd();\
}\
\
void spewBreakpoint(CacheIRReader& reader) {\
  spewOp(CacheOp::Breakpoint);\
  spewOpEnd();\
}\
\
void spewWrapResult(CacheIRReader& reader) {\
  spewOp(CacheOp::WrapResult);\
  spewOpEnd();\
}\
\
void spewBailout(CacheIRReader& reader) {\
  spewOp(CacheOp::Bailout);\
  spewOpEnd();\
}\
\
void spewAssertFloat32Result(CacheIRReader& reader) {\
  spewOp(CacheOp::AssertFloat32Result);\
  spewOperandId("valId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("mustBeFloat32", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAssertRecoveredOnBailoutResult(CacheIRReader& reader) {\
  spewOp(CacheOp::AssertRecoveredOnBailoutResult);\
  spewOperandId("valId", reader.valOperandId());\
  spewArgSeparator();\
  spewBoolImm("mustBeRecovered", reader.readBool());\
  spewOpEnd();\
}\
\
void spewAssertPropertyLookup(CacheIRReader& reader) {\
  spewOp(CacheOp::AssertPropertyLookup);\
  spewOperandId("objId", reader.objOperandId());\
  spewArgSeparator();\
  spewField("idOffset", reader.stubOffset());\
  spewArgSeparator();\
  spewField("slotOffset", reader.stubOffset());\
  spewOpEnd();\
}\


#define CACHE_IR_CLONE_GENERATED \
void cloneReturnFromIC(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ReturnFromIC);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToObject);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNullOrUndefined(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNullOrUndefined);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNull(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNull);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsUndefined(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsUndefined);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNotUninitializedLexical(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNotUninitializedLexical);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToBoolean(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToBoolean);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToString);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToSymbol(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToSymbol);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToBigInt(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToBigInt);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNumber(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNumber);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToInt32);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToNonGCThing(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToNonGCThing);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardBooleanToInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardBooleanToInt32);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToInt32Index(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToInt32Index);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32ToIntPtr(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32ToIntPtr);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNumberToIntPtrIndex(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNumberToIntPtrIndex);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  bool supportOOB = reader.readBool();\
  writer.writeBoolImm(supportOOB);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToInt32ModUint32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToInt32ModUint32);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToUint8Clamped(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToUint8Clamped);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNonDoubleType(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNonDoubleType);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  ValueType type = reader.valueType();\
  writer.writeValueTypeImm(type);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardShape(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardShape);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getWeakShapeField(shapeOffset);\
  writer.writeWeakShapeField(shape);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardMultipleShapes(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardMultipleShapes);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t shapesOffset = reader.stubOffset();\
  JSObject* shapes = getObjectField(shapesOffset);\
  writer.writeObjectField(shapes);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t protoOffset = reader.stubOffset();\
  JSObject* proto = getWeakObjectField(protoOffset);\
  writer.writeWeakObjectField(proto);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNullProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNullProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardClass(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardClass);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  GuardClassKind kind = reader.guardClassKind();\
  writer.writeGuardClassKindImm(kind);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFuse(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFuse);\
  RealmFuses::FuseIndex fuseWord = reader.realmFuseIndex();\
  writer.writeRealmFuseIndexImm(fuseWord);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardRuntimeFuse(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardRuntimeFuse);\
  RuntimeFuses::FuseIndex fuseWord = reader.runtimeFuseIndex();\
  writer.writeRuntimeFuseIndexImm(fuseWord);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardObjectFuseProperty(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardObjectFuseProperty);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t objFuseOwnerOffset = reader.stubOffset();\
  JSObject* objFuseOwner = getWeakObjectField(objFuseOwnerOffset);\
  writer.writeWeakObjectField(objFuseOwner);\
  uint32_t objFuseOffset = reader.stubOffset();\
  const void* objFuse = getRawPointerField(objFuseOffset);\
  writer.writeRawPointerField(objFuse);\
  uint32_t expectedGenerationOffset = reader.stubOffset();\
  uint32_t expectedGeneration = getRawInt32Field(expectedGenerationOffset);\
  writer.writeRawInt32Field(expectedGeneration);\
  uint32_t propIndexOffset = reader.stubOffset();\
  uint32_t propIndex = getRawInt32Field(propIndexOffset);\
  writer.writeRawInt32Field(propIndex);\
  uint32_t propMaskOffset = reader.stubOffset();\
  uint32_t propMask = getRawInt32Field(propMaskOffset);\
  writer.writeRawInt32Field(propMask);\
  bool canUseFastPath = reader.readBool();\
  writer.writeBoolImm(canUseFastPath);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardAnyClass(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardAnyClass);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t claspOffset = reader.stubOffset();\
  const void* clasp = getRawPointerField(claspOffset);\
  writer.writeRawPointerField(clasp);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardGlobalGeneration(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardGlobalGeneration);\
  uint32_t expectedOffset = reader.stubOffset();\
  uint32_t expected = getRawInt32Field(expectedOffset);\
  writer.writeRawInt32Field(expected);\
  uint32_t generationAddrOffset = reader.stubOffset();\
  const void* generationAddr = getRawPointerField(generationAddrOffset);\
  writer.writeRawPointerField(generationAddr);\
  writer.assertLengthMatches();\
}}\
\
void cloneHasClassResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::HasClassResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t claspOffset = reader.stubOffset();\
  const void* clasp = getRawPointerField(claspOffset);\
  writer.writeRawPointerField(clasp);\
  writer.assertLengthMatches();\
}}\
\
void cloneHasShapeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::HasShapeResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallRegExpMatcherResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallRegExpMatcherResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  writer.writeOperandId(lastIndexId);\
  uint32_t stubOffset = reader.stubOffset();\
  JitCode* stub = getJitCodeField(stubOffset);\
  writer.writeJitCodeField(stub);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallRegExpSearcherResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallRegExpSearcherResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId lastIndexId = reader.int32OperandId();\
  writer.writeOperandId(lastIndexId);\
  uint32_t stubOffset = reader.stubOffset();\
  JitCode* stub = getJitCodeField(stubOffset);\
  writer.writeJitCodeField(stub);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpSearcherLastLimitResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpSearcherLastLimitResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpHasCaptureGroupsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpHasCaptureGroupsResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpBuiltinExecMatchResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpBuiltinExecMatchResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  uint32_t stubOffset = reader.stubOffset();\
  JitCode* stub = getJitCodeField(stubOffset);\
  writer.writeJitCodeField(stub);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpBuiltinExecTestResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpBuiltinExecTestResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  StringOperandId inputId = reader.stringOperandId();\
  writer.writeOperandId(inputId);\
  uint32_t stubOffset = reader.stubOffset();\
  JitCode* stub = getJitCodeField(stubOffset);\
  writer.writeJitCodeField(stub);\
  writer.assertLengthMatches();\
}}\
\
void cloneRegExpFlagResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::RegExpFlagResult);\
  ObjOperandId regexpId = reader.objOperandId();\
  writer.writeOperandId(regexpId);\
  int32_t flagsMask = reader.int32Immediate();\
  writer.writeInt32Imm(flagsMask);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallSubstringKernelResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallSubstringKernelResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId beginId = reader.int32OperandId();\
  writer.writeOperandId(beginId);\
  Int32OperandId lengthId = reader.int32OperandId();\
  writer.writeOperandId(lengthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringReplaceStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringReplaceStringResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId patternId = reader.stringOperandId();\
  writer.writeOperandId(patternId);\
  StringOperandId replacementId = reader.stringOperandId();\
  writer.writeOperandId(replacementId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringSplitStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringSplitStringResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId separatorId = reader.stringOperandId();\
  writer.writeOperandId(separatorId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGetFirstDollarIndexResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GetFirstDollarIndexResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardCompartment(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardCompartment);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t globalOffset = reader.stubOffset();\
  JSObject* global = getObjectField(globalOffset);\
  writer.writeObjectField(global);\
  uint32_t compartmentOffset = reader.stubOffset();\
  const void* compartment = getRawPointerField(compartmentOffset);\
  writer.writeRawPointerField(compartment);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsExtensible(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsExtensible);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNativeObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNativeObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsProxy(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsProxy);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNotProxy(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNotProxy);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToArrayBuffer(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToArrayBuffer);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardToSharedArrayBuffer(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardToSharedArrayBuffer);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNotArrayBufferMaybeShared(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNotArrayBufferMaybeShared);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsTypedArray(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsTypedArray);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNonResizableTypedArray(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNonResizableTypedArray);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsResizableTypedArray(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsResizableTypedArray);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardHasProxyHandler(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardHasProxyHandler);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t handlerOffset = reader.stubOffset();\
  const void* handler = getRawPointerField(handlerOffset);\
  writer.writeRawPointerField(handler);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIsNotDOMProxy(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIsNotDOMProxy);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JSObject* expected = getWeakObjectField(expectedOffset);\
  writer.writeWeakObjectField(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardObjectIdentity(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardObjectIdentity);\
  ObjOperandId obj1Id = reader.objOperandId();\
  writer.writeOperandId(obj1Id);\
  ObjOperandId obj2Id = reader.objOperandId();\
  writer.writeOperandId(obj2Id);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificFunction);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JSObject* expected = getWeakObjectField(expectedOffset);\
  writer.writeWeakObjectField(expected);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionScript(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionScript);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t expectedOffset = reader.stubOffset();\
  BaseScript* expected = getWeakBaseScriptField(expectedOffset);\
  writer.writeWeakBaseScriptField(expected);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificAtom(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificAtom);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JSAtom* expected = getAtomField(expectedOffset);\
  writer.writeStringField(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificSymbol(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificSymbol);\
  SymbolOperandId symId = reader.symbolOperandId();\
  writer.writeOperandId(symId);\
  uint32_t expectedOffset = reader.stubOffset();\
  JS::Symbol* expected = getSymbolField(expectedOffset);\
  writer.writeSymbolField(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificInt32);\
  Int32OperandId numId = reader.int32OperandId();\
  writer.writeOperandId(numId);\
  int32_t expected = reader.int32Immediate();\
  writer.writeInt32Imm(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardSpecificValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardSpecificValue);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  uint32_t expectedOffset = reader.stubOffset();\
  const Value expected = getValueField(expectedOffset);\
  writer.writeValueField(expected);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNoDenseElements(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNoDenseElements);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardStringToIndex(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardStringToIndex);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardStringToInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardStringToInt32);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardStringToNumber(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardStringToNumber);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  NumberOperandId resultId = reader.numberOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringToAtom(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringToAtom);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBooleanToNumber(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BooleanToNumber);\
  BooleanOperandId booleanId = reader.booleanOperandId();\
  writer.writeOperandId(booleanId);\
  NumberOperandId resultId = reader.numberOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadGetterSetterFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadGetterSetterFunction);\
  ValOperandId getterSetterId = reader.valOperandId();\
  writer.writeOperandId(getterSetterId);\
  bool isGetter = reader.readBool();\
  writer.writeBoolImm(isGetter);\
  bool needsClassGuard = reader.readBool();\
  writer.writeBoolImm(needsClassGuard);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardHasGetterSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardHasGetterSetter);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t idOffset = reader.stubOffset();\
  jsid id = getIdField(idOffset);\
  writer.writeIdField(id);\
  uint32_t getterSetterOffset = reader.stubOffset();\
  const Value getterSetter = getWeakValueField(getterSetterOffset);\
  writer.writeWeakValueField(getterSetter);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardInt32IsNonNegative(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardInt32IsNonNegative);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIntPtrIsNonNegative(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIntPtrIsNonNegative);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIndexIsValidUpdateOrAdd(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIndexIsValidUpdateOrAdd);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardIndexIsNotDenseElement(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardIndexIsNotDenseElement);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardTagNotEqual(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardTagNotEqual);\
  ValueTagOperandId lhsId = reader.valueTagOperandId();\
  writer.writeOperandId(lhsId);\
  ValueTagOperandId rhsId = reader.valueTagOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardXrayExpandoShapeAndDefaultProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardXrayExpandoShapeAndDefaultProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t shapeWrapperOffset = reader.stubOffset();\
  JSObject* shapeWrapper = getObjectField(shapeWrapperOffset);\
  writer.writeObjectField(shapeWrapper);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardXrayNoExpando(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardXrayNoExpando);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardDynamicSlotIsSpecificObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardDynamicSlotIsSpecificObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId expectedId = reader.objOperandId();\
  writer.writeOperandId(expectedId);\
  uint32_t slotOffset = reader.stubOffset();\
  uint32_t slot = getRawInt32Field(slotOffset);\
  writer.writeRawInt32Field(slot);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardDynamicSlotIsNotObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardDynamicSlotIsNotObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t slotOffset = reader.stubOffset();\
  uint32_t slot = getRawInt32Field(slotOffset);\
  writer.writeRawInt32Field(slot);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFixedSlotValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFixedSlotValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getValueField(valOffset);\
  writer.writeValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardDynamicSlotValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardDynamicSlotValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getValueField(valOffset);\
  writer.writeValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneCheckWeakValueResultForFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CheckWeakValueResultForFixedSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getWeakValueField(valOffset);\
  writer.writeWeakValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneCheckWeakValueResultForDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CheckWeakValueResultForDynamicSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getWeakValueField(valOffset);\
  writer.writeWeakValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadScriptedProxyHandler(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadScriptedProxyHandler);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIdToStringOrSymbol(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IdToStringOrSymbol);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFixedSlot);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDynamicSlot);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t slotOffset = reader.stubOffset();\
  uint32_t slot = getRawInt32Field(slotOffset);\
  writer.writeRawInt32Field(slot);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNoAllocationMetadataBuilder(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNoAllocationMetadataBuilder);\
  uint32_t builderAddrOffset = reader.stubOffset();\
  const void* builderAddr = getRawPointerField(builderAddrOffset);\
  writer.writeRawPointerField(builderAddr);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionHasJitEntry(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionHasJitEntry);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionHasNoJitEntry(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionHasNoJitEntry);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionIsNonBuiltinCtor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionIsNonBuiltinCtor);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardFunctionIsConstructor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardFunctionIsConstructor);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardNotClassConstructor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardNotClassConstructor);\
  ObjOperandId funId = reader.objOperandId();\
  writer.writeOperandId(funId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardArrayIsPacked(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardArrayIsPacked);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardArgumentsObjectFlags(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardArgumentsObjectFlags);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint8_t flags = reader.readByte();\
  writer.writeByteImm(flags);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardObjectHasSameRealm(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardObjectHasSameRealm);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadObject);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  uint32_t objOffset = reader.stubOffset();\
  JSObject* obj = getObjectField(objOffset);\
  writer.writeObjectField(obj);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadProtoObject(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadProtoObject);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  uint32_t protoObjOffset = reader.stubOffset();\
  JSObject* protoObj = getObjectField(protoObjOffset);\
  writer.writeObjectField(protoObj);\
  ObjOperandId receiverObjId = reader.objOperandId();\
  writer.writeOperandId(receiverObjId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadProto(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadProto);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadEnclosingEnvironment(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadEnclosingEnvironment);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadWrapperTarget(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadWrapperTarget);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  bool fallible = reader.readBool();\
  writer.writeBoolImm(fallible);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadValueTag(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadValueTag);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  ValueTagOperandId resultId = reader.valueTagOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentFixedSlot);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  uint8_t slotIndex = reader.readByte();\
  writer.writeByteImm(slotIndex);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentDynamicSlot);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  uint8_t slotIndex = reader.readByte();\
  writer.writeByteImm(slotIndex);\
  writer.assertLengthMatches();\
}}\
\
void cloneTruncateDoubleToUInt32(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TruncateDoubleToUInt32);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleToUint8Clamped(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleToUint8Clamped);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicLoadSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicLoadSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t nameOffset = reader.stubOffset();\
  jsid name = getIdField(nameOffset);\
  writer.writeIdField(name);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicLoadSlotByValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicLoadSlotByValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicLoadSlotPermissiveResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicLoadSlotPermissiveResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t nameOffset = reader.stubOffset();\
  jsid name = getIdField(nameOffset);\
  writer.writeIdField(name);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicLoadSlotByValuePermissiveResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicLoadSlotByValuePermissiveResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicStoreSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicStoreSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t nameOffset = reader.stubOffset();\
  jsid name = getIdField(nameOffset);\
  writer.writeIdField(name);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicSetElement(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicSetElement);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneMegamorphicHasPropResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MegamorphicHasPropResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  bool hasOwn = reader.readBool();\
  writer.writeBoolImm(hasOwn);\
  writer.assertLengthMatches();\
}}\
\
void cloneSmallObjectVariableKeyHasOwnResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SmallObjectVariableKeyHasOwnResult);\
  StringOperandId idId = reader.stringOperandId();\
  writer.writeOperandId(idId);\
  uint32_t propNamesOffset = reader.stubOffset();\
  JSObject* propNames = getObjectField(propNamesOffset);\
  writer.writeObjectField(propNames);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  writer.assertLengthMatches();\
}}\
\
void cloneObjectToIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ObjectToIteratorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t enumeratorsAddrOffset = reader.stubOffset();\
  const void* enumeratorsAddr = getRawPointerField(enumeratorsAddrOffset);\
  writer.writeRawPointerField(enumeratorsAddr);\
  writer.assertLengthMatches();\
}}\
\
void cloneValueToIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ValueToIteratorResult);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDOMExpandoValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDOMExpandoValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDOMExpandoValueGuardGeneration(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDOMExpandoValueGuardGeneration);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t expandoAndGenerationOffset = reader.stubOffset();\
  const void* expandoAndGeneration = getRawPointerField(expandoAndGenerationOffset);\
  writer.writeRawPointerField(expandoAndGeneration);\
  uint32_t generationOffset = reader.stubOffset();\
  uint64_t generation = getRawInt64Field(generationOffset);\
  writer.writeRawInt64Field(generation);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDOMExpandoValueIgnoreGeneration(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDOMExpandoValueIgnoreGeneration);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardDOMExpandoMissingOrGuardShape(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardDOMExpandoMissingOrGuardShape);\
  ValOperandId expandoId = reader.valOperandId();\
  writer.writeOperandId(expandoId);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreFixedSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDynamicSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneAddAndStoreFixedSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AddAndStoreFixedSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t newShapeOffset = reader.stubOffset();\
  Shape* newShape = getShapeField(newShapeOffset);\
  writer.writeShapeField(newShape);\
  bool preserveWrapper = reader.readBool();\
  writer.writeBoolImm(preserveWrapper);\
  writer.assertLengthMatches();\
}}\
\
void cloneAddAndStoreDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AddAndStoreDynamicSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t newShapeOffset = reader.stubOffset();\
  Shape* newShape = getShapeField(newShapeOffset);\
  writer.writeShapeField(newShape);\
  bool preserveWrapper = reader.readBool();\
  writer.writeBoolImm(preserveWrapper);\
  writer.assertLengthMatches();\
}}\
\
void cloneAllocateAndStoreDynamicSlot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AllocateAndStoreDynamicSlot);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t newShapeOffset = reader.stubOffset();\
  Shape* newShape = getShapeField(newShapeOffset);\
  writer.writeShapeField(newShape);\
  uint32_t numNewSlotsOffset = reader.stubOffset();\
  uint32_t numNewSlots = getRawInt32Field(numNewSlotsOffset);\
  writer.writeRawInt32Field(numNewSlots);\
  bool preserveWrapper = reader.readBool();\
  writer.writeBoolImm(preserveWrapper);\
  writer.assertLengthMatches();\
}}\
\
void cloneAddSlotAndCallAddPropHook(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AddSlotAndCallAddPropHook);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t newShapeOffset = reader.stubOffset();\
  Shape* newShape = getShapeField(newShapeOffset);\
  writer.writeShapeField(newShape);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDenseElement(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDenseElement);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool expectPackedElements = reader.readBool();\
  writer.writeBoolImm(expectPackedElements);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDenseElementHole(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDenseElementHole);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool handleAdd = reader.readBool();\
  writer.writeBoolImm(handleAdd);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayPush(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayPush);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayJoinResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayJoinResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  StringOperandId sepId = reader.stringOperandId();\
  writer.writeOperandId(sepId);\
  writer.assertLengthMatches();\
}}\
\
void cloneObjectKeysResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ObjectKeysResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t resultShapeOffset = reader.stubOffset();\
  Shape* resultShape = getShapeField(resultShapeOffset);\
  writer.writeShapeField(resultShape);\
  writer.assertLengthMatches();\
}}\
\
void clonePackedArrayPopResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::PackedArrayPopResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void clonePackedArrayShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::PackedArrayShiftResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void clonePackedArraySliceResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::PackedArraySliceResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  Int32OperandId beginId = reader.int32OperandId();\
  writer.writeOperandId(beginId);\
  Int32OperandId endId = reader.int32OperandId();\
  writer.writeOperandId(endId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArgumentsSliceResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArgumentsSliceResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId argsId = reader.objOperandId();\
  writer.writeOperandId(argsId);\
  Int32OperandId beginId = reader.int32OperandId();\
  writer.writeOperandId(beginId);\
  Int32OperandId endId = reader.int32OperandId();\
  writer.writeOperandId(endId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsArrayResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreFixedSlotUndefinedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreFixedSlotUndefinedResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsObjectResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsPackedArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsPackedArrayResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsCallableResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsCallableResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsConstructorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsConstructorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsCrossRealmArrayConstructorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsCrossRealmArrayConstructorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsTypedArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsTypedArrayResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  bool isPossiblyWrapped = reader.readBool();\
  writer.writeBoolImm(isPossiblyWrapped);\
  writer.assertLengthMatches();\
}}\
\
void cloneIsTypedArrayConstructorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IsTypedArrayConstructorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayBufferViewByteOffsetInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayBufferViewByteOffsetInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayBufferViewByteOffsetDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayBufferViewByteOffsetDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArrayByteLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArrayByteLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArrayByteLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArrayByteLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneResizableTypedArrayByteLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ResizableTypedArrayByteLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneResizableTypedArrayByteLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ResizableTypedArrayByteLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneResizableTypedArrayLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ResizableTypedArrayLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneResizableTypedArrayLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ResizableTypedArrayLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneResizableDataViewByteLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ResizableDataViewByteLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneResizableDataViewByteLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ResizableDataViewByteLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGrowableSharedArrayBufferByteLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GrowableSharedArrayBufferByteLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGrowableSharedArrayBufferByteLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GrowableSharedArrayBufferByteLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardHasAttachedArrayBuffer(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardHasAttachedArrayBuffer);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardResizableArrayBufferViewInBounds(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardResizableArrayBufferViewInBounds);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardResizableArrayBufferViewInBoundsOrDetached(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardResizableArrayBufferViewInBoundsOrDetached);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArrayFillResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArrayFillResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId fillValueId = reader.valOperandId();\
  writer.writeOperandId(fillValueId);\
  IntPtrOperandId startId = reader.intPtrOperandId();\
  writer.writeOperandId(startId);\
  IntPtrOperandId endId = reader.intPtrOperandId();\
  writer.writeOperandId(endId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArraySetResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArraySetResult);\
  ObjOperandId targetId = reader.objOperandId();\
  writer.writeOperandId(targetId);\
  ObjOperandId sourceId = reader.objOperandId();\
  writer.writeOperandId(sourceId);\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  writer.writeOperandId(offsetId);\
  bool canUseBitwiseCopy = reader.readBool();\
  writer.writeBoolImm(canUseBitwiseCopy);\
  writer.assertLengthMatches();\
}}\
\
void cloneTypedArraySubarrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::TypedArraySubarrayResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId startId = reader.intPtrOperandId();\
  writer.writeOperandId(startId);\
  IntPtrOperandId endId = reader.intPtrOperandId();\
  writer.writeOperandId(endId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewArrayIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewArrayIteratorResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewStringIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewStringIteratorResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewRegExpStringIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewRegExpStringIteratorResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneObjectCreateResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ObjectCreateResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewArrayFromLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewArrayFromLengthResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  Int32OperandId lengthId = reader.int32OperandId();\
  writer.writeOperandId(lengthId);\
  uint32_t siteOffset = reader.stubOffset();\
  gc::AllocSite* site = getAllocSiteField(siteOffset);\
  writer.writeAllocSiteField(site);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewTypedArrayFromLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewTypedArrayFromLengthResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  Int32OperandId lengthId = reader.int32OperandId();\
  writer.writeOperandId(lengthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewTypedArrayFromArrayBufferResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewTypedArrayFromArrayBufferResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId bufferId = reader.objOperandId();\
  writer.writeOperandId(bufferId);\
  ValOperandId byteOffsetId = reader.valOperandId();\
  writer.writeOperandId(byteOffsetId);\
  ValOperandId lengthId = reader.valOperandId();\
  writer.writeOperandId(lengthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewTypedArrayFromArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewTypedArrayFromArrayResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewMapObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewMapObjectResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewSetObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewSetObjectResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewMapObjectFromIterableResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewMapObjectFromIterableResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ValOperandId iterableId = reader.valOperandId();\
  writer.writeOperandId(iterableId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewSetObjectFromIterableResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewSetObjectFromIterableResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  ValOperandId iterableId = reader.valOperandId();\
  writer.writeOperandId(iterableId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewStringObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewStringObjectResult);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringFromCharCodeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringFromCharCodeResult);\
  Int32OperandId codeId = reader.int32OperandId();\
  writer.writeOperandId(codeId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringFromCodePointResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringFromCodePointResult);\
  Int32OperandId codeId = reader.int32OperandId();\
  writer.writeOperandId(codeId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringIncludesResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringIncludesResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId searchStrId = reader.stringOperandId();\
  writer.writeOperandId(searchStrId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringIndexOfResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringIndexOfResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId searchStrId = reader.stringOperandId();\
  writer.writeOperandId(searchStrId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringLastIndexOfResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringLastIndexOfResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId searchStrId = reader.stringOperandId();\
  writer.writeOperandId(searchStrId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringStartsWithResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringStartsWithResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId searchStrId = reader.stringOperandId();\
  writer.writeOperandId(searchStrId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringEndsWithResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringEndsWithResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  StringOperandId searchStrId = reader.stringOperandId();\
  writer.writeOperandId(searchStrId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringToLowerCaseResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringToLowerCaseResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringToUpperCaseResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringToUpperCaseResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringTrimResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringTrimResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringTrimStartResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringTrimStartResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStringTrimEndResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StringTrimEndResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathAbsInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathAbsInt32Result);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathAbsNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathAbsNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathClz32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathClz32Result);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSignInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSignInt32Result);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSignNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSignNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSignNumberToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSignNumberToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathImulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathImulResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathSqrtNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathSqrtNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFRoundNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFRoundNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathF16RoundNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathF16RoundNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathRandomResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathRandomResult);\
  uint32_t rngOffset = reader.stubOffset();\
  const void* rng = getRawPointerField(rngOffset);\
  writer.writeRawPointerField(rng);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathHypot2NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathHypot2NumberResult);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathHypot3NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathHypot3NumberResult);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  NumberOperandId thirdId = reader.numberOperandId();\
  writer.writeOperandId(thirdId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathHypot4NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathHypot4NumberResult);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  NumberOperandId thirdId = reader.numberOperandId();\
  writer.writeOperandId(thirdId);\
  NumberOperandId fourthId = reader.numberOperandId();\
  writer.writeOperandId(fourthId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathAtan2NumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathAtan2NumberResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFloorNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFloorNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathCeilNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathCeilNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathTruncNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathTruncNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathRoundNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathRoundNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFloorToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFloorToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathCeilToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathCeilToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathTruncToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathTruncToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathRoundToInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathRoundToInt32Result);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32MinMax(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32MinMax);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  Int32OperandId firstId = reader.int32OperandId();\
  writer.writeOperandId(firstId);\
  Int32OperandId secondId = reader.int32OperandId();\
  writer.writeOperandId(secondId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNumberMinMax(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NumberMinMax);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  NumberOperandId firstId = reader.numberOperandId();\
  writer.writeOperandId(firstId);\
  NumberOperandId secondId = reader.numberOperandId();\
  writer.writeOperandId(secondId);\
  NumberOperandId resultId = reader.numberOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32MinMaxArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32MinMaxArrayResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  writer.assertLengthMatches();\
}}\
\
void cloneNumberMinMaxArrayResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NumberMinMaxArrayResult);\
  ObjOperandId arrayId = reader.objOperandId();\
  writer.writeOperandId(arrayId);\
  bool isMax = reader.readBool();\
  writer.writeBoolImm(isMax);\
  writer.assertLengthMatches();\
}}\
\
void cloneMathFunctionNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MathFunctionNumberResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  UnaryMathFunction fun = reader.unaryMathFunction();\
  writer.writeUnaryMathFunctionImm(fun);\
  writer.assertLengthMatches();\
}}\
\
void cloneNumberParseIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NumberParseIntResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId radixId = reader.int32OperandId();\
  writer.writeOperandId(radixId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleParseIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleParseIntResult);\
  NumberOperandId numId = reader.numberOperandId();\
  writer.writeOperandId(numId);\
  writer.assertLengthMatches();\
}}\
\
void cloneObjectToStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ObjectToStringResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneReflectGetPrototypeOfResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ReflectGetPrototypeOfResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreTypedArrayElement(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreTypedArrayElement);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsCompareExchangeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsCompareExchangeResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId expectedId = reader.valOperandId();\
  writer.writeOperandId(expectedId);\
  ValOperandId replacementId = reader.valOperandId();\
  writer.writeOperandId(replacementId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsExchangeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsExchangeResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsAddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsAddResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsSubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsSubResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsAndResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsAndResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsOrResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsOrResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsXorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsXorResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forEffect = reader.readBool();\
  writer.writeBoolImm(forEffect);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsLoadResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsLoadResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsStoreResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsStoreResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsIsLockFreeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsIsLockFreeResult);\
  Int32OperandId valueId = reader.int32OperandId();\
  writer.writeOperandId(valueId);\
  writer.assertLengthMatches();\
}}\
\
void cloneAtomicsPauseResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AtomicsPauseResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeSetter);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t setterOffset = reader.stubOffset();\
  JSObject* setter = getObjectField(setterOffset);\
  writer.writeObjectField(setter);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedSetter);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInlinedSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInlinedSetter);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t icScriptOffset = reader.stubOffset();\
  const void* icScript = getRawPointerField(icScriptOffset);\
  writer.writeRawPointerField(icScript);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallDOMSetter(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallDOMSetter);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t jitInfoOffset = reader.stubOffset();\
  const void* jitInfo = getRawPointerField(jitInfoOffset);\
  writer.writeRawPointerField(jitInfo);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallSetArrayLength(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallSetArrayLength);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxySet(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxySet);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t idOffset = reader.stubOffset();\
  jsid id = getIdField(idOffset);\
  writer.writeIdField(id);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxySetByValue(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxySetByValue);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallAddOrUpdateSparseElementHelper(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallAddOrUpdateSparseElementHelper);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId idId = reader.int32OperandId();\
  writer.writeOperandId(idId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  bool strict = reader.readBool();\
  writer.writeBoolImm(strict);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInt32ToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInt32ToString);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNumberToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNumberToString);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32ToStringWithBaseResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32ToStringWithBaseResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  Int32OperandId baseId = reader.int32OperandId();\
  writer.writeOperandId(baseId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBooleanToString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BooleanToString);\
  BooleanOperandId inputId = reader.booleanOperandId();\
  writer.writeOperandId(inputId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t argcFixed = reader.uint32Immediate();\
  writer.writeUInt32Imm(argcFixed);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallBoundScriptedFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallBoundScriptedFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  ObjOperandId targetId = reader.objOperandId();\
  writer.writeOperandId(targetId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t numBoundArgs = reader.uint32Immediate();\
  writer.writeUInt32Imm(numBoundArgs);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallWasmFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallWasmFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t argcFixed = reader.uint32Immediate();\
  writer.writeUInt32Imm(argcFixed);\
  uint32_t funcTypeOffset = reader.stubOffset();\
  const void* funcType = getRawPointerField(funcTypeOffset);\
  writer.writeRawPointerField(funcType);\
  uint32_t instanceOffset = reader.stubOffset();\
  JSObject* instance = getObjectField(instanceOffset);\
  writer.writeObjectField(instance);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardWasmArg(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardWasmArg);\
  ValOperandId argId = reader.valOperandId();\
  writer.writeOperandId(argId);\
  wasm::ValType::Kind type = reader.wasmValType();\
  writer.writeWasmValTypeImm(type);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t argcFixed = reader.uint32Immediate();\
  writer.writeUInt32Imm(argcFixed);\
  bool ignoresReturnValue = reader.readBool();\
  writer.writeBoolImm(ignoresReturnValue);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallDOMFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallDOMFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  ObjOperandId thisObjId = reader.objOperandId();\
  writer.writeOperandId(thisObjId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t argcFixed = reader.uint32Immediate();\
  writer.writeUInt32Imm(argcFixed);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallDOMFunctionWithAllocSite(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallDOMFunctionWithAllocSite);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  ObjOperandId thisObjId = reader.objOperandId();\
  writer.writeOperandId(thisObjId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t argcFixed = reader.uint32Immediate();\
  writer.writeUInt32Imm(argcFixed);\
  uint32_t siteOffset = reader.stubOffset();\
  gc::AllocSite* site = getAllocSiteField(siteOffset);\
  writer.writeAllocSiteField(site);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallClassHook(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallClassHook);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t argcFixed = reader.uint32Immediate();\
  writer.writeUInt32Imm(argcFixed);\
  uint32_t targetOffset = reader.stubOffset();\
  const void* target = getRawPointerField(targetOffset);\
  writer.writeRawPointerField(target);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInlinedFunction(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInlinedFunction);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  Int32OperandId argcId = reader.int32OperandId();\
  writer.writeOperandId(argcId);\
  uint32_t icScriptOffset = reader.stubOffset();\
  const void* icScript = getRawPointerField(icScriptOffset);\
  writer.writeRawPointerField(icScript);\
  CallFlags flags = reader.callFlags();\
  writer.writeCallFlagsImm(flags);\
  uint32_t argcFixed = reader.uint32Immediate();\
  writer.writeUInt32Imm(argcFixed);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedProxyGetResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedProxyGetResult);\
  ValOperandId targetId = reader.valOperandId();\
  writer.writeOperandId(targetId);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  ObjOperandId handlerId = reader.objOperandId();\
  writer.writeOperandId(handlerId);\
  ObjOperandId trapId = reader.objOperandId();\
  writer.writeOperandId(trapId);\
  uint32_t propertyOffset = reader.stubOffset();\
  jsid property = getIdField(propertyOffset);\
  writer.writeIdField(property);\
  uint32_t nargsAndFlags = reader.uint32Immediate();\
  writer.writeUInt32Imm(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedProxyGetByValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedProxyGetByValueResult);\
  ValOperandId targetId = reader.valOperandId();\
  writer.writeOperandId(targetId);\
  ObjOperandId receiverId = reader.objOperandId();\
  writer.writeOperandId(receiverId);\
  ObjOperandId handlerId = reader.objOperandId();\
  writer.writeOperandId(handlerId);\
  ValOperandId propertyId = reader.valOperandId();\
  writer.writeOperandId(propertyId);\
  ObjOperandId trapId = reader.objOperandId();\
  writer.writeOperandId(trapId);\
  uint32_t nargsAndFlags = reader.uint32Immediate();\
  writer.writeUInt32Imm(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneMetaScriptedThisShape(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MetaScriptedThisShape);\
  uint32_t thisShapeOffset = reader.stubOffset();\
  Shape* thisShape = getShapeField(thisShapeOffset);\
  writer.writeShapeField(thisShape);\
  writer.assertLengthMatches();\
}}\
\
void cloneBindFunctionResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BindFunctionResult);\
  ObjOperandId targetId = reader.objOperandId();\
  writer.writeOperandId(targetId);\
  uint32_t argc = reader.uint32Immediate();\
  writer.writeUInt32Imm(argc);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneSpecializedBindFunctionResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SpecializedBindFunctionResult);\
  ObjOperandId targetId = reader.objOperandId();\
  writer.writeOperandId(targetId);\
  uint32_t argc = reader.uint32Immediate();\
  writer.writeUInt32Imm(argc);\
  uint32_t templateObjectOffset = reader.stubOffset();\
  JSObject* templateObject = getObjectField(templateObjectOffset);\
  writer.writeObjectField(templateObject);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFixedSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFixedSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFixedSlotTypedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFixedSlotTypedResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  ValueType type = reader.valueType();\
  writer.writeValueTypeImm(type);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDynamicSlotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDynamicSlotResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t offsetOffset = reader.stubOffset();\
  uint32_t offset = getRawInt32Field(offsetOffset);\
  writer.writeRawInt32Field(offset);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  bool expectPackedElements = reader.readBool();\
  writer.writeBoolImm(expectPackedElements);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementHoleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementHoleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallGetSparseElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallGetSparseElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementExistsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementExistsResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadTypedArrayElementExistsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadTypedArrayElementExistsResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDenseElementHoleExistsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDenseElementHoleExistsResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadTypedArrayElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadTypedArrayElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId indexId = reader.intPtrOperandId();\
  writer.writeOperandId(indexId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  bool forceDoubleForUint32 = reader.readBool();\
  writer.writeBoolImm(forceDoubleForUint32);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDataViewValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDataViewValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  writer.writeOperandId(offsetId);\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  writer.writeOperandId(littleEndianId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  bool forceDoubleForUint32 = reader.readBool();\
  writer.writeBoolImm(forceDoubleForUint32);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneStoreDataViewValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::StoreDataViewValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId offsetId = reader.intPtrOperandId();\
  writer.writeOperandId(offsetId);\
  ValOperandId valueId = reader.valOperandId();\
  writer.writeOperandId(valueId);\
  BooleanOperandId littleEndianId = reader.booleanOperandId();\
  writer.writeOperandId(littleEndianId);\
  Scalar::Type elementType = reader.scalarType();\
  writer.writeScalarTypeImm(elementType);\
  ArrayBufferViewKind viewKind = reader.arrayBufferViewKind();\
  writer.writeArrayBufferViewKindImm(viewKind);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32ArrayLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32ArrayLengthResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32ArrayLength(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32ArrayLength);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentsObjectArgResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentsObjectArgResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentsObjectArgHoleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentsObjectArgHoleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentsObjectArgExistsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentsObjectArgExistsResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentsObjectLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentsObjectLengthResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArgumentsObjectLength(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArgumentsObjectLength);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFunctionLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFunctionLengthResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadFunctionNameResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadFunctionNameResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBoundFunctionNumArgs(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBoundFunctionNumArgs);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBoundFunctionTarget(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBoundFunctionTarget);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ObjOperandId resultId = reader.objOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBoundFunctionArgument(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBoundFunctionArgument);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t index = reader.uint32Immediate();\
  writer.writeUInt32Imm(index);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGuardBoundFunctionIsConstructor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GuardBoundFunctionIsConstructor);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferByteLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferByteLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferByteLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferByteLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferViewLengthInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferViewLengthInt32Result);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferViewLengthDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferViewLengthDoubleResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadArrayBufferViewLength(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadArrayBufferViewLength);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLinearizeForCharAccess(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LinearizeForCharAccess);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLinearizeForCodePointAccess(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LinearizeForCodePointAccess);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneToRelativeStringIndex(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ToRelativeStringIndex);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringCharResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringCharResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringAtResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringAtResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringCharCodeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringCharCodeResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringCodePointResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringCodePointResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  bool handleOOB = reader.readBool();\
  writer.writeBoolImm(handleOOB);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringLengthResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringLengthResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneFrameIsConstructingResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::FrameIsConstructingResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadObjectResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadSymbolResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadSymbolResult);\
  SymbolOperandId symId = reader.symbolOperandId();\
  writer.writeOperandId(symId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32Result);\
  Int32OperandId valId = reader.int32OperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDoubleResult);\
  NumberOperandId valId = reader.numberOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBigIntResult);\
  BigIntOperandId valId = reader.bigIntOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallScriptedGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallScriptedGetterResult);\
  ValOperandId receiverId = reader.valOperandId();\
  writer.writeOperandId(receiverId);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallInlinedGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallInlinedGetterResult);\
  ValOperandId receiverId = reader.valOperandId();\
  writer.writeOperandId(receiverId);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  uint32_t icScriptOffset = reader.stubOffset();\
  const void* icScript = getRawPointerField(icScriptOffset);\
  writer.writeRawPointerField(icScript);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeGetterResult);\
  ValOperandId receiverId = reader.valOperandId();\
  writer.writeOperandId(receiverId);\
  uint32_t getterOffset = reader.stubOffset();\
  JSObject* getter = getObjectField(getterOffset);\
  writer.writeObjectField(getter);\
  bool sameRealm = reader.readBool();\
  writer.writeBoolImm(sameRealm);\
  uint32_t nargsAndFlagsOffset = reader.stubOffset();\
  uint32_t nargsAndFlags = getRawInt32Field(nargsAndFlagsOffset);\
  writer.writeRawInt32Field(nargsAndFlags);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallDOMGetterResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallDOMGetterResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t jitInfoOffset = reader.stubOffset();\
  const void* jitInfo = getRawPointerField(jitInfoOffset);\
  writer.writeRawPointerField(jitInfo);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxyGetResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxyGetResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t idOffset = reader.stubOffset();\
  jsid id = getIdField(idOffset);\
  writer.writeIdField(id);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxyGetByValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxyGetByValueResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  writer.assertLengthMatches();\
}}\
\
void cloneProxyHasPropResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ProxyHasPropResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  ValOperandId idId = reader.valOperandId();\
  writer.writeOperandId(idId);\
  bool hasOwn = reader.readBool();\
  writer.writeBoolImm(hasOwn);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallObjectHasSparseElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallObjectHasSparseElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeGetElementResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeGetElementResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallNativeGetElementSuperResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallNativeGetElementSuperResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  Int32OperandId indexId = reader.int32OperandId();\
  writer.writeOperandId(indexId);\
  ValOperandId receiverId = reader.valOperandId();\
  writer.writeOperandId(receiverId);\
  writer.assertLengthMatches();\
}}\
\
void cloneGetNextMapSetEntryForIteratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::GetNextMapSetEntryForIteratorResult);\
  ObjOperandId iterId = reader.objOperandId();\
  writer.writeOperandId(iterId);\
  ObjOperandId resultArrId = reader.objOperandId();\
  writer.writeOperandId(resultArrId);\
  bool isMap = reader.readBool();\
  writer.writeBoolImm(isMap);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadUndefinedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadUndefinedResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBooleanResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBooleanResult);\
  bool val = reader.readBool();\
  writer.writeBoolImm(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32Constant(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32Constant);\
  uint32_t valOffset = reader.stubOffset();\
  uint32_t val = getRawInt32Field(valOffset);\
  writer.writeRawInt32Field(val);\
  Int32OperandId resultId = reader.int32OperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32AsIntPtrConstant(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32AsIntPtrConstant);\
  uint32_t valOffset = reader.stubOffset();\
  uint32_t val = getRawInt32Field(valOffset);\
  writer.writeRawInt32Field(val);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDoubleConstant(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDoubleConstant);\
  uint32_t valOffset = reader.stubOffset();\
  double val = getDoubleField(valOffset);\
  writer.writeDoubleField(val);\
  NumberOperandId resultId = reader.numberOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBooleanConstant(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBooleanConstant);\
  bool val = reader.readBool();\
  writer.writeBoolImm(val);\
  BooleanOperandId resultId = reader.booleanOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadUndefined(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadUndefined);\
  ValOperandId resultId = reader.valOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadConstantString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadConstantString);\
  uint32_t strOffset = reader.stubOffset();\
  JSString* str = getStringField(strOffset);\
  writer.writeStringField(str);\
  StringOperandId resultId = reader.stringOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadConstantStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadConstantStringResult);\
  uint32_t strOffset = reader.stubOffset();\
  JSString* str = getStringField(strOffset);\
  writer.writeStringField(str);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInstanceOfObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInstanceOfObjectResult);\
  ValOperandId lhsId = reader.valOperandId();\
  writer.writeOperandId(lhsId);\
  ObjOperandId protoId = reader.objOperandId();\
  writer.writeOperandId(protoId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadTypeOfObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadTypeOfObjectResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadTypeOfEqObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadTypeOfEqObjectResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  TypeofEqOperand operand = reader.typeofEqOperand();\
  writer.writeTypeofEqOperandImm(operand);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleAddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleAddResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleSubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleSubResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleMulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleMulResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleDivResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleDivResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleModResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleModResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoublePowResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoublePowResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32AddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32AddResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32SubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32SubResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32MulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32MulResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32DivResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32DivResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32ModResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32ModResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32PowResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32PowResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntAddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntAddResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntSubResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntSubResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntMulResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntMulResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntDivResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntDivResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntModResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntModResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPowResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPowResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntToIntPtr(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntToIntPtr);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIntPtrToBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IntPtrToBigIntResult);\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrAdd(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrAdd);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrSub(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrSub);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrMul(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrMul);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrDiv(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrDiv);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrMod(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrMod);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrPow(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrPow);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32BitOrResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32BitOrResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32BitXorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32BitXorResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32BitAndResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32BitAndResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32LeftShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32LeftShiftResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32RightShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32RightShiftResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32URightShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32URightShiftResult);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  bool forceDouble = reader.readBool();\
  writer.writeBoolImm(forceDouble);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32NotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32NotResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntBitOrResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntBitOrResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntBitXorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntBitXorResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntBitAndResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntBitAndResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntLeftShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntLeftShiftResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntRightShiftResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntRightShiftResult);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntNotResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntNotResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrBitOr(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrBitOr);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrBitXor(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrBitXor);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrBitAnd(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrBitAnd);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrLeftShift(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrLeftShift);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrRightShift(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrRightShift);\
  IntPtrOperandId lhsId = reader.intPtrOperandId();\
  writer.writeOperandId(lhsId);\
  IntPtrOperandId rhsId = reader.intPtrOperandId();\
  writer.writeOperandId(rhsId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrNot(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrNot);\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  writer.writeOperandId(inputId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32NegationResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32NegationResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleNegationResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleNegationResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntNegationResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntNegationResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrNegation(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrNegation);\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  writer.writeOperandId(inputId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32IncResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32IncResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneInt32DecResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Int32DecResult);\
  Int32OperandId inputId = reader.int32OperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleIncResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleIncResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDoubleDecResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DoubleDecResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntIncResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntIncResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntDecResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntDecResult);\
  BigIntOperandId inputId = reader.bigIntOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrInc(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrInc);\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  writer.writeOperandId(inputId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntPtrDec(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntPtrDec);\
  IntPtrOperandId inputId = reader.intPtrOperandId();\
  writer.writeOperandId(inputId);\
  IntPtrOperandId resultId = reader.intPtrOperandId();\
  writer.newOperandId();\
  writer.writeOperandId(resultId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadInt32TruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadInt32TruthyResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadDoubleTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadDoubleTruthyResult);\
  NumberOperandId inputId = reader.numberOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadStringTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadStringTruthyResult);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadObjectTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadObjectTruthyResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadBigIntTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadBigIntTruthyResult);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadValueTruthyResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadValueTruthyResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadValueResult);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getValueField(valOffset);\
  writer.writeValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneUncheckedLoadWeakValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::UncheckedLoadWeakValueResult);\
  uint32_t valOffset = reader.stubOffset();\
  const Value val = getWeakValueField(valOffset);\
  writer.writeWeakValueField(val);\
  writer.assertLengthMatches();\
}}\
\
void cloneUncheckedLoadWeakObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::UncheckedLoadWeakObjectResult);\
  uint32_t objOffset = reader.stubOffset();\
  JSObject* obj = getWeakObjectField(objOffset);\
  writer.writeWeakObjectField(obj);\
  writer.assertLengthMatches();\
}}\
\
void cloneLoadOperandResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::LoadOperandResult);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewPlainObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewPlainObjectResult);\
  uint32_t numFixedSlots = reader.uint32Immediate();\
  writer.writeUInt32Imm(numFixedSlots);\
  uint32_t numDynamicSlots = reader.uint32Immediate();\
  writer.writeUInt32Imm(numDynamicSlots);\
  gc::AllocKind allocKind = reader.allocKind();\
  writer.writeAllocKindImm(allocKind);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  uint32_t siteOffset = reader.stubOffset();\
  gc::AllocSite* site = getAllocSiteField(siteOffset);\
  writer.writeAllocSiteField(site);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewArrayObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewArrayObjectResult);\
  uint32_t arrayLength = reader.uint32Immediate();\
  writer.writeUInt32Imm(arrayLength);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  uint32_t siteOffset = reader.stubOffset();\
  gc::AllocSite* site = getAllocSiteField(siteOffset);\
  writer.writeAllocSiteField(site);\
  writer.assertLengthMatches();\
}}\
\
void cloneNewFunctionCloneResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::NewFunctionCloneResult);\
  uint32_t canonicalOffset = reader.stubOffset();\
  JSObject* canonical = getObjectField(canonicalOffset);\
  writer.writeObjectField(canonical);\
  gc::AllocKind allocKind = reader.allocKind();\
  writer.writeAllocKindImm(allocKind);\
  uint32_t siteOffset = reader.stubOffset();\
  gc::AllocSite* site = getAllocSiteField(siteOffset);\
  writer.writeAllocSiteField(site);\
  writer.assertLengthMatches();\
}}\
\
void cloneConcatStringsResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ConcatStringsResult);\
  StringOperandId lhsId = reader.stringOperandId();\
  writer.writeOperandId(lhsId);\
  StringOperandId rhsId = reader.stringOperandId();\
  writer.writeOperandId(rhsId);\
  uint32_t stubOffset = reader.stubOffset();\
  JitCode* stub = getJitCodeField(stubOffset);\
  writer.writeJitCodeField(stub);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallStringObjectConcatResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallStringObjectConcatResult);\
  ValOperandId lhsId = reader.valOperandId();\
  writer.writeOperandId(lhsId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallIsSuspendedGeneratorResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallIsSuspendedGeneratorResult);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareStringResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  StringOperandId lhsId = reader.stringOperandId();\
  writer.writeOperandId(lhsId);\
  StringOperandId rhsId = reader.stringOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareObjectResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  ObjOperandId lhsId = reader.objOperandId();\
  writer.writeOperandId(lhsId);\
  ObjOperandId rhsId = reader.objOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareSymbolResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareSymbolResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  SymbolOperandId lhsId = reader.symbolOperandId();\
  writer.writeOperandId(lhsId);\
  SymbolOperandId rhsId = reader.symbolOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareInt32Result);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  Int32OperandId lhsId = reader.int32OperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareDoubleResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareDoubleResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  BigIntOperandId rhsId = reader.bigIntOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntInt32Result);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  Int32OperandId rhsId = reader.int32OperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntNumberResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntNumberResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareBigIntStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareBigIntStringResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  BigIntOperandId lhsId = reader.bigIntOperandId();\
  writer.writeOperandId(lhsId);\
  StringOperandId rhsId = reader.stringOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareNullUndefinedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareNullUndefinedResult);\
  JSOp op = reader.jsop();\
  writer.writeJSOpImm(op);\
  bool isUndefined = reader.readBool();\
  writer.writeBoolImm(isUndefined);\
  ValOperandId inputId = reader.valOperandId();\
  writer.writeOperandId(inputId);\
  writer.assertLengthMatches();\
}}\
\
void cloneCompareDoubleSameValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CompareDoubleSameValueResult);\
  NumberOperandId lhsId = reader.numberOperandId();\
  writer.writeOperandId(lhsId);\
  NumberOperandId rhsId = reader.numberOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSameValueResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SameValueResult);\
  ValOperandId lhsId = reader.valOperandId();\
  writer.writeOperandId(lhsId);\
  ValOperandId rhsId = reader.valOperandId();\
  writer.writeOperandId(rhsId);\
  writer.assertLengthMatches();\
}}\
\
void cloneIndirectTruncateInt32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::IndirectTruncateInt32Result);\
  Int32OperandId valId = reader.int32OperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntAsIntNResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntAsIntNResult);\
  Int32OperandId bitsId = reader.int32OperandId();\
  writer.writeOperandId(bitsId);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneBigIntAsUintNResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::BigIntAsUintNResult);\
  Int32OperandId bitsId = reader.int32OperandId();\
  writer.writeOperandId(bitsId);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetHasResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetHasResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetHasNonGCThingResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetHasNonGCThingResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetHasStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetHasStringResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetHasSymbolResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetHasSymbolResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  SymbolOperandId symId = reader.symbolOperandId();\
  writer.writeOperandId(symId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetHasBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetHasBigIntResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetHasObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetHasObjectResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetDeleteResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetDeleteResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetAddResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetAddResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  ValOperandId keyId = reader.valOperandId();\
  writer.writeOperandId(keyId);\
  writer.assertLengthMatches();\
}}\
\
void cloneSetSizeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::SetSizeResult);\
  ObjOperandId setId = reader.objOperandId();\
  writer.writeOperandId(setId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapHasResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapHasResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapHasNonGCThingResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapHasNonGCThingResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapHasStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapHasStringResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapHasSymbolResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapHasSymbolResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  SymbolOperandId symId = reader.symbolOperandId();\
  writer.writeOperandId(symId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapHasBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapHasBigIntResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapHasObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapHasObjectResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapGetResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapGetResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapGetNonGCThingResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapGetNonGCThingResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapGetStringResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapGetStringResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  StringOperandId strId = reader.stringOperandId();\
  writer.writeOperandId(strId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapGetSymbolResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapGetSymbolResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  SymbolOperandId symId = reader.symbolOperandId();\
  writer.writeOperandId(symId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapGetBigIntResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapGetBigIntResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  BigIntOperandId bigIntId = reader.bigIntOperandId();\
  writer.writeOperandId(bigIntId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapGetObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapGetObjectResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapDeleteResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapDeleteResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapSetResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapSetResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  ValOperandId keyId = reader.valOperandId();\
  writer.writeOperandId(keyId);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  writer.assertLengthMatches();\
}}\
\
void cloneMapSizeResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::MapSizeResult);\
  ObjOperandId mapId = reader.objOperandId();\
  writer.writeOperandId(mapId);\
  writer.assertLengthMatches();\
}}\
\
void cloneWeakMapGetObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::WeakMapGetObjectResult);\
  ObjOperandId weakMapId = reader.objOperandId();\
  writer.writeOperandId(weakMapId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneWeakMapHasObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::WeakMapHasObjectResult);\
  ObjOperandId weakMapId = reader.objOperandId();\
  writer.writeOperandId(weakMapId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneWeakSetHasObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::WeakSetHasObjectResult);\
  ObjOperandId weakSetId = reader.objOperandId();\
  writer.writeOperandId(weakSetId);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDateFillLocalTimeSlots(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DateFillLocalTimeSlots);\
  ObjOperandId dateId = reader.objOperandId();\
  writer.writeOperandId(dateId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDateHoursFromSecondsIntoYearResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DateHoursFromSecondsIntoYearResult);\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  writer.writeOperandId(secondsIntoYearId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDateMinutesFromSecondsIntoYearResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DateMinutesFromSecondsIntoYearResult);\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  writer.writeOperandId(secondsIntoYearId);\
  writer.assertLengthMatches();\
}}\
\
void cloneDateSecondsFromSecondsIntoYearResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::DateSecondsFromSecondsIntoYearResult);\
  ValOperandId secondsIntoYearId = reader.valOperandId();\
  writer.writeOperandId(secondsIntoYearId);\
  writer.assertLengthMatches();\
}}\
\
void cloneArrayFromArgumentsObjectResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::ArrayFromArgumentsObjectResult);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t shapeOffset = reader.stubOffset();\
  Shape* shape = getShapeField(shapeOffset);\
  writer.writeShapeField(shape);\
  writer.assertLengthMatches();\
}}\
\
void cloneCloseIterScriptedResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CloseIterScriptedResult);\
  ObjOperandId iterId = reader.objOperandId();\
  writer.writeOperandId(iterId);\
  ObjOperandId calleeId = reader.objOperandId();\
  writer.writeOperandId(calleeId);\
  CompletionKind kind = reader.completionKind();\
  writer.writeCompletionKindImm(kind);\
  uint32_t targetNargs = reader.uint32Immediate();\
  writer.writeUInt32Imm(targetNargs);\
  writer.assertLengthMatches();\
}}\
\
void cloneCallPrintString(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::CallPrintString);\
  const char* str = reinterpret_cast<char*>(reader.pointer());\
  writer.writeStaticStringImm(str);\
  writer.assertLengthMatches();\
}}\
\
void cloneBreakpoint(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Breakpoint);\
  writer.assertLengthMatches();\
}}\
\
void cloneWrapResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::WrapResult);\
  writer.assertLengthMatches();\
}}\
\
void cloneBailout(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::Bailout);\
  writer.assertLengthMatches();\
}}\
\
void cloneAssertFloat32Result(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AssertFloat32Result);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  bool mustBeFloat32 = reader.readBool();\
  writer.writeBoolImm(mustBeFloat32);\
  writer.assertLengthMatches();\
}}\
\
void cloneAssertRecoveredOnBailoutResult(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AssertRecoveredOnBailoutResult);\
  ValOperandId valId = reader.valOperandId();\
  writer.writeOperandId(valId);\
  bool mustBeRecovered = reader.readBool();\
  writer.writeBoolImm(mustBeRecovered);\
  writer.assertLengthMatches();\
}}\
\
void cloneAssertPropertyLookup(CacheIRReader& reader, CacheIRWriter& writer) {{\
  writer.writeOp(CacheOp::AssertPropertyLookup);\
  ObjOperandId objId = reader.objOperandId();\
  writer.writeOperandId(objId);\
  uint32_t idOffset = reader.stubOffset();\
  jsid id = getIdField(idOffset);\
  writer.writeIdField(id);\
  uint32_t slotOffset = reader.stubOffset();\
  uint32_t slot = getRawInt32Field(slotOffset);\
  writer.writeRawInt32Field(slot);\
  writer.assertLengthMatches();\
}}\




#endif // jit_CacheIROpsGenerated_h
