/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef jit_LIROpsGenerated_h
#define jit_LIROpsGenerated_h

/* This file is generated by jit/GenerateLIRFiles.py. Do not edit! */

#define LIR_OPCODE_LIST(_)\
_(Phi)\
_(Box)\
_(OsiPoint)\
_(MoveGroup)\
_(Integer)\
_(Integer64)\
_(Pointer)\
_(Double)\
_(Float32)\
_(Value)\
_(Parameter)\
_(Goto)\
_(NewArray)\
_(NewIterator)\
_(NewTypedArray)\
_(NewTypedArrayInline)\
_(BindFunction)\
_(NewObject)\
_(NewPlainObject)\
_(NewArrayObject)\
_(NewCallObject)\
_(NewMapObject)\
_(NewSetObject)\
_(NewStringObject)\
_(InitElemGetterSetter)\
_(MutateProto)\
_(InitPropGetterSetter)\
_(WasmRefAsNonNull)\
_(WasmRefTestConcrete)\
_(WasmRefTestAbstract)\
_(WasmRefTestConcreteAndBranch)\
_(WasmRefTestAbstractAndBranch)\
_(WasmRefCastConcrete)\
_(WasmRefCastAbstract)\
_(WasmNewStructObject)\
_(WasmNewArrayObject)\
_(ReinterpretCast)\
_(ReinterpretCastFromI64)\
_(ReinterpretCastToI64)\
_(Rotate)\
_(RotateI64)\
_(WasmStackSwitchToMain)\
_(WasmStackSwitchToSuspendable)\
_(WasmStackContinueOnSuspendable)\
_(WasmInterruptCheck)\
_(TypeOfV)\
_(TypeOfO)\
_(TypeOfIsNonPrimitiveV)\
_(TypeOfIsNonPrimitiveO)\
_(TypeOfIsPrimitive)\
_(ToAsyncIter)\
_(CreateArgumentsObject)\
_(CreateInlinedArgumentsObject)\
_(GetInlinedArgument)\
_(GetInlinedArgumentHole)\
_(GuardArgumentsObjectFlags)\
_(GuardObjectHasSameRealm)\
_(GuardBoundFunctionIsConstructor)\
_(BoxNonStrictThis)\
_(StackArgT)\
_(StackArgV)\
_(CallGeneric)\
_(CallKnown)\
_(CallNative)\
_(CallDOMNative)\
_(CallClassHook)\
_(Unreachable)\
_(UnreachableResultV)\
_(UnreachableResultT)\
_(GetDOMProperty)\
_(GetDOMMemberV)\
_(GetDOMMemberT)\
_(SetDOMProperty)\
_(LoadDOMExpandoValueGuardGeneration)\
_(GuardDOMExpandoMissingOrGuardShape)\
_(ApplyArgsGeneric)\
_(ApplyArgsObj)\
_(ApplyArrayGeneric)\
_(ConstructArgsGeneric)\
_(ConstructArrayGeneric)\
_(ApplyArgsNative)\
_(ApplyArgsObjNative)\
_(ApplyArrayNative)\
_(ConstructArgsNative)\
_(ConstructArrayNative)\
_(TestIAndBranch)\
_(TestIPtrAndBranch)\
_(TestI64AndBranch)\
_(TestDAndBranch)\
_(TestFAndBranch)\
_(TestBIAndBranch)\
_(TestOAndBranch)\
_(TestVAndBranch)\
_(Compare)\
_(CompareI64)\
_(CompareI64AndBranch)\
_(CompareAndBranch)\
_(CompareD)\
_(CompareF)\
_(CompareDAndBranch)\
_(CompareFAndBranch)\
_(CompareS)\
_(CompareSInline)\
_(CompareSSingle)\
_(CompareBigInt)\
_(CompareBigIntInt32)\
_(CompareBigIntDouble)\
_(CompareBigIntString)\
_(CompareBigIntInt32AndBranch)\
_(StrictConstantCompareInt32AndBranch)\
_(StrictConstantCompareBooleanAndBranch)\
_(BitAndAndBranch)\
_(BitAnd64AndBranch)\
_(IsNullOrLikeUndefinedV)\
_(IsNullOrLikeUndefinedT)\
_(IsNull)\
_(IsUndefined)\
_(IsNullOrLikeUndefinedAndBranchV)\
_(IsNullOrLikeUndefinedAndBranchT)\
_(IsNullAndBranch)\
_(IsUndefinedAndBranch)\
_(NotI)\
_(NotIPtr)\
_(NotI64)\
_(NotD)\
_(NotF)\
_(NotBI)\
_(NotO)\
_(NotV)\
_(BitNotI)\
_(BitNotI64)\
_(BitOpI)\
_(BitOpI64)\
_(ShiftI)\
_(ShiftIntPtr)\
_(ShiftI64)\
_(SignExtendInt32)\
_(SignExtendIntPtr)\
_(SignExtendInt64)\
_(UrshD)\
_(Return)\
_(MinMaxI)\
_(MinMaxIntPtr)\
_(MinMaxD)\
_(MinMaxF)\
_(MinMaxArrayI)\
_(MinMaxArrayD)\
_(NegI)\
_(NegI64)\
_(NegD)\
_(NegF)\
_(AbsI)\
_(AbsD)\
_(AbsF)\
_(CopySignD)\
_(CopySignF)\
_(ClzI)\
_(ClzI64)\
_(CtzI)\
_(CtzI64)\
_(PopcntI)\
_(PopcntI64)\
_(SqrtD)\
_(SqrtF)\
_(Atan2D)\
_(Hypot)\
_(PowI)\
_(PowII)\
_(PowD)\
_(PowOfTwoI)\
_(SignI)\
_(SignD)\
_(SignDI)\
_(SignID)\
_(MathFunctionD)\
_(MathFunctionF)\
_(AddI)\
_(AddI64)\
_(AddIntPtr)\
_(SubI)\
_(SubI64)\
_(SubIntPtr)\
_(MulI64)\
_(MulIntPtr)\
_(MathD)\
_(MathF)\
_(ModD)\
_(ModPowTwoD)\
_(WasmBuiltinModD)\
_(BigIntAdd)\
_(BigIntSub)\
_(BigIntMul)\
_(BigIntDiv)\
_(BigIntMod)\
_(BigIntPow)\
_(BigIntBitAnd)\
_(BigIntBitOr)\
_(BigIntBitXor)\
_(BigIntLsh)\
_(BigIntRsh)\
_(BigIntIncrement)\
_(BigIntDecrement)\
_(BigIntNegate)\
_(BigIntBitNot)\
_(BigIntPtrAdd)\
_(BigIntPtrSub)\
_(BigIntPtrMul)\
_(BigIntPtrDiv)\
_(BigIntPtrDivPowTwo)\
_(BigIntPtrMod)\
_(BigIntPtrModPowTwo)\
_(BigIntPtrPow)\
_(BigIntPtrBitAnd)\
_(BigIntPtrBitOr)\
_(BigIntPtrBitXor)\
_(BigIntPtrLsh)\
_(BigIntPtrRsh)\
_(BigIntPtrBitNot)\
_(Concat)\
_(StringIncludesSIMD)\
_(StringIndexOfSIMD)\
_(StringStartsWithInline)\
_(StringEndsWithInline)\
_(StringToLowerCase)\
_(CharCodeToLowerCase)\
_(StringToUpperCase)\
_(CharCodeToUpperCase)\
_(Int32ToDouble)\
_(Float32ToDouble)\
_(DoubleToFloat32)\
_(Int32ToFloat32)\
_(DoubleToFloat16)\
_(DoubleToFloat32ToFloat16)\
_(Float32ToFloat16)\
_(Int32ToFloat16)\
_(ValueToDouble)\
_(ValueToFloat32)\
_(ValueToFloat16)\
_(ValueToNumberInt32)\
_(ValueTruncateToInt32)\
_(ValueToBigInt)\
_(DoubleToInt32)\
_(Float32ToInt32)\
_(TruncateDToInt32)\
_(WasmBuiltinTruncateDToInt32)\
_(TruncateFToInt32)\
_(WasmBuiltinTruncateFToInt32)\
_(WasmTruncateToInt32)\
_(WrapInt64ToInt32)\
_(ExtendInt32ToInt64)\
_(BooleanToString)\
_(IntToString)\
_(DoubleToString)\
_(ValueToString)\
_(PowHalfD)\
_(NaNToZero)\
_(OsrEntry)\
_(OsrValue)\
_(OsrEnvironmentChain)\
_(OsrReturnValue)\
_(OsrArgumentsObject)\
_(RegExp)\
_(RegExpHasCaptureGroups)\
_(GetFirstDollarIndex)\
_(StringReplace)\
_(BinaryValueCache)\
_(BinaryBoolCache)\
_(ModuleMetadata)\
_(DynamicImport)\
_(Lambda)\
_(FunctionWithProto)\
_(KeepAliveObject)\
_(DebugEnterGCUnsafeRegion)\
_(DebugLeaveGCUnsafeRegion)\
_(GetNextEntryForIterator)\
_(ResizableTypedArrayLength)\
_(ResizableDataViewByteLength)\
_(GuardResizableArrayBufferViewInBounds)\
_(GuardResizableArrayBufferViewInBoundsOrDetached)\
_(GuardHasAttachedArrayBuffer)\
_(GuardNumberToIntPtrIndex)\
_(BoundsCheck)\
_(BoundsCheckRange)\
_(BoundsCheckLower)\
_(SpectreMaskIndex)\
_(LoadElementV)\
_(InArray)\
_(GuardElementNotHole)\
_(LoadElementHole)\
_(StoreElementV)\
_(StoreElementT)\
_(StoreHoleValueElement)\
_(StoreElementHoleV)\
_(StoreElementHoleT)\
_(ArrayPopShift)\
_(FrameArgumentsSlice)\
_(InlineArgumentsSlice)\
_(ObjectKeys)\
_(ObjectKeysLength)\
_(LoadUnboxedScalar)\
_(LoadUnboxedInt64)\
_(LoadDataViewElement)\
_(LoadDataViewElement64)\
_(LoadTypedArrayElementHole)\
_(LoadTypedArrayElementHoleBigInt)\
_(StoreUnboxedScalar)\
_(StoreUnboxedInt64)\
_(StoreDataViewElement)\
_(StoreDataViewElement64)\
_(StoreTypedArrayElementHole)\
_(StoreTypedArrayElementHoleInt64)\
_(TypedArraySubarray)\
_(TypedArrayFill)\
_(TypedArrayFill64)\
_(AtomicIsLockFree)\
_(CompareExchangeTypedArrayElement)\
_(AtomicExchangeTypedArrayElement)\
_(AtomicTypedArrayElementBinop)\
_(AtomicTypedArrayElementBinopForEffect)\
_(AtomicLoad64)\
_(AtomicStore64)\
_(CompareExchangeTypedArrayElement64)\
_(AtomicExchangeTypedArrayElement64)\
_(AtomicTypedArrayElementBinop64)\
_(AtomicTypedArrayElementBinopForEffect64)\
_(EffectiveAddress3)\
_(EffectiveAddress2)\
_(ClampIToUint8)\
_(ClampDToUint8)\
_(ClampVToUint8)\
_(LoadFixedSlotV)\
_(LoadFixedSlotAndAtomize)\
_(LoadFixedSlotT)\
_(LoadFixedSlotAndUnbox)\
_(LoadDynamicSlotAndUnbox)\
_(LoadElementAndUnbox)\
_(LoadFixedSlotUnboxAndAtomize)\
_(LoadDynamicSlotUnboxAndAtomize)\
_(AddAndStoreSlot)\
_(AddAndStoreSlotPreserveWrapper)\
_(StoreFixedSlotV)\
_(StoreFixedSlotT)\
_(GetPropSuperCache)\
_(GetPropertyCache)\
_(LoadDynamicSlotV)\
_(LoadDynamicSlotAndAtomize)\
_(StoreDynamicSlotV)\
_(StoreDynamicSlotT)\
_(Floor)\
_(FloorF)\
_(Ceil)\
_(CeilF)\
_(Round)\
_(RoundF)\
_(Trunc)\
_(TruncF)\
_(NearbyInt)\
_(NearbyIntF)\
_(RoundToDouble)\
_(RoundToFloat32)\
_(NewLexicalEnvironmentObject)\
_(NewClassBodyEnvironmentObject)\
_(NewVarEnvironmentObject)\
_(MegamorphicSetElement)\
_(CallDeleteProperty)\
_(CallDeleteElement)\
_(ObjectToIterator)\
_(ValueToIterator)\
_(IteratorHasIndicesAndBranch)\
_(IteratorsMatchAndHaveIndicesAndBranch)\
_(SetPropertyCache)\
_(GetIteratorCache)\
_(IsNoIterAndBranch)\
_(CloseIterCache)\
_(Int32ToIntPtr)\
_(NonNegativeIntPtrToInt32)\
_(IntPtrToDouble)\
_(AdjustDataViewLength)\
_(BooleanToInt64)\
_(StringToInt64)\
_(ValueToInt64)\
_(TruncateBigIntToInt64)\
_(Int64ToBigInt)\
_(Uint64ToBigInt)\
_(Int64ToIntPtr)\
_(IntPtrToInt64)\
_(PostWriteBarrierO)\
_(PostWriteBarrierS)\
_(PostWriteBarrierBI)\
_(PostWriteBarrierV)\
_(PostWriteElementBarrierO)\
_(PostWriteElementBarrierS)\
_(PostWriteElementBarrierBI)\
_(PostWriteElementBarrierV)\
_(AssertCanElidePostWriteBarrier)\
_(GuardObjectIdentity)\
_(GuardSpecificFunction)\
_(GuardSpecificAtom)\
_(GuardSpecificSymbol)\
_(GuardSpecificInt32)\
_(GuardProto)\
_(GuardNullProto)\
_(GuardIsNativeObject)\
_(GuardGlobalGeneration)\
_(GuardIsProxy)\
_(GuardIsNotProxy)\
_(GuardIsNotDOMProxy)\
_(ProxyHasProp)\
_(GuardIsNotArrayBufferMaybeShared)\
_(GuardIsTypedArray)\
_(GuardIsNonResizableTypedArray)\
_(GuardIsResizableTypedArray)\
_(GuardHasProxyHandler)\
_(GuardNoDenseElements)\
_(InCache)\
_(HasOwnCache)\
_(CheckPrivateFieldCache)\
_(InstanceOfO)\
_(InstanceOfV)\
_(IsCallableO)\
_(IsCallableV)\
_(IsArrayO)\
_(IsArrayV)\
_(IsTypedArray)\
_(IsObjectAndBranch)\
_(IsNullOrUndefinedAndBranch)\
_(HasClass)\
_(GuardToClass)\
_(GuardToFunction)\
_(WasmSelect)\
_(WasmSelectI64)\
_(WasmCompareAndSelect)\
_(WasmAddOffset)\
_(WasmAddOffset64)\
_(WasmBoundsCheck)\
_(WasmBoundsCheck64)\
_(WasmBoundsCheckInstanceField)\
_(WasmBoundsCheckInstanceField64)\
_(WasmExtendU32Index)\
_(WasmWrapU32Index)\
_(WasmAlignmentCheck)\
_(WasmAlignmentCheck64)\
_(WasmLoadInstance)\
_(WasmLoadInstance64)\
_(WasmHeapReg)\
_(WasmLoad)\
_(WasmLoadI64)\
_(WasmStore)\
_(WasmStoreI64)\
_(AsmJSLoadHeap)\
_(AsmJSStoreHeap)\
_(WasmCompareExchangeHeap)\
_(WasmAtomicExchangeHeap)\
_(WasmAtomicBinopHeap)\
_(WasmAtomicBinopHeapForEffect)\
_(WasmLoadSlot)\
_(WasmLoadElement)\
_(WasmLoadSlotI64)\
_(WasmLoadElementI64)\
_(WasmStoreSlot)\
_(WasmStoreSlotI64)\
_(WasmStoreStackResult)\
_(WasmStoreStackResultI64)\
_(WasmStoreElement)\
_(WasmStoreElementI64)\
_(WasmStoreElementRef)\
_(WasmLoadTableElement)\
_(WasmDerivedPointer)\
_(WasmDerivedIndexPointer)\
_(WasmStoreRef)\
_(WasmPostWriteBarrierWholeCell)\
_(WasmPostWriteBarrierEdgeAtIndex)\
_(WasmParameter)\
_(WasmParameterI64)\
_(WasmReturn)\
_(WasmReturnI64)\
_(WasmReturnVoid)\
_(WasmStackArg)\
_(WasmStackArgI64)\
_(WasmNullConstant)\
_(WasmCallIndirectAdjunctSafepoint)\
_(WasmCall)\
_(WasmRegisterResult)\
_(WasmRegisterPairResult)\
_(WasmBuiltinFloatRegisterResult)\
_(WasmStackResultArea)\
_(WasmStackResult)\
_(WasmStackResult64)\
_(AssertRangeI)\
_(AssertRangeD)\
_(AssertRangeF)\
_(AssertRangeV)\
_(AssertClass)\
_(AssertShape)\
_(GuardValue)\
_(GuardNullOrUndefined)\
_(GuardIsNotObject)\
_(GuardFunctionFlags)\
_(GuardFunctionIsNonBuiltinCtor)\
_(GuardFunctionKind)\
_(GuardFunctionScript)\
_(LexicalCheck)\
_(ThrowRuntimeLexicalError)\
_(ThrowMsg)\
_(MemoryBarrier)\
_(Debugger)\
_(Random)\
_(CheckObjCoercible)\
_(CheckClassHeritage)\
_(CheckThis)\
_(CheckThisReinit)\
_(Generator)\
_(AsyncResolve)\
_(AsyncReject)\
_(AsyncAwait)\
_(CanSkipAwait)\
_(MaybeExtractAwaitValue)\
_(DebugCheckSelfHosted)\
_(GuardArrayIsPacked)\
_(ObjectStaticProto)\
_(GuardTagNotEqual)\
_(GuardHasGetterSetter)\
_(GuardIsExtensible)\
_(GuardInt32IsNonNegative)\
_(GuardInt32Range)\
_(GuardIndexIsNotDenseElement)\
_(GuardIndexIsValidUpdateOrAdd)\
_(GuardNonGCThing)\
_(CanonicalizeNaND)\
_(CanonicalizeNaNF)\
_(IonToWasmCall)\
_(IonToWasmCallV)\
_(IonToWasmCallI64)\
_(WasmNewI31Ref)\
_(Simd128)\
_(WasmTernarySimd128)\
_(WasmBinarySimd128)\
_(WasmBinarySimd128WithConstant)\
_(WasmVariableShiftSimd128)\
_(WasmConstantShiftSimd128)\
_(WasmSignReplicationSimd128)\
_(WasmShuffleSimd128)\
_(WasmPermuteSimd128)\
_(WasmReplaceLaneSimd128)\
_(WasmReplaceInt64LaneSimd128)\
_(WasmScalarToSimd128)\
_(WasmInt64ToSimd128)\
_(WasmReduceSimd128)\
_(WasmReduceAndBranchSimd128)\
_(WasmReduceSimd128ToInt64)\
_(WasmLoadLaneSimd128)\
_(WasmStoreLaneSimd128)\
_(Unbox)\
_(UnboxFloatingPoint)\
_(WasmUint32ToDouble)\
_(WasmUint32ToFloat32)\
_(DivI)\
_(ModI)\
_(DivPowTwoI)\
_(ModPowTwoI)\
_(TableSwitch)\
_(TableSwitchV)\
_(MulI)\
_(DivConstantI)\
_(ModConstantI)\
_(UDivConstant)\
_(UModConstant)\
_(UDiv)\
_(UMod)\
_(DivI64)\
_(ModI64)\
_(UDivI64)\
_(UModI64)\
_(DivPowTwoI64)\
_(ModPowTwoI64)\
_(DivConstantI64)\
_(ModConstantI64)\
_(UDivConstantI64)\
_(UModConstantI64)\
_(WasmTruncateToInt64)\
_(Int64ToFloatingPoint)\
_(AddDisposableResource)\
_(CreateSuppressedError)\
_(Callee)\
_(IsConstructing)\
_(Throw)\
_(ThrowWithStack)\
_(NewArrayDynamicLength)\
_(NewTypedArrayDynamicLength)\
_(NewTypedArrayFromArray)\
_(NewTypedArrayFromArrayBuffer)\
_(NewMapObjectFromIterable)\
_(NewSetObjectFromIterable)\
_(NewBoundFunction)\
_(BoundFunctionNumArgs)\
_(Bail)\
_(EncodeSnapshot)\
_(StrictConstantCompareInt32)\
_(StrictConstantCompareBoolean)\
_(SameValueDouble)\
_(SameValue)\
_(CreateThis)\
_(GetArgumentsObjectArg)\
_(SetArgumentsObjectArg)\
_(LoadArgumentsObjectArg)\
_(LoadArgumentsObjectArgHole)\
_(InArgumentsObjectArg)\
_(ArgumentsObjectLength)\
_(ArrayFromArgumentsObject)\
_(LoadScriptedProxyHandler)\
_(CheckScriptedProxyGetResult)\
_(IdToStringOrSymbol)\
_(ReturnFromCtor)\
_(WasmAnyRefFromJSValue)\
_(WasmAnyRefFromJSObject)\
_(WasmAnyRefFromJSString)\
_(WasmAnyRefIsJSString)\
_(WasmTrapIfAnyRefIsNotJSString)\
_(WasmAnyRefJSStringLength)\
_(WasmI31RefGet)\
_(TypeOfName)\
_(ToPropertyKeyCache)\
_(BigIntToIntPtr)\
_(IntPtrToBigInt)\
_(Int32ToStringWithBase)\
_(NumberParseInt)\
_(DoubleParseInt)\
_(LinearizeString)\
_(LinearizeForCharAccess)\
_(LinearizeForCodePointAccess)\
_(ToRelativeStringIndex)\
_(CharCodeAt)\
_(CharCodeAtOrNegative)\
_(CodePointAt)\
_(CodePointAtOrNegative)\
_(NegativeToNaN)\
_(NegativeToUndefined)\
_(FromCharCode)\
_(FromCharCodeEmptyIfNegative)\
_(FromCharCodeUndefinedIfNegative)\
_(FromCodePoint)\
_(StringIncludes)\
_(StringIndexOf)\
_(StringLastIndexOf)\
_(StringStartsWith)\
_(StringEndsWith)\
_(StringTrimStartIndex)\
_(StringTrimEndIndex)\
_(StringSplit)\
_(ImplicitThis)\
_(UnaryCache)\
_(CheckOverRecursed)\
_(InterruptCheck)\
_(WasmTrap)\
_(GlobalDeclInstantiation)\
_(RegExpMatcher)\
_(RegExpSearcher)\
_(RegExpSearcherLastLimit)\
_(RegExpExecMatch)\
_(RegExpExecTest)\
_(Substr)\
_(SetFunName)\
_(Slots)\
_(Elements)\
_(InitializedLength)\
_(SetInitializedLength)\
_(ArrayLength)\
_(SetArrayLength)\
_(FunctionLength)\
_(FunctionName)\
_(ArrayBufferByteLength)\
_(ArrayBufferViewLength)\
_(ArrayBufferViewByteOffset)\
_(ArrayBufferViewElements)\
_(ArrayBufferViewElementsWithOffset)\
_(GrowableSharedArrayBufferByteLength)\
_(TypedArrayElementSize)\
_(TypedArraySet)\
_(TypedArraySetFromSubarray)\
_(GuardTypedArraySetOffset)\
_(ToIntegerIndex)\
_(ArrayPush)\
_(ArraySlice)\
_(ArgumentsSlice)\
_(NormalizeSliceTerm)\
_(ArrayJoin)\
_(HomeObjectSuperBase)\
_(BindNameCache)\
_(CallBindVar)\
_(GuardShape)\
_(HasShape)\
_(GuardFuse)\
_(GuardMultipleShapes)\
_(GuardShapeList)\
_(ProxyGet)\
_(ProxyGetByValue)\
_(ProxySet)\
_(ProxySetByValue)\
_(CallSetArrayLength)\
_(MegamorphicLoadSlot)\
_(MegamorphicLoadSlotPermissive)\
_(MegamorphicLoadSlotByValue)\
_(MegamorphicLoadSlotByValuePermissive)\
_(MegamorphicStoreSlot)\
_(MegamorphicHasProp)\
_(SmallObjectVariableKeyHasProp)\
_(GuardToArrayBuffer)\
_(GuardToSharedArrayBuffer)\
_(NurseryObject)\
_(GuardStringToIndex)\
_(GuardStringToInt32)\
_(GuardStringToDouble)\
_(FunctionEnvironment)\
_(HomeObject)\
_(AllocateAndStoreSlot)\
_(AddSlotAndCallAddPropHook)\
_(GetNameCache)\
_(CallGetIntrinsicValue)\
_(IteratorLength)\
_(LoadIteratorElement)\
_(LoadSlotByIteratorIndex)\
_(StoreSlotByIteratorIndex)\
_(LoadSlotByIteratorIndexIndexed)\
_(StoreSlotByIteratorIndexIndexed)\
_(LoadDOMExpandoValue)\
_(LoadDOMExpandoValueIgnoreGeneration)\
_(StringLength)\
_(OptimizeSpreadCallCache)\
_(IteratorMore)\
_(IteratorEnd)\
_(OptimizeGetIteratorCache)\
_(NewPrivateName)\
_(InstanceOfCache)\
_(ArgumentsLength)\
_(GetFrameArgument)\
_(GetFrameArgumentHole)\
_(NewTarget)\
_(Rest)\
_(NewNamedLambdaObject)\
_(IsConstructor)\
_(IsCrossRealmArrayConstructor)\
_(IsObject)\
_(IsNullOrUndefined)\
_(ObjectClassToString)\
_(CheckReturn)\
_(IncrementWarmUpCounter)\
_(AtomicPause)\
_(CheckIsObj)\
_(IsPackedArray)\
_(GuardElementsArePacked)\
_(GetPrototypeOf)\
_(ObjectWithProto)\
_(BuiltinObject)\
_(SuperFunction)\
_(SuperFunctionAndUnbox)\
_(InitHomeObject)\
_(IsTypedArrayConstructor)\
_(LoadValueTag)\
_(LoadWrapperTarget)\
_(LoadGetterSetterFunction)\
_(GuardIntPtrIsNonNegative)\
_(CallAddOrUpdateSparseElement)\
_(CallGetSparseElement)\
_(CallNativeGetElement)\
_(CallNativeGetElementSuper)\
_(CallObjectHasSparseElement)\
_(BigIntAsIntN)\
_(BigIntAsUintN)\
_(ToHashableNonGCThing)\
_(ToHashableString)\
_(ToHashableValue)\
_(HashNonGCThing)\
_(HashString)\
_(HashSymbol)\
_(HashBigInt)\
_(HashObject)\
_(HashValue)\
_(SetObjectHasNonBigInt)\
_(SetObjectHasBigInt)\
_(SetObjectHasValue)\
_(SetObjectHasValueVMCall)\
_(SetObjectDelete)\
_(SetObjectAdd)\
_(SetObjectSize)\
_(MapObjectHasNonBigInt)\
_(MapObjectHasBigInt)\
_(MapObjectHasValue)\
_(MapObjectHasValueVMCall)\
_(MapObjectGetNonBigInt)\
_(MapObjectGetBigInt)\
_(MapObjectGetValue)\
_(MapObjectGetValueVMCall)\
_(MapObjectDelete)\
_(MapObjectSet)\
_(MapObjectSize)\
_(WeakMapGetObject)\
_(WeakMapHasObject)\
_(WeakSetHasObject)\
_(DateFillLocalTimeSlots)\
_(DateHoursFromSecondsIntoYear)\
_(DateMinutesFromSecondsIntoYear)\
_(DateSecondsFromSecondsIntoYear)\
_(WasmBoundsCheckRange32)\
_(WasmClampTable64Address)\
_(WasmFence)\
_(WasmCallLandingPrePad)\
_(WasmUnarySimd128)\
_(TakeDisposeCapability)

#define LIR_OPCODE_CLASS_GENERATED \
class LBox : public LInstructionHelper<BOX_PIECES, 1, 0> {\
  MIRType type_;\
 public:\
  LIR_HEADER(Box)\
  static constexpr size_t PayloadIndex = 0;\
  explicit LBox(const LAllocation& payload, MIRType type) : LInstructionHelper(classOpcode), type_(type) {\
    setOperand(PayloadIndex, payload);\
  }\
  const LAllocation* payload() const { return getOperand(PayloadIndex); }\
  MIRType type() const { return type_; }\
  inline const char* extraName() const;\
};\
class LInteger : public LInstructionHelper<1, 0, 0> {\
  int32_t i32_;\
 public:\
  LIR_HEADER(Integer)\
  explicit LInteger(int32_t i32) : LInstructionHelper(classOpcode), i32_(i32) {\
  }\
  int32_t i32() const { return i32_; }\
};\
class LInteger64 : public LInstructionHelper<INT64_PIECES, 0, 0> {\
  int64_t i64_;\
 public:\
  LIR_HEADER(Integer64)\
  explicit LInteger64(int64_t i64) : LInstructionHelper(classOpcode), i64_(i64) {\
  }\
  int64_t i64() const { return i64_; }\
};\
class LPointer : public LInstructionHelper<1, 0, 0> {\
  const gc::Cell* gcptr_;\
 public:\
  LIR_HEADER(Pointer)\
  explicit LPointer(const gc::Cell* gcptr) : LInstructionHelper(classOpcode), gcptr_(gcptr) {\
  }\
  const gc::Cell* gcptr() const { return gcptr_; }\
};\
class LDouble : public LInstructionHelper<1, 0, 0> {\
  double value_;\
 public:\
  LIR_HEADER(Double)\
  explicit LDouble(double value) : LInstructionHelper(classOpcode), value_(value) {\
  }\
  double value() const { return value_; }\
};\
class LFloat32 : public LInstructionHelper<1, 0, 0> {\
  float value_;\
 public:\
  LIR_HEADER(Float32)\
  explicit LFloat32(float value) : LInstructionHelper(classOpcode), value_(value) {\
  }\
  float value() const { return value_; }\
};\
class LParameter : public LInstructionHelper<BOX_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(Parameter)\
  explicit LParameter() : LInstructionHelper(classOpcode) {\
  }\
};\
class LGoto : public LControlInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(Goto)\
  explicit LGoto(MBasicBlock* target) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, target);\
  }\
  MBasicBlock* target() const { return getSuccessor(0); }\
};\
class LNewArray : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewArray)\
  explicit LNewArray(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewArray* mir() const { return mir_->toNewArray(); };\
  inline const char* extraName() const;\
};\
class LNewIterator : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewIterator)\
  explicit LNewIterator(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewIterator* mir() const { return mir_->toNewIterator(); };\
};\
class LNewTypedArray : public LInstructionHelper<1, 0, 4> {\
 public:\
  LIR_HEADER(NewTypedArray)\
  explicit LNewTypedArray(const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MNewTypedArray* mir() const { return mir_->toNewTypedArray(); };\
};\
class LNewTypedArrayInline : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewTypedArrayInline)\
  explicit LNewTypedArrayInline(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewTypedArray* mir() const { return mir_->toNewTypedArray(); };\
};\
class LBindFunction : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(BindFunction)\
  static constexpr size_t TargetIndex = 0;\
  explicit LBindFunction(const LAllocation& target, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(TargetIndex, target);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* target() const { return getOperand(TargetIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBindFunction* mir() const { return mir_->toBindFunction(); };\
};\
class LNewObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewObject)\
  explicit LNewObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewObject* mir() const { return mir_->toNewObject(); };\
  inline const char* extraName() const;\
};\
class LNewPlainObject : public LInstructionHelper<1, 0, 3> {\
 public:\
  LIR_HEADER(NewPlainObject)\
  explicit LNewPlainObject(const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MNewPlainObject* mir() const { return mir_->toNewPlainObject(); };\
};\
class LNewArrayObject : public LInstructionHelper<1, 0, 2> {\
 public:\
  LIR_HEADER(NewArrayObject)\
  explicit LNewArrayObject(const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MNewArrayObject* mir() const { return mir_->toNewArrayObject(); };\
};\
class LNewCallObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewCallObject)\
  explicit LNewCallObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewCallObject* mir() const { return mir_->toNewCallObject(); };\
};\
class LNewMapObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewMapObject)\
  explicit LNewMapObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewMapObject* mir() const { return mir_->toNewMapObject(); };\
};\
class LNewSetObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewSetObject)\
  explicit LNewSetObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewSetObject* mir() const { return mir_->toNewSetObject(); };\
};\
class LNewStringObject : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(NewStringObject)\
  static constexpr size_t InputIndex = 0;\
  explicit LNewStringObject(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewStringObject* mir() const { return mir_->toNewStringObject(); };\
};\
class LInitElemGetterSetter : public LInstructionHelper<0, 2 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(InitElemGetterSetter)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t IdIndex = 2;\
  explicit LInitElemGetterSetter(const LAllocation& object, const LBoxAllocation& id, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setBoxOperand(IdIndex, id);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  MInitElemGetterSetter* mir() const { return mir_->toInitElemGetterSetter(); };\
};\
class LMutateProto : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(MutateProto)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LMutateProto(const LAllocation& object, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
};\
class LInitPropGetterSetter : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(InitPropGetterSetter)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LInitPropGetterSetter(const LAllocation& object, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  MInitPropGetterSetter* mir() const { return mir_->toInitPropGetterSetter(); };\
};\
class LWasmRefAsNonNull : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmRefAsNonNull)\
  static constexpr size_t RefIndex = 0;\
  explicit LWasmRefAsNonNull(const LAllocation& ref) : LInstructionHelper(classOpcode) {\
    setOperand(RefIndex, ref);\
  }\
  const LAllocation* ref() const { return getOperand(RefIndex); }\
  MWasmRefAsNonNull* mir() const { return mir_->toWasmRefAsNonNull(); };\
};\
class LWasmRefTestConcrete : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(WasmRefTestConcrete)\
  static constexpr size_t RefIndex = 0;\
  static constexpr size_t SuperSTVIndex = 1;\
  explicit LWasmRefTestConcrete(const LAllocation& ref, const LAllocation& superSTV, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(RefIndex, ref);\
    setOperand(SuperSTVIndex, superSTV);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* ref() const { return getOperand(RefIndex); }\
  const LAllocation* superSTV() const { return getOperand(SuperSTVIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MWasmRefTestConcrete* mir() const { return mir_->toWasmRefTestConcrete(); };\
};\
class LWasmRefTestAbstract : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(WasmRefTestAbstract)\
  static constexpr size_t RefIndex = 0;\
  explicit LWasmRefTestAbstract(const LAllocation& ref, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(RefIndex, ref);\
    setTemp(0, temp0);\
  }\
  const LAllocation* ref() const { return getOperand(RefIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmRefTestAbstract* mir() const { return mir_->toWasmRefTestAbstract(); };\
};\
class LWasmRefTestConcreteAndBranch : public LControlInstructionHelper<2, 2, 2> {\
  wasm::MaybeRefType sourceType_;\
  wasm::RefType destType_;\
 public:\
  LIR_HEADER(WasmRefTestConcreteAndBranch)\
  static constexpr size_t RefIndex = 0;\
  static constexpr size_t SuperSTVIndex = 1;\
  explicit LWasmRefTestConcreteAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& ref, const LAllocation& superSTV, const LDefinition& temp0, const LDefinition& temp1, wasm::MaybeRefType sourceType, wasm::RefType destType) : LControlInstructionHelper(classOpcode), sourceType_(sourceType), destType_(destType) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(RefIndex, ref);\
    setOperand(SuperSTVIndex, superSTV);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* ref() const { return getOperand(RefIndex); }\
  const LAllocation* superSTV() const { return getOperand(SuperSTVIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  wasm::MaybeRefType sourceType() const { return sourceType_; }\
  wasm::RefType destType() const { return destType_; }\
};\
class LWasmRefTestAbstractAndBranch : public LControlInstructionHelper<2, 1, 1> {\
  wasm::MaybeRefType sourceType_;\
  wasm::RefType destType_;\
 public:\
  LIR_HEADER(WasmRefTestAbstractAndBranch)\
  static constexpr size_t RefIndex = 0;\
  explicit LWasmRefTestAbstractAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& ref, const LDefinition& temp0, wasm::MaybeRefType sourceType, wasm::RefType destType) : LControlInstructionHelper(classOpcode), sourceType_(sourceType), destType_(destType) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(RefIndex, ref);\
    setTemp(0, temp0);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* ref() const { return getOperand(RefIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  wasm::MaybeRefType sourceType() const { return sourceType_; }\
  wasm::RefType destType() const { return destType_; }\
};\
class LWasmRefCastConcrete : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(WasmRefCastConcrete)\
  static constexpr size_t RefIndex = 0;\
  static constexpr size_t SuperSTVIndex = 1;\
  explicit LWasmRefCastConcrete(const LAllocation& ref, const LAllocation& superSTV, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(RefIndex, ref);\
    setOperand(SuperSTVIndex, superSTV);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* ref() const { return getOperand(RefIndex); }\
  const LAllocation* superSTV() const { return getOperand(SuperSTVIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MWasmRefCastConcrete* mir() const { return mir_->toWasmRefCastConcrete(); };\
};\
class LWasmRefCastAbstract : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(WasmRefCastAbstract)\
  static constexpr size_t RefIndex = 0;\
  explicit LWasmRefCastAbstract(const LAllocation& ref, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(RefIndex, ref);\
    setTemp(0, temp0);\
  }\
  const LAllocation* ref() const { return getOperand(RefIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmRefCastAbstract* mir() const { return mir_->toWasmRefCastAbstract(); };\
};\
class LWasmNewStructObject : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(WasmNewStructObject)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t AllocSiteIndex = 1;\
  explicit LWasmNewStructObject(const LAllocation& instance, const LAllocation& allocSite, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InstanceIndex, instance);\
    setOperand(AllocSiteIndex, allocSite);\
    setTemp(0, temp0);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LAllocation* allocSite() const { return getOperand(AllocSiteIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmNewStructObject* mir() const { return mir_->toWasmNewStructObject(); };\
};\
class LWasmNewArrayObject : public LInstructionHelper<1, 3, 2> {\
 public:\
  LIR_HEADER(WasmNewArrayObject)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t NumElementsIndex = 1;\
  static constexpr size_t AllocSiteIndex = 2;\
  explicit LWasmNewArrayObject(const LAllocation& instance, const LAllocation& numElements, const LAllocation& allocSite, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(InstanceIndex, instance);\
    setOperand(NumElementsIndex, numElements);\
    setOperand(AllocSiteIndex, allocSite);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LAllocation* numElements() const { return getOperand(NumElementsIndex); }\
  const LAllocation* allocSite() const { return getOperand(AllocSiteIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MWasmNewArrayObject* mir() const { return mir_->toWasmNewArrayObject(); };\
};\
class LReinterpretCast : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ReinterpretCast)\
  static constexpr size_t InputIndex = 0;\
  explicit LReinterpretCast(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MReinterpretCast* mir() const { return mir_->toReinterpretCast(); };\
};\
class LReinterpretCastFromI64 : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(ReinterpretCastFromI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LReinterpretCastFromI64(const LInt64Allocation& input) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  MReinterpretCast* mir() const { return mir_->toReinterpretCast(); };\
};\
class LReinterpretCastToI64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(ReinterpretCastToI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LReinterpretCastToI64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MReinterpretCast* mir() const { return mir_->toReinterpretCast(); };\
};\
class LRotate : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(Rotate)\
  static constexpr size_t InputIndex = 0;\
  static constexpr size_t CountIndex = 1;\
  explicit LRotate() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LAllocation* count() const { return getOperand(CountIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
  void setCount(const LAllocation& count) { setOperand(CountIndex, count); }\
  MRotate* mir() const { return mir_->toRotate(); };\
};\
class LRotateI64 : public LInstructionHelper<INT64_PIECES, 1 + 1 * INT64_PIECES, 1> {\
 public:\
  LIR_HEADER(RotateI64)\
  static constexpr size_t CountIndex = 0;\
  static constexpr size_t InputIndex = 1;\
  explicit LRotateI64() : LInstructionHelper(classOpcode) {\
    setTemp(0, LDefinition::BogusTemp());\
  }\
  const LAllocation* count() const { return getOperand(CountIndex); }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  void setCount(const LAllocation& count) { setOperand(CountIndex, count); }\
  void setInput(const LInt64Allocation& input) { setInt64Operand(InputIndex, input); }\
  const LDefinition* temp0() { return getTemp(0); }\
  void setTemp0(const LDefinition& temp0) { setTemp(0, temp0); }\
  MRotate* mir() const { return mir_->toRotate(); };\
};\
class LWasmStackSwitchToMain : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(WasmStackSwitchToMain)\
  static constexpr size_t SuspenderIndex = 0;\
  static constexpr size_t FnIndex = 1;\
  static constexpr size_t DataIndex = 2;\
  explicit LWasmStackSwitchToMain(const LAllocation& suspender, const LAllocation& fn, const LAllocation& data) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(SuspenderIndex, suspender);\
    setOperand(FnIndex, fn);\
    setOperand(DataIndex, data);\
  }\
  const LAllocation* suspender() const { return getOperand(SuspenderIndex); }\
  const LAllocation* fn() const { return getOperand(FnIndex); }\
  const LAllocation* data() const { return getOperand(DataIndex); }\
};\
class LWasmStackSwitchToSuspendable : public LInstructionHelper<0, 3, 0> {\
 public:\
  LIR_HEADER(WasmStackSwitchToSuspendable)\
  static constexpr size_t SuspenderIndex = 0;\
  static constexpr size_t FnIndex = 1;\
  static constexpr size_t DataIndex = 2;\
  explicit LWasmStackSwitchToSuspendable(const LAllocation& suspender, const LAllocation& fn, const LAllocation& data) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(SuspenderIndex, suspender);\
    setOperand(FnIndex, fn);\
    setOperand(DataIndex, data);\
  }\
  const LAllocation* suspender() const { return getOperand(SuspenderIndex); }\
  const LAllocation* fn() const { return getOperand(FnIndex); }\
  const LAllocation* data() const { return getOperand(DataIndex); }\
};\
class LWasmStackContinueOnSuspendable : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(WasmStackContinueOnSuspendable)\
  static constexpr size_t SuspenderIndex = 0;\
  static constexpr size_t ResultIndex = 1;\
  explicit LWasmStackContinueOnSuspendable(const LAllocation& suspender, const LAllocation& result) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(SuspenderIndex, suspender);\
    setOperand(ResultIndex, result);\
  }\
  const LAllocation* suspender() const { return getOperand(SuspenderIndex); }\
  const LAllocation* result() const { return getOperand(ResultIndex); }\
};\
class LWasmInterruptCheck : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmInterruptCheck)\
  static constexpr size_t InstanceIndex = 0;\
  explicit LWasmInterruptCheck(const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(InstanceIndex, instance);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  MWasmInterruptCheck* mir() const { return mir_->toWasmInterruptCheck(); };\
};\
class LTypeOfV : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(TypeOfV)\
  static constexpr size_t InputIndex = 0;\
  explicit LTypeOfV(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MTypeOf* mir() const { return mir_->toTypeOf(); };\
};\
class LTypeOfO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypeOfO)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LTypeOfO(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MTypeOf* mir() const { return mir_->toTypeOf(); };\
};\
class LTypeOfIsNonPrimitiveV : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(TypeOfIsNonPrimitiveV)\
  static constexpr size_t InputIndex = 0;\
  explicit LTypeOfIsNonPrimitiveV(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MTypeOfIs* mir() const { return mir_->toTypeOfIs(); };\
};\
class LTypeOfIsNonPrimitiveO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypeOfIsNonPrimitiveO)\
  static constexpr size_t InputIndex = 0;\
  explicit LTypeOfIsNonPrimitiveO(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MTypeOfIs* mir() const { return mir_->toTypeOfIs(); };\
};\
class LTypeOfIsPrimitive : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(TypeOfIsPrimitive)\
  static constexpr size_t InputIndex = 0;\
  explicit LTypeOfIsPrimitive(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MTypeOfIs* mir() const { return mir_->toTypeOfIs(); };\
};\
class LToAsyncIter : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ToAsyncIter)\
  static constexpr size_t IteratorIndex = 0;\
  static constexpr size_t NextMethodIndex = 1;\
  explicit LToAsyncIter(const LAllocation& iterator, const LBoxAllocation& nextMethod) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(IteratorIndex, iterator);\
    setBoxOperand(NextMethodIndex, nextMethod);\
  }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  LBoxAllocation nextMethod() const { return getBoxOperand(NextMethodIndex); }\
};\
class LCreateArgumentsObject : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(CreateArgumentsObject)\
  static constexpr size_t CallObjectIndex = 0;\
  explicit LCreateArgumentsObject(const LAllocation& callObject, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(CallObjectIndex, callObject);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* callObject() const { return getOperand(CallObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MCreateArgumentsObject* mir() const { return mir_->toCreateArgumentsObject(); };\
};\
class LGuardArgumentsObjectFlags : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardArgumentsObjectFlags)\
  static constexpr size_t ArgsObjectIndex = 0;\
  explicit LGuardArgumentsObjectFlags(const LAllocation& argsObject, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ArgsObjectIndex, argsObject);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardArgumentsObjectFlags* mir() const { return mir_->toGuardArgumentsObjectFlags(); };\
};\
class LGuardObjectHasSameRealm : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardObjectHasSameRealm)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardObjectHasSameRealm(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardObjectHasSameRealm* mir() const { return mir_->toGuardObjectHasSameRealm(); };\
};\
class LGuardBoundFunctionIsConstructor : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardBoundFunctionIsConstructor)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardBoundFunctionIsConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
};\
class LBoxNonStrictThis : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(BoxNonStrictThis)\
  static constexpr size_t ValueIndex = 0;\
  explicit LBoxNonStrictThis(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MBoxNonStrictThis* mir() const { return mir_->toBoxNonStrictThis(); };\
};\
class LStackArgT : public LInstructionHelper<0, 1, 0> {\
  uint32_t argslot_;\
  MIRType type_;\
 public:\
  LIR_HEADER(StackArgT)\
  static constexpr size_t ArgIndex = 0;\
  explicit LStackArgT(const LAllocation& arg, uint32_t argslot, MIRType type) : LInstructionHelper(classOpcode), argslot_(argslot), type_(type) {\
    setOperand(ArgIndex, arg);\
  }\
  const LAllocation* arg() const { return getOperand(ArgIndex); }\
  uint32_t argslot() const { return argslot_; }\
  MIRType type() const { return type_; }\
};\
class LStackArgV : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
  uint32_t argslot_;\
 public:\
  LIR_HEADER(StackArgV)\
  static constexpr size_t ValueIndex = 0;\
  explicit LStackArgV(const LBoxAllocation& value, uint32_t argslot) : LInstructionHelper(classOpcode), argslot_(argslot) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  uint32_t argslot() const { return argslot_; }\
};\
class LUnreachable : public LControlInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(Unreachable)\
  explicit LUnreachable() : LControlInstructionHelper(classOpcode) {\
  }\
};\
class LUnreachableResultV : public LInstructionHelper<BOX_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(UnreachableResultV)\
  explicit LUnreachableResultV() : LInstructionHelper(classOpcode) {\
  }\
};\
class LUnreachableResultT : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(UnreachableResultT)\
  explicit LUnreachableResultT() : LInstructionHelper(classOpcode) {\
  }\
};\
class LGetDOMProperty : public LInstructionHelper<BOX_PIECES, 1, 3> {\
 public:\
  LIR_HEADER(GetDOMProperty)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGetDOMProperty(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MGetDOMProperty* mir() const { return mir_->toGetDOMProperty(); };\
};\
class LGetDOMMemberV : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(GetDOMMemberV)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGetDOMMemberV(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MGetDOMMember* mir() const { return mir_->toGetDOMMember(); };\
};\
class LGetDOMMemberT : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GetDOMMemberT)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGetDOMMemberT(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MGetDOMMember* mir() const { return mir_->toGetDOMMember(); };\
};\
class LSetDOMProperty : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(SetDOMProperty)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LSetDOMProperty(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MSetDOMProperty* mir() const { return mir_->toSetDOMProperty(); };\
};\
class LLoadDOMExpandoValueGuardGeneration : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDOMExpandoValueGuardGeneration)\
  static constexpr size_t ProxyIndex = 0;\
  explicit LLoadDOMExpandoValueGuardGeneration(const LAllocation& proxy) : LInstructionHelper(classOpcode) {\
    setOperand(ProxyIndex, proxy);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  MLoadDOMExpandoValueGuardGeneration* mir() const { return mir_->toLoadDOMExpandoValueGuardGeneration(); };\
};\
class LGuardDOMExpandoMissingOrGuardShape : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(GuardDOMExpandoMissingOrGuardShape)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardDOMExpandoMissingOrGuardShape(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardDOMExpandoMissingOrGuardShape* mir() const { return mir_->toGuardDOMExpandoMissingOrGuardShape(); };\
};\
class LTestIAndBranch : public LControlInstructionHelper<2, 1, 0> {\
 public:\
  LIR_HEADER(TestIAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestIAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LTestIPtrAndBranch : public LControlInstructionHelper<2, 1, 0> {\
 public:\
  LIR_HEADER(TestIPtrAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestIPtrAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LTestI64AndBranch : public LControlInstructionHelper<2, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(TestI64AndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestI64AndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LInt64Allocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setInt64Operand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
};\
class LTestDAndBranch : public LControlInstructionHelper<2, 1, 0> {\
 public:\
  LIR_HEADER(TestDAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestDAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LTestFAndBranch : public LControlInstructionHelper<2, 1, 0> {\
 public:\
  LIR_HEADER(TestFAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestFAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LTestBIAndBranch : public LControlInstructionHelper<2, 1, 0> {\
 public:\
  LIR_HEADER(TestBIAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestBIAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LTestOAndBranch : public LControlInstructionHelper<2, 1, 1> {\
 public:\
  LIR_HEADER(TestOAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestOAndBranch(MBasicBlock* ifTruthy, MBasicBlock* ifFalsy, const LAllocation& input, const LDefinition& temp0) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTruthy);\
    setSuccessor(1, ifFalsy);\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  MBasicBlock* ifTruthy() const { return getSuccessor(0); }\
  MBasicBlock* ifFalsy() const { return getSuccessor(1); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MTest* mir() const { return mir_->toTest(); };\
};\
class LTestVAndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(TestVAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LTestVAndBranch(MBasicBlock* ifTruthy, MBasicBlock* ifFalsy, const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTruthy);\
    setSuccessor(1, ifFalsy);\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  MBasicBlock* ifTruthy() const { return getSuccessor(0); }\
  MBasicBlock* ifFalsy() const { return getSuccessor(1); }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MTest* mir() const { return mir_->toTest(); };\
};\
class LCompare : public LInstructionHelper<1, 2, 0> {\
  JSOp jsop_;\
 public:\
  LIR_HEADER(Compare)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompare(const LAllocation& left, const LAllocation& right, JSOp jsop) : LInstructionHelper(classOpcode), jsop_(jsop) {\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  JSOp jsop() const { return jsop_; }\
  MCompare* mir() const { return mir_->toCompare(); };\
  inline const char* extraName() const;\
};\
class LCompareI64 : public LInstructionHelper<1, 0 + 2 * INT64_PIECES, 0> {\
  JSOp jsop_;\
 public:\
  LIR_HEADER(CompareI64)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1 * INT64_PIECES;\
  explicit LCompareI64(const LInt64Allocation& left, const LInt64Allocation& right, JSOp jsop) : LInstructionHelper(classOpcode), jsop_(jsop) {\
    setInt64Operand(LeftIndex, left);\
    setInt64Operand(RightIndex, right);\
  }\
  LInt64Allocation left() const { return getInt64Operand(LeftIndex); }\
  LInt64Allocation right() const { return getInt64Operand(RightIndex); }\
  JSOp jsop() const { return jsop_; }\
  MCompare* mir() const { return mir_->toCompare(); };\
  inline const char* extraName() const;\
};\
class LCompareI64AndBranch : public LControlInstructionHelper<2, 0 + 2 * INT64_PIECES, 0> {\
  MCompare* cmpMir_;\
  JSOp jsop_;\
 public:\
  LIR_HEADER(CompareI64AndBranch)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1 * INT64_PIECES;\
  explicit LCompareI64AndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LInt64Allocation& left, const LInt64Allocation& right, MCompare* cmpMir, JSOp jsop) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir), jsop_(jsop) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setInt64Operand(LeftIndex, left);\
    setInt64Operand(RightIndex, right);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LInt64Allocation left() const { return getInt64Operand(LeftIndex); }\
  LInt64Allocation right() const { return getInt64Operand(RightIndex); }\
  MCompare* cmpMir() const { return cmpMir_; }\
  JSOp jsop() const { return jsop_; }\
  MTest* mir() const { return mir_->toTest(); };\
  inline const char* extraName() const;\
};\
class LCompareAndBranch : public LControlInstructionHelper<2, 2, 0> {\
  MCompare* cmpMir_;\
  JSOp jsop_;\
 public:\
  LIR_HEADER(CompareAndBranch)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& left, const LAllocation& right, MCompare* cmpMir, JSOp jsop) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir), jsop_(jsop) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* cmpMir() const { return cmpMir_; }\
  JSOp jsop() const { return jsop_; }\
  MTest* mir() const { return mir_->toTest(); };\
  inline const char* extraName() const;\
};\
class LCompareD : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareD)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareD(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareF : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareF)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareF(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareDAndBranch : public LControlInstructionHelper<2, 2, 0> {\
  MCompare* cmpMir_;\
 public:\
  LIR_HEADER(CompareDAndBranch)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareDAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& left, const LAllocation& right, MCompare* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* cmpMir() const { return cmpMir_; }\
};\
class LCompareFAndBranch : public LControlInstructionHelper<2, 2, 0> {\
  MCompare* cmpMir_;\
 public:\
  LIR_HEADER(CompareFAndBranch)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareFAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& left, const LAllocation& right, MCompare* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* cmpMir() const { return cmpMir_; }\
};\
class LCompareS : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareS)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareS(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareSInline : public LInstructionHelper<1, 1, 0> {\
  JSOffThreadAtom* constant_;\
 public:\
  LIR_HEADER(CompareSInline)\
  static constexpr size_t InputIndex = 0;\
  explicit LCompareSInline(const LAllocation& input, JSOffThreadAtom* constant) : LInstructionHelper(classOpcode), constant_(constant) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  JSOffThreadAtom* constant() const { return constant_; }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareSSingle : public LInstructionHelper<1, 1, 1> {\
  JSOp jsop_;\
  JSOffThreadAtom* constant_;\
 public:\
  LIR_HEADER(CompareSSingle)\
  static constexpr size_t InputIndex = 0;\
  explicit LCompareSSingle(const LAllocation& input, const LDefinition& temp0, JSOp jsop, JSOffThreadAtom* constant) : LInstructionHelper(classOpcode), jsop_(jsop), constant_(constant) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  JSOp jsop() const { return jsop_; }\
  JSOffThreadAtom* constant() const { return constant_; }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareBigInt : public LInstructionHelper<1, 2, 3> {\
 public:\
  LIR_HEADER(CompareBigInt)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareBigInt(const LAllocation& left, const LAllocation& right, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareBigIntInt32 : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CompareBigIntInt32)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareBigIntInt32(const LAllocation& left, const LAllocation& right, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareBigIntDouble : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareBigIntDouble)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareBigIntDouble(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareBigIntString : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareBigIntString)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareBigIntString(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LCompareBigIntInt32AndBranch : public LControlInstructionHelper<2, 2, 2> {\
  MCompare* cmpMir_;\
 public:\
  LIR_HEADER(CompareBigIntInt32AndBranch)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LCompareBigIntInt32AndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& left, const LAllocation& right, const LDefinition& temp0, const LDefinition& temp1, MCompare* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCompare* cmpMir() const { return cmpMir_; }\
};\
class LStrictConstantCompareInt32AndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 0> {\
  MStrictConstantCompareInt32* cmpMir_;\
 public:\
  LIR_HEADER(StrictConstantCompareInt32AndBranch)\
  static constexpr size_t ValueIndex = 0;\
  explicit LStrictConstantCompareInt32AndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& value, MStrictConstantCompareInt32* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(ValueIndex, value);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MStrictConstantCompareInt32* cmpMir() const { return cmpMir_; }\
  MTest* mir() const { return mir_->toTest(); };\
  inline const char* extraName() const;\
};\
class LStrictConstantCompareBooleanAndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 0> {\
  MStrictConstantCompareBoolean* cmpMir_;\
 public:\
  LIR_HEADER(StrictConstantCompareBooleanAndBranch)\
  static constexpr size_t ValueIndex = 0;\
  explicit LStrictConstantCompareBooleanAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& value, MStrictConstantCompareBoolean* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(ValueIndex, value);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MStrictConstantCompareBoolean* cmpMir() const { return cmpMir_; }\
  MTest* mir() const { return mir_->toTest(); };\
  inline const char* extraName() const;\
};\
class LBitAndAndBranch : public LControlInstructionHelper<2, 2, 0> {\
  Assembler::Condition cond_;\
 public:\
  LIR_HEADER(BitAndAndBranch)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LBitAndAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& left, const LAllocation& right, Assembler::Condition cond) : LControlInstructionHelper(classOpcode), cond_(cond) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  Assembler::Condition cond() const { return cond_; }\
};\
class LBitAnd64AndBranch : public LControlInstructionHelper<2, 0 + 2 * INT64_PIECES, 0> {\
  Assembler::Condition cond_;\
 public:\
  LIR_HEADER(BitAnd64AndBranch)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1 * INT64_PIECES;\
  explicit LBitAnd64AndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LInt64Allocation& left, const LInt64Allocation& right, Assembler::Condition cond) : LControlInstructionHelper(classOpcode), cond_(cond) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setInt64Operand(LeftIndex, left);\
    setInt64Operand(RightIndex, right);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LInt64Allocation left() const { return getInt64Operand(LeftIndex); }\
  LInt64Allocation right() const { return getInt64Operand(RightIndex); }\
  Assembler::Condition cond() const { return cond_; }\
};\
class LIsNullOrLikeUndefinedV : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(IsNullOrLikeUndefinedV)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsNullOrLikeUndefinedV(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LIsNullOrLikeUndefinedT : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsNullOrLikeUndefinedT)\
  static constexpr size_t InputIndex = 0;\
  explicit LIsNullOrLikeUndefinedT(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LIsNull : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(IsNull)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsNull(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LIsUndefined : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(IsUndefined)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsUndefined(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
class LIsNullOrLikeUndefinedAndBranchV : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 2> {\
  MCompare* cmpMir_;\
 public:\
  LIR_HEADER(IsNullOrLikeUndefinedAndBranchV)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsNullOrLikeUndefinedAndBranchV(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1, MCompare* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCompare* cmpMir() const { return cmpMir_; }\
  MTest* mir() const { return mir_->toTest(); };\
};\
class LIsNullOrLikeUndefinedAndBranchT : public LControlInstructionHelper<2, 1, 1> {\
  MCompare* cmpMir_;\
 public:\
  LIR_HEADER(IsNullOrLikeUndefinedAndBranchT)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsNullOrLikeUndefinedAndBranchT(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& value, const LDefinition& temp0, MCompare* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MCompare* cmpMir() const { return cmpMir_; }\
  MTest* mir() const { return mir_->toTest(); };\
};\
class LIsNullAndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 0> {\
  MCompare* cmpMir_;\
 public:\
  LIR_HEADER(IsNullAndBranch)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsNullAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& value, MCompare* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(ValueIndex, value);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MCompare* cmpMir() const { return cmpMir_; }\
};\
class LIsUndefinedAndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 0> {\
  MCompare* cmpMir_;\
 public:\
  LIR_HEADER(IsUndefinedAndBranch)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsUndefinedAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& value, MCompare* cmpMir) : LControlInstructionHelper(classOpcode), cmpMir_(cmpMir) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(ValueIndex, value);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MCompare* cmpMir() const { return cmpMir_; }\
};\
class LNotI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotI)\
  static constexpr size_t InputIndex = 0;\
  explicit LNotI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LNotIPtr : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotIPtr)\
  static constexpr size_t InputIndex = 0;\
  explicit LNotIPtr(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LNotI64 : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(NotI64)\
  static constexpr size_t InputI64Index = 0;\
  explicit LNotI64(const LInt64Allocation& inputI64) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputI64Index, inputI64);\
  }\
  LInt64Allocation inputI64() const { return getInt64Operand(InputI64Index); }\
};\
class LNotD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotD)\
  static constexpr size_t InputIndex = 0;\
  explicit LNotD(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
class LNotF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotF)\
  static constexpr size_t InputIndex = 0;\
  explicit LNotF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
class LNotBI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotBI)\
  static constexpr size_t InputIndex = 0;\
  explicit LNotBI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
class LNotO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotO)\
  static constexpr size_t InputIndex = 0;\
  explicit LNotO(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
class LNotV : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(NotV)\
  static constexpr size_t InputIndex = 0;\
  explicit LNotV(const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
class LBitNotI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BitNotI)\
  static constexpr size_t InputIndex = 0;\
  explicit LBitNotI() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
};\
class LBitNotI64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(BitNotI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LBitNotI64() : LInstructionHelper(classOpcode) {\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  void setInput(const LInt64Allocation& input) { setInt64Operand(InputIndex, input); }\
};\
class LBitOpI : public LInstructionHelper<1, 2, 0> {\
  JSOp bitop_;\
 public:\
  LIR_HEADER(BitOpI)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBitOpI(JSOp bitop) : LInstructionHelper(classOpcode), bitop_(bitop) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
  JSOp bitop() const { return bitop_; }\
  inline const char* extraName() const;\
};\
class LBitOpI64 : public LInstructionHelper<INT64_PIECES, 0 + 2 * INT64_PIECES, 0> {\
  JSOp bitop_;\
 public:\
  LIR_HEADER(BitOpI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1 * INT64_PIECES;\
  explicit LBitOpI64(JSOp bitop) : LInstructionHelper(classOpcode), bitop_(bitop) {\
  }\
  LInt64Allocation lhs() const { return getInt64Operand(LhsIndex); }\
  LInt64Allocation rhs() const { return getInt64Operand(RhsIndex); }\
  void setLhs(const LInt64Allocation& lhs) { setInt64Operand(LhsIndex, lhs); }\
  void setRhs(const LInt64Allocation& rhs) { setInt64Operand(RhsIndex, rhs); }\
  JSOp bitop() const { return bitop_; }\
  inline const char* extraName() const;\
};\
class LShiftI : public LInstructionHelper<1, 2, 0> {\
  JSOp bitop_;\
 public:\
  LIR_HEADER(ShiftI)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LShiftI(JSOp bitop) : LInstructionHelper(classOpcode), bitop_(bitop) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
  JSOp bitop() const { return bitop_; }\
  MInstruction* mir() const { return mir_->toInstruction(); };\
  inline const char* extraName() const;\
};\
class LShiftIntPtr : public LInstructionHelper<1, 2, 0> {\
  JSOp bitop_;\
 public:\
  LIR_HEADER(ShiftIntPtr)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LShiftIntPtr(JSOp bitop) : LInstructionHelper(classOpcode), bitop_(bitop) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
  JSOp bitop() const { return bitop_; }\
  MInstruction* mir() const { return mir_->toInstruction(); };\
  inline const char* extraName() const;\
};\
class LShiftI64 : public LInstructionHelper<INT64_PIECES, 1 + 1 * INT64_PIECES, 0> {\
  JSOp bitop_;\
 public:\
  LIR_HEADER(ShiftI64)\
  static constexpr size_t RhsIndex = 0;\
  static constexpr size_t LhsIndex = 1;\
  explicit LShiftI64(JSOp bitop) : LInstructionHelper(classOpcode), bitop_(bitop) {\
  }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  LInt64Allocation lhs() const { return getInt64Operand(LhsIndex); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
  void setLhs(const LInt64Allocation& lhs) { setInt64Operand(LhsIndex, lhs); }\
  JSOp bitop() const { return bitop_; }\
  MInstruction* mir() const { return mir_->toInstruction(); };\
  inline const char* extraName() const;\
};\
class LSignExtendInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SignExtendInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LSignExtendInt32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MSignExtendInt32* mir() const { return mir_->toSignExtendInt32(); };\
};\
class LSignExtendIntPtr : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SignExtendIntPtr)\
  static constexpr size_t InputIndex = 0;\
  explicit LSignExtendIntPtr(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MSignExtendIntPtr* mir() const { return mir_->toSignExtendIntPtr(); };\
};\
class LSignExtendInt64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(SignExtendInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LSignExtendInt64(const LInt64Allocation& input) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  MSignExtendInt64* mir() const { return mir_->toSignExtendInt64(); };\
};\
class LUrshD : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(UrshD)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LUrshD(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LMinMaxI : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(MinMaxI)\
  static constexpr size_t FirstIndex = 0;\
  static constexpr size_t SecondIndex = 1;\
  explicit LMinMaxI(const LAllocation& first, const LAllocation& second) : LInstructionHelper(classOpcode) {\
    setOperand(FirstIndex, first);\
    setOperand(SecondIndex, second);\
  }\
  const LAllocation* first() const { return getOperand(FirstIndex); }\
  const LAllocation* second() const { return getOperand(SecondIndex); }\
  MMinMax* mir() const { return mir_->toMinMax(); };\
  inline const char* extraName() const;\
};\
class LMinMaxIntPtr : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(MinMaxIntPtr)\
  static constexpr size_t FirstIndex = 0;\
  static constexpr size_t SecondIndex = 1;\
  explicit LMinMaxIntPtr(const LAllocation& first, const LAllocation& second) : LInstructionHelper(classOpcode) {\
    setOperand(FirstIndex, first);\
    setOperand(SecondIndex, second);\
  }\
  const LAllocation* first() const { return getOperand(FirstIndex); }\
  const LAllocation* second() const { return getOperand(SecondIndex); }\
  MMinMax* mir() const { return mir_->toMinMax(); };\
  inline const char* extraName() const;\
};\
class LMinMaxD : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(MinMaxD)\
  static constexpr size_t FirstIndex = 0;\
  static constexpr size_t SecondIndex = 1;\
  explicit LMinMaxD(const LAllocation& first, const LAllocation& second) : LInstructionHelper(classOpcode) {\
    setOperand(FirstIndex, first);\
    setOperand(SecondIndex, second);\
  }\
  const LAllocation* first() const { return getOperand(FirstIndex); }\
  const LAllocation* second() const { return getOperand(SecondIndex); }\
  MMinMax* mir() const { return mir_->toMinMax(); };\
  inline const char* extraName() const;\
};\
class LMinMaxF : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(MinMaxF)\
  static constexpr size_t FirstIndex = 0;\
  static constexpr size_t SecondIndex = 1;\
  explicit LMinMaxF(const LAllocation& first, const LAllocation& second) : LInstructionHelper(classOpcode) {\
    setOperand(FirstIndex, first);\
    setOperand(SecondIndex, second);\
  }\
  const LAllocation* first() const { return getOperand(FirstIndex); }\
  const LAllocation* second() const { return getOperand(SecondIndex); }\
  MMinMax* mir() const { return mir_->toMinMax(); };\
  inline const char* extraName() const;\
};\
class LMinMaxArrayI : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(MinMaxArrayI)\
  static constexpr size_t ArrayIndex = 0;\
  explicit LMinMaxArrayI(const LAllocation& array, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(ArrayIndex, array);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* array() const { return getOperand(ArrayIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MMinMaxArray* mir() const { return mir_->toMinMaxArray(); };\
};\
class LMinMaxArrayD : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(MinMaxArrayD)\
  static constexpr size_t ArrayIndex = 0;\
  explicit LMinMaxArrayD(const LAllocation& array, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(ArrayIndex, array);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* array() const { return getOperand(ArrayIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MMinMaxArray* mir() const { return mir_->toMinMaxArray(); };\
};\
class LNegI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NegI)\
  static constexpr size_t InputIndex = 0;\
  explicit LNegI() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
};\
class LNegI64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(NegI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LNegI64() : LInstructionHelper(classOpcode) {\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  void setInput(const LInt64Allocation& input) { setInt64Operand(InputIndex, input); }\
};\
class LNegD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NegD)\
  static constexpr size_t InputIndex = 0;\
  explicit LNegD() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
};\
class LNegF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NegF)\
  static constexpr size_t InputIndex = 0;\
  explicit LNegF() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
};\
class LAbsI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AbsI)\
  static constexpr size_t InputIndex = 0;\
  explicit LAbsI() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
  MAbs* mir() const { return mir_->toAbs(); };\
};\
class LAbsD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AbsD)\
  static constexpr size_t InputIndex = 0;\
  explicit LAbsD() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
};\
class LAbsF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AbsF)\
  static constexpr size_t InputIndex = 0;\
  explicit LAbsF() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  void setInput(const LAllocation& input) { setOperand(InputIndex, input); }\
};\
class LCopySignD : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CopySignD)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LCopySignD() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
};\
class LCopySignF : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CopySignF)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LCopySignF() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
};\
class LClzI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ClzI)\
  static constexpr size_t InputIndex = 0;\
  explicit LClzI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MClz* mir() const { return mir_->toClz(); };\
};\
class LClzI64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(ClzI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LClzI64(const LInt64Allocation& input) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  MClz* mir() const { return mir_->toClz(); };\
};\
class LCtzI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CtzI)\
  static constexpr size_t InputIndex = 0;\
  explicit LCtzI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MCtz* mir() const { return mir_->toCtz(); };\
};\
class LCtzI64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(CtzI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LCtzI64(const LInt64Allocation& input) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  MCtz* mir() const { return mir_->toCtz(); };\
};\
class LPopcntI : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(PopcntI)\
  static constexpr size_t InputIndex = 0;\
  explicit LPopcntI(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPopcnt* mir() const { return mir_->toPopcnt(); };\
};\
class LPopcntI64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * INT64_PIECES, 1> {\
 public:\
  LIR_HEADER(PopcntI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LPopcntI64(const LInt64Allocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPopcnt* mir() const { return mir_->toPopcnt(); };\
};\
class LSqrtD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SqrtD)\
  static constexpr size_t InputIndex = 0;\
  explicit LSqrtD(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LSqrtF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SqrtF)\
  static constexpr size_t InputIndex = 0;\
  explicit LSqrtF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LAtan2D : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(Atan2D)\
  static constexpr size_t YIndex = 0;\
  static constexpr size_t XIndex = 1;\
  explicit LAtan2D(const LAllocation& y, const LAllocation& x) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(YIndex, y);\
    setOperand(XIndex, x);\
  }\
  const LAllocation* y() const { return getOperand(YIndex); }\
  const LAllocation* x() const { return getOperand(XIndex); }\
};\
class LPowI : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(PowI)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t PowerIndex = 1;\
  explicit LPowI(const LAllocation& value, const LAllocation& power) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ValueIndex, value);\
    setOperand(PowerIndex, power);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* power() const { return getOperand(PowerIndex); }\
};\
class LPowII : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(PowII)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t PowerIndex = 1;\
  explicit LPowII(const LAllocation& value, const LAllocation& power, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ValueIndex, value);\
    setOperand(PowerIndex, power);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* power() const { return getOperand(PowerIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MPow* mir() const { return mir_->toPow(); };\
};\
class LPowD : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(PowD)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t PowerIndex = 1;\
  explicit LPowD(const LAllocation& value, const LAllocation& power) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ValueIndex, value);\
    setOperand(PowerIndex, power);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* power() const { return getOperand(PowerIndex); }\
};\
class LPowOfTwoI : public LInstructionHelper<1, 1, 0> {\
  uint32_t base_;\
 public:\
  LIR_HEADER(PowOfTwoI)\
  static constexpr size_t PowerIndex = 0;\
  explicit LPowOfTwoI(const LAllocation& power, uint32_t base) : LInstructionHelper(classOpcode), base_(base) {\
    setOperand(PowerIndex, power);\
  }\
  const LAllocation* power() const { return getOperand(PowerIndex); }\
  uint32_t base() const { return base_; }\
};\
class LSignI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SignI)\
  static constexpr size_t InputIndex = 0;\
  explicit LSignI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LSignD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SignD)\
  static constexpr size_t InputIndex = 0;\
  explicit LSignD(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LSignDI : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(SignDI)\
  static constexpr size_t InputIndex = 0;\
  explicit LSignDI(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LSignID : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(SignID)\
  static constexpr size_t InputIndex = 0;\
  explicit LSignID(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LMathFunctionD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(MathFunctionD)\
  static constexpr size_t InputIndex = 0;\
  explicit LMathFunctionD(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MMathFunction* mir() const { return mir_->toMathFunction(); };\
  inline const char* extraName() const;\
};\
class LMathFunctionF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(MathFunctionF)\
  static constexpr size_t InputIndex = 0;\
  explicit LMathFunctionF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MMathFunction* mir() const { return mir_->toMathFunction(); };\
  inline const char* extraName() const;\
};\
class LAddI64 : public LInstructionHelper<INT64_PIECES, 0 + 2 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(AddI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1 * INT64_PIECES;\
  explicit LAddI64() : LInstructionHelper(classOpcode) {\
  }\
  LInt64Allocation lhs() const { return getInt64Operand(LhsIndex); }\
  LInt64Allocation rhs() const { return getInt64Operand(RhsIndex); }\
  void setLhs(const LInt64Allocation& lhs) { setInt64Operand(LhsIndex, lhs); }\
  void setRhs(const LInt64Allocation& rhs) { setInt64Operand(RhsIndex, rhs); }\
};\
class LAddIntPtr : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(AddIntPtr)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LAddIntPtr() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
};\
class LSubI64 : public LInstructionHelper<INT64_PIECES, 0 + 2 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(SubI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1 * INT64_PIECES;\
  explicit LSubI64() : LInstructionHelper(classOpcode) {\
  }\
  LInt64Allocation lhs() const { return getInt64Operand(LhsIndex); }\
  LInt64Allocation rhs() const { return getInt64Operand(RhsIndex); }\
  void setLhs(const LInt64Allocation& lhs) { setInt64Operand(LhsIndex, lhs); }\
  void setRhs(const LInt64Allocation& rhs) { setInt64Operand(RhsIndex, rhs); }\
};\
class LSubIntPtr : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(SubIntPtr)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LSubIntPtr() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
};\
class LMulI64 : public LInstructionHelper<INT64_PIECES, 0 + 2 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(MulI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1 * INT64_PIECES;\
  explicit LMulI64() : LInstructionHelper(classOpcode) {\
  }\
  LInt64Allocation lhs() const { return getInt64Operand(LhsIndex); }\
  LInt64Allocation rhs() const { return getInt64Operand(RhsIndex); }\
  void setLhs(const LInt64Allocation& lhs) { setInt64Operand(LhsIndex, lhs); }\
  void setRhs(const LInt64Allocation& rhs) { setInt64Operand(RhsIndex, rhs); }\
};\
class LMulIntPtr : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(MulIntPtr)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LMulIntPtr() : LInstructionHelper(classOpcode) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
};\
class LMathD : public LInstructionHelper<1, 2, 0> {\
  JSOp jsop_;\
 public:\
  LIR_HEADER(MathD)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LMathD(JSOp jsop) : LInstructionHelper(classOpcode), jsop_(jsop) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
  JSOp jsop() const { return jsop_; }\
  inline const char* extraName() const;\
};\
class LMathF : public LInstructionHelper<1, 2, 0> {\
  JSOp jsop_;\
 public:\
  LIR_HEADER(MathF)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LMathF(JSOp jsop) : LInstructionHelper(classOpcode), jsop_(jsop) {\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  void setLhs(const LAllocation& lhs) { setOperand(LhsIndex, lhs); }\
  void setRhs(const LAllocation& rhs) { setOperand(RhsIndex, rhs); }\
  JSOp jsop() const { return jsop_; }\
  inline const char* extraName() const;\
};\
class LModD : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(ModD)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LModD(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LModPowTwoD : public LInstructionHelper<1, 1, 0> {\
  uint32_t divisor_;\
 public:\
  LIR_HEADER(ModPowTwoD)\
  static constexpr size_t LhsIndex = 0;\
  explicit LModPowTwoD(const LAllocation& lhs, uint32_t divisor) : LInstructionHelper(classOpcode), divisor_(divisor) {\
    setOperand(LhsIndex, lhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  uint32_t divisor() const { return divisor_; }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LWasmBuiltinModD : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(WasmBuiltinModD)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  static constexpr size_t InstanceIndex = 2;\
  explicit LWasmBuiltinModD(const LAllocation& lhs, const LAllocation& rhs, const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setOperand(InstanceIndex, instance);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  MWasmBuiltinModD* mir() const { return mir_->toWasmBuiltinModD(); };\
};\
class LBigIntAdd : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntAdd)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntAdd(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntAdd* mir() const { return mir_->toBigIntAdd(); };\
};\
class LBigIntSub : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntSub)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntSub(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntSub* mir() const { return mir_->toBigIntSub(); };\
};\
class LBigIntMul : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntMul)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntMul(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntMul* mir() const { return mir_->toBigIntMul(); };\
};\
class LBigIntDiv : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntDiv)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntDiv(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntDiv* mir() const { return mir_->toBigIntDiv(); };\
};\
class LBigIntMod : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntMod)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntMod(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntMod* mir() const { return mir_->toBigIntMod(); };\
};\
class LBigIntPow : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntPow)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPow(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntPow* mir() const { return mir_->toBigIntPow(); };\
};\
class LBigIntBitAnd : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntBitAnd)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntBitAnd(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntBitAnd* mir() const { return mir_->toBigIntBitAnd(); };\
};\
class LBigIntBitOr : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntBitOr)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntBitOr(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntBitOr* mir() const { return mir_->toBigIntBitOr(); };\
};\
class LBigIntBitXor : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntBitXor)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntBitXor(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntBitXor* mir() const { return mir_->toBigIntBitXor(); };\
};\
class LBigIntLsh : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntLsh)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntLsh(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntLsh* mir() const { return mir_->toBigIntLsh(); };\
};\
class LBigIntRsh : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntRsh)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntRsh(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntRsh* mir() const { return mir_->toBigIntRsh(); };\
};\
class LBigIntIncrement : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BigIntIncrement)\
  static constexpr size_t InputIndex = 0;\
  explicit LBigIntIncrement(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MBigIntIncrement* mir() const { return mir_->toBigIntIncrement(); };\
};\
class LBigIntDecrement : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BigIntDecrement)\
  static constexpr size_t InputIndex = 0;\
  explicit LBigIntDecrement(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MBigIntDecrement* mir() const { return mir_->toBigIntDecrement(); };\
};\
class LBigIntNegate : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(BigIntNegate)\
  static constexpr size_t InputIndex = 0;\
  explicit LBigIntNegate(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MBigIntNegate* mir() const { return mir_->toBigIntNegate(); };\
};\
class LBigIntBitNot : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BigIntBitNot)\
  static constexpr size_t InputIndex = 0;\
  explicit LBigIntBitNot(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MBigIntBitNot* mir() const { return mir_->toBigIntBitNot(); };\
};\
class LBigIntPtrAdd : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntPtrAdd)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrAdd(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntPtrAdd* mir() const { return mir_->toBigIntPtrAdd(); };\
};\
class LBigIntPtrSub : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntPtrSub)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrSub(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntPtrSub* mir() const { return mir_->toBigIntPtrSub(); };\
};\
class LBigIntPtrMul : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntPtrMul)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrMul(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntPtrMul* mir() const { return mir_->toBigIntPtrMul(); };\
};\
class LBigIntPtrDiv : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(BigIntPtrDiv)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrDiv(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBigIntPtrDiv* mir() const { return mir_->toBigIntPtrDiv(); };\
};\
class LBigIntPtrDivPowTwo : public LInstructionHelper<1, 1, 0> {\
  int32_t shift_;\
  bool negativeDivisor_;\
 public:\
  LIR_HEADER(BigIntPtrDivPowTwo)\
  static constexpr size_t LhsIndex = 0;\
  explicit LBigIntPtrDivPowTwo(const LAllocation& lhs, int32_t shift, bool negativeDivisor) : LInstructionHelper(classOpcode), shift_(shift), negativeDivisor_(negativeDivisor) {\
    setOperand(LhsIndex, lhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  int32_t shift() const { return shift_; }\
  bool negativeDivisor() const { return negativeDivisor_; }\
};\
class LBigIntPtrMod : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(BigIntPtrMod)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrMod(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBigIntPtrMod* mir() const { return mir_->toBigIntPtrMod(); };\
};\
class LBigIntPtrModPowTwo : public LInstructionHelper<1, 1, 1> {\
  int32_t shift_;\
 public:\
  LIR_HEADER(BigIntPtrModPowTwo)\
  static constexpr size_t LhsIndex = 0;\
  explicit LBigIntPtrModPowTwo(const LAllocation& lhs, const LDefinition& temp0, int32_t shift) : LInstructionHelper(classOpcode), shift_(shift) {\
    setOperand(LhsIndex, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  int32_t shift() const { return shift_; }\
};\
class LBigIntPtrPow : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(BigIntPtrPow)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrPow(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBigIntPtrPow* mir() const { return mir_->toBigIntPtrPow(); };\
};\
class LBigIntPtrBitAnd : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntPtrBitAnd)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrBitAnd(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntPtrBitAnd* mir() const { return mir_->toBigIntPtrBitAnd(); };\
};\
class LBigIntPtrBitOr : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntPtrBitOr)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrBitOr(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntPtrBitOr* mir() const { return mir_->toBigIntPtrBitOr(); };\
};\
class LBigIntPtrBitXor : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntPtrBitXor)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrBitXor(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MBigIntPtrBitXor* mir() const { return mir_->toBigIntPtrBitXor(); };\
};\
class LBigIntPtrLsh : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(BigIntPtrLsh)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrLsh(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBigIntPtrLsh* mir() const { return mir_->toBigIntPtrLsh(); };\
};\
class LBigIntPtrRsh : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(BigIntPtrRsh)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LBigIntPtrRsh(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBigIntPtrRsh* mir() const { return mir_->toBigIntPtrRsh(); };\
};\
class LBigIntPtrBitNot : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BigIntPtrBitNot)\
  static constexpr size_t InputIndex = 0;\
  explicit LBigIntPtrBitNot(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MBigIntPtrBitNot* mir() const { return mir_->toBigIntPtrBitNot(); };\
};\
class LConcat : public LInstructionHelper<1, 2, 5> {\
 public:\
  LIR_HEADER(Concat)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LConcat(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3, const LDefinition& temp4) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
    setTemp(4, temp4);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  const LDefinition* temp4() { return getTemp(4); }\
};\
class LStringIncludesSIMD : public LInstructionHelper<1, 1, 3> {\
  JSOffThreadAtom* searchString_;\
 public:\
  LIR_HEADER(StringIncludesSIMD)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringIncludesSIMD(const LAllocation& string, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, JSOffThreadAtom* searchString) : LInstructionHelper(classOpcode), searchString_(searchString) {\
    setOperand(StringIndex, string);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  JSOffThreadAtom* searchString() const { return searchString_; }\
};\
class LStringIndexOfSIMD : public LInstructionHelper<1, 1, 3> {\
  JSOffThreadAtom* searchString_;\
 public:\
  LIR_HEADER(StringIndexOfSIMD)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringIndexOfSIMD(const LAllocation& string, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, JSOffThreadAtom* searchString) : LInstructionHelper(classOpcode), searchString_(searchString) {\
    setOperand(StringIndex, string);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  JSOffThreadAtom* searchString() const { return searchString_; }\
};\
class LStringStartsWithInline : public LInstructionHelper<1, 1, 1> {\
  JSOffThreadAtom* searchString_;\
 public:\
  LIR_HEADER(StringStartsWithInline)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringStartsWithInline(const LAllocation& string, const LDefinition& temp0, JSOffThreadAtom* searchString) : LInstructionHelper(classOpcode), searchString_(searchString) {\
    setOperand(StringIndex, string);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  JSOffThreadAtom* searchString() const { return searchString_; }\
};\
class LStringEndsWithInline : public LInstructionHelper<1, 1, 1> {\
  JSOffThreadAtom* searchString_;\
 public:\
  LIR_HEADER(StringEndsWithInline)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringEndsWithInline(const LAllocation& string, const LDefinition& temp0, JSOffThreadAtom* searchString) : LInstructionHelper(classOpcode), searchString_(searchString) {\
    setOperand(StringIndex, string);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  JSOffThreadAtom* searchString() const { return searchString_; }\
};\
class LStringToLowerCase : public LInstructionHelper<1, 1, 5> {\
 public:\
  LIR_HEADER(StringToLowerCase)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringToLowerCase(const LAllocation& string, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3, const LDefinition& temp4) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
    setTemp(4, temp4);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  const LDefinition* temp4() { return getTemp(4); }\
  MStringConvertCase* mir() const { return mir_->toStringConvertCase(); };\
};\
class LCharCodeToLowerCase : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(CharCodeToLowerCase)\
  static constexpr size_t CodeIndex = 0;\
  explicit LCharCodeToLowerCase(const LAllocation& code, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(CodeIndex, code);\
    setTemp(0, temp0);\
  }\
  const LAllocation* code() const { return getOperand(CodeIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MCharCodeConvertCase* mir() const { return mir_->toCharCodeConvertCase(); };\
};\
class LStringToUpperCase : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(StringToUpperCase)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringToUpperCase(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  MStringConvertCase* mir() const { return mir_->toStringConvertCase(); };\
};\
class LCharCodeToUpperCase : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(CharCodeToUpperCase)\
  static constexpr size_t CodeIndex = 0;\
  explicit LCharCodeToUpperCase(const LAllocation& code, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(CodeIndex, code);\
    setTemp(0, temp0);\
  }\
  const LAllocation* code() const { return getOperand(CodeIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MCharCodeConvertCase* mir() const { return mir_->toCharCodeConvertCase(); };\
};\
class LInt32ToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Int32ToDouble)\
  static constexpr size_t InputIndex = 0;\
  explicit LInt32ToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LFloat32ToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Float32ToDouble)\
  static constexpr size_t InputIndex = 0;\
  explicit LFloat32ToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LDoubleToFloat32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(DoubleToFloat32)\
  static constexpr size_t InputIndex = 0;\
  explicit LDoubleToFloat32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LInt32ToFloat32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Int32ToFloat32)\
  static constexpr size_t InputIndex = 0;\
  explicit LInt32ToFloat32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LDoubleToFloat16 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(DoubleToFloat16)\
  static constexpr size_t InputIndex = 0;\
  explicit LDoubleToFloat16(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LDoubleToFloat32ToFloat16 : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(DoubleToFloat32ToFloat16)\
  static constexpr size_t InputIndex = 0;\
  explicit LDoubleToFloat32ToFloat16(const LAllocation& input, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
class LFloat32ToFloat16 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(Float32ToFloat16)\
  static constexpr size_t InputIndex = 0;\
  explicit LFloat32ToFloat16(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LInt32ToFloat16 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(Int32ToFloat16)\
  static constexpr size_t InputIndex = 0;\
  explicit LInt32ToFloat16(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LValueToDouble : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ValueToDouble)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueToDouble(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MToDouble* mir() const { return mir_->toToDouble(); };\
};\
class LValueToFloat32 : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ValueToFloat32)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueToFloat32(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MToFloat32* mir() const { return mir_->toToFloat32(); };\
};\
class LValueToFloat16 : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ValueToFloat16)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueToFloat16(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToFloat16* mir() const { return mir_->toToFloat16(); };\
};\
class LValueToNumberInt32 : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ValueToNumberInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueToNumberInt32(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToNumberInt32* mir() const { return mir_->toToNumberInt32(); };\
};\
class LValueTruncateToInt32 : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(ValueTruncateToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueTruncateToInt32(const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MTruncateToInt32* mir() const { return mir_->toTruncateToInt32(); };\
};\
class LValueToBigInt : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ValueToBigInt)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueToBigInt(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MToBigInt* mir() const { return mir_->toToBigInt(); };\
};\
class LDoubleToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(DoubleToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LDoubleToInt32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MToNumberInt32* mir() const { return mir_->toToNumberInt32(); };\
};\
class LFloat32ToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Float32ToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LFloat32ToInt32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MToNumberInt32* mir() const { return mir_->toToNumberInt32(); };\
};\
class LTruncateDToInt32 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(TruncateDToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LTruncateDToInt32(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MTruncateToInt32* mir() const { return mir_->toTruncateToInt32(); };\
};\
class LWasmBuiltinTruncateDToInt32 : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(WasmBuiltinTruncateDToInt32)\
  static constexpr size_t InputIndex = 0;\
  static constexpr size_t InstanceIndex = 1;\
  explicit LWasmBuiltinTruncateDToInt32(const LAllocation& input, const LAllocation& instance, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setOperand(InstanceIndex, instance);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmBuiltinTruncateToInt32* mir() const { return mir_->toWasmBuiltinTruncateToInt32(); };\
};\
class LTruncateFToInt32 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(TruncateFToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LTruncateFToInt32(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MTruncateToInt32* mir() const { return mir_->toTruncateToInt32(); };\
};\
class LWasmBuiltinTruncateFToInt32 : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(WasmBuiltinTruncateFToInt32)\
  static constexpr size_t InputIndex = 0;\
  static constexpr size_t InstanceIndex = 1;\
  explicit LWasmBuiltinTruncateFToInt32(const LAllocation& input, const LAllocation& instance, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setOperand(InstanceIndex, instance);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmBuiltinTruncateToInt32* mir() const { return mir_->toWasmBuiltinTruncateToInt32(); };\
};\
class LWasmTruncateToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmTruncateToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmTruncateToInt32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MWasmTruncateToInt32* mir() const { return mir_->toWasmTruncateToInt32(); };\
};\
class LWrapInt64ToInt32 : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WrapInt64ToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LWrapInt64ToInt32(const LInt64Allocation& input) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  MWrapInt64ToInt32* mir() const { return mir_->toWrapInt64ToInt32(); };\
};\
class LExtendInt32ToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(ExtendInt32ToInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LExtendInt32ToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MExtendInt32ToInt64* mir() const { return mir_->toExtendInt32ToInt64(); };\
};\
class LBooleanToString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BooleanToString)\
  static constexpr size_t InputIndex = 0;\
  explicit LBooleanToString(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MToString* mir() const { return mir_->toToString(); };\
};\
class LIntToString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IntToString)\
  static constexpr size_t InputIndex = 0;\
  explicit LIntToString(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MToString* mir() const { return mir_->toToString(); };\
};\
class LDoubleToString : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(DoubleToString)\
  static constexpr size_t InputIndex = 0;\
  explicit LDoubleToString(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToString* mir() const { return mir_->toToString(); };\
};\
class LValueToString : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ValueToString)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueToString(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToString* mir() const { return mir_->toToString(); };\
};\
class LPowHalfD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(PowHalfD)\
  static constexpr size_t InputIndex = 0;\
  explicit LPowHalfD(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MPowHalf* mir() const { return mir_->toPowHalf(); };\
};\
class LNaNToZero : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(NaNToZero)\
  static constexpr size_t InputIndex = 0;\
  explicit LNaNToZero(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNaNToZero* mir() const { return mir_->toNaNToZero(); };\
};\
class LOsrValue : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(OsrValue)\
  static constexpr size_t EntryIndex = 0;\
  explicit LOsrValue(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(EntryIndex, entry);\
  }\
  const LAllocation* entry() const { return getOperand(EntryIndex); }\
  MOsrValue* mir() const { return mir_->toOsrValue(); };\
};\
class LOsrEnvironmentChain : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(OsrEnvironmentChain)\
  static constexpr size_t EntryIndex = 0;\
  explicit LOsrEnvironmentChain(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(EntryIndex, entry);\
  }\
  const LAllocation* entry() const { return getOperand(EntryIndex); }\
  MOsrEnvironmentChain* mir() const { return mir_->toOsrEnvironmentChain(); };\
};\
class LOsrReturnValue : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(OsrReturnValue)\
  static constexpr size_t EntryIndex = 0;\
  explicit LOsrReturnValue(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(EntryIndex, entry);\
  }\
  const LAllocation* entry() const { return getOperand(EntryIndex); }\
  MOsrReturnValue* mir() const { return mir_->toOsrReturnValue(); };\
};\
class LOsrArgumentsObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(OsrArgumentsObject)\
  static constexpr size_t EntryIndex = 0;\
  explicit LOsrArgumentsObject(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(EntryIndex, entry);\
  }\
  const LAllocation* entry() const { return getOperand(EntryIndex); }\
  MOsrArgumentsObject* mir() const { return mir_->toOsrArgumentsObject(); };\
};\
class LRegExp : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(RegExp)\
  explicit LRegExp(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRegExp* mir() const { return mir_->toRegExp(); };\
};\
class LRegExpHasCaptureGroups : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(RegExpHasCaptureGroups)\
  static constexpr size_t RegexpIndex = 0;\
  static constexpr size_t InputIndex = 1;\
  explicit LRegExpHasCaptureGroups(const LAllocation& regexp, const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(RegexpIndex, regexp);\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* regexp() const { return getOperand(RegexpIndex); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MRegExpHasCaptureGroups* mir() const { return mir_->toRegExpHasCaptureGroups(); };\
};\
class LGetFirstDollarIndex : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(GetFirstDollarIndex)\
  static constexpr size_t StrIndex = 0;\
  explicit LGetFirstDollarIndex(const LAllocation& str, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(StrIndex, str);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* str() const { return getOperand(StrIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
};\
class LStringReplace : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(StringReplace)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t PatternIndex = 1;\
  static constexpr size_t ReplacementIndex = 2;\
  explicit LStringReplace(const LAllocation& string, const LAllocation& pattern, const LAllocation& replacement) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(PatternIndex, pattern);\
    setOperand(ReplacementIndex, replacement);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* pattern() const { return getOperand(PatternIndex); }\
  const LAllocation* replacement() const { return getOperand(ReplacementIndex); }\
  MStringReplace* mir() const { return mir_->toStringReplace(); };\
};\
class LBinaryValueCache : public LInstructionHelper<BOX_PIECES, 0 + 2 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(BinaryValueCache)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1 * BOX_PIECES;\
  explicit LBinaryValueCache(const LBoxAllocation& lhs, const LBoxAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LhsIndex, lhs);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation lhs() const { return getBoxOperand(LhsIndex); }\
  LBoxAllocation rhs() const { return getBoxOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBinaryCache* mir() const { return mir_->toBinaryCache(); };\
};\
class LBinaryBoolCache : public LInstructionHelper<1, 0 + 2 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(BinaryBoolCache)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1 * BOX_PIECES;\
  explicit LBinaryBoolCache(const LBoxAllocation& lhs, const LBoxAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LhsIndex, lhs);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation lhs() const { return getBoxOperand(LhsIndex); }\
  LBoxAllocation rhs() const { return getBoxOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBinaryCache* mir() const { return mir_->toBinaryCache(); };\
};\
class LModuleMetadata : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(ModuleMetadata)\
  explicit LModuleMetadata() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
  }\
  MModuleMetadata* mir() const { return mir_->toModuleMetadata(); };\
};\
class LDynamicImport : public LInstructionHelper<1, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(DynamicImport)\
  static constexpr size_t SpecifierIndex = 0;\
  static constexpr size_t OptionsIndex = 1 * BOX_PIECES;\
  explicit LDynamicImport(const LBoxAllocation& specifier, const LBoxAllocation& options) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(SpecifierIndex, specifier);\
    setBoxOperand(OptionsIndex, options);\
  }\
  LBoxAllocation specifier() const { return getBoxOperand(SpecifierIndex); }\
  LBoxAllocation options() const { return getBoxOperand(OptionsIndex); }\
  MDynamicImport* mir() const { return mir_->toDynamicImport(); };\
};\
class LLambda : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(Lambda)\
  static constexpr size_t EnvironmentChainIndex = 0;\
  explicit LLambda(const LAllocation& environmentChain, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(EnvironmentChainIndex, environmentChain);\
    setTemp(0, temp0);\
  }\
  const LAllocation* environmentChain() const { return getOperand(EnvironmentChainIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLambda* mir() const { return mir_->toLambda(); };\
};\
class LFunctionWithProto : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(FunctionWithProto)\
  static constexpr size_t EnvChainIndex = 0;\
  static constexpr size_t PrototypeIndex = 1;\
  explicit LFunctionWithProto(const LAllocation& envChain, const LAllocation& prototype) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(EnvChainIndex, envChain);\
    setOperand(PrototypeIndex, prototype);\
  }\
  const LAllocation* envChain() const { return getOperand(EnvChainIndex); }\
  const LAllocation* prototype() const { return getOperand(PrototypeIndex); }\
  MFunctionWithProto* mir() const { return mir_->toFunctionWithProto(); };\
};\
class LKeepAliveObject : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(KeepAliveObject)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LKeepAliveObject(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
};\
class LDebugEnterGCUnsafeRegion : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(DebugEnterGCUnsafeRegion)\
  explicit LDebugEnterGCUnsafeRegion(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LDebugLeaveGCUnsafeRegion : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(DebugLeaveGCUnsafeRegion)\
  explicit LDebugLeaveGCUnsafeRegion(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGetNextEntryForIterator : public LInstructionHelper<1, 2, 3> {\
 public:\
  LIR_HEADER(GetNextEntryForIterator)\
  static constexpr size_t IterIndex = 0;\
  static constexpr size_t ResultIndex = 1;\
  explicit LGetNextEntryForIterator(const LAllocation& iter, const LAllocation& result, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(IterIndex, iter);\
    setOperand(ResultIndex, result);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* iter() const { return getOperand(IterIndex); }\
  const LAllocation* result() const { return getOperand(ResultIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MGetNextEntryForIterator* mir() const { return mir_->toGetNextEntryForIterator(); };\
};\
class LResizableTypedArrayLength : public LInstructionHelper<1, 1, 1> {\
  js::jit::Synchronization synchronization_;\
 public:\
  LIR_HEADER(ResizableTypedArrayLength)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LResizableTypedArrayLength(const LAllocation& object, const LDefinition& temp0, js::jit::Synchronization synchronization) : LInstructionHelper(classOpcode), synchronization_(synchronization) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  js::jit::Synchronization synchronization() const { return synchronization_; }\
};\
class LResizableDataViewByteLength : public LInstructionHelper<1, 1, 1> {\
  js::jit::Synchronization synchronization_;\
 public:\
  LIR_HEADER(ResizableDataViewByteLength)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LResizableDataViewByteLength(const LAllocation& object, const LDefinition& temp0, js::jit::Synchronization synchronization) : LInstructionHelper(classOpcode), synchronization_(synchronization) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  js::jit::Synchronization synchronization() const { return synchronization_; }\
};\
class LGuardResizableArrayBufferViewInBounds : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardResizableArrayBufferViewInBounds)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardResizableArrayBufferViewInBounds(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardResizableArrayBufferViewInBoundsOrDetached : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardResizableArrayBufferViewInBoundsOrDetached)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardResizableArrayBufferViewInBoundsOrDetached(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardHasAttachedArrayBuffer : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardHasAttachedArrayBuffer)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardHasAttachedArrayBuffer(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardNumberToIntPtrIndex : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GuardNumberToIntPtrIndex)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardNumberToIntPtrIndex(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MGuardNumberToIntPtrIndex* mir() const { return mir_->toGuardNumberToIntPtrIndex(); };\
};\
class LBoundsCheck : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(BoundsCheck)\
  static constexpr size_t IndexIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  explicit LBoundsCheck(const LAllocation& index, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  MBoundsCheck* mir() const { return mir_->toBoundsCheck(); };\
};\
class LBoundsCheckRange : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(BoundsCheckRange)\
  static constexpr size_t IndexIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  explicit LBoundsCheckRange(const LAllocation& index, const LAllocation& length, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
    setTemp(0, temp0);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MBoundsCheck* mir() const { return mir_->toBoundsCheck(); };\
};\
class LBoundsCheckLower : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(BoundsCheckLower)\
  static constexpr size_t IndexIndex = 0;\
  explicit LBoundsCheckLower(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MBoundsCheckLower* mir() const { return mir_->toBoundsCheckLower(); };\
};\
class LSpectreMaskIndex : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(SpectreMaskIndex)\
  static constexpr size_t IndexIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  explicit LSpectreMaskIndex(const LAllocation& index, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  MSpectreMaskIndex* mir() const { return mir_->toSpectreMaskIndex(); };\
};\
class LLoadElementV : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(LoadElementV)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLoadElementV(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MLoadElement* mir() const { return mir_->toLoadElement(); };\
};\
class LInArray : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(InArray)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t InitLengthIndex = 2;\
  explicit LInArray(const LAllocation& elements, const LAllocation& index, const LAllocation& initLength) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(InitLengthIndex, initLength);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* initLength() const { return getOperand(InitLengthIndex); }\
  MInArray* mir() const { return mir_->toInArray(); };\
};\
class LGuardElementNotHole : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardElementNotHole)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LGuardElementNotHole(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
};\
class LLoadElementHole : public LInstructionHelper<BOX_PIECES, 3, 0> {\
 public:\
  LIR_HEADER(LoadElementHole)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t InitLengthIndex = 2;\
  explicit LLoadElementHole(const LAllocation& elements, const LAllocation& index, const LAllocation& initLength) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(InitLengthIndex, initLength);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* initLength() const { return getOperand(InitLengthIndex); }\
  MLoadElementHole* mir() const { return mir_->toLoadElementHole(); };\
};\
class LStoreElementV : public LInstructionHelper<0, 2 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(StoreElementV)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LStoreElementV(const LAllocation& elements, const LAllocation& index, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MStoreElement* mir() const { return mir_->toStoreElement(); };\
  inline const char* extraName() const;\
};\
class LStoreElementT : public LInstructionHelper<0, 3, 0> {\
 public:\
  LIR_HEADER(StoreElementT)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LStoreElementT(const LAllocation& elements, const LAllocation& index, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  MStoreElement* mir() const { return mir_->toStoreElement(); };\
  inline const char* extraName() const;\
};\
class LStoreHoleValueElement : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(StoreHoleValueElement)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LStoreHoleValueElement(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
};\
class LStoreElementHoleV : public LInstructionHelper<0, 3 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(StoreElementHoleV)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ElementsIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LStoreElementHoleV(const LAllocation& object, const LAllocation& elements, const LAllocation& index, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStoreElementHole* mir() const { return mir_->toStoreElementHole(); };\
};\
class LStoreElementHoleT : public LInstructionHelper<0, 4, 1> {\
 public:\
  LIR_HEADER(StoreElementHoleT)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ElementsIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LStoreElementHoleT(const LAllocation& object, const LAllocation& elements, const LAllocation& index, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStoreElementHole* mir() const { return mir_->toStoreElementHole(); };\
};\
class LArrayPopShift : public LInstructionHelper<BOX_PIECES, 1, 2> {\
 public:\
  LIR_HEADER(ArrayPopShift)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LArrayPopShift(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MArrayPopShift* mir() const { return mir_->toArrayPopShift(); };\
  inline const char* extraName() const;\
};\
class LFrameArgumentsSlice : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(FrameArgumentsSlice)\
  static constexpr size_t BeginIndex = 0;\
  static constexpr size_t CountIndex = 1;\
  explicit LFrameArgumentsSlice(const LAllocation& begin, const LAllocation& count, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(BeginIndex, begin);\
    setOperand(CountIndex, count);\
    setTemp(0, temp0);\
  }\
  const LAllocation* begin() const { return getOperand(BeginIndex); }\
  const LAllocation* count() const { return getOperand(CountIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MFrameArgumentsSlice* mir() const { return mir_->toFrameArgumentsSlice(); };\
};\
class LObjectKeys : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ObjectKeys)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LObjectKeys(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
};\
class LObjectKeysLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ObjectKeysLength)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LObjectKeysLength(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
};\
class LLoadUnboxedScalar : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(LoadUnboxedScalar)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLoadUnboxedScalar(const LAllocation& elements, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MLoadUnboxedScalar* mir() const { return mir_->toLoadUnboxedScalar(); };\
};\
class LLoadUnboxedInt64 : public LInstructionHelper<INT64_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(LoadUnboxedInt64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLoadUnboxedInt64(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MLoadUnboxedScalar* mir() const { return mir_->toLoadUnboxedScalar(); };\
};\
class LLoadDataViewElement : public LInstructionHelper<1, 3, 2 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(LoadDataViewElement)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t LittleEndianIndex = 2;\
  explicit LLoadDataViewElement(const LAllocation& elements, const LAllocation& index, const LAllocation& littleEndian, const LDefinition& temp0, const LDefinition& temp1, const LInt64Definition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(LittleEndianIndex, littleEndian);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setInt64Temp(2 + 0 * INT64_PIECES, temp2);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* littleEndian() const { return getOperand(LittleEndianIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  LInt64Definition temp2() { return getInt64Temp(2 + 0 * INT64_PIECES); }\
  MLoadDataViewElement* mir() const { return mir_->toLoadDataViewElement(); };\
};\
class LLoadDataViewElement64 : public LInstructionHelper<INT64_PIECES, 3, 0> {\
 public:\
  LIR_HEADER(LoadDataViewElement64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t LittleEndianIndex = 2;\
  explicit LLoadDataViewElement64(const LAllocation& elements, const LAllocation& index, const LAllocation& littleEndian) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(LittleEndianIndex, littleEndian);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* littleEndian() const { return getOperand(LittleEndianIndex); }\
  MLoadDataViewElement* mir() const { return mir_->toLoadDataViewElement(); };\
};\
class LLoadTypedArrayElementHole : public LInstructionHelper<BOX_PIECES, 3, 1> {\
 public:\
  LIR_HEADER(LoadTypedArrayElementHole)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t LengthIndex = 2;\
  explicit LLoadTypedArrayElementHole(const LAllocation& elements, const LAllocation& index, const LAllocation& length, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadTypedArrayElementHole* mir() const { return mir_->toLoadTypedArrayElementHole(); };\
};\
class LLoadTypedArrayElementHoleBigInt : public LInstructionHelper<BOX_PIECES, 3, 1 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(LoadTypedArrayElementHoleBigInt)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t LengthIndex = 2;\
  explicit LLoadTypedArrayElementHoleBigInt(const LAllocation& elements, const LAllocation& index, const LAllocation& length, const LDefinition& temp0, const LInt64Definition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
    setTemp(0, temp0);\
    setInt64Temp(1 + 0 * INT64_PIECES, temp1);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  LInt64Definition temp1() { return getInt64Temp(1 + 0 * INT64_PIECES); }\
  MLoadTypedArrayElementHole* mir() const { return mir_->toLoadTypedArrayElementHole(); };\
};\
class LStoreUnboxedScalar : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(StoreUnboxedScalar)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LStoreUnboxedScalar(const LAllocation& elements, const LAllocation& index, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStoreUnboxedScalar* mir() const { return mir_->toStoreUnboxedScalar(); };\
};\
class LStoreUnboxedInt64 : public LInstructionHelper<0, 2 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(StoreUnboxedInt64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LStoreUnboxedInt64(const LAllocation& elements, const LAllocation& index, const LInt64Allocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  MStoreUnboxedScalar* mir() const { return mir_->toStoreUnboxedScalar(); };\
};\
class LStoreDataViewElement : public LInstructionHelper<0, 4, 1 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(StoreDataViewElement)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  static constexpr size_t LittleEndianIndex = 3;\
  explicit LStoreDataViewElement(const LAllocation& elements, const LAllocation& index, const LAllocation& value, const LAllocation& littleEndian, const LDefinition& temp0, const LInt64Definition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setOperand(LittleEndianIndex, littleEndian);\
    setTemp(0, temp0);\
    setInt64Temp(1 + 0 * INT64_PIECES, temp1);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* littleEndian() const { return getOperand(LittleEndianIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  LInt64Definition temp1() { return getInt64Temp(1 + 0 * INT64_PIECES); }\
  MStoreDataViewElement* mir() const { return mir_->toStoreDataViewElement(); };\
};\
class LStoreDataViewElement64 : public LInstructionHelper<0, 3 + 1 * INT64_PIECES, 0 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(StoreDataViewElement64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t LittleEndianIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LStoreDataViewElement64(const LAllocation& elements, const LAllocation& index, const LInt64Allocation& value, const LAllocation& littleEndian, const LInt64Definition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(LittleEndianIndex, littleEndian);\
    setInt64Operand(ValueIndex, value);\
    setInt64Temp(0 + 0 * INT64_PIECES, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* littleEndian() const { return getOperand(LittleEndianIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  LInt64Definition temp0() { return getInt64Temp(0 + 0 * INT64_PIECES); }\
  MStoreDataViewElement* mir() const { return mir_->toStoreDataViewElement(); };\
};\
class LStoreTypedArrayElementHole : public LInstructionHelper<0, 4, 1> {\
 public:\
  LIR_HEADER(StoreTypedArrayElementHole)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LStoreTypedArrayElementHole(const LAllocation& elements, const LAllocation& length, const LAllocation& index, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(LengthIndex, length);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStoreTypedArrayElementHole* mir() const { return mir_->toStoreTypedArrayElementHole(); };\
};\
class LStoreTypedArrayElementHoleInt64 : public LInstructionHelper<0, 3 + 1 * INT64_PIECES, 1> {\
 public:\
  LIR_HEADER(StoreTypedArrayElementHoleInt64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LStoreTypedArrayElementHoleInt64(const LAllocation& elements, const LAllocation& length, const LAllocation& index, const LInt64Allocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(LengthIndex, length);\
    setOperand(IndexIndex, index);\
    setInt64Operand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStoreTypedArrayElementHole* mir() const { return mir_->toStoreTypedArrayElementHole(); };\
};\
class LTypedArraySubarray : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(TypedArraySubarray)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t StartIndex = 1;\
  static constexpr size_t LengthIndex = 2;\
  explicit LTypedArraySubarray(const LAllocation& object, const LAllocation& start, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(StartIndex, start);\
    setOperand(LengthIndex, length);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* start() const { return getOperand(StartIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  MTypedArraySubarray* mir() const { return mir_->toTypedArraySubarray(); };\
};\
class LTypedArrayFill : public LInstructionHelper<0, 4, 0> {\
 public:\
  LIR_HEADER(TypedArrayFill)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t StartIndex = 2;\
  static constexpr size_t EndIndex = 3;\
  explicit LTypedArrayFill(const LAllocation& object, const LAllocation& value, const LAllocation& start, const LAllocation& end) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setOperand(StartIndex, start);\
    setOperand(EndIndex, end);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* start() const { return getOperand(StartIndex); }\
  const LAllocation* end() const { return getOperand(EndIndex); }\
  MTypedArrayFill* mir() const { return mir_->toTypedArrayFill(); };\
};\
class LTypedArrayFill64 : public LInstructionHelper<0, 3 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(TypedArrayFill64)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t StartIndex = 1;\
  static constexpr size_t EndIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LTypedArrayFill64(const LAllocation& object, const LInt64Allocation& value, const LAllocation& start, const LAllocation& end) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(StartIndex, start);\
    setOperand(EndIndex, end);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* start() const { return getOperand(StartIndex); }\
  const LAllocation* end() const { return getOperand(EndIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  MTypedArrayFill* mir() const { return mir_->toTypedArrayFill(); };\
};\
class LAtomicIsLockFree : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AtomicIsLockFree)\
  static constexpr size_t ValueIndex = 0;\
  explicit LAtomicIsLockFree(const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ValueIndex, value);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
};\
class LCompareExchangeTypedArrayElement : public LInstructionHelper<1, 4, 1> {\
 public:\
  LIR_HEADER(CompareExchangeTypedArrayElement)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t OldvalIndex = 2;\
  static constexpr size_t NewvalIndex = 3;\
  explicit LCompareExchangeTypedArrayElement(const LAllocation& elements, const LAllocation& index, const LAllocation& oldval, const LAllocation& newval, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(OldvalIndex, oldval);\
    setOperand(NewvalIndex, newval);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* oldval() const { return getOperand(OldvalIndex); }\
  const LAllocation* newval() const { return getOperand(NewvalIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MCompareExchangeTypedArrayElement* mir() const { return mir_->toCompareExchangeTypedArrayElement(); };\
};\
class LAtomicExchangeTypedArrayElement : public LInstructionHelper<1, 3, 1> {\
 public:\
  LIR_HEADER(AtomicExchangeTypedArrayElement)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LAtomicExchangeTypedArrayElement(const LAllocation& elements, const LAllocation& index, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MAtomicExchangeTypedArrayElement* mir() const { return mir_->toAtomicExchangeTypedArrayElement(); };\
};\
class LAtomicTypedArrayElementBinop : public LInstructionHelper<1, 3, 2> {\
 public:\
  LIR_HEADER(AtomicTypedArrayElementBinop)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LAtomicTypedArrayElementBinop(const LAllocation& elements, const LAllocation& index, const LAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MAtomicTypedArrayElementBinop* mir() const { return mir_->toAtomicTypedArrayElementBinop(); };\
};\
class LAtomicTypedArrayElementBinopForEffect : public LInstructionHelper<0, 3, 0> {\
 public:\
  LIR_HEADER(AtomicTypedArrayElementBinopForEffect)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LAtomicTypedArrayElementBinopForEffect(const LAllocation& elements, const LAllocation& index, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  MAtomicTypedArrayElementBinop* mir() const { return mir_->toAtomicTypedArrayElementBinop(); };\
};\
class LAtomicLoad64 : public LInstructionHelper<INT64_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(AtomicLoad64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LAtomicLoad64(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MLoadUnboxedScalar* mir() const { return mir_->toLoadUnboxedScalar(); };\
};\
class LAtomicStore64 : public LInstructionHelper<0, 2 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(AtomicStore64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LAtomicStore64(const LAllocation& elements, const LAllocation& index, const LInt64Allocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  MStoreUnboxedScalar* mir() const { return mir_->toStoreUnboxedScalar(); };\
};\
class LCompareExchangeTypedArrayElement64 : public LInstructionHelper<INT64_PIECES, 2 + 2 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(CompareExchangeTypedArrayElement64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t OldvalIndex = 2;\
  static constexpr size_t NewvalIndex = 2 + 1 * INT64_PIECES;\
  explicit LCompareExchangeTypedArrayElement64(const LAllocation& elements, const LAllocation& index, const LInt64Allocation& oldval, const LInt64Allocation& newval) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setInt64Operand(OldvalIndex, oldval);\
    setInt64Operand(NewvalIndex, newval);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation oldval() const { return getInt64Operand(OldvalIndex); }\
  LInt64Allocation newval() const { return getInt64Operand(NewvalIndex); }\
  MCompareExchangeTypedArrayElement* mir() const { return mir_->toCompareExchangeTypedArrayElement(); };\
};\
class LAtomicExchangeTypedArrayElement64 : public LInstructionHelper<INT64_PIECES, 2 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(AtomicExchangeTypedArrayElement64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LAtomicExchangeTypedArrayElement64(const LAllocation& elements, const LAllocation& index, const LInt64Allocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  MAtomicExchangeTypedArrayElement* mir() const { return mir_->toAtomicExchangeTypedArrayElement(); };\
};\
class LAtomicTypedArrayElementBinop64 : public LInstructionHelper<INT64_PIECES, 2 + 1 * INT64_PIECES, 0 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(AtomicTypedArrayElementBinop64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LAtomicTypedArrayElementBinop64(const LAllocation& elements, const LAllocation& index, const LInt64Allocation& value, const LInt64Definition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setInt64Operand(ValueIndex, value);\
    setInt64Temp(0 + 0 * INT64_PIECES, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  LInt64Definition temp0() { return getInt64Temp(0 + 0 * INT64_PIECES); }\
  MAtomicTypedArrayElementBinop* mir() const { return mir_->toAtomicTypedArrayElementBinop(); };\
};\
class LAtomicTypedArrayElementBinopForEffect64 : public LInstructionHelper<0, 2 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(AtomicTypedArrayElementBinopForEffect64)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LAtomicTypedArrayElementBinopForEffect64(const LAllocation& elements, const LAllocation& index, const LInt64Allocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  MAtomicTypedArrayElementBinop* mir() const { return mir_->toAtomicTypedArrayElementBinop(); };\
};\
class LEffectiveAddress3 : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(EffectiveAddress3)\
  static constexpr size_t BaseIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LEffectiveAddress3(const LAllocation& base, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(BaseIndex, base);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MEffectiveAddress3* mir() const { return mir_->toEffectiveAddress3(); };\
};\
class LEffectiveAddress2 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(EffectiveAddress2)\
  static constexpr size_t IndexIndex = 0;\
  explicit LEffectiveAddress2(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MEffectiveAddress2* mir() const { return mir_->toEffectiveAddress2(); };\
};\
class LClampIToUint8 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ClampIToUint8)\
  static constexpr size_t InputIndex = 0;\
  explicit LClampIToUint8(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LClampDToUint8 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(ClampDToUint8)\
  static constexpr size_t InputIndex = 0;\
  explicit LClampDToUint8(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LClampVToUint8 : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ClampVToUint8)\
  static constexpr size_t InputIndex = 0;\
  explicit LClampVToUint8(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MClampToUint8* mir() const { return mir_->toClampToUint8(); };\
};\
class LLoadFixedSlotV : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadFixedSlotV)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LLoadFixedSlotV(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MLoadFixedSlot* mir() const { return mir_->toLoadFixedSlot(); };\
};\
class LLoadFixedSlotAndAtomize : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(LoadFixedSlotAndAtomize)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LLoadFixedSlotAndAtomize(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadFixedSlot* mir() const { return mir_->toLoadFixedSlot(); };\
};\
class LLoadFixedSlotT : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadFixedSlotT)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LLoadFixedSlotT(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MLoadFixedSlot* mir() const { return mir_->toLoadFixedSlot(); };\
};\
class LLoadFixedSlotAndUnbox : public LInstructionHelper<1, 1, 0 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(LoadFixedSlotAndUnbox)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LLoadFixedSlotAndUnbox(const LAllocation& object, const LInt64Definition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setInt64Temp(0 + 0 * INT64_PIECES, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LInt64Definition temp0() { return getInt64Temp(0 + 0 * INT64_PIECES); }\
  MLoadFixedSlotAndUnbox* mir() const { return mir_->toLoadFixedSlotAndUnbox(); };\
};\
class LLoadDynamicSlotAndUnbox : public LInstructionHelper<1, 1, 0 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(LoadDynamicSlotAndUnbox)\
  static constexpr size_t SlotsIndex = 0;\
  explicit LLoadDynamicSlotAndUnbox(const LAllocation& slots, const LInt64Definition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(SlotsIndex, slots);\
    setInt64Temp(0 + 0 * INT64_PIECES, temp0);\
  }\
  const LAllocation* slots() const { return getOperand(SlotsIndex); }\
  LInt64Definition temp0() { return getInt64Temp(0 + 0 * INT64_PIECES); }\
  MLoadDynamicSlotAndUnbox* mir() const { return mir_->toLoadDynamicSlotAndUnbox(); };\
};\
class LLoadElementAndUnbox : public LInstructionHelper<1, 2, 0 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(LoadElementAndUnbox)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLoadElementAndUnbox(const LAllocation& elements, const LAllocation& index, const LInt64Definition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
    setInt64Temp(0 + 0 * INT64_PIECES, temp0);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Definition temp0() { return getInt64Temp(0 + 0 * INT64_PIECES); }\
  MLoadElementAndUnbox* mir() const { return mir_->toLoadElementAndUnbox(); };\
};\
class LLoadFixedSlotUnboxAndAtomize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadFixedSlotUnboxAndAtomize)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LLoadFixedSlotUnboxAndAtomize(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MLoadFixedSlotAndUnbox* mir() const { return mir_->toLoadFixedSlotAndUnbox(); };\
};\
class LLoadDynamicSlotUnboxAndAtomize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadDynamicSlotUnboxAndAtomize)\
  static constexpr size_t SlotsIndex = 0;\
  explicit LLoadDynamicSlotUnboxAndAtomize(const LAllocation& slots) : LInstructionHelper(classOpcode) {\
    setOperand(SlotsIndex, slots);\
  }\
  const LAllocation* slots() const { return getOperand(SlotsIndex); }\
  MLoadDynamicSlotAndUnbox* mir() const { return mir_->toLoadDynamicSlotAndUnbox(); };\
};\
class LAddAndStoreSlot : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(AddAndStoreSlot)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LAddAndStoreSlot(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MAddAndStoreSlot* mir() const { return mir_->toAddAndStoreSlot(); };\
};\
class LAddAndStoreSlotPreserveWrapper : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(AddAndStoreSlotPreserveWrapper)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LAddAndStoreSlotPreserveWrapper(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MAddAndStoreSlot* mir() const { return mir_->toAddAndStoreSlot(); };\
};\
class LStoreFixedSlotV : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(StoreFixedSlotV)\
  static constexpr size_t ObjIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LStoreFixedSlotV(const LAllocation& obj, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ObjIndex, obj);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* obj() const { return getOperand(ObjIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MStoreFixedSlot* mir() const { return mir_->toStoreFixedSlot(); };\
};\
class LStoreFixedSlotT : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(StoreFixedSlotT)\
  static constexpr size_t ObjIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LStoreFixedSlotT(const LAllocation& obj, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ObjIndex, obj);\
    setOperand(ValueIndex, value);\
  }\
  const LAllocation* obj() const { return getOperand(ObjIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  MStoreFixedSlot* mir() const { return mir_->toStoreFixedSlot(); };\
};\
class LGetPropSuperCache : public LInstructionHelper<BOX_PIECES, 1 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(GetPropSuperCache)\
  static constexpr size_t ObjIndex = 0;\
  static constexpr size_t ReceiverIndex = 1;\
  static constexpr size_t IdIndex = 1 + 1 * BOX_PIECES;\
  explicit LGetPropSuperCache(const LAllocation& obj, const LBoxAllocation& receiver, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setOperand(ObjIndex, obj);\
    setBoxOperand(ReceiverIndex, receiver);\
    setBoxOperand(IdIndex, id);\
  }\
  const LAllocation* obj() const { return getOperand(ObjIndex); }\
  LBoxAllocation receiver() const { return getBoxOperand(ReceiverIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  MGetPropSuperCache* mir() const { return mir_->toGetPropSuperCache(); };\
};\
class LGetPropertyCache : public LInstructionHelper<BOX_PIECES, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(GetPropertyCache)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t IdIndex = 1 * BOX_PIECES;\
  explicit LGetPropertyCache(const LBoxAllocation& value, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IdIndex, id);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  MGetPropertyCache* mir() const { return mir_->toGetPropertyCache(); };\
};\
class LLoadDynamicSlotV : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDynamicSlotV)\
  static constexpr size_t InputIndex = 0;\
  explicit LLoadDynamicSlotV(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MLoadDynamicSlot* mir() const { return mir_->toLoadDynamicSlot(); };\
};\
class LLoadDynamicSlotAndAtomize : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(LoadDynamicSlotAndAtomize)\
  static constexpr size_t InputIndex = 0;\
  explicit LLoadDynamicSlotAndAtomize(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadDynamicSlot* mir() const { return mir_->toLoadDynamicSlot(); };\
};\
class LStoreDynamicSlotV : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(StoreDynamicSlotV)\
  static constexpr size_t SlotsIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LStoreDynamicSlotV(const LAllocation& slots, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(SlotsIndex, slots);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* slots() const { return getOperand(SlotsIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MStoreDynamicSlot* mir() const { return mir_->toStoreDynamicSlot(); };\
};\
class LStoreDynamicSlotT : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(StoreDynamicSlotT)\
  static constexpr size_t SlotsIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LStoreDynamicSlotT(const LAllocation& slots, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(SlotsIndex, slots);\
    setOperand(ValueIndex, value);\
  }\
  const LAllocation* slots() const { return getOperand(SlotsIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  MStoreDynamicSlot* mir() const { return mir_->toStoreDynamicSlot(); };\
};\
class LFloor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Floor)\
  static constexpr size_t InputIndex = 0;\
  explicit LFloor(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LFloorF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FloorF)\
  static constexpr size_t InputIndex = 0;\
  explicit LFloorF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LCeil : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Ceil)\
  static constexpr size_t InputIndex = 0;\
  explicit LCeil(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LCeilF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CeilF)\
  static constexpr size_t InputIndex = 0;\
  explicit LCeilF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LRound : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(Round)\
  static constexpr size_t InputIndex = 0;\
  explicit LRound(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRound* mir() const { return mir_->toRound(); };\
};\
class LRoundF : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(RoundF)\
  static constexpr size_t InputIndex = 0;\
  explicit LRoundF(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRound* mir() const { return mir_->toRound(); };\
};\
class LTrunc : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Trunc)\
  static constexpr size_t InputIndex = 0;\
  explicit LTrunc(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LTruncF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TruncF)\
  static constexpr size_t InputIndex = 0;\
  explicit LTruncF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LNearbyInt : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NearbyInt)\
  static constexpr size_t InputIndex = 0;\
  explicit LNearbyInt(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNearbyInt* mir() const { return mir_->toNearbyInt(); };\
};\
class LNearbyIntF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NearbyIntF)\
  static constexpr size_t InputIndex = 0;\
  explicit LNearbyIntF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNearbyInt* mir() const { return mir_->toNearbyInt(); };\
};\
class LRoundToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(RoundToDouble)\
  static constexpr size_t InputIndex = 0;\
  explicit LRoundToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MRoundToDouble* mir() const { return mir_->toRoundToDouble(); };\
};\
class LRoundToFloat32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(RoundToFloat32)\
  static constexpr size_t InputIndex = 0;\
  explicit LRoundToFloat32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MRoundToDouble* mir() const { return mir_->toRoundToDouble(); };\
};\
class LNewLexicalEnvironmentObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewLexicalEnvironmentObject)\
  explicit LNewLexicalEnvironmentObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewLexicalEnvironmentObject* mir() const { return mir_->toNewLexicalEnvironmentObject(); };\
};\
class LNewClassBodyEnvironmentObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewClassBodyEnvironmentObject)\
  explicit LNewClassBodyEnvironmentObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewClassBodyEnvironmentObject* mir() const { return mir_->toNewClassBodyEnvironmentObject(); };\
};\
class LNewVarEnvironmentObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewVarEnvironmentObject)\
  explicit LNewVarEnvironmentObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewVarEnvironmentObject* mir() const { return mir_->toNewVarEnvironmentObject(); };\
};\
class LMegamorphicSetElement : public LInstructionHelper<0, 1 + 2 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(MegamorphicSetElement)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 1 + 1 * BOX_PIECES;\
  explicit LMegamorphicSetElement(const LAllocation& object, const LBoxAllocation& index, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(IndexIndex, index);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation index() const { return getBoxOperand(IndexIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MMegamorphicSetElement* mir() const { return mir_->toMegamorphicSetElement(); };\
};\
class LCallDeleteProperty : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CallDeleteProperty)\
  static constexpr size_t ValueIndex = 0;\
  explicit LCallDeleteProperty(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MDeleteProperty* mir() const { return mir_->toDeleteProperty(); };\
};\
class LCallDeleteElement : public LInstructionHelper<1, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CallDeleteElement)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t IndexIndex = 1 * BOX_PIECES;\
  explicit LCallDeleteElement(const LBoxAllocation& value, const LBoxAllocation& index) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IndexIndex, index);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  LBoxAllocation index() const { return getBoxOperand(IndexIndex); }\
  MDeleteElement* mir() const { return mir_->toDeleteElement(); };\
};\
class LObjectToIterator : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(ObjectToIterator)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LObjectToIterator(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MObjectToIterator* mir() const { return mir_->toObjectToIterator(); };\
};\
class LValueToIterator : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ValueToIterator)\
  static constexpr size_t ValueIndex = 0;\
  explicit LValueToIterator(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MValueToIterator* mir() const { return mir_->toValueToIterator(); };\
};\
class LIteratorHasIndicesAndBranch : public LControlInstructionHelper<2, 2, 2> {\
 public:\
  LIR_HEADER(IteratorHasIndicesAndBranch)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IteratorIndex = 1;\
  explicit LIteratorHasIndicesAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& object, const LAllocation& iterator, const LDefinition& temp0, const LDefinition& temp1) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(ObjectIndex, object);\
    setOperand(IteratorIndex, iterator);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
class LIteratorsMatchAndHaveIndicesAndBranch : public LControlInstructionHelper<2, 3, 2> {\
 public:\
  LIR_HEADER(IteratorsMatchAndHaveIndicesAndBranch)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IteratorIndex = 1;\
  static constexpr size_t OtherIteratorIndex = 2;\
  explicit LIteratorsMatchAndHaveIndicesAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& object, const LAllocation& iterator, const LAllocation& otherIterator, const LDefinition& temp0, const LDefinition& temp1) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(ObjectIndex, object);\
    setOperand(IteratorIndex, iterator);\
    setOperand(OtherIteratorIndex, otherIterator);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  const LAllocation* otherIterator() const { return getOperand(OtherIteratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
class LSetPropertyCache : public LInstructionHelper<0, 1 + 2 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(SetPropertyCache)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IdIndex = 1;\
  static constexpr size_t ValueIndex = 1 + 1 * BOX_PIECES;\
  explicit LSetPropertyCache(const LAllocation& object, const LBoxAllocation& id, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setBoxOperand(IdIndex, id);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MSetPropertyCache* mir() const { return mir_->toSetPropertyCache(); };\
};\
class LGetIteratorCache : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(GetIteratorCache)\
  static constexpr size_t ValueIndex = 0;\
  explicit LGetIteratorCache(const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MGetIteratorCache* mir() const { return mir_->toGetIteratorCache(); };\
};\
class LIsNoIterAndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(IsNoIterAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LIsNoIterAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
};\
class LCloseIterCache : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(CloseIterCache)\
  static constexpr size_t IterIndex = 0;\
  explicit LCloseIterCache(const LAllocation& iter, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(IterIndex, iter);\
    setTemp(0, temp0);\
  }\
  const LAllocation* iter() const { return getOperand(IterIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MCloseIterCache* mir() const { return mir_->toCloseIterCache(); };\
};\
class LInt32ToIntPtr : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Int32ToIntPtr)\
  static constexpr size_t InputIndex = 0;\
  explicit LInt32ToIntPtr(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MInt32ToIntPtr* mir() const { return mir_->toInt32ToIntPtr(); };\
};\
class LNonNegativeIntPtrToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NonNegativeIntPtrToInt32)\
  static constexpr size_t InputIndex = 0;\
  explicit LNonNegativeIntPtrToInt32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LIntPtrToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IntPtrToDouble)\
  static constexpr size_t InputIndex = 0;\
  explicit LIntPtrToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LAdjustDataViewLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AdjustDataViewLength)\
  static constexpr size_t InputIndex = 0;\
  explicit LAdjustDataViewLength(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MAdjustDataViewLength* mir() const { return mir_->toAdjustDataViewLength(); };\
};\
class LBooleanToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(BooleanToInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LBooleanToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MToInt64* mir() const { return mir_->toToInt64(); };\
};\
class LStringToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(StringToInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LStringToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MToInt64* mir() const { return mir_->toToInt64(); };\
};\
class LValueToInt64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ValueToInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LValueToInt64(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToInt64* mir() const { return mir_->toToInt64(); };\
};\
class LTruncateBigIntToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(TruncateBigIntToInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LTruncateBigIntToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MTruncateBigIntToInt64* mir() const { return mir_->toTruncateBigIntToInt64(); };\
};\
class LInt64ToBigInt : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 0 + 1 * INT64_PIECES> {\
 public:\
  LIR_HEADER(Int64ToBigInt)\
  static constexpr size_t InputIndex = 0;\
  explicit LInt64ToBigInt(const LInt64Allocation& input, const LInt64Definition& temp0) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
    setInt64Temp(0 + 0 * INT64_PIECES, temp0);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  LInt64Definition temp0() { return getInt64Temp(0 + 0 * INT64_PIECES); }\
};\
class LUint64ToBigInt : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 1> {\
 public:\
  LIR_HEADER(Uint64ToBigInt)\
  static constexpr size_t InputIndex = 0;\
  explicit LUint64ToBigInt(const LInt64Allocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MInt64ToBigInt* mir() const { return mir_->toInt64ToBigInt(); };\
};\
class LInt64ToIntPtr : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(Int64ToIntPtr)\
  static constexpr size_t InputIndex = 0;\
  explicit LInt64ToIntPtr(const LInt64Allocation& input) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  MInt64ToIntPtr* mir() const { return mir_->toInt64ToIntPtr(); };\
};\
class LIntPtrToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(IntPtrToInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LIntPtrToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LPostWriteBarrierO : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierO)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LPostWriteBarrierO(const LAllocation& object, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
class LPostWriteBarrierS : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierS)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LPostWriteBarrierS(const LAllocation& object, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
class LPostWriteBarrierBI : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierBI)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LPostWriteBarrierBI(const LAllocation& object, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
class LPostWriteBarrierV : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierV)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LPostWriteBarrierV(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
class LPostWriteElementBarrierO : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierO)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  explicit LPostWriteElementBarrierO(const LAllocation& object, const LAllocation& value, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
class LPostWriteElementBarrierS : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierS)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  explicit LPostWriteElementBarrierS(const LAllocation& object, const LAllocation& value, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
class LPostWriteElementBarrierBI : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierBI)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  explicit LPostWriteElementBarrierBI(const LAllocation& object, const LAllocation& value, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
class LPostWriteElementBarrierV : public LInstructionHelper<0, 2 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierV)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LPostWriteElementBarrierV(const LAllocation& object, const LAllocation& index, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
class LAssertCanElidePostWriteBarrier : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(AssertCanElidePostWriteBarrier)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LAssertCanElidePostWriteBarrier(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardObjectIdentity : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardObjectIdentity)\
  static constexpr size_t InputIndex = 0;\
  static constexpr size_t ExpectedIndex = 1;\
  explicit LGuardObjectIdentity(const LAllocation& input, const LAllocation& expected) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setOperand(ExpectedIndex, expected);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LAllocation* expected() const { return getOperand(ExpectedIndex); }\
  MGuardObjectIdentity* mir() const { return mir_->toGuardObjectIdentity(); };\
};\
class LGuardSpecificFunction : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardSpecificFunction)\
  static constexpr size_t InputIndex = 0;\
  static constexpr size_t ExpectedIndex = 1;\
  explicit LGuardSpecificFunction(const LAllocation& input, const LAllocation& expected) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setOperand(ExpectedIndex, expected);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LAllocation* expected() const { return getOperand(ExpectedIndex); }\
};\
class LGuardSpecificAtom : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardSpecificAtom)\
  static constexpr size_t StrIndex = 0;\
  explicit LGuardSpecificAtom(const LAllocation& str, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(StrIndex, str);\
    setTemp(0, temp0);\
  }\
  const LAllocation* str() const { return getOperand(StrIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardSpecificAtom* mir() const { return mir_->toGuardSpecificAtom(); };\
};\
class LGuardSpecificSymbol : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardSpecificSymbol)\
  static constexpr size_t SymbolIndex = 0;\
  explicit LGuardSpecificSymbol(const LAllocation& symbol) : LInstructionHelper(classOpcode) {\
    setOperand(SymbolIndex, symbol);\
  }\
  const LAllocation* symbol() const { return getOperand(SymbolIndex); }\
  MGuardSpecificSymbol* mir() const { return mir_->toGuardSpecificSymbol(); };\
};\
class LGuardSpecificInt32 : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardSpecificInt32)\
  static constexpr size_t NumIndex = 0;\
  explicit LGuardSpecificInt32(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(NumIndex, num);\
  }\
  const LAllocation* num() const { return getOperand(NumIndex); }\
  MGuardSpecificInt32* mir() const { return mir_->toGuardSpecificInt32(); };\
};\
class LGuardProto : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(GuardProto)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ExpectedIndex = 1;\
  explicit LGuardProto(const LAllocation& object, const LAllocation& expected, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ExpectedIndex, expected);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* expected() const { return getOperand(ExpectedIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardNullProto : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardNullProto)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardNullProto(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardIsNativeObject : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNativeObject)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsNativeObject(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardGlobalGeneration : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(GuardGlobalGeneration)\
  explicit LGuardGlobalGeneration(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardGlobalGeneration* mir() const { return mir_->toGuardGlobalGeneration(); };\
};\
class LGuardIsProxy : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsProxy)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsProxy(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardIsNotProxy : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNotProxy)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsNotProxy(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardIsNotDOMProxy : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNotDOMProxy)\
  static constexpr size_t ProxyIndex = 0;\
  explicit LGuardIsNotDOMProxy(const LAllocation& proxy, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ProxyIndex, proxy);\
    setTemp(0, temp0);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LProxyHasProp : public LInstructionHelper<BOX_PIECES, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ProxyHasProp)\
  static constexpr size_t ProxyIndex = 0;\
  static constexpr size_t IdIndex = 1;\
  explicit LProxyHasProp(const LAllocation& proxy, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ProxyIndex, proxy);\
    setBoxOperand(IdIndex, id);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  MProxyHasProp* mir() const { return mir_->toProxyHasProp(); };\
};\
class LGuardIsNotArrayBufferMaybeShared : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNotArrayBufferMaybeShared)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsNotArrayBufferMaybeShared(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardIsTypedArray : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsTypedArray)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsTypedArray(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardIsNonResizableTypedArray : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNonResizableTypedArray)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsNonResizableTypedArray(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardIsResizableTypedArray : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsResizableTypedArray)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsResizableTypedArray(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardHasProxyHandler : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardHasProxyHandler)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardHasProxyHandler(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MGuardHasProxyHandler* mir() const { return mir_->toGuardHasProxyHandler(); };\
};\
class LGuardNoDenseElements : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardNoDenseElements)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardNoDenseElements(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LInCache : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(InCache)\
  static constexpr size_t RhsIndex = 0;\
  static constexpr size_t LhsIndex = 1;\
  explicit LInCache(const LBoxAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(RhsIndex, rhs);\
    setBoxOperand(LhsIndex, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  LBoxAllocation lhs() const { return getBoxOperand(LhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MInCache* mir() const { return mir_->toInCache(); };\
};\
class LHasOwnCache : public LInstructionHelper<1, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(HasOwnCache)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t IdIndex = 1 * BOX_PIECES;\
  explicit LHasOwnCache(const LBoxAllocation& value, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IdIndex, id);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  MHasOwnCache* mir() const { return mir_->toHasOwnCache(); };\
};\
class LCheckPrivateFieldCache : public LInstructionHelper<1, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CheckPrivateFieldCache)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t IdIndex = 1 * BOX_PIECES;\
  explicit LCheckPrivateFieldCache(const LBoxAllocation& value, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IdIndex, id);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  MCheckPrivateFieldCache* mir() const { return mir_->toCheckPrivateFieldCache(); };\
};\
class LInstanceOfO : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(InstanceOfO)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LInstanceOfO(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MInstanceOf* mir() const { return mir_->toInstanceOf(); };\
};\
class LInstanceOfV : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(InstanceOfV)\
  static constexpr size_t RhsIndex = 0;\
  static constexpr size_t LhsIndex = 1;\
  explicit LInstanceOfV(const LBoxAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(RhsIndex, rhs);\
    setBoxOperand(LhsIndex, lhs);\
  }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  LBoxAllocation lhs() const { return getBoxOperand(LhsIndex); }\
  MInstanceOf* mir() const { return mir_->toInstanceOf(); };\
};\
class LIsCallableO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsCallableO)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsCallableO(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MIsCallable* mir() const { return mir_->toIsCallable(); };\
};\
class LIsCallableV : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(IsCallableV)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsCallableV(const LBoxAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation object() const { return getBoxOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIsCallable* mir() const { return mir_->toIsCallable(); };\
};\
class LIsArrayO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsArrayO)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsArrayO(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MIsArray* mir() const { return mir_->toIsArray(); };\
};\
class LIsArrayV : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(IsArrayV)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsArrayV(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIsArray* mir() const { return mir_->toIsArray(); };\
};\
class LIsTypedArray : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsTypedArray)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsTypedArray(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MIsTypedArray* mir() const { return mir_->toIsTypedArray(); };\
};\
class LIsObjectAndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(IsObjectAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LIsObjectAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
};\
class LIsNullOrUndefinedAndBranch : public LControlInstructionHelper<2, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(IsNullOrUndefinedAndBranch)\
  static constexpr size_t InputIndex = 0;\
  explicit LIsNullOrUndefinedAndBranch(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LBoxAllocation& input) : LControlInstructionHelper(classOpcode) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setBoxOperand(InputIndex, input);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
};\
class LHasClass : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(HasClass)\
  static constexpr size_t LhsIndex = 0;\
  explicit LHasClass(const LAllocation& lhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  MHasClass* mir() const { return mir_->toHasClass(); };\
};\
class LGuardToClass : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardToClass)\
  static constexpr size_t LhsIndex = 0;\
  explicit LGuardToClass(const LAllocation& lhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardToClass* mir() const { return mir_->toGuardToClass(); };\
};\
class LGuardToFunction : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardToFunction)\
  static constexpr size_t LhsIndex = 0;\
  explicit LGuardToFunction(const LAllocation& lhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardToFunction* mir() const { return mir_->toGuardToFunction(); };\
};\
class LWasmSelect : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(WasmSelect)\
  static constexpr size_t TrueExprIndex = 0;\
  static constexpr size_t FalseExprIndex = 1;\
  static constexpr size_t CondExprIndex = 2;\
  explicit LWasmSelect(const LAllocation& trueExpr, const LAllocation& falseExpr, const LAllocation& condExpr) : LInstructionHelper(classOpcode) {\
    setOperand(TrueExprIndex, trueExpr);\
    setOperand(FalseExprIndex, falseExpr);\
    setOperand(CondExprIndex, condExpr);\
  }\
  const LAllocation* trueExpr() const { return getOperand(TrueExprIndex); }\
  const LAllocation* falseExpr() const { return getOperand(FalseExprIndex); }\
  const LAllocation* condExpr() const { return getOperand(CondExprIndex); }\
  MWasmSelect* mir() const { return mir_->toWasmSelect(); };\
};\
class LWasmSelectI64 : public LInstructionHelper<INT64_PIECES, 1 + 2 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmSelectI64)\
  static constexpr size_t CondExprIndex = 0;\
  static constexpr size_t TrueExprIndex = 1;\
  static constexpr size_t FalseExprIndex = 1 + 1 * INT64_PIECES;\
  explicit LWasmSelectI64(const LInt64Allocation& trueExpr, const LInt64Allocation& falseExpr, const LAllocation& condExpr) : LInstructionHelper(classOpcode) {\
    setOperand(CondExprIndex, condExpr);\
    setInt64Operand(TrueExprIndex, trueExpr);\
    setInt64Operand(FalseExprIndex, falseExpr);\
  }\
  const LAllocation* condExpr() const { return getOperand(CondExprIndex); }\
  LInt64Allocation trueExpr() const { return getInt64Operand(TrueExprIndex); }\
  LInt64Allocation falseExpr() const { return getInt64Operand(FalseExprIndex); }\
  MWasmSelect* mir() const { return mir_->toWasmSelect(); };\
};\
class LWasmCompareAndSelect : public LInstructionHelper<1, 4, 0> {\
  MCompare::CompareType compareType_;\
  JSOp jsop_;\
 public:\
  LIR_HEADER(WasmCompareAndSelect)\
  static constexpr size_t LeftExprIndex = 0;\
  static constexpr size_t RightExprIndex = 1;\
  static constexpr size_t IfTrueExprIndex = 2;\
  static constexpr size_t IfFalseExprIndex = 3;\
  explicit LWasmCompareAndSelect(const LAllocation& leftExpr, const LAllocation& rightExpr, const LAllocation& ifTrueExpr, const LAllocation& ifFalseExpr, MCompare::CompareType compareType, JSOp jsop) : LInstructionHelper(classOpcode), compareType_(compareType), jsop_(jsop) {\
    setOperand(LeftExprIndex, leftExpr);\
    setOperand(RightExprIndex, rightExpr);\
    setOperand(IfTrueExprIndex, ifTrueExpr);\
    setOperand(IfFalseExprIndex, ifFalseExpr);\
  }\
  const LAllocation* leftExpr() const { return getOperand(LeftExprIndex); }\
  const LAllocation* rightExpr() const { return getOperand(RightExprIndex); }\
  const LAllocation* ifTrueExpr() const { return getOperand(IfTrueExprIndex); }\
  const LAllocation* ifFalseExpr() const { return getOperand(IfFalseExprIndex); }\
  MCompare::CompareType compareType() const { return compareType_; }\
  JSOp jsop() const { return jsop_; }\
  MWasmSelect* mir() const { return mir_->toWasmSelect(); };\
};\
class LWasmAddOffset : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmAddOffset)\
  static constexpr size_t BaseIndex = 0;\
  explicit LWasmAddOffset(const LAllocation& base) : LInstructionHelper(classOpcode) {\
    setOperand(BaseIndex, base);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  MWasmAddOffset* mir() const { return mir_->toWasmAddOffset(); };\
};\
class LWasmAddOffset64 : public LInstructionHelper<INT64_PIECES, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmAddOffset64)\
  static constexpr size_t BaseIndex = 0;\
  explicit LWasmAddOffset64(const LInt64Allocation& base) : LInstructionHelper(classOpcode) {\
    setInt64Operand(BaseIndex, base);\
  }\
  LInt64Allocation base() const { return getInt64Operand(BaseIndex); }\
  MWasmAddOffset* mir() const { return mir_->toWasmAddOffset(); };\
};\
class LWasmBoundsCheck : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WasmBoundsCheck)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t BoundsCheckLimitIndex = 1;\
  explicit LWasmBoundsCheck(const LAllocation& ptr, const LAllocation& boundsCheckLimit) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(BoundsCheckLimitIndex, boundsCheckLimit);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* boundsCheckLimit() const { return getOperand(BoundsCheckLimitIndex); }\
  MWasmBoundsCheck* mir() const { return mir_->toWasmBoundsCheck(); };\
};\
class LWasmBoundsCheck64 : public LInstructionHelper<INT64_PIECES, 0 + 2 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmBoundsCheck64)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t BoundsCheckLimitIndex = 1 * INT64_PIECES;\
  explicit LWasmBoundsCheck64(const LInt64Allocation& ptr, const LInt64Allocation& boundsCheckLimit) : LInstructionHelper(classOpcode) {\
    setInt64Operand(PtrIndex, ptr);\
    setInt64Operand(BoundsCheckLimitIndex, boundsCheckLimit);\
  }\
  LInt64Allocation ptr() const { return getInt64Operand(PtrIndex); }\
  LInt64Allocation boundsCheckLimit() const { return getInt64Operand(BoundsCheckLimitIndex); }\
  MWasmBoundsCheck* mir() const { return mir_->toWasmBoundsCheck(); };\
};\
class LWasmBoundsCheckInstanceField : public LInstructionHelper<1, 2, 0> {\
  uint32_t offset_;\
 public:\
  LIR_HEADER(WasmBoundsCheckInstanceField)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t PtrIndex = 1;\
  explicit LWasmBoundsCheckInstanceField(const LAllocation& instance, const LAllocation& ptr, uint32_t offset) : LInstructionHelper(classOpcode), offset_(offset) {\
    setOperand(InstanceIndex, instance);\
    setOperand(PtrIndex, ptr);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  uint32_t offset() const { return offset_; }\
  MWasmBoundsCheck* mir() const { return mir_->toWasmBoundsCheck(); };\
};\
class LWasmBoundsCheckInstanceField64 : public LInstructionHelper<INT64_PIECES, 1 + 1 * INT64_PIECES, 0> {\
  uint32_t offset_;\
 public:\
  LIR_HEADER(WasmBoundsCheckInstanceField64)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t PtrIndex = 1;\
  explicit LWasmBoundsCheckInstanceField64(const LAllocation& instance, const LInt64Allocation& ptr, uint32_t offset) : LInstructionHelper(classOpcode), offset_(offset) {\
    setOperand(InstanceIndex, instance);\
    setInt64Operand(PtrIndex, ptr);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  LInt64Allocation ptr() const { return getInt64Operand(PtrIndex); }\
  uint32_t offset() const { return offset_; }\
  MWasmBoundsCheck* mir() const { return mir_->toWasmBoundsCheck(); };\
};\
class LWasmExtendU32Index : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmExtendU32Index)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmExtendU32Index(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MWasmExtendU32Index* mir() const { return mir_->toWasmExtendU32Index(); };\
};\
class LWasmWrapU32Index : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmWrapU32Index)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmWrapU32Index(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MWasmWrapU32Index* mir() const { return mir_->toWasmWrapU32Index(); };\
};\
class LWasmAlignmentCheck : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmAlignmentCheck)\
  static constexpr size_t PtrIndex = 0;\
  explicit LWasmAlignmentCheck(const LAllocation& ptr) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  MWasmAlignmentCheck* mir() const { return mir_->toWasmAlignmentCheck(); };\
};\
class LWasmAlignmentCheck64 : public LInstructionHelper<0, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmAlignmentCheck64)\
  static constexpr size_t PtrIndex = 0;\
  explicit LWasmAlignmentCheck64(const LInt64Allocation& ptr) : LInstructionHelper(classOpcode) {\
    setInt64Operand(PtrIndex, ptr);\
  }\
  LInt64Allocation ptr() const { return getInt64Operand(PtrIndex); }\
  MWasmAlignmentCheck* mir() const { return mir_->toWasmAlignmentCheck(); };\
};\
class LWasmLoadInstance : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmLoadInstance)\
  static constexpr size_t InstanceIndex = 0;\
  explicit LWasmLoadInstance(const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(InstanceIndex, instance);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  MWasmLoadInstance* mir() const { return mir_->toWasmLoadInstance(); };\
};\
class LWasmLoadInstance64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(WasmLoadInstance64)\
  static constexpr size_t InstanceIndex = 0;\
  explicit LWasmLoadInstance64(const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(InstanceIndex, instance);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  MWasmLoadInstance* mir() const { return mir_->toWasmLoadInstance(); };\
};\
class LWasmHeapReg : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(WasmHeapReg)\
  explicit LWasmHeapReg() : LInstructionHelper(classOpcode) {\
  }\
  MWasmHeapReg* mir() const { return mir_->toWasmHeapReg(); };\
};\
class LWasmLoad : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WasmLoad)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t MemoryBaseIndex = 1;\
  explicit LWasmLoad(const LAllocation& ptr, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmLoad* mir() const { return mir_->toWasmLoad(); };\
};\
class LWasmLoadI64 : public LInstructionHelper<INT64_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(WasmLoadI64)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t MemoryBaseIndex = 1;\
  explicit LWasmLoadI64(const LAllocation& ptr, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmLoad* mir() const { return mir_->toWasmLoad(); };\
};\
class LWasmStore : public LInstructionHelper<0, 3, 0> {\
 public:\
  LIR_HEADER(WasmStore)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t MemoryBaseIndex = 2;\
  explicit LWasmStore(const LAllocation& ptr, const LAllocation& value, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(ValueIndex, value);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmStore* mir() const { return mir_->toWasmStore(); };\
};\
class LWasmStoreI64 : public LInstructionHelper<0, 2 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmStoreI64)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t MemoryBaseIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LWasmStoreI64(const LAllocation& ptr, const LInt64Allocation& value, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(MemoryBaseIndex, memoryBase);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  MWasmStore* mir() const { return mir_->toWasmStore(); };\
};\
class LAsmJSLoadHeap : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(AsmJSLoadHeap)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t BoundsCheckLimitIndex = 1;\
  static constexpr size_t MemoryBaseIndex = 2;\
  explicit LAsmJSLoadHeap(const LAllocation& ptr, const LAllocation& boundsCheckLimit, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(BoundsCheckLimitIndex, boundsCheckLimit);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* boundsCheckLimit() const { return getOperand(BoundsCheckLimitIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MAsmJSLoadHeap* mir() const { return mir_->toAsmJSLoadHeap(); };\
};\
class LAsmJSStoreHeap : public LInstructionHelper<1, 4, 0> {\
 public:\
  LIR_HEADER(AsmJSStoreHeap)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t BoundsCheckLimitIndex = 2;\
  static constexpr size_t MemoryBaseIndex = 3;\
  explicit LAsmJSStoreHeap(const LAllocation& ptr, const LAllocation& value, const LAllocation& boundsCheckLimit, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(ValueIndex, value);\
    setOperand(BoundsCheckLimitIndex, boundsCheckLimit);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* boundsCheckLimit() const { return getOperand(BoundsCheckLimitIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MAsmJSStoreHeap* mir() const { return mir_->toAsmJSStoreHeap(); };\
};\
class LWasmCompareExchangeHeap : public LInstructionHelper<1, 4, 0> {\
 public:\
  LIR_HEADER(WasmCompareExchangeHeap)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t OldValueIndex = 1;\
  static constexpr size_t NewValueIndex = 2;\
  static constexpr size_t MemoryBaseIndex = 3;\
  explicit LWasmCompareExchangeHeap(const LAllocation& ptr, const LAllocation& oldValue, const LAllocation& newValue, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(OldValueIndex, oldValue);\
    setOperand(NewValueIndex, newValue);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* oldValue() const { return getOperand(OldValueIndex); }\
  const LAllocation* newValue() const { return getOperand(NewValueIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmCompareExchangeHeap* mir() const { return mir_->toWasmCompareExchangeHeap(); };\
};\
class LWasmAtomicExchangeHeap : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(WasmAtomicExchangeHeap)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t MemoryBaseIndex = 2;\
  explicit LWasmAtomicExchangeHeap(const LAllocation& ptr, const LAllocation& value, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(ValueIndex, value);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmAtomicExchangeHeap* mir() const { return mir_->toWasmAtomicExchangeHeap(); };\
};\
class LWasmAtomicBinopHeap : public LInstructionHelper<1, 3, 1> {\
 public:\
  LIR_HEADER(WasmAtomicBinopHeap)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t MemoryBaseIndex = 2;\
  explicit LWasmAtomicBinopHeap(const LAllocation& ptr, const LAllocation& value, const LAllocation& memoryBase, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(ValueIndex, value);\
    setOperand(MemoryBaseIndex, memoryBase);\
    setTemp(0, temp0);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmAtomicBinopHeap* mir() const { return mir_->toWasmAtomicBinopHeap(); };\
};\
class LWasmAtomicBinopHeapForEffect : public LInstructionHelper<0, 3, 0> {\
 public:\
  LIR_HEADER(WasmAtomicBinopHeapForEffect)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  static constexpr size_t MemoryBaseIndex = 2;\
  explicit LWasmAtomicBinopHeapForEffect(const LAllocation& ptr, const LAllocation& value, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(ValueIndex, value);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmAtomicBinopHeap* mir() const { return mir_->toWasmAtomicBinopHeap(); };\
};\
class LWasmLoadSlot : public LInstructionHelper<1, 1, 0> {\
  size_t offset_;\
  MIRType type_;\
  MWideningOp wideningOp_;\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmLoadSlot)\
  static constexpr size_t ContainerRefIndex = 0;\
  explicit LWasmLoadSlot(const LAllocation& containerRef, size_t offset, MIRType type, MWideningOp wideningOp, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), type_(type), wideningOp_(wideningOp), maybeTrap_(maybeTrap) {\
    setOperand(ContainerRefIndex, containerRef);\
  }\
  const LAllocation* containerRef() const { return getOperand(ContainerRefIndex); }\
  size_t offset() const { return offset_; }\
  MIRType type() const { return type_; }\
  MWideningOp wideningOp() const { return wideningOp_; }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmLoadElement : public LInstructionHelper<1, 2, 1> {\
  MIRType type_;\
  MWideningOp wideningOp_;\
  Scale scale_;\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmLoadElement)\
  static constexpr size_t BaseIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LWasmLoadElement(const LAllocation& base, const LAllocation& index, const LDefinition& temp0, MIRType type, MWideningOp wideningOp, Scale scale, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), type_(type), wideningOp_(wideningOp), scale_(scale), maybeTrap_(maybeTrap) {\
    setOperand(BaseIndex, base);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIRType type() const { return type_; }\
  MWideningOp wideningOp() const { return wideningOp_; }\
  Scale scale() const { return scale_; }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmLoadSlotI64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
  size_t offset_;\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmLoadSlotI64)\
  static constexpr size_t ContainerRefIndex = 0;\
  explicit LWasmLoadSlotI64(const LAllocation& containerRef, size_t offset, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), maybeTrap_(maybeTrap) {\
    setOperand(ContainerRefIndex, containerRef);\
  }\
  const LAllocation* containerRef() const { return getOperand(ContainerRefIndex); }\
  size_t offset() const { return offset_; }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmLoadElementI64 : public LInstructionHelper<INT64_PIECES, 2, 0> {\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmLoadElementI64)\
  static constexpr size_t BaseIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LWasmLoadElementI64(const LAllocation& base, const LAllocation& index, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), maybeTrap_(maybeTrap) {\
    setOperand(BaseIndex, base);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmStoreSlot : public LInstructionHelper<0, 2, 0> {\
  size_t offset_;\
  MIRType type_;\
  MNarrowingOp narrowingOp_;\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmStoreSlot)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t ContainerRefIndex = 1;\
  explicit LWasmStoreSlot(const LAllocation& value, const LAllocation& containerRef, size_t offset, MIRType type, MNarrowingOp narrowingOp, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), type_(type), narrowingOp_(narrowingOp), maybeTrap_(maybeTrap) {\
    setOperand(ValueIndex, value);\
    setOperand(ContainerRefIndex, containerRef);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* containerRef() const { return getOperand(ContainerRefIndex); }\
  size_t offset() const { return offset_; }\
  MIRType type() const { return type_; }\
  MNarrowingOp narrowingOp() const { return narrowingOp_; }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmStoreSlotI64 : public LInstructionHelper<0, 1 + 1 * INT64_PIECES, 0> {\
  size_t offset_;\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmStoreSlotI64)\
  static constexpr size_t ContainerRefIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LWasmStoreSlotI64(const LInt64Allocation& value, const LAllocation& containerRef, size_t offset, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), maybeTrap_(maybeTrap) {\
    setOperand(ContainerRefIndex, containerRef);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* containerRef() const { return getOperand(ContainerRefIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  size_t offset() const { return offset_; }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmStoreStackResult : public LInstructionHelper<0, 2, 0> {\
  size_t offset_;\
  MIRType type_;\
 public:\
  LIR_HEADER(WasmStoreStackResult)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t StackResultsAreaIndex = 1;\
  explicit LWasmStoreStackResult(const LAllocation& value, const LAllocation& stackResultsArea, size_t offset, MIRType type) : LInstructionHelper(classOpcode), offset_(offset), type_(type) {\
    setOperand(ValueIndex, value);\
    setOperand(StackResultsAreaIndex, stackResultsArea);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* stackResultsArea() const { return getOperand(StackResultsAreaIndex); }\
  size_t offset() const { return offset_; }\
  MIRType type() const { return type_; }\
};\
class LWasmStoreStackResultI64 : public LInstructionHelper<0, 1 + 1 * INT64_PIECES, 0> {\
  size_t offset_;\
 public:\
  LIR_HEADER(WasmStoreStackResultI64)\
  static constexpr size_t StackResultsAreaIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LWasmStoreStackResultI64(const LInt64Allocation& value, const LAllocation& stackResultsArea, size_t offset) : LInstructionHelper(classOpcode), offset_(offset) {\
    setOperand(StackResultsAreaIndex, stackResultsArea);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* stackResultsArea() const { return getOperand(StackResultsAreaIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  size_t offset() const { return offset_; }\
};\
class LWasmStoreElement : public LInstructionHelper<0, 3, 1> {\
  MIRType type_;\
  MNarrowingOp narrowingOp_;\
  Scale scale_;\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmStoreElement)\
  static constexpr size_t BaseIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LWasmStoreElement(const LAllocation& base, const LAllocation& index, const LAllocation& value, const LDefinition& temp0, MIRType type, MNarrowingOp narrowingOp, Scale scale, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), type_(type), narrowingOp_(narrowingOp), scale_(scale), maybeTrap_(maybeTrap) {\
    setOperand(BaseIndex, base);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIRType type() const { return type_; }\
  MNarrowingOp narrowingOp() const { return narrowingOp_; }\
  Scale scale() const { return scale_; }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmStoreElementI64 : public LInstructionHelper<0, 2 + 1 * INT64_PIECES, 0> {\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
 public:\
  LIR_HEADER(WasmStoreElementI64)\
  static constexpr size_t BaseIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LWasmStoreElementI64(const LAllocation& base, const LAllocation& index, const LInt64Allocation& value, wasm::MaybeTrapSiteDesc maybeTrap) : LInstructionHelper(classOpcode), maybeTrap_(maybeTrap) {\
    setOperand(BaseIndex, base);\
    setOperand(IndexIndex, index);\
    setInt64Operand(ValueIndex, value);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LInt64Allocation value() const { return getInt64Operand(ValueIndex); }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
};\
class LWasmStoreElementRef : public LInstructionHelper<0, 4, 2> {\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
  WasmPreBarrierKind preBarrierKind_;\
 public:\
  LIR_HEADER(WasmStoreElementRef)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t BaseIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LWasmStoreElementRef(const LAllocation& instance, const LAllocation& base, const LAllocation& index, const LAllocation& value, const LDefinition& temp0, const LDefinition& temp1, wasm::MaybeTrapSiteDesc maybeTrap, WasmPreBarrierKind preBarrierKind) : LInstructionHelper(classOpcode), maybeTrap_(maybeTrap), preBarrierKind_(preBarrierKind) {\
    setOperand(InstanceIndex, instance);\
    setOperand(BaseIndex, base);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
  WasmPreBarrierKind preBarrierKind() const { return preBarrierKind_; }\
};\
class LWasmLoadTableElement : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WasmLoadTableElement)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LWasmLoadTableElement(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
};\
class LWasmDerivedPointer : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmDerivedPointer)\
  static constexpr size_t BaseIndex = 0;\
  explicit LWasmDerivedPointer(const LAllocation& base) : LInstructionHelper(classOpcode) {\
    setOperand(BaseIndex, base);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  MWasmDerivedPointer* mir() const { return mir_->toWasmDerivedPointer(); };\
};\
class LWasmDerivedIndexPointer : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WasmDerivedIndexPointer)\
  static constexpr size_t BaseIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LWasmDerivedIndexPointer(const LAllocation& base, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(BaseIndex, base);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MWasmDerivedIndexPointer* mir() const { return mir_->toWasmDerivedIndexPointer(); };\
};\
class LWasmStoreRef : public LInstructionHelper<0, 3, 1> {\
  uint32_t offset_;\
  wasm::MaybeTrapSiteDesc maybeTrap_;\
  WasmPreBarrierKind preBarrierKind_;\
 public:\
  LIR_HEADER(WasmStoreRef)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t ValueBaseIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LWasmStoreRef(const LAllocation& instance, const LAllocation& valueBase, const LAllocation& value, const LDefinition& temp0, uint32_t offset, wasm::MaybeTrapSiteDesc maybeTrap, WasmPreBarrierKind preBarrierKind) : LInstructionHelper(classOpcode), offset_(offset), maybeTrap_(maybeTrap), preBarrierKind_(preBarrierKind) {\
    setOperand(InstanceIndex, instance);\
    setOperand(ValueBaseIndex, valueBase);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LAllocation* valueBase() const { return getOperand(ValueBaseIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  uint32_t offset() const { return offset_; }\
  wasm::MaybeTrapSiteDesc maybeTrap() const { return maybeTrap_; }\
  WasmPreBarrierKind preBarrierKind() const { return preBarrierKind_; }\
  MWasmStoreRef* mir() const { return mir_->toWasmStoreRef(); };\
};\
class LWasmPostWriteBarrierWholeCell : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(WasmPostWriteBarrierWholeCell)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t ObjectIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LWasmPostWriteBarrierWholeCell(const LAllocation& instance, const LAllocation& object, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InstanceIndex, instance);\
    setOperand(ObjectIndex, object);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmPostWriteBarrierWholeCell* mir() const { return mir_->toWasmPostWriteBarrierWholeCell(); };\
};\
class LWasmPostWriteBarrierEdgeAtIndex : public LInstructionHelper<0, 5, 1> {\
  uint32_t elemSize_;\
 public:\
  LIR_HEADER(WasmPostWriteBarrierEdgeAtIndex)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t ObjectIndex = 1;\
  static constexpr size_t ValueBaseIndex = 2;\
  static constexpr size_t IndexIndex = 3;\
  static constexpr size_t ValueIndex = 4;\
  explicit LWasmPostWriteBarrierEdgeAtIndex(const LAllocation& instance, const LAllocation& object, const LAllocation& valueBase, const LAllocation& index, const LAllocation& value, const LDefinition& temp0, uint32_t elemSize) : LInstructionHelper(classOpcode), elemSize_(elemSize) {\
    setOperand(InstanceIndex, instance);\
    setOperand(ObjectIndex, object);\
    setOperand(ValueBaseIndex, valueBase);\
    setOperand(IndexIndex, index);\
    setOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* valueBase() const { return getOperand(ValueBaseIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  uint32_t elemSize() const { return elemSize_; }\
  MWasmPostWriteBarrierEdgeAtIndex* mir() const { return mir_->toWasmPostWriteBarrierEdgeAtIndex(); };\
};\
class LWasmParameter : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(WasmParameter)\
  explicit LWasmParameter() : LInstructionHelper(classOpcode) {\
  }\
};\
class LWasmParameterI64 : public LInstructionHelper<INT64_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(WasmParameterI64)\
  explicit LWasmParameterI64() : LInstructionHelper(classOpcode) {\
  }\
};\
class LWasmReturn : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(WasmReturn)\
  static constexpr size_t RvalIndex = 0;\
  static constexpr size_t InstanceIndex = 1;\
  explicit LWasmReturn(const LAllocation& rval, const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(RvalIndex, rval);\
    setOperand(InstanceIndex, instance);\
  }\
  const LAllocation* rval() const { return getOperand(RvalIndex); }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
};\
class LWasmReturnI64 : public LInstructionHelper<0, 1 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmReturnI64)\
  static constexpr size_t InstanceIndex = 0;\
  static constexpr size_t RvalIndex = 1;\
  explicit LWasmReturnI64(const LInt64Allocation& rval, const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(InstanceIndex, instance);\
    setInt64Operand(RvalIndex, rval);\
  }\
  const LAllocation* instance() const { return getOperand(InstanceIndex); }\
  LInt64Allocation rval() const { return getInt64Operand(RvalIndex); }\
};\
class LWasmReturnVoid : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmReturnVoid)\
  static constexpr size_t RvalIndex = 0;\
  explicit LWasmReturnVoid(const LAllocation& rval) : LInstructionHelper(classOpcode) {\
    setOperand(RvalIndex, rval);\
  }\
  const LAllocation* rval() const { return getOperand(RvalIndex); }\
};\
class LWasmStackArg : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmStackArg)\
  static constexpr size_t ArgIndex = 0;\
  explicit LWasmStackArg(const LAllocation& arg) : LInstructionHelper(classOpcode) {\
    setOperand(ArgIndex, arg);\
  }\
  const LAllocation* arg() const { return getOperand(ArgIndex); }\
  MWasmStackArg* mir() const { return mir_->toWasmStackArg(); };\
};\
class LWasmStackArgI64 : public LInstructionHelper<0, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmStackArgI64)\
  static constexpr size_t ArgIndex = 0;\
  explicit LWasmStackArgI64(const LInt64Allocation& arg) : LInstructionHelper(classOpcode) {\
    setInt64Operand(ArgIndex, arg);\
  }\
  LInt64Allocation arg() const { return getInt64Operand(ArgIndex); }\
  MWasmStackArg* mir() const { return mir_->toWasmStackArg(); };\
};\
class LWasmNullConstant : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(WasmNullConstant)\
  explicit LWasmNullConstant() : LInstructionHelper(classOpcode) {\
  }\
};\
class LWasmStackResultArea : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(WasmStackResultArea)\
  explicit LWasmStackResultArea(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmStackResultArea* mir() const { return mir_->toWasmStackResultArea(); };\
};\
class LAssertRangeI : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(AssertRangeI)\
  static constexpr size_t InputIndex = 0;\
  explicit LAssertRangeI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MAssertRange* mir() const { return mir_->toAssertRange(); };\
};\
class LAssertRangeD : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(AssertRangeD)\
  static constexpr size_t InputIndex = 0;\
  explicit LAssertRangeD(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MAssertRange* mir() const { return mir_->toAssertRange(); };\
};\
class LAssertRangeF : public LInstructionHelper<0, 1, 2> {\
 public:\
  LIR_HEADER(AssertRangeF)\
  static constexpr size_t InputIndex = 0;\
  explicit LAssertRangeF(const LAllocation& input, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MAssertRange* mir() const { return mir_->toAssertRange(); };\
};\
class LAssertRangeV : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(AssertRangeV)\
  static constexpr size_t InputIndex = 0;\
  explicit LAssertRangeV(const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MAssertRange* mir() const { return mir_->toAssertRange(); };\
};\
class LAssertClass : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(AssertClass)\
  static constexpr size_t InputIndex = 0;\
  explicit LAssertClass(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MAssertClass* mir() const { return mir_->toAssertClass(); };\
};\
class LAssertShape : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(AssertShape)\
  static constexpr size_t InputIndex = 0;\
  explicit LAssertShape(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MAssertShape* mir() const { return mir_->toAssertShape(); };\
};\
class LGuardValue : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(GuardValue)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardValue(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardValue* mir() const { return mir_->toGuardValue(); };\
};\
class LGuardNullOrUndefined : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(GuardNullOrUndefined)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardNullOrUndefined(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MGuardNullOrUndefined* mir() const { return mir_->toGuardNullOrUndefined(); };\
};\
class LGuardIsNotObject : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(GuardIsNotObject)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardIsNotObject(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MGuardIsNotObject* mir() const { return mir_->toGuardIsNotObject(); };\
};\
class LGuardFunctionFlags : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardFunctionFlags)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LGuardFunctionFlags(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  MGuardFunctionFlags* mir() const { return mir_->toGuardFunctionFlags(); };\
};\
class LGuardFunctionIsNonBuiltinCtor : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardFunctionIsNonBuiltinCtor)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LGuardFunctionIsNonBuiltinCtor(const LAllocation& function, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
    setTemp(0, temp0);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardFunctionKind : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardFunctionKind)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LGuardFunctionKind(const LAllocation& function, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
    setTemp(0, temp0);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardFunctionKind* mir() const { return mir_->toGuardFunctionKind(); };\
};\
class LGuardFunctionScript : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardFunctionScript)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LGuardFunctionScript(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  MGuardFunctionScript* mir() const { return mir_->toGuardFunctionScript(); };\
};\
class LLexicalCheck : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(LexicalCheck)\
  static constexpr size_t InputIndex = 0;\
  explicit LLexicalCheck(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MLexicalCheck* mir() const { return mir_->toLexicalCheck(); };\
};\
class LThrowRuntimeLexicalError : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(ThrowRuntimeLexicalError)\
  explicit LThrowRuntimeLexicalError() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
  }\
  MThrowRuntimeLexicalError* mir() const { return mir_->toThrowRuntimeLexicalError(); };\
};\
class LThrowMsg : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(ThrowMsg)\
  explicit LThrowMsg() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
  }\
  MThrowMsg* mir() const { return mir_->toThrowMsg(); };\
};\
class LMemoryBarrier : public LInstructionHelper<0, 0, 0> {\
  jit::MemoryBarrier barrier_;\
 public:\
  LIR_HEADER(MemoryBarrier)\
  explicit LMemoryBarrier(jit::MemoryBarrier barrier) : LInstructionHelper(classOpcode), barrier_(barrier) {\
  }\
  jit::MemoryBarrier barrier() const { return barrier_; }\
};\
class LDebugger : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(Debugger)\
  explicit LDebugger(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LRandom : public LInstructionHelper<1, 0, 1 + 2 * INT64_PIECES> {\
 public:\
  LIR_HEADER(Random)\
  explicit LRandom(const LDefinition& temp0, const LInt64Definition& temp1, const LInt64Definition& temp2) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
    setInt64Temp(1 + 0 * INT64_PIECES, temp1);\
    setInt64Temp(1 + 1 * INT64_PIECES, temp2);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  LInt64Definition temp1() { return getInt64Temp(1 + 0 * INT64_PIECES); }\
  LInt64Definition temp2() { return getInt64Temp(1 + 1 * INT64_PIECES); }\
  MRandom* mir() const { return mir_->toRandom(); };\
};\
class LCheckObjCoercible : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CheckObjCoercible)\
  static constexpr size_t ValueIndex = 0;\
  explicit LCheckObjCoercible(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
};\
class LCheckClassHeritage : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(CheckClassHeritage)\
  static constexpr size_t HeritageIndex = 0;\
  explicit LCheckClassHeritage(const LBoxAllocation& heritage, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(HeritageIndex, heritage);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation heritage() const { return getBoxOperand(HeritageIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
class LCheckThis : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CheckThis)\
  static constexpr size_t ValueIndex = 0;\
  explicit LCheckThis(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
};\
class LCheckThisReinit : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CheckThisReinit)\
  static constexpr size_t ThisValueIndex = 0;\
  explicit LCheckThisReinit(const LBoxAllocation& thisValue) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ThisValueIndex, thisValue);\
  }\
  LBoxAllocation thisValue() const { return getBoxOperand(ThisValueIndex); }\
};\
class LGenerator : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(Generator)\
  static constexpr size_t CalleeIndex = 0;\
  static constexpr size_t EnvironmentChainIndex = 1;\
  static constexpr size_t ArgsObjectIndex = 2;\
  explicit LGenerator(const LAllocation& callee, const LAllocation& environmentChain, const LAllocation& argsObject) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(CalleeIndex, callee);\
    setOperand(EnvironmentChainIndex, environmentChain);\
    setOperand(ArgsObjectIndex, argsObject);\
  }\
  const LAllocation* callee() const { return getOperand(CalleeIndex); }\
  const LAllocation* environmentChain() const { return getOperand(EnvironmentChainIndex); }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  MGenerator* mir() const { return mir_->toGenerator(); };\
};\
class LAsyncResolve : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(AsyncResolve)\
  static constexpr size_t GeneratorIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LAsyncResolve(const LAllocation& generator, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(GeneratorIndex, generator);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* generator() const { return getOperand(GeneratorIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MAsyncResolve* mir() const { return mir_->toAsyncResolve(); };\
};\
class LAsyncReject : public LInstructionHelper<1, 1 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(AsyncReject)\
  static constexpr size_t GeneratorIndex = 0;\
  static constexpr size_t ReasonIndex = 1;\
  static constexpr size_t StackIndex = 1 + 1 * BOX_PIECES;\
  explicit LAsyncReject(const LAllocation& generator, const LBoxAllocation& reason, const LBoxAllocation& stack) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(GeneratorIndex, generator);\
    setBoxOperand(ReasonIndex, reason);\
    setBoxOperand(StackIndex, stack);\
  }\
  const LAllocation* generator() const { return getOperand(GeneratorIndex); }\
  LBoxAllocation reason() const { return getBoxOperand(ReasonIndex); }\
  LBoxAllocation stack() const { return getBoxOperand(StackIndex); }\
  MAsyncReject* mir() const { return mir_->toAsyncReject(); };\
};\
class LAsyncAwait : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(AsyncAwait)\
  static constexpr size_t GeneratorIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LAsyncAwait(const LBoxAllocation& value, const LAllocation& generator) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(GeneratorIndex, generator);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* generator() const { return getOperand(GeneratorIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MAsyncAwait* mir() const { return mir_->toAsyncAwait(); };\
};\
class LCanSkipAwait : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CanSkipAwait)\
  static constexpr size_t ValueIndex = 0;\
  explicit LCanSkipAwait(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MCanSkipAwait* mir() const { return mir_->toCanSkipAwait(); };\
};\
class LMaybeExtractAwaitValue : public LInstructionHelper<BOX_PIECES, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(MaybeExtractAwaitValue)\
  static constexpr size_t CanSkipIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LMaybeExtractAwaitValue(const LBoxAllocation& value, const LAllocation& canSkip) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(CanSkipIndex, canSkip);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* canSkip() const { return getOperand(CanSkipIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MMaybeExtractAwaitValue* mir() const { return mir_->toMaybeExtractAwaitValue(); };\
};\
class LDebugCheckSelfHosted : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(DebugCheckSelfHosted)\
  static constexpr size_t ValueIndex = 0;\
  explicit LDebugCheckSelfHosted(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
};\
class LGuardArrayIsPacked : public LInstructionHelper<0, 1, 2> {\
 public:\
  LIR_HEADER(GuardArrayIsPacked)\
  static constexpr size_t ArrayIndex = 0;\
  explicit LGuardArrayIsPacked(const LAllocation& array, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ArrayIndex, array);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* array() const { return getOperand(ArrayIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MGuardArrayIsPacked* mir() const { return mir_->toGuardArrayIsPacked(); };\
};\
class LObjectStaticProto : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ObjectStaticProto)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LObjectStaticProto(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
};\
class LGuardTagNotEqual : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardTagNotEqual)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LGuardTagNotEqual(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
};\
class LGuardHasGetterSetter : public LInstructionHelper<0, 1, 3> {\
 public:\
  LIR_HEADER(GuardHasGetterSetter)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardHasGetterSetter(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MGuardHasGetterSetter* mir() const { return mir_->toGuardHasGetterSetter(); };\
};\
class LGuardIsExtensible : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsExtensible)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardIsExtensible(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
class LGuardInt32IsNonNegative : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardInt32IsNonNegative)\
  static constexpr size_t IndexIndex = 0;\
  explicit LGuardInt32IsNonNegative(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
};\
class LGuardInt32Range : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardInt32Range)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardInt32Range(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MGuardInt32Range* mir() const { return mir_->toGuardInt32Range(); };\
};\
class LGuardIndexIsNotDenseElement : public LInstructionHelper<0, 2, 2> {\
 public:\
  LIR_HEADER(GuardIndexIsNotDenseElement)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LGuardIndexIsNotDenseElement(const LAllocation& object, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
class LGuardIndexIsValidUpdateOrAdd : public LInstructionHelper<0, 2, 2> {\
 public:\
  LIR_HEADER(GuardIndexIsValidUpdateOrAdd)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LGuardIndexIsValidUpdateOrAdd(const LAllocation& object, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
class LGuardNonGCThing : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(GuardNonGCThing)\
  static constexpr size_t InputIndex = 0;\
  explicit LGuardNonGCThing(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
};\
class LCanonicalizeNaND : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CanonicalizeNaND)\
  static constexpr size_t InputIndex = 0;\
  explicit LCanonicalizeNaND(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LCanonicalizeNaNF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CanonicalizeNaNF)\
  static constexpr size_t InputIndex = 0;\
  explicit LCanonicalizeNaNF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LWasmNewI31Ref : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmNewI31Ref)\
  static constexpr size_t ValueIndex = 0;\
  explicit LWasmNewI31Ref(const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(ValueIndex, value);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  MWasmNewI31Ref* mir() const { return mir_->toWasmNewI31Ref(); };\
};\
class LSimd128 : public LInstructionHelper<1, 0, 0> {\
  SimdConstant simd128_;\
 public:\
  LIR_HEADER(Simd128)\
  explicit LSimd128(SimdConstant simd128) : LInstructionHelper(classOpcode), simd128_(simd128) {\
  }\
  SimdConstant simd128() const { return simd128_; }\
};\
class LWasmTernarySimd128 : public LInstructionHelper<1, 3, 1> {\
  wasm::SimdOp simdOp_;\
 public:\
  LIR_HEADER(WasmTernarySimd128)\
  static constexpr size_t V0Index = 0;\
  static constexpr size_t V1Index = 1;\
  static constexpr size_t V2Index = 2;\
  explicit LWasmTernarySimd128(const LAllocation& v0, const LAllocation& v1, const LAllocation& v2, const LDefinition& temp0, wasm::SimdOp simdOp) : LInstructionHelper(classOpcode), simdOp_(simdOp) {\
    setOperand(V0Index, v0);\
    setOperand(V1Index, v1);\
    setOperand(V2Index, v2);\
    setTemp(0, temp0);\
  }\
  const LAllocation* v0() const { return getOperand(V0Index); }\
  const LAllocation* v1() const { return getOperand(V1Index); }\
  const LAllocation* v2() const { return getOperand(V2Index); }\
  const LDefinition* temp0() { return getTemp(0); }\
  wasm::SimdOp simdOp() const { return simdOp_; }\
};\
class LWasmBinarySimd128 : public LInstructionHelper<1, 2, 2> {\
  wasm::SimdOp simdOp_;\
 public:\
  LIR_HEADER(WasmBinarySimd128)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LWasmBinarySimd128(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1, wasm::SimdOp simdOp) : LInstructionHelper(classOpcode), simdOp_(simdOp) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  wasm::SimdOp simdOp() const { return simdOp_; }\
};\
class LWasmBinarySimd128WithConstant : public LInstructionHelper<1, 1, 1> {\
  SimdConstant rhs_;\
 public:\
  LIR_HEADER(WasmBinarySimd128WithConstant)\
  static constexpr size_t LhsIndex = 0;\
  explicit LWasmBinarySimd128WithConstant(const LAllocation& lhs, const LDefinition& temp0, SimdConstant rhs) : LInstructionHelper(classOpcode), rhs_(rhs) {\
    setOperand(LhsIndex, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  SimdConstant rhs() const { return rhs_; }\
  MWasmBinarySimd128WithConstant* mir() const { return mir_->toWasmBinarySimd128WithConstant(); };\
};\
class LWasmVariableShiftSimd128 : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(WasmVariableShiftSimd128)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LWasmVariableShiftSimd128(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmShiftSimd128* mir() const { return mir_->toWasmShiftSimd128(); };\
};\
class LWasmConstantShiftSimd128 : public LInstructionHelper<1, 1, 0> {\
  int32_t shift_;\
 public:\
  LIR_HEADER(WasmConstantShiftSimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmConstantShiftSimd128(const LAllocation& src, int32_t shift) : LInstructionHelper(classOpcode), shift_(shift) {\
    setOperand(SrcIndex, src);\
  }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  int32_t shift() const { return shift_; }\
  MWasmShiftSimd128* mir() const { return mir_->toWasmShiftSimd128(); };\
};\
class LWasmSignReplicationSimd128 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmSignReplicationSimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmSignReplicationSimd128(const LAllocation& src) : LInstructionHelper(classOpcode) {\
    setOperand(SrcIndex, src);\
  }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  MWasmShiftSimd128* mir() const { return mir_->toWasmShiftSimd128(); };\
};\
class LWasmShuffleSimd128 : public LInstructionHelper<1, 2, 1> {\
  SimdShuffleOp op_;\
  SimdConstant control_;\
 public:\
  LIR_HEADER(WasmShuffleSimd128)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LWasmShuffleSimd128(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, SimdShuffleOp op, SimdConstant control) : LInstructionHelper(classOpcode), op_(op), control_(control) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  SimdShuffleOp op() const { return op_; }\
  SimdConstant control() const { return control_; }\
};\
class LWasmPermuteSimd128 : public LInstructionHelper<1, 1, 0> {\
  SimdPermuteOp op_;\
  SimdConstant control_;\
 public:\
  LIR_HEADER(WasmPermuteSimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmPermuteSimd128(const LAllocation& src, SimdPermuteOp op, SimdConstant control) : LInstructionHelper(classOpcode), op_(op), control_(control) {\
    setOperand(SrcIndex, src);\
  }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  SimdPermuteOp op() const { return op_; }\
  SimdConstant control() const { return control_; }\
};\
class LWasmReplaceLaneSimd128 : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WasmReplaceLaneSimd128)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LWasmReplaceLaneSimd128(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  MWasmReplaceLaneSimd128* mir() const { return mir_->toWasmReplaceLaneSimd128(); };\
};\
class LWasmReplaceInt64LaneSimd128 : public LInstructionHelper<1, 1 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmReplaceInt64LaneSimd128)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LWasmReplaceInt64LaneSimd128(const LAllocation& lhs, const LInt64Allocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setInt64Operand(RhsIndex, rhs);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  LInt64Allocation rhs() const { return getInt64Operand(RhsIndex); }\
  MWasmReplaceLaneSimd128* mir() const { return mir_->toWasmReplaceLaneSimd128(); };\
};\
class LWasmScalarToSimd128 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmScalarToSimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmScalarToSimd128(const LAllocation& src) : LInstructionHelper(classOpcode) {\
    setOperand(SrcIndex, src);\
  }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  MWasmScalarToSimd128* mir() const { return mir_->toWasmScalarToSimd128(); };\
};\
class LWasmInt64ToSimd128 : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmInt64ToSimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmInt64ToSimd128(const LInt64Allocation& src) : LInstructionHelper(classOpcode) {\
    setInt64Operand(SrcIndex, src);\
  }\
  LInt64Allocation src() const { return getInt64Operand(SrcIndex); }\
  MWasmScalarToSimd128* mir() const { return mir_->toWasmScalarToSimd128(); };\
};\
class LWasmReduceSimd128 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmReduceSimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmReduceSimd128(const LAllocation& src) : LInstructionHelper(classOpcode) {\
    setOperand(SrcIndex, src);\
  }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  MWasmReduceSimd128* mir() const { return mir_->toWasmReduceSimd128(); };\
};\
class LWasmReduceAndBranchSimd128 : public LControlInstructionHelper<2, 1, 0> {\
  wasm::SimdOp simdOp_;\
 public:\
  LIR_HEADER(WasmReduceAndBranchSimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmReduceAndBranchSimd128(MBasicBlock* ifTrue, MBasicBlock* ifFalse, const LAllocation& src, wasm::SimdOp simdOp) : LControlInstructionHelper(classOpcode), simdOp_(simdOp) {\
    setSuccessor(0, ifTrue);\
    setSuccessor(1, ifFalse);\
    setOperand(SrcIndex, src);\
  }\
  MBasicBlock* ifTrue() const { return getSuccessor(0); }\
  MBasicBlock* ifFalse() const { return getSuccessor(1); }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  wasm::SimdOp simdOp() const { return simdOp_; }\
};\
class LWasmReduceSimd128ToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(WasmReduceSimd128ToInt64)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmReduceSimd128ToInt64(const LAllocation& src) : LInstructionHelper(classOpcode) {\
    setOperand(SrcIndex, src);\
  }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  MWasmReduceSimd128* mir() const { return mir_->toWasmReduceSimd128(); };\
};\
class LWasmLoadLaneSimd128 : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(WasmLoadLaneSimd128)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t SrcIndex = 1;\
  static constexpr size_t MemoryBaseIndex = 2;\
  explicit LWasmLoadLaneSimd128(const LAllocation& ptr, const LAllocation& src, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(SrcIndex, src);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmLoadLaneSimd128* mir() const { return mir_->toWasmLoadLaneSimd128(); };\
};\
class LWasmStoreLaneSimd128 : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(WasmStoreLaneSimd128)\
  static constexpr size_t PtrIndex = 0;\
  static constexpr size_t SrcIndex = 1;\
  static constexpr size_t MemoryBaseIndex = 2;\
  explicit LWasmStoreLaneSimd128(const LAllocation& ptr, const LAllocation& src, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(PtrIndex, ptr);\
    setOperand(SrcIndex, src);\
    setOperand(MemoryBaseIndex, memoryBase);\
  }\
  const LAllocation* ptr() const { return getOperand(PtrIndex); }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  const LAllocation* memoryBase() const { return getOperand(MemoryBaseIndex); }\
  MWasmStoreLaneSimd128* mir() const { return mir_->toWasmStoreLaneSimd128(); };\
};\
class LUnboxFloatingPoint : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(UnboxFloatingPoint)\
  static constexpr size_t InputIndex = 0;\
  explicit LUnboxFloatingPoint(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MUnbox* mir() const { return mir_->toUnbox(); };\
};\
class LWasmUint32ToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmUint32ToDouble)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmUint32ToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LWasmUint32ToFloat32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmUint32ToFloat32)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmUint32ToFloat32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
};\
class LDivI : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(DivI)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LDivI(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MDiv* mir() const { return mir_->toDiv(); };\
  inline const char* extraName() const;\
};\
class LModI : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(ModI)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LModI(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MMod* mir() const { return mir_->toMod(); };\
  inline const char* extraName() const;\
};\
class LDivPowTwoI : public LInstructionHelper<1, 2, 0> {\
  int32_t shift_;\
  bool negativeDivisor_;\
 public:\
  LIR_HEADER(DivPowTwoI)\
  static constexpr size_t NumeratorIndex = 0;\
  static constexpr size_t NumeratorCopyIndex = 1;\
  explicit LDivPowTwoI(const LAllocation& numerator, const LAllocation& numeratorCopy, int32_t shift, bool negativeDivisor) : LInstructionHelper(classOpcode), shift_(shift), negativeDivisor_(negativeDivisor) {\
    setOperand(NumeratorIndex, numerator);\
    setOperand(NumeratorCopyIndex, numeratorCopy);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LAllocation* numeratorCopy() const { return getOperand(NumeratorCopyIndex); }\
  int32_t shift() const { return shift_; }\
  bool negativeDivisor() const { return negativeDivisor_; }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LModPowTwoI : public LInstructionHelper<1, 1, 0> {\
  int32_t shift_;\
 public:\
  LIR_HEADER(ModPowTwoI)\
  static constexpr size_t InputIndex = 0;\
  explicit LModPowTwoI(const LAllocation& input, int32_t shift) : LInstructionHelper(classOpcode), shift_(shift) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  int32_t shift() const { return shift_; }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LTableSwitch : public LInstructionHelper<0, 1, 2> {\
 public:\
  LIR_HEADER(TableSwitch)\
  static constexpr size_t IndexIndex = 0;\
  explicit LTableSwitch(const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MTableSwitch* mir() const { return mir_->toTableSwitch(); };\
};\
class LTableSwitchV : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(TableSwitchV)\
  static constexpr size_t InputIndex = 0;\
  explicit LTableSwitchV(const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MTableSwitch* mir() const { return mir_->toTableSwitch(); };\
};\
class LMulI : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(MulI)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  static constexpr size_t LhsCopyIndex = 2;\
  explicit LMulI(const LAllocation& lhs, const LAllocation& rhs, const LAllocation& lhsCopy) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setOperand(LhsCopyIndex, lhsCopy);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LAllocation* lhsCopy() const { return getOperand(LhsCopyIndex); }\
  MMul* mir() const { return mir_->toMul(); };\
  inline const char* extraName() const;\
};\
class LDivConstantI : public LInstructionHelper<1, 1, 1> {\
  int32_t denominator_;\
 public:\
  LIR_HEADER(DivConstantI)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LDivConstantI(const LAllocation& numerator, const LDefinition& temp0, int32_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  int32_t denominator() const { return denominator_; }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LModConstantI : public LInstructionHelper<1, 1, 1> {\
  int32_t denominator_;\
 public:\
  LIR_HEADER(ModConstantI)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LModConstantI(const LAllocation& numerator, const LDefinition& temp0, int32_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  int32_t denominator() const { return denominator_; }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LUDivConstant : public LInstructionHelper<1, 1, 1> {\
  uint32_t denominator_;\
 public:\
  LIR_HEADER(UDivConstant)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LUDivConstant(const LAllocation& numerator, const LDefinition& temp0, uint32_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  uint32_t denominator() const { return denominator_; }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LUModConstant : public LInstructionHelper<1, 1, 1> {\
  uint32_t denominator_;\
 public:\
  LIR_HEADER(UModConstant)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LUModConstant(const LAllocation& numerator, const LDefinition& temp0, uint32_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  uint32_t denominator() const { return denominator_; }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LUDiv : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(UDiv)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LUDiv(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LUMod : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(UMod)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LUMod(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LDivI64 : public LInstructionHelper<INT64_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(DivI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LDivI64(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LModI64 : public LInstructionHelper<INT64_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(ModI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LModI64(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LUDivI64 : public LInstructionHelper<INT64_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(UDivI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LUDivI64(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LUModI64 : public LInstructionHelper<INT64_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(UModI64)\
  static constexpr size_t LhsIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LUModI64(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LhsIndex, lhs);\
    setOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() const { return getOperand(LhsIndex); }\
  const LAllocation* rhs() const { return getOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LDivPowTwoI64 : public LInstructionHelper<1, 2, 0> {\
  int32_t shift_;\
  bool negativeDivisor_;\
 public:\
  LIR_HEADER(DivPowTwoI64)\
  static constexpr size_t NumeratorIndex = 0;\
  static constexpr size_t NumeratorCopyIndex = 1;\
  explicit LDivPowTwoI64(const LAllocation& numerator, const LAllocation& numeratorCopy, int32_t shift, bool negativeDivisor) : LInstructionHelper(classOpcode), shift_(shift), negativeDivisor_(negativeDivisor) {\
    setOperand(NumeratorIndex, numerator);\
    setOperand(NumeratorCopyIndex, numeratorCopy);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LAllocation* numeratorCopy() const { return getOperand(NumeratorCopyIndex); }\
  int32_t shift() const { return shift_; }\
  bool negativeDivisor() const { return negativeDivisor_; }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LModPowTwoI64 : public LInstructionHelper<1, 1, 0> {\
  int32_t shift_;\
 public:\
  LIR_HEADER(ModPowTwoI64)\
  static constexpr size_t InputIndex = 0;\
  explicit LModPowTwoI64(const LAllocation& input, int32_t shift) : LInstructionHelper(classOpcode), shift_(shift) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  int32_t shift() const { return shift_; }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LDivConstantI64 : public LInstructionHelper<1, 1, 1> {\
  int64_t denominator_;\
 public:\
  LIR_HEADER(DivConstantI64)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LDivConstantI64(const LAllocation& numerator, const LDefinition& temp0, int64_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  int64_t denominator() const { return denominator_; }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LModConstantI64 : public LInstructionHelper<1, 1, 1> {\
  int64_t denominator_;\
 public:\
  LIR_HEADER(ModConstantI64)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LModConstantI64(const LAllocation& numerator, const LDefinition& temp0, int64_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  int64_t denominator() const { return denominator_; }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LUDivConstantI64 : public LInstructionHelper<1, 1, 1> {\
  uint64_t denominator_;\
 public:\
  LIR_HEADER(UDivConstantI64)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LUDivConstantI64(const LAllocation& numerator, const LDefinition& temp0, uint64_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  uint64_t denominator() const { return denominator_; }\
  MDiv* mir() const { return mir_->toDiv(); };\
};\
class LUModConstantI64 : public LInstructionHelper<1, 1, 1> {\
  uint64_t denominator_;\
 public:\
  LIR_HEADER(UModConstantI64)\
  static constexpr size_t NumeratorIndex = 0;\
  explicit LUModConstantI64(const LAllocation& numerator, const LDefinition& temp0, uint64_t denominator) : LInstructionHelper(classOpcode), denominator_(denominator) {\
    setOperand(NumeratorIndex, numerator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* numerator() const { return getOperand(NumeratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  uint64_t denominator() const { return denominator_; }\
  MMod* mir() const { return mir_->toMod(); };\
};\
class LWasmTruncateToInt64 : public LInstructionHelper<INT64_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(WasmTruncateToInt64)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmTruncateToInt64(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmTruncateToInt64* mir() const { return mir_->toWasmTruncateToInt64(); };\
};\
class LInt64ToFloatingPoint : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 1> {\
 public:\
  LIR_HEADER(Int64ToFloatingPoint)\
  static constexpr size_t InputIndex = 0;\
  explicit LInt64ToFloatingPoint(const LInt64Allocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LInt64Allocation input() const { return getInt64Operand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MInt64ToFloatingPoint* mir() const { return mir_->toInt64ToFloatingPoint(); };\
};\
class LAddDisposableResource : public LInstructionHelper<0, 2 + 2 * BOX_PIECES, 0> {\
  uint8_t hint_;\
 public:\
  LIR_HEADER(AddDisposableResource)\
  static constexpr size_t EnvironmentIndex = 0;\
  static constexpr size_t NeedsClosureIndex = 1;\
  static constexpr size_t ResourceIndex = 2;\
  static constexpr size_t MethodIndex = 2 + 1 * BOX_PIECES;\
  explicit LAddDisposableResource(const LAllocation& environment, const LBoxAllocation& resource, const LBoxAllocation& method, const LAllocation& needsClosure, uint8_t hint) : LInstructionHelper(classOpcode), hint_(hint) {\
    this->setIsCall();\
    setOperand(EnvironmentIndex, environment);\
    setOperand(NeedsClosureIndex, needsClosure);\
    setBoxOperand(ResourceIndex, resource);\
    setBoxOperand(MethodIndex, method);\
  }\
  const LAllocation* environment() const { return getOperand(EnvironmentIndex); }\
  const LAllocation* needsClosure() const { return getOperand(NeedsClosureIndex); }\
  LBoxAllocation resource() const { return getBoxOperand(ResourceIndex); }\
  LBoxAllocation method() const { return getBoxOperand(MethodIndex); }\
  uint8_t hint() const { return hint_; }\
};\
class LCreateSuppressedError : public LInstructionHelper<1, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CreateSuppressedError)\
  static constexpr size_t ErrorIndex = 0;\
  static constexpr size_t SuppressedIndex = 1 * BOX_PIECES;\
  explicit LCreateSuppressedError(const LBoxAllocation& error, const LBoxAllocation& suppressed) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ErrorIndex, error);\
    setBoxOperand(SuppressedIndex, suppressed);\
  }\
  LBoxAllocation error() const { return getBoxOperand(ErrorIndex); }\
  LBoxAllocation suppressed() const { return getBoxOperand(SuppressedIndex); }\
};\
class LCallee : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(Callee)\
  explicit LCallee() : LInstructionHelper(classOpcode) {\
  }\
  MCallee* mir() const { return mir_->toCallee(); };\
};\
class LIsConstructing : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(IsConstructing)\
  explicit LIsConstructing() : LInstructionHelper(classOpcode) {\
  }\
  MIsConstructing* mir() const { return mir_->toIsConstructing(); };\
};\
class LThrow : public LInstructionHelper<0, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(Throw)\
  static constexpr size_t ValueIndex = 0;\
  explicit LThrow(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MThrow* mir() const { return mir_->toThrow(); };\
};\
class LThrowWithStack : public LInstructionHelper<0, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ThrowWithStack)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t StackIndex = 1 * BOX_PIECES;\
  explicit LThrowWithStack(const LBoxAllocation& value, const LBoxAllocation& stack) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(StackIndex, stack);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  LBoxAllocation stack() const { return getBoxOperand(StackIndex); }\
  MThrowWithStack* mir() const { return mir_->toThrowWithStack(); };\
};\
class LNewArrayDynamicLength : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(NewArrayDynamicLength)\
  static constexpr size_t LengthIndex = 0;\
  explicit LNewArrayDynamicLength(const LAllocation& length, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LengthIndex, length);\
    setTemp(0, temp0);\
  }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewArrayDynamicLength* mir() const { return mir_->toNewArrayDynamicLength(); };\
};\
class LNewTypedArrayDynamicLength : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(NewTypedArrayDynamicLength)\
  static constexpr size_t LengthIndex = 0;\
  explicit LNewTypedArrayDynamicLength(const LAllocation& length, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(LengthIndex, length);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MNewTypedArrayDynamicLength* mir() const { return mir_->toNewTypedArrayDynamicLength(); };\
};\
class LNewTypedArrayFromArray : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NewTypedArrayFromArray)\
  static constexpr size_t ArrayIndex = 0;\
  explicit LNewTypedArrayFromArray(const LAllocation& array) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ArrayIndex, array);\
  }\
  const LAllocation* array() const { return getOperand(ArrayIndex); }\
  MNewTypedArrayFromArray* mir() const { return mir_->toNewTypedArrayFromArray(); };\
};\
class LNewTypedArrayFromArrayBuffer : public LInstructionHelper<1, 1 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(NewTypedArrayFromArrayBuffer)\
  static constexpr size_t ArrayBufferIndex = 0;\
  static constexpr size_t ByteOffsetIndex = 1;\
  static constexpr size_t LengthIndex = 1 + 1 * BOX_PIECES;\
  explicit LNewTypedArrayFromArrayBuffer(const LAllocation& arrayBuffer, const LBoxAllocation& byteOffset, const LBoxAllocation& length) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ArrayBufferIndex, arrayBuffer);\
    setBoxOperand(ByteOffsetIndex, byteOffset);\
    setBoxOperand(LengthIndex, length);\
  }\
  const LAllocation* arrayBuffer() const { return getOperand(ArrayBufferIndex); }\
  LBoxAllocation byteOffset() const { return getBoxOperand(ByteOffsetIndex); }\
  LBoxAllocation length() const { return getBoxOperand(LengthIndex); }\
  MNewTypedArrayFromArrayBuffer* mir() const { return mir_->toNewTypedArrayFromArrayBuffer(); };\
};\
class LNewMapObjectFromIterable : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(NewMapObjectFromIterable)\
  static constexpr size_t IterableIndex = 0;\
  explicit LNewMapObjectFromIterable(const LBoxAllocation& iterable, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(IterableIndex, iterable);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation iterable() const { return getBoxOperand(IterableIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MNewMapObjectFromIterable* mir() const { return mir_->toNewMapObjectFromIterable(); };\
};\
class LNewSetObjectFromIterable : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(NewSetObjectFromIterable)\
  static constexpr size_t IterableIndex = 0;\
  explicit LNewSetObjectFromIterable(const LBoxAllocation& iterable, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(IterableIndex, iterable);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation iterable() const { return getBoxOperand(IterableIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MNewSetObjectFromIterable* mir() const { return mir_->toNewSetObjectFromIterable(); };\
};\
class LNewBoundFunction : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewBoundFunction)\
  explicit LNewBoundFunction(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewBoundFunction* mir() const { return mir_->toNewBoundFunction(); };\
};\
class LBoundFunctionNumArgs : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BoundFunctionNumArgs)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LBoundFunctionNumArgs(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MBoundFunctionNumArgs* mir() const { return mir_->toBoundFunctionNumArgs(); };\
};\
class LBail : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(Bail)\
  explicit LBail() : LInstructionHelper(classOpcode) {\
  }\
  MBail* mir() const { return mir_->toBail(); };\
};\
class LEncodeSnapshot : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(EncodeSnapshot)\
  explicit LEncodeSnapshot() : LInstructionHelper(classOpcode) {\
  }\
  MEncodeSnapshot* mir() const { return mir_->toEncodeSnapshot(); };\
};\
class LStrictConstantCompareInt32 : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(StrictConstantCompareInt32)\
  static constexpr size_t ValueIndex = 0;\
  explicit LStrictConstantCompareInt32(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStrictConstantCompareInt32* mir() const { return mir_->toStrictConstantCompareInt32(); };\
};\
class LStrictConstantCompareBoolean : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(StrictConstantCompareBoolean)\
  static constexpr size_t ValueIndex = 0;\
  explicit LStrictConstantCompareBoolean(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MStrictConstantCompareBoolean* mir() const { return mir_->toStrictConstantCompareBoolean(); };\
};\
class LSameValueDouble : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(SameValueDouble)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1;\
  explicit LSameValueDouble(const LAllocation& left, const LAllocation& right, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(LeftIndex, left);\
    setOperand(RightIndex, right);\
    setTemp(0, temp0);\
  }\
  const LAllocation* left() const { return getOperand(LeftIndex); }\
  const LAllocation* right() const { return getOperand(RightIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MSameValueDouble* mir() const { return mir_->toSameValueDouble(); };\
};\
class LSameValue : public LInstructionHelper<1, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(SameValue)\
  static constexpr size_t LeftIndex = 0;\
  static constexpr size_t RightIndex = 1 * BOX_PIECES;\
  explicit LSameValue(const LBoxAllocation& left, const LBoxAllocation& right) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LeftIndex, left);\
    setBoxOperand(RightIndex, right);\
  }\
  LBoxAllocation left() const { return getBoxOperand(LeftIndex); }\
  LBoxAllocation right() const { return getBoxOperand(RightIndex); }\
  MSameValue* mir() const { return mir_->toSameValue(); };\
};\
class LCreateThis : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(CreateThis)\
  static constexpr size_t CalleeIndex = 0;\
  static constexpr size_t NewTargetIndex = 1;\
  explicit LCreateThis(const LAllocation& callee, const LAllocation& newTarget) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(CalleeIndex, callee);\
    setOperand(NewTargetIndex, newTarget);\
  }\
  const LAllocation* callee() const { return getOperand(CalleeIndex); }\
  const LAllocation* newTarget() const { return getOperand(NewTargetIndex); }\
  MCreateThis* mir() const { return mir_->toCreateThis(); };\
};\
class LGetArgumentsObjectArg : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(GetArgumentsObjectArg)\
  static constexpr size_t ArgsObjectIndex = 0;\
  explicit LGetArgumentsObjectArg(const LAllocation& argsObject, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ArgsObjectIndex, argsObject);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGetArgumentsObjectArg* mir() const { return mir_->toGetArgumentsObjectArg(); };\
};\
class LSetArgumentsObjectArg : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(SetArgumentsObjectArg)\
  static constexpr size_t ArgsObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LSetArgumentsObjectArg(const LAllocation& argsObject, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ArgsObjectIndex, argsObject);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MSetArgumentsObjectArg* mir() const { return mir_->toSetArgumentsObjectArg(); };\
};\
class LLoadArgumentsObjectArg : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(LoadArgumentsObjectArg)\
  static constexpr size_t ArgsObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLoadArgumentsObjectArg(const LAllocation& argsObject, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ArgsObjectIndex, argsObject);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadArgumentsObjectArg* mir() const { return mir_->toLoadArgumentsObjectArg(); };\
};\
class LLoadArgumentsObjectArgHole : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(LoadArgumentsObjectArgHole)\
  static constexpr size_t ArgsObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLoadArgumentsObjectArgHole(const LAllocation& argsObject, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ArgsObjectIndex, argsObject);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadArgumentsObjectArgHole* mir() const { return mir_->toLoadArgumentsObjectArgHole(); };\
};\
class LInArgumentsObjectArg : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(InArgumentsObjectArg)\
  static constexpr size_t ArgsObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LInArgumentsObjectArg(const LAllocation& argsObject, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ArgsObjectIndex, argsObject);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MInArgumentsObjectArg* mir() const { return mir_->toInArgumentsObjectArg(); };\
};\
class LArgumentsObjectLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArgumentsObjectLength)\
  static constexpr size_t ArgsObjectIndex = 0;\
  explicit LArgumentsObjectLength(const LAllocation& argsObject) : LInstructionHelper(classOpcode) {\
    setOperand(ArgsObjectIndex, argsObject);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  MArgumentsObjectLength* mir() const { return mir_->toArgumentsObjectLength(); };\
};\
class LArrayFromArgumentsObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayFromArgumentsObject)\
  static constexpr size_t ArgsObjectIndex = 0;\
  explicit LArrayFromArgumentsObject(const LAllocation& argsObject) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ArgsObjectIndex, argsObject);\
  }\
  const LAllocation* argsObject() const { return getOperand(ArgsObjectIndex); }\
  MArrayFromArgumentsObject* mir() const { return mir_->toArrayFromArgumentsObject(); };\
};\
class LLoadScriptedProxyHandler : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadScriptedProxyHandler)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LLoadScriptedProxyHandler(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MLoadScriptedProxyHandler* mir() const { return mir_->toLoadScriptedProxyHandler(); };\
};\
class LCheckScriptedProxyGetResult : public LInstructionHelper<0, 0 + 3 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(CheckScriptedProxyGetResult)\
  static constexpr size_t TargetIndex = 0;\
  static constexpr size_t IdIndex = 1 * BOX_PIECES;\
  static constexpr size_t ValueIndex = 2 * BOX_PIECES;\
  explicit LCheckScriptedProxyGetResult(const LBoxAllocation& target, const LBoxAllocation& id, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(TargetIndex, target);\
    setBoxOperand(IdIndex, id);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation target() const { return getBoxOperand(TargetIndex); }\
  LBoxAllocation id() const { return getBoxOperand(IdIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCheckScriptedProxyGetResult* mir() const { return mir_->toCheckScriptedProxyGetResult(); };\
};\
class LIdToStringOrSymbol : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(IdToStringOrSymbol)\
  static constexpr size_t IdValIndex = 0;\
  explicit LIdToStringOrSymbol(const LBoxAllocation& idVal, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(IdValIndex, idVal);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation idVal() const { return getBoxOperand(IdValIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIdToStringOrSymbol* mir() const { return mir_->toIdToStringOrSymbol(); };\
};\
class LReturnFromCtor : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ReturnFromCtor)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LReturnFromCtor(const LBoxAllocation& value, const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MReturnFromCtor* mir() const { return mir_->toReturnFromCtor(); };\
};\
class LWasmAnyRefFromJSValue : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(WasmAnyRefFromJSValue)\
  static constexpr size_t DefIndex = 0;\
  explicit LWasmAnyRefFromJSValue(const LBoxAllocation& def, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(DefIndex, def);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation def() const { return getBoxOperand(DefIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmAnyRefFromJSValue* mir() const { return mir_->toWasmAnyRefFromJSValue(); };\
};\
class LWasmAnyRefFromJSObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmAnyRefFromJSObject)\
  static constexpr size_t DefIndex = 0;\
  explicit LWasmAnyRefFromJSObject(const LAllocation& def) : LInstructionHelper(classOpcode) {\
    setOperand(DefIndex, def);\
  }\
  const LAllocation* def() const { return getOperand(DefIndex); }\
  MWasmAnyRefFromJSObject* mir() const { return mir_->toWasmAnyRefFromJSObject(); };\
};\
class LWasmAnyRefFromJSString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmAnyRefFromJSString)\
  static constexpr size_t DefIndex = 0;\
  explicit LWasmAnyRefFromJSString(const LAllocation& def) : LInstructionHelper(classOpcode) {\
    setOperand(DefIndex, def);\
  }\
  const LAllocation* def() const { return getOperand(DefIndex); }\
  MWasmAnyRefFromJSString* mir() const { return mir_->toWasmAnyRefFromJSString(); };\
};\
class LWasmAnyRefIsJSString : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(WasmAnyRefIsJSString)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmAnyRefIsJSString(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmAnyRefIsJSString* mir() const { return mir_->toWasmAnyRefIsJSString(); };\
};\
class LWasmTrapIfAnyRefIsNotJSString : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(WasmTrapIfAnyRefIsNotJSString)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmTrapIfAnyRefIsNotJSString(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmTrapIfAnyRefIsNotJSString* mir() const { return mir_->toWasmTrapIfAnyRefIsNotJSString(); };\
};\
class LWasmAnyRefJSStringLength : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(WasmAnyRefJSStringLength)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmAnyRefJSStringLength(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmAnyRefJSStringLength* mir() const { return mir_->toWasmAnyRefJSStringLength(); };\
};\
class LWasmI31RefGet : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmI31RefGet)\
  static constexpr size_t InputIndex = 0;\
  explicit LWasmI31RefGet(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MWasmI31RefGet* mir() const { return mir_->toWasmI31RefGet(); };\
};\
class LTypeOfName : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypeOfName)\
  static constexpr size_t InputIndex = 0;\
  explicit LTypeOfName(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MTypeOfName* mir() const { return mir_->toTypeOfName(); };\
};\
class LToPropertyKeyCache : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ToPropertyKeyCache)\
  static constexpr size_t InputIndex = 0;\
  explicit LToPropertyKeyCache(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MToPropertyKeyCache* mir() const { return mir_->toToPropertyKeyCache(); };\
};\
class LBigIntToIntPtr : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BigIntToIntPtr)\
  static constexpr size_t InputIndex = 0;\
  explicit LBigIntToIntPtr(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MBigIntToIntPtr* mir() const { return mir_->toBigIntToIntPtr(); };\
};\
class LIntPtrToBigInt : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(IntPtrToBigInt)\
  static constexpr size_t InputIndex = 0;\
  explicit LIntPtrToBigInt(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIntPtrToBigInt* mir() const { return mir_->toIntPtrToBigInt(); };\
};\
class LInt32ToStringWithBase : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(Int32ToStringWithBase)\
  static constexpr size_t InputIndex = 0;\
  static constexpr size_t BaseIndex = 1;\
  explicit LInt32ToStringWithBase(const LAllocation& input, const LAllocation& base, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setOperand(BaseIndex, base);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LAllocation* base() const { return getOperand(BaseIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MInt32ToStringWithBase* mir() const { return mir_->toInt32ToStringWithBase(); };\
};\
class LNumberParseInt : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(NumberParseInt)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t RadixIndex = 1;\
  explicit LNumberParseInt(const LAllocation& string, const LAllocation& radix, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(RadixIndex, radix);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* radix() const { return getOperand(RadixIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNumberParseInt* mir() const { return mir_->toNumberParseInt(); };\
};\
class LDoubleParseInt : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(DoubleParseInt)\
  static constexpr size_t NumberIndex = 0;\
  explicit LDoubleParseInt(const LAllocation& number, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(NumberIndex, number);\
    setTemp(0, temp0);\
  }\
  const LAllocation* number() const { return getOperand(NumberIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MDoubleParseInt* mir() const { return mir_->toDoubleParseInt(); };\
};\
class LLinearizeString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LinearizeString)\
  static constexpr size_t StringIndex = 0;\
  explicit LLinearizeString(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  MLinearizeString* mir() const { return mir_->toLinearizeString(); };\
};\
class LLinearizeForCharAccess : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(LinearizeForCharAccess)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLinearizeForCharAccess(const LAllocation& string, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MLinearizeForCharAccess* mir() const { return mir_->toLinearizeForCharAccess(); };\
};\
class LLinearizeForCodePointAccess : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(LinearizeForCodePointAccess)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLinearizeForCodePointAccess(const LAllocation& string, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLinearizeForCodePointAccess* mir() const { return mir_->toLinearizeForCodePointAccess(); };\
};\
class LToRelativeStringIndex : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(ToRelativeStringIndex)\
  static constexpr size_t IndexIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  explicit LToRelativeStringIndex(const LAllocation& index, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  MToRelativeStringIndex* mir() const { return mir_->toToRelativeStringIndex(); };\
};\
class LCharCodeAt : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CharCodeAt)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LCharCodeAt(const LAllocation& string, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCharCodeAt* mir() const { return mir_->toCharCodeAt(); };\
};\
class LCharCodeAtOrNegative : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CharCodeAtOrNegative)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LCharCodeAtOrNegative(const LAllocation& string, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCharCodeAtOrNegative* mir() const { return mir_->toCharCodeAtOrNegative(); };\
};\
class LCodePointAt : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CodePointAt)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LCodePointAt(const LAllocation& string, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCodePointAt* mir() const { return mir_->toCodePointAt(); };\
};\
class LCodePointAtOrNegative : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CodePointAtOrNegative)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LCodePointAtOrNegative(const LAllocation& string, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCodePointAtOrNegative* mir() const { return mir_->toCodePointAtOrNegative(); };\
};\
class LNegativeToNaN : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(NegativeToNaN)\
  static constexpr size_t InputIndex = 0;\
  explicit LNegativeToNaN(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNegativeToNaN* mir() const { return mir_->toNegativeToNaN(); };\
};\
class LNegativeToUndefined : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(NegativeToUndefined)\
  static constexpr size_t InputIndex = 0;\
  explicit LNegativeToUndefined(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MNegativeToUndefined* mir() const { return mir_->toNegativeToUndefined(); };\
};\
class LFromCharCode : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FromCharCode)\
  static constexpr size_t CodeIndex = 0;\
  explicit LFromCharCode(const LAllocation& code) : LInstructionHelper(classOpcode) {\
    setOperand(CodeIndex, code);\
  }\
  const LAllocation* code() const { return getOperand(CodeIndex); }\
  MFromCharCode* mir() const { return mir_->toFromCharCode(); };\
};\
class LFromCharCodeEmptyIfNegative : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FromCharCodeEmptyIfNegative)\
  static constexpr size_t CodeIndex = 0;\
  explicit LFromCharCodeEmptyIfNegative(const LAllocation& code) : LInstructionHelper(classOpcode) {\
    setOperand(CodeIndex, code);\
  }\
  const LAllocation* code() const { return getOperand(CodeIndex); }\
  MFromCharCodeEmptyIfNegative* mir() const { return mir_->toFromCharCodeEmptyIfNegative(); };\
};\
class LFromCharCodeUndefinedIfNegative : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(FromCharCodeUndefinedIfNegative)\
  static constexpr size_t CodeIndex = 0;\
  explicit LFromCharCodeUndefinedIfNegative(const LAllocation& code) : LInstructionHelper(classOpcode) {\
    setOperand(CodeIndex, code);\
  }\
  const LAllocation* code() const { return getOperand(CodeIndex); }\
  MFromCharCodeUndefinedIfNegative* mir() const { return mir_->toFromCharCodeUndefinedIfNegative(); };\
};\
class LFromCodePoint : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(FromCodePoint)\
  static constexpr size_t CodePointIndex = 0;\
  explicit LFromCodePoint(const LAllocation& codePoint, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(CodePointIndex, codePoint);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* codePoint() const { return getOperand(CodePointIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MFromCodePoint* mir() const { return mir_->toFromCodePoint(); };\
};\
class LStringIncludes : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringIncludes)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t SearchStringIndex = 1;\
  explicit LStringIncludes(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(SearchStringIndex, searchString);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* searchString() const { return getOperand(SearchStringIndex); }\
  MStringIncludes* mir() const { return mir_->toStringIncludes(); };\
};\
class LStringIndexOf : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringIndexOf)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t SearchStringIndex = 1;\
  explicit LStringIndexOf(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(SearchStringIndex, searchString);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* searchString() const { return getOperand(SearchStringIndex); }\
  MStringIndexOf* mir() const { return mir_->toStringIndexOf(); };\
};\
class LStringLastIndexOf : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringLastIndexOf)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t SearchStringIndex = 1;\
  explicit LStringLastIndexOf(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(SearchStringIndex, searchString);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* searchString() const { return getOperand(SearchStringIndex); }\
  MStringLastIndexOf* mir() const { return mir_->toStringLastIndexOf(); };\
};\
class LStringStartsWith : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringStartsWith)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t SearchStringIndex = 1;\
  explicit LStringStartsWith(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(SearchStringIndex, searchString);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* searchString() const { return getOperand(SearchStringIndex); }\
  MStringStartsWith* mir() const { return mir_->toStringStartsWith(); };\
};\
class LStringEndsWith : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringEndsWith)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t SearchStringIndex = 1;\
  explicit LStringEndsWith(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(SearchStringIndex, searchString);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* searchString() const { return getOperand(SearchStringIndex); }\
  MStringEndsWith* mir() const { return mir_->toStringEndsWith(); };\
};\
class LStringTrimStartIndex : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(StringTrimStartIndex)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringTrimStartIndex(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  MStringTrimStartIndex* mir() const { return mir_->toStringTrimStartIndex(); };\
};\
class LStringTrimEndIndex : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringTrimEndIndex)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t StartIndex = 1;\
  explicit LStringTrimEndIndex(const LAllocation& string, const LAllocation& start) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(StartIndex, start);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* start() const { return getOperand(StartIndex); }\
  MStringTrimEndIndex* mir() const { return mir_->toStringTrimEndIndex(); };\
};\
class LStringSplit : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringSplit)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t SeparatorIndex = 1;\
  explicit LStringSplit(const LAllocation& string, const LAllocation& separator) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(StringIndex, string);\
    setOperand(SeparatorIndex, separator);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* separator() const { return getOperand(SeparatorIndex); }\
  MStringSplit* mir() const { return mir_->toStringSplit(); };\
};\
class LImplicitThis : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(ImplicitThis)\
  static constexpr size_t EnvIndex = 0;\
  explicit LImplicitThis(const LAllocation& env) : LInstructionHelper(classOpcode) {\
    setOperand(EnvIndex, env);\
  }\
  const LAllocation* env() const { return getOperand(EnvIndex); }\
  MImplicitThis* mir() const { return mir_->toImplicitThis(); };\
};\
class LUnaryCache : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(UnaryCache)\
  static constexpr size_t InputIndex = 0;\
  explicit LUnaryCache(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  MUnaryCache* mir() const { return mir_->toUnaryCache(); };\
};\
class LCheckOverRecursed : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(CheckOverRecursed)\
  explicit LCheckOverRecursed() : LInstructionHelper(classOpcode) {\
  }\
  MCheckOverRecursed* mir() const { return mir_->toCheckOverRecursed(); };\
};\
class LInterruptCheck : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(InterruptCheck)\
  explicit LInterruptCheck() : LInstructionHelper(classOpcode) {\
  }\
  MInterruptCheck* mir() const { return mir_->toInterruptCheck(); };\
};\
class LWasmTrap : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(WasmTrap)\
  explicit LWasmTrap() : LInstructionHelper(classOpcode) {\
  }\
  MWasmTrap* mir() const { return mir_->toWasmTrap(); };\
};\
class LGlobalDeclInstantiation : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(GlobalDeclInstantiation)\
  explicit LGlobalDeclInstantiation() : LInstructionHelper(classOpcode) {\
  }\
  MGlobalDeclInstantiation* mir() const { return mir_->toGlobalDeclInstantiation(); };\
};\
class LRegExpMatcher : public LInstructionHelper<BOX_PIECES, 3, 0> {\
 public:\
  LIR_HEADER(RegExpMatcher)\
  static constexpr size_t RegexpIndex = 0;\
  static constexpr size_t StringIndex = 1;\
  static constexpr size_t LastIndexIndex = 2;\
  explicit LRegExpMatcher(const LAllocation& regexp, const LAllocation& string, const LAllocation& lastIndex) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(RegexpIndex, regexp);\
    setOperand(StringIndex, string);\
    setOperand(LastIndexIndex, lastIndex);\
  }\
  const LAllocation* regexp() const { return getOperand(RegexpIndex); }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* lastIndex() const { return getOperand(LastIndexIndex); }\
  MRegExpMatcher* mir() const { return mir_->toRegExpMatcher(); };\
};\
class LRegExpSearcher : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(RegExpSearcher)\
  static constexpr size_t RegexpIndex = 0;\
  static constexpr size_t StringIndex = 1;\
  static constexpr size_t LastIndexIndex = 2;\
  explicit LRegExpSearcher(const LAllocation& regexp, const LAllocation& string, const LAllocation& lastIndex) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(RegexpIndex, regexp);\
    setOperand(StringIndex, string);\
    setOperand(LastIndexIndex, lastIndex);\
  }\
  const LAllocation* regexp() const { return getOperand(RegexpIndex); }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* lastIndex() const { return getOperand(LastIndexIndex); }\
  MRegExpSearcher* mir() const { return mir_->toRegExpSearcher(); };\
};\
class LRegExpSearcherLastLimit : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(RegExpSearcherLastLimit)\
  explicit LRegExpSearcherLastLimit(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRegExpSearcherLastLimit* mir() const { return mir_->toRegExpSearcherLastLimit(); };\
};\
class LRegExpExecMatch : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(RegExpExecMatch)\
  static constexpr size_t RegexpIndex = 0;\
  static constexpr size_t StringIndex = 1;\
  explicit LRegExpExecMatch(const LAllocation& regexp, const LAllocation& string) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(RegexpIndex, regexp);\
    setOperand(StringIndex, string);\
  }\
  const LAllocation* regexp() const { return getOperand(RegexpIndex); }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  MRegExpExecMatch* mir() const { return mir_->toRegExpExecMatch(); };\
};\
class LRegExpExecTest : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(RegExpExecTest)\
  static constexpr size_t RegexpIndex = 0;\
  static constexpr size_t StringIndex = 1;\
  explicit LRegExpExecTest(const LAllocation& regexp, const LAllocation& string) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(RegexpIndex, regexp);\
    setOperand(StringIndex, string);\
  }\
  const LAllocation* regexp() const { return getOperand(RegexpIndex); }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  MRegExpExecTest* mir() const { return mir_->toRegExpExecTest(); };\
};\
class LSubstr : public LInstructionHelper<1, 3, 3> {\
 public:\
  LIR_HEADER(Substr)\
  static constexpr size_t StringIndex = 0;\
  static constexpr size_t BeginIndex = 1;\
  static constexpr size_t LengthIndex = 2;\
  explicit LSubstr(const LAllocation& string, const LAllocation& begin, const LAllocation& length, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setOperand(BeginIndex, begin);\
    setOperand(LengthIndex, length);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LAllocation* begin() const { return getOperand(BeginIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MSubstr* mir() const { return mir_->toSubstr(); };\
};\
class LSetFunName : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(SetFunName)\
  static constexpr size_t FunIndex = 0;\
  static constexpr size_t NameIndex = 1;\
  explicit LSetFunName(const LAllocation& fun, const LBoxAllocation& name) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(FunIndex, fun);\
    setBoxOperand(NameIndex, name);\
  }\
  const LAllocation* fun() const { return getOperand(FunIndex); }\
  LBoxAllocation name() const { return getBoxOperand(NameIndex); }\
  MSetFunName* mir() const { return mir_->toSetFunName(); };\
};\
class LSlots : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Slots)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LSlots(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MSlots* mir() const { return mir_->toSlots(); };\
};\
class LElements : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Elements)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LElements(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MElements* mir() const { return mir_->toElements(); };\
};\
class LInitializedLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(InitializedLength)\
  static constexpr size_t ElementsIndex = 0;\
  explicit LInitializedLength(const LAllocation& elements) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  MInitializedLength* mir() const { return mir_->toInitializedLength(); };\
};\
class LSetInitializedLength : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(SetInitializedLength)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LSetInitializedLength(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MSetInitializedLength* mir() const { return mir_->toSetInitializedLength(); };\
};\
class LArrayLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayLength)\
  static constexpr size_t ElementsIndex = 0;\
  explicit LArrayLength(const LAllocation& elements) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  MArrayLength* mir() const { return mir_->toArrayLength(); };\
};\
class LSetArrayLength : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(SetArrayLength)\
  static constexpr size_t ElementsIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LSetArrayLength(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MSetArrayLength* mir() const { return mir_->toSetArrayLength(); };\
};\
class LFunctionLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FunctionLength)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LFunctionLength(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  MFunctionLength* mir() const { return mir_->toFunctionLength(); };\
};\
class LFunctionName : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FunctionName)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LFunctionName(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  MFunctionName* mir() const { return mir_->toFunctionName(); };\
};\
class LArrayBufferByteLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferByteLength)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LArrayBufferByteLength(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MArrayBufferByteLength* mir() const { return mir_->toArrayBufferByteLength(); };\
};\
class LArrayBufferViewLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferViewLength)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LArrayBufferViewLength(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MArrayBufferViewLength* mir() const { return mir_->toArrayBufferViewLength(); };\
};\
class LArrayBufferViewByteOffset : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferViewByteOffset)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LArrayBufferViewByteOffset(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MArrayBufferViewByteOffset* mir() const { return mir_->toArrayBufferViewByteOffset(); };\
};\
class LArrayBufferViewElements : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferViewElements)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LArrayBufferViewElements(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MArrayBufferViewElements* mir() const { return mir_->toArrayBufferViewElements(); };\
};\
class LArrayBufferViewElementsWithOffset : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(ArrayBufferViewElementsWithOffset)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t OffsetIndex = 1;\
  explicit LArrayBufferViewElementsWithOffset(const LAllocation& object, const LAllocation& offset) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(OffsetIndex, offset);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* offset() const { return getOperand(OffsetIndex); }\
  MArrayBufferViewElementsWithOffset* mir() const { return mir_->toArrayBufferViewElementsWithOffset(); };\
};\
class LGrowableSharedArrayBufferByteLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GrowableSharedArrayBufferByteLength)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGrowableSharedArrayBufferByteLength(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MGrowableSharedArrayBufferByteLength* mir() const { return mir_->toGrowableSharedArrayBufferByteLength(); };\
};\
class LTypedArrayElementSize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypedArrayElementSize)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LTypedArrayElementSize(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MTypedArrayElementSize* mir() const { return mir_->toTypedArrayElementSize(); };\
};\
class LTypedArraySet : public LInstructionHelper<0, 3, 0> {\
 public:\
  LIR_HEADER(TypedArraySet)\
  static constexpr size_t TargetIndex = 0;\
  static constexpr size_t SourceIndex = 1;\
  static constexpr size_t OffsetIndex = 2;\
  explicit LTypedArraySet(const LAllocation& target, const LAllocation& source, const LAllocation& offset) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(TargetIndex, target);\
    setOperand(SourceIndex, source);\
    setOperand(OffsetIndex, offset);\
  }\
  const LAllocation* target() const { return getOperand(TargetIndex); }\
  const LAllocation* source() const { return getOperand(SourceIndex); }\
  const LAllocation* offset() const { return getOperand(OffsetIndex); }\
  MTypedArraySet* mir() const { return mir_->toTypedArraySet(); };\
};\
class LTypedArraySetFromSubarray : public LInstructionHelper<0, 5, 0> {\
 public:\
  LIR_HEADER(TypedArraySetFromSubarray)\
  static constexpr size_t TargetIndex = 0;\
  static constexpr size_t SourceIndex = 1;\
  static constexpr size_t OffsetIndex = 2;\
  static constexpr size_t SourceOffsetIndex = 3;\
  static constexpr size_t SourceLengthIndex = 4;\
  explicit LTypedArraySetFromSubarray(const LAllocation& target, const LAllocation& source, const LAllocation& offset, const LAllocation& sourceOffset, const LAllocation& sourceLength) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(TargetIndex, target);\
    setOperand(SourceIndex, source);\
    setOperand(OffsetIndex, offset);\
    setOperand(SourceOffsetIndex, sourceOffset);\
    setOperand(SourceLengthIndex, sourceLength);\
  }\
  const LAllocation* target() const { return getOperand(TargetIndex); }\
  const LAllocation* source() const { return getOperand(SourceIndex); }\
  const LAllocation* offset() const { return getOperand(OffsetIndex); }\
  const LAllocation* sourceOffset() const { return getOperand(SourceOffsetIndex); }\
  const LAllocation* sourceLength() const { return getOperand(SourceLengthIndex); }\
  MTypedArraySetFromSubarray* mir() const { return mir_->toTypedArraySetFromSubarray(); };\
};\
class LGuardTypedArraySetOffset : public LInstructionHelper<1, 3, 1> {\
 public:\
  LIR_HEADER(GuardTypedArraySetOffset)\
  static constexpr size_t OffsetIndex = 0;\
  static constexpr size_t TargetLengthIndex = 1;\
  static constexpr size_t SourceLengthIndex = 2;\
  explicit LGuardTypedArraySetOffset(const LAllocation& offset, const LAllocation& targetLength, const LAllocation& sourceLength, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(OffsetIndex, offset);\
    setOperand(TargetLengthIndex, targetLength);\
    setOperand(SourceLengthIndex, sourceLength);\
    setTemp(0, temp0);\
  }\
  const LAllocation* offset() const { return getOperand(OffsetIndex); }\
  const LAllocation* targetLength() const { return getOperand(TargetLengthIndex); }\
  const LAllocation* sourceLength() const { return getOperand(SourceLengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardTypedArraySetOffset* mir() const { return mir_->toGuardTypedArraySetOffset(); };\
};\
class LToIntegerIndex : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(ToIntegerIndex)\
  static constexpr size_t IndexIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  explicit LToIntegerIndex(const LAllocation& index, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  MToIntegerIndex* mir() const { return mir_->toToIntegerIndex(); };\
};\
class LArrayPush : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(ArrayPush)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LArrayPush(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MArrayPush* mir() const { return mir_->toArrayPush(); };\
};\
class LArraySlice : public LInstructionHelper<1, 3, 2> {\
 public:\
  LIR_HEADER(ArraySlice)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t BeginIndex = 1;\
  static constexpr size_t EndIndex = 2;\
  explicit LArraySlice(const LAllocation& object, const LAllocation& begin, const LAllocation& end, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(BeginIndex, begin);\
    setOperand(EndIndex, end);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* begin() const { return getOperand(BeginIndex); }\
  const LAllocation* end() const { return getOperand(EndIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MArraySlice* mir() const { return mir_->toArraySlice(); };\
};\
class LArgumentsSlice : public LInstructionHelper<1, 3, 2> {\
 public:\
  LIR_HEADER(ArgumentsSlice)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t BeginIndex = 1;\
  static constexpr size_t EndIndex = 2;\
  explicit LArgumentsSlice(const LAllocation& object, const LAllocation& begin, const LAllocation& end, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(BeginIndex, begin);\
    setOperand(EndIndex, end);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* begin() const { return getOperand(BeginIndex); }\
  const LAllocation* end() const { return getOperand(EndIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MArgumentsSlice* mir() const { return mir_->toArgumentsSlice(); };\
};\
class LNormalizeSliceTerm : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(NormalizeSliceTerm)\
  static constexpr size_t ValueIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  explicit LNormalizeSliceTerm(const LAllocation& value, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(ValueIndex, value);\
    setOperand(LengthIndex, length);\
  }\
  const LAllocation* value() const { return getOperand(ValueIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  MNormalizeSliceTerm* mir() const { return mir_->toNormalizeSliceTerm(); };\
};\
class LArrayJoin : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(ArrayJoin)\
  static constexpr size_t ArrayIndex = 0;\
  static constexpr size_t SeparatorIndex = 1;\
  explicit LArrayJoin(const LAllocation& array, const LAllocation& separator, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ArrayIndex, array);\
    setOperand(SeparatorIndex, separator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* array() const { return getOperand(ArrayIndex); }\
  const LAllocation* separator() const { return getOperand(SeparatorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MArrayJoin* mir() const { return mir_->toArrayJoin(); };\
};\
class LHomeObjectSuperBase : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(HomeObjectSuperBase)\
  static constexpr size_t HomeObjectIndex = 0;\
  explicit LHomeObjectSuperBase(const LAllocation& homeObject) : LInstructionHelper(classOpcode) {\
    setOperand(HomeObjectIndex, homeObject);\
  }\
  const LAllocation* homeObject() const { return getOperand(HomeObjectIndex); }\
  MHomeObjectSuperBase* mir() const { return mir_->toHomeObjectSuperBase(); };\
};\
class LBindNameCache : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(BindNameCache)\
  static constexpr size_t EnvironmentChainIndex = 0;\
  explicit LBindNameCache(const LAllocation& environmentChain, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(EnvironmentChainIndex, environmentChain);\
    setTemp(0, temp0);\
  }\
  const LAllocation* environmentChain() const { return getOperand(EnvironmentChainIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MBindNameCache* mir() const { return mir_->toBindNameCache(); };\
};\
class LCallBindVar : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CallBindVar)\
  static constexpr size_t EnvironmentChainIndex = 0;\
  explicit LCallBindVar(const LAllocation& environmentChain) : LInstructionHelper(classOpcode) {\
    setOperand(EnvironmentChainIndex, environmentChain);\
  }\
  const LAllocation* environmentChain() const { return getOperand(EnvironmentChainIndex); }\
  MCallBindVar* mir() const { return mir_->toCallBindVar(); };\
};\
class LGuardShape : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardShape)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardShape(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardShape* mir() const { return mir_->toGuardShape(); };\
};\
class LHasShape : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(HasShape)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LHasShape(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MHasShape* mir() const { return mir_->toHasShape(); };\
};\
class LGuardFuse : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(GuardFuse)\
  explicit LGuardFuse() : LInstructionHelper(classOpcode) {\
  }\
  MGuardFuse* mir() const { return mir_->toGuardFuse(); };\
};\
class LGuardMultipleShapes : public LInstructionHelper<1, 2, 4> {\
 public:\
  LIR_HEADER(GuardMultipleShapes)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ShapeListIndex = 1;\
  explicit LGuardMultipleShapes(const LAllocation& object, const LAllocation& shapeList, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(ShapeListIndex, shapeList);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* shapeList() const { return getOperand(ShapeListIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MGuardMultipleShapes* mir() const { return mir_->toGuardMultipleShapes(); };\
};\
class LGuardShapeList : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(GuardShapeList)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardShapeList(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MGuardShapeList* mir() const { return mir_->toGuardShapeList(); };\
};\
class LProxyGet : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(ProxyGet)\
  static constexpr size_t ProxyIndex = 0;\
  explicit LProxyGet(const LAllocation& proxy, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ProxyIndex, proxy);\
    setTemp(0, temp0);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MProxyGet* mir() const { return mir_->toProxyGet(); };\
};\
class LProxyGetByValue : public LInstructionHelper<BOX_PIECES, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ProxyGetByValue)\
  static constexpr size_t ProxyIndex = 0;\
  static constexpr size_t IdValIndex = 1;\
  explicit LProxyGetByValue(const LAllocation& proxy, const LBoxAllocation& idVal) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ProxyIndex, proxy);\
    setBoxOperand(IdValIndex, idVal);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  LBoxAllocation idVal() const { return getBoxOperand(IdValIndex); }\
  MProxyGetByValue* mir() const { return mir_->toProxyGetByValue(); };\
};\
class LProxySet : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ProxySet)\
  static constexpr size_t ProxyIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LProxySet(const LAllocation& proxy, const LBoxAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ProxyIndex, proxy);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  LBoxAllocation rhs() const { return getBoxOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MProxySet* mir() const { return mir_->toProxySet(); };\
};\
class LProxySetByValue : public LInstructionHelper<0, 1 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ProxySetByValue)\
  static constexpr size_t ProxyIndex = 0;\
  static constexpr size_t IdValIndex = 1;\
  static constexpr size_t RhsIndex = 1 + 1 * BOX_PIECES;\
  explicit LProxySetByValue(const LAllocation& proxy, const LBoxAllocation& idVal, const LBoxAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ProxyIndex, proxy);\
    setBoxOperand(IdValIndex, idVal);\
    setBoxOperand(RhsIndex, rhs);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  LBoxAllocation idVal() const { return getBoxOperand(IdValIndex); }\
  LBoxAllocation rhs() const { return getBoxOperand(RhsIndex); }\
  MProxySetByValue* mir() const { return mir_->toProxySetByValue(); };\
};\
class LCallSetArrayLength : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CallSetArrayLength)\
  static constexpr size_t ObjIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LCallSetArrayLength(const LAllocation& obj, const LBoxAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjIndex, obj);\
    setBoxOperand(RhsIndex, rhs);\
  }\
  const LAllocation* obj() const { return getOperand(ObjIndex); }\
  LBoxAllocation rhs() const { return getBoxOperand(RhsIndex); }\
  MCallSetArrayLength* mir() const { return mir_->toCallSetArrayLength(); };\
};\
class LMegamorphicLoadSlot : public LInstructionHelper<BOX_PIECES, 1, 4> {\
 public:\
  LIR_HEADER(MegamorphicLoadSlot)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LMegamorphicLoadSlot(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMegamorphicLoadSlot* mir() const { return mir_->toMegamorphicLoadSlot(); };\
};\
class LMegamorphicLoadSlotPermissive : public LInstructionHelper<BOX_PIECES, 1, 4> {\
 public:\
  LIR_HEADER(MegamorphicLoadSlotPermissive)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LMegamorphicLoadSlotPermissive(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMegamorphicLoadSlotPermissive* mir() const { return mir_->toMegamorphicLoadSlotPermissive(); };\
};\
class LMegamorphicLoadSlotByValue : public LInstructionHelper<BOX_PIECES, 1 + 1 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(MegamorphicLoadSlotByValue)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IdValIndex = 1;\
  explicit LMegamorphicLoadSlotByValue(const LAllocation& object, const LBoxAllocation& idVal, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(IdValIndex, idVal);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation idVal() const { return getBoxOperand(IdValIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MMegamorphicLoadSlotByValue* mir() const { return mir_->toMegamorphicLoadSlotByValue(); };\
};\
class LMegamorphicLoadSlotByValuePermissive : public LInstructionHelper<BOX_PIECES, 1 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(MegamorphicLoadSlotByValuePermissive)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IdValIndex = 1;\
  explicit LMegamorphicLoadSlotByValuePermissive(const LAllocation& object, const LBoxAllocation& idVal, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(IdValIndex, idVal);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation idVal() const { return getBoxOperand(IdValIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMegamorphicLoadSlotByValuePermissive* mir() const { return mir_->toMegamorphicLoadSlotByValuePermissive(); };\
};\
class LMegamorphicStoreSlot : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(MegamorphicStoreSlot)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t RhsIndex = 1;\
  explicit LMegamorphicStoreSlot(const LAllocation& object, const LBoxAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation rhs() const { return getBoxOperand(RhsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MMegamorphicStoreSlot* mir() const { return mir_->toMegamorphicStoreSlot(); };\
};\
class LMegamorphicHasProp : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 3> {\
 public:\
  LIR_HEADER(MegamorphicHasProp)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IdValIndex = 1;\
  explicit LMegamorphicHasProp(const LAllocation& object, const LBoxAllocation& idVal, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(IdValIndex, idVal);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation idVal() const { return getBoxOperand(IdValIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MMegamorphicHasProp* mir() const { return mir_->toMegamorphicHasProp(); };\
};\
class LSmallObjectVariableKeyHasProp : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SmallObjectVariableKeyHasProp)\
  static constexpr size_t IdStrIndex = 0;\
  explicit LSmallObjectVariableKeyHasProp(const LAllocation& idStr) : LInstructionHelper(classOpcode) {\
    setOperand(IdStrIndex, idStr);\
  }\
  const LAllocation* idStr() const { return getOperand(IdStrIndex); }\
  MSmallObjectVariableKeyHasProp* mir() const { return mir_->toSmallObjectVariableKeyHasProp(); };\
};\
class LGuardToArrayBuffer : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardToArrayBuffer)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardToArrayBuffer(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardToArrayBuffer* mir() const { return mir_->toGuardToArrayBuffer(); };\
};\
class LGuardToSharedArrayBuffer : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardToSharedArrayBuffer)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LGuardToSharedArrayBuffer(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardToSharedArrayBuffer* mir() const { return mir_->toGuardToSharedArrayBuffer(); };\
};\
class LNurseryObject : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(NurseryObject)\
  explicit LNurseryObject() : LInstructionHelper(classOpcode) {\
  }\
  MNurseryObject* mir() const { return mir_->toNurseryObject(); };\
};\
class LGuardStringToIndex : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GuardStringToIndex)\
  static constexpr size_t StringIndex = 0;\
  explicit LGuardStringToIndex(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  MGuardStringToIndex* mir() const { return mir_->toGuardStringToIndex(); };\
};\
class LGuardStringToInt32 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardStringToInt32)\
  static constexpr size_t StringIndex = 0;\
  explicit LGuardStringToInt32(const LAllocation& string, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardStringToInt32* mir() const { return mir_->toGuardStringToInt32(); };\
};\
class LGuardStringToDouble : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(GuardStringToDouble)\
  static constexpr size_t StringIndex = 0;\
  explicit LGuardStringToDouble(const LAllocation& string, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MGuardStringToDouble* mir() const { return mir_->toGuardStringToDouble(); };\
};\
class LFunctionEnvironment : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FunctionEnvironment)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LFunctionEnvironment(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  MFunctionEnvironment* mir() const { return mir_->toFunctionEnvironment(); };\
};\
class LHomeObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(HomeObject)\
  static constexpr size_t FunctionIndex = 0;\
  explicit LHomeObject(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  MHomeObject* mir() const { return mir_->toHomeObject(); };\
};\
class LAllocateAndStoreSlot : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(AllocateAndStoreSlot)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LAllocateAndStoreSlot(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MAllocateAndStoreSlot* mir() const { return mir_->toAllocateAndStoreSlot(); };\
};\
class LAddSlotAndCallAddPropHook : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(AddSlotAndCallAddPropHook)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LAddSlotAndCallAddPropHook(const LAllocation& object, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MAddSlotAndCallAddPropHook* mir() const { return mir_->toAddSlotAndCallAddPropHook(); };\
};\
class LGetNameCache : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(GetNameCache)\
  static constexpr size_t EnvObjIndex = 0;\
  explicit LGetNameCache(const LAllocation& envObj, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(EnvObjIndex, envObj);\
    setTemp(0, temp0);\
  }\
  const LAllocation* envObj() const { return getOperand(EnvObjIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGetNameCache* mir() const { return mir_->toGetNameCache(); };\
};\
class LCallGetIntrinsicValue : public LInstructionHelper<BOX_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(CallGetIntrinsicValue)\
  explicit LCallGetIntrinsicValue() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
  }\
  MCallGetIntrinsicValue* mir() const { return mir_->toCallGetIntrinsicValue(); };\
};\
class LIteratorLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IteratorLength)\
  static constexpr size_t IterIndex = 0;\
  explicit LIteratorLength(const LAllocation& iter) : LInstructionHelper(classOpcode) {\
    setOperand(IterIndex, iter);\
  }\
  const LAllocation* iter() const { return getOperand(IterIndex); }\
  MIteratorLength* mir() const { return mir_->toIteratorLength(); };\
};\
class LLoadIteratorElement : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(LoadIteratorElement)\
  static constexpr size_t IterIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LLoadIteratorElement(const LAllocation& iter, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(IterIndex, iter);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* iter() const { return getOperand(IterIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MLoadIteratorElement* mir() const { return mir_->toLoadIteratorElement(); };\
};\
class LLoadSlotByIteratorIndex : public LInstructionHelper<BOX_PIECES, 2, 2> {\
 public:\
  LIR_HEADER(LoadSlotByIteratorIndex)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IteratorIndex = 1;\
  explicit LLoadSlotByIteratorIndex(const LAllocation& object, const LAllocation& iterator, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(IteratorIndex, iterator);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MLoadSlotByIteratorIndex* mir() const { return mir_->toLoadSlotByIteratorIndex(); };\
};\
class LStoreSlotByIteratorIndex : public LInstructionHelper<0, 2 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(StoreSlotByIteratorIndex)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IteratorIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LStoreSlotByIteratorIndex(const LAllocation& object, const LAllocation& iterator, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(IteratorIndex, iterator);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MStoreSlotByIteratorIndex* mir() const { return mir_->toStoreSlotByIteratorIndex(); };\
};\
class LLoadSlotByIteratorIndexIndexed : public LInstructionHelper<BOX_PIECES, 3, 2> {\
 public:\
  LIR_HEADER(LoadSlotByIteratorIndexIndexed)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IteratorIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  explicit LLoadSlotByIteratorIndexIndexed(const LAllocation& object, const LAllocation& iterator, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(IteratorIndex, iterator);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MLoadSlotByIteratorIndexIndexed* mir() const { return mir_->toLoadSlotByIteratorIndexIndexed(); };\
};\
class LStoreSlotByIteratorIndexIndexed : public LInstructionHelper<0, 3 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(StoreSlotByIteratorIndexIndexed)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IteratorIndex = 1;\
  static constexpr size_t IndexIndex = 2;\
  static constexpr size_t ValueIndex = 3;\
  explicit LStoreSlotByIteratorIndexIndexed(const LAllocation& object, const LAllocation& iterator, const LAllocation& index, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setOperand(IteratorIndex, iterator);\
    setOperand(IndexIndex, index);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MStoreSlotByIteratorIndexIndexed* mir() const { return mir_->toStoreSlotByIteratorIndexIndexed(); };\
};\
class LLoadDOMExpandoValue : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDOMExpandoValue)\
  static constexpr size_t ProxyIndex = 0;\
  explicit LLoadDOMExpandoValue(const LAllocation& proxy) : LInstructionHelper(classOpcode) {\
    setOperand(ProxyIndex, proxy);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  MLoadDOMExpandoValue* mir() const { return mir_->toLoadDOMExpandoValue(); };\
};\
class LLoadDOMExpandoValueIgnoreGeneration : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDOMExpandoValueIgnoreGeneration)\
  static constexpr size_t ProxyIndex = 0;\
  explicit LLoadDOMExpandoValueIgnoreGeneration(const LAllocation& proxy) : LInstructionHelper(classOpcode) {\
    setOperand(ProxyIndex, proxy);\
  }\
  const LAllocation* proxy() const { return getOperand(ProxyIndex); }\
  MLoadDOMExpandoValueIgnoreGeneration* mir() const { return mir_->toLoadDOMExpandoValueIgnoreGeneration(); };\
};\
class LStringLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(StringLength)\
  static constexpr size_t StringIndex = 0;\
  explicit LStringLength(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    setOperand(StringIndex, string);\
  }\
  const LAllocation* string() const { return getOperand(StringIndex); }\
  MStringLength* mir() const { return mir_->toStringLength(); };\
};\
class LOptimizeSpreadCallCache : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(OptimizeSpreadCallCache)\
  static constexpr size_t ValueIndex = 0;\
  explicit LOptimizeSpreadCallCache(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MOptimizeSpreadCallCache* mir() const { return mir_->toOptimizeSpreadCallCache(); };\
};\
class LIteratorMore : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(IteratorMore)\
  static constexpr size_t IteratorIndex = 0;\
  explicit LIteratorMore(const LAllocation& iterator, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(IteratorIndex, iterator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIteratorMore* mir() const { return mir_->toIteratorMore(); };\
};\
class LIteratorEnd : public LInstructionHelper<0, 1, 3> {\
 public:\
  LIR_HEADER(IteratorEnd)\
  static constexpr size_t IteratorIndex = 0;\
  explicit LIteratorEnd(const LAllocation& iterator, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(IteratorIndex, iterator);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* iterator() const { return getOperand(IteratorIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MIteratorEnd* mir() const { return mir_->toIteratorEnd(); };\
};\
class LOptimizeGetIteratorCache : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(OptimizeGetIteratorCache)\
  static constexpr size_t ValueIndex = 0;\
  explicit LOptimizeGetIteratorCache(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MOptimizeGetIteratorCache* mir() const { return mir_->toOptimizeGetIteratorCache(); };\
};\
class LNewPrivateName : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(NewPrivateName)\
  explicit LNewPrivateName() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
  }\
  MNewPrivateName* mir() const { return mir_->toNewPrivateName(); };\
};\
class LInstanceOfCache : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(InstanceOfCache)\
  static constexpr size_t ProtoIndex = 0;\
  static constexpr size_t ObjIndex = 1;\
  explicit LInstanceOfCache(const LBoxAllocation& obj, const LAllocation& proto) : LInstructionHelper(classOpcode) {\
    setOperand(ProtoIndex, proto);\
    setBoxOperand(ObjIndex, obj);\
  }\
  const LAllocation* proto() const { return getOperand(ProtoIndex); }\
  LBoxAllocation obj() const { return getBoxOperand(ObjIndex); }\
  MInstanceOfCache* mir() const { return mir_->toInstanceOfCache(); };\
};\
class LArgumentsLength : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(ArgumentsLength)\
  explicit LArgumentsLength() : LInstructionHelper(classOpcode) {\
  }\
  MArgumentsLength* mir() const { return mir_->toArgumentsLength(); };\
};\
class LGetFrameArgument : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(GetFrameArgument)\
  static constexpr size_t IndexIndex = 0;\
  explicit LGetFrameArgument(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MGetFrameArgument* mir() const { return mir_->toGetFrameArgument(); };\
};\
class LGetFrameArgumentHole : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(GetFrameArgumentHole)\
  static constexpr size_t IndexIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  explicit LGetFrameArgumentHole(const LAllocation& index, const LAllocation& length, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
    setTemp(0, temp0);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGetFrameArgumentHole* mir() const { return mir_->toGetFrameArgumentHole(); };\
};\
class LNewTarget : public LInstructionHelper<BOX_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(NewTarget)\
  explicit LNewTarget() : LInstructionHelper(classOpcode) {\
  }\
  MNewTarget* mir() const { return mir_->toNewTarget(); };\
};\
class LRest : public LInstructionHelper<1, 1, 4> {\
 public:\
  LIR_HEADER(Rest)\
  static constexpr size_t NumActualsIndex = 0;\
  explicit LRest(const LAllocation& numActuals, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(NumActualsIndex, numActuals);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* numActuals() const { return getOperand(NumActualsIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MRest* mir() const { return mir_->toRest(); };\
};\
class LNewNamedLambdaObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewNamedLambdaObject)\
  explicit LNewNamedLambdaObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewNamedLambdaObject* mir() const { return mir_->toNewNamedLambdaObject(); };\
};\
class LIsConstructor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsConstructor)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MIsConstructor* mir() const { return mir_->toIsConstructor(); };\
};\
class LIsCrossRealmArrayConstructor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsCrossRealmArrayConstructor)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsCrossRealmArrayConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MIsCrossRealmArrayConstructor* mir() const { return mir_->toIsCrossRealmArrayConstructor(); };\
};\
class LIsObject : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(IsObject)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsObject(const LBoxAllocation& object) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ObjectIndex, object);\
  }\
  LBoxAllocation object() const { return getBoxOperand(ObjectIndex); }\
  MIsObject* mir() const { return mir_->toIsObject(); };\
};\
class LIsNullOrUndefined : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(IsNullOrUndefined)\
  static constexpr size_t ValueIndex = 0;\
  explicit LIsNullOrUndefined(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MIsNullOrUndefined* mir() const { return mir_->toIsNullOrUndefined(); };\
};\
class LObjectClassToString : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(ObjectClassToString)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LObjectClassToString(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MObjectClassToString* mir() const { return mir_->toObjectClassToString(); };\
};\
class LCheckReturn : public LInstructionHelper<BOX_PIECES, 0 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CheckReturn)\
  static constexpr size_t ReturnValueIndex = 0;\
  static constexpr size_t ThisValueIndex = 1 * BOX_PIECES;\
  explicit LCheckReturn(const LBoxAllocation& returnValue, const LBoxAllocation& thisValue) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ReturnValueIndex, returnValue);\
    setBoxOperand(ThisValueIndex, thisValue);\
  }\
  LBoxAllocation returnValue() const { return getBoxOperand(ReturnValueIndex); }\
  LBoxAllocation thisValue() const { return getBoxOperand(ThisValueIndex); }\
  MCheckReturn* mir() const { return mir_->toCheckReturn(); };\
};\
class LIncrementWarmUpCounter : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(IncrementWarmUpCounter)\
  explicit LIncrementWarmUpCounter(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIncrementWarmUpCounter* mir() const { return mir_->toIncrementWarmUpCounter(); };\
};\
class LAtomicPause : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(AtomicPause)\
  explicit LAtomicPause() : LInstructionHelper(classOpcode) {\
  }\
  MAtomicPause* mir() const { return mir_->toAtomicPause(); };\
};\
class LCheckIsObj : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CheckIsObj)\
  static constexpr size_t ValueIndex = 0;\
  explicit LCheckIsObj(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MCheckIsObj* mir() const { return mir_->toCheckIsObj(); };\
};\
class LIsPackedArray : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(IsPackedArray)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsPackedArray(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIsPackedArray* mir() const { return mir_->toIsPackedArray(); };\
};\
class LGuardElementsArePacked : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardElementsArePacked)\
  static constexpr size_t ElementsIndex = 0;\
  explicit LGuardElementsArePacked(const LAllocation& elements) : LInstructionHelper(classOpcode) {\
    setOperand(ElementsIndex, elements);\
  }\
  const LAllocation* elements() const { return getOperand(ElementsIndex); }\
  MGuardElementsArePacked* mir() const { return mir_->toGuardElementsArePacked(); };\
};\
class LGetPrototypeOf : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(GetPrototypeOf)\
  static constexpr size_t TargetIndex = 0;\
  explicit LGetPrototypeOf(const LAllocation& target) : LInstructionHelper(classOpcode) {\
    setOperand(TargetIndex, target);\
  }\
  const LAllocation* target() const { return getOperand(TargetIndex); }\
  MGetPrototypeOf* mir() const { return mir_->toGetPrototypeOf(); };\
};\
class LObjectWithProto : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(ObjectWithProto)\
  static constexpr size_t PrototypeIndex = 0;\
  explicit LObjectWithProto(const LBoxAllocation& prototype) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(PrototypeIndex, prototype);\
  }\
  LBoxAllocation prototype() const { return getBoxOperand(PrototypeIndex); }\
  MObjectWithProto* mir() const { return mir_->toObjectWithProto(); };\
};\
class LBuiltinObject : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(BuiltinObject)\
  explicit LBuiltinObject() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
  }\
  MBuiltinObject* mir() const { return mir_->toBuiltinObject(); };\
};\
class LSuperFunction : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(SuperFunction)\
  static constexpr size_t CalleeIndex = 0;\
  explicit LSuperFunction(const LAllocation& callee) : LInstructionHelper(classOpcode) {\
    setOperand(CalleeIndex, callee);\
  }\
  const LAllocation* callee() const { return getOperand(CalleeIndex); }\
  MSuperFunction* mir() const { return mir_->toSuperFunction(); };\
};\
class LSuperFunctionAndUnbox : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SuperFunctionAndUnbox)\
  static constexpr size_t CalleeIndex = 0;\
  explicit LSuperFunctionAndUnbox(const LAllocation& callee) : LInstructionHelper(classOpcode) {\
    setOperand(CalleeIndex, callee);\
  }\
  const LAllocation* callee() const { return getOperand(CalleeIndex); }\
  MSuperFunctionAndUnbox* mir() const { return mir_->toSuperFunctionAndUnbox(); };\
};\
class LInitHomeObject : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(InitHomeObject)\
  static constexpr size_t FunctionIndex = 0;\
  static constexpr size_t HomeObjectIndex = 1;\
  explicit LInitHomeObject(const LAllocation& function, const LBoxAllocation& homeObject) : LInstructionHelper(classOpcode) {\
    setOperand(FunctionIndex, function);\
    setBoxOperand(HomeObjectIndex, homeObject);\
  }\
  const LAllocation* function() const { return getOperand(FunctionIndex); }\
  LBoxAllocation homeObject() const { return getBoxOperand(HomeObjectIndex); }\
  MInitHomeObject* mir() const { return mir_->toInitHomeObject(); };\
};\
class LIsTypedArrayConstructor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsTypedArrayConstructor)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LIsTypedArrayConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MIsTypedArrayConstructor* mir() const { return mir_->toIsTypedArrayConstructor(); };\
};\
class LLoadValueTag : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(LoadValueTag)\
  static constexpr size_t ValueIndex = 0;\
  explicit LLoadValueTag(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MLoadValueTag* mir() const { return mir_->toLoadValueTag(); };\
};\
class LLoadWrapperTarget : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadWrapperTarget)\
  static constexpr size_t ObjectIndex = 0;\
  explicit LLoadWrapperTarget(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MLoadWrapperTarget* mir() const { return mir_->toLoadWrapperTarget(); };\
};\
class LLoadGetterSetterFunction : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(LoadGetterSetterFunction)\
  static constexpr size_t GetterSetterIndex = 0;\
  explicit LLoadGetterSetterFunction(const LBoxAllocation& getterSetter, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(GetterSetterIndex, getterSetter);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation getterSetter() const { return getBoxOperand(GetterSetterIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadGetterSetterFunction* mir() const { return mir_->toLoadGetterSetterFunction(); };\
};\
class LGuardIntPtrIsNonNegative : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GuardIntPtrIsNonNegative)\
  static constexpr size_t IndexIndex = 0;\
  explicit LGuardIntPtrIsNonNegative(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MGuardIntPtrIsNonNegative* mir() const { return mir_->toGuardIntPtrIsNonNegative(); };\
};\
class LCallAddOrUpdateSparseElement : public LInstructionHelper<0, 2 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CallAddOrUpdateSparseElement)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LCallAddOrUpdateSparseElement(const LAllocation& object, const LAllocation& index, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MCallAddOrUpdateSparseElement* mir() const { return mir_->toCallAddOrUpdateSparseElement(); };\
};\
class LCallGetSparseElement : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(CallGetSparseElement)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LCallGetSparseElement(const LAllocation& object, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MCallGetSparseElement* mir() const { return mir_->toCallGetSparseElement(); };\
};\
class LCallNativeGetElement : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(CallNativeGetElement)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LCallNativeGetElement(const LAllocation& object, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  MCallNativeGetElement* mir() const { return mir_->toCallNativeGetElement(); };\
};\
class LCallNativeGetElementSuper : public LInstructionHelper<BOX_PIECES, 2 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(CallNativeGetElementSuper)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  static constexpr size_t ReceiverIndex = 2;\
  explicit LCallNativeGetElementSuper(const LAllocation& object, const LAllocation& index, const LBoxAllocation& receiver) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
    setBoxOperand(ReceiverIndex, receiver);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  LBoxAllocation receiver() const { return getBoxOperand(ReceiverIndex); }\
  MCallNativeGetElementSuper* mir() const { return mir_->toCallNativeGetElementSuper(); };\
};\
class LCallObjectHasSparseElement : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CallObjectHasSparseElement)\
  static constexpr size_t ObjectIndex = 0;\
  static constexpr size_t IndexIndex = 1;\
  explicit LCallObjectHasSparseElement(const LAllocation& object, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(ObjectIndex, object);\
    setOperand(IndexIndex, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCallObjectHasSparseElement* mir() const { return mir_->toCallObjectHasSparseElement(); };\
};\
class LBigIntAsIntN : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntAsIntN)\
  static constexpr size_t BitsIndex = 0;\
  static constexpr size_t InputIndex = 1;\
  explicit LBigIntAsIntN(const LAllocation& bits, const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(BitsIndex, bits);\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* bits() const { return getOperand(BitsIndex); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MBigIntAsIntN* mir() const { return mir_->toBigIntAsIntN(); };\
};\
class LBigIntAsUintN : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntAsUintN)\
  static constexpr size_t BitsIndex = 0;\
  static constexpr size_t InputIndex = 1;\
  explicit LBigIntAsUintN(const LAllocation& bits, const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(BitsIndex, bits);\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* bits() const { return getOperand(BitsIndex); }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MBigIntAsUintN* mir() const { return mir_->toBigIntAsUintN(); };\
};\
class LToHashableNonGCThing : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ToHashableNonGCThing)\
  static constexpr size_t InputIndex = 0;\
  explicit LToHashableNonGCThing(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToHashableNonGCThing* mir() const { return mir_->toToHashableNonGCThing(); };\
};\
class LToHashableString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ToHashableString)\
  static constexpr size_t InputIndex = 0;\
  explicit LToHashableString(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MToHashableString* mir() const { return mir_->toToHashableString(); };\
};\
class LToHashableValue : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(ToHashableValue)\
  static constexpr size_t InputIndex = 0;\
  explicit LToHashableValue(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToHashableValue* mir() const { return mir_->toToHashableValue(); };\
};\
class LHashNonGCThing : public LInstructionHelper<1, 0 + 1 * BOX_PIECES, 1> {\
 public:\
  LIR_HEADER(HashNonGCThing)\
  static constexpr size_t InputIndex = 0;\
  explicit LHashNonGCThing(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MHashNonGCThing* mir() const { return mir_->toHashNonGCThing(); };\
};\
class LHashString : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(HashString)\
  static constexpr size_t InputIndex = 0;\
  explicit LHashString(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MHashString* mir() const { return mir_->toHashString(); };\
};\
class LHashSymbol : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(HashSymbol)\
  static constexpr size_t InputIndex = 0;\
  explicit LHashSymbol(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  MHashSymbol* mir() const { return mir_->toHashSymbol(); };\
};\
class LHashBigInt : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(HashBigInt)\
  static constexpr size_t InputIndex = 0;\
  explicit LHashBigInt(const LAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* input() const { return getOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MHashBigInt* mir() const { return mir_->toHashBigInt(); };\
};\
class LHashObject : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(HashObject)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t InputIndex = 1;\
  explicit LHashObject(const LAllocation& setObject, const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(SetObjectIndex, setObject);\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MHashObject* mir() const { return mir_->toHashObject(); };\
};\
class LHashValue : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(HashValue)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t InputIndex = 1;\
  explicit LHashValue(const LAllocation& setObject, const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(SetObjectIndex, setObject);\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  LBoxAllocation input() const { return getBoxOperand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MHashValue* mir() const { return mir_->toHashValue(); };\
};\
class LSetObjectHasNonBigInt : public LInstructionHelper<1, 2 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(SetObjectHasNonBigInt)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LSetObjectHasNonBigInt(const LAllocation& setObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(SetObjectIndex, setObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MSetObjectHasNonBigInt* mir() const { return mir_->toSetObjectHasNonBigInt(); };\
};\
class LSetObjectHasBigInt : public LInstructionHelper<1, 2 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(SetObjectHasBigInt)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LSetObjectHasBigInt(const LAllocation& setObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(SetObjectIndex, setObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MSetObjectHasBigInt* mir() const { return mir_->toSetObjectHasBigInt(); };\
};\
class LSetObjectHasValue : public LInstructionHelper<1, 2 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(SetObjectHasValue)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LSetObjectHasValue(const LAllocation& setObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(SetObjectIndex, setObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MSetObjectHasValue* mir() const { return mir_->toSetObjectHasValue(); };\
};\
class LSetObjectHasValueVMCall : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(SetObjectHasValueVMCall)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LSetObjectHasValueVMCall(const LAllocation& setObject, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(SetObjectIndex, setObject);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MSetObjectHasValueVMCall* mir() const { return mir_->toSetObjectHasValueVMCall(); };\
};\
class LSetObjectDelete : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(SetObjectDelete)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t KeyIndex = 1;\
  explicit LSetObjectDelete(const LAllocation& setObject, const LBoxAllocation& key) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(SetObjectIndex, setObject);\
    setBoxOperand(KeyIndex, key);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  LBoxAllocation key() const { return getBoxOperand(KeyIndex); }\
  MSetObjectDelete* mir() const { return mir_->toSetObjectDelete(); };\
};\
class LSetObjectAdd : public LInstructionHelper<0, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(SetObjectAdd)\
  static constexpr size_t SetObjectIndex = 0;\
  static constexpr size_t KeyIndex = 1;\
  explicit LSetObjectAdd(const LAllocation& setObject, const LBoxAllocation& key) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(SetObjectIndex, setObject);\
    setBoxOperand(KeyIndex, key);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  LBoxAllocation key() const { return getBoxOperand(KeyIndex); }\
  MSetObjectAdd* mir() const { return mir_->toSetObjectAdd(); };\
};\
class LSetObjectSize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SetObjectSize)\
  static constexpr size_t SetObjectIndex = 0;\
  explicit LSetObjectSize(const LAllocation& setObject) : LInstructionHelper(classOpcode) {\
    setOperand(SetObjectIndex, setObject);\
  }\
  const LAllocation* setObject() const { return getOperand(SetObjectIndex); }\
  MSetObjectSize* mir() const { return mir_->toSetObjectSize(); };\
};\
class LMapObjectHasNonBigInt : public LInstructionHelper<1, 2 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(MapObjectHasNonBigInt)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LMapObjectHasNonBigInt(const LAllocation& mapObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(MapObjectIndex, mapObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MMapObjectHasNonBigInt* mir() const { return mir_->toMapObjectHasNonBigInt(); };\
};\
class LMapObjectHasBigInt : public LInstructionHelper<1, 2 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(MapObjectHasBigInt)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LMapObjectHasBigInt(const LAllocation& mapObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(MapObjectIndex, mapObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMapObjectHasBigInt* mir() const { return mir_->toMapObjectHasBigInt(); };\
};\
class LMapObjectHasValue : public LInstructionHelper<1, 2 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(MapObjectHasValue)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LMapObjectHasValue(const LAllocation& mapObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(MapObjectIndex, mapObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMapObjectHasValue* mir() const { return mir_->toMapObjectHasValue(); };\
};\
class LMapObjectHasValueVMCall : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(MapObjectHasValueVMCall)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LMapObjectHasValueVMCall(const LAllocation& mapObject, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(MapObjectIndex, mapObject);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MMapObjectHasValueVMCall* mir() const { return mir_->toMapObjectHasValueVMCall(); };\
};\
class LMapObjectGetNonBigInt : public LInstructionHelper<BOX_PIECES, 2 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(MapObjectGetNonBigInt)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LMapObjectGetNonBigInt(const LAllocation& mapObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(MapObjectIndex, mapObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MMapObjectGetNonBigInt* mir() const { return mir_->toMapObjectGetNonBigInt(); };\
};\
class LMapObjectGetBigInt : public LInstructionHelper<BOX_PIECES, 2 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(MapObjectGetBigInt)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LMapObjectGetBigInt(const LAllocation& mapObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(MapObjectIndex, mapObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMapObjectGetBigInt* mir() const { return mir_->toMapObjectGetBigInt(); };\
};\
class LMapObjectGetValue : public LInstructionHelper<BOX_PIECES, 2 + 1 * BOX_PIECES, 4> {\
 public:\
  LIR_HEADER(MapObjectGetValue)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t HashIndex = 1;\
  static constexpr size_t ValueIndex = 2;\
  explicit LMapObjectGetValue(const LAllocation& mapObject, const LBoxAllocation& value, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(MapObjectIndex, mapObject);\
    setOperand(HashIndex, hash);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  const LAllocation* hash() const { return getOperand(HashIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMapObjectGetValue* mir() const { return mir_->toMapObjectGetValue(); };\
};\
class LMapObjectGetValueVMCall : public LInstructionHelper<BOX_PIECES, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(MapObjectGetValueVMCall)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t ValueIndex = 1;\
  explicit LMapObjectGetValueVMCall(const LAllocation& mapObject, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(MapObjectIndex, mapObject);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MMapObjectGetValueVMCall* mir() const { return mir_->toMapObjectGetValueVMCall(); };\
};\
class LMapObjectDelete : public LInstructionHelper<1, 1 + 1 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(MapObjectDelete)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t KeyIndex = 1;\
  explicit LMapObjectDelete(const LAllocation& mapObject, const LBoxAllocation& key) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(MapObjectIndex, mapObject);\
    setBoxOperand(KeyIndex, key);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  LBoxAllocation key() const { return getBoxOperand(KeyIndex); }\
  MMapObjectDelete* mir() const { return mir_->toMapObjectDelete(); };\
};\
class LMapObjectSet : public LInstructionHelper<0, 1 + 2 * BOX_PIECES, 0> {\
 public:\
  LIR_HEADER(MapObjectSet)\
  static constexpr size_t MapObjectIndex = 0;\
  static constexpr size_t KeyIndex = 1;\
  static constexpr size_t ValueIndex = 1 + 1 * BOX_PIECES;\
  explicit LMapObjectSet(const LAllocation& mapObject, const LBoxAllocation& key, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(MapObjectIndex, mapObject);\
    setBoxOperand(KeyIndex, key);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  LBoxAllocation key() const { return getBoxOperand(KeyIndex); }\
  LBoxAllocation value() const { return getBoxOperand(ValueIndex); }\
  MMapObjectSet* mir() const { return mir_->toMapObjectSet(); };\
};\
class LMapObjectSize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(MapObjectSize)\
  static constexpr size_t MapObjectIndex = 0;\
  explicit LMapObjectSize(const LAllocation& mapObject) : LInstructionHelper(classOpcode) {\
    setOperand(MapObjectIndex, mapObject);\
  }\
  const LAllocation* mapObject() const { return getOperand(MapObjectIndex); }\
  MMapObjectSize* mir() const { return mir_->toMapObjectSize(); };\
};\
class LWeakMapGetObject : public LInstructionHelper<BOX_PIECES, 2, 7> {\
 public:\
  LIR_HEADER(WeakMapGetObject)\
  static constexpr size_t WeakMapIndex = 0;\
  static constexpr size_t ObjectIndex = 1;\
  explicit LWeakMapGetObject(const LAllocation& weakMap, const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3, const LDefinition& temp4, const LDefinition& temp5, const LDefinition& temp6) : LInstructionHelper(classOpcode) {\
    setOperand(WeakMapIndex, weakMap);\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
    setTemp(4, temp4);\
    setTemp(5, temp5);\
    setTemp(6, temp6);\
  }\
  const LAllocation* weakMap() const { return getOperand(WeakMapIndex); }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  const LDefinition* temp4() { return getTemp(4); }\
  const LDefinition* temp5() { return getTemp(5); }\
  const LDefinition* temp6() { return getTemp(6); }\
  MWeakMapGetObject* mir() const { return mir_->toWeakMapGetObject(); };\
};\
class LWeakMapHasObject : public LInstructionHelper<1, 2, 7> {\
 public:\
  LIR_HEADER(WeakMapHasObject)\
  static constexpr size_t WeakMapIndex = 0;\
  static constexpr size_t ObjectIndex = 1;\
  explicit LWeakMapHasObject(const LAllocation& weakMap, const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3, const LDefinition& temp4, const LDefinition& temp5, const LDefinition& temp6) : LInstructionHelper(classOpcode) {\
    setOperand(WeakMapIndex, weakMap);\
    setOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
    setTemp(4, temp4);\
    setTemp(5, temp5);\
    setTemp(6, temp6);\
  }\
  const LAllocation* weakMap() const { return getOperand(WeakMapIndex); }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  const LDefinition* temp4() { return getTemp(4); }\
  const LDefinition* temp5() { return getTemp(5); }\
  const LDefinition* temp6() { return getTemp(6); }\
  MWeakMapHasObject* mir() const { return mir_->toWeakMapHasObject(); };\
};\
class LWeakSetHasObject : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WeakSetHasObject)\
  static constexpr size_t WeakSetIndex = 0;\
  static constexpr size_t ObjectIndex = 1;\
  explicit LWeakSetHasObject(const LAllocation& weakSet, const LAllocation& object) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(WeakSetIndex, weakSet);\
    setOperand(ObjectIndex, object);\
  }\
  const LAllocation* weakSet() const { return getOperand(WeakSetIndex); }\
  const LAllocation* object() const { return getOperand(ObjectIndex); }\
  MWeakSetHasObject* mir() const { return mir_->toWeakSetHasObject(); };\
};\
class LDateFillLocalTimeSlots : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(DateFillLocalTimeSlots)\
  static constexpr size_t DateIndex = 0;\
  explicit LDateFillLocalTimeSlots(const LAllocation& date, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(DateIndex, date);\
    setTemp(0, temp0);\
  }\
  const LAllocation* date() const { return getOperand(DateIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MDateFillLocalTimeSlots* mir() const { return mir_->toDateFillLocalTimeSlots(); };\
};\
class LDateHoursFromSecondsIntoYear : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(DateHoursFromSecondsIntoYear)\
  static constexpr size_t SecondsIntoYearIndex = 0;\
  explicit LDateHoursFromSecondsIntoYear(const LBoxAllocation& secondsIntoYear, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(SecondsIntoYearIndex, secondsIntoYear);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation secondsIntoYear() const { return getBoxOperand(SecondsIntoYearIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MDateHoursFromSecondsIntoYear* mir() const { return mir_->toDateHoursFromSecondsIntoYear(); };\
};\
class LDateMinutesFromSecondsIntoYear : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(DateMinutesFromSecondsIntoYear)\
  static constexpr size_t SecondsIntoYearIndex = 0;\
  explicit LDateMinutesFromSecondsIntoYear(const LBoxAllocation& secondsIntoYear, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(SecondsIntoYearIndex, secondsIntoYear);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation secondsIntoYear() const { return getBoxOperand(SecondsIntoYearIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MDateMinutesFromSecondsIntoYear* mir() const { return mir_->toDateMinutesFromSecondsIntoYear(); };\
};\
class LDateSecondsFromSecondsIntoYear : public LInstructionHelper<BOX_PIECES, 0 + 1 * BOX_PIECES, 2> {\
 public:\
  LIR_HEADER(DateSecondsFromSecondsIntoYear)\
  static constexpr size_t SecondsIntoYearIndex = 0;\
  explicit LDateSecondsFromSecondsIntoYear(const LBoxAllocation& secondsIntoYear, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(SecondsIntoYearIndex, secondsIntoYear);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  LBoxAllocation secondsIntoYear() const { return getBoxOperand(SecondsIntoYearIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MDateSecondsFromSecondsIntoYear* mir() const { return mir_->toDateSecondsFromSecondsIntoYear(); };\
};\
class LWasmBoundsCheckRange32 : public LInstructionHelper<1, 3, 1> {\
 public:\
  LIR_HEADER(WasmBoundsCheckRange32)\
  static constexpr size_t IndexIndex = 0;\
  static constexpr size_t LengthIndex = 1;\
  static constexpr size_t LimitIndex = 2;\
  explicit LWasmBoundsCheckRange32(const LAllocation& index, const LAllocation& length, const LAllocation& limit, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(IndexIndex, index);\
    setOperand(LengthIndex, length);\
    setOperand(LimitIndex, limit);\
    setTemp(0, temp0);\
  }\
  const LAllocation* index() const { return getOperand(IndexIndex); }\
  const LAllocation* length() const { return getOperand(LengthIndex); }\
  const LAllocation* limit() const { return getOperand(LimitIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmBoundsCheckRange32* mir() const { return mir_->toWasmBoundsCheckRange32(); };\
};\
class LWasmClampTable64Address : public LInstructionHelper<1, 0 + 1 * INT64_PIECES, 0> {\
 public:\
  LIR_HEADER(WasmClampTable64Address)\
  static constexpr size_t AddressIndex = 0;\
  explicit LWasmClampTable64Address(const LInt64Allocation& address) : LInstructionHelper(classOpcode) {\
    setInt64Operand(AddressIndex, address);\
  }\
  LInt64Allocation address() const { return getInt64Operand(AddressIndex); }\
  MWasmClampTable64Address* mir() const { return mir_->toWasmClampTable64Address(); };\
};\
class LWasmFence : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(WasmFence)\
  explicit LWasmFence() : LInstructionHelper(classOpcode) {\
  }\
  MWasmFence* mir() const { return mir_->toWasmFence(); };\
};\
class LWasmCallLandingPrePad : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(WasmCallLandingPrePad)\
  explicit LWasmCallLandingPrePad() : LInstructionHelper(classOpcode) {\
  }\
  MWasmCallLandingPrePad* mir() const { return mir_->toWasmCallLandingPrePad(); };\
};\
class LWasmUnarySimd128 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(WasmUnarySimd128)\
  static constexpr size_t SrcIndex = 0;\
  explicit LWasmUnarySimd128(const LAllocation& src, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(SrcIndex, src);\
    setTemp(0, temp0);\
  }\
  const LAllocation* src() const { return getOperand(SrcIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmUnarySimd128* mir() const { return mir_->toWasmUnarySimd128(); };\
};\
class LTakeDisposeCapability : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(TakeDisposeCapability)\
  static constexpr size_t EnvironmentIndex = 0;\
  explicit LTakeDisposeCapability(const LAllocation& environment) : LInstructionHelper(classOpcode) {\
    setOperand(EnvironmentIndex, environment);\
  }\
  const LAllocation* environment() const { return getOperand(EnvironmentIndex); }\
  MTakeDisposeCapability* mir() const { return mir_->toTakeDisposeCapability(); };\
};



#endif // jit_LIROpsGenerated_h
