function GetMethod(V, P) {
  ;;
  var func = V[P];
  if (IsNullOrUndefined(func)) {
    return undefined;
  }
  if (!IsCallable(func)) {
    ThrowTypeError(12, typeof func);
  }
  return func;
}
function IsPropertyKey(argument) {
  var type = typeof argument;
  return type === "string" || type === "symbol";
}
function SpeciesConstructor(obj, defaultConstructor) {
  ;;
  var ctor = obj.constructor;
  if (ctor === undefined) {
    return defaultConstructor;
  }
  if (!IsObject(ctor)) {
    ThrowTypeError(56, "object's 'constructor' property");
  }
  var s = ctor[GetBuiltinSymbol("species")];
  if (IsNullOrUndefined(s)) {
    return defaultConstructor;
  }
  if (IsConstructor(s)) {
    return s;
  }
  ThrowTypeError(
    14,
    "@@species property of object's constructor"
  );
}
function GetTypeError(...args) {
  try {
    callFunction(std_Function_apply, ThrowTypeError, undefined, args);
  } catch (e) {
    return e;
  }
  ;;
}
function GetAggregateError(...args) {
  try {
    callFunction(std_Function_apply, ThrowAggregateError, undefined, args);
  } catch (e) {
    return e;
  }
  ;;
}
function GetInternalError(...args) {
  try {
    callFunction(std_Function_apply, ThrowInternalError, undefined, args);
  } catch (e) {
    return e;
  }
  ;;
}
function NullFunction() {}
function CopyDataProperties(target, source, excludedItems) {
  ;;
  ;;
  if (IsNullOrUndefined(source)) {
    return;
  }
  var from = ToObject(source);
  var keys = CopyDataPropertiesOrGetOwnKeys(target, from, excludedItems);
  if (keys === null) {
    return;
  }
  for (var index = 0; index < keys.length; index++) {
    var key = keys[index];
    if (
      !hasOwn(key, excludedItems) &&
      callFunction(std_Object_propertyIsEnumerable, from, key)
    ) {
      DefineDataProperty(target, key, from[key]);
    }
  }
}
function CopyDataPropertiesUnfiltered(target, source) {
  ;;
  if (IsNullOrUndefined(source)) {
    return;
  }
  var from = ToObject(source);
  var keys = CopyDataPropertiesOrGetOwnKeys(target, from, null);
  if (keys === null) {
    return;
  }
  for (var index = 0; index < keys.length; index++) {
    var key = keys[index];
    if (callFunction(std_Object_propertyIsEnumerable, from, key)) {
      DefineDataProperty(target, key, from[key]);
    }
  }
}
function outer() {
  return function inner() {
    return "foo";
  };
}
function ArrayEvery(callbackfn ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.every");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    if (k in O) {
      if (!callContentFunction(callbackfn, T, O[k], k, O)) {
        return false;
      }
    }
  }
  return true;
}
SetIsInlinableLargeFunction(ArrayEvery);
function ArraySome(callbackfn ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.some");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    if (k in O) {
      if (callContentFunction(callbackfn, T, O[k], k, O)) {
        return true;
      }
    }
  }
  return false;
}
SetIsInlinableLargeFunction(ArraySome);
function ArrayForEach(callbackfn ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.forEach");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    if (k in O) {
      callContentFunction(callbackfn, T, O[k], k, O);
    }
  }
  return undefined;
}
SetIsInlinableLargeFunction(ArrayForEach);
function ArrayMap(callbackfn ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.map");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var A = CanOptimizeArraySpecies(O) ? std_Array(len) : ArraySpeciesCreate(O, len);
  for (var k = 0; k < len; k++) {
    if (k in O) {
      var mappedValue = callContentFunction(callbackfn, T, O[k], k, O);
      DefineDataProperty(A, k, mappedValue);
    }
  }
  return A;
}
SetIsInlinableLargeFunction(ArrayMap);
function ArrayFilter(callbackfn ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.filter");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var A = CanOptimizeArraySpecies(O) ? [] : ArraySpeciesCreate(O, 0);
  for (var k = 0, to = 0; k < len; k++) {
    if (k in O) {
      var kValue = O[k];
      if (callContentFunction(callbackfn, T, kValue, k, O)) {
        DefineDataProperty(A, to++, kValue);
      }
    }
  }
  return A;
}
SetIsInlinableLargeFunction(ArrayFilter);
function ArrayReduce(callbackfn ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.reduce");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var k = 0;
  var accumulator;
  if (ArgumentsLength() > 1) {
    accumulator = GetArgument(1);
  } else {
    if (len === 0) {
      throw ThrowTypeError(52);
    }
    var kPresent = false;
    do {
      if (k in O) {
        kPresent = true;
        break;
      }
    } while (++k < len);
    if (!kPresent) {
      throw ThrowTypeError(52);
    }
    accumulator = O[k++];
  }
  for (; k < len; k++) {
    if (k in O) {
      accumulator = callContentFunction(
        callbackfn,
        undefined,
        accumulator,
        O[k],
        k,
        O
      );
    }
  }
  return accumulator;
}
function ArrayReduceRight(callbackfn ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.reduce");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var k = len - 1;
  var accumulator;
  if (ArgumentsLength() > 1) {
    accumulator = GetArgument(1);
  } else {
    if (len === 0) {
      throw ThrowTypeError(52);
    }
    var kPresent = false;
    do {
      if (k in O) {
        kPresent = true;
        break;
      }
    } while (--k >= 0);
    if (!kPresent) {
      throw ThrowTypeError(52);
    }
    accumulator = O[k--];
  }
  for (; k >= 0; k--) {
    if (k in O) {
      accumulator = callContentFunction(
        callbackfn,
        undefined,
        accumulator,
        O[k],
        k,
        O
      );
    }
  }
  return accumulator;
}
function ArrayFind(predicate ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.find");
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    var kValue = O[k];
    if (callContentFunction(predicate, T, kValue, k, O)) {
      return kValue;
    }
  }
  return undefined;
}
SetIsInlinableLargeFunction(ArrayFind);
function ArrayFindIndex(predicate ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.find");
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    if (callContentFunction(predicate, T, O[k], k, O)) {
      return k;
    }
  }
  return -1;
}
SetIsInlinableLargeFunction(ArrayFindIndex);
function ArrayCopyWithin(target, start, end = undefined) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  var relativeTarget = ToInteger(target);
  var to =
    relativeTarget < 0
      ? std_Math_max(len + relativeTarget, 0)
      : std_Math_min(relativeTarget, len);
  var relativeStart = ToInteger(start);
  var from =
    relativeStart < 0
      ? std_Math_max(len + relativeStart, 0)
      : std_Math_min(relativeStart, len);
  var relativeEnd = end === undefined ? len : ToInteger(end);
  var final =
    relativeEnd < 0
      ? std_Math_max(len + relativeEnd, 0)
      : std_Math_min(relativeEnd, len);
  var count = std_Math_min(final - from, len - to);
  if (from < to && to < from + count) {
    from = from + count - 1;
    to = to + count - 1;
    while (count > 0) {
      if (from in O) {
        O[to] = O[from];
      } else {
        delete O[to];
      }
      from--;
      to--;
      count--;
    }
  } else {
    while (count > 0) {
      if (from in O) {
        O[to] = O[from];
      } else {
        delete O[to];
      }
      from++;
      to++;
      count--;
    }
  }
  return O;
}
function ArrayFill(value, start = 0, end = undefined) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  var relativeStart = ToInteger(start);
  var k =
    relativeStart < 0
      ? std_Math_max(len + relativeStart, 0)
      : std_Math_min(relativeStart, len);
  var relativeEnd = end === undefined ? len : ToInteger(end);
  var final =
    relativeEnd < 0
      ? std_Math_max(len + relativeEnd, 0)
      : std_Math_min(relativeEnd, len);
  for (; k < final; k++) {
    O[k] = value;
  }
  return O;
}
function ArrayIteratorNext() {
  var obj = this;
  if (!IsObject(obj) || (obj = GuardToArrayIterator(obj)) === null) {
    return callFunction(
      CallArrayIteratorMethodIfWrapped,
      this,
      "ArrayIteratorNext"
    );
  }
  var a = UnsafeGetReservedSlot(obj, 0);
  var result = { value: undefined, done: false };
  if (a === null) {
    result.done = true;
    return result;
  }
  var index = UnsafeGetReservedSlot(obj, 1);
  var itemKind = UnsafeGetInt32FromReservedSlot(obj, 2);
  var len;
  if (IsPossiblyWrappedTypedArray(a)) {
    len = PossiblyWrappedTypedArrayLength(a);
    if (len === 0) {
      if (PossiblyWrappedTypedArrayHasDetachedBuffer(a)) {
        ThrowTypeError(598);
      }
    }
  } else {
    len = ToLength(a.length);
  }
  if (index >= len) {
    UnsafeSetReservedSlot(obj, 0, null);
    result.done = true;
    return result;
  }
  UnsafeSetReservedSlot(obj, 1, index + 1);
  if (itemKind === 1) {
    result.value = a[index];
    return result;
  }
  if (itemKind === 2) {
    var pair = [index, a[index]];
    result.value = pair;
    return result;
  }
  ;;
  result.value = index;
  return result;
}
SetIsInlinableLargeFunction(ArrayIteratorNext);
function $ArrayValues() {
  var iteratedObject = ToObject(this); var iterator = NewArrayIterator(); UnsafeSetReservedSlot(iterator, 0, iteratedObject); UnsafeSetReservedSlot(iterator, 1, 0); UnsafeSetReservedSlot(iterator, 2, 1); return iterator;
}
SetCanonicalName($ArrayValues, "values");
function ArrayEntries() {
  var iteratedObject = ToObject(this); var iterator = NewArrayIterator(); UnsafeSetReservedSlot(iterator, 0, iteratedObject); UnsafeSetReservedSlot(iterator, 1, 0); UnsafeSetReservedSlot(iterator, 2, 2); return iterator;
}
function ArrayKeys() {
  var iteratedObject = ToObject(this); var iterator = NewArrayIterator(); UnsafeSetReservedSlot(iterator, 0, iteratedObject); UnsafeSetReservedSlot(iterator, 1, 0); UnsafeSetReservedSlot(iterator, 2, 0); return iterator;
}
function ArrayFromAsync(asyncItems, mapfn = undefined, thisArg = undefined) {
  var C = this;
  var fromAsyncClosure = async () => {
    var mapping = mapfn !== undefined;
    if (mapping && !IsCallable(mapfn)) {
      ThrowTypeError(12, ToSource(mapfn));
    }
    var usingAsyncIterator = asyncItems[GetBuiltinSymbol("asyncIterator")];
    if (usingAsyncIterator === null) {
      usingAsyncIterator = undefined;
    }
    var usingSyncIterator = undefined;
    if (usingAsyncIterator !== undefined) {
      if (!IsCallable(usingAsyncIterator)) {
        ThrowTypeError(71, ToSource(asyncItems));
      }
    } else {
      usingSyncIterator = asyncItems[GetBuiltinSymbol("iterator")];
      if (usingSyncIterator === null) {
        usingSyncIterator = undefined;
      }
      if (usingSyncIterator !== undefined) {
        if (!IsCallable(usingSyncIterator)) {
          ThrowTypeError(71, ToSource(asyncItems));
        }
      }
    }
    if (usingAsyncIterator !== undefined || usingSyncIterator !== undefined) {
      var A = IsConstructor(C) ? constructContentFunction(C, C) : [];
      var k = 0;
      for await (var nextValue of allowContentIterWith(
        asyncItems,
        usingAsyncIterator,
        usingSyncIterator
      )) {
        var mappedValue = nextValue;
        if (mapping) {
          mappedValue = callContentFunction(mapfn, thisArg, nextValue, k);
          mappedValue = await mappedValue;
        }
        DefineDataProperty(A, k, mappedValue);
        k = k + 1;
      }
      A.length = k;
      return A;
    }
    var arrayLike = ToObject(asyncItems);
    var len = ToLength(arrayLike.length);
    var A = IsConstructor(C) ? constructContentFunction(C, C, len) : std_Array(len);
    var k = 0;
    while (k < len) {
      var kValue = await arrayLike[k];
      var mappedValue = mapping
        ? await callContentFunction(mapfn, thisArg, kValue, k)
        : kValue;
      DefineDataProperty(A, k, mappedValue);
      k = k + 1;
    }
    A.length = len;
    return A;
  };
  return fromAsyncClosure();
}
function ArrayFrom(items, mapfn = undefined, thisArg = undefined) {
  var C = this;
  var mapping = mapfn !== undefined;
  if (mapping && !IsCallable(mapfn)) {
    ThrowTypeError(12, DecompileArg(1, mapfn));
  }
  var T = thisArg;
  var usingIterator = items[GetBuiltinSymbol("iterator")];
  if (!IsNullOrUndefined(usingIterator)) {
    if (!IsCallable(usingIterator)) {
      ThrowTypeError(71, DecompileArg(0, items));
    }
    var A = IsConstructor(C) ? constructContentFunction(C, C) : [];
    var k = 0;
    for (var nextValue of allowContentIterWith(items, usingIterator)) {
      var mappedValue = mapping
        ? callContentFunction(mapfn, T, nextValue, k)
        : nextValue;
      DefineDataProperty(A, k++, mappedValue);
    }
    A.length = k;
    return A;
  }
  var arrayLike = ToObject(items);
  var len = ToLength(arrayLike.length);
  var A = IsConstructor(C)
    ? constructContentFunction(C, C, len)
    : std_Array(len);
  for (var k = 0; k < len; k++) {
    var kValue = items[k];
    var mappedValue = mapping
      ? callContentFunction(mapfn, T, kValue, k)
      : kValue;
    DefineDataProperty(A, k, mappedValue);
  }
  A.length = len;
  return A;
}
function ArrayToString() {
  var array = ToObject(this);
  var func = array.join;
  if (!IsCallable(func)) {
    return callFunction(std_Object_toString, array);
  }
  return callContentFunction(func, array);
}
function ArrayToLocaleString(locales, options) {
  ;;
  var array = this;
  var len = ToLength(array.length);
  if (len === 0) {
    return "";
  }
  var firstElement = array[0];
  var R;
  if (IsNullOrUndefined(firstElement)) {
    R = "";
  } else {
    R = ToString(
      callContentFunction(
        firstElement.toLocaleString,
        firstElement,
        locales,
        options
      )
    );
  }
  var separator = ",";
  for (var k = 1; k < len; k++) {
    var nextElement = array[k];
    R += separator;
    if (!IsNullOrUndefined(nextElement)) {
      R += ToString(
        callContentFunction(
          nextElement.toLocaleString,
          nextElement,
          locales,
          options
        )
      );
    }
  }
  return R;
}
function $ArraySpecies() {
  return this;
}
SetCanonicalName($ArraySpecies, "get [Symbol.species]");
function ArraySpeciesCreate(originalArray, length) {
  ;;
  ;;
  if (length === -0) {
    length = 0;
  }
  if (!IsArray(originalArray)) {
    return std_Array(length);
  }
  var originalConstructor = originalArray.constructor;
  var C = originalConstructor;
  if (IsConstructor(C) && IsCrossRealmArrayConstructor(C)) {
    return std_Array(length);
  }
  if (IsObject(C)) {
    C = C[GetBuiltinSymbol("species")];
    if (C === GetBuiltinConstructor("Array")) {
      return std_Array(length);
    }
    if (C === null) {
      return std_Array(length);
    }
  }
  if (C === undefined) {
    return std_Array(length);
  }
  if (!IsConstructor(C)) {
    ThrowTypeError(14, "constructor property");
  }
  return constructContentFunction(C, C, length);
}
function ArrayFlatMap(mapperFunction ) {
  var O = ToObject(this);
  var sourceLen = ToLength(O.length);
  if (!IsCallable(mapperFunction)) {
    ThrowTypeError(12, DecompileArg(0, mapperFunction));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var A = CanOptimizeArraySpecies(O) ? [] : ArraySpeciesCreate(O, 0);
  FlattenIntoArray(A, O, sourceLen, 0, 1, mapperFunction, T);
  return A;
}
function ArrayFlat( ) {
  var O = ToObject(this);
  var sourceLen = ToLength(O.length);
  var depthNum = 1;
  if (ArgumentsLength() && GetArgument(0) !== undefined) {
    depthNum = ToInteger(GetArgument(0));
  }
  var A = CanOptimizeArraySpecies(O) ? [] : ArraySpeciesCreate(O, 0);
  FlattenIntoArray(A, O, sourceLen, 0, depthNum);
  return A;
}
function FlattenIntoArray(
  target,
  source,
  sourceLen,
  start,
  depth,
  mapperFunction,
  thisArg
) {
  var targetIndex = start;
  for (var sourceIndex = 0; sourceIndex < sourceLen; sourceIndex++) {
    if (sourceIndex in source) {
      var element = source[sourceIndex];
      if (mapperFunction) {
        ;;
        element = callContentFunction(
          mapperFunction,
          thisArg,
          element,
          sourceIndex,
          source
        );
      }
      var shouldFlatten = false;
      if (depth > 0) {
        shouldFlatten = IsArray(element);
      }
      if (shouldFlatten) {
        var elementLen = ToLength(element.length);
        targetIndex = FlattenIntoArray(
          target,
          element,
          elementLen,
          targetIndex,
          depth - 1
        );
      } else {
        if (targetIndex >= 0x1fffffffffffff) {
          ThrowTypeError(591);
        }
        DefineDataProperty(target, targetIndex, element);
        targetIndex++;
      }
    }
  }
  return targetIndex;
}
function ArrayAt(index) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  var relativeIndex = ToInteger(index);
  var k;
  if (relativeIndex >= 0) {
    k = relativeIndex;
  } else {
    k = len + relativeIndex;
  }
  if (k < 0 || k >= len) {
    return undefined;
  }
  return O[k];
}
SetIsInlinableLargeFunction(ArrayAt);
function ArrayToReversed() {
  var O = ToObject(this);
  var len = ToLength(O.length);
  var A = std_Array(len);
  for (var k = 0; k < len; k++) {
    var from = len - k - 1;
    var fromValue = O[from];
    DefineDataProperty(A, k, fromValue);
  }
  return A;
}
function ArrayToSorted(comparefn) {
  if (comparefn !== undefined && !IsCallable(comparefn)) {
    ThrowTypeError(7);
  }
  var O = ToObject(this);
  var len = ToLength(O.length);
  var items = std_Array(len);
  for (var k = 0; k < len; k++) {
    DefineDataProperty(items, k, O[k]);
  }
  if (len <= 1) {
    return items;
  }
  return callFunction(std_Array_sort, items, comparefn);
}
function ArrayFindLast(predicate ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.findLast");
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = len - 1; k >= 0; k--) {
    var kValue = O[k];
    if (callContentFunction(predicate, thisArg, kValue, k, O)) {
      return kValue;
    }
  }
  return undefined;
}
SetIsInlinableLargeFunction(ArrayFindLast);
function ArrayFindLastIndex(predicate ) {
  var O = ToObject(this);
  var len = ToLength(O.length);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "Array.prototype.findLastIndex");
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = len - 1; k >= 0; k--) {
    if (callContentFunction(predicate, thisArg, O[k], k, O)) {
      return k;
    }
  }
  return -1;
}
SetIsInlinableLargeFunction(ArrayFindLastIndex);
function AsyncFunctionNext(val) {
  ;
   ;
  return resumeGenerator(this, val, "next");
}
function AsyncFunctionThrow(val) {
  ;
   ;
  return resumeGenerator(this, val, "throw");
}
function AsyncIteratorIdentity() {
  return this;
}
function AsyncGeneratorNext(val) {
  ;
   ;
  return resumeGenerator(this, val, "next");
}
function AsyncGeneratorThrow(val) {
  ;
   ;
  return resumeGenerator(this, val, "throw");
}
function AsyncGeneratorReturn(val) {
  ;
   ;
  return resumeGenerator(this, val, "return");
}
async function AsyncIteratorClose(iteratorRecord, value) {
  var iterator = iteratorRecord.iterator;
  var returnMethod = iterator.return;
  if (!IsNullOrUndefined(returnMethod)) {
    var result = await callContentFunction(returnMethod, iterator);
    if (!IsObject(result)) {
      ThrowTypeError(56, DecompileArg(0, result));
    }
  }
  return value;
}
function GetIteratorDirect(obj) {
  if (!IsObject(obj)) {
    ThrowTypeError(56, DecompileArg(0, obj));
  }
  var nextMethod = obj.next;
  if (!IsCallable(nextMethod)) {
    ThrowTypeError(12, DecompileArg(0, nextMethod));
  }
  return {
    iterator: obj,
    nextMethod,
    done: false,
  };
}
function GetAsyncIteratorDirectWrapper(obj) {
  if (!IsObject(obj)) {
    ThrowTypeError(56, obj);
  }
  var nextMethod = obj.next;
  if (!IsCallable(nextMethod)) {
    ThrowTypeError(12, nextMethod);
  }
  return {
    [GetBuiltinSymbol("asyncIterator")]: function AsyncIteratorMethod() {
      return this;
    },
    next(value) {
      return callContentFunction(nextMethod, obj, value);
    },
    async return(value) {
      var returnMethod = obj.return;
      if (!IsNullOrUndefined(returnMethod)) {
        return callContentFunction(returnMethod, obj, value);
      }
      return { done: true, value };
    },
  };
}
function AsyncIteratorHelperNext(value) {
  var O = this;
  if (!IsObject(O) || (O = GuardToAsyncIteratorHelper(O)) === null) {
    return callFunction(
      CallAsyncIteratorHelperMethodIfWrapped,
      this,
      value,
      "AsyncIteratorHelperNext"
    );
  }
  var generator = UnsafeGetReservedSlot(
    O,
    0
  );
  return callFunction(IntrinsicAsyncGeneratorNext, generator, value);
}
function AsyncIteratorHelperReturn(value) {
  var O = this;
  if (!IsObject(O) || (O = GuardToAsyncIteratorHelper(O)) === null) {
    return callFunction(
      CallAsyncIteratorHelperMethodIfWrapped,
      this,
      value,
      "AsyncIteratorHelperReturn"
    );
  }
  var generator = UnsafeGetReservedSlot(
    O,
    0
  );
  return callFunction(IntrinsicAsyncGeneratorReturn, generator, value);
}
function AsyncIteratorHelperThrow(value) {
  var O = this;
  if (!IsObject(O) || (O = GuardToAsyncIteratorHelper(O)) === null) {
    return callFunction(
      CallAsyncIteratorHelperMethodIfWrapped,
      this,
      value,
      "AsyncIteratorHelperThrow"
    );
  }
  var generator = UnsafeGetReservedSlot(
    O,
    0
  );
  return callFunction(IntrinsicAsyncGeneratorThrow, generator, value);
}
function AsyncIteratorMap(mapper) {
  var iterated = GetIteratorDirect(this);
  if (!IsCallable(mapper)) {
    ThrowTypeError(12, DecompileArg(0, mapper));
  }
  var iteratorHelper = NewAsyncIteratorHelper();
  var generator = AsyncIteratorMapGenerator(iterated, mapper);
  callFunction(IntrinsicAsyncGeneratorNext, generator);
  UnsafeSetReservedSlot(
    iteratorHelper,
    0,
    generator
  );
  return iteratorHelper;
}
async function* AsyncIteratorMapGenerator(iterated, mapper) {
  var lastValue;
  var needClose = true;
  try {
    yield;
    needClose = false;
    for (
      var next = await IteratorNext(iterated, lastValue);
      !next.done;
      next = await IteratorNext(iterated, lastValue)
    ) {
      var value = next.value;
      needClose = true;
      lastValue = yield callContentFunction(mapper, undefined, value);
      needClose = false;
    }
  } finally {
    if (needClose) {
      AsyncIteratorClose(iterated);
    }
  }
}
function AsyncIteratorFilter(filterer) {
  var iterated = GetIteratorDirect(this);
  if (!IsCallable(filterer)) {
    ThrowTypeError(12, DecompileArg(0, filterer));
  }
  var iteratorHelper = NewAsyncIteratorHelper();
  var generator = AsyncIteratorFilterGenerator(iterated, filterer);
  callFunction(IntrinsicAsyncGeneratorNext, generator);
  UnsafeSetReservedSlot(
    iteratorHelper,
    0,
    generator
  );
  return iteratorHelper;
}
async function* AsyncIteratorFilterGenerator(iterated, filterer) {
  var lastValue;
  var needClose = true;
  try {
    yield;
    needClose = false;
    for (
      var next = await IteratorNext(iterated, lastValue);
      !next.done;
      next = await IteratorNext(iterated, lastValue)
    ) {
      var value = next.value;
      needClose = true;
      if (await callContentFunction(filterer, undefined, value)) {
        lastValue = yield value;
      }
      needClose = false;
    }
  } finally {
    if (needClose) {
      AsyncIteratorClose(iterated);
    }
  }
}
function AsyncIteratorTake(limit) {
  var iterated = GetIteratorDirect(this);
  var remaining = ToInteger(limit);
  if (remaining < 0) {
    ThrowRangeError(696);
  }
  var iteratorHelper = NewAsyncIteratorHelper();
  var generator = AsyncIteratorTakeGenerator(iterated, remaining);
  callFunction(IntrinsicAsyncGeneratorNext, generator);
  UnsafeSetReservedSlot(
    iteratorHelper,
    0,
    generator
  );
  return iteratorHelper;
}
async function* AsyncIteratorTakeGenerator(iterated, remaining) {
  var lastValue;
  var needClose = true;
  try {
    yield;
    needClose = false;
    for (; remaining > 0; remaining--) {
      var next = await IteratorNext(iterated, lastValue);
      if (next.done) {
        return undefined;
      }
      var value = next.value;
      needClose = true;
      lastValue = yield value;
      needClose = false;
    }
  } finally {
    if (needClose) {
      AsyncIteratorClose(iterated, undefined);
    }
  }
  return AsyncIteratorClose(iterated, undefined);
}
function AsyncIteratorDrop(limit) {
  var iterated = GetIteratorDirect(this);
  var remaining = ToInteger(limit);
  if (remaining < 0) {
    ThrowRangeError(696);
  }
  var iteratorHelper = NewAsyncIteratorHelper();
  var generator = AsyncIteratorDropGenerator(iterated, remaining);
  callFunction(IntrinsicAsyncGeneratorNext, generator);
  UnsafeSetReservedSlot(
    iteratorHelper,
    0,
    generator
  );
  return iteratorHelper;
}
async function* AsyncIteratorDropGenerator(iterated, remaining) {
  var needClose = true;
  try {
    yield;
    needClose = false;
    for (; remaining > 0; remaining--) {
      var next = await IteratorNext(iterated);
      if (next.done) {
        return;
      }
    }
    var lastValue;
    for (
      var next = await IteratorNext(iterated, lastValue);
      !next.done;
      next = await IteratorNext(iterated, lastValue)
    ) {
      var value = next.value;
      needClose = true;
      lastValue = yield value;
      needClose = false;
    }
  } finally {
    if (needClose) {
      AsyncIteratorClose(iterated);
    }
  }
}
function AsyncIteratorAsIndexedPairs() {
  var iterated = GetIteratorDirect(this);
  var iteratorHelper = NewAsyncIteratorHelper();
  var generator = AsyncIteratorAsIndexedPairsGenerator(iterated);
  callFunction(IntrinsicAsyncGeneratorNext, generator);
  UnsafeSetReservedSlot(
    iteratorHelper,
    0,
    generator
  );
  return iteratorHelper;
}
async function* AsyncIteratorAsIndexedPairsGenerator(iterated) {
  var needClose = true;
  try {
    yield;
    needClose = false;
    var lastValue;
    for (
      var next = await IteratorNext(iterated, lastValue), index = 0;
      !next.done;
      next = await IteratorNext(iterated, lastValue), index++
    ) {
      var value = next.value;
      needClose = true;
      lastValue = yield [index, value];
      needClose = false;
    }
  } finally {
    if (needClose) {
      AsyncIteratorClose(iterated);
    }
  }
}
function AsyncIteratorFlatMap(mapper) {
  var iterated = GetIteratorDirect(this);
  if (!IsCallable(mapper)) {
    ThrowTypeError(12, DecompileArg(0, mapper));
  }
  var iteratorHelper = NewAsyncIteratorHelper();
  var generator = AsyncIteratorFlatMapGenerator(iterated, mapper);
  callFunction(IntrinsicAsyncGeneratorNext, generator);
  UnsafeSetReservedSlot(
    iteratorHelper,
    0,
    generator
  );
  return iteratorHelper;
}
async function* AsyncIteratorFlatMapGenerator(iterated, mapper) {
  var needClose = true;
  try {
    yield;
    needClose = false;
    for (
      var next = await IteratorNext(iterated);
      !next.done;
      next = await IteratorNext(iterated)
    ) {
      var value = next.value;
      needClose = true;
      var mapped = await callContentFunction(mapper, undefined, value);
      for await (var innerValue of allowContentIter(mapped)) {
        yield innerValue;
      }
      needClose = false;
    }
  } finally {
    if (needClose) {
      AsyncIteratorClose(iterated);
    }
  }
}
async function AsyncIteratorReduce(reducer ) {
  var iterated = GetAsyncIteratorDirectWrapper(this);
  if (!IsCallable(reducer)) {
    ThrowTypeError(12, DecompileArg(0, reducer));
  }
  var accumulator;
  if (ArgumentsLength() === 1) {
    var next = await callContentFunction(iterated.next, iterated);
    if (!IsObject(next)) {
      ThrowTypeError(56, DecompileArg(0, next));
    }
    if (next.done) {
      ThrowTypeError(53);
    }
    accumulator = next.value;
  } else {
    accumulator = GetArgument(1);
  }
  for await (var value of allowContentIter(iterated)) {
    accumulator = await callContentFunction(
      reducer,
      undefined,
      accumulator,
      value
    );
  }
  return accumulator;
}
async function AsyncIteratorToArray() {
  var iterated = { [GetBuiltinSymbol("asyncIterator")]: () => this };
  var items = [];
  var index = 0;
  for await (var value of allowContentIter(iterated)) {
    DefineDataProperty(items, index++, value);
  }
  return items;
}
async function AsyncIteratorForEach(fn) {
  var iterated = GetAsyncIteratorDirectWrapper(this);
  if (!IsCallable(fn)) {
    ThrowTypeError(12, DecompileArg(0, fn));
  }
  for await (var value of allowContentIter(iterated)) {
    await callContentFunction(fn, undefined, value);
  }
}
async function AsyncIteratorSome(fn) {
  var iterated = GetAsyncIteratorDirectWrapper(this);
  if (!IsCallable(fn)) {
    ThrowTypeError(12, DecompileArg(0, fn));
  }
  for await (var value of allowContentIter(iterated)) {
    if (await callContentFunction(fn, undefined, value)) {
      return true;
    }
  }
  return false;
}
async function AsyncIteratorEvery(fn) {
  var iterated = GetAsyncIteratorDirectWrapper(this);
  if (!IsCallable(fn)) {
    ThrowTypeError(12, DecompileArg(0, fn));
  }
  for await (var value of allowContentIter(iterated)) {
    if (!(await callContentFunction(fn, undefined, value))) {
      return false;
    }
  }
  return true;
}
async function AsyncIteratorFind(fn) {
  var iterated = GetAsyncIteratorDirectWrapper(this);
  if (!IsCallable(fn)) {
    ThrowTypeError(12, DecompileArg(0, fn));
  }
  for await (var value of allowContentIter(iterated)) {
    if (await callContentFunction(fn, undefined, value)) {
      return value;
    }
  }
}
function ErrorToString() {
  var obj = this;
  if (!IsObject(obj)) {
    ThrowTypeError(3, "Error", "toString", "value");
  }
  var name = obj.name;
  name = name === undefined ? "Error" : ToString(name);
  var msg = obj.message;
  msg = msg === undefined ? "" : ToString(msg);
  if (name === "") {
    return msg;
  }
  if (msg === "") {
    return name;
  }
  return name + ": " + msg;
}
function ErrorToStringWithTrailingNewline() {
  return callFunction(std_Function_apply, ErrorToString, this, []) + "\n";
}
function GeneratorNext(val) {
  if (!IsSuspendedGenerator(this)) {
    if (!IsObject(this) || !IsGeneratorObject(this)) {
      return callFunction(
        CallGeneratorMethodIfWrapped,
        this,
        val,
        "GeneratorNext"
      );
    }
    if (GeneratorObjectIsClosed(this)) {
      return { value: undefined, done: true };
    }
    if (GeneratorIsRunning(this)) {
      ThrowTypeError(46);
    }
  }
  try {
    return resumeGenerator(this, val, "next");
  } catch (e) {
    if (!GeneratorObjectIsClosed(this)) {
      GeneratorSetClosed(this);
    }
    throw e;
  }
}
function GeneratorThrow(val) {
  if (!IsSuspendedGenerator(this)) {
    if (!IsObject(this) || !IsGeneratorObject(this)) {
      return callFunction(
        CallGeneratorMethodIfWrapped,
        this,
        val,
        "GeneratorThrow"
      );
    }
    if (GeneratorObjectIsClosed(this)) {
      throw val;
    }
    if (GeneratorIsRunning(this)) {
      ThrowTypeError(46);
    }
  }
  try {
    return resumeGenerator(this, val, "throw");
  } catch (e) {
    if (!GeneratorObjectIsClosed(this)) {
      GeneratorSetClosed(this);
    }
    throw e;
  }
}
function GeneratorReturn(val) {
  if (!IsSuspendedGenerator(this)) {
    if (!IsObject(this) || !IsGeneratorObject(this)) {
      return callFunction(
        CallGeneratorMethodIfWrapped,
        this,
        val,
        "GeneratorReturn"
      );
    }
    if (GeneratorObjectIsClosed(this)) {
      return { value: val, done: true };
    }
    if (GeneratorIsRunning(this)) {
      ThrowTypeError(46);
    }
  }
  try {
    var rval = { value: val, done: true };
    return resumeGenerator(this, rval, "return");
  } catch (e) {
    if (!GeneratorObjectIsClosed(this)) {
      GeneratorSetClosed(this);
    }
    throw e;
  }
}
function InterpretGeneratorResume(gen, val, kind) {
  forceInterpreter();
  if (kind === "next") {
    return resumeGenerator(gen, val, "next");
  }
  if (kind === "throw") {
    return resumeGenerator(gen, val, "throw");
  }
  ;;
  return resumeGenerator(gen, val, "return");
}
function IteratorIdentity() {
  return this;
}
function IteratorNext(iteratorRecord, value) {
  var result =
    ArgumentsLength() < 2
      ? callContentFunction(iteratorRecord.nextMethod, iteratorRecord.iterator)
      : callContentFunction(
        iteratorRecord.nextMethod,
        iteratorRecord.iterator,
        value
      );
  if (!IsObject(result)) {
    ThrowTypeError(56, result);
  }
  return result;
}
function GetIterator(obj, isAsync, method) {
  if (!method) {
    if (isAsync) {
      method = GetMethod(obj, GetBuiltinSymbol("asyncIterator"));
      if (!method) {
        var syncMethod = GetMethod(obj, GetBuiltinSymbol("iterator"));
        var syncIteratorRecord = GetIterator(obj, false, syncMethod);
        return CreateAsyncFromSyncIterator(syncIteratorRecord.iterator, syncIteratorRecord.nextMethod);
      }
    } else {
      method = GetMethod(obj, GetBuiltinSymbol("iterator"));
    }
  }
  var iterator = callContentFunction(method, obj);
  if (!IsObject(iterator)) {
    ThrowTypeError(71, obj === null ? "null" : typeof obj);
  }
  var nextMethod = iterator.next;
  var iteratorRecord = {
    __proto__: null,
    iterator,
    nextMethod,
    done: false,
  };
  return iteratorRecord;
}
function GetIteratorFlattenable(obj, rejectStrings) {
  ;;
  if (!IsObject(obj)) {
    if (rejectStrings || typeof obj !== "string") {
      ThrowTypeError(56, obj === null ? "null" : typeof obj);
    }
  }
  var method = obj[GetBuiltinSymbol("iterator")];
  var iterator;
  if (IsNullOrUndefined(method)) {
    iterator = obj;
  } else {
    iterator = callContentFunction(method, obj);
  }
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  return iterator;
}
function IteratorFrom(O) {
  var iterator = GetIteratorFlattenable(O, false);
  var nextMethod = iterator.next;
  var hasInstance = callFunction(
    std_Object_isPrototypeOf,
    GetBuiltinPrototype("Iterator"),
    iterator
  );
  if (hasInstance) {
    return iterator;
  }
  var wrapper = NewWrapForValidIterator();
  UnsafeSetReservedSlot(
    wrapper,
    0,
    iterator
  );
  UnsafeSetReservedSlot(
    wrapper,
    1,
    nextMethod
  );
  return wrapper;
}
function WrapForValidIteratorNext() {
  var O = this;
  if (!IsObject(O) || (O = GuardToWrapForValidIterator(O)) === null) {
    return callFunction(
      CallWrapForValidIteratorMethodIfWrapped,
      this,
      "WrapForValidIteratorNext"
    );
  }
  var iterator = UnsafeGetReservedSlot(O, 0);
  var nextMethod = UnsafeGetReservedSlot(O, 1);
  return callContentFunction(nextMethod, iterator);
}
function WrapForValidIteratorReturn() {
  var O = this;
  if (!IsObject(O) || (O = GuardToWrapForValidIterator(O)) === null) {
    return callFunction(
      CallWrapForValidIteratorMethodIfWrapped,
      this,
      "WrapForValidIteratorReturn"
    );
  }
  var iterator = UnsafeGetReservedSlot(O, 0);
  ;;
  var returnMethod = iterator.return;
  if (IsNullOrUndefined(returnMethod)) {
    return {
      value: undefined,
      done: true,
    };
  }
  return callContentFunction(returnMethod, iterator);
}
function IteratorDispose() {
  var O = this;
  var returnMethod = GetMethod(O, "return");
  if (returnMethod !== undefined) {
    callContentFunction(returnMethod, O);
  }
}
function IteratorHelperNext() {
  var O = this;
  if (!IsObject(O) || (O = GuardToIteratorHelper(O)) === null) {
    return callFunction(
      CallIteratorHelperMethodIfWrapped,
      this,
      "IteratorHelperNext"
    );
  }
  var generator = UnsafeGetReservedSlot(O, 0);
  return callFunction(GeneratorNext, generator, undefined);
}
function IteratorHelperReturn() {
  var O = this;
  if (!IsObject(O) || (O = GuardToIteratorHelper(O)) === null) {
    return callFunction(
      CallIteratorHelperMethodIfWrapped,
      this,
      "IteratorHelperReturn"
    );
  }
  var generator = UnsafeGetReservedSlot(O, 0);
  var resumeIndex = UnsafeGetReservedSlot(generator, 4);
  ;
   ;
  var isSuspendedStart = resumeIndex === 0;
  ;
   ;
  var result = callFunction(GeneratorReturn, generator, undefined);
  if (isSuspendedStart) {
    var underlyingIterator = UnsafeGetReservedSlot(O, 1);
    ;
     ;
    if (IsObject(underlyingIterator)) {
      IteratorClose(underlyingIterator);
    }
  }
  return result;
}
function IteratorMap(mapper) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(mapper)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, mapper));
  }
  var nextMethod = iterator.next;
  var result = NewIteratorHelper();
  var generator = IteratorMapGenerator(iterator, nextMethod, mapper);
  UnsafeSetReservedSlot(
    result,
    0,
    generator
  );
  UnsafeSetReservedSlot(
    result,
    1,
    iterator
  );
  return result;
}
function* IteratorMapGenerator(iterator, nextMethod, mapper) {
  var counter = 0;
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    var mapped = callContentFunction(mapper, undefined, value, counter);
    yield mapped;
    counter += 1;
  }
}
function IteratorFilter(predicate) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(predicate)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var nextMethod = iterator.next;
  var result = NewIteratorHelper();
  var generator = IteratorFilterGenerator(iterator, nextMethod, predicate);
  UnsafeSetReservedSlot(
    result,
    0,
    generator
  );
  UnsafeSetReservedSlot(
    result,
    1,
    iterator
  );
  return result;
}
function* IteratorFilterGenerator(iterator, nextMethod, predicate) {
  var counter = 0;
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    var selected = callContentFunction(predicate, undefined, value, counter);
    if (selected) {
      yield value;
    }
    counter += 1;
  }
}
function IteratorTake(limit) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  var numLimit;
  try {
    numLimit = +limit;
  } catch (e) {
    try {
      IteratorClose(iterator);
    } catch {}
    throw e;
  }
  var integerLimit = std_Math_trunc(numLimit);
  if (!(integerLimit >= 0)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowRangeError(696);
  }
  var nextMethod = iterator.next;
  var result = NewIteratorHelper();
  var generator = IteratorTakeGenerator(iterator, nextMethod, integerLimit);
  UnsafeSetReservedSlot(
    result,
    0,
    generator
  );
  UnsafeSetReservedSlot(
    result,
    1,
    iterator
  );
  return result;
}
function* IteratorTakeGenerator(iterator, nextMethod, remaining) {
  if (remaining === 0) {
    IteratorClose(iterator);
    return;
  }
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    yield value;
    if (--remaining === 0) {
      break;
    }
  }
}
function IteratorDrop(limit) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  var numLimit;
  try {
    numLimit = +limit;
  } catch (e) {
    try {
      IteratorClose(iterator);
    } catch {}
    throw e;
  }
  var integerLimit = std_Math_trunc(numLimit);
  if (!(integerLimit >= 0)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowRangeError(696);
  }
  var nextMethod = iterator.next;
  var result = NewIteratorHelper();
  var generator = IteratorDropGenerator(iterator, nextMethod, integerLimit);
  UnsafeSetReservedSlot(
    result,
    0,
    generator
  );
  UnsafeSetReservedSlot(
    result,
    1,
    iterator
  );
  return result;
}
function* IteratorDropGenerator(iterator, nextMethod, remaining) {
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    if (remaining-- <= 0) {
      yield value;
    }
  }
}
function IteratorFlatMap(mapper) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(mapper)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, mapper));
  }
  var nextMethod = iterator.next;
  var result = NewIteratorHelper();
  var generator = IteratorFlatMapGenerator(iterator, nextMethod, mapper);
  UnsafeSetReservedSlot(
    result,
    0,
    generator
  );
  UnsafeSetReservedSlot(
    result,
    1,
    iterator
  );
  return result;
}
function* IteratorFlatMapGenerator(iterator, nextMethod, mapper) {
  var counter = 0;
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    var mapped = callContentFunction(mapper, undefined, value, counter);
    var innerIterator = GetIteratorFlattenable(mapped, true);
    var innerIteratorNextMethod = innerIterator.next;
    for (var innerValue of allowContentIterWithNext(innerIterator, innerIteratorNextMethod)) {
      yield innerValue;
    }
    counter += 1;
  }
}
function IteratorReduce(reducer ) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(reducer)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, reducer));
  }
  var nextMethod = iterator.next;
  var accumulator;
  var counter;
  if (ArgumentsLength() === 1) {
    counter = -1;
  } else {
    accumulator = GetArgument(1);
    counter = 0;
  }
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    if (counter < 0) {
      accumulator = value;
      counter = 1;
    } else {
      accumulator = callContentFunction(reducer, undefined, accumulator, value, counter++);
    }
  }
  if (counter < 0) {
    ThrowTypeError(53);
  }
  return accumulator;
}
function IteratorToArray() {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  var nextMethod = iterator.next;
  return [...allowContentIterWithNext(iterator, nextMethod)];
}
function IteratorForEach(fn) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(fn)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, fn));
  }
  var nextMethod = iterator.next;
  var counter = 0;
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    callContentFunction(fn, undefined, value, counter++);
  }
}
function IteratorSome(predicate) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(predicate)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var nextMethod = iterator.next;
  var counter = 0;
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    if (callContentFunction(predicate, undefined, value, counter++)) {
      return true;
    }
  }
  return false;
}
function IteratorEvery(predicate) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(predicate)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var nextMethod = iterator.next;
  var counter = 0;
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    if (!callContentFunction(predicate, undefined, value, counter++)) {
      return false;
    }
  }
  return true;
}
function IteratorFind(predicate) {
  var iterator = this;
  if (!IsObject(iterator)) {
    ThrowTypeError(56, iterator === null ? "null" : typeof iterator);
  }
  if (!IsCallable(predicate)) {
    try {
      IteratorClose(iterator);
    } catch {}
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var nextMethod = iterator.next;
  var counter = 0;
  for (var value of allowContentIterWithNext(iterator, nextMethod)) {
    if (callContentFunction(predicate, undefined, value, counter++)) {
      return value;
    }
  }
}
function IteratorConcat() {
  var index = ArgumentsLength() * 2;
  var iterables = std_Array(index);
  for (var i = 0; i < ArgumentsLength(); i++) {
    var item = GetArgument(i);
    if (!IsObject(item)) {
      ThrowTypeError(56, typeof item);
    }
    var method = item[GetBuiltinSymbol("iterator")];
    if (!IsCallable(method)) {
      ThrowTypeError(71, ToSource(item));
    }
    DefineDataProperty(iterables, --index, item);
    DefineDataProperty(iterables, --index, method);
  }
  ;;
  var result = NewIteratorHelper();
  var generator = IteratorConcatGenerator(iterables);
  UnsafeSetReservedSlot(
    result,
    0,
    generator
  );
  return result;
}
function* IteratorConcatGenerator(iterables) {
  ;;
  ;;
  for (var i = iterables.length; i > 0;) {
    var item = iterables[--i];
    var method = iterables[--i];
    iterables.length -= 2;
    for (var innerValue of allowContentIterWith(item, method)) {
      yield innerValue;
    }
  }
}
function MapConstructorInit(iterable) {
  var map = this;
  var adder = map.set;
  if (!IsCallable(adder)) {
    ThrowTypeError(12, typeof adder);
  }
  for (var nextItem of allowContentIter(iterable)) {
    if (!IsObject(nextItem)) {
      ThrowTypeError(45, "Map");
    }
    callContentFunction(adder, map, nextItem[0], nextItem[1]);
  }
}
function MapForEach(callbackfn, thisArg = undefined) {
  var M = this;
  if (!IsObject(M) || (M = GuardToMapObject(M)) === null) {
    return callFunction(
      CallMapMethodIfWrapped,
      this,
      callbackfn,
      thisArg,
      "MapForEach"
    );
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var entries = callFunction(std_Map_entries, M);
  var mapIterationResultPair = globalMapIterationResultPair;
  while (true) {
    var done = GetNextMapEntryForIterator(entries, mapIterationResultPair);
    if (done) {
      break;
    }
    var key = mapIterationResultPair[0];
    var value = mapIterationResultPair[1];
    mapIterationResultPair[0] = null;
    mapIterationResultPair[1] = null;
    callContentFunction(callbackfn, thisArg, value, key, M);
  }
}
var globalMapIterationResultPair = CreateMapIterationResultPair();
function MapIteratorNext() {
  var O = this;
  if (!IsObject(O) || (O = GuardToMapIterator(O)) === null) {
    return callFunction(
      CallMapIteratorMethodIfWrapped,
      this,
      "MapIteratorNext"
    );
  }
  var mapIterationResultPair = globalMapIterationResultPair;
  var retVal = { value: undefined, done: true };
  var done = GetNextMapEntryForIterator(O, mapIterationResultPair);
  if (!done) {
    var itemKind = UnsafeGetInt32FromReservedSlot(O, 1);
    var result;
    if (itemKind === 0) {
      result = mapIterationResultPair[0];
    } else if (itemKind === 1) {
      result = mapIterationResultPair[1];
    } else {
      ;;
      result = [mapIterationResultPair[0], mapIterationResultPair[1]];
    }
    mapIterationResultPair[0] = null;
    mapIterationResultPair[1] = null;
    retVal.value = result;
    retVal.done = false;
  }
  return retVal;
}
function $MapSpecies() {
  return this;
}
SetCanonicalName($MapSpecies, "get [Symbol.species]");
function MapGroupBy(items, callbackfn) {
  if (IsNullOrUndefined(items)) {
    ThrowTypeError(
      54,
      DecompileArg(0, items),
      items === null ? "null" : "undefined"
    );
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(1, callbackfn));
  }
  var C = GetBuiltinConstructor("Map");
  var map = new C();
  var k = 0;
  for (var value of allowContentIter(items)) {
    ;;
    var key = callContentFunction(callbackfn, undefined, value, k);
    var elements = callFunction(std_Map_get, map, key);
    if (elements === undefined) {
      callFunction(std_Map_set, map, key, [value]);
    } else {
      DefineDataProperty(elements, elements.length, value);
    }
    k += 1;
  }
  return map;
}
function MapGetOrInsertComputed(key, callbackfn) {
  var M = this;
  if (!IsObject(M) || (M = GuardToMapObject(M)) === null) {
    return callFunction(
      CallMapMethodIfWrapped,
      this,
      key,
      callbackfn,
      "MapGetOrInsertComputed"
    );
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(1, callbackfn));
  }
  if (key === 0) {
    key = 0;
  }
  if (callFunction(std_Map_has, M, key)) {
    return callFunction(std_Map_get, M, key);
  }
  var value = callContentFunction(callbackfn, undefined, key);
  callFunction(std_Map_set, M, key, value);
  return value;
}
function Number_isFinite(num) {
  if (typeof num !== "number") {
    return false;
  }
  return num - num === 0;
}
function Number_isNaN(num) {
  if (typeof num !== "number") {
    return false;
  }
  return num !== num;
}
function Number_isInteger(number) {
  if (typeof number !== "number") {
    return false;
  }
  var integer = std_Math_trunc(number);
  return number - integer === 0;
}
function Number_isSafeInteger(number) {
  if (typeof number !== "number") {
    return false;
  }
  var integer = std_Math_trunc(number);
  if (number - integer !== 0) {
    return false;
  }
  return -((2 ** 53) - 1) <= integer && integer <= (2 ** 53) - 1;
}
function Global_isNaN(number) {
  return Number_isNaN(+number);
}
function Global_isFinite(number) {
  return Number_isFinite(+number);
}
function ObjectGetOwnPropertyDescriptors(O) {
  var obj = ToObject(O);
  var keys = std_Reflect_ownKeys(obj);
  var descriptors = {};
  for (var index = 0, len = keys.length; index < len; index++) {
    var key = keys[index];
    var desc = ObjectGetOwnPropertyDescriptor(obj, key);
    if (typeof desc !== "undefined") {
      DefineDataProperty(descriptors, key, desc);
    }
  }
  return descriptors;
}
function ObjectGetPrototypeOf(obj) {
  return std_Reflect_getPrototypeOf(ToObject(obj));
}
function ObjectIsExtensible(obj) {
  return IsObject(obj) && std_Reflect_isExtensible(obj);
}
function Object_toLocaleString() {
  var O = this;
  return callContentFunction(O.toString, O);
}
function Object_valueOf() {
  return ToObject(this);
}
function Object_hasOwnProperty(V) {
  return hasOwn(V, this);
}
function $ObjectProtoGetter() {
  return std_Reflect_getPrototypeOf(ToObject(this));
}
SetCanonicalName($ObjectProtoGetter, "get __proto__");
function $ObjectProtoSetter(proto) {
  return callFunction(std_Object_setProto, this, proto);
}
SetCanonicalName($ObjectProtoSetter, "set __proto__");
function ObjectDefineSetter(name, setter) {
  var object = ToObject(this);
  if (!IsCallable(setter)) {
    ThrowTypeError(33, "setter");
  }
  var key = (typeof name !== "string" && typeof name !== "number" && typeof name !== "symbol" ? ToPropertyKey(name) : name);
  DefineProperty(
    object,
    key,
    0x200 | 0x01 | 0x02,
    null,
    setter,
    true
  );
}
function ObjectDefineGetter(name, getter) {
  var object = ToObject(this);
  if (!IsCallable(getter)) {
    ThrowTypeError(33, "getter");
  }
  var key = (typeof name !== "string" && typeof name !== "number" && typeof name !== "symbol" ? ToPropertyKey(name) : name);
  DefineProperty(
    object,
    key,
    0x200 | 0x01 | 0x02,
    getter,
    null,
    true
  );
}
function ObjectLookupSetter(name) {
  var object = ToObject(this);
  var key = (typeof name !== "string" && typeof name !== "number" && typeof name !== "symbol" ? ToPropertyKey(name) : name);
  do {
    var desc = GetOwnPropertyDescriptorToArray(object, key);
    if (desc) {
      if (desc[0] & 0x200) {
        return desc[2];
      }
      return undefined;
    }
    object = std_Reflect_getPrototypeOf(object);
  } while (object !== null);
}
function ObjectLookupGetter(name) {
  var object = ToObject(this);
  var key = (typeof name !== "string" && typeof name !== "number" && typeof name !== "symbol" ? ToPropertyKey(name) : name);
  do {
    var desc = GetOwnPropertyDescriptorToArray(object, key);
    if (desc) {
      if (desc[0] & 0x200) {
        return desc[1];
      }
      return undefined;
    }
    object = std_Reflect_getPrototypeOf(object);
  } while (object !== null);
}
function ObjectGetOwnPropertyDescriptor(obj, propertyKey) {
  var desc = GetOwnPropertyDescriptorToArray(obj, propertyKey);
  if (!desc) {
    return undefined;
  }
  var attrsAndKind = desc[0];
  if (attrsAndKind & 0x100) {
    return {
      value: desc[1],
      writable: !!(attrsAndKind & 0x04),
      enumerable: !!(attrsAndKind & 0x01),
      configurable: !!(attrsAndKind & 0x02),
    };
  }
  ;
   ;
  return {
    get: desc[1],
    set: desc[2],
    enumerable: !!(attrsAndKind & 0x01),
    configurable: !!(attrsAndKind & 0x02),
  };
}
function ObjectOrReflectDefineProperty(obj, propertyKey, attributes, strict) {
  if (!IsObject(obj)) {
    ThrowTypeError(56, DecompileArg(0, obj));
  }
  propertyKey = (typeof propertyKey !== "string" && typeof propertyKey !== "number" && typeof propertyKey !== "symbol" ? ToPropertyKey(propertyKey) : propertyKey);
  if (!IsObject(attributes)) {
    ThrowTypeError(
      58,
      DecompileArg(2, attributes)
    );
  }
  var attrs = 0;
  var hasValue = false;
  var value;
  var getter = null;
  var setter = null;
  if ("enumerable" in attributes) {
    attrs |= attributes.enumerable ? 0x01 : 0x08;
  }
  if ("configurable" in attributes) {
    attrs |= attributes.configurable ? 0x02 : 0x10;
  }
  if ("value" in attributes) {
    attrs |= 0x100;
    value = attributes.value;
    hasValue = true;
  }
  if ("writable" in attributes) {
    attrs |= 0x100;
    attrs |= attributes.writable ? 0x04 : 0x20;
  }
  if ("get" in attributes) {
    attrs |= 0x200;
    getter = attributes.get;
    if (!IsCallable(getter) && getter !== undefined) {
      ThrowTypeError(68, "get");
    }
  }
  if ("set" in attributes) {
    attrs |= 0x200;
    setter = attributes.set;
    if (!IsCallable(setter) && setter !== undefined) {
      ThrowTypeError(68, "set");
    }
  }
  if (attrs & 0x200) {
    if (attrs & 0x100) {
      ThrowTypeError(62);
    }
    return DefineProperty(obj, propertyKey, attrs, getter, setter, strict);
  }
  if (hasValue) {
    if (strict) {
      if (
        (attrs & (0x01 | 0x02 | 0x04)) ===
        (0x01 | 0x02 | 0x04)
      ) {
        DefineDataProperty(obj, propertyKey, value);
        return true;
      }
    }
    return DefineProperty(obj, propertyKey, attrs, value, null, strict);
  }
  return DefineProperty(obj, propertyKey, attrs, undefined, undefined, strict);
}
function ObjectDefineProperty(obj, propertyKey, attributes) {
  if (!ObjectOrReflectDefineProperty(obj, propertyKey, attributes, true)) {
    return null;
  }
  return obj;
}
function ObjectFromEntries(iter) {
  var obj = {};
  for (var pair of allowContentIter(iter)) {
    if (!IsObject(pair)) {
      ThrowTypeError(45, "Object.fromEntries");
    }
    DefineDataProperty(obj, pair[0], pair[1]);
  }
  return obj;
}
function ObjectHasOwn(O, P) {
  var obj = ToObject(O);
  return hasOwn(P, obj);
}
function ObjectGroupBy(items, callbackfn) {
  if (IsNullOrUndefined(items)) {
    ThrowTypeError(
      54,
      DecompileArg(0, items),
      items === null ? "null" : "undefined"
    );
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(1, callbackfn));
  }
  var obj = std_Object_create(null);
  var k = 0;
  for (var value of allowContentIter(items)) {
    ;;
    var key = callContentFunction(callbackfn, undefined, value, k);
    key = (typeof key !== "string" && typeof key !== "number" && typeof key !== "symbol" ? ToPropertyKey(key) : key);
    var elements = obj[key];
    if (elements === undefined) {
      DefineDataProperty(obj, key, [value]);
    } else {
      DefineDataProperty(elements, elements.length, value);
    }
    k += 1;
  }
  return obj;
}
function Promise_finally(onFinally) {
  var promise = this;
  if (!IsObject(promise)) {
    ThrowTypeError(3, "Promise", "finally", "value");
  }
  var C = SpeciesConstructor(promise, GetBuiltinConstructor("Promise"));
  ;;
  var thenFinally, catchFinally;
  if (!IsCallable(onFinally)) {
    thenFinally = onFinally;
    catchFinally = onFinally;
  } else {
    (thenFinally) = function(value) {
      var result = callContentFunction(onFinally, undefined);
      var promise = PromiseResolve(C, result);
      return callContentFunction(promise.then, promise, function() {
        return value;
      });
    };
    (catchFinally) = function(reason) {
      var result = callContentFunction(onFinally, undefined);
      var promise = PromiseResolve(C, result);
      return callContentFunction(promise.then, promise, function() {
        throw reason;
      });
    };
  }
  return callContentFunction(promise.then, promise, thenFinally, catchFinally);
}
function CreateListFromArrayLikeForArgs(obj) {
  ;
   ;
  var len = ToLength(obj.length);
  if (len > (500 * 1000)) {
    ThrowRangeError(119);
  }
  var list = std_Array(len);
  for (var i = 0; i < len; i++) {
    DefineDataProperty(list, i, obj[i]);
  }
  return list;
}
function Reflect_apply(target, thisArgument, argumentsList) {
  if (!IsCallable(target)) {
    ThrowTypeError(12, DecompileArg(0, target));
  }
  if (!IsObject(argumentsList)) {
    ThrowTypeError(
      57,
      "`argumentsList`",
      "Reflect.apply",
      ToSource(argumentsList)
    );
  }
  return callFunction(std_Function_apply, target, thisArgument, argumentsList);
}
SetIsInlinableLargeFunction(Reflect_apply);
function Reflect_construct(target, argumentsList ) {
  if (!IsConstructor(target)) {
    ThrowTypeError(14, DecompileArg(0, target));
  }
  var newTarget;
  if (ArgumentsLength() > 2) {
    newTarget = GetArgument(2);
    if (!IsConstructor(newTarget)) {
      ThrowTypeError(14, DecompileArg(2, newTarget));
    }
  } else {
    newTarget = target;
  }
  if (!IsObject(argumentsList)) {
    ThrowTypeError(
      57,
      "`argumentsList`",
      "Reflect.construct",
      ToSource(argumentsList)
    );
  }
  var args =
    IsPackedArray(argumentsList) && argumentsList.length <= (500 * 1000)
      ? argumentsList
      : CreateListFromArrayLikeForArgs(argumentsList);
  switch (args.length) {
    case 0:
      return constructContentFunction(target, newTarget);
    case 1:
      return constructContentFunction(target, newTarget, args[0]);
    case 2:
      return constructContentFunction(target, newTarget, args[0], args[1]);
    case 3:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2]);
    case 4:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3]);
    case 5:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4]);
    case 6:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4], args[5]);
    case 7:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
    case 8:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
    case 9:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
    case 10:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
    case 11:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10]);
    case 12:
      return constructContentFunction(target, newTarget, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11]);
    default:
      return ConstructFunction(target, newTarget, args);
  }
}
function Reflect_defineProperty(obj, propertyKey, attributes) {
  return ObjectOrReflectDefineProperty(obj, propertyKey, attributes, false);
}
function Reflect_getOwnPropertyDescriptor(target, propertyKey) {
  if (!IsObject(target)) {
    ThrowTypeError(56, DecompileArg(0, target));
  }
  return ObjectGetOwnPropertyDescriptor(target, propertyKey);
}
function Reflect_has(target, propertyKey) {
  if (!IsObject(target)) {
    ThrowTypeError(
      57,
      "`target`",
      "Reflect.has",
      ToSource(target)
    );
  }
  return propertyKey in target;
}
function Reflect_get(target, propertyKey ) {
  if (!IsObject(target)) {
    ThrowTypeError(
      57,
      "`target`",
      "Reflect.get",
      ToSource(target)
    );
  }
  if (ArgumentsLength() > 2) {
    return getPropertySuper(target, propertyKey, GetArgument(2));
  }
  return target[propertyKey];
}
function $RegExpFlagsGetter() {
  var R = this;
  if (!IsObject(R)) {
    ThrowTypeError(56, R === null ? "null" : typeof R);
  }
  var result = "";
  if (R.hasIndices) {
    result += "d";
  }
  if (R.global) {
    result += "g";
  }
  if (R.ignoreCase) {
    result += "i";
  }
  if (R.multiline) {
    result += "m";
  }
  if (R.dotAll) {
    result += "s";
  }
  if (R.unicode) {
    result += "u";
  }
  if (R.unicodeSets) {
    result += "v";
  }
  if (R.sticky) {
    result += "y";
  }
  return result;
}
SetCanonicalName($RegExpFlagsGetter, "get flags");
function $RegExpToString() {
  var R = this;
  if (!IsObject(R)) {
    ThrowTypeError(56, R === null ? "null" : typeof R);
  }
  var pattern = ToString(R.source);
  var flags = ToString(R.flags);
  return "/" + pattern + "/" + flags;
}
SetCanonicalName($RegExpToString, "toString");
function AdvanceStringIndex(S, index) {
  ;;
  ;
   ;
  var supplementary = (
    index < S.length &&
    callFunction(std_String_codePointAt, S, index) > 0xffff
  );
  return index + 1 + supplementary;
}
function RegExpMatch(string) {
  var rx = this;
  if (!IsObject(rx)) {
    ThrowTypeError(56, rx === null ? "null" : typeof rx);
  }
  var S = ToString(string);
  if (IsOptimizableRegExpObject(rx)) {
    var flags = UnsafeGetInt32FromReservedSlot(rx, 2);
    var global = !!(flags & 0x02);
    if (global) {
      var fullUnicode = !!(flags & 0x10) || !!(flags & 0x80);
      return RegExpGlobalMatchOpt(rx, S, fullUnicode);
    }
    return RegExpBuiltinExec(rx, S);
  }
  return RegExpMatchSlowPath(rx, S);
}
function RegExpMatchSlowPath(rx, S) {
  var flags = ToString(rx.flags);
  if (!callFunction(std_String_includes, flags, "g")) {
    return RegExpExec(rx, S);
  }
  var fullUnicode = callFunction(std_String_includes, flags, "u") || callFunction(std_String_includes, flags, "v");
  rx.lastIndex = 0;
  var A = [];
  var n = 0;
  while (true) {
    var result = RegExpExec(rx, S);
    if (result === null) {
      return n === 0 ? null : A;
    }
    var matchStr = ToString(result[0]);
    DefineDataProperty(A, n, matchStr);
    if (matchStr === "") {
      var lastIndex = ToLength(rx.lastIndex);
      rx.lastIndex = fullUnicode
        ? AdvanceStringIndex(S, lastIndex)
        : lastIndex + 1;
    }
    n++;
  }
}
function RegExpGlobalMatchOpt(rx, S, fullUnicode) {
  var lastIndex = 0;
  rx.lastIndex = 0;
  var A = [];
  var n = 0;
  var lengthS = S.length;
  while (true) {
    var position = RegExpSearcher(rx, S, lastIndex);
    if (position === -1) {
      return n === 0 ? null : A;
    }
    lastIndex = RegExpSearcherLastLimit(S);
    var matchStr = Substring(S, position, lastIndex - position);
    DefineDataProperty(A, n, matchStr);
    if (matchStr === "") {
      lastIndex = fullUnicode
        ? AdvanceStringIndex(S, lastIndex)
        : lastIndex + 1;
      if (lastIndex > lengthS) {
        return A;
      }
    }
    n++;
  }
}
function RegExpReplace(string, replaceValue) {
  var rx = this;
  if (!IsObject(rx)) {
    ThrowTypeError(56, rx === null ? "null" : typeof rx);
  }
  var S = ToString(string);
  var lengthS = S.length;
  var functionalReplace = IsCallable(replaceValue);
  var firstDollarIndex = -1;
  if (!functionalReplace) {
    replaceValue = ToString(replaceValue);
    if (replaceValue.length > 1) {
      firstDollarIndex = GetFirstDollarIndex(replaceValue);
    }
  }
  if (IsOptimizableRegExpObject(rx)) {
    var flags = UnsafeGetInt32FromReservedSlot(rx, 2);
    var global = !!(flags & 0x02);
    if (global) {
      if (functionalReplace) {
        if (lengthS > 5000) {
          var elemBase = GetElemBaseForLambda(replaceValue);
          if (IsObject(elemBase)) {
            return RegExpGlobalReplaceOptElemBase(
              rx,
              S,
              lengthS,
              replaceValue,
              flags,
              elemBase
            );
          }
        }
        return RegExpGlobalReplaceOptFunc(rx, S, lengthS, replaceValue, flags);
      }
      if (firstDollarIndex !== -1) {
        return RegExpGlobalReplaceOptSubst(
          rx,
          S,
          lengthS,
          replaceValue,
          flags,
          firstDollarIndex
        );
      }
      return RegExpGlobalReplaceOptSimple(rx, S, lengthS, replaceValue, flags);
    }
    if (functionalReplace) {
      return RegExpLocalReplaceOptFunc(rx, S, lengthS, replaceValue);
    }
    if (firstDollarIndex !== -1) {
      return RegExpLocalReplaceOptSubst(
        rx,
        S,
        lengthS,
        replaceValue,
        firstDollarIndex
      );
    }
    return RegExpLocalReplaceOptSimple(rx, S, lengthS, replaceValue);
  }
  return RegExpReplaceSlowPath(
    rx,
    S,
    lengthS,
    replaceValue,
    functionalReplace,
    firstDollarIndex
  );
}
function RegExpReplaceSlowPath(
  rx,
  S,
  lengthS,
  replaceValue,
  functionalReplace,
  firstDollarIndex
) {
  var flags = ToString(rx.flags);
  var global = callFunction(std_String_includes, flags, "g");
  var fullUnicode = false;
  if (global) {
    fullUnicode = callFunction(std_String_includes, flags, "u") || callFunction(std_String_includes, flags, "v");
    rx.lastIndex = 0;
  }
  var results = new_List();
  var nResults = 0;
  while (true) {
    var result = RegExpExec(rx, S);
    if (result === null) {
      break;
    }
    DefineDataProperty(results, nResults++, result);
    if (!global) {
      break;
    }
    var matchStr = ToString(result[0]);
    if (matchStr === "") {
      var lastIndex = ToLength(rx.lastIndex);
      rx.lastIndex = fullUnicode
        ? AdvanceStringIndex(S, lastIndex)
        : lastIndex + 1;
    }
  }
  var accumulatedResult = "";
  var nextSourcePosition = 0;
  for (var i = 0; i < nResults; i++) {
    result = results[i];
    var nCaptures = std_Math_max(ToLength(result.length) - 1, 0);
    var matched = ToString(result[0]);
    var matchLength = matched.length;
    var position = std_Math_max(
      std_Math_min(ToInteger(result.index), lengthS),
      0
    );
    var replacement;
    if (functionalReplace || firstDollarIndex !== -1) {
      replacement = RegExpGetComplexReplacement(
        result,
        matched,
        S,
        position,
        nCaptures,
        replaceValue,
        functionalReplace,
        firstDollarIndex
      );
    } else {
      for (var n = 1; n <= nCaptures; n++) {
        var capN = result[n];
        if (capN !== undefined) {
          ToString(capN);
        }
      }
      var namedCaptures = result.groups;
      if (namedCaptures !== undefined) {
        ToObject(namedCaptures);
      }
      replacement = replaceValue;
    }
    if (position >= nextSourcePosition) {
      accumulatedResult +=
        Substring(S, nextSourcePosition, position - nextSourcePosition) +
        replacement;
      nextSourcePosition = position + matchLength;
    }
  }
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpGetComplexReplacement(
  result,
  matched,
  S,
  position,
  nCaptures,
  replaceValue,
  functionalReplace,
  firstDollarIndex
) {
  var captures = new_List();
  var capturesLength = 0;
  DefineDataProperty(captures, capturesLength++, matched);
  for (var n = 1; n <= nCaptures; n++) {
    var capN = result[n];
    if (capN !== undefined) {
      capN = ToString(capN);
    }
    DefineDataProperty(captures, capturesLength++, capN);
  }
  var namedCaptures = result.groups;
  if (functionalReplace) {
    if (namedCaptures === undefined) {
      switch (nCaptures) {
        case 0:
          return ToString(
            callContentFunction(
              replaceValue,
              undefined,
              captures[0],
              position,
              S
            )
          );
        case 1:
          return ToString(
            callContentFunction(
              replaceValue,
              undefined,
              captures[0], captures[1],
              position,
              S
            )
          );
        case 2:
          return ToString(
            callContentFunction(
              replaceValue,
              undefined,
              captures[0], captures[1], captures[2],
              position,
              S
            )
          );
        case 3:
          return ToString(
            callContentFunction(
              replaceValue,
              undefined,
              captures[0], captures[1], captures[2], captures[3],
              position,
              S
            )
          );
        case 4:
          return ToString(
            callContentFunction(
              replaceValue,
              undefined,
              captures[0], captures[1], captures[2], captures[3], captures[4],
              position,
              S
            )
          );
      }
    }
    DefineDataProperty(captures, capturesLength++, position);
    DefineDataProperty(captures, capturesLength++, S);
    if (namedCaptures !== undefined) {
      DefineDataProperty(captures, capturesLength++, namedCaptures);
    }
    return ToString(
      callFunction(std_Function_apply, replaceValue, undefined, captures)
    );
  }
  if (namedCaptures !== undefined) {
    namedCaptures = ToObject(namedCaptures);
  }
  return RegExpGetSubstitution(
    captures,
    S,
    position,
    replaceValue,
    firstDollarIndex,
    namedCaptures
  );
}
function RegExpGetFunctionalReplacement(result, S, position, replaceValue) {
  ;;
  var nCaptures = result.length - 1;
  var namedCaptures = result.groups;
  if (namedCaptures === undefined) {
    switch (nCaptures) {
      case 0:
        return ToString(
          callContentFunction(
            replaceValue,
            undefined,
            result[0],
            position,
            S
          )
        );
      case 1:
        return ToString(
          callContentFunction(
            replaceValue,
            undefined,
            result[0], result[1],
            position,
            S
          )
        );
      case 2:
        return ToString(
          callContentFunction(
            replaceValue,
            undefined,
            result[0], result[1], result[2],
            position,
            S
          )
        );
      case 3:
        return ToString(
          callContentFunction(
            replaceValue,
            undefined,
            result[0], result[1], result[2], result[3],
            position,
            S
          )
        );
      case 4:
        return ToString(
          callContentFunction(
            replaceValue,
            undefined,
            result[0], result[1], result[2], result[3], result[4],
            position,
            S
          )
        );
    }
  }
  var captures = new_List();
  for (var n = 0; n <= nCaptures; n++) {
    ;
     ;
    DefineDataProperty(captures, n, result[n]);
  }
  DefineDataProperty(captures, nCaptures + 1, position);
  DefineDataProperty(captures, nCaptures + 2, S);
  if (namedCaptures !== undefined) {
    DefineDataProperty(captures, nCaptures + 3, namedCaptures);
  }
  return ToString(
    callFunction(std_Function_apply, replaceValue, undefined, captures)
  );
}
function RegExpGlobalReplaceOptSimple(rx, S, lengthS, replaceValue, flags) {
  var fullUnicode = !!(flags & 0x10) || !!(flags & 0x80);
  var lastIndex = 0;
  rx.lastIndex = 0;
  var accumulatedResult = "";
  var nextSourcePosition = 0;
  while (true) {
    var position = RegExpSearcher(rx, S, lastIndex);
    if (position === -1) {
      break;
    }
    lastIndex = RegExpSearcherLastLimit(S);
    accumulatedResult +=
      Substring(S, nextSourcePosition, position - nextSourcePosition) +
      replaceValue;
    nextSourcePosition = lastIndex;
    if (lastIndex === position) {
      lastIndex = fullUnicode
        ? AdvanceStringIndex(S, lastIndex)
        : lastIndex + 1;
      if (lastIndex > lengthS) {
        break;
      }
    }
  }
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpGlobalReplaceOptFunc(
  rx,
  S,
  lengthS,
  replaceValue,
  flags,
) {
  var fullUnicode = !!(flags & 0x10);
  var lastIndex = 0;
  rx.lastIndex = 0;
  var originalSource = UnsafeGetStringFromReservedSlot(rx, 1);
  var originalFlags = flags;
  var hasCaptureGroups = RegExpHasCaptureGroups(rx, S);
  var accumulatedResult = "";
  var nextSourcePosition = 0;
  while (true) {
    var replacement;
    var matchLength;
    if (!hasCaptureGroups) {
      var position = RegExpSearcher(rx, S, lastIndex);
      if (position === -1) {
        break;
      }
      lastIndex = RegExpSearcherLastLimit(S);
      var matched = Substring(S, position, lastIndex - position);
      matchLength = matched.length;
      replacement = ToString(
        callContentFunction(
          replaceValue,
          undefined,
          matched,
          position,
          S
        )
      );
    } else
    {
      var result = RegExpMatcher(rx, S, lastIndex);
      if (result === null) {
        break;
      }
      ;;
      var matched = result[0];
      matchLength = matched.length | 0;
      var position = result.index | 0;
      lastIndex = position + matchLength;
      replacement = RegExpGetFunctionalReplacement(
        result,
        S,
        position,
        replaceValue
      );
    }
    accumulatedResult +=
      Substring(S, nextSourcePosition, position - nextSourcePosition) +
      replacement;
    nextSourcePosition = lastIndex;
    if (matchLength === 0) {
      lastIndex = fullUnicode
        ? AdvanceStringIndex(S, lastIndex)
        : lastIndex + 1;
      if (lastIndex > lengthS) {
        break;
      }
      lastIndex |= 0;
    }
    if (
      UnsafeGetStringFromReservedSlot(rx, 1) !==
        originalSource ||
      UnsafeGetInt32FromReservedSlot(rx, 2) !== originalFlags
    ) {
      rx = RegExpConstructRaw(originalSource, originalFlags);
    }
  }
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpGlobalReplaceOptElemBase(
  rx,
  S,
  lengthS,
  replaceValue,
  flags,
  elemBase
) {
  var fullUnicode = !!(flags & 0x10);
  var lastIndex = 0;
  rx.lastIndex = 0;
  var originalSource = UnsafeGetStringFromReservedSlot(rx, 1);
  var originalFlags = flags;
  var accumulatedResult = "";
  var nextSourcePosition = 0;
  while (true) {
    var replacement;
    var matchLength;
    {
      var result = RegExpMatcher(rx, S, lastIndex);
      if (result === null) {
        break;
      }
      ;;
      var matched = result[0];
      matchLength = matched.length | 0;
      var position = result.index | 0;
      lastIndex = position + matchLength;
      if (IsObject(elemBase)) {
        var prop = GetStringDataProperty(elemBase, matched);
        if (prop !== undefined) {
          ;
           ;
          replacement = prop;
        } else {
          elemBase = undefined;
        }
      }
      if (!IsObject(elemBase)) {
        replacement = RegExpGetFunctionalReplacement(
          result,
          S,
          position,
          replaceValue
        );
      }
    }
    accumulatedResult +=
      Substring(S, nextSourcePosition, position - nextSourcePosition) +
      replacement;
    nextSourcePosition = lastIndex;
    if (matchLength === 0) {
      lastIndex = fullUnicode
        ? AdvanceStringIndex(S, lastIndex)
        : lastIndex + 1;
      if (lastIndex > lengthS) {
        break;
      }
      lastIndex |= 0;
    }
    if (
      UnsafeGetStringFromReservedSlot(rx, 1) !==
        originalSource ||
      UnsafeGetInt32FromReservedSlot(rx, 2) !== originalFlags
    ) {
      rx = RegExpConstructRaw(originalSource, originalFlags);
    }
  }
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpGlobalReplaceOptSubst(
  rx,
  S,
  lengthS,
  replaceValue,
  flags,
  firstDollarIndex,
) {
  var fullUnicode = !!(flags & 0x10);
  var lastIndex = 0;
  rx.lastIndex = 0;
  var accumulatedResult = "";
  var nextSourcePosition = 0;
  while (true) {
    var replacement;
    var matchLength;
    {
      var result = RegExpMatcher(rx, S, lastIndex);
      if (result === null) {
        break;
      }
      ;;
      var matched = result[0];
      matchLength = matched.length | 0;
      var position = result.index | 0;
      lastIndex = position + matchLength;
      var namedCaptures = result.groups;
      if (namedCaptures !== undefined) {
        namedCaptures = ToObject(namedCaptures);
      }
      replacement = RegExpGetSubstitution(
        result,
        S,
        position,
        replaceValue,
        firstDollarIndex,
        namedCaptures
      );
    }
    accumulatedResult +=
      Substring(S, nextSourcePosition, position - nextSourcePosition) +
      replacement;
    nextSourcePosition = lastIndex;
    if (matchLength === 0) {
      lastIndex = fullUnicode
        ? AdvanceStringIndex(S, lastIndex)
        : lastIndex + 1;
      if (lastIndex > lengthS) {
        break;
      }
      lastIndex |= 0;
    }
  }
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpLocalReplaceOptSimple(
  rx,
  S,
  lengthS,
  replaceValue,
) {
  var lastIndex = ToLength(rx.lastIndex);
  var flags = UnsafeGetInt32FromReservedSlot(rx, 2);
  var globalOrSticky = !!(flags & (0x02 | 0x08));
  if (globalOrSticky) {
    if (lastIndex > lengthS) {
      if (globalOrSticky) {
        rx.lastIndex = 0;
      }
      return S;
    }
  } else {
    lastIndex = 0;
  }
  var position = RegExpSearcher(rx, S, lastIndex);
  if (position === -1) {
    if (globalOrSticky) {
      rx.lastIndex = 0;
    }
    return S;
  }
  var nextSourcePosition = RegExpSearcherLastLimit(S);
  if (globalOrSticky) {
    rx.lastIndex = nextSourcePosition;
  }
  var replacement;
  replacement = replaceValue;
  var accumulatedResult = Substring(S, 0, position) + replacement;
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpLocalReplaceOptFunc(
  rx,
  S,
  lengthS,
  replaceValue,
) {
  var lastIndex = ToLength(rx.lastIndex);
  var flags = UnsafeGetInt32FromReservedSlot(rx, 2);
  var globalOrSticky = !!(flags & (0x02 | 0x08));
  if (globalOrSticky) {
    if (lastIndex > lengthS) {
      if (globalOrSticky) {
        rx.lastIndex = 0;
      }
      return S;
    }
  } else {
    lastIndex = 0;
  }
  var result = RegExpMatcher(rx, S, lastIndex);
  if (result === null) {
    if (globalOrSticky) {
      rx.lastIndex = 0;
    }
    return S;
  }
  ;;
  var matched = result[0];
  var matchLength = matched.length;
  var position = result.index;
  var nextSourcePosition = position + matchLength;
  if (globalOrSticky) {
    rx.lastIndex = nextSourcePosition;
  }
  var replacement;
  replacement = RegExpGetFunctionalReplacement(
    result,
    S,
    position,
    replaceValue
  );
  var accumulatedResult = Substring(S, 0, position) + replacement;
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpLocalReplaceOptSubst(
  rx,
  S,
  lengthS,
  replaceValue,
  firstDollarIndex
) {
  var lastIndex = ToLength(rx.lastIndex);
  var flags = UnsafeGetInt32FromReservedSlot(rx, 2);
  var globalOrSticky = !!(flags & (0x02 | 0x08));
  if (globalOrSticky) {
    if (lastIndex > lengthS) {
      if (globalOrSticky) {
        rx.lastIndex = 0;
      }
      return S;
    }
  } else {
    lastIndex = 0;
  }
  var result = RegExpMatcher(rx, S, lastIndex);
  if (result === null) {
    if (globalOrSticky) {
      rx.lastIndex = 0;
    }
    return S;
  }
  ;;
  var matched = result[0];
  var matchLength = matched.length;
  var position = result.index;
  var nextSourcePosition = position + matchLength;
  if (globalOrSticky) {
    rx.lastIndex = nextSourcePosition;
  }
  var replacement;
  var namedCaptures = result.groups;
  if (namedCaptures !== undefined) {
    namedCaptures = ToObject(namedCaptures);
  }
  replacement = RegExpGetSubstitution(
    result,
    S,
    position,
    replaceValue,
    firstDollarIndex,
    namedCaptures
  );
  var accumulatedResult = Substring(S, 0, position) + replacement;
  if (nextSourcePosition >= lengthS) {
    return accumulatedResult;
  }
  return (
    accumulatedResult +
    Substring(S, nextSourcePosition, lengthS - nextSourcePosition)
  );
}
function RegExpSearch(string) {
  var rx = this;
  if (!IsObject(rx)) {
    ThrowTypeError(56, rx === null ? "null" : typeof rx);
  }
  var S = ToString(string);
  var previousLastIndex = rx.lastIndex;
  var lastIndexIsZero = SameValue(previousLastIndex, 0);
  if (!lastIndexIsZero) {
    rx.lastIndex = 0;
  }
  if (IsOptimizableRegExpObject(rx) && S.length < 0x7fff) {
    var result = RegExpSearcher(rx, S, 0);
    if (!lastIndexIsZero) {
      rx.lastIndex = previousLastIndex;
    } else {
      var flags = UnsafeGetInt32FromReservedSlot(rx, 2);
      if (flags & (0x02 | 0x08)) {
        rx.lastIndex = previousLastIndex;
      }
    }
    return result;
  }
  return RegExpSearchSlowPath(rx, S, previousLastIndex);
}
function RegExpSearchSlowPath(rx, S, previousLastIndex) {
  var result = RegExpExec(rx, S);
  var currentLastIndex = rx.lastIndex;
  if (!SameValue(currentLastIndex, previousLastIndex)) {
    rx.lastIndex = previousLastIndex;
  }
  if (result === null) {
    return -1;
  }
  return result.index;
}
function RegExpSplit(string, limit) {
  var rx = this;
  if (!IsObject(rx)) {
    ThrowTypeError(56, rx === null ? "null" : typeof rx);
  }
  var S = ToString(string);
  var builtinCtor = GetBuiltinConstructor("RegExp");
  var C = SpeciesConstructor(rx, builtinCtor);
  var optimizable =
    IsOptimizableRegExpObject(rx) &&
    C === builtinCtor &&
    (limit === undefined || typeof limit === "number");
  var flags, unicodeMatching, splitter;
  if (optimizable) {
    flags = UnsafeGetInt32FromReservedSlot(rx, 2);
    unicodeMatching = !!(flags & 0x10);
    if (flags & 0x08) {
      var source = UnsafeGetStringFromReservedSlot(rx, 1);
      splitter = RegExpConstructRaw(source, flags & ~0x08);
    } else {
      splitter = rx;
    }
  } else {
    flags = ToString(rx.flags);
    unicodeMatching = callFunction(std_String_includes, flags, "u");
    var newFlags;
    if (callFunction(std_String_includes, flags, "y")) {
      newFlags = flags;
    } else {
      newFlags = flags + "y";
    }
    splitter = constructContentFunction(C, C, rx, newFlags);
  }
  var A = [];
  var lengthA = 0;
  var lim;
  if (limit === undefined) {
    lim = 0xffffffff;
  } else {
    lim = limit >>> 0;
  }
  var p = 0;
  if (lim === 0) {
    return A;
  }
  var size = S.length;
  if (size === 0) {
    if (optimizable) {
      if (RegExpSearcher(splitter, S, 0) !== -1) {
        return A;
      }
    } else {
      if (RegExpExec(splitter, S) !== null) {
        return A;
      }
    }
    DefineDataProperty(A, 0, S);
    return A;
  }
  var q = p;
  var optimizableNoCaptures = optimizable && !RegExpHasCaptureGroups(splitter, S);
  while (q < size) {
    var e, z;
    if (optimizableNoCaptures) {
      q = RegExpSearcher(splitter, S, q);
      if (q === -1 || q >= size) {
        break;
      }
      e = RegExpSearcherLastLimit(S);
      z = null;
    } else if (optimizable) {
      z = RegExpMatcher(splitter, S, q);
      if (z === null) {
        break;
      }
      q = z.index;
      if (q >= size) {
        break;
      }
      e = q + z[0].length;
    } else {
      splitter.lastIndex = q;
      z = RegExpExec(splitter, S);
      if (z === null) {
        q = unicodeMatching ? AdvanceStringIndex(S, q) : q + 1;
        continue;
      }
      e = ToLength(splitter.lastIndex);
    }
    if (e === p) {
      q = unicodeMatching ? AdvanceStringIndex(S, q) : q + 1;
      continue;
    }
    DefineDataProperty(A, lengthA, Substring(S, p, q - p));
    lengthA++;
    if (lengthA === lim) {
      return A;
    }
    p = e;
    if (z !== null) {
      var numberOfCaptures = std_Math_max(ToLength(z.length) - 1, 0);
      var i = 1;
      while (i <= numberOfCaptures) {
        DefineDataProperty(A, lengthA, z[i]);
        i++;
        lengthA++;
        if (lengthA === lim) {
          return A;
        }
      }
    }
    q = p;
  }
  if (p >= size) {
    DefineDataProperty(A, lengthA, "");
  } else {
    DefineDataProperty(A, lengthA, Substring(S, p, size - p));
  }
  return A;
}
function RegExp_prototype_Exec(string) {
  var R = this;
  if (!IsObject(R) || !IsRegExpObject(R)) {
    return callFunction(
      CallRegExpMethodIfWrapped,
      R,
      string,
      "RegExp_prototype_Exec"
    );
  }
  var S = ToString(string);
  return RegExpBuiltinExec(R, S);
}
function RegExpTest(string) {
  var R = this;
  if (!IsObject(R)) {
    ThrowTypeError(56, R === null ? "null" : typeof R);
  }
  var S = ToString(string);
  return RegExpExecForTest(R, S);
}
function $RegExpSpecies() {
  return this;
}
SetCanonicalName($RegExpSpecies, "get [Symbol.species]");
function RegExpMatchAll(string) {
  var rx = this;
  if (!IsObject(rx)) {
    ThrowTypeError(56, rx === null ? "null" : typeof rx);
  }
  var str = ToString(string);
  var builtinCtor = GetBuiltinConstructor("RegExp");
  var C = SpeciesConstructor(rx, builtinCtor);
  var source, flags, matcher, lastIndex;
  if (IsOptimizableRegExpObject(rx) && C === builtinCtor) {
    source = UnsafeGetStringFromReservedSlot(rx, 1);
    flags = UnsafeGetInt32FromReservedSlot(rx, 2);
    matcher = rx;
    lastIndex = ToLength(rx.lastIndex);
  } else {
    source = "";
    flags = ToString(rx.flags);
    matcher = constructContentFunction(C, C, rx, flags);
    matcher.lastIndex = ToLength(rx.lastIndex);
    flags =
      (callFunction(std_String_includes, flags, "g") ? 0x02 : 0) |
      (callFunction(std_String_includes, flags, "u") ? 0x10 : 0);
    lastIndex = -2;
  }
  return CreateRegExpStringIterator(matcher, str, source, flags, lastIndex);
}
function CreateRegExpStringIterator(regexp, string, source, flags, lastIndex) {
  ;;
  ;;
  ;;
  ;;
  var iterator = NewRegExpStringIterator();
  UnsafeSetReservedSlot(iterator, 0, regexp);
  UnsafeSetReservedSlot(iterator, 1, string);
  UnsafeSetReservedSlot(iterator, 2, source);
  UnsafeSetReservedSlot(iterator, 3, flags | 0);
  UnsafeSetReservedSlot(
    iterator,
    4,
    lastIndex
  );
  return iterator;
}
function RegExpStringIteratorNext() {
  var obj = this;
  if (!IsObject(obj) || (obj = GuardToRegExpStringIterator(obj)) === null) {
    return callFunction(
      CallRegExpStringIteratorMethodIfWrapped,
      this,
      "RegExpStringIteratorNext"
    );
  }
  var result = { value: undefined, done: false };
  var lastIndex = UnsafeGetReservedSlot(
    obj,
    4
  );
  if (lastIndex === -1) {
    result.done = true;
    return result;
  }
  var regexp = UnsafeGetObjectFromReservedSlot(
    obj,
    0
  );
  var string = UnsafeGetStringFromReservedSlot(
    obj,
    1
  );
  var flags = UnsafeGetInt32FromReservedSlot(
    obj,
    3
  );
  var global = !!(flags & 0x02);
  var fullUnicode = !!(flags & 0x10) || !!(flags & 0x80);
  if (lastIndex >= 0) {
    ;;
    var source = UnsafeGetStringFromReservedSlot(
      obj,
      2
    );
    if (
      IsRegExpPrototypeOptimizable() &&
      UnsafeGetStringFromReservedSlot(regexp, 1) === source &&
      UnsafeGetInt32FromReservedSlot(regexp, 2) === flags
    ) {
      var globalOrSticky = !!(
        flags &
        (0x02 | 0x08)
      );
      if (!globalOrSticky) {
        lastIndex = 0;
      }
      var match =
        lastIndex <= string.length
          ? RegExpMatcher(regexp, string, lastIndex)
          : null;
      if (match === null) {
        UnsafeSetReservedSlot(
          obj,
          4,
          -1
        );
        result.done = true;
        return result;
      }
      if (global) {
        var matchLength = match[0].length;
        lastIndex = match.index + matchLength;
        if (matchLength === 0) {
          lastIndex = fullUnicode
            ? AdvanceStringIndex(string, lastIndex)
            : lastIndex + 1;
        }
        UnsafeSetReservedSlot(
          obj,
          4,
          lastIndex
        );
      } else {
        UnsafeSetReservedSlot(
          obj,
          4,
          -1
        );
      }
      result.value = match;
      return result;
    }
    regexp = RegExpConstructRaw(source, flags);
    regexp.lastIndex = lastIndex;
    UnsafeSetReservedSlot(obj, 0, regexp);
    UnsafeSetReservedSlot(
      obj,
      4,
      -2
    );
  }
  var match = RegExpExec(regexp, string);
  if (match === null) {
    UnsafeSetReservedSlot(
      obj,
      4,
      -1
    );
    result.done = true;
    return result;
  }
  if (global) {
    var matchStr = ToString(match[0]);
    if (matchStr.length === 0) {
      var thisIndex = ToLength(regexp.lastIndex);
      var nextIndex = fullUnicode
        ? AdvanceStringIndex(string, thisIndex)
        : thisIndex + 1;
      regexp.lastIndex = nextIndex;
    }
  } else {
    UnsafeSetReservedSlot(
      obj,
      4,
      -1
    );
  }
  result.value = match;
  return result;
}
function IsRegExp(argument) {
  if (!IsObject(argument)) {
    return false;
  }
  var matcher = argument[GetBuiltinSymbol("match")];
  if (matcher !== undefined) {
    return !!matcher;
  }
  return IsPossiblyWrappedRegExpObject(argument);
}
function ThrowIncompatibleMethod(name, thisv) {
  ThrowTypeError(3, "String", name, ToString(thisv));
}
function String_match(regexp) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("match", this);
  }
  if (IsObject(regexp)) {
    if (IsOptimizableRegExpObject(regexp)) {
      return callFunction(RegExpMatch, regexp, this);
    }
    var matcher = GetMethod(regexp, GetBuiltinSymbol("match"));
    if (matcher !== undefined) {
      return callContentFunction(matcher, regexp, this);
    }
  }
  var S = ToString(this);
  if (typeof regexp === "string" && IsRegExpPrototypeOptimizable()) {
    var flatResult = FlatStringMatch(S, regexp);
    if (flatResult !== undefined) {
      return flatResult;
    }
  }
  var rx = RegExpCreate(regexp);
  if (IsRegExpPrototypeOptimizable()) {
    return RegExpMatcher(rx, S, 0);
  }
  return callContentFunction(GetMethod(rx, GetBuiltinSymbol("match")), rx, S);
}
function String_matchAll(regexp) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("matchAll", this);
  }
  if (IsObject(regexp)) {
    if (IsRegExp(regexp)) {
      var flags = regexp.flags;
      if (IsNullOrUndefined(flags)) {
        ThrowTypeError(111);
      }
      if (!callFunction(std_String_includes, ToString(flags), "g")) {
        ThrowTypeError(112, "matchAll");
      }
    }
    if (IsOptimizableRegExpObject(regexp)) {
      return callFunction(RegExpMatchAll, regexp, this);
    }
    var matcher = GetMethod(regexp, GetBuiltinSymbol("matchAll"));
    if (matcher !== undefined) {
      return callContentFunction(matcher, regexp, this);
    }
  }
  var string = ToString(this);
  var rx = RegExpCreate(regexp, "g");
  return callContentFunction(
    GetMethod(rx, GetBuiltinSymbol("matchAll")),
    rx,
    string
  );
}
function String_pad(maxLength, fillString, padEnd) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod(padEnd ? "padEnd" : "padStart", this);
  }
  var str = ToString(this);
  var intMaxLength = ToLength(maxLength);
  var strLen = str.length;
  if (intMaxLength <= strLen) {
    return str;
  }
  ;;
  var filler = ToString(fillString);
  if (filler === "") {
    return str;
  }
  if (intMaxLength > ((1 << 30) - 2)) {
    ThrowRangeError(110);
  }
  var fillLen = intMaxLength - strLen;
  var truncatedStringFiller = callFunction(
    String_repeat,
    filler,
    (fillLen / filler.length) | 0
  );
  truncatedStringFiller += Substring(filler, 0, fillLen % filler.length);
  if (padEnd === true) {
    return str + truncatedStringFiller;
  }
  return truncatedStringFiller + str;
}
function String_pad_start(maxLength, fillString = " ") {
  return callFunction(String_pad, this, maxLength, fillString, false);
}
function String_pad_end(maxLength, fillString = " ") {
  return callFunction(String_pad, this, maxLength, fillString, true);
}
function Substring(str, from, length) {
  ;;
  ;
   ;
  ;
   ;
  return SubstringKernel(
    str,
    std_Math_max(from, 0) | 0,
    std_Math_max(length, 0) | 0
  );
}
function String_replace(searchValue, replaceValue) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("replace", this);
  }
  if (IsObject(searchValue)) {
    if (IsOptimizableRegExpObject(searchValue)) {
      return callFunction(RegExpReplace, searchValue, this, replaceValue);
    }
    var replacer = GetMethod(searchValue, GetBuiltinSymbol("replace"));
    if (replacer !== undefined) {
      return callContentFunction(replacer, searchValue, this, replaceValue);
    }
  }
  var string = ToString(this);
  var searchString = ToString(searchValue);
  if (typeof replaceValue === "string") {
    return StringReplaceString(string, searchString, replaceValue);
  }
  if (!IsCallable(replaceValue)) {
    return StringReplaceString(string, searchString, ToString(replaceValue));
  }
  var pos = callFunction(std_String_indexOf, string, searchString);
  if (pos === -1) {
    return string;
  }
  var replStr = ToString(
    callContentFunction(replaceValue, undefined, searchString, pos, string)
  );
  var tailPos = pos + searchString.length;
  var newString;
  if (pos === 0) {
    newString = "";
  } else {
    newString = Substring(string, 0, pos);
  }
  newString += replStr;
  var stringLength = string.length;
  if (tailPos < stringLength) {
    newString += Substring(string, tailPos, stringLength - tailPos);
  }
  return newString;
}
function String_replaceAll(searchValue, replaceValue) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("replaceAll", this);
  }
  if (IsObject(searchValue)) {
    if (IsRegExp(searchValue)) {
      var flags = searchValue.flags;
      if (IsNullOrUndefined(flags)) {
        ThrowTypeError(111);
      }
      if (!callFunction(std_String_includes, ToString(flags), "g")) {
        ThrowTypeError(112, "replaceAll");
      }
    }
    if (IsOptimizableRegExpObject(searchValue)) {
      return callFunction(RegExpReplace, searchValue, this, replaceValue);
    }
    var replacer = GetMethod(searchValue, GetBuiltinSymbol("replace"));
    if (replacer !== undefined) {
      return callContentFunction(replacer, searchValue, this, replaceValue);
    }
  }
  var string = ToString(this);
  var searchString = ToString(searchValue);
  if (!IsCallable(replaceValue)) {
    return StringReplaceAllString(string, searchString, ToString(replaceValue));
  }
  var searchLength = searchString.length;
  var advanceBy = std_Math_max(1, searchLength);
  var endOfLastMatch = 0;
  var result = "";
  var position = 0;
  while (true) {
    var nextPosition = callFunction(
      std_String_indexOf,
      string,
      searchString,
      position
    );
    if (nextPosition < position) {
      break;
    }
    position = nextPosition;
    var replacement = ToString(
      callContentFunction(
        replaceValue,
        undefined,
        searchString,
        position,
        string
      )
    );
    var stringSlice = Substring(
      string,
      endOfLastMatch,
      position - endOfLastMatch
    );
    result += stringSlice + replacement;
    endOfLastMatch = position + searchLength;
    position += advanceBy;
  }
  if (endOfLastMatch < string.length) {
    result += Substring(string, endOfLastMatch, string.length - endOfLastMatch);
  }
  return result;
}
function String_search(regexp) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("search", this);
  }
  var isPatternString = typeof regexp === "string";
  if (IsObject(regexp)) {
    if (IsOptimizableRegExpObject(regexp)) {
      return callFunction(RegExpSearch, regexp, this);
    }
    var searcher = GetMethod(regexp, GetBuiltinSymbol("search"));
    if (searcher !== undefined) {
      return callContentFunction(searcher, regexp, this);
    }
  }
  var string = ToString(this);
  if (isPatternString && IsRegExpPrototypeOptimizable()) {
    var flatResult = FlatStringSearch(string, regexp);
    if (flatResult !== -2) {
      return flatResult;
    }
  }
  var rx = RegExpCreate(regexp);
  return callContentFunction(
    GetMethod(rx, GetBuiltinSymbol("search")),
    rx,
    string
  );
}
function String_split(separator, limit) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("split", this);
  }
  if (typeof this === "string") {
    if (typeof separator === "string") {
      if (limit === undefined) {
        return StringSplitString(this, separator);
      }
    }
  }
  if (IsObject(separator)) {
    if (IsOptimizableRegExpObject(separator)) {
      return callFunction(RegExpSplit, separator, this, limit);
    }
    var splitter = GetMethod(separator, GetBuiltinSymbol("split"));
    if (splitter !== undefined) {
      return callContentFunction(splitter, separator, this, limit);
    }
  }
  var S = ToString(this);
  var R;
  if (limit !== undefined) {
    var lim = limit >>> 0;
    R = ToString(separator);
    if (lim === 0) {
      return [];
    }
    if (separator === undefined) {
      return [S];
    }
    return StringSplitStringLimit(S, R, lim);
  }
  R = ToString(separator);
  if (separator === undefined) {
    return [S];
  }
  return StringSplitString(S, R);
}
function String_substring(start, end) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("substring", this);
  }
  var str = ToString(this);
  var len = str.length;
  var intStart = ToInteger(start);
  var intEnd = end === undefined ? len : ToInteger(end);
  var finalStart = std_Math_min(std_Math_max(intStart, 0), len);
  var finalEnd = std_Math_min(std_Math_max(intEnd, 0), len);
  var from = std_Math_min(finalStart, finalEnd);
  var to = std_Math_max(finalStart, finalEnd);
  return SubstringKernel(str, from | 0, (to - from) | 0);
}
SetIsInlinableLargeFunction(String_substring);
function String_substr(start, length) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("substr", this);
  }
  var str = ToString(this);
  var intStart = ToInteger(start);
  var size = str.length;
  var end = length === undefined ? size : ToInteger(length);
  if (intStart < 0) {
    intStart = std_Math_max(intStart + size, 0);
  } else {
    intStart = std_Math_min(intStart, size);
  }
  var resultLength = std_Math_min(std_Math_max(end, 0), size - intStart);
  ;
   ;
  return SubstringKernel(str, intStart | 0, resultLength | 0);
}
SetIsInlinableLargeFunction(String_substr);
function String_concat(arg1) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("concat", this);
  }
  var str = ToString(this);
  if (ArgumentsLength() === 0) {
    return str;
  }
  if (ArgumentsLength() === 1) {
    return str + ToString(GetArgument(0));
  }
  if (ArgumentsLength() === 2) {
    return str + ToString(GetArgument(0)) + ToString(GetArgument(1));
  }
  var result = str;
  for (var i = 0; i < ArgumentsLength(); i++) {
    var nextString = ToString(GetArgument(i));
    result += nextString;
  }
  return result;
}
function String_slice(start, end) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("slice", this);
  }
  var str = ToString(this);
  var len = str.length;
  var intStart = ToInteger(start);
  var intEnd = end === undefined ? len : ToInteger(end);
  var from =
    intStart < 0
      ? std_Math_max(len + intStart, 0)
      : std_Math_min(intStart, len);
  var to =
    intEnd < 0 ? std_Math_max(len + intEnd, 0) : std_Math_min(intEnd, len);
  var span = std_Math_max(to - from, 0);
  return SubstringKernel(str, from | 0, span | 0);
}
SetIsInlinableLargeFunction(String_slice);
function String_repeat(count) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("repeat", this);
  }
  var S = ToString(this);
  var n = ToInteger(count);
  if (n < 0) {
    ThrowRangeError(108);
  }
  if (!(n * S.length <= ((1 << 30) - 2))) {
    ThrowRangeError(110);
  }
  ;
   ;
  ;
   ;
  n = n & (((1 << 30) - 2) + 1);
  var T = "";
  for (;;) {
    if (n & 1) {
      T += S;
    }
    n >>= 1;
    if (n) {
      S += S;
    } else {
      break;
    }
  }
  return T;
}
function String_iterator() {
  if (IsNullOrUndefined(this)) {
    ThrowTypeError(
      4,
      "String",
      "Symbol.iterator",
      ToString(this)
    );
  }
  var S = ToString(this);
  var iterator = NewStringIterator();
  UnsafeSetReservedSlot(iterator, 0, S);
  UnsafeSetReservedSlot(iterator, 1, 0);
  return iterator;
}
function StringIteratorNext() {
  var obj = this;
  if (!IsObject(obj) || (obj = GuardToStringIterator(obj)) === null) {
    return callFunction(
      CallStringIteratorMethodIfWrapped,
      this,
      "StringIteratorNext"
    );
  }
  var S = UnsafeGetStringFromReservedSlot(obj, 0);
  var index = UnsafeGetInt32FromReservedSlot(obj, 1);
  var size = S.length;
  var result = { value: undefined, done: false };
  if (index >= size) {
    result.done = true;
    return result;
  }
  var codePoint = callFunction(std_String_codePointAt, S, index);
  var charCount = 1 + (codePoint > 0xffff);
  UnsafeSetReservedSlot(obj, 1, index + charCount);
  result.value = callFunction(std_String_fromCodePoint, null, codePoint);
  return result;
}
SetIsInlinableLargeFunction(StringIteratorNext);
function String_static_raw(callSite ) {
  var cooked = ToObject(callSite);
  var raw = ToObject(cooked.raw);
  var literalSegments = ToLength(raw.length);
  if (literalSegments === 0) {
    return "";
  }
  if (literalSegments === 1) {
    return ToString(raw[0]);
  }
  var resultString = ToString(raw[0]);
  for (var nextIndex = 1; nextIndex < literalSegments; nextIndex++) {
    if (nextIndex < ArgumentsLength()) {
      resultString += ToString(GetArgument(nextIndex));
    }
    resultString += ToString(raw[nextIndex]);
  }
  return resultString;
}
function String_big() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("big", this);
  }
  return "<big>" + ToString(this) + "</big>";
}
function String_blink() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("blink", this);
  }
  return "<blink>" + ToString(this) + "</blink>";
}
function String_bold() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("bold", this);
  }
  return "<b>" + ToString(this) + "</b>";
}
function String_fixed() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("fixed", this);
  }
  return "<tt>" + ToString(this) + "</tt>";
}
function String_italics() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("italics", this);
  }
  return "<i>" + ToString(this) + "</i>";
}
function String_small() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("small", this);
  }
  return "<small>" + ToString(this) + "</small>";
}
function String_strike() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("strike", this);
  }
  return "<strike>" + ToString(this) + "</strike>";
}
function String_sub() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("sub", this);
  }
  return "<sub>" + ToString(this) + "</sub>";
}
function String_sup() {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("sup", this);
  }
  return "<sup>" + ToString(this) + "</sup>";
}
function EscapeAttributeValue(v) {
  var inputStr = ToString(v);
  return StringReplaceAllString(inputStr, '"', "&quot;");
}
function String_anchor(name) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("anchor", this);
  }
  var S = ToString(this);
  return '<a name="' + EscapeAttributeValue(name) + '">' + S + "</a>";
}
function String_fontcolor(color) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("fontcolor", this);
  }
  var S = ToString(this);
  return '<font color="' + EscapeAttributeValue(color) + '">' + S + "</font>";
}
function String_fontsize(size) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("fontsize", this);
  }
  var S = ToString(this);
  return '<font size="' + EscapeAttributeValue(size) + '">' + S + "</font>";
}
function String_link(url) {
  if (IsNullOrUndefined(this)) {
    ThrowIncompatibleMethod("link", this);
  }
  var S = ToString(this);
  return '<a href="' + EscapeAttributeValue(url) + '">' + S + "</a>";
}
function SetConstructorInit(iterable) {
  var set = this;
  var adder = set.add;
  if (!IsCallable(adder)) {
    ThrowTypeError(12, typeof adder);
  }
  for (var nextValue of allowContentIter(iterable)) {
    callContentFunction(adder, set, nextValue);
  }
}
function SetForEach(callbackfn, thisArg = undefined) {
  var S = this;
  if (!IsObject(S) || (S = GuardToSetObject(S)) === null) {
    return callFunction(
      CallSetMethodIfWrapped,
      this,
      callbackfn,
      thisArg,
      "SetForEach"
    );
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var values = callFunction(std_Set_values, S);
  var setIterationResult = globalSetIterationResult;
  while (true) {
    var done = GetNextSetEntryForIterator(values, setIterationResult);
    if (done) {
      break;
    }
    var value = setIterationResult[0];
    setIterationResult[0] = null;
    callContentFunction(callbackfn, thisArg, value, value, S);
  }
}
function $SetSpecies() {
  return this;
}
SetCanonicalName($SetSpecies, "get [Symbol.species]");
var globalSetIterationResult = CreateSetIterationResult();
function SetIteratorNext() {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetIterator(O)) === null) {
    return callFunction(
      CallSetIteratorMethodIfWrapped,
      this,
      "SetIteratorNext"
    );
  }
  var setIterationResult = globalSetIterationResult;
  var retVal = { value: undefined, done: true };
  var done = GetNextSetEntryForIterator(O, setIterationResult);
  if (!done) {
    var itemKind = UnsafeGetInt32FromReservedSlot(O, 1);
    var result;
    if (itemKind === 1) {
      result = setIterationResult[0];
    } else {
      ;;
      result = [setIterationResult[0], setIterationResult[0]];
    }
    setIterationResult[0] = null;
    retVal.value = result;
    retVal.done = false;
  }
  return retVal;
}
function GetSetRecord(obj) {
  if (!IsObject(obj)) {
    ThrowTypeError(56, obj === null ? "null" : typeof obj);
  }
  var rawSize = obj.size;
  var numSize = +rawSize;
  if (numSize !== numSize) {
    if (rawSize === undefined) {
      ThrowTypeError(54, "size", "undefined");
    } else {
      ThrowTypeError(54, "size", "NaN");
    }
  }
  var intSize = ToInteger(numSize);
  if (intSize < 0) {
    ThrowRangeError(700);
  }
  var has = obj.has;
  if (!IsCallable(has)) {
    ThrowTypeError(13, "has");
  }
  var keys = obj.keys;
  if (!IsCallable(keys)) {
    ThrowTypeError(13, "keys");
  }
  return { set: obj, size: intSize, has, keys };
}
function GetIteratorFromMethod(setRec) {
  var keysIter = callContentFunction(setRec.keys, setRec.set);
  if (!IsObject(keysIter)) {
    ThrowTypeError(
      56,
      keysIter === null ? "null" : typeof keysIter
    );
  }
  return keysIter;
}
function SetUnion(other) {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetObject(O)) === null) {
    return callFunction(CallSetMethodIfWrapped, this, other, "SetUnion");
  }
  var otherRec = GetSetRecord(other);
  var keysIter = GetIteratorFromMethod(otherRec);
  var keysIterNext = keysIter.next;
  var result = SetCopy(O);
  for (var nextValue of allowContentIterWithNext(keysIter, keysIterNext)) {
    callFunction(std_Set_add, result, nextValue);
  }
  return result;
}
function SetIntersection(other) {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetObject(O)) === null) {
    return callFunction(CallSetMethodIfWrapped, this, other, "SetIntersection");
  }
  var otherRec = GetSetRecord(other);
  var Set = GetBuiltinConstructor("Set");
  var result = new Set();
  var thisSize = callFunction(std_Set_size, O);
  if (thisSize <= otherRec.size) {
    var values = callFunction(std_Set_values, O);
    var setIterationResult = globalSetIterationResult;
    while (true) {
      var done = GetNextSetEntryForIterator(values, setIterationResult);
      if (done) {
        break;
      }
      var value = setIterationResult[0];
      setIterationResult[0] = null;
      if (callContentFunction(otherRec.has, otherRec.set, value)) {
        callFunction(std_Set_add, result, value);
      }
    }
  } else {
    var keysIter = GetIteratorFromMethod(otherRec);
    for (var nextValue of allowContentIterWithNext(keysIter, keysIter.next)) {
      if (callFunction(std_Set_has, O, nextValue)) {
        callFunction(std_Set_add, result, nextValue);
      }
    }
  }
  return result;
}
function SetDifference(other) {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetObject(O)) === null) {
    return callFunction(CallSetMethodIfWrapped, this, other, "SetDifference");
  }
  var otherRec = GetSetRecord(other);
  var result = SetCopy(O);
  var thisSize = callFunction(std_Set_size, O);
  if (thisSize <= otherRec.size) {
    var values = callFunction(std_Set_values, result);
    var setIterationResult = globalSetIterationResult;
    while (true) {
      var done = GetNextSetEntryForIterator(values, setIterationResult);
      if (done) {
        break;
      }
      var value = setIterationResult[0];
      setIterationResult[0] = null;
      if (callContentFunction(otherRec.has, otherRec.set, value)) {
        callFunction(std_Set_delete, result, value);
      }
    }
  } else {
    var keysIter = GetIteratorFromMethod(otherRec);
    for (var nextValue of allowContentIterWithNext(keysIter, keysIter.next)) {
      callFunction(std_Set_delete, result, nextValue);
    }
  }
  return result;
}
function SetSymmetricDifference(other) {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetObject(O)) === null) {
    return callFunction(
      CallSetMethodIfWrapped,
      this,
      other,
      "SetSymmetricDifference"
    );
  }
  var otherRec = GetSetRecord(other);
  var keysIter = GetIteratorFromMethod(otherRec);
  var keysIterNext = keysIter.next;
  var result = SetCopy(O);
  for (var nextValue of allowContentIterWithNext(keysIter, keysIterNext)) {
    if (callFunction(std_Set_has, O, nextValue)) {
      callFunction(std_Set_delete, result, nextValue);
    } else {
      callFunction(std_Set_add, result, nextValue);
    }
  }
  return result;
}
function SetIsSubsetOf(other) {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetObject(O)) === null) {
    return callFunction(CallSetMethodIfWrapped, this, other, "SetIsSubsetOf");
  }
  var otherRec = GetSetRecord(other);
  var thisSize = callFunction(std_Set_size, O);
  if (thisSize > otherRec.size) {
    return false;
  }
  var values = callFunction(std_Set_values, O);
  var setIterationResult = globalSetIterationResult;
  while (true) {
    var done = GetNextSetEntryForIterator(values, setIterationResult);
    if (done) {
      break;
    }
    var value = setIterationResult[0];
    setIterationResult[0] = null;
    if (!callContentFunction(otherRec.has, otherRec.set, value)) {
      return false;
    }
  }
  return true;
}
function SetIsSupersetOf(other) {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetObject(O)) === null) {
    return callFunction(CallSetMethodIfWrapped, this, other, "SetIsSupersetOf");
  }
  var otherRec = GetSetRecord(other);
  var thisSize = callFunction(std_Set_size, O);
  if (thisSize < otherRec.size) {
    return false;
  }
  var keysIter = GetIteratorFromMethod(otherRec);
  for (var nextValue of allowContentIterWithNext(keysIter, keysIter.next)) {
    if (!callFunction(std_Set_has, O, nextValue)) {
      return false;
    }
  }
  return true;
}
function SetIsDisjointFrom(other) {
  var O = this;
  if (!IsObject(O) || (O = GuardToSetObject(O)) === null) {
    return callFunction(
      CallSetMethodIfWrapped,
      this,
      other,
      "SetIsDisjointFrom"
    );
  }
  var otherRec = GetSetRecord(other);
  var thisSize = callFunction(std_Set_size, O);
  if (thisSize <= otherRec.size) {
    var values = callFunction(std_Set_values, O);
    var setIterationResult = globalSetIterationResult;
    while (true) {
      var done = GetNextSetEntryForIterator(values, setIterationResult);
      if (done) {
        break;
      }
      var value = setIterationResult[0];
      setIterationResult[0] = null;
      if (callContentFunction(otherRec.has, otherRec.set, value)) {
        return false;
      }
    }
  } else {
    var keysIter = GetIteratorFromMethod(otherRec);
    for (var nextValue of allowContentIterWithNext(keysIter, keysIter.next)) {
      if (callFunction(std_Set_has, O, nextValue)) {
        return false;
      }
    }
  }
  return true;
}
function ViewedArrayBufferIfReified(tarray) {
  ;;
  var buf = UnsafeGetReservedSlot(tarray, 0);
  ;
   ;
  return IsObject(buf) ? buf : null;
}
function GetArrayBufferFlagsOrZero(buffer) {
  if (buffer === null) {
    return 0;
  }
  ;
   ;
  if ((buffer = GuardToArrayBuffer(buffer)) === null) {
    return 0;
  }
  return UnsafeGetInt32FromReservedSlot(buffer, 3);
}
function EnsureAttachedArrayBuffer(tarray) {
  var buffer = ViewedArrayBufferIfReified(tarray);
  var flags = GetArrayBufferFlagsOrZero(buffer);
  if ((flags & 0x8) !== 0) {
    ThrowTypeError(598);
  }
}
function EnsureAttachedMutableArrayBuffer(tarray) {
  var buffer = ViewedArrayBufferIfReified(tarray);
  var flags = GetArrayBufferFlagsOrZero(buffer);
  if ((flags & 0x8) !== 0) {
    ThrowTypeError(598);
  }
  if ((flags & 0x80) !== 0) {
    ThrowTypeError(599);
  }
}
function EnsureAttachedArrayBufferMethod() {
  EnsureAttachedArrayBuffer(this);
}
function EnsureTypedArrayWithArrayBuffer(arg) {
  if (IsObject(arg) && IsTypedArray(arg)) {
    EnsureAttachedArrayBuffer(arg);
    return;
  }
  callFunction(
    CallTypedArrayMethodIfWrapped,
    arg,
    "EnsureAttachedArrayBufferMethod"
  );
}
function TypedArraySpeciesConstructor(obj) {
  ;;
  var ctor = obj.constructor;
  if (ctor === undefined) {
    return ConstructorForTypedArray(obj);
  }
  if (!IsObject(ctor)) {
    ThrowTypeError(56, "object's 'constructor' property");
  }
  var s = ctor[GetBuiltinSymbol("species")];
  if (IsNullOrUndefined(s)) {
    return ConstructorForTypedArray(obj);
  }
  if (IsConstructor(s)) {
    return s;
  }
  ThrowTypeError(
    14,
    "@@species property of object's constructor"
  );
}
function ValidateWritableTypedArray(obj) {
  if (IsObject(obj)) {
    if (IsTypedArray(obj)) {
      EnsureAttachedMutableArrayBuffer(obj);
      return;
    }
    if (IsPossiblyWrappedTypedArray(obj)) {
      if (PossiblyWrappedTypedArrayHasDetachedBuffer(obj)) {
        ThrowTypeError(598);
      }
      if (PossiblyWrappedTypedArrayHasImmutableBuffer(obj)) {
        ThrowTypeError(599);
      }
      return;
    }
  }
  ThrowTypeError(617);
}
function TypedArrayCreateWithLength(constructor, length) {
  var newTypedArray = constructContentFunction(
    constructor,
    constructor,
    length
  );
  ValidateWritableTypedArray(newTypedArray);
  var len = PossiblyWrappedTypedArrayLength(newTypedArray);
  if (len < length) {
    ThrowTypeError(618, length, len);
  }
  return newTypedArray;
}
function TypedArraySpeciesCreateWithLength(exemplar, length) {
  var C = TypedArraySpeciesConstructor(exemplar);
  return TypedArrayCreateWithLength(C, length);
}
function TypedArrayEntries() {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  PossiblyWrappedTypedArrayLength(O);
  var iteratedObject = ToObject(O); var iterator = NewArrayIterator(); UnsafeSetReservedSlot(iterator, 0, iteratedObject); UnsafeSetReservedSlot(iterator, 1, 0); UnsafeSetReservedSlot(iterator, 2, 2); return iterator;
}
function TypedArrayEvery(callbackfn ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "%TypedArray%.prototype.every");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    var kValue = O[k];
    var testResult = callContentFunction(callbackfn, thisArg, kValue, k, O);
    if (!testResult) {
      return false;
    }
  }
  return true;
}
SetIsInlinableLargeFunction(TypedArrayEvery);
function TypedArrayFilter(callbackfn ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "%TypedArray%.prototype.filter");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var kept = new_List();
  var captured = 0;
  for (var k = 0; k < len; k++) {
    var kValue = O[k];
    if (callContentFunction(callbackfn, T, kValue, k, O)) {
      kept[captured++] = kValue;
    }
  }
  var A = TypedArraySpeciesCreateWithLength(O, captured);
  for (var n = 0; n < captured; n++) {
    A[n] = kept[n];
  }
  return A;
}
SetIsInlinableLargeFunction(TypedArrayFilter);
function TypedArrayFind(predicate ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "%TypedArray%.prototype.find");
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    var kValue = O[k];
    if (callContentFunction(predicate, thisArg, kValue, k, O)) {
      return kValue;
    }
  }
  return undefined;
}
SetIsInlinableLargeFunction(TypedArrayFind);
function TypedArrayFindIndex(predicate ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(
      55,
      0,
      "%TypedArray%.prototype.findIndex"
    );
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    if (callContentFunction(predicate, thisArg, O[k], k, O)) {
      return k;
    }
  }
  return -1;
}
SetIsInlinableLargeFunction(TypedArrayFindIndex);
function TypedArrayForEach(callbackfn ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "TypedArray.prototype.forEach");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    callContentFunction(callbackfn, thisArg, O[k], k, O);
  }
  return undefined;
}
SetIsInlinableLargeFunction(TypedArrayForEach);
function TypedArrayKeys() {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  PossiblyWrappedTypedArrayLength(O);
  var iteratedObject = ToObject(O); var iterator = NewArrayIterator(); UnsafeSetReservedSlot(iterator, 0, iteratedObject); UnsafeSetReservedSlot(iterator, 1, 0); UnsafeSetReservedSlot(iterator, 2, 0); return iterator;
}
function TypedArrayMap(callbackfn ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "%TypedArray%.prototype.map");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var T = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var A = TypedArraySpeciesCreateWithLength(O, len);
  for (var k = 0; k < len; k++) {
    var mappedValue = callContentFunction(callbackfn, T, O[k], k, O);
    A[k] = mappedValue;
  }
  return A;
}
SetIsInlinableLargeFunction(TypedArrayMap);
function TypedArrayReduce(callbackfn ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "%TypedArray%.prototype.reduce");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  if (len === 0 && ArgumentsLength() === 1) {
    ThrowTypeError(52);
  }
  var k = 0;
  var accumulator = ArgumentsLength() > 1 ? GetArgument(1) : O[k++];
  for (; k < len; k++) {
    accumulator = callContentFunction(
      callbackfn,
      undefined,
      accumulator,
      O[k],
      k,
      O
    );
  }
  return accumulator;
}
function TypedArrayReduceRight(callbackfn ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(
      55,
      0,
      "%TypedArray%.prototype.reduceRight"
    );
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  if (len === 0 && ArgumentsLength() === 1) {
    ThrowTypeError(52);
  }
  var k = len - 1;
  var accumulator = ArgumentsLength() > 1 ? GetArgument(1) : O[k--];
  for (; k >= 0; k--) {
    accumulator = callContentFunction(
      callbackfn,
      undefined,
      accumulator,
      O[k],
      k,
      O
    );
  }
  return accumulator;
}
function TypedArraySome(callbackfn ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "%TypedArray%.prototype.some");
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(0, callbackfn));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = 0; k < len; k++) {
    var kValue = O[k];
    var testResult = callContentFunction(callbackfn, thisArg, kValue, k, O);
    if (testResult) {
      return true;
    }
  }
  return false;
}
SetIsInlinableLargeFunction(TypedArraySome);
function TypedArrayToLocaleString(locales = undefined, options = undefined) {
  var array = this;
  EnsureTypedArrayWithArrayBuffer(array);
  var len = PossiblyWrappedTypedArrayLength(array);
  if (len === 0) {
    return "";
  }
  var firstElement = array[0];
  ;
   ;
  var R = ToString(
    callContentFunction(
      firstElement.toLocaleString,
      firstElement,
      locales,
      options
    )
  );
  var separator = ",";
  for (var k = 1; k < len; k++) {
    R += separator;
    var nextElement = array[k];
    if (nextElement === undefined) {
      continue;
    }
    ;
     ;
    R += ToString(
      callContentFunction(
        nextElement.toLocaleString,
        nextElement,
        locales,
        options
      )
    );
  }
  return R;
}
function TypedArrayAt(index) {
  var obj = this;
  if (!IsObject(obj) || !IsTypedArray(obj)) {
    return callFunction(
      CallTypedArrayMethodIfWrapped,
      obj,
      index,
      "TypedArrayAt"
    );
  }
  EnsureAttachedArrayBuffer(obj);
  var len = TypedArrayLength(obj);
  var relativeIndex = ToInteger(index);
  var k;
  if (relativeIndex >= 0) {
    k = relativeIndex;
  } else {
    k = len + relativeIndex;
  }
  if (k < 0 || k >= len) {
    return undefined;
  }
  return obj[k];
}
SetIsInlinableLargeFunction(TypedArrayAt);
function TypedArrayFindLast(predicate ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(55, 0, "%TypedArray%.prototype.findLast");
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = len - 1; k >= 0; k--) {
    var kValue = O[k];
    if (callContentFunction(predicate, thisArg, kValue, k, O)) {
      return kValue;
    }
  }
  return undefined;
}
SetIsInlinableLargeFunction(TypedArrayFindLast);
function TypedArrayFindLastIndex(predicate ) {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  if (ArgumentsLength() === 0) {
    ThrowTypeError(
      55,
      0,
      "%TypedArray%.prototype.findLastIndex"
    );
  }
  if (!IsCallable(predicate)) {
    ThrowTypeError(12, DecompileArg(0, predicate));
  }
  var thisArg = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  for (var k = len - 1; k >= 0; k--) {
    if (callContentFunction(predicate, thisArg, O[k], k, O)) {
      return k;
    }
  }
  return -1;
}
SetIsInlinableLargeFunction(TypedArrayFindLastIndex);
function $TypedArrayValues() {
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  PossiblyWrappedTypedArrayLength(O);
  var iteratedObject = ToObject(O); var iterator = NewArrayIterator(); UnsafeSetReservedSlot(iterator, 0, iteratedObject); UnsafeSetReservedSlot(iterator, 1, 0); UnsafeSetReservedSlot(iterator, 2, 1); return iterator;
}
SetCanonicalName($TypedArrayValues, "values");
function TypedArrayStaticFrom(source, mapfn = undefined, thisArg = undefined) {
  var C = this;
  if (!IsConstructor(C)) {
    ThrowTypeError(14, typeof C);
  }
  var mapping;
  if (mapfn !== undefined) {
    if (!IsCallable(mapfn)) {
      ThrowTypeError(12, DecompileArg(1, mapfn));
    }
    mapping = true;
  } else {
    mapping = false;
  }
  var T = thisArg;
  var usingIterator = source[GetBuiltinSymbol("iterator")];
  if (usingIterator !== undefined && usingIterator !== null) {
    if (!IsCallable(usingIterator)) {
      ThrowTypeError(71, DecompileArg(0, source));
    }
    if (!mapping && IsTypedArrayConstructor(C) && IsObject(source)) {
      if (
        usingIterator === $TypedArrayValues &&
        IsTypedArray(source) &&
        ArrayIteratorPrototypeOptimizable()
      ) {
        EnsureAttachedArrayBuffer(source);
        var len = TypedArrayLength(source);
        var targetObj = constructContentFunction(C, C, len);
        for (var k = 0; k < len; k++) {
          targetObj[k] = source[k];
        }
        return targetObj;
      }
      if (
        usingIterator === $ArrayValues &&
        IsPackedArray(source) &&
        ArrayIteratorPrototypeOptimizable()
      ) {
        var targetObj = constructContentFunction(C, C, source.length);
        TypedArrayInitFromPackedArray(targetObj, source);
        return targetObj;
      }
    }
    var values = IterableToList(source, usingIterator);
    var len = values.length;
    var targetObj = TypedArrayCreateWithLength(C, len);
    for (var k = 0; k < len; k++) {
      var kValue = values[k];
      var mappedValue = mapping
        ? callContentFunction(mapfn, T, kValue, k)
        : kValue;
      targetObj[k] = mappedValue;
    }
    return targetObj;
  }
  var arrayLike = ToObject(source);
  var len = ToLength(arrayLike.length);
  var targetObj = TypedArrayCreateWithLength(C, len);
  for (var k = 0; k < len; k++) {
    var kValue = arrayLike[k];
    var mappedValue = mapping
      ? callContentFunction(mapfn, T, kValue, k)
      : kValue;
    targetObj[k] = mappedValue;
  }
  return targetObj;
}
function TypedArrayStaticOf( ) {
  var len = ArgumentsLength();
  var C = this;
  if (!IsConstructor(C)) {
    ThrowTypeError(14, typeof C);
  }
  var newObj = TypedArrayCreateWithLength(C, len);
  for (var k = 0; k < len; k++) {
    newObj[k] = GetArgument(k);
  }
  return newObj;
}
function $TypedArraySpecies() {
  return this;
}
SetCanonicalName($TypedArraySpecies, "get [Symbol.species]");
function IterableToList(items, method) {
  ;;
  var iterator = callContentFunction(method, items);
  if (!IsObject(iterator)) {
    ThrowTypeError(73);
  }
  var nextMethod = iterator.next;
  var values = [];
  var i = 0;
  while (true) {
    var next = callContentFunction(nextMethod, iterator);
    if (!IsObject(next)) {
      ThrowTypeError(74, "next");
    }
    if (next.done) {
      break;
    }
    DefineDataProperty(values, i++, next.value);
  }
  return values;
}
function $ArrayBufferSpecies() {
  return this;
}
SetCanonicalName($ArrayBufferSpecies, "get [Symbol.species]");
function $SharedArrayBufferSpecies() {
  return this;
}
SetCanonicalName($SharedArrayBufferSpecies, "get [Symbol.species]");
function TypedArrayCreateSameType(exemplar, length) {
  ;
   ;
  var constructor = ConstructorForTypedArray(exemplar);
  return TypedArrayCreateWithLength(constructor, length);
}
function TypedArrayToSorted(comparefn) {
  if (comparefn !== undefined) {
    if (!IsCallable(comparefn)) {
      ThrowTypeError(12, DecompileArg(0, comparefn));
    }
  }
  var O = this;
  EnsureTypedArrayWithArrayBuffer(O);
  var len = PossiblyWrappedTypedArrayLength(O);
  var A = TypedArrayCreateSameType(O, len);
  for (var k = 0; k < len; k++) {
    A[k] = O[k];
  }
  if (len > 1) {
    callFunction(std_TypedArray_sort, A, comparefn);
  }
  return A;
}
function WeakMapConstructorInit(iterable) {
  var map = this;
  var adder = map.set;
  if (!IsCallable(adder)) {
    ThrowTypeError(12, typeof adder);
  }
  for (var nextItem of allowContentIter(iterable)) {
    if (!IsObject(nextItem)) {
      ThrowTypeError(45, "WeakMap");
    }
    callContentFunction(adder, map, nextItem[0], nextItem[1]);
  }
}
function WeakMapGetOrInsertComputed(key, callbackfn) {
  var M = this;
  if (!IsObject(M) || (M = GuardToWeakMapObject(M)) === null) {
    return callFunction(
      CallWeakMapMethodIfWrapped,
      this,
      key,
      callbackfn,
      "WeakMapGetOrInsertComputed"
    );
  }
  if (!IsCallable(callbackfn)) {
    ThrowTypeError(12, DecompileArg(1, callbackfn));
  }
  if (!CanBeHeldWeakly(key)) {
    ThrowTypeError(29, DecompileArg(0, key));
  }
  if (callFunction(std_WeakMap_has, M, key)) {
    return callFunction(std_WeakMap_get, M, key);
  }
  var value = callContentFunction(callbackfn, undefined, key);
  callFunction(std_WeakMap_set, M, key, value);
  return value;
}
function WeakSetConstructorInit(iterable) {
  var set = this;
  var adder = set.add;
  if (!IsCallable(adder)) {
    ThrowTypeError(12, typeof adder);
  }
  for (var nextValue of allowContentIter(iterable)) {
    callContentFunction(adder, set, nextValue);
  }
}
function resolveCollatorInternals(lazyCollatorData) {
  ;;
  var internalProps = std_Object_create(null);
  var Collator = collatorInternalProperties;
  internalProps.usage = lazyCollatorData.usage;
  var collatorIsSorting = lazyCollatorData.usage === "sort";
  var localeData = collatorIsSorting
    ? Collator.sortLocaleData
    : Collator.searchLocaleData;
  var relevantExtensionKeys = Collator.relevantExtensionKeys;
  var r = ResolveLocale(
    "Collator",
    lazyCollatorData.requestedLocales,
    lazyCollatorData.opt,
    relevantExtensionKeys,
    localeData
  );
  internalProps.locale = r.locale;
  var collation = r.co;
  if (collation === null) {
    collation = "default";
  }
  internalProps.collation = collation;
  internalProps.numeric = r.kn === "true";
  internalProps.caseFirst = r.kf;
  var s = lazyCollatorData.rawSensitivity;
  if (s === undefined) {
    s = "variant";
  }
  internalProps.sensitivity = s;
  var ignorePunctuation = lazyCollatorData.ignorePunctuation;
  if (ignorePunctuation === undefined) {
    var actualLocale = collatorActualLocale(r.dataLocale);
    ignorePunctuation = intl_isIgnorePunctuation(actualLocale);
  }
  internalProps.ignorePunctuation = ignorePunctuation;
  return internalProps;
}
function getCollatorInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveCollatorInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function InitializeCollator(collator, locales, options) {
  ;;
  ;
   ;
  var lazyCollatorData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyCollatorData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else {
    options = ToObject(options);
  }
  var u = GetOption(options, "usage", "string", ["sort", "search"], "sort");
  lazyCollatorData.usage = u;
  var opt = std_Object_create(null);
  lazyCollatorData.opt = opt;
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  opt.localeMatcher = matcher;
  var collation = GetOption(
    options,
    "collation",
    "string",
    undefined,
    undefined
  );
  if (collation !== undefined) {
    collation = intl_ValidateAndCanonicalizeUnicodeExtensionType(
      collation,
      "collation",
      "co"
    );
  }
  opt.co = collation;
  var numericValue = GetOption(
    options,
    "numeric",
    "boolean",
    undefined,
    undefined
  );
  if (numericValue !== undefined) {
    numericValue = numericValue ? "true" : "false";
  }
  opt.kn = numericValue;
  var caseFirstValue = GetOption(
    options,
    "caseFirst",
    "string",
    ["upper", "lower", "false"],
    undefined
  );
  opt.kf = caseFirstValue;
  var s = GetOption(
    options,
    "sensitivity",
    "string",
    ["base", "accent", "case", "variant"],
    undefined
  );
  lazyCollatorData.rawSensitivity = s;
  var ip = GetOption(options, "ignorePunctuation", "boolean", undefined, undefined);
  lazyCollatorData.ignorePunctuation = ip;
  initializeIntlObject(collator, "Collator", lazyCollatorData);
}
function Intl_Collator_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "Collator";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
var collatorInternalProperties = {
  sortLocaleData: collatorSortLocaleData,
  searchLocaleData: collatorSearchLocaleData,
  relevantExtensionKeys: ["co", "kf", "kn"],
};
function collatorActualLocale(locale) {
  ;;
  return BestAvailableLocaleIgnoringDefault("Collator", locale);
}
function collatorSortCaseFirst(locale) {
  var actualLocale = collatorActualLocale(locale);
  if (intl_isUpperCaseFirst(actualLocale)) {
    return ["upper", "false", "lower"];
  }
  return ["false", "lower", "upper"];
}
function collatorSortCaseFirstDefault(locale) {
  var actualLocale = collatorActualLocale(locale);
  if (intl_isUpperCaseFirst(actualLocale)) {
    return "upper";
  }
  return "false";
}
function collatorSortLocaleData() {
  return {
    co: intl_availableCollations,
    kn: function() {
      return ["false", "true"];
    },
    kf: collatorSortCaseFirst,
    default: {
      co: function() {
        return null;
      },
      kn: function() {
        return "false";
      },
      kf: collatorSortCaseFirstDefault,
    },
  };
}
function collatorSearchLocaleData() {
  return {
    co: function() {
      return [null];
    },
    kn: function() {
      return ["false", "true"];
    },
    kf: function() {
      return ["false", "lower", "upper"];
    },
    default: {
      co: function() {
        return null;
      },
      kn: function() {
        return "false";
      },
      kf: function() {
        return "false";
      },
    },
  };
}
function createCollatorCompare(collator) {
  return function(x, y) {
    ;;
    ;
     ;
    var X = ToString(x);
    var Y = ToString(y);
    return intl_CompareStrings(collator, X, Y);
  };
}
function $Intl_Collator_compare_get() {
  var collator = this;
  if (
    !IsObject(collator) ||
    (collator = intl_GuardToCollator(collator)) === null
  ) {
    return callFunction(
      intl_CallCollatorMethodIfWrapped,
      this,
      "$Intl_Collator_compare_get"
    );
  }
  var internals = getCollatorInternals(collator);
  if (internals.boundCompare === undefined) {
    internals.boundCompare = createCollatorCompare(collator);
  }
  return internals.boundCompare;
}
SetCanonicalName($Intl_Collator_compare_get, "get compare");
function Intl_Collator_resolvedOptions() {
  var collator = this;
  if (
    !IsObject(collator) ||
    (collator = intl_GuardToCollator(collator)) === null
  ) {
    return callFunction(
      intl_CallCollatorMethodIfWrapped,
      this,
      "Intl_Collator_resolvedOptions"
    );
  }
  var internals = getCollatorInternals(collator);
  var result = {
    locale: internals.locale,
    usage: internals.usage,
    sensitivity: internals.sensitivity,
    ignorePunctuation: internals.ignorePunctuation,
    collation: internals.collation,
    numeric: internals.numeric,
    caseFirst: internals.caseFirst,
  };
  return result;
}
function startOfUnicodeExtensions(locale) {
  ;;
  var start = callFunction(std_String_indexOf, locale, "-u-");
  if (start < 0) {
    return -1;
  }
  var privateExt = callFunction(std_String_indexOf, locale, "-x-");
  if (privateExt >= 0 && privateExt < start) {
    return -1;
  }
  return start;
}
function endOfUnicodeExtensions(locale, start) {
  ;;
  ;;
  ;
   ;
  for (var i = start + 5, end = locale.length - 4; i <= end; i++) {
    if (locale[i] !== "-") {
      continue;
    }
    if (locale[i + 2] === "-") {
      return i;
    }
    i += 2;
  }
  return locale.length;
}
function removeUnicodeExtensions(locale) {
  ;
   ;
  var start = startOfUnicodeExtensions(locale);
  if (start < 0) {
    return locale;
  }
  var end = endOfUnicodeExtensions(locale, start);
  var left = Substring(locale, 0, start);
  var right = Substring(locale, end, locale.length - end);
  var combined = left + right;
  ;;
  ;
   ;
  return combined;
}
function getUnicodeExtensions(locale) {
  ;;
  var start = startOfUnicodeExtensions(locale);
  ;;
  var end = endOfUnicodeExtensions(locale, start);
  return Substring(locale, start, end - start);
}
function IsASCIIAlphaString(s) {
  ;;
  for (var i = 0; i < s.length; i++) {
    var c = callFunction(std_String_charCodeAt, s, i);
    if (!((0x41 <= c && c <= 0x5a) || (0x61 <= c && c <= 0x7a))) {
      return false;
    }
  }
  return true;
}
function CanonicalizeLocaleList(locales) {
  if (locales === undefined) {
    return [];
  }
  var tag = intl_ValidateAndCanonicalizeLanguageTag(locales, false);
  if (tag !== null) {
    ;
     ;
    return [tag];
  }
  var seen = [];
  var O = ToObject(locales);
  var len = ToLength(O.length);
  var k = 0;
  while (k < len) {
    if (k in O) {
      var kValue = O[k];
      if (!(typeof kValue === "string" || IsObject(kValue))) {
        ThrowTypeError(538);
      }
      var tag = intl_ValidateAndCanonicalizeLanguageTag(kValue, true);
      ;
       ;
      if (callFunction(std_Array_indexOf, seen, tag) === -1) {
        DefineDataProperty(seen, seen.length, tag);
      }
    }
    k++;
  }
  return seen;
}
function BestAvailableLocale(availableLocales, locale) {
  return intl_BestAvailableLocale(availableLocales, locale, intl_DefaultLocale());
}
function BestAvailableLocaleIgnoringDefault(availableLocales, locale) {
  return intl_BestAvailableLocale(availableLocales, locale, null);
}
function LookupMatcher(availableLocales, requestedLocales) {
  var result = std_Object_create(null);
  for (var i = 0; i < requestedLocales.length; i++) {
    var locale = requestedLocales[i];
    var noExtensionsLocale = removeUnicodeExtensions(locale);
    var availableLocale = BestAvailableLocale(
      availableLocales,
      noExtensionsLocale
    );
    if (availableLocale !== undefined) {
      result.locale = availableLocale;
      if (locale !== noExtensionsLocale) {
        result.extension = getUnicodeExtensions(locale);
      }
      return result;
    }
  }
  result.locale = intl_DefaultLocale();
  return result;
}
function BestFitMatcher(availableLocales, requestedLocales) {
  return LookupMatcher(availableLocales, requestedLocales);
}
function UnicodeExtensionValue(extension, key) {
  ;;
  ;
   ;
  ;;
  ;;
  var size = extension.length;
  var searchValue = "-" + key + "-";
  var pos = callFunction(std_String_indexOf, extension, searchValue);
  if (pos !== -1) {
    var start = pos + 4;
    var end = start;
    var k = start;
    while (true) {
      var e = callFunction(std_String_indexOf, extension, "-", k);
      var len = e === -1 ? size - k : e - k;
      if (len === 2) {
        break;
      }
      if (e === -1) {
        end = size;
        break;
      }
      end = e;
      k = e + 1;
    }
    return callFunction(String_substring, extension, start, end);
  }
  searchValue = "-" + key;
  if (callFunction(std_String_endsWith, extension, searchValue)) {
    return "";
  }
}
function ResolveLocale(
  availableLocales,
  requestedLocales,
  options,
  relevantExtensionKeys,
  localeData
) {
  var matcher = options.localeMatcher;
  var r =
    matcher === "lookup"
      ? LookupMatcher(availableLocales, requestedLocales)
      : BestFitMatcher(availableLocales, requestedLocales);
  var foundLocale = r.locale;
  var extension = r.extension;
  var result = std_Object_create(null);
  result.dataLocale = foundLocale;
  var supportedExtension = "-u";
  var localeDataProvider = localeData();
  for (var i = 0; i < relevantExtensionKeys.length; i++) {
    var key = relevantExtensionKeys[i];
    var keyLocaleData = undefined;
    var value = undefined;
    var supportedExtensionAddition = "";
    if (extension !== undefined) {
      var requestedValue = UnicodeExtensionValue(extension, key);
      if (requestedValue !== undefined) {
        keyLocaleData = callFunction(
          localeDataProvider[key],
          null,
          foundLocale
        );
        if (requestedValue !== "") {
          if (
            callFunction(std_Array_indexOf, keyLocaleData, requestedValue) !==
            -1
          ) {
            value = requestedValue;
            supportedExtensionAddition = "-" + key + "-" + value;
          }
        } else {
          if (callFunction(std_Array_indexOf, keyLocaleData, "true") !== -1) {
            value = "true";
            supportedExtensionAddition = "-" + key;
          }
        }
      }
    }
    var optionsValue = options[key];
    ;
     ;
    if (optionsValue !== undefined && optionsValue !== value) {
      if (keyLocaleData === undefined) {
        keyLocaleData = callFunction(
          localeDataProvider[key],
          null,
          foundLocale
        );
      }
      if (callFunction(std_Array_indexOf, keyLocaleData, optionsValue) !== -1) {
        value = optionsValue;
        supportedExtensionAddition = "";
      }
    }
    if (value === undefined) {
      value =
        keyLocaleData === undefined
          ? callFunction(localeDataProvider.default[key], null, foundLocale)
          : keyLocaleData[0];
    }
    ;
     ;
    result[key] = value;
    supportedExtension += supportedExtensionAddition;
  }
  if (supportedExtension.length > 2) {
    foundLocale = addUnicodeExtension(foundLocale, supportedExtension);
  }
  result.locale = foundLocale;
  return result;
}
function addUnicodeExtension(locale, extension) {
  ;;
  ;
   ;
  ;
   ;
  ;;
  ;
   ;
  var privateIndex = callFunction(std_String_indexOf, locale, "-x-");
  if (privateIndex === -1) {
    locale += extension;
  } else {
    var preExtension = callFunction(String_substring, locale, 0, privateIndex);
    var postExtension = callFunction(String_substring, locale, privateIndex);
    locale = preExtension + extension + postExtension;
  }
  ;;
  return locale;
}
function LookupSupportedLocales(availableLocales, requestedLocales) {
  var subset = [];
  for (var i = 0; i < requestedLocales.length; i++) {
    var locale = requestedLocales[i];
    var noExtensionsLocale = removeUnicodeExtensions(locale);
    var availableLocale = BestAvailableLocale(
      availableLocales,
      noExtensionsLocale
    );
    if (availableLocale !== undefined) {
      DefineDataProperty(subset, subset.length, locale);
    }
  }
  return subset;
}
function BestFitSupportedLocales(availableLocales, requestedLocales) {
  return LookupSupportedLocales(availableLocales, requestedLocales);
}
function SupportedLocales(availableLocales, requestedLocales, options) {
  var matcher;
  if (options !== undefined) {
    options = ToObject(options);
    matcher = options.localeMatcher;
    if (matcher !== undefined) {
      matcher = ToString(matcher);
      if (matcher !== "lookup" && matcher !== "best fit") {
        ThrowRangeError(539, matcher);
      }
    }
  }
  return matcher === undefined || matcher === "best fit"
    ? BestFitSupportedLocales(availableLocales, requestedLocales)
    : LookupSupportedLocales(availableLocales, requestedLocales);
}
function GetOption(options, property, type, values, fallback) {
  var value = options[property];
  if (value !== undefined) {
    if (type === "boolean") {
      value = !!value;
    } else if (type === "string") {
      value = ToString(value);
    } else {
      ;;
    }
    if (
      values !== undefined &&
      callFunction(std_Array_indexOf, values, value) === -1
    ) {
      ThrowRangeError(540, property, `"${value}"`);
    }
    return value;
  }
  return fallback;
}
function GetStringOrBooleanOption(
  options,
  property,
  stringValues,
  fallback
) {
  ;;
  var value = options[property];
  if (value === undefined) {
    return fallback;
  }
  if (value === true) {
    return true;
  }
  if (!value) {
    return false;
  }
  value = ToString(value);
  if (callFunction(std_Array_indexOf, stringValues, value) === -1) {
    ThrowRangeError(540, property, `"${value}"`);
  }
  return value;
}
function DefaultNumberOption(value, minimum, maximum, fallback) {
  ;
   ;
  ;
   ;
  ;
   ;
  ;
   ;
  if (value === undefined) {
    return fallback;
  }
  value = +value;
  if (Number_isNaN(value) || value < minimum || value > maximum) {
    ThrowRangeError(535, value);
  }
  return std_Math_floor(value) | 0;
}
function GetNumberOption(options, property, minimum, maximum, fallback) {
  return DefaultNumberOption(options[property], minimum, maximum, fallback);
}
var intlFallbackSymbolHolder = { value: undefined };
function intlFallbackSymbol() {
  var fallbackSymbol = intlFallbackSymbolHolder.value;
  if (!fallbackSymbol) {
    var Symbol = GetBuiltinConstructor("Symbol");
    fallbackSymbol = Symbol("IntlLegacyConstructedSymbol");
    intlFallbackSymbolHolder.value = fallbackSymbol;
  }
  return fallbackSymbol;
}
function initializeIntlObject(obj, type, lazyData) {
  ;;
  ;
   ;
  ;;
  var internals = std_Object_create(null);
  internals.type = type;
  internals.lazyData = lazyData;
  internals.internalProps = null;
  ;
   ;
  UnsafeSetReservedSlot(obj, 0, internals);
}
function setInternalProperties(internals, internalProps) {
  ;;
  ;;
  internals.internalProps = internalProps;
  internals.lazyData = null;
}
function maybeInternalProperties(internals) {
  ;;
  var lazyData = internals.lazyData;
  if (lazyData) {
    return null;
  }
  ;
   ;
  return internals.internalProps;
}
function getIntlObjectInternals(obj) {
  ;;
  ;
   ;
  var internals = UnsafeGetReservedSlot(obj, 0);
  ;;
  ;;
  ;
   ;
  ;;
  ;;
  return internals;
}
function getInternals(obj) {
  var internals = getIntlObjectInternals(obj);
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  var type = internals.type;
  if (type === "Collator") {
    internalProps = resolveCollatorInternals(internals.lazyData);
  } else if (type === "DateTimeFormat") {
    internalProps = resolveDateTimeFormatInternals(internals.lazyData);
  } else if (type === "DisplayNames") {
    internalProps = resolveDisplayNamesInternals(internals.lazyData);
  } else if (type === "DurationFormat") {
    internalProps = resolveDurationFormatInternals(internals.lazyData);
  } else if (type === "ListFormat") {
    internalProps = resolveListFormatInternals(internals.lazyData);
  } else if (type === "NumberFormat") {
    internalProps = resolveNumberFormatInternals(internals.lazyData);
  } else if (type === "PluralRules") {
    internalProps = resolvePluralRulesInternals(internals.lazyData);
  } else if (type === "RelativeTimeFormat") {
    internalProps = resolveRelativeTimeFormatInternals(internals.lazyData);
  } else {
    ;;
    internalProps = resolveSegmenterInternals(internals.lazyData);
  }
  setInternalProperties(internals, internalProps);
  return internalProps;
}
var currencyDigits = {
  BHD: 3,
  BIF: 0,
  CLF: 4,
  CLP: 0,
  DJF: 0,
  GNF: 0,
  IQD: 3,
  ISK: 0,
  JOD: 3,
  JPY: 0,
  KMF: 0,
  KRW: 0,
  KWD: 3,
  LYD: 3,
  OMR: 3,
  PYG: 0,
  RWF: 0,
  TND: 3,
  UGX: 0,
  UYI: 0,
  UYW: 4,
  VND: 0,
  VUV: 0,
  XAF: 0,
  XOF: 0,
  XPF: 0,
};
function resolveDateTimeFormatInternals(lazyDateTimeFormatData) {
  ;;
  var internalProps = std_Object_create(null);
  var DateTimeFormat = dateTimeFormatInternalProperties;
  var localeData = DateTimeFormat.localeData;
  var r = ResolveLocale(
    "DateTimeFormat",
    lazyDateTimeFormatData.requestedLocales,
    lazyDateTimeFormatData.localeOpt,
    DateTimeFormat.relevantExtensionKeys,
    localeData
  );
  if (r.ca === "islamic") {
    ReportWarning(556);
    r.ca = "islamic-tbla";
  } else if (r.ca === "islamic-rgsa") {
    r.ca = "islamic-tbla";
  }
  internalProps.locale = r.locale;
  internalProps.calendar = r.ca;
  internalProps.numberingSystem = r.nu;
  var formatOptions = lazyDateTimeFormatData.formatOptions;
  if (r.hc !== null && formatOptions.hour12 === undefined) {
    formatOptions.hourCycle = r.hc;
  }
  internalProps.timeZone = lazyDateTimeFormatData.timeZone;
  if (lazyDateTimeFormatData.patternOption !== undefined) {
    internalProps.pattern = lazyDateTimeFormatData.patternOption;
  } else if (
    lazyDateTimeFormatData.dateStyle !== undefined ||
    lazyDateTimeFormatData.timeStyle !== undefined
  ) {
    internalProps.hourCycle = formatOptions.hourCycle;
    internalProps.hour12 = formatOptions.hour12;
    internalProps.dateStyle = lazyDateTimeFormatData.dateStyle;
    internalProps.timeStyle = lazyDateTimeFormatData.timeStyle;
  } else {
    internalProps.required = lazyDateTimeFormatData.required;
    internalProps.defaults = lazyDateTimeFormatData.defaults;
    internalProps.hourCycle = formatOptions.hourCycle;
    internalProps.hour12 = formatOptions.hour12;
    internalProps.weekday = formatOptions.weekday;
    internalProps.era = formatOptions.era;
    internalProps.year = formatOptions.year;
    internalProps.month = formatOptions.month;
    internalProps.day = formatOptions.day;
    internalProps.dayPeriod = formatOptions.dayPeriod;
    internalProps.hour = formatOptions.hour;
    internalProps.minute = formatOptions.minute;
    internalProps.second = formatOptions.second;
    internalProps.fractionalSecondDigits = formatOptions.fractionalSecondDigits;
    internalProps.timeZoneName = formatOptions.timeZoneName;
  }
  return internalProps;
}
function getDateTimeFormatInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveDateTimeFormatInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function UnwrapDateTimeFormat(dtf) {
  if (
    IsObject(dtf) &&
    intl_GuardToDateTimeFormat(dtf) === null &&
    !intl_IsWrappedDateTimeFormat(dtf) &&
    callFunction(
      std_Object_isPrototypeOf,
      GetBuiltinPrototype("DateTimeFormat"),
      dtf
    )
  ) {
    dtf = dtf[intlFallbackSymbol()];
  }
  return dtf;
}
function InitializeDateTimeFormat(
  dateTimeFormat,
  thisValue,
  locales,
  options,
  required,
  defaults,
  toLocaleStringTimeZone,
  mozExtensions
) {
  ;
   ;
  ;
   ;
  ;
   ;
  ;
   ;
  ;
   ;
  var lazyDateTimeFormatData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyDateTimeFormatData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else {
    options = ToObject(options);
  }
  var localeOpt = std_Object_create(null);
  lazyDateTimeFormatData.localeOpt = localeOpt;
  var localeMatcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  localeOpt.localeMatcher = localeMatcher;
  var calendar = GetOption(options, "calendar", "string", undefined, undefined);
  if (calendar !== undefined) {
    calendar = intl_ValidateAndCanonicalizeUnicodeExtensionType(
      calendar,
      "calendar",
      "ca"
    );
  }
  localeOpt.ca = calendar;
  var numberingSystem = GetOption(
    options,
    "numberingSystem",
    "string",
    undefined,
    undefined
  );
  if (numberingSystem !== undefined) {
    numberingSystem = intl_ValidateAndCanonicalizeUnicodeExtensionType(
      numberingSystem,
      "numberingSystem",
      "nu"
    );
  }
  localeOpt.nu = numberingSystem;
  var hour12 = GetOption(options, "hour12", "boolean", undefined, undefined);
  var hourCycle = GetOption(
    options,
    "hourCycle",
    "string",
    ["h11", "h12", "h23", "h24"],
    undefined
  );
  if (hour12 !== undefined) {
    hourCycle = null;
  }
  localeOpt.hc = hourCycle;
  var timeZone = options.timeZone;
  if (timeZone === undefined) {
    if (toLocaleStringTimeZone !== undefined) {
      timeZone = toLocaleStringTimeZone;
    } else {
      timeZone = intl_DefaultTimeZone();
    }
  } else {
    if (toLocaleStringTimeZone !== undefined) {
      ThrowTypeError(
        541,
        "timeZone",
        "Temporal.ZonedDateTime.toLocaleString"
      );
    }
    timeZone = ToString(timeZone);
    timeZone = intl_ValidateAndCanonicalizeTimeZone(timeZone);
  }
  lazyDateTimeFormatData.timeZone = timeZone;
  var formatOptions = std_Object_create(null);
  lazyDateTimeFormatData.formatOptions = formatOptions;
  if (mozExtensions) {
    var pattern = GetOption(options, "pattern", "string", undefined, undefined);
    lazyDateTimeFormatData.patternOption = pattern;
  }
  if (hour12 !== undefined) {
    formatOptions.hour12 = hour12;
  }
  formatOptions.weekday = GetOption(
    options,
    "weekday",
    "string",
    ["narrow", "short", "long"],
    undefined
  );
  formatOptions.era = GetOption(
    options,
    "era",
    "string",
    ["narrow", "short", "long"],
    undefined
  );
  formatOptions.year = GetOption(
    options,
    "year",
    "string",
    ["2-digit", "numeric"],
    undefined
  );
  formatOptions.month = GetOption(
    options,
    "month",
    "string",
    ["2-digit", "numeric", "narrow", "short", "long"],
    undefined
  );
  formatOptions.day = GetOption(
    options,
    "day",
    "string",
    ["2-digit", "numeric"],
    undefined
  );
  formatOptions.dayPeriod = GetOption(
    options,
    "dayPeriod",
    "string",
    ["narrow", "short", "long"],
    undefined
  );
  formatOptions.hour = GetOption(
    options,
    "hour",
    "string",
    ["2-digit", "numeric"],
    undefined
  );
  formatOptions.minute = GetOption(
    options,
    "minute",
    "string",
    ["2-digit", "numeric"],
    undefined
  );
  formatOptions.second = GetOption(
    options,
    "second",
    "string",
    ["2-digit", "numeric"],
    undefined
  );
  formatOptions.fractionalSecondDigits = GetNumberOption(
    options,
    "fractionalSecondDigits",
    1,
    3,
    undefined
  );
  formatOptions.timeZoneName = GetOption(
    options,
    "timeZoneName",
    "string",
    [
      "short",
      "long",
      "shortOffset",
      "longOffset",
      "shortGeneric",
      "longGeneric",
    ],
    undefined
  );
  var formatMatcher = GetOption(
    options,
    "formatMatcher",
    "string",
    ["basic", "best fit"],
    "best fit"
  );
  void formatMatcher;
  var dateStyle = GetOption(
    options,
    "dateStyle",
    "string",
    ["full", "long", "medium", "short"],
    undefined
  );
  lazyDateTimeFormatData.dateStyle = dateStyle;
  var timeStyle = GetOption(
    options,
    "timeStyle",
    "string",
    ["full", "long", "medium", "short"],
    undefined
  );
  lazyDateTimeFormatData.timeStyle = timeStyle;
  if (dateStyle !== undefined || timeStyle !== undefined) {
    var explicitFormatComponent =
      formatOptions.weekday !== undefined
        ? "weekday"
        : formatOptions.era !== undefined
        ? "era"
        : formatOptions.year !== undefined
        ? "year"
        : formatOptions.month !== undefined
        ? "month"
        : formatOptions.day !== undefined
        ? "day"
        : formatOptions.dayPeriod !== undefined
        ? "dayPeriod"
        : formatOptions.hour !== undefined
        ? "hour"
        : formatOptions.minute !== undefined
        ? "minute"
        : formatOptions.second !== undefined
        ? "second"
        : formatOptions.fractionalSecondDigits !== undefined
        ? "fractionalSecondDigits"
        : formatOptions.timeZoneName !== undefined
        ? "timeZoneName"
        : undefined;
    if (explicitFormatComponent !== undefined) {
      ThrowTypeError(
        541,
        explicitFormatComponent,
        dateStyle !== undefined ? "dateStyle" : "timeStyle"
      );
    }
    if (required === "date" && timeStyle !== undefined) {
      ThrowTypeError(542, "timeStyle", "date");
    }
    if (required === "time" && dateStyle !== undefined) {
      ThrowTypeError(542, "dateStyle", "time");
    }
  } else {
    lazyDateTimeFormatData.required = required;
    lazyDateTimeFormatData.defaults = defaults;
  }
  initializeIntlObject(
    dateTimeFormat,
    "DateTimeFormat",
    lazyDateTimeFormatData
  );
  if (
    dateTimeFormat !== thisValue &&
    callFunction(
      std_Object_isPrototypeOf,
      GetBuiltinPrototype("DateTimeFormat"),
      thisValue
    )
  ) {
    DefineDataProperty(
      thisValue,
      intlFallbackSymbol(),
      dateTimeFormat,
      0x08 | 0x10 | 0x20
    );
    return thisValue;
  }
  return dateTimeFormat;
}
function Intl_DateTimeFormat_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "DateTimeFormat";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
var dateTimeFormatInternalProperties = {
  localeData: dateTimeFormatLocaleData,
  relevantExtensionKeys: ["ca", "hc", "nu"],
};
function dateTimeFormatLocaleData() {
  return {
    ca: intl_availableCalendars,
    nu: getNumberingSystems,
    hc: () => {
      return [null, "h11", "h12", "h23", "h24"];
    },
    default: {
      ca: intl_defaultCalendar,
      nu: intl_numberingSystem,
      hc: () => {
        return null;
      },
    },
  };
}
function createDateTimeFormatFormat(dtf) {
  return function(date) {
    ;;
    ;
     ;
    return intl_FormatDateTime(dtf, date, false);
  };
}
function $Intl_DateTimeFormat_format_get() {
  var thisArg = UnwrapDateTimeFormat(this);
  var dtf = thisArg;
  if (!IsObject(dtf) || (dtf = intl_GuardToDateTimeFormat(dtf)) === null) {
    return callFunction(
      intl_CallDateTimeFormatMethodIfWrapped,
      thisArg,
      "$Intl_DateTimeFormat_format_get"
    );
  }
  var internals = getDateTimeFormatInternals(dtf);
  if (internals.boundFormat === undefined) {
    internals.boundFormat = createDateTimeFormatFormat(dtf);
  }
  return internals.boundFormat;
}
SetCanonicalName($Intl_DateTimeFormat_format_get, "get format");
function Intl_DateTimeFormat_formatToParts(date) {
  var dtf = this;
  if (!IsObject(dtf) || (dtf = intl_GuardToDateTimeFormat(dtf)) === null) {
    return callFunction(
      intl_CallDateTimeFormatMethodIfWrapped,
      this,
      date,
      "Intl_DateTimeFormat_formatToParts"
    );
  }
  getDateTimeFormatInternals(dtf);
  return intl_FormatDateTime(dtf, date, true);
}
function Intl_DateTimeFormat_formatRange(startDate, endDate) {
  var dtf = this;
  if (!IsObject(dtf) || (dtf = intl_GuardToDateTimeFormat(dtf)) === null) {
    return callFunction(
      intl_CallDateTimeFormatMethodIfWrapped,
      this,
      startDate,
      endDate,
      "Intl_DateTimeFormat_formatRange"
    );
  }
  if (startDate === undefined || endDate === undefined) {
    ThrowTypeError(
      545,
      startDate === undefined ? "start" : "end",
      "formatRange"
    );
  }
  getDateTimeFormatInternals(dtf);
  return intl_FormatDateTimeRange(dtf, startDate, endDate, false);
}
function Intl_DateTimeFormat_formatRangeToParts(startDate, endDate) {
  var dtf = this;
  if (!IsObject(dtf) || (dtf = intl_GuardToDateTimeFormat(dtf)) === null) {
    return callFunction(
      intl_CallDateTimeFormatMethodIfWrapped,
      this,
      startDate,
      endDate,
      "Intl_DateTimeFormat_formatRangeToParts"
    );
  }
  if (startDate === undefined || endDate === undefined) {
    ThrowTypeError(
      545,
      startDate === undefined ? "start" : "end",
      "formatRangeToParts"
    );
  }
  getDateTimeFormatInternals(dtf);
  return intl_FormatDateTimeRange(dtf, startDate, endDate, true);
}
function Intl_DateTimeFormat_resolvedOptions() {
  var thisArg = UnwrapDateTimeFormat(this);
  var dtf = thisArg;
  if (!IsObject(dtf) || (dtf = intl_GuardToDateTimeFormat(dtf)) === null) {
    return callFunction(
      intl_CallDateTimeFormatMethodIfWrapped,
      thisArg,
      "Intl_DateTimeFormat_resolvedOptions"
    );
  }
  var internals = getDateTimeFormatInternals(dtf);
  var result = {
    locale: internals.locale,
    calendar: internals.calendar,
    numberingSystem: internals.numberingSystem,
    timeZone: internals.timeZone,
  };
  if (internals.pattern !== undefined) {
    DefineDataProperty(result, "pattern", internals.pattern);
  }
  var hasDateStyle = internals.dateStyle !== undefined;
  var hasTimeStyle = internals.timeStyle !== undefined;
  if (hasDateStyle || hasTimeStyle) {
    if (hasTimeStyle) {
      intl_resolveDateTimeFormatComponents(
        dtf,
        result,
                                      false
      );
    }
    if (hasDateStyle) {
      DefineDataProperty(result, "dateStyle", internals.dateStyle);
    }
    if (hasTimeStyle) {
      DefineDataProperty(result, "timeStyle", internals.timeStyle);
    }
  } else {
    intl_resolveDateTimeFormatComponents(
      dtf,
      result,
                                    true
    );
  }
  return result;
}
function displayNamesLocaleData() {
  return {};
}
var displayNamesInternalProperties = {
  localeData: displayNamesLocaleData,
  relevantExtensionKeys: [],
};
function mozDisplayNamesLocaleData() {
  return {
    ca: intl_availableCalendars,
    default: {
      ca: intl_defaultCalendar,
    },
  };
}
var mozDisplayNamesInternalProperties = {
  localeData: mozDisplayNamesLocaleData,
  relevantExtensionKeys: ["ca"],
};
function resolveDisplayNamesInternals(lazyDisplayNamesData) {
  ;;
  var internalProps = std_Object_create(null);
  var mozExtensions = lazyDisplayNamesData.mozExtensions;
  var DisplayNames = mozExtensions
    ? mozDisplayNamesInternalProperties
    : displayNamesInternalProperties;
  var localeData = DisplayNames.localeData;
  var r = ResolveLocale(
    "DisplayNames",
    lazyDisplayNamesData.requestedLocales,
    lazyDisplayNamesData.opt,
    DisplayNames.relevantExtensionKeys,
    localeData
  );
  internalProps.style = lazyDisplayNamesData.style;
  var type = lazyDisplayNamesData.type;
  internalProps.type = type;
  internalProps.fallback = lazyDisplayNamesData.fallback;
  internalProps.locale = r.locale;
  if (type === "language") {
    internalProps.languageDisplay = lazyDisplayNamesData.languageDisplay;
  }
  if (mozExtensions) {
    internalProps.calendar = r.ca;
  }
  return internalProps;
}
function getDisplayNamesInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveDisplayNamesInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function InitializeDisplayNames(displayNames, locales, options, mozExtensions) {
  ;
   ;
  ;
   ;
  var lazyDisplayNamesData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyDisplayNamesData.requestedLocales = requestedLocales;
  if (!IsObject(options)) {
    ThrowTypeError(
      56,
      options === null ? "null" : typeof options
    );
  }
  var opt = std_Object_create(null);
  lazyDisplayNamesData.opt = opt;
  lazyDisplayNamesData.mozExtensions = mozExtensions;
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  opt.localeMatcher = matcher;
  if (mozExtensions) {
    var calendar = GetOption(
      options,
      "calendar",
      "string",
      undefined,
      undefined
    );
    if (calendar !== undefined) {
      calendar = intl_ValidateAndCanonicalizeUnicodeExtensionType(
        calendar,
        "calendar",
        "ca"
      );
    }
    opt.ca = calendar;
  }
  var style;
  if (mozExtensions) {
    style = GetOption(
      options,
      "style",
      "string",
      ["narrow", "short", "abbreviated", "long"],
      "long"
    );
  } else {
    style = GetOption(
      options,
      "style",
      "string",
      ["narrow", "short", "long"],
      "long"
    );
  }
  lazyDisplayNamesData.style = style;
  var type;
  if (mozExtensions) {
    type = GetOption(
      options,
      "type",
      "string",
      [
        "language",
        "region",
        "script",
        "currency",
        "calendar",
        "dateTimeField",
        "weekday",
        "month",
        "quarter",
        "dayPeriod",
      ],
      undefined
    );
  } else {
    type = GetOption(
      options,
      "type",
      "string",
      ["language", "region", "script", "currency", "calendar", "dateTimeField"],
      undefined
    );
  }
  if (type === undefined) {
    ThrowTypeError(547);
  }
  lazyDisplayNamesData.type = type;
  var fallback = GetOption(
    options,
    "fallback",
    "string",
    ["code", "none"],
    "code"
  );
  lazyDisplayNamesData.fallback = fallback;
  var languageDisplay = GetOption(
    options,
    "languageDisplay",
    "string",
    ["dialect", "standard"],
    "dialect"
  );
  if (type === "language") {
    lazyDisplayNamesData.languageDisplay = languageDisplay;
  }
  initializeIntlObject(displayNames, "DisplayNames", lazyDisplayNamesData);
}
function Intl_DisplayNames_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "DisplayNames";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
function Intl_DisplayNames_of(code) {
  var displayNames = this;
  if (
    !IsObject(displayNames) ||
    (displayNames = intl_GuardToDisplayNames(displayNames)) === null
  ) {
    return callFunction(
      intl_CallDisplayNamesMethodIfWrapped,
      this,
      "Intl_DisplayNames_of"
    );
  }
  code = ToString(code);
  var internals = getDisplayNamesInternals(displayNames);
  var {
    locale,
    calendar = "",
    style,
    type,
    languageDisplay = "",
    fallback,
  } = internals;
  return intl_ComputeDisplayName(
    displayNames,
    locale,
    calendar,
    style,
    languageDisplay,
    fallback,
    type,
    code
  );
}
function Intl_DisplayNames_resolvedOptions() {
  var displayNames = this;
  if (
    !IsObject(displayNames) ||
    (displayNames = intl_GuardToDisplayNames(displayNames)) === null
  ) {
    return callFunction(
      intl_CallDisplayNamesMethodIfWrapped,
      this,
      "Intl_DisplayNames_resolvedOptions"
    );
  }
  var internals = getDisplayNamesInternals(displayNames);
  var options = {
    locale: internals.locale,
    style: internals.style,
    type: internals.type,
    fallback: internals.fallback,
  };
  ;
   ;
  if (hasOwn("languageDisplay", internals)) {
    DefineDataProperty(options, "languageDisplay", internals.languageDisplay);
  }
  if (hasOwn("calendar", internals)) {
    DefineDataProperty(options, "calendar", internals.calendar);
  }
  return options;
}
function durationFormatLocaleData() {
  return {
    nu: getNumberingSystems,
    default: {
      nu: intl_numberingSystem,
    },
  };
}
var durationFormatInternalProperties = {
  localeData: durationFormatLocaleData,
  relevantExtensionKeys: ["nu"],
};
function resolveDurationFormatInternals(lazyDurationFormatData) {
  ;;
  var internalProps = std_Object_create(null);
  var DurationFormat = durationFormatInternalProperties;
  var r = ResolveLocale(
    "DurationFormat",
    lazyDurationFormatData.requestedLocales,
    lazyDurationFormatData.opt,
    DurationFormat.relevantExtensionKeys,
    DurationFormat.localeData
  );
  internalProps.locale = r.locale;
  internalProps.numberingSystem = r.nu;
  internalProps.style = lazyDurationFormatData.style;
  internalProps.yearsStyle = lazyDurationFormatData.yearsStyle;
  internalProps.yearsDisplay = lazyDurationFormatData.yearsDisplay;
  internalProps.weeksStyle = lazyDurationFormatData.weeksStyle;
  internalProps.weeksDisplay = lazyDurationFormatData.weeksDisplay;
  internalProps.monthsStyle = lazyDurationFormatData.monthsStyle;
  internalProps.monthsDisplay = lazyDurationFormatData.monthsDisplay;
  internalProps.daysStyle = lazyDurationFormatData.daysStyle;
  internalProps.daysDisplay = lazyDurationFormatData.daysDisplay;
  internalProps.hoursStyle = lazyDurationFormatData.hoursStyle;
  internalProps.hoursDisplay = lazyDurationFormatData.hoursDisplay;
  internalProps.minutesStyle = lazyDurationFormatData.minutesStyle;
  internalProps.minutesDisplay = lazyDurationFormatData.minutesDisplay;
  internalProps.secondsStyle = lazyDurationFormatData.secondsStyle;
  internalProps.secondsDisplay = lazyDurationFormatData.secondsDisplay;
  internalProps.millisecondsStyle = lazyDurationFormatData.millisecondsStyle;
  internalProps.millisecondsDisplay =
    lazyDurationFormatData.millisecondsDisplay;
  internalProps.microsecondsStyle = lazyDurationFormatData.microsecondsStyle;
  internalProps.microsecondsDisplay =
    lazyDurationFormatData.microsecondsDisplay;
  internalProps.nanosecondsStyle = lazyDurationFormatData.nanosecondsStyle;
  internalProps.nanosecondsDisplay = lazyDurationFormatData.nanosecondsDisplay;
  internalProps.fractionalDigits = lazyDurationFormatData.fractionalDigits;
  return internalProps;
}
function getDurationFormatInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveDurationFormatInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function InitializeDurationFormat(durationFormat, locales, options) {
  ;
   ;
  ;
   ;
  var lazyDurationFormatData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyDurationFormatData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else if (!IsObject(options)) {
    ThrowTypeError(
      56,
      options === null ? "null" : typeof options
    );
  }
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  var numberingSystem = GetOption(
    options,
    "numberingSystem",
    "string",
    undefined,
    undefined
  );
  if (numberingSystem !== undefined) {
    numberingSystem = intl_ValidateAndCanonicalizeUnicodeExtensionType(
      numberingSystem,
      "numberingSystem",
      "nu"
    );
  }
  var opt = std_Object_create(null);
  opt.localeMatcher = matcher;
  opt.nu = numberingSystem;
  lazyDurationFormatData.opt = opt;
  var style = GetOption(
    options,
    "style",
    "string",
    ["long", "short", "narrow", "digital"],
    "short"
  );
  lazyDurationFormatData.style = style;
  var yearsOptions = GetDurationUnitOptions(
    "years",
    options,
    style,
    ["long", "short", "narrow"],
    "short",
                     ""
  );
  lazyDurationFormatData.yearsStyle = yearsOptions.style;
  lazyDurationFormatData.yearsDisplay = yearsOptions.display;
  var monthsOptions = GetDurationUnitOptions(
    "months",
    options,
    style,
    ["long", "short", "narrow"],
    "short",
                     ""
  );
  lazyDurationFormatData.monthsStyle = monthsOptions.style;
  lazyDurationFormatData.monthsDisplay = monthsOptions.display;
  var weeksOptions = GetDurationUnitOptions(
    "weeks",
    options,
    style,
    ["long", "short", "narrow"],
    "short",
                     ""
  );
  lazyDurationFormatData.weeksStyle = weeksOptions.style;
  lazyDurationFormatData.weeksDisplay = weeksOptions.display;
  var daysOptions = GetDurationUnitOptions(
    "days",
    options,
    style,
    ["long", "short", "narrow"],
    "short",
                     ""
  );
  lazyDurationFormatData.daysStyle = daysOptions.style;
  lazyDurationFormatData.daysDisplay = daysOptions.display;
  var hoursOptions = GetDurationUnitOptions(
    "hours",
    options,
    style,
    ["long", "short", "narrow", "numeric", "2-digit"],
    "numeric",
                     ""
  );
  lazyDurationFormatData.hoursStyle = hoursOptions.style;
  lazyDurationFormatData.hoursDisplay = hoursOptions.display;
  var minutesOptions = GetDurationUnitOptions(
    "minutes",
    options,
    style,
    ["long", "short", "narrow", "numeric", "2-digit"],
    "numeric",
    hoursOptions.style
  );
  lazyDurationFormatData.minutesStyle = minutesOptions.style;
  lazyDurationFormatData.minutesDisplay = minutesOptions.display;
  var secondsOptions = GetDurationUnitOptions(
    "seconds",
    options,
    style,
    ["long", "short", "narrow", "numeric", "2-digit"],
    "numeric",
    minutesOptions.style
  );
  lazyDurationFormatData.secondsStyle = secondsOptions.style;
  lazyDurationFormatData.secondsDisplay = secondsOptions.display;
  var millisecondsOptions = GetDurationUnitOptions(
    "milliseconds",
    options,
    style,
    ["long", "short", "narrow", "numeric"],
    "numeric",
    secondsOptions.style
  );
  lazyDurationFormatData.millisecondsStyle = millisecondsOptions.style;
  lazyDurationFormatData.millisecondsDisplay = millisecondsOptions.display;
  var microsecondsOptions = GetDurationUnitOptions(
    "microseconds",
    options,
    style,
    ["long", "short", "narrow", "numeric"],
    "numeric",
    millisecondsOptions.style
  );
  lazyDurationFormatData.microsecondsStyle = microsecondsOptions.style;
  lazyDurationFormatData.microsecondsDisplay = microsecondsOptions.display;
  var nanosecondsOptions = GetDurationUnitOptions(
    "nanoseconds",
    options,
    style,
    ["long", "short", "narrow", "numeric"],
    "numeric",
    microsecondsOptions.style
  );
  lazyDurationFormatData.nanosecondsStyle = nanosecondsOptions.style;
  lazyDurationFormatData.nanosecondsDisplay = nanosecondsOptions.display;
  lazyDurationFormatData.fractionalDigits = GetNumberOption(
    options,
    "fractionalDigits",
    0,
    9,
    undefined
  );
  initializeIntlObject(
    durationFormat,
    "DurationFormat",
    lazyDurationFormatData
  );
}
function GetDurationUnitOptions(
  unit,
  options,
  baseStyle,
  stylesList,
  digitalBase,
  prevStyle
) {
  ;;
  ;;
  ;;
  ;;
  ;;
  ;;
  var styleOption = GetOption(options, unit, "string", stylesList, undefined);
  var style = styleOption;
  var displayDefault = "always";
  if (style === undefined) {
    if (baseStyle === "digital") {
      if (unit !== "hours" && unit !== "minutes" && unit !== "seconds") {
        displayDefault = "auto";
      }
      style = digitalBase;
    } else {
      if (prevStyle === "numeric" || prevStyle === "2-digit") {
        if (unit !== "minutes" && unit !== "seconds") {
          displayDefault = "auto";
        }
        style = "numeric";
      } else {
        displayDefault = "auto";
        style = baseStyle;
      }
    }
  }
  var isFractional =
    style === "numeric" &&
    (unit === "milliseconds" ||
      unit === "microseconds" ||
      unit === "nanoseconds");
  if (isFractional) {
    displayDefault = "auto";
  }
  var displayField = unit + "Display";
  var displayOption = GetOption(
    options,
    displayField,
    "string",
    ["auto", "always"],
    undefined
  );
  var display = displayOption ?? displayDefault;
  if (display === "always" && isFractional) {
    ;
     ;
    ThrowRangeError(
      styleOption !== undefined && displayOption !== undefined
        ? 552
        : displayOption !== undefined
        ? 553
        : 554,
      unit
    );
  }
  if (prevStyle === "numeric" || prevStyle === "2-digit") {
    if (style !== "numeric" && style !== "2-digit") {
      ThrowRangeError(
        551,
        unit,
        `"${style}"`
      );
    }
    else if (unit === "minutes" || unit === "seconds") {
      style = "2-digit";
    }
  }
  return { style, display };
}
function Intl_DurationFormat_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "DurationFormat";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
function Intl_DurationFormat_resolvedOptions() {
  var durationFormat = this;
  if (
    !IsObject(durationFormat) ||
    (durationFormat = intl_GuardToDurationFormat(durationFormat)) === null
  ) {
    return callFunction(
      intl_CallDurationFormatMethodIfWrapped,
      this,
      "Intl_DurationFormat_resolvedOptions"
    );
  }
  var internals = getDurationFormatInternals(durationFormat);
  var result = {
    locale: internals.locale,
    numberingSystem: internals.numberingSystem,
    style: internals.style,
    years: internals.yearsStyle,
    yearsDisplay: internals.yearsDisplay,
    months: internals.monthsStyle,
    monthsDisplay: internals.monthsDisplay,
    weeks: internals.weeksStyle,
    weeksDisplay: internals.weeksDisplay,
    days: internals.daysStyle,
    daysDisplay: internals.daysDisplay,
    hours: internals.hoursStyle,
    hoursDisplay: internals.hoursDisplay,
    minutes: internals.minutesStyle,
    minutesDisplay: internals.minutesDisplay,
    seconds: internals.secondsStyle,
    secondsDisplay: internals.secondsDisplay,
    milliseconds: internals.millisecondsStyle,
    millisecondsDisplay: internals.millisecondsDisplay,
    microseconds: internals.microsecondsStyle,
    microsecondsDisplay: internals.microsecondsDisplay,
    nanoseconds: internals.nanosecondsStyle,
    nanosecondsDisplay: internals.nanosecondsDisplay,
  };
  if (internals.fractionalDigits !== undefined) {
    DefineDataProperty(result, "fractionalDigits", internals.fractionalDigits);
  }
  return result;
}
function Intl_getCanonicalLocales(locales) {
  return CanonicalizeLocaleList(locales);
}
function Intl_supportedValuesOf(key) {
  key = ToString(key);
  return intl_SupportedValuesOf(key);
}
function Intl_getCalendarInfo(locales) {
  var requestedLocales = CanonicalizeLocaleList(locales);
  var DateTimeFormat = dateTimeFormatInternalProperties;
  var localeData = DateTimeFormat.localeData;
  var localeOpt = std_Object_create(null);
  localeOpt.localeMatcher = "best fit";
  var r = ResolveLocale(
    "DateTimeFormat",
    requestedLocales,
    localeOpt,
    DateTimeFormat.relevantExtensionKeys,
    localeData
  );
  var result = intl_GetCalendarInfo(r.locale);
  DefineDataProperty(result, "calendar", r.ca);
  DefineDataProperty(result, "locale", r.locale);
  return result;
}
function listFormatLocaleData() {
  return {};
}
var listFormatInternalProperties = {
  localeData: listFormatLocaleData,
  relevantExtensionKeys: [],
};
function resolveListFormatInternals(lazyListFormatData) {
  ;;
  var internalProps = std_Object_create(null);
  var ListFormat = listFormatInternalProperties;
  var localeData = ListFormat.localeData;
  var r = ResolveLocale(
    "ListFormat",
    lazyListFormatData.requestedLocales,
    lazyListFormatData.opt,
    ListFormat.relevantExtensionKeys,
    localeData
  );
  internalProps.locale = r.locale;
  internalProps.type = lazyListFormatData.type;
  internalProps.style = lazyListFormatData.style;
  return internalProps;
}
function getListFormatInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveListFormatInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function InitializeListFormat(listFormat, locales, options) {
  ;;
  ;
   ;
  var lazyListFormatData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyListFormatData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else if (!IsObject(options)) {
    ThrowTypeError(
      56,
      options === null ? "null" : typeof options
    );
  }
  var opt = std_Object_create(null);
  lazyListFormatData.opt = opt;
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  opt.localeMatcher = matcher;
  var type = GetOption(
    options,
    "type",
    "string",
    ["conjunction", "disjunction", "unit"],
    "conjunction"
  );
  lazyListFormatData.type = type;
  var style = GetOption(
    options,
    "style",
    "string",
    ["long", "short", "narrow"],
    "long"
  );
  lazyListFormatData.style = style;
  initializeIntlObject(listFormat, "ListFormat", lazyListFormatData);
}
function Intl_ListFormat_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "ListFormat";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
function StringListFromIterable(iterable, methodName) {
  if (iterable === undefined) {
    return [];
  }
  var list = [];
  for (var element of allowContentIter(iterable)) {
    if (typeof element !== "string") {
      ThrowTypeError(
        70,
        methodName,
        "string",
        typeof element
      );
    }
    DefineDataProperty(list, list.length, element);
  }
  return list;
}
function Intl_ListFormat_format(list) {
  var listFormat = this;
  if (
    !IsObject(listFormat) ||
    (listFormat = intl_GuardToListFormat(listFormat)) === null
  ) {
    return callFunction(
      intl_CallListFormatMethodIfWrapped,
      this,
      list,
      "Intl_ListFormat_format"
    );
  }
  var stringList = StringListFromIterable(list, "format");
  if (stringList.length < 2) {
    return stringList.length === 0 ? "" : stringList[0];
  }
  getListFormatInternals(listFormat);
  return intl_FormatList(listFormat, stringList, false);
}
function Intl_ListFormat_formatToParts(list) {
  var listFormat = this;
  if (
    !IsObject(listFormat) ||
    (listFormat = intl_GuardToListFormat(listFormat)) === null
  ) {
    return callFunction(
      intl_CallListFormatMethodIfWrapped,
      this,
      list,
      "Intl_ListFormat_formatToParts"
    );
  }
  var stringList = StringListFromIterable(list, "formatToParts");
  if (stringList.length < 2) {
    return stringList.length === 0
      ? []
      : [{ type: "element", value: stringList[0] }];
  }
  getListFormatInternals(listFormat);
  return intl_FormatList(listFormat, stringList, true);
}
function Intl_ListFormat_resolvedOptions() {
  var listFormat = this;
  if (
    !IsObject(listFormat) ||
    (listFormat = intl_GuardToListFormat(listFormat)) === null
  ) {
    return callFunction(
      intl_CallListFormatMethodIfWrapped,
      this,
      "Intl_ListFormat_resolvedOptions"
    );
  }
  var internals = getListFormatInternals(listFormat);
  var result = {
    locale: internals.locale,
    type: internals.type,
    style: internals.style,
  };
  return result;
}
var numberFormatInternalProperties = {
  localeData: numberFormatLocaleData,
  relevantExtensionKeys: ["nu"],
};
function resolveNumberFormatInternals(lazyNumberFormatData) {
  ;;
  var internalProps = std_Object_create(null);
  var NumberFormat = numberFormatInternalProperties;
  var r = ResolveLocale(
    "NumberFormat",
    lazyNumberFormatData.requestedLocales,
    lazyNumberFormatData.opt,
    NumberFormat.relevantExtensionKeys,
    NumberFormat.localeData
  );
  internalProps.locale = r.locale;
  internalProps.numberingSystem = r.nu;
  var style = lazyNumberFormatData.style;
  internalProps.style = style;
  if (style === "currency") {
    internalProps.currency = lazyNumberFormatData.currency;
    internalProps.currencyDisplay = lazyNumberFormatData.currencyDisplay;
    internalProps.currencySign = lazyNumberFormatData.currencySign;
  }
  if (style === "unit") {
    internalProps.unit = lazyNumberFormatData.unit;
    internalProps.unitDisplay = lazyNumberFormatData.unitDisplay;
  }
  var notation = lazyNumberFormatData.notation;
  internalProps.notation = notation;
  internalProps.minimumIntegerDigits =
    lazyNumberFormatData.minimumIntegerDigits;
  internalProps.roundingIncrement = lazyNumberFormatData.roundingIncrement;
  internalProps.roundingMode = lazyNumberFormatData.roundingMode;
  internalProps.trailingZeroDisplay = lazyNumberFormatData.trailingZeroDisplay;
  if ("minimumFractionDigits" in lazyNumberFormatData) {
    ;
     ;
    internalProps.minimumFractionDigits =
      lazyNumberFormatData.minimumFractionDigits;
    internalProps.maximumFractionDigits =
      lazyNumberFormatData.maximumFractionDigits;
  }
  if ("minimumSignificantDigits" in lazyNumberFormatData) {
    ;
     ;
    internalProps.minimumSignificantDigits =
      lazyNumberFormatData.minimumSignificantDigits;
    internalProps.maximumSignificantDigits =
      lazyNumberFormatData.maximumSignificantDigits;
  }
  internalProps.roundingPriority = lazyNumberFormatData.roundingPriority;
  if (notation === "compact") {
    internalProps.compactDisplay = lazyNumberFormatData.compactDisplay;
  }
  internalProps.useGrouping = lazyNumberFormatData.useGrouping;
  internalProps.signDisplay = lazyNumberFormatData.signDisplay;
  return internalProps;
}
function getNumberFormatInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveNumberFormatInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function UnwrapNumberFormat(nf) {
  if (
    IsObject(nf) &&
    intl_GuardToNumberFormat(nf) === null &&
    !intl_IsWrappedNumberFormat(nf) &&
    callFunction(
      std_Object_isPrototypeOf,
      GetBuiltinPrototype("NumberFormat"),
      nf
    )
  ) {
    return nf[intlFallbackSymbol()];
  }
  return nf;
}
function SetNumberFormatDigitOptions(
  lazyData,
  options,
  mnfdDefault,
  mxfdDefault,
  notation
) {
  ;;
  ;;
  ;;
  ;;
  ;;
  var mnid = GetNumberOption(options, "minimumIntegerDigits", 1, 21, 1);
  var mnfd = options.minimumFractionDigits;
  var mxfd = options.maximumFractionDigits;
  var mnsd = options.minimumSignificantDigits;
  var mxsd = options.maximumSignificantDigits;
  lazyData.minimumIntegerDigits = mnid;
  var roundingIncrement = GetNumberOption(
    options,
    "roundingIncrement",
    1,
    5000,
    1
  );
  switch (roundingIncrement) {
    case 1:
    case 2:
    case 5:
    case 10:
    case 20:
    case 25:
    case 50:
    case 100:
    case 200:
    case 250:
    case 500:
    case 1000:
    case 2000:
    case 2500:
    case 5000:
      break;
    default:
      ThrowRangeError(
        540,
        "roundingIncrement",
        roundingIncrement
      );
  }
  var roundingMode = GetOption(
    options,
    "roundingMode",
    "string",
    [
      "ceil",
      "floor",
      "expand",
      "trunc",
      "halfCeil",
      "halfFloor",
      "halfExpand",
      "halfTrunc",
      "halfEven",
    ],
    "halfExpand"
  );
  var roundingPriority = GetOption(
    options,
    "roundingPriority",
    "string",
    ["auto", "morePrecision", "lessPrecision"],
    "auto"
  );
  var trailingZeroDisplay = GetOption(
    options,
    "trailingZeroDisplay",
    "string",
    ["auto", "stripIfInteger"],
    "auto"
  );
  if (roundingIncrement !== 1) {
    mxfdDefault = mnfdDefault;
  }
  lazyData.roundingIncrement = roundingIncrement;
  lazyData.roundingMode = roundingMode;
  lazyData.trailingZeroDisplay = trailingZeroDisplay;
  var hasSignificantDigits = mnsd !== undefined || mxsd !== undefined;
  var hasFractionDigits = mnfd !== undefined || mxfd !== undefined;
  var needSignificantDigits =
    roundingPriority !== "auto" || hasSignificantDigits;
  var needFractionalDigits =
    roundingPriority !== "auto" ||
    !(hasSignificantDigits || (!hasFractionDigits && notation === "compact"));
  if (needSignificantDigits) {
    if (hasSignificantDigits) {
      mnsd = DefaultNumberOption(mnsd, 1, 21, 1);
      lazyData.minimumSignificantDigits = mnsd;
      mxsd = DefaultNumberOption(mxsd, mnsd, 21, 21);
      lazyData.maximumSignificantDigits = mxsd;
    } else {
      lazyData.minimumSignificantDigits = 1;
      lazyData.maximumSignificantDigits = 21;
    }
  }
  if (needFractionalDigits) {
    if (hasFractionDigits) {
      mnfd = DefaultNumberOption(mnfd, 0, 100, undefined);
      mxfd = DefaultNumberOption(mxfd, 0, 100, undefined);
      if (mnfd === undefined) {
        ;
         ;
        mnfd = std_Math_min(mnfdDefault, mxfd);
      }
      else if (mxfd === undefined) {
        mxfd = std_Math_max(mxfdDefault, mnfd);
      }
      else if (mnfd > mxfd) {
        ThrowRangeError(535, mxfd);
      }
      lazyData.minimumFractionDigits = mnfd;
      lazyData.maximumFractionDigits = mxfd;
    } else {
      lazyData.minimumFractionDigits = mnfdDefault;
      lazyData.maximumFractionDigits = mxfdDefault;
    }
  }
  if (!needSignificantDigits && !needFractionalDigits) {
    ;;
    ;
     ;
    ;
     ;
    lazyData.minimumFractionDigits = 0;
    lazyData.maximumFractionDigits = 0;
    lazyData.minimumSignificantDigits = 1;
    lazyData.maximumSignificantDigits = 2;
    lazyData.roundingPriority = "morePrecision";
  } else {
    lazyData.roundingPriority = roundingPriority;
  }
  if (roundingIncrement !== 1) {
    if (roundingPriority !== "auto") {
      ThrowTypeError(
        549,
        "roundingIncrement",
        "roundingPriority"
      );
    }
    if (hasSignificantDigits) {
      ThrowTypeError(
        549,
        "roundingIncrement",
        "minimumSignificantDigits"
      );
    }
    if (
      lazyData.minimumFractionDigits !==
      lazyData.maximumFractionDigits
    ) {
      ThrowRangeError(550);
    }
  }
}
function toASCIIUpperCase(s) {
  ;;
  var result = "";
  for (var i = 0; i < s.length; i++) {
    var c = callFunction(std_String_charCodeAt, s, i);
    result +=
      0x61 <= c && c <= 0x7a
        ? callFunction(std_String_fromCharCode, null, c & ~0x20)
        : s[i];
  }
  return result;
}
function IsWellFormedCurrencyCode(currency) {
  ;;
  return currency.length === 3 && IsASCIIAlphaString(currency);
}
function IsWellFormedUnitIdentifier(unitIdentifier) {
  ;
   ;
  if (IsSanctionedSimpleUnitIdentifier(unitIdentifier)) {
    return true;
  }
  var pos = callFunction(std_String_indexOf, unitIdentifier, "-per-");
  if (pos < 0) {
    return false;
  }
  var next = pos + "-per-".length;
  var numerator = Substring(unitIdentifier, 0, pos);
  var denominator = Substring(
    unitIdentifier,
    next,
    unitIdentifier.length - next
  );
  return (
    IsSanctionedSimpleUnitIdentifier(numerator) &&
    IsSanctionedSimpleUnitIdentifier(denominator)
  );
}
function IsSanctionedSimpleUnitIdentifier(unitIdentifier) {
  ;
   ;
  var isSanctioned = hasOwn(unitIdentifier, sanctionedSimpleUnitIdentifiers);
  return isSanctioned;
}
function InitializeNumberFormat(numberFormat, thisValue, locales, options) {
  ;
   ;
  ;
   ;
  var lazyNumberFormatData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyNumberFormatData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else {
    options = ToObject(options);
  }
  var opt = std_Object_create(null);
  lazyNumberFormatData.opt = opt;
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  opt.localeMatcher = matcher;
  var numberingSystem = GetOption(
    options,
    "numberingSystem",
    "string",
    undefined,
    undefined
  );
  if (numberingSystem !== undefined) {
    numberingSystem = intl_ValidateAndCanonicalizeUnicodeExtensionType(
      numberingSystem,
      "numberingSystem",
      "nu"
    );
  }
  opt.nu = numberingSystem;
  var style = GetOption(
    options,
    "style",
    "string",
    ["decimal", "percent", "currency", "unit"],
    "decimal"
  );
  lazyNumberFormatData.style = style;
  var currency = GetOption(options, "currency", "string", undefined, undefined);
  if (currency === undefined) {
    if (style === "currency") {
      ThrowTypeError(543);
    }
  } else {
    if (!IsWellFormedCurrencyCode(currency)) {
      ThrowRangeError(533, currency);
    }
  }
  var currencyDisplay = GetOption(
    options,
    "currencyDisplay",
    "string",
    ["code", "symbol", "narrowSymbol", "name"],
    "symbol"
  );
  var currencySign = GetOption(
    options,
    "currencySign",
    "string",
    ["standard", "accounting"],
    "standard"
  );
  if (style === "currency") {
    currency = toASCIIUpperCase(currency);
    lazyNumberFormatData.currency = currency;
    lazyNumberFormatData.currencyDisplay = currencyDisplay;
    lazyNumberFormatData.currencySign = currencySign;
  }
  var unit = GetOption(options, "unit", "string", undefined, undefined);
  if (unit === undefined) {
    if (style === "unit") {
      ThrowTypeError(544);
    }
  } else {
    if (!IsWellFormedUnitIdentifier(unit)) {
      ThrowRangeError(534, unit);
    }
  }
  var unitDisplay = GetOption(
    options,
    "unitDisplay",
    "string",
    ["short", "narrow", "long"],
    "short"
  );
  if (style === "unit") {
    lazyNumberFormatData.unit = unit;
    lazyNumberFormatData.unitDisplay = unitDisplay;
  }
  var notation = GetOption(
    options,
    "notation",
    "string",
    ["standard", "scientific", "engineering", "compact"],
    "standard"
  );
  lazyNumberFormatData.notation = notation;
  var mnfdDefault, mxfdDefault;
  if (style === "currency" && notation === "standard") {
    var cDigits = CurrencyDigits(currency);
    mnfdDefault = cDigits;
    mxfdDefault = cDigits;
  } else {
    mnfdDefault = 0;
    mxfdDefault = style === "percent" ? 0 : 3;
  }
  SetNumberFormatDigitOptions(
    lazyNumberFormatData,
    options,
    mnfdDefault,
    mxfdDefault,
    notation
  );
  var compactDisplay = GetOption(
    options,
    "compactDisplay",
    "string",
    ["short", "long"],
    "short"
  );
  if (notation === "compact") {
    lazyNumberFormatData.compactDisplay = compactDisplay;
  }
  var defaultUseGrouping = notation !== "compact" ? "auto" : "min2";
  var useGrouping = GetStringOrBooleanOption(
    options,
    "useGrouping",
    ["min2", "auto", "always", "true", "false"],
    defaultUseGrouping
  );
  if (useGrouping === "true" || useGrouping === "false") {
    useGrouping = defaultUseGrouping;
  } else if (useGrouping === true) {
    useGrouping = "always";
  }
  ;
   ;
  lazyNumberFormatData.useGrouping = useGrouping;
  var signDisplay = GetOption(
    options,
    "signDisplay",
    "string",
    ["auto", "never", "always", "exceptZero", "negative"],
    "auto"
  );
  lazyNumberFormatData.signDisplay = signDisplay;
  initializeIntlObject(numberFormat, "NumberFormat", lazyNumberFormatData);
  if (
    numberFormat !== thisValue &&
    callFunction(
      std_Object_isPrototypeOf,
      GetBuiltinPrototype("NumberFormat"),
      thisValue
    )
  ) {
    DefineDataProperty(
      thisValue,
      intlFallbackSymbol(),
      numberFormat,
      0x08 | 0x10 | 0x20
    );
    return thisValue;
  }
  return numberFormat;
}
function CurrencyDigits(currency) {
  ;;
  ;;
  ;;
  if (hasOwn(currency, currencyDigits)) {
    return currencyDigits[currency];
  }
  return 2;
}
function Intl_NumberFormat_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "NumberFormat";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
function getNumberingSystems(locale) {
  var defaultNumberingSystem = intl_numberingSystem(locale);
  return [defaultNumberingSystem, "adlm", "ahom", "arab", "arabext", "bali", "beng", "bhks", "brah", "cakm", "cham", "deva", "diak", "fullwide", "gara", "gong", "gonm", "gujr", "gukh", "guru", "hanidec", "hmng", "hmnp", "java", "kali", "kawi", "khmr", "knda", "krai", "lana", "lanatham", "laoo", "latn", "lepc", "limb", "mathbold", "mathdbl", "mathmono", "mathsanb", "mathsans", "mlym", "modi", "mong", "mroo", "mtei", "mymr", "mymrepka", "mymrpao", "mymrshan", "mymrtlng", "nagm", "newa", "nkoo", "olck", "onao", "orya", "osma", "outlined", "rohg", "saur", "segment", "shrd", "sind", "sinh", "sora", "sund", "sunu", "takr", "talu", "tamldec", "telu", "thai", "tibt", "tirh", "tnsa", "tols", "vaii", "wara", "wcho"];
}
function numberFormatLocaleData() {
  return {
    nu: getNumberingSystems,
    default: {
      nu: intl_numberingSystem,
    },
  };
}
function createNumberFormatFormat(nf) {
  return function(value) {
    ;;
    ;
     ;
    return intl_FormatNumber(nf, value, false);
  };
}
function $Intl_NumberFormat_format_get() {
  var thisArg = UnwrapNumberFormat(this);
  var nf = thisArg;
  if (!IsObject(nf) || (nf = intl_GuardToNumberFormat(nf)) === null) {
    return callFunction(
      intl_CallNumberFormatMethodIfWrapped,
      thisArg,
      "$Intl_NumberFormat_format_get"
    );
  }
  var internals = getNumberFormatInternals(nf);
  if (internals.boundFormat === undefined) {
    internals.boundFormat = createNumberFormatFormat(nf);
  }
  return internals.boundFormat;
}
SetCanonicalName($Intl_NumberFormat_format_get, "get format");
function Intl_NumberFormat_formatToParts(value) {
  var nf = this;
  if (!IsObject(nf) || (nf = intl_GuardToNumberFormat(nf)) === null) {
    return callFunction(
      intl_CallNumberFormatMethodIfWrapped,
      this,
      value,
      "Intl_NumberFormat_formatToParts"
    );
  }
  return intl_FormatNumber(nf, value, true);
}
function Intl_NumberFormat_formatRange(start, end) {
  var nf = this;
  if (!IsObject(nf) || (nf = intl_GuardToNumberFormat(nf)) === null) {
    return callFunction(
      intl_CallNumberFormatMethodIfWrapped,
      this,
      start,
      end,
      "Intl_NumberFormat_formatRange"
    );
  }
  if (start === undefined || end === undefined) {
    ThrowTypeError(
      546,
      start === undefined ? "start" : "end",
      "NumberFormat",
      "formatRange"
    );
  }
  return intl_FormatNumberRange(nf, start, end, false);
}
function Intl_NumberFormat_formatRangeToParts(start, end) {
  var nf = this;
  if (!IsObject(nf) || (nf = intl_GuardToNumberFormat(nf)) === null) {
    return callFunction(
      intl_CallNumberFormatMethodIfWrapped,
      this,
      start,
      end,
      "Intl_NumberFormat_formatRangeToParts"
    );
  }
  if (start === undefined || end === undefined) {
    ThrowTypeError(
      546,
      start === undefined ? "start" : "end",
      "NumberFormat",
      "formatRangeToParts"
    );
  }
  return intl_FormatNumberRange(nf, start, end, true);
}
function Intl_NumberFormat_resolvedOptions() {
  var thisArg = UnwrapNumberFormat(this);
  var nf = thisArg;
  if (!IsObject(nf) || (nf = intl_GuardToNumberFormat(nf)) === null) {
    return callFunction(
      intl_CallNumberFormatMethodIfWrapped,
      thisArg,
      "Intl_NumberFormat_resolvedOptions"
    );
  }
  var internals = getNumberFormatInternals(nf);
  var result = {
    locale: internals.locale,
    numberingSystem: internals.numberingSystem,
    style: internals.style,
  };
  ;
   ;
  ;
   ;
  ;
   ;
  if (hasOwn("currency", internals)) {
    DefineDataProperty(result, "currency", internals.currency);
    DefineDataProperty(result, "currencyDisplay", internals.currencyDisplay);
    DefineDataProperty(result, "currencySign", internals.currencySign);
  }
  ;
   ;
  ;
   ;
  if (hasOwn("unit", internals)) {
    DefineDataProperty(result, "unit", internals.unit);
    DefineDataProperty(result, "unitDisplay", internals.unitDisplay);
  }
  DefineDataProperty(
    result,
    "minimumIntegerDigits",
    internals.minimumIntegerDigits
  );
  ;
   ;
  if (hasOwn("minimumFractionDigits", internals)) {
    DefineDataProperty(
      result,
      "minimumFractionDigits",
      internals.minimumFractionDigits
    );
    DefineDataProperty(
      result,
      "maximumFractionDigits",
      internals.maximumFractionDigits
    );
  }
  ;
   ;
  if (hasOwn("minimumSignificantDigits", internals)) {
    DefineDataProperty(
      result,
      "minimumSignificantDigits",
      internals.minimumSignificantDigits
    );
    DefineDataProperty(
      result,
      "maximumSignificantDigits",
      internals.maximumSignificantDigits
    );
  }
  DefineDataProperty(result, "useGrouping", internals.useGrouping);
  var notation = internals.notation;
  DefineDataProperty(result, "notation", notation);
  if (notation === "compact") {
    DefineDataProperty(result, "compactDisplay", internals.compactDisplay);
  }
  DefineDataProperty(result, "signDisplay", internals.signDisplay);
  DefineDataProperty(result, "roundingIncrement", internals.roundingIncrement);
  DefineDataProperty(result, "roundingMode", internals.roundingMode);
  DefineDataProperty(result, "roundingPriority", internals.roundingPriority);
  DefineDataProperty(
    result,
    "trailingZeroDisplay",
    internals.trailingZeroDisplay
  );
  return result;
}
var pluralRulesInternalProperties = {
  localeData: pluralRulesLocaleData,
  relevantExtensionKeys: [],
};
function pluralRulesLocaleData() {
  return {};
}
function resolvePluralRulesInternals(lazyPluralRulesData) {
  ;;
  var internalProps = std_Object_create(null);
  var PluralRules = pluralRulesInternalProperties;
  var localeData = PluralRules.localeData;
  var r = ResolveLocale(
    "PluralRules",
    lazyPluralRulesData.requestedLocales,
    lazyPluralRulesData.opt,
    PluralRules.relevantExtensionKeys,
    localeData
  );
  internalProps.locale = r.locale;
  internalProps.type = lazyPluralRulesData.type;
  internalProps.minimumIntegerDigits = lazyPluralRulesData.minimumIntegerDigits;
  internalProps.roundingIncrement = lazyPluralRulesData.roundingIncrement;
  internalProps.roundingMode = lazyPluralRulesData.roundingMode;
  internalProps.trailingZeroDisplay = lazyPluralRulesData.trailingZeroDisplay;
  if ("minimumFractionDigits" in lazyPluralRulesData) {
    ;
     ;
    internalProps.minimumFractionDigits =
      lazyPluralRulesData.minimumFractionDigits;
    internalProps.maximumFractionDigits =
      lazyPluralRulesData.maximumFractionDigits;
  }
  if ("minimumSignificantDigits" in lazyPluralRulesData) {
    ;
     ;
    internalProps.minimumSignificantDigits =
      lazyPluralRulesData.minimumSignificantDigits;
    internalProps.maximumSignificantDigits =
      lazyPluralRulesData.maximumSignificantDigits;
  }
  internalProps.roundingPriority = lazyPluralRulesData.roundingPriority;
  internalProps.pluralCategories = null;
  return internalProps;
}
function getPluralRulesInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolvePluralRulesInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function InitializePluralRules(pluralRules, locales, options) {
  ;;
  ;
   ;
  var lazyPluralRulesData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyPluralRulesData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else {
    options = ToObject(options);
  }
  var opt = std_Object_create(null);
  lazyPluralRulesData.opt = opt;
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  opt.localeMatcher = matcher;
  var type = GetOption(
    options,
    "type",
    "string",
    ["cardinal", "ordinal"],
    "cardinal"
  );
  lazyPluralRulesData.type = type;
  SetNumberFormatDigitOptions(lazyPluralRulesData, options, 0, 3, "standard");
  initializeIntlObject(pluralRules, "PluralRules", lazyPluralRulesData);
}
function Intl_PluralRules_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "PluralRules";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
function Intl_PluralRules_select(value) {
  var pluralRules = this;
  if (
    !IsObject(pluralRules) ||
    (pluralRules = intl_GuardToPluralRules(pluralRules)) === null
  ) {
    return callFunction(
      intl_CallPluralRulesMethodIfWrapped,
      this,
      value,
      "Intl_PluralRules_select"
    );
  }
  var n = +value;
  getPluralRulesInternals(pluralRules);
  return intl_SelectPluralRule(pluralRules, n);
}
function Intl_PluralRules_selectRange(start, end) {
  var pluralRules = this;
  if (
    !IsObject(pluralRules) ||
    (pluralRules = intl_GuardToPluralRules(pluralRules)) === null
  ) {
    return callFunction(
      intl_CallPluralRulesMethodIfWrapped,
      this,
      start,
      end,
      "Intl_PluralRules_selectRange"
    );
  }
  if (start === undefined || end === undefined) {
    ThrowTypeError(
      546,
      start === undefined ? "start" : "end",
      "PluralRules",
      "selectRange"
    );
  }
  var x = +start;
  var y = +end;
  return intl_SelectPluralRuleRange(pluralRules, x, y);
}
function Intl_PluralRules_resolvedOptions() {
  var pluralRules = this;
  if (
    !IsObject(pluralRules) ||
    (pluralRules = intl_GuardToPluralRules(pluralRules)) === null
  ) {
    return callFunction(
      intl_CallPluralRulesMethodIfWrapped,
      this,
      "Intl_PluralRules_resolvedOptions"
    );
  }
  var internals = getPluralRulesInternals(pluralRules);
  var internalsPluralCategories = internals.pluralCategories;
  if (internalsPluralCategories === null) {
    internalsPluralCategories = intl_GetPluralCategories(pluralRules);
    internals.pluralCategories = internalsPluralCategories;
  }
  var pluralCategories = [];
  for (var i = 0; i < internalsPluralCategories.length; i++) {
    DefineDataProperty(pluralCategories, i, internalsPluralCategories[i]);
  }
  var result = {
    locale: internals.locale,
    type: internals.type,
    minimumIntegerDigits: internals.minimumIntegerDigits,
  };
  ;
   ;
  if (hasOwn("minimumFractionDigits", internals)) {
    DefineDataProperty(
      result,
      "minimumFractionDigits",
      internals.minimumFractionDigits
    );
    DefineDataProperty(
      result,
      "maximumFractionDigits",
      internals.maximumFractionDigits
    );
  }
  ;
   ;
  if (hasOwn("minimumSignificantDigits", internals)) {
    DefineDataProperty(
      result,
      "minimumSignificantDigits",
      internals.minimumSignificantDigits
    );
    DefineDataProperty(
      result,
      "maximumSignificantDigits",
      internals.maximumSignificantDigits
    );
  }
  DefineDataProperty(result, "pluralCategories", pluralCategories);
  DefineDataProperty(result, "roundingIncrement", internals.roundingIncrement);
  DefineDataProperty(result, "roundingMode", internals.roundingMode);
  DefineDataProperty(result, "roundingPriority", internals.roundingPriority);
  DefineDataProperty(
    result,
    "trailingZeroDisplay",
    internals.trailingZeroDisplay
  );
  return result;
}
var relativeTimeFormatInternalProperties = {
  localeData: relativeTimeFormatLocaleData,
  relevantExtensionKeys: ["nu"],
};
function relativeTimeFormatLocaleData() {
  return {
    nu: getNumberingSystems,
    default: {
      nu: intl_numberingSystem,
    },
  };
}
function resolveRelativeTimeFormatInternals(lazyRelativeTimeFormatData) {
  ;;
  var internalProps = std_Object_create(null);
  var RelativeTimeFormat = relativeTimeFormatInternalProperties;
  var r = ResolveLocale(
    "RelativeTimeFormat",
    lazyRelativeTimeFormatData.requestedLocales,
    lazyRelativeTimeFormatData.opt,
    RelativeTimeFormat.relevantExtensionKeys,
    RelativeTimeFormat.localeData
  );
  internalProps.locale = r.locale;
  internalProps.numberingSystem = r.nu;
  internalProps.style = lazyRelativeTimeFormatData.style;
  internalProps.numeric = lazyRelativeTimeFormatData.numeric;
  return internalProps;
}
function getRelativeTimeFormatInternals(obj) {
  ;
   ;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveRelativeTimeFormatInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function InitializeRelativeTimeFormat(relativeTimeFormat, locales, options) {
  ;
   ;
  ;
   ;
  var lazyRelativeTimeFormatData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazyRelativeTimeFormatData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else {
    options = ToObject(options);
  }
  var opt = std_Object_create(null);
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  opt.localeMatcher = matcher;
  var numberingSystem = GetOption(
    options,
    "numberingSystem",
    "string",
    undefined,
    undefined
  );
  if (numberingSystem !== undefined) {
    numberingSystem = intl_ValidateAndCanonicalizeUnicodeExtensionType(
      numberingSystem,
      "numberingSystem",
      "nu"
    );
  }
  opt.nu = numberingSystem;
  lazyRelativeTimeFormatData.opt = opt;
  var style = GetOption(
    options,
    "style",
    "string",
    ["long", "short", "narrow"],
    "long"
  );
  lazyRelativeTimeFormatData.style = style;
  var numeric = GetOption(
    options,
    "numeric",
    "string",
    ["always", "auto"],
    "always"
  );
  lazyRelativeTimeFormatData.numeric = numeric;
  initializeIntlObject(
    relativeTimeFormat,
    "RelativeTimeFormat",
    lazyRelativeTimeFormatData
  );
}
function Intl_RelativeTimeFormat_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "RelativeTimeFormat";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
function Intl_RelativeTimeFormat_format(value, unit) {
  var relativeTimeFormat = this;
  if (
    !IsObject(relativeTimeFormat) ||
    (relativeTimeFormat = intl_GuardToRelativeTimeFormat(
      relativeTimeFormat
    )) === null
  ) {
    return callFunction(
      intl_CallRelativeTimeFormatMethodIfWrapped,
      this,
      value,
      unit,
      "Intl_RelativeTimeFormat_format"
    );
  }
  var t = +value;
  var u = ToString(unit);
  return intl_FormatRelativeTime(relativeTimeFormat, t, u, false);
}
function Intl_RelativeTimeFormat_formatToParts(value, unit) {
  var relativeTimeFormat = this;
  if (
    !IsObject(relativeTimeFormat) ||
    (relativeTimeFormat = intl_GuardToRelativeTimeFormat(
      relativeTimeFormat
    )) === null
  ) {
    return callFunction(
      intl_CallRelativeTimeFormatMethodIfWrapped,
      this,
      value,
      unit,
      "Intl_RelativeTimeFormat_formatToParts"
    );
  }
  var t = +value;
  var u = ToString(unit);
  return intl_FormatRelativeTime(relativeTimeFormat, t, u, true);
}
function Intl_RelativeTimeFormat_resolvedOptions() {
  var relativeTimeFormat = this;
  if (
    !IsObject(relativeTimeFormat) ||
    (relativeTimeFormat = intl_GuardToRelativeTimeFormat(
      relativeTimeFormat
    )) === null
  ) {
    return callFunction(
      intl_CallRelativeTimeFormatMethodIfWrapped,
      this,
      "Intl_RelativeTimeFormat_resolvedOptions"
    );
  }
  var internals = getRelativeTimeFormatInternals(relativeTimeFormat);
  var result = {
    locale: internals.locale,
    style: internals.style,
    numeric: internals.numeric,
    numberingSystem: internals.numberingSystem,
  };
  return result;
}
var sanctionedSimpleUnitIdentifiers = {
  "acre": true,
  "bit": true,
  "byte": true,
  "celsius": true,
  "centimeter": true,
  "day": true,
  "degree": true,
  "fahrenheit": true,
  "fluid-ounce": true,
  "foot": true,
  "gallon": true,
  "gigabit": true,
  "gigabyte": true,
  "gram": true,
  "hectare": true,
  "hour": true,
  "inch": true,
  "kilobit": true,
  "kilobyte": true,
  "kilogram": true,
  "kilometer": true,
  "liter": true,
  "megabit": true,
  "megabyte": true,
  "meter": true,
  "microsecond": true,
  "mile": true,
  "mile-scandinavian": true,
  "milliliter": true,
  "millimeter": true,
  "millisecond": true,
  "minute": true,
  "month": true,
  "nanosecond": true,
  "ounce": true,
  "percent": true,
  "petabyte": true,
  "pound": true,
  "second": true,
  "stone": true,
  "terabit": true,
  "terabyte": true,
  "week": true,
  "yard": true,
  "year": true
};
function segmenterLocaleData() {
  return {};
}
var segmenterInternalProperties = {
  localeData: segmenterLocaleData,
  relevantExtensionKeys: [],
};
function resolveSegmenterInternals(lazySegmenterData) {
  ;;
  var internalProps = std_Object_create(null);
  var Segmenter = segmenterInternalProperties;
  var localeData = Segmenter.localeData;
  var r = ResolveLocale(
    "Segmenter",
    lazySegmenterData.requestedLocales,
    lazySegmenterData.opt,
    Segmenter.relevantExtensionKeys,
    localeData
  );
  internalProps.locale = r.locale;
  internalProps.granularity = lazySegmenterData.granularity;
  return internalProps;
}
function getSegmenterInternals(obj) {
  ;;
  ;
   ;
  var internals = getIntlObjectInternals(obj);
  ;
   ;
  var internalProps = maybeInternalProperties(internals);
  if (internalProps) {
    return internalProps;
  }
  internalProps = resolveSegmenterInternals(internals.lazyData);
  setInternalProperties(internals, internalProps);
  return internalProps;
}
function InitializeSegmenter(segmenter, locales, options) {
  ;;
  ;
   ;
  var lazySegmenterData = std_Object_create(null);
  var requestedLocales = CanonicalizeLocaleList(locales);
  lazySegmenterData.requestedLocales = requestedLocales;
  if (options === undefined) {
    options = std_Object_create(null);
  } else if (!IsObject(options)) {
    ThrowTypeError(
      56,
      options === null ? "null" : typeof options
    );
  }
  var opt = std_Object_create(null);
  lazySegmenterData.opt = opt;
  var matcher = GetOption(
    options,
    "localeMatcher",
    "string",
    ["lookup", "best fit"],
    "best fit"
  );
  opt.localeMatcher = matcher;
  var granularity = GetOption(
    options,
    "granularity",
    "string",
    ["grapheme", "word", "sentence"],
    "grapheme"
  );
  lazySegmenterData.granularity = granularity;
  initializeIntlObject(segmenter, "Segmenter", lazySegmenterData);
}
function Intl_Segmenter_supportedLocalesOf(locales ) {
  var options = ArgumentsLength() > 1 ? GetArgument(1) : undefined;
  var availableLocales = "Segmenter";
  var requestedLocales = CanonicalizeLocaleList(locales);
  return SupportedLocales(availableLocales, requestedLocales, options);
}
function Intl_Segmenter_segment(value) {
  var segmenter = this;
  if (
    !IsObject(segmenter) ||
    (segmenter = intl_GuardToSegmenter(segmenter)) === null
  ) {
    return callFunction(
      intl_CallSegmenterMethodIfWrapped,
      this,
      value,
      "Intl_Segmenter_segment"
    );
  }
  getSegmenterInternals(segmenter);
  var string = ToString(value);
  return intl_CreateSegmentsObject(segmenter, string);
}
function Intl_Segmenter_resolvedOptions() {
  var segmenter = this;
  if (
    !IsObject(segmenter) ||
    (segmenter = intl_GuardToSegmenter(segmenter)) === null
  ) {
    return callFunction(
      intl_CallSegmenterMethodIfWrapped,
      this,
      "Intl_Segmenter_resolvedOptions"
    );
  }
  var internals = getSegmenterInternals(segmenter);
  var options = {
    locale: internals.locale,
    granularity: internals.granularity,
  };
  return options;
}
function CreateSegmentDataObject(string, boundaries) {
  ;;
  ;
   ;
  var startIndex = boundaries[0];
  ;
   ;
  var endIndex = boundaries[1];
  ;
   ;
  var isWordLike = boundaries[2];
  ;
   ;
  ;;
  ;
   ;
  ;;
  var segment = Substring(string, startIndex, endIndex - startIndex);
  if (isWordLike === undefined) {
    return {
      segment,
      index: startIndex,
      input: string,
    };
  }
  return {
    segment,
    index: startIndex,
    input: string,
    isWordLike,
  };
}
function Intl_Segments_containing(index) {
  var segments = this;
  if (
    !IsObject(segments) ||
    (segments = intl_GuardToSegments(segments)) === null
  ) {
    return callFunction(
      intl_CallSegmentsMethodIfWrapped,
      this,
      index,
      "Intl_Segments_containing"
    );
  }
  var string = UnsafeGetStringFromReservedSlot(
    segments,
    1
  );
  var len = string.length;
  var n = ToInteger(index);
  if (n < 0 || n >= len) {
    return undefined;
  }
  var boundaries = intl_FindSegmentBoundaries(segments, n | 0);
  return CreateSegmentDataObject(string, boundaries);
}
function Intl_Segments_iterator() {
  var segments = this;
  if (
    !IsObject(segments) ||
    (segments = intl_GuardToSegments(segments)) === null
  ) {
    return callFunction(
      intl_CallSegmentsMethodIfWrapped,
      this,
      "Intl_Segments_iterator"
    );
  }
  return intl_CreateSegmentIterator(segments);
}
function Intl_SegmentIterator_next() {
  var iterator = this;
  if (
    !IsObject(iterator) ||
    (iterator = intl_GuardToSegmentIterator(iterator)) === null)
  {
    return callFunction(
      intl_CallSegmentIteratorMethodIfWrapped,
      this,
      "Intl_SegmentIterator_next"
    );
  }
  var string = UnsafeGetStringFromReservedSlot(
    iterator,
    1
  );
  var index = UnsafeGetInt32FromReservedSlot(
    iterator,
    3
  );
  var result = { value: undefined, done: false };
  if (index === string.length) {
    result.done = true;
    return result;
  }
  var boundaries = intl_FindNextSegmentBoundaries(iterator);
  result.value = CreateSegmentDataObject(string, boundaries);
  return result;
}
async function AsyncDisposableStackDisposeAsyncImpl() {
  var asyncDisposableStack = this;
  if (!IsObject(asyncDisposableStack) || (asyncDisposableStack = GuardToAsyncDisposableStackHelper(asyncDisposableStack)) === null) {
    return callFunction(
      CallAsyncDisposableStackMethodIfWrapped,
      this,
      "$AsyncDisposableStackDisposeAsync"
    );
  }
  var state = UnsafeGetReservedSlot(asyncDisposableStack, 1);
  if (state === undefined) {
    ThrowTypeError(47, 'disposeAsync', 'method', 'AsyncDisposableStack');
  }
  if (state === 1) {
    return undefined;
  }
  UnsafeSetReservedSlot(asyncDisposableStack, 1, 1);
  var disposeCapability = UnsafeGetReservedSlot(asyncDisposableStack, 0);
  UnsafeSetReservedSlot(asyncDisposableStack, 0, undefined);
  if (disposeCapability === undefined) {
    return undefined;
  }
  DisposeResourcesAsync(disposeCapability, disposeCapability.length);
  return undefined;
}
function $AsyncDisposableStackDisposeAsync() {
  return callFunction(AsyncDisposableStackDisposeAsyncImpl, this);
}
SetCanonicalName($AsyncDisposableStackDisposeAsync, "disposeAsync");
function $DisposableStackDispose() {
  var disposableStack = this;
  if (!IsObject(disposableStack) || (disposableStack = GuardToDisposableStackHelper(disposableStack)) === null) {
    return callFunction(
      CallDisposableStackMethodIfWrapped,
      this,
      "$DisposableStackDispose"
    );
  }
  var state = UnsafeGetReservedSlot(disposableStack, 1);
  if (state === 1) {
    return undefined;
  }
  UnsafeSetReservedSlot(disposableStack, 1, 1);
  var disposeCapability = UnsafeGetReservedSlot(disposableStack, 0);
  UnsafeSetReservedSlot(disposableStack, 0, undefined);
  if (disposeCapability === undefined) {
    return undefined;
  }
  DisposeResourcesSync(disposeCapability, disposeCapability.length);
  return undefined;
}
SetCanonicalName($DisposableStackDispose, "dispose");