// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBackgroundhangmonitorMetrics_h
#define mozilla_GleanBackgroundhangmonitorMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace hangs {
  /**
   * generated from hangs.modules
   */
  using ModulesObjectItem = nsTArray<nsCString>;

  using ModulesObject = nsTArray<ModulesObjectItem>;
  /**
   * A set of modules found in hang reports sent in the same ping. The data is an array of string pairs (array of 2 strings). The first string of the pair is the module name (eg. "libxul.so"), the second string is the debug id (33 hexadecimal characters) which can be used to fetch the symbols from the Mozilla symbol server.
   */
  constexpr impl::ObjectMetric<ModulesObject, struct ModulesObjectTag> modules(4601);

  /**
   * generated from hangs.reports
   */
  using ReportsObjectItemAnnotationsItem = nsTArray<nsCString>;

  using ReportsObjectItemAnnotations = nsTArray<ReportsObjectItemAnnotationsItem>;


  struct ReportsObjectItemStackItem {
    Maybe<nsCString> frame;
    Maybe<int64_t> module;
  };

  using ReportsObjectItemStack = nsTArray<ReportsObjectItemStackItem>;


  struct ReportsObjectItem {
    Maybe<int64_t> duration;
    Maybe<nsCString> thread;
    Maybe<nsCString> runnableName;
    Maybe<nsCString> process;
    Maybe<nsCString> remoteType;
    Maybe<ReportsObjectItemAnnotations> annotations;
    Maybe<ReportsObjectItemStack> stack;
  };

  using ReportsObject = nsTArray<ReportsObjectItem>;
  /**
   * A set of hang reports from Background Hang Reporter.
   * The data is an array with one item per hang report.
   * Each hang report is an object with the following fields:
   *  - duration: detected duration of the hang in milliseconds.
   *  - thread: the name of the unresponsive thread.
   *     (eg. "Gecko", "Gecko_Child", "Render")
   *  - runnableName: the name of the runnable that was in the event
   *                  loop at the time the stack was captured.
   *  - process: the type of the process (eg. "default", "tab")
   *  - remoteType: (optional) the type of remote process. Eg. "webIsolated".
   *     Will be null for the parent process.
   *  - annotations: (optional) an array of string pairs (array of 2 strings).
   *     The first string of the pair will be the annotation name, the second
   *     will be its value.
   *  - stack: The frames of the stack that was recorded for the hang, stored
   *      as an array of objects, one for each stack frame.
   *      Stack frame objects contain the following fields:
   *        - frame: either a plain text label or JS frame, or the hex offset
   *            in the module if the module field is set.
   *        - module: (optional) Will only be set for native frames, and will
   *            be a module index (in the array of the 'modules' metric).
   */
  constexpr impl::ObjectMetric<ReportsObject, struct ReportsObjectTag> reports(4602);
}

template <>
inline void impl::ObjectMetric<hangs::ModulesObject, hangs::ModulesObjectTag>::Set(const hangs::ModulesObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartArrayElement();
      {
        for (const auto& aobjitemItem: aobjItem) {
          writer.StringElement(aobjitemItem);

        }
      }
      writer.EndArray();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<hangs::ReportsObject, hangs::ReportsObjectTag>::Set(const hangs::ReportsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.duration.isSome()) {
          writer.IntProperty("duration", *(aobjItem.duration));
        }
        if (aobjItem.thread.isSome()) {
          writer.StringProperty("thread", *(aobjItem.thread));
        }
        if (aobjItem.runnableName.isSome()) {
          writer.StringProperty("runnableName", *(aobjItem.runnableName));
        }
        if (aobjItem.process.isSome()) {
          writer.StringProperty("process", *(aobjItem.process));
        }
        if (aobjItem.remoteType.isSome()) {
          writer.StringProperty("remoteType", *(aobjItem.remoteType));
        }
        if (aobjItem.annotations.isSome()) {
          writer.StartArrayProperty("annotations");
          for (const auto& aobjitemAnnotationsItem: *aobjItem.annotations) {
            writer.StartArrayElement();
            {
              for (const auto& aobjitemannotationsitemItem: aobjitemAnnotationsItem) {
                writer.StringElement(aobjitemannotationsitemItem);

              }
            }
            writer.EndArray();

          }
          writer.EndArray();
        }
        if (aobjItem.stack.isSome()) {
          writer.StartArrayProperty("stack");
          for (const auto& aobjitemStackItem: *aobjItem.stack) {
            writer.StartObjectElement();
            {
              if (aobjitemStackItem.frame.isSome()) {
                writer.StringProperty("frame", *(aobjitemStackItem.frame));
              }
              if (aobjitemStackItem.module.isSome()) {
                writer.IntProperty("module", *(aobjitemStackItem.module));
              }
            }
            writer.EndObject();

          }
          writer.EndArray();
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBackgroundhangmonitorMetrics_h
