// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBrowserExtensionsDataLeakBlockerMetrics_h
#define mozilla_GleanBrowserExtensionsDataLeakBlockerMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace data_leak_blocker {
  /**
   * generated from data_leak_blocker.report_v1
   */
  struct ReportV1Extra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> blocked;
    mozilla::Maybe<nsCString> contentPolicyType;
    mozilla::Maybe<nsCString> isAddonLoading;
    mozilla::Maybe<nsCString> isAddonTriggering;
    mozilla::Maybe<nsCString> isContentScript;
    mozilla::Maybe<nsCString> method;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (blocked) {
        extraKeys.AppendElement()->AssignASCII("blocked");
        extraValues.EmplaceBack(blocked.value());
      }
      if (contentPolicyType) {
        extraKeys.AppendElement()->AssignASCII("content_policy_type");
        extraValues.EmplaceBack(contentPolicyType.value());
      }
      if (isAddonLoading) {
        extraKeys.AppendElement()->AssignASCII("is_addon_loading");
        extraValues.EmplaceBack(isAddonLoading.value());
      }
      if (isAddonTriggering) {
        extraKeys.AppendElement()->AssignASCII("is_addon_triggering");
        extraValues.EmplaceBack(isAddonTriggering.value());
      }
      if (isContentScript) {
        extraKeys.AppendElement()->AssignASCII("is_content_script");
        extraValues.EmplaceBack(isContentScript.value());
      }
      if (method) {
        extraKeys.AppendElement()->AssignASCII("method");
        extraValues.EmplaceBack(method.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded on requests originated from add-on that are targeting one of the domains listed in the related RemoteSettings data.
   */
  constexpr impl::EventMetric<ReportV1Extra> report_v1(1032);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBrowserExtensionsDataLeakBlockerMetrics_h
